/*
 * Decompiled with CFR 0.152.
 */
package com.servidor.itms.sign;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;

public class FirmaDigital {
    public static void copia(String nombreFuente, String nombreDestino) throws IOException {
        FileInputStream fis = new FileInputStream(nombreFuente);
        FileOutputStream fos = new FileOutputStream(nombreDestino);
        FileChannel canalFuente = fis.getChannel();
        FileChannel canalDestino = fos.getChannel();
        canalFuente.transferTo(0L, canalFuente.size(), canalDestino);
        fis.close();
        fos.close();
    }

    public static void firmarPdf(String origen, String destino, String firma, String passKeyStore, String PrivateKey2, String location, String pwd) throws Exception {
        KeyStore ks = KeyStore.getInstance("pkcs12");
        ks.load(new FileInputStream(firma), passKeyStore.toCharArray());
        String alias = ks.aliases().nextElement();
        PrivateKey key = (PrivateKey)ks.getKey(alias, PrivateKey2.toCharArray());
        Certificate[] chain = ks.getCertificateChain(alias);
        PdfReader.unethicalreading = true;
        PdfReader reader = new PdfReader(origen);
        FileOutputStream fout = new FileOutputStream(destino);
        PdfStamper stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fout, (char)'\u0000');
        PdfSignatureAppearance sap = stp.getSignatureAppearance();
        sap.setCrypto(key, chain, null, PdfSignatureAppearance.SELF_SIGNED);
        sap.setReason("Certificacion ITMS");
        sap.setLocation(location);
        sap.setCertificationLevel(1);
        if (!pwd.isEmpty()) {
            stp.setEncryption(2, pwd, null, 2052);
        }
        stp.close();
        fout.close();
        reader.close();
        System.out.println("Archivo Firmado:" + destino);
    }

    public static void main(String[] args) {
        String pathLectura = "";
        String pathDestino = "";
        String pathError = "";
        String firma = "";
        String location = "";
        String passKeyStore = "";
        String PrivateKey2 = "";
        String passPDFDefault = "";
        int borraFuente = 0;
        String rutPaciente = "";
        String infoID = "";
        String medID = "";
        String flagPassword = "";
        String firmaPassword = "";
        String separadorCampos = "";
        String nombreArchivoSalida = "";
        String nombreArchivoSalidaSinExt = "";
        String urlNotificacion = "";
        String repositorioCertificados = "";
        String KeyCertificados = "";
        String plataforma = "";
        try {
            Properties p = new Properties();
            FileInputStream streamArchivoIni = new FileInputStream("firmaDigital.ini");
            p.load(streamArchivoIni);
            pathLectura = p.getProperty("pathLectura");
            pathError = p.getProperty("pathError");
            pathDestino = p.getProperty("pathDestino");
            firma = p.getProperty("firma");
            location = p.getProperty("location");
            passKeyStore = p.getProperty("passKeyStore");
            PrivateKey2 = p.getProperty("PrivateKey");
            borraFuente = Integer.parseInt(p.getProperty("borraFuente"));
            passPDFDefault = p.getProperty("passPDFDefault");
            separadorCampos = p.getProperty("separadorCampos");
            urlNotificacion = p.getProperty("urlNotificacion");
            repositorioCertificados = p.getProperty("repositorioCertificados");
            KeyCertificados = p.getProperty("KeyCertificados");
            streamArchivoIni.close();
            boolean firma_ITMS = false;
            if (separadorCampos == null) {
                throw new NullPointerException("No existe separador de campos en archivo ini");
            }
            if (pathLectura == null) {
                throw new NullPointerException("No existe pathLectura en archivo ini");
            }
            if (pathDestino == null) {
                throw new NullPointerException("No existe pathDestino en archivo ini");
            }
            if (repositorioCertificados == null) {
                throw new NullPointerException("No existe repositorioCertificados en archivo ini");
            }
            if (KeyCertificados == null) {
                throw new NullPointerException("No existe KeyCertificados en archivo ini");
            }
            File fc = new File(repositorioCertificados);
            if (!fc.canRead()) {
                throw new NullPointerException("No se puede leer repositorio de certificados " + repositorioCertificados);
            }
            fc = new File(pathLectura);
            if (!fc.canRead()) {
                throw new NullPointerException("No se puede leer diretorio de origen " + pathLectura);
            }
            fc = new File(pathDestino);
            if (!fc.canWrite()) {
                throw new NullPointerException("No se puede escribir diretorio de destino " + pathDestino);
            }
            System.out.println("Demonio de firma digital de PDF V. 1.1");
            System.out.println("Esperando archivos en:" + pathLectura);
            System.out.println();
            File dir = new File(pathLectura);
            boolean firmaOK = false;
            boolean passOK = false;
            byte[] OWNER_PASS = passPDFDefault.getBytes();
            String USER_PASS = "";
            int lim = 0;
            while (dir.isDirectory()) {
                File[] archivos = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String str) {
                        return str.endsWith(".pdf");
                    }
                });
                int i = 0;
                while (archivos != null && i < archivos.length) {
                    System.gc();
                    String name = archivos[i].getAbsolutePath();
                    String aliasKey = "";
                    if (archivos[i].getName().contains(separadorCampos)) {
                        String[] nombreArchivoPdf = archivos[i].getName().replace(".pdf", "").split(separadorCampos);
                        if (nombreArchivoPdf.length > 4) {
                            plataforma = nombreArchivoPdf[0];
                            flagPassword = nombreArchivoPdf[1];
                            rutPaciente = nombreArchivoPdf[2];
                            infoID = nombreArchivoPdf[3];
                            medID = nombreArchivoPdf[4];
                            aliasKey = nombreArchivoPdf.length > 5 ? nombreArchivoPdf[5] : "";
                            nombreArchivoSalida = String.valueOf(String.valueOf(String.valueOf(infoID))) + ".pdf";
                            nombreArchivoSalidaSinExt = String.valueOf(String.valueOf(String.valueOf(infoID))) + ".pdf";
                            passOK = true;
                            firmaPassword = flagPassword.toLowerCase().equals("si") ? rutPaciente : "";
                        } else {
                            System.out.println("El archivo no tiene el formato esperado : " + archivos[i].getName());
                        }
                    } else {
                        System.out.println("El archivo no tiene el formato esperado  " + archivos[i].getName());
                    }
                    try {
                        System.out.println("Leyendo archivo :" + name);
                        if (passOK) {
                            File f = new File(String.valueOf(String.valueOf(repositorioCertificados)) + "/" + medID + "/" + medID + ".p12");
                            if (f.exists() && !f.isDirectory()) {
                                System.out.println("Usando firma de m\u00c3\u00a9dico.");
                                firma_ITMS = false;
                                firma = String.valueOf(String.valueOf(repositorioCertificados)) + "/" + medID + "/" + medID + ".p12";
                                String textKey = new String(Files.readAllBytes(Paths.get(String.valueOf(String.valueOf(repositorioCertificados)) + "/" + medID + "/keyDigital", new String[0])), StandardCharsets.ISO_8859_1);
                                String aliasKeyMed = aliasKey;
                                String passKey = FirmaDigital.decrypt(textKey, KeyCertificados);
                                FirmaDigital.firmarPdf(name, String.valueOf(String.valueOf(String.valueOf(pathDestino))) + nombreArchivoSalida, firma, passKey, aliasKeyMed, location, firmaPassword);
                            } else {
                                System.out.println("Usando firma por defecto ITMS.");
                                firma_ITMS = true;
                                firma = String.valueOf(String.valueOf(repositorioCertificados)) + "/" + "itms" + "/" + "itms" + ".p12";
                                PrivateKey2 = p.getProperty("PrivateKey");
                                String passKey = passKeyStore;
                                FirmaDigital.firmarPdf(name, String.valueOf(String.valueOf(String.valueOf(pathDestino))) + nombreArchivoSalida, firma, passKey, PrivateKey2, location, firmaPassword);
                            }
                        }
                        firmaOK = true;
                        System.out.println("Se omite noticar firma.");
                    }
                    catch (Exception e) {
                        firmaOK = false;
                        e.printStackTrace();
                        System.out.println("Error al firmar el archivo PDF: " + archivos[i].getName());
                        System.out.println("Error : " + e.getMessage());
                        FirmaDigital.copia(archivos[i].getAbsolutePath(), String.valueOf(String.valueOf(String.valueOf(pathError))) + archivos[i].getName());
                        FirmaDigital.copia(name, String.valueOf(String.valueOf(String.valueOf(pathError))) + archivos[i].getName().replace(".fin", ".pdf"));
                    }
                    if (borraFuente == 1) {
                        if (archivos[i].delete()) {
                            File delPdf = new File(name);
                            if (delPdf.delete()) {
                                System.out.println("El fichero ha sido borrado satisfactoriamente");
                            }
                        } else {
                            System.out.println("El fichero no puede ser borrado");
                        }
                    }
                    ++i;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    System.out.println("Se cayo el sleep");
                }
                ++lim;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void notificar_firma(String urlNotifica, String infoId, String MedId, String propietarioFirma, String RutaPdf, String RutPaciente) throws IOException, ExecutionException, InterruptedException {
        URL url = new URL(urlNotifica);
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("infoId", infoId);
        arguments.put("mediId", MedId);
        arguments.put("propietarioFirma", propietarioFirma);
        arguments.put("rutaPdf", RutaPdf);
        arguments.put("paciRut", RutPaciente);
        System.out.println("Enviando Notificaci\u00c3\u00b3n a " + urlNotifica);
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry entry : arguments.entrySet()) {
            sj.add(String.valueOf(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8"))) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            System.out.println("Parametro " + (String)entry.getKey() + " = " + (String)entry.getValue());
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        http.setFixedLengthStreamingMode(length);
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        http.connect();
        Throwable exception1 = null;
        Throwable exception2 = null;
        try (OutputStream os = http.getOutputStream();){
            os.write(out);
        }
        catch (Throwable throwable) {
            exception2 = null;
            if (exception1 == null) {
                exception1 = exception2;
            } else if (exception1 != exception2) {
                exception1.addSuppressed(exception2);
            }
            throw throwable;
        }
        exception2 = null;
        if (exception1 == null) {
            exception1 = exception2;
        } else if (exception1 != exception2) {
            exception1.addSuppressed(exception2);
        }
    }

    public static String decrypt(String text, String key) {
        String result = "";
        byte[] byteArray = Base64.getDecoder().decode(text.getBytes(StandardCharsets.ISO_8859_1));
        String decodedString = new String(byteArray, StandardCharsets.ISO_8859_1);
        int i = 0;
        while (i < decodedString.length()) {
            String cara = decodedString.substring(i, i + 1);
            int pos = i % key.length() - 1;
            if (pos == -1) {
                pos = key.length() - 1;
            }
            String keychar = key.substring(pos, pos + 1);
            String charr = String.valueOf((char)(FirmaDigital.ord(cara) - FirmaDigital.ord(keychar)));
            result = String.valueOf(String.valueOf(result)) + charr;
            ++i;
        }
        return result;
    }

    public static int ord(String sChar) {
        int ascii_code = 0;
        try {
            ascii_code = String.valueOf(sChar.charAt(0)).codePointAt(0);
        }
        catch (Exception e) {
            System.out.println("crypto ord error: " + e.getMessage());
            ascii_code = 0;
        }
        return ascii_code;
    }
}

