/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PdfImageObject {
    protected PdfDictionary dictionary;
    protected byte[] streamBytes;

    public PdfImageObject(PRStream stream) {
        this.dictionary = stream;
        try {
            this.streamBytes = PdfName.FLATEDECODE.equals(this.dictionary.getAsName(PdfName.FILTER)) ? PdfReader.getStreamBytes(stream) : PdfReader.getStreamBytesRaw(stream);
        }
        catch (IOException ioe) {
            this.streamBytes = null;
        }
    }

    public PdfObject get(PdfName key) {
        return this.dictionary.get(key);
    }

    public PdfDictionary getDictionary() {
        return this.dictionary;
    }

    public byte[] getStreamBytes() {
        return this.streamBytes;
    }

    public BufferedImage getAwtImage() throws IOException {
        PdfName filter = this.dictionary.getAsName(PdfName.FILTER);
        if (PdfName.DCTDECODE.equals(filter)) {
            return ImageIO.read(new ByteArrayInputStream(this.streamBytes));
        }
        if (!PdfName.FLATEDECODE.equals(filter)) {
            return null;
        }
        BufferedImage bi = null;
        DataBufferByte db = new DataBufferByte(this.streamBytes, this.streamBytes.length);
        int width = this.dictionary.getAsNumber(PdfName.WIDTH).intValue();
        int height = this.dictionary.getAsNumber(PdfName.HEIGHT).intValue();
        int bpc = this.dictionary.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
        switch (bpc) {
            case 1: {
                WritableRaster raster = Raster.createPackedRaster(db, width, height, 1, null);
                bi = new BufferedImage(width, height, 12);
                bi.setData(raster);
                break;
            }
            default: {
                PdfObject colorspace = this.dictionary.getDirectObject(PdfName.COLORSPACE);
                if (PdfName.DEVICERGB.equals(colorspace)) {
                    if (width * height == this.streamBytes.length) {
                        bi = new BufferedImage(width, height, 13);
                        WritableRaster raster = Raster.createPackedRaster(db, width, height, bpc, null);
                        bi.setData(raster);
                        break;
                    }
                    bi = new BufferedImage(width, height, 1);
                    WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, new int[]{0, 1, 2}, null);
                    bi.setData(raster);
                    break;
                }
                if (!(colorspace instanceof PdfArray)) break;
                PdfArray colorspacearray = (PdfArray)colorspace;
                if (PdfName.INDEXED.equals(colorspacearray.getAsName(0))) {
                    int hival = colorspacearray.getAsNumber(2).intValue();
                    byte[] index = colorspacearray.getDirectObject(3).getBytes();
                    WritableRaster raster = Raster.createPackedRaster(db, width, height, bpc, null);
                    IndexColorModel cm = new IndexColorModel(bpc, hival + 1, index, 0, false);
                    bi = new BufferedImage(cm, raster, false, null);
                    break;
                }
                bi = new BufferedImage(width, height, 1);
                WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, new int[]{0, 1, 2}, null);
                bi.setData(raster);
            }
        }
        return bi;
    }
}

