/*
 * Decompiled with CFR 0.152.
 */
package ezjcom;

import ezjcom.JComActiveXObject;
import ezjcom.JComException;
import ezjcom.JComObject;
import java.awt.Canvas;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JPopupMenu;

public class JComActiveXContainer
extends Canvas {
    boolean attached = false;
    boolean addNotifyCalled = false;
    boolean initialSized = false;
    int lastWidth = -1;
    int lastHeight = -1;
    JComActiveXObject activeX = null;
    static String ezjcomError = null;
    static String title = "EZ-JCom ActiveX Container";
    Runnable checkSize = new Runnable(){

        public void run() {
            if (JComActiveXContainer.this.trackContainerSize()) {
                try {
                    JComActiveXContainer.this.resizeActiveX(JComActiveXContainer.this.activeX, JComActiveXContainer.this.getWidth(), JComActiveXContainer.this.getHeight());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    protected void onInitialize() {
    }

    public boolean isInitialized() {
        return this.attached;
    }

    public void addNotify() {
        super.addNotify();
        if (this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = true;
        if (this.activeX != null && !this.attached) {
            try {
                this.ezJComAttachActiveXObject(this.activeX);
                this.attached = true;
                this.onInitialize();
            }
            catch (JComException jComException) {
                throw new RuntimeException(jComException.toString());
            }
        }
    }

    public void removeNotify() {
        this.attached = false;
        this.addNotifyCalled = false;
        try {
            this.ezJComDetachActiveXObject(this.activeX);
        }
        catch (JComException jComException) {
            super.removeNotify();
            throw new RuntimeException(jComException.toString());
        }
        super.removeNotify();
    }

    void checkResize() {
        if (this.attached && this.isDisplayable() && (this.trackContainerSize() || !this.initialSized)) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.lastHeight != n2 || this.lastWidth != n || !this.initialSized) {
                try {
                    this.resizeActiveX(this.activeX, n, n2);
                    this.initialSized = true;
                    this.lastHeight = n2;
                    this.lastWidth = n;
                }
                catch (JComException jComException) {
                    throw new RuntimeException(jComException.toString());
                }
            }
        }
    }

    public JComActiveXContainer() throws JComException {
        new JComObject();
        if (ezjcomError != null) {
            throw new JComException(ezjcomError);
        }
        Listener listener = new Listener();
        this.addComponentListener(listener);
        this.addHierarchyListener(listener);
        this.addFocusListener(listener);
    }

    public void setActiveX(JComActiveXObject jComActiveXObject) throws JComException {
        jComActiveXObject.ezJComInitActiveX();
        if (this.activeX != null) {
            throw new JComException("ActiveX object already attached");
        }
        if (jComActiveXObject == null) {
            throw new NullPointerException("ActiveX object is null");
        }
        this.activeX = jComActiveXObject;
        if (this.addNotifyCalled) {
            this.ezJComAttachActiveXObject(this.activeX);
            this.attached = true;
            this.onInitialize();
        }
    }

    public JComActiveXObject getActiveX() {
        return this.activeX;
    }

    protected boolean onResizeRequest(int n, int n2) {
        return false;
    }

    protected boolean trackContainerSize() {
        return true;
    }

    protected void resizeActiveX(int n, int n2) throws JComException {
        this.resizeActiveX(this.activeX, n, n2);
    }

    protected void finalize() throws Throwable {
        this.activeX.ezJComCloseActiveX();
    }

    native void resizeActiveX(JComActiveXObject var1, int var2, int var3) throws JComException;

    native void ezJComAttachActiveXObject(JComActiveXObject var1) throws JComException;

    native void ezJComDetachActiveXObject(JComActiveXObject var1) throws JComException;

    static native String ezJComInitialize(String var0);

    native void ezJComOnSetFocus(JComActiveXObject var1);

    public JComObject createActiveX(Class clazz) throws JComException {
        return this.createActiveX(clazz, null);
    }

    public native JComObject createActiveX(Class var1, String var2) throws JComException;

    static {
        String string = System.getProperty("java.version");
        if (string.startsWith("0.") || string.startsWith("1.0") || string.startsWith("1.1") || string.startsWith("1.2")) {
            ezjcomError = "Java version " + string + "; EZ JCom ActiveX needs at least 1.3";
        }
        if (ezjcomError == null) {
            System.loadLibrary("EZJcomLib18");
            ezjcomError = JComActiveXContainer.ezJComInitialize(System.getProperty("java.home"));
        }
        if (ezjcomError == null) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }
    }

    private class Listener
    implements ComponentListener,
    HierarchyListener,
    FocusListener {
        private Listener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            JComActiveXContainer.this.checkResize();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            JComActiveXContainer.this.checkResize();
        }

        public void componentShown(ComponentEvent componentEvent) {
            JComActiveXContainer.this.checkResize();
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            JComActiveXContainer.this.checkResize();
        }

        public void focusGained(FocusEvent focusEvent) {
            JComActiveXContainer.this.ezJComOnSetFocus(JComActiveXContainer.this.activeX);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

