/*
 * Decompiled with CFR 0.152.
 */
package ezjcom;

import ezjcom.JComEnumeration;
import ezjcom.JComException;
import ezjcom.JComObject;
import ezjcom.JComRecord;
import java.math.BigDecimal;
import java.util.Date;

public class JComVariant {
    public static final int VARIANT_INT4 = 3;
    public static final int VARIANT_INT = 22;
    public static final int VARIANT_SHORT = 2;
    public static final int VARIANT_BOOLEAN = 11;
    public static final int VARIANT_EMPTY = 0;
    public static final int VARIANT_NULL = 1;
    public static final int VARIANT_FLOAT = 4;
    public static final int VARIANT_DOUBLE = 5;
    public static final int VARIANT_STRING = 8;
    public static final int VARIANT_JCOMOBJ = 9;
    public static final int VARIANT_ERROR = 10;
    public static final int VARIANT_CHAR = 16;
    public static final int VARIANT_BYTE = 17;
    public static final int VARIANT_UINT4 = 19;
    public static final int VARIANT_UINT = 23;
    public static final int VARIANT_USHORT = 18;
    public static final int VARIANT_CY = 6;
    public static final int VARIANT_DATE = 7;
    public static final int VARIANT_FILETIME = 64;
    public static final int VARIANT_VARIANT = 12;
    public static final int VARIANT_DECIMAL = 14;
    public static final int VARIANT_RECORD = 36;
    int variantData = 0;

    public JComVariant() {
        this.setType(0);
    }

    public JComVariant(byte by) {
        this.setByte(by);
        this.setType(17);
    }

    public JComVariant(int n) {
        this.setInt(n);
        this.setType(22);
    }

    public JComVariant(float f) {
        this.setFloat(f);
        this.setType(4);
    }

    public JComVariant(double d) {
        this.setDouble(d);
        this.setType(5);
    }

    public JComVariant(String string) {
        this.setString(string);
        this.setType(8);
    }

    public JComVariant(Date date) {
        this.setDate(date);
        this.setType(7);
    }

    public JComVariant(boolean bl) {
        this.setBoolean(bl);
        this.setType(11);
    }

    public JComVariant(BigDecimal bigDecimal) {
        this.setDecimal(bigDecimal);
        this.setType(14);
    }

    public JComVariant(JComRecord jComRecord) throws JComException {
        this.setRecord(jComRecord);
        this.setType(36);
    }

    public JComVariant(JComObject jComObject) {
        this.setJcomObject(jComObject);
        this.setType(9);
    }

    public JComVariant(JComEnumeration jComEnumeration) {
        this.setEnumeratedValue(jComEnumeration);
    }

    public boolean isByte() {
        int n = this.getType();
        return n == 16 || n == 17;
    }

    public boolean isShort() {
        int n = this.getType();
        return n == 2 || n == 18;
    }

    public boolean isBoolean() {
        return this.getType() == 11;
    }

    public boolean isInt() {
        int n = this.getType();
        return n == 3 || n == 19 || n == 22 || n == 23;
    }

    public boolean isFloat() {
        return this.getType() == 4;
    }

    public boolean isDouble() {
        return this.getType() == 5;
    }

    public boolean isString() {
        return this.getType() == 8;
    }

    public boolean isDate() {
        return this.getType() == 7;
    }

    public boolean isCurrency() {
        return this.getType() == 6;
    }

    public boolean isDecimal() {
        return this.getType() == 14;
    }

    public boolean isJComObject() {
        int n = this.getType();
        return n == 9 || n == 13;
    }

    public boolean isArray() {
        int n = this.getType();
        return (n & 0x2000) != 0 || (n & 0x1000) != 0;
    }

    public int getArrayType() {
        int n = this.getType();
        if ((n & 0x2000) == 0 && (n & 0x1000) == 0) {
            return 0;
        }
        n &= 0xFFFFDFFF;
        return n &= 0xFFFFEFFF;
    }

    public boolean isByteArray() {
        int n = this.getArrayType();
        return n == 16 || n == 17;
    }

    public boolean isBooleanArray() {
        return this.getArrayType() == 11;
    }

    public boolean isIntArray() {
        int n = this.getArrayType();
        return n == 3 || n == 19 || n == 22 || n == 23;
    }

    public boolean isShortArray() {
        int n = this.getArrayType();
        return n == 2 || n == 18;
    }

    public boolean isFloatArray() {
        return this.getArrayType() == 4;
    }

    public boolean isDoubleArray() {
        return this.getArrayType() == 5;
    }

    public boolean isStringArray() {
        return this.getArrayType() == 8;
    }

    public boolean isDateArray() {
        return this.getArrayType() == 7;
    }

    public boolean isCurrencyArray() {
        return this.getArrayType() == 6;
    }

    public boolean isVariantArray() {
        return this.getArrayType() == 12;
    }

    public boolean isJComObjectArray() {
        return this.getArrayType() == 9 || this.getArrayType() == 13;
    }

    public boolean isRecord() {
        return this.getType() == 36;
    }

    public boolean isMultiDimensionalArray() {
        return this.getNumberOfArrayDimensions() > 1;
    }

    public native int getNumberOfArrayDimensions();

    public native Class getRecordClass();

    public Object getObject() {
        int n = this.getType();
        switch (n) {
            case 0: 
            case 1: 
            case 24: {
                return null;
            }
            case 3: 
            case 19: 
            case 22: 
            case 23: {
                return new Integer(this.getInt());
            }
            case 11: {
                return new Boolean(this.getBoolean());
            }
            case 16: 
            case 17: {
                return new Byte(this.getByte());
            }
            case 2: 
            case 18: {
                return new Short(this.getShort());
            }
            case 4: {
                return new Float(this.getFloat());
            }
            case 5: {
                return new Double(this.getDouble());
            }
            case 8: {
                return this.getString();
            }
            case 7: {
                return this.getDate();
            }
            case 14: {
                return this.getDecimal();
            }
            case 6: {
                return new Long(this.getCurrency());
            }
            case 9: 
            case 13: {
                return this.getJcomObject();
            }
            case 36: {
                try {
                    return this.getRecord();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        if ((n & 0x2000) != 0 || (n & 0x1000) != 0) {
            n &= 0xFFFFDFFF;
            switch (n &= 0xFFFFEFFF) {
                case 3: 
                case 19: 
                case 22: 
                case 23: {
                    return this.getIntArray();
                }
                case 11: {
                    return this.getBooleanArray();
                }
                case 12: {
                    return this.getVariantArray();
                }
                case 16: 
                case 17: {
                    return this.getByteArray();
                }
                case 2: 
                case 18: {
                    return this.getShortArray();
                }
                case 4: {
                    return this.getFloatArray();
                }
                case 5: {
                    return this.getDoubleArray();
                }
                case 8: {
                    return this.getStringArray();
                }
                case 7: {
                    return this.getDateArray();
                }
                case 6: {
                    return this.getCurrencyArray();
                }
                case 9: 
                case 13: {
                    return this.getJComObjectArray();
                }
            }
        }
        return null;
    }

    public String toString() {
        int n = this.getType();
        switch (n) {
            case 0: 
            case 1: 
            case 24: {
                return "null";
            }
            case 3: 
            case 19: 
            case 22: 
            case 23: {
                return String.valueOf(this.getInt());
            }
            case 16: 
            case 17: {
                return String.valueOf(this.getByte());
            }
            case 2: 
            case 18: {
                return String.valueOf(this.getShort());
            }
            case 4: {
                return String.valueOf(this.getFloat());
            }
            case 5: {
                return String.valueOf(this.getDouble());
            }
            case 8: {
                return this.getString();
            }
            case 14: {
                return String.valueOf(this.getDecimal());
            }
            case 7: {
                return String.valueOf(this.getDate());
            }
            case 6: {
                return String.valueOf(this.getCurrency());
            }
            case 9: 
            case 13: {
                return String.valueOf(this.getJcomObject());
            }
        }
        Object object = this.getObject();
        if (object == null) {
            return "<Unsupported-variant>";
        }
        return object.toString();
    }

    public native int getType();

    public native int getInt();

    public native short getShort();

    public native byte getByte();

    public native boolean getBoolean();

    public native float getFloat();

    public native double getDouble();

    public native String getString();

    public native JComObject getJcomObject();

    public native long getCurrency();

    public native Date getDate();

    public native BigDecimal getDecimal();

    public native JComRecord getRecord() throws JComException;

    public native Object getMultiDimensionalArray() throws JComException;

    public native Date getFileTime();

    public native void setType(int var1);

    public native void setByte(byte var1);

    public native void setInt(int var1);

    public native void setShort(short var1);

    public native void setBoolean(boolean var1);

    public native void setFloat(float var1);

    public native void setDouble(double var1);

    public native void setString(String var1);

    public native void setJcomObject(JComObject var1);

    public native void setDate(Date var1);

    public native void setFileTime(Date var1);

    public native void setCurrency(long var1);

    public native void setDecimal(BigDecimal var1);

    public void setEnumeratedValue(JComEnumeration jComEnumeration) {
        this.setInt(jComEnumeration.getEnumeratedIntValue());
        this.setType(3);
    }

    public native int[] getIntArray();

    public native byte[] getByteArray();

    public native short[] getShortArray();

    public native boolean[] getBooleanArray();

    public native float[] getFloatArray();

    public native double[] getDoubleArray();

    public native String[] getStringArray();

    public native Date[] getDateArray();

    public native long[] getCurrencyArray();

    public native JComVariant[] getVariantArray();

    public native JComObject[] getJComObjectArray();

    public JComVariant(int[] nArray) {
        this.setIntArray(nArray);
        this.setType(8214);
    }

    public JComVariant(byte[] byArray) {
        this.setByteArray(byArray);
        this.setType(8209);
    }

    public JComVariant(short[] sArray) {
        this.setShortArray(sArray);
        this.setType(8194);
    }

    public JComVariant(float[] fArray) {
        this.setFloatArray(fArray);
        this.setType(8196);
    }

    public JComVariant(double[] dArray) {
        this.setDoubleArray(dArray);
        this.setType(8197);
    }

    public JComVariant(String[] stringArray) {
        this.setStringArray(stringArray);
        this.setType(8200);
    }

    public JComVariant(Date[] dateArray) {
        this.setDateArray(dateArray);
        this.setType(8199);
    }

    public JComVariant(JComObject[] jComObjectArray) {
        this.setJComObjectArray(jComObjectArray);
        this.setType(8201);
    }

    public native void setIntArray(int[] var1);

    public native void setByteArray(byte[] var1);

    public native void setShortArray(short[] var1);

    public native void setBooleanArray(boolean[] var1);

    public native void setFloatArray(float[] var1);

    public native void setDoubleArray(double[] var1);

    public native void setStringArray(String[] var1);

    public native void setDateArray(Date[] var1);

    public native void setCurrencyArray(long[] var1);

    public native void setVariantArray(JComVariant[] var1);

    public native void setJComObjectArray(JComObject[] var1);

    public native void setMultiDimensionalArray(int var1, int var2, Object var3) throws JComException;

    public void setMultiDimensionalArray(Object object) throws JComException {
        if (object instanceof int[][][]) {
            this.setMultiDimensionalArray(3, 22, object);
        } else if (object instanceof int[][]) {
            this.setMultiDimensionalArray(2, 22, object);
        } else if (object instanceof int[]) {
            this.setMultiDimensionalArray(1, 22, object);
        } else if (object instanceof float[][][]) {
            this.setMultiDimensionalArray(3, 4, object);
        } else if (object instanceof float[][]) {
            this.setMultiDimensionalArray(2, 4, object);
        } else if (object instanceof float[]) {
            this.setMultiDimensionalArray(1, 4, object);
        } else if (object instanceof short[][][]) {
            this.setMultiDimensionalArray(3, 2, object);
        } else if (object instanceof short[][]) {
            this.setMultiDimensionalArray(2, 2, object);
        } else if (object instanceof short[]) {
            this.setMultiDimensionalArray(1, 2, object);
        } else if (object instanceof double[][][]) {
            this.setMultiDimensionalArray(3, 5, object);
        } else if (object instanceof double[][]) {
            this.setMultiDimensionalArray(2, 5, object);
        } else if (object instanceof double[]) {
            this.setMultiDimensionalArray(1, 5, object);
        } else if (object instanceof String[][][]) {
            this.setMultiDimensionalArray(3, 8, object);
        } else if (object instanceof String[][]) {
            this.setMultiDimensionalArray(2, 8, object);
        } else if (object instanceof String[]) {
            this.setMultiDimensionalArray(1, 8, object);
        } else if (object instanceof byte[][][]) {
            this.setMultiDimensionalArray(3, 17, object);
        } else if (object instanceof byte[][]) {
            this.setMultiDimensionalArray(2, 17, object);
        } else if (object instanceof byte[]) {
            this.setMultiDimensionalArray(1, 17, object);
        } else if (object instanceof BigDecimal[][][]) {
            this.setMultiDimensionalArray(3, 14, object);
        } else if (object instanceof BigDecimal[][]) {
            this.setMultiDimensionalArray(2, 14, object);
        } else if (object instanceof BigDecimal[]) {
            this.setMultiDimensionalArray(1, 14, object);
        } else {
            throw new JComException("Argument type is not handled by this method, try calling other overload directly.");
        }
    }

    public native void setRecord(JComRecord var1) throws JComException;

    synchronized native void freeMemory();

    static native void initialize();

    protected void finalize() throws Throwable {
        this.freeMemory();
    }

    public void release() {
        this.freeMemory();
    }

    static {
        System.loadLibrary("EZJcomLib18");
        JComVariant.initialize();
    }
}

