/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import netscape.applet.EmbeddedAppletFrame;
import netscape.applet.MozillaAppletContext;

final class AppletClassLoader
extends ClassLoader {
    Hashtable classes;
    URL codeBaseURL;
    MozillaAppletContext context;

    AppletClassLoader(MozillaAppletContext cx, URL codebase) {
        String file = codebase.getFile();
        int i = file.lastIndexOf(47);
        if (i > 0 && i < file.length() - 1) {
            try {
                codebase = new URL(codebase, file.substring(0, i + 1));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.codeBaseURL = codebase;
        this.context = cx;
        this.classes = new Hashtable();
    }

    boolean mayScript() {
        return EmbeddedAppletFrame.getMayScript(this.codeBaseURL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class loadClass(URL url) throws IOException {
        Class<?> clazz;
        InputStream in = null;
        try {
            int n;
            URLConnection c = url.openConnection();
            c.setAllowUserInteraction(false);
            in = c.getInputStream();
            int len = c.getContentLength();
            byte[] data = new byte[len == -1 ? 4096 : len];
            int total = 0;
            while ((n = in.read(data, total, data.length - total)) >= 0) {
                if ((total += n) != data.length) continue;
                if (len >= 0) break;
                byte[] newdata = new byte[total * 2];
                System.arraycopy(data, 0, newdata, 0, total);
                data = newdata;
            }
            clazz = this.defineClass(data, 0, total);
            Object var4_9 = null;
            if (in == null) return clazz;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return clazz;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class cl = (Class)this.classes.get(name);
        if (cl == null) {
            int i;
            SecurityManager security = System.getSecurityManager();
            if (security != null && (i = name.lastIndexOf(46)) >= 0) {
                security.checkPackageAccess(name.substring(0, i));
            }
            try {
                return this.findSystemClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                cl = this.findClass(name);
            }
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    private synchronized Class findClass(String name) throws ClassNotFoundException {
        URL url;
        int i;
        SecurityManager security;
        Class cl = (Class)this.classes.get(name);
        if (cl != null) {
            return cl;
        }
        if (this.context != null && MozillaAppletContext.debug > 0) {
            System.out.println("# Find class " + name);
        }
        if ((security = System.getSecurityManager()) != null && (i = name.lastIndexOf(46)) >= 0) {
            security.checkPackageDefinition(name.substring(0, i));
        }
        String cname = name.replace('.', '/') + ".class";
        try {
            url = new URL(this.codeBaseURL, cname);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(name);
        }
        if (this.context != null && MozillaAppletContext.debug > 0) {
            System.out.println("# Fetching " + url);
        }
        try {
            cl = this.loadClass(url);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(name);
        }
        if (!name.equals(cl.getName())) {
            Class oldcl = cl;
            cl = null;
            throw new ClassFormatError(name + " != " + oldcl.getName());
        }
        this.classes.put(name, cl);
        return cl;
    }
}

