/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.io.File;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.applet.AppletClassLoader;
import netscape.applet.AppletSecurityException;
import netscape.applet.AppletThreadGroup;

public class AppletSecurity
extends SecurityManager {
    boolean initACL;
    String[] readACL;
    String[] writeACL;
    int networkMode;
    static final int NETWORK_NONE = 1;
    static final int NETWORK_HOST = 2;
    static final int NETWORK_UNRESTRICTED = 3;

    public AppletSecurity() {
        this.reset();
    }

    void reset() {
        String str = System.getProperty("appletviewer.security.mode");
        if (str == null) {
            str = "host";
        }
        if (str.equals("unrestricted")) {
            this.networkMode = 3;
            return;
        }
        if (str.equals("none")) {
            this.networkMode = 1;
            return;
        }
        this.networkMode = 2;
    }

    public synchronized boolean getInCheck() {
        return super.getInCheck();
    }

    boolean fromApplet() {
        return this.classLoaderDepth() == 1;
    }

    boolean inApplet() {
        return this.inClassLoader();
    }

    public Object getSecurityContext() {
        AppletClassLoader loader = (AppletClassLoader)this.currentClassLoader();
        if (loader == null) {
            return null;
        }
        return loader.codeBaseURL;
    }

    public synchronized void checkCreateClassLoader(int caller_depth) {
        if (this.classLoaderDepth() == caller_depth + 1) {
            throw new AppletSecurityException("classloader");
        }
    }

    public synchronized void checkAccess(Thread t, int caller_depth) {
        if (this.classLoaderDepth() == caller_depth + 1 && !(t.getThreadGroup() instanceof AppletThreadGroup)) {
            throw new AppletSecurityException("thread");
        }
    }

    public synchronized void checkAccess(ThreadGroup g, int caller_depth) {
        if (this.classLoaderDepth() == caller_depth + 1 && !(g instanceof AppletThreadGroup)) {
            throw new AppletSecurityException("threadgroup", g.toString());
        }
    }

    public synchronized void checkExit(int status) {
        if (this.inApplet()) {
            throw new AppletSecurityException("exit", String.valueOf(status));
        }
    }

    public synchronized void checkExec(String cmd) {
        if (this.inApplet()) {
            throw new AppletSecurityException("exec", cmd);
        }
    }

    public synchronized void checkLink(String lib, int caller_depth) {
        if (this.classLoaderDepth() == caller_depth + 1) {
            throw new AppletSecurityException("link", lib);
        }
    }

    public synchronized void checkPropertiesAccess(int caller_depth) {
        if (this.classLoaderDepth() == caller_depth + 1) {
            throw new AppletSecurityException("properties");
        }
    }

    public synchronized void checkPropertyAccess(String key, int caller_depth) {
        if (this.classLoaderDepth() == caller_depth + 1 && !"true".equalsIgnoreCase(System.getProperty(key + ".applet"))) {
            throw new AppletSecurityException("properties");
        }
    }

    void parseACL(Vector v, String path, String defaultPath) {
        StringTokenizer t = new StringTokenizer(path, System.getProperty("path.separator"));
        while (t.hasMoreTokens()) {
            String dir = t.nextToken();
            if (dir.startsWith("~")) {
                v.addElement(System.getProperty("user.home") + dir.substring(1));
                continue;
            }
            if (dir.equals("+")) {
                if (defaultPath == null) continue;
                this.parseACL(v, defaultPath, null);
                continue;
            }
            v.addElement(dir);
        }
    }

    String[] parseACL(String path, String defaultPath) {
        if (path == null) {
            return new String[0];
        }
        if (path.equals("*")) {
            return null;
        }
        Vector v = new Vector();
        this.parseACL(v, path, defaultPath);
        Object[] acl = new String[v.size()];
        v.copyInto(acl);
        return acl;
    }

    void initializeACLs() {
        this.readACL = this.parseACL(System.getProperty("acl.read"), System.getProperty("acl.read.default"));
        this.writeACL = this.parseACL(System.getProperty("acl.write"), System.getProperty("acl.write.default"));
        this.initACL = true;
    }

    public synchronized void checkRead(String file) {
        AppletClassLoader loader = (AppletClassLoader)this.currentClassLoader();
        if (loader != null) {
            this.checkRead(file, loader.codeBaseURL);
        }
    }

    public synchronized void checkRead(String file, URL base) {
        if (base != null) {
            String dir;
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.readACL == null) {
                return;
            }
            int i = this.readACL.length;
            while (i-- > 0) {
                if (!file.startsWith(this.readACL[i])) continue;
                return;
            }
            if (base.getProtocol().equals("file") && file.startsWith(dir = base.getFile().replace('/', File.separatorChar))) {
                return;
            }
            throw new AppletSecurityException("file.read", file);
        }
    }

    public void checkRead(String file, Object context) {
        this.checkRead(file);
        if (context != null) {
            this.checkRead(file, (URL)context);
        }
    }

    public synchronized void checkWrite(String file) {
        if (this.inApplet()) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.writeACL == null) {
                return;
            }
            int i = this.writeACL.length;
            while (i-- > 0) {
                if (!file.startsWith(this.writeACL[i])) continue;
                return;
            }
            throw new AppletSecurityException("file.write", file);
        }
    }

    public synchronized void checkRead(FileDescriptor fd) {
        if (this.inApplet() && !this.inClass("java.net.SocketInputStream") || !fd.valid()) {
            throw new AppletSecurityException("fd.read");
        }
    }

    public synchronized void checkWrite(FileDescriptor fd) {
        if (this.inApplet() && !this.inClass("java.net.SocketOutputStream") || !fd.valid()) {
            throw new AppletSecurityException("fd.write");
        }
    }

    public synchronized void checkListen(int port) {
        AppletClassLoader loader = (AppletClassLoader)this.currentClassLoader();
        if (loader == null) {
            return;
        }
        if (port > 1024) {
            return;
        }
        throw new AppletSecurityException("socket.listen", String.valueOf(port));
    }

    public synchronized void checkAccept(String host, int port) {
        AppletClassLoader loader = (AppletClassLoader)this.currentClassLoader();
        if (loader == null) {
            return;
        }
        this.checkConnect(loader.codeBaseURL.getHost(), host);
    }

    public synchronized void checkConnect(String host, int port) {
        AppletClassLoader loader = (AppletClassLoader)this.currentClassLoader();
        if (loader == null) {
            return;
        }
        this.checkConnect(loader.codeBaseURL.getHost(), host);
    }

    public void checkConnect(String host, int port, Object context) {
        this.checkConnect(host, port);
        if (context != null) {
            this.checkConnect(((URL)context).getHost(), host);
        }
    }

    public synchronized void checkConnect(String fromHost, String toHost) {
        if (fromHost == null) {
            return;
        }
        switch (this.networkMode) {
            case 1: {
                throw new AppletSecurityException("socket.connect", fromHost + "->" + toHost);
            }
            case 2: {
                if (fromHost.length() == 0 && toHost.length() == 0) {
                    return;
                }
                this.inCheck = true;
                try {
                    try {
                        if (InetAddress.getByName(fromHost).equals(InetAddress.getByName(toHost))) {
                            Object var4_3 = null;
                            this.inCheck = false;
                            return;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.inCheck = false;
                    throw throwable;
                }
                Object var4_4 = null;
                this.inCheck = false;
                break;
            }
            case 3: {
                return;
            }
        }
        throw new AppletSecurityException("socket.connect", fromHost + "->" + toHost);
    }

    public synchronized void checkURLConnect(URL url) {
        AppletClassLoader loader = (AppletClassLoader)this.currentClassLoader();
        if (loader == null) {
            return;
        }
        String codeBaseProtocol = loader.codeBaseURL.getProtocol();
        String protocol = url.getProtocol();
        if (protocol.equals(codeBaseProtocol)) {
            if (protocol.equals("http") || protocol.equals("https") || protocol.equals("ftp") || protocol.equals("gopher")) {
                this.checkConnect(url.getHost(), url.getPort());
                return;
            }
            if (protocol.equals("file")) {
                this.checkConnect(url.getHost(), url.getPort());
                String baseDir = loader.codeBaseURL.getFile();
                String file = url.getFile();
                if (baseDir == null || file == null) {
                    return;
                }
                if (file.startsWith(baseDir)) {
                    return;
                }
            }
        }
        throw new AppletSecurityException("protocol", protocol);
    }

    public synchronized boolean checkTopLevelWindow(Object window) {
        return !this.inClassLoader();
    }

    public synchronized void checkPackageAccess(String pkg) {
        int i = pkg.indexOf(46);
        if (i > 0) {
            pkg = pkg.substring(0, i);
        }
        if (this.inClassLoader() && Boolean.getBoolean("package.restrict.access." + pkg)) {
            throw new SecurityException();
        }
    }

    public synchronized void checkPackageDefinition(String pkg) {
        int i = pkg.indexOf(46);
        if (i > 0) {
            pkg = pkg.substring(0, i);
        }
        if (this.inClassLoader() && Boolean.getBoolean("package.restrict.definition." + pkg)) {
            throw new SecurityException();
        }
    }

    public synchronized void checkSetFactory() {
        throw new SecurityException();
    }
}

