/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.applet.AppletThreadGroup;
import netscape.applet.MozillaAppletContext;
import netscape.applet.MozillaWindow;

class EmbeddedAppletFrame
extends Frame
implements AppletStub,
Runnable {
    int pData;
    MozillaAppletContext context;
    URL documentURL;
    URL codebaseURL;
    Hashtable atts;
    Applet applet;
    int status;
    Thread handler;
    static final int APPLET_DISPOSE = 0;
    static final int APPLET_LOAD = 1;
    static final int APPLET_INIT = 2;
    static final int APPLET_START = 3;
    static final int APPLET_STOP = 4;
    static final int APPLET_DESTROY = 5;
    static final int APPLET_RESIZE = 51234;
    Dimension appletSize = new Dimension(100, 100);
    static Hashtable mayScript = new Hashtable();
    Event queue;
    String currentStatus = "";
    String errorReason;

    EmbeddedAppletFrame(URL documentURL, URL codebaseURL, Hashtable atts, MozillaAppletContext context, int pLJAppletData) {
        this.pData = pLJAppletData;
        this.context = context;
        this.documentURL = documentURL;
        this.codebaseURL = codebaseURL;
        this.atts = atts;
        this.setLayout(new BorderLayout());
        String att = this.getParameter("width");
        if (att != null) {
            this.appletSize.width = Integer.valueOf(att);
        }
        if ((att = this.getParameter("height")) != null) {
            this.appletSize.height = Integer.valueOf(att);
        }
        if ((att = this.getParameter("mayscript")) != null) {
            EmbeddedAppletFrame.setMayScript(codebaseURL, 1);
        }
    }

    protected void finalize() {
        String att = this.getParameter("mayscript");
        if (att != null) {
            EmbeddedAppletFrame.setMayScript(this.codebaseURL, -1);
        }
    }

    static synchronized boolean getMayScript(URL codebaseURL) {
        int i;
        Integer iobj = (Integer)mayScript.get(codebaseURL);
        int n = i = iobj == null ? 0 : iobj;
        return i > 0;
    }

    static synchronized void setMayScript(URL codebaseURL, int delta) {
        if (mayScript.containsKey(codebaseURL)) {
            Integer i = (Integer)mayScript.get(codebaseURL);
            int val = i != null ? i : 0;
            mayScript.put(codebaseURL, new Integer(val + delta));
            return;
        }
        mayScript.put(codebaseURL, new Integer(delta));
    }

    void dumpState(PrintStream out, int i) {
        MozillaWindow.indent(out, i);
        out.println("EmbeddedAppletFrame id=" + this.pData + " documentURL=" + this.documentURL);
        MozillaWindow.indent(out, i);
        out.println("  codebaseURL=" + this.codebaseURL + " status=" + this.statusToString(this.status));
        MozillaWindow.indent(out, i);
        out.println("  handler=" + this.handler);
        Enumeration e = this.atts.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.atts.get(key);
            MozillaWindow.indent(out, i + 1);
            out.println(key + " = " + value);
        }
    }

    String statusToString(int status) {
        switch (status) {
            case 0: {
                return "dispose";
            }
            case 1: {
                return "load";
            }
            case 2: {
                return "init";
            }
            case 3: {
                return "start";
            }
            case 4: {
                return "stop";
            }
            case 5: {
                return "destroy";
            }
        }
        return Integer.toString(status, 10);
    }

    public Dimension minimumSize() {
        return new Dimension(this.appletSize.width, this.appletSize.height);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    void sendEvent(int id) {
        this.sendEvent(new Event(null, id, null));
    }

    synchronized void sendEvent(Event evt) {
        if (this.queue == null) {
            evt.target = this.queue;
            this.queue = evt;
            this.notifyAll();
            return;
        }
        Event q = this.queue;
        while (q.target != null) {
            q = (Event)q.target;
        }
        q.target = evt;
    }

    synchronized Event getNextEvent() throws InterruptedException {
        while (this.queue == null) {
            this.wait();
        }
        Event evt = this.queue;
        this.queue = (Event)this.queue.target;
        evt.target = this;
        return evt;
    }

    public void start() {
        this.handler = new Thread((ThreadGroup)new AppletThreadGroup("applet-" + this.atts.get("code"), this), this);
        this.handler.start();
    }

    public void run() {
        block24: while (true) {
            Event evt;
            try {
                evt = this.getNextEvent();
            }
            catch (InterruptedException e) {
                this.showAppletException(e, "interrupted, bailing out...");
                return;
            }
            try {
                switch (evt.id) {
                    default: {
                        continue block24;
                    }
                    case 1: {
                        if (this.status != 0) {
                            this.wrongState("can't load", "not disposed");
                            continue block24;
                        }
                        String code = this.getParameter("code");
                        if (code.endsWith(".class")) {
                            code = code.substring(0, code.length() - 6).replace('/', '.');
                        }
                        if (code.endsWith(".java")) {
                            code = code.substring(0, code.length() - 5).replace('/', '.');
                        }
                        try {
                            this.applet = (Applet)this.context.loadClass(this.codebaseURL, code).newInstance();
                        }
                        catch (VerifyError e) {
                            this.showAppletException(e, "class " + e.getMessage() + " got a security violation: method verification error");
                            continue block24;
                        }
                        catch (SecurityException e) {
                            this.showAppletException(e, "class " + code + " got a security violation: " + e.getMessage());
                            continue block24;
                        }
                        catch (ClassNotFoundException e) {
                            this.showAppletException(e, "class " + code + " not found");
                            continue block24;
                        }
                        catch (InstantiationException e) {
                            this.showAppletException(e, "class " + code + " can't be instantiated");
                            continue block24;
                        }
                        catch (IllegalAccessException e) {
                            this.showAppletException(e, "class " + code + " is not public or has no public constructor");
                            continue block24;
                        }
                        catch (Exception e) {
                            this.showAppletException(e, "exception: " + e.toString());
                            continue block24;
                        }
                        catch (ThreadDeath threadDeath) {
                            this.showAppletStatus("killed");
                            return;
                        }
                        catch (Error e) {
                            this.showAppletException(e, "error: " + e.toString());
                            continue block24;
                        }
                        this.applet.setStub(this);
                        this.applet.hide();
                        this.add("Center", this.applet);
                        this.status = 1;
                        this.rightState("loaded");
                        this.validate();
                        continue block24;
                    }
                    case 2: {
                        if (this.status != 1) {
                            this.wrongState("can't init", "applet not loaded");
                            continue block24;
                        }
                        this.pack();
                        this.show();
                        this.applet.resize(this.appletSize);
                        this.applet.init();
                        this.validate();
                        this.status = 2;
                        this.rightState("initialized");
                        continue block24;
                    }
                    case 3: {
                        if (this.status != 2) {
                            this.wrongState("can't start", "applet not initialized");
                            continue block24;
                        }
                        this.status = 3;
                        this.applet.resize(this.appletSize);
                        this.applet.start();
                        this.applet.show();
                        this.validate();
                        this.context.mochaOnLoad(0);
                        this.rightState("running");
                        continue block24;
                    }
                    case 4: {
                        if (this.status != 3) {
                            this.wrongState("can't stop", "applet not started");
                            continue block24;
                        }
                        this.status = 2;
                        this.applet.hide();
                        this.applet.stop();
                        this.rightState("stopped");
                        continue block24;
                    }
                    case 5: {
                        if (this.status != 2) {
                            this.wrongState("can't destroy", "applet not stopped");
                            continue block24;
                        }
                        this.status = 1;
                        this.applet.destroy();
                        ((Component)this).hide();
                        this.rightState("destroyed");
                        continue block24;
                    }
                    case 0: 
                }
                if (this.status != 1) {
                    this.wrongState("can't dispose", "applet not destroyed");
                    continue;
                }
                this.status = 0;
                this.remove(this.applet);
                this.rightState("disposed");
                this.dispose();
                return;
            }
            catch (SecurityException e) {
                this.showAppletException(e, "security violation: " + e.getMessage());
                continue;
            }
            catch (Exception e) {
                this.showAppletException(e, "exception: " + e.toString());
                continue;
            }
            catch (ThreadDeath threadDeath) {
                this.showAppletStatus("killed");
                return;
            }
            catch (Error e) {
                this.showAppletException(e, "error: " + e.toString());
                continue;
            }
            break;
        }
    }

    public boolean isActive() {
        return this.status == 3;
    }

    public String getParameter(String name) {
        return (String)this.atts.get(name.toLowerCase());
    }

    public URL getDocumentBase() {
        return this.documentURL;
    }

    public URL getCodeBase() {
        return this.codebaseURL;
    }

    public AppletContext getAppletContext() {
        return this.context;
    }

    public void appletResize(int width, int height) {
        this.appletSize.width = width;
        this.appletSize.height = height;
        ((Component)this).postEvent(new Event(this, 51234, this.preferredSize()));
    }

    protected void showAppletStatus(String status) {
        if (this.applet == null) {
            this.currentStatus = "Applet " + status;
        } else {
            String name = this.applet.getParameter("name");
            if (name == null) {
                name = this.applet.getClass().getName().toString();
            }
            this.currentStatus = "Applet " + name + " " + status;
        }
        this.getAppletContext().showStatus(this.currentStatus);
    }

    protected void showAppletLog(String str) {
        String longStr;
        if (this.applet == null) {
            longStr = "# Applet log: " + str;
        } else {
            String name = this.applet.getParameter("name");
            if (name == null) {
                name = this.applet.getClass().getName().toString();
            }
            longStr = "# Applet " + name + " " + " log: " + str;
        }
        System.err.println(longStr);
    }

    protected void rightState(String message) {
        this.errorReason = null;
        this.showAppletStatus(message);
    }

    protected void wrongState(String message, String newReason) {
        this.showAppletStatus(message + ": " + (this.errorReason != null ? this.errorReason : newReason));
    }

    protected void showAppletException(Throwable t, String message) {
        this.context.mochaOnLoad(-1);
        if (message == null) {
            message = t.toString();
        }
        this.errorReason = message;
        System.err.println("# Applet exception: " + message);
        t.printStackTrace();
        this.showAppletStatus(message);
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        this.getAppletContext().showStatus(this.currentStatus);
        return true;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        this.getAppletContext().showStatus("");
        return true;
    }
}

