/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.applet.MozillaAppletContext;
import netscape.applet.MozillaFrame;
import netscape.applet.MozillaWindow;

class HistoryElement {
    MozillaFrame frame;
    int id;
    MozillaAppletContext appletContext;
    boolean visible;
    private static Vector history = new Vector();
    private static Hashtable historyHash = new Hashtable();
    static int hiddenElements;

    HistoryElement(int id, MozillaFrame frame, MozillaAppletContext acx) {
        this.id = id;
        this.appletContext = acx;
        this.frame = frame;
        frame.add(this);
        history.addElement(this);
        historyHash.put(new Integer(id), this);
    }

    void destroy() {
        history.removeElement(this);
        historyHash.remove(new Integer(this.id));
        this.frame.remove(this);
    }

    void stop() {
        if (this.visible) {
            ++hiddenElements;
            this.visible = false;
        }
    }

    void start() {
        if (!this.visible) {
            --hiddenElements;
            this.visible = true;
            this.frame.setCurrent(this);
        }
    }

    void resurrect(MozillaAppletContext acx) {
        this.appletContext = acx;
    }

    static HistoryElement lookup(int id) {
        return (HistoryElement)historyHash.get(new Integer(id));
    }

    static void trim() {
        int n = history.size();
        int i = 0;
        while (i < n) {
            HistoryElement h = (HistoryElement)history.elementAt(i);
            if (!h.visible && h.appletContext != null) {
                MozillaAppletContext acx = h.appletContext;
                h.appletContext = null;
                acx.trim();
                return;
            }
            ++i;
        }
    }

    static Enumeration elements() {
        return history.elements();
    }

    static void destroyAll() {
        System.err.println("Destroying all applets");
        history.size();
        Enumeration e = history.elements();
        while (e.hasMoreElements()) {
            HistoryElement h = (HistoryElement)e.nextElement();
            MozillaAppletContext acx = h.appletContext;
            if (acx != null) {
                acx.trim();
            }
            h.destroy();
        }
    }

    void dumpState(PrintStream out, int i) {
        MozillaWindow.indent(out, i);
        out.println("HistoryElement id=" + this.id);
        if (this.appletContext != null) {
            this.appletContext.dumpState(out, i + 1);
        }
    }
}

