/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.applet.AppletAudioClip;
import netscape.applet.AppletClassLoader;
import netscape.applet.AppletProperties;
import netscape.applet.AppletSecurity;
import netscape.applet.Console;
import netscape.applet.EmbeddedAppletFrame;
import netscape.applet.HistoryElement;
import netscape.applet.MozillaFrame;
import netscape.applet.MozillaWindow;
import netscape.net.URLStreamHandlerFactory;
import sun.awt.image.URLImageSource;

class MozillaAppletContext
implements AppletContext {
    int frameMWContext;
    HistoryElement history;
    Hashtable appletFrames = new Hashtable();
    Hashtable imageCache = new Hashtable();
    Hashtable audioClipCache = new Hashtable();
    Hashtable classLoaders = new Hashtable();
    URL documentURL;
    static int debug;
    static Console console;
    static int totalApplets;
    static int MAX_APPLETS;
    static int APPLETS_PER_WINDOW;

    MozillaAppletContext() {
    }

    void dumpState(PrintStream out, int i) {
        URL u;
        Enumeration e;
        MozillaWindow.indent(out, i);
        out.println("MozillaAppletContext #frames=" + this.appletFrames.size() + " #images=" + this.imageCache.size() + " #audioClips=" + this.audioClipCache.size() + " #classLoaders=" + this.classLoaders.size() + " url=" + this.documentURL);
        Enumeration e2 = this.appletFrames.elements();
        while (e2.hasMoreElements()) {
            EmbeddedAppletFrame eaf = (EmbeddedAppletFrame)e2.nextElement();
            eaf.dumpState(out, i + 1);
        }
        if (this.imageCache.size() > 0) {
            MozillaWindow.indent(out, i + 1);
            out.println("image cache:");
            e = this.imageCache.keys();
            while (e.hasMoreElements()) {
                u = (URL)e.nextElement();
                MozillaWindow.indent(out, i + 2);
                out.println(u.toString());
            }
        }
        if (this.audioClipCache.size() > 0) {
            MozillaWindow.indent(out, i + 1);
            out.println("audio clip cache:");
            e = this.audioClipCache.keys();
            while (e.hasMoreElements()) {
                u = (URL)e.nextElement();
                MozillaWindow.indent(out, i + 2);
                out.println(u.toString());
            }
        }
        if (this.classLoaders.size() > 0) {
            MozillaWindow.indent(out, i + 1);
            out.println("class loader cache:");
            e = this.classLoaders.keys();
            while (e.hasMoreElements()) {
                u = (URL)e.nextElement();
                MozillaWindow.indent(out, i + 2);
                out.println(u.toString());
            }
        }
    }

    void destroy() {
        if (debug > 0) {
            System.err.println("# destroy acx=" + this + " frameMWContext=" + this.frameMWContext);
        }
        this.frameMWContext = 0;
        this.appletFrames = null;
        this.imageCache = null;
        this.audioClipCache = null;
    }

    void trim() {
        this.destroyApplets();
        this.destroy();
    }

    Class loadClass(URL codebase, String code) throws ClassNotFoundException {
        AppletClassLoader loader = MozillaAppletContext.lookupClassLoader(this, codebase);
        return loader.loadClass(code);
    }

    public AudioClip getAudioClip(URL url) {
        AudioClip clip = MozillaAppletContext.lookupAudioClip(this, url);
        return clip;
    }

    public Image getImage(URL url) {
        Image img = MozillaAppletContext.lookupImage(this, url);
        return img;
    }

    public Applet getApplet(String name) {
        name = name.toLowerCase();
        Enumeration e = this.appletFrames.elements();
        while (e.hasMoreElements()) {
            EmbeddedAppletFrame p = (EmbeddedAppletFrame)e.nextElement();
            if (!name.equals(p.applet.getParameter("name"))) continue;
            return p.applet;
        }
        return null;
    }

    public Enumeration getApplets() {
        Vector<Applet> v = new Vector<Applet>();
        Enumeration e = this.appletFrames.elements();
        while (e.hasMoreElements()) {
            EmbeddedAppletFrame p = (EmbeddedAppletFrame)e.nextElement();
            v.addElement(p.applet);
        }
        return v.elements();
    }

    public void showDocument(URL url) {
        this.showDocument(url, "_top");
    }

    public void showDocument(URL url, String target) {
        this.pShowDocument(url.toExternalForm(), null, target);
    }

    public void showStatus(String status) {
        this.pShowStatus(status);
    }

    public void mochaOnLoad(int result) {
        this.pMochaOnLoad(result);
    }

    private native void pShowDocument(String var1, String var2, String var3);

    private native void pShowStatus(String var1);

    private native void pMochaOnLoad(int var1);

    static synchronized AppletClassLoader lookupClassLoader(MozillaAppletContext incx, URL url) {
        Object loader;
        if (incx != null && (loader = incx.classLoaders.get(url)) != null) {
            return (AppletClassLoader)loader;
        }
        loader = new AppletClassLoader(incx, url);
        incx.classLoaders.put(url, loader);
        if (debug > 0) {
            System.err.println("# New class loader: " + url);
        }
        return loader;
    }

    static synchronized AudioClip lookupAudioClip(MozillaAppletContext incx, URL url) {
        Enumeration e = HistoryElement.elements();
        while (e.hasMoreElements()) {
            Object clip;
            HistoryElement h = (HistoryElement)e.nextElement();
            MozillaAppletContext acx = h.appletContext;
            if (acx == null || (clip = acx.audioClipCache.get(url)) == null) continue;
            return (AudioClip)clip;
        }
        AppletAudioClip clip = new AppletAudioClip(url);
        incx.audioClipCache.put(url, clip);
        if (debug > 0) {
            System.err.println("# New audio clip: " + url);
        }
        return clip;
    }

    static synchronized Image lookupImage(MozillaAppletContext incx, URL url) {
        Image image;
        Enumeration e = HistoryElement.elements();
        while (e.hasMoreElements()) {
            Object image2;
            HistoryElement h = (HistoryElement)e.nextElement();
            MozillaAppletContext acx = h.appletContext;
            if (acx == null || (image2 = acx.imageCache.get(url)) == null) continue;
            return (Image)image2;
        }
        try {
            URLImageSource source = new URLImageSource(url);
            image = Toolkit.getDefaultToolkit().createImage(source);
            incx.imageCache.put(url, image);
            if (debug > 0) {
                System.err.println("# New image: " + url);
            }
        }
        catch (Exception exception) {
            image = null;
        }
        return image;
    }

    synchronized void initApplet(int pLJAppletData, String[] argv) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        int i = 1;
        while (i < argv.length) {
            String str = argv[i];
            int j = str.indexOf(61);
            if (j >= 0) {
                params.put(str.substring(0, j).toLowerCase(), str.substring(j + 1));
            }
            ++i;
        }
        String dbg = (String)params.get("debug");
        if (dbg != null) {
            try {
                debug = Integer.parseInt(dbg);
            }
            catch (Exception exception) {}
        }
        try {
            this.documentURL = new URL(argv[0]);
        }
        catch (MalformedURLException malformedURLException) {
            if (debug > 0) {
                System.err.println("# Malformed documentURL: " + argv[0]);
            }
            this.mochaOnLoad(-1);
            return;
        }
        String codebase = (String)params.get("codebase");
        if (codebase == null) {
            codebase = argv[0];
            int tail = codebase.lastIndexOf(47) + 1;
            codebase = codebase.substring(0, tail);
        } else {
            if (!codebase.endsWith("/")) {
                codebase = codebase + "/";
            }
            try {
                URL u = new URL(this.documentURL, codebase);
                codebase = u.toString();
                int tail = codebase.lastIndexOf(47) + 1;
                if (tail != codebase.length() - 1) {
                    codebase = codebase.substring(0, tail);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        params.put("codebase", codebase);
        URL codebaseURL = this.documentURL;
        try {
            codebaseURL = new URL(codebase);
        }
        catch (MalformedURLException malformedURLException) {}
        Integer appKey = new Integer(pLJAppletData);
        EmbeddedAppletFrame frame = new EmbeddedAppletFrame(this.documentURL, codebaseURL, params, this, pLJAppletData);
        this.appletFrames.put(appKey, frame);
        ++totalApplets;
        if (debug > 0) {
            System.err.println("# Total applets " + totalApplets);
        }
        if (debug > 0) {
            String p = "";
            Enumeration e = params.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                p = p + (String)key + "=" + (String)params.get(key) + " ";
            }
            System.err.println("# New applet: " + pLJAppletData + " at " + codebaseURL + " " + p);
        }
        frame.start();
        frame.pack();
        frame.show();
        frame.sendEvent(1);
        frame.sendEvent(2);
    }

    synchronized void startApplet(int pLJAppletData) {
        Integer appKey;
        EmbeddedAppletFrame frame;
        if (debug > 0) {
            System.err.println("# startApplet: appletID=" + pLJAppletData);
        }
        if ((frame = (EmbeddedAppletFrame)this.appletFrames.get(appKey = new Integer(pLJAppletData))) != null) {
            frame.sendEvent(3);
            this.history.start();
            return;
        }
        if (debug > 0) {
            System.err.println("# Warning: startApplet: appletID " + pLJAppletData + " not found!");
        }
    }

    synchronized void stopApplet(int pLJAppletData) {
        Integer appKey;
        EmbeddedAppletFrame frame;
        if (debug > 0) {
            System.err.println("# stopApplet: appletID=" + pLJAppletData);
        }
        if ((frame = (EmbeddedAppletFrame)this.appletFrames.get(appKey = new Integer(pLJAppletData))) != null) {
            frame.sendEvent(4);
            this.history.stop();
            return;
        }
        if (debug > 0) {
            System.err.println("# Warning: stopApplet: appletID " + pLJAppletData + " not found!");
        }
    }

    synchronized void destroyApplet(int pLJAppletData) {
        ThreadGroup group;
        Integer appKey;
        EmbeddedAppletFrame frame;
        if (debug > 0) {
            System.err.println("# destroyApplet: appletID=" + pLJAppletData);
        }
        if ((frame = (EmbeddedAppletFrame)this.appletFrames.get(appKey = new Integer(pLJAppletData))) == null) {
            if (debug > 0) {
                System.err.println("# Warning: destroyApplet: appletID " + pLJAppletData + " not found!");
            }
            return;
        }
        --totalApplets;
        if (debug > 0) {
            System.err.println("# Total applets " + totalApplets);
        }
        this.appletFrames.remove(appKey);
        ThreadGroup threadGroup = group = frame.handler.getThreadGroup();
        synchronized (threadGroup) {
            frame.sendEvent(4);
            frame.sendEvent(5);
            frame.sendEvent(0);
            try {
                group.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
            if (group.activeCount() > 0) {
                group.stop();
                try {
                    group.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                group.destroy();
            }
            catch (Exception exception) {}
            return;
        }
    }

    synchronized void iconifyApplets() {
        if (debug > 0) {
            System.err.println("# iconifyApplets");
        }
        Enumeration frames = this.appletFrames.elements();
        while (frames.hasMoreElements()) {
            EmbeddedAppletFrame frame = (EmbeddedAppletFrame)frames.nextElement();
            frame.sendEvent(4);
            this.history.stop();
            if (debug <= 0) continue;
            System.err.println("# iconifyApplet: stopping appletID " + frame.pData);
        }
    }

    synchronized void uniconifyApplets() {
        if (debug > 0) {
            System.err.println("# uniconifyApplets");
        }
        Enumeration frames = this.appletFrames.elements();
        while (frames.hasMoreElements()) {
            EmbeddedAppletFrame frame = (EmbeddedAppletFrame)frames.nextElement();
            frame.sendEvent(3);
            this.history.start();
            if (debug <= 0) continue;
            System.err.println("# uniconifyApplet: starting appletID " + frame.pData);
        }
    }

    synchronized void destroyApplets() {
        if (debug > 0) {
            System.err.println("# destroyApplets");
        }
        Enumeration e = this.appletFrames.keys();
        while (e.hasMoreElements()) {
            Integer frame = (Integer)e.nextElement();
            this.destroyApplet(frame);
        }
    }

    static void init() {
        console = new Console();
        System.setProperties(new AppletProperties());
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory());
        System.setSecurityManager(new AppletSecurity());
    }

    static void setConsoleState(int newstate) {
        MozillaAppletContext.setConsoleState0(newstate);
    }

    static native void setConsoleState0(int var0);

    static void showConsole() {
        console.show();
    }

    static void hideConsole() {
        console.hide();
    }

    static void trimOneFrame() {
        int numWindows = MozillaWindow.numWindows();
        int maxApplets = Math.max(numWindows * APPLETS_PER_WINDOW, MAX_APPLETS);
        if (totalApplets >= maxApplets) {
            HistoryElement.trim();
        }
    }

    static void trimOneFrameForced() {
        HistoryElement.trim();
    }

    static void setTrimThreshold(int trimThreshold) {
        MAX_APPLETS = trimThreshold;
        APPLETS_PER_WINDOW = trimThreshold;
    }

    static void initApplet(int parentContext, int frameContext, int historyID, int pLJAppletData, String[] argv) {
        MozillaAppletContext acx;
        if (debug > 0) {
            System.err.println("# initApplet: historyID=" + historyID + " appletID=" + pLJAppletData + " parentContext=" + parentContext + " frameContext=" + frameContext);
        }
        MozillaAppletContext.trimOneFrame();
        MozillaWindow win = MozillaWindow.lookupOrCreate(parentContext);
        HistoryElement h = HistoryElement.lookup(historyID);
        if (h == null) {
            MozillaFrame frame = win.lookupFrame(frameContext);
            if (frame == null) {
                frame = new MozillaFrame(win, frameContext);
            }
            acx = new MozillaAppletContext();
            h = new HistoryElement(historyID, frame, acx);
        } else if (h.appletContext == null) {
            acx = new MozillaAppletContext();
            h.resurrect(acx);
        } else {
            acx = h.appletContext;
        }
        if (debug > 0) {
            System.err.println("# initApplet: setting frameMWContext, acx=" + acx + " old frameMWContext=" + acx.frameMWContext + " new frameMWContext=" + frameContext);
        }
        acx.frameMWContext = frameContext;
        acx.history = h;
        acx.initApplet(pLJAppletData, argv);
    }

    static void startApplet(int historyID, int pLJAppletData, int newFrameMWContext) {
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# startApplet: historyID=" + historyID + " appletID=" + pLJAppletData + " newFrameMWContext=" + newFrameMWContext);
        }
        if ((h = HistoryElement.lookup(historyID)) != null) {
            MozillaAppletContext acx = h.appletContext;
            if (acx != null) {
                if (debug > 0) {
                    System.err.println("# startApplet: acx=" + acx + " old frameMWContext=" + acx.frameMWContext);
                }
                acx.frameMWContext = newFrameMWContext;
                h.frame.setMWContext(newFrameMWContext);
                acx.startApplet(pLJAppletData);
                return;
            }
        } else if (debug > 0) {
            System.err.println("# Warning: startApplet: historyID " + historyID + " not found!");
        }
    }

    static void stopApplet(int historyID, int pLJAppletData) {
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# stopApplet: historyID=" + historyID + " appletID=" + pLJAppletData);
        }
        if ((h = HistoryElement.lookup(historyID)) != null) {
            MozillaAppletContext acx = h.appletContext;
            if (acx != null) {
                acx.stopApplet(pLJAppletData);
                if (debug > 0) {
                    System.err.println("# stopApplet: acx=" + acx + " old frameMWContext=" + acx.frameMWContext);
                }
                acx.frameMWContext = 0;
                h.frame.setMWContext(0);
                return;
            }
        } else if (debug > 0) {
            System.err.println("# Warning: stopApplet: historyID " + historyID + " not found!");
        }
    }

    static void destroyApplet(int historyID, int pLJAppletData) {
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# destroyApplet: historyID=" + historyID + " appletID=" + pLJAppletData);
        }
        if ((h = HistoryElement.lookup(historyID)) != null) {
            MozillaAppletContext acx = h.appletContext;
            if (acx != null) {
                acx.destroyApplet(pLJAppletData);
                if (acx.appletFrames.isEmpty()) {
                    if (debug > 0) {
                        System.err.println("# destroy: historyID=" + historyID);
                    }
                    acx.destroy();
                    h.destroy();
                    return;
                }
            } else {
                h.destroy();
            }
        }
    }

    static void iconifyApplets(int historyID) {
        MozillaAppletContext acx;
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# iconifyApplets: historyID=" + historyID);
        }
        if ((h = HistoryElement.lookup(historyID)) != null && (acx = h.appletContext) != null) {
            acx.iconifyApplets();
        }
    }

    static void uniconifyApplets(int historyID) {
        MozillaAppletContext acx;
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# uniconifyApplets: historyID=" + historyID);
        }
        if ((h = HistoryElement.lookup(historyID)) != null && (acx = h.appletContext) != null) {
            acx.uniconifyApplets();
        }
    }

    static void destroyApplets(int historyID) {
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# destroyApplets: historyID=" + historyID);
        }
        if ((h = HistoryElement.lookup(historyID)) != null) {
            MozillaAppletContext acx = h.appletContext;
            acx.destroyApplets();
            if (debug > 0) {
                System.err.println("# destroyApplets: destroying historyID " + historyID);
            }
            acx.destroy();
        }
    }

    static Object reflectApplet(int historyID, int pLJAppletData) {
        HistoryElement h;
        if (debug > 0) {
            System.err.println("# reflectApplet: historyID=" + historyID + " appletID=" + pLJAppletData);
        }
        if ((h = HistoryElement.lookup(historyID)) != null) {
            MozillaAppletContext acx = h.appletContext;
            if (acx != null) {
                Integer appKey = new Integer(pLJAppletData);
                EmbeddedAppletFrame frame = (EmbeddedAppletFrame)acx.appletFrames.get(appKey);
                if (frame != null) {
                    if (frame.applet == null && debug > 0) {
                        System.err.println("# Warning: reflectApplet: applet " + pLJAppletData + " not loaded yet");
                    }
                    return frame.applet;
                }
                System.err.println("# Warning: reflectApplet: appletData " + pLJAppletData + " not found!");
            } else if (debug > 0) {
                System.err.println("# Warning: reflectApplet: null AppletContext");
            }
        } else if (debug > 0) {
            System.err.println("# Warning: reflectApplet: historyID " + historyID + " not found!");
        }
        return null;
    }

    static void destroyAll() {
        if (debug > 0) {
            System.err.println("# destroyAll");
        }
        HistoryElement.destroyAll();
    }

    static {
        MAX_APPLETS = 10;
        APPLETS_PER_WINDOW = 5;
    }
}

