/*
 * Decompiled with CFR 0.152.
 */
package netscape.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.applet.AppletSecurity;
import netscape.net.URLInputStream;
import netscape.net.URLOutputStream;

public class URLConnection
extends java.net.URLConnection {
    static final String EOL = "\r\n";
    int pStreamData;
    URLInputStream currentInputStream;
    URLOutputStream currentOutputStream;
    String postHeaders;
    Hashtable properties;
    static Hashtable defaultProperties;

    protected URLConnection(URL url) {
        super(url);
        String hostAddress = null;
        try {
            hostAddress = url.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {}
        this.pCreate(url.toExternalForm(), hostAddress);
    }

    private native void pCreate(String var1, String var2);

    protected native void finalize();

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null && security instanceof AppletSecurity) {
            ((AppletSecurity)security).checkURLConnect(this.url);
        }
        this.connected = true;
        StringBuffer propString = new StringBuffer();
        if (this.postHeaders != null) {
            propString.append(this.postHeaders);
        }
        boolean contentTypeSet = false;
        Hashtable props = this.properties;
        if (props == null) {
            props = defaultProperties;
        }
        if (props != null) {
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.equalsIgnoreCase("Content-length")) continue;
                if (key.equalsIgnoreCase("Content-type")) {
                    contentTypeSet = true;
                }
                String value = (String)props.get(key);
                propString.append(key);
                propString.append(":");
                propString.append(value);
                propString.append(EOL);
            }
        }
        if (!contentTypeSet) {
            propString.append("Content-type: multipart/form-data");
            propString.append(EOL);
        }
        this.postHeaders = propString.toString();
        this.properties = null;
        if (this.currentOutputStream != null) {
            this.currentOutputStream.close();
        }
        URLInputStream in = (URLInputStream)this.getInputStream();
        in.open();
    }

    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return -1;
        }
        return this.getContentLength0();
    }

    public native int getContentLength0();

    public String getContentType() {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.getContentType0();
    }

    public native String getContentType0();

    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.getHeaderField0(name);
    }

    public native String getHeaderField0(String var1);

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new UnknownServiceException("protocol doesn't support input");
        }
        if (this.currentInputStream == null) {
            this.currentInputStream = new URLInputStream(this);
        }
        return this.currentInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (!this.doOutput) {
            throw new UnknownServiceException("protocol doesn't support output");
        }
        if (this.currentOutputStream == null) {
            this.currentOutputStream = new URLOutputStream(this);
            this.currentOutputStream.open();
        }
        return this.currentOutputStream;
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (value != null) {
            this.properties.put(key, value);
            return;
        }
        this.properties.remove(key);
    }

    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(key);
    }

    public static void setDefaultRequestProperty(String key, String value) {
        if (defaultProperties == null) {
            defaultProperties = new Hashtable();
        }
        if (value != null) {
            defaultProperties.put(key, value);
            return;
        }
        defaultProperties.remove(key);
    }

    public static String getDefaultRequestProperty(String key) {
        if (defaultProperties == null) {
            return null;
        }
        return (String)defaultProperties.get(key);
    }

    native void close() throws IOException;
}

