/*
 * Decompiled with CFR 0.152.
 */
package br.com.dm.vital.to;

import br.com.dmservice.wavitals.IDevice;
import br.com.dmservice.wavitals.IReading;
import br.com.dmservice.wavitals.IReadings;
import br.com.dmservice.wavitals.NIBPDisplayUnits;
import br.com.dmservice.wavitals.TempDisplayUnits;
import ezjcom.JComException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class VitalsValues {
    private String data;
    private String hora;
    private String leitura;
    private String paSis;
    private String paDia;
    private String temperatura;
    private String spo2;
    private String puls;
    private IDevice idv;
    private IReadings ireadings;
    private IReading ireading;
    private String hRate;

    public VitalsValues(IDevice idv) throws JComException, Exception {
        this.idv = idv;
        this.initData();
        this.ireads();
        this.iread();
    }

    private void setData(String data) {
        this.data = data;
    }

    private void setHora(String hora) {
        this.hora = hora;
    }

    public String getData() {
        return this.data;
    }

    public String getHora() {
        return this.hora;
    }

    private void setLeitura(String leitura) {
        this.leitura = leitura;
    }

    public String getLeitura() {
        return this.leitura;
    }

    public String getPaDia() {
        return this.paDia;
    }

    private void setPaDia(String paDia) {
        this.paDia = paDia;
    }

    public String getPaSis() {
        return this.paSis;
    }

    private void setPaSis(String paSis) {
        this.paSis = paSis;
    }

    public String getPuls() {
        return this.puls;
    }

    private void setPuls(String puls) {
        this.puls = puls;
    }

    public String getSpo2() {
        return this.spo2;
    }

    private void setSpo2(String spo2) {
        this.spo2 = spo2;
    }

    public String getTemperatura() {
        return this.temperatura;
    }

    private void setTemperatura(String temperatura) {
        this.temperatura = temperatura;
    }

    public String gethRate() {
        return this.hRate;
    }

    private void sethRate(String hRate) {
        this.hRate = hRate;
    }

    private void initData() {
        Calendar cal = Calendar.getInstance();
        Date current = cal.getTime();
        SimpleDateFormat ft = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat fth = new SimpleDateFormat("hh:mm a");
        this.setData(ft.format(current) == null || ft.format(current).isEmpty() ? "" : ft.format(current));
        this.setHora(fth.format(current) == null || fth.format(current).isEmpty() ? "" : fth.format(current));
    }

    private void ireads() throws JComException {
        this.ireadings = this.idv.GetReadings();
        this.setLeitura(String.valueOf(this.ireadings.getCount() + 1));
    }

    private void iread() throws Exception {
        try {
            this.ireading = this.idv.GetCurrentReading();
            int sisValue = Math.round(this.ireading.getSystolic(NIBPDisplayUnits.NIBP_MMHG));
            this.setPaSis(String.valueOf(sisValue));
            int diaValue = Math.round(this.ireading.getDiastolic(NIBPDisplayUnits.NIBP_MMHG));
            this.setPaDia(String.valueOf(diaValue));
            float temperatura = this.ireading.getTemperature(TempDisplayUnits.DEG_C);
            temperatura = temperatura < 0.0f ? 0.0f : temperatura;
            DecimalFormat df = new DecimalFormat("###.0");
            float tempValue = (float)Math.round(temperatura) * 10.0f / 10.0f;
            if (tempValue <= 26.7f) {
                tempValue = 0.0f;
            }
            this.setTemperatura(String.valueOf(df.format(temperatura)).replace(',', '.'));
            this.setSpo2(String.valueOf(this.ireading.getO2Sat()).equals("0") ? "- -" : String.valueOf(this.ireading.getO2Sat()));
            this.sethRate(this.ireading.getHR() == 0 ? "" : String.valueOf(this.ireading.getHR()));
            this.setPuls(String.valueOf(this.ireading.getPulse()).equals("0") ? this.gethRate() : String.valueOf(this.ireading.getPulse()));
        }
        catch (Exception ex) {
            throw new Exception("iread...");
        }
    }
}

