<?php

require_once( APPPATH.'libraries/phpThumb/phpthumb.class.php');

class PhpThumbWrapper {

    public function __construct() {
        ;
    }

    /**
     * Configuración obliga a que todos los archivos de miniatura sean del tipo PNG
     * así asegura compatibilidad con archivo de PDF
     */
    public function generarMiniatura( $ruta, $nombre_archivo, $ancho = 100, $alto = 100 ) {

        $punto      = strrpos( $nombre_archivo, '.' );
        $nombre     = substr( $nombre_archivo, 0, $punto );
        $extension  = substr( $nombre_archivo, $punto + 1, strlen( $nombre_archivo ) );

        $phpThumb = new phpThumb(); 
       log_message("error", "ruta: ". $ruta.$nombre_archivo); 
       $phpThumb->setSourceFilename( $ruta.$nombre_archivo );
        $phpThumb->setParameter( 'w', $ancho );
        // $phpThumb->setParameter( 'h', $alto );
        

        switch( strtolower( (string) $extension ) ) {

            case "bmp" : $phpThumb->setParameter( 'f', 'png' ); break;
            case "jpeg":
            case "jpg" : $phpThumb->setParameter( 'f', 'jpg' ); break;
            case "png" : $phpThumb->setParameter( 'f', 'png' ); break;
            default    : $phpThumb->setParameter( 'f', 'png' ); break;
        }
//
        if( $phpThumb->GenerateThumbnail() ){
            echo "<pre>";
            echo "llega a libreria";
            print_r($phpThumb);
            print_r($phpThumb->RenderToFile( $ruta.DIRECTORY_SEPARATOR.'thumb_'.$nombre_archivo ));
            echo "</pre>";
            die();
            return $phpThumb->RenderToFile( $ruta.DIRECTORY_SEPARATOR.'thumb_'.$nombre_archivo );
        }
        return false;
    }
}
