<?php

include( 'fpdf/fpdf.php' );

class Reporte_FPDF extends FPDF {

    private $CI = NULL;
    private $imagen_cliente = NULL;

    public function Reporte_FPDF( $orientation='P', $unit='mm', $size='Letter' ) {

        parent::FPDF( $orientation, $unit, $size );

        /**
        * Permite carga de archivos de imagenes desde la base de datos.
        * Obtenido desde: http://www.fpdf.org/en/script/script45.php
        */
        @stream_wrapper_register('var', 'VariableStream');

        // Tipo de fuente por omisión
        $this->SetFont('Arial', '',10);
        $this->AddPage();
    }

    function Header() {

        $y = $this->GetY();
        $this->CI = &get_instance( );
        switch( (int)$this->CI->session->userdata('SIT_ID') ) {

            // 2: Logo Chile
            case  2 : $this->Image( 'images/pdf/top_cl.jpg', null, null, 0, 20 ); break;

            // 21: Logo Brasil
            case 21 : $this->Image( 'images/pdf/top_br.jpg', null, null, 0, 20 ); break;

            // 22: Logo Colombia
            case 22 : $this->Image( 'images/pdf/top_co.jpg', null, null, 0, 20 ); break;

            // 25: Logo Peru, resto logo standard
            case 25 : $this->Image( 'images/pdf/top_pe.jpg', null, null, 0, 20 ); break;

            // Resto logo standard
            default : $this->Image( 'images/pdf/top.jpg', null, null, 0, 20 ); break;
        }
//        $x = $this->GetX(); //<--- no funciona
        $x = 175;

        if( !empty( $this->imagen_cliente ) ) {
            $this->MemImage( base64_decode( $this->imagen_cliente ), $x, $y, 30, 20 );
        }
    }

    function Footer() {

        $this->SetFont('Arial', '', 10);

        $this->SetY(-15);

        $texto = html_entity_decode( $this->CI->lang->line( 'pdf_fecha_y_hora_impresion_reporte' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) . ': ' . date( 'd-m-Y' ) . ' ' . date( 'H:i' );
        $texto.= '                                               ';
        $texto.= html_entity_decode( $this->CI->lang->line( 'pdf_numero_pagina' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) . ' '. $this->PageNo().' de (total): {nb}';
        $this->Ln();
        $this->Cell( 0,0, $texto, 0,0, 'C');
    }

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        //Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        //Display the GD image associated to $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }

    /**
     *
     * @param type $data
     */
    public function datos_generales( $data ) {

        // Información general
        $this->SetFont('Arial', 'B', 8);
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line('reporte_title'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'C' );
        $this->SetFont('Arial', '', 6);

        // Primera fila
//        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('cliente') ) );
//        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
//        $this->Cell( 40, 6, utf8_decode( $data['REP_CLIENTES'] ) );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_tc_con_desde'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
        $this->Cell( 5, 6, ': ', 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_FECHA_CONTESTADA_DESDE'] ), 0, 1 );

        // Segunda fila
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_tc_env_desde'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_FECHA_ENVIADA_DESDE'] ) );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_hasta'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_FECHA_ENVIADA_HASTA'] ) , 0, 1);

        // Tercera fila
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_tc_total') ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_TOTAL'] ), 0, 1 );

        // Cuarta fila
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_estado') ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_ESTADO'] ) );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_especialidades'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_ESPECIALIDAD'] ), 0, 1, 'L' );

        // Quinta fila
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_med_primera_resp'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_ESTADO'] ) );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line('reporte_med_final_resp'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
        $this->Cell( 5, 6, ': ' , 0, 0, 'C' );
        $this->Cell( 40, 6, utf8_decode( $data['REP_ESPECIALISTA_CONTESTADA'] ), 0, 1, 'L' );
    }

    /**
     *
     */
    public function datos_tabulados( $data ) {

        $i = 1;
        foreach( $data as $cliente => $tcs ) {

            $this->SetFont('Arial', 'B', 10);
            $this->Cell( 20, 6, html_entity_decode( $this->CI->lang->line('cliente'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ). ': ', 0, 0, 'R' );
            $this->SetFont('Arial', '', 10);
            $this->Cell( 50, 6, utf8_decode( $cliente ) );
            $this->ln();

            // Cabezera de la tabla
            $this->SetFont('Arial', 'B',5);
            $this->Cell(  5, 4, html_entity_decode( $this->CI->lang->line( 'tc_id' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 15, 4, html_entity_decode( $this->CI->lang->line( 'tc_id_paciente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 35, 4, html_entity_decode( $this->CI->lang->line( 'tc_nom_ape' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 25, 4, html_entity_decode( $this->CI->lang->line( 'tc_establ' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 20, 4, html_entity_decode( $this->CI->lang->line( 'tc_time_envio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 20, 4, html_entity_decode( $this->CI->lang->line( 'tc_especialidad_busqueda' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 20, 4, html_entity_decode( $this->CI->lang->line( 'tc_time_exsol' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 20, 4, html_entity_decode( $this->CI->lang->line( 'tc_time_contestada' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
            $this->Cell( 35, 4, html_entity_decode( $this->CI->lang->line( 'tc_especialista_contesto' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

            $this->SetFont('Arial', '',5);
            foreach( $tcs as $rd ) {

                // Cabezera de la tabla
                $this->SetFont('Arial', '',5);
                $this->Cell( 5, 4, utf8_decode( $rd['TEL_ID'] ), 1, 0, 'C' );
                $this->Cell( 15, 4, utf8_decode( $rd['PAC_IDT_VALOR'] ), 1, 0, 'C' );
                $this->Cell( 35, 4, utf8_decode( $rd['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $rd['TEL_PAC_PRIMER_APELLIDO'] . ( !empty( $rd['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' '. $rd['TEL_PAC_SEGUNDO_APELLIDO'] : '' ) ), 1, 0, 'C' );
                $this->Cell( 25, 4, utf8_decode( $rd['ETB_NOMBRE'] ), 1, 0, 'C' );
                $this->Cell( 20, 4, utf8_decode( isset( $rd['TEL_FECHA_HORA_ENVIO'] ) && !empty( $rd['TEL_FECHA_HORA_ENVIO'] ) ? $this->CI->util->fecha_orden2( $rd['TEL_FECHA_HORA_ENVIO'] ) : '' ), 1, 0, 'C' );
                $this->Cell( 20, 4, utf8_decode( $rd['ESP_NOMBRE'] ), 1, 0, 'C' );
                $this->Cell( 20, 4, utf8_decode( isset( $rd['TEL_FECHA_HORA_SOLEXA'] ) && !empty( $rd['TEL_FECHA_HORA_SOLEXA'] ) ? $this->CI->util->fecha_orden2( $rd['TEL_FECHA_HORA_SOLEXA'] ) : '' ), 1, 0, 'C' );
                $this->Cell( 20, 4, utf8_decode( isset( $rd['TEL_FECHA_HORA_RESPUESTA'] ) && !empty( $rd['TEL_FECHA_HORA_RESPUESTA'] ) ? $this->CI->util->fecha_orden2( $rd['TEL_FECHA_HORA_RESPUESTA'] ) : '' ), 1, 0, 'C' );
                $this->Cell( 35, 4, utf8_decode( isset( $rd['usu_especialista'] ) && !empty( $rd['usu_especialista'] ) ? $rd['usu_especialista'] : '' ), 1, 1, 'C' );
            }

            // Evita agregar una página sobrante en blanco al final
            if( $i < count( $data ) )
                $this->AddPage();
            $i++;
        }

    }

    public function establecer_imagen_cliente( $datos ) {
        $this->imagen_cliente = trim( $datos[ 'usuario_envia' ]['CLI_IMAGEN_INSTITUCIONAL'] );
    }

}

/**
 * Permite carga de archivos de imagenes desde la base de datos.
 * Obtenido desde: http://www.fpdf.org/en/script/script45.php
 */
class VariableStream
{
    var $varname;
    var $position;

    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }

    function stream_stat()
    {
        return array();
    }
}