<?php

require( 'fpdf/fpdf.php' );

class TC_FPDF extends FPDF {

    private $CI = NULL;
    private $imagen_cliente = NULL;
    private $htmlpurifier = NULL;

    public function __construct( $orientation='P', $unit='mm', $size='Letter' ) {

        parent::FPDF( $orientation, $unit, $size );

        /**
        * Permite carga de archivos de imagenes desde la base de datos.
        * Obtenido desde: http://www.fpdf.org/en/script/script45.php
        */
        @stream_wrapper_register('var', 'VariableStream');

        // Tipo de fuente por omisión
        $this->SetFont('Arial', '',10);

        $this->CI = &get_instance( );
        $this->AliasNbPages();

        $this->CI->load->library( 'HtmlPurifierWrapper' );
        $this->htmlpurifier = $this->CI->htmlpurifierwrapper->HtmlPurifierFactory();

    }

    function Header() {

        $y = $this->GetY();

        switch( (int)$this->CI->session->userdata('SIT_ID') ) {

            // 2: Logo Chile
            case  2 : $this->Image( 'images/pdf/top_cl.jpg', null, null, 0, 20 ); break;

            // 21: Logo Brasil
            case 21 : $this->Image( 'images/pdf/top_br.jpg', null, null, 0, 20 ); break;

            // 22: Logo Colombia
            case 22 : $this->Image( 'images/pdf/top_co.jpg', null, null, 0, 20 ); break;

            // 25: Logo Peru, resto logo standard
            case 25 : $this->Image( 'images/pdf/top_pe.jpg', null, null, 0, 20 ); break;

            // Resto logo standard
            default : $this->Image( 'images/pdf/top.jpg', null, null, 0, 20 ); break;
        }

        $x = 175;

        if( !empty( $this->imagen_cliente ) && file_exists('images/clientes/'.$this->imagen_cliente) ) {
            $this->Image( 'images/clientes/'.$this->imagen_cliente, $x, $y, 30, 20 );
        }
    }

    function Footer() {

        $this->SetFont('Arial', '', 10);

        $this->SetY(-15);

        $texto = html_entity_decode( $this->CI->lang->line( 'pdf_fecha_y_hora_impresion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) . ': ' . date( 'd-m-Y' ) . ' ' . date( 'H:i' );
        $texto.= '                                               ';
        $texto.= html_entity_decode( $this->CI->lang->line( 'pdf_numero_pagina' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) . ' '. $this->PageNo().' de (total): {nb}';
        $this->Ln();
        $this->Cell( 0,0, $texto, 0,0, 'C');
    }

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link=''){
        //Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link=''){
        //Display the GD image associated to $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }

    public function establecer_imagen_cliente( $datos ){
        $this->imagen_cliente = (isset($datos[ 'tc' ]['CLI_IMAGEN_INSTITUCIONAL']) && $datos[ 'tc' ]['CLI_IMAGEN_INSTITUCIONAL']) ? trim( $datos[ 'tc' ]['CLI_IMAGEN_INSTITUCIONAL'] ) : "";
    }

    /**
     * Datos de la solicitud de la Teleconsulta
     * <table>
     *  <tr>
     *      <td>Id</td>
     *      <td>Estado de la TC</td>
     *  </tr>
     *  <tr>
     *      <td>Médico solicitante</td>
     *      <td>Fecha y hora de envío</td>
     *  </tr>
     *  <tr>
     *      <td>Nº registro</td>
     *      <td>Nivel establec. de origen</td>
     *  </tr>
     *  <tr>
     *      <td>Firma</td>
     *      <td>Especialidad de destino</td>
     *  </tr>
     *  <tr>
     *      <td>&nbsp;</td>
     *      <td>Prioridad en origen</td>
     *  </tr>
     * </table>
     *
     * @param array $datos Datos de la TC que contenga la información requerida
     *              en el método
     */
    public function establecer_datos_solicitud( $datos ) {

        // Datos de la solicitud
        $this->SetFont('Arial', 'B', 10);
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_datos_de_la_solicitud' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1 );

        // Primera fila
        $this->SetFont('Arial', '',10);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'idteleconsulta' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos[ 'tc' ][ 'TEL_ID' ] ), 0, 0, 'L' );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'estado_teleconsulta' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'estado_' . $datos[ 'estado' ] ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

        // Segunda fila:
        // PERU: No muestra información del generalista (nombre, firma). Además se mueve información de especialidad
        // y prioridad al lugar que la info del generalista ocupa
        if( $this->CI->session->userdata('SIT_ID') == 25 ) {

            $y = $this->GetY();     // Lógica para mantener posición en la misma línea: FPDF aunque tenga el parametro correcto realiza salto

            // 2da fila
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'especialidad_destino' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'ESP_NOMBRE' ] ), 0, 1, 'L' );

            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_origen' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_' . $datos['estado_enviada'][ 'PRI_ID' ] ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        } else {
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'enviada_por' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) .': ', 0, 0, 'R' );
            $y = $this->GetY();     // Lógica para mantener posición en la misma línea: FPDF aunque tenga el parametro correcto realiza salto
            $this->MultiCell( 50, 6, utf8_decode( $datos['usuario_envia'][ 'USU_NOMBRE' ] ), 0, 'L', false, 0 );
        }

        $this->SetY( $y );
        $this->SetX( $this->lMargin + 100 );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_envio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, utf8_decode( $datos['estado_enviada'][ 'TEP_FECHA_HORA' ] ), 0, 1, 'L' );

        // Tercera fila
        $this->Cell( 150, 6, html_entity_decode( $this->CI->lang->line( 'nivel_establ_origen' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, $datos['etb'][ 'ETB_NIVEL' ], 0, 1, 'L' );

        // Cuarta fila: Dibujado en columnas para poner firma después de nº de registro
        //              Así, si establecimiento (2da columna) genera 2 lineas firma y
        //              nº de registro no se separan
        // 1era columna
        // No debe mostrar en Site PERU, se mueve información de especialidad y prioridad
        if( $this->CI->session->userdata('SIT_ID') == 25 ) {

            $establ_x = 110;
            $establ_y = $this->GetY();
        } else {

            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'pdf_nro_registro' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 50, 6, utf8_decode( $datos['usuario_envia'][ 'USU_NRO_REGISTRO' ] ), 0, 0, 'L' );
            $establ_x = $this->GetX();
            $establ_y = $this->GetY();

            $this->ln( );

            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ). ': ', 0, 0, 'R' );
            $x = $this->GetX();
            $y = $this->GetY();
            if( !empty( $datos['usuario_envia'][ 'USU_FIRMA' ] ) ) {
                $this->MemImage( base64_decode( $datos['usuario_envia'][ 'USU_FIRMA' ] ), $x, $y, 50, 17 );
            } else
                $this->Cell( 50, 6, '', 0, 1, 'L' );
        }

        // 2da columna
        $this->SetY( $establ_y );
        $this->SetX( $establ_x );
        $this->Cell( 50 , 6, html_entity_decode( $this->CI->lang->line( 'establecimiento_origen' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->MultiCell( 50, 6, utf8_decode( $datos['etb'][ 'ETB_NOMBRE' ] ), 0, 'L', false, 0 );

        // PERU: Las siguientes filas se mueven a la parte superior, donde se eliminan los datos del médico generalista (nombre, firma)
        if( $this->CI->session->userdata('SIT_ID') != 25 ) {

            // Quinta fila
            $this->SetX( $establ_x );
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'especialidad_destino' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'ESP_NOMBRE' ] ), 0, 1, 'L' );

            $this->SetX( $establ_x );
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_origen' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_' . $datos['estado_enviada'][ 'PRI_ID' ] ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        }
    }

    /**
     * Datos del paciente
     * <table>
     *  <tr>
     *      <td>Nombre</td>
     *      <td>Fecha de naciemiento</td>
     *  </tr>
     *  <tr>
     *      <td>Rut BR</td>
     *      <td>Edad</td>
     *  </tr>
     *  <tr>
     *      <td>Procedencia</td>
     *      <td>Sexo</td>
     *  </tr>
     *  <tr>
     *      <td>Ocupación</td>
     *      <td>Afiliación</td>
     *  </tr>
     * </table>
     *
     * @param array $datos Datos del paciente que contenga la información requerida
     *              en el método
     */
  public function establecer_datos_paciente( $datos ) {

        // Datos del paciente
        $this->Ln();
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_datos_del_paciente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1 );

        $y = $this->GetY();

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'nombre' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );

        $y2 = $this->GetY();
        $nombre = $datos['tc'][ 'TEL_PAC_PRIMER_NOMBRE' ] . ' ' . $datos['tc'][ 'TEL_PAC_SEGUNDO_NOMBRE' ] . ' ' .
                  $datos['tc'][ 'TEL_PAC_PRIMER_APELLIDO' ] . ' ' . $datos['tc'][ 'TEL_PAC_SEGUNDO_APELLIDO' ];
        $this->MultiCell( 50, 6, utf8_decode( $nombre ), 0, 'L', false, 0 );
        $y = $this->GetY();

        $x = $this->lMargin + 100;
        $this->SetY($y2);
        $this->SetX($x);

        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_fecha_nacimiento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, $this->CI->util->fecha_orden( $datos['tc'][ 'TEL_PAC_NACIMIENTO' ] ), 0, 1, 'L' );
        $y2 = $this->GetY();

        // Segunda fila
        $this->SetY($y);
        $this->Cell( 50, 6, utf8_decode( $datos['identificadores'][ 0 ][ 'TCI_NOMBRE' ] ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['identificadores'][ 0 ][ 'TCI_VALOR' ] ), 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_edad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_EDAD' ] ) . ' ' . html_entity_decode( $this->CI->lang->line( 'annos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $y2 = $this->GetY( );

        // Tercera fila
        $this->SetY($y);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_procedencia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_PROCEDENCIA' ] ), 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_sexo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );

        switch( $datos['tc'][ 'TEL_PAC_SEXO' ] ) {
            case 'M' : { $sexo = $this->CI->lang->line( 'p_masculino' ); } break;
            case 'F' : { $sexo = $this->CI->lang->line( 'p_femenino' ); } break;
        }
        $this->Cell( 40, 6, $sexo, 0, 1, 'L' );
        $y2 = $this->GetY( );

        // Cuarta fila
        $this->SetY($y);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'ocupacion_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_OCUPACION' ] ), 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'afiliacion_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_AFI_NOMBRE' ] ), 0, 1, 'L' );
        $y2 = $this->GetY( );
    
    //JV 25-09-2015
    // Quinta fila
        $this->SetY($y);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line('pac_departamento'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( !empty($datos['tc'][ 'TEL_PAC_DPTO_NOMBRE' ] ) ? $datos['tc'][ 'TEL_PAC_DPTO_NOMBRE' ] : ' - ' ) , 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'pac_municipio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6,  utf8_decode( !empty($datos['tc'][ 'TEL_PAC_MUN_NOMBRE' ] ) ? $datos['tc'][ 'TEL_PAC_MUN_NOMBRE' ] : ' - ' ), 0, 1, 'L' );
        $y2 = $this->GetY( );
    //JV 25-09-2015 FIN

        // Sexta fila
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( !empty( $datos['tc'][ 'TEL_PAC_TELEFONO' ] ) ? $datos['tc'][ 'TEL_PAC_TELEFONO' ] : ' - ' ), 0, 1, 'L' );
        $y = $this->GetY();


        // Septima fila
        // BRASIL: Debe mostrar nombre de la madre
        if( $this->CI->session->userdata('SIT_ID') == 21 ) {
            $this->SetFont( 'Arial', '', 10 );
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_nombre_madre_completo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );

            $y2 = $this->GetY();
            $nombre = $datos['tc'][ 'TEL_PAC_NOMBRE_MADRE' ] . ' ' . $datos['tc'][ 'TEL_PAC_APELLIDO_MADRE' ];
            $this->MultiCell( 50, 6, utf8_decode( $nombre ), 0, 'L', false, 0 );
            $this->SetY($y2);
        } else
            // PERU: Mueve campo "email" a la primera columna, para ahorrar espacio
            if( $this->CI->session->userdata('SIT_ID') == 25 ) {

            $this->SetY($y);
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_email' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 40, 6, utf8_decode( !empty( $datos['tc'][ 'TEL_PAC_EMAIL' ] ) ? $datos['tc'][ 'TEL_PAC_EMAIL' ] : ' - ' ), 0, 1, 'L' );
        }

        // PERU: No muestra campo "email", es movido a la primera columna para ahorrar espacio
        if( $this->CI->session->userdata('SIT_ID') != 25 ) {
            $this->SetX($x);
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'p_email' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Cell( 40, 6, utf8_decode( !empty( $datos['tc'][ 'TEL_PAC_EMAIL' ] ) ? $datos['tc'][ 'TEL_PAC_EMAIL' ] : ' - ' ), 0, 1, 'L' );
        }



        $this->SetY($y2+10);

        if( $this->CI->session->userdata('SIT_ID') == 22 ) {
            $this->Ln();
            $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'entidad_administradora' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->MultiCell( 120, 6, utf8_decode( !empty($datos['tc'][ 'TEL_PAC_ENTADM_NOMBRE' ] ) ? $datos['tc'][ 'TEL_PAC_ENTADM_NOMBRE' ] : ' - ' ), 0, 'L', false, 0 );//JV 25-09-2015
        }

        $this->SetY($y2+35);

    }

    /**
     *
     */
    public function establecer_datos_solicitud_info_examen( $datos ) {

        $this->AddPage();
        $this->establecer_datos_solicitud( $datos );
        $this->establecer_datos_paciente( $datos );

        // Evaluación y respuesta del especialista
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_solicitudes_adicionales' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exsol_por' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exsol'][ 'USU_NOMBRE' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_exsol' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['estado_exsol'][ 'TEP_FECHA_HORA' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exsol_por_nro_registro' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exsol'][ 'USU_NRO_REGISTRO' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_exsol' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, $this->CI->lang->line( 'prioridad_' . $datos['estado_exsol'][ 'PRI_ID' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_exsol'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_exsol'][ 'USU_FIRMA' ] ), $x, $y, 50, 17 );
            $this->Ln( ); $this->Ln( );
        } else
            $this->Cell( 60, 6, '', 0, 0, 'L' );

        $this->Ln( );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'solicitud_adicional' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );

        if( !empty( $datos['tc']['TEL_SOL_ADICIONALES'] ) )
            $archivos = $datos['tc']['TEL_SOL_ADICIONALES'];
        else
            $archivos = html_entity_decode( $this->CI->lang->line( 'attach_vacio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' );
        $this->MultiCell( 0, 6, utf8_decode( $archivos ) );
    }

    /**
     *
     */
    public function establecer_datos_solicitud_respuesta( $datos ) {

        $this->AddPage();

        // Respuesta información adicional
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_resultados_examenes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'resultados' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_SOL_ADICIONALES_RESP' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exreal_por' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exreal'][ 'USU_NOMBRE' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exreal_por_nro_registro' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exreal'][ 'USU_NRO_REGISTRO' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_exreal'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_exreal'][ 'USU_FIRMA' ] ), $x, $y, 50, 17 );
            $this->Ln( ); $this->Ln( );
        } else
            $this->Cell( 60, 6, '', 0, 0, 'L' );

        $this->Ln( );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_exreal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['estado_exreal'][ 'TEP_FECHA_HORA' ] ), 0, 1, 'L' );
    }

    public function establecer_datos_respuesta_especialista( $datos ) {

        $this->AddPage();

        // PERU: Omite cabezeras "datos de la solicitud" y "datos del paciente" al generar hoja de respuesta
        if( $this->CI->session->userdata('SIT_ID') != 25 ) {

            $this->establecer_datos_solicitud( $datos );
            $this->establecer_datos_paciente( $datos );
        }

        // Evaluación y respuesta del especialista
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_evaluacion_respuesta' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'contestada_por' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['usuario_contesta'][ 'USU_NOMBRE' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_contestada' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['estado_contestada'][ 'TEP_FECHA_HORA'] ), 0, 1, 'L' );

        $this->Cell( 60, 6, 'Modalidad Respuesta: ', 0, 0, 'R' );
        $this->Cell( 30, 6, ((isset($datos['tc'][ 'TEL_MODALIDAD_RESPUESTA' ])) ? strtoupper($datos['tc'][ 'TEL_MODALIDAD_RESPUESTA' ]) : ""), 0, 1, 'L' );
    
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'contestada_por_nro_registro' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_contesta'][ 'USU_NRO_REGISTRO'] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_contestada_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_' . $datos['estado_contestada'][ 'PRI_ID' ] ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'l' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_contesta'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_contesta'][ 'USU_FIRMA' ] ), $x, $y, 50, 17 );
            $this->Ln( ); $this->Ln( );
        } else
            $this->Cell( 60, 6, '', 0, 0, 'L' );

        if( ( $this->CI->session->userdata('SIT_ID') == 25 || $this->CI->session->userdata('SIT_ID') == 2 ) && $datos['especialidad']['ESP_ARCHIVO_FORMULARIO'] == 'form_oftalmologia' ) {

            // PDF vacío si no tiene info de respuesta
            if( !isset( $datos['form_oftalmologia'] ) && !empty( $datos['form_oftalmologia'] ) &&
                !isset( $datos['form_oftalmologia']['respondida'] ) && !empty( $datos['form_oftalmologia']['respondida'] ) ) {

                $this->Cell(100, 6, 'Sin datos de respuesta', 0, 0, 'C' );
            } else {

                // Títulos: Izquierdo | Derecho
                $this->Ln( ); $this->Ln( );
                $this->SetFont( 'Arial', 'B', 12 );
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_izquierdo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_derecho' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );

                $this->SetFont( 'Arial', 'U', 10 );
                $this->Ln( );

                // Izquierdo: Nervio optico
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_nervio_optico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

                // Derecho: Nervio optico
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_nervio_optico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

                $this->SetFont( 'Arial', '', 10 );
                // Izquierdo: Relación copa/disco
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_relacion_copa_disco' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_relacion_copa_disco'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_relacion_copa_disco'] ) ) {
                    $texto = $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_relacion_copa_disco'];
                    if( $texto == 'indefinido' ) $texto = $this->CI->lang->line('oftalmologia_indefinido');
                } else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Relación copa/disco
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_relacion_copa_disco' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_relacion_copa_disco'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_relacion_copa_disco'] ) ) {
                    $texto = $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_relacion_copa_disco'];
                    if( $texto == 'indefinido' ) $texto = $this->CI->lang->line('oftalmologia_indefinido');
                } else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Izquierdo: Color
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_color' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_color'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_color'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_color_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_color'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Color
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_color' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_color'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_color'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_color_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_color'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Izquierdo: Bordes
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_bordes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_bordes'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_bordes'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_borde_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_bordes'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, html_entity_decode( $texto, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

                // Derecho: Bordes
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_bordes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_bordes'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_bordes'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_borde_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_bordes'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, html_entity_decode( $texto, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );


                $this->SetFont( 'Arial', 'U', 10 );
                // Izquierdo: Mácula
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_macula' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

                // Derecho: Mácula
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_macula' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

                $this->SetFont( 'Arial', '', 10 );
                // Izquierdo: Zona macular
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_zona_macular' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_macula'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_macula'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_zona_macular_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_macula'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, utf8_decode($texto), 0, 0, 'L' );

                // Derecho: Zona macular
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_zona_macular' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_macula'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_macula'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_zona_macular_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_macula'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, utf8_decode($texto), 0, 1, 'L' );

                $this->SetFont( 'Arial', 'U', 10 );
                // Izquierdo: Arquitectura vascular
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_arquitectura_vascular' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

                // Derecho: Arquitectura vascular
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_arquitectura_vascular' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

                $this->SetFont( 'Arial', '', 10 );
                // Izquierdo: Relación arteria/vena
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_relacion_arteria_vena' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_relacion_arteria_vena'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_relacion_arteria_vena'] ) )
                    $texto = $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_relacion_arteria_vena'];
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Relación arteria/vena
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_relacion_arteria_vena' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_relacion_arteria_vena'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_relacion_arteria_vena'] ) )
                    $texto = $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_relacion_arteria_vena'];
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Izquierdo: Arteriosclorosis
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_arteriosclerosis' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_arteriosclerosis'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_arteriosclerosis'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_arteriosclerosis'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Arteriosclorosis
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_arteriosclerosis' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_arteriosclerosis'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_arteriosclerosis'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_arteriosclerosis'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Izquierdo: Cruces arteriovenosos
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_cruces_arteriovenosos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_cruces_arteriovenosos'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_cruces_arteriovenosos'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_cruces_arteriovenosos'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Cruces arteriovenosos
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_cruces_arteriovenosos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_cruces_arteriovenosos'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_cruces_arteriovenosos'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_cruces_arteriovenosos'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                $this->SetFont( 'Arial', 'U', 10 );
                // Izquierdo: Retina
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_retina' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

                // Derecho: Retina
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_retina' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

                $this->SetFont( 'Arial', '', 10 );
                // Izquierdo: Cruces arteriovenosos
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_exudados' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_exudados'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_exudados'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_exudados'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Cruces arteriovenosos
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_exudados' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_exudados'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_exudados'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_exudados'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Izquierdo: Hemorragias
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_hemorragias' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_hemorragias'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_hemorragias'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_hemorragias'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Hemorragias
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_hemorragias' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_hemorragias'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_hemorragias'] ) )
                    if( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_hemorragias'] == 1 )
                        $texto = $this->CI->lang->line('oftalmologia_si');
                    else
                        $texto = $this->CI->lang->line('oftalmologia_no');
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Izquierdo: Retina
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_retina' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_retina'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_retina'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_retina_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['izquierdo_retina'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 0, 'L' );

                // Derecho: Retina
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_retina' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_retina'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_retina'] ) )
                    $texto = $this->CI->platc_model->pe_oftalmologia_retina_get( (int)$datos['tc']['datos']['form_oftalmologia']['respondida']['derecho_retina'] );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Conclusiones diagnosticas
                //                $this->AddPage();
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_ayuda_diagnostica' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

                // Diagnosticos
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_diagnosticos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                $texto = "";
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['diagnosticos'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['diagnosticos'] ) )
                    foreach( json_decode( $datos['tc']['datos']['form_oftalmologia']['respondida']['diagnosticos'] ) as $v )
                        $texto.= html_entity_decode( $this->CI->platc_model->pe_oftalmologia_diagnostico_get( (int)$v ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).PHP_EOL;
                else
                    $texto = ' - ';
                $this->MultiCell( 50, 6, $texto );

                // Conclusiones diagnosticas
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_ayuda_diagnostica' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                $texto = "";
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['ayuda_diagnostica'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['ayuda_diagnostica'] ) )
                    $this->MultiCell( 0, 6, str_replace( array('<br>','<br />'), "\n", $this->htmlpurifier->purify( utf8_decode( $datos['tc']['datos']['form_oftalmologia']['respondida']['ayuda_diagnostica'] ) ) ) );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Recomendaciones
                //                $this->AddPage();
                $this->Cell(100, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_recomendaciones' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

                // Control
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_control' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                $texto = "";
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['recomendaciones_control'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['recomendaciones_control'] ) )
                    $this->MultiCell( 0, 6, html_entity_decode( $this->CI->platc_model->pe_oftalmologia_control_get( (int) $datos['tc']['datos']['form_oftalmologia']['respondida']['recomendaciones_control'] ) ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );

                // Recomendaciones
                $this->Cell(50, 6, html_entity_decode( $this->CI->lang->line( 'oftalmologia_recomendaciones' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                $texto = "";
                if( isset( $datos['tc']['datos']['form_oftalmologia']['respondida']['recomendaciones'] ) &&
                    !empty( $datos['tc']['datos']['form_oftalmologia']['respondida']['recomendaciones'] ) )
                    $this->MultiCell( 0, 6, str_replace( array('<br>','<br />'), "\n", $this->htmlpurifier->purify( utf8_decode( $datos['tc']['datos']['form_oftalmologia']['respondida']['recomendaciones'] ) ) ) );
                else
                    $texto = ' - ';
                $this->Cell( 50, 6, $texto, 0, 1, 'L' );
            }
        } else {

      //CORRECCION SI641 
      $datos['tc']['TEL_CON_ESPECIALISTA'] = preg_replace("/[\r\n]+/", "\n", $datos['tc']['TEL_CON_ESPECIALISTA']);
      $datos['tc']['TEL_DIA_ESPECIALISTA'] = preg_replace("/[\r\n]+/", "\n", $datos['tc']['TEL_DIA_ESPECIALISTA']);
      $datos['tc']['TEL_DIA_FUNDAMENTOS'] = preg_replace("/[\r\n]+/", "\n", $datos['tc']['TEL_DIA_FUNDAMENTOS']);
      $datos['tc']['TEL_DIA_ORIENTACION'] = preg_replace("/[\r\n]+/", "\n", $datos['tc']['TEL_DIA_ORIENTACION']);
      //FIN
            $this->Ln( );
            $this->Cell(60, 6, html_entity_decode( $this->CI->lang->line( 'dm_diagnostico_cie10' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            if( isset( $datos['cie10_respuesta'] ) && !empty( $datos['cie10_respuesta'] ) ) {
                $x = $this->GetX( );
                foreach( $datos['cie10_respuesta'] as $k => $v ) {
                    $this->MultiCell( 0, 6, html_entity_decode( $v['descripcion'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                    $this->SetX( $x );
                }
                $this->Ln( );
            }  else
                $this->MultiCell( 0, 6, html_entity_decode( $this->CI->lang->line( 'dm_sin_diagnosticos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
      //CONCORDANCIA DIAGNOSTICA
      if($this->CI->session->userdata('SIT_ID') == 2){
        $this->Cell(60, 6, html_entity_decode( $this->CI->lang->line('tc_concordancia_diagnostica'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, html_entity_decode((($datos['tc']['CD_CONCORDANCIA_DIAGNOSTICA']) ? $this->CI->lang->line('si') : $this->CI->lang->line('no')), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
        if($datos['tc']['CD_CONCORDANCIA_VALUES'] && $datos['concordancia_diagnostica']){
          $x = $this->GetX( );
          foreach(json_decode($datos['tc']['CD_CONCORDANCIA_VALUES']) as $val){
            foreach($datos['concordancia_diagnostica'] as $item){
              if($val == $item['CD_ID']){
                $this->SetX( $x + 60 );
                $this->MultiCell( 0, 6, html_entity_decode( (( $this->CI->lang->line($item['CD_LABEL']) != "" && !is_null($this->CI->lang->line($item['AI_LABEL'])) ) ? "- ".utf8_decode($this->CI->lang->line($item['CD_LABEL'])) : "- ".$item['CD_DESCRIPCION']), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                CONTINUE;
              }
            }
          }
        }
      }
      //FIN

            $this->Cell(60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_conespecialista_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->MultiCell( 0, 6, str_replace( array('<br>','<br />'), "\n", utf8_decode( $this->htmlpurifier->purify( $datos['tc'][ 'TEL_CON_ESPECIALISTA'] ) ) ) );

            $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_diaespecialista_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->Multicell( 0, 6, str_replace( array('<br>','<br />'), "\n", utf8_decode( $this->htmlpurifier->purify( $datos['tc'][ 'TEL_DIA_ESPECIALISTA'] ) ) ) );

            $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_diaorientacion_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $this->MultiCell( 0, 6, str_replace( array('<br>','<br />'), "\n", utf8_decode( $this->htmlpurifier->purify( $datos['tc'][ 'TEL_DIA_ORIENTACION'] ) ) ) );

      //ACCION INDICADA
      if($this->CI->session->userdata('SIT_ID') == 2){
        $this->Cell(60, 6, html_entity_decode( $this->CI->lang->line('acciones_indicadas'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        if($datos['tc']['AI_ACCION_INDICADA_VALUES'] && $datos['accion_indicada']){
          $x = $this->GetX( );
          foreach(json_decode($datos['tc']['AI_ACCION_INDICADA_VALUES']) as $val){
            foreach($datos['accion_indicada'] as $item){
              if($val == $item['AI_ID']){
                $this->SetX( $x );
                $this->MultiCell( 0, 6, html_entity_decode( (( $this->CI->lang->line($item['AI_LABEL']) != "" && !is_null($this->CI->lang->line($item['AI_LABEL'])) ) ? "- ".utf8_decode($this->CI->lang->line($item['AI_LABEL'])) : "- ".$item['AI_DESCRIPCION']), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                CONTINUE;
              }
            }
          }
        }
      }
      //FIN
      
            if( (int)$this->GetY() > 210 ) $this->AddPage( );
            $y = $this->GetY();
            //correccion (SI2020)
            $this->MultiCell( 150, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_diafundamentos_pdf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 'L' );
            $x = $this->lMargin + 60;

            $this->SetY( $y );
            $this->SetX( $x );
            $this->Ln();
            $this->MultiCell( 0, 6, str_replace( array('<br>','<br />'), "\n", utf8_decode( $this->htmlpurifier->purify( $datos['tc'][ 'TEL_DIA_FUNDAMENTOS'] ) ) ) );
        }
    }

    /*
     * Genera el llenado de datos en el PDF para las Recetas
     */
    public function establecer_recetas( $tc ) {

        /*
         * Obtiene datos de la receta desde variable $tc
         */
        $recetas = $tc['recetas'];
        $cie10 = ($tc['TEL_CIE_ID_RESPUESTA']) ? $this->CI->platc_model->cie10_get(json_decode($tc['TEL_CIE_ID_RESPUESTA'])) : "";

        if( isset( $recetas ) && !empty( $recetas ) ) {

            foreach( $recetas as $r => $listado_recetas ){

                $listado_solicitudes = array();
                $listado_solicitudes = $listado_recetas['receta']['receta_solicitudes'];

                //imprimir($listado_solicitudes);
                foreach( $listado_solicitudes as $k => $solicitudes ) {

                    /*
                     * Agregar pagina en blanco PDF
                     */
                    $this->AddPage();

                    /*
                     * Nombre del recetario
                     */
                    $this->Rect(10, 30, 200, 235);
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 10 );
                    $this->Cell(200, 6, html_entity_decode( $this->CI->lang->line( 'recetario_recetario' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.' '.html_entity_decode( $listado_recetas['receta']['RF_NOMBRE'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );

                    /*
                     * Titulo Paciente, datos de fecha, dia, mes, ano
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(100, 4, '1.'. html_entity_decode( $this->CI->lang->line( 'recetario_paciente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_fecha' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.$listado_recetas['receta']['fecha_d'], 1, 0, 'L' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_mes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.$listado_recetas['receta']['fecha_m'], 1, 0, 'L' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_ano' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.$listado_recetas['receta']['fecha_a'], 1, 0, 'L' );

                    /*
                     * Titulo Primer apellido, segundo apellido, nombres
                     * Datos Primer apellido, segundo apellido, nombres
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_primer_apellido' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_segundo_apellido' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(66, 4, html_entity_decode( $this->CI->lang->line( 'recetario_nombres' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(67, 4, utf8_decode( $listado_recetas['paciente']['PAC_PRIMER_APELLIDO']  ), 1, 0, 'L' );
                    $this->Cell(67, 4, utf8_decode( $listado_recetas['paciente']['PAC_SEGUNDO_APELLIDO'] ), 1, 0, 'L' );
                    $this->Cell(66, 4, utf8_decode( $listado_recetas['paciente']['PAC_PRIMER_NOMBRE']    ).' '.  utf8_decode( $listado_recetas['paciente']['PAC_SEGUNDO_NOMBRE'] ));

                    /*
                     * Titulo Documento identificación, numero, edad, genero
                     * Datos Documento identificación, numero, edad, genero
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_documento_identificacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_numero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_edad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_genero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    /* (SI2811)
                        agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                     */
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'  ', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(50, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'  ', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(50, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(50, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(50, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $listado_recetas['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }

                    $this->Cell(50, 4, html_entity_decode( $listado_recetas['paciente_identificadores'][0]['PAC_IDT_VALOR'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $tc['TEL_PAC_EDAD'] ), 1, 0, 'C' );

                    if( !empty($listado_recetas['paciente']['PAC_SEXO']) && $listado_recetas['paciente']['PAC_SEXO'] == 'M' ){
                        //$this->Cell(50, 4,  html_entity_decode( $r['paciente']['PAC_SEXO'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                        $this->Cell(50, 4, html_entity_decode( 'F: '.'___'.'  '.'M: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['paciente']['PAC_SEXO']) && $listado_recetas['paciente']['PAC_SEXO'] == 'F' ){
                        $this->Cell(50, 4, html_entity_decode( 'F: '. '_x_'.'  '.'M: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }

                    /*
                     * Titulo Telefono, municipio, dirección residencia, departamento
                     * Datos Telefono, municipio, dirección residencia, departamento
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_municipio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(60, 4, html_entity_decode( $this->CI->lang->line( 'recetario_direccion_residencia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(60, 4, html_entity_decode( $this->CI->lang->line( 'recetario_departamento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(40, 4, html_entity_decode( $listado_recetas['paciente']['PAC_TELEFONO'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(40, 4, html_entity_decode( $listado_recetas['receta']['MUNI_ID'].'-'.$tc['TEL_PAC_MUN_NOMBRE'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(60, 4, html_entity_decode( $listado_recetas['receta']['PAC_DIRECCION_RESIDENCIA'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );

                    $this->Cell(60, 4, html_entity_decode( $listado_recetas['paciente']['DEP_ID'] .'-'.$tc['TEL_PAC_DPTO_NOMBRE'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    /*
                     * Titulo Afiliación, nombre entidad
                     * Datos Afiliación, nombre entidad
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(100, 4, html_entity_decode( $this->CI->lang->line( 'recetario_afiliacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(100, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_nombre_entidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(100, 4, html_entity_decode( $tc['TEL_PAC_AFI_NOMBRE'] ), 2, 0, 'L' );
                    $this->SetFont( 'Arial', '', 6 );
                    $this->Cell(100, 4,  html_entity_decode( $tc['TEL_PAC_ENTADM_NOMBRE'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );

                    /*
                     * Solicitudes
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '2.'.html_entity_decode( $this->CI->lang->line( 'recetario_solicitudes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, '' );
                    $this->SetFont( 'Arial', '', 6 );
                    $this->MultiCell(200, 3, utf8_decode( $solicitudes['RFR_SOLICITUDES'] ), 0, 'L');
          //$this->Cell( 200, 4, utf8_decode( $solicitudes['RFR_SOLICITUDES'] ), 1, 0, '' ); //SI2074
                    /*
                     * Diagnosticos CIE10
                     */
           $this->SetFont( 'Arial', '', 8 );
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(200, 4, html_entity_decode( $this->CI->lang->line( 'recetario_diagnostico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    if( isset( $cie10 ) && !empty( $cie10 ) ) {
                        $x = $this->GetX( );
                        foreach( $cie10 as $k => $v ) {
                            $this->MultiCell( 200, 4, html_entity_decode( $v['id10']." - ".$v['dec10'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                            $this->SetX( $x );
                        }
                    }  else{
                        $this->MultiCell( 0, 4, html_entity_decode( $this->CI->lang->line( 'dm_sin_diagnosticos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                        $this->Ln( );
                    }

                    /*
                     * Titulo Nombre del Profesional que remite el caso
                     * Datos Nombre del Profesional que remite el caso
                     */
                    $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '3.'.html_entity_decode( $this->CI->lang->line( 'recetario_profesional_remite_caso' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, '' );
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(200, 4, html_entity_decode( $this->CI->lang->line( 'recetario_nombre_completo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(200, 4, utf8_decode( $listado_recetas['generalista']['USU_NOMBRE'] ), 0, 0, 'L' );

                    /*
                     * Titulo Documento de identidad, numero, resolucion, firma
                     * Datos Documento de identidad, numero, resolucion, firma
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_documento_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(30, 4, html_entity_decode( $this->CI->lang->line( 'recetario_numero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(90, 4, html_entity_decode( $this->CI->lang->line( 'recetario_resolucion_autorizacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->Rect(50, $y+4, 30, 20);

                    // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(40, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(40, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(40, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(40, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }


                    $this->Cell(30, 4, html_entity_decode( $listado_recetas['generalista']['USU_N_IDENTIFICACION'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
                    $this->Cell(90, 4, html_entity_decode( $listado_recetas['generalista']['USU_NRO_REGISTRO'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
                    $this->Rect(170, $y+4, 40, 20);
                    if( !empty( $listado_recetas['generalista']['USU_FIRMA'] ) ) {
                        $this->MemImage( base64_decode( $listado_recetas['generalista']['USU_FIRMA'] ), 171, $y+5, 38, 19 );
                    }

                    /*
                     * Nombre profesional que remite el caso, Institucion donde labora, direccion, ciudad, telefono
                     */
                    $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->Cell(90, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_donde_labora' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(55, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_direccion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(30, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_ciudad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    $y5_array_ = array();
                    $y = $this->GetY( );
                    $y5 = $y;
                    $y4 = $y;

                    // Nombre
                    $this->SetXY( 10, $y);
                    $this->MultiCell(90, 4, utf8_decode( $tc['ETB_NOMBRE'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y5_array[] = $y;

                    $y = $y4;
                    // Dirección
                    $this->SetXY( 90+10, $y);
                    $this->MultiCell(55, 4, utf8_decode( $tc['ETB_DIRECCION'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y5_array[] = $y;

                    $y = $y4;
                    // Ciudad
                    $this->SetXY( 145+10, $y);
                    $this->MultiCell(30, 4, utf8_decode( $tc['ETB_CIUDAD'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y5_array[] = $y;

                    $y = $y4;
                    // Telefono
                    $this->SetXY( 175+10, $y);
                    $this->MultiCell(25, 4, utf8_decode( $tc['ETB_TELEFONO'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y5_array[] = $y;

                    $y4 = max($y5_array);
                    $y = $y4;

                    $this->SetY($y4);
                    $this->Line(100, $y5, 100, $y4);
                    $this->Line(155, $y5, 155, $y4);
                    $this->Line(185, $y5, 185, $y4);

                    /*
                     * Titulo Profesional
                     */
                    $x = $this->GetX( );
                    $this->SetXY( $x, $y);
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '4.'.html_entity_decode( $this->CI->lang->line( 'recetario_profesional' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, '' );
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(200, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_nombre_completo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(200, 4, html_entity_decode( $listado_recetas['especialista']['USU_NOMBRE'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

                    /*
                     * Titulo Documento de identidad, numero, resolucion, firma
                     * Datos Documento de identidad, numero, resolucion, firma
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_documento_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(30, 4, html_entity_decode( $this->CI->lang->line( 'recetario_numero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(90, 4, html_entity_decode( $this->CI->lang->line( 'recetario_resolucion_autorizacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );

                    $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->Rect(50, $y+4, 30, 20);
                    
                                        // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(40, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(40, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(40, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(40, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION']) && $listado_recetas['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }


                    $this->Cell(30, 4, utf8_decode( $listado_recetas['especialista']['IDT_VALOR'] ), 0, 0, 'C' );
                    $this->Cell(90, 4, utf8_decode( $listado_recetas['especialista']['USU_N_IDENTIFICACION'] ), 0, 0, 'C' );

                    $this->Rect(170, $y+4, 40, 20);
                    if( !empty( $listado_recetas['especialista']['USU_FIRMA'] ) ) {
                        $this->MemImage( base64_decode( $listado_recetas['especialista']['USU_FIRMA'] ), 171, $y+5, 38, 19 );
                    }

                    /*
                     * Titulo Profesional, Institucion donde labora, direccion, ciudad, telefono
                     * Datos Profesional, Institucion donde labora, direccion, ciudad, telefono
                     */
                    $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_donde_labora' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_direccion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_ciudad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_institucion', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_direccion', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_ciudad', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_telefono', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'L' );

                    /*
                     * Entrega de medicamentos
                     */
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '5.'.html_entity_decode( $this->CI->lang->line( 'recetario_entrega_medicamento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, '' );

                    /*
                     * Apellidos y nombres de quien recibe
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(120, 4, html_entity_decode( $this->CI->lang->line( 'recetario_apellidos_nombre_quien_recibe' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(80, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_n_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );

                    /*
                     * Apellidos y nombres de quien dispensa
                     */
                    $this->Ln( ); $this->Ln( ); $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(120, 4, html_entity_decode( $this->CI->lang->line( 'recetario_apellidos_nombre_quien_dispensa' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(80, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_n_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );

                    /*
                     * Establecimiento farmaceutico, direccion, fecha de despacho
                     */
                    $this->Ln( ); $this->Ln( ); $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_establecimiento_farmaceutico_nombre' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_establecimiento_farmaceutico_direccion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(66, 4, html_entity_decode( $this->CI->lang->line( 'recetario_fecha_de_despacho' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(67, 4, '', 0, 0, '' );
                    $this->Cell(67, 4, '', 0, 0, '' );
                    $this->Cell(10, 4, html_entity_decode( $this->CI->lang->line( 'recetario_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );
                    $this->Cell(10, 4, '', 1, 0, '' );
                    $this->Cell(10, 4, html_entity_decode( $this->CI->lang->line( 'recetario_mes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );
                    $this->Cell(10, 4, '', 1, 0, '' );
                    $this->Cell(10, 4, html_entity_decode( $this->CI->lang->line( 'recetario_ano' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );
                    $this->Cell(10, 4, '', 1, 0, '' );
                }
            }
        }
    }

    /*
     * Genera el llenado de datos en el PDF para anexos
     */
    public function establecer_anexos( $tc ) {
    $pdf_anexo = array();
    $pdf_cups_list = array();
    $pdf_diagnosticos_list= array();
    $pdf_guiaspracticas_list= array();
    $pdf_paciente_data= array();
    $pdf_paciente_identificadores_data= array();
    $pdf_data_entadm_paciente= array();
    $pdf_data_depto_paciente= array();
    $pdf_data_munic_paciente= array();
    $pdf_entidad_adm_data= array();
    $pdf_establecimiento_data= array();
    $pdf_data_depto_establec= array();
    $pdf_data_munic_establec= array();
    $pdf_data_establecimiento= array();
    $pdf_especialista= array();
    $pdf_especialista_identificacion= array();
    $pdf_anexo= $tc['anexo3'];
    $pdf_cups_list= $tc['cups_list'];
      $pdf_diagnosticos_list = $tc['diagnosticos_list'];
    $pdf_guiaspracticas_list = $tc['guiaspracticas_list'];
    $pdf_paciente_data = $tc['paciente_data'];
    $pdf_paciente_identificadores_data = $tc['paciente_identificadores_data'];
    $pdf_data_entadm_paciente = $tc['data_entadm_paciente'];
    $pdf_data_depto_paciente = $tc['data_depto_paciente'];
    $pdf_data_munic_paciente = $tc['data_munic_paciente'];
    $pdf_especialista= $tc['especialista'];
    $pdf_especialista_identificacion= $tc['especialista_identificacion'];
    $pdf_data_depto_establec = $tc['data_depto_establec'];
      $pdf_data_munic_establec = $tc['data_munic_establec'];
    $pdf_data_establecimiento= $tc['data_establecimiento'];
    $this->AddPage();
                        /*
      * Nombre del recetario
      */
    $this->Rect(10, 30, 200, 235);
    $this->Ln( );
    $this->SetFont( 'Arial', 'B', 10 );
    if($pdf_data_entadm_paciente['ENTADM_ID']){
      $this->Cell(200, 8, utf8_decode( $this->CI->lang->line( 'axo_sheet_00_title' )), 0, 0, 'C' );
    }
    else{
      $this->Cell(200, 8, utf8_decode('SOLICITUD DE AUTORIZACIÓN DE SERVICIOS DE SALUD'), 0, 0, 'C' );
    }
      /*
    * 1. GENERAL
    */
    $this->Ln( );
    $this->SetFont( 'Arial', 'B', 6 );
    $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_title' ) ), 1, 0, 'L' );
    $this->Ln( );   
    $this->SetFont( 'Arial', '', 6 );
    $this->Cell(67, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_nro' ).": ".(($pdf_anexo['AXO_SOL_ID']) ? "0".$pdf_anexo['AXO_SOL_ID'] : "")), 1, 0, 'C' );
    $this->Cell(67, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_fecha' ).": ".(($pdf_anexo['AXO_SOL_FECHA'] && date_create($pdf_anexo['AXO_SOL_FECHA'])) ? date('d-m-Y',strtotime($pdf_anexo['AXO_SOL_FECHA'])) : "")), 1, 0, 'C' );
    $this->Cell(66, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_hora' ).": ".(($pdf_anexo['AXO_SOL_FECHA'] && date_create($pdf_anexo['AXO_SOL_FECHA'])) ? date('H:i:s',strtotime($pdf_anexo['AXO_SOL_FECHA'])) : "") ), 1, 0, 'C' );
    
    $this->Ln( );   
    $this->SetFont( 'Arial', '', 6 );
    $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_prestcod' )), 1, 0, 'C' );
    $this->Cell(75, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_prestnombre' )), 1, 0, 'C' );
    $this->Cell(75, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_estabnombre' )), 1, 0, 'C' );

    
    /*
    $this->Ln( );
    $this->Cell(50, 5, ( isset( $tc['CLI_CODIGO_PRESTADOR'] ) && !empty( $tc['CLI_CODIGO_PRESTADOR'] ) ) ? $tc['CLI_CODIGO_PRESTADOR'] : '-' , 1, 0, 'C' );
    $this->Cell(75, 5, ( isset( $tc['CLI_NOMBRE'] ) && !empty( $tc['CLI_NOMBRE'] ) ) ? $tc['CLI_NOMBRE'] : '-', 1, 0, 'C' );
    $this->Cell(75, 5, ( isset( $pdf_data_establecimiento['ETB_NOMBRE'] ) && !empty( $pdf_data_establecimiento['ETB_NOMBRE'] ) ) ? $pdf_data_establecimiento['ETB_NOMBRE'] : '-', 1, 0, 'C' );
    */
    
    
    
    $this->Ln( );
    $y_array = array();
    $x = $this->GetX();
    $y = $this->GetY();
    $this->MultiCell(50, 4, $tc['CLI_CODIGO_PRESTADOR'], '', 'C', false );
    $y_array[] = $this->GetY();
    $this->SetXY($x + 50,$y);
    $this->MultiCell(75, 4, $tc['CLI_NOMBRE'], '', 'C', false );
    $y_array[] = $this->GetY();
    $this->SetXY($x + 125,$y);
    $this->MultiCell(75, 4, $pdf_data_establecimiento['ETB_NOMBRE'], '', 'C', false );
    $y_array[] = $this->GetY();
    $this->SetY(max($y_array));
    
    $this->Line($x, $y, $x, max($y_array));
    $this->Line($x + 50, $y, $x + 50, max($y_array));
    $this->Line($x + 125, $y, $x + 125, max($y_array));
    $this->Line($x + 200, $y, $x + 200, max($y_array));
    
    
    

    $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_estadirec' ).": ".(( isset( $pdf_data_establecimiento['ETB_DIRECCION'] ) && !empty( $pdf_data_establecimiento['ETB_DIRECCION'] ) ) ? $pdf_data_establecimiento['ETB_DIRECCION'] : '-')), 1, 0, 'C' );
    $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_estadepto' ).": ".(( isset( $pdf_data_depto_establec['DPTO_NOMBRE'] ) && !empty( $pdf_data_depto_establec['DPTO_NOMBRE'] ) ) ? $pdf_data_depto_establec['DPTO_ID']. '-' .$pdf_data_depto_establec['DPTO_NOMBRE'] : '')), 1, 0, 'C' );
    $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_estamunic' ).": ".(( isset( $pdf_data_munic_establec['MUN_NOMBRE'] ) && !empty( $pdf_data_munic_establec['MUN_NOMBRE'] ) ) ? $pdf_data_munic_establec['MUN_ID_REAL']. '-' .$pdf_data_munic_establec['MUN_NOMBRE'] : '') ), 1, 0, 'C' );
    $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_01_sol_estatelefono' ).": ".(( isset( $pdf_data_establecimiento['ETB_TELEFONO'] ) && !empty( $pdf_data_establecimiento['ETB_TELEFONO'] ) ) ? $pdf_data_establecimiento['ETB_TELEFONO'] : '-') ), 1, 0, 'C' );
    
  
    /*
    * 2. ENTIDAD A LA QUE SE SOLICITA AUTORIZACIÓN
    */
    $this->Ln( );
    $this->SetFont( 'Arial', 'B', 6 );
    $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_02_title' )), 1, 0, 'L' );
    $this->Ln( );   
    $this->SetFont( 'Arial', 'B', 6 );
    //$this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_02_entcodigo' ).": ".(( isset( $pdf_data_entadm_paciente['ENTADM_ID'] ) && !empty( $pdf_data_entadm_paciente['ENTADM_ID'] ) ) ? $pdf_data_entadm_paciente['ENTADM_ID'] : 'No Aplica') ), 1, 0, 'C' );
    $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_02_entnombre' ).": ".(( isset( $tc['TEL_PAC_ENTADM_NOMBRE'] ) && !empty( $tc['TEL_PAC_ENTADM_NOMBRE'] ) ) ? $tc['TEL_PAC_ENTADM_NOMBRE'] : '-') ), 1, 0, 'C' );
    
    /*
    * 3. DATOS DEL PACIENTE
    */
    $this->Ln( );
    $this->SetFont( 'Arial', 'B', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_title' )), 1, 0, 'L' );
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_1erapellido' ) ), 1, 0, 'C' );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_2doapellido' ) ), 1, 0, 'C' );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_1ernombre' )), 1, 0, 'C' );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_2donombre' ) ), 1, 0, 'C' );
        $this->Ln( );
        $this->Cell(50, 5, ( isset( $pdf_paciente_data['PAC_PRIMER_APELLIDO'] ) && !empty( $pdf_paciente_data['PAC_PRIMER_APELLIDO'] ) ) ? $pdf_paciente_data['PAC_PRIMER_APELLIDO'] : '-', 1, 0, 'C' );
        $this->Cell(50, 5, ( isset( $pdf_paciente_data['PAC_SEGUNDO_APELLIDO'] ) && !empty( $pdf_paciente_data['PAC_SEGUNDO_APELLIDO'] ) ) ? $pdf_paciente_data['PAC_SEGUNDO_APELLIDO'] : '-', 1, 0, 'C' );
        $this->Cell(50, 5, ( isset( $pdf_paciente_data['PAC_PRIMER_NOMBRE'] ) && !empty( $pdf_paciente_data['PAC_PRIMER_NOMBRE'] ) ) ? $pdf_paciente_data['PAC_PRIMER_NOMBRE'] : '-', 1, 0, 'C' );
        $this->Cell(50, 5, ( isset( $pdf_paciente_data['PAC_SEGUNDO_NOMBRE'] ) && !empty( $pdf_paciente_data['PAC_SEGUNDO_NOMBRE'] ) ) ? $pdf_paciente_data['PAC_SEGUNDO_NOMBRE'] : '-', 1, 0, 'C' );

        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_docident' )), 1, 0, 'C' );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_docnro' ) ), 1, 0, 'C' );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_fecnac' ) ), 1, 0, 'C' );
        $this->Cell(50, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_genero' ) ), 1, 0, 'C' );
        $this->Ln( );
        $this->Cell(50, 5,  $pdf_paciente_identificadores_data[0] ['TIPO_IDENTIFICACION'] . '-'. $pdf_paciente_identificadores_data[0] ['IDT_NOMBRE'] , 1, 0, 'C' );
        $this->Cell(50, 5, $pdf_paciente_identificadores_data[0] ['PAC_IDT_VALOR'], 1, 0, 'C' );
        $this->Cell(50, 5, ( isset( $pdf_paciente_data['PAC_NACIMIENTO'] ) && !empty( $pdf_paciente_data['PAC_NACIMIENTO'] ) ) ? $pdf_paciente_data['PAC_NACIMIENTO'] : '-', 1, 0, 'C' );
        $this->Cell(50, 5, ( $pdf_paciente_data['PAC_SEXO'] == 'F' )? '_F_ Femenino':'_M_ Masculino', 1, 0, 'C' );
        
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(40, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_email' ) ), 1, 0, 'C' );
        $this->Cell(40, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_phone' ) ), 1, 0, 'C' );
        $this->Cell(40, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_direcc' ) ), 1, 0, 'C' );
        $this->Cell(40, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_depto' ) ), 1, 0, 'C' );
        $this->Cell(40, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_muni' ) ), 1, 0, 'C' );
        $this->Ln( );
        $this->Cell(40, 5, ( isset( $pdf_paciente_data['PAC_EMAIL'] ) && !empty( $pdf_paciente_data['PAC_EMAIL'] ) ) ? $pdf_paciente_data['PAC_EMAIL'] : '-', 1, 0, 'C' );
        $this->Cell(40, 5, ( isset( $pdf_paciente_data['PAC_TELEFONO'] ) && !empty( $pdf_paciente_data['PAC_TELEFONO'] ) ) ? $pdf_paciente_data['PAC_TELEFONO'] : '-', 1, 0, 'C' );
        $this->Cell(40, 5, '-', 1, 0, 'L' );
        $this->Cell(40, 5, ( isset( $pdf_data_depto_paciente['DPTO_NOMBRE'] ) && !empty( $pdf_data_depto_paciente['DPTO_NOMBRE'] ) ) ? $pdf_data_depto_paciente['DPTO_ID'] . '-'.$pdf_data_depto_paciente['DPTO_NOMBRE'] : '-', 1, 0, 'C' );
        $this->Cell(40, 5, ( isset( $pdf_data_munic_paciente['MUN_NOMBRE'] ) && !empty( $pdf_data_munic_paciente['MUN_NOMBRE'] ) ) ? $pdf_data_munic_paciente['MUN_ID_REAL'] . '-'.$pdf_data_munic_paciente['MUN_NOMBRE'] : '-', 1, 0, 'C' );
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_03_pac_afilia' )), 1, 0, 'C' );
        $this->Ln( );

        // imprimir($tc);

        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(200, 5, ( isset( $pdf_paciente_data['AFI_NOMBRE'] ) && !empty( $pdf_paciente_data['AFI_NOMBRE'] ) ) ? '_X_ '.$tc['TEL_PAC_AFI_NOMBRE'] : '-', 1, 0, 'C' );
        
        /*
        * 4. INFORMACION DE LA ATENCION Y SERVICIOS SOLICITADOS
        */
        $this->Ln( );
        $this->SetFont( 'Arial', 'B', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_title' )), 1, 0, 'L' );
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(100, 6, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_servorig' ) ), 1, 0, 'C' );
        $this->Cell(100, 6, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_servtipo' )), 1, 0, 'C' );
        $this->Ln( );
        $this->Cell(100, 5, ($pdf_anexo['AXO_SERV_ORIG_COD'] == 1 )? '_X_ Enfermedad General' :'___ Enfermedad General' , 1, 0, 'L' );
        $this->Cell(100, 5, ($pdf_anexo['AXO_SERV_TIPO_COD'] == 1 )? '_X_ Servicios Electivos' :'___ Servicios Electivos', 1, 0, 'L' );
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(100, 6, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_serpriori' ) ), 1, 0, 'C' );
        $this->Cell(100, 6, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_serubic' ) ), 1, 0, 'C' );
        $this->Ln( );
        $this->Cell(100, 5, ($pdf_anexo['AXO_SERV_PRIO_COD'] == 1 )? '_X_ No Prioritaria' :'___ No Prioritaria', 1, 0, 'L' );
        $this->Cell(100, 5, ($pdf_anexo['AXO_SERV_UBICPAC_COD'] == 1 )? '_X_ Consulta Externa' :'___ Consulta Externa', 1, 0, 'L' );
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(100, 6, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_servicio' ) ), 1, 0, 'C' );
        $this->Cell(100, 6, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_cama' ) ), 1, 0, 'C' );
        $this->Ln( );
        $this->Cell(100, 5, $pdf_anexo['AXO_SERV_SERVICIO'], 1, 0, 'L' );
        $this->Cell(100, 5, $pdf_anexo['AXO_SERV_CAMA'], 1, 0, 'L' );
        $this->Ln( );       
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_manejo' )), 1, 0, 'C' );
        $this->Ln( );

        $y_array = array();
        $y = $this->GetY( );
        $y2 = 0;
        $this->SetFont( 'Arial', '', 6 );
        for( $i = 0; $i < count($pdf_guiaspracticas_list) ; $i++ ) {

            if ($i == 0) {
                $y2 = $y; } elseif ($i>0) {
                    $y2 = max($y_array);
                    $y_array = array();
                    $y = $y2;
                }

            $this->SetXY( 10, $y);
            if ($i==$pdf_anexo['AXO_SERV_GUIAPRACT_COD']) {
                 if ($i==0) {
                     $this->MultiCell(200, 4, ($pdf_anexo['AXO_SERV_GUIAPRACT_COD'] == 0 )? 'Otro' :'' , "", 'L', false );
                     }else{
                          $this->MultiCell(200, 4, ($pdf_anexo['AXO_SERV_GUIAPRACT_COD'] == $i )? utf8_decode( $pdf_guiaspracticas_list[$i]['GPC_NOMBRE'] ): '' , "", 'L', false );
                 }
             
             }
            $y = $this->GetY( );
            $y_array[] = $y;

            $y = $y2;

            $y = $this->GetY( );
            $y_array[] = $y;
        }
            $this->SetXY( 10, $y);  
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_observa' ) ), 1, 0, 'C' );
        if($pdf_anexo['AXO_SERV_GUIAPRACT_COD'] == 0 ){
            $this->Ln( );
            $this->Cell(200, 5, $pdf_anexo['AXO_SERV_GUIAPRACT_OBS'], 1, 0, 'L' );
        }
    
        /*
        * 5. 5. Cups
        */
        $this->Ln( );
        $this->SetFont( 'Arial', 'B', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_05_title' )), 1, 0, 'L' );
        $this->Ln( );   

        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(20, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_05_cups_codigo' ) ), 1, 0, 'C' );
        $this->Cell(15, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_05_cups_cantidad' ) ), 1, 0, 'C' );
        $this->Cell(165, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_05_cups_descrip' ) ), 1, 0, 'C' );
        $this->Ln( );
        $this->SetFont( 'Arial', '', 6 );
        if( isset( $pdf_cups_list ) && !empty( $pdf_cups_list ) ) {
            $x = $this->GetX( );
            foreach( $pdf_cups_list as $k => $v ) {
                //$this->Cell(20, 5, utf8_decode( $v['ACU_CUP_ID'] ), 1, 0, 'L' );
                //$this->Cell(15, 5, utf8_decode( $v['ACU_CANT'] ), 1, 0, 'C' );
                //$this->Cell(165, 5, utf8_decode( $v['CUPS_DESC'] ), 1, 0, 'L' );
                //$this->Ln( );
                
                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(20, 4, utf8_decode( $v['ACU_CUP_ID'] ), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 20,$y);
                $this->MultiCell(15, 4, utf8_decode( $v['ACU_CANT'] ), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 35,$y);
                $this->MultiCell(165, 3, utf8_decode( preg_replace('/\r?\n|\r/',' ',$v['CUPS_DESC'] )), 0, 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 20, $y, $x + 20, max($y_array));
                $this->Line($x + 35, $y, $x + 35, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));
                $this->Line($x, max($y_array), $x + 200, max($y_array));
            }
        }  else{
            $this->MultiCell( 0, 4, utf8_decode( $this->CI->lang->line( 'axo_sheet_msg_sincups' ) ), 0, 'L', false, 0 );
            $this->Ln( );
        }
        $this->AddPage();
        $this->SetFont( 'Arial', '', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_04_sol_justif' )), 1, 0, 'C' );
        $this->Ln( );
        $this->SetFont( 'Arial', '', 6 );
        //$this->Cell(200, 5, $pdf_anexo['AXO_SERV_JUSTIFICA'], 1, 0, 'L' );
        //$this->Ln( );
        $this->MultiCell(200, 4, utf8_decode($pdf_anexo['AXO_SERV_JUSTIFICA']), 1, 'L', false );
        $this->SetFont( 'Arial', 'B', 6 );
        $this->Cell(200, 5, utf8_decode( $this->CI->lang->line( 'axo_sheet_05_diagtitle' )), 1, 0, 'L' );
        $this->Ln( );
        
        $cie10_label = "";
        $this->SetFont( 'Arial', '', 6 );
        if( isset( $pdf_diagnosticos_list ) && !empty( $pdf_diagnosticos_list ) ) {
            $x = $this->GetX( );
            foreach( $pdf_diagnosticos_list as $k => $v ) {
                
                $cie10_label[] = $v['id10']." - ".$v['dec10'];
            }
        }
        
        $this->MultiCell( 0, 4, (($cie10_label && is_array($cie10_label)) ? implode(', ',$cie10_label) : utf8_decode( $this->CI->lang->line( 'axo_sheet_msg_sindiags' ))), 0, 'L', false, 0 );

      // echo('<pre>');
      // print_r($formulas[$f]['paciente_identificadores'][0]['PAC_IDT_VALOR']);
      // echo('</pre>');
      // die();
        
        /*
         * FIRMAS MEDICOS 
         */
         $this->SetFont( 'Arial', '', 6 );
        $this->Ln( );
        $x = $this->GetX();
        $y = $this->GetY();
        $this->MultiCell(30, 10, 'MEDICO TRATANTE:', 1, 'L');
        $this->SetXY($x+30,$y);
        $this->MultiCell(50, 10, utf8_decode($tc['generalista']['USU_NOMBRE']), 1, 'L');
        $this->SetXY($x+80,$y);
        $this->MultiCell(30, 5, "MEDICO ESPECIALISTA:", 1, 'L');
        $this->SetXY($x+110,$y);
        $this->MultiCell(90, 10, utf8_decode($tc['especialista']['USU_NOMBRE']), 1, 'L');
        //Registro Medico
        $x = $this->GetX();
        $y = $this->GetY();
        $this->MultiCell(30, 10, 'REGISTRO MEDICO:', 1, 'L');
        $this->SetXY($x+30,$y);
        $this->MultiCell(50, 10, utf8_decode($tc['generalista']['USU_NRO_REGISTRO']), 1, 'L');
        $this->SetXY($x+80,$y);
        $this->MultiCell(30, 10, "ESPECIALIDAD:", 1, 'L');
        $this->SetXY($x+110,$y);
        $this->MultiCell(40, 10, utf8_decode($tc['ESP_NOMBRE']), 1, 'L');
        $this->SetXY($x+150,$y);
        $this->MultiCell(20, 10, utf8_decode('REGISTRO:'), 1, 'L');
        $this->SetXY($x+170,$y);
        $this->MultiCell(30, 10, utf8_decode($tc['especialista']['USU_NRO_REGISTRO']), 1, 'L');
        //Firmas
        $x = $this->GetX();
        $y = $this->GetY();
        $this->MultiCell(30, 10, 'FIRMA:', 1, 'L');
        $this->SetXY($x+30,$y);
        $this->Rect($x+30, $y, 50, 10);
        if( !empty( $tc['generalista']['USU_FIRMA'] ) ) {
            $this->MemImage( base64_decode( $tc['generalista']['USU_FIRMA'] ), $x+40, $y+1, '', 8 );
        }
        $this->SetXY($x+80,$y);
        $this->MultiCell(30, 10, "FIRMA:", 1, 'L');
        $this->SetXY($x+110,$y);
        $this->Rect($x+110, $y, 90, 10);
        if( !empty( $tc['especialista']['USU_FIRMA'] ) ) {
            $this->MemImage( base64_decode( $tc['especialista']['USU_FIRMA'] ), $x+120, $y+1, '', 8 );
        }
        
    }     
   
    /*
     * Genera el llenado de datos en el PDF para las Formulas
     */
    public function establecer_formulas( $tc ) {

      $formulas = array();
      $formulas = $tc['formulas'];



      $cie10 = ($tc['TEL_CIE_ID_RESPUESTA']) ? $this->CI->platc_model->cie10_get(json_decode($tc['TEL_CIE_ID_RESPUESTA'])) : "";
      $f=0;

      if( isset( $formulas ) && !empty( $formulas ) ) {

        do{
            $m = $tc['formulas'][$f]['receta_formula_medicamentos'];
            //imprimir($m);
            $medicamentos_agrupados = array( );

            do {
                $i=0;
                $temp = array();

                do{
                    $temp[] = array_shift( $m );
                    $i++;
                } while( $i < 7 && !empty( $m ) );

                //imprimir($temp);

                $medicamentos_agrupados[] = $temp;
            }while( !empty( $m ) );

            //imprimir($medicamentos_agrupados);

            for( $a = 0; $a < count( $medicamentos_agrupados ) ; $a++ ) {

                    $this->AddPage();

                    /*
                     * Titulo Formula de Medicamentos
                     */
                    $this->Rect(10, 30, 200, 235);
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 14 );
                    $this->Cell(200, 6, html_entity_decode( $this->CI->lang->line( 'recetario_formula_medicamentos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    if( !empty($formulas[$f]['receta']['RF_NOMBRE'])){
                        $this->SetFont( 'Arial', '', 8 );
                        $this->Cell(200, 6, html_entity_decode( $this->CI->lang->line( 'recetario_nombre' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.' '.utf8_decode( $formulas[$f]['receta']['RF_NOMBRE'] ), 1, 0, 'L' );
                    }

                    /*
                     * Paciente, fecha , dia, mes, ano
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(100, 4, '1. '. html_entity_decode( $this->CI->lang->line( 'recetario_paciente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_fecha' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.$formulas[$f]['receta']['fecha_d'], 1, 0, 'L' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_mes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.$formulas[$f]['receta']['fecha_m'], 1, 0, 'L' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_ano' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.$formulas[$f]['receta']['fecha_a'], 1, 0, 'L' );

                    /*
                     * Primer apellido, segundo apellido, nombres
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_primer_apellido' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_segundo_apellido' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(66, 4, html_entity_decode( $this->CI->lang->line( 'recetario_nombres' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(67, 4, utf8_decode( $formulas[$f]['paciente']['PAC_PRIMER_APELLIDO']  ), 1, 0, 'L' );
                    $this->Cell(67, 4, utf8_decode( $formulas[$f]['paciente']['PAC_SEGUNDO_APELLIDO'] ), 1, 0, 'L' );
                    $this->Cell(66, 4, utf8_decode( $formulas[$f]['paciente']['PAC_PRIMER_NOMBRE']    ).' '.  utf8_decode( $formulas[$f]['paciente']['PAC_SEGUNDO_NOMBRE'] ));

                    /*
                     * Nombre del paciente
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_documento_identificacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_numero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_edad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_genero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(50, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(50, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(50, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(50, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $formulas[$f]['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }

                    $this->Cell(50, 4, html_entity_decode( $formulas[$f]['paciente_identificadores'][0]['PAC_IDT_VALOR'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $tc['TEL_PAC_EDAD'] ), 1, 0, 'C' );

                    if( !empty($formulas[$f]['paciente']['PAC_SEXO']) && $formulas[$f]['paciente']['PAC_SEXO'] == 'F' ){
                        $this->Cell(50, 4, html_entity_decode( 'F: '. '_x_'.'  '.'M: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['paciente']['PAC_SEXO']) && $formulas[$f]['paciente']['PAC_SEXO'] == 'M' ){
                        $this->Cell(50, 4, html_entity_decode( 'F: '.'___'.'  '.'M: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }

                    /*
                     * Telefono, municipio, dirección residencia, departamento
                     */
                    
                    // imprimir($tc['TEL_PAC_DPTO_NOMBRE']);
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_municipio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(60, 4, html_entity_decode( $this->CI->lang->line( 'recetario_direccion_residencia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(60, 4, html_entity_decode( $this->CI->lang->line( 'recetario_departamento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    $this->Cell(40, 4, utf8_decode( $formulas[$f]['paciente']['PAC_TELEFONO'] ), 1, 0, 'C' );
                    $this->Cell(40, 4, utf8_decode( $formulas[$f]['paciente']['MUNI_ID'] .'-'. $tc['TEL_PAC_MUN_NOMBRE'] ), 1, 0, 'C' );
                    $this->Cell(60, 4, utf8_decode( $formulas[$f]['receta']['PAC_DIRECCION_RESIDENCIA'] ), 1, 0, 'C' );

                    $this->Cell(60, 4, utf8_decode( $formulas[$f]['paciente']['DEP_ID'] .'-'.  $tc['TEL_PAC_DPTO_NOMBRE'] ), 1, 0, 'C' );

                    /*
                     * Afiliación, nombre entidad
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(100, 4, html_entity_decode( $this->CI->lang->line( 'recetario_afiliacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(100, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_nombre_entidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    $this->Cell(100, 4, utf8_decode( $tc['TEL_PAC_AFI_NOMBRE'] ), 1, 0, 'L' );
                    $this->SetFont( 'Arial', '', 6 );
                    $this->Cell(100, 4,  utf8_decode( $tc['TEL_PAC_ENTADM_NOMBRE'] ), 1, 0, 'L' );

                    /*
                     * Titulo Medicamentos
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '2. '.html_entity_decode( $this->CI->lang->line( 'recetario_medicamentos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Ln( );

                    /*
                     * Nombre generico, concentracion, forma farmaceutica, dosis, via de administracion, cantidad prescrita(en numeros, en letras)
                     */
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(23, 8, html_entity_decode( $this->CI->lang->line( 'recetario_nombre_generico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(22, 8, html_entity_decode( $this->CI->lang->line( 'recetario_concentracion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(26, 8, html_entity_decode( $this->CI->lang->line( 'recetario_forma_farmaceutica' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(68, 8, html_entity_decode( $this->CI->lang->line( 'recetario_dosis' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(25, 8, html_entity_decode( $this->CI->lang->line( 'recetario_via_administracion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $x = $this->Getx();
                    $this->Cell(36, 4, html_entity_decode( $this->CI->lang->line( 'recetario_cantidad_prescrita' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );
                    $this->SetX($x);
                    $this->Cell(16, 4, html_entity_decode( $this->CI->lang->line( 'recetario_en_numeros' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C');
                    $this->Cell(20, 4, html_entity_decode( $this->CI->lang->line( 'recetario_en_letras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    $y_array = array();
                    $y = $this->GetY( );
                    $y2 = 0;
                    $this->SetFont( 'Arial', '', 6 );
                    for( $i = 0; $i < count($medicamentos_agrupados[$a]) ; $i++ ) {

                        if ($i == 0) {
                            $y2 = $y; } elseif ($i>0) {
                                $y2 = max($y_array);
                                $y_array = array();
                                $y = $y2;
                            }

                        // Nombre genérico
                        $this->SetXY( 10, $y);
                        $this->MultiCell(23, 4, $medicamentos_agrupados[$a][$i]['RFM_NOMBRE_GENERICO'] , "", 'L', false );

                        $y = $this->GetY( );
                        $y_array[] = $y;

                        $y = $y2;
                        // Concentración
                        $this->SetXY( 23+10, $y);
                        $this->MultiCell(22, 4, $medicamentos_agrupados[$a][$i]['RFM_CONCENTRACION'] , "", 'L', false );

                        $y = $this->GetY( );
                        $y_array[] = $y;

                        $y = $y2;
                        // Forma farmecéutica
                        $this->SetXY( 45+10, $y);
                        $this->MultiCell(26, 4, $medicamentos_agrupados[$a][$i]['RFM_FORMA_FARMACEUTICA'] , "", 'L', false );

                        $y = $this->GetY( );
                        $y_array[] = $y;

                        $y = $y2;
                        // Dosis
                        $this->SetXY( 71+10, $y);
                        $this->MultiCell(68, 4, $medicamentos_agrupados[$a][$i]['RFM_DOSIS'] , "", 'L', false );

                        $y = $this->GetY( );
                        $y_array[] = $y;

                        $y = $y2;
                        // Vía administración
                        $this->SetXY( 139+10, $y);
                        $this->MultiCell(25, 4, $medicamentos_agrupados[$a][$i]['RFM_VIA_ADMINISTRACION'] , "", 'L', false );

                        $y = $this->GetY( );
                        $y_array[] = $y;

                        $y = $y2;
                        // Cantidad: en números
                        $this->SetXY( 164+10, $y);
                        $this->MultiCell(16, 4, $medicamentos_agrupados[$a][$i]['RFM_CANTIDAD_NUMEROS'] , "", 'L', false );
                        $this->Ln( );
                        $this->Line($this->GetX(), $y, 210, $y);
                        $y = $this->GetY( );
                        $y_array[] = $y;

                        $y = $y2;
                        // Cantidad: en letras
                        $this->SetXY( 180+10, $y);
                        $this->MultiCell(20, 4, $medicamentos_agrupados[$a][$i]['RFM_CANTIDAD_LETRAS'] , "", 'L', false );

                        $y = $this->GetY( );
                        $y_array[] = $y;
                    }

                    $this->SetY(max($y_array));
                    $this->Line(33, 90, 33, max($y_array)+4);
                    $this->Line(55, 90, 55, max($y_array)+4);
                    $this->Line(81, 90, 81, max($y_array)+4);
                    $this->Line(149, 90, 149, max($y_array)+4);
                    $this->Line(174, 90, 174, max($y_array)+4);
                    $this->Line(190, 90, 190, max($y_array)+4);

                    /*
                     * Diagnostico
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(200, 4, html_entity_decode( $this->CI->lang->line( 'recetario_diagnostico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 6 );
                    if( isset( $cie10 ) && !empty( $cie10 ) ) {
                        $x = $this->GetX( );
                        foreach( $cie10 as $k => $v ) {
                            $this->MultiCell( 200, 4, html_entity_decode( $v['id10']." - ".$v['dec10'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                            $this->SetX( $x );
                        }
                    }  else{
                        $this->MultiCell( 0, 4, html_entity_decode( $this->CI->lang->line( 'dm_sin_diagnosticos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
                        $this->Ln( );
                    }

                    /*
                     * Nombre del Profesional que remite el caso
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '3.'.html_entity_decode( $this->CI->lang->line( 'recetario_profesional_remite_caso' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, '' );

                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(200, 4, html_entity_decode( $this->CI->lang->line( 'recetario_nombre_completo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );

                    $this->Cell(200, 4, utf8_decode( $formulas[$f]['generalista']['USU_NOMBRE'] ), 0, 0, 'L' );

                    /*
                     * Documento de identidad, numero, resolucion, firma
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_documento_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(30, 4, html_entity_decode( $this->CI->lang->line( 'recetario_numero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(90, 4, html_entity_decode( $this->CI->lang->line( 'recetario_resolucion_autorizacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    $this->Ln( );

                    // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(40, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(40, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(40, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(40, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['generalista_identificacion']['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    $this->Rect(50, $y+4, 30, 16);
                    $this->Cell(30, 4, utf8_decode( $formulas[$f]['generalista']['USU_N_IDENTIFICACION'] ), 0, 0, 'C' );
                    $this->Cell(90, 4, utf8_decode( $formulas[$f]['generalista']['USU_NRO_REGISTRO'] ), 0, 0, 'C' );

                    $this->Rect(170, $y+4, 40, 16);
                    if( !empty( $formulas[$f]['generalista']['USU_FIRMA'] ) ) {
                        $this->MemImage( base64_decode( $formulas[$f]['generalista']['USU_FIRMA'] ), 171, $y+5, 38, 15 );
                    }

                    /*
                     * Nombre profesional que remite el caso, Institucion donde labora, direccion, ciudad, telefono
                     */
                    $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->Cell(90, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_donde_labora' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(55, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_direccion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(30, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_ciudad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    /*
                     * Cantidad de filas para antecedentes de Profesional que remite el caso
                     */

                    $y1_array_ = array();
                    $y = $this->GetY( );
                    $y5 = $y;
                    $y4 = $y;

                    // Nombre
                    $this->SetXY( 10, $y);
                    $this->MultiCell(90, 4, utf8_decode( $tc['ETB_NOMBRE'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y1_array[] = $y;

                    $y = $y4;
                    // Dirección
                    $this->SetXY( 90+10, $y);
                    $this->MultiCell(55, 4, utf8_decode( $tc['ETB_DIRECCION'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y1_array[] = $y;

                    $y = $y4;
                    // Ciudad
                    $this->SetXY( 145+10, $y);
                    $this->MultiCell(30, 4, utf8_decode( $tc['ETB_CIUDAD'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y1_array[] = $y;

                    $y = $y4;
                    // Telefono
                    $this->SetXY( 175+10, $y);
                    $this->MultiCell(25, 4, utf8_decode( $tc['ETB_TELEFONO'] ), "", 'L', false );

                    $y = $this->GetY( );
                    $y1_array[] = $y;

                    $y4 = max($y1_array);
                    $y = $y4;

                    $this->SetY($y4);
                    $this->Line(100, $y5, 100, $y4);
                    $this->Line(155, $y5, 155, $y4);
                    $this->Line(185, $y5, 185, $y4);

                    /*
                     * Profesional
                     */
                    $this->SetXY( $x, $y);
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '4.'.html_entity_decode( $this->CI->lang->line( 'recetario_profesional' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, '' );
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(200, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_nombre_completo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( );
                    $this->Cell(200, 4, utf8_decode( $formulas[$f]['especialista']['USU_NOMBRE'] ), 0, 0, 'L' );

                    /*
                     * Documento de identidad, numero, resolucion, firma
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_documento_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(30, 4, html_entity_decode( $this->CI->lang->line( 'recetario_numero' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(90, 4, html_entity_decode( $this->CI->lang->line( 'recetario_resolucion_autorizacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $y = $this->GetY( );
                    $this->Cell(40, 4, html_entity_decode( $this->CI->lang->line( 'recetario_firma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    $this->Ln( );


                    // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(40, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(40, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(40, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(40, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(40, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(40, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION']) && $formulas[$f]['especialista_identificacion']['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(40, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }

                    $this->Rect(50, $y+4, 30, 16);
                    $this->Cell(30, 4, html_entity_decode( $formulas[$f]['especialista']['IDT_VALOR'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
                    $this->Cell(90, 4, html_entity_decode( $formulas[$f]['especialista']['USU_N_IDENTIFICACION'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );

                    $this->Rect(170, $y+4, 40, 16);
                    if( !empty( $formulas[$f]['especialista']['USU_FIRMA'] ) ) {
                        $this->MemImage( base64_decode( $formulas[$f]['especialista']['USU_FIRMA'] ), 171, $y+4, 38, 15 );
                    }

                    /*
                     * Institucion donde labora, direccion, ciudad, telefono
                     */
                    $this->Ln( ); $this->Ln( ); $this->Ln( );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_donde_labora' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_direccion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_ciudad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->lang->line( 'recetario_institucion_telefono' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_institucion', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_direccion', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_ciudad', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    $this->Cell(50, 4, html_entity_decode( $this->CI->config->item( 'receta_telefono', 'platc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'L' );

                    /*
                     * Entrega de medicamentos
                     */
                    $this->SetFont( 'Arial', 'B', 8 );
                    $this->Cell(200, 4, '5.'.html_entity_decode( $this->CI->lang->line( 'recetario_entrega_medicamento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, '' );

                    /*
                     * Apellidos y nombres de quien recibe
                     */
                    $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(120, 4, html_entity_decode( $this->CI->lang->line( 'recetario_apellidos_nombre_quien_recibe' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(80, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_n_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    /*
                     * Apellidos y nombres de quien dispensa
                     */
                    $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(120, 4, html_entity_decode( $this->CI->lang->line( 'recetario_apellidos_nombre_quien_dispensa' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(80, 4,  html_entity_decode( $this->CI->lang->line( 'recetario_n_identidad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 1, 'C' );

                    /*
                     * Establecimiento farmaceutico, direccion, fecha de despacho
                     */
                    $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_establecimiento_farmaceutico_nombre' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(67, 4, html_entity_decode( $this->CI->lang->line( 'recetario_establecimiento_farmaceutico_direccion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Cell(66, 4, html_entity_decode( $this->CI->lang->line( 'recetario_fecha_de_despacho' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    $this->Ln( ); $this->Ln( );
                    $this->SetFont( 'Arial', '', 8 );
                    $this->Cell(67, 4, '', 0, 0, '' );
                    $this->Cell(67, 4, '', 0, 0, '' );
                    $this->Cell(10, 4, html_entity_decode( $this->CI->lang->line( 'recetario_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );
                    $this->Cell(10, 4, '', 1, 0, '' );
                    $this->Cell(10, 4, html_entity_decode( $this->CI->lang->line( 'recetario_mes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );
                    $this->Cell(10, 4, '', 1, 0, '' );
                    $this->Cell(10, 4, html_entity_decode( $this->CI->lang->line( 'recetario_ano' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, '' );
                    $this->Cell(10, 4, '', 1, 0, '' );
            }
            $f++;
         }while( $f < (count($tc['formulas'])) );
      }
    }
    
    //NO POS NF525
    //RECETA NO POS
    public function establecer_recetas_no_pos($data){
        $recetas = $data['tc']['recetasNoPos'];
        $cie10 = ($data['tc']['TEL_CIE_ID_RESPUESTA']) ? $this->CI->platc_model->cie10_get(json_decode($data['tc']['TEL_CIE_ID_RESPUESTA'])) : "";
        if(!empty($recetas)){
            foreach($recetas as $r => $listado_recetas){
                /*
                 * Agregar pagina en blanco PDF
                 */
                $this->AddPage();
                /*
                 * Titulo Paciente, datos de fecha, dia, mes, ano
                 */
                $this->Ln( );
                $this->SetFont( 'Arial', 'B', 14 );
                $this->Cell(200, 6, $this->CI->lang->line('recetario_recetario_no_pos'), 1, 1, 'C' );
                $this->Ln( );
                $this->SetFont( 'Arial', 'B', 8 );
                $this->Cell(100, 4, '1. DATOS DEL PACIENTE', 1, 0, 'L' );
                $this->SetFont( 'Arial', '', 8 );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_fecha' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.date('d',strtotime($listado_recetas['RC_FECHA'])), 1, 0, 'L' );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_mes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.date('m',strtotime($listado_recetas['RC_FECHA'])), 1, 0, 'L' );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_ano' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.date('Y',strtotime($listado_recetas['RC_FECHA'])), 1, 0, 'L' );
                /*
                 * Titulo Primer apellido, segundo apellido, nombres
                 * Datos Primer apellido, segundo apellido, nombres
                 */
                $this->Ln( );
                $this->SetFont( 'Arial', '', 8 );
                $this->Cell(150, 4, 'PACIENTE: '.$data['tc']['TEL_PAC_PRIMER_NOMBRE'].' '.$data['tc']['TEL_PAC_SEGUNDO_NOMBRE'].' '.$data['tc']['TEL_PAC_PRIMER_APELLIDO'].' '.$data['tc']['TEL_PAC_SEGUNDO_APELLIDO'], 1, 0 );
                $this->Cell(50, 4, 'CIUDAD: ', 1, 0 );
                /*
                 * Titulo Documento identificación, numero, edad, genero
                 * Datos Documento identificación, numero, edad, genero
                 */
                $this->Ln( );
                $this->SetFont( 'Arial', '', 8 );
                $this->Cell(75, 4, 'TIPO Y NUMERO DE DOCUMENTO: ', 1, 0 );
                
                    // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(50, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(50, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(50, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(50, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }

                $this->Cell(25, 4, 'EDAD: ' .$data['tc']['TEL_PAC_EDAD'], 1, 0 );
                $this->Cell(25, 4, 'SEXO: ', 1, 0 );
                $this->Cell(25, 4, $data['tc']['TEL_PAC_SEXO'], 1, 0 );
                /*
                 * IPS, ambito, 
                 */
                $this->Ln( );
                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(75, 4, 'IPS: '.$data['tc']['ETB_NOMBRE'], '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 75,$y);
                $this->MultiCell(25, 4, 'AMBITO: ', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 100,$y);
                $this->MultiCell(25, 4, 'Ambulatorio: ', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 125,$y);
                $this->MultiCell(25, 4, 'X', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 150,$y);
                $this->MultiCell(25, 4, html_entity_decode('Hospitalizaci&oacute;n: ', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 175,$y);
                $this->MultiCell(25, 4, '', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 75, $y, $x + 75, max($y_array));
                $this->Line($x + 100, $y, $x + 100, max($y_array));
                $this->Line($x + 125, $y, $x + 125, max($y_array));
                $this->Line($x + 150, $y, $x + 150, max($y_array));
                $this->Line($x + 175, $y, $x + 175, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));
                $this->Line($x, max($y_array), $x + 200, max($y_array));
                /*
                 * Entidad, Afiliacion 
                 */
                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(75, 4, 'ENTIDAD: '.$data['tc']['ENTADM_NOMBRE'], '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 75,$y);
                $this->MultiCell(25, 4, 'AFILIACION: ', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 100,$y);
                $this->MultiCell(25, 4, $data['tc']['TEL_PAC_AFI_NOMBRE'], '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 125,$y);
                $this->MultiCell(25, 4, 'X', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 150,$y);
                $this->MultiCell(25, 4, 'Beneficiario', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 175,$y);
                $this->MultiCell(25, 4, '', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 75, $y, $x + 75, max($y_array));
                $this->Line($x + 100, $y, $x + 100, max($y_array));
                $this->Line($x + 125, $y, $x + 125, max($y_array));
                $this->Line($x + 150, $y, $x + 150, max($y_array));
                $this->Line($x + 175, $y, $x + 175, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));

                /*
                 * Medico Tratante, Especialista, Especialidad
                 */
                $this->Cell(70, 4, 'Med. Tratante: '.utf8_decode($data['generalista']['USU_NOMBRE']), 1, 0);
                $this->Cell(65, 4, 'Especialista: '.utf8_decode($data['especialista']['USU_NOMBRE']), 1, 0);
                $this->Cell(65, 4, 'Especialidad: '.utf8_decode($data['tc']['ESP_NOMBRE']), 1, 0);
                /*
                 * Descripcion Clinica - CIE10 respuesta
                 */
                $this->Ln( );
                $this->Cell(200, 4, 'DESCRIPCION CLINICA', 1, 0,'C');
                $this->Ln( );
                $cie10_label = "";
                if( isset( $cie10 ) && !empty( $cie10 ) ) {
                    foreach( $cie10 as $k => $v ) {
                        $cie10_label[] = $v['id10']." - ".$v['dec10'];
                    }
                }
                $this->MultiCell(200, 4, (($cie10_label && is_array($cie10_label)) ? implode(', ',$cie10_label) : ''), 1, 'L', false );
                /*
                 * Resumen de Historia
                 */
                $this->Ln( );
                $this->Cell(200, 4, 'RESUMEN DE HISTORIA', 1, 0,'C');
                $this->Ln();
                $this->MultiCell(200, 4, utf8_decode($listado_recetas['RC_RESUMEN_HISTORIA']), 1, 'L', false );
                /*
                 * Servicio NO POS
                 */
                $this->Ln( );
                $this->Cell(200, 4, utf8_decode('SERVICIO MEDICO O PRESTACIÓN NO POS'), 1, 0,'C');
                // Nombre del Servicio medico / Frecuencia / Cantidad / Dias Tratamiento
                $this->Ln();
                $this->Cell(100, 4, utf8_decode('Nombre del Servicio Médico o Prestación NO POS'), 1, 0);
                $this->Cell(40, 4, 'Frecuencia de Uso', 1, 0,'C');
                $this->Cell(30, 4, 'Cantidad Solicitada', 1, 0,'C');
                $this->Cell(30, 4, utf8_decode('Días de Tratamiento'), 1, 0,'C');
                // DATOS
                $this->Ln();
                $this->Cell(100, 4, utf8_decode($listado_recetas['prestacionNoPos'][0]['RCN_NOMBRE']), 1, 0);
                $this->Cell(40, 4, utf8_decode($listado_recetas['prestacionNoPos'][0]['RCN_FRECUENCIA']), 1, 0,'C');
                $this->Cell(30, 4, utf8_decode($listado_recetas['prestacionNoPos'][0]['RCN_CANTIDAD']), 1, 0,'C');
                $this->Cell(30, 4, utf8_decode($listado_recetas['prestacionNoPos'][0]['RCN_DIAS_TRATAMIENTO']), 1, 0,'C');
                /*
                 * Justificacion
                 */
                $this->Ln( );
                $this->Cell(200, 4, 'JUSTIFICACION PARA EL USO DEL NO POS', 1, 0,'C');
                $this->Ln();
                $this->MultiCell(200, 4, utf8_decode($listado_recetas['RC_JUSTIFICACION']), 1, 'L', false );
                /*
                 * Justificacion
                 */
                $this->Ln( );
                $this->Cell(200, 4, utf8_decode('SI EL SERVICIO MEDICO O PRESTACIÓN SE DEBE REPETIR, EXPLIQUE EL MOTIVO'), 1, 0,'C');
                $this->Ln();
                $this->MultiCell(200, 4, ($listado_recetas['RC_REPETIR']) ? utf8_decode(str_replace('<br />','',$listado_recetas['RC_REPETIR_MOTIVO'])) : 'N/A', 1, 'L', false );
                /*
                 * Objetivo
                 */
                $this->Ln();
                $this->Cell(100, 4, utf8_decode('OBJETIVO DEL SERVICIO NO POS: '), 1, 0);
                if($listado_recetas['RC_OBJETIVO_SERVICIO'] && $listado_recetas['RC_OBJETIVO_SERVICIO'] == 1){
                        $this->Cell(100, 4, 'DIAGNOSTICO', 1, 0);
                }
                if($listado_recetas['RC_OBJETIVO_SERVICIO'] && $listado_recetas['RC_OBJETIVO_SERVICIO'] == 2){
                        $this->Cell(100, 4, 'TERAPEUTICO', 1, 0);
                }
                if($listado_recetas['RC_OBJETIVO_SERVICIO'] && $listado_recetas['RC_OBJETIVO_SERVICIO'] == 3){
                        $this->Cell(100, 4, 'PROMOCION', 1, 0);
                }
                if($listado_recetas['RC_OBJETIVO_SERVICIO'] && $listado_recetas['RC_OBJETIVO_SERVICIO'] == 4){
                        $this->Cell(100, 4, 'PREVENCION', 1, 0);
                }
                if($listado_recetas['RC_OBJETIVO_SERVICIO'] && $listado_recetas['RC_OBJETIVO_SERVICIO'] == 5){
                        $this->Cell(100, 4, 'REHABILITACION', 1, 0);
                }
                /*
                 * Servicio POS
                 */
                $this->Ln( );
                $this->Cell(200, 4, utf8_decode('SERVICIO MEDICO O PRESTACION POS QUE SUSTITUYE O REEMPLAZA CON LA PRESTACION NO POS'), 1, 0,'C');
                // Nombre del Servicio medico
                $this->Ln();
                $this->Cell(120, 4, utf8_decode('NOMBRE DEL SERVICIO MEDICO O PRESTACIÓN POS'), 1, 0);
                $this->Cell(80, 4, utf8_decode($listado_recetas['prestacionPos'][0]['RCP_NOMBRE']), 1, 0,'C');
                /*
                 * FIRMAS MEDICOS 
                 */
                $this->Ln( );
                $this->Cell(200, 4, 'MEDICOS', 1, 0,'C');
                $this->Ln( );
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(30, 10, 'MEDICO TRATANTE:', 1, 'L');
                $this->SetXY($x+30,$y);
                $this->MultiCell(50, 10, utf8_decode($data['generalista']['USU_NOMBRE']), 1, 'L');
                $this->SetXY($x+80,$y);
                $this->MultiCell(30, 5, "MEDICO ESPECIALISTA:", 1, 'L');
                $this->SetXY($x+110,$y);
                $this->MultiCell(90, 10, utf8_decode($data['especialista']['USU_NOMBRE']), 1, 'L');
                //Registro Medico
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(30, 10, 'REGISTRO MEDICO:', 1, 'L');
                $this->SetXY($x+30,$y);
                $this->MultiCell(50, 10, utf8_decode($data['generalista']['USU_NRO_REGISTRO']), 1, 'L');
                $this->SetXY($x+80,$y);
                $this->MultiCell(30, 10, "ESPECIALIDAD:", 1, 'L');
                $this->SetXY($x+110,$y);
                $this->MultiCell(40, 5, utf8_decode($data['tc']['ESP_NOMBRE']), 1, 'L');
                $this->SetXY($x+150,$y);
                $this->MultiCell(20, 10, utf8_decode('REGISTRO:'), 1, 'L');
                $this->SetXY($x+170,$y);
                $this->MultiCell(30, 10, utf8_decode($data['especialista']['USU_NRO_REGISTRO']), 1, 'L');
                //Firmas
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(30, 10, 'FIRMA:', 1, 'L');
                $this->SetXY($x+30,$y);
                $this->Rect($x+30, $y, 50, 10);
                if( !empty( $data['generalista']['USU_FIRMA'] ) ) {
                    $this->MemImage( base64_decode( $data['generalista']['USU_FIRMA'] ), $x+40, $y+1, '', 8 );
                }
                $this->SetXY($x+80,$y);
                $this->MultiCell(30, 10, "FIRMA:", 1, 'L');
                $this->SetXY($x+110,$y);
                $this->Rect($x+110, $y, 90, 10);
                if( !empty( $data['especialista']['USU_FIRMA'] ) ) {
                    $this->MemImage( base64_decode( $data['especialista']['USU_FIRMA'] ), $x+120, $y+1, '', 8 );
                }
            }
        }
    }

    //FORMULA NO POS
    public function establecer_formulas_no_pos($data){
        $formulas = $data['tc']['formulasNoPos'];
        $cie10 = ($data['tc']['TEL_CIE_ID_RESPUESTA']) ? $this->CI->platc_model->cie10_get(json_decode($data['tc']['TEL_CIE_ID_RESPUESTA'])) : "";
        if(!empty($formulas)){
            foreach($formulas as $r => $listado){
                /*
                 * Agregar pagina en blanco PDF
                 */
                $this->AddPage();
                /*
                 * Titulo Paciente, datos de fecha, dia, mes, ano
                 */
                $this->Ln( );
                $this->SetFont( 'Arial', 'B', 14 );
                $this->Cell(200, 6, $this->CI->lang->line('recetario_formula_medicamentos_no_pos'), 1, 1, 'C' );
                $this->Ln( );
                $this->SetFont( 'Arial', 'B', 8 );
                $this->Cell(100, 4, '1. DATOS DEL PACIENTE', 1, 0, 'L' );
                $this->SetFont( 'Arial', '', 8 );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_fecha' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.date('d',strtotime($listado['FM_FECHA'])), 1, 0, 'L' );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_mes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.date('m',strtotime($listado['FM_FECHA'])), 1, 0, 'L' );
                $this->Cell(25, 4, html_entity_decode( $this->CI->lang->line( 'recetario_ano' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).':'.'  '.date('Y',strtotime($listado['FM_FECHA'])), 1, 0, 'L' );
                /*
                 * Titulo Primer apellido, segundo apellido, nombres
                 * Datos Primer apellido, segundo apellido, nombres
                 */
                $this->Ln( );
                $this->SetFont( 'Arial', '', 8 );
                $this->Cell(150, 4, 'PACIENTE: '.$data['tc']['TEL_PAC_PRIMER_NOMBRE'].' '.$data['tc']['TEL_PAC_SEGUNDO_NOMBRE'].' '.$data['tc']['TEL_PAC_PRIMER_APELLIDO'].' '.$data['tc']['TEL_PAC_SEGUNDO_APELLIDO'], 1, 0 );
                $this->Cell(50, 4, 'CIUDAD: ', 1, 0 );
                /*
                 * Titulo Documento identificación, numero, edad, genero
                 * Datos Documento identificación, numero, edad, genero
                 */
                $this->Ln( );
                $this->SetFont( 'Arial', '', 8 );
                $this->Cell(75, 4, 'TIPO Y NUMERO DE DOCUMENTO: ', 1, 0 );

                    // (SI2811)
                    // agregamos tipo  de documento pasaporte para evitar solapamiento de linea en receta
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CC' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'_x_'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'RC' ){
                        $this->Cell(50, 4, html_entity_decode( 'Registro civil', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'TI' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'_x_'.'    '.'C.C: '.'___'.'    '.'Otro: '.'___', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'CE' ){
                        $this->Cell(50, 4, html_entity_decode( 'Cedula de Extranjeria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NU' ){
                        $this->Cell(50, 4, html_entity_decode( 'Número único identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'NI' ){
                        $this->Cell(50, 4, html_entity_decode( 'Numero de identificación tributaria', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'AS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Adulto sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'MS' ){
                        $this->Cell(50, 4, html_entity_decode( 'Menor sin identificación', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'PA' ){
                        $this->Cell(50, 4, html_entity_decode( 'Pasaporte', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'C' );
                    }
                    if( !empty($data['paciente_identificadores'][0]['TIPO_IDENTIFICACION']) && $data['paciente_identificadores'][0]['TIPO_IDENTIFICACION'] == 'OTRO' ){
                        $this->Cell(50, 4, html_entity_decode( 'T.I: '.'___'.'    '.'C.C: '.'___'.'    '.'Otro: '.'_x_', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 0, 'L' );
                    }
                
                $this->Cell(25, 4, 'EDAD: '.$data['tc']['TEL_PAC_EDAD'], 1, 0 );
                $this->Cell(25, 4, 'SEXO: ', 1, 0 );
                $this->Cell(25, 4, $data['tc']['TEL_PAC_SEXO'], 1, 0 );
                /*
                 * IPS, ambito, 
                 */
                $this->Ln( );
                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(75, 4, 'IPS: '.$data['tc']['ETB_NOMBRE'], '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 75,$y);
                $this->MultiCell(25, 4, 'AMBITO: ', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 100,$y);
                $this->MultiCell(25, 4, 'Ambulatorio: ', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 125,$y);
                $this->MultiCell(25, 4, 'X', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 150,$y);
                $this->MultiCell(25, 4, html_entity_decode('Hospitalizaci&oacute;n: ', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 175,$y);
                $this->MultiCell(25, 4, '', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 75, $y, $x + 75, max($y_array));
                $this->Line($x + 100, $y, $x + 100, max($y_array));
                $this->Line($x + 125, $y, $x + 125, max($y_array));
                $this->Line($x + 150, $y, $x + 150, max($y_array));
                $this->Line($x + 175, $y, $x + 175, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));
                $this->Line($x, max($y_array), $x + 200, max($y_array));
                /*
                 * Entidad, Afiliacion 
                 */
                
                // imprimir($data['tc']['TEL_PAC_AFI_NOMBRE']);

                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(75, 4, 'ENTIDAD: '.$data['tc']['ENTADM_NOMBRE'], '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 75,$y);
                $this->MultiCell(25, 4, 'AFILIACION: ', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 100,$y);
                $this->MultiCell(25, 4, $data['tc']['TEL_PAC_AFI_NOMBRE'], '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 125,$y);
                $this->MultiCell(25, 4, 'X', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 150,$y);
                $this->MultiCell(25, 4, 'Beneficiario', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 175,$y);
                $this->MultiCell(25, 4, '', '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 75, $y, $x + 75, max($y_array));
                $this->Line($x + 100, $y, $x + 100, max($y_array));
                $this->Line($x + 125, $y, $x + 125, max($y_array));
                $this->Line($x + 150, $y, $x + 150, max($y_array));
                $this->Line($x + 175, $y, $x + 175, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));
                
                
                /*
                 * Medico Tratante, Especialista, Especialidad
                 */
                $this->Cell(70, 4, 'Med. Tratante: '.utf8_decode($data['generalista']['USU_NOMBRE']), 1, 0);
                $this->Cell(65, 4, 'Especialista: '.utf8_decode($data['especialista']['USU_NOMBRE']), 1, 0);
                $this->Cell(65, 4, 'Especialidad: '.utf8_decode($data['tc']['ESP_NOMBRE']), 1, 0);
                /*
                 * Descripcion Clinica - CIE10 respuesta
                 */
                $this->Ln( );
                $this->Cell(200, 4, 'DESCRIPCION CLINICA', 1, 0,'C');
                $this->Ln( );
                $cie10_label = "";
                if( isset( $cie10 ) && !empty( $cie10 ) ) {
                    foreach( $cie10 as $k => $v ) {
                        $cie10_label[] = $v['id10']." - ".$v['dec10'];
                    }
                }
                $this->SetFont('Arial','',6);
                $this->MultiCell(200, 4, (($cie10_label && is_array($cie10_label)) ? implode(', ',$cie10_label) : ''), 1, 'L', false );
                /*
                 * Resumen de Historia
                 */
                $this->SetFont('Arial','',8);
                $this->Cell(200, 4, 'RESUMEN DE HISTORIA', 1, 0,'C');
                $this->Ln();
                $this->SetFont('Arial','',6);
                $this->MultiCell(200, 4, utf8_decode($listado['FM_RESUMEN_HISTORIA']), 1, 'L', false );
                /*
                 * Genera Riesgo
                 */
                $this->SetFont('Arial','',8);
                $this->Cell(100, 4, utf8_decode('¿GENERA UN RIESGO EN LA VIDA Y SALUD DEL PACIENTE?'), 1, 0,'C');
                $this->Cell(100, 4, ($listado['FM_GENERA_RIESGO']) ? 'SI' : 'NO', 1, 0);
                /*
                 * Medicamentos POS
                 */
                $this->Ln( );
                $this->Cell(200, 4, utf8_decode('MEDICAMENTOS POS QUE SUSTITUYE'), 1, 0,'C');
                // Nombre y Presentacion / Dosis / Posologia / Tiempo Utilizacion / Cantidad
                $this->Ln();
                $this->Cell(80, 4, utf8_decode('Nombre y Presentacion'), 1, 0);
                $this->Cell(30, 4, 'Dosis', 1, 0,'C');
                $this->Cell(40, 4, 'Posologia', 1, 0,'C');
                $this->Cell(30, 4, utf8_decode('Tiempo de Utilizacion'), 1, 0,'C');
                $this->Cell(20, 4, utf8_decode('Cantidad'), 1, 0,'C');
                // DATOS
                $this->Ln();
                $this->SetFont('Arial','',6);
                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(80, 4, utf8_decode($listado['medicamentoPos'][0]['MF_NOMBRE']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 80,$y);
                $this->MultiCell(30, 4, utf8_decode($listado['medicamentoPos'][0]['MF_DOSIS']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 110,$y);
                $this->MultiCell(40, 4, utf8_decode($listado['medicamentoPos'][0]['MF_POSOLOGIA']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 150,$y);
                $this->MultiCell(30, 4, utf8_decode($listado['medicamentoPos'][0]['MF_TIEMPO']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 180,$y);
                $this->MultiCell(20, 4, utf8_decode($listado['medicamentoPos'][0]['MF_CANTIDAD']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 80, $y, $x + 80, max($y_array));
                $this->Line($x + 110, $y, $x + 110, max($y_array));
                $this->Line($x + 150, $y, $x + 150, max($y_array));
                $this->Line($x + 180, $y, $x + 180, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));
                /*
                 * Medicamentos NO POS
                 */
                $this->SetFont('Arial','',8);
                $this->Cell(200, 4, utf8_decode('SOLICITUD DEL TRATAMIENTO DEL MEDICAMENTO NO POS'), 1, 0,'C');
                // Nombre y Presentacion / Dosis / Posologia / Tiempo Utilizacion / Cantidad
                $this->Ln();
                $this->Cell(60, 4, utf8_decode('Principio Activo'), 1, 0);
                $this->Cell(30, 4, 'Grupo Terapeutico', 1, 0,'C');
                $this->Cell(30, 4, 'Concentracion', 1, 0,'C');
                $this->Cell(30, 4, utf8_decode('Forma Farmaceutica'), 1, 0,'C');
                $this->Cell(20, 4, utf8_decode('Dosis /Día'), 1, 0,'C');
                $this->Cell(30, 4, utf8_decode('Días Tratamiento'), 1, 0,'C');
                // DATOS
                $this->Ln();
                $this->SetFont('Arial','',6);
                $y_array = array();
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(60, 4, utf8_decode($listado['medicamentoNoPos'][0]['MFN_PRINCIPIO_ACTIVO']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 60,$y);
                $this->MultiCell(30, 4, utf8_decode($listado['medicamentoNoPos'][0]['MFN_GRUPO']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 90,$y);
                $this->MultiCell(30, 4, utf8_decode($listado['medicamentoNoPos'][0]['MFN_CONCENTRACION']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 120,$y);
                $this->MultiCell(30, 4, utf8_decode($listado['medicamentoNoPos'][0]['MFN_FORMA']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 150,$y);
                $this->MultiCell(20, 4, utf8_decode($listado['medicamentoNoPos'][0]['MFN_DOSIS']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetXY($x + 170,$y);
                $this->MultiCell(30, 4, utf8_decode($listado['medicamentoNoPos'][0]['MFN_DIAS_TRATAMIENTO']), '', 'L', false );
                $y_array[] = $this->GetY();
                $this->SetY(max($y_array));
                
                $this->Line($x, $y, $x, max($y_array));
                $this->Line($x + 60, $y, $x + 60, max($y_array));
                $this->Line($x + 90, $y, $x + 90, max($y_array));
                $this->Line($x + 120, $y, $x + 120, max($y_array));
                $this->Line($x + 150, $y, $x + 150, max($y_array));
                $this->Line($x + 170, $y, $x + 170, max($y_array));
                $this->Line($x + 200, $y, $x + 200, max($y_array));
                /*
                 * Justificacion
                 */
                $this->SetFont('Arial','',8);
                $this->Cell(200, 4, 'JUSTIFICACION PARA EL USO DEL NO POS', 1, 0,'C');
                $this->Ln();
                $this->SetFont('Arial','',6);
                $this->MultiCell(200, 4, utf8_decode(str_replace('<br />','',$listado['FM_JUSTIFICACION'])), 1, 'L', false );
                /*
                 * Efecto Terapeutico
                 */
                 $this->SetFont('Arial','',8);
                $this->Cell(200, 4, 'EFECTO TERAPEUTICO ESPERADO', 1, 0,'C');
                $this->Ln();
                $this->SetFont('Arial','',6);
                $this->MultiCell(200, 4, utf8_decode($listado['FM_EFECTO_TERAPEUTICO']), 1, 'L', false );
                /*
                 * Efectos Adversos
                 */
                 $this->SetFont('Arial','',8);
                $this->Cell(200, 4, 'EFECTOS ADVERSOS Y POSIBLES RIESGOS QUE SE DERIVEN POR EL USO DEL MEDICAMENTO NO POS', 1, 0,'C');
                $this->Ln();
                $this->SetFont('Arial','',6);
                $this->MultiCell(200, 4, utf8_decode($listado['FM_EFECTOS_ADVERSOS']), 1, 'L', false );
                /*
                 * FIRMAS MEDICOS 
                 */
                $this->Ln( );
                $this->SetFont('Arial','',8);
                $this->Cell(200, 4, 'MEDICOS', 1, 0,'C');
                $this->Ln( );
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(30, 10, 'MEDICO TRATANTE:', 1, 'L');
                $this->SetXY($x+30,$y);
                $this->MultiCell(50, 10, utf8_decode($data['generalista']['USU_NOMBRE']), 1, 'L');
                $this->SetXY($x+80,$y);
                $this->MultiCell(30, 5, "MEDICO ESPECIALISTA:", 1, 'L');
                $this->SetXY($x+110,$y);
                $this->MultiCell(90, 10, utf8_decode($data['especialista']['USU_NOMBRE']), 1, 'L');
                //Registro Medico
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(30, 10, 'REGISTRO MEDICO:', 1, 'L');
                $this->SetXY($x+30,$y);
                $this->MultiCell(50, 10, utf8_decode($data['generalista']['USU_NRO_REGISTRO']), 1, 'L');
                $this->SetXY($x+80,$y);
                $this->MultiCell(30, 10, "ESPECIALIDAD:", 1, 'L');
                $this->SetXY($x+110,$y);
                $this->MultiCell(40, 5, utf8_decode($data['tc']['ESP_NOMBRE']), 1, 'L');
                $this->SetXY($x+150,$y);
                $this->MultiCell(20, 10, utf8_decode('REGISTRO:'), 1, 'L');
                $this->SetXY($x+170,$y);
                $this->MultiCell(30, 10, utf8_decode($data['especialista']['USU_NRO_REGISTRO']), 1, 'L');
                //Firmas
                $x = $this->GetX();
                $y = $this->GetY();
                $this->MultiCell(30, 10, 'FIRMA:', 1, 'L');
                $this->SetXY($x+30,$y);
                $this->Rect($x+30, $y, 50, 10);
                if( !empty( $data['generalista']['USU_FIRMA'] ) ) {
                    $this->MemImage( base64_decode( $data['generalista']['USU_FIRMA'] ), $x+40, $y+1, '', 8 );
                }
                $this->SetXY($x+80,$y);
                $this->MultiCell(30, 10, "FIRMA:", 1, 'L');
                $this->SetXY($x+110,$y);
                $this->Rect($x+110, $y, 90, 10);
                if( !empty( $data['especialista']['USU_FIRMA'] ) ) {
                    $this->MemImage( base64_decode( $data['especialista']['USU_FIRMA'] ), $x+120, $y+1, '', 8 );
                }
            }
        }
    }
    //FIN

}

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    class VariableStream
    {
    var $varname;
    var $position;

    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }

    function stream_stat()
    {
        return array();
    }
}
