<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Util
*
* Clase que provee de metods utiles para la aplicacion
*
* @author Esteban G�mez Lillo
* @author http://www.swift.cl
*
* @package Platc_Model
*/
class Util {

	private $CI;

	/**
	* Constructor de la clase
	*
	* @access public
	* @param none
	* @return none
	*/
	public function __construct()
	{
		$this->CI =& get_instance();
	}

	/**
	* Segun los datos los prepara en un arreglo para que opuedan ser
	* desplegados como select dentro de las vistas.
	*
	* @access public
	* @param array $data Arreglo con los datos a ordenar
	* @param string $nom nombre del registro
	* @param string $cont contenido
	* @param string $first contenido del primer registro
	* @param boolean $zero_first para setear si el primer registro es vacio o cero
	* @return array con los datos para ser desplegaods en un form como CI los trabaja
	*/
	public function select_form_prepare($data, $nom, $cont, $first = '', $zero_first = '')
	{
		if ($data != NULL) {
			if ($zero_first == TRUE)
				$reg[0] = $first;
			else
				$reg[''] = $first;
			foreach ($data as $r)
				$reg[$r[$nom]] = $r[$cont];
			return $reg;
		}
		else
			return NULL;
	}

	/**
	* Pone ceros delante de un entero hasta compeltar 10 caracteres.
	*
	* @access public
	* @param int $seed_number numero a modificar
	* @return int con el nuevo numero
	*/
	public function zeroes($seed_number)
	{
		$zs = "";
		for ( $i = strlen($seed_number); $i <= 10; $i ++ )
			$zs .= 0;
		return $zs.$seed_number;
	}

	/**
	* Genera un nuevo arreglo sin los datos vacios.
	*
	* @access public
	* @param array $data Arreglo con los datos a preparar
	* @return array con los datos preparados
	*/
	public function prepare_data($data = array())
	{
		foreach ($data as $key => $val) {
			if ($val !== '')
				$ndata[$key] = $val;
		}
		return $ndata;
	}

	/**
	* Prepara un arreglo con a�os para ser mostrado dentro de un select de CI
	*
	* @access public
	* @param none
	* @return array con los a�os
	*/
	public function select_form_prepare_annos()
	{
		$reg[''] = '';
		$anno = date('Y');
		for ($i = $anno; $i >= 1900; $i --)
			$reg[$i] = $i;
		return $reg;
	}

	/**
	* Prepara un arreglo con los meses de un a�os para ser mostrado dentro de un select de CI
	*
	* @access public
	* @param none
	* @return array con los meses de un a�o
	*/
	public function select_form_prepare_meses()
	{
		$reg[''] = '';
		$reg['01'] = '01';
		$reg['02'] = '02';
		$reg['03'] = '03';
		$reg['04'] = '04';
		$reg['05'] = '05';
		$reg['06'] = '06';
		$reg['07'] = '07';
		$reg['08'] = '08';
		$reg['09'] = '09';
		$reg['10'] = '10';
		$reg['11'] = '11';
		$reg['12'] = '12';
		return $reg;
	}

	/**
	* Prepara un arreglo con los dias de un mes para ser mostrado dentro de un select de CI
	*
	* @access public
	* @param none
	* @return array con los dias de un mes
	*/
	public function select_form_prepare_dias()
	{
		$reg[''] = '';
		$reg['01'] = '01';
		$reg['02'] = '02';
		$reg['03'] = '03';
		$reg['04'] = '04';
		$reg['05'] = '05';
		$reg['06'] = '06';
		$reg['07'] = '07';
		$reg['08'] = '08';
		$reg['09'] = '09';
		$reg['10'] = '10';
		$reg['11'] = '11';
		$reg['12'] = '12';
		$reg['13'] = '13';
		$reg['14'] = '14';
		$reg['15'] = '15';
		$reg['16'] = '16';
		$reg['17'] = '17';
		$reg['18'] = '18';
		$reg['19'] = '19';
		$reg['20'] = '20';
		$reg['21'] = '21';
		$reg['22'] = '22';
		$reg['23'] = '23';
		$reg['24'] = '24';
		$reg['25'] = '25';
		$reg['26'] = '26';
		$reg['27'] = '27';
		$reg['28'] = '28';
		$reg['29'] = '29';
		$reg['30'] = '30';
		$reg['31'] = '31';
		return $reg;
	}

	/**
	* Ordena la fecha de aaaa-mm-dd a dd-mm-aaaa
	*
	* @access public
	* @param string $fecha Fecha a ordenar
	* @return string Fecha ordenada
	*/
	public function fecha_orden($fecha)
	{
		$arr_fecha = explode('-', $fecha);
		return $arr_fecha[2].'-'.$arr_fecha[1].'-'.$arr_fecha[0];
	}

	/**
	* Ordena la fecha y hora de aaaa-mm-dd hh:mm:ss a dd-mm-aaaa hh:mm:ss
	*
	* @access public
	* @param string $fecha Fecha y hora a ordenar
	* @return string Fecha y hora ordenada
	*/
	public function fecha_orden2($fecha)
	{
		$fecha_hora = explode(' ', $fecha);
		return $this->fecha_orden($fecha_hora[0]).' '.$fecha_hora[1];
	}

	/**
	 * Convert BR tags to nl
	 *
	 * @param string The string to convert
	 * @return string The converted string
	 */
	public function br2nl($string)
	{
		return preg_replace('/\<br(\s*)?\/?\>/i', "\n", $string);
	}

	/**
	* Calcula la edad de un paciente
	*
	* @access public
	* @param string $birthday Fecha de nacimiento del paciente
	* @return int calculo de la edad del paciente
	*/
	public function yearscalc($birthday)
	{
		$date = explode('-', $birthday);
		$day = date('d');
		$month = date('m');
		$year = date('Y');
		if (($date[1] == $month) && ($date[2] > $day))
			$year = ($year - 1);
		if ($date[1] > $month)
			$year = ($year - 1);
		$age = ($year - $date[0]);
		return $age;
	}

	/**
	* Consume webservice para obtener Interconsultas de la PIT
	*
	* @access public
	* @param string $id_pac Identificador del paciente
	* @param int $id_site Identificador del site en la PIT
	* @return array con el parce del XML obtenido
	*/
	public function get_pit_ex($id_pac, $id_site)
	{
		@$xmlDoc = new DOMDocument();
		@$xmlDoc->load('http://wsco.telemedicina.com:8080/axis2/services/GetExamenesPITtoTC?idPaciente='.$id_pac.'&tpoId=1&idSite=5');
		$root = @$xmlDoc->documentElement;
		$node = $root->firstChild;
		$resp = array ();
		while ($node) {
			if (($node->nodeType == XML_ELEMENT_NODE) && ($node->nodeName == 'ns:return')) {
				$content = $node->firstChild;
				$resp[] = $content->nodeValue;
			}
			$node = $node->nextSibling;
        }
		return $resp;
	}

	/**
	* Quita acentos y caracteres extra�os de un string
	*
	* @access public
	* @param string $cadena Cadena de caracteres a formatear
	* @return string nueva cadena sin acentos ni caracteres extra�os
	*/
	public function quitar_acentos($cadena)
	{
		$caracteres = '� � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � � " \' & < > ?';
		$caracteres = explode(' ', $caracteres);
		$nchar = count($caracteres);
		$base = 0;
		while($base < $nchar){
			$cadena = str_replace($caracteres[$base], '_', $cadena);
			$base ++;
		}
		return $cadena;
	}

	public function lee_archivo($archivo)
	{
		$f = fopen($archivo, "r");
		$contenido = "";
		while (!feof($f))
			$contenido .= fread($f, 1024);
		fclose($f);
		return $contenido;
	}

    public function is_json( $string ) {

        json_decode( $string );
        return( json_last_error() == JSON_ERROR_NONE );
    }

    /**
     * Calcula edad de una persona retornando un array con
     * los años, meses y días de diferencia
     * Importante: Usa funciones de PHP 5.3
     *
     * @param $fecha string Fecha original en formato YYYY-mm-dd
     * @return array Fecha de distancia entre $fecha y el "ahora"
     */
    public function calcular_edad_full( $fecha ) {

        $fecha1 = new DateTime( $fecha );
        return (array) $fecha1->diff( new DateTime( ) );
//        imprimir( (array) $fecha1->diff( new DateTime( ) ) );
    }


    /**
     * Configura librería de CI "email" con configuración obtenida desde
     * archivo "config/platc.php". Configuración
     */
    public function email_factory( $config_sobrecarga = array() ) {

        // Configuración para el envio de emails via gmail
        $config = Array(
            'protocol'  => 'smtp',
            'smtp_host' => $this->CI->config->item( 'email_servidor', 'platc' ),
            'smtp_port' => $this->CI->config->item( 'email_puerto', 'platc' ),
            'smtp_user' => $this->CI->config->item( 'email_usuario', 'platc' ),
            'smtp_pass' => $this->CI->config->item( 'email_contrasena', 'platc' ),
            'mailtype'  => 'html',
            'charset'   => 'utf-8'
        );

        // Agrega/cambia configuración de la librería
        if( !empty( $config_sobrecarga ) ) $config = array_merge( $config, $config_sobrecarga );

        $this->CI->load->library( 'email');
        $this->CI->email->clear(TRUE);
        $this->CI->email->initialize( $config );
        $this->CI->email->set_newline("\r\n");
    }

    /**
     * Obtiene ip real del cliente.
     * Puede que el cliente esté bajo condiciones indirectas que ofusquen
     * su IP externa
     * 
     * @return String IP del cliente
     */
    public function obtenerIPCliente( ) {

        if ($_SERVER) {
            if ( isset($_SERVER['HTTP_X_FORWARDED_FOR']) ) {
                $realip = $_SERVER["HTTP_X_FORWARDED_FOR"];
            } elseif ( isset($_SERVER["HTTP_CLIENT_IP"]) ) {
                $realip = $_SERVER["HTTP_CLIENT_IP"];
            } else {
                $realip = $_SERVER["REMOTE_ADDR"];
            }
        } else {
            if ( getenv( 'HTTP_X_FORWARDED_FOR' ) ) {
                $realip = getenv( 'HTTP_X_FORWARDED_FOR' );
            } elseif ( getenv( 'HTTP_CLIENT_IP' ) ) {
                $realip = getenv( 'HTTP_CLIENT_IP' );
            } else {
                $realip = getenv( 'REMOTE_ADDR' );
            }
        }
        
        return $realip;
    }
}
