<?php

/**
 * Description of migracion_model
 *
 * @author pmercado
 */
class Migracion_model extends CI_Model{

    private $mensaje = "";

    public function __construct() {
        parent::__construct();
    }

    public function tc_migracion_dm_general( $id_teleconsulta = NULL ) {
$this->db->trans_start();
        $sql = "SELECT *
                FROM TC_TELECONSULTA_DATA d
                        INNER JOIN TC_TELECONSULTA t ON ( t.TEL_ID = d.TEL_ID )
                WHERE d.TD_CLAVE = 'dm_general' AND t.SIT_ID = 22";
        if( !empty( $id_teleconsulta ) )
            $sql.= " AND d.TEL_ID = " . (int)$id_teleconsulta;

        $resultado = $this->db->query( $sql );

        if( $resultado->num_rows( ) > 0 ) {

            /*
             * Genera array con todas las TC y sus códigos CIE10 asociados
             */
            $update_array = array( );
            foreach( $resultado->result_array() as $fila_tc ) {

                $valores_dm = json_decode( $fila_tc['TD_VALOR'] );

                /*
                 * Genera array con todos los códigos asociados a la TC
                 */
                if( !is_array( $valores_dm ) )
                    $valores_dm = array( $valores_dm );

                $array_idcie10 = array( );
                foreach( $valores_dm as $codigo_cie ) {

                    $sql = "SELECT *
                            FROM TC_CIE10 c
                            WHERE c.id10 = '" . $codigo_cie . "' AND SIT_ID = 22";
                    $r = $this->db->query( $sql );

                    if( $r->num_rows( ) > 0 ) {

                        $fila_cie10 = $r->row_array( );
                        $array_idcie10[ ] = $fila_cie10['CIE_ID'];  // CIE_ID: el autoincrement
                    } else {
                        $this->mensaje( "[ERROR] TC:".$fila_tc['TEL_ID']." No se ha encontrado registro CIE10 con identificador '".$codigo_cie."', omitido, puede que ya se haya procesado......." );
                    }
                }

                // Una vez encontrados todos los códigos CIE10 se asocian a la TC a actualizar
                if( !empty( $array_idcie10 ) )
                    $update_array[ $fila_tc['TEL_ID'] ] = $array_idcie10;
            }

            /*
             * Actualiza data de TC_TELECONSULTA_DATA
             */
            if( !empty( $update_array ) )
                foreach( $update_array as $tel_id => $array_idcie10 ) {

                    $sql = "UPDATE TC_TELECONSULTA_DATA SET TD_VALOR = '". json_encode( $array_idcie10 ). "' WHERE TD_CLAVE = 'dm_general' AND TEL_ID = ".$tel_id;
                    $this->db->query( $sql );
                    $registros_afectados = $this->db->affected_rows( );
                    if( $registros_afectados == 0 )
                        $this->mensaje( "[PRECAUCION] No se pudo cambiar valor de dm_general 'json_encode( " . $array_idcie10 . " )' en TEL_ID=". $tel_id );
                    else
                        $this->mensaje( "[INFORMACION] TC:".$tel_id." = ".json_encode( $array_idcie10 )." OK");
                }
        } else {
            if( empty( $id_teleconsulta ) )
                $this->mensaje( "[PRECAUCION] No se han encontrado registros con TEL_ID=".$id_teleconsulta );
        }
$this->db->trans_complete();
        return $this->mensaje;
    }

    private function mensaje( $str ) {

        $this->mensaje.= $str."\n";
//        $this->output->set_output( $this->mensaje.= $str."\n" );
    }

 /*    public function cl_patologias( ) {

        // 1) Obtiene folios con campo patologias
        $sql = "SELECT TEL_ID FROM TC_TELECONSULTA_DATA WHERE TD_CLAVE = \"pat_patologias\" );";
        $q = $this->db->query($sql);
        $r = $q->result_array();

        // 2) Insertar campos ap_radio_patologia
        $data = array( );
        if( !empty( $r ) )
            foreach( $r as $folio ) {
                $t = array( );
                $t['TEL_ID'] = (int)$folio;
                $t['TD_CLAVE'] = "ap_radio_patologia";
                $t['TD_VALOR'] = "si";

                $data[] = $t;
            }

        $this->db->insert_batch('TC_TELECONSULTA_DATA', $data );

        // 3)
        $sql = "UPDATE TC_TELECONSULTA_DATA SET TD_CLAVE = 'ap_patologia' WHERE TD_CLAVE = 'pat_patologias'";
        $this->db->query( $sql );
    }
 */
}

