<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

// compatibilidad PHP <5.4
if( !defined( 'ENT_HTML401' ) ) define( 'ENT_HTML401', 0 );

/**
 * Platc
 *
 * Clase principal de la aplicacion de tipo controlador
 * esta clase carga el modelo que utiliza para obtener los
 * datos y los envia a la vista correspondiente.
 *
 * @author Esteban G�mez Lillo
 * @author http://www.swift.cl
 *
 * @package Platc
 */
class Platc extends CI_Controller {

    private $data = array();
    private $menu = array();
    private $language = '';
    private $path_file;
	private $config_cli_id;

    /**
     * 'ADMIN' => 1 <br />
     * 'SUPERVISOR' => 2 <br />
     * 'ESPECIALISTA' => 3 <br />
     * 'MEDICO_GENERAL' => 4 <br />
     * 'MEDICO_ASISTENTE' => 5 <br />
     * 'MEDICO_REVISOR' => 6 <br />
     * 'FACTURADOR' => 7 <br />
     * 'AUDITOR' => 8 <br />
     * 'ATENCION_CLIENTE' => 9 <br />
     * 
     * @var array
     */
    static $ROL = array('ADMIN' => 1, 'SUPERVISOR' => 2, 'ESPECIALISTA' => 3,
                        'MEDICO_GENERAL' => 4, 'MEDICO_ASISTENTE' => 5, 'MEDICO_REVISOR' => 6,
                        'FACTURADOR' => 7,
                        'AUDITOR' => 8, 'ATENCION_CLIENTE' => 9  );

    static $DERMA_DIR_FOTOS = array('ANATOMICA' => 'anatomica', '30CM' => '30cm',
                                    'LUZBLANCA' => 'luz_blanca', 'LUZUV' => 'luz_uv',
                                    'BORRADOS' => 'borrados', 'BORRADORES' => 'borradores' );

    static $IMG_EXT = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff', 'JPG', 'GIF', 'JPEG', 'PNG', 'BMP', 'TIFF' );

    static $OTORRINO_DIR_EXAMEN_ESPECIFICO = array( 'CABEZA' => 'cabeza', 'OIDO_IZQUIERDO' => 'oido_izquierdo',
                                                    'OIDO_DERECHO' => 'oido_derecho',
                                                    'NARIZ_IZQUIERDO' => 'nariz_izquierdo',
                                                    'NARIZ_DERECHO' => 'nariz_derecho',
                                                    'BOCA' => 'boca', 'CUELLO' => 'cuello', 'BORRADOS' => 'borrados' );

    static $OTORRINO_DIR_Y = array( 'FRONTAL' => 'frontal', 'IZQUIERDO' => 'izquierdo',
                                    'DERECHO' => 'derecho', 'BOCA' => 'boca',
                                    'CUELLO'  => 'cuello',  'BORRADOS' => 'borrados' );

    static $OFTALMOLOGICO_PROTOCOLOS = array(   'ESTRUCTURAS_EXTERNAS' => 'estructuras_externas',
                                                'FONDO_OJOS' => 'fondo_ojos',
                                                'TINCION_FLUORESCENCIA' => 'tincion_fluorescencia',
                                                'FRONTAL_CARA' => 'frontal_cara', 'BORRADOS' => 'borrados' );

    static $OFTALMOLOGICO_LADO  = array(    'IZQUIERDO' => 'izquierdo',
                                            'DERECHO' => 'derecho' );

    static $AFILIACIONES_CO  = array(   'REGIMENES_ESPECIALES' => 56,
                                        'REGIMENES_CONTRIBUTIVO' => 51,
                                        'MEDICINA_PREPAGADA' => 54,
                                        'PARTICULAR' => 55,
                                        'REGIMENES_SUBSIDIADO' => 52,
                                        'NO_ASEGURADO' => 53,
                                        'VINCULADO' => 57 );

    static $RECETARIO_TIPO = array( 'FORMULA' => 'formula', 'RECETA' => 'receta' );

    static $CO_PEDIATRIA_DE = array('PESO_EDAD' => 'peso_edad'  , 'TALLA_EDAD' => 'talla_edad',
                                    'PESO_TALLA_0_2' => 'peso_talla_0_2', 'PESO_TALLA_2_5' => 'peso_talla_2_5',
                                    'IMC' => 'imc'              , 'PERIMETRO_CEFALICO' => 'p_cefalico' );

    /*
     * CL
     */
    static $CL_OFTALMOLOGIA_FOTOS  = array( 'BORRADOS' => 'borrados', 'BORRADORES' => 'borradores',
                                            'IZQUIERDO' => 'izquierdo', 'DERECHO' => 'derecho' );

    /**
     * 'TOMADA' => 1<br />
     * 'ESPERA' => 2<br />
     * 'FINALIZADA' => 3<br />
     * 'CANCELADA' => 4
     * 
     * @var array
     */
    public static $AGENDAMIENTO_ESTADOS = array( 'TOMADA' => 1, 'ESPERA' => 2, 'FINALIZADA' => 3, 'CANCELADA' => 4 );

    /**
     * 'DESCONECTADO' => 1<br />
     * 'EN_SESION' => 2<br />
     * 'TERMINADO' => 3
     * 
     * @var array
     */
    public static $AGENDAMIENTO_SESION  = array( 'DESCONECTADO' => 1, 'EN_SESION' => 2, 'TERMINADO' => 3 );

    /**
     * PACIENTE_NO_ASISTE = 1 <br/>
     * PACIENTE_CANCELA_CITA = 2 <br/>
     * PROBLEMA_CONECTIVIDAD = 3 <br />
     * OTROS = 4 <br />
     * 
     */
    public static $AGENDAMIENTO_ESTADO_MOTIVO_RECHAZO = array(  'PACIENTE_NO_ASISTE' => 1, 'PACIENTE_CANCELA_CITA' => 2,
                                                                'PROBLEMA_CONECTIVIDAD' => 3, 'OTROS' => 4 );

    /**
     * BRASIL = 21 <br />
     * CHILE = 2 <br />
     * COLOMBIA = 22 <br />
     * PERU = 25 <br />
     * 
     */
    public static $SITE = array( 'CHILE' => 2, 'PERU' => 25, 'BRASIL' => 21, 'COLOMBIA' => 22 );

    /**
     * BORRADOR = 1 <br />
     * ENVIADA_NUEVA = 2 <br />
     * RECHAZADA => 3 <br />
     * ELIMINADA = 4 <br />
     * EXAM_SOLICITADO = 5 <br />
     * EXAM_REALIZADO' => 6 <br />
     * CONTESTADA = 7 <br />
     * 
     */
    public static $ESTADO_TC = array(   'BORRADOR' => 1, 'ENVIADA_NUEVA' => 2, 'RECHAZADA' => 3, 'ELIMINADA' => 4,
                                        'EXAM_SOLICITADO' => 5, 'EXAM_REALIZADO' => 6, 'CONTESTADA' => 7 );

    /**
     * Contructor de la clase que carga el modelo y las
     * librerias necesarias, ademas setea el idioma.
     *
     * @access default
     * @param none
     * @return none
     */
    function __construct() {

        parent::__construct();
        $this->load->model('platc_model');
		$this->load->model('cliente_model');
        $this->load->library('form_validation');
        $this->load->library('util');
        $CI = &get_instance();
        $CI->config->load('platc', true);
        $this->path_file = $CI->config->item('path_file', 'platc');
		$this->config_cli_id = $CI->config->item('cli_id', 'platc');
        if ($this->session->userdata('IDI_NOMBRE') == '')
            $this->language = $this->config->item('language');
        else {
            $this->language = $this->session->userdata('IDI_NOMBRE');
            if( (int)(int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] )
                $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($this->session->userdata('USU_ID'));
        }
		if($this->session->userdata('SIT_PAIS'))
			$this->lang->load($this->language."_".$this->session->userdata('SIT_PAIS'), $this->language);
		else
			$this->lang->load($this->language, $this->language);
    }

    /**
     * Metodo que comprueba si el usuario esta logeado, y si
     * es asi lo lleva a la vista correspondiente, de lo
     * contrario lo lleva a la vista de login para que se
     * autentique nuevamente.
     *
     * @access public
     * @param string $view la vista a cargar
     * @return none
     */
    public function index($view = 'index_view') {
        if ($this->session->is_logged()) {
            $this->menu();

            // Obtiene imagen institucional
            $usuario = $this->platc_model->usuario_get($this->session->userdata('USU_ID'));
            if (!empty($usuario))
                $this->data['imagen_institucional'] = $usuario['CLI_IMAGEN_INSTITUCIONAL'];
            else
                $this->data['imagen_institucional'] = NULL;

            // Establece link "Inicio"
            switch( (int)$this->session->userdata('ROL_ID') ) {
                case self::$ROL['ESPECIALISTA']     :  $this->data['content'] = 'especialistas'; break;
                case self::$ROL['MEDICO_GENERAL']   :
                case self::$ROL['MEDICO_ASISTENTE'] :  $this->data['content'] = 'generalistas'; break;
                case self::$ROL['MEDICO_REVISOR']   :  $this->data['content'] = 'revisor'; break;
                default :  $this->data['content'] = 'home';
            }

            $this->load->view($view, $this->data);
        }
        else {
            if ($view == 'index_view') {
                $this->data['reload_login'] = FALSE;
            }
            else
                $this->data['reload_login'] = TRUE;
            $this->load->view('login_view', $this->data);
        }
    }

    /**
     * Autentica al usuario segun parametros recividos desde
     * la vista login
     *
     * @access public
     * @param string $_POST['mail'] coreo para la autenticacion
     * @param string $_POST['pass'] contrase�a para la autenticacion
     * @return none
     */
    public function login() {
        $this->form_validation->set_rules('mail', '', 'required');
        $this->form_validation->set_rules('pass', '', 'required');
        if ($this->form_validation->run() != FALSE) {
            $data_user = $this->platc_model->login($this->input->post('mail'), md5($this->input->post('pass')));
            if ($data_user != FALSE) {
                $data_user['logged_in'] = TRUE;
                if( $data_user['ROL_ID'] == self::$ROL['ESPECIALISTA'] ) {
                    $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($data_user['USU_ID']);
                    $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($data_user['USU_ID']);
                    $data_user['grupos'] = $this->platc_model->grupos_por_usuario( $data_user['USU_ID'] );
                }
                $this->session->set_session($data_user);

                // Cambia de idioma según el usuario acreditado
                $this->language = $this->session->userdata('IDI_NOMBRE');
                $this->lang->load( $this->language, $this->language );
            }
            else
                $this->data['msg'] = TRUE;
        }

        // Establece link "Inicio"
        switch( (int)$this->session->userdata('ROL_ID') ) {
            case self::$ROL['ESPECIALISTA']     :  $this->data['content'] = 'especialistas'; break;
            case self::$ROL['MEDICO_GENERAL']   :
            case self::$ROL['MEDICO_ASISTENTE'] :  $this->data['content'] = 'generalistas'; break;
            case self::$ROL['MEDICO_REVISOR']   :  $this->data['content'] = 'revisor'; break;
            default :  $this->data['content'] = 'home';
        }

        $this->index();
    }

    /**
     * Carga el menu con todos los links del usuario segun el rol.
     * esto se carga en la variable global $data.
     *
     * @access private
     * @param none
     * @return none
     */
    private function menu() {
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ) {
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_2'), 'url' => 'platc/tc_lista_view/2/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_3'), 'url' => 'platc/tc_lista_view/5/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_4'), 'url' => 'platc/tc_lista_view/6/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_5'), 'url' => 'platc/tc_lista_view/7/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_6'), 'url' => 'platc/tc_lista_view/3/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_7'), 'url' => 'platc/tc_lista_view/4/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_18'), 'url' => 'platc/busqueda_tc/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_0'), 'url' => 'platc/paciente_listado/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_9'), 'url' => 'platc/grupos/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_10'), 'url' => 'platc/clientes/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_11'), 'url' => 'platc/establecimientos/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_12'), 'url' => 'platc/usuarios/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_13'), 'url' => 'platc/afiliaciones/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_14'), 'url' => 'platc/especialidades/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_16'), 'url' => 'platc/identificadores/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_19'), 'url' => 'platc/reportes_v2/', 'identificador' => '' );
			$this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_20'), 'url' => 'platc/tc_admin/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_21'), 'url' => 'platc/agenda_resumen/', 'identificador' => '' );

            if( in_array((int)$this->session->userdata('SIT_ID'), array(2,22)) ) {
                $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_22'), 'url' => 'platc/facturacion/', 'identificador' => '' );
                $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_23'), 'url' => 'platc/bolsas_resumen/', 'identificador' => '' );
                $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_24'), 'url' => 'platc/tarjetas_coordenadas/', 'identificador' => '' );
            }
        }
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_2'), 'url' => 'platc/tc_lista_view/2/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_3'), 'url' => 'platc/tc_lista_view/5/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_4'), 'url' => 'platc/tc_lista_view/6/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_5'), 'url' => 'platc/tc_lista_view/7/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_6'), 'url' => 'platc/tc_lista_view/3/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_7'), 'url' => 'platc/tc_lista_view/4/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_18'), 'url' => 'platc/busqueda_tc/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_0'), 'url' => 'platc/paciente_listado/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_10'), 'url' => 'platc/clientes/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_11'), 'url' => 'platc/establecimientos/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_12'), 'url' => 'platc/usuarios/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_20'), 'url' => 'platc/tc_admin/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_21'), 'url' => 'platc/agenda_resumen/', 'identificador' => '' );
        }
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] ) {
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_2'), 'url' => 'platc/tc_lista_view/2/', 'identificador' => 'enviadas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_3'), 'url' => 'platc/tc_lista_view/5/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_4'), 'url' => 'platc/tc_lista_view/6/', 'identificador' => 'realizadas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_5'), 'url' => 'platc/tc_lista_view/7/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_6'), 'url' => 'platc/tc_lista_view/3/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_17'), 'url' => 'platc/busqueda_tc/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_21'), 'url' => 'platc/agendamiento_resumen/' );
        }
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ) {

            if( $this->session->userdata( 'CLI_ACTIVO' ) == 1 ) {
                $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_1'), 'url' => 'platc/tc_crear/', 'identificador' => '' );
                $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_15'), 'url' => 'platc/tc_lista_view/1/', 'identificador' => 'borradores' );
            }
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_2'), 'url' => 'platc/tc_lista_view/2/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_3'), 'url' => 'platc/tc_lista_view/5/', 'identificador' => 'solicitadas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_4'), 'url' => 'platc/tc_lista_view/6/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_5'), 'url' => 'platc/tc_lista_view/7/', 'identificador' => 'respondidas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_6'), 'url' => 'platc/tc_lista_view/3/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_17'), 'url' => 'platc/busqueda_tc/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_21'), 'url' => 'platc/agendamiento_resumen/', 'identificador' => '' );
        }
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] ) {
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_2'), 'url' => 'platc/tc_lista_view/2/', 'identificador' => 'enviadas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_3'), 'url' => 'platc/tc_lista_view/5/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_4'), 'url' => 'platc/tc_lista_view/6/', 'identificador' => 'realizadas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_6'), 'url' => 'platc/tc_lista_view/3/', 'identificador' => '' );
        }
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['FACTURADOR'] ) {
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_22'), 'url' => 'platc/facturacion/', 'identificador' => '' );
        }

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ATENCION_CLIENTE'] ) { // NF432 -> FH
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_1'), 'url' => 'platc/tc_crear/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_2'), 'url' => 'platc/tc_lista_view/2/', 'identificador' => 'enviadas' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_18'), 'url' => 'platc/busqueda_tc/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_12'), 'url' => 'platc/usuarios/', 'identificador' => '' );
            $this->data['menu'][] = array( 'etiqueta' => $this->lang->line('menu_21'), 'url' => 'platc/agendamiento_resumen/', 'identificador' => '' );
        }        
    }

    /**
     * Mata la session del usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function logout() {
        $this->session->unset_userdata('logged_in');
        $this->session->sess_destroy();
        $this->index();
    }

    /**
     * Acceso a la vista principal del usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function home() {
        $this->index('home_view');
    }

    public function obtener_alertas( ) {

        if( $this->session->is_logged( ) ) {

            $alertas = array( );

            switch( (int)$this->session->userdata('ROL_ID') ) {

                case self::$ROL['ESPECIALISTA'] : {
                            // Independiente de que esté vista o no vista
                            $alertas['enviadas']    = count( $this->platc_model->tc_lista_get( 2, null, null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) ) );
                            $alertas['realizadas']  = count( $this->platc_model->tc_lista_get( 6, null, null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) ) );
                        } break;

                case self::$ROL['MEDICO_GENERAL'] :
                case self::$ROL['MEDICO_ASISTENTE'] : {

                            // Independiente de que esté vista o no vista
                            $alertas['borradores']  = count( $this->platc_model->tc_lista_get( 1 ) );
                            $alertas['solicitadas'] = count( $this->platc_model->tc_lista_get( 5, null, null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) ) );
                            // Solo no vista
                            $alertas['respondidas'] = count( $this->platc_model->tc_lista_get( 7, null, null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) ) );
                        } break;
                case self::$ROL['MEDICO_REVISOR'] : {

                            // Independiente de que esté vista o no vista
                            $alertas['enviadas']    = count( $this->platc_model->tc_lista_get( 2, null, null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) ) );
                            $alertas['realizadas']  = count( $this->platc_model->tc_lista_get( 6, null, null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) ) );
                        } break;
            }

            $listado = array( );
            if( !empty( $alertas ) ) {

                foreach( $alertas as $estado => $cantidad )
                    $listado[] = array( 'estado' => $estado, 'cantidad' => $cantidad );
            }
            $this->output->set_output( json_encode( $listado ) );
        }
    }

    /**
     * Acceso a la vista principal del rol generalista.
     *
     * @access public
     * @param none
     * @return none
     */
    public function generalistas() {
        $this->data['tc_borradores']         = $this->platc_model->tc_lista_get(1, 'ASC' );
        $this->data['tc_solicitud_examenes'] = $this->platc_model->tc_lista_get(5, 'ASC', null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) );
        $this->data['tc_contestadas']        = $this->platc_model->tc_lista_get(7, 'DESC', null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) );
        $this->index('generalistas_view');
    }

    /**
     * Acceso a la vista principal del rol especialista.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialistas() {
        $this->data['examenes_realizados']  = $this->platc_model->tc_lista_get(6, 'ASC', null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) );
        $this->data['examenes_enviados']    = $this->platc_model->tc_lista_get(2, 'ASC', null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) );
        $this->index('especialistas_view');
    }

    /**
     * Acceso a la vista principal del rol especialista.
     *
     * @access public
     * @param none
     * @return none
     */
    public function revisor() {
        $this->data['examenes_enviados']    = $this->platc_model->tc_lista_get(2, 'ASC', null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) );
        $this->data['examenes_realizados']  = $this->platc_model->tc_lista_get(6, 'ASC', null, ( ($this->session->userdata( 'SIT_ID' ) == 2) ? true : false ) );
        $this->index('revisor_view');
    }

    /**
     * Acceso a la vista para cambiar la password del usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function cambiar_passwd() {
        $this->index('chpassword_view', $this->data);
    }

    /**
     * Cambia el password del usuario.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param none
     * @param string $_POST['passnow'] password actual del usuario
     * @param string $_POST['passnew'] la nueva password del usuario
     * @param string $_POST['passrnew'] la repeticion de la nueva password del usuario
     * @return none
     */
    public function cambia_passwd() {
        $this->form_validation->set_rules('passnow', '', 'required');
        $this->form_validation->set_rules('passnew', '', 'required');
        $this->form_validation->set_rules('passrnew', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->input->post('passnew') == $this->input->post('passrnew')) {
            if ($this->platc_model->usuario_chpass($this->session->userdata('USU_ID'), md5($this->input->post('passnow')), md5($this->input->post('passnew')))) {
                $resp['action'] = 'true';
                $content = 'home';
                if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
                    (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ||
                    (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] )
                    $content = 'generalistas';
                if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] )
                    $content = 'especialistas';
                $resp['method'] = base_url() . 'platc/' . $content . '/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('chpass_ok');
            }
            else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('chpass_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Acceso a la vista para ver los sites creados,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function sites() {
        $this->index('sites_view');
    }

    /**
     * Metodo que saca todos los sites que existen en el sistema.
     *
     * @access public
     * @param none
     * @return array $this->data['sites'] con todos los sites del sistema
     */
    public function sites_lista() {
        $this->data['sites'] = $this->platc_model->sites_lista_get();
        $this->index('sites_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo site,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function site_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $idiomas = $this->platc_model->idiomas_get();
        $this->data['idiomas_select'] = $this->util->select_form_prepare($idiomas, 'IDI_ID', 'IDI_NOMBRE');
        $this->index('sites_agrega_view');
    }

    /**
     * Metodo encargado de recivir los parametros del nuevo site,
     * validarlos y crear el site,
     * esto solo para el rol de administrador.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del nuevo site
     * @param string $_POST['descripcion'] descripcion del nuevo site
     * @param int $_POST['idioma'] idioma del site
     * @param int $_POST['idpit'] identificador del site en la PIT
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function site_crea() {
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('idioma', '', 'required');
        $this->form_validation->set_rules('idpit', '', 'required');
        if( $this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ) {
            $data['SIT_NOMBRE'] = $this->input->post('nombre');
            $data['SIT_DESCRIPCION'] = $this->input->post('descripcion');
            $data['IDI_ID'] = $this->input->post('idioma');
            $data['SIT_PIT_ID'] = $this->input->post('idpit');
            if ($this->platc_model->site_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/sites_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('sites_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('sites_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Llama a la vista con los datos del site a editar,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param int $id identificador del site a editar
     * @return none
     */
    public function site_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['site'] = $this->platc_model->site_get($id);
        $idiomas = $this->platc_model->idiomas_get();
        $this->data['idiomas_select'] = $this->util->select_form_prepare($idiomas, 'IDI_ID', 'IDI_NOMBRE');
        $this->index('sites_edita_view');
    }

    /**
     * Metodo encargado de recivir los parametros del site ya existente,
     * validarlos y editar el site,
     * esto solo para el rol de administrador.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del nuevo site
     * @param string $_POST['descripcion'] descripcion del nuevo site
     * @param int $_POST['idioma'] idioma del site
     * @param int $_POST['idpit'] identificador del site en la PIT
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function site_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('idioma', '', 'required');
        $this->form_validation->set_rules('idpit', '', 'required');
        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['SIT_ID'] = $this->input->post('id');
            $data['SIT_NOMBRE'] = $this->input->post('nombre');
            $data['SIT_DESCRIPCION'] = $this->input->post('descripcion');
            $data['IDI_ID'] = $this->input->post('idioma');
            $data['SIT_PIT_ID'] = $this->input->post('idpit');
            if ($this->platc_model->site_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/sites_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('sites_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('sites_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina un site segun el id recibido por GET,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param int $id identificador del site a eliminar
     * @return none
     */
    public function site_eliminar($id) {
        if ((int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            if ($this->platc_model->site_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista de los grupos,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function grupos() {
        $this->index('grupos_view');
    }

    /**
     * Metodo que saca todos los grupos del sistema.
     *
     * @access public
     * @param none
     * @return array $this->data['grupos'] con todos los grupos del sistema
     */
    public function grupos_lista() {

        $this->data['grupos'] = $this->platc_model->grupos_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('grupos_datagrid_view');
    }

    /**
     * Muestra la vista para la creacion de un grupo.
     *
     * @access public
     * @param none
     * @return array $this->data['sites_select'] con todos los site del sistema
     */
    public function grupo_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes'] = !empty( $clientes ) ? $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) ) : null;

        $roles = array( self::$ROL['SUPERVISOR'], self::$ROL['ESPECIALISTA'], self::$ROL['MEDICO_REVISOR'] );
        $usuarios = $this->platc_model->usuarios_por_rol( $roles, $this->session->userdata('SIT_ID'),TRUE );
        $this->data['usuarios'] = !empty( $usuarios ) ? $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_EMAIL_NOMBRE' ) ) : null;

        $this->index('grupos_agrega_view');
    }

    /**
     * Crea un grupo con los parametros recividos.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $data['nombre'] nombre del grupo
     * @param string $data['descripcion'] descripcion del grupo
     * @param int $data['site'] id del site al cual esta asignandoce el grupo
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function grupo_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if( $this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ) {
            $data['GRU_NOMBRE'] = $this->input->post('nombre');
            $data['GRU_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            $clientes = $this->input->post('clientes');
            $usuarios = $this->input->post('usuarios');

            if ($this->platc_model->grupo_set($data, $clientes, $usuarios )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/grupos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('grupos_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('grupos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un grupo
     *
     * @access public
     * @param int $id identificador del grupo el cual se quiere editar
     * @return none
     */
    public function grupo_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['grupo'] = $this->platc_model->grupo_get($id);

        // Datos del grupo
        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        if( !empty( $clientes ) )
            $this->data['clientes'] = $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) );
        else
            $this->data['clientes'] = array( );

        $roles = array( self::$ROL['SUPERVISOR'], self::$ROL['ESPECIALISTA'], self::$ROL['MEDICO_REVISOR'] , self::$ROL['ATENCION_CLIENTE'] ); // NF432
        $usuarios = $this->platc_model->usuarios_por_rol( $roles, $this->session->userdata('SIT_ID'), TRUE );
        if( !empty( $usuarios ) )
            $this->data['usuarios'] = $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_EMAIL_NOMBRE' ) );
        else
            $this->data['usuarios'] = array( );

        // Datos para los dropdown de la página
        $clientes = $this->platc_model->clientes_grupo_get( $id );
        if( !empty( $clientes ) )
            $this->data['clientes_sel'] = $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) );
        else
            $this->data['clientes_sel'] = array( );

        $usuarios = $this->platc_model->usuarios_por_grupo( $id );
        if( !empty( $usuarios ) )
            $this->data['usuarios_sel'] = $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_NOMBRE' ) );
        else
            $this->data['usuarios_sel'] = array( );

        $this->index('grupos_edita_view');
    }

    /**
     * Edita un grupo segun nuevos parametros recibidos,
     * se validan y se hace el cambio.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $data['id'] id del grupo que se quiere editar
     * @param string $data['nombre'] nombre del grupo
     * @param string $data['descripcion'] descripcion del grupo
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function grupo_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ){
            $data['GRU_ID'] = $this->input->post('id');
            $data['GRU_NOMBRE'] = $this->input->post('nombre');
            $data['GRU_DESCRIPCION'] = $this->input->post('descripcion');

            $clientes = $this->input->post('clientes');
            $usuarios = $this->input->post('usuarios');

            if ($this->platc_model->grupo_upd($data, $clientes, $usuarios )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/grupos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('grupos_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('grupos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina un grupo segun el id recibido por GET,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param int $id identificador del grupo a eliminar
     * @return none
     */
    public function grupo_eliminar($id) {
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ) {
            if ($this->platc_model->grupo_del($id))
                echo 'true';
        }
    }

    /**
     * Metodo que autocompleta el campo generalista
     * y especialista segun el tipo y el string que
     * que se necesita que haga match,
     *
     * @access public
     * @param int $tipo tipo de usuario (generalista o especialista)
     * @return none
     */
    public function autocomplete($tipo, $match) {
        $result = $this->platc_model->autocomplete_search_get($tipo, $match);
        $resultado = array();
        if ($result != NULL) {
            foreach ($result as $r)
                $resultado[] = $r['USU_NOMBRE'];

            $this->output->set_output( json_encode( $resultado ) );
        }
        else
            $this->output->set_output( '[' . json_encode( array( 'value'=>'error', 'label' => html_entity_decode( $this->lang->line( 'error_busqueda' ) ) ) , JSON_FORCE_OBJECT ) . ']' );
    }

    /**
     * Carga la vista para la busqueda de TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function busqueda_tc($sdasd = NULL, $cache = FALSE) {
        
        // Inicializa campos
        $this->data['especialidades_select'] = array( );

        // Administrador
        // if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ) {
        if( ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']  )  || ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ATENCION_CLIENTE'] )    ) { // NF432
            $grupos = $this->platc_model->grupos_site_get( $this->session->userdata('SIT_ID') );
            $this->data['grupos_select'] = $this->util->select_form_prepare($grupos, 'GRU_ID', 'GRU_NOMBRE' );
            $especialidades = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
            if( !empty( $especialidades ) ) $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE' );
        } else
            // Supervisor
            if( (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            $clientes = $this->platc_model->clientes_usuario_get( $this->session->userdata('USU_ID') );
            $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', $this->lang->line('todos'), TRUE );

        } else
            // Especialista
            if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] ) {
            $clientes = $this->platc_model->clientes_usuario_get( $this->session->userdata('USU_ID') );
            $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', $this->lang->line('todos'), TRUE );
        } else {

            // Generalistas
            $establs = $this->platc_model->establecimientos_cliente_get($this->session->userdata('CLI_ID'));
            $this->data['establs_select'] = ($establs) ? $this->util->select_form_prepare($establs, 'ETB_ID', 'ETB_NOMBRE', $this->lang->line('todos'), TRUE ) : array();

            $especialidades = $this->platc_model->especialidades_por_cliente( $this->session->userdata('CLI_ID') );
            if( !empty( $especialidades ) ) $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE');
        }

        $this->data['estados_select'] = $this->platc_model->estados_select($this->language);

        if ($cache != FALSE)
            $this->data['search_cache'] = TRUE;
        else
            $this->data['search_cache'] = FALSE;
        $this->index('busqueda_tc_view');
    }

    /**
     * Carga la vista para la administracion de clientes.
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes() {
        $this->index('clientes_view');
    }

    /**
     * Lista todos los clientes del sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes_lista() {
        $this->data['clientes'] = $this->platc_model->clientes_lista_get();
        $this->index('clientes_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo cliente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function cliente_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));

        // Define especialidades por cada cliente
        $this->data['especialidades'] = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
        // TODO: "usuario_especialidades" debe ser "cliente_especialiades" no se cambia por ocupar misma lógica (reutilización de código)
        $this->index('clientes_agrega_view');
    }

    /**
     * Recibe parametros del nuevo cliente, los valida,
     * y lo crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del cliente
     * @param string $_POST['rut'] rut del cliente
     * @param string $_POST['razonsocial'] razon social del cliente
     * @param int $_POST['site'] site del cliente
     * @param int $_POST['grupo'] grupo del cliente
     * @return none
     */
    public function cliente_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('rut', '', 'required');
		$this->form_validation->set_rules('codprest', '', 'required');
        $this->form_validation->set_rules('especialidades', '', 'required');

        if( $this->form_validation->run() != FALSE &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) ) {
            $data['CLI_NOMBRE'] = $this->input->post('nombre');
            $data['CLI_RUT'] = $this->input->post('rut');
			$data['CLI_CODIGO_PRESTADOR'] = $this->input->post('codprest');
            $data['CLI_RAZON_SOCIAL'] = $this->input->post('razonsocial');
            $data['CLI_REVISOR'] = $this->input->post('revisor');
            $data['CLI_REVISOR'] = empty( $data['CLI_REVISOR'] ) ? 0 : 1 ;
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            $especialidades = $this->input->post( 'especialidades' );

            if ($this->platc_model->cliente_set($data, $especialidades )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/clientes_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('clientes_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('clientes_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un cliente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function cliente_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['cliente'] = $this->platc_model->cliente_get($id);

        // Define especialidades por cada cliente
        $this->data['especialidades'] = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
        // TODO: "usuario_especialidades" debe ser "cliente_especialiades" no se cambia por ocupar misma lógica (reutilización de código)
        $this->data['usuario_especialidades'] = $this->platc_model->especialidades_por_cliente( $id );
        $this->index('clientes_edita_view');
    }

    /**
     * Recibe los parametros para la edicion de un cliente.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del cliente
     * @param string $_POST['nombre'] nombre del cliente
     * @param string $_POST['rut'] rut del cliente
     * @param string $_POST['razonsocial'] razon social del cliente
     * @param int $_POST['grupo'] grupo del cliente
     * @return none
     */
    public function cliente_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('rut', '', 'required');
		$this->form_validation->set_rules('codprest', '', 'required');
        $this->form_validation->set_rules('especialidades', '', 'required');

        if( $this->form_validation->run() != FALSE &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) ) {
            $data['CLI_ID'] = $this->input->post('id');
            $data['CLI_NOMBRE'] = $this->input->post('nombre');
            $data['CLI_RUT'] = $this->input->post('rut');
			$data['CLI_CODIGO_PRESTADOR'] = $this->input->post('codprest');
            $data['CLI_RAZON_SOCIAL'] = $this->input->post('razonsocial');
            $data['CLI_REVISOR'] = $this->input->post('revisor');
            $data['CLI_REVISOR'] = empty( $data['CLI_REVISOR'] ) ? 0 : 1 ;
            $especialidades           = $this->input->post('especialidades');

            // Lee archivo de imagen institucional
            $archivo_imagen = $this->input->post('imagen_institucional');
            if (!empty($archivo_imagen)) {
                $nombre_archivo = 'uploads/' . $archivo_imagen;

                // Elimina del nombre del archivo el timestamp (nombre_archivo_xxxxxxxx.jpg)
                // y lo deja tal cual lo ingresaron (nombre_archivo.jpg)
                $archivo_imagen = explode('.', $archivo_imagen);
                $extension = array_pop($archivo_imagen);
                $archivo_imagen = explode('_', implode('.', $archivo_imagen));
                array_pop($archivo_imagen); //Descarta timestamp
                $archivo_imagen = implode('_', $archivo_imagen);
                $archivo_imagen = implode('.', array($archivo_imagen, $extension));

                @rename($nombre_archivo, 'images/clientes/' . $archivo_imagen);
                @unlink($nombre_archivo);
                $data['CLI_IMAGEN_INSTITUCIONAL'] = $archivo_imagen;
            }
            if ($this->platc_model->cliente_upd($data, $especialidades )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/clientes_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('clientes_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('clientes_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Página que permite subir el archivo de imagen de la institucion
     */
    public function cliente_subir_imagen_inst() {

        $error = '';

        if (!empty($_FILES)) {
            $config['upload_path'] = './uploads/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '100';
            $config['max_width'] = '200';
            $config['max_height'] = '100';
            $this->load->library('upload', $config);

            if ($this->upload->do_upload('imagen_institucional')) {
                $datos = $this->upload->data();
                $ruta = explode('/', $datos['full_path']);
                array_pop($ruta);
                $ruta = implode('/', $ruta);
                $nombre_nuevo = $datos['raw_name'] . '_' . time() . $datos['file_ext'];

                @rename($ruta . '/' . $datos['file_name'], $ruta . '/' . $nombre_nuevo);

                $retorno = '<script language="javascript" type="text/javascript">';
                $retorno.= 'window.opener.document.getElementById( "imagen_institucional" ).value = "' . $nombre_nuevo . '" ;';
                $retorno.= 'window.close();';
                $retorno.= '</script>';

                exit($retorno);
            } else {
                $error = array('error' => $this->upload->display_errors());
            }
        }

        $this->load->view('clientes_subir_imagen_inst', array('error' => $error));
    }

    public function cliente_eliminar($id) {
        if( ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) ) {
            if ($this->platc_model->cliente_del($id))
                $this->output->set_output( 'true' );
        }
    }

    public function cliente_desactivar( $id_cliente ) {
        if( $this->session->userdata( 'ROL_ID' ) < 3 ) {
            if( $this->platc_model->cliente_desactivar( $id_cliente ) )
                $this->output->set_output( 'true' );
        }
    }

    public function cliente_activar( $id_cliente ) {
        if( $this->session->userdata( 'ROL_ID' ) < 3 ) {
            if( $this->platc_model->cliente_activar( $id_cliente ) )
                $this->output->set_output( 'true' );
        }
    }

    /**
     * Carga la vista para la administracion de establecimientos.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimientos() {
        $this->index('establecimientos_view');
    }

    /**
     * Lista todos los establecimientos del sistema
     * esto segun el rol que esta tenga.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimientos_lista() {
        $this->data['establecimientos'] = $this->platc_model->establecimientos_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('establecimientos_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un establecimiento.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimiento_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes_select']   = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE');

        if( empty( $this->data[ 'clientes_select' ] ) ) $this->data[ 'clientes_select' ] = array( );

        //$municipios = $this->platc_model->municipios_get(  );
        //$this->data['municipios_select'] = $this->util->select_form_prepare( $municipios, 'MUNI_ID', 'MUNI_NOMBRE');
		$departamentos = $this->platc_model->departamentos_m_list_get();
		$this->data['departamentos_select'] = $this->util->select_form_prepare( $departamentos, 'DPTO_ID', 'DPTO_NOMBRE');
		unset( $this->data['departamentos_select'][''] );    // Elimina elemento vacío

        $this->index('establecimientos_agrega_view');
    }

    /**
     * Recibe los parametros para la edicion de un cliente.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del establecimiento
     * @param string $_POST['nivel'] nivel del establecimiento
     * @param string $_POST['direccion'] direccion del establecimiento
     * @param string $_POST['email'] email del establecimiento
     * @param int $_POST['site'] site del establecimiento
     * @param int $_POST['grupo'] grupo del establecimiento
     * @param int $_POST['cliente'] cliente del establecimiento
     * @return none
     */
    public function establecimiento_crea() {
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('nivel', '', 'required');
        $this->form_validation->set_rules('direccion', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('cliente', '', 'required');
        $this->form_validation->set_rules('detalle_nivel', '', 'required');

        if( $this->session->userdata('SIT_ID') == 22 ) {
           // $this->form_validation->set_rules('municipio', '', 'required');
//            $this->form_validation->set_rules('ciudad', '', 'required');
            $this->form_validation->set_rules('telefono', '', 'required');
        }

        if ($this->form_validation->run() != FALSE &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) ) {
            $data['ETB_NOMBRE']     = $this->input->post('nombre');
            $data['ETB_NIVEL']      = $this->input->post('nivel');
            $data['ETB_DIRECCION']  = $this->input->post('direccion');
            $data['ETB_EMAIL']      = $this->input->post('email');
            $data['CLI_ID']         = $this->input->post('cliente');
            $data['ETB_DETALLE_NIVEL'] = $this->input->post('detalle_nivel');
            $data['SIT_ID']         = $this->session->userdata('SIT_ID');

            if( $this->session->userdata('SIT_ID') == 22 ) {
                //$data['MUNI_ID']    = $this->input->post('municipio');
                //$data['ETB_CIUDAD'] = $this->input->post('ciudad');
				
				$data['ETB_DPTO_ID'] = $this->input->post('departamentos');
				$data['ETB_MUNI_ID'] = $this->input->post('municipio');
				$data['ETB_TELEFONO'] = $this->input->post('telefono');
            }

            if ($this->platc_model->establecimiento_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/establecimientos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('establecimientos_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('establecimientos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un establecimiento.
     *
     * @access public
     * @param none
     * @return none
     */
    
    // (SI2811)
    // agregamos busqueda a municipio para guardar y mostrarlo en el combo
    public function establecimiento_editar($id) {

        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes_select'] = $this->util->select_form_prepare($clientes, 'CLI_ID', 'CLI_NOMBRE');

        $departamentos = $this->platc_model->departamentos_m_list_get();
        $this->data['departamentos_select'] = $this->util->select_form_prepare( $departamentos, 'DPTO_ID', 'DPTO_NOMBRE');
        unset( $this->data['departamentos_select'][''] );    // Elimina elemento vacío

        $municipios = $this->platc_model->municipios_get(  );
        $this->data['municipios_select'] = $this->util->select_form_prepare( $municipios, 'MUNI_ID', 'MUNI_NOMBRE');
        unset( $this->data['municipios_select'][''] );    // Elimina elemento vacío

        $this->data['establecimiento'] = $this->platc_model->establecimiento_get($id);

        $this->index('establecimientos_edita_view');
    }

    /**
     * Recibe los parametros para editar un establecimiento.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del establecimiento
     * @param string $_POST['nombre'] nombre del establecimiento
     * @param string $_POST['nivel'] nivel del establecimiento
     * @param string $_POST['direccion'] direccion del establecimiento
     * @param string $_POST['email'] email del establecimiento
     * @param int $_POST['cliente'] cliente del establecimiento
     * @return none
     */
    public function establecimiento_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('nivel', '', 'required');
        $this->form_validation->set_rules('direccion', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('cliente', '', 'required');
        $this->form_validation->set_rules('detalle_nivel', '', 'required');

        if( $this->session->userdata('SIT_ID') == 22 ) {
            //$this->form_validation->set_rules('municipio', '', 'required');
            //$this->form_validation->set_rules('ciudad', '', 'required');
			$this->form_validation->set_rules('departamentos', '', 'required');
			$this->form_validation->set_rules('municipio', '', 'required');
            $this->form_validation->set_rules('telefono', '', 'required');
        }

        if ($this->form_validation->run() != FALSE &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) ) {
            $data['ETB_ID'] = $this->input->post('id');
            $data['ETB_NOMBRE'] = $this->input->post('nombre');
            $data['ETB_NIVEL'] = $this->input->post('nivel');
            $data['ETB_DIRECCION'] = $this->input->post('direccion');
            $data['ETB_EMAIL'] = $this->input->post('email');
            $data['CLI_ID'] = $this->input->post('cliente');
            $data['ETB_DETALLE_NIVEL'] = $this->input->post('detalle_nivel');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            if( $this->session->userdata('SIT_ID') == 22 ) {
                //$data['MUNI_ID']    = $this->input->post('municipio');
                //$data['ETB_CIUDAD'] = $this->input->post('ciudad');
				$data['ETB_MUNI_ID'] = $this->input->post('municipio');
				$data['ETB_DPTO_ID'] = $this->input->post('departamentos');
				
                $data['ETB_TELEFONO'] = $this->input->post('telefono');
            }

            if ($this->platc_model->establecimiento_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/establecimientos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('establecimientos_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('establecimientos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Recibe el id de un establecimiento y lo elimina.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimiento_eliminar($id) {
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            if ($this->platc_model->establecimiento_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la administracion de los usuarios.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuarios() {
        $this->index('usuarios/usuarios_view');
    }

    /**
     * Carga la lista con los usuarios del sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuarios_lista() {
        $this->data['usuarios'] = $this->platc_model->usuarios_get( $this->session->userdata('SIT_ID') );
        $this->index('usuarios/usuarios_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $roles = $this->platc_model->roles_get();
        $i = 0;
        foreach ($roles as $r) {
            $rol[$i]['id'] = $r['ROL_ID'];
            $rol[$i]['nombre'] = $this->lang->line('rol_' . $r['ROL_ID']);
            $i++;
        }
        $this->data['rol_select'] = $this->util->select_form_prepare($rol, 'id', 'nombre');

        if( $this->session->userdata('SIT_ID') == 22 ) {
            $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
            $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
            unset( $this->data['identificadores_select'][''] );    // Elimina elemento vacío
            $this->data['identificadores_validador'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_VALIDADOR');
            unset( $this->data['identificadores_validador'][''] );    // Elimina elemento vacío
        }

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes_select'] = $this->util->select_form_prepare($clientes, 'CLI_ID', 'CLI_NOMBRE');
        $this->index('usuarios/usuarios_agrega_view');
    }

    /**
     * Crea lista con todas las especialidades que tenga un site,
     * esto para poder crear un usuario con especialidades.
     *
     * @access public
     * @param  $idsite int Identificador del site al que pertenece la especialidad
     * @param  $idusu  int Identificador del usuario para completar datos del formulario
     * @return none
     */
    public function usuario_especialidades_site($idsite, $idusu = NULL) {
        $this->data['especialidades'] = $this->platc_model->especialidades_site_get($idsite);
        if ($idusu != NULL)
            $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($idusu);
        $this->index('usuarios/usuarios_especialidades_view');
    }

    /**
     * Carga la vista para la edicion de un usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['usuario'] = $this->platc_model->usuario_get($id);
        $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($id);

        if( $this->session->userdata('SIT_ID') == 22 ) {
            $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
            $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
            unset( $this->data['identificadores_select'][''] );    // Elimina elemento vacío
            $this->data['identificadores_validador'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_VALIDADOR');
            unset( $this->data['identificadores_validador'][''] );    // Elimina elemento vacío
            $this->data['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get($id);
        }

        $roles = $this->platc_model->roles_get();
        $i = 0;
        foreach ($roles as $r) {
            $rol[$i]['id'] = $r['ROL_ID'];
            $rol[$i]['nombre'] = $this->lang->line('rol_' . $r['ROL_ID']);
            $i++;
        }
        $this->data['rol_select'] = $this->util->select_form_prepare($rol, 'id', 'nombre');

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] )
            $clientes = $this->platc_model->clientes_get( );
        else
            $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        // imprimir($this->db->last_query());

        $this->data['clientes_select'] = $this->util->select_form_prepare($clientes, 'CLI_ID', 'CLI_NOMBRE');


        //NF432 - Elijo la vista de edicion usuario solo para perfil ATENCION_CLIENTE
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ATENCION_CLIENTE'] ){
            $this->index('usuarios/usuarios_edita_atencion_view');
        } else {
            $this->index('usuarios/usuarios_edita_view');
        }
            

    }

    /**
     * Desactiva un usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_desactivar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $data['USU_ID'] = $id;
        $data['USU_ACTIVO'] = '0';
        $this->platc_model->usuario_estado_upd($data);
        echo 'true';
    }

    /**
     * Activa un usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_activar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $data['USU_ID'] = $id;
        $data['USU_ACTIVO'] = '1';
        $this->platc_model->usuario_estado_upd($data);
        echo 'true';
    }

    /**
     * Recibe los parametros para la creacion de un nuevo usuario,
     * los valida y lo crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del usuario
     * @param string $_POST['email'] email del establecimiento
     * @param string $_POST['passwd'] password del usuario
     * @param string $_POST['passwdr'] la repeticion del password del usuario
     * @param int $_POST['rol'] rol del usuario
     * @param int $_POST['site'] site al que pertenece el usuario
     * @param int $_POST['grupo'] grupo al que pertenece el usuario
     * @param int $_POST['cliente'] cliente al que pertenece el usuario
     * @param int $_POST['establ'] establecimiento al que pertenece el usuario si es un generalista
     * @param array $_POST['especialidades'] especialidades al que pertenece el usuario si es un especialista
     * @return none
     */
    public function usuario_crea() {
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('passwd', '', 'required');
        $this->form_validation->set_rules('passwdr', '', 'required');
        $this->form_validation->set_rules('rol', '', 'required');

        if( $this->session->userdata('SIT_ID') == 22 ) {
            $this->form_validation->set_rules('identificador', '', 'required');
            $this->form_validation->set_rules('identificador_valor', '', 'required');
        }
        // Generalistas: necesita estar asociados a clientes
        // Especialistas: necesita estar asociados a especialidades
        // Revisor: no necesita estar asociado a nada
        if( $this->input->post('rol') == self::$ROL['MEDICO_GENERAL'] ||
            $this->input->post('rol') == self::$ROL['MEDICO_ASISTENTE'] ) {
            $data['CLI_ID'] = $this->input->post('cliente');
            $this->form_validation->set_rules('cliente', '', 'required');
        } else if( $this->input->post('rol') == self::$ROL['ESPECIALISTA'] )
            $this->form_validation->set_rules('especialidades', '', 'required');

        if( $this->form_validation->run() != FALSE &&
            $this->input->post('passwd') == $this->input->post('passwdr') &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) ) {
            $data['USU_NOMBRE']     = $this->input->post('nombre');
            $data['USU_EMAIL']      = $this->input->post('email');
            $data['USU_TELEFONO']   = $this->input->post('telefono');
            $data['USU_N_IDENTIFICACION'] = $this->input->post('n_identificacion');
            $data['USU_PASSWORD']   = md5($this->input->post('passwd'));
            $data['ROL_ID']         = $this->input->post('rol');
            $data['USU_NRO_REGISTRO'] = $this->input->post('nro_registro');
            $data['USU_SKYPE_ID']   = $this->input->post('cuenta_skype');
            $data['USU_ACTIVO']     = 1;
            $data['SIT_ID']         = $this->session->userdata('SIT_ID');

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $data['IDT_ID']         = $this->input->post('identificador');
                $data['IDT_VALOR']  = $this->input->post('identificador_valor');
            }

            // Lee archivo de imagen de firma
            $archivo_firma = $this->input->post('imagen_firma');
            if (!empty($archivo_firma)) {
                $nombre_archivo = 'uploads/' . $this->input->post('imagen_firma');
                $fp = fopen($nombre_archivo, 'r');
                $imagen = fread($fp, filesize($nombre_archivo));
                $imagen = base64_encode($imagen);
                fclose($fp);
                @unlink($nombre_archivo);
                $data['USU_FIRMA'] = $imagen;
            }

            $id_usu = NULL;
            if ($this->platc_model->site_identificadores_get($data['SIT_ID']) == NULL ||
                    $this->platc_model->site_afiliaciones_get($data['SIT_ID']) == NULL ||
                    $this->platc_model->especialidades_site_get($data['SIT_ID']) == NULL) {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('usuarios_error_2');
            } else {

                // Ingresa usuario
                $id_usu = $this->platc_model->usuario_set($data, null);
                switch ($id_usu) {

                    case 'ERROR1' : {
                            $resp['action'] = 'false';
                            $resp['msgt'] = $this->lang->line('error');
                            $resp['msg'] = $this->lang->line('usuarios_error_1');
                        };
                        break;

                    case FALSE : {
                            $resp['action'] = 'false';
                            $resp['msgt'] = $this->lang->line('error');
                            $resp['msg'] = $this->lang->line('usuarios_error');
                        };
                        break;

                    default : {
                            if ($data['ROL_ID'] == self::$ROL['ESPECIALISTA']) {
                                foreach ($this->input->post('especialidades') as $esp) {
                                    $dataesp['USU_ID'] = $id_usu;
                                    $dataesp['ESP_ID'] = $esp;
                                    $this->platc_model->usuario_especialidad_set_upd($dataesp);
                                }
                            }
                            $resp['action'] = 'true';
                            $resp['method'] = base_url() . 'platc/usuarios_lista/';
                            $resp['div'] = 'deploy_content';
                            $resp['msgt'] = 'OK';
                            $resp['msg'] = $this->lang->line('usuarios_ok');
                        };
                        break;
                }
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Recibe los parametros para la edicion de un usuario,
     * ya existente.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del usuario
     * @param string $_POST['nombre'] nombre del usuario
     * @param string $_POST['email'] email del establecimiento
     * @param string $_POST['passwd'] password del usuario
     * @param string $_POST['passwdr'] la repeticion del password del usuario
     * @param int $_POST['rol'] rol del usuario
     * @param int $_POST['grupo'] grupo al que pertenece el usuario
     * @param int $_POST['cliente'] cliente al que pertenece el usuario
     * @param int $_POST['establ'] establecimiento al que pertenece el usuario si es un generalista
     * @param array $_POST['especialidades'] especialidades al que pertenece el usuario si es un especialista
     * @return none
     */
    public function usuario_edita() {

        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('passwd', '', 'required');
        $this->form_validation->set_rules('passwdr', '', 'required');
        $this->form_validation->set_rules('rol', '', 'required');

        if( $this->session->userdata('SIT_ID') == 22 ) {

            $this->form_validation->set_rules('identificador', '', 'required');
            $this->form_validation->set_rules('identificador_valor', '', 'required');
        }

        if( $this->input->post('rol') == self::$ROL['MEDICO_GENERAL'] ||
            $this->input->post('rol') == self::$ROL['MEDICO_ASISTENTE'] || 
			$this->input->post('rol') == self::$ROL['ATENCION_CLIENTE'] ) {
            $this->form_validation->set_rules('cliente', '', 'required');
        } else if( $this->input->post('rol') == self::$ROL['ESPECIALISTA'] )
            $this->form_validation->set_rules('especialidades', '', 'required');

        if( $this->form_validation->run() != FALSE &&
            $this->input->post('passwd') == $this->input->post('passwdr') &&
            (int)$this->session->userdata('ROL_ID') < $this->input->post('rol') &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] )
            ) {
            $data['USU_ID'] = $this->input->post('id');
            $data['USU_NOMBRE'] = $this->input->post('nombre');
            $data['USU_EMAIL'] = $this->input->post('email');
            $data['USU_TELEFONO'] = $this->input->post('telefono');
            $data['USU_N_IDENTIFICACION'] = $this->input->post('n_identificacion');
            if ($this->input->post('passwd') != 'nocambiarestapassword')
                $data['USU_PASSWORD'] = md5($this->input->post('passwd'));
            $data['ROL_ID'] = $this->input->post('rol');

            if( $data['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] ||
                $data['ROL_ID'] == self::$ROL['MEDICO_ASISTENTE'] ||
				$data['ROL_ID'] == self::$ROL['ATENCION_CLIENTE'] )
                $data['CLI_ID'] = $this->input->post('cliente');

            $data['USU_NRO_REGISTRO'] = $this->input->post('nro_registro');
            $data['USU_SKYPE_ID']     = $this->input->post('cuenta_skype');

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $data['IDT_ID']         = $this->input->post('identificador');
                $data['IDT_VALOR']  = $this->input->post('identificador_valor');
            }

            // Lee archivo de imagen de firma
            $archivo_firma = $this->input->post('imagen_firma');
            if (!empty($archivo_firma)) {
                $nombre_archivo = 'uploads/' . $this->input->post('imagen_firma');
                $fp = fopen($nombre_archivo, 'r');
                $imagen = fread($fp, filesize($nombre_archivo));
                $imagen = base64_encode($imagen);
                fclose($fp);
                @unlink($nombre_archivo);
                $data['USU_FIRMA'] = $imagen;
            }

            if ($this->platc_model->usuario_upd($data, $this->input->post('grupo'))) {
                if ($data['ROL_ID'] == self::$ROL['ESPECIALISTA'] ) {
                    foreach ($this->input->post('especialidades') as $esp) {
                        $dataesp['USU_ID'] = $data['USU_ID'];
                        $dataesp['ESP_ID'] = $esp;
                        $this->platc_model->usuario_especialidad_set_upd($dataesp);
                    }
                }
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/usuarios_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('usuarios_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('usuarios_upd_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }


    public function usuario_edita_contrasenia(){ // NF432

        $contrasenia = $_POST['con1'];
        $id_usuario = $_POST['id_usuario'];


        if ( $contrasenia != 'nocambiarestapassword' ){
            $resp = $this->platc_model->usuario_edita_contrasenia($contrasenia, $id_usuario);
            return $resp;
        } else {
            echo "Los datos no fueron modificados.";
        }

    }

    /**
     * Página que permite subir el archivo de imagen que contiene
     * la firma del médico tratante.
     */
    public function usuario_subir_firma() {

        $error = '';

        if (!empty($_FILES)) {
            $config['upload_path'] = './uploads/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '800';
            $config['max_width'] = '200';
            $config['max_height'] = '70';
            $this->load->library('upload', $config);

            if ($this->upload->do_upload('firma')) {

                $datos = $this->upload->data();
                $info  = getimagesize( $datos['full_path'] );
                if( $info != FALSE && ( (int)$info[0] > 200 || (int)$info[1] > 70 ) ) {
                    $error = array('error' => $this->upload->display_errors());
                    $this->load->view('usuarios/usuarios_subir_firma', array('error' => $error));
                    return;
                }

                $ruta = explode('/', $datos['full_path']);
                array_pop($ruta);
                $ruta = implode('/', $ruta);
                $nombre_nuevo = $datos['raw_name'] . '_' . time() . $datos['file_ext'];

                rename($ruta . '/' . $datos['file_name'], $ruta . '/' . $nombre_nuevo);

                $retorno = '<script language="javascript" type="text/javascript">';
                $retorno.= 'window.opener.document.getElementById( "imagen_firma" ).value = "' . $nombre_nuevo . '" ;';
                $retorno.= 'window.close();';
                $retorno.= '</script>';

                exit($retorno);
            } else {
				//echo $this->upload->display_errors();
				//die();
                $error = array('error' => $this->upload->display_errors());
            }
        }

        $this->load->view('usuarios/usuarios_subir_firma', array('error' => $error));
    }

    /**
     * Elimina un usuario segun el ID recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_eliminar($id) {
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            if ($this->platc_model->usuario_del($id))
                echo 'true';
        }
    }

    /**
     * Carga las teleconsultas que un paciente tenga en el sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_paciente($pac_id, $est_id, $tc_id) {
        $this->data['teleconsultas'] = $this->platc_model->tc_paciente_get($pac_id, $tc_id);
        $this->data['est_id'] = $est_id;
        $this->data['tc_id'] = $tc_id;
        $this->index('tc_paciente_datagrid_view');
    }

    /**
     * Carga la vista para la administracion de pacientes.
     *
     * @access public
     * @param none
     * @return none
     */
    public function pacientes() {
        $this->index('pacientes_view');
    }

    /**
     * Lista los pacientes del sistema, esto segun el rol del usuario que esta,
     * trabajando.
     *
     * @access public
     * @param none
     * @return none
     */
    public function pacientes_lista() {
        $this->data['flag'] = FALSE;
        $this->index('pacientes_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo paciente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_crear() {
		//die;
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
       
	   

		
		
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        unset( $this->data['identificadores_select'][''] );    // Elimina elemento vacío
        $this->data['identificadores_validador'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_VALIDADOR');
        unset( $this->data['identificadores_validador'][''] );    // Elimina elemento vacío

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            $clientes = $this->platc_model->clientes_lista_get( );
            $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE');
            unset( $this->data['clientes_select'][''] );    // Elimina elemento vacío
        }

	    $afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'));
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
		unset( $this->data['afiliaciones_select'][''] );
		
		$departamentos = $this->platc_model->departamentos_m_list_get();
		$this->data['departamentos_select'] = $this->util->select_form_prepare( $departamentos, 'DPTO_ID', 'DPTO_NOMBRE');
		unset( $this->data['departamentos_select'][''] );    // Elimina elemento vacío

        $this->data['llamado'] = 'paciente';
		$this->data['config_cli_id'] = $this->config_cli_id;
        $this->index('pacientes_agrega_view');
    }

    /**
     * Carga la vista para la edicion de un paciente que ya existe recibiendo
     * el id de este por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['paciente'] = $this->platc_model->paciente_get($id);
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        unset( $this->data['identificadores_select'][''] );    // Elimina elemento vacío
        $this->data['identificadores_validador'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_VALIDADOR');
        unset( $this->data['identificadores_validador'][''] );    // Elimina elemento vacío
        $this->data['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get($id);
        
		$afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'));
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
		unset( $this->data['afiliaciones_select'][''] );    // Elimina elemento vacío
		
        $departamentos = $this->platc_model->departamentos_m_list_get();
		$this->data['departamentos_select'] = $this->util->select_form_prepare( $departamentos, 'DPTO_ID', 'DPTO_NOMBRE');
		unset( $this->data['departamentos_select'][''] );    // Elimina elemento vacío

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            $clientes = $this->platc_model->clientes_lista_get( );
            $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE');
            unset( $this->data['clientes_select'][''] );    // Elimina elemento vacío
        }

        $this->index('pacientes_edita_view');
    }

    /**
     * Carga grilla de las teleconsultas vinculadas via ajax.
     * Esta pagina usa funcionalidades escritas en "paciente_edita_view"
     *
     * @param type $id_paciente
     */
    public function paciente_teleconsultas_vinculadas_datagrid( $id_paciente ) {

        // TC vinculados/anteriores
        $this->data['tc_anteriores'] = $this->platc_model->tc_paciente_get( $id_paciente, null, array() );
        $this->index( 'tc_paciente_vinculadas_datagrid_view' );
    }

    /**
     * Desvincula teleconsulta de un paciente
     *
     * @param type $id_teleconsulta
     */
    public function paciente_desvincular_teleconsulta( $id_teleconsulta = NULL ) {

        if( $this->session->is_logged( ) )
            $this->platc_model->paciente_desvincular_teleconsulta( $id_teleconsulta );
    }

    /**
     * Carga grilla de las teleconsultas desvinculadas via ajax.
     * Esta pagina usa funcionalidades escritas en "paciente_edita_view"
     */
    public function paciente_teleconsultas_desvinculadas_datagrid( ) {

        // TC vinculados/anteriores
        $this->data['tc_desvinculadas'] = $this->platc_model->tc_desvinculadas( $this->session->userdata( 'SIT_ID' ) );
        $this->index( 'tc_desvinculadas_datagrid_view' );
    }

    /**
     * Desvincula teleconsulta de un paciente
     *
     * @param type $id_teleconsulta
     */
    public function paciente_vincular_teleconsulta( $id_teleconsulta = NULL, $id_paciente = NULL ) {

        if( $this->session->is_logged( ) )
            $this->platc_model->paciente_vincular_teleconsulta( $id_teleconsulta, $id_paciente );
    }

    /**
     * Recibe los parametros para la creacion de un paciente,
     * los valida y lo crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['afiliacion'] afiliacion del paciente
     * @param string $_POST['nombre1'] primer nombre del paciente
     * @param string $_POST['nombre2'] segundo nombre del paciente
     * @param string $_POST['apellido1'] primer apellido del paciente
     * @param string $_POST['apellido2'] segundo apellido del paciente
     * @param int $_POST['anno'] anno de nacimiento del paciente
     * @param int $_POST['mes'] mes de nacimiento del paciente
     * @param int $_POST['dia'] dia de nacimiento del paciente
     * @param string $_POST['sexo'] sexo del paciente (M o F)
     * @param string $_POST['procedencia'] procedenciadel paciente
     * @param string $_POST['ocupacion'] ocupacion del paciente
     * @param array $_POST['identificador'] arreglo con los diferentes identificadores del paciente
     * @return none
     */
    public function paciente_crea($serial_file_tmp = '') {

		
		if($serial_file_tmp){
			$newsession = array('session_pdf_temp' => $serial_file_tmp);
			$this->session->set_userdata($newsession);
		}
	
        $this->form_validation->set_rules('p_nombre1', '', 'required');
        $this->form_validation->set_rules('p_apellido1', '', 'required');
        $this->form_validation->set_rules('dia', '', 'required');
        $this->form_validation->set_rules('mes', '', 'required');
        $this->form_validation->set_rules('anno', '', 'required');
        $this->form_validation->set_rules('sexo', '', 'required');
        if(($this->session->userdata('CLI_ID') != $this->config_cli_id['sinergia'])) $this->form_validation->set_rules('telefono', '', 'required');
       // $this->form_validation->set_rules('afiliacion', '', 'required');
        $this->form_validation->set_rules('identificador', '', 'required');
        $this->form_validation->set_rules('identificador_valor', '', 'required');
		// $this->form_validation->set_rules('departamento', '', 'required');
		//  $this->form_validation->set_rules('municipio', '', 'required');
		
        if( $this->session->userdata( 'ROL_ID' )  < 3 )
            $this->form_validation->set_rules('cliente', '', 'required');

        // Campos obligatorios para Brasil
        if( $this->session->userdata('SIT_ID') == 21 ) {
            $this->form_validation->set_rules('p_nombre1_madre', '', 'required');
            $this->form_validation->set_rules('p_apellido1_madre', '', 'required');
        }

        if ($this->form_validation->run() != FALSE ) {
            $data['AFI_ID'] = $this->input->post('afiliacion');
			$data['EA_ID'] = $this->input->post('entidad_administra');
			$data['DEP_ID'] = $this->input->post('departamentos');
			$data['MUNI_ID'] = $this->input->post('municipio');
			//$data['DEP_ID_PROCEDENCIA'] = $this->input->post('depprocedencia');
			
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            $data['PAC_PRIMER_NOMBRE'] = $this->input->post('p_nombre1');
            $data['PAC_PRIMER_APELLIDO'] = $this->input->post('p_apellido1');
            $data['PAC_NACIMIENTO'] = $this->input->post('anno') . "-" . $this->input->post('mes') . "-" . $this->input->post('dia');
            $data['PAC_SEXO'] = $this->input->post('sexo');
            $data['PAC_TELEFONO'] = $this->input->post('telefono');
            $data['PAC_EMAIL'] = $this->input->post('email');
            $data['PAC_PROCEDENCIA'] = $this->input->post('procedencia');
            $data['PAC_OCUPACION'] = $this->input->post('ocupacion');
            $data['PAC_ACTIVO'] = 1;
            if( $this->session->userdata( 'ROL_ID' )  < 3 )
                $data['CLI_ID'] = $this->input->post( 'cliente' );
            else
                $data['CLI_ID'] = $this->session->userdata('CLI_ID');

            // Campos obligatorios para Brasil
            if( $this->session->userdata('SIT_ID') == 21 ) {
                $data['PAC_NOMBRE_MADRE']   = $this->input->post('p_nombre1_madre');
                $data['PAC_APELLIDO_MADRE'] = $this->input->post('p_apellido1_madre');
            } else {
                $data['PAC_SEGUNDO_NOMBRE'] = $this->input->post('p_nombre2');
                $data['PAC_SEGUNDO_APELLIDO'] = $this->input->post('p_apellido2');
            }


            $data2 = array();
            $data2[0]['IDT_ID'] = $this->input->post('identificador');
            $data2[0]['PAC_IDT_VALOR'] = $this->input->post('identificador_valor');

            $usu_id = $this->platc_model->paciente_set($data, $data2);
            if (is_numeric($usu_id)) {
                if ($this->input->post('tc') == true) {
                    $resp['action'] = 'true';
                    $resp['method'] = base_url() . 'platc/tc_nueva/' . $usu_id . '/';
                    $resp['div'] = 'deploy_content';
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('pacientes_ok');
                } else {
                    $resp['action'] = 'true';
                    $resp['method'] = base_url() . 'platc/paciente_listado/';
                    $resp['div'] = 'deploy';
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('pacientes_ok');
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('pacientes_error');
            }
            /* 			}
              else {
              $resp['action'] = 'false';
              $resp['msgt'] = $this->lang->line('error');
              $resp['msg'] = $this->lang->line('pacientes_ident_error');
              } */
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Recibe los parametros para la edicion de un paciente,
     * los valida y edita.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del paciente
     * @param int $_POST['afiliacion'] afiliacion del paciente
     * @param string $_POST['nombre1'] primer nombre del paciente
     * @param string $_POST['nombre2'] segundo nombre del paciente
     * @param string $_POST['apellido1'] primer apellido del paciente
     * @param string $_POST['apellido2'] segundo apellido del paciente
     * @param int $_POST['anno'] anno de nacimiento del paciente
     * @param int $_POST['mes'] mes de nacimiento del paciente
     * @param int $_POST['dia'] dia de nacimiento del paciente
     * @param string $_POST['sexo'] sexo del paciente (M o F)
     * @param string $_POST['procedencia'] procedenciadel paciente
     * @param string $_POST['ocupacion'] ocupacion del paciente
     * @param array $_POST['identificador'] arreglo con los diferentes identificadores del paciente

     * @return none
     */
    public function paciente_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('afiliacion', '', 'required');
        $this->form_validation->set_rules('p_nombre1', '', 'required');
        $this->form_validation->set_rules('p_apellido1', '', 'required');
        $this->form_validation->set_rules('anno', '', 'required');
        $this->form_validation->set_rules('mes', '', 'required');
        $this->form_validation->set_rules('dia', '', 'required');
        $this->form_validation->set_rules('sexo', '', 'required');
        $this->form_validation->set_rules('telefono', '', 'required');
        $this->form_validation->set_rules('identificador', '', 'required');
        $this->form_validation->set_rules('identificador_valor', '', 'required');

        if( $this->session->userdata( 'ROL_ID' ) < 3 )
            $this->form_validation->set_rules('cliente', '', 'required');

        // Campos obligatorios para Brasil
        if( $this->session->userdata('SIT_ID') == 21 ) {
            $this->form_validation->set_rules('p_nombre1_madre', '', 'required');
            $this->form_validation->set_rules('p_apellido1_madre', '', 'required');
        }

        if( $this->form_validation->run() != FALSE &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] )
            ) {
            $data['PAC_ID'] = $this->input->post('id');

			$data['AFI_ID'] = $this->input->post('afiliacion');
			$data['EA_ID'] = $this->input->post('entidad_administra');
			$data['DEP_ID'] = $this->input->post('departamentos');
			$data['MUNI_ID'] = $this->input->post('municipio');
			//$data['DEP_ID_PROCEDENCIA'] = $this->input->post('depprocedencia');
			
            $data['PAC_PRIMER_NOMBRE'] = $this->input->post('p_nombre1');
            $data['PAC_PRIMER_APELLIDO'] = $this->input->post('p_apellido1');
            $data['PAC_NACIMIENTO'] = $this->input->post('anno') . "-" . $this->input->post('mes') . "-" . $this->input->post('dia');
            $data['PAC_SEXO'] = $this->input->post('sexo');
            $data['PAC_TELEFONO'] = $this->input->post('telefono');
            $data['PAC_EMAIL'] = $this->input->post('email');
            $data['PAC_PROCEDENCIA'] = $this->input->post('procedencia');
            $data['PAC_OCUPACION'] = $this->input->post('ocupacion');
            $data2[0]['IDT_ID'] = $this->input->post('identificador');
            $data2[0]['PAC_IDT_VALOR'] = $this->input->post('identificador_valor');
            if( $this->session->userdata( 'ROL_ID' ) < 3 )
                $data['CLI_ID'] = $this->input->post( 'cliente' );
            else
                $data['CLI_ID'] = $this->session->userdata('CLI_ID');

            // Campos obligatorios para Brasil
            if( $this->session->userdata('SIT_ID') == 21 ) {
                $data['PAC_NOMBRE_MADRE']   = $this->input->post('p_nombre1_madre');
                $data['PAC_APELLIDO_MADRE'] = $this->input->post('p_apellido1_madre');
            } else {
                $data['PAC_SEGUNDO_NOMBRE'] = $this->input->post('p_nombre2');
                $data['PAC_SEGUNDO_APELLIDO'] = $this->input->post('p_apellido2');
            }

            if ($this->platc_model->paciente_upd($data, $data2)) {

                $this->platc_model->paciente_upd_tc_vinculadas( $data['PAC_ID'], $data, $data2[0] );

                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/paciente_listado/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('pacientes_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('pacientes_error');
            }

        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina a un paciente del sistema recibiendo por GET,
     * el ID de este.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_desactivar( $id ) {

        if ((int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ) {
            if ($this->platc_model->paciente_desactivar($id))
                echo 'true';
            else
                echo 'false';
        }
    }

    public function paciente_listado( )  {

        $this->index( 'paciente_listado_view' );
    }

    /**
     * Metodo que obtiene todos los pacientes del sistema según el site
     * del Administrador
     *
     * @access public
     * @param none
     * @return array Todos los pacientes del site
     */
    public function paciente_listado_datagrid() {

        $this->data['paciente_admin'] = $this->platc_model->paciente_listar( $this->session->userdata('SIT_ID'), (int)$this->session->userdata('ROL_ID') );
        $this->index('paciente_listado_datagrid_view');
    }

    /**
     * Realiza búsqueda de municipio para autocompletar campos de formularios
     */
    public function municipio_autocomplete( $texto )  {

        $municipios = array( );

        if( !empty( $texto ) ) {

            $listado_municipios = $this->platc_model->municipio_busqueda_por_texto( $texto );

            if( !empty( $listado_municipios ) )
                foreach( $listado_municipios as $valor ) {
                    $municipios[] = array( 'label' => $valor['MUNI_NOMBRE'], 'value' => $valor['MUNI_ID'] );
                }
        }

        $this->output->set_output( json_encode( $municipios ) );
    }

    /**
     * Retorna información de un municipio
     */
    public function municipio_get_por_id( )  {

        $id_municipio = $this->input->get( 'id_municipio' );
        if( !empty( $id_municipio ) ) {

            $this->output->set_output( json_encode( $this->platc_model->municipio_get( $id_municipio ) ) );
        }
    }

    /**
     * Carga la vista para la administracion de,
     * las afilicaciones de un site
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliaciones() {
        $this->index('afiliaciones_view');
    }

    /**
     * Crea una lista con todas las afiliacionde del sistema o del site,
     * segun el rol.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliaciones_lista() {
        $this->data['afiliaciones'] = $this->platc_model->afiliaciones_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('afiliaciones_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de una nueva afiliacion.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliacion_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->index('afiliaciones_agrega_view');
    }

    /**
     * Recibe los parametros para la creacion de una nueva afiliacion,
     * los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre de la afiliacion
     * @param string $_POST['descripcion'] descripcion de la afiliacion
     * @param int $_POST['site'] site de la afiliacion
     * @return none
     */
    public function afiliacion_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['AFI_NOMBRE'] = $this->input->post('nombre');
            $data['AFI_DESCRIPCION'] = $this->input->post('descripcion');
			$data['AFI_ACTIVO'] = $this->input->post('status');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            if ($this->platc_model->afiliacion_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/afiliaciones_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('afiliaciones_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('afiliaciones_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de una afiliacion,
     * recibiendo el id de este por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliacion_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['afiliacion'] = $this->platc_model->afiliacion_get($id);
        $this->index('afiliaciones_edita_view');
    }

    /**
     * Recibe los parametros para la edicion de una afiliacion ya existente,
     * los valida y edita la afiliacion.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la afiliacion
     * @param string $_POST['nombre'] nombre de la afiliacion
     * @param string $_POST['descripcion'] descripcion de la afiliacion
     * @return none
     */
    public function afiliacion_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['AFI_ID'] = $this->input->post('id');
            $data['AFI_NOMBRE'] = $this->input->post('nombre');
            $data['AFI_DESCRIPCION'] = $this->input->post('descripcion');
			$data['AFI_ACTIVO'] = $this->input->post('status');
            if ($this->platc_model->afiliacion_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/afiliaciones_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('afiliaciones_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('afiliaciones_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina una afiliacion recibiendo el ID de esta por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliacion_eliminar($id) {
        if ((int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            if ($this->platc_model->afiliacion_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la administracion de especialidades.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades() {
        $this->index('especialidades_view');
    }

    /**
     * Lista todas las especialidades que hayan segun el tipo de usuario,
     * si es admin lista todas, si es supervisor solo lista las del site que
     * le corresponde.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_lista() {
        $this->data['especialidades'] = $this->platc_model->especialidades_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('especialidades_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de una nueva especialidad
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidad_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->index('especialidades_agrega_view');
    }

    /**
     * Recibe los parametros de la especialidad,
     * los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre de la especialidad
     * @param string $_POST['descripcion'] descripcion de la especialidad
     * @param int $_POST['site'] site de la especialidad
     * @return none
     */
    public function especialidad_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('sexo', '', 'required');

        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['ESP_NOMBRE'] = $this->input->post('nombre');
            $data['ESP_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            $sexo = $this->input->post('sexo');

            if( empty( $sexo ) || count( $sexo ) > 1 )
                $data['ESP_GENERO'] = NULL;

            if( count( $sexo ) == 1  ) {
                switch ( $sexo[0] ) {
                    case 'M' : $data['ESP_GENERO'] = 'M'; break;
                    case 'F' : $data['ESP_GENERO'] = 'F'; break;
                    default  : $data['ESP_GENERO'] = NULL;
                }
            }

            if ($this->platc_model->especialidad_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/especialidades_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('especialidades_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('especialidades_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de una especialidad,
     * recibiendo por GET el ID de esta.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidad_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['especialidad'] = $this->platc_model->especialidad_get($id);
        $this->index('especialidades_edita_view');
    }

    /**
     * Recibe los parametros de la especialidad a editar,
     * los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la especialidad
     * @param string $_POST['nombre'] nombre de la especialidad
     * @param string $_POST['descripcion'] descripcion de la especialidad
     * @return none
     */
    public function especialidad_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('sexo', '', 'required');
        $this->form_validation->set_rules('site', '', 'required');

        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['ESP_ID'] = $this->input->post('id');
            $data['ESP_NOMBRE'] = $this->input->post('nombre');
            $data['ESP_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->input->post('site');
            $sexo = $this->input->post('sexo');

            if( empty( $sexo ) || count( $sexo ) > 1  )
                $data['ESP_GENERO'] = NULL;

            if( count( $sexo ) == 1  ) {
                switch ( $sexo[0] ) {
                    case 'M' : $data['ESP_GENERO'] = 'M'; break;
                    case 'F' : $data['ESP_GENERO'] = 'F'; break;
                    default  : $data['ESP_GENERO'] = NULL;
                }
            }

            if ($this->platc_model->especialidad_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/especialidades_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('especialidades_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('especialidades_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina una especialidad segun el ID de esta
     * recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidad_eliminar($id) {
        if ((int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            if ($this->platc_model->especialidad_del($id))
                echo 'true';
            else
                echo 'false';
        }
    }

    /**
     * Carga la vista para la administracion de identificadores.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificadores() {
        $this->index('identificadores_view');
    }

    /**
     * Lista todos los identificadores del sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificadores_lista() {
        $this->data['identificadores'] = $this->platc_model->identificadores_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('identificadores_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un
     * nuevo identificador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificador_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->index('identificadores_agrega_view');
    }

    /**
     * Recibe los parametros para la creacion de un
     * nuevo identificador, los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del identificador
     * @param string $_POST['descripcion'] descripcion del identificador
     * @param int $_POST['site'] site del identificador
     * @return none
     */
    public function identificador_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['IDT_NOMBRE'] = $this->input->post('nombre');
            $data['IDT_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            if ($this->platc_model->identificador_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/identificadores_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('identificadores_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('identificadores_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un identificador,
     * segun el ID de este recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificador_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['identificador'] = $this->platc_model->identificador_get($id);
        $this->index('identificadores_edita_view');
    }

    /**
     * Recibe los parametros para la edicion de un identificador
     * ya existente, los valida y edita.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del identificador
     * @param string $_POST['nombre'] nombre del identificador
     * @param string $_POST['descripcion'] descripcion del identificador
     * @return none
     */
    public function identificador_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            $data['IDT_ID'] = $this->input->post('id');
            $data['IDT_NOMBRE'] = $this->input->post('nombre');
            $data['IDT_DESCRIPCION'] = $this->input->post('descripcion');
            if ($this->platc_model->identificador_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/identificadores_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('identificadores_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('identificadores_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina un identificador segun el
     * ID recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificador_eliminar($id) {
        if ((int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN']) {
            if ($this->platc_model->identificador_del($id))
                echo 'true';
        }
    }

    /**
     * Devuelve el metodo para mostrar la TC segun el estado
     * en que esta se encuentre.
     *
     * @access private
     * @param none
     * @return none
     */
    private function tc_metodo_view($estado) {
        if ($estado == 1)
            $metodo = 'tc_borrador_editar';
        else if ($estado == 2)
            $metodo = 'tc_enviada_responder';
        else if ($estado == 3)
            $metodo = 'tc_rechazadas_view';
        else if ($estado == 4)
            $metodo = 'tc_eliminada_view';
        else if ($estado == 5)
            $metodo = 'tc_exsol_responder';
        else if ($estado == 6)
            $metodo = 'tc_exreal_responder';
        else if ($estado == 7)
            $metodo = 'tc_contestadas_view';
        else
            $metodo = NULL;
        return $metodo;
    }

    /**
     * Metodo que es llamado desde el menu de usuario y sirve
     * para traer el listado de las teleconsultas segun el estado
     * en que se encuentren.
     *
     * @access public
     * @param int $estado estado la de la TC
     * @param string $view vista que se desplegara
     * @return none
     */
    public function tc_lista_view($estado, $view = NULL) {
        $this->data['reload_view'] = $view;
        $this->data['titulo'] = $this->tc_title($estado);
        $this->data['estado'] = $estado;
        $this->data['metodo'] = 'tc_lista';
        $this->data['tc_id'] = '';
        $this->index('tc_view');
    }

    /**
     * Muestra la TC segun el id y estado.
     *
     * @access public
     * @param int $estado estado de la TC
     * @param int $tc_id ID de la TC
     * @return none
     */
    public function tc_view($estado, $tc_id, $view = NULL, $tc_view = NULL, $est_ant = NULL, $id_ant = NULL) {
        if ($tc_view == 'false')
            $data['tc_paciente_view'] = FALSE;
        else if ($tc_view == 'cache')
            $data['tc_paciente_view'] = 'cache';
        else
            $data['tc_paciente_view'] = TRUE;
        $data['tc_paciente_estado'] = $est_ant;
        $data['tc_paciente_id'] = $id_ant;
        $this->session->set_userdata($data);
        $this->data['reload_view'] = $view;
        $this->data['titulo'] = $this->tc_title($estado, TRUE);
        $this->data['estado'] = $estado;
        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['tc_id'] = $tc_id;
        $this->index('tc_view');
    }

    /**
     * Saca el titulo del archivo de lengua para los diferentes
     * estados de la TC, ya sea singular o plural
     * dependiendo de si se esta viendo la lista de TC o una en
     * particular.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_title($estado, $singular = FALSE) {
        if ($estado == 1 && $singular == FALSE)
            return $this->lang->line('tc_borradores_title');
        else if ($estado == 1 && $singular = TRUE)
            return $this->lang->line('tc_borrador_title');

        if ($estado == 2 && $singular == FALSE) {
            if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
                (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] )
                return $this->lang->line('tc_enviadas_title');
            else
                return $this->lang->line('tc_nuevas_title');
        }
        else if ($estado == 2 && $singular == TRUE) {
            if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
                (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ||
                (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] )
                return $this->lang->line('tc_enviada_title');
            else
                return $this->lang->line('tc_nueva_title');
        }
        if ($estado == 3 && $singular == FALSE)
            return $this->lang->line('tc_rechazadas_title');
        else if ($estado == 3 && $singular = TRUE)
            return $this->lang->line('tc_rechazada_title');

        if ($estado == 4 && $singular == FALSE)
            return $this->lang->line('tc_eliminadas_title');
        else if ($estado == 4 && $singular = TRUE)
            return $this->lang->line('tc_eliminada_title');

        if ($estado == 5 && $singular == FALSE)
            return $this->lang->line('tc_exsols_title');
        else if ($estado == 5 && $singular = TRUE)
            return $this->lang->line('tc_exsol_title');

        if ($estado == 6 && $singular == FALSE)
            return $this->lang->line('tc_exreals_title');
        else if ($estado == 6 && $singular = TRUE)
            return $this->lang->line('tc_exreal_title');

        if ($estado == 7 && $singular == FALSE)
            return $this->lang->line('tc_contestadas_title');
        else if ($estado == 7 && $singular = TRUE)
            return $this->lang->line('tc_contestada_title');
    }

    /**
     * Metodo que llama a un WebService de la PIT con el identificador
     * del paciente para ver los examenes que tenga en esta.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_examenes_get($id_pac, $id_site) {
        $this->data['examenes_pit'] = $this->util->get_pit_ex($id_pac, $id_site);
        $this->index('tc_examenes_pit_view');
    }

    /**
     * Valida al usuario que quiere enviar la TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_valida_usuario($pass) {
        $passval = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($pass));
        if ($passval != FALSE)
            echo 'true';
        else
            echo 'false';
    }

    /**
     * Carga la vista para la creacion de una
     * nueva TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_crear($cache = '') {
        if ($cache == 'true')
            $this->data['flag'] = TRUE;
        else
            $this->data['flag'] = FALSE;
        $this->index('tc_crear_view');
    }

    /**
     * Busca a un paciente por el identificador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_busca_id() {
        $id= $this->input->post('id');
        $resp= $this->input->post('resp');
        if ($id != '' )
			if(in_array((int)$this->session->userdata('ROL_ID'),array((int)self::$ROL['ATENCION_CLIENTE']))){
				$this->data['pacientes'] = $this->platc_model->pacientes_buscar_id_por_rol($id, $this->session->userdata( 'SIT_ID' ) );
			}
			else{
				$this->data['pacientes'] = $this->platc_model->pacientes_buscar_id($id, $this->session->userdata( 'SIT_ID' ) );
			}
        else
            $this->data['pacientes'] = NULL;
        $data['busqueda'] = $this->data['pacientes'];
        $this->session->set_userdata($data);
        if ($resp == 1)
            $this->index('tc_crear_resultado_busqueda_view');
        else if ($resp == 2)
            $this->index('pacientes_resultado_busqueda_view');
    }

    /**
     * Busca a un paciente por el nombre y/o apellido.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_busca_na() {
        $nombre     = $this->input->post('nombre');
        $apellido   = $this->input->post('apellido');
        $resp       = $this->input->post('resp');

		if(in_array((int)$this->session->userdata('ROL_ID'),array((int)self::$ROL['ATENCION_CLIENTE']))){
			$this->data['pacientes'] = $this->platc_model->pacientes_buscar_na_por_rol($nombre, $apellido, $this->session->userdata( 'SIT_ID' ) );
		}
		else{
			$this->data['pacientes'] = $this->platc_model->pacientes_buscar_na($nombre, $apellido, $this->session->userdata( 'SIT_ID' ) );
		}
        $this->session->set_userdata( array( 'busqueda_nombre' => $nombre, 'busqueda_apellido' => $apellido  ) );

        if ($resp == 1)
            $this->index('tc_crear_resultado_busqueda_view');
        else if ($resp == 2)
            $this->index('pacientes_resultado_busqueda_view');
    }

    /**
     * Carga la vista para la creacion de una TC buscando al
     * paciente o creando uno nuevo.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_crear_pacientes_lista($cache = '') {

        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
		if(in_array((int)$this->session->userdata('ROL_ID'),array((int)self::$ROL['ATENCION_CLIENTE']))){
			$this->data['pacientes'] = $this->platc_model->pacientes_get_por_rol();	
		}
		else{
			$this->data['pacientes'] = $this->platc_model->pacientes_get();
		}
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        if ($cache == 'true')
            $this->data['flag'] = TRUE;
        else
            $this->data['flag'] = FALSE;

        $this->index('tc_crear_pacientes_datagrid_view');
    }

    /**
     * Carga el cache de una busqueda ya hecha.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_busqueda_cache() {
        $nombre     = $this->session->userdata('busqueda_nombre');
        $apellido   = $this->session->userdata('busqueda_apellido');
        $this->data['pacientes'] = $this->platc_model->pacientes_buscar_na($nombre, $apellido, $this->session->userdata( 'SIT_ID' ) );
        $this->index('tc_crear_resultado_busqueda_view');
    }
    
	/**
     * Carga e importacion de archivo de paciente
     *
     * @access public
     * @param none
     * @return none
     */
	public function tc_import_paciente() {
	
	   $this->index('pacientes_import_view');
	}
    
	
	/**
     * Carga la vista para la creacion de un paciente y luego
     * la creacion de una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_crear_paciente($rand = '', $serial_file_tmp = '') {
		
		//die();
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select']  = $this->util->select_form_prepare_dias();

        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        unset( $this->data['identificadores_select'][''] );    // Elimina elemento vacío

        $this->data['identificadores_validador'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_VALIDADOR');
        unset( $this->data['identificadores_validador'][''] );    // Elimina elemento vacío

		//NF514
		$cod_afiliacion = "";
		$result = $this->cliente_model->afiliacion(array('AC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_afiliacion[] = $row['AC_AFI_ID'];
			}
		}
		$this->data['config_cli_id'] = $this->config_cli_id;
		//FIN
        $afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'), $cod_afiliacion);
		
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
	  $afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'));
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
		
		$departamentos = $this->platc_model->departamentos_m_list_get();
		$this->data['departamentos_select'] = $this->util->select_form_prepare( $departamentos, 'DPTO_ID', 'DPTO_NOMBRE');
		unset( $this->data['departamentos_select'][''] );    // Elimina elemento vací
		

        $this->data['llamado'] = 'tc';
		
		$this->data['serial_file_tmp'] = $serial_file_tmp;
		
        $this->index('pacientes_agrega_view');
    }

    /**
     * Prepara el select con el lenguaje correspondientes para las prioridades
     * de las TC.
     *
     * @access private
     * @param none
     * @return none
     */
    private function tc_prioridades_select($ids = '') {
        $this->lang->load($this->session->userdata('IDI_NOMBRE')."_".$this->session->userdata('SIT_PAIS'), $this->session->userdata('IDI_NOMBRE'));
        $prioridades = $this->platc_model->prioridades_get($ids);
        $i = 0;
        foreach ($prioridades as $prioridad) {
            $p[$i]['PRI_ID'] = $prioridad['PRI_ID'];
            $p[$i]['PRI_NOMBRE'] = $this->lang->line('prioridad_' . $prioridad['PRI_ID']);
            $i++;
        }
        return $this->util->select_form_prepare($p, 'PRI_ID', 'PRI_NOMBRE');
    }

    /**
     * Carga la vista para la creacion de una nueva TC segun
     * el ID del paciente recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_nueva($id, $rand = '', $serial_file_tmp = '') {
		
		$this->load->model('cliente_model');

        $establecimientos = $this->platc_model->establs_cliente_get($this->session->userdata('CLI_ID'));
        // imprimir( $this->db->last_query());
        if( !empty( $establecimientos ) )
            $this->data['establecimiento_select'] = $this->util->select_form_prepare( $establecimientos, 'ETB_ID', 'ETB_NOMBRE');
        else
            $this->data['establecimiento_select'] = array( );



        // Datos del paciente
        $this->data['paciente'] = $this->platc_model->paciente_get($id);
	$this->data['paciente']['PAC_EDAD'] = ($this->data['paciente']['PAC_NACIMIENTO'] && date_create($this->data['paciente']['PAC_NACIMIENTO'])) ? $this->util->yearscalc($this->data['paciente']['PAC_NACIMIENTO']) : "";
        //$this->data['paciente']['PAC_EDAD'] = $this->util->yearscalc($this->data['paciente']['PAC_NACIMIENTO']);
        $this->data['identificadores']      = $this->platc_model->ident_get($id);
     $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['PAC_IDT_VALOR'] );

        // Listado de especialidades disponibles (en función del grupo asociado) y si el genero del paciente lo necesita
        $especialidades = $this->platc_model->especialidades_por_cliente( $this->session->userdata('CLI_ID'), $this->data['paciente']['PAC_SEXO'] );
        if( !empty( $especialidades ) )
            $this->data['especialidades_select'] = $this->util->select_form_prepare( $especialidades, 'ESP_ID', 'ESP_NOMBRE');
        else
            $this->data['especialidades_select'] = array( );

        /*
         * Listado de Medicos Generalistas asociados a la TC
         */
            // [CL - CO] Asistente establece asignación a medico generalista de la TC con su respectivo establecimiento
        if( $this->session->userdata('SIT_ID') == 22 || $this->session->userdata('SIT_ID') == 2 ) {
            $medicos_generalistas = $this->platc_model->usuarios_por_rol( 4, (int)$this->session->userdata('SIT_ID'), TRUE, $this->session->userdata( 'CLI_ID' ) );
            $this->data['medico_general_select'] = $this->util->select_form_prepare( $medicos_generalistas, 'USU_ID', 'USU_NOMBRE' );
        } else {
            $this->data['medico_general_select'] = array( );
        }

		//NF514
		$this->data['config_cli_id'] = $this->config_cli_id;
		$cod_afiliacion = "";
		$result = $this->cliente_model->afiliacion(array('AC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_afiliacion[] = $row['AC_AFI_ID'];
			}
		}
		$cod_entidad_adm = "";
		$result = $this->cliente_model->ent_adm(array('EAC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_entidad_adm[] = $row['EAC_ENTADM_ID'];
			}
		}
		$cod_amb_proc = "";
		$result = $this->cliente_model->amb_proc(array('APC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_amb_proc[] = $row['APC_AMBPROC_ID'];
			}
		}
		$cod_municipio = "";
		$result = $this->cliente_model->municipio(array('MC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_municipio[] = $row['MC_MUNI_ID'];
			}
		}
		$cod_prioridad = "";
		$result = $this->cliente_model->prioridad(array('PC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_prioridad[] = $row['PC_PRI_ID'];
			}
		}
		//FIN
		
		$this->data['prioridades_select'] = $this->tc_prioridades_select($cod_prioridad);
		
        // Campos RIPS
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $ent_administradoras = $this->platc_model->entidades_administradoras__con_codigo_get($cod_entidad_adm);
            $this->data['ent_admnistradoras_select'] = $this->util->select_form_prepare( $ent_administradoras, 'ENTADM_ID', 'ENTADM_NOMBRE' );

            $finalidad_procedimiento = $this->platc_model->finalidad_procedimiento_get( );
            $this->data['finalidad_procedimiento_select'] = $this->util->select_form_prepare( $finalidad_procedimiento, 'FINPROC_ID', 'FINPROC_DESCRIPCION' );

            $ambito_procedimiento = $this->platc_model->ambito_procedimiento_get($cod_amb_proc);
            $this->data['ambito_procedimiento_select'] = $this->util->select_form_prepare( $ambito_procedimiento, 'AMBPROC_ID', 'AMBPROC_DESCRIPCION' );

            $zona_residencia = $this->platc_model->zona_residencia_get( );
            $this->data['zona_residencia_select'] = $this->util->select_form_prepare( $zona_residencia, 'ZON_ID', 'ZON_NOMBRE' );

            $municipio = $this->platc_model->municipios_get($cod_municipio);
            $this->data['municipio_select'] = $this->util->select_form_prepare( $municipio, 'MUNI_ID', 'MUNI_NOMBRECOMPLETO' );
        }
		$this->data['afiliaciones'] = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'),$cod_afiliacion);
		
		//	JV 25-09-2015
		//	OBTENEMOS TODOS LOS DEPARTAMENTOS Y MUNICIPIO
		
		$departamentos = $this->platc_model->departamentos_m_list_get();
		$this->data['departamentos_select'] = $this->util->select_form_prepare( $departamentos, 'DPTO_ID', 'DPTO_NOMBRE');
		unset( $this->data['departamentos_select'][''] );    // Elimina elemento vacío
		
		//JV FIN
		
		// sacamos nombre segun nueva estructura
		$departamento_name = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$this->data['paciente']['DEP_ID']);
		$this->data['departamento_name']=$departamento_name;
		$municipio_name    = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$this->data['paciente']['MUNI_ID']);
		$this->data['municipio_name']=$municipio_name;
		//$procedencia_name  = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$this->data['paciente']['DEP_ID_PROCEDENCIA']);
		//$this->data['procedencia_name']=$procedencia_name;
		$entidadadm_name   = $this->platc_model->get_info_table_param('TC_ENTIDADES_ADMINISTRADORAS','ENTADM_CORR',$this->data['paciente']['EA_ID']);
		$this->data['entidadadm_name']=$entidadadm_name;
		
		
		
		if(!$serial_file_tmp){
			$serial_file_tmp = ($this->session->userdata('session_pdf_temp')) ? $this->session->userdata('session_pdf_temp') : "";
			$this->session->unset_userdata('session_pdf_temp');
		}
			
		$this->data['serial_file_tmp'] = $serial_file_tmp;
        $this->index('tc_nueva_view');
    }

    /**
     * Metodo que es llamado para desplegar todas las TC
     * segun el estado que es pasada con la variable $estado.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_datagrid($estado) {
        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        
        if( $estado == 7 || $estado == 9 )
            $this->data['teleconsultas'] = $this->platc_model->tc_lista_get($estado, '', 100 );
        else
            $this->data['teleconsultas'] = $this->platc_model->tc_lista_get($estado );

        $this->index('tc_datagrid_view');
    }

    /**
     * Busca una teleconsulta segun el estado y el id de esta,
     * que son parametros recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_busca_tcid($estado, $id) {
        $id = str_replace('-', '', $id);
        if ($id != ''){
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_tcid($id, $estado);
        } else
            $this->data['teleconsultas'] = NULL;

        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }

    /**
     * Busca una teleconsulta segun el estado y el id del paciente,
     * que son parametros recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_busca_id($estado, $id = '') {

        $id = trim( $id, '-');

        if ($id != '')
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_id($id, $estado);
        else
            $this->data['teleconsultas'] = NULL;

        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }

    /**
     * Busca una teleconsultas segun nombre y/o apellido del paciente
     * que son parametros recibidos por GET (busca hacer match con los datos).
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_busca_na($estado, $nombre = '', $apellido = '') {
        $nombre = str_replace('-', '', $nombre);
        $apellido = str_replace('-', '', $apellido);
        if (is_numeric($nombre))
            $nombre = '';
        if (is_numeric($apellido))
            $apellido = '';
        if ($nombre != '' || $apellido != '')
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_na( $estado, $nombre, $apellido );
        else
            $this->data['teleconsultas'] = NULL;
        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }
	
    public function tc_busca_etb($estado, $etb) {
        if ($etb != ''){
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_etb($etb, $estado);
        } else
            $this->data['teleconsultas'] = NULL;

        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }

    /**
     * Carga la vista para la visualizaion de las TC
     * que se encuentran en estado "Contestadas".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_contestadas_view($estado = NULL, $id) {
		//NF514
		$this->load->model('teleconsulta_model');
		if($this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL']){
			//Obtengo registro TC
			$tel = $this->teleconsulta_model->select(array('TEL_ID' => $id));
			//Actualizo registro TC
			$arrGral = "";
			if($tel){
				$arrGral = $tel['TEL_VISTO_POR_GENERALISTA'];
			}
			if(!in_array($this->session->userdata('USU_ID'),explode(',',$arrGral))){
				$arrGral = (!$arrGral) ? $this->session->userdata('USU_ID') : $arrGral.','.$this->session->userdata('USU_ID');
				$arrGral = explode(',',$arrGral);
				$update = array(
					'TEL_VISTO_POR_GENERALISTA' => implode(',',$arrGral)
				);
				$this->teleconsulta_model->update(array('TEL_ID' => $id),$update);
			}
		}
		//FIN

        $this->load->library( 'HtmlPurifierWrapper' );
        $htmlpurifier = $this->htmlpurifierwrapper->HtmlPurifierFactory();

        // Obtiene teleconsulta
        // Genera parte paciente y datos de la TC
        $this->data['tc'] = $this->platc_model->tc_get($id);
		
		//SI641 Corrige TC contestadas para la visualizacion
		if(!empty($this->data['tc']) && is_array($this->data['tc'])){
			foreach($this->data['tc'] as $key => &$col){
				if(in_array(strtolower($key),array('tel_obs_adicionales'))
					|| in_array(strtolower($key),array('tel_dia_presuntivo'))
					|| in_array(strtolower($key),array('tel_tra_actual'))
					|| in_array(strtolower($key),array('tel_con_especialista'))
					|| in_array(strtolower($key),array('tel_dia_especialista'))
					|| in_array(strtolower($key),array('tel_dia_fundamentos'))
					|| in_array(strtolower($key),array('tel_sol_adicionales'))
					|| in_array(strtolower($key),array('tel_sol_adicionales_resp'))
					|| in_array(strtolower($key),array('tel_sol_adicionales_resp'))
					|| in_array(strtolower($key),array('tel_revisor_solicitud_info_adicional'))
					|| in_array(strtolower($key),array('tel_revisor_solicitud_info_adicional_resp'))
					)
				{
					$col = preg_replace("/\r\n+|\r+|\n+|\t+/i", "\n\n", $col);
				}
			}
		}
		//FIN SI641
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['etb']              = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        //$this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        if( empty( $this->data['estado_enviada'] ) ){
            $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 1);
            if( empty( $this->data['estado_enviada'] ) ){
                $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 7);
            }
        }
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );
	$this->data['examenes_anteriores_ris']  = $this->platc_model->paciente_examenes_anteriores_ris( $this->data['identificadores'][0]['TCI_VALOR'] );
        // Compatibilidad con version nueva
        $this->data['mostrar_tcanteriores']    = TRUE;
        $this->data['tc_agendamientos_anteriores']  = $this->platc_model->tc_agendamientos_get($id, 3);
        $this->index('tc_contestada_view');

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */


        /*
         * Lógica para cargar información de datos de flujo Revisor
         */
        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_respuesta = array( );
            $data_respuesta['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data_respuesta['tel_revisor_solicitud_info_adicional'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'];
            $data_respuesta['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data_respuesta['tc_id'] = $this->data['tc']['TEL_ID'];
            $data_respuesta['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data_respuesta );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data_respuesta = array( );
                $data_respuesta['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data_respuesta['tel_revisor_solicitud_info_adicional_resp'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'];
                $data_respuesta['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data_respuesta['tc_id']  = $this->data['tc']['TEL_ID'];
                $data_respuesta['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data_respuesta );
            }
        }

        /*
         * Lógica que carga solicitudes de exámenes del especialista
         */
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if( !empty( $this->data['estado_exsol'] ) ) {

            // Limpiar código HTML/XML
            $this->data['tc']['TEL_SOL_ADICIONALES'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES'] );
            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            $this->data['modo'] = 1;    // Archivos respuesta especialista modo lectura
            $this->load->view( 'forms/parcial_solicitud_examenes', $this->data );

            // Carga formulario examenes realizados
            $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
            if( !empty( $this->data['estado_exreal'] ) ) {

                // Limpiar código HTML/XML
                $this->data['tc']['TEL_SOL_ADICIONALES_RESP'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES_RESP'] );
                $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
                $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
                $this->load->view( 'forms/parcial_solicitud_examenes_resp', $this->data );
            }
        }

        /*
         *  Carga respueta final de la TC
         */
        $this->data['especialidad'] = $this->platc_model->especialidad_get( (int)$this->data['tc']['ESP_ID'] );
        if( ( $this->session->userdata('SIT_ID') == 25 || $this->session->userdata('SIT_ID') == 2 ) && $this->data['especialidad']['ESP_ARCHIVO_FORMULARIO'] == 'form_oftalmologia' ) {

            $oftalmo_data = array( );

            $data_respuesta = $this->platc_model->tc_obtener_data_respuesta( (int)$id );

            if( !empty( $data_respuesta ) ) {

                foreach( $data_respuesta as $k => $v ) {

                    if( $this->util->is_json( $v ) )
                        $oftalmo_data[$k] = json_decode( $v );
                    else
                        $oftalmo_data[$k] = $htmlpurifier->purify( $v );
                }

                foreach( $oftalmo_data as $k => $v ) {

                    switch( $k ) {

                        case 'izquierdo_color'  : $oftalmo_data['izquierdo_color_nombre']   = $this->platc_model->pe_oftalmologia_color_get( (int)$v ); break;
                        case 'izquierdo_bordes' : $oftalmo_data['izquierdo_bordes_nombre']  = $this->platc_model->pe_oftalmologia_borde_get( (int)$v ); break;
                        case 'izquierdo_macula' : $oftalmo_data['izquierdo_macula_nombre']  = $this->platc_model->pe_oftalmologia_zona_macular_get( (int)$v ); break;
    //                    case 'izquierdo_arteriosclerosis'       : $this->lang->line('izquierdo_arteriosclerosis'); break;
    //                    case 'izquierdo_cruces_arteriovenosos'  : $this->lang->line('izquierdo_cruces_arteriovenosos'); break;
                        case 'izquierdo_retina' : $oftalmo_data['izquierdo_retina_nombre']  = $this->platc_model->pe_oftalmologia_retina_get( (int)$v ); break;
                        case 'derecho_color'    : $oftalmo_data['derecho_color_nombre']     = $this->platc_model->pe_oftalmologia_color_get( (int)$v ); break;
                        case 'derecho_bordes'   : $oftalmo_data['derecho_bordes_nombre']    = $this->platc_model->pe_oftalmologia_borde_get( (int)$v ); break;
                        case 'derecho_macula'   : $oftalmo_data['derecho_macula_nombre']    = $this->platc_model->pe_oftalmologia_zona_macular_get( (int)$v ); break;
    //                    case 'derecho_arteriosclerosis' : $this->lang->line('derecho_arteriosclerosis'); break;
    //                    case 'derecho_cruces_arteriovenosos'    : $this->lang->line('derecho_cruces_arteriovenosos'); break;
                        case 'derecho_retina'   : $oftalmo_data['derecho_retina_nombre']    = $this->platc_model->pe_oftalmologia_retina_get( (int)$v ); break;
                        case 'diagnosticos'     : $oftalmo_data['diagnosticos_nombre']      = $this->platc_model->pe_oftalmologia_diagnostico_get( (int)$v ); break;
                        case 'recomendaciones_control' : $oftalmo_data['recomendaciones_control_nombre'] = $this->platc_model->pe_oftalmologia_control_get( (int)$v ); break;
                    }
                }
            }

            $this->data['oftalmo_data'] = $oftalmo_data;
        } else {

            // Limpiar código HTML/XML
            $this->data['tc']['TEL_CON_ESPECIALISTA'] = $htmlpurifier->purify( $this->data['tc']['TEL_CON_ESPECIALISTA'] );
            $this->data['tc']['TEL_DIA_ESPECIALISTA'] = $htmlpurifier->purify( $this->data['tc']['TEL_DIA_ESPECIALISTA'] );
            $this->data['tc']['TEL_DIA_FUNDAMENTOS']  = $htmlpurifier->purify( $this->data['tc']['TEL_DIA_FUNDAMENTOS'] );
            $this->data['tc']['TEL_DIA_ORIENTACION']  = $htmlpurifier->purify( $this->data['tc']['TEL_DIA_ORIENTACION'] );

            $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
            $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
            $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
            // Listado de códigos CIE10 de respuesta ingresados por el autoguardar: Convierte data de DB a array de php
            // Compatibilidad de lógica con el parcial diagnostico medico de la proforma
            if( !empty( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) ) {
                $cie_id_respuestas = $this->platc_model->cie10_get( json_decode( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) );
                $cie_id_respuestas = $this->util->select_form_prepare( $cie_id_respuestas, 'CIE_ID', 'descripcion');
                unset( $cie_id_respuestas[''] ); // Elimina elemento vacío
                $this->data['tc']['TEL_CIE_ID_RESPUESTA'] = $cie_id_respuestas;
            }

            if( $this->session->userdata('SIT_ID') == 22 ) {

                $this->data['tc']['FORMULAS']   = $this->platc_model->recetario_formulas_get( (int)$this->data['tc']['TEL_ID'] );
                $this->data['tc']['RECETAS']    = $this->platc_model->recetarios_get( (int)$this->data['tc']['TEL_ID'] );
                $this->data['tc']['ANEXOS']    = $this->platc_model->anexo_get( (int)$this->data['tc']['TEL_ID'] );
            }
        }
		
		if($this->session->userdata('SIT_ID') == 2){
			//ACCION INDICADA
			$this->load->model('accion_indicada_model');
			$this->data['accion_indicada'] = $this->accion_indicada_model->select();

			//CONCORDANCIA DIAGNOSTICA
			$this->load->model('concordancia_diagnostica_model');
			$this->data['concordancia_diagnostica'] = $this->concordancia_diagnostica_model->select();
		}

        $this->load->view( 'forms/parcial_respuesta_examen', $this->data );

        // Si es Medico generalista muestra botones para evaluar respuesta de la TC
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ) {
            $this->load->view( 'botones_evaluarexamen', $this->data );
        }

        // Si es Administrador o Supervisor se muestra funcionalidad eliminar
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {
            $this->load->view( 'botones_eliminar' );
        }
    }

    /**
     * Carga la vista para la visualizaion de las TC
     * que se encuentran en estado "Rechazadas".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_rechazadas_view($estado = NULL, $id) {

        // Genera parte paciente y datos de la TC
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['rechazos'] = $this->platc_model->tc_historia($id, (int)3 );
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );
	$this->data['examenes_anteriores_ris']  = $this->platc_model->paciente_examenes_anteriores_ris( $this->data['identificadores'][0]['TCI_VALOR'] );
        $this->index('tc_rechazada_view');

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */

        /*
         * Lógica para cargar información de datos de flujo Revisor
         */
        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data = array( );
            $data['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data['tel_revisor_solicitud_info_adicional'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'];
            $data['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data['tc_id'] = $this->data['tc']['TEL_ID'];
            $data['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data = array( );
                $data['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data['tel_revisor_solicitud_info_adicional_resp'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'];
                $data['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data['tc_id']  = $this->data['tc']['TEL_ID'];
                $data['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data );
            }
        }

        // Listado de motivos de rechazos
        $this->load->view( 'forms/motivos_rechazo', $this->data );
    }

    /**
     * Carga la vista para la visualizaion de una teleconsulta en especifico
     * que se encuentra en estado eliminada, parametros
     * recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_eliminada_view($estado = NULL, $id) {

        //
        $this->data['tc']               = $this->platc_model->tc_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get( $this->data['tc']['ETB_ID'] );
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);

        //
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        if( !empty( $this->data['estado_enviada'] ) ) {

            $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
            $this->data['estado_enviada']['TEP_FECHA_HORA'] = (isset($this->data['estado_enviada']['TEP_FECHA_HORA']) && date_create($this->data['estado_enviada']['TEP_FECHA_HORA'])) ? $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']) : "";
        } else {

            $this->data['usuario_envia']['USU_NOMBRE']      = '-';
            $this->data['estado_enviada']['TEP_FECHA_HORA'] = '-';
        }

        //
        $this->data['estado_eliminada'] = $this->platc_model->tc_estado_get($id, 4);
        $this->data['estado_eliminada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_eliminada']['TEP_FECHA_HORA']);
        $this->data['usuario_elimina']  = (isset($this->data['estado_eliminada']['USU_ID']) && $this->data['estado_eliminada']['USU_ID']) ? $this->platc_model->usuario_estado_get($this->data['estado_eliminada']['USU_ID']) : NULL;

        $this->load->view( 'tc_eliminada_view', $this->data );

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */


        /*
         * Lógica para cargar información de datos de flujo Revisor
         */
        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data = array( );
            $data['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data['tel_revisor_solicitud_info_adicional'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'];
            $data['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data['tc_id'] = $this->data['tc']['TEL_ID'];
            $data['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data = array( );
                $data['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data['tel_revisor_solicitud_info_adicional_resp'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'];
                $data['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data['tc_id']  = $this->data['tc']['TEL_ID'];
                $data['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data );
            }
        }

        /*
         * Lógica que carga solicitudes de exámenes del especialista
         */
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if( !empty( $this->data['estado_exsol'] ) ) {

            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            $this->data['modo'] = 1;    // Archivos respuesta especialista modo lectura
            $this->load->view( 'forms/parcial_solicitud_examenes', $this->data );

            // Carga formulario examenes realizados
            $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
            if( !empty( $this->data['estado_exreal'] ) ) {

                $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
                $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
                $this->load->view( 'forms/parcial_solicitud_examenes_resp', $this->data );
            }
        }

        // Carga respueta final de la TC
        $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
        $this->data['especialidad'] = $this->platc_model->especialidad_get( (int)$this->data['tc']['ESP_ID'] );
        if( !empty( $this->data['estado_contestada'] ) ) {

            $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
            $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
            $this->load->view( 'forms/parcial_respuesta_examen', $this->data );
        }

        // Boton para deseliminar
        $this->load->view( 'forms/botones_deseliminar', $this->data );
    }

    /**
     * Carga la vista para la visualizaicon de una teleconsulta en especifico
     * que se encuentra en estado "Examenes solicitados", parametros
     * recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_exsol_responder($estado = NULL, $id) {

        $this->load->library( 'HtmlPurifierWrapper' );
        $htmlpurifier = $this->htmlpurifierwrapper->HtmlPurifierFactory();

        // Obtiene teleconsulta
        // Genera parte paciente y datos de la TC
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );
	$this->data['examenes_anteriores_ris']  = $this->platc_model->paciente_examenes_anteriores_ris( $this->data['identificadores'][0]['TCI_VALOR'] );
        // Compatibilidad con version nueva
        $this->data['mostrar_tcanteriores']    = TRUE;
        $this->index('tc_exsol_responder_view');

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */

        /*
         * Lógica para cargar información de datos de flujo Revisor
         */
        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data = array( );
            $data['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data['tel_revisor_solicitud_info_adicional'] = $htmlpurifier->purify( $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] );
            $data['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data['tc_id'] = $this->data['tc']['TEL_ID'];
            $data['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data = array( );
                $data['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data['tel_revisor_solicitud_info_adicional_resp'] = $htmlpurifier->purify( $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'] );
                $data['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data['tc_id']  = $this->data['tc']['TEL_ID'];
                $data['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data );
            }
        }

        // Carga solicitudes de exámenes del especialista
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if( !empty( $this->data['estado_exsol'] ) ) {

            $this->data['tc']['TEL_SOL_ADICIONALES'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES'] );
            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            $this->data['modo'] = 1;    // Archivos respuesta especialista modo lectura
            $this->load->view( 'forms/parcial_solicitud_examenes', $this->data );
        }

        // Revisor: Muestra formulario para responder solicitud de examen del revisor (Revisada: 0)
        // Generalista: Muestra formulario para responder solicitud de examen (Revisada: 1)
        if( $this->data['tc']['TEL_REVISADA'] == 0 && (int)$this->session->userdata('ROL_ID') != Platc::$ROL['MEDICO_REVISOR'] ) {

            $this->load->view( 'forms/botones_revisor_solicitud_examenes_resp', $this->data );
        } elseif( $this->data['tc']['TEL_REVISADA'] == 1 ) {

            $this->load->view( 'forms/botones_solicitud_examen_resp', $this->data );
        }

        // Generalistas marcan examen como Tomado al ver la solitud de examenes
        // validación necesaria pues especialistas tambien visualizan TC con sol. de exam. con este método
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] )
            $this->platc_model->tc_marcar_toma( (int)$id );
    }

    /**
     * Carga la vista con todas las TC segun el estado de esta,
     * respetando la visibilidad segun rol y site, grupo y/o establecimiento al
     * que pertenece el susuario, parametros recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_lista($estado) {
        $this->data['estado'] = $estado;
        $this->index('tc_buscador_view');
    }

    /**
     * Recibe los parametros de la teleconsulta que se quiere reponder
     * en estado "Enviada/Nueva", validando los datos cambiandola de estado a
     * "Examnes solicitados" o guardandola segun corresponda al rol o parametros recibidos.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['estadoanterior'] estadoanterior de la TC
     * @param int $_POST['respuesta'] respuesta de la TC
     * @return none
     */
    public function tc_exsol_responde() {
        $this->form_validation->set_rules('tc_id', '', 'required');
        $this->form_validation->set_rules('estadoanterior', '', 'required');
        $this->form_validation->set_rules('respuesta', '', 'required');

        // Campo requerido para CO y CL
        if( $this->form_validation->run() != FALSE &&
            ( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ||
              (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] ) ) {
            $chk_control = FALSE;
            if ($this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE) {
                    $newpath = $this->path_file['exam_realizados'] . $this->input->post('tc_id') . '/';
                    @mkdir($newpath, 0777, true);
                    $this->dir_move($this->path_file['exam_solicitados'] . $this->input->post('tc_id') . '/', $newpath);
                    $data['EST_ID'] = 6;
                    $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
                    $data['TEL_FECHA_HORA_SOLEXARESP'] = date('Y-m-d') . " " . date('H:i:s');
                } else {
                    $data['EST_ID'] = $this->input->post('estadoanterior');
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = $this->input->post('estadoanterior');
            $data['TEL_ID'] = $this->input->post('tc_id');
            //$data['TEL_SOL_ADICIONALES_RESP'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('respuesta') );
			$data['TEL_SOL_ADICIONALES_RESP'] = $this->input->post('respuesta');
            if ($this->platc_model->tc_upd($data)) {
                if ($this->input->post('estadoanterior') != $data['EST_ID'])
                    $this->tc_cambio_estado($this->input->post('tc_id'), $data['EST_ID'], NULL, $this->session->userdata('USU_ID'));
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/5/';
                $resp['div'] = 'deploy';
                if ($chk_control == TRUE) {
                    $resp['msgt'] = $this->lang->line('error');
                    unset( $resp['method'] );   // Permanece en la página cuando la contrasena es invalida
                    $resp['msg'] = $this->lang->line('tc_error_passwd');
                } elseif ($chk_control == FALSE && $data['EST_ID'] == $this->input->post('estadoanterior')) {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_guardada_ok');
                } else {
                    $this->correo_estado_respuesta_solicitud_examen( $data['TEL_ID'] );
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_enviada_ok');

                    // Desmarca toma
                    $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        $this->output->set_output( json_encode($resp) );
    }

    /**
     * Envía correo al médico generalista dando aviso del cambio de estado de la TC
     * a examen solicitado.
     * Asume que TC ya está en estado (5)Solicitud de examen: asi se sabe
     * quién hizo la solicitud para establecer el remitente ("from") en el mail
     */
    private function correo_estado_respuesta_solicitud_examen( $id_teleconsulta ) {

        if( (bool)$this->config->item( 'email_activo', 'platc' ) ) {

            $tc = $this->platc_model->tc_get( $id_teleconsulta );

            // Destinatario es Especialista que solicitó info. "foreach" necesario por si TC tiene historia de revisor
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 5 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['ESPECIALISTA'] )
                    $id_especialista = $estado['USU_ID'];
            }

            // Remitente: Generalista propietario de la TC
            // TODO: Verificar si es usuario de sesion o de la historia quien se establece como Remitente: Por si generalista se desvincula
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
                    $id_generalista = $estado['USU_ID'];
            }

            // Establece datos para el correo
            $especialista = $this->platc_model->usuario_get( $id_especialista );
            $generalista  = $this->platc_model->usuario_get( $id_generalista );

            $datos = array( );
            $datos[ 'id_teleconsulta' ]     = $tc['TEL_ID'];
            $datos[ 'nombre_generalista' ]  = $generalista['USU_NOMBRE'];
            $datos[ 'nombre_paciente' ]     = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO']. ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' );
            $datos[ 'nombre_especialista' ] = $especialista['USU_NOMBRE'];
            $datos[ 'solicitud' ]           = $tc['TEL_SOL_ADICIONALES'];

            // Realiza configuración de librería "email" de CI. Como toda librería
            // propia de CI, se usa la variable $this->email
            $this->util->email_factory();
            $plantilla_email = $this->platc_model->plantilla_email_get( (int)$this->session->userdata('SIT_ID'), 6 );

            // Desde: Médico Especialista
            $this->email->from( $this->config->item( 'email_usuario', 'platc' ), $this->config->item( 'email_nombre_remitente', 'platc' ) );

            // Hacia: Médico Generalista
    //        $this->email->to( $datos['generalista']['USU_EMAIL'] );
            $this->email->to( 'certificacion.medsolutions@gmail.com' );

            // Asunto
            $this->load->library('parser');
            $asunto  = $this->parser->parse_string( (string)$plantilla_email['EMA_ASUNTO'], $datos );
            $this->email->subject( $asunto );

            // Mensaje
            $mensaje = $this->parser->parse_string( (string)$plantilla_email['EMA_TEXTO'], $datos );
            $this->email->message( nl2br( $mensaje ) );

            $result = $this->email->send( );
            log_message( 'INFO', $this->email->print_debugger() );

            return $result;
        }

        return TRUE;
    }

    /**
     * Carga la vista para la visualizacion de una TC en estado "Examnes realizados".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_exreal_responder($estado = NULL, $id) {

        $this->load->library( 'HtmlPurifierWrapper' );
        $htmlpurifier = $this->htmlpurifierwrapper->HtmlPurifierFactory();

        // Obtiene teleconsulta
        // Genera parte paciente y datos de la TC
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );
	$this->data['examenes_anteriores_ris']  = $this->platc_model->paciente_examenes_anteriores_ris( $this->data['identificadores'][0]['TCI_VALOR'] );
        // Compatibilidad con version nueva
        $this->data['mostrar_tcanteriores']    = TRUE;
        $this->index('tc_exreal_responder_view');

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */

        /*
         * Lógica para cargar información de datos de flujo Revisor
         */
        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data = array( );
            $data['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data['tel_revisor_solicitud_info_adicional'] = $htmlpurifier->purify( $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] );
            $data['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data['tc_id'] = $this->data['tc']['TEL_ID'];
            $data['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data = array( );
                $data['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data['tel_revisor_solicitud_info_adicional_resp'] = $htmlpurifier->purify( $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'] );
                $data['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data['tc_id']  = $this->data['tc']['TEL_ID'];
                $data['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data );
            }
        }

        /*
         * Lógica que carga solicitudes de exámenes del especialista
         */
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if( !empty( $this->data['estado_exsol'] ) ) {

            // Limpiar código HTML/XML
            $this->data['tc']['TEL_SOL_ADICIONALES'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES'] );
            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            $this->data['modo'] = 1;    // Archivos respuesta especialista modo lectura
            $this->load->view( 'forms/parcial_solicitud_examenes', $this->data );

            // Carga formulario examenes realizados
            $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
            if( !empty( $this->data['estado_exreal'] ) ) {

                // Limpiar código HTML/XML
                $this->data['tc']['TEL_SOL_ADICIONALES_RESP'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES_RESP'] );
                $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
                $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
                $this->load->view( 'forms/parcial_solicitud_examenes_resp', $this->data );
            }
        }

        /*
         * Médico revisor: Muestra botones para establecer TC como nueva/enviada al especialista o rechazar.
         * Médico especialista: Muestra botones para responder definitivamente TC
         */
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] ) {

            // Listado de motivos de rechazos
            $listado_motivos = $this->platc_model->motivo_rechazo_lista_get( $this->session->userdata('SIT_ID') );
            $this->data['listado_motivos_rechazo'] = $this->util->select_form_prepare( $listado_motivos, 'MR_ID', 'MR_DESCRIPCION' );

            $this->load->view( 'forms/botones_revisor_respuesta', $this->data );
        } elseif( (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] ) {

            // Listado de códigos CIE10 de respuesta ingresados por el autoguardar: Convierte data de DB a array de php
            // Compatibilidad de lógica con el parcial diagnostico medico de la proforma
            if( !empty( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) ) {
                $cie_id_respuestas = $this->platc_model->cie10_get( json_decode( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) );
                $cie_id_respuestas = $this->util->select_form_prepare( $cie_id_respuestas, 'CIE_ID', 'descripcion');
                unset( $cie_id_respuestas[''] ); // Elimina elemento vacío
                $this->data['tc']['TEL_CIE_ID_RESPUESTA'] = $cie_id_respuestas;
            }

            // Prioridad
            $prioridad = array( 1 => $this->lang->line( 'prioridad_1' ),
                                2 => $this->lang->line( 'prioridad_2' ),
                                3 => $this->lang->line( 'prioridad_3' ) );
            $this->data['prioridades'] = $prioridad;

            // Especialidad de respuesta
            $this->data['especialidad'] = $this->platc_model->especialidad_get( (int)$this->data['tc']['ESP_ID'] );
            if( ( $this->session->userdata('SIT_ID') == 25 || $this->session->userdata('SIT_ID') == 2 ) && $this->data['especialidad']['ESP_ARCHIVO_FORMULARIO'] == 'form_oftalmologia' ) {

                $this->data['oftalmo_data']['color']  = $this->platc_model->pe_oftalmologia_colores_get( );
                $this->data['oftalmo_data']['bordes'] = $this->platc_model->pe_oftalmologia_bordes_get( );
                $this->data['oftalmo_data']['macula'] = $this->platc_model->pe_oftalmologia_zonas_maculares_get( );
                $this->data['oftalmo_data']['diagnosticos']     = $this->platc_model->pe_oftalmologia_diagnosticos_get( );
                $this->data['oftalmo_data']['recomendaciones']  = $this->platc_model->pe_oftalmologia_controles_get( );
            }

            $this->data['tc']['TC_TELECONSULTA_RESPUESTA'] = $this->platc_model->tc_obtener_data_respuesta( (int)$this->data['tc']['TEL_ID'] );
            if( $this->session->userdata('SIT_ID') == 22 ) {

                //$this->data['tc']['FORMULAS']   = $this->platc_model->recetario_formulas_get( (int)$this->data['tc']['TEL_ID'] );
                //$this->data['tc']['RECETAS']    = $this->platc_model->recetarios_get( (int)$this->data['tc']['TEL_ID'] );


                $this->data['tc']['FORMULAS']   = $this->platc_model->recetario_formulas_get( (int)$this->data['tc']['TEL_ID'],TRUE,0 );
                $this->data['tc']['RECETAS']    = $this->platc_model->recetarios_get( (int)$this->data['tc']['TEL_ID'],TRUE,0 );
                $this->data['tc']['ANEXOS']    = $this->platc_model->anexo_get( (int)$this->data['tc']['TEL_ID'] );
            }

            $this->load->view( 'forms/botones_responder_examen', $this->data );
        }

        // Generalistas marcan examen como Tomado al ver la solitud de examenes
        // validación necesaria pues especialistas tambien visualizan TC con sol. de exam. con este método
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] )
            $this->platc_model->tc_marcar_toma( (int)$id );
    }

    /**
     * Carga la vista para la visualizacion de una TC en estado "Borrador"
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_borrador_editar($estado = NULL, $id) {

		//NF514
		$cod_prioridad = "";
		$result = $this->cliente_model->prioridad(array('PC_CLI_ID' => $this->session->userdata('CLI_ID')));
		if($result){ foreach($result as $row){
				$cod_prioridad[] = $row['PC_PRI_ID'];
			}
		}
		//FIN
	
        // Obtiene teleconsulta
        // Genera parte paciente y datos de la TC
        $this->data['tc'] = $this->platc_model->tc_get($id);
		
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['mostrar_tcanteriores'] = true;
        $this->data['paciente'] = $this->platc_model->paciente_get($this->data['tc']['PAC_ID']);
        $this->data['paciente']['PAC_EDAD'] = $this->util->yearscalc($this->data['paciente']['PAC_NACIMIENTO']);
        $this->data['prioridades_select'] = $this->tc_prioridades_select($cod_prioridad);
        unset( $this->data['prioridades_select'][''] );
        $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );
		
        // Campos RIPS
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $ent_administradoras = $this->platc_model->entidades_administradoras_get( );
            $this->data['ent_admnistradoras_select'] = $this->util->select_form_prepare( $ent_administradoras, 'ENTADM_ID', 'ENTADM_NOMBRE' );

            $finalidad_procedimiento = $this->platc_model->finalidad_procedimiento_get( );
            $this->data['finalidad_procedimiento_select'] = $this->util->select_form_prepare( $finalidad_procedimiento, 'FINPROC_ID', 'FINPROC_DESCRIPCION' );

            $this->data['codigo_autorizacion_inpt'] = $this->data['tc'];

            $ambito_procedimiento = $this->platc_model->ambito_procedimiento_get( );
            $this->data['ambito_procedimiento_select'] = $this->util->select_form_prepare( $ambito_procedimiento, 'AMBPROC_ID', 'AMBPROC_DESCRIPCION' );

            $zona_residencia = $this->platc_model->zona_residencia_get( );
            $this->data['zona_residencia_select'] = $this->util->select_form_prepare( $zona_residencia, 'ZON_ID', 'ZON_NOMBRE' );
        }

        $this->index('tc_borradores_edita_view');

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_ESCRITURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */

        //
        $this->load->view( 'forms/botones_borrador' );
    }

    /**
     * Recibe los parametros de la TC que se quiere crear dejandola en estado "Enviada/Nuvea"
     * o "Borrador".
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['especialidad'] especialidad de la TC
     * @param string $_POST['motpaciente'] motivo del paciente de la TC
     * @param string $_POST['motinterconsulta'] motivo de la interconsulta de la TC
     * @param string $_POST['resatencion'] resumen de la atencion de la TC
     * @param string $_POST['svpa_sistolica']  de la TC
     * @param string $_POST['svpa_diastolica']  de la TC
     * @param int $_POST['svfc']
     * @param int $_POST['svfr']
     * @param int $_POST['svtemp']
     * @param int $_POST['svsato2']
     * @param int $_POST['svpeso']
     * @param int $_POST['svtalla']
     * @param float $_POST['svimc']
     * @param string $_POST['svimc_clasificacion']
     * @param string $_POST['ayudiagnostica']
     * @param string $_POST['obsadicionales']
     * @param string $_POST['diapresuntivo']
     * @param string $_POST['traactual']
     * @return none
     */
    public function tc_crea() {

        $es_usuario_valido = false;

        /*
         * Valida que sea el médico general quien realiza la creación de la TC
         */
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL']
            && (string)$this->input->post('passwd') != '' ) {

            $data_user = $this->platc_model->login( $this->session->userdata('USU_EMAIL'), md5( (string)$this->input->post('passwd') ) );
            if( $data_user != FALSE )
                $es_usuario_valido = true;
        }

        if( !$es_usuario_valido ) {

            $resp['action'] = 'false';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('tc_error_passwd');
            $this->output->set_output( json_encode( $resp ) );
            return;
        }

        /*
         *
         */

        // Obtiene campos que deben ser requeridos antes de continuar con el ingreso
        $this->load->library( 'FormularioXML' );
        $campos_requeridos = $this->formularioxml->obtener_campos_requeridos( $this->input->post('id_teleconsulta') );
        $campos_requeridos[] = 'id_teleconsulta';
        foreach( $campos_requeridos as $campo )
            $this->form_validation->set_rules( $campo, '', 'required');

        // Realiza validación de datos del formulario (campos requeridos)
        if( $this->form_validation->run() != FALSE ) {

            $id_teleconsulta    = $this->input->post( 'id_teleconsulta' );
            $tc                 = $this->platc_model->tc_get( $id_teleconsulta );

            // Establece datos de la TC
            $data = array( );
            $data['TEL_FECHA_HORA_ENVIO']   = date('Y-m-d') . " " . date('H:i:s');
            $data['EST_ID']                 = 2;    // 2: Enviada
            $data['PRI_ID']                 = $this->input->post('prioridad');

            // Establece si TC debiera ser revisada por un Revisor, esto en función del Cliente pues
            // es quien tiene la capacidad de decidir si se va al Revisor asociado en el grupo.
            $id_cliente = $this->session->userdata( 'CLI_ID' );
            $cliente                = !empty( $id_cliente ) ? $this->platc_model->cliente_get( $id_cliente ) : null;
            $data['TEL_REVISADA']   = ( $cliente == null || $cliente['CLI_REVISOR'] == 1 ) ? 0 : 1;

            /*
             * Inicio nueva lógica TC_TELECONSULTA_DATA
             */
            $tc_data = array( );

            // Hacer lógica para asociar formulario con archivo xml
            $this->load->library( 'FormularioXML' );
            $campos = $this->formularioxml->obtener_campos( $id_teleconsulta );

            // Ciclo recorre campos definido en xml para obtener información desde $_POST
            foreach( $campos as $campo )
                if( is_array( $this->input->post( $campo ) ) )

                    $tc_data[ $campo ]  = json_encode( $this->input->post( $campo ) );
                else {
                    $c = $this->input->post( $campo );
                    if( $c != "" && !isset( $tc_data[ $campo ] ) ) {
                        $tc_data[ $campo ] = preg_replace( "/<br(\s)*(\/)*>/i", "", $c );
                        $tc_data[ $campo ] = preg_replace( "/^\n++(?! )/", "", $tc_data[ $campo ] );
                        $tc_data[ $campo ] = preg_replace( "/\n++(?! )(&nbsp;)*$/", "", $tc_data[ $campo ] );
                    }
                }
            /*
             * No borrar, lógica que valida si la data ingresada es la viene por $_POST
             * $estado = $this->platc_model->tc_comprobar_data( $tcid, $data1 );
             * if( $estado == FALSE ) {
             *     $resp['action'] = 'false';
             *     $resp['div'] = 'deploy';
             *     $resp['msgt'] = $this->lang->line('error');
             *     $resp['msg'] = $this->lang->line('tc_falta_informacion');
             *     $this->output->set_output( json_encode( $resp ) );
             *     return;
             * }
             */

            /*
             * Fin nueva lógica TC_TELECONSULTA_DATA
             */

            /*
             *
             */
            $esp    = $this->platc_model->especialidad_get( $tc['ESP_ID'] );
            if( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_derma_lesion' ) == 0 ) {

                $this->derma_lesion_reorganizar_archivos( $id_teleconsulta );
            } elseif( ( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_oftalmologia' ) == 0 ) && $this->session->userdata('SIT_ID') == 2 ) {

                $this->cl_oftalmologia_reorganizar_archivos( $id_teleconsulta );
            } elseif( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_otorrinologia' ) == 0 ) {

                $array_exa_especifico = array(  'otorrino_examen_cabeza_imagenes',
                                                'otorrino_examen_boca_imagenes',
                                                'otorrino_examen_oido_izquierdo_imagenes',
                                                'otorrino_examen_oido_derecho_imagenes',
                                                'otorrino_examen_nariz_izquierdo_imagenes',
                                                'otorrino_examen_nariz_derecho_imagenes',
                                                'otorrino_examen_cuello_imagenes' );

                foreach( $array_exa_especifico as $k => $variable )
                    if( isset( $_POST[ $variable ] ) && !empty( $_POST[ $variable ] ) &&
                        $_POST[ $variable ] != 1 )
                        unset( $array_exa_especifico[ $k ] );

                $this->otorrino_reorganizar_archivos( $id_teleconsulta, $array_exa_especifico );
            }

            $comentario     = $this->lang->line('tc_estado_enviado');
            $info_tecnico   = $this->lang->line('tc_estado_enviado'). ' [' . $this->session->userdata('USU_ID').']['.$this->session->userdata('USU_NOMBRE').']';
            $estado = $this->tc_guardar( $id_teleconsulta, $tc['PRI_ID'], $data, $tc_data, $comentario, $info_tecnico );

            if( $estado ) {

                // Mueve archivos adjuntos
                $newpath = $this->path_file['enviadas'] . $id_teleconsulta . '/';
                @mkdir($newpath, 0777, true);
                $this->dir_move($this->path_file['borradores'] . $id_teleconsulta . '/', $newpath);

                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('tc_enviada_ok');
            } else {

                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');

            //
            $a = array( );
            foreach( $campos_requeridos as $cr ) {
                if( !isset( $_POST[ $cr ] ) || empty( $_POST[ $cr ] ) )
                    $a[] = $this->lang->line( $cr );
            }

            $resp['msg'] = $this->lang->line('complete_campos').'<br/> '. ( !empty( $a ) ? '* '.implode( '<br/> * ', $a ) : '' );
        }
        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     * Guarda los cambios hechos en una TC en estado "Borrador".
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['especialidad'] especialidad de la TC
     * @param string $_POST['motpaciente'] motivo del paciente de la TC
     * @param string $_POST['motinterconsulta'] motivo de la interconsulta de la TC
     * @param string $_POST['resatencion'] resumen de la atencion de la TC
     * @param string $_POST['svpa_sistolica']  de la TC
     * @param string $_POST['svpa_diastolica']  de la TC
     * @param int $_POST['svfc']
     * @param int $_POST['svfr']
     * @param int $_POST['svtemp']
     * @param int $_POST['svsato2']
     * @param int $_POST['svpeso']
     * @param int $_POST['svtalla']
     * @param float $_POST['svimc']
     * @param string $_POST['svimc_clasificacion']
     * @param string $_POST['ayudiagnostica']
     * @param string $_POST['obsadicionales']
     * @param string $_POST['diapresuntivo']
     * @param string $_POST['traactual']
     * @return none
     */
    public function tc_borrador_edita() {

        $resp = array( );
        $id_teleconsulta    = $this->input->post( 'id_teleconsulta' );
        $tc                 = $this->platc_model->tc_get( $id_teleconsulta );

        $data = array( );
		//NF432
		if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ATENCION_CLIENTE'] ){
			$data['EST_ID'] = 2;
			$data['TEL_FECHA_HORA_ENVIO'] = date('Y-m-d H:i:s'); 
		}
		//FIN
		else{
			$data['EST_ID'] = 1;
		}
        $data['PRI_ID'] = $this->input->post('prioridad');

        // Establece si TC debiera ser revisada por un Revisor, esto en función del Cliente pues
        // es quien tiene la capacidad de decidir si se va al Revisor asociado en el grupo.
        $id_cliente = $this->session->userdata( 'CLI_ID' );
        $cliente                = !empty( $id_cliente ) ? $this->platc_model->cliente_get( $id_cliente ) : null;
        $data['TEL_REVISADA']   = ( $cliente == null || $cliente['CLI_REVISOR'] == 1 ) ? 0 : 1;

        /*
         * Inicio nueva lógica TC_TELECONSULTA_DATA
         */
        $tc_data = array( );
        $tc_data['tc_id'] = $id_teleconsulta;

        // Hacer lógica para asociar formulario con archivo xml
        $this->load->library( 'FormularioXML' );
        $campos = $this->formularioxml->obtener_campos( $id_teleconsulta );
		
		// Ciclo recorre campos definido en xml para obtener información desde $_POST
        foreach( $campos as $campo )
            if( is_array( $this->input->post( $campo ) ) )

                $tc_data[ $campo ]  = json_encode( $this->input->post( $campo ) );
            else {
                $c = $this->input->post( $campo );
				
				//SI641
				//se limpia el valor enviado antes de guardar
				$c = trim(str_replace("<br />"," ",$c));
				$c = trim(str_replace("<br/>"," ",$c));
                if( $c != "" && !isset( $tc_data[ $campo ] ) ) {
                    $tc_data[ $campo ] = preg_replace( "/<br(\s)*(\/)*>/i", "", $c );
                    $tc_data[ $campo ] = preg_replace( "/^\n++(?! )/", "", $tc_data[ $campo ] );
                    $tc_data[ $campo ] = preg_replace( "/\n++(?! )(&nbsp;)*$/", "", $tc_data[ $campo ] );
                }
            }
            /*
         * No borrar, lógica que valida si la data ingresada es la viene por $_POST
         * $estado = $this->platc_model->tc_comprobar_data( $tcid, $data1 );
         * if( $estado == FALSE ) {
         *     $resp['action'] = 'false';
         *     $resp['div'] = 'deploy';
         *     $resp['msgt'] = $this->lang->line('error');
         *     $resp['msg'] = $this->lang->line('tc_falta_informacion');
         *     $this->output->set_output( json_encode( $resp ) );
         *     return;
         * }
         */

        /*
         * Fin nueva lógica TC_TELECONSULTA_DATA
         */

            $comentario     = $this->lang->line('tc_estado_borrador');
            $info_tecnico   = $this->lang->line('tc_estado_borrador'). ' [' . $this->session->userdata('USU_ID').']['.$this->session->userdata('USU_NOMBRE').']';
            $estado = $this->tc_guardar( $id_teleconsulta, $tc['PRI_ID'], $data, $tc_data, $comentario, $info_tecnico );

            if( (int)$estado ) {

                $resp['div']    = 'deploy';
                $resp['msgt']   = 'OK';
                $resp['action'] = 'true';
                $resp['method'] = ( (int)$this->session->userdata('ROL_ID') == self::$ROL['ATENCION_CLIENTE'] ) ? base_url() . 'platc/tc_lista_view/2/' : base_url() . 'platc/tc_lista_view/1/' ;
                $resp['msg']    = $this->lang->line('tc_guardada_ok');

//                // Si el Cliente asociado al Generalista no tiene activo la funcionalidad de Revisor
//                // entonces envia correo ( ['CLI_REVISOR'] == 0 ) al especialista directamente
//                if( (int)$cliente['CLI_REVISOR'] == 0 )
//                    $this->correo_estado_nueva_enviada( $data['TEL_ID'] );

            } else {

                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('tc_error');
            }

        $this->output->set_output( json_encode($resp) );
    }

    private function  tc_guardar( $id_teleconsulta, $id_prioridad, $data, $tc_data ) {

        // Obtiene información de la TC
        $data['TEL_ID'] = $id_teleconsulta;
        $estado = (bool)$this->platc_model->tc_upd( $data );

        // Elimina la información del autoguardado para después guardar
        $estado &= (bool)$this->platc_model->tc_borrar_data( $id_teleconsulta );
        $estado &= (bool)$this->platc_model->tc_agregar_data( $id_teleconsulta, $tc_data );

        $estado &= (bool)$this->tc_cambio_estado($id_teleconsulta, $data['EST_ID'], $id_prioridad, $this->session->userdata('USU_ID') );

//                // Si el Cliente asociado al Generalista no tiene activo la funcionalidad de Revisor
//                // entonces envia correo ( ['CLI_REVISOR'] == 0 ) al especialista directamente
//                if( (int)$cliente['CLI_REVISOR'] == 0 )
//                    $this->correo_estado_nueva_enviada( $data['TEL_ID'] );

        return $estado;
    }

//    /**
//     * Envía correo al médico Especialista dando aviso del cambio de estado de la TC
//     * a examen enviado/nuevo.
//     * Asume que el estado de la TC sea enviada/nueva, así obtiene id del médico
//     * que envió.
//     */
//    private function correo_estado_nueva_enviada( $id_teleconsulta ) {
//
//        $tc = $this->platc_model->tc_get( $id_teleconsulta );
//
//        // Destinatario: Generalista
//        $estados  = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );
//        foreach( $estados as $estado ) {
//            if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
//                $id_generalista = $estado['USU_ID'];
//        }
//
//        // Remitente: Especialista
//        $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 7 );
//        foreach( $estados as $estado ) {
//            if( $estado['ROL_ID'] == self::$ROL['ESPECIALISTA'] )
//                $id_especialista = $estado['USU_ID'];
//        }
//
//        $datos = array( );
//        $datos[ 'tc' ]              = $tc;
//        $datos[ 'generalista' ]     = $this->platc_model->usuario_get( $id_generalista );
//        $datos[ 'especialista' ]    = $this->platc_model->usuario_get( $id_especialista );
//        $datos[ 'especialidad' ]    = $this->platc_model->especialidad_get( $tc['ESP_ID'] );
//
//        // Realiza configuración de librería "email" de CI. Como toda librería
//        // propia de CI, se usa la variable $this->email
//        $this->util->email_factory();
//        $plantilla_email = $this->platc_model->plantilla_email_get( $this->session->usersession('SIT_ID'), 2 );
//
//        // Desde: Médico generalista
//        $this->email->from( $datos['generalista']['USU_EMAIL'], $datos['generalista']['USU_NOMBRE'] );
//
//        // Hacia: Médico especialista
////        $this->email->to( $datos['especialista']['USU_EMAIL'] );
//        $this->email->to( 'certificacion.medsolutions@gmail.com' );
//
//        // Asunto
//        $this->load->library('parser');
//        $asunto  = $this->parser->parse( $plantilla_email['EMA_ASUNTO'], $datos );
//        $this->email->subject( $asunto );
//
//        // Mensaje
//        $mensaje = $this->parser->parse( $plantilla_email['EMA_TEXTO'], $datos );
//        $this->email->message( $mensaje );
//
//        $result = $this->email->send( );
//        log_message( 'INFO', $this->email->print_debugger() );
//
//        return true;
//    }

    /**
     * Elimina de forma definitiva una TC que se encuentra en
     * estado borrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_borrador_eliminar($id) {
        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] ) {
            if ($this->platc_model->tc_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la visualizacion de una teleconsulta
     * en estado "Enviada/Nueva".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_enviada_responder($estado = NULL, $id) {
       

        $this->load->library( 'HtmlPurifierWrapper' );
        $htmlpurifier = $this->htmlpurifierwrapper->HtmlPurifierFactory();

        // Obtiene teleconsulta
        // Genera parte paciente y datos de la TC
        $this->data['tc'] = $this->platc_model->tc_get($id);
//        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);

        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
      
            $this->data['examenes_anteriores']      = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );
        $this->data['examenes_anteriores_ris']  = 0;// $this->platc_model->paciente_examenes_anteriores_ris( $this->data['identificadores'][0]['TCI_VALOR'] );
        

        $this->data['paciente']                 = $this->platc_model->paciente_get( $this->data['tc']['PAC_ID'] );
        $this->data['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( $this->data['tc']['PAC_ID'] );

        // Compatibilidad con version nueva
        $this->data['mostrar_tcanteriores']    = TRUE;
        $this->data['tc_agendamientos_anteriores']  = $this->platc_model->tc_agendamientos_get($id, 3);

        // Campos RIPS
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $ent_administradoras = $this->platc_model->entidades_administradoras_get( );
            $this->data['ent_administradoras_select'] = $this->util->select_form_prepare( $ent_administradoras, 'ENTADM_ID', 'ENTADM_NOMBRE' );

            $finalidad_procedimiento = $this->platc_model->finalidad_procedimiento_get( );
            $this->data['finalidad_procedimiento_select'] = $this->util->select_form_prepare( $finalidad_procedimiento, 'FINPROC_ID', 'FINPROC_DESCRIPCION' );

            $ambito_procedimiento = $this->platc_model->ambito_procedimiento_get( );
            $this->data['ambito_procedimiento_select'] = $this->util->select_form_prepare( $ambito_procedimiento, 'AMBPROC_ID', 'AMBPROC_DESCRIPCION' );

            $zona_residencia = $this->platc_model->zona_residencia_get( );
            $this->data['zona_residencia_select'] = $this->util->select_form_prepare( $zona_residencia, 'ZON_ID', 'ZON_NOMBRE' );

            $municipio = $this->platc_model->municipios_get( );
            $this->data['municipio_select'] = $this->util->select_form_prepare( $municipio, 'MUNI_ID', 'MUNI_NOMBRE' );
        }

        $this->index('tc_enviadas_responder_view');

        /*
         * Inicio XML
         */
		 			
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */
        /*
         * Lógica para cargar información de datos de flujo Revisor
         */

        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data = array( );
            $data['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data['tel_revisor_solicitud_info_adicional'] = $htmlpurifier->purify( $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] );
            $data['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data['tc_id'] = $this->data['tc']['TEL_ID'];
            $data['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura

            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data = array( );
                $data['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data['tel_revisor_solicitud_info_adicional_resp'] = $htmlpurifier->purify( $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'] );
                $data['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data['tc_id']  = $this->data['tc']['TEL_ID'];
                $data['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data );
            }
        }

        // Carga botones: Solicitud de examenes, Responder y Rechazar
        // Prioridad
        $prioridad = array( 1 => $this->lang->line( 'prioridad_1' ),
                            2 => $this->lang->line( 'prioridad_2' ),
                            3 => $this->lang->line( 'prioridad_3' ) );
        $this->data[ 'tc_prioridad' ] = $prioridad;

        // Listado de motivos de rechazos
        $listado_motivos = $this->platc_model->motivo_rechazo_lista_get( $this->session->userdata('SIT_ID') );
        $this->data['listado_motivos_rechazo'] = $this->util->select_form_prepare( $listado_motivos, 'MR_ID', 'MR_DESCRIPCION' );

        // Listado de códigos CIE10 de respuesta ingresados por el autoguardar: Convierte data de DB a array de php
        // Compatibilidad de lógica con el parcial diagnostico medico de la proforma
        if( !empty( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) ) {
            $cie_id_respuestas = $this->platc_model->cie10_get( json_decode( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) );
            $cie_id_respuestas = $this->util->select_form_prepare( $cie_id_respuestas, 'CIE_ID', 'descripcion');
            unset( $cie_id_respuestas[''] ); // Elimina elemento vacío
            $this->data['tc']['TEL_CIE_ID_RESPUESTA'] = $cie_id_respuestas;
        }

        // Especialidad de respuesta
        $this->data['especialidad'] = $this->platc_model->especialidad_get( (int)$this->data['tc']['ESP_ID'] );
        if( ( $this->session->userdata('SIT_ID') == 25 || $this->session->userdata('SIT_ID') == 2 ) && $this->data['especialidad']['ESP_ARCHIVO_FORMULARIO'] == 'form_oftalmologia' ) {

            $this->data['oftalmo_data']['color']  = $this->platc_model->pe_oftalmologia_colores_get( );
            $this->data['oftalmo_data']['bordes'] = $this->platc_model->pe_oftalmologia_bordes_get( );
            $this->data['oftalmo_data']['macula'] = $this->platc_model->pe_oftalmologia_zonas_maculares_get( );
            $this->data['oftalmo_data']['diagnosticos']     = $this->platc_model->pe_oftalmologia_diagnosticos_get( );
            $this->data['oftalmo_data']['recomendaciones']  = $this->platc_model->pe_oftalmologia_controles_get( );
        }

        $this->data['tc']['TC_TELECONSULTA_RESPUESTA'] = $this->platc_model->tc_obtener_data_respuesta( (int)$this->data['tc']['TEL_ID'] );
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $this->data['tc']['FORMULAS']   = $this->platc_model->recetario_formulas_get( (int)$this->data['tc']['TEL_ID'],TRUE,0 );
            $this->data['tc']['RECETAS']    = $this->platc_model->recetarios_get( (int)$this->data['tc']['TEL_ID'],TRUE,0 );
			$this->data['tc']['ANEXOS']    = $this->platc_model->anexo_get( (int)$this->data['tc']['TEL_ID'] );
			
//			print_r($this->data['tc']['ANEXOS']);
//			echo $this->data['tc']['TEL_ID'];
//			die;
        }
		
		if( $this->session->userdata('SIT_ID') == 2 ) {
			//ACCION INDICADA
			$this->load->model('accion_indicada_model');
			$this->data['accion_indicada'] = $this->accion_indicada_model->select();

			//CONCORDANCIA DIAGNOSTICA
			$this->load->model('concordancia_diagnostica_model');
			$this->data['concordancia_diagnostica'] = $this->concordancia_diagnostica_model->select();
		}

        $this->index( 'forms/botones_enviadanueva' );

        // Generalistas solo visualizan examen enviado/nuevo: no necesitan marcar como tomado
        // Especialistas y revisores deben marcar TC enviada/nueva para responder
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] )
            $this->platc_model->tc_marcar_toma( (int)$id );
    }

    /**
     * Recibe los parametros de la edicion de una TC en estado "Enviada/Nueva"
     * segun estos se le cambia el estado segun corresponda o solo se guarda.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['estadoanterior'] estado anterior de la TC
     * @param string $_POST['conespecialista'] concepto del especialista de la TC
     * @return none
     */
    public function tc_enviada_responde() {

        $tc = $this->platc_model->tc_get( $this->input->post('tc_id') );

        if( $this->session->userdata('SIT_ID') == 22 &&
            count( $this->platc_model->get_existe_axo( $tc['TEL_ID'] ) ) == 0 &&
            count( $this->platc_model->recetario_formulas_get( $tc['TEL_ID'] ) ) == 0 ) {
            $resp = array( );
            $resp['action'] = 'false';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('recetario_recetario_formular_obligatorio');
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        if( $tc['EST_ID'] == 7 || $tc['EST_ID'] == 5 ) {

            $resp = array( );
            $resp['action'] = 'true';
            $resp['div']    = 'deploy';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('tc_respondido_anteriormente');
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $this->form_validation->set_rules('tc_id', '', 'required');
        $this->form_validation->set_rules('prioridad', '', 'required');
        $this->form_validation->set_rules('conespecialista', '', 'required');
        $this->form_validation->set_rules('estadoanterior', '', 'required');
        //campo asignado MODALIDAD DE ENVIO (SI2811)
		$this->form_validation->set_rules('modalidad_respuesta', '', 'required');

        // Campo requerido para CO y CL
        if( $this->session->userdata('SIT_ID') == 22 || $this->session->userdata('SIT_ID') == 2 ) {

            $this->form_validation->set_rules('dm_general_respuesta', '', 'required');
        }

        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA']) {
            $chk_control = FALSE;
            //if ($this->input->post('passwd') != '') {
			if ($this->input->post('guardarSinEnviar') == 0 && $this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE) {
                    $data['EST_ID'] = 7;
                    $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
                    $data['TEL_ABIERTA'] = 1;
                    $data['TEL_FECHA_HORA_RESPUESTA'] = date('Y-m-d') . " " . date('H:i:s');
                } else {
                    $data['EST_ID'] = $this->input->post('estadoanterior');
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = $this->input->post('estadoanterior');
            $data['TEL_ID'] = $this->input->post('tc_id');
            $data['PRI_ID'] = $this->input->post('prioridad');
            $data['TEL_MODALIDAD_RESPUESTA'] = $this->input->post('modalidad_respuesta');
            //$data['TEL_CON_ESPECIALISTA'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('conespecialista') );
            //$data['TEL_DIA_ESPECIALISTA'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('diaespecialista') );
            //$data['TEL_DIA_ORIENTACION']  = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('diaorientacion') );
            //$data['TEL_DIA_FUNDAMENTOS']  = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('diafundamentos') );
			
            $data['TEL_CON_ESPECIALISTA'] = $this->input->post('conespecialista');
            $data['TEL_DIA_ESPECIALISTA'] = $this->input->post('diaespecialista');
            $data['TEL_DIA_ORIENTACION']  = $this->input->post('diaorientacion');
            $data['TEL_DIA_FUNDAMENTOS']  = $this->input->post('diafundamentos');
			
			if($this->session->userdata('SIT_ID') == 2) {
				$data['CD_CONCORDANCIA_DIAGNOSTICA'] = ($this->input->post('concordancia_diagnostica')) ? 1 : 0;
				$data['CD_CONCORDANCIA_VALUES'] = ($this->input->post('concordancia_diagnostica_values')) ? json_encode($this->input->post('concordancia_diagnostica_values')) : "";
				$data['AI_ACCION_INDICADA_VALUES'] = ($this->input->post('accion_indicada_values')) ? json_encode($this->input->post('accion_indicada_values')) : "";
			}
			
            if ($this->platc_model->tc_upd($data)) {

                // Actualiza respuesta CIE10
                $codigos_cie_10_respuesta = $this->input->post('dm_general_respuesta');
                $this->platc_model->tc_update_cie10_respuesta( $data['TEL_ID'], $codigos_cie_10_respuesta );

                if ($this->input->post('estadoanterior') != $data['EST_ID'])
                    $this->tc_cambio_estado($this->input->post('tc_id'), $data['EST_ID'], $this->input->post('prioridad'), $this->session->userdata('USU_ID'));
                $resp['action'] = 'true';
                $resp['div'] = 'deploy';
                if ($this->input->post('estadoanterior') == 6)
                    $resp['method'] = base_url() . 'platc/tc_lista_view/6/';
                else
                    $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                if ($chk_control == TRUE) {
                    $resp['msgt'] = $this->lang->line('error');
                    unset( $resp['method'] );   // Permanece en la página cuando la contrasena es invalida
                    $resp['msg'] = $this->lang->line('tc_error_passwd');
                } elseif ($chk_control == FALSE && $data['EST_ID'] == $this->input->post('estadoanterior')) {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_guardada_ok');
                } else {

                    $this->correo_estado_respondido( (int)$data['TEL_ID'] );
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_enviada_ok');

                    // Desmarca toma
                    $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {

            $resp['action'] = 'false';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('complete_campos');

            // Campo requerido para CO y CL
            if( ($this->session->userdata('SIT_ID') == 22 || $this->session->userdata('SIT_ID') == 2 ) &&
                ( !isset( $_POST['dm_general_respuesta'] ) || empty( $_POST['dm_general_respuesta'] ) ) ) {
                $resp['msg'].= '<br/>'. $this->lang->line('ia_diapresuntivo');
            }

        }
        $this->output->set_output( json_encode($resp) );
    }

    /**
     * Envía correo al médico generalista dando aviso del cambio de estado de la TC
     * a examen respondido
     */
    private function correo_estado_respondido( $id_teleconsulta ) {

        if( (bool)$this->config->item( 'email_activo', 'platc' ) ) {

            $tc = $this->platc_model->tc_get( $id_teleconsulta );

            // Si se recibe desde respuesta de solicitud se envía correo al Generalista
            // que solicita el examen. Si no viene de solicitud de examen
            // ($this->platc_model->tc_ultimo_estado(x, 5) retorna vacío) entonces la TC
            // viene del estado enviada/nueva ($this->platc_model->tc_ultimo_estado(x, 2)
            // Destinatario: Generalista
            $estados  = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 6 );
            if( empty( $estados ) )
                $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );

            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
                    $id_generalista = $estado['USU_ID'];
            }

            // Remitente: Especialista
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 7 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['ESPECIALISTA'] )
                    $id_especialista = $estado['USU_ID'];
            }

            // Establece datos para el correo
            $especialista = $this->platc_model->usuario_get( $id_especialista );
            $generalista  = $this->platc_model->usuario_get( $id_generalista );

            $datos = array( );
            $datos[ 'id_teleconsulta' ]     = $tc['TEL_ID'];
            $datos[ 'nombre_generalista' ]  = $generalista['USU_NOMBRE'];
            $datos[ 'nombre_paciente' ]     = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO'] . ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' );
            $datos[ 'nombre_especialista' ] = $especialista['USU_NOMBRE'];
    //        $datos[ 'solicitud' ]           = $tc['TEL_SOL_ADICIONALES']; // TODO: ¿que poner?

            // Realiza configuración de librería "email" de CI. Como toda librería
            // propia de CI, se usa la variable $this->email
            $this->util->email_factory();
            $plantilla_email = $this->platc_model->plantilla_email_get( (int)$this->session->userdata('SIT_ID'), 7 );

            // Desde: Médico Especialista
            $this->email->from( $this->config->item( 'email_usuario', 'platc' ), $this->config->item( 'email_nombre_remitente', 'platc' ) );

            // Hacia: Médico Generalista
    //        $this->email->to( $datos['generalista']['USU_EMAIL'] );
            $this->email->to( 'certificacion.medsolutions@gmail.com' );

            // Asunto
            $this->load->library('parser');
            $asunto  = $this->parser->parse_string( (string)$plantilla_email['EMA_ASUNTO'], $datos );
            $this->email->subject( $asunto );

            // Mensaje
            $mensaje = $this->parser->parse_string( (string)$plantilla_email['EMA_TEXTO'], $datos );
            $this->email->message( nl2br( $mensaje ) );

            $result = $this->email->send( );
            log_message( 'INFO', $this->email->print_debugger() );

            return $result;
        }

        return TRUE;
    }

    /**
     * Pone en estado "Rechazada" a una TC que se encuentra en
     * estado "Enviada/Nueva" o "Respuesta de solicitud" (flujo desde generalista)
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_enviada_rechazar() {

        $tc = $this->platc_model->tc_get( $this->input->post('tc_id') );

        if( $tc['EST_ID'] == 3 || $tc['EST_ID'] == 5 || $tc['EST_ID'] == 7 ) {

            switch( (int)$tc['EST_ID'] ) {

                case 3 : $texto = $this->lang->line('tc_rechazada_anteriormente');
                case 5 : $texto = $this->lang->line('tc_sol_examen_pendiente');
                case 7 : $texto = $this->lang->line('tc_respondido_anteriormente');
            }

            $resp = array( );
            $resp['action'] = 'true';
            $resp['div']    = 'deploy';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
        if ($data_user != FALSE) {

            $id_tc = $this->input->post( 'tc_id', true );
            $motivo_id = $this->input->post( 'motivo_id', true );
            $motivo_comentario = $this->input->post( 'motivo_comentario' );

            $estado = $this->platc_model->tc_rechazar( $id_tc, $motivo_id, $motivo_comentario );
            if( $estado ) {
                $this->correo_estado_rechazado( $id_tc );
                $this->output->set_output('true');
            } else
                $this->output->set_output('false');
        } else {

            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('tc_error_passwd');
            $this->output->set_output( json_encode( $resp ) );
        }

    }

    /**
     * Envía correo al médico generalista dando aviso del cambio de estado de la TC
     * a examen respondido
     */
    private function correo_estado_rechazado( $id_teleconsulta ) {

        if( (bool)$this->config->item( 'email_activo', 'platc' ) ) {

            $tc         = $this->platc_model->tc_get( $id_teleconsulta );

            // Si se recibe desde solicitud de examen se envía correo al Generalista
            // que solicita el examen. Si no está en solicitud de examen
            // ($this->platc_model->tc_ultimo_estado(x, 5) retorna vacío) entonces la TC
            // viene del estado enviada/nueva ($this->platc_model->tc_ultimo_estado(x, 2)
            // Destinatario: Generalista
            $estados  = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 5 );
            if( empty( $estados ) )
                $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );

            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
                    $id_generalista = $estado['USU_ID'];
            }

            // Remitente: Especialista o Revisor
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 3 );
            foreach( $estados as $estado ) {
    //            if( $estado['ROL_ID'] == self::$ROL['ESPECIALISTA'] )
                if( $estado['ROL_ID'] == (int)$this->session->userdata('ROL_ID') )
                    $id_especialista = $estado['USU_ID'];
            }

            // Establece datos para el correo
            $especialista = $this->platc_model->usuario_get( $id_especialista );
            $generalista  = $this->platc_model->usuario_get( $id_generalista );

            $datos = array( );
            $datos[ 'id_teleconsulta' ]     = $tc['TEL_ID'];
            $datos[ 'nombre_generalista' ]  = $generalista['USU_NOMBRE'];
            $datos[ 'nombre_paciente' ]     = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO'] . ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' );
            $datos[ 'nombre_especialista' ] = $especialista['USU_NOMBRE'];
            $datos[ 'solicitud' ]           = $tc['TEL_SOL_ADICIONALES'];

            // Realiza configuración de librería "email" de CI. Como toda librería
            // propia de CI, se usa la variable $this->email
            $this->util->email_factory();
            $plantilla_email = $this->platc_model->plantilla_email_get( (int)$this->session->userdata('SIT_ID'), 3 );

            // Desde: Médico Especialista
            $this->email->from( $this->config->item( 'email_usuario', 'platc' ), $this->config->item( 'email_nombre_remitente', 'platc' ) );

            // Hacia: Médico Generalista
    //        $this->email->to( $datos['generalista']['USU_EMAIL'] );
            $this->email->to( 'certificacion.medsolutions@gmail.com' );

            // Asunto
            $this->load->library('parser');
            $asunto  = $this->parser->parse_string( (string)$plantilla_email['EMA_ASUNTO'], $datos );
            $this->email->subject( $asunto );

            // Mensaje
            $mensaje = $this->parser->parse_string( (string)$plantilla_email['EMA_TEXTO'], $datos );
            $this->email->message( nl2br( $mensaje ) );

            $result = $this->email->send( );
            log_message( 'INFO', $this->email->print_debugger() );

            return $result;
        }

        return TRUE;
    }

    /**
     * Vuelve la TC de estado "Rechazada" a estado "Enviada/Nueva".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_enviada_rechazar_revertir( ) {
        $id = $this->input->post( 'id' );
        $motivo = $this->input->post( 'motivo', true );

        $data['TEL_ID'] = $id;
        $data['EST_ID'] = 2;
        $data['TEL_ESTADO_ANT'] = 3;
        $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
        $this->tc_cambio_estado($id, 2, NULL, $this->session->userdata('USU_ID'), $motivo );
        if ($this->platc_model->tc_upd($data))
            echo 'true';
        else
            echo 'false';
    }

    /**
     * Pone en estado "Eliminada" a una TC, esta eliminacion es solo un cambio
     * de estado y se puede revertir.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_eliminar($id) {
//        if ((int)$this->session->userdata('ROL_ID') < 3) {
            $tc = $this->platc_model->tc_get($id);
            $data['TEL_ID'] = $id;
            $data['EST_ID'] = 4;
            $data['TEL_ESTADO_ANT'] = $tc['EST_ID'];
            $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            if ($this->platc_model->tc_upd($data)) {
                $this->tc_cambio_estado($id, $data['EST_ID'], NULL, $this->session->userdata('USU_ID'));
                echo 'true';
            }
            else
                echo 'false';
//        }
//        else
//            echo 'false';
    }

    /**
     * Vuelve al estado anterior a una TC que se encuentra en estado
     * "Eliminada".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_eliminar_revertir($id) {

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ) {

            $tc = $this->platc_model->tc_get($id);
            $data['TEL_ID'] = $id;
            $data['EST_ID'] = $tc['TEL_ESTADO_ANT'];
            $data['TEL_ESTADO_ANT'] = $tc['EST_ID'];
            $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            $this->tc_cambio_estado($id, $data['EST_ID'], $tc['PRI_ID'], $this->session->userdata('USU_ID'));
            if ($this->platc_model->tc_upd($data))
                echo 'true';
            else
                echo 'false';
        }
        else
            echo 'false';
    }

    /**
     * Pone en estado "Exam. Solicitados" a una TC que se encuentra en
     * estado "Enviada/Nueva" guardando en la db las solicitudes hechas por
     * el especialista.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['estadoanterior'] estado anterior de la TC
     * @param string $_POST['soladicionales'] soladicionales de la TC
     * @return none
     */
    public function tc_enviada_solex() {

        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( $tc['EST_ID'] == 7 || $tc['EST_ID'] == 5 || $tc['EST_ID'] == 3 ) {

            switch( (int)$tc['EST_ID'] ) {
                case 7: {$texto = $this->lang->line('tc_respondido_anteriormente');} break;
                case 5: {$texto = $this->lang->line('tc_sol_examen_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['div']    = 'deploy';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $this->form_validation->set_rules('tc_id', '', 'required');
        $this->form_validation->set_rules('prioridad', '', 'required');
        $this->form_validation->set_rules('estadoanterior', '', 'required');
        $this->form_validation->set_rules('soladicionales', '', 'required');
        if ($this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA']) {
            $data['TEL_ID'] = $this->input->post('tc_id');
            $data['PRI_ID'] = $this->input->post('prioridad');
            //$data['TEL_SOL_ADICIONALES'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('soladicionales') );
			$data['TEL_SOL_ADICIONALES'] = $this->input->post('soladicionales');
            $data['EST_ID'] = 5;
            $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
            $data['TEL_FECHA_HORA_SOLEXA'] = date('Y-m-d') . " " . date('H:i:s');
            if ($this->platc_model->tc_upd($data)) {
                $this->tc_cambio_estado($this->input->post('tc_id'), $data['EST_ID'], $this->input->post('prioridad'), $this->session->userdata('USU_ID'));

                // Envía correo avisando del cambio de estado a solicitud de examen
                $this->correo_estado_examen_solicitado( $data['TEL_ID'] );

                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('tc_enviada_ok');

                // Desmarca toma
                $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        $this->output->set_output( json_encode($resp) );
    }

    /**
     * Envía correo al médico generalista dando aviso del cambio de estado de la TC
     * a examen solicitado.
     * Asume que TC ya está en estado (5)Solicitud de examen: asi se sabe
     * quién hizo la solicitud para establecer el remitente ("from") en el mail
     */
    private function correo_estado_examen_solicitado( $id_teleconsulta ) {

        if( (bool)$this->config->item( 'email_activo', 'platc' ) ) {

            $tc = $this->platc_model->tc_get( $id_teleconsulta );

            // Destinatario es generalista. "foreach" necesario por si TC tiene historia de revisor
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
                    $id_generalista = $estado['USU_ID'];
            }

            // Remitente
            // TODO: Verificar si es usuario de sesion o de la historia quien se establece como Remitente: Por si especialista se desvincula
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 5 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['ESPECIALISTA'] )
                    $id_especialista = $estado['USU_ID'];
            }

            // Establece datos para el correo
            $especialista = $this->platc_model->usuario_get( $id_especialista );
            $generalista  = $this->platc_model->usuario_get( $id_generalista );

            $datos = array( );
            $datos[ 'id_teleconsulta' ]     = $tc['TEL_ID'];
            $datos[ 'nombre_generalista' ]  = $generalista['USU_NOMBRE'];
            $datos[ 'nombre_paciente' ]     = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO']. ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' );
            $datos[ 'nombre_especialista' ] = $especialista['USU_NOMBRE'];
            $datos[ 'solicitud' ]           = $tc['TEL_SOL_ADICIONALES'];

            // Realiza configuración de librería "email" de CI. Como toda librería
            // propia de CI, se usa la variable $this->email
            $this->util->email_factory();
            $plantilla_email = $this->platc_model->plantilla_email_get( (int)$this->session->userdata('SIT_ID'), 5 );

            // Desde:
            $this->email->from( $this->config->item( 'email_usuario', 'platc' ), $this->config->item( 'email_nombre_remitente', 'platc' ) );

            // Hacia: usuario medico destinatario
    //        $this->email->to( $datos['generalista']['USU_EMAIL'] );
            $this->email->to( 'certificacion.medsolutions@gmail.com' );

            // Asunto
            $this->load->library('parser');
            $asunto  = $this->parser->parse_string( (string)$plantilla_email['EMA_ASUNTO'], $datos );
            $this->email->subject( $asunto );

            // Mensaje
            $mensaje = $this->parser->parse_string( (string)$plantilla_email['EMA_TEXTO'], $datos );
            $this->email->message( nl2br( $mensaje ) );

            $result = $this->email->send( );
            log_message( 'INFO', $this->email->print_debugger() );

            return $result;
        }

        return TRUE;
    }

    /**
     * Deja un registro del cambio de estado en la historia de la TC.
     *
     * @access private
     * @param $tel_id Id de teleconsulta
     * @param $estid Nuevo estado de la teleconsulta
     * @param $priid Prioridad del estado de la teleconsulta
     * @param $usuid Usuario que establece el cambio.
     * @param $comentario Texto que describe cambio, mostrado en historial de la Teleconsulta
     * @param $info_tecnico Texto que describe cambio, usado como información de depuración
     * @return none
     */
    private function tc_cambio_estado($telid, $estid, $priid, $usuid, $comentario = null, $info_tecnico = null ) {
        $data['TEL_ID'] = $telid;
        $data['EST_ID'] = $estid;
        $data['PRI_ID'] = $priid;
        $data['USU_ID'] = $usuid;
        $data['TEP_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
        $data['TEP_COMENTARIO'] = $comentario;
        if( !empty( $info_tecnico ) ) $data['TEP_INFO_TECNICO'] = $info_tecnico;
        return $this->platc_model->tc_estado_set($data);
    }

    public function tc_ver( $id, $mostrar_tcanteriores = TRUE ) {

        $this->load->library( 'HtmlPurifierWrapper' );
        $htmlpurifier = $this->htmlpurifierwrapper->HtmlPurifierFactory();

        //
        $this->data['tc']               = $this->platc_model->tc_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get( $this->data['tc']['ETB_ID'] );
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);
		
        $this->data['examenes_anteriores']  = $this->platc_model->paciente_examenes_anteriores( $this->data['identificadores'][0]['TCI_VALOR'] );

        // Si no hay data de suceso, es por que TC está en borrador o fue eliminada en borrador
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        if( empty( $this->data['estado_enviada'] ) ){
            $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 1);
            if( empty( $this->data['estado_enviada'] ) ){
                $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 7);
            }
        }

        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);

        $this->data['mostrar_tcanteriores']    = ( $mostrar_tcanteriores === TRUE ) ? TRUE : FALSE;

        $this->load->view( 'tc_ver_view', $this->data );

        /*
         * Inicio XML
         */
        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar( $id, FormularioXML::$MODO_LECTURA );
        $this->output->append_output( $html );
        /*
         * Fin XML
         */

        /*
         * Lógica para cargar información de datos de flujo Revisor
         */
        $data_revisor_solicitud_examen = $this->platc_model->tc_revisor_obtener_solicitud_examen( $this->data['tc']['TEL_ID'] );
        if( !empty( $data_revisor_solicitud_examen ) && $data_revisor_solicitud_examen['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] ) {

            // Si se solicita examenes desde el revisor (una vez enviado desde el
            // estado enviada/nueva) carga vista de la solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data = array( );
            $data['revisor_nombre'] = $data_revisor_solicitud_examen['USU_NOMBRE'];
            $data['tel_revisor_solicitud_info_adicional'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'];
            $data['tep_fecha_hora'] = $data_revisor_solicitud_examen['TEP_FECHA_HORA'];
            $data['tc_id'] = $this->data['tc']['TEL_ID'];
            $data['modo'] = true;   // Carga archivos adjuntos de solo lectura
            $this->load->view( 'forms/parcial_revisor_solicitud_examen', $data );

            // Si se responden solicitudes de examenes desde el generalista (una vez enviado desde el
            // estado solicitud de examenes del revisor) carga vista de la respuesta de solicitud de examen
            // tanto para médicos generalistas como para revisor de solo lectura
            $data_revisor_solicitud_examen_resp = $this->platc_model->tc_revisor_obtener_solicitud_examen_resp( $this->data['tc']['TEL_ID'] );
            if( !empty( $data_revisor_solicitud_examen_resp ) ) {

                $data = array( );
                $data['revisor_nombre'] = $data_revisor_solicitud_examen_resp['USU_NOMBRE'];
                $data['tel_revisor_solicitud_info_adicional_resp'] = $this->data['tc']['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'];
                $data['tep_fecha_hora'] = $data_revisor_solicitud_examen_resp['TEP_FECHA_HORA'];
                $data['tc_id']  = $this->data['tc']['TEL_ID'];
                $data['modo']   = true;   // Carga archivos adjuntos de solo lectura
                $this->load->view( 'forms/parcial_revisor_solicitud_examen_resp', $data );
            }
        }

        /*
         * Lógica que carga solicitudes de exámenes del especialista
         */
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if( !empty( $this->data['estado_exsol'] ) ) {

            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            $this->data['modo'] = 1;    // Archivos respuesta especialista modo lectura
            $this->load->view( 'forms/parcial_solicitud_examenes', $this->data );

            // Carga formulario examenes realizados
            $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
            if( !empty( $this->data['estado_exreal'] ) ) {

                $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
                $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
                $this->load->view( 'forms/parcial_solicitud_examenes_resp', $this->data );
            }
        }

        // Carga respueta final de la TC
        $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
        $this->data['especialidad'] = $this->platc_model->especialidad_get( (int)$this->data['tc']['ESP_ID'] );
        if( !empty( $this->data['estado_contestada'] ) ) {

            if( ( $this->session->userdata('SIT_ID') == 25 || $this->session->userdata('SIT_ID') == 2 ) && $this->data['especialidad']['ESP_ARCHIVO_FORMULARIO'] == 'form_oftalmologia' ) {

                $oftalmo_data = array( );

                $data_respuesta = $this->platc_model->tc_obtener_data_respuesta( (int)$id );

                if( !empty( $data_respuesta ) ) {

                    foreach( $data_respuesta as $k => $v ) {

                        if( $this->util->is_json( $v ) )
                            $oftalmo_data[$k] = json_decode( $v );
                        else
                            $oftalmo_data[$k] = $htmlpurifier->purify( $v );
                    }

                    foreach( $oftalmo_data as $k => $v ) {

                        switch( $k ) {

                            case 'izquierdo_color'  : $oftalmo_data['izquierdo_color_nombre']   = $this->platc_model->pe_oftalmologia_color_get( (int)$v ); break;
                            case 'izquierdo_bordes' : $oftalmo_data['izquierdo_bordes_nombre']  = $this->platc_model->pe_oftalmologia_borde_get( (int)$v ); break;
                            case 'izquierdo_macula' : $oftalmo_data['izquierdo_macula_nombre']  = $this->platc_model->pe_oftalmologia_zona_macular_get( (int)$v ); break;
        //                    case 'izquierdo_arteriosclerosis'       : $this->lang->line('izquierdo_arteriosclerosis'); break;
        //                    case 'izquierdo_cruces_arteriovenosos'  : $this->lang->line('izquierdo_cruces_arteriovenosos'); break;
                            case 'izquierdo_retina' : $oftalmo_data['izquierdo_retina_nombre']  = $this->platc_model->pe_oftalmologia_retina_get( (int)$v ); break;
                            case 'derecho_color'    : $oftalmo_data['derecho_color_nombre']     = $this->platc_model->pe_oftalmologia_color_get( (int)$v ); break;
                            case 'derecho_bordes'   : $oftalmo_data['derecho_bordes_nombre']    = $this->platc_model->pe_oftalmologia_borde_get( (int)$v ); break;
                            case 'derecho_macula'   : $oftalmo_data['derecho_macula_nombre']    = $this->platc_model->pe_oftalmologia_zona_macular_get( (int)$v ); break;
        //                    case 'derecho_arteriosclerosis' : $this->lang->line('derecho_arteriosclerosis'); break;
        //                    case 'derecho_cruces_arteriovenosos'    : $this->lang->line('derecho_cruces_arteriovenosos'); break;
                            case 'derecho_retina'   : $oftalmo_data['derecho_retina_nombre']    = $this->platc_model->pe_oftalmologia_retina_get( (int)$v ); break;
                            case 'diagnosticos'     : $oftalmo_data['diagnosticos_nombre']      = $this->platc_model->pe_oftalmologia_diagnostico_get( (int)$v ); break;
                            case 'recomendaciones_control' : $oftalmo_data['recomendaciones_control_nombre'] = $this->platc_model->pe_oftalmologia_control_get( (int)$v ); break;
                        }
                    }
                }

                $this->data['oftalmo_data'] = $oftalmo_data;
            } else {

                $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
                $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);

                // Listado de códigos CIE10 de respuesta ingresados por el autoguardar: Convierte data de DB a array de php
                // Compatibilidad de lógica con el parcial diagnostico medico de la proforma
                if( !empty( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) ) {
                    $cie_id_respuestas = $this->platc_model->cie10_get( json_decode( $this->data['tc']['TEL_CIE_ID_RESPUESTA'] ) );
                    $cie_id_respuestas = $this->util->select_form_prepare( $cie_id_respuestas, 'CIE_ID', 'descripcion');
                    unset( $cie_id_respuestas[''] ); // Elimina elemento vacío
                    $this->data['tc']['TEL_CIE_ID_RESPUESTA'] = $cie_id_respuestas;
                }
            }

            $this->load->view( 'forms/parcial_respuesta_examen', $this->data );
        }
    }

    /**
     * Guarda en BD la evaluación del médico Generalista a la respuesta de la TC
     * otorgado por el especialista.
     * @param int $tel_id Identificador de la TC
     * @param string $texto_evaluacion Texto de la evaluación escrito por el generalista
     * @param int $nota_evaluacion Calificación (del 1 al 5) de la respuesta de la TC
     */
    public function tc_guardar_evaluacion( ) {

        $tel_id             = $this->input->post( 'tel_id' );
        $texto_evaluacion   = $this->input->post( 'texto_evaluacion' );
        $nota_evaluacion    = $this->input->post( 'nota_evaluacion' );
        $estado = $this->platc_model->tc_guardar_evaluacion( $tel_id, $texto_evaluacion, $nota_evaluacion );

        if( !empty( $estado ) )
            echo json_encode( array( 'action' => 'true' , 'msgt' => 'OK', 'div' => 'deploy', 'method' => base_url() . 'platc/tc_lista_view/7/', 'msg' => $this->lang->line( 'tc_evaluacion_cambio_satisfactorio' ) ) );
        else
            echo json_encode( array( 'action' => 'false', 'msgt' => $this->lang->line('error'), 'msg' => $this->lang->line( 'tc_evaluacion_cambio_fallido' ) ) );
    }

    /**
     * Guarda en BD la evaluación del médico Generalista a la respuesta de la TC
     * otorgado por el especialista.
     * @param int $tel_id Identificador de la TC
     * @param string $texto_evaluacion Texto de la evaluación escrito por el generalista
     * @param int $nota_evaluacion Calificación (del 1 al 5) de la respuesta de la TC
     */
    public function tc_guardar_evaluacion_solicitud( ) {

        $tel_id             = $this->input->post( 'tel_id' );
        $texto_evaluacion   = $this->input->post( 'texto_evaluacion' );
        $nota_evaluacion    = $this->input->post( 'nota_evaluacion' );
        $estado = $this->platc_model->tc_guardar_evaluacion_solicitud( $tel_id, $texto_evaluacion, $nota_evaluacion );

        if( !empty( $estado ) )
            echo json_encode( array( 'action' => 'true' , 'msgt' => 'OK', 'div' => 'deploy', 'method' => base_url() . 'platc/tc_lista_view/2/', 'msg' => $this->lang->line( 'tc_evaluacion_cambio_satisfactorio' ) ) );
        else
            echo json_encode( array( 'action' => 'false', 'msgt' => $this->lang->line('error'), 'msg' => $this->lang->line( 'tc_evaluacion_cambio_fallido' ) ) );
    }

    /**
     * Genera el select de los Grupos de un Site.
     *
     * @access public
     * @param none
     * @return none
     */
    public function grupos_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->grupos_site_get($_POST['id']);
        if ($first != FALSE && $first != 'Todos')
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['GRU_ID'])
                echo '<option  selected="selected" value="' . $r['GRU_ID'] . '">' . $r['GRU_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['GRU_ID'] . '">' . $r['GRU_NOMBRE'] . '</option>';
        }
    }

    /**
     * Genera el select de las especialidades de un Site.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_combobox($first) {
        $q = $this->platc_model->especialidades_site_get($_POST['id']);
        echo '<option value="0">' . $first . '</option>';
        foreach ($q as $r)
            echo '<option value="' . $r['ESP_ID'] . '">' . $r['ESP_NOMBRE'] . '</option>';
    }

    /**
     * Genera el select de las especialidades de un Site.
     * Usado en Búsqueda de TC
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_por_cliente( ) {

        $id_cliente = $this->input->post( 'id' );
        $q = $this->platc_model->especialidades_por_cliente( $id_cliente );
        $q = $this->util->select_form_prepare( $q, 'ESP_ID', 'ESP_NOMBRE' );

        $especialidades = $this->util->select_form_prepare( $this->data['usuario_especialidades'], 'ESP_ID', 'ESP_NOMBRE' );

        foreach ( $q as $k => $v ) {

            // Lógica especial para Especialista (rol=3): Retorna especialidades del cliente
            // que están también en su especialidad. Este if salta iteración si no encuentra
            // especialidades del cliente que coincida con alguno de las especialidades del usuario
            // en sesión.
            if( $this->session->userdata( 'ROL_ID' ) == 3 && !array_key_exists( $k, $especialidades ) )
                continue;

            echo '<option value="' . $k . '">' . $v . '</option>';
        }
    }

    /**
     * Genera el select de las especialidades a las que un usuario tiene acceso según
     * su configuración de grupos. Lógica usada para usuarios a los que se le
     * asocien grupos como Supervisores y Especialistas
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_por_usuario( ) {

        $id_usuario = $this->input->post( 'id' );

        $q = $this->platc_model->especialidades_por_usuario( $id_usuario );
        $q = $this->util->select_form_prepare( $q, 'ESP_ID', 'ESP_NOMBRE' );
        foreach ( $q as $k => $v )
            echo '<option value="' . $k . '">' . $v . '</option>';
    }

    /**
     * Genera el select de los Clientes de un Grupos.
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->clientes_grupo_get($_POST['id']);
        if ($first != FALSE && $first != 'Todos')
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['CLI_ID'])
                echo '<option  selected="selected" value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
        }
    }

    /**
     * Genera el select de los Clientes según Site
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes_combobox_por_site( $default = '', $first = FALSE ) {

        $id_site = $this->input->post('id');

        $q = $this->platc_model->clientes_get( $id_site );
        if ($first != FALSE && $first != 'Todos')
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';

        if( !empty( $q ) )
            foreach ($q as $r) {
                if ($default == $r['CLI_ID'])
                    echo '<option  selected="selected" value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
                else
                    echo '<option value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
            }
    }

    /**
     * Genera el select de los Establecimientos de un Cliente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establs_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->establs_cliente_get($_POST['id']);
        if ($first != FALSE)
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['ETB_ID'])
                echo '<option  selected="selected" value="' . $r['ETB_ID'] . '">' . $r['ETB_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['ETB_ID'] . '">' . $r['ETB_NOMBRE'] . '</option>';
        }
    }

    /**
     * Retorna listado de establecimientos en función del identificador del cliente
     * String de retorno en el siguiente formato:
     * array(   array( 'id' => '1', 'nombre' => 'establecimiento1' ),
     *          array( 'id' => '2', 'nombre' => 'establecimiento2' ), ... )
     *
     * @access public
     * @param int $id_cliente Identificador del cliente
     * @return string Listado de establecimientos en formato JSON
     */
    public function establecimientos_combobox( $id_cliente ) {

        $establecimientos = $this->platc_model->establs_cliente_get( $id_cliente );

        $listado_establecimientos = array( );
        foreach( $establecimientos as $establecimiento ) {

            $e = array( 'id' => $establecimiento['ETB_ID'], 'nombre' => $establecimiento['ETB_NOMBRE'] );
            $listado_establecimientos[] = $e;
        }

        $this->output->set_output( json_encode( $listado_establecimientos ) );
    }

    /**
     * Genera el select de los Especialistas de una Especialidad.
     *
     * @deprecated Especialistas se asocian a grupos usando mantenedor grupos
     * Por lo que no tiene sentido mostrar un combo que permita la selección
     * de un elemento en particular
     * @access public
     * @param none
     * @return none
     */
    public function especialistas_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->especialistas_especialidad_get($_POST['id']);
        if ($first != FALSE)
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['USU_ID'])
                echo '<option  selected="selected" value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
        }
    }

    /**
     * Setea variables de session con parametros del autcomplete de la busqueda.
     *
     * @access public
     * @param none
     * @return none
     */
    public function autocomplete_select($tipo, $id = NULL) {
        if ($tipo == 'especialidad')
            $data['autocomplete_especialidad'] = $id;
        else if ($tipo == 'cliente')
            $data['autocomplete_cliente'] = $id;
        else if ($tipo == 'establ')
            $data['autocomplete_establ'] = $id;
        $this->session->set_userdata($data);
    }

    /**
     * Genera el select de los Generalistas (medicos y no medicos) de una Establecimiento.
     *
     * @access public
     * @param none
     * @return none
     */
    public function generalistas_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->generalistas_establecimiento_get($_POST['id']);
        if ($first != FALSE)
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['USU_ID'])
                echo '<option  selected="selected" value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
        }
    }

    /**
     * Agrega comentarios al archivo(s) adjuntadado(s) a la TC.
     *
     * @access public
     * @param int $_POST['tipo'] tipo de archivo
     * @param int $_POST['file'] nombre del archivo
     * @param int $_POST['comment'] comentario del archivo
     * @return none
     */
    public function attach_file_comment($tipo, $id) {
        $this->form_validation->set_rules('file', '', 'required');
        if ($this->form_validation->run() != FALSE ) {
            $file = $this->input->post('file');
            if ($tipo == 1)
                $filecom = $this->path_file['users'] . $id . '/' . $file . '.comment';
            else if ($tipo == 2)
                $filecom = $this->path_file['borradores'] . $id . '/' . $file . '.comment';
            else if ($tipo == 3)
                $filecom = $this->path_file['enviadas'] . $id . '/' . $file . '.comment';
            else if ($tipo == 4)
                $filecom = $this->path_file['exam_solicitados'] . $id . '/' . $file . '.comment';
            else if ($tipo == 5)
                $filecom = $this->path_file['exam_realizados'] . $id . '/' . $file . '.comment';
            else if ($tipo == 6)
                $filecom = $this->path_file['sol_adicional'] . $id . '/' . $file . '.comment';
            else if ($tipo == 7)
                $filecom = $this->path_file['respuesta'] . $id . '/' . $file . '.comment';
            else if ($tipo == 8)
                $filecom = $this->path_file['revisor_sol_adicional'] . $id . '/' . $file . '.comment';
            else if ($tipo == 9)
                $filecom = $this->path_file['revisor_respuesta_sol_adicional'] . $id . '/' . $file . '.comment';

            // Si existe archivo de comentario, se elimina para crear uno nuevo
            if( is_file( $filecom ) )
                @unlink($filecom);

            $f = fopen($filecom, 'a+');

            // Nombre ayuda
            if ($this->input->post('nombre_ayuda') == '')
                $comment[ ]= html_entity_decode( $this->lang->line('sin_comentario') );
            else
                $comment[ ]= $this->input->post('nombre_ayuda');

            // Observacion ayuda
            if ($this->input->post('ayuda_observacion') == '')
                $comment[ ]= $this->lang->line('sin_comentario');
            else
                $comment[ ]= $this->input->post('ayuda_observacion');

            // Observacion_ayuda
            if ($this->input->post('valoracion_ayuda') == '')
                $comment[ ]= $this->lang->line('sin_comentario');
            else
                $comment[ ]= $this->input->post('valoracion_ayuda');
            fwrite($f, implode( '##', $comment ) );
            fclose($f);
            $resp['action'] = 'false';
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('ok_comentario') . ' ' . $file;
            echo json_encode($resp);
        }
    }

    /**
     * Elimina algun archivo subido al servidor antes de que se envie la TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function attach_file_drop($tipo = NULL, $id = NULL, $file = NULL, $user = NULL) {
//        $file=str_replace('oooooo','.', $file);
        if ($tipo != NULL && is_numeric($tipo) && $id != NULL && is_numeric($id) && $file != NULL) {
            if ($tipo == 1)
                $delfile = $this->path_file['users'] . $id . '/' ;
            else if ($tipo == 2)
                $delfile = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 3)
                $delfile = $this->path_file['enviadas'] . $id . '/';
            else if ($tipo == 4)
                $delfile = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 5)
                $delfile = $this->path_file['exam_realizados'] . $id . '/';
            else if ($tipo == 6)
                $delfile = $this->path_file['sol_adicional'] . $id . '/';
            else if ($tipo == 7)
                $delfile = $this->path_file['respuesta'] . $id . '/';
            else if ($tipo == 8)
                $delfile = $this->path_file['revisor_sol_adicional'] . $id . '/';
            else if ($tipo == 9)
                $delfile = $this->path_file['revisor_respuesta_sol_adicional'] . $id . '/';

            // Realiza respaldo de archivos a eliminar
            if( !is_dir( $delfile.'borrados/' ) && !@mkdir( $delfile.'borrados/' ) )
                throw new ErrorException( 'No se pudo crear carpeta de archivos eliminados: ['. $delfile.'borrados/' .']' );
            if( is_dir( $delfile.'borrados/' ) ) {
                rename( $delfile.$file, $delfile.'borrados/'.date('YmdHis').'_'.$file );

                if( is_file( $delfile.$file.'.comment' ) )
                    rename( $delfile.$file.'.comment', $delfile.'borrados/'.date('YmdHis').'_'.$file.'.comment' );
            }

            $this->attach_file($tipo, $id, $user, TRUE );
        }
    }

    /**
     * Muestra los archivos atachados a una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function attach_file($tipo = NULL, $id = NULL, $user = NULL, $modo = TRUE) {

        $this->load->library( 'FormularioXML' );

        if ($tipo != NULL && is_numeric($tipo) && $id != NULL && is_numeric($id)) {
            if ($tipo == 1)
                $dir = $this->path_file['users'] . $id . '/';
            else if ($tipo == 2)
                $dir = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 3)
                $dir = $this->path_file['enviadas'] . $id . '/';
            else if ($tipo == 4)
                $dir = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 5)
                $dir = $this->path_file['exam_realizados'] . $id . '/';
            else if ($tipo == 6)
                $dir = $this->path_file['sol_adicional'] . $id . '/';
            else if ($tipo == 7)
                $dir = $this->path_file['respuesta'] . $id . '/';
            else if ($tipo == 8)
                $dir = $this->path_file['revisor_sol_adicional'] . $id . '/';
            else if ($tipo == 9)
                $dir = $this->path_file['revisor_respuesta_sol_adicional'] . $id . '/';
//            else
//                break;
            $this->data['archivos'] = NULL;
            $this->data['folder']   = $dir;
            $this->data['tipo']     = $tipo;
            $this->data['id']       = $id;
            $this->data['modo']     = ( ( $modo == 1 ) || ( $modo == TRUE ) ) &&
                                      ( (int)$this->session->userdata('ROL_ID') != Platc::$ROL['ADMIN'] ) ? FormularioXML::$MODO_LECTURA : FormularioXML::$MODO_ESCRITURA;

            $archivos = array( );

            if( is_dir( $dir ) ) {

                $directorio = opendir($dir);
                while( $archivo = readdir( $directorio ) ) {

                    $archivo= str_replace("Ñ","N",$archivo);
                    if( $archivo != "." && $archivo != ".." && substr($archivo, -8) != ".comment" && $archivo != 'borrados' ) {

                        $a = array( );
                        $a['nombre']        = $archivo;
                        if( is_file( $dir . $archivo . ".comment" ) ) {

                            $temp = explode( '##', $this->util->lee_archivo( $dir . $archivo . ".comment" ) );
                            $a['comentario']    = $temp[0];
                            $a['observacion']   = $temp[1];
                            $a['evaluacion']    = $temp[2];
                        } else {

                            // sin archivo .comment (sin comentario, observación ni evaluación)
                            $a['comentario']    = utf8_encode( html_entity_decode( $this->lang->line('sin_comentario') ) );
                            $a['observacion']   = '';
                            $a['evaluacion']    = 0;
                        }

                        $archivos[] = $a;
                    }
                }
            }

            $this->data['archivos'] = $archivos;

            $this->index('attach_files_view');
        }
    }

    /**
     * Metodo que genera arreglo con todos los archivos atachados de una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function attach_file_arr($tipo = NULL, $id = NULL) {
        $archivos = NULL;
        if ($id != NULL && is_numeric($id)) {
            if ($tipo == 1)
                $dir = $this->path_file['users'] . $id . '/';
            else if ($tipo == 2)
                $dir = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 3)
                $dir = $this->path_file['enviadas'] . $id . '/';
            else if ($tipo == 4)
                $dir = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 5)
                $dir = $this->path_file['exam_realizados'] . $id . '/';
            else if ($tipo == 6)
                $dir = $this->path_file['sol_adicional'] . $id . '/';
            else if ($tipo == 8)
                $dir = $this->path_file['revisor_sol_adicional'] . $id . '/';
            else if ($tipo == 9)
                $dir = $this->path_file['revisor_respuesta_sol_adicional'] . $id . '/';
//            else
//                break;
            $this->data['archivos'] = NULL;
            $this->data['folder'] = $dir;
            $this->data['id'] = $id;
            if (is_dir($dir)) {
                $directorio = opendir($dir);
                while ($archivo = readdir($directorio)) {
                    if ($archivo != "." && $archivo != ".." && substr($archivo, -8) != ".comment")
                        $archivos[] = $archivo;
                }
            }
            return $archivos;
        }
    }

    /**
     * Mueve el contenido de un directorio a otro, dependiendo del
     * estado de la TC.
     *
     * @access private
     * @param none
     * @return none
     */
    private function dir_move($dir1, $dir2) {
        if (is_dir($dir1) && is_dir($dir2)) {
            $directorio = opendir($dir1);
            while ($archivo = readdir($directorio)) {
                if ($archivo != "." && $archivo != "..") {
                    @copy($dir1 . $archivo, $dir2 . $archivo);
                    @unlink($dir1 . $archivo);
                }
            }
            @rmdir($dir1);
        }
    }

    /**
     * Sube al servidor un archivo, esto para adjuntarlo
     * a una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function upload_file($tipo = NULL, $id = NULL) {

        $exito = true;

        if (!empty($_FILES)) {
            if ($tipo == 1)
                $dir = $this->path_file['users'] . $id . '/';
            else if ($tipo == 2)
                $dir = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 3)
                $dir = $this->path_file['enviadas'] . $id . '/';
            else if ($tipo == 4)
                $dir = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 5)
                $dir = $this->path_file['exam_realizados'] . $id . '/';
            else if ($tipo == 6)
                $dir = $this->path_file['sol_adicional'] . $id . '/';
            else if ($tipo == 7)
                $dir = $this->path_file['respuesta'] . $id . '/';
            else if ($tipo == 8)
                $dir = $this->path_file['revisor_sol_adicional'] . $id . '/';
            else if ($tipo == 9)
                $dir = $this->path_file['revisor_respuesta_sol_adicional'] . $id . '/';
//            else
//                break;
            if (!is_dir($dir))
                mkdir(str_replace('//', '/', $dir), 0755, true);
            $temp_file = $_FILES['Filedata']['tmp_name'];
            $name_file = $this->util->quitar_acentos($_FILES['Filedata']['name']);
            $name_file = str_replace(' ', '_', $name_file);
            $name_file = str_replace('(', '-', $name_file);
            $name_file = str_replace(')', '-', $name_file);
			$name_file = str_replace('Ñ', 'N', $name_file);
			$name_file = str_replace('ñ', 'n', $name_file);
            $dir = str_replace('//', '/', $dir);
            $target_file = $dir . $name_file;
            $ext[] = 'doc';
            $ext[] = 'docx';
            $ext[] = 'xls';
            $ext[] = 'xlsx';
            $ext[] = 'pdf';
            $ext[] = 'jpg';
            $ext[] = 'gif';
            $ext[] = 'png';
            $ext[] = 'bmp';
            $ext[] = 'tiff';
            $ext[] = 'rtf';
            $ext[] = 'rar';
            $ext[] = 'zip';
            $ext[] = '7z';
            $ext[] = 'tar';
            $ext[] = 'tgz';
            $ext_file = explode('.', $name_file);
            $resp = 0;
            $large = count($ext_file);
            foreach ($ext as $e) {
                if ($e == strtolower($ext_file[$large - 1]))
                    $resp = 1;
            }
            if ($resp == 1) {
                $i = 1;
                while (is_file($target_file)) {
                    $name_file = '';
                    for ($j = 0; $j < $large - 1; $j++) {
                        $name_file .= $ext_file[$j] . '.';
                    }
                    $target_file = $dir . $name_file . $i . '.' . $ext_file[$large - 1];
                    $i++;
                }
                move_uploaded_file($temp_file, $target_file);
            }
            echo $resp;
        }

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function entregar_token( ) {

        $data_user = $this->platc_model->login($this->input->post('mail'), md5($this->input->post('pass')));
        if ($data_user != FALSE) {
            $data_user['logged_in'] = TRUE;
            if( $data_user['ROL_ID'] == self::$ROL['ESPECIALISTA'] ) {
                $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($data_user['USU_ID']);
                $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($data_user['USU_ID']);
                $data_user['grupos'] = $this->platc_model->grupos_por_usuario( $data_user['USU_ID'] );
            }
            $this->session->set_session($data_user);

            // Cambia de idioma según el usuario acreditado
            $this->language = $this->session->userdata('IDI_NOMBRE');
            $this->lang->load( $this->language, $this->language );
        }
    }

    /**
     * Metodo que exporta una TC a PDF.
     * a una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function exportar_pdf( $id, $token = null ) {


        if( ( empty( $token ) && $this->session->is_logged() ) ||
            (!empty( $token ) && $this->es_token_valido( $token ) )  ) {

            $datos = $this->tc_pdf( $id );

            $this->load->library( 'FormularioXML' );
            $this->formularioxml->establecer_datos_pdf( $datos );
            $ruta_salida = $this->formularioxml->generar( $id, FormularioXML::$MODO_PDF );

//            if( empty( $token ) )
                $this->output->set_output('<script>window.location.href="'.$ruta_salida.'";</script>');
//            else
//                $this->output->set_output( $ruta_salida );
        }

    }

    private function es_token_valido( $token ) {

        $estado = $this->platc_model->comprobar_token( $token );
        return (bool)$estado;
    }

    /**
     * Carga la vista que luego es tomada para generar el PDF.
     *
     * @access private
     * @param none
     * @return none
     */
    

    private function tc_pdf( $id ) {

        $this->load->library( 'HtmlPurifierWrapper' );
        $htmlpurifier = $this->htmlpurifierwrapper->HtmlPurifierFactory();

        $this->data['tc'] = $this->platc_model->tc_get($id);
		//SI641 Corrige TC contestadas para la visualizacion
		if(!empty($this->data['tc']) && is_array($this->data['tc'])){ 
			foreach($this->data['tc'] as $key => &$col){
				if(in_array(strtolower($key),array('tel_obs_adicionales'))
					|| in_array(strtolower($key),array('tel_dia_presuntivo'))
					|| in_array(strtolower($key),array('tel_tra_actual'))
					|| in_array(strtolower($key),array('tel_con_especialista'))
					|| in_array(strtolower($key),array('tel_dia_especialista'))
					|| in_array(strtolower($key),array('tel_dia_fundamentos'))
					|| in_array(strtolower($key),array('tel_sol_adicionales'))
					|| in_array(strtolower($key),array('tel_sol_adicionales_resp'))
					|| in_array(strtolower($key),array('tel_sol_adicionales_resp'))
					|| in_array(strtolower($key),array('tel_revisor_solicitud_info_adicional'))
					|| in_array(strtolower($key),array('tel_revisor_solicitud_info_adicional_resp'))
					)
				{
					$col = preg_replace("/\r\n+|\r+|\n+|\t+/i", "\n\n", $col);
				}
			}
		}
		//FIN SI641
        $this->data['tc']['datos'] = $this->platc_model->tc_obtener_data( $id );

        //(SI2811)
	   //seteamos la variable cuando se carga a cero para generarla en el pdf
        if( $this->data['tc']['TEL_MODALIDAD_RESPUESTA']=='0' )
            unset( $this->data['tc']['TEL_MODALIDAD_RESPUESTA'] );

        if( isset( $this->data['tc']['datos']['dm_general'] ) && !empty( $this->data['tc']['datos']['dm_general'] ) )
            $this->data['tc']['datos']['dm_general_valor'] = $this->util->select_form_prepare( $this->platc_model->cie10_get( json_decode( $this->data['tc']['datos']['dm_general'] ) ), 'CIE_ID', 'descripcion' );

        // Elimina registro vacío que se agrega al usar $this->util->select_form_prepare
        if( isset( $this->data['tc']['datos']['dm_general_valor'][''] ) )
            unset( $this->data['tc']['datos']['dm_general_valor'][''] );

        $this->data['tc']['TEL_MOTIVO_TEXTO'] = $this->lang->line( 'tc_mot_'.$this->data['tc']['TEL_MOTIVO'] );
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        if( empty( $this->data['estado_enviada'] ) ){
            $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 1);
            if( empty( $this->data['estado_enviada'] ) ){
                $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 7);
            }
        }
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['file3'] = $this->attach_file_arr(3, $id);
        $this->data['especialidad'] = $this->platc_model->especialidad_get($this->data['tc']['ESP_ID']);

        if( $this->data['tc']['EST_ID'] >= 5 && $this->data['tc']['EST_ID'] <= 7) {
            if ($this->data['tc']['TEL_SOL_ADICIONALES'] != NULL) {

                // Limpiar código HTML/XML
                $this->data['tc']['TEL_SOL_ADICIONALES'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES'] );
                $this->data['file6'] = $this->attach_file_arr(6, $id);
                $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
                $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
                $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            }
            if ($this->data['tc']['TEL_SOL_ADICIONALES_RESP'] != NULL) {
                $this->data['tc']['TEL_SOL_ADICIONALES_RESP'] = $htmlpurifier->purify( $this->data['tc']['TEL_SOL_ADICIONALES_RESP'] );
                $this->data['file5'] = $this->attach_file_arr(5, $id);
                $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
                $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
                $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
            }
            if ( $this->data['tc']['EST_ID'] == 7 ) {
                $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
                $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
                $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
                $this->data['cie10_respuesta']  = $this->platc_model->cie10_respuesta_get( $this->data['tc']['TEL_ID'] );
            }
        }
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['estado'] = $this->data['tc']['EST_ID'];

        /**
         * TODO: Específico para especialidades, sacar esta lógica de aquí
         */
        $esp = $this->platc_model->especialidad_get( $this->data['tc']['ESP_ID'] );
        if( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_derma_lesion' ) == 0 ) {

            $this->data['tc']['datos']['form_derma_lesion'] = $this->platc_model->derma_lesion_obtener( $id );
        } elseif( ( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_oftalmologia' ) == 0 ) && ($this->session->userdata('SIT_ID') == 2 ) ) {

            $this->data['tc']['datos']['form_oftalmologia'] = $this->platc_model->cl_oftalmologia_obtener( $id );
        } elseif( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_otorrinologia' ) == 0 ) {

            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CABEZA'] ] = $this->platc_model->otorrino_cabeza_obtener( $id );
            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BOCA'] ]   = $this->platc_model->otorrino_boca_obtener( $id );
            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_IZQUIERDO'] ] = $this->platc_model->otorrino_oido_izquierdo_obtener( $id );
            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_DERECHO'] ]   = $this->platc_model->otorrino_oido_derecho_obtener( $id );
            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_IZQUIERDO'] ] = $this->platc_model->otorrino_nariz_izquierdo_obtener( $id );
            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_DERECHO'] ]   = $this->platc_model->otorrino_nariz_derecho_obtener( $id );
            $this->data['tc']['datos']['form_otorrino'][ Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CUELLO'] ]   = $this->platc_model->otorrino_cuello_obtener( $id );
        } elseif( ( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_oftalmologia' ) == 0 ||
                    strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_oftalmologia_plantilla' ) == 0 ) && $this->data['tc']['SIT_ID'] == 22 ) {

            // TODO: sacar función "element", editar lógica en platc_model
            $this->data['tc']['datos']['form_oftalmologia'][ Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] ] = element( Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'], $this->platc_model->oftalmologia_obtener( $id, Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] ) );
            $this->data['tc']['datos']['form_oftalmologia'][ Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] ]           = element( Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'], $this->platc_model->oftalmologia_obtener( $id, Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] ) );
            $this->data['tc']['datos']['form_oftalmologia'][ Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] ]= element( Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'], $this->platc_model->oftalmologia_obtener( $id, Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] ) );
            $this->data['tc']['datos']['form_oftalmologia'][ Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] ]         = element( Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'], $this->platc_model->oftalmologia_obtener( $id, Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] ) );

        } elseif( strcmp( $esp['ESP_ARCHIVO_FORMULARIO'], 'form_oftalmologia' ) == 0 && ( $this->data['tc']['SIT_ID'] == 25 ) ) {

            $this->data['tc']['datos']['form_oftalmologia'] = array();

            /*
             * Imagenes adjuntas al crear TC (estado: nueva/enviada)
             */
            $img = $this->platc_model->pe_oftalmologia_imagenes_obtener( $id );
            if( !empty( $img ) ) {

                $i = element( Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'],  $img );
                if( !empty( $i ) ) {

                    if( !isset( $this->data['tc']['datos']['form_oftalmologia']['enviada'] ) )
                        $this->data['tc']['datos']['form_oftalmologia']['enviada'] = array();

                    $this->data['tc']['datos']['form_oftalmologia']['enviada'][ Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] ] = $i;
                }

                $d = element( Platc::$OFTALMOLOGICO_LADO['DERECHO'],  $img );
                if( !empty( $d ) ) {

                    if( !isset( $this->data['tc']['datos']['form_oftalmologia']['enviada'] ) )
                        $this->data['tc']['datos']['form_oftalmologia']['enviada'] = array();

                    $this->data['tc']['datos']['form_oftalmologia']['enviada'][ Platc::$OFTALMOLOGICO_LADO['DERECHO'] ]   = $d;
                }
            }

            /*
             * Respuesta de la TC (estado: respondida)
             */
            $respuesta = $this->platc_model->tc_obtener_data_respuesta( $id );
            if( !empty( $respuesta ) ) {

                $this->data['tc']['datos']['form_oftalmologia']['respondida'] = array();
                $this->data['tc']['datos']['form_oftalmologia']['respondida'] = $respuesta;
            }
        }

        /*
         * Recetas y Fórmulas
         */
        $this->data['tc']['recetas']  = $this->platc_model->recetas_get( (int)$id );
        $this->data['tc']['formulas'] = $this->platc_model->formulas_get( (int)$id );

		if($this->session->userdata('SIT_ID') == 2){
			//ACCION INDICADA
			$this->load->model('accion_indicada_model');
			$this->data['accion_indicada'] = $this->accion_indicada_model->select();

			//CONCORDANCIA DIAGNOSTICA
			$this->load->model('concordancia_diagnostica_model');
			$this->data['concordancia_diagnostica'] = $this->concordancia_diagnostica_model->select();
		}		
		
		  /*
         * Anexo 3 FFARIAS
         */
		 
		 $this->data['tc']['anexo3']  = $this->platc_model->anexo3_get( (int)$id );
		 
		 $this->data['tc']['cups_list']    = $this->platc_model->anexo_obtener_cups_lista( (int)$id);
		 $this->data['tc']['diagnosticos_list']    = $this->platc_model->cie10_respuesta_get( (int)$id);
        /*
         * Datos del paciente
         */
        $this->data['tc']['paciente_data']      = $this->platc_model->paciente_get( $this->data['tc']['PAC_ID'] );
 	    $this->data['tc']['paciente_identificadores_data'] = $this->platc_model->paciente_identificadores_get(  $this->data['tc']['PAC_ID'] );
 		$this->data['tc']['guiaspracticas_list']    = $this->platc_model->guias_practicas_list_get();

		
    	$departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$this->data['tc']['paciente_data']['DEP_ID']);
		$this->data['tc']['data_depto_paciente']=$departamento_data;
		
		$municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$this->data['tc']['paciente_data']['MUNI_ID']);
		$this->data['tc']['data_munic_paciente']=$municipio_data;

        $entidad_adm_data = $this->platc_model->get_info_entidad_administradora($this->data['tc']['paciente_data']['EA_ID']);
		$this->data['tc']['data_entadm_paciente']=$entidad_adm_data;
		
		$establecimiento_data = $this->platc_model->get_info_table_param('TC_ESTABLECIMIENTO','ETB_ID',(int)$this->data['tc']['ETB_ID']);
		$this->data['tc']['data_establecimiento']=$establecimiento_data;
		

        $establec_departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$this->data['tc']['data_establecimiento']['ETB_DPTO_ID']);
		$this->data['tc']['data_depto_establec']=$establec_departamento_data;
		
		$establec_municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$this->data['tc']['data_establecimiento']['ETB_MUNI_ID']);
		$this->data['tc']['data_munic_establec']=$establec_municipio_data;

        // Datos médico Especialista (Profesional)
        $this->data['tc']['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $this->data['tc']['especialista_identificacion'] = $this->platc_model->identificador_get( $this->data['tc']['especialista']['IDT_ID'] );
		
        return $this->data;
    }

    /**
     * Busca una TC segun el id de esta, esto para la vista de busqueda de TC.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC que se esta buscando
     * @return none
     */
    public function buscar_tc_id() {
        $this->form_validation->set_rules('tcid', '', 'required');
        if ($this->form_validation->run() != FALSE) {
            $resp['action'] = 'true';
            $resp['method'] = base_url() . 'platc/busqueda_tcid_datagrid/' . $this->input->post('tcid') . '/';
            $resp['div'] = 'deploy_search_tc';
            $resp['msgt'] = 'false';
            $resp['msg'] = 'false';
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Muestra el resultado de la busqueda por ID de una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function busqueda_tcid_datagrid($id) {

        $this->data['teleconsultas'] = $this->platc_model->busca_tcid($id);
        if ($this->data['teleconsultas'] != NULL) {
            // TODO: Se establece estos valores para compatibilidad con grilla en tc_busqueda_datagrid_view.php
            $r['identificador'] = $this->platc_model->tc_ident_get($id);
            $this->data['teleconsultas'][0]['PAC_IDT_VALOR']    = $r['identificador'][0]['TCI_VALOR'];
            $this->data['teleconsultas'][0]['hora_envio']       = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($id, 2) );
            $this->data['teleconsultas'][0]['hora_solexam']     = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($id, 5) );
            $this->data['teleconsultas'][0]['hora_respuesta']   = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($id, 7) );
            $this->data['teleconsultas'][0]['usu_especialista'] = element( 'USU_NOMBRE', $this->platc_model->busca_tc_estado($id, 7) );
        }
        $this->session->set_userdata($this->data);
        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Metodo que recibe los datos para la busqueda de TC,
     * los valida y busca.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['site'] site para la busqueda
     * @param int $_POST['grupo'] grupo para la busqueda
     * @param int $_POST['cliente'] cliente para la busqueda
     * @param int $_POST['especialidad'] especialidad para la busqueda
     * @param int $_POST['estado'] estado para la busqueda
     * @param string $_POST['generalista'] estado para la busqueda
     * @param string $_POST['especialista1'] especialista que solicito examenes adicionales
     * @param string $_POST['especialista2'] especialista que contesto
     * @return none
     */

    public function buscar_tc() {
//imprimir( $_POST );

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] )
            $this->form_validation->set_rules('grupo', '', 'required');

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] || (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] )
            $this->form_validation->set_rules('cliente', '', 'required');

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] )
            $this->form_validation->set_rules('establ', '', 'required');

        
		// SI1383 ffarias  campos fecha desde hasta 
		$this->form_validation->set_rules('estado', '', 'required');
		$this->form_validation->set_rules('fecha_env_desde', '', 'required');
		$this->form_validation->set_rules('fecha_env_hasta', '', 'required');
		// SI1383  ffarias
        if ($this->form_validation->run() != FALSE) {

            if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] )
                $grupo = $this->input->post('grupo');
            $grupo = empty( $grupo ) ? 0 : $grupo;

            if( (int)$this->session->userdata('ROL_ID') == self::$ROL['ADMIN'] ||
                (int)$this->session->userdata('ROL_ID') == self::$ROL['SUPERVISOR'] ||
                (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] )
                $c = $this->input->post('cliente');
            $c = empty( $c ) ? 0 : $c;

            $e = $this->input->post('establ');
            $e = !empty( $e ) ? $e : 0;
            if ($this->input->post('generalista') != '') {
                $gen = $this->platc_model->usuario_busca_get($this->input->post('generalista'));
                if ($gen != NULL)
                    $g = $gen['USU_ID'];
                else
                    $g = 0;
            }
            else
                $g = 0;
            $es = $this->input->post('especialidad');
            $es = empty( $es ) ? 0 : $es;
            if ($this->input->post('especialista1') != '') {
                $esp1 = $this->platc_model->usuario_busca_get($this->input->post('especialista1'));
                if ($esp1 != NULL)
                    $es1 = $esp1['USU_ID'];
                else
                    $es1 = 0;
            }
            else
                $es1 = 0;
            if ($this->input->post('especialista2') != '') {
                $esp2 = $this->platc_model->usuario_busca_get($this->input->post('especialista2'));
                if ($esp2 != NULL)
                    $es2 = $esp2['USU_ID'];
                else
                    $es2 = 0;
            }
            else
                $es2 = 0;
            $est = $this->input->post('estado');
            if ($this->input->post('fecha_env_desde') != '' && $this->input->post('fecha_env_hasta') != '') {
                $f = explode('/', $this->input->post('fecha_env_desde'));
                $fenv_des = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha1 = str_replace('/', '-', $this->input->post('fecha_env_desde'));
                $f = explode('/', $this->input->post('fecha_env_hasta'));
                $fenv_has = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha2 = str_replace('/', '-', $this->input->post('fecha_env_hasta'));
            } else {
                $fenv_des = 0;
                $fecha1 = 'Todas';
                $fenv_has = 0;
                $fecha2 = 'Todas';
            }
            if ($this->input->post('fecha_con_desde') != '' && $this->input->post('fecha_con_hasta') != '') {
                $f = explode('/', $this->input->post('fecha_con_desde'));
                $fcon_des = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha3 = str_replace('/', '-', $this->input->post('fecha_con_desde'));
                $f = explode('/', $this->input->post('fecha_con_hasta'));
                $fcon_has = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha4 = str_replace('/', '-', $this->input->post('fecha_con_hasta'));
            } else {
                $fcon_des = 0;
                $fecha3 = 'Todas';
                $fcon_has = 0;
                $fecha4 = 'Todas';
            }
            $resp['action'] = 'true';
            $resp['method'] = base_url() . 'platc/busqueda_tc_datagrid/' . $c . '/' . $e . '/' . $g . '/' . $es . '/' . $es1 . '/' . $es2 . '/' . $est . '/' . $fenv_des . '/' . $fenv_has . '/' . $fcon_des . '/' . $fcon_has . '/' . $fecha1 . '/' . $fecha2 . '/' . $fecha3 . '/' . $fecha4 . '/' . $grupo . '/';
            $resp['div'] = 'deploy_search_tc';
            $resp['msgt'] = 'false';
            $resp['msg'] = 'false';
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = $this->lang->line('complete_camposReqTit');
            $resp['msg'] = $this->lang->line('complete_camposReq');
        }
        echo json_encode($resp);
    }

    /**
     * Realiza listado de TC en función del identificador del paciente
     * siendo el identificador del paciente el RUT o equivalente
     * @param int $idt_paciente ID del paciente
     * @return none
     */
    public function buscar_tc_idt_paciente( $idt_paciente ) {

        $id_site = $this->session->userdata( 'SIT_ID' );
        $listado_tc = $this->platc_model->busca_tc_id_paciente( $idt_paciente, $id_site );

        $this->data['teleconsultas'] = $listado_tc;
        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Realiza listado de TC en función del nombre o apellido del paciente
     */
    public function buscar_tc_na_paciente( ) {

        $nombre     = $this->input->post( 'nombre_paciente', true );
        $apellido   = $this->input->post( 'apellido_paciente', true );
        $id_site    = $this->session->userdata( 'SIT_ID' );
        $listado_tc = $this->platc_model->busca_tc_na_paciente( $id_site, $nombre, $apellido );

        $this->data['teleconsultas'] = $listado_tc;

        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Busca las TC segun parametros recibidos por GET, ademas prepara los datos
     * para guardar el reporte que luego se podra exportar a PDF o Excel segun corresponda al rol.
     *
     * @access public
     * @param none
     * @return none
     */
    public function busqueda_tc_datagrid($c, $e, $g, $es, $es1, $es2, $est, $fenv_des, $fenv_has, $fcon_des, $fcon_has, $fecha1, $fecha2, $fecha3, $fecha4, $grupo ) {
 // ffarias
        $data['cliente'] = $c;
        $data['establ'] = $e;
        $data['generalista'] = $g;
        $data['especialidad'] = $es;
        $data['especialista1'] = $es1;
        $data['especialista2'] = $es2;
        $data['estado'] = $est;
        $data['fecha_env_desde'] = $fenv_des;
        $data['fecha_env_hasta'] = $fenv_has;
        $data['fecha_con_desde'] = $fcon_des;
        $data['fecha_con_hasta'] = $fcon_has;
        $data['grupo'] = $grupo;

       
	   
	   	$listado_tc_temp =  $this->platc_model->buscar_tc_b_imp($data);
        $this->data['teleconsultas']=$listado_tc_temp->result_array();
				
					
	    
	  // imprimir($this->platc_model->buscar_tc_b_imp($data));
	    if ($this->data['teleconsultas'] != NULL) {
           
            foreach ($this->data['teleconsultas'] as $i => $tc) {

                // TODO: Se establece estos valores para compatibilidad con grilla en tc_busqueda_datagrid_view.php
                $r['identificador'] = $this->platc_model->tc_ident_get($tc['TEL_ID']);

                $this->data['teleconsultas'][$i]['PAC_IDT_VALOR']    = $r['identificador'][0]['TCI_VALOR'];
                $this->data['teleconsultas'][$i]['hora_envio']       = $tc['TEL_FECHA_HORA_ENVIO'];
                $this->data['teleconsultas'][$i]['hora_solexam']     = $tc['TEL_FECHA_HORA_SOLEXA'];
                $this->data['teleconsultas'][$i]['hora_respuesta']   = $tc['TEL_FECHA_HORA_RESPUESTA'];
                $this->data['teleconsultas'][$i]['usu_especialista'] = $tc['usu_especialista'];
            }
        }
        $this->index('tc_busqueda_datagrid_view');
    }

    public function busqueda_tc_cache() {
        $this->data['teleconsultas'] = $this->session->userdata('teleconsultas');
        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Exporta a Excel la busqueda realizada.
     *
     * @access public
     * @param none
     * @return none
     */
    public function exportar_busq_xls( ) {

        $form = $this->input->post( 'form' );
        //echo $form ;
		//exit();
        // 1) Obtiene listado de teleconsultas
        $data       = array( );
        $id_site    = $this->session->userdata( 'SIT_ID' );

        switch( $form ) {
            case 'paciente_id_form' : {
                    $idt_paciente = $this->input->post( 'paciente_id_inpt' );
                    $listado_tc = $this->platc_model->busca_tc_id_paciente( $idt_paciente, $id_site );

                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;

            case 'paciente_na_form' : {
                    $nombre     = $this->input->post( 'paciente_nombre_inpt' );
                    $apellido   = $this->input->post( 'paciente_apellido_inpt' );
                    $listado_tc = $this->platc_model->busca_tc_na_paciente( $id_site, $nombre, $apellido );

                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;

            case 'tcid_form' : {
				    //imprimir("aqui1");
                    $tc_id      = $this->input->post( 'tcid' );
                    $listado_tc = $this->platc_model->busca_tcid( $tc_id );
//imprimir( $listado_tc );
                    // Se hereda data desde $this->busqueda_tcid_datagrid()
                    // Se cambia para ajuste con nueva lógica
                    $r['identificador'] = $this->platc_model->tc_ident_get($tc_id);
                    $listado_tc[0]['PAC_IDT_VALOR']    = $r['identificador'][0]['TCI_VALOR'];
                    $listado_tc[0]['hora_envio']       = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($tc_id, 2) );
                    $listado_tc[0]['hora_solexam']     = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($tc_id, 5) );
                    $listado_tc[0]['hora_respuesta']   = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($tc_id, 7) );
                    $listado_tc[0]['usu_especialista'] = element( 'USU_NOMBRE', $this->platc_model->busca_tc_estado( $listado_tc[0]['TEL_ID'], 7) );

                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;

            case 'buscar_form' : {
                    //imprimir("aqui2");
                    $data['cliente']        = $this->input->post( 'cliente' );
                    $data['establ']         = $this->input->post( 'establ' );
                    $data['generalista']    = $this->input->post( 'generalista' );
                    $data['especialidad']   = $this->input->post( 'especialidad' );
                    $data['especialista1']  = $this->input->post( 'especialista1' );
                    $data['especialista2']  = $this->input->post( 'especialista2' );
                    $data['estado']         = $this->input->post( 'estado' );
                    $data['fecha_env_desde'] = $this->input->post( 'fecha_env_desde' );
                    $data['fecha_env_hasta'] = $this->input->post( 'fecha_env_hasta' );
                    $data['fecha_con_desde'] = $this->input->post( 'fecha_con_desde' );
                    $data['fecha_con_hasta'] = $this->input->post( 'fecha_con_hasta' );

                    $data['generalista']    = !empty( $data['generalista'] ) ? element( 'USU_ID', $this->platc_model->usuario_busca_get($this->input->post('generalista' ) ) ) : null;
                    $data['especialista1']  = !empty( $data['especialista1'] ) ? element( 'USU_ID', $this->platc_model->usuario_busca_get($this->input->post('especialista1') ) ) : null;
                    $data['especialista2']  = !empty( $data['especialista2'] ) ? element( 'USU_ID', $this->platc_model->usuario_busca_get($this->input->post('especialista2') ) ) : null;
                    $data['fecha_env_desde'] = !empty( $data['fecha_env_desde'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_env_desde' ) ) ) : null;
                    $data['fecha_env_hasta'] = !empty( $data['fecha_env_hasta'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_env_hasta' ) ) ) : null;
                    $data['fecha_con_desde'] = !empty( $data['fecha_con_desde'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_con_desde' ) ) ) : null;
                    $data['fecha_con_hasta'] = !empty( $data['fecha_con_hasta'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_con_hasta' ) ) ) : null;


					$listado_tc_temp =  $this->platc_model->buscar_tc_b_imp($data);//ffarias SI1434


					$listado_tc=   $listado_tc_temp->result_array();
				    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {
                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;
        }

        // 2) Datos generales (como cabezera del formulario)
        $datos_generales = array( );
        $datos_generales['REP_SITE'] = $this->session->userdata( 'SIT_NOMBRE' );

        $datos_generales['REP_CLIENTES']                = !empty( $data['cliente'] ) ? element( 'CLI_NOMBRE', $this->platc_model->cliente_get( $data['cliente'] ) ) : $this->lang->line( 'todos' );
        $datos_generales['REP_FECHA_CONTESTADA_DESDE']  = !empty( $data['hora_respuesta'] ) ? $this->util->fecha_orden( $data['hora_respuesta'] ) : $this->lang->line( 'todos' );
        $datos_generales['REP_FECHA_ENVIADA_DESDE']     = !empty( $data['fecha_env_desde'] ) ? $this->util->fecha_orden( $data['fecha_env_desde'] ) : $this->lang->line( 'todas' );
        $datos_generales['REP_FECHA_ENVIADA_HASTA']     = !empty( $data['fecha_env_hasta'] ) ? $this->util->fecha_orden( $data['fecha_env_hasta'] ): $this->lang->line( 'todas' );
        $datos_generales['REP_TOTAL']                   = count( $listado_tc );
        $datos_generales['REP_ESTADO']                  = !empty( $data['estado'] ) ? $this->lang->line( 'estado_'.$data['estado'] ) : $this->lang->line( 'todos' );
        $datos_generales['REP_ESPECIALIDAD']            = !empty( $data['especialidad'] ) ? element( 'ESP_NOMBRE', $this->platc_model->especialidad_get( $data['especialidad'] ) ) : $this->lang->line( 'todas' );
        $datos_generales['REP_ESPECIALISTA_CONTESTADA'] = !empty( $data['usu_especialista'] ) ? $data['usu_especialista'] : $this->lang->line( 'todos' );

        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
        $objPHPExcel->setActiveSheetIndex(0);

        $i = 1;

		// Fila de cabezera de tabla
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'tc_establ' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'tc_time_envio' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'tc_especialidad_busqueda' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'tc_time_exsol' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'tc_time_contestada' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( $this->lang->line( 'tc_especialista_contesto' ) ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( "Fecha Solic. Examen" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( "Estado" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('M'.$i, html_entity_decode( "Edad" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('N'.$i, html_entity_decode( "Sexo" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('O'.$i, html_entity_decode( "CIE10" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('P'.$i, html_entity_decode( "CIE10 descripci&oacute;n" ) );
		$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':P'.$i)->getFont()->setBold(true);
		$i++; // Salto de línea
		
        // 3) Completa filas por clientes
        if( !empty( $listado_x_cliente ) ) {

            // Completa filas por teleconsulta
            foreach( $listado_x_cliente as $cliente => $listado_tc ) {
				/*
                // Nombre del cliente
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'cliente' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, $cliente );
				$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':M'.$i)->getFont()->setBold(true);

                // Fila de cabezera de tabla
                $i++; // Salto de línea
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
				$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'tc_establ' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'tc_time_envio' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'tc_especialidad_busqueda' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'tc_time_exsol' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'tc_time_contestada' ) ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( $this->lang->line( 'tc_especialista_contesto' ) ) );
				$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( "Fecha Solic. Examen" ) );
				*/
				
				if(isset($tc['glo_estado']) && $tc['glo_estado']){
					switch($tc['glo_estado']){
						case 'Eliminada':
								//$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, html_entity_decode( "Fecha Eliminación" ) );
								$objPHPExcel->getActiveSheet()->SetCellValue('K1', html_entity_decode( "Fecha Eliminación" ) );
								break;  
						case 'Rechazada':
								//$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, html_entity_decode( "Fecha Rechazo" ) );
								$objPHPExcel->getActiveSheet()->SetCellValue('K1', html_entity_decode( "Fecha Rechazo" ) );
								break;  
						default:
								//$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, html_entity_decode( "Fecha Creación TC" ) );
								$objPHPExcel->getActiveSheet()->SetCellValue('K1', html_entity_decode( "Fecha Creación TC" ) );

					}
				}
				else{
					$objPHPExcel->getActiveSheet()->SetCellValue('K1', html_entity_decode( "Fecha Creación TC" ) );
				}
				
				
				
//				if ($tc['glo_estado']=='Eliminada' ) {
	//				$objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( "Fecha Eliminación" ) );
		//		}else {
		//		    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( "Fecha Creación TC" ) );
			//	}
				/*
				$objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( "Estado" ) );
				$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':L'.$i)->getFont()->setBold(true);
                $i++; // Salto de línea
				*/
				
                foreach( $listado_tc as $tc ) {
					//CIE10
					$array_cie10 = "";
					if(isset($tc['TEL_CIE_ID_RESPUESTA']) && $tc['TEL_CIE_ID_RESPUESTA']){
						$cie10_respuesta = json_decode($tc['TEL_CIE_ID_RESPUESTA']);
						foreach($cie10_respuesta as $cie10){
							 if(!empty($cie10)){
								$result = $this->platc_model->cie10_get($cie10);
								foreach($result as $row){
									$array_cie10['cie10'][] = $row['id10'];
									$array_cie10['dec10'][] = $row['dec10'];
								}
							}
						}
					}
					//FIN
					
                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $tc['TEL_ID']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $tc['PAC_IDT_VALOR']);
					$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $tc['TEL_PAC_PRIMER_NOMBRE'].' '.$tc['TEL_PAC_PRIMER_APELLIDO'] . ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' ) );
					$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $tc['ETB_NOMBRE']);
					$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, isset( $tc['TEL_FECHA_HORA_ENVIO'] ) && !empty( $tc['TEL_FECHA_HORA_ENVIO'] ) ? $this->util->fecha_orden2( $tc['TEL_FECHA_HORA_ENVIO'] ) : '' );
					$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $tc['ESP_NOMBRE']);
					$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, isset( $tc['TEL_FECHA_HORA_SOLEXA'] ) && !empty( $tc['TEL_FECHA_HORA_SOLEXA'] ) ? $this->util->fecha_orden2( $tc['TEL_FECHA_HORA_SOLEXA'] ) : '' );
					$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, isset( $tc['TEL_FECHA_HORA_RESPUESTA'] ) && !empty( $tc['TEL_FECHA_HORA_RESPUESTA'] ) ? $this->util->fecha_orden2( $tc['TEL_FECHA_HORA_RESPUESTA'] ) : '' );
					$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, isset( $tc['usu_especialista'] ) && !empty( $tc['usu_especialista'] ) ? $tc['usu_especialista'] : '' );
					$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(10);
					$objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, isset( $tc['TEL_FECHA_HORA_REVISOR_SOLEXA'] ) && !empty( $tc['TEL_FECHA_HORA_REVISOR_SOLEXA'] ) ? $tc['TEL_FECHA_HORA_REVISOR_SOLEXA'] : '' );
					$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);

					if(isset($tc['glo_estado']) && $tc['glo_estado']){
						switch($tc['glo_estado']){
							case 'Eliminada':
								$objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, isset( $tc['TEL_FECHA_HORA'] ) && !empty( $tc['TEL_FECHA_HORA'] ) ? $tc['TEL_FECHA_HORA'] : '' );		
								$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
									break;  
							case 'Rechazada':
								$objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, isset( $tc['TEL_FECHA_HORA_RECHAZO'] ) && !empty( $tc['TEL_FECHA_HORA_RECHAZO'] ) ? $tc['TEL_FECHA_HORA_RECHAZO'] : '' );
								$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
									break;  
							default:
								$objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, isset( $tc['TEL_FECHA_HORA'] ) && !empty( $tc['TEL_FECHA_HORA'] ) ? $tc['TEL_FECHA_HORA'] : '' );
								$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
						}
					}
					else{
						$objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, isset( $tc['TEL_FECHA_HORA'] ) && !empty( $tc['TEL_FECHA_HORA'] ) ? $tc['TEL_FECHA_HORA'] : '' );
						$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
					}
					
					$objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, isset( $tc['glo_estado'] ) && !empty( $tc['glo_estado'] ) ? $tc['glo_estado'] : '' );
					$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, isset( $tc['TEL_PAC_EDAD'] ) && !empty( $tc['TEL_PAC_EDAD'] ) ? $tc['TEL_PAC_EDAD'] : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) ? $tc['TEL_PAC_SEXO'] : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, (($array_cie10 && array_key_exists('cie10',$array_cie10) && is_array($array_cie10['cie10'])) ? implode("\n",$array_cie10['cie10']) : "") );
					$objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, (($array_cie10 && array_key_exists('dec10',$array_cie10) && is_array($array_cie10['dec10'])) ? implode("\n",$array_cie10['dec10']) : "") );
                    $i++; // Salto de línea
                }

                //$i++; // Salto de línea
            }

            $objPHPExcel->getActiveSheet()->setTitle('Simple');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $excel_name = 'reporte_temporal.xls';
            $file_path = $this->path_file['excel'] . $excel_name;
		    $objWriter->save($this->path_file['excel'] . $excel_name);
            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename=reporte_' . date('YmdHis') . '.xls');
            header('Cache-Control: public');
            header('Content-Description: File Transfer');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path));
            header('Pragma: no-cache');
            header('Expires: 0');
            readfile($file_path);
            unlink($file_path);
        }
    }

    /**
     * Exporta a PDF la busqueda realizada.
     *
     * @access public
     * @param none
     * @return none
     */
    public function exportar_busq_pdf( ) {

        $form = $this->input->post( 'form' );

        // 1) Obtiene listado de teleconsultas
        $data       = array( );
        $id_site    = $this->session->userdata( 'SIT_ID' );

        switch( $form ) {
            case 'paciente_id_form' : {
                    $idt_paciente = $this->input->post( 'paciente_id_inpt' );
                    $listado_tc = $this->platc_model->busca_tc_id_paciente( $idt_paciente, $id_site );

                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;

            case 'paciente_na_form' : {
                    $nombre     = $this->input->post( 'paciente_nombre_inpt' );
                    $apellido   = $this->input->post( 'paciente_apellido_inpt' );
                    $listado_tc = $this->platc_model->busca_tc_na_paciente( $id_site, $nombre, $apellido );

                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;

            case 'tcid_form' : {
                    $tc_id      = $this->input->post( 'tcid' );
                    $listado_tc = $this->platc_model->busca_tcid( $tc_id );
//imprimir( $listado_tc );
                    // Se hereda data desde $this->busqueda_tcid_datagrid()
                    // Se cambia para ajuste con nueva lógica
                    $r['identificador'] = $this->platc_model->tc_ident_get($tc_id);
                    $listado_tc[0]['PAC_IDT_VALOR']    = $r['identificador'][0]['TCI_VALOR'];
                    $listado_tc[0]['hora_envio']       = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($tc_id, 2) );
                    $listado_tc[0]['hora_solexam']     = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($tc_id, 5) );
                    $listado_tc[0]['hora_respuesta']   = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($tc_id, 7) );
                    $listado_tc[0]['usu_especialista'] = element( 'USU_NOMBRE', $this->platc_model->busca_tc_estado( $listado_tc[0]['TEL_ID'], 7) );

                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;

            case 'buscar_form' : {

                    $data['cliente']        = $this->input->post( 'cliente' );
                    $data['establ']         = $this->input->post( 'establ' );
                    $data['generalista']    = $this->input->post( 'generalista' );
                    $data['especialidad']   = $this->input->post( 'especialidad' );
                    $data['especialista1']  = $this->input->post( 'especialista1' );
                    $data['especialista2']  = $this->input->post( 'especialista2' );
                    $data['estado']         = $this->input->post( 'estado' );
                    $data['fecha_env_desde'] = $this->input->post( 'fecha_env_desde' );
                    $data['fecha_env_hasta'] = $this->input->post( 'fecha_env_hasta' );
                    $data['fecha_con_desde'] = $this->input->post( 'fecha_con_desde' );
                    $data['fecha_con_hasta'] = $this->input->post( 'fecha_con_hasta' );

                    $data['generalista']    = !empty( $data['generalista'] ) ? element( 'USU_ID', $this->platc_model->usuario_busca_get($this->input->post('generalista' ) ) ) : null;
                    $data['especialista1']  = !empty( $data['especialista1'] ) ? element( 'USU_ID', $this->platc_model->usuario_busca_get($this->input->post('especialista1') ) ) : null;
                    $data['especialista2']  = !empty( $data['especialista2'] ) ? element( 'USU_ID', $this->platc_model->usuario_busca_get($this->input->post('especialista2') ) ) : null;
                    $data['fecha_env_desde'] = !empty( $data['fecha_env_desde'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_env_desde' ) ) ) : null;
                    $data['fecha_env_hasta'] = !empty( $data['fecha_env_hasta'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_env_hasta' ) ) ) : null;
                    $data['fecha_con_desde'] = !empty( $data['fecha_con_desde'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_con_desde' ) ) ) : null;
                    $data['fecha_con_hasta'] = !empty( $data['fecha_con_hasta'] ) ? $this->util->fecha_orden( str_replace( '/', '-', $this->input->post( 'fecha_con_hasta' ) ) ) : null;

                    //$listado_tc = $this->platc_model->buscar_tc_b($data);
					$listado_tc_temp =  $this->platc_model->buscar_tc_b_imp($data);//ffarias SI1434
                    $listado_tc=   $listado_tc_temp->result_array();
                    // Realiza agrupamiento por cliente de cada item del listado
                    if ( !empty( $listado_tc ) ) {

                        $listado_x_cliente = array( );
                        foreach( $listado_tc as $tc )
                            $listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
                    }
                }; break;
        }

        // 2) Datos generales (como cabezera del formulario)
        $datos_generales = array( );
        $datos_generales['REP_SITE'] = $this->session->userdata( 'SIT_NOMBRE' );

        $datos_generales['REP_CLIENTES']                = !empty( $data['cliente'] ) ? element( 'CLI_NOMBRE', $this->platc_model->cliente_get( $data['cliente'] ) ) : $this->lang->line( 'todos' );
        $datos_generales['REP_FECHA_CONTESTADA_DESDE']  = !empty( $data['hora_respuesta'] ) ? $this->util->fecha_orden( $data['hora_respuesta'] ) : $this->lang->line( 'todos' );
        $datos_generales['REP_FECHA_ENVIADA_DESDE']     = !empty( $data['fecha_env_desde'] ) ? $this->util->fecha_orden( $data['fecha_env_desde'] ) : $this->lang->line( 'todas' );
        $datos_generales['REP_FECHA_ENVIADA_HASTA']     = !empty( $data['fecha_env_hasta'] ) ? $this->util->fecha_orden( $data['fecha_env_hasta'] ): $this->lang->line( 'todas' );
        $datos_generales['REP_TOTAL']                   = count( $listado_tc );
        $datos_generales['REP_ESTADO']                  = !empty( $data['estado'] ) ? $this->lang->line( 'estado_'.$data['estado'] ) : $this->lang->line( 'todos' );
        $datos_generales['REP_ESPECIALIDAD']            = !empty( $data['especialidad'] ) ? element( 'ESP_NOMBRE', $this->platc_model->especialidad_get( $data['especialidad'] ) ) : $this->lang->line( 'todas' );
        $datos_generales['REP_ESPECIALISTA_CONTESTADA'] = !empty( $data['usu_especialista'] ) ? $data['usu_especialista'] : $this->lang->line( 'todos' );

//        $this->load->library('reporte_fpdf');
//        $pdf = new Reporte_FPDF();
//        $pdf->datos_generales( $datos_generales );
//        $pdf->datos_tabulados( $listado_x_cliente );
//        $pdf->AliasNbPages();
//        $pdf->Output();

	$this->load->library('Pdf');
	$pdf = new TCPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor('Medical Solution');
	$pdf->SetTitle('Reporte');
	$pdf->SetSubject('-');
	$pdf->SetKeywords('-');
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "REPORTE", "Teleconsultas");
	$pdf->setHeaderFont(Array('helvetica', '', '8'));
    $pdf->setFooterFont(Array('helvetica', '', '9'));
	
	// set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
	
	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	
	// set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	
	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/spa.php')) {
		require_once(dirname(__FILE__).'/lang/spa.php');
		$pdf->setLanguageArray($l);
	}
	
		// set font
	$pdf->SetFont('helvetica', '', 8);
	
	// add a page
	$pdf->AddPage();
	
    $columHead="<table border='0'  cellpadding='0' cellspacing='0' align='center' fontsize='7'>";
	$columHead .="<tr>
	<td width='5%'>ID</td> 
	<td width='10%'>ID_PACIENTE</td> 
	<td width='15%'>NOMBRE PACIENTE</td>
	<td width='15%'>EDAD</td>
	<td width='15%'>SEXO</td>
	<td width='15%'>ESTABLECIMIENTO</td>
	<td width='5%'>FECHA ENVIO</td>
	<td width='15%'>ESPECIALIDAD</td>
	<td width='10%'>FechaHora ex. sol.</td>
	<td width='10%'>Especialista que contestó</td>
	 ";

		switch($tc['glo_estado']){
		case 'Eliminada':
				$columHead .="<td width='10%'>Fecha Eliminación</td>";
				break;  
		case 'Rechazada':
				$columHead .="<td width='10%'>Fecha Rechazo</td>";
				break;  
		case 'Contestada':
				$columHead .="<td width='10%'>Fecha Contestado</td>";
				break;  
		default:
				$columHead .="<td width='10%'>Fecha Creación TC</td>";

	    }
	$columHead .="
	<td width='10%'>ESTADO</td>
	</tr>
	</table>";

	$i = 1;
	if( !empty( $listado_x_cliente ) ) {
		  foreach( $listado_x_cliente as $cliente => $tcs ) {
			  $clieGlosa= "CLIENTE : ". strtoupper($cliente);
			  $pdf->writeHTML($clieGlosa, true, false, true, false, '');
			  $pdf->writeHTML($columHead, true, false, true, false, '');
			  $pdf->Ln(0);
			  $j=0;
			  foreach( $tcs as $rd ) {
					$val01= $rd['TEL_ID'] ;
					$val02= $rd['PAC_IDT_VALOR'] ;
					$val03= $rd['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $rd['TEL_PAC_PRIMER_APELLIDO'];
					$val11= $rd['TEL_PAC_EDAD'];
					$val12= $rd['TEL_PAC_SEXO'];
					$val04= $rd['ETB_NOMBRE'] ;
					$val05=$rd['TEL_FECHA_HORA_ENVIO'];
					$val06=$rd['ESP_NOMBRE'];
					$val07=$rd['TEL_FECHA_HORA_SOLEXA'] ;
					$val08=$rd['usu_especialista'] ;
					$val09=$rd['glo_estado'] ;
					switch($tc['glo_estado']){
						case 'Eliminada':
					        	
								$val10=$rd['TEL_FECHA_HORA'] ;
								break;  
						case 'Rechazada':
								$val10=$rd['TEL_FECHA_HORA_RECHAZO'] ;
								break;  
						case 'Contestada':
								$val10=$rd['TEL_FECHA_HORA_RESPUESTA'] ;
								break;  
						default:
								$val10=$rd['TEL_FECHA_HORA'] ;
						    		

					}

					$rows="<table border='0'  cellpadding='0' cellspacing='0' align='center' fontsize='8'>";
					$rows .="<tr>
					<td width='10%' bgcolor='#CCCCCC'>{$val01}</td> 
					<td width='10%'>{$val02}</td> 
					<td width='30%'>{$val03}</td>
					<td width='30%'>{$val11}</td>
					<td width='30%'>{$val12}</td>					
					<td width='20%'>{$val04}</td>
					<td width='10%'>{$val05}</td>
					<td width='5%'>{$val06}</td>
					<td width='5%'>{$val07}</td>
					<td width='10%'>{$val08}</td>
					<td width='10%'>{$val10}</td>
					<td width='10%'>{$val09}</td>
					</tr>";
					$rows .="</table>";
					$pdf->writeHTML($rows, true, false, false, false, '');
					$pdf->Ln(0);
					$j++;
			  }
				// Evita agregar una página sobrante en blanco al final
				if( $i < count( $listado_x_cliente ) ) {
					$pdf->AddPage();
				}
				$i++;
				
		  }
	
	
	} else {
		
		$info="<table border='0'  cellpadding='0' cellspacing='0' align='center' fontsize='10'>";
		$info.="<tr>";
		$info.="  <td>NO EXISTE REGISTROS PARA DESPLEGAR....</td>";
		$info.="</tr>";
		$info.="</table>";
		$pdf->writeHTML($info, true, false, true, false, '');
		$pdf->Ln(2);
	
	}	
	// reset pointer to the last page
	$pdf->lastPage();
    $pdf->Output('reporte.pdf', 'I');
	



}

    /**
     * Carga en la vista el reporte que se requiere que se guardo anteriormente.
     *
     * @access public
     * @param $id ID
     * @return none
     */
    public function tc_busq_pdf($id) {
        $data['reporte'] = $this->platc_model->reporte_get($id);
        $data['reporte_detalle'] = $this->platc_model->reporte_detalle_get($id);
        return $data;
    }

    /**
     *
     */
    public function reportes( ) {

        $clientes = $this->platc_model->clientes_lista_get( );
        $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', 'Todos', TRUE );

        $this->index('reporte_excel');
    }
	/**
	 *	JV: ZOHO SI834
	 *
     *	se clona la function reportes ya que al llamarla esta indicaba que no existia
     */
	public function reportes_v2( ) {

        $clientes = $this->platc_model->clientes_lista_get( );
        $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', 'Todos', TRUE );

        $this->index('reporte_excel');
    }
	/**
	 *	JV: FIN ZOHO SI834
     */

    /**
     * Genera reporte de usuarios del servicio
     */
    public function reporte_usuarios_del_servicio(  ) {

        $fecha_ini  = $this->input->post( 'fecha_usuarios_servicio_desde' );
        $fecha_fin  = $this->input->post( 'fecha_usuarios_servicio_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_usuarios_del_servicio( $fecha_ini, $fecha_fin, $id_cliente );

        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->SetCellValue('A1', html_entity_decode( $this->lang->line( 'reporte_tipo_identificacion_usuario' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', html_entity_decode( $this->lang->line( 'reporte_numero_identificacion_usuario' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', html_entity_decode( $this->lang->line( 'reporte_codigo_entidad_administradora' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', html_entity_decode( $this->lang->line( 'reporte_tipo_usuario' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', html_entity_decode( $this->lang->line( 'p_apellido1' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', html_entity_decode( $this->lang->line( 'p_apellido2' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', html_entity_decode( $this->lang->line( 'p_nombre1' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', html_entity_decode( $this->lang->line( 'p_nombre2' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', html_entity_decode( $this->lang->line( 'p_edad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', html_entity_decode( $this->lang->line( 'reporte_unidad_medida_edad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', html_entity_decode( $this->lang->line( 'p_sexo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', html_entity_decode( $this->lang->line( 'reporte_codigo_departamento' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', html_entity_decode( $this->lang->line( 'reporte_codigo_municipio' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('N1', html_entity_decode( $this->lang->line( 'reporte_zona_residencia' ) ) );

        $i = 2;
        if ( !empty( $reportes ) ) {
            foreach ($reportes as $reporte) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $reporte['TIPO_IDENTIFICACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $reporte['PAC_IDT_VALOR']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['ENTADM_ID']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['ID_PACIENTE_TIPO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $reporte['TEL_PAC_PRIMER_APELLIDO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['TEL_PAC_SEGUNDO_APELLIDO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $reporte['TEL_PAC_PRIMER_NOMBRE']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['TEL_PAC_SEGUNDO_NOMBRE']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['TEL_PAC_EDAD']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['UNIDAD_ANOS']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $reporte['TEL_PAC_SEXO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $reporte['DEPTO_CODIGO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, $reporte['MUNI_CODIGO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, $reporte['ZON_ID']);
                $i++;
            }
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Reporte_' . date('YmdHis') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    /**
     * Genera reporte de servicios facturados
     */
/*
    public function reporte_servicios_facturados( ) {

        $fecha_ini  = $this->input->post( 'fecha_desde' );
        $fecha_fin  = $this->input->post( 'fecha_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_servicios_facturados( $fecha_ini, $fecha_fin, $id_cliente );

        if ($reportes != NULL) {
            ini_set('zend.ze1_compatibility_mode', '0');
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $this->lang->line('reporte_codigo_prestador') );
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', $this->lang->line('reporte_razon_nombre_prestador') );
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', $this->lang->line('reporte_tipo_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', $this->lang->line('reporte_numero_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', $this->lang->line('reporte_numero_factura') );
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', $this->lang->line('reporte_fecha_expedicion_factura') );
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', $this->lang->line('reporte_fecha_inicio') );
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', $this->lang->line('reporte_fecha_final') );
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', $this->lang->line('reporte_codigo_entidad_administradora') );
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', $this->lang->line('reporte_nombre_entidad_administradora') );
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', $this->lang->line('reporte_numero_contrato') );
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', $this->lang->line('reporte_plan_beneficios') );
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', $this->lang->line('reporte_numero_poliza') );
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', $this->lang->line('reporte_valor_total_compartido_copago') );
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', $this->lang->line('reporte_valor_comision') );
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', $this->lang->line('reporte_valor_descuentos') );
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', $this->lang->line('reporte_valor_neto_pagar_entidad_contratante') );

            $i = 2;
            foreach ($reportes as $reporte) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, '110011735401');
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, 'ITMS Colombia');
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['TIPO_IDENTIFICACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['PAC_IDT_VALOR']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, null );
//                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['FECHA_EXPEDICION_FACTURA']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $reporte['FECHA_INICIO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['FECHA_FIN']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $i, $reporte['']);
                $i++;
            }
            $objPHPExcel->getActiveSheet()->setTitle('Simple');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $excel_name = 'reporte_temporal.xls';
            $file_path = $this->path_file['excel'] . $excel_name;
            $objWriter->save($this->path_file['excel'] . $excel_name);
            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename=Reporte_' . date('YmdHis') . '.xls');
            header('Cache-Control: public');
            header('Content-Description: File Transfer');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path));
            header('Pragma: no-cache');
            header('Expires: 0');
            readfile($file_path);
            unlink($file_path);
        }
    }
*/
    /**
     *
     */
    public function reporte_archivo_consulta( ) {

        $fecha_ini  = $this->input->post( 'fecha_servicios_facturados_desde' );
        $fecha_fin  = $this->input->post( 'fecha_servicios_facturados_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_archivo_consulta( $fecha_ini, $fecha_fin, $id_cliente );

        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->SetCellValue('A1', html_entity_decode( $this->lang->line( 'reporte_numero_factura' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', html_entity_decode( $this->lang->line( 'reporte_codigo_prestador' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', html_entity_decode( $this->lang->line( 'reporte_tipo_identificacion_usuario' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', html_entity_decode( $this->lang->line( 'reporte_numero_identificacion_usuario' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', html_entity_decode( $this->lang->line( 'reporte_fecha_consulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', html_entity_decode( $this->lang->line( 'reporte_numero_autorizacion' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', html_entity_decode( $this->lang->line( 'reporte_codigo_consulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', html_entity_decode( $this->lang->line( 'reporte_finalidad_consulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', html_entity_decode( $this->lang->line( 'reporte_causa_externa' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', html_entity_decode( $this->lang->line( 'reporte_codigo_diagnostico_principal' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', html_entity_decode( $this->lang->line( 'reporte_codigo_diagnostico_relacionado_1' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', html_entity_decode( $this->lang->line( 'reporte_codigo_diagnostico_relacionado_2' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', html_entity_decode( $this->lang->line( 'reporte_codigo_diagnostico_relacionado_3' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('N1', html_entity_decode( $this->lang->line( 'reporte_tipo_diagnostico_principal' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('O1', html_entity_decode( $this->lang->line( 'reporte_valor_consulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('P1', html_entity_decode( $this->lang->line( 'reporte_valor_cuota_moderada' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('Q1', html_entity_decode( $this->lang->line( 'reporte_valor_neto_a_pagar' ) ) );

        if ( !empty( $reportes ) ) {
            $i = 2;
            foreach ($reportes as $reporte) {
//                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $reporte['']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, '110011735401');
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['TIPO_IDENTIFICACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['PAC_IDT_VALOR']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $reporte['TEL_FECHA_HORA']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['TEL_CODIGO_AUTORIZACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, '890402' );
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['FINPROC_ID']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, '');
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, 1);
//                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $i, $reporte['']);
                $i++;
            }
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Reporte_' . date('YmdHis') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    /**
     * Genera archivo excel con el reporte de estadísticas de TC's generadas
     * en la plataforma con los siguientes campos:
     * a. ID TC
     * b. Establecimiento
     * c. ID Paciente
     * d. Nombre y apellido del paciente
     * e. Fecha Hora contestada
     * f. Motivo de TC
     * g. Diagnostico presuntivo principal (el que define el medico del cliente)
     * h. Diagnostico definitivo principal (el que define el especialista)
     * i. Especialista que contesto
     * j. Medico que envía
     */
    public function reporte_estadisticas( ) {

        $fecha_ini  = $this->input->post( 'fecha_estadisticas_desde' );
        $fecha_fin  = $this->input->post( 'fecha_estadisticas_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_estadisticas( $this->session->userdata('SIT_ID'), $fecha_ini, $fecha_fin, $id_cliente );

        /*
         * Lógica que convierte identificadores al correspondiente código de la tabla CIE10
         * Ej: 1 => A00, 2 => A001, etc....
         * Genera un listado intermedio que permite asociar identificadores
         * con el código correspondiente para reemplazar campo de cada TC.
         * Realiza cambios tanto como a los campos diagnosticos medicos
         * presuntivos del generalista como los definitivos del especialista
         */
        if( !empty( $reportes ) ) {

            // Genera listado intermedio con TODOS los identificadores de TODAS
            // las TC del reporte, generando array usando como clave el
            // identificador: así se evita duplicar identificadores
            $cie10_id_todos_generalista = array( );
            $cie10_id_todos_especialista = array( );
            foreach( $reportes as $reporte ) {

                $id_codigos_generalista  = json_decode( $reporte['diag_generalista'] );
                if( !empty( $id_codigos_generalista ) )
                    foreach( $id_codigos_generalista as $id_cie10 )
                        $cie10_id_todos_generalista[ $id_cie10 ] = NULL;

                $id_codigos_especialista = json_decode( $reporte['diag_especialista'] );
                if( !empty( $id_codigos_especialista ) )
                    foreach( $id_codigos_especialista as $id_cie10 )
                        $cie10_id_todos_especialista[ $id_cie10 ] = NULL;
            }

            // Genera array con clave CIE_ID y valor id10 ( 1 => 'A00' ) y elimina elemento vacío
            $codigos_cie10_generalista = $this->platc_model->cie10_get( array_keys( $cie10_id_todos_generalista ) );
            $codigos_cie10_generalista = $this->util->select_form_prepare( $codigos_cie10_generalista, 'CIE_ID', 'id10' );
            unset( $codigos_cie10_generalista[''] );

            $codigos_cie10_especialista = $this->platc_model->cie10_get( array_keys( $cie10_id_todos_especialista ) );
            $codigos_cie10_especialista = $this->util->select_form_prepare( $codigos_cie10_especialista, 'CIE_ID', 'id10' );
            unset( $codigos_cie10_especialista[''] );

            // Reescribe campos de las TC's del reporte
            foreach( $reportes as &$reporte ) {

                $id_codigos_generalista  = json_decode( $reporte['diag_generalista'] );
                $id_codigos_especialista = json_decode( $reporte['diag_especialista'] );

                $t = array();
                if( !empty( $id_codigos_generalista ) )
                    foreach( $id_codigos_generalista as $id_cie10 )
                        $t[] = $codigos_cie10_generalista[ $id_cie10 ];
                $reporte['diag_generalista'] = implode( ', ', $t );

                $t = array();
                if( !empty( $id_codigos_especialista ) )
                    foreach( $id_codigos_especialista as $id_cie10 )
                        $t[] = $codigos_cie10_especialista[ $id_cie10 ];
                $reporte['diag_especialista'] = implode( ', ', $t );
            }
        }

        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->SetCellValue('A1', html_entity_decode( $this->lang->line( 'idteleconsulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', html_entity_decode( $this->lang->line( 'tc_establecimiento' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', html_entity_decode( $this->lang->line( 'tc_time_contestada' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', html_entity_decode( $this->lang->line( 'tc_motivo_teleconsulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', html_entity_decode( $this->lang->line( 'reporte_diag_presuntivo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', html_entity_decode( $this->lang->line( 'reporte_diag_definitivo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', html_entity_decode( $this->lang->line( 'contestada_por' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', html_entity_decode( $this->lang->line( 'enviada_por' ) ) );

        $i = 2;

        if ( !empty( $reportes ) ) {
            unset($reporte);
            foreach ($reportes as $reporte) {

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $reporte['TEL_ID']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $reporte['ETB_NOMBRE']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['PAC_IDT_VALOR']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['PAC_PRIMER_NOMBRE']. ' ' . $reporte['PAC_PRIMER_APELLIDO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $reporte['fecha_contestada']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, empty( $reporte['motivo_de_tc'] ) ? '' : html_entity_decode( $this->lang->line( 'tc_mot_'.$reporte['motivo_de_tc'] ), ENT_COMPAT, 'UTF-8' ) );
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $reporte['diag_generalista'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['diag_especialista'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['especialista_nombre']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['generalista_nombre']);
                $i++;
            }
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Estadisticas_' . date('YmdHis') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    /**
     *
     */
    public function reporte_tiempos_respuestas( ) {

        $fecha_ini  = $this->input->post( 'fecha_tiempos_respuestas_desde' );
        $fecha_fin  = $this->input->post( 'fecha_tiempos_respuestas_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_tiempos_respuestas( $this->session->userdata('SIT_ID'), $fecha_ini, $fecha_fin, $id_cliente );

        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->SetCellValue('A1', html_entity_decode( $this->lang->line( 'idteleconsulta' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', html_entity_decode( $this->lang->line( 'tc_establecimiento' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', html_entity_decode( $this->lang->line( 'tc_time_envio' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', html_entity_decode( $this->lang->line( 'tc_time_revisor' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', html_entity_decode( $this->lang->line( 'tc_time_contestada' ) ) );

        $i = 2;

        if ( !empty( $reportes ) ) {
//            unset($reporte);
            foreach ($reportes as $reporte) {

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $reporte['TEL_ID'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $reporte['ETB_NOMBRE'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['PAC_PRIMER_NOMBRE']. ' ' . $reporte['PAC_PRIMER_APELLIDO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['TEL_FECHA_HORA_ENVIO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $reporte['TEL_FECHA_HORA_REVISOR_ENVIO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['TEL_FECHA_HORA_RESPUESTA'] );
                $i++;
            }
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Estadisticas_' . date('YmdHis') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    /**
     * Retorna a navegador el formulario basado en xml en función de la especialidad
     * seleccionada
     *
     * Tiene id_teleconsulta porque la TC siempre se crea cuando inicia el flujo
     * y se pasa como parámetro para que cargue los archivos adjuntos
     *
     * @param int $id_teleconsulta Id de la teleconsulta
     * @param int $id_especialidad Id de la especialidad
     */
    public function tc_cargar_formulario( $id_teleconsulta, $rand = '', $serial_file_tmp = '' ) {
		if($serial_file_tmp){
            $directorioTemp = dirname($_SERVER['SCRIPT_FILENAME'])."/application/modules/platc/controllers/PDFBox/temp/".$serial_file_tmp; //Define ruta carpeta temporal
			$destino = dirname($_SERVER['SCRIPT_FILENAME']).'/files/borradores/'.$id_teleconsulta;
			if (is_dir($directorioTemp)){
				$repo = scandir($directorioTemp);
				if($repo){ foreach($repo as $fileTmp){
						if(strpos(strtolower($fileTmp),".pdf") !== FALSE){
							if(!is_dir($destino)){
								mkdir($destino, 0777, TRUE);
							}
							if (!@copy($directorioTemp.'/'.$fileTmp, $destino.'/'.$fileTmp)){
								//Registrar log de error...
								imprimir('Error al copiar PDF');
							}
						}
					}
				}
			}
		}

        $this->load->library( 'FormularioXML' );
        $this->output->set_output( $this->formularioxml->generar( $id_teleconsulta, FormularioXML::$MODO_ESCRITURA ) );
    }

    /**
     * Verifica que la TC no esté siendo vista por otro médico especialista
     */
    public function tc_comprobar_toma( ) {

        $id_teleconsulta = $this->input->get('id_teleconsulta');

        $estado = $this->platc_model->tc_comprobar_toma( $id_teleconsulta );

        // Si el usuario que tiene tomado la TC es el mismo usuario que está en sesión
        // significa que está retomando la actividad pendiente
        if( empty( $estado ) || (int)$estado['TEL_LOCK_OWNER'] == (int)$this->session->userdata('USU_ID') )
            $estado = array( 'tomado' => 0, 'usuario' => '' );
        else
            $estado = array( 'tomado' => (int)( !empty( $estado['TEL_LOCK_USED'] ) ? $estado['TEL_LOCK_USED'] : 0 ), 'usuario' => ( !empty( $estado['USU_NOMBRE'] ) ? $estado['USU_NOMBRE'] : '' ) );
        $this->output->set_output( json_encode( $estado ) );
    }

    /**
     * Método que es solicitado via ajax y que retorna un listado de diagnosticos CIE10
     * que es filtrado a traves de la palabra que se obtiene por parámetro. (mínimo 2 letras)
     *
     * @param string $texto letras asociadas al CIE10 a buscar
     */
    public function diagnosticos_medicos_busqueda_por_texto( $texto ) {

        $dm = array( );

        if( !empty( $texto ) ) {

            $site = $this->session->userdata( 'SIT_ID' );
            $lista_diagnosticos_medicos = $this->platc_model->diagnosticos_medicos_busqueda_por_texto( $site, $texto );

            if( !empty( $lista_diagnosticos_medicos ) )
                foreach( $lista_diagnosticos_medicos as $valor ) {
                    $dm[] = array( 'label' => $valor['descripcion'], 'value' => $valor['CIE_ID'] );
                }
        }

        exit( json_encode( $dm ) );
    }

    public function tc_autoguardar( ) {

        $data = array( );
        $id_teleconsulta = $this->input->post( 'id_teleconsulta' );
        $tc = $this->platc_model->tc_get( $id_teleconsulta );
        if( empty( $id_teleconsulta ) ) {

            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            $data['ESP_ID'] = $this->input->post('especialidad');
            $data['ETB_ID'] = $this->input->post('establecimiento');
            $data['PRI_ID'] = $this->input->post('tc_prioridad');
            $data['EST_ID'] = 1;

            // Campos RIPS
            if( $this->session->userdata('SIT_ID') == 22 ) {
                $data['ENTADM_ID'] = $this->input->post('ent_administradoras');
                $data['FINPROC_ID'] = $this->input->post('finalidad_procedimiento');
                $data['AMBPROC_ID'] = $this->input->post('ambito_procedimiento');
                $data['TEL_CODIGO_AUTORIZACION'] = $this->input->post('codigo_autorizacion');
                $data['ZON_ID'] = $this->input->post('zona_residencia');
                $data['MUNI_ID'] = $this->input->post('id_municipio');
                $data['AFI_ID'] = $this->input->post('afiliacion');
            } else {
                $data['ENTADM_ID'] = null;
                $data['FINPROC_ID'] = null;
                $data['AMBPROC_ID'] = null;
                $data['TEL_CODIGO_AUTORIZACION'] = null;
                $data['ZON_ID'] = null;
                $data['MUNI_ID'] = null;
                $data['AFI_ID'] = null;
            }

            // Datos del paciente
            $data['PAC_ID']                     = $this->input->post('idpac');
            $data['TEL_PAC_PRIMER_NOMBRE']      = $this->input->post('nombre1');
            $data['TEL_PAC_PRIMER_APELLIDO']    = $this->input->post('apellido1');

            if( $this->session->userdata('SIT_ID') == 21 ) {

                $data['TEL_PAC_NOMBRE_MADRE']       = $this->input->post('nombre1_madre');
                $data['TEL_PAC_APELLIDO_MADRE']     = $this->input->post('apellido1_madre');
                $data['TEL_PAC_SEGUNDO_NOMBRE']     = NULL;
                $data['TEL_PAC_SEGUNDO_APELLIDO']   = NULL;
            } else {

                $data['TEL_PAC_NOMBRE_MADRE']       = NULL;
                $data['TEL_PAC_APELLIDO_MADRE']     = NULL;
                $data['TEL_PAC_SEGUNDO_NOMBRE']     = $this->input->post('nombre2');
                $data['TEL_PAC_SEGUNDO_APELLIDO']   = $this->input->post('apellido2');
            }
            $data['TEL_PAC_NACIMIENTO']         = $this->input->post('nacimiento');
            $data['TEL_PAC_SEXO']               = $this->input->post('sexo');
            $data['TEL_PAC_EDAD']               = $this->input->post('edad');
            $data['TEL_PAC_TELEFONO']           = $this->input->post('telefono');
            $data['TEL_PAC_EMAIL']              = $this->input->post('email');
            $data['TEL_PAC_PROCEDENCIA']        = $this->input->post('procedencia');
            $data['TEL_PAC_OCUPACION']          = $this->input->post('ocupacion');
			//JV 25-09-2015
            $data['TEL_PAC_DPTO_NOMBRE']		= $this->input->post('departamentos_nombre');
			$data['TEL_PAC_MUN_NOMBRE']			= $this->input->post('municipio_nombre');
			$data['TEL_PAC_AFI_NOMBRE']			= $this->input->post('afiliacion_nombre');
			$data['TEL_PAC_ENTADM_NOMBRE']		= $this->input->post('entidadadm_nombre');
			//JV 25-09-2015 FIN
            $data['TEL_FECHA_HORA']             = date('Y-m-d') . " " . date('H:i:s');

            if( ($this->session->userdata('SIT_ID') == 22) && ($this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE']) )
                $data['TEL_GENERALISTA']        = $this->input->post('tc_medico_general');

            // Ingreso de información
            $tcid = $this->platc_model->tc_set($data);
            $this->tc_cambio_estado($tcid, 1, $this->input->post('tc_prioridad'), $this->session->userdata('USU_ID'));

            // Retorna ID de la teleconsulta en json
            $this->output->set_output( json_encode( array( 'id_teleconsulta' => $tcid ) ) );
        } elseif( !empty( $id_teleconsulta ) && $tc['EST_ID'] == 1  ) {

            /*
             * Cambia valor de la prioridad
             */
            $data['TEL_ID'] = $id_teleconsulta;
            $data['EST_ID'] = $tc['EST_ID'];
            $data['PRI_ID'] = $this->input->post('prioridad');
            $this->platc_model->tc_upd( $data );

            /*
             * Inicio nueva lógica TC_TELECONSULTA_DATA
             */
            $data1 = array( );

            // Carga los campos que necesita grabar el formulario
            $this->load->library( 'FormularioXML' );
            $campos = $this->formularioxml->obtener_campos( $id_teleconsulta );

            // Ciclo recorre campos definido en xml para obtener información desde $_POST
            foreach( $campos as $campo )
                if( is_array( $this->input->post( $campo ) ) )

                    $data1[ $campo ]  = json_encode( $this->input->post( $campo ) );
                else {
                    $c = $this->input->post( $campo );
                    if( $c != "" && !isset( $data1[ $campo ] ) ) {
                        $data1[ $campo ] = preg_replace( "/<br(\s)*(\/)*>/i", "", $c );
                        $data1[ $campo ] = preg_replace( "/^\n++(?! )/", "", $data1[ $campo ] );
                        $data1[ $campo ] = preg_replace( "/\n++(?! )(&nbsp;)*$/", "", $data1[ $campo ] );
                    }
                }

            // Actualiza información de la especialidad (formulario del xml)
            $this->platc_model->tc_borrar_data( $id_teleconsulta );
            $this->platc_model->tc_agregar_data( $id_teleconsulta, $data1 );
            /*
             * Fin nueva lógica TC_TELECONSULTA_DATA
             */
        }
    }

    public function tc_autoguardar_solicitud_examen( ) {

        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( $tc['EST_ID'] == 7 || $tc['EST_ID'] == 5 || $tc['EST_ID'] == 3 ) {

            switch( (int)$tc['EST_ID'] ) {
                case 7: {$texto = $this->lang->line('tc_respondido_anteriormente');} break;
                case 5: {$texto = $this->lang->line('tc_sol_examen_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $data['TEL_ID'] = $this->input->post('tc_id');
        $data['PRI_ID'] = $this->input->post('prioridad');
        //$data['TEL_SOL_ADICIONALES'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('soladicionales') );
		$data['TEL_SOL_ADICIONALES'] = $this->input->post('soladicionales');
        $data['EST_ID'] = $this->input->post('estadoanterior');

        $data['TEL_CON_ESPECIALISTA'] = null;
        $data['TEL_DIA_ESPECIALISTA'] = null;
        $data['TEL_DIA_ORIENTACION'] = null;
        $data['TEL_DIA_FUNDAMENTOS'] = null;

        $this->platc_model->tc_upd( $data );
    }

    public function tc_autoguardar_responder( ) {

        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( (int)$tc['EST_ID'] == 7 || (int)$tc['EST_ID'] == 5 || (int)$tc['EST_ID'] == 3) {

            switch( (int)$tc['EST_ID'] ) {
                case 7: {$texto = $this->lang->line('tc_respondido_anteriormente');} break;
                case 5: {$texto = $this->lang->line('tc_sol_examen_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        /*
         *
         */
//        if( (int)$this->session->userdata('SIT_ID') == 22 ) {
//
//            $tiene_formula = $this->input->post('recetario_formula');
//            if( $tiene_formula == 'si' ) {
//
//                // Obtiene desde POST los campos que se deben guardar
//                // TODO: Establecer lógica para saber qué guardar como respuesta (similar a form_[especialidad]_valores.xml)
//                $campos = array( );
//                $campos_a_guardar = array( 'recetario_formula' );
//                foreach( $campos_a_guardar as $v )
//                    if( isset( $_POST[ $v ] ) )
//                        $campos[ $v ] = $this->input->post( $v );
//
//                $this->platc_model->tc_borrar_data_respuesta( (int)$tc['TEL_ID'] );
//                $this->platc_model->tc_agregar_data_respuesta( (int)$tc['TEL_ID'], $campos );
//            }
//        }


        $data['TEL_ID'] = $this->input->post('tc_id');
        $data['PRI_ID'] = $this->input->post('prioridad');
        $data['EST_ID'] = $this->input->post('estadoanterior');

        //$data['TEL_CON_ESPECIALISTA']   = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('conespecialista') );
        //$data['TEL_DIA_ESPECIALISTA']   = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('diaespecialista') );
        //$data['TEL_DIA_ORIENTACION']    = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('diaorientacion') );
        //$data['TEL_DIA_FUNDAMENTOS']    = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('diafundamentos') );



        $data['TEL_MODALIDAD_RESPUESTA']   = $_POST['modalidad_respuesta'];  //$this->input->post('modalidad_respuesta');



		$data['TEL_CON_ESPECIALISTA']   = $this->input->post('conespecialista');
        $data['TEL_DIA_ESPECIALISTA']   = $this->input->post('diaespecialista');
        $data['TEL_DIA_ORIENTACION']    = $this->input->post('diaorientacion');
        $data['TEL_DIA_FUNDAMENTOS']    = $this->input->post('diafundamentos');

        // establece null para evitar llenar campo innecesariamente cuando se ingresa con respuesta desde nueva/enviada
        // si viende desde "respuesta de solicitud (estado 6)" evita eliminar campo ingresado previamente en el flujo
        if( $data['EST_ID'] != 6 ) {
            $data['TEL_SOL_ADICIONALES'] = null;

            $delfile = $this->path_file['sol_adicional'] . $this->input->post( 'tc_id' );
            if( is_dir( $delfile ) ) {

                log_message('debug', 'Eliminando: '.$delfile);
                $this->load->helper('file');
                delete_files( $delfile );
                @rmdir($delfile);
            }
        }

        $this->platc_model->tc_upd( $data );

        $dm_general_respuesta   = $this->input->post('dm_general_respuesta');
        if( !empty( $dm_general_respuesta ) )
            $this->platc_model->tc_update_cie10_respuesta( $data['TEL_ID'], $dm_general_respuesta );

    }

    public function tc_autoguardar_responder_solicitud( ) {

        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( $tc['EST_ID'] == 6 || $tc['EST_ID'] == 3) {

            switch( (int)$tc['EST_ID'] ) {
                case 6: {$texto = $this->lang->line('tc_sol_examen_resp_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $data['TEL_ID'] = $this->input->post('tc_id');
        $data['EST_ID'] = $this->input->post('estadoanterior');

        //$data['TEL_SOL_ADICIONALES_RESP'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('respuesta') );
		$data['TEL_SOL_ADICIONALES_RESP'] = $this->input->post('respuesta');

        $this->platc_model->tc_upd( $data );
    }

    public function tc_autoguardar_revisor_solicitud_examen( ) {

        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( ( $tc['EST_ID'] == 2 && $tc['TEL_REVISADA'] == 1 ) ||
            ( $tc['EST_ID'] == 5 && $tc['TEL_REVISADA'] == 0 ) ||
              $tc['EST_ID'] == 3 ) {

            // Lógica que elimina el campo de solicitud de examen al ser anteriormente
            // respondido o rechazado: no tiene sentido conservarlo. Se guarda
            // solo el texto ingresado anteriormente (desde otro médico)
            $data['TEL_ID'] = $tc['TEL_ID'];
            $data['EST_ID'] = $tc['EST_ID'];
            $data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] = null;

            switch( (int)$tc['EST_ID'] ) {
                case 2: {$texto = $this->lang->line('tc_enviada_anteriormente'); $this->platc_model->tc_upd( $data );} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente'); $this->platc_model->tc_upd( $data );} break;
                case 5: {$texto = $this->lang->line('tc_sol_examen_pendiente');} break;
            };

            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $data['TEL_ID'] = $tc['TEL_ID'];
        $data['EST_ID'] = $tc['EST_ID'];
        //$data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('revisor_solicitud_info_adicional_inpt') );
		$data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] = $this->input->post('revisor_solicitud_info_adicional_inpt');

        $this->platc_model->tc_upd( $data );
    }

    public function tc_autoguardar_revisor_solicitud_examen_resp( ) {

        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( ( $tc['EST_ID'] == 6 && $tc['TEL_REVISADA'] == 0 ) || $tc['EST_ID'] == 3 ) {

            switch( (int)$tc['EST_ID'] ) {
                case 6: {$texto = $this->lang->line('tc_sol_examen_resp_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
            };

            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $data['TEL_ID'] = $this->input->post('tc_id');
        $data['EST_ID'] = $tc['EST_ID'];
        //$data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $this->input->post('revisor_respuesta_solicitud_info_adicional_resp') );
		$data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'] = $this->input->post('revisor_respuesta_solicitud_info_adicional_resp');

        $this->platc_model->tc_upd( $data );
    }

    /**
     *
     */
    public function agenda_resumen( ) {

        $this->index( 'agenda_resumen_view' );
    }

    /**
     * Página con listado de agendas
     */
    public function agenda_resumen_grilla( ) {

        //load data
        $data['agendas'] = $this->platc_model->obtener_agendas( $this->session->userdata('SIT_ID') );

        $this->output->set_output( json_encode( $data['agendas'] ) );
    }

    /**
     * Página con formulario para agregar agenda
     */
    public function agenda_agregar( ) {

        $especialistas = $this->platc_model->especialistas_por_site( $this->session->userdata( 'SIT_ID' ) );
        $this->data[ 'especialistas' ] = $this->util->select_form_prepare( $especialistas, 'USU_ID', 'USU_NOMBRE' );
        $this->index( 'agenda_agregar_view' );
    }

    public function agenda_agrega( ) {

        $this->form_validation->set_rules( 'fecha_inicio',  '', 'required');
        $this->form_validation->set_rules( 'fecha_fin',     '', 'required');
        $this->form_validation->set_rules( 'hora_inicio',   '', 'required');
        $this->form_validation->set_rules( 'hora_fin',      '', 'required');
        $this->form_validation->set_rules( 'intervalo',     '', 'required');
        $this->form_validation->set_rules( 'especialista',  '', 'required');

        if( $this->form_validation->run( ) != FALSE ) {

            $fecha_inicio = $this->util->fecha_orden( $this->input->post( 'fecha_inicio' ) );
            $fecha_fin    = $this->util->fecha_orden( $this->input->post( 'fecha_fin' ) );
            $hora_inicio  = $this->input->post( 'hora_inicio' );
            $hora_fin     = $this->input->post( 'hora_fin' );
            $intervalo    = $this->input->post( 'intervalo' );
            $descripcion  = $this->input->post( 'descripcion' );
            $site         = $this->session->userdata('SIT_ID');
            $especialista = $this->input->post( 'especialista' );

            $id = $this->platc_model->agenda_agregar(   $fecha_inicio, $fecha_fin, $hora_inicio, $hora_fin, $intervalo,
                                                        $descripcion, $site, $especialista );

            if( !empty( $id ) ){
                $resp['method'] = base_url() . 'platc/agenda_resumen/';
                $resp['div'] = 'deploy';
                $resp['action'] = 'true';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agenda_agregado_ok');
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agenda_agregado_error');
            }


        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);

    }

    public function agenda_editar( $id_agenda ) {

        $especialistas = $this->platc_model->especialistas_por_site( $this->session->userdata( 'SIT_ID' ) );
        $this->data[ 'especialistas' ] = $this->util->select_form_prepare( $especialistas, 'USU_ID', 'USU_NOMBRE' );

        $this->data[ 'agenda' ]          = $this->platc_model->agenda_get( $id_agenda );
//        $this->data[ 'agenda_bloqueos' ] = $this->platc_model->agenda_bloqueos_get( $id_agenda );

        $this->index( 'agenda_editar_view' );
    }

    public function agenda_edita( ) {

        $this->form_validation->set_rules( 'fecha_inicio',  $this->lang->line('agenda_fecha_inicio'), 'required');
        $this->form_validation->set_rules( 'fecha_fin',     $this->lang->line('agenda_fecha_fin'), 'required');
        $this->form_validation->set_rules( 'hora_inicio',   $this->lang->line('agenda_hora_inicio'), 'required');
        $this->form_validation->set_rules( 'hora_fin',      $this->lang->line('agenda_hora_fin'), 'required');
        $this->form_validation->set_rules( 'intervalo',     $this->lang->line('agenda_hora_intervalo'), 'required');
        $this->form_validation->set_rules( 'especialista',  $this->lang->line('especialista'), 'required');

        if( $this->form_validation->run( ) != FALSE ) {

            $fecha_inicio = $this->util->fecha_orden( $this->input->post( 'fecha_inicio' ) );
            $fecha_fin    = $this->util->fecha_orden( $this->input->post( 'fecha_fin' ) );
            $hora_inicio  = $this->input->post( 'hora_inicio' );
            $hora_fin     = $this->input->post( 'hora_fin' );
            $intervalo    = $this->input->post( 'intervalo' );
            $especialista = $this->input->post( 'especialista' );
            $descripcion  = $this->input->post( 'descripcion' );
            $site         = $this->session->userdata('SIT_ID');
            $id_agenda    = $this->input->post( 'agenda_id' );

            $id = $this->platc_model->agenda_editar( $id_agenda, $fecha_inicio, $fecha_fin, $hora_inicio, $hora_fin, $intervalo,
                                                     $especialista, $descripcion, $site );

            if( !empty( $id ) ){
                $resp['method'] = base_url() . 'platc/agenda_resumen/';
                $resp['div'] = 'deploy';
                $resp['action'] = 'true';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agenda_editar_ok');
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agenda_editar_error');
            }


        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    public function agenda_agrega_bloqueo( ) {

//        $id_agenda_bloqueo  = $this->input->post( 'agenda_bloqueo_id' );
        $id_agenda          = $this->input->post( 'agenda_id' );
        $bloqueo_dias       = $this->input->post( 'bloqueo_dias' );
        $bloqueo_horas      = $this->input->post( 'bloqueo_horas' );

        $estado = $this->platc_model->agenda_agregar_bloqueo( $id_agenda, $bloqueo_dias, $bloqueo_horas );

        if( !empty( $estado ) ){
            $resp['method'] = base_url() . 'platc/agenda_resumen/';
            $resp['div'] = 'deploy';
            $resp['action'] = 'true';
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('agenda_agregado_ok');
        } else {
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('agenda_agregado_error');
        }
        echo json_encode($resp);
    }

    public function agenda_agrega_bloqueo_por_fecha( ) {

        $id_agenda          = $this->input->post( 'agenda_id' );
        $bloqueo_por_fecha  = $this->input->post( 'bloqueo_por_fecha' );

        $estado = $this->platc_model->agenda_agregar_bloqueo_por_fecha( $id_agenda, $this->util->fecha_orden( $bloqueo_por_fecha ) );

        if( !empty( $estado ) ){
            $resp['method'] = base_url() . 'platc/agenda_resumen/';
            $resp['div'] = 'deploy';
            $resp['action'] = 'true';
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('agenda_agregado_ok');
        } else {
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('agenda_agregado_error');
        }
        echo json_encode($resp);
    }

    public function agenda_elimina( $id_agenda ) {

        if ( $this->platc_model->agenda_eliminar( $id_agenda ) )
            echo 'true';
    }

    public function agenda_bloqueos_data_grid( $id_agenda ) {

        $listado_tc = $this->platc_model->agenda_bloqueos_get( $id_agenda );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }

    public function agenda_bloqueo_eliminar( ) {

        $id_agenda_bloqueo = (int)$this->input->post('id_agenda_bloqueo');
        $estado = $this->platc_model->agenda_bloqueo_eliminar( (int)$id_agenda_bloqueo );
        if( $estado )
            $this->output->set_output( 'true' );
        else
            $this->output->set_output( 'false' );
    }

    public function agendamiento_resumen( ) {
		if((int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'])
			$this->agenda_resumen();
		else
			$this->index( 'agendamiento_resumen_view' );
    }

    /**
     * @todo Juntar {@see agendamiento_pendientes}, {@see agendamiento_proceso_atencion}, 
     * {@see agendamiento_realizados} y {@see agendamiento_cancelados}
     * para ser parametrizados
     */
    public function agendamiento_pendientes( ) {
		$name = (isset($_GET['name']) && $_GET['name']) ? $_GET['name'] : "";
		$desde = (isset($_GET['d']) && $_GET['d']) ? substr($_GET['d'],6,4)."-".substr($_GET['d'],3,2)."-".substr($_GET['d'],0,2) : "";
		$hasta = (isset($_GET['h']) && $_GET['h']) ? substr($_GET['h'],6,4)."-".substr($_GET['h'],3,2)."-".substr($_GET['h'],0,2) : "";
        $id_site            = $this->session->userdata( 'SIT_ID' );
        $id_estado          = Platc::$AGENDAMIENTO_ESTADOS['TOMADA'];
        $id_usuario_medico  = $this->session->userdata( 'USU_ID' );
        $id_rol_medico      = $this->session->userdata( 'ROL_ID' );

        $agendamiento_pendientes = $this->platc_model->agendamientos_get( $id_site, $id_estado, $id_rol_medico, $id_usuario_medico, $name, $desde, $hasta );

//        $this->index( 'agendamiento_pendientes_view' );
        $this->output->set_output( json_encode( $agendamiento_pendientes ) );
    }

    /**
     * @todo Juntar {@see agendamiento_pendientes}, {@see agendamiento_proceso_atencion}, 
     * {@see agendamiento_realizados} y {@see agendamiento_cancelados}
     * para ser parametrizados
     */
    public function agendamiento_proceso_atencion( ) {

        $id_site            = $this->session->userdata( 'SIT_ID' );
        $id_estado          = Platc::$AGENDAMIENTO_ESTADOS['ESPERA'];
        $id_usuario_medico  = $this->session->userdata( 'USU_ID' );
        $id_rol_medico      = $this->session->userdata( 'ROL_ID' );

        $agendamiento_en_proceso = $this->platc_model->agendamientos_get( $id_site, $id_estado, $id_rol_medico, $id_usuario_medico );

        $this->output->set_output( json_encode( $agendamiento_en_proceso ) );
    }

    /**
     * @todo Juntar {@see agendamiento_pendientes}, {@see agendamiento_proceso_atencion}, 
     * {@see agendamiento_realizados} y {@see agendamiento_cancelados}
     * para ser parametrizados
     */
    public function agendamiento_realizados( ) {

        $id_site            = $this->session->userdata( 'SIT_ID' );
        $id_estado          = Platc::$AGENDAMIENTO_ESTADOS['FINALIZADA'];
        $id_usuario_medico  = $this->session->userdata( 'USU_ID' );
        $id_rol_medico      = $this->session->userdata( 'ROL_ID' );

        $agendamiento_realizados = $this->platc_model->agendamientos_get( $id_site, $id_estado, $id_rol_medico, $id_usuario_medico );
        $this->output->set_output( json_encode( $agendamiento_realizados ) );
    }

    /**
     * @todo Juntar {@see agendamiento_pendientes}, {@see agendamiento_proceso_atencion}, 
     * {@see agendamiento_realizados} y {@see agendamiento_cancelados}
     * para ser parametrizados
     */
    public function agendamiento_cancelados( ) {

        $id_site            = $this->session->userdata( 'SIT_ID' );
        $id_estado          = Platc::$AGENDAMIENTO_ESTADOS['CANCELADA'];
        $id_usuario_medico  = $this->session->userdata( 'USU_ID' );
        $id_rol_medico      = $this->session->userdata( 'ROL_ID' );

        $agendamiento_cancelados = $this->platc_model->agendamientos_get( $id_site, $id_estado, $id_rol_medico, $id_usuario_medico );
        $this->output->set_output( json_encode( $agendamiento_cancelados ) );
    }

    public function agendamiento_agregar( ) {
 if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] || $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE']  ) {

        // medico generalista
            $medicos_generalistas = $this->platc_model->usuarios_por_rol( 4, (int)$this->session->userdata('SIT_ID'), TRUE, $this->session->userdata( 'CLI_ID' ) );
            $this->data['medicos_generalistas'] = $this->util->select_form_prepare( $medicos_generalistas, 'USU_ID', 'USU_NOMBRE' );
        }

        // Especialidades
            $especialidades = $this->platc_model->especialidades_site_get($this->session->userdata('SIT_ID'));
            $this->data['especialidades'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE', 'Todas', TRUE);

        // Estados
        $this->data['estados'] = $this->platc_model->estados_select($this->language, true );

        // COLOMBIA: Permite agendar TC virtuales a documentos en borrador
        if( $this->session->userdata('SIT_ID') == Platc::$SITE['COLOMBIA'] ) {
            unset( $this->data['estados'][Platc::$ESTADO_TC['CONTESTADA']] );
            unset( $this->data['estados'][Platc::$ESTADO_TC['EXAM_SOLICITADO']] );
        } else
            unset( $this->data['estados'][Platc::$ESTADO_TC['BORRADOR']] );

        // TODOS: se elimina del listado las TC rechazados y TC eliminada
        unset( $this->data['estados'][Platc::$ESTADO_TC['RECHAZADA']] );  // saca del listado estado 'rechazada'
        unset( $this->data['estados'][Platc::$ESTADO_TC['ELIMINADA']] );  // saca del listado estado 'Eliminadas'

        // Administrador selecciona cliente, luego por ajax carga establecimientos
        // if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {
        if( ( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) || $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE'] )  { // NF432
            
            // Clientes
            $clientes = $this->platc_model->clientes_get( $this->session->userdata( 'SIT_ID' ) );
            $this->data[ 'clientes' ] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' );
        } else {

            // Establecimientos
            $establecimientos = $this->platc_model->establecimientos_cliente_get( $this->session->userdata( 'CLI_ID' ) );
            $this->data[ 'establecimientos' ] = $this->util->select_form_prepare( $establecimientos, 'ETB_ID', 'ETB_NOMBRE' );
        }
        //
//        $especialistas = $this->platc_model->establecimientos_cliente_get( $this->session->userdata( 'CLI_ID' ) );
        $especialistas = array( );
        if( !empty( $especialistas ) )
            $this->data[ 'especialistas' ]    = $this->util->select_form_prepare( $especialistas, 'USU_ID', 'USU_NOMBRE' );
        else
            $this->data[ 'especialistas' ]    = array( );

        $this->index( 'agendamiento_agregar_view' );
    }

    public function agendamiento_agrega( ) {

        $this->form_validation->set_rules( 'agendamiento_id_tc',  '', 'required');
        $this->form_validation->set_rules( 'agendamiento_id_agenda_def',  '', 'required');
        $this->form_validation->set_rules( 'agendamiento_fecha',  '', 'required');
        $this->form_validation->set_rules( 'agendamiento_hora',  '', 'required');

        if( $this->form_validation->run( ) != FALSE ) {

            $id_estado      = Platc::$AGENDAMIENTO_ESTADOS['TOMADA'];  // 1: Tomada
            $id_site        = $this->session->userdata( 'SIT_ID' );
            $id_especialista = $this->input->post( 'agendamiento_id_medico' );
            $id_tc          = $this->input->post( 'agendamiento_id_tc' );
            $id_agenda_def  = $this->input->post( 'agendamiento_id_agenda_def' );
            $fecha          = $this->util->fecha_orden( $this->input->post( 'agendamiento_fecha' ) );
            $hora           = $this->input->post( 'agendamiento_hora' );
            $observaciones  = $this->input->post( 'agendamiento_observaciones' );
            $telefono       = $this->input->post( 'agendamiento_telefono_contacto' );
            $email          = $this->input->post( 'agendamiento_email_contacto' );
            switch( (int)$this->session->userdata('ROL_ID') ) {
                case Platc::$ROL['MEDICO_GENERAL']      : 
                    $id_generalista = (int)$this->session->userdata( 'USU_ID' );
                    $id_asistente = null;
                    break;
                case Platc::$ROL['MEDICO_ASISTENTE']    :
                case Platc::$ROL['ADMIN']    :
                    $id_generalista = (int)$this->input->post( 'agendamiento_generalista' );
                    $id_asistente = (int)$this->session->userdata( 'USU_ID' );
                    break;
                case Platc::$ROL['ATENCION_CLIENTE']    : /* NF432 */
                    $id_generalista = (int)$this->input->post( 'agendamiento_generalista' );
                    $id_asistente = (int)$this->session->userdata( 'USU_ID' );
                    break;                    
            }

            $id = $this->platc_model->agendamiento_agregar( $id_estado, $id_site, $id_generalista, $id_asistente, $id_tc, $id_agenda_def, $id_especialista, $fecha, $hora, $observaciones, $telefono, $email );
			
			echo $id;

            if( !empty( $id ) ){
                $resp['method'] = ( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) ? base_url() . 'platc/agenda_resumen/' : base_url() . 'platc/agendamiento_resumen/';
                $resp['div'] = 'deploy';
                $resp['action'] = 'true';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agendamiento_agregado_ok');
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agendamiento_agregado_error');
            }


        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Dado un identificador de una definicion de agenda, este metodo retorna
     * sus atributos en formato json. Usado desde views/agendamiento_agregar_view.php
     *
     * @param int $id_agenda Identificador de la agenda
     */
    public function agendamiento_calendario_definicion( $id_agenda ) {

        //
        $agenda_def = $this->platc_model->agendamiento_calendario_definicion( $id_agenda, $this->session->userdata( 'SIT_ID' ) );

        foreach( $agenda_def as $k => $v ) {

            unset( $agenda_def[ $k ] );
            $agenda_def[ strtolower( $k ) ] = $v;
        }

        $this->output->set_output( json_encode( $agenda_def ) );
    }

    public function agendamiento_especialista_agendas_disponibles( $id_especialista ) {

        $agendas_disponibles = $this->platc_model->agendamiento_especialista_agendas_disponibles( $id_especialista, $this->session->userdata( 'SIT_ID' ));

        $r = array();
        foreach( $agendas_disponibles as $agenda ) {

            $t = array( );
            foreach( $agenda as $k => $v ) {

                if( strcmp( $k, 'AGEDEF_FECHA_INI' ) == 0 || strcmp( $k, 'AGEDEF_FECHA_FIN' ) == 0 )
                    // Cambia orden de la fecha
                    $t[ strtolower( $k ) ] = $this->util->fecha_orden( $v );
                else
                    $t[ strtolower( $k ) ] = $v;
            }
            $r[] = $t;
        }

        $this->output->set_output( json_encode( $r ) );
    }

    public function agendamiento_calendario_bloqueados( ) {

        // Uso de gmdate es para obtener fecha exacta
        $fecha_inicio = gmdate( 'Y-m-d', $this->input->post( 'start' ) );
        $fecha_fin    = gmdate( 'Y-m-d', $this->input->post( 'end' ) );
        $id_agenda_def = $this->input->post( 'id_agenda_def' );

        //
        $fechas_bloqueadas = $this->platc_model->agendamiento_bloqueos_por_agendamiento( $id_agenda_def, $fecha_inicio, $fecha_fin );
        $fechas_tomadas    = $this->platc_model->agendamiento_tomados_por_agendamiento( $id_agenda_def, $fecha_inicio, $fecha_fin );

        // Establece fechas del especialistas como bloqueadas
        $listado_fechas_tomadas = array( );
        if( !empty( $fechas_tomadas ) )
            foreach( $fechas_tomadas as $t )
                $listado_fechas_tomadas[] = array( 'title' => $this->lang->line('agendamiento_no_disponible'), 'start' => $t['start'], 'id' => 'bloqueado' );

        $this->output->set_output( json_encode( array_merge( $fechas_bloqueadas, $listado_fechas_tomadas ) ) );
    }

    public function agendamiento_calendario_tomados_especialista( ) {

        // Uso de gmdate es para obtener fecha exacta
        $fecha_inicio = gmdate( 'Y-m-d', $this->input->post( 'start' ) );
        $fecha_fin    = gmdate( 'Y-m-d', $this->input->post( 'end' ) );
        $especialista = $this->input->post( 'especialista' );

        //
        $fechas_tomados = $this->platc_model->agendamiento_tomados_por_agendamiento( $especialista, $fecha_inicio, $fecha_fin, $this->session->userdata( 'USU_ID' ) );

        echo json_encode( $fechas_tomados );
    }

    public function agendamiento_calendario_tomados_generalista( ) {

        // Uso de gmdate es para obtener fecha exacta
        $fecha_inicio = gmdate( 'Y-m-d', $this->input->post( 'start' ) );
        $fecha_fin    = gmdate( 'Y-m-d', $this->input->post( 'end' ) );
        $especialista = $this->input->post( 'especialista' );

        //
        $fechas_tomados = $this->platc_model->agendamiento_tomados_por_generalista( $this->session->userdata( 'USU_ID' ), $fecha_inicio, $fecha_fin, $especialista );

        echo json_encode( $fechas_tomados );
    }

    /**
     * Realiza búsqueda de teleconsultas usando filtros establecidos por el usuario
     *
     * @param int $_POST['busqueda_establecimiento']    Identificador del establecimiento
     * @param int $_POST['busqueda_especialidad']       Identificador de la especialidad
     * @param int $_POST['busqueda_estado']             Identificador del estado
     * @param string $_POST['busqueda_fecha_inicio']    Fecha en formato dd-mm-YYYY
     * @param string $_POST['busqueda_fecha_fin']       Fecha en formato dd-mm-YYYY
     */
    public function agendamiento_busqueda_tc_por_filtro( ) {

        $this->form_validation->set_rules( 'busqueda_establecimiento', '', 'required');

        // if ($this->form_validation->run() != FALSE) {

        //     $id_site         = $this->session->userdata( 'SIT_ID' );
        //     $establecimiento = $this->input->post( 'busqueda_establecimiento' );
        //     $especialidad    = $this->input->post( 'busqueda_especialidad' );
        //     $estado          = $this->input->post( 'busqueda_estado' );
        //     $fecha_inicio    = $this->input->post( 'busqueda_fecha_inicio' );
        //     $fecha_inicio    = !empty( $fecha_inicio ) ? $this->util->fecha_orden( $fecha_inicio ) : null;
        //     $fecha_fin       = $this->input->post( 'busqueda_fecha_fin' );
        //     $fecha_fin       = !empty( $fecha_fin ) ? $this->util->fecha_orden( $fecha_fin ) : null;

        //     $this->data['teleconsultas'] = $this->platc_model->agendamiento_buscar_tc_por_filtro( (int)$id_site, $establecimiento, $especialidad, $estado, $fecha_inicio, $fecha_fin );
        //     $this->index('agendamiento_busqueda_grid_view');

        // } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
            $this->output->set_output( json_encode($resp) );
        // }
    }

    /**
     * Realiza búsqueda de teleconsulta usando primer nombre y primer apellido
     *
     * @param int $_POST['busqueda_nombre']     Primer nombre del paciente
     * @param int $_POST['busqueda_apellido']   Primer apellido del paciente
     */
    public function agendamiento_busqueda_tc_por_paciente( ) {

        $id_site    = $this->session->userdata( 'SIT_ID' );
        $nombre     = $this->input->post( 'busqueda_nombre' );
        $apellido   = $this->input->post( 'busqueda_apellido' );

        if( !empty( $nombre ) || !empty( $apellido ) )
            $this->data['teleconsultas'] = $this->platc_model->agendamiento_buscar_tc_por_paciente( (int)$id_site, $nombre, $apellido );
        else
            $this->data['teleconsultas'] = array( );

        $this->index('agendamiento_busqueda_grid_view');
    }

    /**
     * Realiza búsqueda de teleconsulta usando id conocido
     *
     * @param int $_POST['busqueda_id']     Identificador de la teleconsulta
     */
    public function agendamiento_busqueda_tc_por_id_paciente( ) {

        $id_site         = $this->session->userdata( 'SIT_ID' );
        $idt_paciente    = $this->input->post( 'busqueda_id_paciente' );

        if( !empty( $idt_paciente ) )
            $this->data['teleconsultas'] = $this->platc_model->agendamiento_buscar_tc_por_id_paciente( (int)$id_site, $idt_paciente );
        else
            $this->data['teleconsultas'] = array( );

        $this->index('agendamiento_busqueda_grid_view');
    }

    /**
     * Realiza búsqueda de teleconsulta usando id conocido
     *
     * @param int $_POST['busqueda_id']     Identificador de la teleconsulta
     */
    public function agendamiento_busqueda_tc_por_id( ) {

        $id_site            = $this->session->userdata( 'SIT_ID' );
        $id_teleconsulta    = $this->input->post( 'busqueda_id' );

        if( !empty( $id_teleconsulta ) )
            $this->data['teleconsultas'] = $this->platc_model->agendamiento_buscar_tc_por_id( (int)$id_site, $id_teleconsulta );
        else
            $this->data['teleconsultas'] = array( );

        $this->index('agendamiento_busqueda_grid_view');
    }

    

	/**
     * Obtiene listado de médicos especialistas y además la especialidad de la
     * teleconsulta
     */
    public function agendamiento_obtener_medicos_especialidad( ) {

        $id_teleconsulta = $this->input->get( 'id_teleconsulta' );
        $tc = $this->platc_model->tc_get( $id_teleconsulta );

        $id_cliente     = ( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) ? $tc['CLI_ID'] : $this->session->userdata( 'CLI_ID' );
        $id_cliente     = ( $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE'] ) ? $tc['CLI_ID'] : $this->session->userdata( 'CLI_ID' ); // NF432
        $especialidad   = $this->platc_model->especialidad_get( $tc['ESP_ID'] );
        $medicos_especialistas = $this->platc_model->especialistas_de_cliente_por_especialidad( $id_cliente, $tc['ESP_ID'] );

        $lista_medicos = array( );
        if( !empty( $medicos_especialistas ) )
            foreach( $medicos_especialistas as $medico ) {
                $lista_medicos[] = array( 'id' => $medico['USU_ID'], 'nombre' => $medico['USU_NOMBRE'] );
            }

        $this->output->set_output( json_encode( array( 'medicos' => $lista_medicos, 'especialidad' => $especialidad['ESP_NOMBRE'] ) ) );
       //echo "-1";    
	}

    /**
     * Entrega el estado (conectado/desconectado) del médico cuando va a realizar
     * una TC virtual.
     */
    public function agendamiento_comprobar_estado_contraparte( $id_agenda, $id_rol ) {

        $estado = $this->platc_model->agendamiento_comprobar_estado_contraparte( $id_agenda, $id_rol );

        $this->output->set_output( json_encode( $estado ? '1' : '0' ) );
    }

    public function agendamiento_establecer_fecha_inicio_reunion( $id_agendamiento ) {

        $this->platc_model->agendamiento_establecer_fecha_inicio_reunion( $id_agendamiento );
    }

    /**
     * Carga página que muestra información de un Agendamiento
     * @param int $id_agendamiento Identificador del agendamiento a mostrar
     */
    public function agendamiento_ver_pendientes( $id_agendamiento ) {

        $id_site = $this->session->userdata( 'SIT_ID' );

        $this->data['agendamiento'] = $this->platc_model->agendamiento_get( $id_agendamiento, $id_site );
        $this->data['especialista'] = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_ESPECIALISTA'] );
        $this->data['generalista']  = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_MEDICO'] );

        $this->index( 'agendamiento_ver_pendientes_view' );
    }

    /**
     * Carga página que muestra información de un Agendamiento
     * @param int $id_agendamiento Identificador del agendamiento a mostrar
     */
    public function agendamiento_ver_proceso_atencion( $id_agendamiento ) {

        $id_site = $this->session->userdata( 'SIT_ID' );

        $this->data['agendamiento'] = $this->platc_model->agendamiento_get( $id_agendamiento, $id_site );
        $this->data['especialista'] = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_ESPECIALISTA'] );
        $this->data['generalista']  = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_MEDICO'] );

        $this->index( 'agendamiento_ver_proceso_atencion_view' );
    }

    /**
     * Carga página que muestra información de un Agendamiento
     * @param int $id_agendamiento Identificador del agendamiento a mostrar
     */
    public function agendamiento_ver_realizados( $id_agendamiento ) {

        $id_site = $this->session->userdata( 'SIT_ID' );

        $this->data['agendamiento'] = $this->platc_model->agendamiento_get( $id_agendamiento, $id_site );
        $this->data['especialista'] = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_ESPECIALISTA'] );
        $this->data['generalista']  = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_MEDICO'] );

        $this->index( 'agendamiento_ver_realizados_view' );
    }

    /**
     * Carga página que muestra información de un Agendamiento
     * @param int $id_agendamiento Identificador del agendamiento a mostrar
     */
    public function agendamiento_ver_cancelados( $id_agendamiento ) {

        $id_site = $this->session->userdata( 'SIT_ID' );

        $this->data['agendamiento'] = $this->platc_model->agendamiento_get( (int)$id_agendamiento, $id_site );
        $this->data['especialista'] = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_ESPECIALISTA'] );
        $this->data['generalista']  = $this->platc_model->usuario_get( $this->data['agendamiento']['USU_ID_MEDICO'] );
        $this->data['agendamiento_historia'] = $this->platc_model->agendamiento_historial( (int)$id_agendamiento, 4 );
//imprimir( $this->data['agendamiento_historia'] );
        $this->index( 'agendamiento_ver_cancelados_view' );
    }

    public function agendamiento_cancelar_reunion( ) {

        $id_agendamiento    = $this->input->post( 'id_agendamiento' );
        $id_motivo_rechazo  = $this->input->post( 'id_motivo_rechazo' );
        $motivo             = $this->input->post( 'motivo' );

        $estado = $this->platc_model->agendamiento_cancelar_reunion( $id_agendamiento, $id_motivo_rechazo, $motivo );

        if( $estado )
            $this->output->set_output( 'true' );
        else
            $this->output->set_output( 'false' );
    }

    public function agendamiento_iniciar_reunion( ) {

        $id_agendamiento    = $this->input->post( 'id_agendamiento' );

        $estado = $this->platc_model->agendamiento_en_espera_atencion( $id_agendamiento );

        if( $estado )
            $this->output->set_output( 'true' );
        else
            $this->output->set_output( 'false' );
    }

    public function agendamiento_terminar_reunion( ) {

        $id_agendamiento = $this->input->post( 'id_agendamiento' );
        $comentarios     = $this->input->post( 'comentarios' );

        $estado = $this->platc_model->agendamiento_terminar_reunion( $id_agendamiento, $comentarios );

        if( $estado )
            $this->output->set_output( 'true' );
        else
            $this->output->set_output( 'false' );
    }

    public function agendamiento_cambiar_fecha_hora( ) {

        $id_agendamiento    = $this->input->post('id_agendamiento');
        $fecha              = $this->input->post('fecha');
        $hora               = $this->input->post('hora');

        $estado = $this->platc_model->agendamiento_cambiar_fecha_hora( $id_agendamiento, $fecha, $hora );

        $resp = array( );
        if( $estado == true ) {
            $resp['action'] = true;
            $resp['msgt']   = $this->lang->line('agendamiento_agregar');
            $resp['msg']    = $this->lang->line('agendamiento_cambio_hora_ok');
        } else {
            $resp['action'] = false;
            $resp['msgt']   = $this->lang->line('agendamiento_agregar');
            $resp['msg']    = $this->lang->line('agendamiento_cambio_hora_error');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    public function agendamiento_exportar( $id_estado_agendamiento ) {

        if( !in_array( (int)$id_estado_agendamiento, Platc::$AGENDAMIENTO_ESTADOS ) )
            return;

        switch( (int)$id_estado_agendamiento ) {
            case Platc::$AGENDAMIENTO_ESTADOS['TOMADA']     : $this->agendamiento_exportar_tomada( ); break;
            case Platc::$AGENDAMIENTO_ESTADOS['FINALIZADA'] : $this->agendamiento_exportar_finalizada( ); break;
            case Platc::$AGENDAMIENTO_ESTADOS['CANCELADA']  : $this->agendamiento_exportar_cancelada( ); break;
        }
    }

    private function agendamiento_exportar_tomada( ) {

        // 1) Obtiene listado de teleconsultas
        $reporte = $this->platc_model->agendamiento_exportar_tomadas( Platc::$AGENDAMIENTO_ESTADOS['TOMADA'] );

        // 2) Datos generales (como cabezera del formulario)
        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);

        $i = 1;

        // 3) Completa fila de cabezera de tabla
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( "Agenda ID" ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'tc_establ' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'agendamiento_fecha_hora_agenda' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'tc_especialidad_busqueda' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'rol_3' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'agendamiento_persona_que_agenda' ) ) );
        $i++; // Salto de línea

        foreach( $reporte as $r ) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $r['AGE_ID']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $r['PAC_IDT_VALOR']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $r['PAC_PRIMER_NOMBRE'].' '.$r['PAC_PRIMER_APELLIDO'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $r['ETB_NOMBRE']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $r['AGE_HORA'] . " " . $this->util->fecha_orden( $r['AGE_FECHA'] ) );
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $r['ESP_NOMBRE']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $r['USU_NOMBRE_ESPECIALISTA'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $r['USU_NOMBRE_GENERALISTA'] );
            $i++; // Salto de línea
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Agendas_confirmadas_' . date('d-m-Y') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    private function agendamiento_exportar_finalizada( ) {

        // 1) Obtiene listado de teleconsultas
        $reporte = $this->platc_model->agendamiento_exportar_finalizadas( Platc::$AGENDAMIENTO_ESTADOS['FINALIZADA'] );

        // 2) Datos generales (como cabezera del formulario)
        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);

        $i = 1;

        // 3) Completa fila de cabezera de tabla
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'tc_establ' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'rol_4' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'fechahora_envio' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'usuarios_especialidad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'fechahora_contestada' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( $this->lang->line( 'agenda_duracion' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( $this->lang->line( 'rol_3' ) ) );
        $i++; // Salto de línea

        foreach( $reporte as $r ) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $r['TEL_ID']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $r['PAC_IDT_VALOR']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $r['PAC_PRIMER_NOMBRE'].' '.$r['PAC_PRIMER_APELLIDO'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $r['ETB_NOMBRE']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $r['USU_NOMBRE_GENERALISTA'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, ( ( !empty( $r['TEL_FECHA_HORA_ENVIO'] ) ) ? $this->util->fecha_orden2( $r['TEL_FECHA_HORA_ENVIO'] ) : null ) );
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $r['ESP_NOMBRE'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, ( ( !empty( $r['TEL_FECHA_HORA_RESPUESTA'] ) ) ? $this->util->fecha_orden2( $r['TEL_FECHA_HORA_RESPUESTA'] ) : null ) );
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $r['DURACION_TC_SINCRONICA'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $r['USU_NOMBRE_ESPECIALISTA'] );
            $i++; // Salto de línea
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Agendas_realizadas_' . date('d-m-Y') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    private function agendamiento_exportar_cancelada( ) {

        // 1) Obtiene listado de teleconsultas
        $reporte = $this->platc_model->agendamiento_exportar_cancelada( Platc::$AGENDAMIENTO_ESTADOS['CANCELADA'] );

        // 2) Datos generales (como cabezera del formulario)
        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);

        $i = 1;

        // 3) Completa fila de cabezera de tabla
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'tc_nom_ape' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'tc_establ' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'agendamiento_fecha_hora_agenda' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'usuarios_especialidad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'rol_3' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'agenda_usuario_cancela' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( $this->lang->line( 'agenda_motivo_cancela' ) ) );
        $i++; // Salto de línea
//tc_motivo_rechazo_title
        foreach( $reporte as $r ) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $r['TEL_ID']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $r['PAC_IDT_VALOR']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $r['TEL_PAC_PRIMER_NOMBRE'].' '.$r['TEL_PAC_PRIMER_APELLIDO'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $r['ETB_NOMBRE']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $r['AGE_HORA'] . " " . $this->util->fecha_orden( $r['AGE_FECHA'] ) );
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $r['ESP_NOMBRE'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $r['USU_NOMBRE_ESPECIALISTA'] );
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $r['USU_CANCELA'] );

            switch( (int)$r['AMR_ID_MOTIVO_CANCELA'] ) {
                case 1 : $texto = $this->lang->line('agendamiento_paciente_no_asiste'); break;
                case 2 : $texto = $this->lang->line('agendamiento_paciente_cancela_cita'); break;
                case 3 : $texto = $this->lang->line('agendamiento_problema_conectividad'); break;
                case 4 : $texto = html_entity_decode( $r['AMR_COMENTARIO'] ); break;
                default: $texto = "-";
            }

            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $texto );
            $i++; // Salto de línea
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Agendas_canceladas_' . date('d-m-Y') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    /**
     * Realiza salida del listado de plantillas asociados a un site. Site
     * determinado por el usuario en sesión. Solicitud hecha al crear una TC,
     * al cargar sección "examen físico".
     *
     * Método llamado via ajax, salida formateada en json
     */
    public function plantillas_get( ) {

        if( $this->session->is_logged( ) ) {

            $tags = array( 'tc_examen_fisico_cabeza', 'tc_examen_fisico_cuello', 'tc_examen_fisico_torax', 'tc_examen_fisico_abdomen', 'tc_examen_fisico_genitales', 'tc_examen_fisico_extremidades', 'tc_examen_fisico_neurologico' );
            $plantillas = $this->platc_model->plantillas_get( $this->session->userdata( 'SIT_ID' ), $tags );

            $listado_plantillas = array();
            foreach( $plantillas as $plantilla ) {
                $p = array( );
                $p = array( 'id' => $plantilla['PLA_ID'], 'nombre' => $this->lang->line( 'plantilla_'.$plantilla['PLA_NOMBRE'] ), 'texto' => ( !empty( $plantilla['PLA_TEXTO'] ) ? $plantilla['PLA_TEXTO'] : '' ) );

                $listado_plantillas[ $plantilla['PLA_TAG'] ][] = $p;
            }

            $this->output->set_output( json_encode( $listado_plantillas ) );
        }
    }

    /**
     * Realiza salida del texto asociado a una plantilla
     *
     * Método llamado via ajax
     *
     * @param int $id_plantilla Id de la plantilla a retornar
     */
    public function plantilla_get( $id_plantilla = NULL ) {

        if( !empty( $id_plantilla ) && $this->session->is_logged( ) ) {
            $texto = $this->platc_model->plantilla_get( $id_plantilla );
        }

        $this->output->set_output( ( $texto ) );
    }

    public function tc_revisor_aprueba( ) {

        /*
         * Valida que la TC no haya cambiado de estado con anterioridad
         */
        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( $tc['EST_ID'] == 7 || $tc['EST_ID'] == 5 || $tc['EST_ID'] == 3 || ( $tc['EST_ID'] == 2 && $tc['TEL_REVISADA'] == 1 ) ) {

            switch( (int)$tc['EST_ID'] ) {
                case 7: {$texto = $this->lang->line('tc_respondido_anteriormente');} break;
                case 5: {$texto = $this->lang->line('tc_sol_examen_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
                case 2: {$texto = $this->lang->line('tc_enviada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        // Realiza validación
        $chk_control = FALSE;
        $data_user = $this->platc_model->login( $this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd') ) );

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] && $data_user != FALSE ) {

            $data['TEL_ID'] = $this->input->post( 'tc_id' );
            $data['EST_ID'] = 2;        // Mismo estado si viene de nueva/enviada. Establece estado si viene de respuesta de solicitud, necesario para realizar Update
            $data['TEL_REVISADA'] = 1;  // de 0 (no revisada) a 1 (revisada)
            $data['TEL_FECHA_HORA_REVISOR_ENVIO'] = date('Y-m-d') . " " . date('H:i:s');
            $this->platc_model->tc_upd( $data );

            // Deja registro del cambio en TC_TELECONSULTA_ESTADO
            $tc_estado = array( );
            $tc_estado['TEL_ID'] = $data['TEL_ID'];
            $tc_estado['EST_ID'] = $data['EST_ID'];
            $tc_estado['USU_ID'] = $this->session->userdata('USU_ID');
            $tc_estado['TEP_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            $tc_estado['TEP_COMENTARIO'] = sprintf( $this->lang->line('tc_estado_revisor_aprueba'), $this->session->userdata('USU_ID'), $this->session->userdata('USU_NOMBRE') );
            $this->platc_model->tc_estado_set( $tc_estado );

            // Desmarca toma
            $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
            $chk_control = TRUE;
        }

        //mensaje de error
        $resp['action'] = 'true';
        $resp['div']    = 'deploy';
        if ($chk_control == FALSE) {
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('tc_envio_error_passwd');
        } else {
            $resp['msgt']   = 'OK';
            $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
            $resp['msg']    = $this->lang->line('tc_guardada_ok');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    public function tc_revisor_solicitud_info_adicional( ) {

        /*
         * Valida que la TC no haya cambiado de estado con anterioridad
         */
        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( $tc['EST_ID'] == 7 || $tc['EST_ID'] == 5 || $tc['EST_ID'] == 3 || ( $tc['EST_ID'] == 2 && $tc['TEL_REVISADA'] == 1 ) ) {

            switch( (int)$tc['EST_ID'] ) {
                case 7: {$texto = $this->lang->line('tc_respondido_anteriormente');} break;
                case 5: {$texto = $this->lang->line('tc_sol_examen_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
                case 2: {$texto = $this->lang->line('tc_enviada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        // Realiza validación
        $chk_control = FALSE;
        $data_user = $this->platc_model->login( $this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd') ) );

        if( (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_REVISOR'] && $data_user != FALSE ) {

            $data['TEL_ID'] = $this->input->post( 'tc_id' );
            $data['EST_ID'] = 5;        // Cambia estado de nueva/enviada a solicitud de examen
            $data['TEL_REVISADA'] = 0;  // se mantiene sin revisar (0: sin revisar)
            $data['TEL_FECHA_HORA_REVISOR_SOLEXA'] = date('Y-m-d') . " " . date('H:i:s');
            $data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'] = $this->input->post('revisor_solicitud_info_adicional_inpt');  //
            $this->platc_model->tc_upd( $data );

            // Deja registro del cambio en TC_TELECONSULTA_ESTADO
            $tc_estado = array( );
            $tc_estado['TEL_ID'] = $data['TEL_ID'];
            $tc_estado['EST_ID'] = $data['EST_ID'];
            $tc_estado['USU_ID'] = $this->session->userdata('USU_ID');
            $tc_estado['TEP_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            $tc_estado['TEP_COMENTARIO'] = sprintf( $this->lang->line('tc_estado_revisor_solicitar_informacion'), $this->session->userdata('USU_ID'), $this->session->userdata('USU_NOMBRE') );
            $this->platc_model->tc_estado_set( $tc_estado );

            // Desmarca toma
            $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
            $chk_control = TRUE;
        }

        //mensaje de error
        $resp['action'] = 'true';
        $resp['div']    = 'deploy';
        if ($chk_control == FALSE) {
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('tc_envio_error_passwd');
        } else {

            // Envía correo avisando del cambio de estado a solicitud de examen
            $this->correo_estado_examen_solicitado_revisor( $data['TEL_ID'] );
            $resp['msgt']   = 'OK';
            $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
            $resp['msg']    = $this->lang->line('tc_guardada_ok');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     * Envía correo al médico generalista dando aviso del cambio de estado de la TC
     * a examen solicitado por parte del Revisor
     * Asume que TC ya está en estado (5)Solicitud de examen: asi se sabe
     * quién hizo la solicitud para establecer el remitente ("from") en el mail
     */
    private function correo_estado_examen_solicitado_revisor( $id_teleconsulta ) {

        if( (bool)$this->config->item( 'email_activo', 'platc' ) ) {

            $tc = $this->platc_model->tc_get( $id_teleconsulta );

            // Destinatario es Generalista. "foreach" necesario por si TC tiene historia de revisor
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
                    $id_generalista = $estado['USU_ID'];
            }

            // Remitente
            // TODO: Verificar si es usuario de sesion o de la historia quien se establece como Remitente: Por si especialista se desvincula
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 5 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] )
                    $id_revisor = $estado['USU_ID'];
            }

            // Establece datos para el correo
            $revisor = $this->platc_model->usuario_get( $id_revisor );
            $generalista  = $this->platc_model->usuario_get( $id_generalista );

            $datos = array( );
            $datos[ 'id_teleconsulta' ]     = $tc['TEL_ID'];
            $datos[ 'nombre_generalista' ]  = $generalista['USU_NOMBRE'];
            $datos[ 'nombre_paciente' ]     = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO'] . ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' ) ;
            $datos[ 'nombre_especialista' ] = $revisor['USU_NOMBRE'];
            $datos[ 'solicitud' ]           = $tc['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL'];

            // Realiza configuración de librería "email" de CI. Como toda librería
            // propia de CI, se usa la variable $this->email
            $this->util->email_factory();
            $plantilla_email = $this->platc_model->plantilla_email_get( (int)$this->session->userdata('SIT_ID'), 5 );

            // Desde:
            $this->email->from( $this->config->item( 'email_usuario', 'platc' ), $this->config->item( 'email_nombre_remitente', 'platc' ) );

            // Hacia: usuario medico destinatario
    //        $this->email->to( $datos['generalista']['USU_EMAIL'] );
            $this->email->to( 'certificacion.medsolutions@gmail.com' );

            // Asunto
            $this->load->library('parser');
            $asunto  = $this->parser->parse_string( (string)$plantilla_email['EMA_ASUNTO'], $datos );
            $this->email->subject( $asunto );

            // Mensaje
            $mensaje = $this->parser->parse_string( (string)$plantilla_email['EMA_TEXTO'], $datos );
            $this->email->message( nl2br( $mensaje ) );

            $result = $this->email->send( );
            log_message( 'INFO', $this->email->print_debugger() );

            return $result;
        }

        return TRUE;
    }

    public function tc_revisor_responder_solicitud_info_adicional( ) {

        /*
         * Valida que la TC no haya cambiado de estado con anterioridad
         */
        $tc = $this->platc_model->tc_get( (int)$this->input->post('tc_id') );

        if( $tc['EST_ID'] == 7 || ( $tc['EST_ID'] == 6 && $tc['TEL_REVISADA'] == 0 ) || $tc['EST_ID'] == 3 || ( $tc['EST_ID'] == 2 && $tc['TEL_REVISADA'] == 1 ) ) {

            switch( (int)$tc['EST_ID'] ) {
                case 7: {$texto = $this->lang->line('tc_respondido_anteriormente');} break;
                case 6: {$texto = $this->lang->line('tc_sol_examen_resp_pendiente');} break;
                case 3: {$texto = $this->lang->line('tc_rechazada_anteriormente');} break;
                case 2: {$texto = $this->lang->line('tc_enviada_anteriormente');} break;
            };
            $resp = array( );
            $resp['action'] = 'true';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        // Realiza validación
        $chk_control = FALSE;
        $data_user = $this->platc_model->login( $this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd') ) );

        if( (   (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_GENERAL'] ||
                (int)$this->session->userdata('ROL_ID') == self::$ROL['MEDICO_ASISTENTE'] ) && $data_user != FALSE ) {

            $data['TEL_ID'] = $this->input->post( 'tc_id' );
            $data['EST_ID'] = 6;        // Cambia estado de (5) solicitud de examen a (6) examenes realizados
            $data['TEL_REVISADA'] = 0;  // se mantiene sin revisar (0: sin revisar)
            $data['TEL_FECHA_HORA_REVISOR_SOLEXARESP'] = date('Y-m-d') . " " . date('H:i:s');
            $data['TEL_REVISOR_SOLICITUD_INFO_ADICIONAL_RESP'] = $this->input->post('revisor_respuesta_solicitud_info_adicional_resp');  //
            $this->platc_model->tc_upd( $data );

            // Deja registro del cambio en TC_TELECONSULTA_ESTADO
            $tc_estado = array( );
            $tc_estado['TEL_ID'] = $data['TEL_ID'];
            $tc_estado['EST_ID'] = $data['EST_ID'];
            $tc_estado['USU_ID'] = $this->session->userdata('USU_ID');
            $tc_estado['TEP_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            $tc_estado['TEP_COMENTARIO'] = sprintf( $this->lang->line('tc_estado_revisor_responde_solexa'), $this->session->userdata('USU_ID'), $this->session->userdata('USU_NOMBRE') );
            $this->platc_model->tc_estado_set( $tc_estado );

            $chk_control = TRUE;

            // Desmarca toma
            $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
        }

        //mensaje de error
        $resp['action'] = 'true';
        $resp['div']    = 'deploy';
        if ($chk_control == FALSE) {
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('tc_envio_error_passwd');
        } else {
            $resp['msgt']   = 'OK';
            $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
            $resp['msg']    = $this->lang->line('tc_guardada_ok');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     * Pone en estado "Rechazada" a una TC que se encuentra en
     * estado "Enviada/Nueva" y "Respuesta de solicitud de examen"
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_revisor_enviada_rechazar() {

        $tc = $this->platc_model->tc_get( $this->input->post('tc_id') );

        if( $tc['EST_ID'] == 3 || $tc['EST_ID'] == 5 || $tc['EST_ID'] == 7 ) {

            switch( (int)$tc['EST_ID'] ) {

                case 3 : $texto = $this->lang->line('tc_rechazada_anteriormente');
                case 5 : $texto = $this->lang->line('tc_sol_examen_pendiente');
                case 7 : $texto = $this->lang->line('tc_respondido_anteriormente');
            }

            $resp = array( );
            $resp['action'] = 'true';
            $resp['div']    = 'deploy';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $texto;
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
        if ($data_user != FALSE) {

            $id_tc = $this->input->post( 'tc_id', true );
            $motivo_id = $this->input->post( 'motivo_id', true );
            $motivo_comentario = $this->input->post( 'motivo_comentario' );

            $estado = $this->platc_model->tc_rechazar( $id_tc, $motivo_id, $motivo_comentario );
            if( $estado ) {
                $this->correo_estado_rechazado_revisor( $id_tc );
                $this->output->set_output('true');
            } else
                $this->output->set_output('false');
        } else {

            $resp['msgt'] = $this->lang->line('error');
            $resp['msg'] = $this->lang->line('tc_error_passwd');
            $this->output->set_output( json_encode( $resp ) );
        }

    }

    /**
     * Envía correo al médico generalista dando aviso del cambio de estado de la TC
     * a examen rechazado
     */
    private function correo_estado_rechazado_revisor( $id_teleconsulta ) {

        if( (bool)$this->config->item( 'email_activo', 'platc' ) ) {

            $tc = $this->platc_model->tc_get( $id_teleconsulta );

            // Si se recibe desde solicitud de examen se envía correo al Generalista
            // que solicita el examen. Si no está en 'respuesta de solicitud de examen'
            // ($this->platc_model->tc_ultimo_estado(x, 6) retorna vacío) entonces la TC
            // viene del estado enviada/nueva ($this->platc_model->tc_ultimo_estado(x, 2)
            // Destinatario: Generalista
            $estados  = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 6 );
            if( empty( $estados ) )
                $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 2 );

            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_GENERAL'] )
                    $id_generalista = $estado['USU_ID'];
            }

            // Remitente: Revisor
            $estados = $this->platc_model->tc_ultimo_estado( $tc['TEL_ID'], 3 );
            foreach( $estados as $estado ) {
                if( $estado['ROL_ID'] == self::$ROL['MEDICO_REVISOR'] )
                    $id_revisor = $estado['USU_ID'];
            }

            // Establece datos para el correo
            $revisor        = $this->platc_model->usuario_get( $id_revisor );
            $generalista    = $this->platc_model->usuario_get( $id_generalista );

            $datos = array( );
            $datos[ 'id_teleconsulta' ]     = $tc['TEL_ID'];
            $datos[ 'nombre_generalista' ]  = $generalista['USU_NOMBRE'];
            $datos[ 'nombre_paciente' ]     = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO'] . ( !empty( $tc['TEL_PAC_SEGUNDO_APELLIDO'] ) ? ' ' . $tc['TEL_PAC_SEGUNDO_APELLIDO'] : '' );
            $datos[ 'nombre_revisor' ]      = $revisor['USU_NOMBRE'];
            $datos[ 'solicitud' ]           = $tc['TEL_SOL_ADICIONALES'];

            // Realiza configuración de librería "email" de CI. Como toda librería
            // propia de CI, se usa la variable $this->email
            $this->util->email_factory();
            $plantilla_email = $this->platc_model->plantilla_email_get( (int)$this->session->userdata('SIT_ID'), 3 );

            // Desde: Médico Revisor
            $this->email->from( $this->config->item( 'email_usuario', 'platc' ), $this->config->item( 'email_nombre_remitente', 'platc' ) );

            // Hacia: Médico Generalista
    //        $this->email->to( $datos['generalista']['USU_EMAIL'] );
            $this->email->to( 'certificacion.medsolutions@gmail.com' );

            // Asunto
            $this->load->library('parser');
            $asunto  = $this->parser->parse_string( (string)$plantilla_email['EMA_ASUNTO'], $datos );
            $this->email->subject( $asunto );

            // Mensaje
            $mensaje = $this->parser->parse_string( (string)$plantilla_email['EMA_TEXTO'], $datos );
            $this->email->message( nl2br( $mensaje ) );

            $result = $this->email->send( );
            log_message( 'INFO', $this->email->print_debugger() );

            return $result;
        }

        return TRUE;
    }

    public function derma_lesion_archivos_borradores( $tel_id ) {

        $data = array( );
        $data[ 'lesiones' ] = $this->platc_model->derma_lesion_obtener( $tel_id, TRUE );
        $data[ 'tel_id' ]   = $tel_id;
        $data[ 'ultimo_borrador' ] = key( array_slice( $data[ 'lesiones' ], -1, 1, true ) );

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_lesion_ajax', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $html );
    }

    public function derma_lesion_archivos( $tel_id ) {                                                                      

        $data = array( );
        $data[ 'lesiones' ] = $this->platc_model->derma_lesion_obtener( $tel_id );
        $data[ 'borrador' ] = FALSE;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_lesion_ajax', FormularioXML::$MODO_LECTURA, $data );

        $this->output->set_output( $html );
    }

    public function derma_lesion_agregar_view( $tel_id ) {

        $data = array( );
        $data[ 'tel_id' ]        = $tel_id;
        $data[ 'hash_borrador' ] = $this->platc_model->derma_lesion_crear_carpeta_borrador( $tel_id );

        $this->load->library( 'FormularioXML' );
        $vista = $this->formularioxml->generar_parcial( $tel_id, 'archivos_lesion_agregar', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $vista );
    }


    //aca se realiza la carga de las imagenes para derma 
    public function derma_lesion_archivos_upload( $tel_id, $hash_borrador, $directorio_lesion ) {

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/dermato/$tel_id/
             */
            $ruta = str_replace( '//', '/', 'files/derma/'.$tel_id.DIRECTORY_SEPARATOR.'/borradores/'.$hash_borrador.DIRECTORY_SEPARATOR.$directorio_lesion );

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio borrador
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );
           

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );

                // Si es un archivo del tipo BMP de windows, se convierte a formato PNG
                // esto porque la librería fpdf no lee archivos BMP :(
                if( strtolower( $data['file_ext'] ) == '.bmp' ) {

                    // Carga archivo BMP en memoria
                    $this->load->helper('image');
                    $imagen  = imagecreatefrombmp( $data['full_path'] );
                    if( $imagen ) {

                        // Imagen en memoria ($imagen) es convertido a archivo PNG
                        imagepng( $imagen, $data['file_path'].'/'.$data['raw_name'].'.png', 9, PNG_NO_FILTER );
                        imagedestroy( $imagen );

                        // Mueve a carpeta "borrados" archivo BMP, a modo de respaldo
                        if( !is_dir( $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] ) )
                            @mkdir( $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] );
                        @rename( $data['full_path'], $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'].'/'. date('YmdHis').'_'.$data['file_name'] );

                        // Cambia información, estableciendo archivo convertido PNG como archivo subido
                        $data['file_name']  = $data['raw_name'].'.png';
                        $data['file_type']  = 'image/png';
                        $data['full_path']  = $data['file_path'].'/'.$data['raw_name'].'.png';
                        $data['orig_name']  = $data['raw_name'].'.png';
                        // $data['client_name']= $data['raw_name'].'.png'; <--???
                        $data['file_ext']   = '.png';
                        $data['image_type'] = 'png';
                    } else {
                        log_message( 'error', 'No se pudo convertir archivo de imagen a png: '.$data['full_path'] );
                        $exito = false;
                    }
                }

                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                    echo "<pre>";
                    print_r($exito);
                    echo "</pre>";
                    die();
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function derma_lesion_guardar_comentario( $tel_id, $hash_borrador ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/derma/'.$tel_id;
            $ruta.= '/'.Platc::$DERMA_DIR_FOTOS['BORRADORES'].'/'.$hash_borrador.'/';

            $observacion = NULL;
            $ruta_foto = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$DERMA_DIR_FOTOS['ANATOMICA'] : { $ruta_foto = Platc::$DERMA_DIR_FOTOS['ANATOMICA'];    $observacion = $v; } break;
                        case Platc::$DERMA_DIR_FOTOS['30CM'] :      { $ruta_foto = Platc::$DERMA_DIR_FOTOS['30CM'];         $observacion = $v; } break;
                        case Platc::$DERMA_DIR_FOTOS['LUZBLANCA'] : { $ruta_foto = Platc::$DERMA_DIR_FOTOS['LUZBLANCA'];    $observacion = $v; } break;
                        case Platc::$DERMA_DIR_FOTOS['LUZUV'] :     { $ruta_foto = Platc::$DERMA_DIR_FOTOS['LUZUV'];        $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_foto ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_foto ) )
                            mkdir( $ruta.'/'.$ruta_foto, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_foto.'/'.$ruta_foto.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' HASH['.$hash_borrador.']'.'FOTO['.$ruta_foto.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('derma_lesiones_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('derma_lesiones_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    private function derma_lesion_reorganizar_archivos( $tel_id ) {

        $exito = TRUE;
        $ruta_borrador  = 'files/derma/'.$tel_id.'/'.Platc::$DERMA_DIR_FOTOS['BORRADORES'].'/';
        $ruta_fijo      = 'files/derma/'.$tel_id.'/';

        if( is_dir( $ruta_borrador ) )
            $handle = opendir( $ruta_borrador );
        else
            $handle = false;

        if( $handle ) {

            $i = 1;

            // Recorre todas las lesiones
            while( false !== ( $hash_borrador = readdir( $handle ) ) && $exito ) {

                if( $hash_borrador != '.' && $hash_borrador != '..' ) {

                    $ruta_lesiones_borrador = $ruta_borrador.$hash_borrador;
                    $ruta_lesiones_fijo     = $ruta_fijo.$i;
                    if( @rename( $ruta_lesiones_borrador, $ruta_lesiones_fijo ) )
                        $exito = TRUE;
                    else
                        $exito = FALSE;

                    $i++;
                }
            }

            closedir($handle);
            if( !@rmdir( $ruta_borrador ) ) {
                error_log( 'No se pudo eliminar directorio ['.$ruta_borrador.']');
            }
        }

        return $exito;
    }

    public function derma_lesion_eliminar_borrador( ) {
        
        $exito = FALSE;
        try{
            if( !empty( $_POST ) ) {
            $tel_id         = $this->input->post( 'tel_id' );
            $hash_borrador  = $this->input->post( 'hash' );
            
            $ruta_borradores = 'files/derma/'.$tel_id.'/'.Platc::$DERMA_DIR_FOTOS['BORRADORES'].'/'.$hash_borrador;
            $ruta_borrados   = 'files/derma/'.$tel_id.'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'].'/'.$hash_borrador;

            if( is_dir( $ruta_borradores ) ) {

                if( !is_dir( $ruta_borrados ) )
                    mkdir( $ruta_borrados, 0755, TRUE );

                if( @rename( $ruta_borradores, $ruta_borrados ) )
                    $exito = TRUE;
                else
                    $exito = FALSE;
            }
        }
        }catch(Exception $e)
        {
            
        }
        

        $this->output->set_output( (bool) $exito );
    }

    public function derma_lesion_visualizar( $tel_id ) {

        $data = array( );
        $data['tel_id']     = $tel_id;
        $data['lesiones']   = $this->platc_model->derma_lesion_obtener( $tel_id );

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_vista_completa( $tel_id, 'derma_lesion_imagen_view', $data );

        $this->output->set_output( $html );
    }

    public function otorrino_cabeza_archivos_upload( $tel_id, $x, $y ) {

        // Valida que $x e $y sean rutas válidas
        if( array_search( $x, Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO ) === FALSE &&
            array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/dermato/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.$x.DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_cabeza_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_cabeza' ] = $this->platc_model->otorrino_cabeza_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_cabeza_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_cabeza_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CABEZA'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['FRONTAL']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['FRONTAL'];     $observacion = $v; } break;
                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO']: { $ruta_y = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];   $observacion = $v; } break;
                        case Platc::$OTORRINO_DIR_Y['DERECHO']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['DERECHO'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    /**
     * Elimina (traspasa a borrados) archivos de imagenes/observaciones cuando se
     * suben archivos y se seleccione opción de no requerir imágenes.
     *
     * @param int $tel_id Identificador de la Teleconsulta
     * @param array $array_exa_especifico Array con las variables del POST que el usuario
     * ha ingresado para ingresar en la TC
     */
    private function otorrino_reorganizar_archivos( $tel_id, $array_exa_especifico ) {

        $estado = FALSE;

        /*
         * Recorre cada carpeta de examen específico para comprobar si existe la carpeta
         * cuando el usuario no lo ha ingresado se mueva a Borrados
         */
        $ruta = "files/otorrino/".$tel_id."/";

        // Si no se adjuntan imagenes no se crea $ruta
        if( !is_dir( $ruta ) ) return TRUE;

        $ruta_exa_especificos = opendir( $ruta );
        while( false !== ( $carpeta_exa_especifico = readdir( $ruta_exa_especificos ) ) ) {

            if( $carpeta_exa_especifico != "." && $carpeta_exa_especifico != ".." ) {

                // Asocia variable de $_POST con carpeta de examen específico
                switch( $carpeta_exa_especifico ) {

                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CABEZA']           : { $variable_exa_especifico = 'otorrino_examen_cabeza_imagenes'; } break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_IZQUIERDO']   : { $variable_exa_especifico = 'otorrino_examen_oido_izquierdo_imagenes'; } ; break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_DERECHO']     : { $variable_exa_especifico = 'otorrino_examen_oido_derecho_imagenes'; } ; break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_IZQUIERDO']  : { $variable_exa_especifico = 'otorrino_examen_nariz_izquierdo_imagenes'; } ; break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_DERECHO']    : { $variable_exa_especifico = 'otorrino_examen_nariz_derecho_imagenes'; } ; break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BOCA']             : { $variable_exa_especifico = 'otorrino_examen_boca_imagenes'; } ; break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CUELLO']           : { $variable_exa_especifico = 'otorrino_examen_cuello_imagenes'; } ; break;
                    case Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BORRADOS']         : { $variable_exa_especifico = ''; } ; break;
                }

                // Si el usuario ha decidido no ingresar imagenes ($variable_exa_especifico),
                // entonces mueve archivos a borrados
                if( array_search( $variable_exa_especifico, $array_exa_especifico ) === FALSE ) {

                    if( !is_dir( $ruta.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BORRADOS'] ) )
                        @mkdir( $ruta.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BORRADOS'] );

                    $estado = @rename( $ruta.$carpeta_exa_especifico, $ruta.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BORRADOS'].'/'.date('YmdHis').'_'.$carpeta_exa_especifico );
                }
            }
        }

        return $estado;
    }

    public function otorrino_oido_izquierdo_archivos_upload( $tel_id, $y ) {

        // Valida que $y sea ruta válida
        if( array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_IZQUIERDO'].DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_oido_izquierdo_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_oido_izquierdo' ] = $this->platc_model->otorrino_oido_izquierdo_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_oido_izquierdo_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_oido_izquierdo_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_IZQUIERDO'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function otorrino_oido_derecho_archivos_upload( $tel_id, $y ) {

        // Valida que $y sea ruta válida
        if( array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_DERECHO'].DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_oido_derecho_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_oido_derecho' ] = $this->platc_model->otorrino_oido_derecho_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_oido_derecho_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_oido_derecho_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_DERECHO'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['DERECHO']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['DERECHO'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function otorrino_nariz_izquierdo_archivos_upload( $tel_id, $y ) {

        // Valida que $y sea ruta válida
        if( array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_IZQUIERDO'].DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_nariz_izquierdo_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_nariz_izquierdo' ] = $this->platc_model->otorrino_nariz_izquierdo_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_nariz_izquierdo_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_nariz_izquierdo_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_IZQUIERDO'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function otorrino_nariz_derecho_archivos_upload( $tel_id, $y ) {

        // Valida que $y sea ruta válida
        if( array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_DERECHO'].DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_nariz_derecho_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_nariz_derecho' ] = $this->platc_model->otorrino_nariz_derecho_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_nariz_derecho_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_nariz_derecho_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_DERECHO'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['DERECHO']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['DERECHO'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function otorrino_boca_archivos_upload( $tel_id, $y ) {

        // Valida que $y sea ruta válida
        if( array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BOCA'].DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_boca_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_boca' ] = $this->platc_model->otorrino_boca_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_boca_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_boca_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BOCA'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['BOCA']  : { $ruta_y = Platc::$OTORRINO_DIR_Y['BOCA'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function otorrino_cuello_archivos_upload( $tel_id, $y ) {

        // Valida que $y sea ruta válida
        if( array_search( $y, Platc::$OTORRINO_DIR_Y ) === FALSE ) {

            $this->output->set_output( 0 );
            return false;
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/otorrino/'.$tel_id.DIRECTORY_SEPARATOR.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CUELLO'].DIRECTORY_SEPARATOR.$y;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OTORRINO_DIR_Y['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );
                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function otorrino_cuello_archivos( $tel_id, $modo ) {

        $data = array( );
        $data[ 'otorrino_cuello' ] = $this->platc_model->otorrino_cuello_obtener( $tel_id );
        $modo = ( $modo == 0 ) ? FormularioXML::$MODO_ESCRITURA : FormularioXML::$MODO_LECTURA;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'otorrino_examen_cuello_imagenes_ajax', $modo, $data );

        $this->output->set_output( $html );
    }

    public function otorrino_cuello_guardar_comentario( $tel_id ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CUELLO'].'/';

            $observacion = NULL;
            $ruta_y = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OTORRINO_DIR_Y['FRONTAL']      : { $ruta_y = Platc::$OTORRINO_DIR_Y['FRONTAL'];     $observacion = $v; } break;
                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO']    : { $ruta_y = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];     $observacion = $v; } break;
                        case Platc::$OTORRINO_DIR_Y['DERECHO']      : { $ruta_y = Platc::$OTORRINO_DIR_Y['DERECHO'];     $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_y ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_y ) )
                            mkdir( $ruta.'/'.$ruta_y, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_y.'/'.$ruta_y.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' FOTO['.$ruta_y.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('otorrino_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function oftalmologia_archivos_borradores( $tel_id, $protocolo ) {

        switch( $protocolo ) {
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] : {
                $parcial = 'archivos_estructuras_externas_ajax';
            }; break;
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] : {
                $parcial = 'archivos_fondo_ojos_ajax';
            }; break;
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] : {
                $parcial = 'archivos_frontal_cara_ajax';
            }; break;
            default: return;
        }

        $data = array( );
        $data[ 'archivos' ] = $this->platc_model->oftalmologia_obtener( $tel_id, $protocolo );
        $data[ 'tel_id' ]   = $tel_id;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, $parcial, FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $html );
    }

    /*
     *
     */
    public function oftalmologia_guardar_comentario( $tel_id, $protocolo, $hash_borrador ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            // Valida que $protocolo sea ruta válida
            switch( (string)$protocolo ) {

                case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] :
                case Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] : {

                    $ruta = 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.$protocolo.DIRECTORY_SEPARATOR;

                    foreach( $_POST as $lado => $observacion ) {

                        if( !empty( $lado ) && !empty( $observacion ) ) {

                            if( !is_dir( $ruta.$lado ) )
                                mkdir( $ruta.$lado, 0755, TRUE );

                            if( FALSE !== $h_comentario = fopen( $ruta.$lado.'/'.$lado.'.comment', 'w' ) ) {

                                fwrite( $h_comentario, $observacion );
                                fclose( $h_comentario );
                                $exito = TRUE;
                            } else
                                throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.'FOTO['.$lado.']' );
                        }
                    }
                }; break;
                case Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] :
                case Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] : {

                    /*
                     * 1) Establece ruta donde guardar archivo: files/oftalmologia/$tel_id/$protocolo/$hash_borrador
                     */
                    $ruta = 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.$protocolo.DIRECTORY_SEPARATOR.$hash_borrador;

                    /*
                     * 2) Lateralidad del ojo: Izquierdo (Platc::$OFTALMOLOGICO_LADO['IZQUIERDO']) o derecho (Platc::$OFTALMOLOGICO_LADO['DERECHO])
                     */
                    $lateralidad_ojo = $this->input->post('lateralidad_ojo');

                    if( !is_dir( $ruta ) )
                        mkdir( $ruta, 0755, TRUE );

                    if( !empty( $lateralidad_ojo ) ) {
                        if( FALSE !== $h_comentario = fopen( $ruta.'/lateralidad_ojo.comment', 'w' ) ) {

                            fwrite( $h_comentario, $lateralidad_ojo );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.'FOTO['.$lado.']' );
                    }

                    /*
                     * 3) Guarda comentario
                     */
                    if( !is_dir( $ruta ) )
                        mkdir( $ruta, 0755, TRUE );

                    $observacion = $this->input->post('observaciones_'.$hash_borrador);
                    if( !empty( $observacion ) ) {
                        if( FALSE !== $h_comentario = fopen( $ruta.'/observaciones.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.'FOTO['.$lado.']' );
                    }
                }; break;
                default:{   $this->output->set_output( 0 );
                            return false;}
            }


        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('oftalmologia_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('oftalmologia_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function oftalmologia_archivos( $tel_id, $protocolo ) {

        // Valida que $protocolo sea ruta válida
        switch( (string)$protocolo ) {

            case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS']   : $archivo = Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS']; break;
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS']             : $archivo = Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS']; break;
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA']  : $archivo = Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA']; break;
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA']           : $archivo = Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA']; break;
            default:{   $this->output->set_output( 0 );
                        return false;}
        }

        $data = array( );
        $data[ 'archivos' ] = $this->platc_model->oftalmologia_obtener( $tel_id, $protocolo );
        $data[ 'tel_id' ]   = $tel_id;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_'.$archivo.'_ajax', FormularioXML::$MODO_LECTURA, $data );

        $this->output->set_output( $html );
    }

    public function oftalmologia_archivos_upload( $tel_id, $protocolo, $lado = '', $hash_borrador = '' ) {

        // Valida que $protocolo sea ruta válida
        switch( (string)$protocolo ) {

            case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] :
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] : {

                // Verifica que $lado tenga un valor válido
                switch( (string)$lado ) {

                    case Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] : ; break;
                    case Platc::$OFTALMOLOGICO_LADO['DERECHO'] : ; break;
                    default:    {$this->output->set_output( 0 );
                                return false;}
                }

                /*
                 * 1) Establece ruta donde guardar archivo: files/oftalmologia/$tel_id/$protocolo/$lado
                 */
                $ruta = 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.$protocolo.DIRECTORY_SEPARATOR.$lado;
            }; break;
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] :
            case Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] : {
                $lado = "";

                /*
                 * 1) Establece ruta donde guardar archivo: files/oftalmologia/$tel_id/$protocolo/hash_borrador
                 */
                $ruta = 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.$protocolo.DIRECTORY_SEPARATOR.$hash_borrador;
            }; break;
            default:{   $this->output->set_output( 0 );
                        return false;}
        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza carga del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );

                // Si es un archivo del tipo BMP de windows, se convierte a formato PNG
                // esto porque la librería fpdf no lee archivos BMP :(
                if( $data['file_ext'] == '.bmp' ) {

                    // Carga archivo BMP en memoria
                    $this->load->helper('image');
                    $imagen  = imagecreatefrombmp( $data['full_path'] );
                    if( $imagen ) {

                        // Imagen en memoria ($imagen) es convertido a archivo PNG
                        imagepng( $imagen, $data['file_path'].'/'.$data['raw_name'].'.png', 9, PNG_NO_FILTER );
                        imagedestroy( $imagen );

                        // Mueve a carpeta "borrados" archivo BMP
                        if( !is_dir( $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] ) )
                            @mkdir( $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] );
                        @rename( $data['full_path'], $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'].'/'. date('YmdHis').'_'.$data['file_name'] );

                        // Cambia información, estableciendo archivo convertido PNG como archivo subido
                        $data['file_name']  = $data['raw_name'].'.png';
                        $data['file_type']  = 'image/png';
                        $data['full_path']  = $data['file_path'].'/'.$data['raw_name'].'.png';
                        $data['orig_name']  = $data['raw_name'].'.png';
                        // $data['client_name']= $data['raw_name'].'.png'; <--???
                        $data['file_ext']   = '.png';
                        $data['image_type'] = 'png';
                    } else {
                        log_message( 'error', 'No se pudo convertir archivo de imagen a png: '.$data['full_path'] );
                        $exito = false;
                    }
                }

                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function oftalmologia_tincion_fluorescencia_archivos_borradores( $tel_id ) {

        $data = array( );
        $data[ 'tincion_fluorescencia_archivos' ]   = element( Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'], $this->platc_model->oftalmologia_obtener( $tel_id, Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] ) );
        $data[ 'tel_id' ]                           = $tel_id;
        $data[ 'lados' ]                            = array(Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] => $this->lang->line('oftalmologia_izquierdo'),
                                                            Platc::$OFTALMOLOGICO_LADO['DERECHO'] => $this->lang->line('oftalmologia_derecho') );


        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_tincion_fluorescencia_ajax', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $html );
    }

    public function oftalmologia_frontal_cara_agregar_view( $tel_id ) {

        $data = array( );
        $data[ 'tel_id' ]        = $tel_id;
        $data[ 'hash_borrador' ] = substr( md5( rand( ) ), 1, 5 );

        $this->load->library( 'FormularioXML' );
        $vista = $this->formularioxml->generar_parcial( $tel_id, 'archivos_frontal_cara_agregar', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $vista );
    }

    public function oftalmologia_tincion_fluorescencia_agregar_view( $tel_id ) {

        $data = array( );
        $data[ 'tel_id' ]        = $tel_id;
        $data[ 'hash_borrador' ] = substr( md5( rand( ) ), 1, 5 );
        $data[ 'lados' ]         = array(   Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] => $this->lang->line('oftalmologia_izquierdo'),
                                            Platc::$OFTALMOLOGICO_LADO['DERECHO'] => $this->lang->line('oftalmologia_derecho') );

        $this->load->library( 'FormularioXML' );
        $vista = $this->formularioxml->generar_parcial( $tel_id, 'archivos_tincion_fluorescencia_agregar', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $vista );
    }

    public function oftalmologia_eliminar_borrador( ) {

        $exito = FALSE;

        if( !empty( $_POST ) ) {

            $protocolo      = $this->input->post( 'protocolo' );
            $tel_id         = $this->input->post( 'tel_id' );
            $hash_borrador  = $this->input->post( 'hash' );

            // Valida que $protocolo sea ruta válida
            switch( (string)$protocolo ) {

                case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] :
                case Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] : {

                    $this->output->set_output( 0 ); return false;
                }; break;
                case Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] :
                case Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] : {

                    /*
                     * 1) Establece ruta donde guardar archivo: files/oftalmologia/$tel_id/$protocolo/$hash_borrador
                     */
                    $ruta = 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.$protocolo;
                }; break;
                default:{   $this->output->set_output( 0 );
                            return false;}
            }

            $ruta_borradores = $ruta.'/'.$hash_borrador;
            $ruta_borrados   = $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'].DIRECTORY_SEPARATOR.$hash_borrador;

            if( is_dir( $ruta_borradores ) ) {

                if( !is_dir( $ruta_borrados ) )
                    mkdir( $ruta_borrados, 0755, TRUE );

                if( @rename( $ruta_borradores, $ruta_borrados ) )
                    $exito = TRUE;
                else
                    $exito = FALSE;
            }
        }

        $this->output->set_output( (bool) $exito );
    }

    /**
     * Realiza salida del listado de plantillas asociados a un site. Site
     * determinado por el usuario en sesión. Solicitud hecha al crear una TC,
     * al cargar sección "examen físico".
     *
     * Método llamado via ajax, salida formateada en json
     */
    public function oftalmologia_plantillas_get( ) {

        if( $this->session->is_logged( ) ) {

            $tags = array( 'examen_externo_parpado', 'examen_externo_orbita', 'examen_externo_conjuntiva', 'examen_externo_cornea', 'examen_externo_iris_pupila' );
            $plantillas = $this->platc_model->plantillas_get( $this->session->userdata( 'SIT_ID' ), $tags );

            $listado_plantillas = array();
            foreach( $plantillas as $plantilla ) {
                $p = array( );
                $p = array( 'id' => $plantilla['PLA_ID'], 'nombre' => $this->lang->line( 'plantilla_'.$plantilla['PLA_NOMBRE'] ), 'texto' => ( !empty( $plantilla['PLA_TEXTO'] ) ? $plantilla['PLA_TEXTO'] : '' ) );

                $listado_plantillas[ $plantilla['PLA_TAG'] ][] = $p;
            }

            $this->output->set_output( json_encode( $listado_plantillas ) );
        }
    }

	//TC ADMIN
	public function tc_admin() {
		$this->index( 'tc_admin_view' );
	}

    public function tc_admin_buscar( $id ) {
        $this->data['teleconsultas'] = $this->platc_model->busca_tcid($id);
        if ($this->data['teleconsultas'] != NULL) {
            // TODO: Se establece estos valores para compatibilidad con grilla en tc_busqueda_datagrid_view.php
            $r['identificador'] = $this->platc_model->tc_ident_get($id);
            $this->data['teleconsultas'][0]['PAC_IDT_VALOR']    = $r['identificador'][0]['TCI_VALOR'];
            $this->data['teleconsultas'][0]['hora_envio']       = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($id, 2) );
            $this->data['teleconsultas'][0]['hora_solexam']     = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($id, 5) );
            $this->data['teleconsultas'][0]['hora_respuesta']   = element( 'TEP_FECHA_HORA', $this->platc_model->busca_tc_estado($id, 7) );
            $this->data['teleconsultas'][0]['usu_especialista'] = element( 'USU_NOMBRE', $this->platc_model->busca_tc_estado($id, 7) );
        }
        $this->session->set_userdata($this->data);
        $this->index('tc_admin_buscar_view');
	}

	public function tc_admin_editar($estado, $tc_id, $view = NULL, $tc_view = NULL, $est_ant = NULL, $id_ant = NULL) {

        $this->data['tc'] = $this->platc_model->tc_get( $tc_id );
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);

        $especialidades = $this->platc_model->especialidades_por_cliente( $this->data['tc']['CLI_ID'] );
        if( !empty( $especialidades ) )
            $this->data['especialidades_select'] = $this->util->select_form_prepare( $especialidades, 'ESP_ID', 'ESP_NOMBRE');
        else
            $this->data['especialidades_select'] = array( );

        $establecimientos = $this->platc_model->establs_cliente_get( $this->data['tc']['CLI_ID'] );
        if( !empty( $establecimientos ) )
            $this->data['establecimiento_select'] = $this->util->select_form_prepare( $establecimientos, 'ETB_ID', 'ETB_NOMBRE');
        else
            $this->data['establecimiento_select'] = array( );

        // Campos RIPS
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $ent_administradoras = $this->platc_model->entidades_administradoras_get( );
            $this->data['ent_admnistradoras_select'] = $this->util->select_form_prepare( $ent_administradoras, 'ENTADM_ID', 'ENTADM_NOMBRE' );

            $finalidad_procedimiento = $this->platc_model->finalidad_procedimiento_get( );
            $this->data['finalidad_procedimiento_select'] = $this->util->select_form_prepare( $finalidad_procedimiento, 'FINPROC_ID', 'FINPROC_DESCRIPCION' );

            $this->data['codigo_autorizacion_inpt'] = $this->data['tc'];

            $ambito_procedimiento = $this->platc_model->ambito_procedimiento_get( );
            $this->data['ambito_procedimiento_select'] = $this->util->select_form_prepare( $ambito_procedimiento, 'AMBPROC_ID', 'AMBPROC_DESCRIPCION' );

            $zona_residencia = $this->platc_model->zona_residencia_get( );
            $this->data['zona_residencia_select'] = $this->util->select_form_prepare( $zona_residencia, 'ZON_ID', 'ZON_NOMBRE' );
        }

        // Identificadores
        $this->data['identificadores'] = $this->platc_model->tc_ident_get( $tc_id );

        // Titulo de la página: estado de la TC (enviada/nueva, solicitud de examen.... )
        $this->data['titulo'] = $this->tc_title($estado, TRUE);

        // Historia del documento
        $this->data['historia'] = $this->platc_model->tc_historia( $tc_id );

        $this->index( 'tc_admin_editar_view' );
        //130062
    }

    public function tc_admin_buscar_paciente($cache = '') {
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $this->data['pacientes'] = $this->platc_model->pacientes_get();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        if ($cache == 'true')
            $this->data['flag'] = TRUE;
        else
            $this->data['flag'] = FALSE;
        $this->index('tc_admin_buscar_paciente_nuevo_view');
    }

	public function tc_admin_getpacientenuevo( $id ) {

        $this->data['paciente']         = $this->platc_model->paciente_get($id);
		$this->data['identificadores']  = $this->platc_model->ident_get( $id );

        $this->index( 'tc_admin_buscar_paciente_nuevo_view' );
	}

	public function tc_admin_actualizar() {

        if( isset($_POST) && !empty($_POST) ) {

            $id_tc              = $this->input->post( 'tel_id' );
            $id_paciente        = $this->input->post( 'pac_id' );
            $id_establecimiento = $this->input->post( 'etb_id' );

			$this->output->set_output( $this->platc_model->tc_admin_actualizar( $id_tc, $id_paciente, $id_establecimiento ) );
		}
		else $this->output->set_output( FALSE );
	}
	//FIN TC ADMIN

    /**
     * Site: PERU
     *
     */
    public function tc_respuesta_pe() {

        $tc = $this->platc_model->tc_get( $this->input->post('tc_id') );

        if( $tc['EST_ID'] == 7 || $tc['EST_ID'] == 5 ) {

            $resp = array( );
            $resp['action'] = 'true';
            $resp['div']    = 'deploy';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('tc_respondido_anteriormente');
            $resp['method'] = base_url() . 'platc/tc_lista_view/'.(int)$tc['EST_ID'].'/';
            $a = json_encode( $resp );
            $this->output->set_output( $a );
            return;
        }

        $this->form_validation->set_rules('tc_id', '', 'required');
        $this->load->library( 'FormularioXML' );
        $campos_requeridos = $this->formularioxml->obtener_campos_requeridos_respuesta( $tc['TEL_ID'] );
        $campos_requeridos[] = 'tc_id';
        foreach( $campos_requeridos as $campo )
            $this->form_validation->set_rules( $campo, '', 'required');

        if( $this->form_validation->run() != FALSE && (int)$this->session->userdata('ROL_ID') == self::$ROL['ESPECIALISTA'] ) {

            $chk_control = FALSE;
            if ($this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE) {
                    $data['EST_ID'] = 7;
                    $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
                    $data['TEL_ABIERTA'] = 1;
                    $data['TEL_FECHA_HORA_RESPUESTA'] = date('Y-m-d') . " " . date('H:i:s');
                } else {
                    $data['EST_ID'] = $this->input->post('estadoanterior');
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = $this->input->post('estadoanterior');
            $data['TEL_ID'] = $this->input->post('tc_id');

            if ($this->platc_model->tc_upd($data)) {

                /*
                 * Inicio nueva lógica TC_TELECONSULTA_DATA
                 */
                $data1 = array( );

                // Hacer lógica para asociar formulario con archivo xml
                $campos = $this->formularioxml->obtener_campos_respuesta( $tc['TEL_ID'] );

                // Ciclo recorre campos definido en xml para obtener información desde $_POST
                foreach( $campos as $campo )
                    if( is_array( $this->input->post( $campo ) ) )

                        $data1[ $campo ]  = json_encode( $this->input->post( $campo ) );
                    else {
                        $c = $this->input->post( $campo );
                        //if( $c != "" && !isset( $data1[ $campo ] ) ) $data1[ $campo ] = preg_replace( '/<br(\s)*(\/)*>/i', "\n", $c );
						if( $c != "" && !isset( $data1[ $campo ] ) ) $data1[ $campo ] = $c;
                    }

                // Elimina la información del autoguardado para después guardar
                $this->platc_model->tc_borrar_data_respuesta( $tc['TEL_ID'] );
                $this->platc_model->tc_agregar_data_respuesta( $tc['TEL_ID'], $data1 );
                /*
                 * Fin nueva lógica TC_TELECONSULTA_DATA
                 */

                // Actualiza respuesta CIE10
//                $codigos_cie_10_respuesta = $this->input->post('dm_general_respuesta');
//                $this->platc_model->tc_update_cie10_respuesta( $data['TEL_ID'], $codigos_cie_10_respuesta );

                if ($this->input->post('estadoanterior') != $data['EST_ID'])
                    $this->tc_cambio_estado($this->input->post('tc_id'), $data['EST_ID'], $this->input->post('prioridad'), $this->session->userdata('USU_ID'));
                $resp['action'] = 'true';
                $resp['div'] = 'deploy';
                if ($this->input->post('estadoanterior') == 6)
                    $resp['method'] = base_url() . 'platc/tc_lista_view/6/';
                else
                    $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                if ($chk_control == TRUE) {
                    $resp['msgt'] = $this->lang->line('error');
                    unset( $resp['method'] );   // Permanece en la página cuando la contrasena es invalida
                    $resp['msg'] = $this->lang->line('tc_error_passwd');
                } elseif ($chk_control == FALSE && $data['EST_ID'] == $this->input->post('estadoanterior')) {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_guardada_ok');
                } else {

                    $this->correo_estado_respondido( (int)$data['TEL_ID'] );
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_enviada_ok');

                    // Desmarca toma
                    $this->platc_model->tc_desmarcar_toma( $data['TEL_ID'] );
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = $this->lang->line('error');
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {

            $resp['action'] = 'false';
            $resp['msgt']   = $this->lang->line('error');
            $resp['msg']    = $this->lang->line('complete_campos');
        }
        $this->output->set_output( json_encode($resp) );
    }

    public function pe_oftalmologia_imagenes_archivos_borradores( $tel_id ) {

        $data = array( );
        $data[ 'imagen' ]   = $this->platc_model->pe_oftalmologia_imagenes_obtener( $tel_id );
        $data[ 'tel_id' ]   = $tel_id;
        $data[ 'ultimo_borrador' ] = key( array_slice( $data[ 'imagen' ], -1, 1, true ) );

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_imagenes_ajax', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $html );
    }

    public function pe_oftalmologia_imagenes_archivos( $tel_id ) {

        $data = array( );
        $data[ 'imagen' ] = $this->platc_model->pe_oftalmologia_imagenes_obtener( $tel_id );
        $data[ 'tel_id' ]   = $tel_id;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_imagenes_ajax', FormularioXML::$MODO_LECTURA, $data );

        $this->output->set_output( $html );
    }

    /*
     *
     */
    public function pe_oftalmologia_guardar_comentario( $tel_id ) {

        // Valida que $protocolo sea ruta válida
//        switch( (string)$lado ) {
//
//            case Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] : break;
//            case Platc::$OFTALMOLOGICO_LADO['DERECHO'] : break;
//            default:{   $this->output->set_output( 0 );
//                        return false;}
//        }

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/oftalmologia/'.$tel_id;

            $observacion = NULL;
            $ruta_foto = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] : { $ruta_foto = Platc::$OFTALMOLOGICO_LADO['IZQUIERDO']; $observacion = $v; } break;
                        case Platc::$OFTALMOLOGICO_LADO['DERECHO']   : { $ruta_foto = Platc::$OFTALMOLOGICO_LADO['DERECHO'];   $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_foto ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_foto ) )
                            mkdir( $ruta.'/'.$ruta_foto, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_foto.'/'.$ruta_foto.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.'FOTO['.$ruta_foto.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('oftalmologia_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('oftalmologia_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function pe_oftalmologia_archivos_upload( $tel_id, $lado = '' ) {

        // Valida que $protocolo sea ruta válida
//        switch( (string)$protocolo ) {

//            case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] : {

                // Verifica que $lado tenga un valor válido
                switch( (string)$lado ) {

                    case Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] : ; break;
                    case Platc::$OFTALMOLOGICO_LADO['DERECHO'] : ; break;
                    default:    {$this->output->set_output( 0 );
                                return false;}
                }
//            }; break;
//            default:{   $this->output->set_output( 0 );
//                        return false;}
//        }

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/otorrino/$tel_id/
             */
            $ruta = 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.$lado;

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio,
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );

                // Si es un archivo del tipo BMP de windows, se convierte a formato PNG
                // esto porque la librería fpdf no lee archivos BMP :(
                if( $data['file_ext'] == '.bmp' ) {

                    // Carga archivo BMP en memoria
                    $this->load->helper('image');
                    $imagen  = imagecreatefrombmp( $data['full_path'] );
                    if( $imagen ) {

                        // Imagen en memoria ($imagen) es convertido a archivo PNG
                        imagepng( $imagen, $data['file_path'].'/'.$data['raw_name'].'.png', 9, PNG_NO_FILTER );
                        imagedestroy( $imagen );

                        // Mueve a carpeta "borrados" archivo BMP
                        if( !is_dir( $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] ) )
                            @mkdir( $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'] );
                        @rename( $data['full_path'], $data['file_path'].'/'.Platc::$DERMA_DIR_FOTOS['BORRADOS'].'/'. date('YmdHis').'_'.$data['file_name'] );

                        // Cambia información, estableciendo archivo convertido PNG como archivo subido
                        $data['file_name']  = $data['raw_name'].'.png';
                        $data['file_type']  = 'image/png';
                        $data['full_path']  = $data['file_path'].'/'.$data['raw_name'].'.png';
                        $data['orig_name']  = $data['raw_name'].'.png';
                        // $data['client_name']= $data['raw_name'].'.png'; <--???
                        $data['file_ext']   = '.png';
                        $data['image_type'] = 'png';
                    } else {
                        log_message( 'error', 'No se pudo convertir archivo de imagen a png: '.$data['full_path'] );
                        $exito = false;
                    }
                }

                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function recetario_formula_listar_medicamentos_tc( $tel_id = '' ) {
        $datos = $this->platc_model->recetario_formulas_medicamentos_tc_get( (int)$tel_id, TRUE );
        $this->output->set_output( json_encode( $datos ) );
    }

    public function recetas_solicitudes_tc( $tel_id = '' ) {

        $datos = $this->platc_model->recetas_solicitudes_tc_get( (int)$tel_id, TRUE );
        $this->output->set_output( json_encode( $datos ) );
    }

    public function recetario_formula_listar( $tel_id = '' ) {

        $datos = array( );
        $datos['tc'] = $this->platc_model->tc_get( (int)$tel_id );
        $datos['listado_formulas'] = $this->platc_model->recetario_formulas_get( (int)$tel_id );

        $this->load->view( 'forms/recetario_listado_formulas_datagrid', $datos );
    }

    public function recetario_formula_crear( $tel_id = '' ) {

        $datos = array();
        $tc = $this->platc_model->tc_get( (int)$tel_id );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
        $datos['tc']['FORMULAS']= $this->platc_model->recetario_formulas_get( (int)$tc['TEL_ID'] );
        $datos['tc']['RECETAS'] = $this->platc_model->recetarios_get( (int)$tc['TEL_ID'] );


        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        $datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
        $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

		$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
		$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";

		$this->load->view('forms/recetario_formula_nuevo', $datos );
    }

    public function recetario_formula_crea( ) {

        // Info formula
        $tel_id                 = $this->input->post('tel_id');
        $tipo                   = Platc::$RECETARIO_TIPO['FORMULA'];
        $id_medico_generalista  = $this->input->post('id_medico_generalista');
        $id_medico_especialista = $this->input->post('id_medico_especialista');
        $paciente_telefono      = $this->input->post('recetario_telefono');
        $paciente_id_municipio  = $this->input->post('recetario_id_municipio');
        $paciente_direccion_residencia = $this->input->post('recetario_direccion_residencia');
//        $recetario_diagnostico  = $this->input->post('recetario_diagnostico');
        $recetario_nombre_formula = $this->input->post('recetario_nombre_formula');

        $rec_id = $this->platc_model->recetario_crear( $tel_id, $tipo, $id_medico_generalista, $id_medico_especialista,
                                                       $paciente_telefono, $paciente_id_municipio, $paciente_direccion_residencia, null, $recetario_nombre_formula );

        // Ciclo que recoge información de los medicamentos
        $medicamentos = array( );
        $listado_medicamentos_post = array( 'nombre_generico', 'concentracion', 'forma_farmaceutica',
                                            'dosis', 'via_administracion', 'cantidad_prescrita_numeros',
                                            'cantidad_prescrita_letras' );

        foreach( $listado_medicamentos_post as $medicamento_post ) {

            foreach( $this->input->post( $medicamento_post ) as $k => $v ) {

                $medicamentos[ $k ][ $medicamento_post ] = $v;
            }
        }

        foreach( $medicamentos as $v ) {

            $this->platc_model->recetario_formula_medicamento_crear($rec_id,
                                                                    $v['nombre_generico'],
                                                                    $v['concentracion'],
                                                                    $v['forma_farmaceutica'],
                                                                    $v['dosis'],
                                                                    $v['via_administracion'],
                                                                    $v['cantidad_prescrita_numeros'],
                                                                    $v['cantidad_prescrita_letras'] );
        }

        if( (int)$rec_id > 0 ) {
            $resp = array(  'msgt' => 'false',
                            'msg'  => 'false',
                            'id_receta'  => (int)$rec_id,
                            'action' => 'true' );

            $this->output->set_output( json_encode( $resp ) );
            return;
        }
    }

    public function recetario_formula_editar( $id_receta = '' ) {

        $datos = array();
        $datos['receta']     = $this->platc_model->recetario_get( $id_receta );
        $datos['receta']['fecha_d'] = (isset($datos['receta']['REC_FECHA']) && $datos['receta']['REC_FECHA'] && date_create($datos['receta']['REC_FECHA'])) ? element( 2, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) ) : "";
        $datos['receta']['fecha_m'] = (isset($datos['receta']['REC_FECHA']) && $datos['receta']['REC_FECHA'] && date_create($datos['receta']['REC_FECHA'])) ? element( 1, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) ) : "";
        $datos['receta']['fecha_a'] = (isset($datos['receta']['REC_FECHA']) && $datos['receta']['REC_FECHA'] && date_create($datos['receta']['REC_FECHA'])) ? element( 0, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) ) : "";
        $datos['formula']       = $this->platc_model->recetario_formula_get( $id_receta );
        $datos['formula_medicamentos'] = $this->platc_model->recetario_formula_medicamentos_get( (int)$id_receta );
        $tc = $this->platc_model->tc_get( (int)$datos['formula']['TEL_ID'] );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
        $datos['tc']['FORMULAS']= $this->platc_model->recetario_formulas_get( (int)$tc['TEL_ID'] );
        $datos['tc']['RECETAS'] = $this->platc_model->recetarios_get( (int)$tc['TEL_ID'] );
        $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (string)$tc['ENTADM_ID'] );

        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );

        $datos['municipio']     = null;
        $datos['entidad_administradora']    = null;
        if( isset( $datos['receta']['MUNI_ID'] ) && !empty( $datos['receta']['MUNI_ID'] ) ) {

            $datos['municipio']     = $this->platc_model->municipio_get( (string)$datos['receta']['MUNI_ID'] );
            $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
        }

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;
        $datos['generalista_identificacion'] = null;
        if( isset( $datos['receta']['USU_ID_GENERALISTA'] ) && !empty( $datos['receta']['USU_ID_GENERALISTA'] ) ) {

            $datos['generalista'] = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_GENERALISTA'] );
            $datos['generalista_identificacion'] = $this->platc_model->identificador_get( $datos['generalista']['IDT_ID'] );
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = null;
        $datos['especialista_identificacion'] = null;
        if( isset( $datos['receta']['USU_ID_ESPECIALISTA'] ) && !empty( $datos['receta']['USU_ID_ESPECIALISTA'] ) ) {

            $datos['especialista']  = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_ESPECIALISTA'] );
            $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
        }

		$this->load->view('forms/recetario_formula_editar', $datos );
    }

    public function recetario_formula_edita( ) {

        /*
         * 1) Actualiza datos de la receta
         */
        $rec_id                 = $this->input->post('id_receta');
        $paciente_telefono      = $this->input->post('recetario_telefono');
        $paciente_id_municipio  = $this->input->post('recetario_id_municipio');
        $paciente_direccion_residencia = $this->input->post('recetario_direccion_residencia');
        $recetario_nombre_formula = $this->input->post('recetario_nombre_formula');

        $rec_id_nuevo = $this->platc_model->recetario_editar( $rec_id, $paciente_telefono, $paciente_id_municipio, $paciente_direccion_residencia, null, $recetario_nombre_formula );

        // Ciclo que recoge información de los medicamentos
        $medicamentos = array( );
        $listado_medicamentos_post = array( 'nombre_generico', 'concentracion', 'forma_farmaceutica',
                                            'dosis', 'via_administracion', 'cantidad_prescrita_numeros',
                                            'cantidad_prescrita_letras' );

        foreach( $listado_medicamentos_post as $medicamento_post ) {

            foreach( $this->input->post( $medicamento_post ) as $k => $v ) {

                $medicamentos[ $k ][ $medicamento_post ] = $v;
            }
        }

        foreach( $medicamentos as $v ) {

            $this->platc_model->recetario_formula_medicamento_crear($rec_id_nuevo,
                                                                    $v['nombre_generico'],
                                                                    $v['concentracion'],
                                                                    $v['forma_farmaceutica'],
                                                                    $v['dosis'],
                                                                    $v['via_administracion'],
                                                                    $v['cantidad_prescrita_numeros'],
                                                                    $v['cantidad_prescrita_letras'] );
        }

        if( (int)$rec_id_nuevo > 0 ) {
            $resp = array(  'msgt' => 'false',
                            'msg'  => 'false',
                            'action' => 'true',
                            'id_receta'  => (int)$rec_id_nuevo);

            $this->output->set_output( json_encode( $resp ) );
            return;
        }
    }

    public function recetario_formula_ver( $id_receta ) {

        $datos = array();
        $datos['id_receta']     = (int) $id_receta;

        $this->load->view( 'forms/recetario_formula_ver', $datos );
    }

    public function recetario_formula_imprimir( $id_receta ) {

        $datos = array();
        $datos['id_receta']     = (int) $id_receta;
        $receta                 = $this->platc_model->recetario_get( $id_receta );
        $datos['generalista']   = $this->platc_model->usuario_get( (int)$receta['USU_ID_GENERALISTA'] );

        $this->load->view( 'forms/recetario_formula_imprimir', $datos );
        $this->recetario_formula_ver_contenido( $id_receta );
    }

    public function recetario_formula_ver_contenido( $id_receta = '' ) {

        $datos = array();
        $datos['receta']     = $this->platc_model->recetario_get( $id_receta );
        $datos['receta']['fecha_d'] = element( 2, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['receta']['fecha_m'] = element( 1, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['receta']['fecha_a'] = element( 0, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['formula']       = $this->platc_model->recetario_formula_get( $id_receta );
        $datos['formula_medicamentos'] = $this->platc_model->recetario_formula_medicamentos_get( (int)$id_receta );

        $tc = $this->platc_model->tc_get( (int)$datos['receta']['TEL_ID'] );
        $datos['tc']         = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
        $datos['tc']['FORMULAS']= $this->platc_model->recetario_formulas_get( (int)$tc['TEL_ID'] );
        $datos['tc']['RECETAS'] = $this->platc_model->recetarios_get( (int)$tc['TEL_ID'] );

        // Agrega códigos CIE10
        if( !empty( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['TEL_CIE_ID_RESPUESTA'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        $datos['municipio']     = $this->platc_model->municipio_get( (string)$datos['receta']['MUNI_ID'] );
        $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;
        $datos['generalista'] = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_GENERALISTA'] );
        $datos['generalista_identificacion'] = $this->platc_model->identificador_get( $datos['generalista']['IDT_ID'] );

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_ESPECIALISTA'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
		$this->load->view( 'forms/recetario_formula_ver_contenido', $datos );
    }

    public function recetario_elimina( ) {

        $id_receta = $this->input->post( 'id_receta' );
        $estado = $this->platc_model->recetario_eliminar( $id_receta );

        $this->output->set_output( json_encode( array( 'action' => (bool)$estado ) ) );
    }

    public function recetario_listar( $tel_id = '' ) {

        $datos = array( );
        $datos['tc'] = $this->platc_model->tc_get( (int)$tel_id );
        $datos['listado_recetas'] = $this->platc_model->recetarios_get( (int)$tel_id );
		$datos['solicitudesReceta'] = $this->platc_model->recetas_solicitudes_tc_get($tel_id);
        $this->load->view( 'forms/recetario_listado_datagrid', $datos );
    }

    public function recetario_crear( $tel_id = '' ) {

        $datos = array();
        $tc = $this->platc_model->tc_get( (int)$tel_id );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
        $datos['tc']['FORMULAS']= $this->platc_model->recetario_formulas_get( (int)$tc['TEL_ID'] );
        $datos['tc']['RECETAS'] = $this->platc_model->recetarios_get( (int)$tc['TEL_ID'] );

        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        $datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
        $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

		$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
		$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";

		$this->load->view('forms/recetario_nuevo', $datos );

    }

    public function recetario_crea( ) {

        // Info Receta
        $tel_id                 = $this->input->post('tel_id');
        $tipo                   = Platc::$RECETARIO_TIPO['RECETA'];
        $id_medico_generalista  = $this->input->post('id_medico_generalista');
        $id_medico_especialista = $this->input->post('id_medico_especialista');
        $paciente_telefono      = $this->input->post('recetario_telefono');
        $paciente_id_municipio  = $this->input->post('recetario_id_municipio');
        $paciente_direccion_residencia = $this->input->post('recetario_direccion_residencia');
        $recetario_nombre_formula = $this->input->post('recetario_nombre_formula');
		$nombre_recetario       = $this->input->post('nombre_recetario');

        $rec_id = $this->platc_model->recetario_crear(
														$tel_id,
														$tipo,
														$id_medico_generalista,
														$id_medico_especialista,
														$paciente_telefono,
														$paciente_id_municipio,
														$paciente_direccion_residencia,
														$nombre_recetario,
														'',
														$recetario_nombre_formula
													);

        // Ciclo que recoge información de las solicitudes
        $solicitudes = array( );
        $listado_solicitudes_post = array( 'solicitudes' );

        foreach( $listado_solicitudes_post as $solicitudes_post ) {

            foreach( $this->input->post( $solicitudes_post ) as $k => $v ) {

                $solicitudes[ $k ][ $solicitudes_post ] = $v;
            }
        }

        foreach( $solicitudes as $v ) {

            $this->platc_model->recetario_solicitudes_crear($rec_id,
                                                            $v['solicitudes'] );
        }

        if( (int)$rec_id > 0 ) {
            $resp = array(  'msgt' => 'false',
                            'msg'  => 'false',
                            'id_receta' => $rec_id,
                            'action' => 'true' );

            $this->output->set_output( json_encode( $resp ) );
            return;
        }
    }

    public function recetario_editar( $id_receta = '' ) {

        $datos = array();
        $datos['receta'] = $this->platc_model->recetario_get( $id_receta );
        $datos['receta']['fecha_d'] = element( 2, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['receta']['fecha_m'] = element( 1, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['receta']['fecha_a'] = element( 0, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $tc = $this->platc_model->tc_get( (int)$datos['receta']['TEL_ID'] );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
        $datos['tc']['RECETAS'] = $this->platc_model->recetarios_get( (int)$tc['TEL_ID'] );
        $datos['receta_solicitudes'] = $this->platc_model->recetas_solicitudes_tc_get( (int)$tc['TEL_ID'] );
        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        $datos['municipio']     = $this->platc_model->municipio_get( (string)$datos['receta']['MUNI_ID'] );
        $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;
        $datos['generalista'] = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_GENERALISTA'] );
        $datos['generalista_identificacion'] = $this->platc_model->identificador_get( $datos['generalista']['IDT_ID'] );

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_ESPECIALISTA'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

		$this->load->view('forms/recetario_editar', $datos );
    }

    public function recetario_edita( ) {

        /*
         * 1) Actualiza datos de la receta
         */
        $rec_id                 = $this->input->post('id_receta');
        $nombre_recetario       = $this->input->post('nombre_recetario');
        $paciente_telefono      = $this->input->post('recetario_telefono');
        $paciente_id_municipio  = $this->input->post('recetario_id_municipio');
        $paciente_direccion_residencia = $this->input->post('recetario_direccion_residencia');
        //$solicitudes            = $this->input->post('solicitudes');

        $rec_id_nuevo = $this->platc_model->recetario_editar( $rec_id, $paciente_telefono, $paciente_id_municipio, $paciente_direccion_residencia, $nombre_recetario, null );

        // Ciclo que recoge información de las solicitudes
        $solicitud = array( );
        $listado_solicitudes_post = array( 'solicitudes' );

        foreach( $listado_solicitudes_post as $solicitud_post ) {

            foreach( $this->input->post( $solicitud_post ) as $k => $v ) {

                $solicitud[ $k ][ $solicitud_post ] = $v;
            }
        }
        //imprimir($solicitud);

        foreach( $solicitud as $v ) {

            $this->platc_model->recetario_solicitudes_crear($rec_id_nuevo,
                                                            $v['solicitudes'] );
        }

        if( (int)$rec_id_nuevo > 0 ) {
            $resp = array(  'msgt' => 'false',
                            'msg'  => 'false',
                            'action' => 'true',
                            'id_receta'  => (int)$rec_id_nuevo);

            $this->output->set_output( json_encode( $resp ) );
            return;
        }
    }

    public function recetario_ver( $id_receta ) {

        $datos = array();
        $datos['id_receta']     = (int) $id_receta;

        $this->load->view( 'forms/recetario_ver', $datos );
    }

    public function recetario_imprimir( $id_receta ) {

        $datos = array();
        $datos['id_receta']     = (int) $id_receta;
        $receta                 = $this->platc_model->recetario_get( $id_receta );
        $datos['generalista']   = $this->platc_model->usuario_get( (int)$receta['USU_ID_GENERALISTA'] );

        $this->load->view( 'forms/recetario_imprimir', $datos );
        $this->recetario_ver_contenido( $id_receta );
    }

    public function recetario_ver_contenido( $id_receta ) {

        $datos = array();
        $datos['receta'] = $this->platc_model->recetario_get( $id_receta );
        $datos['receta']['solicitudes']  = $this->platc_model->recetas_solicitudes_tc_get( $datos['receta']['TEL_ID'], TRUE );
        $datos['receta']['fecha_d']      = element( 2, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['receta']['fecha_m']      = element( 1, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );
        $datos['receta']['fecha_a']      = element( 0, explode( '-', substr( $datos['receta']['REC_FECHA'], 0, 10 ) ) );

        $tc = $this->platc_model->tc_get( (int)$datos['receta']['TEL_ID'] );
        $datos['tc']         = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );

        // Agrega códigos CIE10
        if( !empty( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['TEL_CIE_ID_RESPUESTA'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        $datos['municipio']     = $this->platc_model->municipio_get( (string)$datos['receta']['MUNI_ID'] );
        $datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;
        $datos['generalista'] = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_GENERALISTA'] );
        $datos['generalista_identificacion'] = $this->platc_model->identificador_get( $datos['generalista']['IDT_ID'] );

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$datos['receta']['USU_ID_ESPECIALISTA'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

		$this->load->view( 'forms/recetario_ver_contenido', $datos );
    }

    /*
     * Facturación
     */

    /**
     * Muestra página de inicio con los filtros para generar excel con la información
     * para realizar facturación.
     */
    public function facturacion( ) {

        $clientes = $this->platc_model->clientes_lista_get( );
        $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', 'Todos', TRUE );

        $especialidades = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
        if( !empty( $especialidades ) ) $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE');

        $this->load->view( 'facturacion/resumen_view', $this->data );
    }

    public function facturacion_rips( ) {

        $id_cliente         = $this->input->post( 'cliente', TRUE );
        $id_establecimiento = $this->input->post( 'establecimiento', TRUE );
        $id_especialidad    = $this->input->post( 'especialidad', TRUE );
        $fecha_ini          = $this->input->post( 'fecha_desde', TRUE );
        $fecha_fin          = $this->input->post( 'fecha_hasta', TRUE );
        $id_site            = $this->session->userdata( 'SIT_ID' );

        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
        $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');

        /*
         * Primera pestaña "usuarios_serv"
         */
        $datos = $this->platc_model->facturacion_rips_usuarios_serv( $id_site, $fecha_ini, $fecha_fin, $id_cliente, $id_establecimiento, $id_especialidad );

//imprimir( $datos );
        $usuarios_serv = new PHPExcel_Worksheet( $objPHPExcel, 'usuarios_serv' );
        $objPHPExcel->addSheet( $usuarios_serv, 0 );
        $objPHPExcel->removeSheetByIndex( $objPHPExcel->getActiveSheetIndex() ); // Elimina hoja vacía creada por omisión
        $objPHPExcel->setActiveSheetIndex();

        $hojaExcel = $objPHPExcel->getSheetByName( 'usuarios_serv' );
        $hojaExcel->SetCellValue('A1', html_entity_decode( 'Tipo de Identificación del Usuario' ) );
        $hojaExcel->SetCellValue('B1', html_entity_decode( 'Número de Identifiación del Usuario en el Sistema' ) );
        $hojaExcel->SetCellValue('C1', html_entity_decode( 'Código Entidad Administradora' ) );
        $hojaExcel->SetCellValue('D1', html_entity_decode( 'Tipo de Usuario' ) );
        $hojaExcel->SetCellValue('E1', html_entity_decode( 'Primer Apellido del usuario' ) );
        $hojaExcel->SetCellValue('F1', html_entity_decode( 'Segundo apellido del usuario' ) );
        $hojaExcel->SetCellValue('G1', html_entity_decode( 'Primer nombre del usuario' ) );
        $hojaExcel->SetCellValue('H1', html_entity_decode( 'Segundo nombre del usuario' ) );
        $hojaExcel->SetCellValue('I1', html_entity_decode( 'Edad' ) );
        $hojaExcel->SetCellValue('J1', html_entity_decode( 'Unidad de medida de la Edad' ) );
        $hojaExcel->SetCellValue('K1', html_entity_decode( 'Sexo' ) );
        $hojaExcel->SetCellValue('L1', html_entity_decode( 'Código del departamento de residencia habitual' ) );
        $hojaExcel->SetCellValue('M1', html_entity_decode( 'Código de municipios de residencia habitual' ) );
        $hojaExcel->SetCellValue('N1', html_entity_decode( 'Zona de residencia habitual' ) );

        $i = 2;
        if ( !empty( $datos ) ) {
            foreach( $datos as $dato ) {
                $hojaExcel->SetCellValue( 'A' . $i, $dato['TIPO_IDENTIFICACION'] );
                $hojaExcel->SetCellValue( 'B' . $i, $dato['PAC_IDT_VALOR'] );
                $hojaExcel->SetCellValue( 'C' . $i, $dato['ENTADM_ID'] );
                $hojaExcel->SetCellValue( 'D' . $i, $dato['ID_PACIENTE_TIPO'] );
                $hojaExcel->SetCellValue( 'E' . $i, $dato['TEL_PAC_PRIMER_APELLIDO'] );
                $hojaExcel->SetCellValue( 'F' . $i, $dato['TEL_PAC_SEGUNDO_APELLIDO'] );
                $hojaExcel->SetCellValue( 'G' . $i, $dato['TEL_PAC_PRIMER_NOMBRE'] );
                $hojaExcel->SetCellValue( 'H' . $i, $dato['TEL_PAC_SEGUNDO_NOMBRE'] );
                $hojaExcel->SetCellValue( 'I' . $i, $dato['TEL_PAC_EDAD'] );
                $hojaExcel->SetCellValue( 'J' . $i, 1 );
                $hojaExcel->SetCellValue( 'K' . $i, $dato['TEL_PAC_SEXO'] );
                $hojaExcel->SetCellValue( 'L' . $i, $dato['DEPTO_CODIGO'] );
                $hojaExcel->SetCellValue( 'M' . $i, $dato['MUNI_ID'] );
                $hojaExcel->SetCellValue( 'N' . $i, $dato['ZON_ID'] );
                $i++;
            }
        }

        /*
         * Segunda pestaña "Servicios facturados"
         */
        $datos = $this->platc_model->facturacion_rips_servicios_facturados( $id_site, $fecha_ini, $fecha_fin, $id_cliente, $id_establecimiento, $id_especialidad );
//imprimir( $datos );
        $servicios_facturados = new PHPExcel_Worksheet( $objPHPExcel, 'Servicios facturados' );
        $objPHPExcel->addSheet( $servicios_facturados, null );

        $hojaExcel = $objPHPExcel->getSheetByName( 'Servicios facturados' );
        $hojaExcel->SetCellValue('A1', html_entity_decode( 'Código del Prestador' ) );
        $hojaExcel->SetCellValue('B1', html_entity_decode( 'Razón Social o Apellidos y nombres del prestador' ) );
        $hojaExcel->SetCellValue('C1', html_entity_decode( 'Tipo de Identificación' ) );
        $hojaExcel->SetCellValue('D1', html_entity_decode( 'Número de Identificación' ) );
        $hojaExcel->SetCellValue('E1', html_entity_decode( 'Número de la factura' ) );
        $hojaExcel->SetCellValue('F1', html_entity_decode( 'Fecha de expedición de la factura' ) );
        $hojaExcel->SetCellValue('G1', html_entity_decode( 'Fecha de Inicio' ) );
        $hojaExcel->SetCellValue('H1', html_entity_decode( 'Fecha final' ) );
        $hojaExcel->SetCellValue('I1', html_entity_decode( 'Código entidad Administradora' ) );
        $hojaExcel->SetCellValue('J1', html_entity_decode( 'Nombre entidad administradora' ) );
        $hojaExcel->SetCellValue('K1', html_entity_decode( 'Número del Contrato' ) );
        $hojaExcel->SetCellValue('L1', html_entity_decode( 'Plan de Beneficios' ) );
        $hojaExcel->SetCellValue('M1', html_entity_decode( 'Número de la póliza' ) );
        $hojaExcel->SetCellValue('N1', html_entity_decode( 'Valor total del pago compartido COPAGO' ) );
        $hojaExcel->SetCellValue('O1', html_entity_decode( 'Valor de la comisión' ) );
        $hojaExcel->SetCellValue('P1', html_entity_decode( 'Valor total de Descuentos' ) );
        $hojaExcel->SetCellValue('Q1', html_entity_decode( 'Valor Neto a Pagar por la entidad Contratante' ) );

        $i = 2;
        if ( !empty( $datos ) ) {
            unset( $dato );
            foreach( $datos as $dato ) {
                $hojaExcel->SetCellValue( 'A' . $i, NULL );
                $hojaExcel->SetCellValue( 'B' . $i, NULL );
                $hojaExcel->SetCellValue( 'C' . $i, $dato['TIPO_IDENTIFICACION'] );
                $hojaExcel->SetCellValue( 'D' . $i, $dato['PAC_IDT_VALOR'] );
                $hojaExcel->SetCellValue( 'E' . $i, NULL );
                $hojaExcel->SetCellValue( 'F' . $i, NULL );
                $hojaExcel->SetCellValue( 'G' . $i, $dato['TEL_FECHA_HORA_ENVIO'] );
                $hojaExcel->SetCellValue( 'H' . $i, $dato['TEL_FECHA_HORA_RESPUESTA'] );
                $hojaExcel->SetCellValue( 'I' . $i, $dato['ENTADM_ID'] );
                $hojaExcel->SetCellValue( 'J' . $i, $dato['ENTADM_NOMBRE'] );
                $hojaExcel->SetCellValue( 'K' . $i, NULL );
                $hojaExcel->SetCellValue( 'L' . $i, NULL );
                $hojaExcel->SetCellValue( 'M' . $i, NULL );
                $hojaExcel->SetCellValue( 'N' . $i, NULL );
                $hojaExcel->SetCellValue( 'O' . $i, NULL );
                $hojaExcel->SetCellValue( 'P' . $i, NULL );
                $hojaExcel->SetCellValue( 'Q' . $i, NULL );
                $i++;
            }
        }

        /*
         * Tercera pestaña "Consulta"
         */
        $datos = $this->platc_model->facturacion_rips_consulta( $id_site, $fecha_ini, $fecha_fin, $id_cliente, $id_establecimiento, $id_especialidad );
        // imprimir($this->db->last_query());
//imprimir( $datos );

        if( !empty( $datos ) ) {
            // Genera listado intermedio con TODOS los identificadores de TODAS
            // las TC del reporte, generando array usando como clave el
            // identificador: así se evita duplicar identificadores
            $cie10_tc           = array( );
            $cie10_tc_respuesta = array( );
            foreach( $datos as $dato ) {

                // CIE10 Generalista
                $id_codigos_cie10  = json_decode( $dato['TD_VALOR'] );
                if( !empty( $id_codigos_cie10 ) )
                    foreach( $id_codigos_cie10 as $id_cie10 )
                        $cie10_tc[ $id_cie10 ] = NULL;

                // CIE10 Respuesta
                $id_codigos_cie10_respuesta  = json_decode( $dato['TEL_CIE_ID_RESPUESTA'] );
                if( !empty( $id_codigos_cie10_respuesta ) )
                    foreach( $id_codigos_cie10_respuesta as $id_cie10 )
                        $cie10_tc_respuesta[ $id_cie10 ] = NULL;
            }

            // Generalista: Genera array con clave CIE_ID y valor id10 ( 1 => 'A00' ) y elimina elemento vacío
            $codigos_cie10_tc = $this->platc_model->cie10_get( array_keys( $cie10_tc ) );
            $codigos_cie10_tc = $this->util->select_form_prepare( $codigos_cie10_tc, 'CIE_ID', 'id10' );
            unset( $codigos_cie10_tc[''] );

            // Respuesta: Genera array con clave CIE_ID y valor id10 ( 1 => 'A00' ) y elimina elemento vacío
            $codigos_cie10_tc_respuesta = $this->platc_model->cie10_get( array_keys( $cie10_tc_respuesta ) );
            $codigos_cie10_tc_respuesta = $this->util->select_form_prepare( $codigos_cie10_tc_respuesta, 'CIE_ID', 'id10' );
            unset( $codigos_cie10_tc_respuesta[''] );

            // Reescribe campos de las TC's del reporte
            foreach( $datos as &$dato ) {

                // Generalista
                $id_codigos_cie10  = json_decode( $dato['TD_VALOR'] );

                $t = array();
                if( !empty( $id_codigos_cie10 ) )
                    foreach( $id_codigos_cie10 as $id_cie10 ) {
                        $dato['TD_VALOR'] = $codigos_cie10_tc[ $id_cie10 ];
                        break;
                    }

                // Respuesta
                $id_codigos_cie10_respuesta  = json_decode( $dato['TEL_CIE_ID_RESPUESTA'] );

                $t = array();
                if( !empty( $id_codigos_cie10_respuesta ) )
                    foreach( $id_codigos_cie10_respuesta as $id_cie10 ) {
                        $dato['TEL_CIE_ID_RESPUESTA'] = $codigos_cie10_tc_respuesta[ $id_cie10 ];
                        break;
                    }
            }
        }

        $consulta = new PHPExcel_Worksheet( $objPHPExcel, 'Consulta' );
        $objPHPExcel->addSheet( $consulta, null );

        $hojaExcel = $objPHPExcel->getSheetByName( 'Consulta' );
        $hojaExcel->SetCellValue('A1', html_entity_decode( 'Número de la factura' ) );
        $hojaExcel->SetCellValue('B1', html_entity_decode( 'Código del prestador de servicios de salud' ) );
        $hojaExcel->SetCellValue('C1', html_entity_decode( 'Tipo de identificación del usuario' ) );
        $hojaExcel->SetCellValue('D1', html_entity_decode( 'Número de identificación del usuario en el sistema' ) );
        $hojaExcel->SetCellValue('E1', html_entity_decode( 'Fecha de la consulta' ) );
        $hojaExcel->SetCellValue('F1', html_entity_decode( 'Número de Autorización' ) );
        $hojaExcel->SetCellValue('G1', html_entity_decode( 'Código de consulta' ) );
        $hojaExcel->SetCellValue('H1', html_entity_decode( 'Finalidad de la consulta' ) );
        $hojaExcel->SetCellValue('I1', html_entity_decode( 'Causa externa' ) );
        $hojaExcel->SetCellValue('J1', html_entity_decode( 'Código del Diagnóstico principal' ) );
        $hojaExcel->SetCellValue('K1', html_entity_decode( 'Código del diagnóstico relacionado N° 1' ) );
        $hojaExcel->SetCellValue('L1', html_entity_decode( 'Código del diagnóstico relacionado N° 2' ) );
        $hojaExcel->SetCellValue('M1', html_entity_decode( 'Código del diagnóstico relacionado N° 3' ) );
        $hojaExcel->SetCellValue('N1', html_entity_decode( 'Tipo de diagnóstico principal' ) );
        $hojaExcel->SetCellValue('O1', html_entity_decode( 'Valor de la consulta' ) );
        $hojaExcel->SetCellValue('P1', html_entity_decode( 'Valor de la cuota moderadora' ) );
        $hojaExcel->SetCellValue('Q1', html_entity_decode( 'Valor Neto a pagar' ) );

        $i = 2;
        if ( !empty( $datos ) ) {
            unset( $dato );
            foreach( $datos as $dato ) {
                $hojaExcel->SetCellValue( 'A' . $i, NULL );
                $hojaExcel->SetCellValue( 'B' . $i, NULL );
                $hojaExcel->SetCellValue( 'C' . $i, $dato['TIPO_IDENTIFICACION'] );
                $hojaExcel->SetCellValue( 'D' . $i, $dato['PAC_IDT_VALOR'] );
                $hojaExcel->SetCellValue( 'E' . $i, $dato['TEL_FECHA_HORA_ENVIO'] );
                $hojaExcel->SetCellValue( 'F' . $i, $dato['TEL_CODIGO_AUTORIZACION'] );
                $hojaExcel->SetCellValue( 'G' . $i, 890402 );
                $hojaExcel->SetCellValue( 'H' . $i, 10 );
                $hojaExcel->SetCellValue( 'I' . $i, 13 );
                $hojaExcel->SetCellValue( 'J' . $i, $dato['TD_VALOR'] );
                $hojaExcel->SetCellValue( 'K' . $i, $dato['TEL_CIE_ID_RESPUESTA'] );
                $hojaExcel->SetCellValue( 'L' . $i, NULL );
                $hojaExcel->SetCellValue( 'M' . $i, NULL );
                $hojaExcel->SetCellValue( 'N' . $i, 1 );
                $hojaExcel->SetCellValue( 'O' . $i, NULL );
                $hojaExcel->SetCellValue( 'P' . $i, NULL );
                $hojaExcel->SetCellValue( 'Q' . $i, NULL );
                $i++;
            }
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Facturacion_RIPS_' . date('YmdHis') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }
	
	public function facturacion_arch_base( ) {
		
		$data['cliente']        = $this->input->post( 'cliente' );
		$data['establ']         = $this->input->post( 'establecimiento' );
		$data['especialidad']   = $this->input->post( 'especialidad' );
		$data['estado']         = 7;
		$data['fecha_env_desde'] = ($this->input->post( 'fecha_desde' )) ? substr($this->input->post( 'fecha_desde' ),6,4).'-'.substr($this->input->post( 'fecha_desde' ),3,2).'-'.substr($this->input->post( 'fecha_desde' ),0,2) : "";
		$data['fecha_env_hasta'] = ($this->input->post( 'fecha_hasta' )) ? substr($this->input->post( 'fecha_hasta' ),6,4).'-'.substr($this->input->post( 'fecha_hasta' ),3,2).'-'.substr($this->input->post( 'fecha_hasta' ),0,2) : "";

		$listado_tc_temp =  $this->platc_model->buscar_tc_b_imp($data);//ffarias SI1434


		$listado_tc=   $listado_tc_temp->result_array();
		// Realiza agrupamiento por cliente de cada item del listado
		if ( !empty( $listado_tc ) ) {
			$listado_x_cliente = array( );
			foreach( $listado_tc as $tc )
				$listado_x_cliente[ $tc['CLI_NOMBRE'] ][] = $tc;
		}
		
		ini_set('zend.ze1_compatibility_mode', '0');
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
		$objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
		$objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
		$objPHPExcel->setActiveSheetIndex(0);

		$i = 1;

		// Fila de cabezera de tabla
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( 'ID TC' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( 'Tipo de Identificación del Usuario' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( 'Número de Identifiación del Usuario en el Sistema' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( 'Código Entidad Administradora' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( 'Cliente' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( 'Establecimiento' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( 'Tipo de Usuario' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( 'Primer Apellido del usuario' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( 'Segundo apellido del usuario' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( 'Primer nombre del usuario' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, html_entity_decode( 'Segundo nombre del usuario' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( "Edad" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('M'.$i, html_entity_decode( "Unidad de medida de la Edad" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('N'.$i, html_entity_decode( "Sexo" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('O'.$i, html_entity_decode( "Departamento" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('P'.$i, html_entity_decode( "Municipio" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('Q'.$i, html_entity_decode( 'Fecha Hora enviada') );
		$objPHPExcel->getActiveSheet()->SetCellValue('R'.$i, html_entity_decode( 'Fecha Hora aceptada' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('S'.$i, html_entity_decode( 'Fecha Hora contestada' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('T'.$i, html_entity_decode( "Número de Autorización" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('U'.$i, html_entity_decode( 'Especialidad' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('V'.$i, html_entity_decode( "Diagnósticos asociados a la respuesta separados por ," ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('W'.$i, html_entity_decode( "Médico generalista que envia" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('X'.$i, html_entity_decode( "Usuario de aceptacion" ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('Y'.$i, html_entity_decode( 'Especialista que contesta' ) );
		$objPHPExcel->getActiveSheet()->SetCellValue('Z'.$i, html_entity_decode( "Modalidad" ) );
		
		//$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( "Fecha Solic. Examen" ) );
		//$objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( "Estado" ) );1
		//$objPHPExcel->getActiveSheet()->SetCellValue('O'.$i, html_entity_decode( "CIE10" ) );
		
		$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':Z'.$i)->getFont()->setBold(true);
		$i++; // Salto de línea
		
		if( !empty( $listado_x_cliente ) ) {

			// Completa filas por teleconsulta
			foreach( $listado_x_cliente as $cliente => $listado_tc ) {
				
				foreach( $listado_tc as $tc ) {
					//CIE10
					$array_cie10 = "";
					if(isset($tc['TEL_CIE_ID_RESPUESTA']) && $tc['TEL_CIE_ID_RESPUESTA']){
						$cie10_respuesta = json_decode($tc['TEL_CIE_ID_RESPUESTA']);
						foreach($cie10_respuesta as $cie10){
                            $result = $this->platc_model->cie10_get($cie10);
                            if($result!=null)
                            {
                               foreach($result as $row){
								$array_cie10['cie10'][] = $row['id10'];
								$array_cie10['dec10'][] = $row['dec10'];
							   } 
                            }else
                            {
                                $array_cie10['cie10'][] = 0;
								$array_cie10['dec10'][] = 0;

                            }
							
						}
					}
					//FIN
					
					$objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $tc['TEL_ID']);
					$objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $tc['TIPO_IDENTIFICACION']);
					$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $tc['PAC_IDT_VALOR'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $tc['ENTADM_NOMBRE']);
					$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $tc['CLI_NOMBRE'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $tc['ETB_NOMBRE']);
					$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $tc['AFI_NOMBRE'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $tc['TEL_PAC_PRIMER_APELLIDO'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
					$objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $tc['TEL_PAC_SEGUNDO_APELLIDO'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(10);
					$objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $tc['TEL_PAC_PRIMER_NOMBRE'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);

					$objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $tc['TEL_PAC_SEGUNDO_NOMBRE'] );
					$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
					
					$objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, isset( $tc['TEL_PAC_EDAD'] ) && !empty( $tc['TEL_PAC_EDAD'] ) ? $tc['TEL_PAC_EDAD'] : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, html_entity_decode( "Años" ) );
					$objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) ? $tc['TEL_PAC_SEXO'] : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, $tc['DPTO_NOMBRE']);
					$objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, $tc['MUN_NOMBRE']);
					$objPHPExcel->getActiveSheet()->SetCellValue('Q' . $i, isset( $tc['FECHA_GENERADO'] ) && !empty( $tc['FECHA_GENERADO'] ) ? date('d/m/Y H:i:s',strtotime($tc['FECHA_GENERADO'])) : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('R' . $i, isset( $tc['FECHA_REVISOR'] ) && !empty( $tc['FECHA_REVISOR'] ) ? date('d/m/Y H:i:s',strtotime($tc['FECHA_REVISOR'])) : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('S' . $i, isset( $tc['TEL_FECHA_HORA_RESPUESTA'] ) && !empty( $tc['TEL_FECHA_HORA_RESPUESTA'] ) ? date('d/m/Y H:i:s',strtotime($tc['TEL_FECHA_HORA_RESPUESTA'])) : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('T' . $i, '');
					$objPHPExcel->getActiveSheet()->SetCellValue('U' . $i, $tc['ESP_NOMBRE']);
					$objPHPExcel->getActiveSheet()->SetCellValue('V' . $i, (($array_cie10 && array_key_exists('cie10',$array_cie10) && is_array($array_cie10['cie10'])) ? implode(", ",$array_cie10['cie10']) : "") );
					$objPHPExcel->getActiveSheet()->SetCellValue('W' . $i, isset( $tc['usu_medico'] ) && !empty( $tc['usu_medico'] ) ? $tc['usu_medico'] : '');
					$objPHPExcel->getActiveSheet()->SetCellValue('X' . $i, isset( $tc['NOMBRE_REVISOR'] ) && !empty( $tc['NOMBRE_REVISOR'] ) ? $tc['NOMBRE_REVISOR'] : '');
					$objPHPExcel->getActiveSheet()->SetCellValue('Y' . $i, isset( $tc['usu_especialista'] ) && !empty( $tc['usu_especialista'] ) ? $tc['usu_especialista'] : '' );
					$objPHPExcel->getActiveSheet()->SetCellValue('Z' . $i, $tc['TEL_MODALIDAD_RESPUESTA']);

					//$objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, (($array_cie10 && array_key_exists('cie10',$array_cie10) && is_array($array_cie10['cie10'])) ? implode(", ",$array_cie10['cie10']) : "") );
					//$objPHPExcel->getActiveSheet()->SetCellValue('V' . $i, (($array_cie10 && array_key_exists('dec10',$array_cie10) && is_array($array_cie10['dec10'])) ? implode(", ",$array_cie10['dec10']) : "") );

					$i++; // Salto de línea
				}

				//$i++; // Salto de línea
			}

			$objPHPExcel->getActiveSheet()->setTitle('Simple');
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
			$excel_name = 'reporte_temporal.xls';
			$file_path = $this->path_file['excel'] . $excel_name;
			$objWriter->save($this->path_file['excel'] . $excel_name);
			header('Content-type: application/vnd.ms-excel');
			header('Content-Disposition: attachment; filename=Facturacion_Arch_Base_' . date('YmdHis') . '.xls');
			header('Cache-Control: public');
			header('Content-Description: File Transfer');
			header('Content-Transfer-Encoding: binary');
			header('Content-Length: ' . filesize($file_path));
			header('Pragma: no-cache');
			header('Expires: 0');
			readfile($file_path);
			unlink($file_path);
		}
	}

    /*
     * Bolsas
     */

    /**
     *
     */
    public function bolsas_resumen( ) {

        //load data
        $data['bolsas'] = $this->platc_model->bolsas_get( $this->session->userdata('SIT_ID') );

        $this->load->view( 'bolsas/resumen_view', $data );
    }

    /**
     *
     */
    public function bolsas_crear( ) {

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes'] = !empty( $clientes ) ? $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) ) : null;

        $roles = array( self::$ROL['SUPERVISOR'], self::$ROL['ESPECIALISTA'], self::$ROL['MEDICO_REVISOR'] );
        $usuarios = $this->platc_model->usuarios_por_rol( $roles, $this->session->userdata('SIT_ID'),TRUE );
        $this->data['usuarios'] = !empty( $usuarios ) ? $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_EMAIL_NOMBRE' ) ) : null;

        $this->index( 'bolsas/agregar_view' );
    }

    /**
     *
     */
    public function bolsas_crea( ) {

        $this->form_validation->set_rules( 'nombre',  '', 'required');
        $this->form_validation->set_rules( 'fecha_desde',  '', 'required');

        if( $this->form_validation->run( ) != FALSE ) {

            $id_site    = $this->session->userdata( 'SIT_ID' );
            $nombre     = $this->input->post( 'nombre' );
            $descripcion= $this->input->post( 'descripcion' );
            $fecha_ini  = $this->util->fecha_orden( $this->input->post( 'fecha_desde' ) );
            $fecha_fin  = $this->input->post( 'fecha_hasta' );
            $fecha_fin  = !empty( $fecha_fin ) ? $this->util->fecha_orden( $fecha_fin ) : NULL ;
            $clientes   = $this->input->post( 'clientes' );
            $usuarios   = $this->input->post( 'usuarios' );

            $id_bolsa = $this->platc_model->bolsa_agregar( $id_site, $nombre, $descripcion, $fecha_ini, $fecha_fin );
            $this->platc_model->bolsa_cliente_agregar( $id_bolsa, $clientes );
            $this->platc_model->bolsa_usuario_agregar( $id_bolsa, $usuarios );

            if( !empty( $id_bolsa ) ){
                $resp['method'] = base_url() . 'platc/bolsas_resumen/';
                $resp['div'] = 'deploy';
                $resp['action'] = 'true';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('bolsas_agregado_ok');
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('bolsas_agregado_error');
            }

        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     *
     */
    public function bolsas_editar( $id_bolsa ) {

        /*
         * Datos de la bolsa
         */
        $this->data['bolsa']          = $this->platc_model->bolsa_get( (int)$id_bolsa );
        $bolsa_clientes               = $this->platc_model->bolsa_clientes_get( (int)$id_bolsa );
        unset( $bolsa_clientes[''] );
        $this->data['bolsa_clientes'] = !empty( $bolsa_clientes ) ? $this->util->prepare_data( $this->util->select_form_prepare( $bolsa_clientes, 'CLI_ID', 'CLI_NOMBRE' ) ) : null;
        $bolsa_usuarios               = $this->platc_model->bolsa_usuarios_get( (int)$id_bolsa );
        unset( $bolsa_usuarios[''] );
        $this->data['bolsa_usuarios'] = !empty( $bolsa_usuarios ) ? $this->util->prepare_data( $this->util->select_form_prepare( $bolsa_usuarios, 'USU_ID', 'USU_NOMBRE' ) ) : null;

        /*
         * Datos del formulario
         */
        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['listado_clientes'] = !empty( $clientes ) ? $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) ) : null;

        $roles = array( self::$ROL['SUPERVISOR'], self::$ROL['ESPECIALISTA'], self::$ROL['MEDICO_REVISOR'] );
        $usuarios = $this->platc_model->usuarios_por_rol( $roles, $this->session->userdata('SIT_ID'),TRUE );
        $this->data['listado_usuarios'] = !empty( $usuarios ) ? $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_EMAIL_NOMBRE' ) ) : null;

        $this->index( 'bolsas/editar_view' );
    }

    /**
     *
     */
    public function bolsas_edita( ) {

        $this->form_validation->set_rules( 'id_bolsa',  '', 'required');
        $this->form_validation->set_rules( 'nombre',  '', 'required');
        $this->form_validation->set_rules( 'fecha_desde',  '', 'required');

        if( $this->form_validation->run( ) != FALSE ) {

            $id_bolsa   = $this->input->post( 'id_bolsa' );
            $nombre     = $this->input->post( 'nombre' );
            $descripcion= $this->input->post( 'descripcion' );
            $fecha_ini  = $this->util->fecha_orden( $this->input->post( 'fecha_desde' ) );
            $fecha_fin  = $this->input->post( 'fecha_hasta' );
            $fecha_fin  = !empty( $fecha_fin ) ? $this->util->fecha_orden( $fecha_fin ) : NULL ;
            $clientes   = $this->input->post( 'clientes' );
            $usuarios   = $this->input->post( 'usuarios' );

            $this->platc_model->bolsa_editar( $id_bolsa, $nombre, $descripcion, $fecha_ini, $fecha_fin );
            $this->platc_model->bolsa_cliente_editar( $id_bolsa, $clientes );
            $this->platc_model->bolsa_usuario_editar( $id_bolsa, $usuarios );

            if( !empty( $id_bolsa ) ){
                $resp['method'] = base_url() . 'platc/bolsas_resumen/';
                $resp['div'] = 'deploy';
                $resp['action'] = 'true';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('bolsas_editado_ok');
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('bolsas_editado_error');
            }

        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     *
     */
    public function bolsas_eliminar( $id_bolsa ) {

        $estado = $this->platc_model->bolsa_eliminar( (int)$id_bolsa );

        if( $estado ) {
            $resp['method'] = base_url() . 'platc/bolsas_resumen/';
            $resp['div'] = 'deploy';
            $resp['action'] = 'true';
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('bolsas_eliminado_ok');
        } else {
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('bolsas_eliminado_error');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     *
     */
    public function bolsas_activar( $id_bolsa ) {

        $estado = $this->platc_model->bolsa_activar( (int)$id_bolsa );

        if( $estado )
            $this->output->set_output( json_encode( 'true' ) );
        else
            $this->output->set_output( json_encode( 'false' ) );

        $this->output->set_output( json_encode( $resp ) );
    }

    /**
     *
     */
    public function bolsas_desactivar( $id_bolsa ) {

        $estado = $this->platc_model->bolsa_desactivar( (int)$id_bolsa );

        if( $estado )
            $this->output->set_output( json_encode( 'true' ) );
        else
            $this->output->set_output( json_encode( 'false' ) );
    }

    /**
     * Retorna listado de teleconsultas asociadas a una bolsa
     *
     * @param $id_bolsa Identificador de la bolsa
     * @return string String en json adaptado para grilla jqGrid con listado
     * teleconsultas asociadas a la bolsa especificado por parámetro
     */
    public function bolsas_teleconsultas_asociadas( $id_bolsa ) {

        $listado_tc = $this->platc_model->bolsa_teleconsultas_get( (int)$id_bolsa );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output(  json_encode( $json_grid ) );
    }

    /**
     * Retorna listado de teleconsultas en estado Enviada/Nuevas para que puedan
     * ser asociadas a la(s) bolsa(s).
     *
     * @param string String en formato json para grilla jqGrid con el listado
     * de teleconsultas en estado Enviadas/Nuevas
     */
    public function bolsas_teleconsultas_disponibles( ) {

        $listado_tc = $this->platc_model->bolsa_teleconsultas_sin_bolsa(  );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }

    /**
     * Retorna listado de teleconsultas en estado Enviada/Nuevas para que puedan
     * ser asociadas a la(s) bolsa(s).
     *
     * @param string String en formato json para grilla jqGrid con el listado
     * de teleconsultas en estado Enviadas/Nuevas
     */
    public function bolsas_teleconsultas_disponibles_tc_id( ) {

        $id_teleconsulta = (int)$this->input->post( 'id_teleconsulta' );

        $listado_tc = $this->platc_model->bolsa_teleconsultas_sin_bolsa_tcid( (int)$id_teleconsulta );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }

    /**
     * Retorna listado de teleconsultas en estado Enviada/Nuevas para que puedan
     * ser asociadas a la(s) bolsa(s).
     *
     * @param string String en formato json para grilla jqGrid con el listado
     * de teleconsultas en estado Enviadas/Nuevas
     */
    public function bolsas_teleconsultas_disponibles_tc_na( ) {

        $nombre     = (string)$this->input->post( 'nombre' );
        $apellido   = (string)$this->input->post( 'apellido' );

        $listado_tc = $this->platc_model->bolsa_teleconsultas_sin_bolsa_na( $nombre, $apellido );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }

    /**
     * Retorna listado de teleconsultas en estado Enviada/Nuevas para que puedan
     * ser asociadas a la(s) bolsa(s).
     *
     * @param string String en formato json para grilla jqGrid con el listado
     * de teleconsultas en estado Enviadas/Nuevas
     */
    public function bolsas_teleconsultas_disponibles_id( ) {

        $id_paciente = (string)$this->input->post( 'id_paciente' );

        $listado_tc = $this->platc_model->bolsa_teleconsultas_sin_bolsa_id( $id_paciente );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }

    /**
     * Retorna listado de teleconsultas en estado Enviada/Nuevas para que puedan
     * ser asociadas a la(s) bolsa(s).
     *
     * @param string String en formato json para grilla jqGrid con el listado
     * de teleconsultas en estado Enviadas/Nuevas
     */
    public function bolsas_teleconsultas_disponibles_fecha( ) {

        $fecha_desde = (string)$this->input->post( 'fecha_desde' );
        $fecha_hasta = (string)$this->input->post( 'fecha_hasta' );

        $listado_tc = $this->platc_model->bolsa_teleconsultas_sin_bolsa_fecha( $fecha_desde, $fecha_hasta );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }

    /**
     * Retorna listado de bolsas disponibles en el sistema
     */
    public function bolsas_bolsas_disponibles( ) {

        $listado_bolsas = $this->platc_model->bolsas_get( $this->session->userdata('SIT_ID') );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_bolsas );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_bolsas );
        $json_grid["rows"]      =  $listado_bolsas;
        $this->output->set_output(  json_encode( $json_grid ) );
    }


    public function bolsas_teleconsultas_asociar( ) {

        $this->form_validation->set_rules( 'bolsas',  '', 'required');
        $this->form_validation->set_rules( 'teleconsultas',  '', 'required');

        if( $this->form_validation->run( ) != FALSE ) {

            $bolsas         = explode( ',', $this->input->post( 'bolsas' ) );
            $teleconsultas  = explode( ',', $this->input->post( 'teleconsultas' ) );

            /*
             * Valida que las tc se asignen a bolsas válidas en fechas
             */
            $bolsa_temp = null;
            foreach( $bolsas as $b ) {
                $bolsa_temp = $this->platc_model->bolsa_get( $b );
//                $fecha_ini = date( $bolsa_temp['BOL_FECHA_INI'] );
                $fecha_fin = date_create( $bolsa_temp['BOL_FECHA_FIN'] );
                $fecha_hoy = date_create( );
                if( $fecha_hoy > $fecha_fin ) {

                    $resp['action'] = 'false';
                    $resp['msgt'] = 'ERROR';
                    $resp['msg'] = sprintf( $this->lang->line('bolsas_asociar_fecha_pasada_error'), $bolsa_temp['BOL_NOMBRE'] );
                    $this->output->set_output( json_encode( $resp ) );
                    return;
                }
            }


            /*
             * Mezcla teleconsultas anteriores con el que viene desde post
             * Calcula los que ya están y los elimina para así solo ingresar
             * los que faltan.
             */
            foreach( $bolsas as $id_bolsa ) {

                $tc_anteriores = $this->platc_model->bolsa_teleconsultas_get( (int)$id_bolsa );

                $tcs = array();
                if( !empty( $tc_anteriores ) )
                    foreach( $tc_anteriores as $t )
                        $tcs[ ] = $t['TEL_ID'];

                $t_final = array_diff( $teleconsultas, $tcs );

                if( !empty( $t_final ) )
                    $estado = $this->platc_model->bolsa_teleconsulta_agregar( $id_bolsa, $t_final );
				
				//NF434
				//if( !empty( $estado ) )
				//	$this->enviar_notificacion_asignacion_bolsa($id_bolsa, $teleconsultas);
				//FIN NF434
            }

            if( !empty( $estado ) ){
                $resp['method'] = base_url() . 'platc/bolsas_resumen/';
                $resp['div'] = 'deploy';
                $resp['action'] = 'true';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('bolsas_asociar_ok');
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('bolsas_asociar_error');
            }

        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('bolsas_asociar_campos_vacios');
        }

        $this->output->set_output( json_encode( $resp ) );
    }

    public function bolsas_teleconsultas_desasociar( ) {

        $id_bolsa        = $this->input->post('id_bolsa');
        $id_teleconsulta = $this->input->post('id_teleconsulta');

        $estado = $this->platc_model->bolsas_teleconsultas_desasociar( (int)$id_bolsa, (int)$id_teleconsulta );
        if( $estado )
            $this->output->set_output( 'true' );
        else
            $this->output->set_output( 'false' );
    }

    /*
     * Tarjetas de coordenadas para pacientes
     */
    public function tarjetas_coordenadas(  ) {

        $this->data['listado_pacientes'] = $this->platc_model->paciente_listar( $this->session->userdata('SIT_ID'), (int)$this->session->userdata('ROL_ID') );
        $this->index( 'acceso_pacientes/tarjetas_coordenadas_view' );
    }

    public function tarjetas_coordenadas_listado_pacientes( ) {

        $this->data['listado_pacientes'] = $this->platc_model->paciente_listar( $this->session->userdata('SIT_ID'), (int)$this->session->userdata('ROL_ID') );
        $this->index( 'acceso_pacientes/listado_pacientes_datagrid_view' );
    }

    public function tarjetas_coordenadas_listado_pacientes_busca_id( ) {

        $rut_paciente = $this->input->post('id');
        $this->data['listado_pacientes'] = $this->platc_model->pacientes_buscar_id( $rut_paciente, $this->session->userdata('SIT_ID') );
        $this->index( 'acceso_pacientes/listado_pacientes_datagrid_view' );
    }

    public function tarjetas_coordenadas_listado_pacientes_busca_na( ) {

        $nombre     = $this->input->post('nombre');
        $apellido   = $this->input->post('apellido');
        $this->data['listado_pacientes'] = $this->platc_model->pacientes_buscar_na( $nombre, $apellido, $this->session->userdata('SIT_ID') );
        $this->index( 'acceso_pacientes/listado_pacientes_datagrid_view' );
    }

    public function tarjetas_coordenadas_asociar_paciente( $id_paciente ) {

        $this->data['paciente']         = $this->platc_model->paciente_get( (int)$id_paciente );
        $this->data['afiliacion']       = $this->platc_model->afiliacion_get( (int)$this->data['paciente']['AFI_ID'] );
        $this->data['identificadores']  = $this->platc_model->paciente_identificadores_get( (int)$this->data['paciente']['PAC_ID'] );

        $this->load->model('admin_seguridad_model');
        $this->data['coordenadas']      = $this->admin_seguridad_model->getCoordenadasUsuario( $id_paciente );
        $this->data['tarjeta']          = $this->admin_seguridad_model->getTarjetaDesdePaciente( $id_paciente );

        $this->index( 'acceso_pacientes/asociar_tarjeta_paciente_view' );
    }

    public function tarjetas_coordenadas_generar_coordenadas( ) {

        $id_paciente    = $this->input->post('id_paciente');

        $this->load->model('admin_seguridad_model');
        $tarjetaId      = $this->admin_seguridad_model->grabarTarjeta( $id_paciente, 1 );
        $coordenadas    = $this->platc_model->genera_coordendas( );
        $this->admin_seguridad_model->grabarCodigos( $tarjetaId, $coordenadas );

        $this->load->view( 'acceso_pacientes/tarjeta_coordenada_paciente_view', array( 'id_tarjeta' => $tarjetaId, 'coordenadas' => $coordenadas ) );
    }

    public function tarjetas_coordenadas_imprimir( $tarjeta_id ) {

        $this->load->model('admin_seguridad_model');
        $usu_nombre   = $this->admin_seguridad_model->getTarjetaUsuario($tarjeta_id);
        $coordenadas  = $this->admin_seguridad_model->getCoordenadas($tarjeta_id);

        header("Content-type: image/png");
        $font   = FCPATH."images/tahoma.ttf";
        $im     = imagecreatefrompng( FCPATH."images/tarjeta.png");

        $negro = imagecolorallocate($im, 0, 0, 0);
        $blanco= imagecolorallocate($im, 255, 255, 255);
        imagettftext($im, 20, 0, 155, 595, $negro, $font, $tarjeta_id);
        imagettftext($im, 20, 0, 20, 630, $negro, $font, strtoupper($usu_nombre));

        for($i=0;$i<5 ; $i++){
            for($j=0;$j<10;$j++){
                imagettftext($im, 20, 0,80+ ( 70 * ($j+1)), 150+(70*$i), $blanco, $font, $coordenadas[$i][$j]);
            }
        }

        imagepng($im);
        imagedestroy($im);

    }

    public function co_pediatria_tabla_de( $tipo, $id_paciente ) {

        if( !in_array( $tipo, Platc::$CO_PEDIATRIA_DE ) || empty( $id_paciente ) )
            return array();

        $paciente   = $this->platc_model->paciente_get( (int)$id_paciente );
        $sexo       = $paciente['PAC_SEXO'];
        $id_site    = $this->session->userdata('SIT_ID');

        /*
         * Desviaciones estandar: Datos tabulados
         */
        $datos = $de = $de_3n = $de_2n = $de_1n = $de_cero = $de_1p = $de_2p = $de_3p = $de_paciente = array();

        switch( $tipo ) {

            case Platc::$CO_PEDIATRIA_DE['TALLA_EDAD'] : {

                // Desviaciones estandard: Talla para la edad
                $de = $this->platc_model->co_pediatria_tabla_crecimiento( $id_site, Platc::$CO_PEDIATRIA_DE['TALLA_EDAD'], $sexo );
                if( !empty( $de ) )
                    foreach( $de as $dato ) {

                        $de_3n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3N'] );
                        $de_2n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2N'] );
                        $de_1n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1N'] );
                        $de_cero[] = array( (int)$dato['PED_MESES'], (float)$dato['PED_CERO'] );
                        $de_1p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1P'] );
                        $de_2p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2P'] );
                        $de_3p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3P'] );
                    }

                // Desviaciones estandard: Datos del paciente
                $datos_paciente = $this->platc_model->co_pediatria_tabla_crecimiento_paciente( $id_paciente, $id_site, Platc::$CO_PEDIATRIA_DE['TALLA_EDAD'] );

                if( !empty( $datos_paciente ) )
                    foreach( $datos_paciente as $dato )
                        $de_paciente[] = array( (int)$dato['meses'], (float)$dato['talla'] );
            } ; break;

            case Platc::$CO_PEDIATRIA_DE['PESO_EDAD'] : {

                // Desviaciones estandard: Peso para la edad
                $de = $this->platc_model->co_pediatria_tabla_crecimiento( $id_site, Platc::$CO_PEDIATRIA_DE['PESO_EDAD'], $sexo );
                if( !empty( $de ) )
                    foreach( $de as $dato ) {

                        $de_3n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3N'] );
                        $de_2n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2N'] );
                        $de_1n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1N'] );
                        $de_cero[] = array( (int)$dato['PED_MESES'], (float)$dato['PED_CERO'] );
                        $de_1p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1P'] );
                        $de_2p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2P'] );
                        $de_3p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3P'] );
                    }

                // Desviaciones estandard: Datos del paciente
                $datos_paciente = $this->platc_model->co_pediatria_tabla_crecimiento_paciente( $id_paciente, $id_site, Platc::$CO_PEDIATRIA_DE['PESO_EDAD'] );

                if( !empty( $datos_paciente ) )
                    foreach( $datos_paciente as $dato )
                        $de_paciente[] = array( (int)$dato['meses'], (float)$dato['peso'] );
            } ; break;

            case Platc::$CO_PEDIATRIA_DE['IMC'] : {

                // Desviaciones estandard: IMC
                $de = $this->platc_model->co_pediatria_tabla_crecimiento( $id_site, Platc::$CO_PEDIATRIA_DE['IMC'], $sexo );
                if( !empty( $de ) )
                    foreach( $de as $dato ) {

                        $de_3n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3N'] );
                        $de_2n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2N'] );
                        $de_1n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1N'] );
                        $de_cero[] = array( (int)$dato['PED_MESES'], (float)$dato['PED_CERO'] );
                        $de_1p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1P'] );
                        $de_2p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2P'] );
                        $de_3p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3P'] );
                    }

                // Desviaciones estandard: Datos del paciente
                $datos_paciente = $this->platc_model->co_pediatria_tabla_crecimiento_paciente( $id_paciente, $id_site, Platc::$CO_PEDIATRIA_DE['IMC'] );

                if( !empty( $datos_paciente ) )
                    foreach( $datos_paciente as $dato )
                        $de_paciente[] = array( (int)$dato['meses'], (float)$dato['imc'] );
            } ; break;

            case Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO'] : {

                // Desviaciones estandard: Perímetro cefálico
                $de = $this->platc_model->co_pediatria_tabla_crecimiento( $id_site, Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO'], $sexo );
                if( !empty( $de ) )
                    foreach( $de as $dato ) {

                        $de_3n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3N'] );
                        $de_2n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2N'] );
                        $de_1n[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1N'] );
                        $de_cero[] = array( (int)$dato['PED_MESES'], (float)$dato['PED_CERO'] );
                        $de_1p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_1P'] );
                        $de_2p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_2P'] );
                        $de_3p[]   = array( (int)$dato['PED_MESES'], (float)$dato['PED_3P'] );
                    }

                // Desviaciones estandard: Datos del paciente
                $datos_paciente = $this->platc_model->co_pediatria_tabla_crecimiento_paciente( $id_paciente, $id_site, Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO'] );

                if( !empty( $datos_paciente ) )
                    foreach( $datos_paciente as $dato )
                        $de_paciente[] = array( (int)$dato['meses'], (float)$dato['p_c'] );
            } ; break;

            case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2'] : {

                // Desviaciones estandard: Peso para la talla
                $de = $this->platc_model->co_pediatria_tabla_crecimiento( $id_site, Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2'], $sexo );
                if( !empty( $de ) )
                    foreach( $de as $dato ) {

                        $de_3n[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_3N'] );
                        $de_2n[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_2N'] );
                        $de_1n[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_1N'] );
                        $de_cero[] = array( (float)$dato['PED_TALLA'], (float)$dato['PED_CERO'] );
                        $de_1p[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_1P'] );
                        $de_2p[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_2P'] );
                        $de_3p[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_3P'] );
                    }

                // Desviaciones estandard: Datos del paciente
                $datos_paciente = $this->platc_model->co_pediatria_tabla_crecimiento_paciente( $id_paciente, $id_site, Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2'] );

                if( !empty( $datos_paciente ) )
                    foreach( $datos_paciente as $dato )
                        if( $dato['meses'] <=24 )
                            $de_paciente[] = array( (float)$dato['talla'], (float)$dato['peso'] );

            } ; break;

            case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5'] : {

                // Desviaciones estandard: Peso para la talla
                $de = $this->platc_model->co_pediatria_tabla_crecimiento( $id_site, Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5'], $sexo );
                if( !empty( $de ) )
                    foreach( $de as $dato ) {

                        $de_3n[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_3N'] );
                        $de_2n[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_2N'] );
                        $de_1n[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_1N'] );
                        $de_cero[] = array( (float)$dato['PED_TALLA'], (float)$dato['PED_CERO'] );
                        $de_1p[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_1P'] );
                        $de_2p[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_2P'] );
                        $de_3p[]   = array( (float)$dato['PED_TALLA'], (float)$dato['PED_3P'] );
                    }

                // Desviaciones estandard: Datos del paciente
                $datos_paciente = $this->platc_model->co_pediatria_tabla_crecimiento_paciente( $id_paciente, $id_site, Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5'] );

                if( !empty( $datos_paciente ) )
                    foreach( $datos_paciente as $dato )
                        if( $dato['meses'] >= 24 )
                            $de_paciente[] = array( (float)$dato['talla'], (float)$dato['peso'] );
            } ; break;
        }

        /*
         * Junta series en un array y lo envia en formato json
         */
        $datos[] = $de_3p;
        $datos[] = $de_2p;
        $datos[] = $de_1p;
        $datos[] = $de_cero;
        $datos[] = $de_1n;
        $datos[] = $de_2n;
        $datos[] = $de_3n;
        $datos[] = $de_paciente;

        $this->output->set_output( json_encode( $datos ) );
    }

    public function co_pediatria_calcular_de( $tipo, $sexo, $x, $y, $z = null ) {

        if( !in_array( $tipo, Platc::$CO_PEDIATRIA_DE ) || empty( $sexo ) || empty( $x ) || empty( $y ) ) {
            $this->output->set_output( "" );
            return array();
        }

        $id_site = (int)$this->session->userdata('SIT_ID');
        $de = $this->platc_model->co_pediatria_obtener_de( $id_site, $tipo, $sexo, $x, $y, $z );
        $valor = "";

        if( !empty( $de ) )

            switch( $tipo ) {

                /*
                 * Valores desde pediatria_tabla_crecimiento, campo "pediatria_talla_para_edad_de"
                 * Valor 1: Menor a -2
                 * Valor 2: Mayor o igual a -2 hasta menor a -1
                 * Valor 3: Mayor o igual a -1
                 */
                case Platc::$CO_PEDIATRIA_DE['TALLA_EDAD']          : {

                    if( $y <= $de['PED_3N'] || $y < $de['PED_2N'] ) $valor = 1;
                    if( $y >= $de['PED_2N'] && $y < $de['PED_1N'] ) $valor = 2;
                    if( $y >= $de['PED_1N'] )                       $valor = 3;
                } break;

                /*
                 * Valores desde pediatria_tabla_crecimiento, campo "pediatria_peso_para_edad_de"
                 * Valor 1: Menor a -3
                 * Valor 2: Menor a -2
                 * Valor 3: Mayor o igual a -2 hasta menor a -1
                 * Valor 4: Mayor o igual a -1 hasta menor o igual a 1
                 */
                case Platc::$CO_PEDIATRIA_DE['PESO_EDAD']           : {

                    if( $y < $de['PED_3N'] )                            $valor = 1;
                    if( $y < $de['PED_2N'] )                            $valor = 2;
                    if( $y >= $de['PED_2N'] && $y < $de['PED_1N'] )     $valor = 3;
                    if( $y >= $de['PED_1N'] )                           $valor = 4;
                } break;

                /*
                 * Valores desde pediatria_tabla_crecimiento, campo "pediatria_peso_para_talla_de"
                 * Valor 1: Menor a -3
                 * Valor 2: Menor a -2
                 * Valor 3: Mayor o igual a -2 hasta menor a -1
                 * Valor 4: Mayor o igual a -1 hasta menor o igual a 1
                 * Valor 5: Mayor o igual a 1  hasta menor o igual a 2
                 * Valor 6: Mayor a 2
                 */
                case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2']      :
                case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5']      : {

                    if( $y < $de['PED_3N'] )                            $valor = 1;
                    if( $y < $de['PED_2N'] )                            $valor = 2;
                    if( $y >= $de['PED_2N'] && $y < $de['PED_1N'] )     $valor = 3;
                    if( $y >= $de['PED_1N'] && $y <= $de['PED_1P'] )    $valor = 4;
                    if( $y >= $de['PED_1P'] && $y <= $de['PED_2P'] )    $valor = 5;
                    if( $y >= $de['PED_2P'] )                           $valor = 6;
                } break;


                /*
                 * Valores desde pediatria_tabla_crecimiento, campo "pediatria_imc_de"
                 * Valor 1: Menor a -2
                 * Valor 2: Mayor o igual a -2 hasta menor a -1
                 * Valor 3: Mayor o igual a -1 hasta menor o igual a 1
                 * Valor 4: Mayor a 1  hasta menor o igual a 2
                 * Valor 5: Mayor a 2
                 */
                case Platc::$CO_PEDIATRIA_DE['IMC']                 : {

                    if( $y < $de['PED_2N'] )                            $valor = 1;
                    if( $y >= $de['PED_2N'] && $y < $de['PED_1N'] )     $valor = 2;
                    if( $y >= $de['PED_1N'] && $y <= $de['PED_1P'] )    $valor = 3;
                    if( $y > $de['PED_1P'] && $y <= $de['PED_2P'] )     $valor = 4;
                    if( $y > $de['PED_2P'] )                            $valor = 5;
                } break;

                /*
                 * Valores desde pediatria_tabla_crecimiento, campo "pediatria_perimetro_cefalico_de"
                 * Valor 1: Menor a -2
                 * Valor 2: Mayor o igual a -2 hasta menor o igual a 2
                 * Valor 3: Mayor a 2
                 */
                case Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO']  : {

                    if( $y < $de['PED_2N'] )                            $valor = 1;
                    if( $y >= $de['PED_2N'] && $y <= $de['PED_2P'] )    $valor = 2;
                    if( $y > $de['PED_2P'] )                            $valor = 3;
                } break;
            }

            $this->output->set_output( $valor );
    }

    public function co_reporte_cie10_por_especialidad( ) {

        $especialidades = array( 39,    41,63,    37 );

        /*
         * Genera Excel, aunque no haya datos que mostrar, así se evita página
         * en blanco
         */
        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->removeSheetByIndex( $objPHPExcel->getActiveSheetIndex() ); // Elimina hoja vacía creada por omisión

        $reporte = array();
        if( !empty( $especialidades ) ) {

            $this->load->model( 'reportes/reportes_co' );
            foreach( $especialidades as $e ) {

                // Obtiene la especialidad para sacar el nombre y colocarlo en pestaña del excel
                $especialidad = $this->platc_model->especialidad_get( (int)$e );

                $r = $this->reportes_co->reportes_cie_por_especialidad( (int)$e, (int)$this->session->userdata('SIT_ID') );
                if( !empty( $r ) )
                    $reporte[ $especialidad['ESP_NOMBRE'] ] = $r;
            }
        }

        if( !empty( $reporte ) ) {

            foreach( $reporte as $nombre_especialidad => $reporte_especialidad ) {

                $especialidad = new PHPExcel_Worksheet( $objPHPExcel, (string)$nombre_especialidad );
                $objPHPExcel->addSheet( $especialidad, 0 );
                $objPHPExcel->setActiveSheetIndex();

                // Fila de cabezera de tabla
                $i = 1; // Indice de fila
                $hojaExcel = $objPHPExcel->getSheetByName( (string)$nombre_especialidad );
                $hojaExcel->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
                $hojaExcel->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'p_genero' ) ) );
                $hojaExcel->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'p_edad' ) ) );
                $hojaExcel->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'diagnostico' ) ) );

                // Completa filas por teleconsulta
                foreach( $reporte_especialidad as $r ) {

                    $hojaExcel->SetCellValue('A' . $i, $r['FOLIO'] );
                    $hojaExcel->SetCellValue('B' . $i, $r['GENERO'] );
                    $hojaExcel->SetCellValue('C' . $i, $r['EDAD'] );
                    $hojaExcel->SetCellValue('D' . $i, $r['DIAGNOSTICOS_CIE10'] );
                    $i++; // Salto de línea
                }
            }
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=ReporteCIE10_por_especialidad_' . date('Ymd') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }

    /*
     * CL: Oftalmología
     */
    public function cl_oftalmologia_agregar_view( $tel_id ) {

        $data = array( );
        $data[ 'tel_id' ]        = $tel_id;
        $data[ 'hash_borrador' ] = $this->platc_model->cl_oftalmologia_crear_carpeta_borrador( $tel_id );

        $this->load->library( 'FormularioXML' );
        $vista = $this->formularioxml->generar_parcial( $tel_id, 'archivos_imagenes_agregar', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $vista );
    }

    public function cl_oftalmologia_archivos_borradores( $tel_id ) {

        $data = array( );
        $data[ 'imagenes' ] = $this->platc_model->cl_oftalmologia_obtener( $tel_id, TRUE );
        $data[ 'tel_id' ]   = $tel_id;
        $data[ 'ultimo_borrador' ] = key( array_slice( $data[ 'imagenes' ], -1, 1, true ) );

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_imagenes_ajax', FormularioXML::$MODO_ESCRITURA, $data );

        $this->output->set_output( $html );
    }

    public function cl_oftalmologia_guardar_comentario( $tel_id, $hash_borrador ) {

        $exito = true;
        if( !empty( $_POST ) ) {

            $ruta = 'files/oftalmologia/'.$tel_id;
            $ruta.= '/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADORES'].'/'.$hash_borrador.'/';

            $observacion = NULL;
            $ruta_foto = NULL;

            foreach( $_POST as $k => $v ) {

                if( !empty( $v ) ) {
                    switch( $k ) {
                        case Platc::$CL_OFTALMOLOGIA_FOTOS['IZQUIERDO'] : { $ruta_foto = Platc::$CL_OFTALMOLOGIA_FOTOS['IZQUIERDO'];$observacion = $v; } break;
                        case Platc::$CL_OFTALMOLOGIA_FOTOS['DERECHO']   : { $ruta_foto = Platc::$CL_OFTALMOLOGIA_FOTOS['DERECHO'];  $observacion = $v; } break;
                        default : $exito = false; break;
                    }

                    if( !empty( $ruta_foto ) && !empty( $observacion ) ) {

                        if( !is_dir( $ruta.'/'.$ruta_foto ) )
                            mkdir( $ruta.'/'.$ruta_foto, 0755, TRUE );

                        if( FALSE !== $h_comentario = fopen( $ruta.'/'.$ruta_foto.'/'.$ruta_foto.'.comment', 'w' ) ) {

                            fwrite( $h_comentario, $observacion );
                            fclose( $h_comentario );
                            $exito = TRUE;
                        } else
                            throw new Exception( 'No se pudo crear/abrir archivo de comentario ID['.$tel_id.']'.' HASH['.$hash_borrador.']'.'FOTO['.$ruta_foto.']' );
                    }
                }
            }
        }

        $msg = array( );
        if( $exito ) {
            $msg['action'] = 'false';
            $msg['msgt'] = 'OK';
            $msg['msg'] = $this->lang->line('oftalmologia_guardar_ok');
        } else {
            $msg['action'] = 'false';
            $msg['msgt'] = $this->lang->line('error');
            $msg['msg'] = $this->lang->line('oftalmologia_guardar_error');
        }

        $this->output->set_output( json_encode( $msg ) );
    }

    public function cl_oftalmologia_eliminar_borrador( ) {

        $exito = FALSE;

        if( !empty( $_POST ) ) {
            $tel_id         = $this->input->post( 'tel_id' );
            $hash_borrador  = $this->input->post( 'hash' );

            $ruta_borradores = 'files/oftalmologia/'.$tel_id.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADORES'].'/'.$hash_borrador;
            $ruta_borrados   = 'files/oftalmologia/'.$tel_id.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'].'/'.$hash_borrador;

            if( is_dir( $ruta_borradores ) ) {

                if( !is_dir( $ruta_borrados ) )
                    mkdir( $ruta_borrados, 0755, TRUE );

                if( @rename( $ruta_borradores, $ruta_borrados ) )
                    $exito = TRUE;
                else
                    $exito = FALSE;
            }
        }

        $this->output->set_output( (bool) $exito );
    }

    public function cl_oftalmologia_archivos_upload( $tel_id, $hash_borrador, $directorio_lesion ) {

        $exito = true;
        if( !empty( $_FILES ) ) {

            /*
             * 1) Establece ruta donde guardar archivo: files/oftalmologia/$tel_id/
             */
            $ruta = str_replace( '//', '/', 'files/oftalmologia/'.$tel_id.DIRECTORY_SEPARATOR.'/borradores/'.$hash_borrador.DIRECTORY_SEPARATOR.$directorio_lesion );

            if( !is_dir( $ruta ) )
                mkdir( str_replace( '//', '/', $ruta ), 0755, true );

            /*
             * Comprueba que exista un solo archivo de imagen subido por el usuario en el directorio borrador
             * si existe, lo traslada a carpeta Borrados
             */
            $dir = glob( $ruta.'/*', GLOB_ONLYDIR );
            $todos = scandir( $ruta );
            $todos_temp = array( );

            foreach( $todos as $k => $v )
                if( $v == '.' || $v == '..' || strrpos( $v, '.comment', -1 ) !== FALSE  )
                    unset( $todos[ $k ] );
                else
                    $todos_temp[ $k ] = $ruta.'/'.$v;

            $array_archivos_subidos = array_diff( $todos_temp, $dir );

            if( !empty( $array_archivos_subidos ) ) {

                if( !file_exists( $ruta.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'] ) )
                    @mkdir( $ruta.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'], 0777, TRUE );

                foreach( $todos as $archivo_subido ) {
                    if( $archivo_subido != '.' && $archivo_subido != '..' &&
                        !is_dir( $ruta.'/'.$archivo_subido ) &&
                        !strpos( $archivo_subido, 'thumb_' ) !== FALSE ) {

                        $origen     = $ruta.'/'.$archivo_subido;
                        $destino    = $ruta.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'].'/'. date('YmdHis').'_'.$archivo_subido;
                        @rename( $origen, $destino );

                        if( is_file( 'thumb_'.$archivo_subido ) ) {

                            $origen     = $ruta.'/thumb_'.$archivo_subido;
                            $destino    = $ruta.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'].'/'. date('YmdHis').'_thumb_'.$archivo_subido;
                            @rename( $origen, $destino );
                        }
                    }
                }
            }

            /*
             * Realiza subida del archivo
             */
            $config['upload_path']   = $ruta;
            $config['allowed_types'] = 'doc|docx|xls|xlsx|pdf|jpg|gif|png|bmp|tiff|rtf|rar|zip|7z|tar|tgz';
            $config['remove_spaces'] = FALSE;
            $config['max_size']      = 0;
            $this->load->library( 'upload', $config );

            if( $this->upload->do_upload( 'Filedata' ) ) {

                $data = $this->upload->data();

                $img_ext = array( 'jpg', 'gif', 'jpeg', 'png', 'bmp', 'tiff' );

                // Si es un archivo del tipo BMP de windows, se convierte a formato PNG
                // esto porque la librería fpdf no lee archivos BMP :(
                if( strtolower( $data['file_ext'] ) == '.bmp' ) {

                    // Carga archivo BMP en memoria
                    $this->load->helper('image');
                    $imagen  = imagecreatefrombmp( $data['full_path'] );
                    if( $imagen ) {

                        // Imagen en memoria ($imagen) es convertido a archivo PNG
                        imagepng( $imagen, $data['file_path'].'/'.$data['raw_name'].'.png', 9, PNG_NO_FILTER );
                        imagedestroy( $imagen );

                        // Mueve a carpeta "borrados" archivo BMP, a modo de respaldo
                        if( !is_dir( $data['file_path'].'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'] ) )
                            @mkdir( $data['file_path'].'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'] );
                        @rename( $data['full_path'], $data['file_path'].'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'].'/'. date('YmdHis').'_'.$data['file_name'] );

                        // Cambia información, estableciendo archivo convertido PNG como archivo subido
                        $data['file_name']  = $data['raw_name'].'.png';
                        $data['file_type']  = 'image/png';
                        $data['full_path']  = $data['file_path'].'/'.$data['raw_name'].'.png';
                        $data['orig_name']  = $data['raw_name'].'.png';
                        // $data['client_name']= $data['raw_name'].'.png'; <--???
                        $data['file_ext']   = '.png';
                        $data['image_type'] = 'png';
                    } else {
                        log_message( 'error', 'No se pudo convertir archivo de imagen a png: '.$data['full_path'] );
                        $exito = false;
                    }
                }

                $origen = strtolower( ltrim( $data['file_ext'], '.' ) );
                if( array_search( $origen, $img_ext ) !== FALSE) {

                    // Genera miniatura
                    $this->load->library( 'phpThumbWrapper' );
                    $exito = $this->phpthumbwrapper->generarMiniatura( $data['file_path'], $data['file_name'] );
                }
            } else
                $exito = FALSE;
        } else
            $exito = FALSE;

        if( $exito )
            $this->output->set_output( 1 );
        else
            $this->output->set_output( 0 );
    }

    public function cl_oftalmologia_archivos( $tel_id ) {

        $data = array( );
        $data[ 'imagenes' ] = $this->platc_model->cl_oftalmologia_obtener( $tel_id );
        $data[ 'borrador' ] = FALSE;

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_parcial( $tel_id, 'archivos_imagenes_ajax', FormularioXML::$MODO_LECTURA, $data );

        $this->output->set_output( $html );
    }

    private function cl_oftalmologia_reorganizar_archivos( $tel_id ) {

        $exito = TRUE;
        $ruta_borrador  = 'files/oftalmologia/'.$tel_id.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADORES'].'/';
        $ruta_fijo      = 'files/oftalmologia/'.$tel_id.'/';

        if( is_dir( $ruta_borrador ) )
            $handle = opendir( $ruta_borrador );
        else
            $handle = false;

        if( $handle ) {

            $i = 1;

            // Recorre todas las lesiones
            while( false !== ( $hash_borrador = readdir( $handle ) ) && $exito ) {

                if( $hash_borrador != '.' && $hash_borrador != '..' ) {

                    $ruta_imagenes_borrador = $ruta_borrador.$hash_borrador;
                    $ruta_imagenes_fijo     = $ruta_fijo.$i;
                    if( @rename( $ruta_imagenes_borrador, $ruta_imagenes_fijo ) )
                        $exito = TRUE;
                    else
                        $exito = FALSE;

                    $i++;
                }
            }

            closedir($handle);
            if( !@rmdir( $ruta_borrador ) ) {
                error_log( 'No se pudo eliminar directorio ['.$ruta_borrador.']');
            }
        }

        return $exito;
    }

    public function cl_oftalmologia_visualizar( $tel_id ) {

        $data = array( );
        $data['tel_id']     = $tel_id;
        $data['imagenes']   = $this->platc_model->cl_oftalmologia_obtener( $tel_id );

        $this->load->library( 'FormularioXML' );
        $html = $this->formularioxml->generar_vista_completa( $tel_id, 'archivos_imagen_view', $data );

        $this->output->set_output( $html );
    }

    public function co_reporte_contestadas( ) {

        $fecha_inicio = "2014-01-01 00:00:00";
        $fecha_fin    = "2015-01-01 00:00:00";

        /*
         * Genera Excel, aunque no haya datos que mostrar, así se evita página
         * en blanco
         */
        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
//        $objPHPExcel->removeSheetByIndex( $objPHPExcel->getActiveSheetIndex() ); // Elimina hoja vacía creada por omisión

        $this->load->model( 'reportes/reportes_co' );
        $reporte = $this->reportes_co->tc_contestadas( $this->session->userdata('SIT_ID'), $fecha_inicio, $fecha_fin );

        // Fila de cabezera de tabla
        $i = 1; // Indice de fila
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'p_nombre_completo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'establecimiento' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'usuarios_especialidad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'p_sexo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'p_edad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'dm_general' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( $this->lang->line( 'dm_ci10_especialista' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( $this->lang->line( 'tc_responder_conespecialista' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, html_entity_decode( $this->lang->line( 'tc_responder_diaespecialista' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( $this->lang->line( 'tc_responder_diafundamentos' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$i, html_entity_decode( $this->lang->line( 'tc_responder_diaorientacion' ) ) );

        if( !empty( $reporte ) ) {

            // Completa filas por teleconsulta
            foreach( $reporte as $r ) {

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $r['TEL_ID'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $r['PAC_IDT_VALOR'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $r['NOMBRE_COMPLETO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $r['ETB_NOMBRE'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $r['ESP_NOMBRE'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $r['TEL_PAC_SEXO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $r['TEL_PAC_EDAD'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $r['CIE10_GENERALISTA'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $r['CIE10_ESPECIALISTA'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $r['TEL_CON_ESPECIALISTA'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $r['TEL_DIA_ESPECIALISTA'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $r['TEL_DIA_FUNDAMENTOS'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, $r['TEL_DIA_ORIENTACION'] );
                $i++; // Salto de línea
            }
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Reporte_respondidos_' . date('Ymd') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }
	
	public function gfr_agen_ExisteAgendamiento() {  //ffarias SI1383
	       $id_tc    = $this->input->post( 'id_teleconsulta' );

		   if ($id_tc) {
	          echo $this->platc_model->gfr_agen_checkExisteAgendamiento( $id_tc );
		   } else {
              echo 'true';
           }
 
	}
	
	private function enviar_notificacion_asignacion_bolsa($id_bolsa = "", $tel_id = ""){
		if($id_bolsa && $tel_id){
			$this->load->model('bolsa_model');
			$this->load->library('email');
			$path = dirname($_SERVER['SCRIPT_FILENAME']).'/'.APPPATH.'logs/sms/';
			$mkdir = FALSE;
			if(!file_exists($path)){
				if(mkdir($path, 0777, TRUE)) $mkdir = TRUE;
			}
			$txtSms = $this->lang->line('texto_sms');
			$dataSms = $this->bolsa_model->selectDataSms($id_bolsa,$tel_id);
			if($dataSms){ foreach($dataSms as $data){
				//Data Fecha/Hora
				$txtSms = str_replace("{FECHA}",date('d-m-Y'),$txtSms);
				$txtSms = str_replace("{HORA}",date('H:i'),$txtSms);
				//Data teleconsulta
				$txtSms = str_replace("{TEL_ID}",$data->TEL_ID,$txtSms);
				$txtSms = str_replace("{ESPECIALIDAD}",$data->ESP_NOMBRE,$txtSms);
				$txtSms = str_replace("{INSTITUCION}",$data->ENTADM_NOMBRE,$txtSms);
				//Data Click A Tell
				$url = $this->config->item('servicio_clickatell', 'platc');
				$url = str_replace("{MOVIL}",preg_replace('/\s+/','',$data->USU_TELEFONO),$url);
				//$url = str_replace("{MOVIL}","56977677061",$url);
				$url = str_replace("{TEXTO}",utf8_decode(preg_replace('/\s+/','+',$txtSms)),$url);
				//Registro LOG
				$log = "";
				//$log = file($url);
				if($log && is_array($log)){
					$msglog = date('H:i:s')." >> Medico ".$data->USU_NOMBRE.", MOVIL = ".$data->USU_TELEFONO." URL: ".$url." LOG SMS ".$log[0]."\n";
					//Notificacion vía Email
					$emails = $this->config->item('email_notificacion_admin', 'platc');
					$this->email->from('noreply@itms.com.co', 'noreply@itms.com.co');
					$this->email->to($emails);
					$this->email->subject('Notificacion SMS generada en asignacion de Bolsa');
					$this->email->message('
Estimado(a):
Este correo ha sido generado de forma automatica para informar a Ud. que se ha notificado al medico especialista: '.$data->USU_NOMBRE.'
de una nueva teleconsulta asociada a su bolsa asociada.
El mensaje enviado es:
"'.$txtSms.'"');
					$this->email->send();
					//echo $this->email->print_debugger();
				}
				else{
					$msglog = date('H:i:s')." >> Medico ".$data->USU_NOMBRE.", MOVIL = ".$data->USU_TELEFONO." URL: ".$url." LOG SMS: Error al invocar URL\n";
				}				
				if($mkdir){
					$logfile = $path."log".date('Ymd').".log";
					$current = file_get_contents($logfile);
					$current .= $msglog;
					file_put_contents($logfile, $current);
				}
			}}
		}
	}
	
	//NF431 AGENDAMIENTO TC VIRTUALES
    public function agendamiento_agrega_tc_virtual() {
        if( $_POST ) {
			$this->load->model('tc_virtual/tc_virtual_model');
            $id_estado      = Platc::$AGENDAMIENTO_ESTADOS['TOMADA'];  // 1: Tomada
            $id_site        = $this->session->userdata( 'SIT_ID' );
            $id_especialista = $this->input->post( 'agendamiento_id_medico' );
            $id_tc          = "";
            $id_agenda_def  = $this->input->post( 'agendamiento_id_agenda_def' );
            $fecha          = $this->util->fecha_orden( $this->input->post( 'agendamiento_fecha' ) );
            $hora           = $this->input->post( 'agendamiento_hora' );
            $observaciones  = $this->input->post( 'agendamiento_observaciones' );
            $telefono       = $this->input->post( 'agendamiento_telefono_contacto' );
            $email          = $this->input->post( 'agendamiento_email_contacto' );
            switch( (int)$this->session->userdata('ROL_ID') ) {
                case Platc::$ROL['MEDICO_GENERAL']      : 
                    $id_generalista = (int)$this->session->userdata( 'USU_ID' );
                    $id_asistente = null;
                    break;
                case Platc::$ROL['MEDICO_ASISTENTE']    :
                case Platc::$ROL['ADMIN']    :
                    $id_generalista = (int)$this->input->post( 'agendamiento_generalista' );
                    $id_asistente = (int)$this->session->userdata( 'USU_ID' );
                    break;
                case Platc::$ROL['ATENCION_CLIENTE']    : /* NF432 */
                    $id_generalista = (int)$this->input->post( 'agendamiento_generalista' );
                    $id_asistente = (int)$this->session->userdata( 'USU_ID' );
                    break;                    
            }

            $id = $this->platc_model->agendamiento_agregar( $id_estado, $id_site, $id_generalista, $id_asistente, $id_tc, $id_agenda_def, $id_especialista, $fecha, $hora, $observaciones, $telefono, $email );

            if( !empty( $id ) ){
				$data = array(
					'TCV_AGE_ID' => $id,
					'TCV_PAC_ID' => $_POST['pac_id'],
					'TCV_ETB_ID' => $_POST['etb_id'],
					'TCV_ESP_ID' => $_POST['esp_id'],
					'TCV_USU_ID' => (int)$this->session->userdata('USU_ID')
				);
				if($this->tc_virtual_model->insert($data)){
					$resp['method'] = ( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) ? base_url() . 'platc/agenda_resumen/' : base_url() . 'platc/agendamiento_resumen/';
					$resp['div'] = 'deploy';
					$resp['action'] = 'true';
					$resp['msgt'] = 'OK';
					$resp['msg'] = $this->lang->line('agendamiento_agregado_ok');	
				}
				else{
					$resp['msgt'] = 'OK';
					$resp['msg'] = $this->lang->line('agendamiento_agregado_error');
				}
            } else {
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('agendamiento_agregado_error');
            }

        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }
    public function agendamiento_cambiar_fecha_hora_tc_virtual( ) {
		$this->load->model('tc_virtual/tc_virtual_model');
        $id_agendamiento    = $this->input->post('id_agendamiento');
        $fecha              = $this->input->post('fecha');
        $hora               = $this->input->post('hora');

        $estado = $this->tc_virtual_model->agendamiento_cambiar_fecha_hora( $id_agendamiento, $fecha, $hora );

        $resp = array( );
        if( $estado == true ) {
            $resp['action'] = true;
            $resp['msgt']   = $this->lang->line('agendamiento_agregar');
            $resp['msg']    = $this->lang->line('agendamiento_cambio_hora_ok');
        } else {
            $resp['action'] = false;
            $resp['msgt']   = $this->lang->line('agendamiento_agregar');
            $resp['msg']    = $this->lang->line('agendamiento_cambio_hora_error');
        }

        $this->output->set_output( json_encode( $resp ) );
    }
	//FIN NF431
	
	//NF514
	public function upd_paciente(){
		if($_POST && array_key_exists('upd_pac_id',$_POST)){
			$this->load->model('platc/paciente_model');
			$data = array(
				'PAC_TELEFONO' => $_POST['upd_pac_telefono'],
				'PAC_EMAIL' => $_POST['upd_pac_email'],
				'PAC_PROCEDENCIA' => $_POST['upd_pac_procedencia'],
				'PAC_OCUPACION' => $_POST['upd_pac_ocupacion'],
				'AFI_ID' => $_POST['upd_pac_afiliacion']
			);
			echo $this->paciente_model->update($_POST['upd_pac_id'],$data);
		}
		else{
			echo FALSE;
		}
	}
	public function get_muni(){
		if($_POST && array_key_exists('etb_id',$_POST)){
			$etb = $this->platc_model->establecimiento_get($_POST['etb_id']);
			echo ($etb) ? $etb['MUNI_ID'] : "";
		}
		else{
			echo FALSE;
		}
	}
	//FIN
	
	//------ START  ANEXO 3
	
    public function anexo_listar( $tel_id = '' ) {

        $datos = array( );
        $datos['tc'] = $this->platc_model->tc_get( (int)$tel_id );
        $datos['listado_anexo'] = $this->platc_model->anexo_get( (int)$tel_id );

        $this->load->view( 'forms/anexo_listado_datagrid', $datos );
    }
	
   public function anexo_crear( $tel_id = '' ) {

        $datos = array();
        $tc = $this->platc_model->tc_get( (int)$tel_id );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );

        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }

        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
		
		$datos['guiaspracticas_list']    = $this->platc_model->guias_practicas_list_get();
        $datos['diagnosticos_list']    = $this->platc_model->cie10_respuesta_get( (int)$tc['TEL_ID']);
	
		$departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['paciente']['DEP_ID']);
		$datos['data_depto_paciente']=$departamento_data;
		
		$municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['paciente']['MUNI_ID']);
		$datos['data_munic_paciente']=$municipio_data;

        $entidad_adm_data = $this->platc_model->get_info_entidad_administradora($datos['paciente']['EA_ID']);
		$datos['data_entadm_paciente']=$entidad_adm_data;
		
		$establecimiento_data = $this->platc_model->get_info_table_param('TC_ESTABLECIMIENTO','ETB_ID',(int)$tc['ETB_ID']);
		$datos['data_establecimiento']=$establecimiento_data;
		
		
        $establec_departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['data_establecimiento']['ETB_DPTO_ID']);
		$datos['data_depto_establec']=$establec_departamento_data;
		
		$establec_municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['data_establecimiento']['ETB_MUNI_ID']);
		$datos['data_munic_establec']=$establec_municipio_data;
        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

		$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
		$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
		$this->load->view('forms/anexo_nuevo', $datos );

    }
    public function anexo_crea( ) {
		$cups_codigo = $this->input->post( 'cups_codigo' );
	 if(empty($cups_codigo)){
           $resp = array(  'msgt' => 'ERROR',
                                'msg'  => 'Codigo CUPS no ingresado.',
                                'id_sol_axo'  => 0,
                                'action' => 'false' );

                $this->output->set_output( json_encode( $resp ) );
                return;
        }else{
    	    // Info formula
            $tel_id                = $this->input->post('axo_tel_id');
    		$id_sersol_origen      = $this->input->post('axo_4_sersol_origen');
    		$id_sersol_tipo        = $this->input->post('axo_4_sersol_tipo');
    		$id_sersol_prio        = $this->input->post('axo_4_sersol_priori');
    		$id_sersol_ubicpac     = $this->input->post('axo_4_sersol_ubicapac');
    		$id_sersol_serv        = $this->input->post('axo_4_sersol_servicio');
    		$id_sersol_cam         = $this->input->post('axo_4_sersol_cama');
    		$id_sersol_just        = $this->input->post('axo_4_sersol_justif');
    		$id_sersol_guiacod     = $this->input->post('axo_guiapract');
    		$id_sersol_guiaobs     = $this->input->post('axo_guiapract_obs');
    		$arr_axo_dm_general     = $this->input->post('axo_dm_general');
    		

    		$anexo_id = $this->platc_model->anexo_crear($tel_id,
    												 $id_sersol_origen,
    												 $id_sersol_tipo,
    												 $id_sersol_prio,
    												 $id_sersol_ubicpac,
    												 $id_sersol_serv,
    												 $id_sersol_cam,
    												 $id_sersol_just,
    												 $id_sersol_guiacod,
    												 $id_sersol_guiaobs);

            $this->platc_model->cups_eliminar($tel_id);
           // Ciclo que recoge información de los CUPS
            $cups = array( );
    		if ($this->input->post('tm_id') ){
    			$listado_cups_post = array( 'tm_id','cups_codigo','cups_cant','cups_desc' );
    			foreach( $listado_cups_post as $cups_post ) {
    				foreach( $this->input->post( $cups_post ) as $k => $v ) {
    					$cups[ $k ][ $cups_post ] = $v;
    				}
    			}
    			foreach( $cups as $v ) {
    				$this->platc_model->anexo_cups_crear($tel_id,$v['tm_id'],$v['cups_codigo'],$v['cups_cant'],$v['cups_desc'] );
    			}
            }
       
          			// Ciclo Diagnosticos 
    	    if ($this->input->post('tm_idd') ){
    		   	
    			$arrCie10Post = "";
    			$arrCie10Ant = "";
    			$arr_axo_dm = array();
    		   	foreach($this->input->post('tm_idd') as $v){
    				$arrCie10Post[] = $v;
    			}
                $arr_axo_dm= explode(",",$arr_axo_dm_general);
    			$arrCie10Ant = json_encode($arr_axo_dm);
    			$arrCie10Post = json_encode($arrCie10Post);

                $arrConcatdiag = json_encode(array_merge(json_decode($arrCie10Ant, true),json_decode($arrCie10Post, true)));
    						
    			$this->platc_model->upd_data_teleconsulta_data($tel_id,$arrConcatdiag);


           }

         

    	   
    	// start - Crea recetario a partir de Anexo 3

            $tipo                   = Platc::$RECETARIO_TIPO['RECETA'];
            $id_medico_generalista  = $this->input->post('id_medico_generalista');
            $id_medico_especialista = $this->input->post('id_medico_especialista');
            $paciente_telefono      = $this->input->post('recetario_telefono');
            $paciente_id_municipio  = $this->input->post('recetario_id_municipio');
            $paciente_direccion_residencia = $this->input->post('recetario_direccion_residencia');


            $this->platc_model->recetario_eliminar_por_tc_id($tel_id);

            $rec_id = $this->platc_model->recetario_crear(
    														$tel_id,//$tel_id
    														$tipo,//$tipo
    														$id_medico_generalista,
    														$id_medico_especialista,
    														$paciente_telefono,
    														$paciente_id_municipio,
    														$paciente_direccion_residencia,
    														'',
    														'',
    														''
    													);
           // End - Crea recetario a partir de Anexo 3
    	   
           // Ciclo que recoge información de las solicitudes
    		if($cups){
    			foreach( $cups as $v ) {
    				$this->platc_model->recetario_solicitudes_crear($rec_id,$v['cups_desc'] );
    			}
    		}

    	//Fin



         if( (int)$anexo_id > 0 ) {
    	       $resp = array(  'msgt' => 'false',
                                'msg'  => 'false',
                                'id_sol_axo'  => (int)$anexo_id,
                                'action' => 'true' );

                $this->output->set_output( json_encode( $resp ) );
                return;
           } else {
                $resp = array(  'msgt' => 'ERROR',
                                'msg'  => 'Existe problemas para grabar e registro.',
                                'id_sol_axo'  => (int)$anexo_id,
                                'action' => 'false' );

                $this->output->set_output( json_encode( $resp ) );
                return;
    	   }	
        }
	}
	

	
	 public function anexo_editar( $tel_id ) {
		 
		 
		$datos = array();
        $tc = $this->platc_model->tc_get( (int)$tel_id );
        $datos['tc'] = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
		$datos['anexo_data']   = $this->platc_model->anexo_get( (int)$tc['TEL_ID'] );
        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }
        $datos ['cups_list']            = $this->platc_model->anexo_obtener_cups_lista( (int)$tc['TEL_ID']);
		$datos ['diagnosticos_list']    = $this->platc_model->cie10_respuesta_get( (int)$tc['TEL_ID']);
        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        //$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
		//$datos['establecimientos']  = $this->platc_model->establecimiento_data_get((int)$tc['ETB_ID']);
		

		$datos['guiaspracticas_list']    = $this->platc_model->guias_practicas_list_get();

		$departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['paciente']['DEP_ID']);
		$datos['data_depto_paciente']=$departamento_data;
		
		$municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO','MUNI_ID',$datos['paciente']['MUNI_ID']);
		$datos['data_munic_paciente']=$municipio_data;

        $entidad_adm_data = $this->platc_model->get_info_entidad_administradora($datos['paciente']['EA_ID']);
		$datos['data_entadm_paciente']=$entidad_adm_data;
		
		$establecimiento_data = $this->platc_model->get_info_table_param('TC_ESTABLECIMIENTO','ETB_ID',(int)$tc['ETB_ID']);
		$datos['data_establecimiento']=$establecimiento_data;
		
		
        $establec_departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['data_establecimiento']['ETB_DPTO_ID']);
		$datos['data_depto_establec']=$establec_departamento_data;
		
		$establec_municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['data_establecimiento']['ETB_MUNI_ID']);
		$datos['data_munic_establec']=$establec_municipio_data;

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

		$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
		$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
		$this->load->view('forms/anexo_editar', $datos );

     
	 }
     public function anexo_editar_cerrado( $tel_id ) {
         
         
        $datos = array();
        $tc = $this->platc_model->tc_get( (int)$tel_id );
        $datos['tc'] = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
        $datos['anexo_data']   = $this->platc_model->anexo_get( (int)$tc['TEL_ID'] );
        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }
        $datos ['cups_list']            = $this->platc_model->anexo_obtener_cups_lista( (int)$tc['TEL_ID']);
        $datos ['diagnosticos_list']    = $this->platc_model->cie10_respuesta_get( (int)$tc['TEL_ID']);
        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
        //$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
        //$datos['establecimientos']  = $this->platc_model->establecimiento_data_get((int)$tc['ETB_ID']);
        

        $datos['guiaspracticas_list']    = $this->platc_model->guias_practicas_list_get();

        $departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['paciente']['DEP_ID']);
        $datos['data_depto_paciente']=$departamento_data;
        
        $municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO','MUNI_ID',$datos['paciente']['MUNI_ID']);
        $datos['data_munic_paciente']=$municipio_data;

        $entidad_adm_data = $this->platc_model->get_info_entidad_administradora($datos['paciente']['EA_ID']);
        $datos['data_entadm_paciente']=$entidad_adm_data;
        
        $establecimiento_data = $this->platc_model->get_info_table_param('TC_ESTABLECIMIENTO','ETB_ID',(int)$tc['ETB_ID']);
        $datos['data_establecimiento']=$establecimiento_data;
        
        
        $establec_departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['data_establecimiento']['ETB_DPTO_ID']);
        $datos['data_depto_establec']=$establec_departamento_data;
        
        $establec_municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['data_establecimiento']['ETB_MUNI_ID']);
        $datos['data_munic_establec']=$establec_municipio_data;

        /*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }


        $estado_contestada = $this->platc_model->tc_estado_get($tc['TEL_ID'], 7);

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( $estado_contestada['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

        $datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
        $datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
        $this->load->view('forms/anexo_editar_cerrado', $datos );

     
     }
	public function anexo_edita( ) {
	
	    // Info formula
        $tel_id                = $this->input->post('axo_tel_id');
		$sol_id                = $this->input->post('axo_sol_id');
		$id_sersol_origen      = $this->input->post('axo_4_sersol_origen');
		$id_sersol_tipo        = $this->input->post('axo_4_sersol_tipo');
		$id_sersol_prio        = $this->input->post('axo_4_sersol_priori');
		$id_sersol_ubicpac     = $this->input->post('axo_4_sersol_ubicapac');
		$id_sersol_serv        = $this->input->post('axo_4_sersol_servicio');
		$id_sersol_cam         = $this->input->post('axo_4_sersol_cama');
		$id_sersol_just        = $this->input->post('axo_4_sersol_justif');
        $id_sersol_guiacod     = $this->input->post('axo_guiapract');
		$id_sersol_guiaobs     = $this->input->post('axo_guiapract_obs');
		$arr_axo_dm_general    = $this->input->post('axo_dm_general');


		
	    $anexo_id_nuevo = $this->platc_model->anexo_editar( 
		  								         $tel_id,
										         $sol_id,
												 $id_sersol_origen,
												 $id_sersol_tipo,
												 $id_sersol_prio,
												 $id_sersol_ubicpac,
												 $id_sersol_serv,
												 $id_sersol_cam,
												 $id_sersol_just,
												 $id_sersol_guiacod,
												 $id_sersol_guiaobs);
       // Ciclo que recoge información de los cups
      if ($this->input->post('tm_id') ){
        $cups = array( );
        $listado_cups_post = array( 'tm_id','cups_codigo','cups_cant','cups_desc' );
        foreach( $listado_cups_post as $cups_post ) {

            foreach( $this->input->post( $cups_post ) as $k => $v ) {

                $cups[ $k ][ $cups_post ] = $v;
            }
        }
        foreach( $cups as $v ) {
            $this->platc_model->anexo_cups_crear($tel_id,$v['tm_id'],$v['cups_codigo'],$v['cups_cant'],$v['cups_desc'] );
        }
       }
		// Ciclo Diagnosticos 
	    if ($this->input->post('tm_idd') ){
		   	
			$arrCie10Post = "";
			$arrCie10Ant = "";
			$arr_axo_dm = array();
		   	foreach($this->input->post('tm_idd') as $v){
				$arrCie10Post[] = $v;
			}
            $arr_axo_dm= explode(",",$arr_axo_dm_general);
			$arrCie10Ant = json_encode($arr_axo_dm);
			$arrCie10Post = json_encode($arrCie10Post);

            $arrConcatdiag = json_encode(array_merge(json_decode($arrCie10Ant, true),json_decode($arrCie10Post, true)));
						
			$this->platc_model->upd_data_teleconsulta_data($tel_id,$arrConcatdiag);


       }



     if( (int)$anexo_id_nuevo > 0 ) {
	       $resp = array(  'msgt' => 'false',
                            'msg'  => 'false',
                            'id_sol_axo'  => (int)$anexo_id_nuevo,
                            'action' => 'true' );

            $this->output->set_output( json_encode( $resp ) );
            return;
       } else {
            $resp = array(  'msgt' => 'ERROR',
                            'msg'  => 'Existe problemas para grabar e registro.',
                            'id_sol_axo'  => (int)$anexo_id_nuevo,
                            'action' => 'false' );

            $this->output->set_output( json_encode( $resp ) );
            return;
	   }
	  }	

		public function anexo_elimina($id_tc='' ) {
	
			//$id_tc = $this->input->post( 'id_tc_axo' );
			if($id_tc) {
				$estado = $this->platc_model->anexo_eliminar( $id_tc );
				$this->output->set_output( json_encode( array( 'action' => (bool)$estado ) ) );
				
				$recetas = $this->platc_model->recetarios_get($id_tc);
				if($recetas && count($recetas)){
					foreach($recetas as $rec){
						$this->platc_model->recetario_eliminar($rec['REC_ID']);
					}
				}
			}
		}	  
	
	public function cups_autocomplete( $texto )  {

        $cups = array( );

        if( !empty( $texto ) ) {

            $lista_cups = $this->platc_model->cups_busqueda_por_texto( $this->session->userdata( 'SIT_ID' ), $texto );
           
            if( !empty( $lista_cups  ) )
                foreach( $lista_cups as $valor ) {
                     $cups[] = array('label' =>  "[". $valor['CUPS_ID'] . "] ".$valor['CUPS_DESC'] . " ",
                                            'value' =>  $valor['CUPS_ID'] ,
											'TM_CODIGO' => $valor['CUPS_ID'],
											'TM_DESC' => $valor['CUPS_DESC']
											);										
                }
        }

        $this->output->set_output( json_encode( $cups ) );
    }
	public function cups_busqueda_por_texto( $texto ) {
	
			$cups = array( );
	
			if( !empty( $texto ) ) {
	
				$lista_cups = $this->platc_model->cups_busqueda_por_texto( $this->session->userdata( 'SIT_ID' ), $texto );
			   

				if( !empty( $lista_cups  ) )
					foreach( $lista_cups as $valor ) {
                            $cups[] = array('label' =>  "[". $valor['CUPS_ID'] . "] ".$valor['CUPS_DESC'] . " ",
												'value' =>  $valor['CUPS_ID'] ,
												'TM_CODIGO' => $valor['CUPS_ID'],
												'TM_DESC' => $valor['CUPS_DESC']
												);										
					}
			}
	
			$this->output->set_output( json_encode( $cups ) );
	}	
	
    public function get_lista_anexos_tc(){

		if($_POST["TEL_ID"]){

    		$this->load->model("platc_model");
			$result = $this->platc_model->select_anexos_tc((int)$_POST["TEL_ID"]);
			if($result){
				$html = "";
				foreach($result as $i => $row){
					$html .= "<tr id='".$row["AXO_SOL_ID"]."'>";
					$html .= "<td>".($i + 1)."</td>";
					$html .= "<td>".(($row["AXO_SOL_FECHA"] && date_create($row["AXO_SOL_FECHA"])) ? date("d-m-Y H:i",strtotime($row["AXO_SOL_FECHA"])) : "")."</td>";
					$html .= "<td><a href='#' id='".$row["AXO_SOL_ID"]."' class='abrir'>Ver Anexo</a></td>";
					$html .= "</tr>";
				}
				echo $html;
			}
			else{
				return FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}	
	
	public function diags_busqueda_por_texto( $texto ) {

        $diags = array( );

        if( !empty( $texto ) ) {

            $lista_diags = $this->platc_model->diags_busqueda_por_texto( $this->session->userdata( 'SIT_ID' ), $texto );
           
            if( !empty( $lista_diags  ) )
                foreach( $lista_diags as $valor ) {
                     $diags[] = array('label' =>  "[". $valor['id10'] . "] ".$valor['dec10'] . " ",
                                            'TM_CODIGOREAL' =>  $valor['CIE_ID'] ,
											'TM_CODIGO' => $valor['id10'],
											'TM_DESC' => $valor['dec10']
											);											
                }
        }

        $this->output->set_output( json_encode( $diags ) );
    }	
	
	public function anexos_solicitudes_tc( $tel_id = '' ) {

        $datos = $this->platc_model->anexos_solicitudes_tc_get( (int)$tel_id );
		$arrayCups = "";
		if($datos){ foreach($datos as &$row){
				
				$cups = $this->platc_model->anexo_obtener_cups_lista((int)$tel_id);
				if($cups){ foreach($cups as $i => $c){
						$arrayCups[$i]['CUPS_DESC'] = substr($c['CUPS_DESC'],0,30)."...";
					}
				}
				else{
					$arrayCups[]['CUPS_DESC'] = "Sin Información";
				}
			}
		}
		if($arrayCups){
			$this->output->set_output(json_encode($arrayCups));
		}
		else{
			echo FALSE;
		}
    }	
	
	
	public function anexo_export_pdf( $id_tc='',$id_sol='' ) {
		
	    
		$datos = array();
        
		$tc = $this->platc_model->tc_get( (int)$id_tc );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
		$datos['anexo_data']   = $this->platc_model->anexo_get( (int)$tc['TEL_ID'] );
        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }
		$datos ['cups_list']    = $this->platc_model->anexo_obtener_cups_lista( (int)$tc['TEL_ID']);
		$datos ['diagnosticos_list']    = $this->platc_model->cie10_respuesta_get( (int)$tc['TEL_ID']);
        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
       // $datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
        //$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
		//$datos['establecimientos']  = $this->platc_model->establecimiento_data_get((int)$tc['ETB_ID']);
		

		$datos['guiaspracticas_list']    = $this->platc_model->guias_practicas_list_get();

		
    	$departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['paciente']['DEP_ID']);
		$datos['data_depto_paciente']=$departamento_data;
		
		$municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['paciente']['MUNI_ID']);
		$datos['data_munic_paciente']=$municipio_data;

        $entidad_adm_data = $this->platc_model->get_info_entidad_administradora($datos['paciente']['EA_ID']);
		$datos['data_entadm_paciente']=$entidad_adm_data;
		
		$establecimiento_data = $this->platc_model->get_info_table_param('TC_ESTABLECIMIENTO','ETB_ID',(int)$tc['ETB_ID']);
		$datos['data_establecimiento']=$establecimiento_data;
		
		
        $establec_departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['data_establecimiento']['ETB_DPTO_ID']);
		$datos['data_depto_establec']=$establec_departamento_data;
		
		$establec_municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['data_establecimiento']['ETB_MUNI_ID']);
		$datos['data_munic_establec']=$establec_municipio_data;
        
		/*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );


		$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
		$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";


        $RecDetalle=$this->load->view( 'forms/anexo_export', $datos, true );

		$html='';
		$html.='<html><head>  
		<style type="text/css">
			  body {overflow-x:hidden !important;
			    color:#666666;
				background: #FFFFFF;
				font-family: Lato Helvetica Neue, Lucida Grande, Arial, Verdana, sans-serif;
				font-size: 10px;
				font-style: normal;
				height: 100%;
				width: 100%;} 
				#receta table, #formula table, #receta_respuesta table { width: 100%;}
			   .texto_item{
				   color:#5155AA;
				   font-size: 10px;
				   background: #DDDDFF;
				  }
			   .texto_item2{
				   font-size: 10px;
				  }
			   .titulo{
				   background: #5155AA;
				   color:#FFFFFF;
				   font-size: 10px;
				  }
        </style>
		</head><body>';
	    $html.= $RecDetalle;
		$html.='</body></html>';

		$this->load->library('dompdf_gen');
		$this->dompdf->load_html(utf8_decode($html));
		$this->dompdf->render();
		$this->dompdf->stream("anexo_to_pdf.pdf");
	}
	
	public function anexo_ver( $id_tc='' ) {
		
	    
		$datos = array();
        
		$tc = $this->platc_model->tc_get( (int)$id_tc );
        $datos['tc']            = $tc;
        $datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
		$datos['anexo_data']   = $this->platc_model->anexo_get( (int)$tc['TEL_ID'] );
        // Agrega códigos CIE10
        if( !empty( $datos['tc']['data']['dm_general'] ) ) {
            $cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['data']['dm_general'] ) );
            $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
            unset( $cie_id[''] ); // Elimina elemento vacío
            $datos['tc']['data']['dm_general'] = $cie_id;
        }
		$datos ['cups_list']    = $this->platc_model->anexo_obtener_cups_lista( (int)$tc['TEL_ID']);
		$datos ['diagnosticos_list']    = $this->platc_model->cie10_respuesta_get( (int)$tc['TEL_ID']);
        /*
         * Datos del paciente
         */
        $datos['paciente']      = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
        $datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
       // $datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
        //$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
		//$datos['establecimientos']  = $this->platc_model->establecimiento_data_get((int)$tc['ETB_ID']);
		

		$datos['guiaspracticas_list']    = $this->platc_model->guias_practicas_list_get();

		
    	$departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['paciente']['DEP_ID']);
		$datos['data_depto_paciente']=$departamento_data;
		
		$municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['paciente']['MUNI_ID']);
		$datos['data_munic_paciente']=$municipio_data;

        $entidad_adm_data = $this->platc_model->get_info_entidad_administradora($datos['paciente']['EA_ID']);
		$datos['data_entadm_paciente']=$entidad_adm_data;
		
		$establecimiento_data = $this->platc_model->get_info_table_param('TC_ESTABLECIMIENTO','ETB_ID',(int)$tc['ETB_ID']);
		$datos['data_establecimiento']=$establecimiento_data;
		
		
        $establec_departamento_data = $this->platc_model->get_info_table_param('TC_DEPARTAMENTO_D','DPTO_ID',$datos['data_establecimiento']['ETB_DPTO_ID']);
		$datos['data_depto_establec']=$establec_departamento_data;
		
		$establec_municipio_data = $this->platc_model->get_info_table_param('TC_MUNICIPIO_M','MUN_ID',$datos['data_establecimiento']['ETB_MUNI_ID']);
		$datos['data_munic_establec']=$establec_municipio_data;
        
		/*
         * Datos médico Generalista (Profesional que remite el caso)
         */
        $datos['generalista'] = null;

        $historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
        foreach( $historia as $v ) {
            $u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
            if( (int)$u['ROL_ID'] == 4 ) {
                $datos['generalista'] = $u;
                $datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
            }
        }

        // Datos médico Especialista (Profesional)
        $datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
        $datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );


		$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
		$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";

		$this->load->view( 'forms/anexo_export', $datos);
	}
	   
	//------ END  ANEXO 3
	
	//NO POS
	public function crear_formula_no_pos($tel_id = ''){
		if($tel_id){
			$this->load->model('tc_formula_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;

			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}

			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			$this->load->view('no_pos/formula_no_pos_view',$datos);
		}
		else{
			echo FALSE;
		}
	}
	public function guardar_formula_no_pos(){
		if($_POST){
			$this->load->model('tc_formula_no_pos_model');
			
			if($_POST['form_id']){
				$update = array(
					'FM_RESUMEN_HISTORIA' => $_POST['resumenHistoria'],
					'FM_GENERA_RIESGO' => $_POST['riegoPaciente'],
					'FM_RESPUESTA_CLINICA' => $_POST['respuestaClinica'],
					'FM_JUSTIFICACION' => $_POST['justificacionMedicamento'],
					'FM_EFECTO_TERAPEUTICO' => $_POST['efectoTerapeutico'],
					'FM_EFECTOS_ADVERSOS' => $_POST['efectosAdversos']
				);
				if($this->tc_formula_no_pos_model->update(array('FM_ID' => $_POST['form_id']), $update)){
					$update = array(
						'MFN_PRINCIPIO_ACTIVO' => $_POST['medicamentoPrincipioActivoNoPos'],
						'MFN_GRUPO' => $_POST['medicamentoGrupoNoPos'],
						'MFN_CONCENTRACION' => $_POST['medicamentoConcentracionNoPos'],
						'MFN_FORMA' => $_POST['medicamentoFormaNoPos'],
						'MFN_DOSIS' => $_POST['medicamentoDosisNoPos'],
						'MFN_DIAS_TRATAMIENTO' => $_POST['medicamentoDiasNoPos']
					);
					$this->tc_formula_no_pos_model->update_no_pos(array('MFN_FM_ID' => $_POST['form_id']), $update);
					$update = array(
						'MF_NOMBRE' => $_POST['medicamentoNombrePos'],
						'MF_CANTIDAD' => $_POST['medicamentoCantidadPos'],
						'MF_DOSIS' => $_POST['medicamentoDosisPos'],
						'MF_POSOLOGIA' => $_POST['medicamentoPosologiaPos'],
						'MF_TIEMPO' => $_POST['medicamentoTiempoPos']
					);
					$this->tc_formula_no_pos_model->update_pos(array('MF_FM_ID' => $_POST['form_id']), $update);
					$resp = array('msgt' => 'false',
								  'msg'  => 'false',
								  'action' => 'true'
								  );
				}
				else{
					$resp = array('msgt' => 'ERROR',
								  'msg'  => 'false',
								  'action' => 'false'
								  );
				}
			}
			else{
				$insert = array(
					'FM_TEL_ID' => $_POST['tel_id'],
					'FM_RESUMEN_HISTORIA' => $_POST['resumenHistoria'],
					'FM_GENERA_RIESGO' => $_POST['riegoPaciente'],
					'FM_RESPUESTA_CLINICA' => $_POST['respuestaClinica'],
					'FM_JUSTIFICACION' => $_POST['justificacionMedicamento'],
					'FM_EFECTO_TERAPEUTICO' => $_POST['efectoTerapeutico'],
					'FM_EFECTOS_ADVERSOS' => $_POST['efectosAdversos']
				);
				if($lastId = $this->tc_formula_no_pos_model->insert($insert)){
					$insert = array(
						'MFN_FM_ID' => $lastId,
						'MFN_PRINCIPIO_ACTIVO' => $_POST['medicamentoPrincipioActivoNoPos'],
						'MFN_GRUPO' => $_POST['medicamentoGrupoNoPos'],
						'MFN_CONCENTRACION' => $_POST['medicamentoConcentracionNoPos'],
						'MFN_FORMA' => $_POST['medicamentoFormaNoPos'],
						'MFN_DOSIS' => $_POST['medicamentoDosisNoPos'],
						'MFN_DIAS_TRATAMIENTO' => $_POST['medicamentoDiasNoPos']
					);
					$this->tc_formula_no_pos_model->insert_no_pos($insert);
					$insert = array(
						'MF_FM_ID' => $lastId,
						'MF_NOMBRE' => $_POST['medicamentoNombrePos'],
						'MF_CANTIDAD' => $_POST['medicamentoCantidadPos'],
						'MF_DOSIS' => $_POST['medicamentoDosisPos'],
						'MF_POSOLOGIA' => $_POST['medicamentoPosologiaPos'],
						'MF_TIEMPO' => $_POST['medicamentoTiempoPos']
					);
					$this->tc_formula_no_pos_model->insert_pos($insert);
					$resp = array('msgt' => 'false',
								  'msg'  => 'false',
								  'action' => 'true'
								  );
				}
				else{
					$resp = array('msgt' => 'ERROR',
								  'msg'  => 'false',
								  'action' => 'false'
								  );
				}
			}
		}
		else{
			$resp = array('msgt' => 'ERROR',
						  'msg'  => 'false',
						  'action' => 'false'
						  );
		}
	
		$this->output->set_output(json_encode($resp));
	}
	public function listarMedicamentosNoPos(){
		if($_POST['t']){
			$this->load->model('tc_formula_no_pos_model');
			$query = $this->tc_formula_no_pos_model->select(array('FM_TEL_ID' => $_POST['t']));
			if($query){
				foreach($query as $row){
					$medicamento = $this->tc_formula_no_pos_model->select_no_pos(array('MFN_FM_ID' => $row['FM_ID']));
					$data[] = array(
						'FM_ID' => $row['FM_ID'],
						'FM_FECHA' => date('d-m-Y',strtotime($row['FM_FECHA'])),
						'MFN_PRINCIPIO_ACTIVO' => $medicamento[0]['MFN_PRINCIPIO_ACTIVO']
					);
				}
				echo json_encode($data);
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
	public function editar_formula_no_pos($tel_id = '', $form_id = ''){
		if($tel_id && $form_id){
			$this->load->model('tc_formula_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;
			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}
			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			//Medicamentos
			$datos['formula'] = $this->tc_formula_no_pos_model->select(array('FM_ID' => $form_id));
			$datos['medicamentos_pos'] = $this->tc_formula_no_pos_model->select_pos(array('MF_FM_ID' => $form_id));
			$datos['medicamentos_no_pos'] = $this->tc_formula_no_pos_model->select_no_pos(array('MFN_FM_ID' => $form_id));
			$this->load->view('no_pos/formula_no_pos_view',$datos);
		}
		else{
			echo FALSE;
		}
	}
	public function ver_formula_no_pos($tel_id = '', $form_id = ''){
		if($tel_id && $form_id){
			$this->load->model('tc_formula_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;
			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}
			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			//Medicamentos
			$datos['formula'] = $this->tc_formula_no_pos_model->select(array('FM_ID' => $form_id));
			$datos['medicamentos_pos'] = $this->tc_formula_no_pos_model->select_pos(array('MF_FM_ID' => $form_id));
			$datos['medicamentos_no_pos'] = $this->tc_formula_no_pos_model->select_no_pos(array('MFN_FM_ID' => $form_id));
			$this->load->view('no_pos/formula_no_pos_print_view',$datos);
		}
		else{
			echo FALSE;
		}
	}
	public function eliminar_formula_no_pos(){
		if($_POST['form_id']){
			$this->load->model('tc_formula_no_pos_model');
			$this->tc_formula_no_pos_model->delete_no_pos(array('MFN_FM_ID' => $_POST['form_id']));
			$this->tc_formula_no_pos_model->delete_pos(array('MF_FM_ID' => $_POST['form_id']));
			$this->tc_formula_no_pos_model->delete(array('FM_ID' => $_POST['form_id']));
			echo TRUE;
		}
		else{
			echo FALSE;
		}
	}
	public function imprimir_formula_no_pos($tel_id = '',$form_id = '') {
		if($tel_id && $form_id){
			$this->load->model('tc_formula_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;
			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}
			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			//Medicamentos
			$datos['formula'] = $this->tc_formula_no_pos_model->select(array('FM_ID' => $form_id));
			$datos['medicamentos_pos'] = $this->tc_formula_no_pos_model->select_pos(array('MF_FM_ID' => $form_id));
			$datos['medicamentos_no_pos'] = $this->tc_formula_no_pos_model->select_no_pos(array('MFN_FM_ID' => $form_id));
			
			$RecDetalle = $this->load->view('no_pos/formula_no_pos_print_view',$datos,TRUE);
			
			$html='';
			$html.='<html><head>  
			<style type="text/css">
				  body {
					font-family: Lato Helvetica Neue, Lucida Grande, Arial, Verdana, sans-serif;
					font-size: 9px;
					width:100%;
					text-align: center;
				  }
				  .titulo {
					  font-size: 11px;
				  }
			</style>
			</head><body>';

			$html.= $RecDetalle;
			$html.='</body></html>';
			
			$this->load->library('dompdf_gen');
			$this->dompdf->load_html(utf8_decode($html));
			$this->dompdf->render();
			$this->dompdf->stream("Solicitud_Medicamentos_".$form_id.".pdf");
		}
		else{
			echo FALSE;
		}
	}
	
	//RECETA NO POS
	public function crear_receta_no_pos($tel_id = ''){
		if($tel_id){
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc'] = $tc;
			$datos['tc']['data'] = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;

			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}

			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );

			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			$this->load->view('no_pos/receta_no_pos_view',$datos);
		}
		else{
			echo FALSE;
		}
	}
	public function guardar_receta_no_pos(){
		if($_POST){
			$this->load->model('tc_receta_no_pos_model');
			
			if($_POST['rec_id']){
				$update = array(
					'RC_RESUMEN_HISTORIA' => $_POST['resumenHistoria'],
					'RC_JUSTIFICACION' => $_POST['justificacionServicio'],
					'RC_REPETIR' => ((isset($_POST['motivoPrestacionNA']) && $_POST['motivoPrestacionNA']) ? 1 : 0),
					'RC_REPETIR_MOTIVO' => $_POST['motivoPrestacion'],
					'RC_OBJETIVO_SERVICIO' => $_POST['objetivoServicio']
				);
				if($this->tc_receta_no_pos_model->update(array('RC_ID' => $_POST['rec_id']), $update)){
					$update = array(
						'RCN_NOMBRE' => $_POST['prestacionNoPos'],
						'RCN_FRECUENCIA' => $_POST['frecuenciaUso'],
						'RCN_CANTIDAD' => $_POST['cantidadSolicitada'],
						'RCN_DIAS_TRATAMIENTO' => $_POST['diasTratamiento']
					);
					$this->tc_receta_no_pos_model->update_no_pos(array('RCN_RC_ID' => $_POST['rec_id']), $update);
					$update = array(
						'RCP_NOMBRE' => $_POST['prestacionPos']
					);
					$this->tc_receta_no_pos_model->update_pos(array('RCP_RC_ID' => $_POST['rec_id']), $update);
					$resp = array('msgt' => 'false',
								  'msg'  => 'false',
								  'action' => 'true'
								  );
				}
				else{
					$resp = array('msgt' => 'ERROR',
								  'msg'  => 'false',
								  'action' => 'false'
								  );
				}
			}
			else{
				$insert = array(
					'RC_TEL_ID' => $_POST['tel_id'],
					'RC_RESUMEN_HISTORIA' => $_POST['resumenHistoria'],
					'RC_JUSTIFICACION' => $_POST['justificacionServicio'],
					'RC_REPETIR' => ((isset($_POST['motivoPrestacionNA']) && $_POST['motivoPrestacionNA']) ? 1 : 0),
					'RC_REPETIR_MOTIVO' => $_POST['motivoPrestacion'],
					'RC_OBJETIVO_SERVICIO' => $_POST['objetivoServicio']
				);
				if($lastId = $this->tc_receta_no_pos_model->insert($insert)){
					$insert = array(
						'RCN_RC_ID' => $lastId,
						'RCN_NOMBRE' => $_POST['prestacionNoPos'],
						'RCN_FRECUENCIA' => $_POST['frecuenciaUso'],
						'RCN_CANTIDAD' => $_POST['cantidadSolicitada'],
						'RCN_DIAS_TRATAMIENTO' => $_POST['diasTratamiento']
					);
					$this->tc_receta_no_pos_model->insert_no_pos($insert);
					$insert = array(
						'RCP_RC_ID' => $lastId,
						'RCP_NOMBRE' => $_POST['prestacionPos']
					);
					$this->tc_receta_no_pos_model->insert_pos($insert);
					$resp = array('msgt' => 'false',
								  'msg'  => 'false',
								  'action' => 'true'
								  );
				}
				else{
					$resp = array('msgt' => 'ERROR',
								  'msg'  => 'false',
								  'action' => 'false'
								  );
				}
			}
		}
		else{
			$resp = array('msgt' => 'ERROR',
						  'msg'  => 'false',
						  'action' => 'false'
						  );
		}
	
		$this->output->set_output(json_encode($resp));
	}
	public function listarRecetasNoPos(){
		if($_POST['t']){
			$this->load->model('tc_receta_no_pos_model');
			$query = $this->tc_receta_no_pos_model->select(array('RC_TEL_ID' => $_POST['t']));
			if($query){
				foreach($query as $row){
					$receta = $this->tc_receta_no_pos_model->select_no_pos(array('RCN_RC_ID' => $row['RC_ID']));
					$data[] = array(
						'RC_ID' => $row['RC_ID'],
						'RC_FECHA' => date('d-m-Y',strtotime($row['RC_FECHA'])),
						'RCN_NOMBRE' => $receta[0]['RCN_NOMBRE']
					);
				}
				echo json_encode($data);
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
	public function editar_receta_no_pos($tel_id = '', $rec_id = ''){
		if($tel_id && $rec_id){
			$this->load->model('tc_receta_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;
			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}
			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			//Medicamentos
			$datos['receta'] = $this->tc_receta_no_pos_model->select(array('RC_ID' => $rec_id));
			$datos['procedimientos_pos'] = $this->tc_receta_no_pos_model->select_pos(array('RCP_RC_ID' => $rec_id));
			$datos['procedimientos_no_pos'] = $this->tc_receta_no_pos_model->select_no_pos(array('RCN_RC_ID' => $rec_id));
			$this->load->view('no_pos/receta_no_pos_view',$datos);
		}
		else{
			echo FALSE;
		}
	}
	public function ver_receta_no_pos($tel_id = '', $rec_id = ''){
		if($tel_id && $rec_id){
			$this->load->model('tc_receta_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;
			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}
			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			//Medicamentos
			$datos['receta'] = $this->tc_receta_no_pos_model->select(array('RC_ID' => $rec_id));
			$datos['procedimientos_pos'] = $this->tc_receta_no_pos_model->select_pos(array('RCP_RC_ID' => $rec_id));
			$datos['procedimientos_no_pos'] = $this->tc_receta_no_pos_model->select_no_pos(array('RCN_RC_ID' => $rec_id));
			$this->load->view('no_pos/receta_no_pos_print_view',$datos);
		}
		else{
			echo FALSE;
		}
	}
	public function eliminar_receta_no_pos(){
		if($_POST['rec_id']){
			$this->load->model('tc_receta_no_pos_model');
			$this->tc_receta_no_pos_model->delete_no_pos(array('RCN_RC_ID' => $_POST['rec_id']));
			$this->tc_receta_no_pos_model->delete_pos(array('RCP_RC_ID' => $_POST['rec_id']));
			$this->tc_receta_no_pos_model->delete(array('RC_ID' => $_POST['rec_id']));
			echo TRUE;
		}
		else{
			echo FALSE;
		}
	}
	
	public function imprimir_receta_no_pos($tel_id = '',$rec_id = '') {
		if($tel_id && $rec_id){
			$this->load->model('tc_receta_no_pos_model');
			$datos = array();
			$tc = $this->platc_model->tc_get( (int)$tel_id );
			$datos['tc']            = $tc;
			$datos['tc']['data']    = $this->platc_model->tc_obtener_data( (int)$tc['TEL_ID'] );
			// Agrega códigos CIE10
			if( !empty( $datos['tc']['data']['dm_general'] ) ) {
				$cie_id = $this->platc_model->cie10_get( json_decode( $datos['tc']['TEL_CIE_ID_RESPUESTA'] ) );
				$cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
				unset( $cie_id[''] ); // Elimina elemento vacío
				$datos['tc']['data']['dm_general'] = $cie_id;
			}
			// Datos del paciente
			$datos['paciente'] = $this->platc_model->paciente_get( (int)$tc['PAC_ID'] );
			$datos['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get( (int)$tc['PAC_ID'] );
			$datos['municipio']     = $this->platc_model->municipio_get( (int)$tc['MUNI_ID'] );
			$datos['entidad_administradora']    = $this->platc_model->entidad_administradora_get( (int)$tc['ENTADM_ID'] );
			/*
			 * Datos médico Generalista (Profesional que remite el caso)
			 */
			$datos['generalista'] = null;
			$historia = $this->platc_model->tc_historia( (int)$tc['TEL_ID'], 2 );   //2: Estado enviada/nueva
			foreach( $historia as $v ) {
				$u = $this->platc_model->usuario_get( (int)$v['USU_ID'] );
				if( (int)$u['ROL_ID'] == 4 ) {
					$datos['generalista'] = $u;
					$datos['generalista_identificacion'] = $this->platc_model->identificador_get( (int)$u['IDT_ID'] );
				}
			}
			// Datos médico Especialista (Profesional)
			$datos['especialista']  = $this->platc_model->usuario_get( (int)$this->session->userdata['USU_ID'] );
			$datos['especialista_identificacion'] = $this->platc_model->identificador_get( $datos['especialista']['IDT_ID'] );
			$datos['logoItms'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/itms.jpg')) ? "itms.jpg" : "";
			$datos['logoCliente'] = (file_exists(dirname($_SERVER['SCRIPT_FILENAME']).'/images/clientes/'.$tc['CLI_IMAGEN_INSTITUCIONAL'])) ? $tc['CLI_IMAGEN_INSTITUCIONAL'] : "";
			//Medicamentos
			$datos['receta'] = $this->tc_receta_no_pos_model->select(array('RC_ID' => $rec_id));
			$datos['procedimientos_pos'] = $this->tc_receta_no_pos_model->select_pos(array('RCP_RC_ID' => $rec_id));
			$datos['procedimientos_no_pos'] = $this->tc_receta_no_pos_model->select_no_pos(array('RCN_RC_ID' => $rec_id));
			
			$RecDetalle = $this->load->view('no_pos/receta_no_pos_print_view',$datos,TRUE);
			
			$html='';
			$html.='<html><head>  
			<style type="text/css">
				  body {
					font-family: Lato Helvetica Neue, Lucida Grande, Arial, Verdana, sans-serif;
					font-size: 9px;
					width:100%;
					text-align: center;
				  }
				  .titulo {
					  font-size: 11px;
				  }
			</style>
			</head><body>';

			$html.= $RecDetalle;
			$html.='</body></html>';
			
			$this->load->library('dompdf_gen');
			$this->dompdf->load_html(utf8_decode($html));
			$this->dompdf->render();
			$this->dompdf->stream("Solicitud_".$rec_id.".pdf");
		}
		else{
			echo FALSE;
		}
	}
	//FIN
	
	
	public function get_entidad_adm_m($withconc=''){
		if($_POST["afiliacion"]){
			//$this->load->model("cliente_model");
			$data = $this->platc_model->select_entidad_administra($_POST["afiliacion"]);
			if($data){
				$option = "<option value=''>Seleccione...</option>";
				foreach($data as $row){
					if ($withconc!='') {
                        $option .= "<option value='".trim($row->ENTADM_CORR)."'>".(($row->ENTADM_ID) ? trim($row->ENTADM_ID). ' - '.trim($row->ENTADM_NOMBRE) : trim($row->ENTADM_NOMBRE))."</option>";
					}else{
					   $option .= "<option value='".trim($row->ENTADM_CORR)."'>".trim($row->ENTADM_NOMBRE)."</option>";
					}
				}
				echo $option;
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
	
	
	public function get_municipios_m(){

		if($_POST["departamentos"]){
			$this->load->model("cliente_model");
			$data = $this->platc_model->select_municipios($_POST["departamentos"]);
			if($data){
				$option = "<option value=''>Seleccione...</option>";
				foreach($data as $row){
					$option .= "<option value='".trim($row->MUN_ID)."'>".trim($row->MUN_NOMBRE)."</option>";
				}
				echo $option;
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
	
	// JV 25-09-2015
	public function update_ficha_paciente()
	{
		if($_POST["pac_id"])
		{
			if($this->input->post('afiliacion') != "")
				$data['AFI_ID']		= $this->input->post('afiliacion');
			if($this->input->post('entidad_administra') != "")
				$data['EA_ID']		= $this->input->post('entidad_administra');
			if($this->input->post('departamentos') != "")
				$data['DEP_ID']		= $this->input->post('departamentos');
			if($this->input->post('municipio') != "")
				$data['MUNI_ID']	= $this->input->post('municipio');
			
			$data = $this->platc_model->update_ficha_paciente($_POST["pac_id"],$data);
			if($data){
				echo TRUE;
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
	
	 public function tc_autoguardar_responder_anexo( ) {
		$cups_codigo = $this->input->post( 'cups_codigo' );
        if(empty($cups_codigo)){
            echo FALSE;
        }else{
            //imprimir ($this->input->post( $cups_post ),false);

            //GRABAMOS DATOS GENERALES ANEXO 3
    		$this->input->post('axo_4_sersol_origen')=='on' ? $id_sersol_origen='1' : $id_sersol_origen='0';
    		$this->input->post('axo_4_sersol_tipo')=='on' ? $id_sersol_tipo='1' : $id_sersol_tipo='0';
    		$this->input->post('axo_4_sersol_priori')=='on' ? $id_sersol_prio='1' : $id_sersol_prio='0';
    		$this->input->post('axo_4_sersol_ubicapac')=='on' ? $id_sersol_ubicpac='1' : $id_sersol_ubicpac='0';
    		$data['AXO_SERV_ORIG_COD']    = $id_sersol_origen;
    		$data['AXO_SERV_TIPO_COD']    = $id_sersol_tipo;
    		$data['AXO_SERV_PRIO_COD']    = $id_sersol_prio;
    		$data['AXO_SERV_UBICPAC_COD'] = $id_sersol_ubicpac;

            $data['AXO_SERV_SERVICIO']        = $this->input->post('axo_4_sersol_servicio');
            $data['AXO_SERV_CAMA']            = $this->input->post('axo_4_sersol_cama');
    		$data['AXO_SERV_JUSTIFICA']       = $this->input->post('axo_4_sersol_justif');
    		$data['AXO_SERV_GUIAPRACT_OBS']   = ($this->input->post('axo_guiapract_obs')) ? $this->input->post('axo_guiapract_obs') : "";
    		$data['AXO_SERV_GUIAPRACT_COD']   = $this->input->post('axo_guiapract');
    		
    		
    		$data['AXO_TEL_ID']           = $this->input->post('axo_tel_id');
    		$axo_tel_id                   = $this->input->post('axo_tel_id');
    	    $arr_axo_dm_general           = $this->input->post('axo_dm_general');

            if($this->platc_model->tc_save_axo( $data,$axo_tel_id )){
    		
    		 // Ciclo que recoge información de los cups
    			$this->platc_model->cups_eliminar($axo_tel_id);
    			if ($this->input->post('tm_id') ){
    			
    				$cups = array( );
    				$listado_cups_post = array( 'tm_id','cups_codigo','cups_cant','cups_desc' );
    				foreach( $listado_cups_post as $cups_post ) {
    					foreach( $this->input->post( $cups_post ) as $k => $v ) {
    						$cups[ $k ][ $cups_post ] = $v;
    					}
    				}
    				foreach( $cups as $v ) {
    					$this->platc_model->anexo_cups_crear($axo_tel_id,$v['tm_id'],$v['cups_codigo'],$v['cups_cant'],$v['cups_desc'] );
    				}
    			}
    			// Ciclo Diagnosticos 
    			if ($this->input->post('tm_idd') ){
    				
    				$arrCie10Post = "";
    				$arrCie10Ant = "";
    				$arr_axo_dm = array();
    				foreach($this->input->post('tm_idd') as $v){
    					$arrCie10Post[] = $v;
    				}
    				$arr_axo_dm= explode(",",$arr_axo_dm_general);
    				$arrCie10Ant = json_encode($arr_axo_dm);
    				$arrCie10Post = json_encode($arrCie10Post);

    				$arrConcatdiag = json_encode(array_merge(json_decode($arrCie10Ant, true),json_decode($arrCie10Post, true)));
    				$this->platc_model->upd_data_teleconsulta_data($axo_tel_id,$arrConcatdiag);
    		   }
    		   // start - Crea recetario a partir de Anexo 3
                $tel_id                = $this->input->post('axo_tel_id');
            $tipo                   = Platc::$RECETARIO_TIPO['RECETA'];
            $id_medico_generalista  = $this->input->post('id_medico_generalista');
            $id_medico_especialista = $this->input->post('id_medico_especialista');
            $paciente_telefono      = $this->input->post('recetario_telefono');
            $paciente_id_municipio  = $this->input->post('recetario_id_municipio');
            $paciente_direccion_residencia = $this->input->post('recetario_direccion_residencia');


            $this->platc_model->recetario_eliminar_por_tc_id($tel_id);

            $rec_id = $this->platc_model->recetario_crear(
                                                            $tel_id,//$tel_id
                                                            $tipo,//$tipo
                                                            $id_medico_generalista,
                                                            $id_medico_especialista,
                                                            $paciente_telefono,
                                                            $paciente_id_municipio,
                                                            $paciente_direccion_residencia,
                                                            '',
                                                            '',
                                                            ''
                                                        );
           // End - Crea recetario a partir de Anexo 3
           
           // Ciclo que recoge información de las solicitudes
            if($cups){
                foreach( $cups as $v ) {
                    $this->platc_model->recetario_solicitudes_crear($rec_id,$v['cups_desc'] );
                }
            }

        //Fin
    		   echo TRUE;
    		}
    		else{
    			echo FALSE;
    		}
        }
    }
}
