<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

$form = array(  'method' => 'post',
                'name' => 'add_agenda_form',
                'id' => 'add_agenda_form');

$form_bloqueo_por_intervalo = array('method' => 'post',
                                    'name'  => 'add_agenda_bloqueo_form',
                                    'id'    => 'add_agenda_bloqueo_form');

$descripcion_inpt = array(  'name' => 'descripcion',
                            'id' => 'descripcion',
                            'type' => 'text',
                            'rows' => '2',
                            'cols' => '30',
                            'value' => $agenda['AGEDEF_DESCRIPCION'],
                            'class' => 'text-input');
$hora_inicio_inpt = array(  'name' => 'hora_inicio',
                            'id' => 'hora_inicio',
                            'type' => 'text',
                            'maxlength' => '5',
                            'value' => $agenda['AGEDEF_HORA_INICIO'],
                            'class' => 'validate[required] text-input',
                            'size' => '5');
$hora_fin_inpt = array( 'name' => 'hora_fin',
                        'id' => 'hora_fin',
                        'type' => 'text',
                        'maxlength' => '5',
                        'value' => $agenda['AGEDEF_HORA_FIN'],
                        'class' => 'validate[required] text-input',
                        'size' => '5');
$intervalo = array('5' => '5', '10' => '10', '15' => '15', '20' => '20', '30' => '30',
                    '45' => '45', '60' => '60');
$agenda_id = array( 'name' => 'agenda_id',
                            'id' => 'agenda_id',
                            'type' => 'hidden',
                            'value' => $agenda['AGEDEF_ID']);
$agenda_bloqueo_id = array( 'name' => 'agenda_bloqueo_id',
                            'id' => 'agenda_bloqueo_id',
                            'type' => 'hidden',
                            'value' => empty( $agenda_bloqueo['AGEBLO_ID'] )? null : $agenda_bloqueo['AGEBLO_ID'] );
$fecha_inicio_inpt = array( 'name' => 'fecha_inicio',
                            'id' => 'fecha_inicio',
                            'type' => 'text',
                            'maxlength' => '50',
                            'value' => $this->util->fecha_orden( $agenda['AGEDEF_FECHA_INI'] ),
                            'class' => 'validate[required] text-input',
                            'size' => '20');
$fecha_fin_inpt = array('name' => 'fecha_fin',
                        'id' => 'fecha_fin',
                        'type' => 'text',
                        'maxlength' => '50',
                        'value' => $this->util->fecha_orden( $agenda['AGEDEF_FECHA_FIN'] ),
                        'class' => 'validate[required] text-input',
                        'size' => '20');
$guardar_butn = array( 'name' => 'button',
                        'id' => 'button',
                        'type' => 'submit',
                        'class' => 'boton_guardar',
                        'content' => $this->lang->line( 'guardar' ) );
$eliminar_butn = array( 'name' => 'del_button',
                        'id' => 'del_button',
                        'type' => 'button',
                        'class' => 'boton_eliminar',
                        'content' => $this->lang->line( 'eliminar' ) );

$bloqueo_por_intervalo_agregar_boton = array( 'name' => 'button',
                                'id' => 'button',
                                'type' => 'submit',
                                'class' => 'boton_aceptar',
                                'content' => 'Establecer bloqueos');
$bloqueo_dias = array(  1 => $this->lang->line('lunes'),
                        2 => $this->lang->line('martes'),
                        3 => $this->lang->line('miercoles'),
                        4 => $this->lang->line('jueves'),
                        5 => $this->lang->line('viernes'),
                        6 => $this->lang->line('sabado'),
                        7 => $this->lang->line('domingo') );

/*
 * Bloqueo por día
 */

$form_bloqueo_por_fecha = array(  'method' => 'post',
                                'name'  => 'form_bloqueo_por_fecha',
                                'id'    => 'form_bloqueo_por_fecha');

$bloqueo_por_fecha_agregar_boton = array( 'name'  => 'button',
                                        'id'    => 'button',
                                        'type'  => 'submit',
                                        'class' => 'boton_aceptar',
                                        'content' => 'Establecer bloqueos');
?>
<style>
/*    .bloqueo_horas {
    background: none repeat scroll 0 0 #FFFFFF;
    border: 1px solid #CCC;
    display: none;
    font-family: 'Strait',sans-serif;
    height: 61px;
    margin-left: -90px;
    margin-top: 5px;
    position: absolute;
    width: 400px;
    z-index: 9999;
    -webkit-box-shadow: 0 10px 6px -6px #777;
    -moz-box-shadow: 0 10px 6px -6px #777;
    box-shadow: 0 10px 6px -6px #777;
}*/
    .ui-datepicker-trigger { vertical-align: middle; }
</style>

<script type="text/javascript" language="javascript" >

    dayNames = [	'<?=$this->lang->line('domingo')?>',
                    '<?=$this->lang->line('lunes')?>',
                    '<?=$this->lang->line('martes')?>',
                    '<?=$this->lang->line('miercoles')?>',
                    '<?=$this->lang->line('jueves')?>',
                    '<?=$this->lang->line('viernes')?>',
                    '<?=$this->lang->line('sabado')?>'];
    dayNamesMin = [	'<?=$this->lang->line('dom')?>',
                    '<?=$this->lang->line('lun')?>',
                    '<?=$this->lang->line('mar')?>',
                    '<?=$this->lang->line('mie')?>',
                    '<?=$this->lang->line('jue')?>',
                    '<?=$this->lang->line('vie')?>',
                    '<?=$this->lang->line('sab')?>'];
    monthNames = [  '<?=$this->lang->line('enero')?>',
                    '<?=$this->lang->line('febrero')?>',
                    '<?=$this->lang->line('marzo')?>',
                    '<?=$this->lang->line('abril')?>',
                    '<?=$this->lang->line('mayo')?>',
                    '<?=$this->lang->line('junio')?>',
                    '<?=$this->lang->line('julio')?>',
                    '<?=$this->lang->line('agosto')?>',
                    '<?=$this->lang->line('septiembre')?>',
                    '<?=$this->lang->line('octubre')?>',
                    '<?=$this->lang->line('noviembre')?>',
                    '<?=$this->lang->line('diciembre')?>'];

    $.widget( "ui.timespinner", $.ui.spinner, {

        options: {
            // cada 10 minutos
            step: 60 * 10000,
            // hours
            page: 60
        },
        _parse: function( value ) {

            if ( typeof value === "string" ) {
                // already a timestamp
                if ( Number( value ) == value ) {
                    return Number( value );
                }
                return +Globalize.parseDate( value, "HH:mm" );
            }
            return value;
        },
        _format: function( value ) {

            return Globalize.format( new Date(value), "HH:mm" );
        }
    } );

    $(document).ready( function( ) {

        // Hora
        $('#hora_inicio').timespinner( );
        $('#hora_fin').timespinner( );

        // Fecha
        fecha = {   minDate: new Date( '01/01/2010' ),
                    showOn: 'button',
                    buttonImageOnly: true,
                    buttonImage: '<?=base_url()?>images/calendario.png',
                    dateFormat: "dd-mm-yy",
                    dayNames: dayNames,
                    dayNamesMin: dayNamesMin,
                    monthNames: monthNames,
                    firstDay: 1,
                    gotoCurrentType: true,
                    showOtherMonths: true,
                    selectOtherMonths: true
                };

        $('#fecha_inicio').datepicker( fecha );
        $('#fecha_fin').datepicker( fecha );

        // Envío de formulario usando ajax
        $('#add_agenda_form').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/agenda_edita/'+Math.random( ),
            success : false,
            failure : false
        } );

        // Envío de formulario usando ajax
        $('#add_agenda_bloqueo_form').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/agenda_agrega_bloqueo/'+Math.random( ),
            success : false,
            failure : false
        } );

        // Botón volver
        $('#volver').click( function( ){
            $('#deploy').load( '<?= base_url() ?>platc/agenda_resumen/'+Math.random( ) );
        } );

        // Elimina agenda
        $("#del_button").click( function() {
            jConfirm('&iquest;<?=$this->lang->line('eliminar_dialogo')?> ?', '<?=$this->lang->line('confirmacion')?>', function(r) {
                if (r == true) {
                    $.get('<?=base_url()?>platc/agenda_elimina/<?=$agenda['AGEDEF_ID']?>/'+Math.random(), function(data){
                        if(data == 'true') {
                            jAlert('<?=$this->lang->line('agenda_eliminar_ok')?>', 'OK');
                            $('#deploy').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                            $('#deploy').load('<?=base_url()?>platc/agenda_resumen/'+Math.random());
                        }
                        else {
                            jAlert('<?=$this->lang->line('agenda_eliminar_error')?>', 'ERROR');
                        }
                    });
                }
            });
        });

        // Bloqueo: marca filas de horas
        $('input:checkbox[id*="bloqueo_hora_fila_"]').click( function( ) {

            if( $(this).attr('checked') ) {
                $('input:checkbox[id*="bloqueo_hora_'+$(this).val()+'"]').attr( 'checked', 'checked' );
            } else {
                $('input:checkbox[id*="bloqueo_hora_'+$(this).val()+'"]').removeAttr( 'checked' );
            }
        } );

        //
        $('#bloqueo_marcar_todo').click( function( ) {

            if( $(this).attr('checked') ) {
                $('input:checkbox[id*="bloqueo_hora_"]').attr( 'checked', 'checked' );
            } else {
                $('input:checkbox[id*="bloqueo_hora_"]').removeAttr( 'checked' );
            }
        } );

        $('#button_agregar').click( function( ) {
            $('#contenedor_crear').show();
        } );

        /*
         * Bloqueo por día
         */

        // Envío de formulario usando ajax
        $('#form_bloqueo_por_fecha').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/agenda_agrega_bloqueo_por_fecha/'+Math.random( ),
            success : false,
            failure : false
        } );

        $('#bloqueo_por_fecha').datepicker( fecha );

        recargar_grilla_bloqueo_agendas( <?=$agenda['AGEDEF_ID']?> );
    } );

    function eliminar_bloqueo( id_agenda_bloqueo ) {

		jConfirm('<?=$this->lang->line('agenda_bloqueo_eliminar_confirmar')?>', '<?=html_entity_decode( $this->lang->line('confirmacion'), ENT_COMPAT, 'UTF-8' )?>', function(r) {
			if (r == true) {
				$.post(
                    '<?=base_url()?>platc/agenda_bloqueo_eliminar/'+Math.random(),
                    { id_agenda_bloqueo: id_agenda_bloqueo },
                    function(data){

                        if(data == 'true') {
                            jAlert('<?=$this->lang->line('agenda_bloqueo_eliminar_ok')?>', 'OK');
                            recargar_grilla_bloqueo_agendas( <?=$agenda['AGEDEF_ID']?> )
                        }
                        else {
                            jAlert('<?=$this->lang->line('agenda_bloqueo_eliminar_error')?>', 'OK');
                        }
				} );
			}
		});
    }

    function recargar_grilla_bloqueo_agendas( id_agenda ) {

        html = "<table id=\"grilla_bloqueos\"><tr><td></td></tr></table>";
        $('#div_grilla_bloqueos').slideDown();
        $('#div_grilla_bloqueos').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
        $('#div_grilla_bloqueos').html(html);
        $('#grilla_bloqueos').jqGrid( {
            url: "<?=base_url()?>platc/agenda_bloqueos_data_grid/"+parseInt( id_agenda ),
            datatype: "json",
            colNames: [ "&nbsp;", "<?=$this->lang->line('dias')?>",
                        "<?=$this->lang->line('horas')?>", "&nbsp;" ],
            colModel: [ {   name: "id_bloqueo", width: 40, align: "center", hidden: true },
                        {   name: "dias",
                            formatter : function( value, options, rData ) {

                                if( ( rData.AGEBLO_DIAS !== null || rData.AGEBLO_DIAS !== "" ) &&
                                    ( rData.AGEBLO_FECHA === null || rData.AGEBLO_FECHA === "" ) ) {
                                    
                                    dias = rData.AGEBLO_DIAS.split( "," );
                                    dias_c = new Array;
                                    for( i in dias ) {

                                        switch( parseInt( dias[i] ) ) {
                                            case 1 : dias_c.push( dayNames[1] ); break; //1: Lunes
                                            case 2 : dias_c.push( dayNames[2] ); break; //2: Martes
                                            case 3 : dias_c.push( dayNames[3] ); break; //3: Miércoles
                                            case 4 : dias_c.push( dayNames[4] ); break; //4: Jueves
                                            case 5 : dias_c.push( dayNames[5] ); break; //5: Viernes
                                            case 6 : dias_c.push( dayNames[6] ); break; //6: Sabado
                                            case 7 : dias_c.push( dayNames[0] ); break; //0: Domingo
                                        }
                                    }

                                    return dias_c.join( ", " );
                                }

                                if( ( rData.AGEBLO_DIAS === null || rData.AGEBLO_DIAS === "" ) &&
                                    ( rData.AGEBLO_FECHA !== null || rData.AGEBLO_FECHA !== "" ) ) {
                                    fecha = new Date( rData.AGEBLO_FECHA );
                                    f = ( ( fecha.getUTCDate() < 10 ) ? "0": "" )+fecha.getUTCDate()+"-";
                                    f+= ( ( fecha.getUTCMonth() < 10 ) ? "0": "" )+( fecha.getUTCMonth() +1 )+"-";
                                    f+= fecha.getFullYear();
                                    
                                    return f;
                                }
                            },
                            width: 300,
                            align: "center" },
                        {   name: "AGEBLO_HORAS", width: 400, align: "center" },
                        {   name: "desasociar", width: 20,
                            formatter: function( value, options, rData ) {
                                return "<img src=\"<?=base_url()?>images/drop.png\" onclick=\"eliminar_bloqueo("+parseInt( rData['AGEBLO_ID'] )+")\" />";
                            }
                        }
                    ]
        } );
    }
</script>

<?= form_open( '', $form) ?>
<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">

    <tr>
        <td align="left"><a href="#" id="volver"><img src="<?=base_url()?>images/volver.png" border="0" /></a></td>
    </tr>
    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line('agenda_editar') ?></td>
    </tr>
    <tr>
        <td><?=form_input($agenda_id)?>
            <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_fecha_inicio')?></td>
                    <td align="left"><?=form_input($fecha_inicio_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_fecha_fin')?></td>
                    <td align="left"><?=form_input($fecha_fin_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_hora_inicio')?></td>
                    <td align="left"><?=form_input($hora_inicio_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_hora_fin')?></td>
                    <td align="left"><?=form_input($hora_fin_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_hora_intervalo')?></td>
                    <td align="left"><?=form_dropdown('intervalo', $intervalo, $agenda['AGEDEF_INTERVALO'] )?> <?=$this->lang->line('agenda_intervalo_minutos')?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('rol_3')?> </td>
                    <td align="left"><?=form_dropdown( 'especialista', $especialistas, $agenda['USU_ID'], 'id="especialista" class="validate[required]"' )?></td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('agenda_descripcion')?> </td>
                    <td align="left"><?=form_textarea($descripcion_inpt)?></td>
                </tr>
                <tr>
                    <td align="right"><?=form_button($guardar_butn)?></td>
                    <td align="center"><?=form_button($eliminar_butn)?></td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<?=form_close()?>

<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">

    <!-- Bloqueo de agendas  -->
    <tr>
        <td align="left">&nbsp;</td>
    </tr>
    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line('agenda_bloqueo_titulo') ?></td>
    </tr>
    <tr>
        <td align="center">
            <div id="div_grilla_bloqueos" >
                <table id="grilla_bloqueos" > </table>
            </div>
        </td>
    </tr>
    <tr>
        <td style="text-align: center;">
            <button class="boton_crear" id="button_agregar" name="button_agregar"><?=$this->lang->line('agenda_bloqueo_agregar')?></button>
        </td>
    </tr>

    <!-- Formularios de bloqueos -->
    <tr>
        <td>
            <div id="contenedor_crear" style="display: none;">
                <?= form_open( '', $form_bloqueo_por_intervalo ) ?>
                <?=form_input($agenda_id)?> <?=form_input($agenda_bloqueo_id)?>
                <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td class="title_data_form"><?= $this->lang->line( 'agenda_bloqueo_por_intervalo' ) ?></td>
                        <td class="title_data_form2">(<span class="redtext">&nbsp;*&nbsp;</span>)&nbsp;<?= $this->lang->line( 'obligatorios' ) ?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('agenda_bloqueo_seleccione_dias')?></td>
                        <td align="left">
                            <input type="checkbox" id="bloqueo_dia_lunes"      name="bloqueo_dias[]" value="1"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '1', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_lunes"> <?=$this->lang->line('lunes')?> </label> <br/>

                            <input type="checkbox" id="bloqueo_dia_martes"     name="bloqueo_dias[]" value="2"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '2', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_martes"> <?=$this->lang->line('martes')?> </label> <br/>

                            <input type="checkbox" id="bloqueo_dia_miercoles"  name="bloqueo_dias[]" value="3"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '3', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_miercoles"> <?=$this->lang->line('miercoles')?> </label> <br/>

                            <input type="checkbox" id="bloqueo_dia_jueves"     name="bloqueo_dias[]" value="4"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '4', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_jueves"> <?=$this->lang->line('jueves')?> </label> <br/>

                            <input type="checkbox" id="bloqueo_dia_viernes"    name="bloqueo_dias[]" value="5"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '5', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_viernes"> <?=$this->lang->line('viernes')?> </label> <br/>

                            <input type="checkbox" id="bloqueo_dia_sabado"     name="bloqueo_dias[]" value="6"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '6', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_sabado"> <?=$this->lang->line('sabado')?> </label> <br/>

                            <input type="checkbox" id="bloqueo_dia_domingo"    name="bloqueo_dias[]" value="7"
                               <?php if( !empty( $agenda_bloqueo ) && array_search( '7', explode( ',', $agenda_bloqueo['AGEBLO_DIAS'] )  ) !== FALSE ) { ?>
                                   checked="checked"
                               <?php } ?>
                            /> <label for="bloqueo_dia_domingo"> <?=$this->lang->line('domingo')?> </label> <br/>
                        </td>
                    </tr>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('agenda_bloqueo_seleccione_horas')?></td>
                        <td align="left">
                            <input type="checkbox" id="bloqueo_marcar_todo"    name="bloqueo_marcar_todo" /> <label for="bloqueo_marcar_todo" style="font-weight: bold;"> <?=$this->lang->line('agenda_bloqueo_marcar_todo')?> </label> <br/>
                        </td>
                    </tr>

                    <tr>
                        <td >&nbsp;</td>
                        <td align="left">
                            <?php
                                /*
                                 * Lógica para generar listados de horas según intervalo definido
                                 * al crear la agenda. Transforma horas a minutos para así operar
                                 * con el intervalo en la misma unidad de medida (minutos). Se
                                 * transforma los minutos al momento de presentar hora calculada
                                 * al usuario.
                                 */

                                // Extrae cifras de hora de inicio y hora de fin
                                $hora_inicio = explode( ':', $agenda['AGEDEF_HORA_INICIO'] );
                                $hora_fin    = explode( ':', $agenda['AGEDEF_HORA_FIN'] ) ;

                                // Transforma horas a minutos
                                $inicio = ( $hora_inicio[0] * 60 ) + $hora_inicio[1];
                                $fin    = ( $hora_fin[0]    * 60 ) + $hora_fin[1];

                                // $hora_salto: variable para salto de línea
                                $hora_salto = $hora_inicio;

                                // $texto_[h|m]: Para crear hora legible al usuario: hora 8 y minuto 5 => 08:05
                                $texto_h = sprintf( "%02s", floor( $inicio/60 ) );  // floor( 9.87 ) = 9    // sprintf: antepone 0 = 09

                                // Ciclo para escribir valores de horas en intervalo
                                for( $intervalo = $inicio ; $intervalo < $fin ; $intervalo = $intervalo + $agenda['AGEDEF_INTERVALO'] ) {

                                    // $texto_[h|m]: Para crear hora legible al usuario: hora 8 y minuto 5 => 08:05
                                    $texto_h = sprintf( "%02s", floor( $intervalo/60 ) );  // floor( 9.87 ) = 9    // sprintf: antepone 0 = 09
                                    $texto_m = sprintf( "%02s", $intervalo%60 );           // operador %: resto (minutos)

                                    // Escribe un salto de línea por cada hora
                                    if( (int) $hora_salto != (int) $texto_h ) { ?>
                                        <br/>
                                        <input type="checkbox" id="bloqueo_hora_fila_<?=$texto_h?>_xx" value="<?=$texto_h?>"  />
                                        <label for="bloqueo_hora_fila_<?=$texto_h?>_xx" style="font-weight: bold;"> <?=$texto_h?>:XX </label>
                            <?php
                                        $hora_salto = $texto_h;
                                    }
                            ?>

                                    <input type="checkbox" id="bloqueo_hora_<?=$texto_h?>_<?=$texto_m?>"
                                           name="bloqueo_horas[]"
                                           value="<?=$texto_h?>:<?=$texto_m?>"
                                           <?php if( !empty( $agenda_bloqueo ) && array_search( $texto_h.':'.$texto_m, explode( ',', $agenda_bloqueo['AGEBLO_HORAS'] )  ) !== FALSE ) { ?>
                                               checked="checked"
                                           <?php } ?>
                                    />
                                    <label for="bloqueo_hora_<?=$texto_h?>_<?=$texto_m?>"> <?=$texto_h?>:<?=$texto_m?> </label>
                            <?php } ?>
                        </td>
                    </tr>

                    <tr>
                        <td>&nbsp;</td>
                        <td align="left"><?=form_button($bloqueo_por_intervalo_agregar_boton)?></td>
                    </tr>
                </table>
                <?=form_close()?>
                <br />
                <?= form_open( '', $form_bloqueo_por_fecha ) ?>
                <?=form_input($agenda_id)?> <?=form_input($agenda_bloqueo_id)?>
                <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td class="title_data_form"><?= $this->lang->line( 'agenda_bloqueo_por_fecha' ) ?></td>
                        <td class="title_data_form2">&nbsp;</td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('agenda_bloqueo_seleccione_dia')?></td>
                        <td align="left">
                            <input type="text" id="bloqueo_por_fecha" name="bloqueo_por_fecha" />
                        </td>
                    </tr>

                    <tr>
                        <td>&nbsp;</td>
                        <td align="left"><?=form_button($bloqueo_por_fecha_agregar_boton)?></td>
                    </tr>
                </table>
                <?=form_close()?>
            </div>
        </td>
    </tr>
</table>
