<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

// Variables de formulario de busqueda por filtro
$busqueda_por_filtro_form = array(  'method' => 'post',
                                    'name'  => 'busqueda_por_filtro_form',
                                    'id'    => 'busqueda_por_filtro_form');

$busqueda_fecha_inicio = array( 'name' => 'busqueda_fecha_inicio',
                                'id'    => 'busqueda_fecha_inicio',
                                'type'  => 'text',
                                'size'  => '20');
$busqueda_fecha_fin = array('name'  => 'busqueda_fecha_fin',
                            'id'    => 'busqueda_fecha_fin',
                            'type'  => 'text',
                            'size'  => '20');

$buscar_por_filtro_btn	= array('name'  => 'buscar_por_filtro_btn',
                                'id'    => 'buscar_por_filtro_btn',
                                'type'  => 'submit',
                                'class' => 'boton_buscar2',
                                'content' => $this->lang->line('buscar') );

// Variables de formulario de busqueda por nombre y apellido del paciente
$busqueda_por_paciente_form = array('method' => 'post',
                                    'name'   => 'busqueda_por_paciente_form',
                                    'id'     => 'busqueda_por_paciente_form');

$busqueda_por_paciente_nombre   = array('name'  => 'busqueda_por_paciente_nombre',
                                        'id'    => 'busqueda_por_paciente_nombre',
                                        'size'  => '20');

$busqueda_por_paciente_apellido = array('name'  => 'busqueda_por_paciente_apellido',
                                        'id'    => 'busqueda_por_paciente_apellido',
                                        'size'  => '20');

$busqueda_por_paciente_btn	= array('name'  => 'busqueda_por_paciente',
                                    'id'    => 'busqueda_por_paciente',
                                    'type'  => 'submit',
                                    'class' => 'boton_buscar2',
                                    'content' => $this->lang->line('buscar') );

// Variables de formulario de busqueda por id del paciente
$busqueda_por_id_paciente_form  = array('method' => 'post',
                                        'name'   => 'busqueda_por_id_paciente_form',
                                        'id'     => 'busqueda_por_id_paciente_form');

$busqueda_por_id_paciente       = array('name'  => 'busqueda_por_id_paciente',
                                        'id'    => 'busqueda_por_id_paciente',
                                        'size'  => '20');

$busqueda_por_id_paciente_btn	= array('name'  => 'busqueda_por_id_paciente_btn',
                                        'id'    => 'busqueda_por_id_paciente_btn',
                                        'type'  => 'submit',
                                        'class' => 'boton_buscar2',
                                        'content' => $this->lang->line('buscar') );

// Variables de formulario de busqueda por ID
$busqueda_por_id_form = array(  'method' => 'post',
                                'name'   => 'busqueda_por_id_form',
                                'id'     => 'busqueda_por_id_form');

$busqueda_por_id        = array('name'  => 'busqueda_por_id',
                                'id'    => 'busqueda_por_id',
                                'class' => 'validate[required]',
                                'size'  => '20');
$busqueda_por_id_btn	= array('name'  => 'busqueda_por_id_btn',
                                'id'    => 'busqueda_por_id_btn',
                                'type'  => 'submit',
                                'class' => 'boton_buscar2',
                                'content' => $this->lang->line('buscar') );

// Variables de formulario de agendamiento
$agendamiento_form = array( 'method' => 'post',
                            'name'  => 'agendamiento_form',
                            'id'    => 'agendamiento_form');

$agendamiento_fecha = array(    'name'  => 'agendamiento_fecha',
                                'id'    => 'agendamiento_fecha',
                                'size'  => '9',
                                'style' => 'text-align:right',
                                'readonly' => 'readonly' );
$agendamiento_hora  = array(    'name'  => 'agendamiento_hora',
                                'id'    => 'agendamiento_hora',
                                'size'  => '9',
                                'style' => 'text-align:right',
                                'readonly' => 'readonly' );
$agendamiento_telefono_contacto = array('name' => 'agendamiento_telefono_contacto',
                                        'size' => '10',
                                        'type' => 'text' );
$agendamiento_email_contacto    = array('name' => 'agendamiento_email_contacto',
                                        'size' => '30',
                                        'type' => 'text' );
$agendamiento_observaciones     = array('name' => 'agendamiento_observaciones',
                                        'rows' => '4' );

$agendamiento_agregar_buton = array('name'  => 'button',
                                    'id'    => 'button',
                                    'type'  => 'submit',
                                    'class' => 'boton_crear',
                                    'content' => $this->lang->line( 'agendamiento_agregar' ) );
?>
<link type="text/css" rel="stylesheet" href="<?=base_url()?>css/jquery.fullcalendar.css" />
<script type="text/javascript" src="<?=base_url()?>js/jquery.fullcalendar.min.js"></script>
<script type="text/javascript" language="javascript" >

    dayNames = [	'<?=html_entity_decode( $this->lang->line('domingo'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('lunes'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('martes'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('miercoles'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('jueves'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('viernes'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('sabado'), ENT_COMPAT, 'UTF-8' )?>'];
    dayNamesMin = [	'<?=html_entity_decode( $this->lang->line('dom'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('lun'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('mar'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('mie'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('jue'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('vie'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('sab'), ENT_COMPAT, 'UTF-8' )?>'];
    monthNames = [  '<?=html_entity_decode( $this->lang->line('enero'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('febrero'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('marzo'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('abril'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('mayo'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('junio'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('julio'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('agosto'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('septiembre'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('octubre'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('noviembre'), ENT_COMPAT, 'UTF-8' )?>',
                    '<?=html_entity_decode( $this->lang->line('diciembre'), ENT_COMPAT, 'UTF-8' )?>'];

    especialidad = null;

    $(document).ready( function( ) {

        // Botón volver
        $('#volver').click( function( ) {
            $('#deploy').load( '<?= base_url() ?>platc/agendamiento_resumen/'+Math.random( ) );
        } );

        // Búsqueda por filtro: Validación y envío de formulario usando ajax
        $('#busqueda_por_filtro_form').validationEngine( );

        // Búsqueda por filtro: Evita que formulario de búsqueda sea enviado, la búsqueda se asocia a $('#buscar_por_filtro_btn').click();
        $("#busqueda_por_filtro_form").submit( function(event) {
            event.preventDefault();
        } );

        // Búsqueda por filtro: Configura fechas para usar plugin de Calendario
        fecha_ini = {   minDate: new Date( '01/01/2010' ),
                    showOn: 'button',
                    buttonImageOnly: true,
                    buttonImage: '<?=base_url()?>images/calendario.png',
                    dateFormat: "dd-mm-yy",
                    dayNames: dayNames,
                    dayNamesMin: dayNamesMin,
                    monthNames: monthNames,
                    firstDay: 1,
                    gotoCurrentType: true,
                    showOtherMonths: true,
                    selectOtherMonths: true
                };
        $('#busqueda_fecha_inicio').datepicker( fecha_ini );
        $('#busqueda_fecha_fin').datepicker( fecha_ini );

        i = new Date();
        $('#busqueda_fecha_inicio').val( '01-'+ ( ( i.getMonth() +1 < 10 ) ? '0'+( i.getMonth() +1 ) : ( i.getMonth() +1 ) ) + '-' + i.getFullYear() );
        f = new Date( i.getFullYear(), i.getMonth()+1, 0  );
        $('#busqueda_fecha_fin').val( f.getDate()+'-'+ ( ( f.getMonth() +1 < 10 ) ? '0'+( f.getMonth() +1 ) : ( f.getMonth() +1 ) ) + '-' + f.getFullYear() );

        $('#busqueda_cliente').change( function( ) {

            if( $(this).val() != "" ) {

                $.getJSON( '<?=base_url()?>platc/establecimientos_combobox/'+$(this).val()+'/'+Math.random(),
                {},
                function( data ) {

                    html ="";
                    for(var i in data ) {
                        html+= "<option value="+data[i].id+">"+data[i].nombre+"</option>"
                    }
                    $('#busqueda_establecimiento').html( html );
                } );
            } else {
                $('#busqueda_establecimiento').html( "" );
            }
        } );

        // Búsqueda por filtro: Realiza búsqueda
        $('#buscar_por_filtro_btn').click( function( ) {

            // Retorna true si el formulario es válido, false cuando no
            if( $('#busqueda_por_filtro_form').validationEngine( { returnIsValid: true } ) ) {

                $('#busqueda_tc_grid').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                $('#tabla_agendamiento_hora').css( 'display', 'none' );

                $('#busqueda_tc_grid').load( '<?=base_url()?>platc/agendamiento_busqueda_tc_por_filtro',
                                            {   busqueda_establecimiento:   $('#busqueda_establecimiento').val(),
                                                busqueda_especialidad:      $('#busqueda_especialidad').val(),
                                                busqueda_estado:            $('#busqueda_estado').val(),
                                                busqueda_fecha_inicio:      $('#busqueda_fecha_inicio').val(),
                                                busqueda_fecha_fin:         $('#busqueda_fecha_fin').val() }
                );
            }
        } );

        // Búsqueda por paciente: Validación y envío de formulario usando ajax
        $('#busqueda_por_paciente_form').validationEngine( );

        // Búsqueda por paciente: Evita que formulario de búsqueda sea enviado, la búsqueda se asocia a $('#buscar_por_paciente_btn').click();
        $("#busqueda_por_paciente_form").submit( function(event) {
            event.preventDefault();
        } );

        // Búsqueda por paciente: Realiza búsqueda
        $('#busqueda_por_paciente').click( function( ) {

            // Retorna true si el formulario es válido, false cuando no
            if( $('#busqueda_por_paciente_form').validationEngine( { returnIsValid: true } ) ) {

                $('#busqueda_tc_grid').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                $('#tabla_agendamiento_hora').css( 'display', 'none' );

                $('#busqueda_tc_grid').load( '<?=base_url()?>platc/agendamiento_busqueda_tc_por_paciente',
                                            {   busqueda_nombre:    $('#busqueda_por_paciente_nombre').val(),
                                                busqueda_apellido:  $('#busqueda_por_paciente_apellido').val() }
                );
            }
        } );

        // Búsqueda por ID: Validación y envío de formulario usando ajax
        $('#busqueda_por_id_form').validationEngine( );

        // Búsqueda por folio TC: Evita que formulario de búsqueda sea enviado, la búsqueda se asocia a $('#busqueda_por_id_btn').click();
        $("#busqueda_por_id_form").submit( function(event) {
            event.preventDefault();
        } );

        // Búsqueda por folio TC: Realiza búsqueda
        $('#busqueda_por_id_btn').click( function( ) {

            // Retorna true si el formulario es válido, false cuando no
            if( $('#busqueda_por_id_form').validationEngine( { returnIsValid: true } ) ) {

                $('#busqueda_tc_grid').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                $('#tabla_agendamiento_hora').css( 'display', 'none' );

                $('#busqueda_tc_grid').load( '<?=base_url()?>platc/agendamiento_busqueda_tc_por_id',
                                            {   busqueda_id: $('#busqueda_por_id').val() }
                );
            }
        } );

        // Búsqueda por ID paciente: Validación y envío de formulario usando ajax
        $('#busqueda_por_id_paciente_form').validationEngine( );

        // Búsqueda por ID paciente: Evita que formulario de búsqueda sea enviado, la búsqueda se asocia a $('#busqueda_por_id_paciente_btn').click();
        $("#busqueda_por_id_paciente_form").submit( function(event) {
            event.preventDefault();
        } );

        // Búsqueda por folio TC: Realiza búsqueda
        $('#busqueda_por_id_paciente_btn').click( function( ) {

            // Retorna true si el formulario es válido, false cuando no
            if( $('#busqueda_por_id_paciente_form').validationEngine( { returnIsValid: true } ) ) {

                $('#busqueda_tc_grid').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                $('#tabla_agendamiento_hora').css( 'display', 'none' );

                $('#busqueda_tc_grid').load( '<?=base_url()?>platc/agendamiento_busqueda_tc_por_id_paciente',
                                            {   busqueda_id_paciente: $('#busqueda_por_id_paciente').val() }
                );
            }
        } );

        // Calendario: Obtiene listado de agendas disponibles en el medico
        $('#agendamiento_medicos_especialistas').change( function( ) {

            $('#calendario').empty( );
            $('#agendamiento_resumen').css( 'display', 'none' );

            if( $(this).val( ) != 0 ) {

                $.getJSON(
                    '<?=base_url()?>platc/agendamiento_especialista_agendas_disponibles/'+$(this).val(),
                    {},
                    function( data ) {

                        html = "";
                        html+="<option></option>";
                        for ( var i in data ) {
                            html+="<option value=\""+data[i].agedef_id+"\"> "+data[i].agedef_hora_inicio+" <?=$this->lang->line('agendamiento_a')?> "+data[i].agedef_hora_fin;
                            html+=" <?=$this->lang->line('agendamiento_desde')?> "+data[i].agedef_fecha_ini+" <?=$this->lang->line('agendamiento_hasta')?> "+data[i].agedef_fecha_fin+"</option>";
                        }

                        $('#agendamiento_agendas_especialistas').html( html );
                    }
                );

                $('[name=agendamiento_id_medico]').val( $(this).val() );
            } else {

                $('#agendamiento_agendas_especialistas').html( "" );
            }

        } );


        $('#agendamiento_agendas_especialistas').change( function( ) {

            if( $(this).val() != null ) {

                $('#calendario').empty( );
                $('#agendamiento_resumen').css( 'display', 'none' );

                id_agenda = $(this).val();

                $.getJSON(
                    '<?=base_url()?>platc/agendamiento_calendario_definicion/'+id_agenda,
                    {},
                    function( agenda_def ) {

                        dias_tomados_bloqueados = { url:        '<?=base_url()?>platc/agendamiento_calendario_bloqueados',
                                                    data:       { id_agenda_def: agenda_def.agedef_id },
                                                    type:       'POST',
                                                    color:      '#888888',
                                                    textColor:  '#333333',
                                                    allDay:     false,
                                                    editable:   false
                                                };

                        recrearCalendario( agenda_def, dias_tomados_bloqueados );
                    }
                );

            }
        } );

        //
        $('#confirmar_hora').click( function( ) {

            agendamiento = $('#calendario').fullCalendar( 'clientEvents', 'agendamiento' );
            if( agendamiento.length > 0 ) {
                $('#agendamiento_fecha').val( agendamiento[0].start.getDate( ) +'-'+ ( ( (parseInt( agendamiento[0].start.getMonth( ) )+1) >= 10 ) ? (parseInt( agendamiento[0].start.getMonth( ) )+1) : '0'+(parseInt( agendamiento[0].start.getMonth( ) )+1) ) +'-'+agendamiento[0].start.getFullYear( ) );
                $('#agendamiento_hora').val( ( ( agendamiento[0].start.getHours( ) >= 10 ) ? ( agendamiento[0].start.getHours( ) ) : ( '0'+agendamiento[0].start.getHours( ) ) )+':' +( ( agendamiento[0].start.getMinutes( ) >= 10 ) ? ( agendamiento[0].start.getMinutes( ) ) : ('0' + agendamiento[0].start.getMinutes( ) ) ) );
                $('#agendamiento_resumen').removeAttr( 'style' );
                $('#agendamiento_form [name=agendamiento_id_agenda_def]').val( $('#agendamiento_agendas_especialistas').val() );
            } else
                jAlert( '<?=$this->lang->line('agendamiento_agregar_sin_agendamiento_error')?>', '<?=$this->lang->line('error')?>' );

        } );

        // Agendamiento: Validación y envío de formulario usando ajax
        $('#agendamiento_form').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/agendamiento_agrega/'+Math.random( ),
            success : false,
            failure : false
        } );

    } );

    // Para fullCalendar: Calcula si Evento se solapa con alguno otro
    function sobrepone( eventos, date ) {
//console.debug( eventos );
//console.debug( date );
//return true;
        for( var i in eventos ) {

//console.debug( "evento.start: "+ eventos[ i ].start + " date: " + date );
//console.debug( "evento.end:   "+ eventos[ i ].end );
//console.debug( "date:         "+ date );
            if( date.getTime() === eventos[ i ].start.getTime() ||
                ( date >= eventos[ i ].start && date < eventos[ i ].end ) ) {
//console.debug( 'se solapa' );
                return true;
            }

        }

        return false;
    }

    function recrearCalendario( agenda_def, dias_bloqueados ) {

        calendario = $('#calendario').fullCalendar( {
            // General: Define distribución de elementos (titulos, botones) en cabezera del calendario
            header: {   left:   'title',
                        right:  'month agendaDay prev,next' },
            firstDay: 1,            // General: Establece primer día de la semana: 1=Lunes
            allDayDefault: false,   // Vista de mes|semana|dia: muestra(false)|evita(true) Eventos por horas en calendario
            allDaySlot: false,      // Vista de semana: muestra(true)/evita(false) campo "todo el día"
            titleFormat: { month: 'MMMM yyyy' , day: 'dddd dd-MMMM-yyyy' },   // Vista de mes|semana|dia: Establece formato de fecha en título de vista
            columnFormat: { day: 'dddd' },  // Vista de semana|día: Establece formato de nombre en título de columna
            dayNames: dayNames,            // General: Estable texto de días
            dayNamesShort: dayNamesMin,   // General: Estable texto de días en formato corto: Lun, Mar,...
            monthNames: monthNames,        // General: Estable texto de mes
            buttonText: {   today:  '<?=$this->lang->line('hoy')?>',
                            day:    '<?=$this->lang->line('dia')?>',
                            week:   '<?=$this->lang->line('semana')?>',
                            month:  '<?=$this->lang->line('mes')?>',
                            year:   '<?=$this->lang->line('anno')?>' },  // General: Establece texto de botones
            timeFormat : { month:'HH:mm{ - HH:mm}', agendaDay:'dddd dd-MMMM-yyyy HH:mm{ - HH:mm}' },    // Vista de mes: Formato de hora en Eventos
            axisFormat: "HH:mm", // Vista de semana: formato de hora en columna-eje "hora"
            slotMinutes: parseInt( agenda_def.agedef_intervalo ),    // Vista de semana: Separación en columna-eje "hora" por cada X minutos. Aquí definir intervalo
            defaultEventMinutes: parseInt( agenda_def.agedef_intervalo ),    // Vista de semana: Duración del evento cuando no hay dateEnd.
            minTime: agenda_def.agedef_hora_inicio,    // Vista de semana: Hora mínima para mostrar en columna-eje "hora"
            maxTime: agenda_def.agedef_hora_fin,   // Vista de semana: Hora máxima para mostrar en columna-eje "hora"
            editable: true,     // Vista de mes|semana: Permite|evita que el usuario pueda realizar cambios en los "eventos" del calendario
            disableResizing: true,  // Vista de mes|semana: Permite|evita que el usuario pueda cambiar el tamaño de los días|horas
            eventSources: [  ],
            ignoreTimezone: true,
            // Cambia de "vista mes" hacia "vista día" al hacer click en un día del mes
            // mostrando en "vista de día" el día seleccionado en la "vista de mes"
            dayClick: function(date, allDay, jsEvent, view) {

                if( view.name === 'month' ) {

                    /*
                     * Valida que no se seleccione una fecha fuera de los rangos
                     * de la agenda y anterior del día vigente
                     */
                    fecha_ini = new Date(  );
                    fecha_fin = new Date( agenda_def.agedef_fecha_fin );

                    // Si está fuera de los años
                    if( date.getYear() < fecha_ini.getYear() ||
                        date.getYear() > fecha_fin.getYear() )
                        return false;

                    // Si está dentro del año, pero fuera de los meses
                    if( date.getUTCMonth() < fecha_ini.getUTCMonth() ||
                        date.getUTCMonth() > fecha_fin.getUTCMonth() )
                        return false;

                    // Si está dentro del año y del mes, pero fuera de los días
                    if( date.getUTCDate() < fecha_ini.getUTCDate() ||
                        date.getUTCDate() > fecha_fin.getUTCDate() )
                        return false;

                    // Si está dentro de las fechas de la agenda, entonces cambia de vista
                    calendario.fullCalendar( 'changeView', 'agendaDay' );
                    calendario.fullCalendar( 'gotoDate', date );
                }

                if( view.name === 'agendaDay' ) {

                    // Si está fuera de la hora actual
                    fecha_ini = new Date(  );
                    if( date.getUTCDate() >= fecha_ini.getDate() ) {
                        if( date.getUTCDate() == fecha_ini.getDate() ) {
                            if( date.getHours() < fecha_ini.getHours() )
                                return false;

                            if( ( date.getHours() == fecha_ini.getHours() ) && date.getMinutes() < fecha_ini.getMinutes() ) {
                                return false;
                            }
                        }
                    } else return false;

                    // Verifica que al hacer un click en alguna hora ésta no se sobreponga
                    // sobre ningun otro Event. Si está solapado, entonces conserva
                    // el último agendamiento establecido por el usuario
                    esta_solapado = sobrepone( $('#calendario').fullCalendar( 'clientEvents' ), date );
                    if( !esta_solapado ) {

                        // Detecta si el usuario ha ingresado un agendamiento (evento con id "agendamiento")
                        // si es así lo elimina y establece el nuevo, con el propósito de que no se repita (evento único)
                        agendamiento = $('#calendario').fullCalendar( 'clientEvents', 'agendamiento' );
                        if( agendamiento.length > 0 )
                            $('#calendario').fullCalendar( 'removeEvents', 'agendamiento' );

                        // Genera nuevo evento
                        nuevo_evento = new Object();
                        nuevo_evento.title  = '<?=$this->lang->line('agendamiento_hora_seleccionada')?>';
                        nuevo_evento.start  = date;
                        nuevo_evento.allDay = false;
                        nuevo_evento.id = 'agendamiento';
                        nuevo_evento.color = '#448844';
                        $('#calendario').fullCalendar( 'renderEvent', nuevo_evento, true );
                    }
                }
            },
            viewDisplay: function( view ) {

                /*
                 * Lógica que desactiva botones izquierda-derecha cuando
                 * el usuario busca meses fuera de la agenda
                 */
                if( view.name === 'month' ) {
                    fecha_ini = new Date( agenda_def.agedef_fecha_ini );
                    fecha_fin = new Date( agenda_def.agedef_fecha_fin );

                    cal_date_string = view.start.getUTCMonth()+'/'+view.start.getFullYear();
                    cur_date_string = fecha_ini.getUTCMonth()+'/'+fecha_ini.getFullYear();
                    end_date_string = fecha_fin.getUTCMonth()+'/'+fecha_fin.getFullYear();

                    if( cal_date_string == cur_date_string )
                        $('.fc-button-prev').addClass("fc-state-disabled");
                    else
                        $('.fc-button-prev').removeClass("fc-state-disabled");

                    if( end_date_string == cal_date_string )
                        $('.fc-button-next').addClass("fc-state-disabled");
                    else
                        $('.fc-button-next').removeClass("fc-state-disabled");
                }

                /*
                 * Lógica que desactiva botones izquierda-derecha cuando
                 * el usuario busca días fuera de la agenda
                 */
                if( view.name === 'agendaDay' ) {

                    fecha_ini = new Date( agenda_def.agedef_fecha_ini );
                    fecha_fin = new Date( agenda_def.agedef_fecha_fin );

                    cal_date_string = view.start.getUTCDay()+'/'+view.start.getUTCMonth()+'/'+view.start.getFullYear();
                    cur_date_string = fecha_ini.getUTCDay()+'/'+fecha_ini.getUTCMonth()+'/'+fecha_ini.getFullYear();
                    end_date_string = fecha_fin.getUTCDay()+'/'+fecha_fin.getUTCMonth()+'/'+fecha_fin.getFullYear();

                    if( cal_date_string == cur_date_string )
                        $('.fc-button-prev').addClass("fc-state-disabled");
                    else
                        $('.fc-button-prev').removeClass("fc-state-disabled");

                    if( end_date_string == cal_date_string )
                        $('.fc-button-next').addClass("fc-state-disabled");
                    else
                        $('.fc-button-next').removeClass("fc-state-disabled");
                }
            },
            eventDrop: function( event, dayDelta, minuteDelta, allDay, revertFunc ) {

                esta_solapado = sobrepone( $('#calendario').fullCalendar( 'clientEvents' ), event.start );
                if( esta_solapado )
                    revertFunc();
            }

        } );

        calendario.fullCalendar( 'addEventSource', dias_bloqueados );
    }
</script>

<!-- Busqueda de teleconsulta asociada -->
<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">

    <tr>
        <td align="left" colspan="2"><a href="#" id="volver"><img src="<?=base_url()?>images/volver.png" border="0" /></a></td>
    </tr>
    <tr>
        <td align="center" class="Titulo" colspan="2">&nbsp;<?= $this->lang->line('agendamiento_titulo_tc_asociada') ?></td>
    </tr>
    <tr>
        <td style="vertical-align: top">
            <?= form_open( '', $busqueda_por_filtro_form )?>
                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%" class="borde">
                    <tr>
                        <td colspan="2" class="Subtitulo" align="center"><?=$this->lang->line('busqueda_tc_title')?></td>
                    </tr>
                    <?php if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) { ?>
                    <tr>
                        <td class="data_form"><span class="redtext">*</span>&nbsp;<?=$this->lang->line('usuarios_cliente')?>: </td>
                        <td align="left"><?=form_dropdown( 'busqueda_cliente', $clientes, '', 'id="busqueda_cliente" type="select-one" class="validate[required]" style="width: 160px" ' )?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><span class="redtext">*</span>&nbsp;<?=$this->lang->line('usuarios_establ')?>: </td>
                        <td align="left"><?=form_dropdown( 'busqueda_establecimiento', array(), '', 'id="busqueda_establecimiento" type="select-one" class="validate[required]" style="width: 160px" ' )?></td>
                    </tr>
                    <?php } else { ?>
                    <tr>
                        <td class="data_form"><span class="redtext">*</span>&nbsp;<?=$this->lang->line('usuarios_establ')?>: </td>
                        <td align="left"><?=form_dropdown( 'busqueda_establecimiento', $establecimientos, '', 'id="busqueda_establecimiento" type="select-one" class="validate[required]" style="width: 160px" ' )?></td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('usuarios_especialidad')?>: </td>
                        <td align="left"><?=form_dropdown( 'busqueda_especialidad', $especialidades, '', 'id="busqueda_especialidad"' )?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('estado_actual')?>: </td>
                        <td align="left"><?=form_dropdown('busqueda_estado', $estados, '', 'id="busqueda_estado"')?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('agenda_fecha_inicio')?>:</td>
                        <td align="left"><?=form_input($busqueda_fecha_inicio)?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('agenda_fecha_fin')?>:</td>
                        <td align="left"><?=form_input($busqueda_fecha_fin)?></td>
                    </tr>

                    <tr>
                        <td align="center" colspan="2"><?=form_button( $buscar_por_filtro_btn )?></td>
                    </tr>
                </table>
            <?= form_close()?>

            <br/>

            <?= form_open( '', $busqueda_por_id_form )?>
                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%" class="borde">
                    <tr>
                        <td colspan="2" class="Subtitulo" align="center"><?=$this->lang->line('buscartcporid')?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('tc_id')?>: </td>
                        <td align="left"><?=form_input( $busqueda_por_id )?></td>
                    </tr>
                    <tr>
                        <td align="center" colspan="2"><?=form_button( $busqueda_por_id_btn )?></td>
                    </tr>
                </table>
            <?= form_close()?>
        </td>

        <td style="vertical-align: top">
            <?= form_open( '', $busqueda_por_paciente_form )?>
                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%" class="borde">
                    <tr>
                        <td colspan="2" class="Subtitulo" align="center"><?=$this->lang->line('buscartcpor')?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('nombre')?>: </td>
                        <td align="left"><?=form_input( $busqueda_por_paciente_nombre )?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('apellido')?>: </td>
                        <td align="left"><?=form_input( $busqueda_por_paciente_apellido )?></td>
                    </tr>

                    <tr>
                        <td align="center" colspan="2"><?=form_button( $busqueda_por_paciente_btn )?></td>
                    </tr>
                </table>
            <?= form_close()?>

            <?= form_open( '', $busqueda_por_id_paciente_form )?>
                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%" class="borde">
                    <tr>
                        <td colspan="2" class="Subtitulo" align="center"><?=$this->lang->line('buscartcporidpaciente')?></td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('tc_id')?>: </td>
                        <td align="left"><?=form_input( $busqueda_por_id_paciente )?></td>
                    </tr>
                    <tr>
                        <td align="center" colspan="2"><?=form_button( $busqueda_por_id_paciente_btn )?></td>
                    </tr>
                </table>
            <?= form_close()?>
        </td>
    </tr>

    <tr>
        <td colspan="2">
            <div id="busqueda_tc_grid"></div>
        </td>
    </tr>
</table>

<!-- Agendamiento de hora -->
<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%" id="tabla_agendamiento_hora" style="display: none;">
    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line('agendamiento_titulo_fecha_agendamiento') ?></td>
    </tr>

    <tr>
        <td>
            <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_tc_seleccionada')?>:</td>
                    <td align="left"> <span id="agendamiento_teleconsulta_seleccionada"></span> </td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_especialidad_teleconsulta')?>:</td>
                    <td align="left"> <span id="agendamiento_especialidad_teleconsulta"></span> </td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_seleccion_especialista')?>:</td>
                    <td align="left"> <?=form_dropdown( 'agendamiento_medicos_especialistas', array(), '', 'id="agendamiento_medicos_especialistas"' )?> </td>
                </tr>

                <tr>
                    <td class="data_form">&nbsp;</td>
                    <td align="left">
                        <br/>
                        <?=$this->lang->line('agenda_horas_disponibles')?>:<br/>
                        <select name="agendamiento_agendas_especialistas" id="agendamiento_agendas_especialistas" style="width: 70%"></select>
                        <br/>
                    </td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_seleccione_fecha')?>:</td>
                    <td align="left">
                        <div id="calendario"></div>
                    </td>
                </tr>

                <tr>
                    <td align="center" colspan="2">
                        <br/>
                        <button id="confirmar_hora" class="boton_01" ><?=$this->lang->line('agendamiento_confirmar_reunion')?></button>
                    </td>
                </tr>


            </table>
        </td>
    </tr>
</table>

<!-- Resumen -->
<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%" id="agendamiento_resumen" style="display: none;">

    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line('agendamiento_titulo_resumen') ?></td>
    </tr>

    <tr>
        <td>
            <?= form_open( '', $agendamiento_form) ?>
            <?= form_hidden( 'agendamiento_id_tc' )?>
            <?= form_hidden( 'agendamiento_id_medico' )?> <!-- especialista -->
            <?= form_hidden( 'agendamiento_id_agenda_def' )?>
            <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">

            <?php
                if ($this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] || $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) ////if ($this->session->userdata('ROL_ID') !== '4' ) // Activa combo de medicos cuando usuario no sea Rol Medico Generalista
                { ?>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('rol_4')?>:</td>
                        <td align="left">
                            <select type="select-one" name="agendamiento_generalista" id="agendamiento_generalista" class="validate[required]">
                                <?php
                                if( isset( $medicos_generalistas ) && !empty( $medicos_generalistas ) ) {
                                    foreach( $medicos_generalistas as $k => $v ) {
                                        echo( "<option value='".$k."'>".$v."</option>" );
                                    }
                                } ?>
                            </select>
                        </td>
                    </tr>
                <?php
                } ?>

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_fecha')?>:</td>
                    <td align="left"><?=form_input( $agendamiento_fecha )?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_hora')?>:</td>
                    <td align="left"><?=form_input( $agendamiento_hora )?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_telefono_contacto')?>:</td>
                    <td align="left"><?=form_input($agendamiento_telefono_contacto )?></td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_email_contacto')?>:</td>
                    <td align="left"><?=form_input($agendamiento_email_contacto, $this->session->userdata('USU_EMAIL') )?></td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('agendamiento_observaciones')?>:</td>
                    <td align="left"><?=  form_textarea($agendamiento_observaciones)?></td>
                </tr>

                <tr>
                    <td>&nbsp;</td>
                    <td align="left"><?=form_button($agendamiento_agregar_buton)?></td>
                </tr>
            </table>
            <?=form_close()?>
        </td>
    </tr>
</table>
