<?php
if( $modo == FormularioXML::$MODO_LECTURA ) {

    // Largo en pixeles de los graficos de barra del factor de riesgo
    $css_largo_barra = 350;
?>
<style type="text/css" >
    div.graph3
    {
        width: <?=$css_largo_barra?>px;
        margin: 10px 0px;
        padding: 0px;
        /*border: 1px solid #000000;*/
    }
    div.leg
    {
        text-align: center;
        padding: 1px;
        width: 99%;
        margin: 0px;
    }
    div.grnbr
    {
        float: left;
        height: 20px;
        background: #55AA55;
        margin: 0px;
        padding: 0px;
        display: inline;
        border-right: 1px solid #ffffff;
    }
    div.bar
    {
        width: 100%;
        background: #cccccc;
        height: 20px;
        margin: 0px;
        padding: 0px;
    }
    div.relpos
    {
        position: relative;
        margin-bottom: 4px;
    }
    div.abspos
    {
        position: absolute;
    }
    div.w100
    {
        width: 100%;
    }
    div.reslts
    {
        position: absolute;
        right: 0;
        margin: 0px;
        padding: 3px 5px;
        display: inline;
    }
    div.grnbrbc
    {
        float: left;
        height: 20px;
        background: #eebb00;
        margin: 0px;
        padding: 0px;
        border-right: 1px solid #ffffff;
    }

</style>

<script src="<?=base_url()?>js/gencvd10_bmi_calc.js" type="text/javascript"></script>

<?php if( $tc['TEL_PAC_EDAD'] >= 20 && $tc['TEL_PAC_EDAD'] <= 79 )
        $ancho = 50;
    else
        $ancho = 100;
?>

<table width="<?=$ancho?>%" cellspacing="0" cellpadding="0" border="0" align="center" style="float: left;">
<tbody>
    <tr>
        <td class="data_form"><?=$this->lang->line('fr_colesterol_total')?>:</td>
        <td align="left">
            <?=isset( $fr_colesterol_total ) ? $fr_colesterol_total : ''?>
        </td>
    </tr>
    <tr>
        <td class="data_form"><?=$this->lang->line('fr_colesterol_hdl')?>:</td>
        <td align="left">
            <?=isset( $fr_colesterol_hdl ) ? $fr_colesterol_hdl : ''?>
        </td>
    </tr>
    <tr>
        <td class="data_form"><?=$this->lang->line('fr_fumador')?>:</td>
        <td>
            <?php if( isset( $fr_rdbtn_fumador ) && $fr_rdbtn_fumador == 1 )
                echo $this->lang->line('fr_si');
            else
                echo $this->lang->line('fr_no');
            ?>
        </td>
    </tr>
    <tr>
        <td class="data_form"><?=$this->lang->line('fr_tratamiento_antihipertensivo')?>:</td>
        <td>
            <?php if( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && $fr_rdbtn_tratamiento_antihipertensivo == 1 )
                echo $this->lang->line('fr_si');
            else
                echo $this->lang->line('fr_no');
            ?>
        </td>
    </tr>
    <tr>
        <td class="data_form"><?=$this->lang->line('fr_diabetes')?>:</td>
        <td>
            <?php if( isset( $fr_rdbtn_diabetes ) && $fr_rdbtn_diabetes == 1 )
                echo $this->lang->line('fr_si');
            else
                echo $this->lang->line('fr_no');
            ?>
        </td>
    </tr>
</tbody>
</table>

<?php if( $tc['TEL_PAC_EDAD'] >= 20 && $tc['TEL_PAC_EDAD'] <= 79 ) { ?>

<!-- Resultados -->
<table width="<?=$ancho?>%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>
        <tr>
            <!-- Riesgo a diez años -->
            <td class="data_form"><?=$this->lang->line('fr_riesgo_diez_anos')?>: </td>
            <td align="left">
                <?=isset( $fr_riesgo_diez_anos ) ? $fr_riesgo_diez_anos : ' - '?> %
            </td>
        </tr>

        <tr>
            <td colspan="2">
                <div class="graph3" id="graph_bkg">
                    <div class="bar relpos">
                       <div class="leg abspos w100"><?=$this->lang->line('fr_riesgo_diez_anos')?></div>
                       <?php
                             $ancho_color = isset( $fr_riesgo_diez_anos ) ? $fr_riesgo_diez_anos : 0 ;
                             if( isset( $fr_riesgo_diez_anos ) && strcmp( $fr_riesgo_diez_anos, "&gt;=30" ) == 0 ) $ancho_color = 31;
                             if( isset( $fr_riesgo_diez_anos ) && strcmp( $fr_riesgo_diez_anos, "&lt;1" ) == 0 ) $ancho_color = 0;
                        ?>
                       <div class="grnbr" id="bmi_risk_bar" style="width:<?= ( isset( $fr_riesgo_diez_anos ) ) ? (int) ( ($ancho_color*$css_largo_barra)/100 ) : 0; ?>px;"></div>
                       <div class="reslts" id="bmi_risk_txt"><?=isset( $fr_riesgo_diez_anos ) ? $fr_riesgo_diez_anos : ' - '?> %</div>
                    </div>
                </div>
            </td>
        </tr>
    </tbody>
</table>
<?php }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<style type="text/css" >
    div.graph3
    {
        width: 350px;
        margin: 10px 0px;
        padding: 0px;
        /*border: 1px solid #000000;*/
    }
    div.leg
    {
        text-align: center;
        padding: 1px;
        width: 99%;
        margin: 0px;
    }
    div.grnbr
    {
        float: left;
        height: 20px;
        background: #55AA55;
        margin: 0px;
        padding: 0px;
        display: inline;
        border-right: 1px solid #ffffff;
    }
    div.bar
    {
        width: 100%;
        background: #cccccc;
        height: 20px;
        margin: 0px;
        padding: 0px;
    }
    div.relpos
    {
        position: relative;
        margin-bottom: 4px;
    }
    div.abspos
    {
        position: absolute;
    }
    div.w100
    {
        width: 100%;
    }
    div.reslts
    {
        position: absolute;
        right: 0;
        margin: 0px;
        padding: 3px 5px;
        display: inline;
    }
    div.grnbrbc
    {
        float: left;
        height: 20px;
        background: #eebb00;
        margin: 0px;
        padding: 0px;
        border-right: 1px solid #ffffff;
    }

</style>

<script src="<?=base_url()?>js/framingham_br.js" type="text/javascript"></script>
<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        $('#fr_calcular').click( calcular_riesgo );

        if( parseInt( $('#edad').val() ) < 20 || parseInt( $('#edad').val() ) > 79 ) {
            $('#fr_calcular').remove( );
            $('#tabla_resultado_framingham').remove( );
            $('#tabla_datos_framingham').attr( 'width', '100%' );
        }
    } );

    // Función que permite obtener valores de riesgos del paciente
    function calcular_riesgo( ) {

        // Vacia y desaparece cuadro de mensaje de errores
        $('#fr_campos_requeridos').empty();
        $('#fr_campos_requeridos').slideUp();
        msg_error = Array();

        // $('#edad') y $('#sexo') definido en vista "tc_nueva.php"
        edad            = $('#edad').val();
        sexo            = ( $('#sexo').val().toLowerCase() == 'm' ) ? 'M' : 'F';
        colesterol_total= $('#fr_colesterol_total').val( );
        colesterol_hdl  = $('#fr_colesterol_hdl').val( );
        fumador         = ( $('#fr_rdbtn_fumador_si').attr('checked') == null ) ? false : true;
        sistolica       = $('#sv_presion_sist').val();
        tratamiento_antihipertensivo = ( $('#fr_rdbtn_tratamiento_antihipertensivo_si').attr('checked') == null ) ? false : true;

        // Validaciones
        if( isNaN( parseInt( edad ) ) || ( parseInt( edad ) > 79 || parseInt( edad ) < 20 ) ) msg_error.push( '<?=$this->lang->line('fr_error_edad')?>' );
        if( isNaN( parseInt( sistolica ) ) ) msg_error.push( '<?=$this->lang->line('fr_error_sistolica')?>' );
        if( isNaN( parseInt( colesterol_total ) ) ) msg_error.push( '<?=$this->lang->line('fr_error_colesterol')?>' );
        if( isNaN( parseInt( colesterol_hdl ) ) ) msg_error.push( '<?=$this->lang->line('fr_error_colesterol_hdl')?>' );
        if( fumador == false && $('#fr_rdbtn_fumador_no').attr('checked') == false ) msg_error.push( '<?=$this->lang->line('fr_error_fumador')?>' );
        if( tratamiento_antihipertensivo == false && $('#fr_rdbtn_tratamiento_antihipertensivo_no').attr('checked') == false ) msg_error.push( '<?=$this->lang->line('fr_error_sistolica_tratamiento')?>' );

        if( msg_error.length > 0 ) {

            $('#bmi_risk_bar').css( 'width', 0 );
            $('#bmi_risk_txt').html( '0%' );
            $('#bmi_normal_bar').css( 'width', 0 );
            $('#bmi_normal_txt').html( '0%' );
            $('#bmi_opt_bar').css( 'width', 0 );
            $('#bmi_opt_txt').html( '0%' );

            $('#fr_edad_vascular_corazon').val( '' );
            $('#fr_riesgo_diez_anos').val( '' );
            $('#fr_riesgo_normal').val( '' );
            $('#fr_riesgo_optimo').val( '' );

            for( var i in msg_error )
                $('#fr_campos_requeridos').append( msg_error[i]+'<br/>' );

            $('#fr_campos_requeridos').slideDown();

            return false;
        }

        //
        framingham = new Framingham();
//console.debug( 'sexo: ' + sexo + ' edad: ' + edad + ' colesterol_total: ' + colesterol_total + " colesterol_hdl: " + colesterol_hdl + " fumador: " + fumador + " sistolica: " + sistolica + " tratamiento_antihipertensivo: " + tratamiento_antihipertensivo );
        resultado = framingham.calcular( sexo, edad, colesterol_total, colesterol_hdl, fumador, sistolica, tratamiento_antihipertensivo );
//console.debug( resultado );

        // And bar widths in the graph
        var fullW = parseInt( $('#graph_bkg').css('width') );
        fullW -= 10; // 10 pixel right border. Sorry.

        // NOTE: Bars peg at 100%
        var maxVal = 100;

        if( resultado == '<1' ) {
            $('#bmi_risk_bar').css( 'width', parseInt( Math.round( fullW * 0 ) / maxVal ) );
            $('#bmi_risk_txt').html( resultado+'%' );
        } else if( resultado == '>=30' ) {

            $('#bmi_risk_bar').css( 'width', parseInt( Math.round( fullW * 31 ) / maxVal ) );
            $('#bmi_risk_txt').html( resultado+'%' );
        } else {
            $('#bmi_risk_bar').css( 'width', parseInt( Math.round( fullW * resultado ) / maxVal ) );
            $('#bmi_risk_txt').html( resultado+'%' );
        }

        // Establece porcentaje de riesgo a 10 años
        $('#fr_riesgo_diez_anos').val( resultado );
    }
</script>

<table width="50%" cellspacing="0" cellpadding="0" border="0" align="center" style="float: left;" id="tabla_datos_framingham" >
    <tbody>
        <tr>
            <td class="data_form"><?=$this->lang->line('fr_colesterol_total')?>:</td>
            <td align="left">
                <input type="text" name="fr_colesterol_total" id="fr_colesterol_total"
                       value="<?=isset( $fr_colesterol_total ) ? $fr_colesterol_total : ''?>"
                />
            </td>
        </tr>
        <tr>
            <td class="data_form"><?=$this->lang->line('fr_colesterol_hdl')?>:</td>
            <td align="left">
                <input type="text" name="fr_colesterol_hdl" id="fr_colesterol_hdl"
                       value="<?=isset( $fr_colesterol_hdl ) ? $fr_colesterol_hdl : ''?>"
               />
            </td>
        </tr>
        <tr>
            <td class="data_form"><?=$this->lang->line('fr_fumador')?>:</td>
            <td>
                <input type="radio" name="fr_rdbtn_fumador" id="fr_rdbtn_fumador_si" value="1"
                   <?=( isset( $fr_rdbtn_fumador ) && ( $fr_rdbtn_fumador == 1 ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_fumador_si"><?=$this->lang->line('fr_si')?></label>
                &nbsp; &nbsp; &nbsp;
                <input type="radio" name="fr_rdbtn_fumador" id="fr_rdbtn_fumador_no" value="0"
                   <?=( ( isset( $fr_rdbtn_fumador ) && ( $fr_rdbtn_fumador == 0 ) ) || !isset( $fr_rdbtn_fumador ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_fumador_no"><?=$this->lang->line('fr_no')?></label>
            </td>
        </tr>
        <tr>
            <td class="data_form"><?=$this->lang->line('fr_tratamiento_antihipertensivo')?>:</td>
            <td>
                <input type="radio" name="fr_rdbtn_tratamiento_antihipertensivo" id="fr_rdbtn_tratamiento_antihipertensivo_si" value="1"
                   <?=( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && ( $fr_rdbtn_tratamiento_antihipertensivo == 1 ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_tratamiento_antihipertensivo_si"><?=$this->lang->line('fr_si')?></label>
                &nbsp; &nbsp; &nbsp;
                <input type="radio" name="fr_rdbtn_tratamiento_antihipertensivo" id="fr_rdbtn_tratamiento_antihipertensivo_no" value="0"
                   <?=( ( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && ( $fr_rdbtn_tratamiento_antihipertensivo == 0 ) || !isset( $fr_rdbtn_tratamiento_antihipertensivo ) ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_tratamiento_antihipertensivo_no"><?=$this->lang->line('fr_no')?></label>
            </td>
        </tr>
        <tr>
            <td class="data_form"><?=$this->lang->line('fr_diabetes')?>:</td>
            <td>
                <input type="radio" name="fr_rdbtn_diabetes" id="fr_rdbtn_diabetes_si" value="1"
                   <?=( isset( $fr_rdbtn_diabetes ) && ( $fr_rdbtn_diabetes == 1 ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_diabetes_si"><?=$this->lang->line('fr_si')?></label>
                &nbsp; &nbsp; &nbsp;
                <input type="radio" name="fr_rdbtn_diabetes" id="fr_rdbtn_diabetes_no" value="0"
                   <?=( ( isset( $fr_rdbtn_diabetes ) && ( $fr_rdbtn_diabetes == 0 ) || !isset( $fr_rdbtn_diabetes ) ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_diabetes_no"><?=$this->lang->line('fr_no')?></label>
            </td>
        </tr>
        <tr>
            <td colspan="2" align="center">
                <input type="button" name="fr_calcular" id="fr_calcular" value="<?=$this->lang->line('fr_calcular')?>" />
            </td>
        </tr>
    </tbody>
</table>

<!-- Resultados -->
<table width="50%" cellspacing="0" cellpadding="0" border="0" align="center" id="tabla_resultado_framingham" >
    <tbody>

        <tr>
            <!-- Riesgo a diez años -->
            <td class="data_form"><?=$this->lang->line('fr_riesgo_diez_anos')?>: </td>
            <td align="left">
                <input type="input" name="fr_riesgo_diez_anos" id="fr_riesgo_diez_anos" size="5" readonly="readonly" style="text-align: right;"
                   value="<?=( isset( $fr_riesgo_diez_anos ) ) ? $fr_riesgo_diez_anos : '' ?>"
                /> %
            </td>
        </tr>

        <tr>
            <td colspan="2">

                <div id="fr_campos_requeridos" style="display: none;"></div>

                <div class="graph3" id="graph_bkg">
                    <div class="bar relpos">
                       <div class="leg abspos w100"><?=$this->lang->line('fr_riesgo_diez_anos')?></div>
                       <div class="grnbr" id="bmi_risk_bar" ></div>
                       <div class="reslts" id="bmi_risk_txt"></div>
                    </div>
                </div>
            </td>
        </tr>
    </tbody>
</table>

<?php
}

if( $modo == FormularioXML::$MODO_PDF ) {

    $alineacion = ( $tc['TEL_PAC_EDAD'] >= 20 && $tc['TEL_PAC_EDAD'] <= 79 ) ? 0 : 1;

    // Colesterol total
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_colesterol_total' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_colesterol_total ) && !empty( $fr_colesterol_total ) ) ? $fr_colesterol_total : '-' ), 0, $alineacion, 'L' );

    if( $tc['TEL_PAC_EDAD'] >= 20 && $tc['TEL_PAC_EDAD'] <= 79 ) {
        // Riesgo a 10 años en porcentaje
        $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_riesgo_diez_anos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_riesgo_diez_anos ) && !empty( $fr_riesgo_diez_anos ) ) ? $fr_riesgo_diez_anos : '-' ).' %', 0, 1, 'L' );
    }

    // Colesterol HDL
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_colesterol_hdl' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_colesterol_hdl ) && !empty( $fr_colesterol_hdl ) ) ? $fr_colesterol_hdl : '-' , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Fumador
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_fumador' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_rdbtn_fumador ) && $fr_rdbtn_fumador == 1 ) ? $this->lang->line('fr_si') : $this->lang->line('fr_no') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // En tratamiento antihipertencivo
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_tratamiento_antihipertensivo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && $fr_rdbtn_tratamiento_antihipertensivo == 1 ) ? $this->lang->line('fr_si') : $this->lang->line('fr_no') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Diabetes
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_diabetes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_rdbtn_diabetes ) && $fr_rdbtn_diabetes == 1 ) ? $this->lang->line('fr_si') : $this->lang->line('fr_no') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

}
