<?php
if ($modo == FormularioXML::$MODO_LECTURA) { ?>

    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_peso') ?>:</td>
                <td align="left"><?=( isset( $df_peso ) && !empty( $df_peso ) ) ? $df_peso : ' - '?> <?=$this->lang->line('kg')?></td>
            </tr>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_talla') ?>:</td>
                <td align="left"><?=( isset( $df_talla ) && !empty( $df_talla ) ) ? $df_talla : ' - '?> <?=$this->lang->line('cm')?></td>
            </tr>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_imc') ?>:</td>
                <td align="left"><?=( isset( $df_imc ) && !empty( $df_imc ) ) ? $df_imc: ' - '?></td>
            </tr>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_imc_clasificacion') ?>:</td>
                <td align="left"><?=( isset( $df_imc_clasificacion ) && !empty( $df_imc_clasificacion ) ) ? $df_imc_clasificacion : ' - '?></td>
            </tr>
        </tbody>
    </table>

<?php

}

if ($modo == FormularioXML::$MODO_ESCRITURA) { ?>

    <script language="javascript" type="text/javascript">

        $(document).ready( function( ) {

            $('#df_peso').blur( function( ) { calculaIMC() } );
            $('#df_talla').blur( function( ) { calculaIMC() } );
        } );

        function calculaIMC() {
            if (document.tc_form.df_talla.value != '' && document.tc_form.df_peso.value != '') {

                tallaAlCuadrado = document.tc_form.df_talla.value * document.tc_form.df_talla.value;
                imc = document.tc_form.df_peso.value / tallaAlCuadrado;
                corr = String(imc * 10000);
                if( ( parseInt( corr ) / 100 ) < 1 )
                    formateado = corr.charAt(0) + corr.charAt(1) + corr.charAt(2) + corr.charAt(3);
                else
                    formateado = corr.charAt(0) + corr.charAt(1) + corr.charAt(2) + corr.charAt(3) + corr.charAt(4);
                document.tc_form.df_imc.value = formateado;
                num = parseInt(formateado);
                if (num < parseFloat( '18.5' ) )
                    document.tc_form.df_imc_clasificacion.value = '<?= $this->lang->line('tc_imc_1') ?>';
                else if (num >= parseFloat( '18.5' ) && num <= parseFloat( '24.9' ) )
                    document.tc_form.df_imc_clasificacion.value = '<?= $this->lang->line('tc_imc_2') ?>';
                else if (num >= parseFloat( '25' ) && num <= parseFloat( '29.9' ) )
                    document.tc_form.df_imc_clasificacion.value = '<?= $this->lang->line('tc_imc_3') ?>';
                else if (num >= parseFloat( '30' ) )
                    document.tc_form.df_imc_clasificacion.value = '<?= $this->lang->line('tc_imc_4') ?>';
            }
        }
    </script>

    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_peso') ?>:</td>
                <td align="left"><input type="text" name="df_peso" id="df_peso" maxlength="6" value="<?=isset( $df_peso ) ? $df_peso : '' ?>"> <?=$this->lang->line('kg')?></td>
            </tr>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_talla') ?>:</td>
                <td align="left"><input type="text" name="df_talla" id="df_talla" maxlength="6" value="<?=isset( $df_talla ) ? $df_talla : '' ?>"> <?=$this->lang->line('cm')?></td>
            </tr>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_imc') ?>:</td>
                <td align="left"><input type="text" name="df_imc" id="df_imc" readonly="readonly"  value="<?=isset( $df_imc ) ? $df_imc : '' ?>"></td>
            </tr>
            <tr>
                <td class="data_form"><?= $this->lang->line('df_imc_clasificacion') ?>:</td>
                <td align="left"><input type="text" name="df_imc_clasificacion" id="df_imc_clasificacion" readonly="readonly"  value="<?=isset( $df_imc_clasificacion ) ? $df_imc_clasificacion : '' ?>"></td>
            </tr>
        </tbody>
    </table>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Peso
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_peso' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $df_peso ) && !empty( $df_peso ) ) ? $df_peso : '-' ) . ' ' . $this->lang->line('kg'), 0, 'L', false, 0 );

    // Talla
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_talla' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $df_talla ) && !empty( $df_talla ) ) ? $df_talla : '-' ) . ' ' . $this->lang->line('cm'), 0, 'L', false, 0 );

    // IMC
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_imc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $df_imc ) && !empty( $df_imc ) ) ? $df_imc : '-' ), 0, 'L', false, 0 );

    // IMC Clasificación
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_imc_clasificacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $df_imc_clasificacion ) && !empty( $df_imc_clasificacion ) ) ? $df_imc_clasificacion : '-' ), 0, 'L', false, 0 );

}
