<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_presion_sist') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_presion_sist ) && !empty( $sv_presion_sist ) ) ? $sv_presion_sist : '-' ?> <?=$this->lang->line('mmhg')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_presion_diast') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_presion_diast ) && !empty( $sv_presion_diast ) ) ? $sv_presion_diast : '-' ?> <?=$this->lang->line('mmhg')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_presion_media') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_presion_media ) && !empty( $sv_presion_media ) ) ? $sv_presion_media : '-' ?> <?=$this->lang->line('mmhg')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_fc') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_fc ) && !empty( $sv_fc ) ) ? $sv_fc : '-' ?> <?=$this->lang->line('bpm')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_fr') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_fr ) && !empty( $sv_fr ) ) ? $sv_fr : '-' ?> <?=$this->lang->line('rpm')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_temperatura') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_temperatura ) && !empty( $sv_temperatura ) ) ? $sv_temperatura : '-' ?> <?=$this->lang->line('grados_centigrados')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_sato2') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $sv_sato2 ) && !empty( $sv_sato2 ) ) ? $sv_sato2 : '-' ?> %</td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

<script language="javascript" type="text/javascript">

    function calcular_presion_arterial_media( presion_sist, presion_diast ) {

        if( parseInt( presion_sist ) > 0 && parseInt( presion_diast ) > 0 ) {

            return Math.round( ( ( 2 * parseInt( presion_diast ) ) + parseInt( presion_sist ) ) / 3 );
        }

        return "";
    }

    function executeContinue( mensaje ) {
//        console.debug( mensaje );

        datos = mensaje.split( '#/' );

        // Posición 0: Fecha
    //    $('#').val( datos[0] );

        // Posición 1: Hora
    //    $('#').val( datos[0] );

        // Posición 2: Lectura
    //    $('#').val( datos[0] );

        // Posición 3: Diastolica
        $('#sv_presion_diast').val( datos[3] );

        // Posición 4: Sistolica
        $('#sv_presion_sist').val( datos[4] );

        $('#sv_presion_media').val( calcular_presion_arterial_media( $('#sv_presion_sist').val( ), $('#sv_presion_diast').val( ) ) );

        // Posición 5: Pulsaciones por minuto
        $('#sv_fc').val( datos[5] );

        // Posición 6: Saturometría
        $('#sv_sato2').val( datos[6] );

        // Posición 7: Temperatura
        $('#sv_temperatura').val( datos[7] );

        // Posición 8: Rate
    //    $('#').val( datos[8] );
    }

    $(document).ready( function( ) {

        $('#sv_presion_sist').blur( function( ) {
            $('#sv_presion_media').val( calcular_presion_arterial_media( parseInt( $(this).val() ), parseInt( $('#sv_presion_diast').val( ) ) ) );
        } );

        $('#sv_presion_diast').blur( function( ) {
            $('#sv_presion_media').val( calcular_presion_arterial_media( parseInt( $('#sv_presion_sist').val( ) ), parseInt( $(this).val() ) ) );
        } );

    } );

</script>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>
        <tr>
            <td colspan="2" align="center" valign="middle">
                <applet archive="<?=base_url()?>applet/appletSpot.jar"
                        code="br.com.dm.forms.VitalsApplet.class"
                        name="SpotApplet"
                        height="30"
                        MAYSCRIPT >
                    <param name="msg_1" value="<?=$this->lang->line('msg_1')?>" />
                    <param name="msg_2" value="<?=$this->lang->line('msg_2')?>" />
                </applet>
                <br/> <br/> <br/> <br/>
            </td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_presion_sist') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_presion_sist" id="sv_presion_sist" value="<?=( isset( $sv_presion_sist ) && !empty( $sv_presion_sist ) ) ? $sv_presion_sist : '' ?>" /> <?=$this->lang->line('mmhg')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_presion_diast') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_presion_diast" id="sv_presion_diast" value="<?=( isset( $sv_presion_diast ) && !empty( $sv_presion_diast ) ) ? $sv_presion_diast : '' ?>" /> <?=$this->lang->line('mmhg')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_presion_media') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_presion_media" id="sv_presion_media" value="<?=( isset( $sv_presion_media ) && !empty( $sv_presion_media ) ) ? $sv_presion_media : '' ?>" readonly /> <?=$this->lang->line('mmhg')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_fc') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_fc" id="sv_fc" value="<?=( isset( $sv_fc ) && !empty( $sv_fc ) ) ? $sv_fc : '' ?>" /> <?=$this->lang->line('bpm')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_fr') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_fr" id="sv_fr" value="<?=( isset( $sv_fr ) && !empty( $sv_fr ) ) ? $sv_fr : '' ?>" /></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_temperatura') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_temperatura" id="sv_temperatura" value="<?=( isset( $sv_temperatura ) && !empty( $sv_temperatura ) ) ? $sv_temperatura : '' ?>"> <?=$this->lang->line('grados_centigrados')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('sv_sato2') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="sv_sato2" id="sv_sato2" value="<?=( isset( $sv_sato2 ) && !empty( $sv_sato2 ) ) ? $sv_sato2 : '' ?>"> %</td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Presión sistólica
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_presion_sist' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $sv_presion_sist ) && !empty( $sv_presion_sist ) ) ? $sv_presion_sist : '-' ) . ' ' . $this->lang->line('mmhg') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Presión diastólica
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_presion_diast' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $sv_presion_diast ) && !empty( $sv_presion_diast ) ) ? $sv_presion_diast : '-' ) . ' ' . $this->lang->line('mmhg') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Presión media
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_presion_media' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $sv_presion_media ) && !empty( $sv_presion_media ) ) ? $sv_presion_media : '-' ) . ' ' . $this->lang->line('mmhg') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Frecuencia cardiaca
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_fc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $sv_fc ) && !empty( $sv_fc ) ) ? $sv_fc : '-' ) . ' ' . $this->lang->line('bpm') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // FR
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_fr' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $sv_fr ) && !empty( $sv_fr ) ) ? $sv_fr : '-' ).' '.$this->lang->line('rpm', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Temperatura
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_temperatura' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $sv_temperatura ) && !empty( $sv_temperatura ) ) ? $sv_temperatura : '-' ) . ' ' . $this->lang->line('grados_centigrados') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Saturometría
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'sv_sato2' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $sv_sato2 ) && !empty( $sv_sato2 ) ) ? $sv_sato2 : '-' ) . ' %', 0, 1, 'L' );

} ?>
