<?php

if( $modo == FormularioXML::$MODO_LECTURA ) {

    $antecedentes_chkbx = !isset( $antecedentes_chkbx ) ? array() : $antecedentes_chkbx;

    if( !empty( $antecedentes_chkbx ) ) {

        foreach( $antecedentes_chkbx as $valor ) {

            $texto = "";
            switch( (string)$valor ) {
                case 'antecedentes_hipertension_arterial'   : $texto = $this->lang->line('oftalmologia_hipertension_arterial'); break;
                case 'antecedentes_dislipidemia'            : $texto = $this->lang->line('oftalmologia_dislipidemia'); break;
                case 'antecedentes_diabetes_mellitus'       : $texto = $this->lang->line('oftalmologia_diabetes_mellitus'); break;
                default : $texto = '-'; break;
            } ?>

            <span><?= !empty( $texto ) ? $texto : '-' ?></span><br />
<?php   }
    } else { ?>
        <span><?=$this->lang->line('oftalmologia_sin_antecedentes')?></span><br />
<?php }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

    } );

</script>

<?php $antecedentes_chkbx = !isset( $antecedentes_chkbx ) ? array() : $antecedentes_chkbx; ?>

<!-- 1: Hipertension arterial -->
<input type="checkbox"
   id="antecedentes_chkbx_hipertension_arterial"
   name="antecedentes_chkbx[]"
   value="antecedentes_hipertension_arterial"
      <?php if( array_search( 'antecedentes_hipertension_arterial', $antecedentes_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="antecedentes_chkbx_hipertension_arterial"><?= $this->lang->line('oftalmologia_hipertension_arterial') ?></label>
<br/>

<!--2: Dislipidemia -->
<input type="checkbox"
   id="antecedentes_chkbx_dislipidemia"
   name="antecedentes_chkbx[]"
   value="antecedentes_dislipidemia"
      <?php if( array_search( 'antecedentes_dislipidemia', $antecedentes_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="antecedentes_chkbx_dislipidemia"><?= $this->lang->line('oftalmologia_dislipidemia') ?></label>
<br/>

<!--3: Diabetes mellitus -->
<input type="checkbox"
   id="antecedentes_chkbx_diabetes_mellitus"
   name="antecedentes_chkbx[]"
   value="antecedentes_diabetes_mellitus"
      <?php if( array_search( 'antecedentes_diabetes_mellitus', $antecedentes_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="antecedentes_chkbx_diabetes_mellitus"><?= $this->lang->line('oftalmologia_diabetes_mellitus') ?></label>
<br/>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $antecedentes_chkbx = !isset( $antecedentes_chkbx ) ? array() : $antecedentes_chkbx;

    $x = $pdf->GetX();

    $pdf->SetX( $x );
    $pdf->SetFont( 'Arial' );

    if( !empty( $antecedentes_chkbx ) ) {

        foreach( $antecedentes_chkbx as $valor ) {

            $texto = "";
            switch( (string)$valor ) {
                case 'antecedentes_hipertension_arterial'   : $texto = $this->lang->line('oftalmologia_hipertension_arterial'); break;
                case 'antecedentes_dislipidemia' 			: $texto = $this->lang->line('oftalmologia_dislipidemia'); break;
                case 'antecedentes_diabetes_mellitus'   	: $texto = $this->lang->line('oftalmologia_diabetes_mellitus'); break;
                default : $texto = '-'; break;
            }

            $pdf->MultiCell( 0, 6, html_entity_decode( $texto, ENT_COMPAT, 'UTF-8'  ), 0, 'L', false, 0 );
            $pdf->SetX( $x );
        }
    } else {

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'oftalmologia_sin_antecedentes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1', ENT_COMPAT, 'UTF-8' ), 0, 'L', false, 0 );
        $pdf->SetFont( 'Arial' );

    }
}