<?php
if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

    <table cellspacing="0" cellpadding="0" border="0" align="center" >
        <tbody>

            <!-- Talla para edad -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_talla_para_edad_de')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_talla_para_edad_de ) && !empty( $pediatria_talla_para_edad_de ) ) ?
                            $this->lang->line( 'pediatria_talla_para_edad_de_'.$pediatria_talla_para_edad_de ) .
                            ' ('.$this->lang->line( 'pediatria_talla_para_edad_de_'.$pediatria_talla_para_edad_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- Peso para la edad -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_peso_para_edad_de')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_peso_para_edad_de ) && !empty( $pediatria_peso_para_edad_de ) ) ?
                            $this->lang->line( 'pediatria_peso_para_edad_de_'.$pediatria_peso_para_edad_de ) .
                            ' ('.$this->lang->line( 'pediatria_peso_para_edad_de_'.$pediatria_peso_para_edad_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- Peso para la talla -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_peso_para_talla_de')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_peso_para_talla_de ) && !empty( $pediatria_peso_para_talla_de ) ) ?
                            $this->lang->line( 'pediatria_peso_para_talla_de_'.$pediatria_peso_para_talla_de ) .
                            ' ('.$this->lang->line( 'pediatria_peso_para_talla_de_'.$pediatria_peso_para_talla_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- IMC -->
            <tr>
                <td class="data_form"><?=$this->lang->line('df_imc')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_imc_de ) && !empty( $pediatria_imc_de ) ) ?
                            $this->lang->line( 'pediatria_imc_de_'.$pediatria_imc_de ) .
                            ' ('.$this->lang->line( 'pediatria_imc_de_'.$pediatria_imc_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- Perimetro cefálico -->
            <tr>
                <td class="data_form"><?=$this->lang->line('df_perimetro_cefalico')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_perimetro_cefalico_de ) && !empty( $pediatria_perimetro_cefalico_de ) ) ?
                            $this->lang->line( 'pediatria_perimetro_cefalico_de_'.$pediatria_perimetro_cefalico_de ) .
                            ' (' . $this->lang->line( 'pediatria_perimetro_cefalico_de_'.$pediatria_perimetro_cefalico_de.'_desc' ) . ')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

        </tbody>
    </table>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        var talla_para_edad = [

            { id: '1', descripcion: '<?=$this->lang->line('pediatria_talla_para_edad_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('pediatria_talla_para_edad_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('pediatria_talla_para_edad_de_3_desc')?>' },
        ];

        var peso_para_edad = [

            { id: '1', descripcion: '<?=$this->lang->line('pediatria_peso_para_edad_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('pediatria_peso_para_edad_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('pediatria_peso_para_edad_de_3_desc')?>' },
            { id: '4', descripcion: '<?=$this->lang->line('pediatria_peso_para_edad_de_4_desc')?>' },
        ];

        var peso_para_talla = [

            { id: '1', descripcion: '<?=$this->lang->line('pediatria_peso_para_talla_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('pediatria_peso_para_talla_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('pediatria_peso_para_talla_de_3_desc')?>' },
            { id: '4', descripcion: '<?=$this->lang->line('pediatria_peso_para_talla_de_4_desc')?>' },
            { id: '5', descripcion: '<?=$this->lang->line('pediatria_peso_para_talla_de_5_desc')?>' },
            { id: '6', descripcion: '<?=$this->lang->line('pediatria_peso_para_talla_de_6_desc')?>' }
        ];

        var imc = [

            { id: '1', descripcion: '<?=$this->lang->line('pediatria_imc_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('pediatria_imc_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('pediatria_imc_de_3_desc')?>' },
            { id: '4', descripcion: '<?=$this->lang->line('pediatria_imc_de_4_desc')?>' },
            { id: '5', descripcion: '<?=$this->lang->line('pediatria_imc_de_5_desc')?>' }
        ];

        var perimetro_cefalico = [

            { id: '1', descripcion: '<?=$this->lang->line('pediatria_perimetro_cefalico_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('pediatria_perimetro_cefalico_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('pediatria_perimetro_cefalico_de_3_desc')?>' }
        ];

        // Cambia texto según selección de la desviación.
        $('#pediatria_talla_para_edad_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in talla_para_edad )
                    if( talla_para_edad[i].id == $(this).val() )
                        $('#pediatria_talla_para_edad_de_desc').html( talla_para_edad[i].descripcion );
            } else
                $('#pediatria_talla_para_edad_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#pediatria_peso_para_edad_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in peso_para_edad )
                    if( peso_para_edad[i].id == $(this).val() )
                        $('#pediatria_peso_para_edad_de_desc').html( peso_para_edad[i].descripcion );
            } else
                $('#pediatria_peso_para_edad_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#pediatria_peso_para_talla_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in peso_para_talla )
                    if( peso_para_talla[i].id == $(this).val() )
                        $('#pediatria_peso_para_talla_de_desc').html( peso_para_talla[i].descripcion );
            } else
                $('#pediatria_peso_para_talla_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#pediatria_imc_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in imc )
                    if( imc[i].id == $(this).val() )
                        $('#pediatria_imc_de_desc').html( imc[i].descripcion );
            } else
                $('#pediatria_imc_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#pediatria_perimetro_cefalico_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in perimetro_cefalico )
                    if( perimetro_cefalico[i].id == $(this).val() )
                        $('#pediatria_perimetro_cefalico_de_desc').html( perimetro_cefalico[i].descripcion );
            } else
                $('#pediatria_perimetro_cefalico_de_desc').html( '-' );
        } );

        // Levanta ventana con imagen de desviación estándar de la talla para la edad
        $('#pediatria_talla_para_edad_de_imagen').click( function( event ) {

            intervalo = '';

            event.preventDefault();
            // $('#edad') Definido en vista "tc_nueva.php"
            edad = $('#edad').val( );

            // $('#sexo') Definido en vista "tc_nueva.php" (M o F)
            sexo = $('#sexo').val( );

            if( edad >= 0 && edad <= 2 )
                intervalo = '0-2';
            if( edad > 2 && edad <= 5 )
                intervalo = '2-5';
            if( edad > 5 && edad <= 18 )
                intervalo = '5-18';

            if( intervalo != '' )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/talla_para_edad_'+sexo.toLowerCase()+'_'+intervalo+'.png' );
        } );

        // Levanta ventana con imagen de desviación estándar del peso para la edad
        $('#pediatria_peso_para_edad_de_imagen').click( function( event ) {

            event.preventDefault();
            // $('#edad') Definido en vista "tc_nueva.php"
            edad = $('#edad').val( );

            // $('#sexo') Definido en vista "tc_nueva.php" (M o F)
            sexo = $('#sexo').val( );

            if( edad >= 0 && edad <= 2 )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/peso_para_edad_'+sexo.toLowerCase()+'_0-2.png' );
            if( edad > 2 && edad <= 5 )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/peso_para_edad_'+sexo.toLowerCase()+'_2-5.png' );
            if( edad > 5 && edad <= 18 )
                jAlert( '<?=$this->lang->line( 'no_aplica' )?>' );
        } );

        // Levanta ventana con imagen de desviación estándar del peso para la edad
        $('#pediatria_peso_para_talla_de_imagen').click( function( event ) {

            event.preventDefault();
            // $('#edad') Definido en vista "tc_nueva.php"
            edad = $('#edad').val( );

            // $('#sexo') Definido en vista "tc_nueva.php" (M o F)
            sexo = $('#sexo').val( );

            if( edad >= 0 && edad <= 2 )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/peso_para_talla_'+sexo.toLowerCase()+'_0-2.png' );
            if( edad > 2 && edad <= 5 )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/peso_para_talla_'+sexo.toLowerCase()+'_2-5.png' );
            if( edad > 5 && edad <= 18 )
                jAlert( '<?=$this->lang->line( 'no_aplica' )?>' );
        } );

        // Levanta ventana con imagen de desviación estándar del IMC
        $('#pediatria_imc_imagen').click( function( event ) {

            intervalo = '';

            event.preventDefault();

            // $('#edad') Definido en vista "tc_nueva.php"
            edad = $('#edad').val( );

            // $('#sexo') Definido en vista "tc_nueva.php" (M o F)
            sexo = $('#sexo').val( );

            if( edad >= 0 && edad <= 2 )
                intervalo = '0-2';
            if( edad > 2 && edad <= 5 )
                intervalo = '2-5';
            if( edad > 5 && edad <= 18 )
                intervalo = '5-18';

            if( intervalo != '' )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/imc_'+sexo.toLowerCase()+'_'+intervalo+'.png' );
        } );

        // Levanta ventana con imagen de desviación estándar del perímetro encefálico
        $('#pediatria_perimetro_cefalico_imagen').click( function( event ) {

            event.preventDefault();
            // $('#edad') Definido en vista "tc_nueva.php"
            edad = $('#edad').val( );

            // $('#sexo') Definido en vista "tc_nueva.php" (M o F)
            sexo = $('#sexo').val( );

            if( edad >= 0 && edad <= 2 )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/perimetro_cefalico_'+sexo.toLowerCase()+'_0-5.png' );
            if( edad > 2 && edad <= 5 )
                window.open( '<?=base_url()?>images/forms/<?=$this->session->userdata('SIT_PAIS')?>/<?=$archivo_formulario?>/perimetro_cefalico_'+sexo.toLowerCase()+'_0-5.png' );
            if( edad > 5 && edad <= 18 )
                jAlert( '<?=$this->lang->line( 'no_aplica' )?>' );
        } );

    } );
</script>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Título de desviación estandar -->
        <tr>
            <td colspan="2" align="center" style="font-weight: bold;"><?=$this->lang->line('pediatria_desviaciones_estandar')?></td>
        </tr>

        <!-- Talla para la edad -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_talla_para_edad_de')?>:</td>
            <td align="left">
                <select name="pediatria_talla_para_edad_de" id="pediatria_talla_para_edad_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $pediatria_talla_para_edad_de ) && !empty($pediatria_talla_para_edad_de) && $pediatria_talla_para_edad_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_talla_para_edad_de_1')?></option>
                    <option value="2" <?=( isset( $pediatria_talla_para_edad_de ) && !empty($pediatria_talla_para_edad_de) && $pediatria_talla_para_edad_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_talla_para_edad_de_2')?></option>
                    <option value="3" <?=( isset( $pediatria_talla_para_edad_de ) && !empty($pediatria_talla_para_edad_de) && $pediatria_talla_para_edad_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_talla_para_edad_de_3')?></option>
                </select>

                &nbsp;<a href="#" id="pediatria_talla_para_edad_de_imagen" ><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="pediatria_talla_para_edad_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $pediatria_talla_para_edad_de ) && !empty($pediatria_talla_para_edad_de) ) {
                            switch( $pediatria_talla_para_edad_de ) {

                                case '1' : echo $this->lang->line('pediatria_talla_para_edad_de_1_desc'); break;
                                case '2' : echo $this->lang->line('pediatria_talla_para_edad_de_2_desc'); break;
                                case '3' : echo $this->lang->line('pediatria_talla_para_edad_de_3_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- Peso para la edad -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_peso_para_edad_de')?>:</td>
            <td align="left">
                <select name="pediatria_peso_para_edad_de" id="pediatria_peso_para_edad_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $pediatria_peso_para_edad_de ) && !empty($pediatria_peso_para_edad_de) && $pediatria_peso_para_edad_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_edad_de_1')?></option>
                    <option value="2" <?=( isset( $pediatria_peso_para_edad_de ) && !empty($pediatria_peso_para_edad_de) && $pediatria_peso_para_edad_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_edad_de_2')?></option>
                    <option value="3" <?=( isset( $pediatria_peso_para_edad_de ) && !empty($pediatria_peso_para_edad_de) && $pediatria_peso_para_edad_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_edad_de_3')?></option>
                    <option value="4" <?=( isset( $pediatria_peso_para_edad_de ) && !empty($pediatria_peso_para_edad_de) && $pediatria_peso_para_edad_de == '4' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_edad_de_4')?></option>
                </select>
                &nbsp;<a href="#" id="pediatria_peso_para_edad_de_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="pediatria_peso_para_edad_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $pediatria_peso_para_edad_de ) && !empty($pediatria_peso_para_edad_de) ) {
                            switch( $pediatria_peso_para_edad_de ) {

                                case '1' : echo $this->lang->line('pediatria_peso_para_edad_de_1_desc'); break;
                                case '2' : echo $this->lang->line('pediatria_peso_para_edad_de_2_desc'); break;
                                case '3' : echo $this->lang->line('pediatria_peso_para_edad_de_3_desc'); break;
                                case '4' : echo $this->lang->line('pediatria_peso_para_edad_de_4_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- Peso para la talla -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_peso_para_talla_de')?>:</td>
            <td align="left">
                <select name="pediatria_peso_para_talla_de" id="pediatria_peso_para_talla_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) && $pediatria_peso_para_talla_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_talla_de_1')?></option>
                    <option value="2" <?=( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) && $pediatria_peso_para_talla_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_talla_de_2')?></option>
                    <option value="3" <?=( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) && $pediatria_peso_para_talla_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_talla_de_3')?></option>
                    <option value="4" <?=( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) && $pediatria_peso_para_talla_de == '4' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_talla_de_4')?></option>
                    <option value="5" <?=( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) && $pediatria_peso_para_talla_de == '5' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_talla_de_5')?></option>
                    <option value="6" <?=( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) && $pediatria_peso_para_talla_de == '6' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_peso_para_talla_de_6')?></option>
                </select>
                <?=$this->lang->line('pediatria_kg')?>
                &nbsp;<a href="#" id="pediatria_peso_para_talla_de_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="pediatria_peso_para_talla_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $pediatria_peso_para_talla_de ) && !empty($pediatria_peso_para_talla_de) ) {
                            switch( $pediatria_peso_para_talla_de ) {

                                case '1' : echo $this->lang->line('pediatria_peso_para_talla_de_1_desc'); break;
                                case '2' : echo $this->lang->line('pediatria_peso_para_talla_de_2_desc'); break;
                                case '3' : echo $this->lang->line('pediatria_peso_para_talla_de_3_desc'); break;
                                case '4' : echo $this->lang->line('pediatria_peso_para_talla_de_4_desc'); break;
                                case '5' : echo $this->lang->line('pediatria_peso_para_talla_de_5_desc'); break;
                                case '6' : echo $this->lang->line('pediatria_peso_para_talla_de_6_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- IMC -->
        <tr>
            <td class="data_form"><?=$this->lang->line('df_imc')?>:</td>
            <td align="left">
                <select name="pediatria_imc_de" id="pediatria_imc_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $pediatria_imc_de ) && !empty($pediatria_imc_de) && $pediatria_imc_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_imc_de_1')?></option>
                    <option value="2" <?=( isset( $pediatria_imc_de ) && !empty($pediatria_imc_de) && $pediatria_imc_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_imc_de_2')?></option>
                    <option value="3" <?=( isset( $pediatria_imc_de ) && !empty($pediatria_imc_de) && $pediatria_imc_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_imc_de_3')?></option>
                    <option value="4" <?=( isset( $pediatria_imc_de ) && !empty($pediatria_imc_de) && $pediatria_imc_de == '4' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_imc_de_4')?></option>
                    <option value="5" <?=( isset( $pediatria_imc_de ) && !empty($pediatria_imc_de) && $pediatria_imc_de == '5' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_imc_de_5')?></option>
                </select>

                &nbsp;<a href="#" id="pediatria_imc_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="pediatria_imc_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $pediatria_imc_de ) && !empty($pediatria_imc_de) ) {
                            switch( $pediatria_imc_de ) {

                                case '1' : echo $this->lang->line('pediatria_imc_de_1_desc'); break;
                                case '2' : echo $this->lang->line('pediatria_imc_de_2_desc'); break;
                                case '3' : echo $this->lang->line('pediatria_imc_de_3_desc'); break;
                                case '4' : echo $this->lang->line('pediatria_imc_de_4_desc'); break;
                                case '5' : echo $this->lang->line('pediatria_imc_de_5_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- Perimetro cefálico -->
        <tr>
            <td class="data_form"><?=$this->lang->line('df_perimetro_cefalico')?>:</td>
            <td align="left">

                <select name="pediatria_perimetro_cefalico_de" id="pediatria_perimetro_cefalico_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $pediatria_perimetro_cefalico_de ) && !empty($pediatria_perimetro_cefalico_de) && $pediatria_perimetro_cefalico_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_perimetro_cefalico_de_1')?></option>
                    <option value="2" <?=( isset( $pediatria_perimetro_cefalico_de ) && !empty($pediatria_perimetro_cefalico_de) && $pediatria_perimetro_cefalico_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_perimetro_cefalico_de_2')?></option>
                    <option value="3" <?=( isset( $pediatria_perimetro_cefalico_de ) && !empty($pediatria_perimetro_cefalico_de) && $pediatria_perimetro_cefalico_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('pediatria_perimetro_cefalico_de_3')?></option>
                </select>

                &nbsp;<a href="#" id="pediatria_perimetro_cefalico_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="pediatria_perimetro_cefalico_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $pediatria_perimetro_cefalico_de ) && !empty($pediatria_perimetro_cefalico_de) ) {
                            switch( $pediatria_perimetro_cefalico_de ) {

                                case '1' : echo $this->lang->line('pediatria_perimetro_cefalico_de_1_desc'); break;
                                case '2' : echo $this->lang->line('pediatria_perimetro_cefalico_de_2_desc'); break;
                                case '3' : echo $this->lang->line('pediatria_perimetro_cefalico_de_3_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
            </td>
        </tr>

    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Talla para edad
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_talla_para_edad_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_talla_para_edad_de) && !empty($pediatria_talla_para_edad_de) )?
            $this->lang->line( 'pediatria_talla_para_edad_de_'.$pediatria_talla_para_edad_de ) .
            ' ('.$this->lang->line( 'pediatria_talla_para_edad_de_'.$pediatria_talla_para_edad_de.'_desc' ).')' : '' ), 0, 'L', false, 0 );

    // Peso para la edad
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_peso_para_edad_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_peso_para_edad_de) && !empty($pediatria_peso_para_edad_de) )?
            $this->lang->line( 'pediatria_peso_para_edad_de_'.$pediatria_peso_para_edad_de ) .
            ' ('.$this->lang->line( 'pediatria_peso_para_edad_de_'.$pediatria_peso_para_edad_de.'_desc' ).')':'' ), 0, 'L', false, 0 );

    // Peso para la talla
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_peso_para_talla_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_peso_para_talla_de) && !empty($pediatria_peso_para_talla_de) )?
            $this->lang->line( 'pediatria_peso_para_talla_de_'.$pediatria_peso_para_talla_de ) .
            ' ('.$this->lang->line( 'pediatria_peso_para_talla_de_'.$pediatria_peso_para_talla_de.'_desc' ).')' :'' ), 0, 'L', false, 0 );

    // IMC
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_imc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_imc_de) && !empty($pediatria_imc_de) )?
            $this->lang->line( 'pediatria_imc_de_'.$pediatria_imc_de ) .
            ' ('.$this->lang->line( 'pediatria_imc_de_'.$pediatria_imc_de.'_desc' ).')' : '' ), 0, 'L', false, 0 );

    // Perimetro cefálico
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_perimetro_cefalico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_perimetro_cefalico_de) && !empty($pediatria_perimetro_cefalico_de) )?
            $this->lang->line( 'pediatria_perimetro_cefalico_de_'.$pediatria_perimetro_cefalico_de ) .
            ' ('.$this->lang->line( 'pediatria_perimetro_cefalico_de_'.$pediatria_perimetro_cefalico_de.'_desc' ) .')' : '' ), 0, 'L', false, 0 );
}

