<?php if( $modo == FormularioXML::$MODO_LECTURA ) {

    if( isset( $dm_general ) && !empty( $dm_general ) ) {
        
        foreach( $dm_general as $clave => $valor ) { ?>

            <?=$valor?><br/><br/>
<?php   }
    } else {
        echo $this->lang->line( 'dm_sin_diagnosticos' );
    }

}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<style>
    .ui-autocomplete {
        max-height: 100px;
        overflow-y: auto;
        /* prevent horizontal scrollbar */
        overflow-x: hidden;
    }

    * html .ui-autocomplete {
        height: 100px;
    }
</style>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        $( "#input_diagnostico_medico" ).autocomplete({
            minLength: 2,
            source: function( request, response ) {

                        $.getJSON(
                            '<?=base_url()?>platc/diagnosticos_medicos_busqueda_por_texto/'+request.term,
                            {},
                            function( data ) {
                                response( data );
                            }
                        );
                    },
            select: function( event, ui ) {

                if( typeof ui !== 'undefined' ){
                    
                    if( ui.item.label != '' && ui.item.value != '' ) {
                        $( "#input_diagnostico_medico" ).val( ui.item.label );
                        $( "#hidden_diagnostico_medico" ).val( ui.item.value );
                    }
                }

                return false;
            }
        });
        
        $('#dm_agregar').click( function() {

            texto_dm = $('#input_diagnostico_medico').val();
            valor_dm = $('#hidden_diagnostico_medico').val();
            
            if( texto_dm != '' && valor_dm != '' ) {
                
                // Inserta texto en tabla
                html = "<tr style=\"display: none;\"><td>"+texto_dm+"</td><td><a href=\"#\" ><img src=\"<?=base_url()?>images/trash.gif\" /><input type=\"hidden\" name=\"dm_general[]\" value=\""+valor_dm+"\" /></a></td></tr>";
                $('#dm_codigos_seleccionados').append(html);
                $('#dm_codigos_seleccionados a').bind( 'click', dm_eliminar );
                $('#dm_codigos_seleccionados tr:last').fadeIn('slow');

                // Elimina texto del campo de búsqueda
                $('#input_diagnostico_medico').val('');
                $('#hidden_diagnostico_medico').val('');
            }
        } );

        // Asocia eventos para eliminar en campos ya ingresados
        $('#dm_codigos_seleccionados a').bind( 'click', dm_eliminar );
    } );

    function dm_eliminar ( ) {

        $(this).parent().parent().remove();
        return false;
    }
</script>

<?=$this->lang->line('dm_cie10')?><br/>
<div class="ui-widget">
    <input type="text" id="input_diagnostico_medico" size="55" value="" />
    <input type="hidden" id="hidden_diagnostico_medico" value="" />
    <img src="<?=base_url()?>images/crear.png" id="dm_agregar" width="16px" height="16px" />
</div>
    
<table id="dm_codigos_seleccionados">
    <?php if( isset( $dm_general ) && !empty( $dm_general ) ) {
        foreach( $dm_general as $clave => $valor ) {
    ?>
        <tr>
            <td><?=$valor?></td>
            <td>
                <a href="#" >
                    <img src="<?=base_url()?>images/trash.gif" />
                    <input type="hidden" name="dm_general[]" value="<?=$clave?>" />
                </a>
            </td>
        </tr>
    <?php }
    }
    ?>
</table>
<br/>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    if( isset( $dm_general ) && !empty( $dm_general ) ) {
        
        $x = $pdf->GetX( );
        foreach( $dm_general as $clave => $valor ) {
            $pdf->MultiCell( 0, 6, utf8_decode( html_entity_decode( $valor ) ), 0, 'L', false, 0 );
            $pdf->SetX( $x );
        }
    } else
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'dm_sin_diagnosticos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
}