<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if( $modo == FormularioXML::$MODO_LECTURA )  { ?>

    <style type="text/css">
        #cockcroft_gault_div {}

        #cockcroft_gault_div input {
            text-align: right;
            width: 50px;
        }

        #cockcroft_gault_div td.item_etiqueta {
            text-align: right;
            width: 100px;
        }

        #cockcroft_gault_div td.item_valores {
            text-align: left;
            width: 200px;
        }

        #cockcroft_gault_div td.indices {
            text-align: center;
        }

        #cockcroft_gault_div .calculos {
            text-align: right;
            height: 20px;
            width: 180px;
            background-color: #CCCCCC;
            padding: 10px 5px 10 0;
        }

        #cockcroft_gault_div .botonera {
            text-align: center;
        }
    </style>

    <div id="cockcroft_gault_div">
        
        <table border="0" cellpadding="0" cellspacing="5">

            <!-- Sexo -->
            <tr>
                <td><?=$this->lang->line('p_sexo')?>:</td>
                <td><?php
                    switch( $tc['TEL_PAC_SEXO'] ) {
                        case "M" : echo $this->lang->line('p_masculino'); break;
                        case "F" : echo $this->lang->line('p_femenino'); break;
                        default: echo " - ";
                    } ?></td>
            </tr>

            <!-- Edad -->
            <tr>
                <td><?=$this->lang->line('p_edad')?>:</td>
                <td><?=$tc['TEL_PAC_EDAD']?> <?=$this->lang->line('anos')?></td>
            </tr>

            <!-- Talla -->
            <tr>
                <td><?=$this->lang->line('talla')?>:</td>
                <td><?=( isset( $df_talla ) && !empty( $df_talla ) ) ? $df_talla : ' - '?> <?=$this->lang->line('cm')?></td>
            </tr>

            <!-- Peso -->
            <tr>
                <td><?=$this->lang->line('df_peso')?>:</td>
                <td><?=( isset( $df_peso ) && !empty( $df_peso ) ) ? $df_peso : ' - '?> <?=$this->lang->line('kg')?></td>
            </tr>

            <!-- Creatinina -->
            <tr>
                <td><?=$this->lang->line('creatinina')?>:</td>
                <td><?= ( isset( $cg_creatinina ) && !empty( $cg_creatinina ) ) ? $cg_creatinina : "" ?> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Superficie corporal -->
            <tr>
                <td class="etiqueta"><?=$this->lang->line('superficie_corporal')?>:</td>
                <td><?=( isset( $cg_superficie_corporal ) && !empty( $cg_superficie_corporal ) ) ? $cg_superficie_corporal: ' - '?> <?=$this->lang->line('m2')?></td>
            </tr>

            <!-- IMC -->
            <tr>
                <td class="etiqueta"><?=$this->lang->line('pediatria_imc_de')?>:</td>
                <td><?=( isset( $df_imc ) && !empty( $df_imc ) ) ? $df_imc: ' - '?> <?=$this->lang->line('kg_m2')?> </td>
            </tr>

            <!-- Cockcroft-Gault -->
            <tr>
                <td class="etiqueta"><?=$this->lang->line('c_g')?>:</td>
                <td><?=( isset( $cg_cockcroft_gault ) && !empty( $cg_cockcroft_gault ) ) ? $cg_cockcroft_gault : ' - '?> <?=$this->lang->line('ml_min')?></td>
            </tr>

            <!-- Cockcroft-Gault corregido por SC -->
            <tr>
                <td class="etiqueta"><?=$this->lang->line('c_g_corregido_sc')?>:</td>
                <td><?=( isset( $cg_cockcroft_gault_por_sc ) && !empty( $cg_cockcroft_gault_por_sc ) ) ? $cg_cockcroft_gault_por_sc : ' - '?> <?=$this->lang->line('ml_min_1.73m2')?></td>
            </tr>

            <!-- Clasificación del paciente según estadio -->
            <tr>
                <td class="etiqueta"><?=$this->lang->line('clasificacion_paciente_segun_estadio_kdoq')?>:</td>
                <td>
                <?php
                    if( isset( $cg_clasificacion_paciente_segun_estadio_kdoq ) && !empty( $cg_clasificacion_paciente_segun_estadio_kdoq ) )
                        echo $this->lang->line( $cg_clasificacion_paciente_segun_estadio_kdoq );
                    else
                        echo " - ";
                ?>
                </td>
            </tr>
        </table>

    </div>
	<hr/>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA )  { ?>

    <style type="text/css">
        #cockcroft_gault_div {}

        #cockcroft_gault_div input {
            text-align: right;
            width: 50px;
        }

        #cockcroft_gault_div td.item_etiqueta {
            text-align: right;
            width: 100px;
        }

        #cockcroft_gault_div td.item_valores {
            text-align: left;
            width: 200px;
        }

        #cockcroft_gault_div td.indices {
            text-align: center;
        }

        #cockcroft_gault_div .calculos {
            text-align: left;
            height: 20px;
            width: 180px;
            background-color: #CCCCCC;
            padding: 10px 0 10 5px;
        }

        #cockcroft_gault_div .botonera {
            text-align: center;
        }
    </style>

    <script type="text/javascript" src="<?=base_url()?>js/herramientas.js" />
    <script type="text/javascript">
        
        dg_sexo = "<?=$tc['TEL_PAC_SEXO']?>";
        dg_edad = "<?=$tc['TEL_PAC_EDAD']?>";

        $(document).ready( function( ) {

            $('#cg_creatinina').change( function( ) { recalcular_cockcroft_gault(); } );
            $('#df_talla').change( function( ) { $('#cg_talla').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );
            $('#df_peso').change( function( ) { $('#cg_peso').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );
            $('#df_imc').change( function( ) { $('#cg_indice_masa_corporal').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );

            recalcular_cockcroft_gault();
        } );

        function recalcular_cockcroft_gault( ) {

            $('#cg_talla').html( $.isEmptyObject( $('#df_talla').val() ) ? " - " : $('#df_talla').val( ) );
            $('#cg_peso').html( $.isEmptyObject( $('#df_peso').val() ) ? " - " : $('#df_peso').val( ) );
            $('#cg_indice_masa_corporal').html( $('#df_imc').val() );

            calculo_cg = 0;

            try {
                $('#cg_superficie_corporal').val( HERRAMIENTAS.redondear( HERRAMIENTAS.superficie_corporal( $('#df_talla').val(), $('#df_peso').val() ), 2 ) );
            } catch( e ) {
                $('#cg_superficie_corporal').val( "" );
            }

            try {
                
                calculo_cg = HERRAMIENTAS.cockcroft_gault( $('#df_talla').val(), $('#df_peso').val(), dg_edad, $('#cg_creatinina').val(), dg_sexo );
                $('#cg_cockcroft_gault').val( HERRAMIENTAS.redondear( calculo_cg, 2 ) );

                cockcroft_gault_por_sc = HERRAMIENTAS.cockcroft_gault_por_sc( $('#df_talla').val(), $('#df_peso').val(), dg_edad, $('#cg_creatinina').val(), dg_sexo, $('#cg_superficie_corporal').val() );
                $('#cg_cockcroft_gault_por_sc').val( HERRAMIENTAS.redondear( cockcroft_gault_por_sc, 2 ) );
            } catch( e ) {
                $('#cg_cockcroft_gault').val( "" );
                $('#cg_cockcroft_gault_por_sc').val( "" );
            }

            if( calculo_cg >= 90 ) {
                $('#clasificacion_paciente_segun_estadio_kdoq_texto').html( "<?=$this->lang->line('clasificacion_kdoq_grado1')?>" );
                $('#cg_clasificacion_paciente_segun_estadio_kdoq').val( 'clasificacion_kdoq_grado1' );
            } else if( calculo_cg >= 60 && calculo_cg < 90 ) {
                $('#clasificacion_paciente_segun_estadio_kdoq_texto').html( "<?=$this->lang->line('clasificacion_kdoq_grado2')?>" );
                $('#cg_clasificacion_paciente_segun_estadio_kdoq').val( 'clasificacion_kdoq_grado2' );
            } else if( calculo_cg >= 45 && calculo_cg < 60 ) {
                $('#clasificacion_paciente_segun_estadio_kdoq_texto').html( "<?=$this->lang->line('clasificacion_kdoq_grado3a')?>" );
                $('#cg_clasificacion_paciente_segun_estadio_kdoq').val( 'clasificacion_kdoq_grado3a' );
            } else if( calculo_cg >= 30 && calculo_cg < 45 ) {
                $('#clasificacion_paciente_segun_estadio_kdoq_texto').html( "<?=$this->lang->line('clasificacion_kdoq_grado3b')?>" );
                $('#cg_clasificacion_paciente_segun_estadio_kdoq').val( 'clasificacion_kdoq_grado3b' );
            } else if( calculo_cg >= 15 && calculo_cg < 30 ) {
                $('#clasificacion_paciente_segun_estadio_kdoq_texto').html( "<?=$this->lang->line('clasificacion_kdoq_grado4')?>" );
                $('#cg_clasificacion_paciente_segun_estadio_kdoq').val( 'clasificacion_kdoq_grado4' );
            } else if( calculo_cg < 15 ) {
                $('#clasificacion_paciente_segun_estadio_kdoq_texto').html( "<?=$this->lang->line('clasificacion_kdoq_grado5')?>" );
                $('#cg_clasificacion_paciente_segun_estadio_kdoq').val( 'clasificacion_kdoq_grado5' );
            } else 
                $('#cg_clasificacion_paciente_segun_estadio_kdoq_texto').html( "-" );
        }

    </script>

    <div id="cockcroft_gault_div">
        <table border="0" cellpadding="5" cellspacing="0">

            <!-- Sexo -->
            <tr>
                <td><?=$this->lang->line('p_sexo')?>:</td>
                <td><?php
                    switch( $tc['TEL_PAC_SEXO'] ) {
                        case "M" : echo $this->lang->line('p_masculino'); break;
                        case "F" : echo $this->lang->line('p_femenino'); break;
                        default: echo " - ";
                    } ?></td>
            </tr>

            <!-- Edad -->
            <tr>
                <td><?=$this->lang->line('p_edad')?>:</td>
                <td><?=$tc['TEL_PAC_EDAD']?> <?=$this->lang->line('anos')?></td>
            </tr>

            <!-- Talla -->
            <tr>
                <td><?=$this->lang->line('talla')?>:</td>
                <td><span id="cg_talla"> - </span></td>
            </tr>

            <!-- Peso -->
            <tr>
                <td><?=$this->lang->line('df_peso')?>:</td>
                <td><span id="cg_peso"> - </span></td>
            </tr>

            <!-- Creatinina -->
            <tr>
                <td><?=$this->lang->line('creatinina')?>:</td>
                <td><input class="validate[required]"  type="text" name="cg_creatinina" id="cg_creatinina" value="<?= ( isset( $cg_creatinina ) && !empty( $cg_creatinina ) ) ? $cg_creatinina : "" ?>" /> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Superficie corporal -->
            <tr>
                <td><?=$this->lang->line('superficie_corporal')?>:</td>
                <td>
                    <div>
                        <input class="validate[required]"  type="text" readonly="readonly" name="cg_superficie_corporal" id="cg_superficie_corporal" /> <?=$this->lang->line('m2')?>
                    </div>
                </td>
            </tr>

            <!-- IMC -->
            <tr>
                <td><?=$this->lang->line('pediatria_imc_de')?>:</td>
                <td><span id="cg_indice_masa_corporal" > - </span><?=$this->lang->line('kg_m2')?></td>
            </tr>

            <!-- Cockcroft-Gault -->
            <tr>
                <td><?=$this->lang->line('c_g')?>:</td>
                <td>
                    <div>
                        <input class="validate[required]"  type="text" readonly="readonly" name="cg_cockcroft_gault" id="cg_cockcroft_gault"><?=$this->lang->line('ml_min')?>
                    </div>
                </td>
            </tr>

            <!-- Cockcroft-Gault corregido por SC -->
            <tr>
                <td><?=$this->lang->line('c_g_corregido_sc')?>:</td>
                <td>
                    <div>
                        <input class="validate[required]"  type="text" readonly="readonly" name="cg_cockcroft_gault_por_sc" id="cg_cockcroft_gault_por_sc" /><?=$this->lang->line('ml_min_1.73m2')?>
                    </div>
                </td>
            </tr>

            <!-- Clasificación del paciente según estadio -->
            <tr>
                <td><?=$this->lang->line('clasificacion_paciente_segun_estadio_kdoq')?>:</td>
                <td>
                    <span id="clasificacion_paciente_segun_estadio_kdoq_texto" style="font-weight: bold"> - </span>
                    <input type="hidden" name="cg_clasificacion_paciente_segun_estadio_kdoq" id="cg_clasificacion_paciente_segun_estadio_kdoq" value="" />
                </td>
            </tr>
        </table>
    </div>
	<hr/>
<?php }

if( $modo == FormularioXML::$MODO_PDF )  {
	$x = $pdf->GetX();
	
	//SEXO
    if( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('p_sexo').": ".(($tc['TEL_PAC_SEXO'] = 'M') ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino')  ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//EDAD

    if( isset( $tc['TEL_PAC_EDAD'] ) && !empty( $tc['TEL_PAC_EDAD'] ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('p_edad').": ".$tc['TEL_PAC_EDAD'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//TALLA
    if( isset( $df_talla ) && !empty( $df_talla ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('talla').": ".$this->lang->line( $df_talla ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//PESO
    if( isset( $df_peso ) && !empty( $df_peso ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('df_peso').": ".$this->lang->line( $df_peso ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//CREATININA
    if( isset( $cg_creatinina ) && !empty( $cg_creatinina ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('creatinina').": ".$this->lang->line( $cg_creatinina )." ".$this->lang->line('mgdl'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//SUPERFICIE
    if( isset( $cg_superficie_corporal ) && !empty( $cg_superficie_corporal ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('superficie_corporal').": ".$this->lang->line( $cg_superficie_corporal )." ".$this->lang->line('m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//IMC
    if( isset( $df_imc ) && !empty( $df_imc ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('pediatria_imc_de').": ".$this->lang->line( $df_imc )."-".$this->lang->line('kg_m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);

	//Cockcroft-Gault
    if( isset( $cg_cockcroft_gault ) && !empty( $cg_cockcroft_gault ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('c_g').": ".$this->lang->line( $cg_cockcroft_gault )."-".$this->lang->line('ml_min'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);

	//Cockcroft-Gault corregido por SC
    if( isset( $cg_cockcroft_gault_por_sc ) && !empty( $cg_cockcroft_gault_por_sc ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('c_g_corregido_sc').": ".$this->lang->line( $cg_cockcroft_gault_por_sc )."-".$this->lang->line('ml_min_1')." ".$this->lang->line('ml_min_1.73m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//Clasificación del paciente según estadio
    if( isset( $cg_clasificacion_paciente_segun_estadio_kdoq ) && !empty( $cg_clasificacion_paciente_segun_estadio_kdoq ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line( $cg_clasificacion_paciente_segun_estadio_kdoq ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
    

}
