<?php

if( $modo == FormularioXML::$MODO_LECTURA ) {

    $clob_chkbx = !isset( $clob_chkbx ) ? array() : $clob_chkbx;

    foreach( $clob_chkbx as $valor ) {

        switch( $valor ) {

            case "clob_ninguno" : $txt = $this->lang->line('clob_ninguno');         $desc = ""; break;
            case "clob_cardiacas" : $txt = $this->lang->line('clob_cardiacas');     $desc = $this->lang->line('clob_cardiacas_descripcion'); break;
            case "clob_cerebrales" : $txt = $this->lang->line('clob_cerebrales');   $desc = $this->lang->line('clob_cerebrales_descripcion'); break;
            case "clob_retinianas" : $txt = $this->lang->line('clob_retinianas');   $desc = $this->lang->line('clob_retinianas_descripcion'); break;
            case "clob_vascular_periferico" : $txt = $this->lang->line('clob_vascular_periferico'); $desc = $this->lang->line('clob_vascular_periferico_descripcion'); break;
            case "clob_renales" : $txt = $this->lang->line('clob_renales');         $desc = $this->lang->line('clob_renales_descripcion'); break;
            default: " - ";
        }
?>
            <span style="font-weight: bold;"><?=$txt?></span><br />
            <p><?= isset( $desc ) ? $desc : "" ?></p><br/><br/>
<?php
    }
	echo "<hr/>";
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        // 0: Ninguno
        $('#clob_chkbx_ninguno').click( function( ) {

            if( $(this).is( ':checked' ) )
                $(this).siblings( 'input' ).removeAttr( "checked" );
        } );

        // 2: Cardiacas 3: Cerebrales 4: Retinianas 5: Vascular periférico 6: Renales
        $('#clob_chkbx_ninguno').siblings('input').click( function( ) {
            $('#clob_chkbx_ninguno').removeAttr( "checked" );
        } );
    } );

</script>

<?php $clob_chkbx = !isset( $clob_chkbx ) ? array() : $clob_chkbx; ?>

<!-- 0: Ninguno -->
<input  type="checkbox" id="clob_chkbx_ninguno" name="clob_chkbx[]" value="clob_ninguno"
        class="validate[minCheckbox[1]] validate[required]" <?= ( array_search( 'clob_ninguno', $clob_chkbx ) !== FALSE ) ? 'checked="checked"' : "" ?> />
<label for="clob_chkbx_ninguno" style="font-weight: bold;"><?= $this->lang->line('clob_ninguno') ?></label>
<br/>

<!--1: Cardíacas -->
<input  type="checkbox" id="clob_chkbx_cardiacas" name="clob_chkbx[]" value="clob_cardiacas"
        class="validate[minCheckbox[1]] validate[required]" <?=( array_search( 'clob_cardiacas', $clob_chkbx ) !== FALSE ) ? 'checked="checked"' : "" ?> />
<label for="clob_chkbx_cardiacas" style="font-weight: bold;"><?=$this->lang->line('clob_cardiacas') ?></label>
<p style="font-style: italic;"><?=$this->lang->line('clob_cardiacas_descripcion') ?></p>
<br/>

<!-- 2: Cerebrales -->
<input  type="checkbox" id="clob_chkbx_cerebrales" name="clob_chkbx[]" value="clob_cerebrales"
        class="validate[minCheckbox[1]] validate[required]" <?=( array_search( 'clob_cerebrales', $clob_chkbx ) !== FALSE ) ? 'checked="checked"' : "" ?> />
<label for="clob_chkbx_cerebrales" style="font-weight: bold;"><?= $this->lang->line('clob_cerebrales') ?></label>
<p style="font-style: italic;"><?=$this->lang->line('clob_cerebrales_descripcion');?></p>
<br/>

<!-- 3: Retinianas -->
<input  type="checkbox" id="clob_chkbx_retinianas" name="clob_chkbx[]" value="clob_retinianas"
        class="validate[minCheckbox[1]] validate[required]" <?=( array_search( 'clob_retinianas', $clob_chkbx ) !== FALSE ) ? 'checked="checked"' : "" ?> />
<label for="clob_chkbx_retinianas" style="font-weight: bold;"><?= $this->lang->line('clob_retinianas') ?></label>
<p style="font-style: italic;"><?=$this->lang->line('clob_retinianas_descripcion');?></p>
<br/>

<!-- 4: Vascular periferico -->
<input  type="checkbox" id="clob_chkbx_vascular_periferico" name="clob_chkbx[]" value="clob_vascular_periferico"
        class="validate[minCheckbox[1]] validate[required]" <?=( array_search( 'clob_vascular_periferico', $clob_chkbx ) !== FALSE ) ? 'checked="checked"' : "" ?> />
<label for="clob_chkbx_vascular_periferico" style="font-weight: bold;"><?= $this->lang->line('clob_vascular_periferico') ?></label>
<p style="font-style: italic;"><?=$this->lang->line('clob_vascular_periferico_descripcion');?></p>
<br/>

<!-- 5: Renales -->
<input  type="checkbox" id="clob_chkbx_renales" name="clob_chkbx[]" value="clob_renales"
        class="validate[minCheckbox[1]] validate[required]" <?=( array_search( 'clob_renales', $clob_chkbx ) !== FALSE ) ? 'checked="checked"' : "" ?> />
<label for="clob_chkbx_renales" style="font-weight: bold;"><?= $this->lang->line('clob_renales') ?></label>
<p style="font-style: italic;"><?=$this->lang->line('clob_renales_descripcion');?></p>
<br/>
<hr/>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $clob_chkbx = !isset( $clob_chkbx ) ? array() : $clob_chkbx;

    $x = $pdf->GetX();

    foreach( $clob_chkbx as $valor ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( $valor ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
        $pdf->SetX( $x );

        $pdf->SetFont( 'Arial' );
        $pdf->MultiCell( 0, 6, utf8_decode( ${$valor} ), 0, 'L', false, 0 );
        $pdf->Ln();
        $pdf->SetX( $x );
    }
}