<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>
<?php
    // Largo en pixeles de los graficos de barra del factor de riesgo
    $css_largo_barra = 350;
?>
<style type="text/css" >
    div.graph3
    {
        width: <?=$css_largo_barra?>px;
        margin: 10px 0px;
        padding: 0px;
        /*border: 1px solid #000000;*/
    }
    div.leg
    {
        text-align: center;
        padding: 1px;
        width: 99%;
        margin: 0px;
    }
    div.grnbr
    {
        float: left;
        height: 20px;
        background: #55AA55;
        margin: 0px;
        padding: 0px;
        display: inline;
        border-right: 1px solid #ffffff;
    }
    div.bar
    {
        width: 100%;
        background: #cccccc;
        height: 20px;
        margin: 0px;
        padding: 0px;
    }
    div.relpos
    {
        position: relative;
        margin-bottom: 4px;
    } 
    div.abspos
    {
        position: absolute; 
    } 
    div.w100
    {
        width: 100%; 
    }
    div.reslts
    {
        position: absolute;
        right: 0;
        margin: 0px;
        padding: 3px 5px;
        display: inline;
    }
    div.grnbrbc
    {
        float: left;
        height: 20px;
        background: #eebb00;
        margin: 0px;
        padding: 0px;
        border-right: 1px solid #ffffff;
    }

</style>

<script src="<?=base_url()?>js/gencvd10_bmi_calc.js" type="text/javascript"></script>

<table cellspacing="0" cellpadding="5" border="0" align="center" >
    <tr>
        <td><span><?=$this->lang->line('fr_colesterol_total')?>:</span></td>
        <td align="left">
            <?=isset( $fr_colesterol_total ) ? $fr_colesterol_total : ''?>
        </td>
    </tr>
    <tr>
        <td><span><?=$this->lang->line('fr_colesterol_hdl')?>:</span></td>
        <td align="left">
            <?=isset( $fr_colesterol_hdl ) ? $fr_colesterol_hdl : ''?>
        </td>
    </tr>
    <tr>
        <td><span><?=$this->lang->line('fr_fumador')?>:</span></td>
        <td>
            <?php if( isset( $fr_rdbtn_fumador ) && $fr_rdbtn_fumador == 1 )
                echo $this->lang->line('fr_si');
            else
                echo $this->lang->line('fr_no');
            ?>
        </td>
    </tr>
    <tr>
        <td><span><?=$this->lang->line('fr_tratamiento_antihipertensivo')?>:</span></td>
        <td>
            <?php if( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && $fr_rdbtn_tratamiento_antihipertensivo == 1 )
                echo $this->lang->line('fr_si');
            else
                echo $this->lang->line('fr_no');
            ?>
        </td>
    </tr>
    <tr>
        <td><span><?=$this->lang->line('fr_diabetes')?>:</span></td>
        <td>
            <?php if( isset( $fr_rdbtn_diabetes ) && $fr_rdbtn_diabetes == 1 )
                echo $this->lang->line('fr_si');
            else
                echo $this->lang->line('fr_no');
            ?>
        </td>
    </tr>
</table>

<!-- Resultados -->
<table cellspacing="0" cellpadding="5" border="0" align="center" >
	<tr>
		<!-- Edad del vascular del corazon -->
		<td><span><?=$this->lang->line('fr_edad_vascular_corazon')?>:</span> </td>
		<td align="left">
			<?=isset( $fr_edad_vascular_corazon ) ? $fr_edad_vascular_corazon : ' - '?>
		</td>
	</tr>
	<tr>
		<!-- Riesgo a diez años -->
		<td><span><?=$this->lang->line('fr_riesgo_diez_anos')?>:</span> </td>
		<td align="left">
			<?=isset( $fr_riesgo_diez_anos ) ? $fr_riesgo_diez_anos : ' - '?> %
		</td>
	</tr>
	<tr>
		<!-- Riesgo normal -->
		<td><span><?=$this->lang->line('fr_riesgo_normal')?>:</span></td>
		<td align="left">
			<?=isset( $fr_riesgo_normal ) ? $fr_riesgo_normal : ' - '?> %
		</td>
	</tr>
	<tr>
		<!-- Riesgo optimo -->
		<td><span><?=$this->lang->line('fr_riesgo_optimo')?>:</span></td>
		<td align="left">
			<?=isset( $fr_riesgo_optimo ) ? $fr_riesgo_optimo : ' - '?> %
		</td>
	</tr>

	<tr>
		<td colspan="2">
			<div class="graph3">
				<div class="bar relpos">
				   <div class="leg abspos w100"><?=$this->lang->line('fr_riesgo_diez_anos')?></div>
				   <div class="grnbr" style="width:<?= ( isset( $fr_riesgo_diez_anos ) ) ? (int) ( ($fr_riesgo_diez_anos*$css_largo_barra)/100 ) : 0; ?>px;"></div>
				   <div class="reslts" ><?=isset( $fr_riesgo_diez_anos ) ? $fr_riesgo_diez_anos : ' - '?> %</div>
				</div>

				<div class="bar relpos">
					<div class="grnbrbc" style="width:<?= ( isset( $fr_riesgo_normal ) ) ? (int) ( ( $fr_riesgo_normal*$css_largo_barra)/100 ) : 0; ?>px;"></div>
					<div class="reslts"><?=isset( $fr_riesgo_normal ) ? $fr_riesgo_normal : ' - '?> %</div>
					<div class="leg abspos"><?=$this->lang->line( 'fr_riesgo_normal' )?></div>
				</div>

				<div class="bar relpos">
					<div class="grnbrbc" style="width:<?= ( isset( $fr_riesgo_optimo ) ) ? (int) ( ( $fr_riesgo_optimo*$css_largo_barra)/100 ) : 0; ?>px;"></div>
					<div class="reslts"><?=isset( $fr_riesgo_optimo ) ? $fr_riesgo_optimo : ' - '?> %</div>
					<div class="leg abspos"><?=$this->lang->line( 'fr_riesgo_optimo' )?></div>
				</div>
			</div>
		</td>
	</tr>
</table>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<style type="text/css" >
    div.graph3
    {
        width: 350px;
        margin: 10px 0px;
        padding: 0px;
        /*border: 1px solid #000000;*/
    }
    div.leg
    {
        text-align: center;
        padding: 1px;
        width: 99%;
        margin: 0px;
    }
    div.grnbr
    {
        float: left;
        height: 20px;
        background: #55AA55;
        margin: 0px;
        padding: 0px;
        display: inline;
        border-right: 1px solid #ffffff;
    }
    div.bar
    {
        width: 100%;
        background: #cccccc;
        height: 20px;
        margin: 0px;
        padding: 0px;
    }
    div.relpos
    {
        position: relative;
        margin-bottom: 4px;
    } 
    div.abspos
    {
        position: absolute; 
    } 
    div.w100
    {
        width: 100%; 
    }
    div.reslts
    {
        position: absolute;
        right: 0;
        margin: 0px;
        padding: 3px 5px;
        display: inline;
    }
    div.grnbrbc
    {
        float: left;
        height: 20px;
        background: #eebb00;
        margin: 0px;
        padding: 0px;
        border-right: 1px solid #ffffff;
    }

</style>

<script src="<?=base_url()?>js/gencvd10_bmi_calc.js" type="text/javascript"></script>
<script language="javascript" type="text/javascript">
<?php // imprimir(get_defined_vars() );?>
    edad_paciente = <?=$tc['TEL_PAC_EDAD']?>;
    sexo_paciente = "<?=$tc['TEL_PAC_SEXO']?>";

    $(document).ready( function( ) {

        $('#fr_calcular').click( calcular_riesgo );

        $('form input[name=h_tabaquismo]').change( function() {

            switch( $(this).val() ) {
                case "si" : $('#fr_rdbtn_fumador_si').attr("checked", "checked"); $('#fr_rdbtn_fumador_no').removeAttr("checked"); break;
                case "no" : $('#fr_rdbtn_fumador_no').attr("checked", "checked"); $('#fr_rdbtn_fumador_si').removeAttr("checked"); break;
            }
        } );

        $('form input[name=fr_rdbtn_fumador]').click( function() { return false; } );
    } );

    // Función que permite obtener valores de riesgos del paciente
    function calcular_riesgo( ) {

        // Vacia y desaparece cuadro de mensaje de errores
        $('#fr_campos_requeridos').empty();
        $('#fr_campos_requeridos').slideUp();
        msg_error = Array();

        // $('#edad') y $('#sexo') definido en vista "tc_nueva.php"
        edad            = $('#edad').val();
        sexo            = ( $('#sexo').val().toLowerCase() == 'm' ) ? 1 : 0;
        colesterol_total= $('#fr_colesterol_total').val( );
        colesterol_hdl  = $('#fr_colesterol_hdl').val( );
        fumador         = ( $('#fr_rdbtn_fumador_si').attr('checked') == null ) ? 0 : 1;
        sistolica       = $('#sv_presion_sist').val();
        tratamiento_antihipertensivo = ( $('#fr_rdbtn_tratamiento_antihipertensivo_si').attr('checked') == null ) ? 0 : 1;
        diabetes        = ( $('#fr_rdbtn_diabetes_si').attr('checked') == null ) ? 0 : 1;
        imc             = $('#df_imc').val( );

        // Validación
        if( isNaN( parseInt( sistolica ) ) || ( parseInt( sistolica ) > 200 || parseInt( sistolica ) < 90 ) ) msg_error.push( '<?=$this->lang->line('fr_error_sistolica')?>' );
        if( isNaN( parseInt( edad ) ) || ( parseInt( edad ) > 74 || parseInt( edad ) < 30 ) ) msg_error.push( '<?=$this->lang->line('fr_error_edad')?>' );
        if( isNaN( parseFloat( imc ) )        ) msg_error.push( '<?=$this->lang->line('fr_error_imc')?>' );
        if( fumador == false && $('#fr_rdbtn_fumador_no').attr('checked') == false ) msg_error.push( '<?=$this->lang->line('fr_error_fumador')?>' );
        if( tratamiento_antihipertensivo == false && $('#fr_rdbtn_tratamiento_antihipertensivo_no').attr('checked') == false ) msg_error.push( '<?=$this->lang->line('fr_error_sistolica_tratamiento')?>' );

        if( msg_error.length > 0 ) {

            $('#bmi_risk_bar').css( 'width', 0 );
            $('#bmi_risk_txt').html( '0%' );
            $('#bmi_normal_bar').css( 'width', 0 );
            $('#bmi_normal_txt').html( '0%' );
            $('#bmi_opt_bar').css( 'width', 0 );
            $('#bmi_opt_txt').html( '0%' );

            $('#fr_edad_vascular_corazon').val( '' );
            $('#fr_riesgo_diez_anos').val( '' );
            $('#fr_riesgo_normal').val( '' );
            $('#fr_riesgo_optimo').val( '' );

            for( var i in msg_error )
                $('#fr_campos_requeridos').append( msg_error[i]+'<br/>' );

            $('#fr_campos_requeridos').slideDown();

            return false;
        }

        //
        resultados = bmiCalc.doCalculation( edad, parseFloat( imc ), diabetes, sexo, parseFloat( sistolica ), fumador, tratamiento_antihipertensivo );

        // And bar widths in the graph
        var fullW = parseInt( $('#graph_bkg').css('width') );
        fullW -= 10; // 10 pixel right border. Sorry.

        // NOTE: Bars peg at 100%
        var maxVal = 100;

        $('#bmi_risk_bar').css( 'width', parseInt( Math.round( fullW * resultados.riesgo ) / maxVal ) );
        $('#bmi_risk_txt').html( resultados.riesgo+'%' );
        $('#bmi_normal_bar').css( 'width', parseInt( Math.round( fullW * resultados.normal ) / maxVal ) );
        $('#bmi_normal_txt').html( resultados.normal+'%' );
        $('#bmi_opt_bar').css( 'width', parseInt( Math.round( fullW * resultados.optimo ) / maxVal ) );
        $('#bmi_opt_txt').html( resultados.optimo+'%' );

        // Edad vascular del corazon
        $('#fr_edad_vascular_corazon').val( resultados.edadCorazon );

        // Establece porcentaje de riesgo a 10 años
        $('#fr_riesgo_diez_anos').val( resultados.riesgo );

        // Establece porcentaje de riesgo normal
        $('#fr_riesgo_normal').val( resultados.normal );

        // Establece porcentaje de riesgo optimo
        $('#fr_riesgo_optimo').val( resultados.optimo );
    }
</script>

<!-- Workaround: #sexo y #edad no está presente en formulario de respuesta -->
<input type="hidden" name="sexo" id="sexo" value="<?=$tc['TEL_PAC_SEXO']?>"/>
<input type="hidden" name="edad" id="edad" value="<?=$tc['TEL_PAC_EDAD']?>"/>


<table width="50%" cellspacing="0" cellpadding="5" border="0" align="center">
    <tbody>
        <tr>
            <td><?=$this->lang->line('fr_colesterol_total')?>:</td>
            <td align="left">
                <input type="text" name="fr_colesterol_total" id="fr_colesterol_total"
                       value="<?=isset( $fr_colesterol_total ) ? $fr_colesterol_total : ''?>"
                />
            </td>
        </tr>
        <tr>
            <td><?=$this->lang->line('fr_colesterol_hdl')?>:</td>
            <td align="left">
                <input type="text" name="fr_colesterol_hdl" id="fr_colesterol_hdl"
                       value="<?=isset( $fr_colesterol_hdl ) ? $fr_colesterol_hdl : ''?>"
               />
            </td>
        </tr>
        <tr>
            <td><?=$this->lang->line('fr_fumador')?>:</td>
            <td>
                <input type="radio" name="fr_rdbtn_fumador" id="fr_rdbtn_fumador_si" value="1"
                   <?=( isset( $fr_rdbtn_fumador ) && ( $fr_rdbtn_fumador == 1 ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_fumador_si"><?=$this->lang->line('fr_si')?></label>
                &nbsp; &nbsp; &nbsp;
                <input type="radio" name="fr_rdbtn_fumador" id="fr_rdbtn_fumador_no" value="0"
                   <?=( ( isset( $fr_rdbtn_fumador ) && ( $fr_rdbtn_fumador == 0 ) ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_fumador_no"><?=$this->lang->line('fr_no')?></label>
            </td>
        </tr>
        <tr>
            <td><?=$this->lang->line('fr_tratamiento_antihipertensivo')?>:</td>
            <td>
                <input type="radio" name="fr_rdbtn_tratamiento_antihipertensivo" id="fr_rdbtn_tratamiento_antihipertensivo_si" value="1"
                   <?=( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && ( $fr_rdbtn_tratamiento_antihipertensivo == 1 ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_tratamiento_antihipertensivo_si"><?=$this->lang->line('fr_si')?></label>
                &nbsp; &nbsp; &nbsp;
                <input type="radio" name="fr_rdbtn_tratamiento_antihipertensivo" id="fr_rdbtn_tratamiento_antihipertensivo_no" value="0"
                   <?=( ( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && ( $fr_rdbtn_tratamiento_antihipertensivo == 0 ) || !isset( $fr_rdbtn_tratamiento_antihipertensivo ) ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_tratamiento_antihipertensivo_no"><?=$this->lang->line('fr_no')?></label>
            </td>
        </tr>
        <tr>
            <td><?=$this->lang->line('fr_diabetes')?>:</td>
            <td>
                <input type="radio" name="fr_rdbtn_diabetes" id="fr_rdbtn_diabetes_si" value="1"
                   <?=( isset( $fr_rdbtn_diabetes ) && ( $fr_rdbtn_diabetes == 1 ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_diabetes_si"><?=$this->lang->line('fr_si')?></label>
                &nbsp; &nbsp; &nbsp;
                <input type="radio" name="fr_rdbtn_diabetes" id="fr_rdbtn_diabetes_no" value="0"
                   <?=( ( isset( $fr_rdbtn_diabetes ) && ( $fr_rdbtn_diabetes == 0 ) || !isset( $fr_rdbtn_diabetes ) ) ) ? 'checked="checked"' : '' ?>
                />
                <label for="fr_rdbtn_diabetes_no"><?=$this->lang->line('fr_no')?></label>
            </td>
        </tr>
        <tr>
            <td colspan="2" align="center">
                <input type="button" class="bot-txt" name="fr_calcular" id="fr_calcular" value="<?=$this->lang->line('fr_calcular')?>" />
            </td>
        </tr>
    </tbody>
</table>

<!-- Resultados -->
<table width="50%" cellspacing="0" cellpadding="5" border="0" align="center" >
    <tbody>
        <tr>
            <!-- Edad del vascular del corazon -->
            <td><?=$this->lang->line('fr_edad_vascular_corazon')?>: </td>
            <td align="left">
                <input type="input" name="fr_edad_vascular_corazon" id="fr_edad_vascular_corazon" size="5" readonly="readonly"
                   value="<?=( isset( $fr_edad_vascular_corazon ) ) ? $fr_edad_vascular_corazon : '' ?>"
                />
            </td>
        </tr>
        <tr>
            <!-- Riesgo a diez años -->
            <td><?=$this->lang->line('fr_riesgo_diez_anos')?>: </td>
            <td align="left">
                <input type="input" name="fr_riesgo_diez_anos" id="fr_riesgo_diez_anos" size="5" readonly="readonly"
                   value="<?=( isset( $fr_riesgo_diez_anos ) ) ? $fr_riesgo_diez_anos : '' ?>"
                /> %
            </td>
        </tr>
        <tr>
            <!-- Riesgo normal -->
            <td><?=$this->lang->line('fr_riesgo_normal')?>:</td>
            <td align="left">
                <input type="input" name="fr_riesgo_normal" id="fr_riesgo_normal" size="5" readonly="readonly"
                   value="<?=( isset( $fr_riesgo_normal ) ) ? $fr_riesgo_normal : '' ?>"
                /> %
            </td>
        </tr>
        <tr>
            <!-- Riesgo optimo -->
            <td><?=$this->lang->line('fr_riesgo_optimo')?>:</td>
            <td align="left">
                <input type="input" name="fr_riesgo_optimo" id="fr_riesgo_optimo" size="5" readonly="readonly"
                   value="<?=( isset( $fr_riesgo_optimo ) ) ? $fr_riesgo_optimo : '' ?>"
                /> %
            </td>
        </tr>

        <tr>
            <td colspan="2">

                <div id="fr_campos_requeridos" style="display: none;"></div>

                <div class="graph3" id="graph_bkg">
                    <div class="bar relpos">
                       <div class="leg abspos w100"><?=$this->lang->line('fr_riesgo_diez_anos')?></div>
                       <div class="grnbr" id="bmi_risk_bar" ></div>
                       <div class="reslts" id="bmi_risk_txt"></div>
                    </div>

                    <div class="bar relpos">
                        <div class="grnbrbc" id="bmi_normal_bar" ></div>
                        <div class="reslts" id="bmi_normal_txt"></div>
                        <div class="leg abspos"><?=$this->lang->line( 'fr_riesgo_normal' )?></div>
                    </div>

                    <div class="bar relpos">
                        <div class="grnbrbc" id="bmi_opt_bar" ></div>
                        <div class="reslts" id="bmi_opt_txt"></div>
                        <div class="leg abspos"><?=$this->lang->line( 'fr_riesgo_optimo' )?></div>
                    </div>
                </div>
            </td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {


    // Colesterol total
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_colesterol_total' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_colesterol_total ) && !empty( $fr_colesterol_total ) ) ? $fr_colesterol_total : '-' , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

    // Edad vascular del corazon
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_edad_vascular_corazon' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_edad_vascular_corazon ) && !empty( $fr_edad_vascular_corazon ) ) ? $fr_edad_vascular_corazon : '-' , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
 
    // Colesterol HDL
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_colesterol_hdl' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_colesterol_hdl ) && !empty( $fr_colesterol_hdl ) ) ? $fr_colesterol_hdl : '-' , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

    // Riesgo a 10 años en porcentaje
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_riesgo_diez_anos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_riesgo_diez_anos ) && !empty( $fr_riesgo_diez_anos ) ) ? $fr_riesgo_diez_anos : '-' ).' %', 0, 1, 'L' );

    // Fumador
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_fumador' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_rdbtn_fumador ) && $fr_rdbtn_fumador == 1 ) ? $this->lang->line('fr_si') : $this->lang->line('fr_no') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

    // Riesgo normal en porcentaje
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_riesgo_normal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_riesgo_normal ) && !empty( $fr_riesgo_normal ) ) ? $fr_riesgo_normal : '-' ).' %', 0, 1, 'L' );

    // En tratamiento antihipertencivo
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_tratamiento_antihipertensivo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_rdbtn_tratamiento_antihipertensivo ) && $fr_rdbtn_tratamiento_antihipertensivo == 1 ) ? $this->lang->line('fr_si') : $this->lang->line('fr_no') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );

    // Riesgo optimo en porcentaje
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_riesgo_optimo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_riesgo_optimo ) && !empty( $fr_riesgo_optimo ) ) ? $fr_riesgo_optimo : '-' ).' %', 0, 1, 'L' );

    // Diabetes
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'fr_diabetes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $fr_rdbtn_diabetes ) && $fr_rdbtn_diabetes == 1 ) ? $this->lang->line('fr_si') : $this->lang->line('fr_no') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

}
