<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if( $modo == FormularioXML::$MODO_LECTURA ) {

    if( isset( $h_tabaquismo ) && !empty( $h_tabaquismo ) ) {

        echo $this->lang->line('tabaquismo'). " (". $this->lang->line('es_fumador_activo') ."): ";
        switch( (string)$h_tabaquismo ) {
            case "si" : echo $this->lang->line('si'); break;
            case "no" : echo $this->lang->line('no'); break;
            default: echo " - ";
        }
    } else
        echo " - ";

    echo( "<br/> <br/>" );

    if( isset( $h_alcohol ) && !empty( $h_alcohol ) ) {

        echo $this->lang->line('alcohol'). " (".$this->lang->line('consume_alcohol')."): ";
        switch( (string)$h_alcohol ) {
            case "si" : echo $this->lang->line('si'); break;
            case "no" : echo $this->lang->line('no'); break;
            default: echo " - ";
        }
    } else
        echo " - ";
	
	echo "<hr/>";
}

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

<?=$this->lang->line('tabaquismo')?> <?=$this->lang->line('es_fumador_activo')?>: <br />
<input type="radio" name="h_tabaquismo" id="h_tabaquismo_si" value="si" class="validate[required]" <?=( isset( $h_tabaquismo ) && !empty($h_tabaquismo) && $h_tabaquismo == "si" ) ? "chequed=\"chequed\"" : "" ?>/><label for="h_tabaquismo_si" ><?=$this->lang->line('si')?></label>  &nbsp; &nbsp; &nbsp;
<input type="radio" name="h_tabaquismo" id="h_tabaquismo_no" value="no" class="validate[required]" <?=( isset( $h_tabaquismo ) && !empty($h_tabaquismo) && $h_tabaquismo == "no" ) ? "chequed=\"chequed\"" : "" ?>/><label for="h_tabaquismo_no" ><?=$this->lang->line('no')?></label> 

<br />
<br />

<?=$this->lang->line('alcohol')?> <?=$this->lang->line('consume_alcohol')?>: <br />
<input type="radio" name="h_alcohol" id="h_alcohol_si" value="si" class="validate[required]" <?=( isset( $h_alcohol ) && !empty($h_alcohol) && $h_alcohol == "si" ) ? "chequed=\"chequed\"" : "" ?>/><label for="h_alcohol_si" ><?=$this->lang->line('si')?></label>  &nbsp; &nbsp; &nbsp;
<input type="radio" name="h_alcohol" id="h_alcohol_no" value="no" class="validate[required]" <?=( isset( $h_alcohol ) && !empty($h_alcohol) && $h_alcohol == "no" ) ? "chequed=\"chequed\"" : "" ?>/><label for="h_alcohol_no" ><?=$this->lang->line('no')?></label> 
<hr/>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Tabaquismo
    $x = $pdf->GetX();
    if( isset( $h_tabaquismo ) && !empty( $h_tabaquismo ) ) {

        $pdf->Cell( 30, 6, html_entity_decode( $this->lang->line( 'tabaquismo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        switch( (string)$h_tabaquismo ) {
            case "si" : $txt = $this->lang->line('si'); break;
            case "no" : $txt = $this->lang->line('no'); break;
            default: $txt = " - ";
        }
    } else
        echo $txt = " - ";

    $pdf->Cell( 20, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );


    $pdf->SetX( $x );
    if( isset( $h_alcohol ) && !empty( $h_alcohol ) ) {

        $pdf->Cell( 30, 6, html_entity_decode( $this->lang->line( 'alcohol' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        switch( (string)$h_alcohol ) {
            case "si" : $txt = $this->lang->line('si'); break;
            case "no" : $txt = $this->lang->line('no'); break;
            default: $txt = " - ";
        }
    } else
        $txt = " - ";

    $pdf->Cell( 20, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
}
