<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<?php

$key1 = 0;
$key2 = 0;
$key3 = 0;

$arrdescript1 = explode('|',$this->lang->line('neurologia_labeldescrip1_glasgow'));
$arrid1 = explode('|',$this->lang->line('neurologia_labelid1_glasgow'));
$arrdescript2 = explode('|',$this->lang->line('neurologia_labeldescrip2_glasgow'));
$arrid2 = explode('|',$this->lang->line('neurologia_labelid2_glasgow'));
$arrdescript3 = explode('|',$this->lang->line('neurologia_labeldescrip3_glasgow'));
$arrid3 = explode('|',$this->lang->line('neurologia_labelid3_glasgow'));

$arrop1 = Array();
if(isset($neurologia_apertura_ocular)) {
	$arrop1 = explode('|',$this->lang->line('neurologia_options1_glasgow'));
	if(count($arrop1) > 0) {
		foreach($arrop1 as $key => $valor) {
			if($arrid1[$key] == $neurologia_apertura_ocular) {
				$key1 = $key;
			}
		}
	}
}

$arrop2 = Array();
if(isset($neurologia_respuesta_verbal)) {
	$arrop2 = explode('|',$this->lang->line('neurologia_options2_glasgow'));
	if(count($arrop2) > 0) {
		foreach($arrop2 as $key => $valor) {
			if($arrid2[$key] == $neurologia_respuesta_verbal) {
				$key2 = $key;
			}
		}
	}
}

$arrop3 = Array();
if(isset($neurologia_respuesta_motora)) {
	$arrop3 = explode('|',$this->lang->line('neurologia_options3_glasgow'));
	if(count($arrop3) > 0) {
		foreach($arrop3 as $key => $valor) {
			if($arrid3[$key] == $neurologia_respuesta_motora) {
				$key3 = $key;
			}
		}
	}
}

$subtotal_glasgow = 0;
$total_glasgow = 0;

if($arrid1[0]) { $total_glasgow += $arrid1[0]; }
if($arrid2[0]) { $total_glasgow += $arrid2[0]; }
if($arrid3[0]) { $total_glasgow += $arrid3[0]; }

if($arrid1[$key1]) { $subtotal_glasgow += $arrid1[$key1]; }
if($arrid2[$key2]) { $subtotal_glasgow += $arrid2[$key2]; }
if($arrid3[$key3]) { $subtotal_glasgow += $arrid3[$key3]; }
?>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>
    	<tr>
    		<td class="data_form">&nbsp;</td>
    		<td align="left" style="width: 30%">&nbsp;</td>
    		<td align="left" style="width: 30%">Inf.</td>
    		<td align="left" style="width: 30%">Val</td>
    	</tr>
        <tr>
            <td class="data_form">&nbsp;<?php echo $this->lang->line('neurologia_subtitulo1_glasgow') ?>: </td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrop1[$key1] ) && !empty( $arrop1[$key1] ) ) ? $arrop1[$key1] : '' ?></td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrdescript1[$key1] ) && !empty( $arrdescript1[$key1] ) ) ? $arrdescript1[$key1] : '' ?></td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrid1[$key1] ) && !empty( $arrid1[$key1] ) ) ? $arrid1[$key1] : '' ?></td>
        </tr>
        <tr>
            <td class="data_form">&nbsp;<?php echo $this->lang->line('neurologia_subtitulo2_glasgow') ?>: </td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrop2[$key2] ) && !empty( $arrop2[$key2] ) ) ? $arrop2[$key2] : '' ?></td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrdescript2[$key2] ) && !empty( $arrdescript2[$key2] ) ) ? $arrdescript2[$key2] : '' ?></td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrid2[$key2] ) && !empty( $arrid2[$key2] ) ) ? $arrid2[$key2] : '' ?></td>
        </tr>
        <tr>
            <td class="data_form">&nbsp;<?php echo $this->lang->line('neurologia_subtitulo3_glasgow') ?>: </td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrop3[$key3] ) && !empty( $arrop3[$key3] ) ) ? $arrop3[$key3] : '' ?></td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrdescript3[$key3] ) && !empty( $arrdescript3[$key3] ) ) ? $arrdescript3[$key3] : '' ?></td>
            <td align="left" style="width: 30%"><?php echo ( isset( $arrid3[$key3] ) && !empty( $arrid3[$key3] ) ) ? $arrid3[$key3] : '' ?></td>
        </tr>
        <tr>
        	<td class="data_form">&nbsp;</td>
        	<td align="left" style="width: 30%">&nbsp;</td>
        	<td align="left" style="width: 30%">Total Glasgow:</td>
        	<td align="left" style="width: 30%"><?php echo $subtotal_glasgow.' / '.$total_glasgow?></td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

<?php
$key1 = 0;
$key2 = 0;
$key3 = 0;
?>

<script language="javascript" type="text/javascript">
	$(document).ready(function() {
		var subtotal_glasgow = 0;
		var total_glasgow = 0;
		var neuro_glasgow_labeldescriptop1 = new Array();
		
		<?php
		$arrdescript1 = explode('|',$this->lang->line('neurologia_labeldescrip1_glasgow'));
		if(count($arrdescript1) > 0) :
		for($i = 0; $i < count($arrdescript1); $i++) : ?>
		neuro_glasgow_labeldescriptop1[<?php echo $i?>] = '<?php echo utf8_encode(html_entity_decode($arrdescript1[$i]))?>';
		<?php endfor; endif;?>
		var neuro_glasgow_labelidop1 = new Array();
		<?php
		$arrid1 = explode('|',$this->lang->line('neurologia_labelid1_glasgow'));
		if(count($arrid1) > 0) : for($i = 0; $i < count($arrid1); $i++) : ?>
		neuro_glasgow_labelidop1[<?php echo $i?>] = '<?php echo $arrid1[$i]?>';
		<?php endfor; endif;?>		

		$("#neurologia_apertura_ocular").change(function() {
			if($(this).val() != "") {
				$("#labeldescriptop1").text( neuro_glasgow_labeldescriptop1[$(this).prop("selectedIndex") - 1] );
				$("#labelidop1").text( neuro_glasgow_labelidop1[$(this).prop("selectedIndex") - 1] );
			} else {
				$("#labeldescriptop1").text('');
				$("#labelidop1").text(0);
			}
			
			subtotal_glasgow = parseInt($("#labelidop1").text()) + parseInt($("#labelidop2").text()) + parseInt($("#labelidop3").text());
			$("#totalglasgow").text(subtotal_glasgow + ' / ' + total_glasgow);
		});

		var neuro_glasgow_labeldescriptop2 = new Array();
		<?php
		$arrdescript2 = explode('|',$this->lang->line('neurologia_labeldescrip2_glasgow'));
		if(count($arrdescript2) > 0) :
		for($i = 0; $i < count($arrdescript2); $i++) : ?>
		neuro_glasgow_labeldescriptop2[<?php echo $i?>] = '<?php echo utf8_encode(html_entity_decode($arrdescript2[$i]))?>';
		<?php endfor; endif;?>
		
		var neuro_glasgow_labelidop2 = new Array();
		<?php
		$arrid2 = explode('|',$this->lang->line('neurologia_labelid2_glasgow'));
		if(count($arrid2) > 0) : for($i = 0; $i < count($arrid2); $i++) : ?>
		neuro_glasgow_labelidop2[<?php echo $i?>] = '<?php echo $arrid2[$i]?>';
		<?php endfor; endif;?>
		
		$("#neurologia_respuesta_verbal").change(function() {
			if($(this).val() != "") {
				$("#labeldescriptop2").text( neuro_glasgow_labeldescriptop2[$(this).prop("selectedIndex") - 1] );
				$("#labelidop2").text( neuro_glasgow_labelidop2[$(this).prop("selectedIndex") - 1] );
			} else {
				$("#labeldescriptop2").text('');
				$("#labelidop2").text(0);
			}
			
			subtotal_glasgow = parseInt($("#labelidop1").text()) + parseInt($("#labelidop2").text()) + parseInt($("#labelidop3").text());
			$("#totalglasgow").text(subtotal_glasgow + ' / ' + total_glasgow);			
		});

		var neuro_glasgow_labeldescriptop3 = new Array();
		<?php
		$arrdescript3 = explode('|',$this->lang->line('neurologia_labeldescrip3_glasgow'));
		if(count($arrdescript3) > 0) :
		for($i = 0; $i < count($arrdescript3); $i++) : ?>
		neuro_glasgow_labeldescriptop3[<?php echo $i?>] = '<?php echo utf8_encode(html_entity_decode($arrdescript3[$i]))?>';
		<?php endfor; endif;?>
		
		var neuro_glasgow_labelidop3 = new Array();
		<?php
		$arrid3 = explode('|',$this->lang->line('neurologia_labelid3_glasgow'));
		if(count($arrid3) > 0) : for($i = 0; $i < count($arrid3); $i++) : ?>
		neuro_glasgow_labelidop3[<?php echo $i?>] = '<?php echo $arrid3[$i]?>';
		<?php endfor; endif;?>
		
		$("#neurologia_respuesta_motora").change(function() {
			if($(this).val() != "") {
				$("#labeldescriptop3").text( neuro_glasgow_labeldescriptop3[$(this).prop("selectedIndex") - 1] );
				$("#labelidop3").text( neuro_glasgow_labelidop3[$(this).prop("selectedIndex") - 1] );
			} else {
				$("#labeldescriptop3").text('');
				$("#labelidop3").text(0);
			}
			
			subtotal_glasgow = parseInt($("#labelidop1").text()) + parseInt($("#labelidop2").text()) + parseInt($("#labelidop3").text());
			$("#totalglasgow").text(subtotal_glasgow + ' / ' + total_glasgow);
		});

		<?php
		$arrop1 = Array();
		$arrop1 = explode('|',$this->lang->line('neurologia_options1_glasgow'));
		if(isset($neurologia_apertura_ocular)) {
			if(count($arrop1) > 0) {
				foreach($arrop1 as $key => $valor) {
					if($arrid1[$key] == $neurologia_apertura_ocular) {
						$key1 = $key;
					}
				}
			}
		}
		
		$arrop2 = Array();
		$arrop2 = explode('|',$this->lang->line('neurologia_options2_glasgow'));
		if(isset($neurologia_respuesta_verbal)) {
			if(count($arrop2) > 0) {
				foreach($arrop2 as $key => $valor) {
					if($arrid2[$key] == $neurologia_respuesta_verbal) {
						$key2 = $key;
					}
				}
			}
		}
		
		$arrop3 = Array();
		$arrop3 = explode('|',$this->lang->line('neurologia_options3_glasgow'));
		if(isset($neurologia_respuesta_motora)) {
			if(count($arrop3) > 0) {
				foreach($arrop3 as $key => $valor) {
					if($arrid3[$key] == $neurologia_respuesta_motora) {
						$key3 = $key;
					}
				}
			}
		}
		
		$subtotal_glasgow = 0;
		
		if($arrid1[$key1]) { $subtotal_glasgow += $arrid1[$key1]; }
		if($arrid2[$key2]) { $subtotal_glasgow += $arrid2[$key2]; }
		if($arrid3[$key3]) { $subtotal_glasgow += $arrid3[$key3]; }
		?>

		total_glasgow = parseInt(neuro_glasgow_labelidop1[0]) + parseInt(neuro_glasgow_labelidop2[0]) + parseInt(neuro_glasgow_labelidop3[0]);
		$("#totalglasgow").text('<?php echo $subtotal_glasgow?> / ' + total_glasgow);
	});
</script>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>
    	<tr>
    		<td class="data_form">&nbsp;</td>
    		<td align="left" style="width: 30%">&nbsp;</td>
    		<td align="left" style="width: 30%">Inf.</td>
    		<td align="left" style="width: 30%">Val</td>
    	</tr>
        <tr>
            <td class="data_form">&nbsp;<?php echo $this->lang->line('neurologia_subtitulo1_glasgow') ?>: </td>
            <td align="left" style="width: 30%"><select name="neurologia_apertura_ocular" id="neurologia_apertura_ocular" class="validate[required]">
            		<option value=""></option>
            		<?php
            			$arrop1 = explode('|',$this->lang->line('neurologia_options1_glasgow'));
						if(count($arrop1) > 0) {
							foreach($arrop1 as $key => $valor) {
								$selected = ( isset( $neurologia_apertura_ocular ) && !empty( $neurologia_apertura_ocular ) && $neurologia_apertura_ocular == $arrid1[$key] ) ? 'selected' : '';
								echo '<option value="'.$arrid1[$key].'" '.$selected.'>'.$valor.'</option>';
							}
						}
            		?>
            	</select>	
            </td>
            <td align="left" style="width: 30%"><label id="labeldescriptop1"><?php echo ( isset( $neurologia_apertura_ocular ) && !empty( $neurologia_apertura_ocular ) ) ? $arrdescript1[$key1] : '&nbsp;'?></label></td>
            <td align="left" style="width: 30%"><label id="labelidop1"><?php echo ( isset( $neurologia_apertura_ocular ) && !empty( $neurologia_apertura_ocular ) ) ? $neurologia_apertura_ocular : '0'?></label></td>
        </tr>
        <tr>
            <td class="data_form">&nbsp;<?php echo $this->lang->line('neurologia_subtitulo2_glasgow') ?>: </td>
            <td align="left" style="width: 30%"><select name="neurologia_respuesta_verbal" id="neurologia_respuesta_verbal" class="validate[required]" >
            		<option value=""></option>
            		<?php
            			$arrop2 = explode('|',$this->lang->line('neurologia_options2_glasgow'));
						if(count($arrop2) > 0) {
							foreach($arrop2 as $key => $valor) {
								$selected = ( isset( $neurologia_respuesta_verbal ) && !empty( $neurologia_respuesta_verbal ) && $neurologia_respuesta_verbal == $arrid2[$key] ) ? 'selected' : '';
								echo '<option value="'.$arrid2[$key].'" '.$selected.'>'.$valor.'</option>';
							}
						}
            		?>
            	</select>	
            </td>
            <td align="left" style="width: 30%"><label id="labeldescriptop2"><?php echo ( isset( $neurologia_respuesta_verbal ) && !empty( $neurologia_respuesta_verbal ) ) ? $arrdescript2[$key2] : '&nbsp;'?></label></td>
            <td align="left" style="width: 30%"><label id="labelidop2"><?php echo ( isset( $neurologia_respuesta_verbal ) && !empty( $neurologia_respuesta_verbal ) ) ? $neurologia_respuesta_verbal : '0'?></label></td>
        </tr>
        <tr>
            <td class="data_form">&nbsp;<?php echo $this->lang->line('neurologia_subtitulo3_glasgow') ?>: </td>
            <td align="left" style="width: 30%"><select name="neurologia_respuesta_motora" id="neurologia_respuesta_motora" class="validate[required]" >
            		<option value=""></option>
            		<?php
            			$arrop3 = explode('|',$this->lang->line('neurologia_options3_glasgow'));
						if(count($arrop3) > 0) {
							foreach($arrop3 as $key => $valor) {
								$selected = ( isset( $neurologia_respuesta_motora ) && !empty( $neurologia_respuesta_motora ) && $neurologia_respuesta_motora == $arrid3[$key] ) ? 'selected' : '';
								echo '<option value="'.$arrid3[$key].'" '.$selected.'>'.$valor.'</option>';
							}
						}
            		?>
            	</select>	
            </td>
            <td align="left" style="width: 30%"><label id="labeldescriptop3"><?php echo ( isset( $neurologia_respuesta_motora ) && !empty( $neurologia_respuesta_motora ) ) ? $arrdescript3[$key3] : '&nbsp;'?></label></label></td>
            <td align="left" style="width: 30%"><label id="labelidop3"><?php echo ( isset( $neurologia_respuesta_motora ) && !empty( $neurologia_respuesta_motora ) ) ? $neurologia_respuesta_motora : '0'?></label></td>
        </tr>
        <tr>
        	<td class="data_form">&nbsp;</td>
        	<td align="left" style="width: 30%">&nbsp;</td>
        	<td align="left" style="width: 30%">Total Glasgow:</td>
        	<td align="left" style="width: 30%"><label id="totalglasgow">&nbsp;</label></td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    /*
     * Apertura ocular
     */
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'neurologia_subtitulo1_glasgow' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX();

    // Opciones
    $arrop1  = explode( '|', $this->lang->line( 'neurologia_options1_glasgow' ) );
    $arridx1 = explode( '|', $this->lang->line( 'neurologia_labelid1_glasgow' ) );
    foreach( $arridx1 as $k => $valor ) {
        if( (int)$valor == (int)$neurologia_apertura_ocular )
            $pdf->Cell( 100, 6, html_entity_decode( $arrop1[$k] ), 0, 0, 'L' );
    }

    // Valores
    $pdf->Cell( 0, 6, html_entity_decode( (int)$neurologia_apertura_ocular , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Descripción (en cursiva)
    $pdf->SetX( $x );
    $pdf->SetFont('', 'I');
    $arrop1_desc = explode( '|', $this->lang->line( 'neurologia_labeldescrip1_glasgow' ) );
    foreach( $arridx1 as $k => $valor ) {
        if( (int)$valor == (int)$neurologia_apertura_ocular )
            $pdf->Cell( 50, 6, html_entity_decode( $arrop1_desc[$k] ), 0, 1, 'L' );
    }
    $pdf->SetFont('', '');

    /*
     * Respuesta verbal
     */
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'neurologia_subtitulo2_glasgow' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX();

    // Opciones
    $arrop2  = explode( '|', $this->lang->line( 'neurologia_options2_glasgow' ) );
    $arridx2 = explode( '|', $this->lang->line( 'neurologia_labelid2_glasgow' ) );
    foreach( $arridx2 as $k => $valor ) {
        if( (int)$valor == (int)$neurologia_respuesta_verbal )
            $pdf->Cell( 100, 6, html_entity_decode( $arrop2[$k] ), 0, 0, 'L' );
    }

    // Valores
    $pdf->Cell( 0, 6, html_entity_decode( (int)$neurologia_respuesta_verbal , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Descripción (en cursiva)
    $pdf->SetX( $x );
    $pdf->SetFont('', 'I');
    $arrop2_desc = explode( '|', $this->lang->line( 'neurologia_labeldescrip2_glasgow' ) );
    foreach( $arridx2 as $k => $valor ) {
        if( (int)$valor == (int)$neurologia_respuesta_verbal )
            $pdf->Cell( 50, 6, html_entity_decode( $arrop2_desc[$k] ), 0, 1, 'L' );
    }
    $pdf->SetFont('', '');

    /*
     * Respuesta motora
     */
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'neurologia_subtitulo3_glasgow' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX();

    // Opciones
    $arrop3  = explode( '|', $this->lang->line( 'neurologia_options3_glasgow' ) );
    $arridx3 = explode( '|', $this->lang->line( 'neurologia_labelid3_glasgow' ) );
    foreach( $arridx3 as $k => $valor ) {
        if( (int)$valor == (int)$neurologia_respuesta_motora )
            $pdf->Cell( 100, 6, html_entity_decode( $arrop3[$k] ), 0, 0, 'L' );
    }

    // Valores
    $pdf->Cell( 0, 6, html_entity_decode( (int)$neurologia_respuesta_motora , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Descripción (en cursiva)
    $pdf->SetX( $x );
    $pdf->SetFont('', 'I');
    $arrop3_desc = explode( '|', $this->lang->line( 'neurologia_labeldescrip3_glasgow' ) );
    foreach( $arridx3 as $k => $valor ) {
        if( (int)$valor == (int)$neurologia_respuesta_motora )
            $pdf->Cell( 50, 6, html_entity_decode( $arrop3_desc[$k]), 0, 1, 'L' );
    }
    $pdf->SetFont('', '');


    $pdf->SetFont('', 'B');
    $pdf->Cell( 150, 6, html_entity_decode( $this->lang->line( 'neurologia_total_glasgow' ) ).':', 0, 0, 'R' );


    $pdf->Cell( 40, 6, html_entity_decode(  (int)$neurologia_apertura_ocular +
                                            (int)$neurologia_respuesta_verbal +
                                            (int)$neurologia_respuesta_motora ), 0, 1, 'L' );
    $pdf->SetFont('', '');

}
