<?php if( $modo == FormularioXML::$MODO_LECTURA ) {

function cambiar_color( $valor ) {

    switch( (int)$valor ) {
        case 1 : return '#FFFFFF'; break;
        case 2 : return '#FFC000'; break;
        case 3 : return '#FFC000'; break;
        case 4 : return '#FFFF00'; break;
        case 5 : return '#FFFF00'; break;
        case 6 : return '#92D050'; break;
        default: return '#FFFFFF';
    }
}

if( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) )
    $color_msd = cambiar_color( $neurologia_valoracion_fuerza_msd );

if( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) )
    $color_mid = cambiar_color( $neurologia_valoracion_fuerza_mid );

if( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) )
    $color_msi = cambiar_color( $neurologia_valoracion_fuerza_msi );

if( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) )
    $color_mii = cambiar_color( $neurologia_valoracion_fuerza_mii );

?>

<style type="text/css">

    #neurologia_valoracion_fuerza_contenedor .texto_nota {
        font-style: italic;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_msd_caja {
        position: absolute;
        background-color: #FFFFFF;
        margin-top: 130px;
        height: 330px;
        width: 70px;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_mid_caja {
        position: absolute;
        background-color: #FFFFFF;
        margin-top: 500px;
        height: 300px;
        width: 127px;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_msi_caja {
        background-color: #FFFFFF;
        height: 330px;
        margin-top: 130px;
        margin-left: 162px;
        width: 90px;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_mii_caja {
        background-color: #FFFFFF;
        height: 300px;
        margin-top: 40px;
        margin-left: 123px;
        width: 127px;
    }
</style>

<script language="javascript" type="text/javascript">

    $(document).ready(function( ) {

    } );

</script>

<table style="width: 100%;">
    <tr>
        <td class="data_form"><?=$this->lang->line('neurologia_valoracion_fuerza')?></td>
        <td align="left" style="width: 100%">
            <?=( isset( $neurologia_valoracion_fuerza ) && !empty($neurologia_valoracion_fuerza ) && $neurologia_valoracion_fuerza == 1 )
                ? $this->lang->line('neurologia_normal')
                : $this->lang->line('neurologia_anormal')
            ?>
        </td>
    </tr>
    <?php if( isset( $neurologia_valoracion_fuerza ) && !empty($neurologia_valoracion_fuerza ) && $neurologia_valoracion_fuerza == 2 ) { ?>
    <tr>
        <td colspan="2">

            <div id="neurologia_valoracion_fuerza_contenedor" style="height: 800px;">

                <!-- Columna izquierda -->
                <div style="width: 257px; float: left;">

                    <!-- Superior -->
                    <div style="margin-top: 130px;">
                        <?php
                            if( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) ) {
                                switch( $neurologia_valoracion_fuerza_msd ) {

                                    case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                                    case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                                    case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                                    case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                                    case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                                    case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                                    default : $r = '-';
                                }
                            }
                            echo $r;
                        ?>
                    </div>

                    <!-- Inferior -->
                    <div style="margin-top: 340px;">
                        <?php
                            if( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) ) {
                                switch( $neurologia_valoracion_fuerza_mid ) {

                                    case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                                    case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                                    case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                                    case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                                    case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                                    case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                                    default : $r = '-';
                                }
                            }
                            echo $r;
                        ?>
                    </div>

                </div>

                <!-- Cuerpo humano -->
                <div style="width: 252px; float: left;">
                    <div id="neurologia_valoracion_fuerza_msd_caja" class="neurologia_valoracion_fuerza_msd_caja" style="background-color: <?=$color_msd?>" > </div>
                    <div id="neurologia_valoracion_fuerza_mid_caja" class="neurologia_valoracion_fuerza_mid_caja" style="background-color: <?=$color_mid?>" > </div>
                    <div style="position: absolute; float: left;">
                        <img src="<?=base_url()?>images/humano.png" height="800" width="252" />
                    </div>
                    <div id="neurologia_valoracion_fuerza_msi_caja" class="neurologia_valoracion_fuerza_msi_caja" style="background-color: <?=$color_msi?>" > </div>
                    <div id="neurologia_valoracion_fuerza_mii_caja" class="neurologia_valoracion_fuerza_mii_caja" style="background-color: <?=$color_mii?>" > </div>
                </div>

                <!-- Columna derecha -->
                <div style="width: 257px; float: right;">

                    <!-- Superior -->
                    <div style="margin-top: 130px;">
                        <?php
                            if( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) ) {
                                switch( $neurologia_valoracion_fuerza_msi ) {

                                    case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                                    case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                                    case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                                    case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                                    case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                                    case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                                    default : $r = '-';
                                }
                            }
                            echo $r;
                        ?>
                    </div>

                    <!-- Inferior -->
                    <div style="margin-top: 325px;">
                        <?php
                            if( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) ) {
                                switch( $neurologia_valoracion_fuerza_mii ) {

                                    case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                                    case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                                    case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                                    case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                                    case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                                    case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                                    default : $r = '-';
                                }
                            }
                            echo $r;
                        ?>
                    </div>

                </div>

            </div>
            <br/><span class="texto_nota"><?=$this->lang->line('neurologia_fuerza_opuesta_examinador')?></span>

        </td>
    </tr>
    <?php } ?>
</table>

<?php
}

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

<style type="text/css">

    #neurologia_valoracion_fuerza_contenedor .texto_nota {
        font-style: italic;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_msd_caja {
        position: absolute;
        background-color: #FFFFFF;
        margin-top: 130px;
        height: 330px;
        width: 70px;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_mid_caja {
        position: absolute;
        background-color: #FFFFFF;
        margin-top: 500px;
        height: 300px;
        width: 127px;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_msi_caja {
        background-color: #FFFFFF;
        height: 330px;
        margin-top: 130px;
        margin-left: 162px;
        width: 90px;
    }

    #neurologia_valoracion_fuerza_contenedor .neurologia_valoracion_fuerza_mii_caja {
        background-color: #FFFFFF;
        height: 300px;
        margin-top: 40px;
        margin-left: 123px;
        width: 127px;
    }
</style>

<script language="javascript" type="text/javascript">

    $(document).ready(function( ) {

        // Bloquea/Desbloquea campo de hallazgo
        $('#neurologia_valoracion_fuerza_normal').click(function( ) {
            $("#neurologia_valoracion_fuerza_contenedor").css("visibility","hidden");
            $("#neurologia_valoracion_fuerza_contenedor").css("position","absolute"); 
            $('#neurologia_valoracion_fuerza_contenedor select').attr( 'disabled', 'disabled');
        } );

        $('#neurologia_valoracion_fuerza_anormal').click(function( ) {
            $("#neurologia_valoracion_fuerza_contenedor").css("visibility","visible");
            $("#neurologia_valoracion_fuerza_contenedor").css("position","relative");  
            $('#neurologia_valoracion_fuerza_contenedor select').removeAttr( 'disabled' );
        } );

        <?php if( isset( $neurologia_valoracion_fuerza ) && $neurologia_valoracion_fuerza == 2 ) { ?>
            $("#neurologia_valoracion_fuerza_contenedor").css("visibility","visible");
            $("#neurologia_valoracion_fuerza_contenedor").css("position","relative");  
            $('#neurologia_valoracion_fuerza_contenedor select').removeAttr( 'disabled' );
        <?php } ?>

        $('#neurologia_valoracion_fuerza_msd').change( function( ) {
            cambiar_color( $('#neurologia_valoracion_fuerza_msd_caja'), $(this).val() );
        } );

        $('#neurologia_valoracion_fuerza_mid').change( function( ) {
            cambiar_color( $('#neurologia_valoracion_fuerza_mid_caja'), $(this).val() );
        } );

        $('#neurologia_valoracion_fuerza_msi').change( function( ) {
            cambiar_color( $('#neurologia_valoracion_fuerza_msi_caja'), $(this).val() );
        } );

        $('#neurologia_valoracion_fuerza_mii').change( function( ) {
            cambiar_color( $('#neurologia_valoracion_fuerza_mii_caja'), $(this).val() );
        } );

        <?php if( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) ) { ?>
            cambiar_color( $('#neurologia_valoracion_fuerza_msd_caja'), <?=(int)$neurologia_valoracion_fuerza_msd?> );
        <?php } ?>

        <?php if( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) ) { ?>
            cambiar_color( $('#neurologia_valoracion_fuerza_mid_caja'), <?=(int)$neurologia_valoracion_fuerza_mid?> );
        <?php } ?>

        <?php if( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) ) { ?>
            cambiar_color( $('#neurologia_valoracion_fuerza_msi_caja'), <?=(int)$neurologia_valoracion_fuerza_msi?> );
        <?php } ?>

        <?php if( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) ) { ?>
            cambiar_color( $('#neurologia_valoracion_fuerza_mii_caja'), <?=(int)$neurologia_valoracion_fuerza_mii?> );
        <?php } ?>
    } );

    function cambiar_color( elemento, valor ) {

        switch( parseInt( valor ) ) {
            case 1 : { elemento.css( 'background-color', '#FFFFFF' ); break; }
            case 2 : { elemento.css( 'background-color', '#FFC000' ); break; }
            case 3 : { elemento.css( 'background-color', '#FFC000' ); break; }
            case 4 : { elemento.css( 'background-color', '#FFFF00' ); break; }
            case 5 : { elemento.css( 'background-color', '#FFFF00' ); break; }
            case 6 : { elemento.css( 'background-color', '#92D050' ); break; }
        }
    }
</script>

<table style="width: 100%;">
    <tr>
        <td class="data_form"><?=$this->lang->line('neurologia_valoracion_fuerza')?></td>
        <td align="left" style="width: 100%">
                <input type="radio" id="neurologia_valoracion_fuerza_normal" name="neurologia_valoracion_fuerza" <?=( !isset( $neurologia_valoracion_fuerza ) || $neurologia_valoracion_fuerza == 1 ) ? "checked=\"checked\"" : ""?> value="1"> <label for="neurologia_valoracion_fuerza_normal"><?=$this->lang->line('neurologia_normal')?></label>
                <input type="radio" id="neurologia_valoracion_fuerza_anormal" name="neurologia_valoracion_fuerza" <?=( isset( $neurologia_valoracion_fuerza ) && $neurologia_valoracion_fuerza == 2 ) ? "checked=\"checked\"" : ""?> value="2"> <label for="neurologia_valoracion_fuerza_anormal"><?=$this->lang->line('neurologia_anormal')?></label>
        </td>
    </tr>
    <tr>
        <td colspan="2">

            <div id="neurologia_valoracion_fuerza_contenedor" style="height: 800px; visibility: hidden; position: absolute;">

                <!-- Columna izquierda -->
                <div style="width: 257px; float: left;">

                    <!-- Superior -->
                    <div style="margin-top: 130px;">
                        <select id="neurologia_valoracion_fuerza_msd" name="neurologia_valoracion_fuerza_msd" style="width: 200px;">
                            <option value="1" <?=( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) && $neurologia_valoracion_fuerza_msd == 1 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_ningun_movimiento')?></option>
                            <option value="2" <?=( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) && $neurologia_valoracion_fuerza_msd == 2 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_contraccion_muscular')?></option>
                            <option value="3" <?=( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) && $neurologia_valoracion_fuerza_msd == 3 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad')?></option>
                            <option value="4" <?=( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) && $neurologia_valoracion_fuerza_msd == 4 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_parcial_sin_resistencia')?></option>
                            <option value="5" <?=( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) && $neurologia_valoracion_fuerza_msd == 5 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia')?></option>
                            <option value="6" <?=( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) && $neurologia_valoracion_fuerza_msd == 6 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad')?></option>
                        </select>
                    </div>

                    <!-- Inferior -->
                    <div style="margin-top: 340px;">
                        <select id="neurologia_valoracion_fuerza_mid" name="neurologia_valoracion_fuerza_mid" style="width: 200px;">
                            <option value="1" <?=( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) && $neurologia_valoracion_fuerza_mid == 1 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_ningun_movimiento')?></option>
                            <option value="2" <?=( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) && $neurologia_valoracion_fuerza_mid == 2 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_contraccion_muscular')?></option>
                            <option value="3" <?=( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) && $neurologia_valoracion_fuerza_mid == 3 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad')?></option>
                            <option value="4" <?=( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) && $neurologia_valoracion_fuerza_mid == 4 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_parcial_sin_resistencia')?></option>
                            <option value="5" <?=( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) && $neurologia_valoracion_fuerza_mid == 5 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia')?></option>
                            <option value="6" <?=( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) && $neurologia_valoracion_fuerza_mid == 6 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad')?></option>
                        </select>
                    </div>

                </div>

                <!-- Cuerpo humano -->
                <div style="width: 252px; float: left;">
                    <div id="neurologia_valoracion_fuerza_msd_caja" class="neurologia_valoracion_fuerza_msd_caja" > </div>
                    <div id="neurologia_valoracion_fuerza_mid_caja" class="neurologia_valoracion_fuerza_mid_caja" > </div>
                    <div style="position: absolute; float: left;">
                        <img src="<?=base_url()?>images/humano.png" height="800" width="252" />
                    </div>
                    <div id="neurologia_valoracion_fuerza_msi_caja" class="neurologia_valoracion_fuerza_msi_caja" > </div>
                    <div id="neurologia_valoracion_fuerza_mii_caja" class="neurologia_valoracion_fuerza_mii_caja" > </div>
                </div>

                <!-- Columna derecha -->
                <div style="width: 257px; float: right;">

                    <!-- Superior -->
                    <div style="margin-top: 130px;">
                        <select id="neurologia_valoracion_fuerza_msi" name="neurologia_valoracion_fuerza_msi" style="width: 200px;">
                            <option value="1" <?=( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) && $neurologia_valoracion_fuerza_msi == 1 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_ningun_movimiento')?></option>
                            <option value="2" <?=( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) && $neurologia_valoracion_fuerza_msi == 2 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_contraccion_muscular')?></option>
                            <option value="3" <?=( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) && $neurologia_valoracion_fuerza_msi == 3 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad')?></option>
                            <option value="4" <?=( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) && $neurologia_valoracion_fuerza_msi == 4 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_parcial_sin_resistencia')?></option>
                            <option value="5" <?=( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) && $neurologia_valoracion_fuerza_msi == 5 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia')?></option>
                            <option value="6" <?=( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) && $neurologia_valoracion_fuerza_msi == 6 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad')?></option>
                        </select>
                    </div>

                    <!-- Inferior -->
                    <div style="margin-top: 340px;">
                        <select id="neurologia_valoracion_fuerza_mii" name="neurologia_valoracion_fuerza_mii" style="width: 200px;">
                            <option value="1" <?=( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) && $neurologia_valoracion_fuerza_mii == 1 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_ningun_movimiento')?></option>
                            <option value="2" <?=( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) && $neurologia_valoracion_fuerza_mii == 2 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_contraccion_muscular')?></option>
                            <option value="3" <?=( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) && $neurologia_valoracion_fuerza_mii == 3 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad')?></option>
                            <option value="4" <?=( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) && $neurologia_valoracion_fuerza_mii == 4 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_parcial_sin_resistencia')?></option>
                            <option value="5" <?=( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) && $neurologia_valoracion_fuerza_mii == 5 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia')?></option>
                            <option value="6" <?=( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) && $neurologia_valoracion_fuerza_mii == 6 ) ? 'selected="selected"' : '' ?>><?=$this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad')?></option>
                        </select>
                    </div>

                </div>

            </div>
            <br/><?=$this->lang->line('neurologia_fuerza_opuesta_examinador')?>

        </td>
    </tr>
</table>
<?php

}

if( $modo == FormularioXML::$MODO_PDF ) {

    // Titulo
    $y = $pdf->GetY();
    $pdf->MultiCell( 80, 6, html_entity_decode( $this->lang->line('neurologia_titulo_valoracion_fuerza'), ENT_COMPAT, 'ISO-8859-1' ).': ', 0, 'L' );
    $x = 50;
    $pdf->SetY( $y );
    $x = $x + 10;
    $pdf->SetX( $x );

    if( $neurologia_valoracion_fuerza == 1 ) {

        // $pdf->Ln();
        $pdf->Cell( 30, 6, html_entity_decode( $this->lang->line( 'neurologia_normal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 1, 'R' );

    } else {

        $limite_pagina = 210;
        $pdf->Ln();
        $pdf->Cell( 30, 6, html_entity_decode( $this->lang->line( 'neurologia_anormal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 1, 'l' );

        /*
         * 1) MSD
         */
        $pdf->SetX( $x );
        $pdf->Cell( 10, 5, html_entity_decode( $this->lang->line( 'neurologia_msd' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 0, 'L' );

        if( isset( $neurologia_valoracion_fuerza_msd ) && !empty( $neurologia_valoracion_fuerza_msd ) ) {

            switch( (int)$neurologia_valoracion_fuerza_msd ) {
                case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                default: $r = ' - '; break;
            }

            $pdf->MultiCell( 0, 5, html_entity_decode( $r, ENT_COMPAT, 'ISO-8859-1' ), 0, 'L' );
        }
        else
            $pdf->MultiCell( 0, 5, '-', 0, 'L' );

        /*
         * 2) MID
         */
        $pdf->SetX( $x );
        $pdf->Cell( 10, 5, html_entity_decode( $this->lang->line( 'neurologia_mid' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 0 );

        if( isset( $neurologia_valoracion_fuerza_mid ) && !empty( $neurologia_valoracion_fuerza_mid ) ) {

            switch( (int)$neurologia_valoracion_fuerza_mid ) {
                case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                default: $r = ' - '; break;
            }

            $pdf->MultiCell( 0, 5, html_entity_decode( $r, ENT_COMPAT, 'ISO-8859-1' ), 0, 'L' );
        }
        else
            $pdf->MultiCell( 0, 5, '-', 0, 'L' );

        /*
         * 3) MSI
         */
        $pdf->SetX( $x );
        $pdf->Cell( 10, 5, html_entity_decode( $this->lang->line( 'neurologia_msi' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 0 );

        if( isset( $neurologia_valoracion_fuerza_msi ) && !empty( $neurologia_valoracion_fuerza_msi ) ) {

            switch( (int)$neurologia_valoracion_fuerza_msi ) {
                case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                default: $r = ' - '; break;
            }

            $pdf->MultiCell( 0, 5, html_entity_decode( $r, ENT_COMPAT, 'ISO-8859-1' ), 0, 'L' );
        }
        else
            $pdf->MultiCell( 0, 5, '-', 0, 'L' );

        /*
         * 4) MII
         */
        $pdf->SetX( $x );
        $pdf->Cell( 10, 5, html_entity_decode( $this->lang->line( 'neurologia_mii' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 0 );

        if( isset( $neurologia_valoracion_fuerza_mii ) && !empty( $neurologia_valoracion_fuerza_mii ) ) {

            switch( (int)$neurologia_valoracion_fuerza_mii ) {
                case 1 : $r = $this->lang->line('neurologia_ningun_movimiento'); break;
                case 2 : $r = $this->lang->line('neurologia_contraccion_muscular'); break;
                case 3 : $r = $this->lang->line('neurologia_movimiento_horizontal_no_supera_gravedad'); break;
                case 4 : $r = $this->lang->line('neurologia_movimiento_parcial_sin_resistencia'); break;
                case 5 : $r = $this->lang->line('neurologia_movimiento_completo_gravedad_parcial_resistencia'); break;
                case 6 : $r = $this->lang->line('neurologia_movimiento_completo_resistencia_mas_gravedad'); break;
                default: $r = ' - '; break;
            }

            $pdf->MultiCell( 0, 5, html_entity_decode( $r, ENT_COMPAT, 'ISO-8859-1' ), 0, 'L' );
        }
        else
            $pdf->MultiCell( 0, 5, '-', 0, 'L' );

        // Texto nota (*)
        $pdf->SetX( $x );
        $pdf->Cell( 10, 5, html_entity_decode( $this->lang->line( 'neurologia_fuerza_opuesta_examinador' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1'  ), 0, 1, 'L' );
    }

}

