<?php
if( $modo == FormularioXML::$MODO_LECTURA ) {

    $intervalo = date_diff( new DateTime(), new DateTime( $tc['TEL_PAC_NACIMIENTO'] ) );
    $meses     = (int)( ( $intervalo->y * 12 ) + $intervalo->m );

    // 216 meses: 18 años
    if( $meses <= 216 ) {
?>

    <table cellspacing="0" cellpadding="0" border="0" align="center" >
        <tbody>

            <!-- Talla para edad -->
            <tr>
                <td class="data_form"><?=$this->lang->line('nutricion_talla_para_edad_de')?>:</td>
                <td align="left">
                    <?=( isset( $nutricion_talla_para_edad_de ) && !empty( $nutricion_talla_para_edad_de ) ) ?
                            $this->lang->line( 'nutricion_talla_para_edad_de_'.$nutricion_talla_para_edad_de ) .
                            ' ('.$this->lang->line( 'nutricion_talla_para_edad_de_'.$nutricion_talla_para_edad_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- Peso para la edad -->
            <tr>
                <td class="data_form"><?=$this->lang->line('nutricion_peso_para_edad_de')?>:</td>
                <td align="left">
                    <?=( isset( $nutricion_peso_para_edad_de ) && !empty( $nutricion_peso_para_edad_de ) ) ?
                            $this->lang->line( 'nutricion_peso_para_edad_de_'.$nutricion_peso_para_edad_de ) .
                            ' ('.$this->lang->line( 'nutricion_peso_para_edad_de_'.$nutricion_peso_para_edad_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- Peso para la talla -->
            <tr>
                <td class="data_form"><?=$this->lang->line('nutricion_peso_para_talla_de')?>:</td>
                <td align="left">
                    <?=( isset( $nutricion_peso_para_talla_de ) && !empty( $nutricion_peso_para_talla_de ) ) ?
                            $this->lang->line( 'nutricion_peso_para_talla_de_'.$nutricion_peso_para_talla_de ) .
                            ' ('.$this->lang->line( 'nutricion_peso_para_talla_de_'.$nutricion_peso_para_talla_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <!-- IMC -->
            <tr>
                <td class="data_form"><?=$this->lang->line('df_imc')?>:</td>
                <td align="left">
                    <?=( isset( $nutricion_imc_de ) && !empty( $nutricion_imc_de ) ) ?
                            $this->lang->line( 'nutricion_imc_de_'.$nutricion_imc_de ) .
                            ' ('.$this->lang->line( 'nutricion_imc_de_'.$nutricion_imc_de.'_desc' ).')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>

            <?php if( $meses <= 60 ) { ?>
            <!-- Perimetro cefálico -->
            <tr>
                <td class="data_form"><?=$this->lang->line('df_perimetro_cefalico')?>:</td>
                <td align="left">
                    <?=( isset( $nutricion_perimetro_cefalico_de ) && !empty( $nutricion_perimetro_cefalico_de ) ) ?
                            $this->lang->line( 'nutricion_perimetro_cefalico_de_'.$nutricion_perimetro_cefalico_de ) .
                            ' (' . $this->lang->line( 'nutricion_perimetro_cefalico_de_'.$nutricion_perimetro_cefalico_de.'_desc' ) . ')'
                        :
                            ' - '
                    ?>
                </td>
            </tr>
            <?php } ?>

        </tbody>
    </table>
<?php } else { ?>
<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Título de desviación estandar -->
        <tr>
            <td colspan="2" align="center" style="font-style: italic; "><?=$this->lang->line('nutricion_no_aplica_mayor_18')?></td>
        </tr>
    </tbody>
</table>
<?php }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) {

    $intervalo = date_diff( new DateTime(), new DateTime( $tc['TEL_PAC_NACIMIENTO'] ) );
    $meses     = (int)( ( $intervalo->y * 12 ) + $intervalo->m );

    // 216 meses: 18 años
    if( $meses <= 216 ) {
?>

<script language="javascript" type="text/javascript" src="<?=base_url()?>js/jqplot/jquery.jqplot.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?=base_url()?>css/jqplot/jquery.jqplot.min.css" />

<script language="javascript" type="text/javascript">

    function co_pediatria_calcular_de( ) {

        // Talla para la edad: Hasta 18 años (216 meses)
        x = "<?=$meses?>";
        y = $('#df_talla').val();
        if( parseInt( x ) <= 216 )
            $.getJSON(
                '<?=base_url()?>platc/co_pediatria_calcular_de/<?=Platc::$CO_PEDIATRIA_DE['TALLA_EDAD']?>/'+$('#sexo').val()+'/'+x+'/'+y,
                { },
                function( data ) {
                    $('#nutricion_talla_para_edad_de').val( data );
                    $('#nutricion_talla_para_edad_de').change( );
                }
            );

        // Peso para la edad: Hasta 5 años (60 meses)
        x = "<?=$meses?>";
        y = $('#df_peso').val();
        if( parseInt( x ) <= 60 )
            $.getJSON(
                '<?=base_url()?>platc/co_pediatria_calcular_de/<?=Platc::$CO_PEDIATRIA_DE['PESO_EDAD']?>/'+$('#sexo').val()+'/'+x+'/'+y,
                { },
                function( data ) {
                    $('#nutricion_peso_para_edad_de').val( data );
                    $('#nutricion_peso_para_edad_de').change( );
                }
            );

        // Peso para la talla
        x = $('#df_talla').val();
        y = $('#df_peso').val();
        if( parseInt( "<?=$meses?>" ) < 60 ) {
            $.getJSON(
                '<?=base_url()?>platc/co_pediatria_calcular_de/<?=( $meses < 24 ) ? Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2'] : Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5'] ?>/'+$('#sexo').val()+'/'+x+'/'+y,
                { },
                function( data ) {
                    $('#nutricion_peso_para_talla_de').val( data );
                    $('#nutricion_peso_para_talla_de').change( );
                }
            );
        }

        // IMC
        x = "<?=$meses?>";
        y = $('#df_peso').val();
        if( parseInt( x ) <= 216 )
            $.getJSON(
                '<?=base_url()?>platc/co_pediatria_calcular_de/<?=Platc::$CO_PEDIATRIA_DE['IMC']?>/'+$('#sexo').val()+'/'+x+'/'+y,
                { },
                function( data ) {
                    $('#nutricion_imc_de').val( data );
                    $('#nutricion_imc_de').change( );
                }
            );

        // Perimetro cefalico
        x = "<?=$meses?>";
        y = $('#df_perimetro_cefalico').val();
        if( parseInt( x ) <= 60 && !isNaN( parseInt( y ) ) )
            $.getJSON(
                '<?=base_url()?>platc/co_pediatria_calcular_de/<?=Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO']?>/'+$('#sexo').val()+'/'+x+'/'+y,
                { },
                function( data ) {
                    $('#nutricion_perimetro_cefalico_de').val( data );
                    $('#nutricion_perimetro_cefalico_de').change( );
                }
            );
    }

    $(document).ready( function( ) {

        var talla_para_edad = [

            { id: '1', descripcion: '<?=$this->lang->line('nutricion_talla_para_edad_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('nutricion_talla_para_edad_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('nutricion_talla_para_edad_de_3_desc')?>' },
        ];

        var peso_para_edad = [

            { id: '1', descripcion: '<?=$this->lang->line('nutricion_peso_para_edad_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('nutricion_peso_para_edad_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('nutricion_peso_para_edad_de_3_desc')?>' },
            { id: '4', descripcion: '<?=$this->lang->line('nutricion_peso_para_edad_de_4_desc')?>' },
        ];

        var peso_para_talla = [

            { id: '1', descripcion: '<?=$this->lang->line('nutricion_peso_para_talla_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('nutricion_peso_para_talla_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('nutricion_peso_para_talla_de_3_desc')?>' },
            { id: '4', descripcion: '<?=$this->lang->line('nutricion_peso_para_talla_de_4_desc')?>' },
            { id: '5', descripcion: '<?=$this->lang->line('nutricion_peso_para_talla_de_5_desc')?>' },
            { id: '6', descripcion: '<?=$this->lang->line('nutricion_peso_para_talla_de_6_desc')?>' }
        ];

        var imc = [

            { id: '1', descripcion: '<?=$this->lang->line('nutricion_imc_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('nutricion_imc_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('nutricion_imc_de_3_desc')?>' },
            { id: '4', descripcion: '<?=$this->lang->line('nutricion_imc_de_4_desc')?>' },
            { id: '5', descripcion: '<?=$this->lang->line('nutricion_imc_de_5_desc')?>' }
        ];

        var perimetro_cefalico = [

            { id: '1', descripcion: '<?=$this->lang->line('nutricion_perimetro_cefalico_de_1_desc')?>' },
            { id: '2', descripcion: '<?=$this->lang->line('nutricion_perimetro_cefalico_de_2_desc')?>' },
            { id: '3', descripcion: '<?=$this->lang->line('nutricion_perimetro_cefalico_de_3_desc')?>' }
        ];

        $('#df_peso').blur( co_pediatria_calcular_de );

        $('#df_talla').blur( co_pediatria_calcular_de );

        $('#df_perimetro_cefalico').blur( co_pediatria_calcular_de );

        // Cambia texto según selección de la desviación.
        $('#nutricion_talla_para_edad_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in talla_para_edad )
                    if( talla_para_edad[i].id == $(this).val() )
                        $('#nutricion_talla_para_edad_de_desc').html( talla_para_edad[i].descripcion );
            } else
                $('#nutricion_talla_para_edad_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#nutricion_peso_para_edad_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in peso_para_edad )
                    if( peso_para_edad[i].id == $(this).val() )
                        $('#nutricion_peso_para_edad_de_desc').html( peso_para_edad[i].descripcion );
            } else
                $('#nutricion_peso_para_edad_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#nutricion_peso_para_talla_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in peso_para_talla )
                    if( peso_para_talla[i].id == $(this).val() )
                        $('#nutricion_peso_para_talla_de_desc').html( peso_para_talla[i].descripcion );
            } else
                $('#nutricion_peso_para_talla_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#nutricion_imc_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in imc )
                    if( imc[i].id == $(this).val() )
                        $('#nutricion_imc_de_desc').html( imc[i].descripcion );
            } else
                $('#nutricion_imc_de_desc').html( '-' );
        } );

        // Cambia texto según selección de la desviación.
        $('#nutricion_perimetro_cefalico_de').change( function( ) {

            if( $(this).val() != '' ) {
                for ( var i in perimetro_cefalico )
                    if( perimetro_cefalico[i].id == $(this).val() )
                        $('#nutricion_perimetro_cefalico_de_desc').html( perimetro_cefalico[i].descripcion );
            } else
                $('#nutricion_perimetro_cefalico_de_desc').html( '-' );
        } );

        // Levanta ventana con imagen de desviación estándar de la talla para la edad
        $('#nutricion_talla_para_edad_de_imagen').click( function( event ) {

            event.preventDefault();

            $('#nutricion_de_cuadro').dialog(
                {   modal: true,
                    title: "<?=$this->lang->line('nutricion_talla_para_edad_de')?>",
                    heigth: 400,
                    width: 900,
                    resizable: false,
                    open: function( event, object ) {

                        $('#nutricion_de_cuadro').css( 'display', 'block' );
                        $('#chartdiv').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $.jqplot( 'chartdiv',  '', {
                            axesDefaults: {
                                showTicks: true,
                            },
                            axes:{
                                xaxis: { min: 0, max: 216 }, yaxis: { min: 40, max: 220 }
                            },
                            seriesDefaults: {
                                lineWidth: 1,
                                shadow: false,
                                markerOptions: { show: false }
                            },
                            series:[{label: '3'}, {label: '2'}, {label: '1'}, {label: '0'}, {label: '-1'}, {label: '-2'}, {label: '-3'},  {label: '<?=$this->lang->line('nutricion_anteriores')?>', markerOptions: { show: true, size: 3, shadow: false } }, {label: '<?=$this->lang->line('nutricion_actual')?>', color: '#FF0000', markerOptions: { show: true, size: 8, shadow: false } } ],
                            dataRenderer: function( ) {
                                data = null;
                                $.ajax( {
                                    async: false,
                                    url: '<?=base_url()?>platc/co_pediatria_tabla_de/<?=Platc::$CO_PEDIATRIA_DE['TALLA_EDAD']?>/'+$('#idpac').val()+'/',
                                    dataType:"json",
                                    success: function( d ) {

                                        x = "<?=$meses?>";
                                        y = $('#df_talla').val();
                                        d[d.length-1].push( [ parseInt( x ), parseInt( y ) ] );
                                        d.push( [ [ parseInt( x ), parseInt( y ) ] ] );
                                        data = d;
                                    }
                                } );

                                return data;
                            },
                            legend: { show: true, location: 'nw' },
                            grid: { drawGridLines: true }
                        } );
                    },
                    close: function( event, ui ) {
                        $('#nutricion_de_cuadro').css( 'display', 'none' );
                    }
                }
            );

        } );

        // Levanta ventana con imagen de desviación estándar del peso para la edad
        $('#nutricion_peso_para_edad_de_imagen').click( function( event ) {

            event.preventDefault();

            $('#nutricion_de_cuadro').dialog(
                {   modal: true,
                    title: "<?=$this->lang->line('nutricion_peso_para_edad_de')?>",
                    heigth: 400,
                    width: 900,
                    resizable: false,
                    open: function( event, object ) {

                        $('#chartdiv').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $.jqplot( 'chartdiv',  '', {
                            axesDefaults: {
                                showTicks: true,
                            },
                            axes:{
                                xaxis: { min: 0, max: 60 }, yaxis: { min: 0, max: 30 }
                            },
                            seriesDefaults: {
                                lineWidth: 1,
                                shadow: false,
                                markerOptions: { show: false }
                            },
                            series:[{label: '3'}, {label: '2'}, {label: '1'}, {label: '0'}, {label: '-1'}, {label: '-2'}, {label: '-3'},  {label: '<?=$this->lang->line('nutricion_anteriores')?>', markerOptions: { show: true, size: 3, shadow: false } }, {label: '<?=$this->lang->line('nutricion_actual')?>', color: '#FF0000', markerOptions: { show: true, size: 8, shadow: false } } ],
                            dataRenderer: function( ) {
                                data = null;
                                $.ajax( {
                                    async: false,
                                    url: '<?=base_url()?>platc/co_pediatria_tabla_de/<?=Platc::$CO_PEDIATRIA_DE['PESO_EDAD']?>/'+$('#idpac').val()+'/',
                                    dataType:"json",
                                    success: function( d ) {

                                        x = "<?=$meses?>";
                                        if( parseInt( x ) <= 60 ) {
                                            y = $('#df_peso').val();
                                            d[d.length-1].push( [ parseInt( x ), parseInt( y ) ] );
                                            d.push( [ [ parseInt( x ), parseInt( y ) ] ] );
                                        }
                                        data = d;
                                    }
                                } );
                                return data;
                            },
                            legend: { show: true, location: 'nw' },
                            grid: { drawGridLines: true },
                            cursor: { show: true, tooltipLocation: 'sw' }
                        } );
                    },
                    close: function( event, ui ) {
                    }
                }
            );

        } );

        // Levanta ventana con imagen de desviación estándar del peso para la edad
        $('#nutricion_peso_para_talla_0_2_de_imagen').click( function( event ) {

            event.preventDefault();

            $('#nutricion_de_cuadro').dialog(
                {   modal: true,
                    title: "<?=$this->lang->line('nutricion_peso_para_talla_0_2_de')?>",
                    heigth: 400,
                    width: 900,
                    resizable: false,
                    open: function( event, object ) {

                        $('#chartdiv').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $.jqplot( 'chartdiv',  '', {
                            axesDefaults: {
                                showTicks: true, tickOptions: { formatString: '%d' }
                            },
                            axes:{
                                xaxis: { min: 45, max: 110 }, yaxis: { min: 0, max: 25 }
                            },
                            seriesDefaults: {
                                lineWidth: 1,
                                shadow: false,
                                markerOptions: { show: false }
                            },
                            series:[{label: '3'}, {label: '2'}, {label: '1'}, {label: '0'}, {label: '-1'}, {label: '-2'}, {label: '-3'},  {label: '<?=$this->lang->line('nutricion_anteriores')?>', markerOptions: { show: true, size: 3, shadow: false } }, {label: '<?=$this->lang->line('nutricion_actual')?>', color: '#FF0000', markerOptions: { show: true, size: 8, shadow: false } } ],
                            dataRenderer: function( ) {
                                data = null;
                                $.ajax( {
                                    async: false,
                                    url: '<?=base_url()?>platc/co_pediatria_tabla_de/<?=Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2']?>/'+$('#idpac').val()+'/',
                                    dataType:"json",
                                    success: function( d ) {

                                        if( parseInt( "<?=$meses?>" ) <= 24 ) {
                                            x = $('#df_talla').val();
                                            y = $('#df_peso').val();
                                            d[d.length-1].push( [ parseInt( x ), parseInt( y ) ] );
                                            d.push( [ [ parseInt( x ), parseInt( y ) ] ] );
                                        }
                                        data = d;
                                    }
                                } );
                                return data;
                            },
                            legend: { show: true, location: 'nw' },
                            grid: { drawGridLines: true },
                            cursor: { show: true, tooltipLocation: 'sw' }
                        } );
                    },
                    close: function( event, ui ) {
                    }
                }
            );

        } );

        // Levanta ventana con imagen de desviación estándar del peso para la edad
        $('#nutricion_peso_para_talla_2_5_de_imagen').click( function( event ) {

            event.preventDefault();

            $('#nutricion_de_cuadro').dialog(
                {   modal: true,
                    title: "<?=$this->lang->line('nutricion_peso_para_talla_2_5_de')?>",
                    heigth: 400,
                    width: 900,
                    resizable: false,
                    open: function( event, object ) {

                        $('#chartdiv').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $.jqplot( 'chartdiv',  '', {
                            axesDefaults: {
                                showTicks: true, tickOptions: { formatString: '%d' }
                            },
                            axes:{ xaxis: { min: 65, max: 125 }, yaxis: { min: 0, max: 35 } },
                            seriesDefaults: {
                                lineWidth: 1,
                                shadow: false,
                                markerOptions: { show: false }
                            },
                            series:[{label: '3'}, {label: '2'}, {label: '1'}, {label: '0'}, {label: '-1'}, {label: '-2'}, {label: '-3'},  {label: '<?=$this->lang->line('nutricion_anteriores')?>', markerOptions: { show: true, size: 3, shadow: false } }, {label: '<?=$this->lang->line('nutricion_actual')?>', color: '#FF0000', markerOptions: { show: true, size: 8, shadow: false } } ],
                            dataRenderer: function( ) {
                                data = null;
                                $.ajax( {
                                    async: false,
                                    url: '<?=base_url()?>platc/co_pediatria_tabla_de/<?=Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5']?>/'+$('#idpac').val()+'/',
                                    dataType:"json",
                                    success: function( d ) {

                                        if( parseInt( "<?=$meses?>" ) >= 24 && parseInt( "<?=$meses?>" ) <= 60 ) {

                                            x = $('#df_talla').val();
                                            y = $('#df_peso').val();
                                            d[d.length-1].push( [ parseInt( x ), parseInt( y ) ] );
                                            d.push( [ [ parseInt( x ), parseInt( y ) ] ] );
                                        }
                                        data = d;
                                    }
                                } );
                                return data;
                            },
                            legend: { show: true, location: 'nw' },
                            grid: { drawGridLines: true },
                            cursor: { show: true, tooltipLocation: 'sw' }
                        } );
                    },
                    close: function( event, ui ) {
                    }
                }
            );

        } );

        // Levanta ventana con imagen de desviación estándar del IMC
        $('#nutricion_imc_imagen').click( function( event ) {

            event.preventDefault();

            $('#nutricion_de_cuadro').dialog(
                {   modal: true,
                    title: "<?=$this->lang->line('nutricion_imc_de')?>",
                    heigth: 400,
                    width: 900,
                    resizable: false,
                    open: function( event, object ) {

                        $('#chartdiv').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $.jqplot( 'chartdiv',  '', {
                            axesDefaults: {
                                showTicks: true,
                            },
                            axes:{ xaxis: { min: 0, max: 216 }, yaxis: { min: 10, max: 40 } },
                            seriesDefaults: {
                                lineWidth: 1,
                                shadow: false,
                                markerOptions: { show: false }
                            },
                            series:[{label: '3'}, {label: '2'}, {label: '1'}, {label: '0'}, {label: '-1'}, {label: '-2'}, {label: '-3'},  {label: '<?=$this->lang->line('nutricion_anteriores')?>', markerOptions: { show: true, size: 3, shadow: false } }, {label: '<?=$this->lang->line('nutricion_actual')?>', color: '#FF0000', markerOptions: { show: true, size: 8, shadow: false } } ],
                            dataRenderer: function( ) {
                                data = null;
                                $.ajax( {
                                    async: false,
                                    url: '<?=base_url()?>platc/co_pediatria_tabla_de/<?=Platc::$CO_PEDIATRIA_DE['IMC']?>/'+$('#idpac').val()+'/',
                                    dataType:"json",
                                    success: function( d ) {

                                        x = "<?=$meses?>";
                                        if( parseInt( x ) <= 216 ) {

                                            y = $('#df_imc').val();
                                            d[d.length-1].push( [ parseInt( x ), parseInt( y ) ] );
                                            d.push( [ [ parseInt( x ), parseInt( y ) ] ] );
                                        }
                                        data = d;
                                    }
                                } );
                                return data;
                            },
                            legend: { show: true, location: 'nw' },
                            grid: { drawGridLines: true },
                            cursor: { show: true, tooltipLocation: 'sw' }
                        } );
                    },
                    close: function( event, ui ) {
                    }
                }
            );

        } );

        // Levanta ventana con imagen de desviación estándar del perímetro encefálico
        $('#nutricion_perimetro_cefalico_imagen').click( function( event ) {

            event.preventDefault();

            $('#nutricion_de_cuadro').dialog(
                {   modal: true,
                    title: "<?=$this->lang->line('nutricion_perimetro_cefalico_de')?>",
                    heigth: 400,
                    width: 900,
                    resizable: false,
                    open: function( event, object ) {

                        $('#chartdiv').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $.jqplot( 'chartdiv',  '', {
                            axesDefaults: {
                                showTicks: true,
                            },
                            axes:{ xaxis: { min: 0, max: 60 }, yaxis: { min: 30, max: 60 } },
                            seriesDefaults: {
                                lineWidth: 1,
                                shadow: false,
                                markerOptions: { show: false }
                            },
                            series:[{label: '3'}, {label: '2'}, {label: '1'}, {label: '0'}, {label: '-1'}, {label: '-2'}, {label: '-3'},  {label: '<?=$this->lang->line('nutricion_anteriores')?>', markerOptions: { show: true, size: 3, shadow: false } }, {label: '<?=$this->lang->line('nutricion_actual')?>', color: '#FF0000', markerOptions: { show: true, size: 8, shadow: false } } ],
                            dataRenderer: function( ) {
                                data = null;
                                $.ajax( {
                                    async: false,
                                    url: '<?=base_url()?>platc/co_pediatria_tabla_de/<?=Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO']?>/'+$('#idpac').val()+'/',
                                    dataType:"json",
                                    success: function( d ) {

                                        x = "<?=$meses?>";
                                        if( parseInt( x ) <= 60 ) {
                                            y = $('#df_perimetro_cefalico').val();
                                            d[d.length-1].push( [ parseInt( x ), parseInt( y ) ] );
                                            d.push( [ [ parseInt( x ), parseInt( y ) ] ] );
                                        }
                                        data = d;
                                    }
                                } );
                                return data;
                            },
                            legend: { show: true, location: 'nw' },
                            grid: { drawGridLines: true },
                            cursor: { show: true, tooltipLocation: 'sw' }
                        } );
                    },
                    close: function( event, ui ) {
                    }
                }
            );

        } );

    } );
</script>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Título de desviación estandar -->
        <tr>
            <td colspan="2" align="center" style="font-weight: bold;"><?=$this->lang->line('nutricion_desviaciones_estandar')?></td>
        </tr>

        <!-- Talla para la edad -->
        <tr>
            <td class="data_form"><?=$this->lang->line('nutricion_talla_para_edad_de')?>:</td>
            <td align="left">
                <select name="nutricion_talla_para_edad_de" id="nutricion_talla_para_edad_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $nutricion_talla_para_edad_de ) && !empty($nutricion_talla_para_edad_de) && $nutricion_talla_para_edad_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_talla_para_edad_de_1')?></option>
                    <option value="2" <?=( isset( $nutricion_talla_para_edad_de ) && !empty($nutricion_talla_para_edad_de) && $nutricion_talla_para_edad_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_talla_para_edad_de_2')?></option>
                    <option value="3" <?=( isset( $nutricion_talla_para_edad_de ) && !empty($nutricion_talla_para_edad_de) && $nutricion_talla_para_edad_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_talla_para_edad_de_3')?></option>
                </select>

                &nbsp;<a href="#" id="nutricion_talla_para_edad_de_imagen" ><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="nutricion_talla_para_edad_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $nutricion_talla_para_edad_de ) && !empty($nutricion_talla_para_edad_de) ) {
                            switch( $nutricion_talla_para_edad_de ) {

                                case '1' : echo $this->lang->line('nutricion_talla_para_edad_de_1_desc'); break;
                                case '2' : echo $this->lang->line('nutricion_talla_para_edad_de_2_desc'); break;
                                case '3' : echo $this->lang->line('nutricion_talla_para_edad_de_3_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- Peso para la edad -->
        <tr>
            <td class="data_form"><?=$this->lang->line('nutricion_peso_para_edad_de')?>:</td>
            <td align="left">
                <select name="nutricion_peso_para_edad_de" id="nutricion_peso_para_edad_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $nutricion_peso_para_edad_de ) && !empty($nutricion_peso_para_edad_de) && $nutricion_peso_para_edad_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_edad_de_1')?></option>
                    <option value="2" <?=( isset( $nutricion_peso_para_edad_de ) && !empty($nutricion_peso_para_edad_de) && $nutricion_peso_para_edad_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_edad_de_2')?></option>
                    <option value="3" <?=( isset( $nutricion_peso_para_edad_de ) && !empty($nutricion_peso_para_edad_de) && $nutricion_peso_para_edad_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_edad_de_3')?></option>
                    <option value="4" <?=( isset( $nutricion_peso_para_edad_de ) && !empty($nutricion_peso_para_edad_de) && $nutricion_peso_para_edad_de == '4' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_edad_de_4')?></option>
                </select>
                &nbsp;<a href="#" id="nutricion_peso_para_edad_de_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="nutricion_peso_para_edad_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $nutricion_peso_para_edad_de ) && !empty($nutricion_peso_para_edad_de) ) {
                            switch( $nutricion_peso_para_edad_de ) {

                                case '1' : echo $this->lang->line('nutricion_peso_para_edad_de_1_desc'); break;
                                case '2' : echo $this->lang->line('nutricion_peso_para_edad_de_2_desc'); break;
                                case '3' : echo $this->lang->line('nutricion_peso_para_edad_de_3_desc'); break;
                                case '4' : echo $this->lang->line('nutricion_peso_para_edad_de_4_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- Peso para la talla -->
        <tr>
            <td class="data_form"><?=$this->lang->line('nutricion_peso_para_talla_de')?>:</td>
            <td align="left">
                <select name="nutricion_peso_para_talla_de" id="nutricion_peso_para_talla_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) && $nutricion_peso_para_talla_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_talla_de_1')?></option>
                    <option value="2" <?=( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) && $nutricion_peso_para_talla_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_talla_de_2')?></option>
                    <option value="3" <?=( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) && $nutricion_peso_para_talla_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_talla_de_3')?></option>
                    <option value="4" <?=( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) && $nutricion_peso_para_talla_de == '4' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_talla_de_4')?></option>
                    <option value="5" <?=( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) && $nutricion_peso_para_talla_de == '5' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_talla_de_5')?></option>
                    <option value="6" <?=( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) && $nutricion_peso_para_talla_de == '6' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_peso_para_talla_de_6')?></option>
                </select>
                <?=$this->lang->line('nutricion_kg')?>
                &nbsp;(0-2 años)<a href="#" id="nutricion_peso_para_talla_0_2_de_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                &nbsp;(2-5 años)<a href="#" id="nutricion_peso_para_talla_2_5_de_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="nutricion_peso_para_talla_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $nutricion_peso_para_talla_de ) && !empty($nutricion_peso_para_talla_de) ) {
                            switch( $nutricion_peso_para_talla_de ) {

                                case '1' : echo $this->lang->line('nutricion_peso_para_talla_de_1_desc'); break;
                                case '2' : echo $this->lang->line('nutricion_peso_para_talla_de_2_desc'); break;
                                case '3' : echo $this->lang->line('nutricion_peso_para_talla_de_3_desc'); break;
                                case '4' : echo $this->lang->line('nutricion_peso_para_talla_de_4_desc'); break;
                                case '5' : echo $this->lang->line('nutricion_peso_para_talla_de_5_desc'); break;
                                case '6' : echo $this->lang->line('nutricion_peso_para_talla_de_6_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <!-- IMC -->
        <tr>
            <td class="data_form"><?=$this->lang->line('df_imc')?>:</td>
            <td align="left">
                <select name="nutricion_imc_de" id="nutricion_imc_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $nutricion_imc_de ) && !empty($nutricion_imc_de) && $nutricion_imc_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_imc_de_1')?></option>
                    <option value="2" <?=( isset( $nutricion_imc_de ) && !empty($nutricion_imc_de) && $nutricion_imc_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_imc_de_2')?></option>
                    <option value="3" <?=( isset( $nutricion_imc_de ) && !empty($nutricion_imc_de) && $nutricion_imc_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_imc_de_3')?></option>
                    <option value="4" <?=( isset( $nutricion_imc_de ) && !empty($nutricion_imc_de) && $nutricion_imc_de == '4' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_imc_de_4')?></option>
                    <option value="5" <?=( isset( $nutricion_imc_de ) && !empty($nutricion_imc_de) && $nutricion_imc_de == '5' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_imc_de_5')?></option>
                </select>

                &nbsp;<a href="#" id="nutricion_imc_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="nutricion_imc_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $nutricion_imc_de ) && !empty($nutricion_imc_de) ) {
                            switch( $nutricion_imc_de ) {

                                case '1' : echo $this->lang->line('nutricion_imc_de_1_desc'); break;
                                case '2' : echo $this->lang->line('nutricion_imc_de_2_desc'); break;
                                case '3' : echo $this->lang->line('nutricion_imc_de_3_desc'); break;
                                case '4' : echo $this->lang->line('nutricion_imc_de_4_desc'); break;
                                case '5' : echo $this->lang->line('nutricion_imc_de_5_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
                <br/>
            </td>
        </tr>

        <?php if( $meses <= 60 ) { ?>
        <!-- Perimetro cefálico -->
        <tr>
            <td class="data_form"><?=$this->lang->line('df_perimetro_cefalico')?>:</td>
            <td align="left">

                <select name="nutricion_perimetro_cefalico_de" id="nutricion_perimetro_cefalico_de">
                    <option value="" > </option>
                    <option value="1" <?=( isset( $nutricion_perimetro_cefalico_de ) && !empty($nutricion_perimetro_cefalico_de) && $nutricion_perimetro_cefalico_de == '1' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_perimetro_cefalico_de_1')?></option>
                    <option value="2" <?=( isset( $nutricion_perimetro_cefalico_de ) && !empty($nutricion_perimetro_cefalico_de) && $nutricion_perimetro_cefalico_de == '2' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_perimetro_cefalico_de_2')?></option>
                    <option value="3" <?=( isset( $nutricion_perimetro_cefalico_de ) && !empty($nutricion_perimetro_cefalico_de) && $nutricion_perimetro_cefalico_de == '3' )? 'selected="selected"' : ''?> ><?=$this->lang->line('nutricion_perimetro_cefalico_de_3')?></option>
                </select>

                &nbsp;<a href="#" id="nutricion_perimetro_cefalico_imagen"><img src="<?=base_url()?>images/ver_ch.png" style="vertical-align: middle;" /></a>
                <br/>
                <span id="nutricion_perimetro_cefalico_de_desc" style="font-style: italic;">
                    <?php
                        if( isset( $nutricion_perimetro_cefalico_de ) && !empty($nutricion_perimetro_cefalico_de) ) {
                            switch( $nutricion_perimetro_cefalico_de ) {

                                case '1' : echo $this->lang->line('nutricion_perimetro_cefalico_de_1_desc'); break;
                                case '2' : echo $this->lang->line('nutricion_perimetro_cefalico_de_2_desc'); break;
                                case '3' : echo $this->lang->line('nutricion_perimetro_cefalico_de_3_desc'); break;
                                default: echo '-';
                            }
                        } else echo '-';
                    ?>
                </span>
            </td>
        </tr>
        <?php } ?>

    </tbody>
</table>

<div id="nutricion_de_cuadro" style="display: none;">
    <div id="chartdiv" style="height:400px;width:850px; "></div>
</div>
<?php } else { ?>
<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Título de desviación estandar -->
        <tr>
            <td colspan="2" align="center" style="font-style: italic; "><?=$this->lang->line('nutricion_no_aplica_mayor_18')?></td>
        </tr>
    </tbody>
</table>
<?php }
}

if( $modo == FormularioXML::$MODO_PDF ) {

    $intervalo = date_diff( new DateTime(), new DateTime( $tc['TEL_PAC_NACIMIENTO'] ) );
    $meses     = (int)( ( $intervalo->y * 12 ) + $intervalo->m );

    // 216 meses: 18 años
    if( $meses <= 216 ) {

        // Talla para edad
        $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_talla_para_edad_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($nutricion_talla_para_edad_de) && !empty($nutricion_talla_para_edad_de) )?
                $this->lang->line( 'nutricion_talla_para_edad_de_'.$nutricion_talla_para_edad_de ) .
                ' ('.$this->lang->line( 'nutricion_talla_para_edad_de_'.$nutricion_talla_para_edad_de.'_desc' ).')' : '' ), 0, 'L', false, 0 );

        // Peso para la edad
        $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_peso_para_edad_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($nutricion_peso_para_edad_de) && !empty($nutricion_peso_para_edad_de) )?
                $this->lang->line( 'nutricion_peso_para_edad_de_'.$nutricion_peso_para_edad_de ) .
                ' ('.$this->lang->line( 'nutricion_peso_para_edad_de_'.$nutricion_peso_para_edad_de.'_desc' ).')':'' ), 0, 'L', false, 0 );

        // Peso para la talla
        $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_peso_para_talla_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($nutricion_peso_para_talla_de) && !empty($nutricion_peso_para_talla_de) )?
                $this->lang->line( 'nutricion_peso_para_talla_de_'.$nutricion_peso_para_talla_de ) .
                ' ('.$this->lang->line( 'nutricion_peso_para_talla_de_'.$nutricion_peso_para_talla_de.'_desc' ).')' :'' ), 0, 'L', false, 0 );

        // IMC
        $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_imc' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($nutricion_imc_de) && !empty($nutricion_imc_de) )?
                $this->lang->line( 'nutricion_imc_de_'.$nutricion_imc_de ) .
                ' ('.$this->lang->line( 'nutricion_imc_de_'.$nutricion_imc_de.'_desc' ).')' : '' ), 0, 'L', false, 0 );

        if( isset( $nutricion_perimetro_cefalico_de ) ) {

            // Perimetro cefálico
            $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'df_perimetro_cefalico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
            $pdf->MultiCell( 0, 6, html_entity_decode( !empty($nutricion_perimetro_cefalico_de ) ?
                    $this->lang->line( 'nutricion_perimetro_cefalico_de_'.$nutricion_perimetro_cefalico_de ) .
                    ' ('.$this->lang->line( 'nutricion_perimetro_cefalico_de_'.$nutricion_perimetro_cefalico_de.'_desc' ) .')' : '' ), 0, 'L', false, 0 );
        }

    } else {

        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'nutricion_no_aplica_mayor_18' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'C', false, 0 );
    }
}

