<?php
if ($modo == FormularioXML::$MODO_LECTURA) {

    if( (int)$tc['TEL_PAC_EDAD'] < 18 ) { ?>

    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>
            <tr>
                <td style="text-align: center; font-style: italic;"><?= $this->lang->line('nutricion_no_aplica_menor_18')?> </td>
            </tr>
        </tbody>
    </table>
<?php   } else { ?>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>

            <!-- Titulos -->
            <tr>
                <td style="text-align: center"><?=$this->lang->line('nutricion_criterio')?></td>
                <td style="text-align: center; width: 300px;" colspan="2"><?=$this->lang->line('nutricion_respuesta')?></td>
                <td style="text-align: center" ><?=$this->lang->line('nutricion_valor')?></td>
            </tr>

            <!-- ¿Ha perdido peso sin intentarlo ? -->
            <tr>
                <td class="data_form"><?= $this->lang->line('nutricion_ha_perdido_peso_sin_intentarlo') ?>:</td>
                <td align="left" style="width: 300px; " colspan="2">
                    <?php
                    $texto = "";
                    $valor = ( isset( $t_perdido_peso_sin_intentar_valor ) && !empty($t_perdido_peso_sin_intentar_valor) ) ? $t_perdido_peso_sin_intentar_valor : ' - ';
                    //imprimir($t_perdido_peso_sin_intentar);
                    if( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) ) {
                        switch( $t_perdido_peso_sin_intentar ) {
                            case 'si' : {$texto = $this->lang->line('nutricion_si'); $valor = $this->lang->line('nutricion_responda_siguiente_pregunta'); }; break;
                            case 'no' : {$texto = $this->lang->line('nutricion_no'); }; break;
                            case 'no_esta_seguro' : {$texto = $this->lang->line('nutricion_no_esta_seguro'); }; break;
                            default: $texto = '-';
                        }
                    }
                    echo $texto;
                    ?>
                </td>
                <td style="text-align: center"><?=$valor?></td>
            </tr>

            <!-- Si la respuesta anterior es si ¿cuantos kilos ha perdido ? -->
            <?php if( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) && $t_perdido_peso_sin_intentar == 'si' ) { ?>
            <tr id="cuadro_t_cuantos_kilos">
                <td class="data_form"><?= $this->lang->line('nutricion_cuantos_kilos_perdidos') ?>:</td>
                <td align="left" style="width: 300px; " colspan="2"><?php
                    $valor = ( isset( $t_cuantos_kilos_valor ) && !empty($t_cuantos_kilos_valor) ) ? $t_cuantos_kilos_valor : ' - ';
                    //imprimir($t_cuantos_kilos);
                    
                    if(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "1-5" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_1-5');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "1-5.9" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_1-5.9');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "6-10" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_6-10');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "6-10.5" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_6-10.5');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "11-15" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_11-15');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "10.6-15" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_10.6-15');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == ">15" ){
                        $texto = $this->lang->line('nutricion_cuantos_kilos_>15');
                    } elseif(isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) && html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == "no_esta_seguro" ){
                        $texto = $this->lang->line('nutricion_no_esta_seguro');
                    } else {$texto = '-';}
                    
//                    switch( isset($t_cuantos_kilos) && !empty ($t_cuantos_kilos) ) {
//                        case "1-5"              : {$texto = $this->lang->line('nutricion_cuantos_kilos_1-5'); }; break;
//                        case "1-5.9"            : {$texto = $this->lang->line('nutricion_cuantos_kilos_1-5.9'); }; break;
//                        case "6-10"             : {$texto = $this->lang->line('nutricion_cuantos_kilos_6-10'); }; break;
//                        case "6-10.5"           : {$texto = $this->lang->line('nutricion_cuantos_kilos_6-10.5'); }; break;
//                        case "11-15"            : {$texto = $this->lang->line('nutricion_cuantos_kilos_11-15'); }; break;
//                        case "10.6-15"          : {$texto = $this->lang->line('nutricion_cuantos_kilos_10.6-15'); }; break;
//                        case ">15"              : {$texto = $this->lang->line('nutricion_cuantos_kilos_>15'); }; break;
//                        case "no_esta_seguro"   : {$texto = $this->lang->line('nutricion_no_esta_seguro'); }; break;
//                        default: $texto = '-';                            
//                    }
                    //imprimir($texto);
                    echo $texto;
                    ?>
                </td>
                <td style="width: 100px; text-align: center"><?=$valor?></td>
            </tr>
            <?php } ?>

            <!-- ¿Ha perdido peso y por eso no come? -->
            <tr>
                <td class="data_form"><?= $this->lang->line('nutricion_perdido_apetito_no_come') ?>:</td>
                <td align="left" style="width: 300px; " colspan="2">
                    <?php
                    $texto = "";
                    if( isset( $t_perdido_apetito ) && !empty( $t_perdido_apetito ) ) {
                        switch( $t_perdido_apetito ) {
                            case "si"   : {$texto = $this->lang->line('nutricion_si'); }; break;
                            case "no"   : {$texto = $this->lang->line('nutricion_no'); }; break;
                            default: $texto = '-';
                        }
                    }
                    echo $texto;
                    ?>
                </td>
                <td style="width: 100px; text-align: center"><?=( isset( $t_perdido_apetito_valor ) ) ? $t_perdido_apetito_valor : '-' ?></td>
            </tr>

            <!-- Total MTF -->
            <tr>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="width: 100px; text-align: right; background-color: #DDDDDD" ><?=$this->lang->line('nutricion_total_mtf')?>: </td>
                <td style="width: 100px; text-align: center; background-color: #DDDDDD" ><?=( isset( $t_nutricion_total_mtf_valor ) ) ? $t_nutricion_total_mtf_valor : ' - ' ?></td>
            </tr>

            <!-- Clasificación -->
            <tr>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="width: 100px; text-align: right; background-color: #BBBBBB" ><?=$this->lang->line('nutricion_clasificacion')?>: </td>
                <td style="width: 100px; text-align: center; background-color: #BBBBBB" ><?=( isset( $t_nutricion_clasificacion_valor ) ) ? $t_nutricion_clasificacion_valor : ' - ' ?></td>
            </tr>

        </tbody>
    </table>

    <?php } ?>
<?php

}

if ($modo == FormularioXML::$MODO_ESCRITURA) {
//imprimir( $tc );
    if( (int)$tc['TEL_PAC_EDAD'] < 18 ) { ?>

    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>
            <tr>
                <td style="text-align: center; font-style: italic;"><?= $this->lang->line('nutricion_no_aplica_menor_18')?> </td>
            </tr>
        </tbody>
    </table>
<?php   } else { ?>

    <script language="javascript" type="text/javascript">

        function calcular_clasificacion(  ) {

            if( ( $('#t_perdido_peso_sin_intentar' ).val() === 'si' && $('#t_cuantos_kilos' ).val() === '' )
                || $('#t_perdido_peso_sin_intentar' ).val() === '' || $('#t_perdido_apetito').val() === '' ) {

                // Establece total calculado
                $('#t_nutricion_total_mtf_span').html( '-' );
                $('#t_nutricion_total_mtf_valor').val( '' );

                // Establece clasificacion segun el total
                $('#t_nutricion_clasificacion_span').html( '-' );
                $('#t_nutricion_clasificacion_valor').val( '' );

                return;
            }

            t_perdido_peso_sin_intentar = parseInt( $('#t_perdido_peso_sin_intentar_valor').val() );
            t_cuantos_kilos             = parseInt( $('#t_cuantos_kilos_valor').val() );
            t_perdido_apetito           = parseInt( $('#t_perdido_apetito_valor').val() );

            //
            t_perdido_peso_sin_intentar = isNaN( t_perdido_peso_sin_intentar ) ? 0 : t_perdido_peso_sin_intentar;
            t_cuantos_kilos             = isNaN( t_cuantos_kilos ) ? 0 : t_cuantos_kilos;
            t_perdido_apetito           = isNaN( t_perdido_apetito ) ? 0 : t_perdido_apetito;

            // Establece total calculado
            total = t_perdido_peso_sin_intentar + t_cuantos_kilos + t_perdido_apetito;
            $('#t_nutricion_total_mtf_span').html( total );
            $('#t_nutricion_total_mtf_valor').val( total );

            // Establece clasificacion segun el total
            clasificacion = "";
            if( total > 3 ) {
                clasificacion = "<?=$this->lang->line('nutricion_riesgo_alto')?>";
            } else if( total > 1 ) {
                clasificacion = "<?=$this->lang->line('nutricion_riesgo_medio')?>";
            } else if( total >= 0 ) {
                clasificacion = "<?=$this->lang->line('nutricion_riesgo_bajo')?>";
            }
            $('#t_nutricion_clasificacion_span').html( clasificacion );
            $('#t_nutricion_clasificacion_valor').val( clasificacion );

            return;
        }

        $(document).ready( function( ) {

            $('#t_perdido_peso_sin_intentar').change( function( ) {

                switch( $(this).val() ) {

                    // '': "Reinicia" formulario
                    case '' :   $('#t_perdido_peso_sin_intentar_valor').val( '' ); // Elimina valor ¿perdido peso sin intenarlo?, en input
                                $('#t_perdido_peso_sin_intentar_span').html( '' );  // Elimina valor ¿perdido peso sin intenarlo?, en pantalla
                                $('#t_cuantos_kilos_cuadro').slideUp();     // Esconde cuadro ¿cuantos kilos?
                                $('#t_cuantos_kilos').val('');              // Elimina respuesta ¿cuantos kilos?
                                $('#t_cuantos_kilos_valor').val('');        // Elimina valor ¿cuantos kilos?, en input
                                $('#t_cuantos_kilos_span').html('');        // Elimina valor ¿cuantos kilos?, en pantalla
                                break;

                    // Si
                    case 'si' : $('#t_perdido_peso_sin_intentar_valor').val( '0' ); // Establece valor "si" en ¿perdido peso sin intenarlo?, en input
                                $('#t_perdido_peso_sin_intentar_span').html( '<?=$this->lang->line('nutricion_responda_siguiente_pregunta')?>' ); // Establece valor "responda siguiente pregunta", en pantalla
                                $('#t_cuantos_kilos_cuadro').slideDown();   // Muestra cuadro ¿cuantos kilos?
                                $('#t_cuantos_kilos').val('');              // Elimina valor ¿cuantos kilos?
                                $('#t_cuantos_kilos_valor').val('');        // Elimina valor ¿cuantos kilos?, en input
                                $('#t_cuantos_kilos_span').html('');        // Elimina valor ¿cuantos kilos?, en pantalla
                                break;

                    // No
                    case 'no' : $('#t_perdido_peso_sin_intentar_valor').val( '0' ); // Establece valor 0 en ¿perdido peso sin intenarlo?, en input
                                $('#t_perdido_peso_sin_intentar_span').html( '0' );   // Establece valor 0 en ¿perdido peso sin intenarlo?, en pantalla
                                $('#t_cuantos_kilos_cuadro').slideUp();     // Esconde cuadro ¿cuantos kilos?
                                $('#t_cuantos_kilos').val('');              // Elimina respuesta ¿cuantos kilos?
                                $('#t_cuantos_kilos_valor').val('');        // Elimina valor ¿cuantos kilos?, en input
                                $('#t_cuantos_kilos_span').html('');        // Elimina valor ¿cuantos kilos?, en pantalla
                                break;

                    // No está seguro
                    case 'no_esta_seguro' :
                                $('#t_perdido_peso_sin_intentar_valor').val( '2' ); // Establece valor 2 en ¿perdido peso sin intenarlo?, en input
                                $('#t_perdido_peso_sin_intentar_span').html( '2' ); // Establece valor 2 en ¿perdido peso sin intenarlo?, en pantalla
                                $('#t_cuantos_kilos_cuadro').slideUp();     // Esconde cuadro ¿cuantos kilos?
                                $('#t_cuantos_kilos').val('');              // Elimina respuesta ¿cuantos kilos?
                                $('#t_cuantos_kilos_valor').val('');        // Elimina valor ¿cuantos kilos?, en input
                                $('#t_cuantos_kilos_span').html('');        // Elimina valor ¿cuantos kilos?, en pantalla
                                break;
                }

                calcular_clasificacion();
            } );

            $('#t_cuantos_kilos').change( function( ) {

                switch( $(this).val() ) {

                    // '': "Reinicia" formulario
                    case ''       :   $('#t_cuantos_kilos_valor').val( '' );  $('#t_cuantos_kilos_span').html( '' ); break;

                    // 1-5
                    case '1-5'    :   $('#t_cuantos_kilos_valor').val( '1' ); $('#t_cuantos_kilos_span').html( '1' ); break;

                    // 1-5.9
                    case '1-5.9'  :   $('#t_cuantos_kilos_valor').val( '1' ); $('#t_cuantos_kilos_span').html( '1' ); break;

                    // 6-10
                    case '6-10'   :   $('#t_cuantos_kilos_valor').val( '2' ); $('#t_cuantos_kilos_span').html( '2' ); break;

                    // 6-10.5
                    case '6-10.5' :   $('#t_cuantos_kilos_valor').val( '2' ); $('#t_cuantos_kilos_span').html( '2' ); break;

                    // 11-15
                    case '11-15'  :   $('#t_cuantos_kilos_valor').val( '3' ); $('#t_cuantos_kilos_span').html( '3' ); break;

                    // 10.6-15
                    case '10.6-15':   $('#t_cuantos_kilos_valor').val( '3' ); $('#t_cuantos_kilos_span').html( '3' ); break;

                    // >15
                    case '>15'    :   $('#t_cuantos_kilos_valor').val( '4' ); $('#t_cuantos_kilos_span').html( '4' ); break;

                    // No está seguro
                    case 'no_esta_seguro' :   $('#t_cuantos_kilos_valor').val( '2' ); $('#t_cuantos_kilos_span').html( '2' ); break;
                }

                calcular_clasificacion();
            } );

            $('#t_perdido_apetito').change( function( ) {

                switch( $(this).val() ) {

                    // '': "Reinicia" formulario
                    case ''     : { $('#t_perdido_apetito_valor').val( '' );  $('#t_perdido_apetito_span').html( '' ); } break;

                    // 1: Si
                    case 'si'   : { $('#t_perdido_apetito_valor').val( '1' ); $('#t_perdido_apetito_span').html( '1' ); } break;

                    // 2: No
                    case 'no'   : { $('#t_perdido_apetito_valor').val( '0' ); $('#t_perdido_apetito_span').html( '0' ); } break;
                }

                calcular_clasificacion();
            } );

            $('#t_perdido_peso_sin_intentar').change();
            $('#t_cuantos_kilos').change();
            $('#t_perdido_apetito').change();
        } );

    </script>

    <table width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>

            <!-- Titulos -->
            <tr>
                <td style="text-align: center"><?=$this->lang->line('nutricion_criterio')?></td>
                <td style="text-align: center; width: 300px;" colspan="2"><?=$this->lang->line('nutricion_respuesta')?></td>
                <td style="text-align: center" ><?=$this->lang->line('nutricion_valor')?></td>
            </tr>

            <!-- ¿Ha perdido peso sin intentarlo ? -->
            <tr>
                <td class="data_form"><?= $this->lang->line('nutricion_ha_perdido_peso_sin_intentarlo') ?>:</td>
                <td align="left" style="width: 300px; " colspan="2">
                    <input type="hidden" name="t_perdido_peso_sin_intentar_valor" id="t_perdido_peso_sin_intentar_valor" value=""/>
                    <select name="t_perdido_peso_sin_intentar" id="t_perdido_peso_sin_intentar" style="width: 200px;" >
                        <option value="" <?= ( !isset( $t_perdido_peso_sin_intentar ) || empty( $t_perdido_peso_sin_intentar ) ) ? 'selected="selected"' :  "" ?>></option>
                        <option value="si" <?= ( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) && $t_perdido_peso_sin_intentar == "si" ) ? 'selected="selected"' :  "" ?> ><?=$this->lang->line('nutricion_si')?></option>
                        <option value="no" <?= ( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) && $t_perdido_peso_sin_intentar == "no" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_no')?></option>
                        <option value="no_esta_seguro" <?=( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) && $t_perdido_peso_sin_intentar == "no_esta_seguro" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_no_esta_seguro')?></option>
                    </select>
                </td>
                <td style="text-align: center"><span id="t_perdido_peso_sin_intentar_span"></span></td>
            </tr>

            <!-- Si la respuesta anterior es si ¿cuantos kilos ha perdido ? -->
            <tr id="t_cuantos_kilos_cuadro" <?=( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) && $t_perdido_peso_sin_intentar == "si" ) ? "" : "style=\"display: none;\" " ?> >
                <td class="data_form"><?= $this->lang->line('nutricion_cuantos_kilos_perdidos') ?>:</td>
                <td align="left" style="width: 300px; " colspan="2">
                    <input type="hidden" name="t_cuantos_kilos_valor" id="t_cuantos_kilos_valor" value="" />
                    <select name="t_cuantos_kilos" id="t_cuantos_kilos" style="width: 200px;">
                        <option value="" <?= ( !isset( $t_cuantos_kilos ) || empty( $t_cuantos_kilos ) ) ? 'selected="selected"' :  "" ?>></option>
                        <?php if( !isset( $t_cuantos_kilos ) || empty( $t_cuantos_kilos ) ) { echo"1"; ?>
                            <option value="1-5.9" ><?=$this->lang->line('nutricion_cuantos_kilos_1-5.9')?></option>
                            <option value="6-10.5" ><?=$this->lang->line('nutricion_cuantos_kilos_6-10.5')?></option>
                            <option value="10.6-15" ><?=$this->lang->line('nutricion_cuantos_kilos_10.6-15')?></option>
                            <option value=">15" ><?=$this->lang->line('nutricion_cuantos_kilos_>15')?></option>
                            <option value="no_esta_seguro" ><?=$this->lang->line('nutricion_no_esta_seguro')?></option>
                        <?php } ?>

                        <!-- MTF tabla antigua -->
                        <?php if( isset( $t_cuantos_kilos ) && !empty( $t_cuantos_kilos ) &&
                                       (($t_cuantos_kilos == "1-5") || ($t_cuantos_kilos == "6-10") ||
                                        ($t_cuantos_kilos == "11-15"))) { echo "2"; ?>
                            <!-- MTF tabla antigua -->
                            <option value="1-5" <?= ( $t_cuantos_kilos == "1-5" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_cuantos_kilos_1-5')?></option>
                            <option value="6-10" <?= ( $t_cuantos_kilos == "6-10" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_cuantos_kilos_6-10')?></option>
                            <option value="11-15" <?= ( $t_cuantos_kilos == "11-15" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_cuantos_kilos_11-15')?></option>
                            <option value=">15" <?= ( html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == ">15" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_cuantos_kilos_>15')?></option>
                            <option value="no_esta_seguro" <?= ( $t_cuantos_kilos == "no_esta_seguro" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_no_esta_seguro')?></option>

                        <?php } elseif( isset( $t_cuantos_kilos ) && !empty( $t_cuantos_kilos ) &&
                                       (($t_cuantos_kilos == "1-5.9") ||
                                        ($t_cuantos_kilos == "6-10.5") ||
                                        ($t_cuantos_kilos == "10.6-15") ||
                                        ( html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == ">15"))) { echo "3";?>
                                            <!-- MTF tabla actualizada -->
                                            <option value="1-5.9" <?= ( $t_cuantos_kilos == "1-5.9" ) ? 'selected="selected"' :  "" ?> ><?=$this->lang->line('nutricion_cuantos_kilos_1-5.9')?></option>
                                            <option value="6-10.5" <?= (  $t_cuantos_kilos == "6-10.5" ) ? 'selected="selected"' :  "" ?> ><?=$this->lang->line('nutricion_cuantos_kilos_6-10.5')?></option>
                                            <option value="10.6-15" <?= ( $t_cuantos_kilos == "10.6-15" ) ? 'selected="selected"' :  "" ?> ><?=$this->lang->line('nutricion_cuantos_kilos_10.6-15')?></option>
                                            <option value=">15" <?= ( html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8" ) == ">15" ) ? 'selected="selected"' :  "" ?> ><?=$this->lang->line('nutricion_cuantos_kilos_>15')?></option>
                                            <option value="no_esta_seguro" <?= ( $t_cuantos_kilos == "no_esta_seguro" ) ? 'selected="selected"' :  "" ?> ><?=$this->lang->line('nutricion_no_esta_seguro')?></option>
                        <?php } ?>

                    </select>
                </td>
                <td style="width: 100px; text-align: center"><span id="t_cuantos_kilos_span"></span></td>
            </tr>

            <!-- ¿Ha perdido peso y por eso no come? -->
            <tr>
                <td class="data_form"><?= $this->lang->line('nutricion_perdido_apetito_no_come') ?>:</td>
                <td align="left" style="width: 300px; " colspan="2">
                    <input type="hidden" name="t_perdido_apetito_valor" id="t_perdido_apetito_valor" value="" />
                    <select name="t_perdido_apetito" id="t_perdido_apetito" >
                        <option value="" <?=( !isset( $t_perdido_apetito ) || empty( $t_perdido_apetito ) ) ? 'selected="selected"' :  "" ?> ></option>
                        <option value="si" <?=( isset( $t_perdido_apetito ) && !empty( $t_perdido_apetito ) && $t_perdido_apetito == "si" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_si')?></option>
                        <option value="no" <?= ( isset( $t_perdido_apetito ) && !empty( $t_perdido_apetito ) && $t_perdido_apetito == "no" ) ? 'selected="selected"' :  "" ?>><?=$this->lang->line('nutricion_no')?></option>
                    </select>
                </td>
                <td style="width: 100px; text-align: center"><span id="t_perdido_apetito_span"></td>
            </tr>

            <!-- Total MTF -->
            <tr>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="width: 100px; text-align: right; background-color: #DDDDDD" ><?=$this->lang->line('nutricion_total_mtf')?>: </td>
                <td style="width: 100px; text-align: center; background-color: #DDDDDD" >
                    <input type="hidden" id="t_nutricion_total_mtf_valor" name="t_nutricion_total_mtf_valor" />
                    <span id="t_nutricion_total_mtf_span"></span>
                </td>
            </tr>

            <!-- Clasificación -->
            <tr>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="width: 100px; text-align: right; background-color: #BBBBBB" ><?=$this->lang->line('nutricion_clasificacion')?>: </td>
                <td style="width: 100px; text-align: center; background-color: #BBBBBB" >
                    <input type="hidden" id="t_nutricion_clasificacion_valor" name="t_nutricion_clasificacion_valor" />
                    <span id="t_nutricion_clasificacion_span"></span>
                </td>
            </tr>

        </tbody>
    </table>

    <?php } ?>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    if( (int)$tc['TEL_PAC_EDAD'] < 18 ) {

        $pdf->SetFont( 'Arial', 'I');
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'nutricion_no_aplica_menor_18' ) ), 0, 0, 'C' );
        $pdf->SetFont( 'Arial' );
    } else {

        // Titulos: Criterio, Respuesta, Valor
        $pdf->Cell( 90, 6, html_entity_decode( $this->lang->line( 'nutricion_criterio' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'nutricion_respuesta' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'nutricion_valor' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
        $pdf->Ln();

        /*
         * ¿ Ha perdido peso sin intentarlo ?
         */
        $valor = isset( $t_perdido_peso_sin_intentar_valor ) ? $t_perdido_peso_sin_intentar_valor : '-';

        if( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) ) {
            switch( $t_perdido_peso_sin_intentar ) {
                case 'si' : {$respuesta = $this->lang->line('nutricion_si'); $valor = $this->lang->line('nutricion_responda_siguiente_pregunta'); }; break;
                case 'no' : {$respuesta = $this->lang->line('nutricion_no'); }; break;
                case 'no_esta_seguro' : {$respuesta = $this->lang->line('nutricion_no_esta_seguro'); }; break;
                default: $respuesta = '-';
            }
        }

        $pdf->Cell( 90, 6, html_entity_decode( $this->lang->line( 'nutricion_ha_perdido_peso_sin_intentarlo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $respuesta ), 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $valor ), 0, 0, 'C' );
        $pdf->Ln();

        /*
         * Si la respuesta anterior es si ¿cuantos kilos ha perdido ?
         */
        $respuesta = "-";
        if( isset( $t_perdido_peso_sin_intentar ) && !empty( $t_perdido_peso_sin_intentar ) && $t_perdido_peso_sin_intentar == 'si' ) {

            if( isset( $t_cuantos_kilos ) && !empty( $t_cuantos_kilos ) ) {
                switch( html_entity_decode( $t_cuantos_kilos, ENT_COMPAT, "UTF-8") ) {
                    case "1-5"              : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_1-5'); }; break;
                    case "1-5.9"            : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_1-5.9'); }; break;
                    case "6-10"             : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_6-10'); }; break;
                    case "6-10.5"           : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_6-10.5'); }; break;
                    case "10.6-15"          : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_10.6-15'); }; break;
                    case "11-15"            : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_11-15'); }; break;
                    case ">15"              : {$respuesta = $this->lang->line('nutricion_cuantos_kilos_>15'); }; break;
                    case "no_esta_seguro"   : {$respuesta = $this->lang->line('nutricion_no_esta_seguro'); }; break;
                    default: $respuesta = '-';
                }
            }
            $valor = isset( $t_cuantos_kilos_valor ) ? $t_cuantos_kilos_valor : '-';

            $pdf->Cell( 90, 6, html_entity_decode( $this->lang->line( 'nutricion_cuantos_kilos_perdidos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
            $pdf->Cell( 40, 6, html_entity_decode( $respuesta ), 0, 0, 'C' );
            $pdf->Cell( 40, 6, html_entity_decode( $valor ), 0, 0, 'C' );
            $pdf->Ln();
        }

        /*
         * ¿Ha perdido el apetito y por eso no come?
         */
        if( isset( $t_perdido_apetito ) && !empty( $t_perdido_apetito ) ) {
            switch( $t_perdido_apetito ) {
                case 'si'               : {$respuesta = $this->lang->line('nutricion_si'); }; break;
                case 'no'               : {$respuesta = $this->lang->line('nutricion_no'); }; break;
                case 'no_esta_seguro'   : {$respuesta = $this->lang->line('nutricion_no_esta_seguro'); }; break;
                default: $respuesta = '-';
            }
        }
        $valor = isset( $t_perdido_apetito_valor ) ? $t_perdido_apetito_valor : '-';

        $pdf->Cell( 90, 6, html_entity_decode( $this->lang->line( 'nutricion_perdido_apetito_no_come' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $respuesta ), 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $valor ), 0, 0, 'C' );
        $pdf->Ln();

        /*
         * Total MTF
         */
        $valor = isset( $t_nutricion_total_mtf_valor ) ? $t_nutricion_total_mtf_valor : ' - ';

        $pdf->Cell( 90, 6, "", 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'nutricion_total_mtf' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ). ': ', 0, 0, 'R' );
        $pdf->Cell( 40, 6, html_entity_decode( $valor ), 0, 0, 'C' );
        $pdf->Ln();

        /*
         * Clasificación
         */
        $valor = isset( $t_nutricion_clasificacion_valor ) ? $t_nutricion_clasificacion_valor : ' - ';

        $pdf->Cell( 90, 6, "", 0, 0, 'C' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'nutricion_clasificacion' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ). ': ', 0, 0, 'R' );
        $pdf->Cell( 40, 6, html_entity_decode( $valor ), 0, 0, 'C' );
        $pdf->Ln();
    }
}
