<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Frecuencia cepillado -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_frecuencia_cepillado')?>:</td>
            <td align="left">
                <?php if( isset( $odon_frecuencia_cepillado ) ) {
                        if( !empty( $odon_frecuencia_cepillado ) )
                            echo $odon_frecuencia_cepillado . "&nbsp;".$this->lang->line('odon_frecuencia_cepillado_xdia');
                        } else
                            echo ' - ';
                ?>
            </td>
        </tr>

        <!-- Tipo de cepillo -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tipo_cepillo')?>:</td>
            <td align="left">
                <?php if( isset( $odon_tipo_cepillo ) && !empty( $odon_tipo_cepillo ) ) {
                            switch( $odon_tipo_cepillo ) {
                                case 'odon_tipo_cepillo_suave' : echo $this->lang->line('odon_suave'); break;
                                case 'odon_tipo_cepillo_media' : echo $this->lang->line('odon_media'); break;
                                case 'odon_tipo_cepillo_dura' : echo $this->lang->line('odon_dura'); break;
                                default : ' - '; break;
                            }
                        } else echo  ' - ';
                ?>
            </td>
        </tr>

        <!-- Cambio de cepillo -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_cambio_cepillo')?>:</td>
            <td align="left">
                <?php if( isset( $odon_cambio_cepillo ) && !empty( $odon_cambio_cepillo ) ) {
                            switch( $odon_cambio_cepillo ) {
                                case 'odon_cambio_cepillo_3meses' : echo $this->lang->line('odon_3_meses'); break;
                                case 'odon_cambio_cepillo_mas3meses' : echo $this->lang->line('odon_mas_3_meses'); break;
                                case 'odon_cambio_cepillo_menos3meses' : echo $this->lang->line('odon_menos_3_meses'); break;
                                default : ' - '; break;
                            }
                        } else echo  ' - ';
                ?>
            </td>
        </tr>

        <!-- Otro medio de higiene bucal -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_otra_forma_higiene')?>:</td>
            <td align="left">

                <?=( isset ( $odon_otra_forma_higiene ) && ( $odon_otra_forma_higiene == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>

                <?php if( isset( $odon_otra_forma_higiene_cual ) && !empty( $odon_otra_forma_higiene_cual ) )
                        echo "<br/><span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cual' )."?</span>: " . $odon_otra_forma_higiene_cual; ?>
                <br />
                <?php if( isset( $odon_otra_forma_higiene_cuanto_tiempo ) && !empty( $odon_otra_forma_higiene_cuanto_tiempo ) )
                        echo "<br/><span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cuanto_tiempo' )."?</span>: " . $odon_otra_forma_higiene_cuanto_tiempo; ?>
            </td>
        </tr>


        <!-- Sangramiento de encias -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sangramiento_cepillado')?>:</td>
            <td align="left">
                <?=( isset ( $odon_sangramiento_cepillado ) && ( $odon_sangramiento_cepillado == 1 ) ) ?
                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ?>
            </td>
        </tr>

    </tbody>
</table>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">
    
    $(document).ready( function( ) {

        // Activa campos cual y cuanto tiempo del item "haciendo algun tratamiento"
        $('#odon_otra_forma_higiene_si').click( function( ) {
            $('#odon_otra_forma_higiene').slideDown();
            $('#odon_otra_forma_higiene').fadeIn();
        } );

        // Desactiva campos cual y cuanto tiempo del item "haciendo algun tratamiento"
        $('#odon_otra_forma_higiene_no').click( function( ) {
            $('#odon_otra_forma_higiene').slideUp( );
            $('#odon_otra_forma_higiene').fadeOut( );
            $('#odon_otra_forma_higiene input').val( '' );
        } );

    } );
</script>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Frecuencia cepillado -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_frecuencia_cepillado')?>:</td>
            <td align="left">
                <input type="text"
                       name="odon_frecuencia_cepillado"
                       size="4"
                       maxlength="4"
                       value="<?=isset( $odon_frecuencia_cepillado ) && !empty( $odon_frecuencia_cepillado ) ? $odon_frecuencia_cepillado : '' ?>"
                />
                <?=$this->lang->line('odon_frecuencia_cepillado_xdia')?>
            </td>
        </tr>

        <!-- Tipo de cepillo -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tipo_cepillo')?>:</td>
            <td align="left">
                <input type="radio" name="odon_tipo_cepillo" id="odon_tipo_cepillo_suave"
                       value="odon_tipo_cepillo_suave" <?=(isset( $odon_tipo_cepillo ) && strcmp( 'odon_tipo_cepillo_suave', $odon_tipo_cepillo ) == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_tipo_cepillo_suave"> <?=$this->lang->line('odon_suave')?> </label>
                <br/>
                <input type="radio" name="odon_tipo_cepillo" id="odon_tipo_cepillo_media"
                       value="odon_tipo_cepillo_media" <?=(isset( $odon_tipo_cepillo ) && strcmp( 'odon_tipo_cepillo_media', $odon_tipo_cepillo ) == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_tipo_cepillo_media"> <?=$this->lang->line('odon_media')?> </label>                
                <br/>
                <input type="radio" name="odon_tipo_cepillo" id="odon_tipo_cepillo_dura"
                       value="odon_tipo_cepillo_dura" <?=(isset( $odon_tipo_cepillo ) && strcmp( 'odon_tipo_cepillo_dura', $odon_tipo_cepillo ) == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_tipo_cepillo_dura"> <?=$this->lang->line('odon_dura')?> </label>
            </td>
        </tr>

        <!-- Cambio de cepillo -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_cambio_cepillo')?>:</td>
            <td align="left">
                <input type="radio" name="odon_cambio_cepillo" id="odon_cambio_cepillo_3meses"
                       value="odon_cambio_cepillo_3meses" <?=(isset( $odon_cambio_cepillo ) && strcmp( 'odon_cambio_cepillo_3meses', $odon_cambio_cepillo ) == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_cambio_cepillo_3meses"> <?=$this->lang->line('odon_3_meses')?> </label>
                <br/>
                <input type="radio" name="odon_cambio_cepillo" id="odon_cambio_cepillo_mas3meses"
                       value="odon_cambio_cepillo_mas3meses" <?=(isset( $odon_cambio_cepillo ) && strcmp( 'odon_cambio_cepillo_mas3meses', $odon_cambio_cepillo ) == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_cambio_cepillo_mas3meses"> <?=$this->lang->line('odon_mas_3_meses')?> </label>                
                <br/>
                <input type="radio" name="odon_cambio_cepillo" id="odon_cambio_cepillo_menos3meses"
                       value="odon_cambio_cepillo_menos3meses" <?=(isset( $odon_cambio_cepillo ) && strcmp( 'odon_cambio_cepillo_menos3meses', $odon_cambio_cepillo ) == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_cambio_cepillo_menos3meses"> <?=$this->lang->line('odon_menos_3_meses')?> </label>
            </td>
        </tr>

        <!-- Otro medio de higiene bucal -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_otra_forma_higiene')?>:</td>
            <td align="left">
                <input type="radio" name="odon_otra_forma_higiene" id="odon_otra_forma_higiene_si"
                       value="1" <?=( isset( $odon_otra_forma_higiene ) && $odon_otra_forma_higiene == 1 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_otra_forma_higiene_si"> <?=$this->lang->line('odon_si')?> </label>
                &nbsp;
                <input type="radio" name="odon_otra_forma_higiene" id="odon_otra_forma_higiene_no"
                       value="0" <?=( !isset( $odon_otra_forma_higiene ) || $odon_otra_forma_higiene == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_otra_forma_higiene_no"> <?=$this->lang->line('odon_no')?> </label>                

                <div id="odon_otra_forma_higiene" <?=( isset( $odon_otra_forma_higiene ) && $odon_otra_forma_higiene == 1 ) ? '' : 'style="display: none;"'?> >
                    <?=$this->lang->line('odon_cual')?>
                    <input type="text"
                           name="odon_otra_forma_higiene_cual"
                           value="<?=( isset ( $odon_otra_forma_higiene_cual ) && !empty( $odon_otra_forma_higiene_cual ) ) ? $odon_otra_forma_higiene_cual : ''?>"
                    />
                </div>
            </td>
        </tr>

        <!-- Sangramiento de encias durante cepillado -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sangramiento_cepillado')?>:</td>
            <td align="left">
                <input type="radio" name="odon_sangramiento_cepillado" id="odon_sangramiento_cepillado_si"
                       value="1" <?=(isset( $odon_sangramiento_cepillado ) && $odon_sangramiento_cepillado == 1 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_sangramiento_cepillado_si"> <?=$this->lang->line('odon_si')?> </label>
                &nbsp;
                <input type="radio" name="odon_sangramiento_cepillado" id="odon_sangramiento_cepillado_no"
                       value="0" <?=( !isset( $odon_otra_forma_higiene ) || $odon_sangramiento_cepillado == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="odon_sangramiento_cepillado_no"> <?=$this->lang->line('odon_no')?> </label>
            </td>
        </tr>

    </tbody>
</table>

<?php } 

if( $modo == FormularioXML::$MODO_PDF ) {

    // Frecuencia cepillado
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_frecuencia_cepillado' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( ( isset( $odon_frecuencia_cepillado ) && !empty( $odon_frecuencia_cepillado ) ) ?
                                                        $odon_frecuencia_cepillado : ' - ' ) . "&nbsp;" . $this->lang->line('odon_frecuencia_cepillado_xdia') ), 0, 1, 'L' );

    // Tipo de cepillo
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_tipo_cepillo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    if( isset( $odon_tipo_cepillo ) ) {
        if( !empty( $odon_tipo_cepillo ) ) {
            switch( $odon_tipo_cepillo ) {
                case 'odon_tipo_cepillo_suave' : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_suave' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_tipo_cepillo_media' : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_media' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_tipo_cepillo_dura'  : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_dura' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                default : $pdf->Cell( 10, 6, html_entity_decode( ' - ' ), 0, 1, 'L' ); break;
            }
        }
    } else $pdf->Cell( 10, 6, html_entity_decode( ' - ' ), 0, 1, 'L' );

    // Cambio de cepillo
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_cambio_cepillo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    if( isset( $odon_cambio_cepillo ) ) {
        if( !empty( $odon_cambio_cepillo ) ) {
            switch( $odon_cambio_cepillo ) {
                case 'odon_cambio_cepillo_3meses'       : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_3_meses' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_cambio_cepillo_mas3meses'    : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_mas_3_meses' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_cambio_cepillo_menos3meses'  : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_menos_3_meses' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                default : $pdf->Cell( 10, 6, html_entity_decode( ' - ' ), 0, 1, 'L' ); break;
            }
        }
    } else $pdf->Cell( 10, 6, html_entity_decode( ' - ' ), 0, 1, 'L' );

    // Otro medio de higiene bucal
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_otra_forma_higiene' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Otro medio de higiene bucal, cual?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_otra_forma_higiene ) && ( $odon_otra_forma_higiene == 1 ) ) ?
                                                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Otro medio de higiene bucal, cual?
    if( isset( $odon_otra_forma_higiene ) && ( $odon_otra_forma_higiene == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'odon_cual' ) ).'? ', 0, 1, 'L' );
        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_otra_forma_higiene_cual ) && !empty( $odon_otra_forma_higiene_cual ) ) ?
                                                utf8_decode( $odon_otra_forma_higiene_cual ) : ' - ' ), 0, 1, 'L' );
    }

    // Sangramiento de encias
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_sangramiento_cepillado' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_sangramiento_cepillado ) && ( $odon_sangramiento_cepillado == 1 ) ) ?
                                                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

}