<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<style type="text/css">
    .plantilla_agregar {
        cursor: pointer;
        vertical-align: middle;
    }

    .examen_externo_ojos {
        padding: 0px 10px;
    }

    .examen_externo_ojos_div_izquierdo {
        float: left;
        width: 365px;
    }

    .examen_externo_ojos_div_derecho {
        float: right;
        width: 366px;
        border-left: 1px solid rgb(170, 170, 170);
        border-color: rgb(170, 170, 170);
        border-width: 1px;
    }

    .examen_externo_ojos .titulo {
        font-size: 18px;
        margin: 10px 0;
        text-align: center;
    }
</style>

<div class="examen_externo_ojos examen_externo_ojos_div_izquierdo">

    <div class="titulo"><?=$this->lang->line('oftalmologia_izquierdo')?></div>

    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?>: </span> &nbsp; <?=( isset( $examen_externo_izquierdo_parpado ) && (int)$examen_externo_izquierdo_parpado == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_parpado_observaciones ) ? nl2br( $examen_externo_izquierdo_parpado_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?>: </span> &nbsp; <?=( isset( $examen_externo_izquierdo_orbita ) && $examen_externo_izquierdo_orbita == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_orbita_observaciones ) ? nl2br( $examen_externo_izquierdo_orbita_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_conjuntiva ) || $examen_externo_izquierdo_conjuntiva == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_conjuntiva_observaciones ) ? nl2br( $examen_externo_izquierdo_conjuntiva_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_cornea ) || $examen_externo_izquierdo_cornea == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_cornea_observaciones ) ? nl2br( $examen_externo_izquierdo_cornea_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 5: Camara anterior -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_camara_anterior') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_camara_anterior ) || $examen_externo_izquierdo_camara_anterior == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_camara_anterior_observaciones ) ? nl2br( $examen_externo_izquierdo_camara_anterior_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 6: Iris -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_iris ) || $examen_externo_izquierdo_iris == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_iris_observaciones ) ? nl2br( $examen_externo_izquierdo_iris_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 7: Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_pupila') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_pupila ) || $examen_externo_izquierdo_pupila == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_pupila_observaciones ) ? nl2br( $examen_externo_izquierdo_pupila_observaciones ) : NULL; ?>
    </div>
    <br/>

</div>

<div  class="examen_externo_ojos examen_externo_ojos_div_derecho">

    <div class="titulo"><?=$this->lang->line('oftalmologia_derecho')?></div>


    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_parpado ) || $examen_externo_derecho_parpado == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_parpado_observaciones ) ? nl2br( $examen_externo_derecho_parpado_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_orbita ) || $examen_externo_derecho_orbita == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_orbita_observaciones ) ? nl2br( $examen_externo_derecho_orbita_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_conjuntiva ) || $examen_externo_derecho_conjuntiva == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_conjuntiva_observaciones ) ? nl2br( $examen_externo_derecho_conjuntiva_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_cornea ) || $examen_externo_derecho_cornea == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_cornea_observaciones ) ? nl2br( $examen_externo_derecho_cornea_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 5: Camara anterior -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_camara_anterior') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_camara_anterior ) || $examen_externo_derecho_camara_anterior == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_camara_anterior_observaciones ) ? nl2br( $examen_externo_derecho_camara_anterior_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 6: Iris -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_iris ) || $examen_externo_derecho_iris == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_iris_observaciones ) ? nl2br( $examen_externo_derecho_iris_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 7: Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_pupila') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_pupila ) || $examen_externo_derecho_pupila == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_pupila_observaciones ) ? nl2br( $examen_externo_derecho_pupila_observaciones ) : NULL; ?>
    </div>
    <br/>

</div>

<?php
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>
<style type="text/css">
    .plantilla_agregar {
        cursor: pointer;
        vertical-align: middle;
    }

    .examen_externo_ojos {
        padding: 0px 10px;
    }

    .examen_externo_ojos_div_izquierdo {
        float: left;
        width: 365px;
    }

    .examen_externo_ojos_div_derecho {
        float: right;
        width: 366px;
        border-left: 1px solid rgb(170, 170, 170);
        border-color: rgb(170, 170, 170);
        border-width: 1px;
    }

    .examen_externo_ojos .titulo {
        font-size: 18px;
        margin: 10px 0;
        text-align: center;
    }
</style>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        tc_examen_plantillas = new Array();

        // Parpado
        $('#plantilla_examen_fisico_cabeza_agregar').click( function( ) {

            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_cabeza" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_cabeza )
                    if( tc_examen_plantillas.tc_examen_fisico_cabeza[i].id == $('#plantilla_examen_fisico_cabeza').val() )
                        $('#tc_examen_fisico_cabeza').val( $('#tc_examen_fisico_cabeza').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_cabeza[i].texto );
            }
        } );

        // Selección de plantilla: Cuello
        $('#plantilla_examen_fisico_cuello_agregar').click( function( ) {

            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_cuello" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_cuello )
                    if( tc_examen_plantillas.tc_examen_fisico_cuello[i].id == $('#plantilla_examen_fisico_cuello').val() )
                        $('#tc_examen_fisico_cuello').val( $('#tc_examen_fisico_cuello').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_cuello[i].texto );
            }
        } );

        // Selección de plantilla: Tórax
        $('#plantilla_examen_fisico_torax_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_torax" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_torax )
                    if( tc_examen_plantillas.tc_examen_fisico_torax[i].id == $('#plantilla_examen_fisico_torax').val() )
                        $('#tc_examen_fisico_torax').val( $('#tc_examen_fisico_torax').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_torax[i].texto );
            }
        } );

        // Selección de plantilla: Abdomen
        $('#plantilla_examen_fisico_abdomen_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_abdomen" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_abdomen )
                    if( tc_examen_plantillas.tc_examen_fisico_abdomen[i].id == $('#plantilla_examen_fisico_abdomen').val() )
                        $('#tc_examen_fisico_abdomen').val( $('#tc_examen_fisico_abdomen').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_abdomen[i].texto );
            }
        } );

        // Selección de plantilla: Genitales
        $('#plantilla_examen_fisico_genitales_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_genitales" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_genitales )
                    if( tc_examen_plantillas.tc_examen_fisico_genitales[i].id == $('#plantilla_examen_fisico_genitales').val() )
                        $('#tc_examen_fisico_genitales').val( $('#tc_examen_fisico_genitales').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_genitales[i].texto );
            }
        } );

        // Selección de plantilla: Extremidades
        $('#plantilla_examen_fisico_extremidades_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_extremidades" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_extremidades )
                    if( tc_examen_plantillas.tc_examen_fisico_extremidades[i].id == $('#plantilla_examen_fisico_extremidades').val() )
                        $('#tc_examen_fisico_extremidades').val( $('#tc_examen_fisico_extremidades').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_extremidades[i].texto );
            }
        } );

        // Selección de plantilla: Neurologico
        $('#plantilla_examen_fisico_neurologico_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_neurologico" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_neurologico )
                    if( tc_examen_plantillas.tc_examen_fisico_neurologico[i].id == $('#plantilla_examen_fisico_neurologico').val() )
                        $('#tc_examen_fisico_neurologico').val( $('#tc_examen_fisico_neurologico').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_neurologico[i].texto );
            }
        } );

        $.getJSON(
            '<?=base_url()?>platc/plantillas_get/'+Math.random( ),
            {},
            function( data ) {

                tc_examen_plantillas = data;

                // Carga listado examen físico cabeza
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_cabeza" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_cabeza )
                        option+= "<option value="+data.tc_examen_fisico_cabeza[i].id+">"+data.tc_examen_fisico_cabeza[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_cabeza').append( option );
                }

                // Carga listado examen físico cuello
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_cuello" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_cuello )
                        option+= "<option value="+data.tc_examen_fisico_cuello[i].id+">"+data.tc_examen_fisico_cuello[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_cuello').append( option );
                }

                // Carga listado examen físico tórax
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_torax" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_torax )
                        option+= "<option value="+data.tc_examen_fisico_torax[i].id+">"+data.tc_examen_fisico_torax[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_torax').append( option );
                }

                // Carga listado examen físico abdomen
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_abdomen" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_abdomen )
                        option+= "<option value="+data.tc_examen_fisico_abdomen[i].id+">"+data.tc_examen_fisico_abdomen[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_abdomen').append( option );
                }

                // Carga listado examen físico genitales
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_genitales" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_genitales )
                        option+= "<option value="+data.tc_examen_fisico_genitales[i].id+">"+data.tc_examen_fisico_genitales[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_genitales').append( option );
                }

                // Carga listado examen físico extremidades
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_extremidades" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_extremidades )
                        option+= "<option value="+data.tc_examen_fisico_extremidades[i].id+">"+data.tc_examen_fisico_extremidades[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_extremidades').append( option );
                }

                // Carga listado examen físico neurologico
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_neurologico" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_neurologico )
                        option+= "<option value="+data.tc_examen_fisico_neurologico[i].id+">"+data.tc_examen_fisico_neurologico[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_neurologico').append( option );
                }

            }
        );
    } );

</script>

<div class="examen_externo_ojos examen_externo_ojos_div_izquierdo">

    <div class="titulo">Izquierdo</div>

    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_parpado_normal" name="examen_externo_izquierdo_parpado" value="1" <?=( !isset( $examen_externo_izquierdo_parpado ) || $examen_externo_izquierdo_parpado == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_parpado_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_parpado_anormal" name="examen_externo_izquierdo_parpado" value="2" <?=( !isset( $examen_externo_izquierdo_parpado ) || $examen_externo_izquierdo_parpado == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_parpado_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_parpado_observaciones" id="examen_externo_izquierdo_parpado_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_parpado_observaciones ) ? nl2br( $examen_externo_izquierdo_parpado_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_orbita_normal" name="examen_externo_izquierdo_orbita" value="1" <?=( !isset( $examen_externo_izquierdo_orbita ) || $examen_externo_izquierdo_orbita == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_orbita_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_orbita_anormal" name="examen_externo_izquierdo_orbita" value="2" <?=( !isset( $examen_externo_izquierdo_orbita ) || $examen_externo_izquierdo_orbita == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_orbita_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_orbita_observaciones" id="examen_externo_izquierdo_orbita_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_orbita_observaciones ) ? nl2br( $examen_externo_izquierdo_orbita_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_conjuntiva_normal" name="examen_externo_izquierdo_conjuntiva" value="1" <?=( !isset( $examen_externo_izquierdo_conjuntiva ) || $examen_externo_izquierdo_conjuntiva == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_conjuntiva_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_conjuntiva_anormal" name="examen_externo_izquierdo_conjuntiva" value="2" <?=( !isset( $examen_externo_izquierdo_conjuntiva ) || $examen_externo_izquierdo_conjuntiva == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_conjuntiva_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_conjuntiva_observaciones" id="examen_externo_izquierdo_conjuntiva_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_conjuntiva_observaciones ) ? nl2br( $examen_externo_izquierdo_conjuntiva_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_cornea_normal" name="examen_externo_izquierdo_cornea" value="1" <?=( !isset( $examen_externo_izquierdo_cornea ) || $examen_externo_izquierdo_cornea == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_cornea_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_cornea_anormal" name="examen_externo_izquierdo_cornea" value="2" <?=( !isset( $examen_externo_izquierdo_cornea ) || $examen_externo_izquierdo_cornea == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_cornea_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_cornea_observaciones" id="examen_externo_izquierdo_cornea_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_cornea_observaciones ) ? nl2br( $examen_externo_izquierdo_cornea_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 5: Camara anterior -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_camara_anterior') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_camara_anterior_normal" name="examen_externo_izquierdo_camara_anterior" value="1" <?=( !isset( $examen_externo_izquierdo_camara_anterior ) || $examen_externo_izquierdo_camara_anterior == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_camara_anterior_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_camara_anterior_anormal" name="examen_externo_izquierdo_camara_anterior" value="2" <?=( !isset( $examen_externo_izquierdo_camara_anterior ) || $examen_externo_izquierdo_camara_anterior == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_camara_anterior_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_camara_anterior_observaciones" id="examen_externo_izquierdo_camara_anterior_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_camara_anterior_observaciones ) ? nl2br( $examen_externo_izquierdo_camara_anterior_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 6: Iris -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_iris_normal" name="examen_externo_izquierdo_iris" value="1" <?=( !isset( $examen_externo_izquierdo_iris ) || $examen_externo_izquierdo_iris == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_iris_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_iris_anormal" name="examen_externo_izquierdo_iris" value="2" <?=( !isset( $examen_externo_izquierdo_iris ) || $examen_externo_izquierdo_iris == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_iris_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_iris_observaciones" id="examen_externo_izquierdo_iris_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_iris_observaciones ) ? nl2br( $examen_externo_izquierdo_iris_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 7: Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_pupila') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_pupila_normal" name="examen_externo_izquierdo_pupila" value="1" <?=( !isset( $examen_externo_izquierdo_pupila ) || $examen_externo_izquierdo_pupila == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_pupila_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_pupila_anormal" name="examen_externo_izquierdo_pupila" value="2" <?=( !isset( $examen_externo_izquierdo_pupila ) || $examen_externo_izquierdo_pupila == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_pupila_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_izquierdo_pupila_observaciones" id="examen_externo_izquierdo_pupila_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_pupila_observaciones ) ? nl2br( $examen_externo_izquierdo_pupila_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

</div>

<div  class="examen_externo_ojos examen_externo_ojos_div_derecho">

    <div class="titulo">Derecho</div>


    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_parpado_normal" name="examen_externo_derecho_parpado" value="1" <?=( !isset( $examen_externo_derecho_parpado ) || $examen_externo_derecho_parpado == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_parpado_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_parpado_anormal" name="examen_externo_derecho_parpado" value="2" <?=( !isset( $examen_externo_derecho_parpado ) || $examen_externo_derecho_parpado == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_parpado_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_parpado_observaciones" id="examen_externo_derecho_parpado_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_parpado_observaciones ) ? nl2br( $examen_externo_derecho_parpado_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_orbita_normal" name="examen_externo_derecho_orbita" value="1" <?=( !isset( $examen_externo_derecho_orbita ) || $examen_externo_derecho_orbita == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_orbita_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_orbita_anormal" name="examen_externo_derecho_orbita" value="2" <?=( !isset( $examen_externo_derecho_orbita ) || $examen_externo_derecho_orbita == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_orbita_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_orbita_observaciones" id="examen_externo_derecho_orbita_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_orbita_observaciones ) ? nl2br( $examen_externo_derecho_orbita_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_conjuntiva_normal" name="examen_externo_derecho_conjuntiva" value="1" <?=( !isset( $examen_externo_derecho_conjuntiva ) || $examen_externo_derecho_conjuntiva == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_conjuntiva_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_conjuntiva_anormal" name="examen_externo_derecho_conjuntiva" value="2" <?=( !isset( $examen_externo_derecho_conjuntiva ) || $examen_externo_derecho_conjuntiva == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_conjuntiva_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_conjuntiva_observaciones" id="examen_externo_derecho_conjuntiva_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_conjuntiva_observaciones ) ? nl2br( $examen_externo_derecho_conjuntiva_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_cornea_normal" name="examen_externo_derecho_cornea" value="1" <?=( !isset( $examen_externo_derecho_cornea ) || $examen_externo_derecho_cornea == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_cornea_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_cornea_anormal" name="examen_externo_derecho_cornea" value="2" <?=( !isset( $examen_externo_derecho_cornea ) || $examen_externo_derecho_cornea == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_cornea_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_cornea_observaciones" id="examen_externo_derecho_cornea_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_cornea_observaciones ) ? nl2br( $examen_externo_derecho_cornea_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 5: Camara anterior -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_camara_anterior') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_camara_anterior_normal" name="examen_externo_derecho_camara_anterior" value="1" <?=( !isset( $examen_externo_derecho_camara_anterior ) || $examen_externo_derecho_camara_anterior == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_camara_anterior_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_camara_anterior_anormal" name="examen_externo_derecho_camara_anterior" value="2" <?=( !isset( $examen_externo_derecho_camara_anterior ) || $examen_externo_derecho_camara_anterior == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_camara_anterior_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_camara_anterior_observaciones" id="examen_externo_derecho_camara_anterior_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_camara_anterior_observaciones ) ? nl2br( $examen_externo_derecho_camara_anterior_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 6: Iris -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_iris_normal" name="examen_externo_derecho_iris" value="1" <?=( !isset( $examen_externo_derecho_iris ) || $examen_externo_derecho_iris == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_iris_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_iris_anormal" name="examen_externo_derecho_iris" value="2" <?=( !isset( $examen_externo_derecho_iris ) || $examen_externo_derecho_iris == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_iris_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_iris_observaciones" id="examen_externo_derecho_iris_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_iris_observaciones ) ? nl2br( $examen_externo_derecho_iris_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 7: Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_pupila') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_pupila_normal" name="examen_externo_derecho_pupila" value="1" <?=( !isset( $examen_externo_derecho_pupila ) || $examen_externo_derecho_pupila == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_pupila_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_pupila_anormal" name="examen_externo_derecho_pupila" value="2" <?=( !isset( $examen_externo_derecho_pupila ) || $examen_externo_derecho_pupila == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_pupila_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <textarea name="examen_externo_derecho_pupila_observaciones" id="examen_externo_derecho_pupila_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_pupila_observaciones ) ? nl2br( $examen_externo_derecho_pupila_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

</div>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    /*
     * Ojo izquierdo
     */

    $campos = array('parpado', 'orbita', 'conjuntiva',
                    'cornea',  'camara_anterior', 'iris',
                    'pupila' );

    $x = $pdf->GetX();

    foreach( array( 'izquierdo', 'derecho' ) as $lado ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'oftalmologia_ojo_'.$lado ) ), 0, 'L', false, 0 );

        foreach( $campos as $valor ) {

            $pdf->SetFont( 'Arial', '' );
            $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'oftalmologia_'.$valor ) ).': ', 0, 0, 'R' );
            $pdf->Cell( 0, 6, ( (int)${'examen_externo_'.$lado.'_'.$valor} == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal'), 0, 1, 'L' );

            if( isset( ${'examen_externo_'.$lado.'_'.$valor.'_observaciones' } ) &&
                !empty( ${'examen_externo_'.$lado.'_'.$valor.'_observaciones' } ) ) {

                $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'oftalmologia_observaciones' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                $pdf->MultiCell( 0, 6, ${'examen_externo_'.$lado.'_'.$valor.'_observaciones'}, 0, 'L' );
            } else {

                $pdf->SetFont( 'Arial', 'I' );
                $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'oftalmologia_sin_observaciones' ) ), 0, 1, 'L' );
            }
            $pdf->Ln();
        }
    }
}

