<?php
if( $modo == FormularioXML::$MODO_LECTURA ) {

    $ap_chkbx = !isset( $ap_chkbx ) ? array() : $ap_chkbx;

    foreach( $ap_chkbx as $valor ) {

        if( isset( ${$valor} ) ) { ?>

        <span style="font-weight: bold;"><?=$this->lang->line($valor)?>:</span></br>
        <?=nl2br( ${$valor} )?><br/><br/>

<?php   }
    }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        // 1: Patológicos   (Plantilla[Proforma])
        $('#ap_chkbx_patologicos').click( function( ) { $('#ap_patologicos').toggle(); } );

        // 2: Alérgicos     (Plantilla[Proforma])
        $('#ap_chkbx_alergicos').click( function( ) { $('#ap_alergicos').toggle(); } );

        // 3: Ocupacionales (Plantilla[Proforma])
        $('#ap_chkbx_ocupacionales').click( function( ) { $('#ap_ocupacionales').toggle(); } );

        // 4: Hábitos       (Plantilla[Proforma])
        $('#ap_chkbx_habitos').click( function( ) { $('#ap_habitos').toggle(); } );

        // 5: FUM           (Plantilla[Proforma])
        $('#ap_chkbx_fum').click( function( ) { $('#ap_fum').toggle(); } );

        // 6: Familiares    (Plantilla[Proforma])
        $('#ap_chkbx_familiares').click( function( ) { $('#ap_familiares').toggle(); } );

        // 7: Quirúrgicos   (Plantilla[Proforma])
        $('#ap_chkbx_quirurgicos').click( function( ) { $('#ap_quirurgicos').toggle(); } );

        // 8: Tóxicos       (Plantilla[Proforma])
        $('#ap_chkbx_toxicos').click( function( ) { $('#ap_toxicos').toggle(); } );
    } );

</script>

<?php $ap_chkbx = !isset( $ap_chkbx ) ? array() : $ap_chkbx; ?>

<!-- 1: Patológicos -->
<input type="checkbox"
       id="ap_chkbx_patologicos"
       name="ap_chkbx[]"
       value="ap_patologicos"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_patologicos', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_patologicos" style="font-weight: bold;"><?= $this->lang->line('ap_patologicos') ?></label>
<div id="ap_patologicos" 
        <?php if( array_search( 'ap_patologicos', $ap_chkbx ) === FALSE )
            echo( "style=\"display: none;\"" );
        ?> >
    
    <textarea name="ap_patologicos" cols="80" style="width: 100%;" ><?php echo isset( $ap_patologicos ) ? $ap_patologicos : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--2: Alérgicos-->
<input type="checkbox"
       id="ap_chkbx_alergicos"
       name="ap_chkbx[]"
       value="ap_alergicos"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_alergicos', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_alergicos" style="font-weight: bold;"><?= $this->lang->line('ap_alergicos') ?></label>
<div id="ap_alergicos"
    <?php if( array_search( 'ap_alergicos', $ap_chkbx ) === FALSE )
        echo( "style=\"display: none;\"" );
    ?> >
    
    <textarea name="ap_alergicos" cols="80" style="width: 100%;" ><?php echo isset( $ap_alergicos ) ? $ap_alergicos : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--3: Ocupacionales-->
<input type="checkbox"
       id="ap_chkbx_ocupacionales"
       name="ap_chkbx[]"
       value="ap_ocupacionales"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_ocupacionales', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_ocupacionales" style="font-weight: bold;"><?= $this->lang->line('ap_ocupacionales') ?></label>
<div id="ap_ocupacionales"
    <?php if( array_search( 'ap_ocupacionales', $ap_chkbx ) === FALSE )
        echo( "style=\"display: none;\"" );
    ?> >
    
    <textarea name="ap_ocupacionales" cols="80" style="width: 100%;" ><?php echo isset( $ap_ocupacionales ) ? $ap_ocupacionales : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--4: Hábitos-->
<input type="checkbox"
       id="ap_chkbx_habitos"
       name="ap_chkbx[]"
       value="ap_habitos"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_habitos', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_habitos" style="font-weight: bold;"><?= $this->lang->line('ap_habitos') ?></label>
<div id="ap_habitos"
     <?php if( array_search( 'ap_habitos', $ap_chkbx ) === FALSE )
           echo( "style=\"display: none;\"" );
    ?> >
    
    <textarea name="ap_habitos" cols="80" style="width: 100%;" ><?php echo isset( $ap_habitos ) ? $ap_habitos : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--5: FUM-->
<input type="checkbox"
       id="ap_chkbx_fum"
       name="ap_chkbx[]"
       value="ap_fum"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_fum', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_fum" style="font-weight: bold;"><?= $this->lang->line('ap_fum') ?></label>
<div id="ap_fum"
     <?php if( array_search( 'ap_fum', $ap_chkbx ) === FALSE )
               echo( "style=\"display: none;\"" );
       ?> >
    
    <textarea name="ap_fum" cols="80" style="width: 100%;" ><?php echo isset( $ap_fum ) ? $ap_fum : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--6: Familiares-->
<input type="checkbox"
       id="ap_chkbx_familiares"
       name="ap_chkbx[]"
       value="ap_familiares"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_familiares', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_familiares" style="font-weight: bold;"><?= $this->lang->line('ap_familiares') ?></label>
<div id="ap_familiares"
    <?php if( array_search( 'ap_familiares', $ap_chkbx ) === FALSE )
           echo( "style=\"display: none;\"" );
    ?> >
    <textarea name="ap_familiares" cols="80" style="width: 100%;" ><?php echo isset( $ap_familiares ) ? $ap_familiares : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--7: Quirúrgicos-->
<input type="checkbox"
       id="ap_chkbx_quirurgicos"
       name="ap_chkbx[]"
       value="ap_quirurgicos"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_quirurgicos', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_quirurgicos" style="font-weight: bold;"><?= $this->lang->line('ap_quirurgicos') ?></label>
<div id="ap_quirurgicos"
        <?php if( array_search( 'ap_quirurgicos', $ap_chkbx ) === FALSE )
            echo( "style=\"display: none;\"" );
        ?> >
    <textarea name="ap_quirurgicos" cols="80" style="width: 100%;" ><?php echo isset( $ap_quirurgicos ) ? $ap_quirurgicos : NULL; ?></textarea>
</div>
<br/>
<br/>

<!--8: Tóxicos-->
<input type="checkbox"
       id="ap_chkbx_toxicos"
       name="ap_chkbx[]"
       value="ap_toxicos"
       class="validate[minCheckbox[1]]"
       <?php if( array_search( 'ap_toxicos', $ap_chkbx ) !== FALSE )
               echo( 'checked="checked"' );
       ?>
/>
       
<label for="ap_chkbx_toxicos" style="font-weight: bold;"><?= $this->lang->line('ap_toxicos') ?></label>
<div id="ap_toxicos"
    <?php if( array_search( 'ap_toxicos', $ap_chkbx ) === FALSE )
           echo( "style=\"display: none;\"" );
    ?> >
    <textarea name="ap_toxicos" cols="80" style="width: 100%;" ><?php echo isset( $ap_toxicos ) ? $ap_toxicos : NULL; ?></textarea>
</div>
<br/>
<br/>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $ap_chkbx = !isset( $ap_chkbx ) ? array() : $ap_chkbx;

    $x = $pdf->GetX();

    foreach( $ap_chkbx as $valor ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( $valor ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
        $pdf->SetX( $x );

        $pdf->SetFont( 'Arial' );
        $pdf->MultiCell( 0, 6, utf8_decode( ${$valor} ), 0, 'L', false, 0 );
        $pdf->Ln();
        $pdf->SetX( $x );
    }
}