<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>
    	<tr>
    		<td class="data_form" align="left" title="<?php echo $this->lang->line('neurologia_descrip1_sensibilidad') ?>"><?php echo $this->lang->line('neurologia_item1_sensibilidad') ?></td>
    		<td align="left"><?php if( isset( $rd_neuro_sensibilidad_normal ) && $rd_neuro_sensibilidad_normal == 1) echo $this->lang->line('neurologia_column1_sensibilidad'); elseif( isset( $rd_neuro_sensibilidad_normal ) && $rd_neuro_sensibilidad_normal == 2) echo $this->lang->line('neurologia_column2_sensibilidad'); else echo '&nbsp';?></td>
    	</tr>
    </tbody>
</table>

<?php if( isset( $rd_neuro_sensibilidad_normal ) && $rd_neuro_sensibilidad_normal == 2):?>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center" class="tablaOtrosSensibilidad">
    <tbody>
	    <tr>
	        <td class="data_form" rowspan="4" title="<?php echo $this->lang->line('neurologia_descrip2_sensibilidad') ?>"><?php echo $this->lang->line('neurologia_item2_sensibilidad') ?></td>
			<td><strong><?php echo $this->lang->line('neurologia_column3_sensibilidad') ?></strong></td>
	    </tr>
	    <tr>
	    	<td colspan="2"><?php echo ( isset( $tf_neuro_sensibilidad_dermatomas_hipoestesia ) && !empty( $tf_neuro_sensibilidad_dermatomas_hipoestesia ) ) ? $tf_neuro_sensibilidad_dermatomas_hipoestesia : ''?><br><br></td>
	    </tr>
	    <tr>
	    	<td colspan="2"><strong><?php echo $this->lang->line('neurologia_column4_sensibilidad') ?>:</strong></td>
	    </tr>
	    <tr>
	    	<td colspan="2"><?php echo ( isset( $tf_neuro_sensibilidad_obs_hipoestesia ) && !empty( $tf_neuro_sensibilidad_obs_hipoestesia ) ) ? $tf_neuro_sensibilidad_obs_hipoestesia : ''?><br><br></td>
	    </tr>
	    <tr>
	        <td class="data_form" rowspan="4" title="<?php echo $this->lang->line('neurologia_descrip3_sensibilidad') ?>"><?php echo $this->lang->line('neurologia_item3_sensibilidad') ?></td>
			<td><strong><?php echo $this->lang->line('neurologia_column3_sensibilidad') ?>:</strong></td>
	    </tr>
	    <tr>
	    	<td colspan="2"><?php echo ( isset( $tf_neuro_sensibilidad_dermatomas_anestesia ) && !empty( $tf_neuro_sensibilidad_dermatomas_anestesia ) ) ? $tf_neuro_sensibilidad_dermatomas_anestesia : ''?><br><br></td>
	    </tr>
	    <tr>
	    	<td colspan="2"><strong><?php echo $this->lang->line('neurologia_column4_sensibilidad') ?>:</strong></td>
	    </tr>
	    <tr>
	    	<td colspan="2"><?php echo ( isset( $tf_neuro_sensibilidad_obs_anestesia ) && !empty( $tf_neuro_sensibilidad_obs_anestesia ) ) ? $tf_neuro_sensibilidad_obs_anestesia : ''?><br><br></td>
	    </tr>
    </tbody>
</table>
<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center" class="tablaOtrosSensibilidad">
    <tbody>
	    <tr>
	    	<td colspan="6"><img style="width: 750px" src="<?php echo base_url()?>images/valoracion_sensibilidad.jpg" border="0" /></td>
	    </tr>
    </tbody>
</table>
<?php endif;?>

<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

<script>
	$(document).ready(function(){
		$("input[name='rd_neuro_sensibilidad_normal']").click(function(e){
			if( $(this).val() == 2 ) {
				$(".tablaOtrosSensibilidad").css("visibility","visible");
				$(".tablaOtrosSensibilidad").css("position","relative");
			}
			else {
				$(".tablaOtrosSensibilidad").css("visibility","hidden");
				$(".tablaOtrosSensibilidad").css("position","absolute");
			}
		});

		if( $("input[name='rd_neuro_sensibilidad_normal']:checked").val() == 2) {
			$(".tablaOtrosSensibilidad").removeAttr("style");
		}
	});
</script>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>
    	<tr>
    		<td class="data_form" align="left">&nbsp;</td>
    		<td align="left" style="width: 20%">&nbsp;</td>
    		<td align="left" style="width: 5%"><?php echo $this->lang->line('neurologia_column1_sensibilidad') ?></td>
    		<td align="left" style="width: 5%"><?php echo $this->lang->line('neurologia_column2_sensibilidad') ?></td>
    		<td align="left">&nbsp;</td>
    		<td align="left">&nbsp;</td>
    	</tr>
    	<tr>
    		<td valign="top" class="data_form" align="left"><?php echo $this->lang->line('neurologia_item1_sensibilidad') ?></td>
    		<td align="left"><?php echo $this->lang->line('neurologia_descrip1_sensibilidad') ?></td>
    		<td align="left"><input type="radio" name="rd_neuro_sensibilidad_normal" id="rd_neuro_sensibilidad_normal_si" value="1" <?php echo ( isset( $rd_neuro_sensibilidad_normal ) && !empty( $rd_neuro_sensibilidad_normal) && ($rd_neuro_sensibilidad_normal == 1) ) ? 'checked' : ''?> class="validate[required]"/></td>
    		<td align="left"><input type="radio" name="rd_neuro_sensibilidad_normal" id="rd_neuro_sensibilidad_normal_no" value="2" <?php echo ( isset( $rd_neuro_sensibilidad_normal ) && !empty( $rd_neuro_sensibilidad_normal) && ($rd_neuro_sensibilidad_normal == 2) ) ? 'checked' : ''?> class="validate[required]"/></td>
    		<td align="left">&nbsp;</td>
    		<td align="left">&nbsp;</td>
    	</tr>
    </tbody>
</table>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center" class="tablaOtrosSensibilidad" style="visibility:hidden;position:absolute;">
    <tbody>
	    <tr>
	        <td class="data_form">&nbsp;</td>
	        <td style="width: 20%">&nbsp;</td>
    		<td style="width: 5%">&nbsp;</td>
    		<td style="width: 5%">&nbsp;</td>
	        <td><?php echo $this->lang->line('neurologia_column3_sensibilidad') ?></td>
	        <td><?php echo $this->lang->line('neurologia_column4_sensibilidad') ?></td>
	    </tr>
	    <tr>
	        <td valign="top" class="data_form"><?php echo $this->lang->line('neurologia_item2_sensibilidad') ?></td>
	        <td><?php echo $this->lang->line('neurologia_descrip2_sensibilidad') ?></td>
    		<td>&nbsp;</td>
    		<td>&nbsp;</td>
	        <td><input type="text" name="tf_neuro_sensibilidad_dermatomas_hipoestesia" value="<?php echo ( isset( $tf_neuro_sensibilidad_dermatomas_hipoestesia ) && !empty( $tf_neuro_sensibilidad_dermatomas_hipoestesia ) ) ? $tf_neuro_sensibilidad_dermatomas_hipoestesia : ''?>" /></td>
	        <td><input type="text" name="tf_neuro_sensibilidad_obs_hipoestesia" value="<?php echo ( isset( $tf_neuro_sensibilidad_obs_hipoestesia ) && !empty( $tf_neuro_sensibilidad_obs_hipoestesia ) ) ? $tf_neuro_sensibilidad_obs_hipoestesia : ''?>" /></td>
	    </tr>
	    <tr>
	        <td valign="top" class="data_form"><?php echo $this->lang->line('neurologia_item3_sensibilidad') ?></td>
	        <td><?php echo $this->lang->line('neurologia_descrip3_sensibilidad') ?></td>
    		<td>&nbsp;</td>
    		<td>&nbsp;</td>
	        <td><input type="text" name="tf_neuro_sensibilidad_dermatomas_anestesia" value="<?php echo ( isset( $tf_neuro_sensibilidad_dermatomas_anestesia ) && !empty( $tf_neuro_sensibilidad_dermatomas_anestesia ) ) ? $tf_neuro_sensibilidad_dermatomas_anestesia : ''?>" /></td>
	        <td><input type="text" name="tf_neuro_sensibilidad_obs_anestesia" value="<?php echo ( isset( $tf_neuro_sensibilidad_obs_anestesia ) && !empty( $tf_neuro_sensibilidad_obs_anestesia ) ) ? $tf_neuro_sensibilidad_obs_anestesia : ''?>" /></td>
	    </tr>
    </tbody>
</table>
<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center" class="tablaOtrosSensibilidad" style="visibility:hidden;position:absolute;">
    <tbody>
	    <tr>
	    	<td colspan="6"><img style="width: 750px" src="<?php echo base_url()?>images/valoracion_sensibilidad.jpg" border="0" /></td>
	    </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $ancho1 = 50;   // Ancho primera columna
    $x2     = 60;   // Ubicación segunda columna: Si/No/-  y observación
    $limite_pagina = 200;

	//NORMAL
    $y_txt = 0; $y_obs = 0;
    if( $pdf->GetY() > $limite_pagina ) $pdf->AddPage();

    $y = $pdf->GetY();
    $pdf->MultiCell( $ancho1, 6, html_entity_decode( $this->lang->line('neurologia_item1_sensibilidad') ).': ', 0, 'R' );
    $y_txt = $pdf->GetY();

    $texto = '-';   // Valor por omisión si no hay "si" ni "no"
    if( isset( $rd_neuro_sensibilidad_normal ) && !empty( $rd_neuro_sensibilidad_normal ) )
        switch( $rd_neuro_sensibilidad_normal ) {
            case '1' : $texto = $this->lang->line('neurologia_column1_sensibilidad'); break;
            case '2' : $texto = $this->lang->line('neurologia_column2_sensibilidad'); break;
            default: $texto = '-'; break;
        }
    $pdf->SetY($y);
    $pdf->SetX($x2);
    $pdf->Cell( $ancho1, 6, html_entity_decode( $texto ), 0, 1, 'L' );

    // Establece nueva ubicación del siguiente item: en función de la altura del texto(1era columna) o de la observación
    $pdf->SetY( ( $y_txt < $y_obs ) ? $y_obs : $y_txt );

    //HIPOESTESIA
    $y_txt = 0; $y_obs = 0;
    if( $pdf->GetY() > $limite_pagina ) $pdf->AddPage();

    $y = $pdf->GetY();
    $pdf->MultiCell( $ancho1, 6, html_entity_decode( $this->lang->line('neurologia_item2_sensibilidad') ).': ', 0, 'R' );
    $y_txt = $pdf->GetY();

    $texto = '-';   // Valor por omisión si no hay "si" ni "no"
    if( isset( $tf_neuro_sensibilidad_dermatomas_hipoestesia ) && !empty( $tf_neuro_sensibilidad_dermatomas_hipoestesia ) )
		$texto = $this->lang->line('neurologia_column3_sensibilidad').': '.$tf_neuro_sensibilidad_dermatomas_hipoestesia;

    $pdf->SetY($y);
    $pdf->SetX($x2);
    $pdf->Cell( $ancho1, 6, html_entity_decode( $texto ), 0, 1, 'L' );

    if( isset( $tf_neuro_sensibilidad_obs_hipoestesia ) && !empty( $tf_neuro_sensibilidad_obs_hipoestesia ) ) {
        $pdf->SetX( $x2 );
        $pdf->MultiCell( 0, 6, utf8_decode( $tf_neuro_sensibilidad_obs_hipoestesia ), 0, 'L' );
        $y_obs = $pdf->GetY();
    }

    // Establece nueva ubicación del siguiente item: en función de la altura del texto(1era columna) o de la observación
    $pdf->SetY( ( $y_txt < $y_obs ) ? $y_obs : $y_txt );

    //ANESTESIA
    $y_txt = 0; $y_obs = 0;
    if( $pdf->GetY() > $limite_pagina ) $pdf->AddPage();

    $y = $pdf->GetY();
    $pdf->MultiCell( $ancho1, 6, html_entity_decode( $this->lang->line('neurologia_item3_sensibilidad') ).': ', 0, 'R' );
    $y_txt = $pdf->GetY();

    $texto = '-';   // Valor por omisión si no hay "si" ni "no"
    if( isset( $tf_neuro_sensibilidad_dermatomas_anestesia ) && !empty( $tf_neuro_sensibilidad_dermatomas_anestesia ) )
		$texto = $this->lang->line('neurologia_column3_sensibilidad').': '.$tf_neuro_sensibilidad_dermatomas_anestesia;

    $pdf->SetY($y);
    $pdf->SetX($x2);
    $pdf->Cell( $ancho1, 6, html_entity_decode( $texto ), 0, 1, 'L' );

    if( isset( $tf_neuro_sensibilidad_obs_anestesia ) && !empty( $tf_neuro_sensibilidad_obs_anestesia ) ) {
        $pdf->SetX( $x2 );
        $pdf->MultiCell( 0, 6, utf8_decode( $tf_neuro_sensibilidad_obs_anestesia ), 0, 'L' );
        $y_obs = $pdf->GetY();
    }

    // Establece nueva ubicación del siguiente item: en función de la altura del texto(1era columna) o de la observación
    $pdf->SetY( ( $y_txt < $y_obs ) ? $y_obs : $y_txt );
} ?>
