<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Sintomas -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sintomas')?>:</td>
            <td align="left">
                <?php
                    if( isset( $odon_sintomas ) && !empty( $odon_sintomas ) )
                        foreach( $odon_sintomas as $sintomas ) {
                            echo( '- '.$this->lang->line( $sintomas ) . "<br/>" );
                        }

                    if( isset( $odon_otros_condicion_salud ) && !empty( $odon_otros_condicion_salud ) ) { ?>
                    <br/>
                    <span style="font-weight: bold; "><?=$this->lang->line( 'odon_otros_condicion_salud' )?></span>: <br/>
                    <?= nl2br( $odon_otros_condicion_salud ) ?>
                <?php } ?>
            </td>
        </tr>

        <!-- Tipo sanguíneo -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tipo_sanguineo')?>:</td>
            <td align="left">
                <?=( isset ( $odon_tipo_sanguineo ) && !empty( $odon_tipo_sanguineo ) ) ?
                        $odon_tipo_sanguineo : ''; ?>
            </td>
        </tr>

        <!-- Tratamiento médico -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esta_en_tratamiento')?>:</td>
            <td align="left">
                <?=( isset ( $odon_esta_en_tratamiento ) && ( $odon_esta_en_tratamiento == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
                <br />
                <?php if( isset( $odon_esta_en_tratamiento_cual ) && !empty( $odon_esta_en_tratamiento_cual ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cual' )."?</span>: " . $odon_esta_en_tratamiento_cual; ?>
                <br />
                <?php if( isset( $odon_esta_en_tratamiento_cuanto_tiempo ) && !empty( $odon_esta_en_tratamiento_cuanto_tiempo ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cuanto_tiempo' )."?</span>: " . $odon_esta_en_tratamiento_cuanto_tiempo; ?>
            </td>
        </tr>

        <!-- Toma algún medicamento -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_toma_medicamento')?>:</td>
            <td align="left">
                <?=( isset ( $odon_toma_medicamento ) && ( $odon_toma_medicamento == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
                <br />
                <?php if( isset( $odon_toma_medicamento_cual ) && !empty( $odon_toma_medicamento_cual ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cual' )."?</span>: " . $odon_toma_medicamento_cual; ?>
                <br />
                <?php if( isset( $odon_toma_medicamento_cuanto_tiempo ) && !empty( $odon_toma_medicamento_cuanto_tiempo ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cuanto_tiempo' )."?</span>: " . $odon_toma_medicamento_cuanto_tiempo; ?>
            </td>
        </tr>

        <!-- Tiene alergia a algun antibiótico? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_alergico_antibiotico')?>:</td>
            <td align="left">
                <?=( isset ( $odon_alergico_antibiotico ) && ( $odon_alergico_antibiotico == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
                <br />
                <?php if( isset( $odon_alergico_antibiotico_cual ) && !empty( $odon_alergico_antibiotico_cual ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cual' )."?</span>: " . $odon_alergico_antibiotico_cual; ?>
                <br />
                <?php if( isset( $odon_alergico_antibiotico_cuanto_tiempo ) && !empty( $odon_alergico_antibiotico_cuanto_tiempo ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cuanto_tiempo' )."?</span>: " . $odon_alergico_antibiotico_cuanto_tiempo; ?>
            </td>
        </tr>

        <!-- Tiene alergia al látex o metales -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sensibilidad_latex_metal')?>:</td>
            <td align="left">
                <?=( isset ( $odon_sensibilidad_latex_metal ) && ( $odon_sensibilidad_latex_metal == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
                <br />
                <?php if( isset( $odon_sensibilidad_latex_metal_cual ) && !empty( $odon_sensibilidad_latex_metal_cual ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cual' )."?</span>: " . $odon_sensibilidad_latex_metal_cual; ?>
                <br />
                <?php if( isset( $odon_sensibilidad_latex_metal_cuanto_tiempo ) && !empty( $odon_sensibilidad_latex_metal_cuanto_tiempo ) )
                        echo "<span style=\"font-weight: bold;\">".$this->lang->line( 'odon_cuanto_tiempo' )."?</span>: " . $odon_sensibilidad_latex_metal_cuanto_tiempo; ?>
            </td>
        </tr>

        <!-- Alergia a anestecia local -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sensibilidad_anestecia_local')?>:</td>
            <td align="left">
                <?=( isset ( $odon_sensibilidad_anestecia_local ) && ( $odon_sensibilidad_anestecia_local == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
            </td>
        </tr>

        <!-- Bebe? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_bebe')?>:</td>
            <td align="left">
                <?=( isset ( $odon_bebe ) && ( $odon_bebe == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
            </td>
        </tr>

        <!-- Fuma? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_fuma')?>:</td>
            <td align="left">
                <?=( isset ( $odon_fuma ) && ( $odon_fuma == 1 ) ) ?
                        $this->lang->line('odon_si') :
                        $this->lang->line('odon_no') ?>
            </td>
        </tr>

    </tbody>
</table>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        // Activa campos cual y cuanto tiempo del item "haciendo algun tratamiento"
        $('#odon_esta_en_tratamiento_si').click( function( ) {
            $('#odon_esta_en_tratamiento').slideDown();
            $('#odon_esta_en_tratamiento').fadeIn();
        } );

        // Desactiva campos cual y cuanto tiempo del item "haciendo algun tratamiento"
        $('#odon_esta_en_tratamiento_no').click( function( ) {
            $('#odon_esta_en_tratamiento').slideUp( );
            $('#odon_esta_en_tratamiento').fadeOut( );
            $('#odon_esta_en_tratamiento input').val( '' );
        } );

        // Activa campos cual y cuanto tiempo del item "haciendo algun medicamento"
        $('#odon_toma_medicamento_si').click( function( ) {
            $('#odon_toma_medicamento').slideDown();
            $('#odon_toma_medicamento').fadeIn();
        } );

        // Desactiva campos cual y cuanto tiempo del item "haciendo algun medicamento"
        $('#odon_toma_medicamento_no').click( function( ) {
            $('#odon_toma_medicamento').slideUp( );
            $('#odon_toma_medicamento').fadeOut( );
            $('#odon_toma_medicamento input').val( '' );
        } );

        // Activa campos cual y cuanto tiempo del item "tiene alergia a algun antibiotico"
        $('#odon_alergico_antibiotico_si').click( function( ) {
            $('#odon_alergico_antibiotico').slideDown();
            $('#odon_alergico_antibiotico').fadeIn();
        } );

        // Desactiva campos cual y cuanto tiempo del item "tiene alergia a algun antibiotico"
        $('#odon_alergico_antibiotico_no').click( function( ) {
            $('#odon_alergico_antibiotico').slideUp( );
            $('#odon_alergico_antibiotico').fadeOut( );
            $('#odon_alergico_antibiotico input').val( '' );
        } );

        // Activa campos cual y cuanto tiempo del item "tiene alergia al latex o metales"
        $('#odon_sensibilidad_latex_metal_si').click( function( ) {
            $('#odon_sensibilidad_latex_metal').slideDown();
            $('#odon_sensibilidad_latex_metal').fadeIn();
        } );

        // Desactiva campos cual y cuanto tiempo del item "tiene alergia a algun antibiotico"
        $('#odon_sensibilidad_latex_metal_no').click( function( ) {
            $('#odon_sensibilidad_latex_metal').slideUp( );
            $('#odon_sensibilidad_latex_metal').fadeOut( );
            $('#odon_sensibilidad_latex_metal input').val( '' );
        } );

    } );
</script>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Sintomas -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sintomas')?></td>
            <td align="left">
                <table>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_alteraciones_presion" <?= ( isset( $odon_sintomas ) && in_array( 'odon_alteraciones_presion', $odon_sintomas ) ) ? 'checked="checked"' : '' ?> />&nbsp;<?=$this->lang->line( 'odon_alteraciones_presion' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_fiebre_reumatica" <?= ( isset( $odon_sintomas ) && in_array( 'odon_fiebre_reumatica', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_fiebre_reumatica' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_asma" <?= ( isset( $odon_sintomas ) && in_array( 'odon_asma', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_asma' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_hinchazon_piernas" <?= ( isset( $odon_sintomas ) && in_array( 'odon_hinchazon_piernas', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_hinchazon_piernas' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_bronquitis" <?= ( isset( $odon_sintomas ) && in_array( 'odon_bronquitis', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_bronquitis' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_enfermedades_cardiacas" <?= ( isset( $odon_sintomas ) && in_array( 'odon_enfermedades_cardiacas', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_enfermedades_cardiacas' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_epilepsia" <?= ( isset( $odon_sintomas ) && in_array( 'odon_epilepsia', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_epilepsia' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_enfermedades_venereas" <?= ( isset( $odon_sintomas ) && in_array( 'odon_enfermedades_venereas', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_enfermedades_venereas' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_hepatitis" <?= ( isset( $odon_sintomas ) && in_array( 'odon_hepatitis', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_hepatitis' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_diabetes" <?= ( isset( $odon_sintomas ) && in_array( 'odon_diabetes', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_diabetes' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_anemia" <?= ( isset( $odon_sintomas ) && in_array( 'odon_anemia', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_anemia' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_artritis" <?= ( isset( $odon_sintomas ) && in_array( 'odon_artritis', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_artritis' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_sinusitis" <?= ( isset( $odon_sintomas ) && in_array( 'odon_sinusitis', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_sinusitis' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_ictericia" <?= ( isset( $odon_sintomas ) && in_array( 'odon_ictericia', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_ictericia' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_osteoporosis" <?= ( isset( $odon_sintomas ) && in_array( 'odon_osteoporosis', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_osteoporosis' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_endocarditis_bacteriana" <?= ( isset( $odon_sintomas ) && in_array( 'odon_endocarditis_bacteriana', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_endocarditis_bacteriana' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_tuberculosis" <?= ( isset( $odon_sintomas ) && in_array( 'odon_tuberculosis', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_tuberculosis' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_tratamiento_psiquiatrico" <?= ( isset( $odon_sintomas ) && in_array( 'odon_tratamiento_psiquiatrico', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_tratamiento_psiquiatrico' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_desmayos_convulsiones" <?= ( isset( $odon_sintomas ) && in_array( 'odon_desmayos_convulsiones', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_desmayos_convulsiones' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_problemas_tiroides" <?= ( isset( $odon_sintomas ) && in_array( 'odon_problemas_tiroides', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_problemas_tiroides' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_ulceras_gastricas" <?= ( isset( $odon_sintomas ) && in_array( 'odon_ulceras_gastricas', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_ulceras_gastricas' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_problemas_renales" <?= ( isset( $odon_sintomas ) && in_array( 'odon_problemas_renales', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_problemas_renales' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_problemas_higado" <?= ( isset( $odon_sintomas ) && in_array( 'odon_problemas_higado', $odon_sintomas ) ) ? 'checked="checked"' : '' ?> />&nbsp;<?=$this->lang->line( 'odon_problemas_higado' )?></td>
                        <td><input type="checkbox" name="odon_sintomas[]" value="odon_portador_vih" <?= ( isset( $odon_sintomas ) && in_array( 'odon_portador_vih', $odon_sintomas ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_portador_vih' )?></td>
                    </tr>
                </table>
                <br/>
                <?=$this->lang->line('odon_otros_condicion_salud')?>:
                <br/>
                <textarea name="odon_otros_condicion_salud"  style="width: 100%;"><?=( isset( $odon_otros_condicion_salud ) ) ? $odon_otros_condicion_salud : '' ?></textarea>
            </td>
        </tr>

        <!-- Tipo sanguíneo -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tipo_sanguineo')?>:</td>
            <td align="left">
                <input type="text" name="odon_tipo_sanguineo" value="<?=isset( $odon_tipo_sanguineo ) ? $odon_tipo_sanguineo : ''?>"/>
            </td>
        </tr>

        <!-- Tratamiento médico -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esta_en_tratamiento')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_esta_en_tratamiento_si"
                       name="odon_esta_en_tratamiento"
                       value="1"
                       <?=( isset ( $odon_esta_en_tratamiento ) && ( $odon_esta_en_tratamiento == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_esta_en_tratamiento_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_esta_en_tratamiento_no"
                       name="odon_esta_en_tratamiento"
                       value="0"
                        <?=( !isset ( $odon_esta_en_tratamiento ) || ( $odon_esta_en_tratamiento == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_esta_en_tratamiento_no"><?=$this->lang->line('odon_no')?></label>

                <div id="odon_esta_en_tratamiento" <?=( isset( $odon_esta_en_tratamiento ) && $odon_esta_en_tratamiento == 1 ) ? '' : 'style="display: none;"'?> >
                    <?=$this->lang->line('odon_cual')?>
                    <input type="text"
                           name="odon_esta_en_tratamiento_cual"
                           value="<?=( isset ( $odon_esta_en_tratamiento_cual ) && !empty( $odon_esta_en_tratamiento_cual ) ) ? $odon_esta_en_tratamiento_cual : ''?>"
                    />

                    <br/>
                    <?=$this->lang->line('odon_cuanto_tiempo')?>
                    <input type="text"
                           name="odon_esta_en_tratamiento_cuanto_tiempo"
                           value="<?=( isset ( $odon_esta_en_tratamiento_cuanto_tiempo ) && !empty( $odon_esta_en_tratamiento_cuanto_tiempo ) ) ? $odon_esta_en_tratamiento_cuanto_tiempo : ''?>"
                    />
                </div>
            </td>
        </tr>

        <!-- Toma algún medicamento -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_toma_medicamento')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_toma_medicamento_si"
                       name="odon_toma_medicamento"
                       value="1"
                       <?=( isset ( $odon_toma_medicamento ) && ( $odon_toma_medicamento == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_toma_medicamento_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_toma_medicamento_no"
                       name="odon_toma_medicamento"
                       value="0"
                        <?=( !isset ( $odon_toma_medicamento ) || ( $odon_toma_medicamento == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_toma_medicamento_no"><?=$this->lang->line('odon_no')?></label>

                <div id="odon_toma_medicamento" <?=( isset( $odon_toma_medicamento ) && $odon_toma_medicamento == 1 ) ? '' : 'style="display: none;"'?> >
                    <?=$this->lang->line('odon_cual')?>
                    <input type="text"
                           name="odon_toma_medicamento_cual"
                           value="<?=( isset ( $odon_toma_medicamento_cual ) && !empty( $odon_esta_en_tratamiento_cual ) ) ? $odon_toma_medicamento_cual : ''?>"
                    />

                    <br/>
                    <?=$this->lang->line('odon_cuanto_tiempo')?>
                    <input type="text"
                           name="odon_toma_medicamento_cuanto_tiempo"
                           value="<?=( isset ( $odon_toma_medicamento_cuanto_tiempo ) && !empty( $odon_toma_medicamento_cuanto_tiempo ) ) ? $odon_toma_medicamento_cuanto_tiempo : ''?>"
                    />
                </div>
            </td>
        </tr>

        <!-- Tiene alergia a algun antibiótico? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_alergico_antibiotico')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_alergico_antibiotico_si"
                       name="odon_alergico_antibiotico"
                       value="1"
                       <?=( isset ( $odon_alergico_antibiotico ) && ( $odon_alergico_antibiotico == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_alergico_antibiotico_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_alergico_antibiotico_no"
                       name="odon_alergico_antibiotico"
                       value="0"
                        <?=( !isset ( $odon_alergico_antibiotico ) || ( $odon_alergico_antibiotico == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_alergico_antibiotico_no"><?=$this->lang->line('odon_no')?></label>

                <div id="odon_alergico_antibiotico"  <?=( isset( $odon_alergico_antibiotico ) && $odon_alergico_antibiotico == 1 ) ? '' : 'style="display: none;"'?> >
                    <?=$this->lang->line('odon_cual')?>
                    <input type="text"
                           name="odon_alergico_antibiotico_cual"
                           value="<?=( isset ( $odon_alergico_antibiotico_cual ) && !empty( $odon_alergico_antibiotico_cual ) ) ? $odon_alergico_antibiotico_cual : ''?>"
                    />

                    <br/>
                    <?=$this->lang->line('odon_cuanto_tiempo')?>
                    <input type="text"
                           name="odon_alergico_antibiotico_cuanto_tiempo"
                           value="<?=( isset ( $odon_alergico_antibiotico_cuanto_tiempo ) && !empty( $odon_alergico_antibiotico_cuanto_tiempo ) ) ? $odon_alergico_antibiotico_cuanto_tiempo : ''?>"
                    />
                </div>
            </td>
        </tr>

        <!-- Tiene alergia al látex o metales -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sensibilidad_latex_metal')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_sensibilidad_latex_metal_si"
                       name="odon_sensibilidad_latex_metal"
                       value="1"
                       <?=( isset ( $odon_sensibilidad_latex_metal ) && ( $odon_sensibilidad_latex_metal == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_sensibilidad_latex_metal_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_sensibilidad_latex_metal_no"
                       name="odon_sensibilidad_latex_metal"
                       value="0"
                        <?=( !isset ( $odon_sensibilidad_latex_metal ) || ( $odon_sensibilidad_latex_metal == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_sensibilidad_latex_metal_no"><?=$this->lang->line('odon_no')?></label>

                <div id="odon_sensibilidad_latex_metal"  <?=( isset( $odon_sensibilidad_latex_metal ) && $odon_sensibilidad_latex_metal == 1 ) ? '' : 'style="display: none;"'?>>
                    <?=$this->lang->line('odon_cual')?>
                    <input type="text"
                           name="odon_sensibilidad_latex_metal_cual"
                           value="<?=( isset ( $odon_sensibilidad_latex_metal_cual ) && !empty( $odon_sensibilidad_latex_metal_cual ) ) ? $odon_sensibilidad_latex_metal_cual : ''?>"
                    />

                    <br/>
                    <?=$this->lang->line('odon_cuanto_tiempo')?>
                    <input type="text"
                           name="odon_sensibilidad_latex_metal_cuanto_tiempo"
                           value="<?=( isset ( $odon_sensibilidad_latex_metal_cuanto_tiempo ) && !empty( $odon_sensibilidad_latex_metal_cuanto_tiempo ) ) ? $odon_sensibilidad_latex_metal_cuanto_tiempo : ''?>"
                    />
                </div>
            </td>
        </tr>

        <!-- Alergia a anestecia local -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_sensibilidad_anestecia_local')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_sensibilidad_anestecia_local_si"
                       name="odon_sensibilidad_anestecia_local"
                       value="1"
                       <?=( isset ( $odon_sensibilidad_anestecia_local ) && ( $odon_sensibilidad_anestecia_local == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_sensibilidad_anestecia_local_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_sensibilidad_anestecia_local_no"
                       name="odon_sensibilidad_anestecia_local"
                       value="0"
                        <?=( !isset ( $odon_sensibilidad_anestecia_local ) || ( $odon_sensibilidad_anestecia_local == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_sensibilidad_anestecia_local_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Bebe? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_bebe')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_bebe_si"
                       name="odon_bebe"
                       value="1"
                       <?=( isset ( $odon_bebe ) && ( $odon_bebe == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_bebe_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_bebe_no"
                       name="odon_bebe"
                       value="0"
                        <?=( !isset ( $odon_bebe ) || ( $odon_bebe == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_bebe_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Fuma? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_fuma')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_fuma_si"
                       name="odon_fuma"
                       value="1"
                       <?=( isset ( $odon_fuma ) && ( $odon_fuma == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_fuma_si"><?=$this->lang->line('odon_si')?></label>

                <input type="radio"
                       id="odon_fuma_no"
                       name="odon_fuma"
                       value="0"
                        <?=( !isset ( $odon_fuma ) || ( $odon_fuma == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_fuma_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Sintomas
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_siente_dolor' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar los sintomas

    if( isset( $odon_sintomas ) && !empty( $odon_sintomas ) ) {
        foreach( $odon_sintomas as $sintomas ) {
            $pdf->SetX( $x );
            $pdf->Cell( 0, 6, html_entity_decode( '- '.$this->lang->line( $sintomas ) ), 0, 1, 'L' );
        }
    } else $pdf->Ln();

    // Otros condicion de salud
    if( ( isset( $odon_siente_dolor ) && ( $odon_siente_dolor == 1 ) ) ) {

        $pdf->Ln();
        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_otros_condicion_salud' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $odon_otros_condicion_salud ) && !empty( $odon_otros_condicion_salud ) ) ?
                                                    utf8_decode( $odon_otros_condicion_salud ) : $this->lang->line( 'odon_sin_sintomas' ) ) , 0, 'L' );
    }

    // Tipo sanguíneo
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_tipo_sanguineo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_tipo_sanguineo ) && !empty( $odon_tipo_sanguineo ) ) ?
                                            utf8_decode( $odon_tipo_sanguineo ) : ' - ' ), 0, 1, 'L' );

    // Tratamiento médico
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_esta_en_tratamiento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tratamiento médico, cual y cuanto tiempo"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_esta_en_tratamiento ) && ( $odon_esta_en_tratamiento == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Tratamiento médico, cual y cuanto tiempo
    if( isset( $odon_esta_en_tratamiento ) && ( $odon_esta_en_tratamiento == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cual' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_esta_en_tratamiento_cual ) && !empty( $odon_esta_en_tratamiento_cual ) ) ?
                                               utf8_decode( $odon_esta_en_tratamiento_cual ) : ' - ' ), 0, 1, 'L' );

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cuanto_tiempo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_esta_en_tratamiento_cuanto_tiempo ) && !empty( $odon_esta_en_tratamiento_cuanto_tiempo ) ) ?
                                               utf8_decode( $odon_esta_en_tratamiento_cuanto_tiempo ) : ' - ' ), 0, 1, 'L' );
    }

    // Toma algún medicamento
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_toma_medicamento' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tiene intención de cambiarlas?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_toma_medicamento ) && ( $odon_toma_medicamento == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );
    // Toma algún medicamento, cual y cuanto tiempo
    if( isset( $odon_toma_medicamento ) && ( $odon_toma_medicamento == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cual' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_toma_medicamento_cual ) && !empty( $odon_toma_medicamento_cual ) ) ?
                                               utf8_decode( $odon_toma_medicamento_cual ) : ' - ' ), 0, 1, 'L' );

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cuanto_tiempo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_toma_medicamento_cuanto_tiempo ) && !empty( $odon_toma_medicamento_cuanto_tiempo ) ) ?
                                               utf8_decode( $odon_toma_medicamento_cuanto_tiempo ) : ' - ' ), 0, 1, 'L' );
    }

    // Tiene alergia a algun antibiótico?
    $y = $pdf->GetY();
    $pdf->MultiCell( 60, 6, html_entity_decode( $this->lang->line( 'odon_alergico_antibiotico' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 'R' );
//    $y2 = $pdf->GetY();
    $pdf->SetY( $y );
    $pdf->SetX( 70 );
    $x = $pdf->GetX(); // para posicionar "Tiene alergia a algun antibiótico? cual y cuanto tiempo"
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_alergico_antibiotico ) && ( $odon_alergico_antibiotico == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Tiene alergia a algun antibiótico?, cual y cuanto tiempo
    if( isset( $odon_alergico_antibiotico ) && ( $odon_alergico_antibiotico == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cual' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_alergico_antibiotico_cual ) && !empty( $odon_alergico_antibiotico_cual ) ) ?
                                               utf8_decode( $odon_alergico_antibiotico_cual ) : ' - ' ), 0, 1, 'L' );

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cuanto_tiempo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_alergico_antibiotico_cuanto_tiempo ) && !empty( $odon_alergico_antibiotico_cuanto_tiempo ) ) ?
                                               utf8_decode( $odon_alergico_antibiotico_cuanto_tiempo ) : ' - ' ), 0, 1, 'L' );
    }
//    $pdf->SetY( $y2 );

    // Tiene alergia al látex o metales
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_sensibilidad_latex_metal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tiene alergia a algun antibiótico?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_sensibilidad_latex_metal ) && ( $odon_sensibilidad_latex_metal == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Tiene alergia al látex o metales, cual y cuanto tiempo
    if( isset( $odon_sensibilidad_latex_metal ) && ( $odon_sensibilidad_latex_metal == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cual' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_sensibilidad_latex_metal_cual ) && !empty( $odon_sensibilidad_latex_metal_cual ) ) ?
                                               utf8_decode( $odon_sensibilidad_latex_metal_cual ) : ' - ' ), 0, 1, 'L' );

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cuanto_tiempo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_sensibilidad_latex_metal_cuanto_tiempo ) && !empty( $odon_sensibilidad_latex_metal_cuanto_tiempo ) ) ?
                                               utf8_decode( $odon_sensibilidad_latex_metal_cuanto_tiempo ) : ' - ' ), 0, 1, 'L' );
    }

    // Alergia a anestecia local
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_sensibilidad_anestecia_local' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tiene alergia a algun antibiótico?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_sensibilidad_anestecia_local ) && ( $odon_sensibilidad_anestecia_local == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Bebe?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_bebe' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tiene alergia a algun antibiótico?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_bebe ) && ( $odon_bebe == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Fuma?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_fuma' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tiene alergia a algun antibiótico?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_fuma ) && ( $odon_fuma == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );
}
