<?php
if( $modo == FormularioXML::$MODO_LECTURA ) {

    $intervalo = "";
    $anos  = ( isset( $pediatria_edad_anos ) && !empty( $pediatria_edad_anos ) ) ? $pediatria_edad_anos : '-';
    $meses = ( isset( $pediatria_edad_meses ) && !empty( $pediatria_edad_meses ) ) ? $pediatria_edad_meses : '-';
    $meses = $meses + $anos * 12;

    if( $meses < 2 ) { ?>

        <!-- Recien nacido -->
        <table id="recien_nacido" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_recien_nacido')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_turberculosis_bcg')?><br/>(<?=$this->lang->line('pediatria_vacuna_unica')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_turberculosis_bcg) && !empty( $pediatria_turberculosis_bcg ) ) ? nl2br( $pediatria_turberculosis_bcg ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_hepatitis_b')?><br/>(<?=$this->lang->line('pediatria_vacuna_unica')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_hepatitis_b) && !empty( $pediatria_hepatitis_b ) ) ? nl2br( $pediatria_hepatitis_b ) : '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 2 && $meses < 4 ) { ?>

        <!-- 2 meses -->
        <table id="2_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_dos_meses')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_polio_oral_im_primera) && !empty( $pediatria_polio_oral_im_primera ) ) ? nl2br( $pediatria_polio_oral_im_primera ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_pentavalente')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_pentavalente_primera) && !empty( $pediatria_pentavalente_primera ) ) ? nl2br( $pediatria_pentavalente_primera ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_rotavirus')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_rotavirus_primera) && !empty( $pediatria_rotavirus_primera ) ) ? nl2br( $pediatria_rotavirus_primera ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_neumococo')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_neumococo_primera) && !empty( $pediatria_neumococo_primera ) ) ? nl2br( $pediatria_neumococo_primera ) : '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 4 && $meses < 6 ) { ?>

        <!-- 4 meses -->
        <table id="4_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_cuatro_meses')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_polio_oral_im_segunda) && !empty( $pediatria_polio_oral_im_segunda ) ) ? nl2br( $pediatria_polio_oral_im_segunda ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_pentavalente')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_pentavalente_segunda) && !empty( $pediatria_pentavalente_segunda ) ) ? nl2br( $pediatria_pentavalente_segunda ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_rotavirus')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_rotavirus_segunda) && !empty( $pediatria_rotavirus_segunda ) ) ? nl2br( $pediatria_rotavirus_segunda ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_neumococo')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_neumococo_segunda) && !empty( $pediatria_neumococo_segunda ) ) ? nl2br( $pediatria_neumococo_segunda ) : '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 6 && $meses < 7 ) { ?>
        <!-- 6 meses -->
        <table id="6_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_seis_meses')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_tercera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_polio_oral_im_tercera) && !empty( $pediatria_polio_oral_im_tercera ) ) ? nl2br( $pediatria_polio_oral_im_tercera ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_pentavalente')?><br/>(<?=$this->lang->line('pediatria_vacuna_tercera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_pentavalente_tercera) && !empty( $pediatria_pentavalente_tercera ) ) ? nl2br( $pediatria_pentavalente_tercera ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_influeza')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_influeza_primera) && !empty( $pediatria_influeza_primera ) ) ? nl2br( $pediatria_influeza_primera ) : '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 7 && $meses < 12 ) { ?>

        <!-- 7 meses -->
        <table id="7_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_siete_meses')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_influeza')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_influeza_segunda) && !empty( $pediatria_influeza_segunda ) ) ? nl2br( $pediatria_influeza_segunda ) : '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 12 && $meses < 18 ) { ?>

        <!-- 12 meses -->
        <table id="12_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_doce_meses')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_sarampion_rubeola_paperas')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_sarampion_rubeola_paperas) && !empty( $pediatria_sarampion_rubeola_paperas ) ) ? nl2br( $pediatria_sarampion_rubeola_paperas ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_fiebre_amarilla')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_fiebre_amarilla) && !empty( $pediatria_fiebre_amarilla ) ) ? nl2br( $pediatria_fiebre_amarilla ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_neumococo')?><br/>(<?=$this->lang->line('pediatria_vacuna_refuerzo')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_neumococo_refuerzo) && !empty( $pediatria_neumococo_refuerzo ) ) ? nl2br( $pediatria_neumococo_refuerzo ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_influeza')?><br/>(<?=$this->lang->line('pediatria_vacuna_anual')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_influeza_anual) && !empty( $pediatria_influeza_anual ) ) ? nl2br( $pediatria_influeza_anual ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_hepatitis_a')?><br/>(<?=$this->lang->line('pediatria_vacuna_unica')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_hepatitis_a) && !empty( $pediatria_hepatitis_a ) )? nl2br( $pediatria_hepatitis_a ): '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 18 && $meses < 60 ) { // 60 meses: 5 años ?>

        <!-- 18 meses -->
        <table id="18_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_dieciocho_meses')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_difteria_tosferina_tetano')?><br/>(<?=$this->lang->line('pediatria_vacuna_1_refuerzo')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_difteria_tosferina_tetano_1_refuerzo) && !empty( $pediatria_difteria_tosferina_tetano_1_refuerzo ) )? nl2br( $pediatria_difteria_tosferina_tetano_1_refuerzo ): '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_1_refuerzo')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_polio_im_1_refuerzo) && !empty( $pediatria_polio_im_1_refuerzo ) )? nl2br( $pediatria_polio_im_1_refuerzo ): '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php }

    if( $meses >= 60 & $meses < 72 ) { ?>

        <!-- 5 años -->
        <table id="5_anos" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_cinco_anos')?></td>
                </tr>

                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_2_refuerzo')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_polio_im_2_refuerzo) && !empty( $pediatria_polio_im_2_refuerzo ) )? nl2br( $pediatria_polio_im_2_refuerzo ) : '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_difteria_tosferina_tetano')?><br/>(<?=$this->lang->line('pediatria_vacuna_2_refuerzo')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_difteria_tosferina_tetano_2_refuerzo) && !empty( $pediatria_difteria_tosferina_tetano_2_refuerzo ) )? nl2br( $pediatria_difteria_tosferina_tetano_2_refuerzo ): '' ?>
                    </td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('pediatria_sarampion_rubeola_paperas')?><br/>(<?=$this->lang->line('pediatria_vacuna_refuerzo')?>):</td>
                    <td align="left">
                        <?=(isset($pediatria_sarampion_rubeola_paperas_refuerzo) && !empty( $pediatria_sarampion_rubeola_paperas_refuerzo ) )? nl2br( $pediatria_sarampion_rubeola_paperas_refuerzo ) : '' ?>
                    </td>
                </tr>

            </tbody>
        </table>
    <?php } 

    if( $meses >= 72 ){ ?>

        <!-- No aplica -->
        <table id="esquema_no_aplica" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
            <tbody>

                <tr>
                    <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('no_aplica')?></td>
                </tr>

            </tbody>
        </table>
<?php } ?>

<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">
    
    $(document).ready( function( ) {

        // Establece todos los campos de texto de las tablas como desactivadas,
        // con esto se evita que se envíe la información al sistema
        // Solo se activa los que por la edad deben estar activos.
        $('#pediatria_tablas_esquema_vacunacion textarea').attr( 'disabled', 'disabled' );

        anos  = $('#edad').val();
        meses = $('#edad_meses').val();
        meses = parseInt(anos)*12 + parseInt( meses );

        if( meses < 2 ) {
            $('#recien_nacido').show();
            $('#recien_nacido textarea').removeAttr( 'disabled' );
        }

        if( meses >= 2 && meses < 4 ) {
            $('#2_meses').show();
            $('#2_meses textarea').removeAttr( 'disabled' );
        }

        if( meses >= 4 && meses < 6 ) {
            $('#4_meses').show();
            $('#4_meses textarea').removeAttr( 'disabled' );
        }

        if( meses >= 6 && meses < 7 ) {
            $('#6_meses').show();
            $('#6_meses textarea').removeAttr( 'disabled' );
        }

        if( meses >= 7 && meses < 12 ) {
            $('#7_meses').show();
            $('#7_meses textarea').removeAttr( 'disabled' );
        }

        if( meses >= 12 && meses < 18 ) {
            $('#12_meses').show();
            $('#12_meses textarea').removeAttr( 'disabled' );
        }

        if( meses >= 18 && meses < 60 ) {   // 60 meses: 5 años
            $('#18_meses').show();
            $('#18_meses textarea').removeAttr( 'disabled' );
        }

        if( meses >= 60 & meses < 72 ) {
            $('#5_anos').show();
            $('#5_anos textarea').removeAttr( 'disabled' );
        }

        if( meses >= 72 ) {
            $('#esquema_no_aplica').show();
        }
    } );
</script>

<div id="pediatria_tablas_esquema_vacunacion">

    <!-- Recien nacido -->
    <table id="recien_nacido" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_recien_nacido')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_turberculosis_bcg')?><br/>(<?=$this->lang->line('pediatria_vacuna_unica')?>):</td>
                <td align="left">
                    <textarea name="pediatria_turberculosis_bcg" style="width: 100%" ><?=(isset($pediatria_turberculosis_bcg) && !empty( $pediatria_turberculosis_bcg ) )? $pediatria_turberculosis_bcg : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_hepatitis_b')?><br/>(<?=$this->lang->line('pediatria_vacuna_unica')?>):</td>
                <td align="left">
                    <textarea name="pediatria_hepatitis_b" style="width: 100%" ><?=(isset($pediatria_hepatitis_b) && !empty( $pediatria_hepatitis_b ) )? $pediatria_hepatitis_b : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- 2 meses -->
    <table id="2_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_dos_meses')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_polio_oral_im_primera" style="width: 100%" ><?=(isset($pediatria_polio_oral_im_primera) && !empty( $pediatria_polio_oral_im_primera ) )? $pediatria_polio_oral_im_primera : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_pentavalente')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_pentavalente_primera" style="width: 100%" ><?=(isset($pediatria_pentavalente_primera) && !empty( $pediatria_pentavalente_primera ) )? $pediatria_pentavalente_primera : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_rotavirus')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_rotavirus_primera" style="width: 100%" ><?=(isset($pediatria_rotavirus_primera) && !empty( $pediatria_rotavirus_primera ) )? $pediatria_rotavirus_primera : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_neumococo')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_neumococo_primera" style="width: 100%" ><?=(isset($pediatria_neumococo_primera) && !empty( $pediatria_neumococo_primera ) )? $pediatria_neumococo_primera : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- 4 meses -->
    <table id="4_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_cuatro_meses')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                <td align="left">
                    <textarea name="pediatria_polio_oral_im_segunda" style="width: 100%" ><?=(isset($pediatria_polio_oral_im_segunda) && !empty( $pediatria_polio_oral_im_segunda ) )? $pediatria_polio_oral_im_segunda : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_pentavalente')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                <td align="left">
                    <textarea name="pediatria_pentavalente_segunda" style="width: 100%" ><?=(isset($pediatria_pentavalente_segunda) && !empty( $pediatria_pentavalente_segunda ) )? $pediatria_pentavalente_segunda : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_rotavirus')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                <td align="left">
                    <textarea name="pediatria_rotavirus_segunda" style="width: 100%" ><?=(isset($pediatria_rotavirus_segunda) && !empty( $pediatria_rotavirus_segunda ) )? $pediatria_rotavirus_segunda : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_neumococo')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                <td align="left">
                    <textarea name="pediatria_neumococo_segunda" style="width: 100%" ><?=(isset($pediatria_neumococo_segunda) && !empty( $pediatria_neumococo_segunda ) )? $pediatria_neumococo_segunda : '' ?></textarea>
                </td>
            </tr>


        </tbody>
    </table>

    <!-- 6 meses -->
    <table id="6_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_seis_meses')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_tercera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_polio_oral_im_tercera" style="width: 100%" ><?=(isset($pediatria_polio_oral_im_tercera) && !empty( $pediatria_polio_oral_im_tercera ) )? $pediatria_polio_oral_im_tercera : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_pentavalente')?><br/>(<?=$this->lang->line('pediatria_vacuna_tercera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_pentavalente_tercera" style="width: 100%" ><?=(isset($pediatria_pentavalente_tercera) && !empty( $pediatria_pentavalente_tercera ) )? $pediatria_pentavalente_tercera : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_influeza')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_influeza_primera" style="width: 100%" ><?=(isset($pediatria_influeza_primera) && !empty( $pediatria_influeza_primera ) )? $pediatria_influeza_primera : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- 7 meses -->
    <table id="7_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_siete_meses')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_influeza')?><br/>(<?=$this->lang->line('pediatria_vacuna_segunda')?>):</td>
                <td align="left">
                    <textarea name="pediatria_influeza_segunda" style="width: 100%" ><?=(isset($pediatria_influeza_segunda) && !empty( $pediatria_influeza_segunda ) )? $pediatria_influeza_segunda : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- 12 meses -->
    <table id="12_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_doce_meses')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_sarampion_rubeola_paperas')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_sarampion_rubeola_paperas" style="width: 100%" ><?=(isset($pediatria_sarampion_rubeola_paperas) && !empty( $pediatria_sarampion_rubeola_paperas ) )? $pediatria_sarampion_rubeola_paperas : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_fiebre_amarilla')?><br/>(<?=$this->lang->line('pediatria_vacuna_primera')?>):</td>
                <td align="left">
                    <textarea name="pediatria_fiebre_amarilla" style="width: 100%" ><?=(isset($pediatria_fiebre_amarilla) && !empty( $pediatria_fiebre_amarilla ) )? $pediatria_fiebre_amarilla : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_neumococo')?><br/>(<?=$this->lang->line('pediatria_vacuna_refuerzo')?>):</td>
                <td align="left">
                    <textarea name="pediatria_neumococo_refuerzo" style="width: 100%" ><?=(isset($pediatria_neumococo_refuerzo) && !empty( $pediatria_neumococo_refuerzo ) )? $pediatria_neumococo_refuerzo : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_influeza')?><br/>(<?=$this->lang->line('pediatria_vacuna_anual')?>):</td>
                <td align="left">
                    <textarea name="pediatria_influeza_anual" style="width: 100%" ><?=(isset($pediatria_influeza_anual) && !empty( $pediatria_influeza_anual ) )? $pediatria_influeza_anual : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_hepatitis_a')?><br/>(<?=$this->lang->line('pediatria_vacuna_unica')?>):</td>
                <td align="left">
                    <textarea name="pediatria_hepatitis_a" style="width: 100%" ><?=(isset($pediatria_hepatitis_a) && !empty( $pediatria_hepatitis_a ) )? $pediatria_hepatitis_a : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- 18 meses -->
    <table id="18_meses" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_dieciocho_meses')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_difteria_tosferina_tetano')?><br/>(<?=$this->lang->line('pediatria_vacuna_1_refuerzo')?>):</td>
                <td align="left">
                    <textarea name="pediatria_difteria_tosferina_tetano_1_refuerzo" style="width: 100%" ><?=(isset($pediatria_difteria_tosferina_tetano_1_refuerzo) && !empty( $pediatria_difteria_tosferina_tetano_1_refuerzo ) )? $pediatria_difteria_tosferina_tetano_1_refuerzo : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_1_refuerzo')?>):</td>
                <td align="left">
                    <textarea name="pediatria_polio_im_1_refuerzo" style="width: 100%" ><?=(isset($pediatria_polio_im_1_refuerzo) && !empty( $pediatria_polio_im_1_refuerzo ) )? $pediatria_polio_im_1_refuerzo : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- 5 años -->
    <table id="5_anos" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('pediatria_vacunas_cinco_anos')?></td>
            </tr>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_polio_oral_im')?><br/>(<?=$this->lang->line('pediatria_vacuna_2_refuerzo')?>):</td>
                <td align="left">
                    <textarea name="pediatria_polio_im_2_refuerzo" style="width: 100%" ><?=(isset($pediatria_polio_im_2_refuerzo) && !empty( $pediatria_polio_im_2_refuerzo ) )? $pediatria_polio_im_2_refuerzo : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_difteria_tosferina_tetano')?><br/>(<?=$this->lang->line('pediatria_vacuna_2_refuerzo')?>):</td>
                <td align="left">
                    <textarea name="pediatria_difteria_tosferina_tetano_2_refuerzo" style="width: 100%" ><?=(isset($pediatria_difteria_tosferina_tetano_2_refuerzo) && !empty( $pediatria_difteria_tosferina_tetano_2_refuerzo ) )? $pediatria_difteria_tosferina_tetano_2_refuerzo : '' ?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_sarampion_rubeola_paperas')?><br/>(<?=$this->lang->line('pediatria_vacuna_refuerzo')?>):</td>
                <td align="left">
                    <textarea name="pediatria_sarampion_rubeola_paperas_refuerzo" style="width: 100%" ><?=(isset($pediatria_sarampion_rubeola_paperas_refuerzo) && !empty( $pediatria_sarampion_rubeola_paperas_refuerzo ) )? $pediatria_sarampion_rubeola_paperas_refuerzo : '' ?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- No aplica -->
    <table id="esquema_no_aplica" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center" style="font-weight: bold"><?=$this->lang->line('no_aplica')?></td>
            </tr>

        </tbody>
    </table>

</div>

<?php }

if( $modo == FormularioXML::$MODO_PDF )  {

    $intervalo = "";
    $anos  = ( isset( $pediatria_edad_anos ) && !empty( $pediatria_edad_anos ) ) ? $pediatria_edad_anos : '0';
    $meses = ( isset( $pediatria_edad_meses ) && !empty( $pediatria_edad_meses ) ) ? $pediatria_edad_meses : '0';
    $dias  = ( isset( $pediatria_edad_dias ) && !empty( $pediatria_edad_dias ) ) ? $pediatria_edad_dias : '0';
    $meses = $meses + $anos * 12;

    // 
    if( $meses < 2 ) {

        // Recien nacido
        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_recien_nacido' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_turberculosis_bcg').": (".$this->lang->line('pediatria_vacuna_unica') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_turberculosis_bcg ) && !empty( $pediatria_turberculosis_bcg ) ) ? utf8_decode( $pediatria_turberculosis_bcg ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_hepatitis_b').": (".$this->lang->line('pediatria_vacuna_unica') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_hepatitis_b ) && !empty( $pediatria_hepatitis_b ) ) ? utf8_decode( $pediatria_hepatitis_b ) : '' ) ), 0, 'L' );
    }

    // 2 meses
    if( $meses >= 2 && $meses < 4 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_dos_meses' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_polio_oral_im').": (".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_polio_oral_im_primera ) && !empty( $pediatria_polio_oral_im_primera ) ) ? utf8_decode( $pediatria_polio_oral_im_primera ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_pentavalente').": (".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_pentavalente_primera ) && !empty( $pediatria_pentavalente_primera ) ) ? utf8_decode( $pediatria_pentavalente_primera ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_rotavirus').": (".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_rotavirus_primera ) && !empty( $pediatria_rotavirus_primera ) ) ? utf8_decode( $pediatria_rotavirus_primera ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_neumococo').": (".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_neumococo_primera ) && !empty( $pediatria_neumococo_primera ) ) ? utf8_decode( $pediatria_neumococo_primera ) : '' ) ), 0, 'L' );
    }

    // 4 meses
    if( $meses >= 4 && $meses < 6 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_cuatro_meses' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_polio_oral_im').": (".$this->lang->line('pediatria_vacuna_segunda') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_polio_oral_im_segunda ) && !empty( $pediatria_polio_oral_im_segunda ) ) ? utf8_decode( $pediatria_polio_oral_im_segunda ) : '' ) ), 0, 'L' );

        $pdf->Ln();
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_pentavalente').": (".$this->lang->line('pediatria_vacuna_segunda') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_pentavalente_segunda ) && !empty( $pediatria_pentavalente_segunda ) ) ? utf8_decode( $pediatria_pentavalente_segunda ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_rotavirus').": (".$this->lang->line('pediatria_vacuna_segunda') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_rotavirus_segunda ) && !empty( $pediatria_rotavirus_segunda ) ) ? utf8_decode( $pediatria_rotavirus_segunda ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_neumococo').": (".$this->lang->line('pediatria_vacuna_segunda') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_neumococo_segunda ) && !empty( $pediatria_neumococo_segunda ) ) ? utf8_decode( $pediatria_neumococo_segunda ) : '' ) ), 0, 'L' );
    }

    // 6 meses
    if( $meses >= 6 && $meses < 7 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_seis_meses' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_polio_oral_im').": (".$this->lang->line('pediatria_vacuna_tercera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_polio_oral_im_tercera ) && !empty( $pediatria_polio_oral_im_tercera ) ) ? utf8_decode( $pediatria_polio_oral_im_tercera ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_pentavalente').": \n(".$this->lang->line('pediatria_vacuna_tercera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_pentavalente_tercera ) && !empty( $pediatria_pentavalente_tercera ) ) ? utf8_decode( $pediatria_pentavalente_tercera ) : '' ) ), 0, 'L', false, 0 );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_influeza').": \n(".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_influeza_primera ) && !empty( $pediatria_influeza_primera ) ) ? utf8_decode( $pediatria_influeza_primera ) : '' ) ), 0, 'L', false, 0 );
    }

    // 7 meses
    if( $meses >= 7 && $meses < 12 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_siete_meses' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_influeza').": (".$this->lang->line('pediatria_vacuna_segunda') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_influeza_segunda ) && !empty( $pediatria_influeza_segunda ) ) ? utf8_decode( $pediatria_influeza_segunda ) : '' ) ), 0, 'L' );
    }

    // 12 meses
    if( $meses >= 12 && $meses < 18 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_doce_meses' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_sarampion_rubeola_paperas').": (".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_sarampion_rubeola_paperas ) && !empty( $pediatria_sarampion_rubeola_paperas ) ) ? utf8_decode( $pediatria_sarampion_rubeola_paperas ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_fiebre_amarilla').": (".$this->lang->line('pediatria_vacuna_primera') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_fiebre_amarilla ) && !empty( $pediatria_fiebre_amarilla ) ) ? utf8_decode( $pediatria_fiebre_amarilla ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_neumococo').": (".$this->lang->line('pediatria_vacuna_refuerzo') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_neumococo_refuerzo ) && !empty( $pediatria_neumococo_refuerzo ) ) ? utf8_decode( $pediatria_neumococo_refuerzo ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 70, 6, html_entity_decode( ( $this->lang->line('pediatria_influeza').": (".$this->lang->line('pediatria_vacuna_anual') ).')'  ), 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_influeza_anual ) && !empty( $pediatria_influeza_anual ) ) ? utf8_decode( $pediatria_influeza_anual ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 70, 6, html_entity_decode( ( $this->lang->line('pediatria_hepatitis_a').": (".$this->lang->line('pediatria_vacuna_unica') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_hepatitis_a ) && !empty( $pediatria_hepatitis_a ) ) ? utf8_decode( $pediatria_hepatitis_a ) : '' ) ), 0, 'L' );
    }

    // 60 meses: 5 años
    if( $meses >= 18 && $meses < 60 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_dieciocho_meses' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_difteria_tosferina_tetano').": (".$this->lang->line('pediatria_vacuna_1_refuerzo') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_difteria_tosferina_tetano_1_refuerzo ) && !empty( $pediatria_difteria_tosferina_tetano_1_refuerzo ) ) ? utf8_decode( $pediatria_difteria_tosferina_tetano_1_refuerzo ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_polio_oral_im').": (".$this->lang->line('pediatria_vacuna_1_refuerzo') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_polio_im_1_refuerzo ) && !empty( $pediatria_polio_im_1_refuerzo ) ) ? utf8_decode( $pediatria_polio_im_1_refuerzo ) : '' ) ), 0, 'L' );
    }

    // 5 años
    if( $meses >= 60 & $meses < 72 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'pediatria_vacunas_cinco_anos' ) ), 0, 1, 'C' );

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_polio_oral_im').": (".$this->lang->line('pediatria_vacuna_2_refuerzo') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_polio_im_2_refuerzo ) && !empty( $pediatria_polio_im_2_refuerzo ) ) ? utf8_decode( $pediatria_polio_im_2_refuerzo ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_difteria_tosferina_tetano').": (".$this->lang->line('pediatria_vacuna_2_refuerzo') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_difteria_tosferina_tetano_2_refuerzo ) && !empty( $pediatria_difteria_tosferina_tetano_2_refuerzo ) ) ? utf8_decode( $pediatria_difteria_tosferina_tetano_2_refuerzo ) : '' ) ), 0, 'L' );
        $pdf->Ln();

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 0, 6, html_entity_decode( ( $this->lang->line('pediatria_sarampion_rubeola_paperas').": (".$this->lang->line('pediatria_vacuna_refuerzo') ).')'  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( ( isset( $pediatria_sarampion_rubeola_paperas_refuerzo ) && !empty( $pediatria_sarampion_rubeola_paperas_refuerzo ) ) ? utf8_decode( $pediatria_sarampion_rubeola_paperas_refuerzo ) : '' ) ), 0, 'L' );
    }

    // No aplica
    if( $meses > 72 ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'no_aplica' ) ), 0, 1, 'C' );
        $pdf->SetFont( 'Arial', '' );
    }
}