<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Platc
 *
 * Clase principal de la aplicacion de tipo controlador
 * esta clase carga el modelo que utiliza para obtener los
 * datos y los envia a la vista correspondiente.
 *
 * @author Esteban G�mez Lillo
 * @author http://www.swift.cl
 *
 * @package Platc
 */
class Platc20 extends CI_Controller {

    private $data = array();
    private $menu = array();
    private $languaje = '';
    private $path_file;

    /**
     * Contructor de la clase que carga el modelo y las
     * librerias necesarias, ademas setea el idioma.
     *
     * @access default
     * @param none
     * @return none
     */
    function __construct() {
        parent::__construct();
        $this->load->model('platc_model');
        $this->load->library('form_validation');
        $this->load->library('util');
        $CI = &get_instance();
        $CI->config->load('platc', true);
        $this->path_file = $CI->config->item('path_file', 'platc');
        if ($this->session->userdata('IDI_NOMBRE') == '')
            $this->languaje = 'spanish';
        else {
            $this->languaje = $this->session->userdata('IDI_NOMBRE');
            if ($this->session->userdata('ROL_ID') == 3)
                $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($this->session->userdata('USU_ID'));
        }
        $this->lang->load($this->languaje, $this->languaje);
    }

    /**
     * Metodo que comprueba si el usuario esta logeado, y si
     * es asi lo lleva a la vista correspondiente, de lo
     * contrario lo lleva a la vista de login para que se
     * autentique nuevamente.
     *
     * @access public
     * @param string $view la vista a cargar
     * @return none
     */
    public function index($view = 'index_view') {
        if ($this->session->is_logged()) {
            $this->menu();

            // Obtiene imagen institucional
            $usuario = $this->platc_model->usuario_get($this->session->userdata('USU_ID'));
            if (!empty($usuario))
                $this->data['imagen_institucional'] = $usuario['CLI_IMAGEN_INSTITUCIONAL'];
            else
                $this->data['imagen_institucional'] = NULL;

            $this->load->view($view, $this->data);
        }
        else {
            if ($view == 'index_view') {
                $this->data['reload_login'] = FALSE;
            }
            else
                $this->data['reload_login'] = TRUE;
            $this->load->view('login_view', $this->data);
        }
    }

    /**
     * Autentica al usuario segun parametros recividos desde
     * la vista login
     *
     * @access public
     * @param string $_POST['mail'] coreo para la autenticacion
     * @param string $_POST['pass'] contrase�a para la autenticacion
     * @return none
     */
    public function login() {
        $this->form_validation->set_rules('mail', '', 'required');
        $this->form_validation->set_rules('pass', '', 'required');
        if ($this->form_validation->run() != FALSE) {
            $data_user = $this->platc_model->login($this->input->post('mail'), md5($this->input->post('pass')));
            if ($data_user != FALSE) {
                $data_user['logged_in'] = TRUE;
                if ($data_user['ROL_ID'] == 3){
                    $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($data_user['USU_ID']);
                    $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($data_user['USU_ID']);
                    $data_user['grupos'] = $this->platc_model->grupos_por_usuario( $data_user['USU_ID'] );
                }
                $this->session->set_session($data_user);
            }
            else
                $this->data['msg'] = TRUE;
        }
        $this->index();
    }

    /**
     * Carga el menu con todos los links del usuario segun el rol.
     * esto se carga en la variable global $data.
     *
     * @access private
     * @param none
     * @return none
     */
    private function menu() {
        if ($this->session->userdata('ROL_ID') == 1) {
            $this->data['menu'][$this->lang->line('menu_2')] = 'platc/tc_lista_view/2/';
            $this->data['menu'][$this->lang->line('menu_3')] = 'platc/tc_lista_view/5/';
            $this->data['menu'][$this->lang->line('menu_4')] = 'platc/tc_lista_view/6/';
            $this->data['menu'][$this->lang->line('menu_5')] = 'platc/tc_lista_view/7/';
            $this->data['menu'][$this->lang->line('menu_6')] = 'platc/tc_lista_view/3/';
            $this->data['menu'][$this->lang->line('menu_7')] = 'platc/tc_lista_view/4/';
            $this->data['menu'][$this->lang->line('menu_18')] = 'platc/busqueda_tc/';
            $this->data['menu'][$this->lang->line('menu_9')] = 'platc/grupos/';
            $this->data['menu'][$this->lang->line('menu_10')] = 'platc/clientes/';
            $this->data['menu'][$this->lang->line('menu_11')] = 'platc/establecimientos/';
            $this->data['menu'][$this->lang->line('menu_12')] = 'platc/usuarios/';
            $this->data['menu'][$this->lang->line('menu_13')] = 'platc/afiliaciones/';
            $this->data['menu'][$this->lang->line('menu_14')] = 'platc/especialidades/';
            $this->data['menu'][$this->lang->line('menu_16')] = 'platc/identificadores/';
            $this->data['menu'][$this->lang->line('menu_19')] = 'platc/reportes/';
        }
        if ($this->session->userdata('ROL_ID') == 2) {
            $this->data['menu'][$this->lang->line('menu_2')] = 'platc/tc_lista_view/2/';
            $this->data['menu'][$this->lang->line('menu_3')] = 'platc/tc_lista_view/5/';
            $this->data['menu'][$this->lang->line('menu_4')] = 'platc/tc_lista_view/6/';
            $this->data['menu'][$this->lang->line('menu_5')] = 'platc/tc_lista_view/7/';
            $this->data['menu'][$this->lang->line('menu_6')] = 'platc/tc_lista_view/3/';
            $this->data['menu'][$this->lang->line('menu_7')] = 'platc/tc_lista_view/4/';
            $this->data['menu'][$this->lang->line('menu_18')] = 'platc/busqueda_tc/';
            $this->data['menu'][$this->lang->line('menu_10')] = 'platc/clientes/';
            $this->data['menu'][$this->lang->line('menu_11')] = 'platc/establecimientos/';
            $this->data['menu'][$this->lang->line('menu_12')] = 'platc/usuarios/';
        }
        if ($this->session->userdata('ROL_ID') == 3) {
            $this->data['menu'][$this->lang->line('menu_2')] = 'platc/tc_lista_view/2/';
            $this->data['menu'][$this->lang->line('menu_3')] = 'platc/tc_lista_view/5/';
            $this->data['menu'][$this->lang->line('menu_4')] = 'platc/tc_lista_view/6/';
            $this->data['menu'][$this->lang->line('menu_5')] = 'platc/tc_lista_view/7/';
            $this->data['menu'][$this->lang->line('menu_6')] = 'platc/tc_lista_view/3/';
            $this->data['menu'][$this->lang->line('menu_17')] = 'platc/busqueda_tc/';
        }
        if ($this->session->userdata('ROL_ID') == 4 || $this->session->userdata('ROL_ID') == 5) {
            $this->data['menu'][$this->lang->line('menu_1')] = 'platc/tc_crear/';
            $this->data['menu'][$this->lang->line('menu_0')] = 'platc/pacientes/';
            $this->data['menu'][$this->lang->line('menu_15')] = 'platc/tc_lista_view/1/';
            $this->data['menu'][$this->lang->line('menu_2')] = 'platc/tc_lista_view/2/';
            $this->data['menu'][$this->lang->line('menu_3')] = 'platc/tc_lista_view/5/';
            $this->data['menu'][$this->lang->line('menu_4')] = 'platc/tc_lista_view/6/';
            $this->data['menu'][$this->lang->line('menu_5')] = 'platc/tc_lista_view/7/';
            $this->data['menu'][$this->lang->line('menu_6')] = 'platc/tc_lista_view/3/';
            $this->data['menu'][$this->lang->line('menu_17')] = 'platc/busqueda_tc/';
        }
    }

    /**
     * Mata la session del usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function logout() {
        $this->session->unset_userdata('logged_in');
        $this->session->sess_destroy();
        $this->index();
    }

    /**
     * Acceso a la vista principal del usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function home() {
        $this->index('home_view');
    }

    /**
     * Acceso a la vista principal del rol generalista.
     *
     * @access public
     * @param none
     * @return none
     */
    public function generalistas() {
        $this->data['exsols'] = $this->platc_model->tc_lista_get(5, 1, 'ASC');
        $this->data['contestadas'] = $this->platc_model->tc_lista_get(7, 1, 'DESC');
        $this->index('generalistas_view');
    }

    /**
     * Acceso a la vista principal del rol especialista.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialistas() {
        $this->data['exreals'] = $this->platc_model->tc_lista_get(6, 1, 'ASC');
        $this->data['enviadas'] = $this->platc_model->tc_lista_get(2, 1, 'ASC');
        $this->index('especialistas_view');
    }

    /**
     * Acceso a la vista para cambiar la password del usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function cambiar_passwd() {
        $this->index('chpassword_view', $this->data);
    }

    /**
     * Cambia el password del usuario.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param none
     * @param string $_POST['passnow'] password actual del usuario
     * @param string $_POST['passnew'] la nueva password del usuario
     * @param string $_POST['passrnew'] la repeticion de la nueva password del usuario
     * @return none
     */
    public function cambia_passwd() {
        $this->form_validation->set_rules('passnow', '', 'required');
        $this->form_validation->set_rules('passnew', '', 'required');
        $this->form_validation->set_rules('passrnew', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->input->post('passnew') == $this->input->post('passrnew')) {
            if ($this->platc_model->usuario_chpass($this->session->userdata('USU_ID'), md5($this->input->post('passnow')), md5($this->input->post('passnew')))) {
                $resp['action'] = 'true';
                $content = 'home';
                if ($this->session->userdata('ROL_ID') > 3)
                    $content = 'generalistas';
                if ($this->session->userdata('ROL_ID') == 3)
                    $content = 'especialistas';
                $resp['method'] = base_url() . 'platc/' . $content . '/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('chpass_ok');
            }
            else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('chpass_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Acceso a la vista para ver los sites creados,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function sites() {
        $this->index('sites_view');
    }

    /**
     * Metodo que saca todos los sites que existen en el sistema.
     *
     * @access public
     * @param none
     * @return array $this->data['sites'] con todos los sites del sistema
     */
    public function sites_lista() {
        $this->data['sites'] = $this->platc_model->sites_lista_get();
        $this->index('sites_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo site,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function site_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $idiomas = $this->platc_model->idiomas_get();
        $this->data['idiomas_select'] = $this->util->select_form_prepare($idiomas, 'IDI_ID', 'IDI_NOMBRE');
        $this->index('sites_agrega_view');
    }

    /**
     * Metodo encargado de recivir los parametros del nuevo site,
     * validarlos y crear el site,
     * esto solo para el rol de administrador.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del nuevo site
     * @param string $_POST['descripcion'] descripcion del nuevo site
     * @param int $_POST['idioma'] idioma del site
     * @param int $_POST['idpit'] identificador del site en la PIT
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function site_crea() {
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('idioma', '', 'required');
        $this->form_validation->set_rules('idpit', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['SIT_NOMBRE'] = $this->input->post('nombre');
            $data['SIT_DESCRIPCION'] = $this->input->post('descripcion');
            $data['IDI_ID'] = $this->input->post('idioma');
            $data['SIT_PIT_ID'] = $this->input->post('idpit');
            if ($this->platc_model->site_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/sites_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('sites_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('sites_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Llama a la vista con los datos del site a editar,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param int $id identificador del site a editar
     * @return none
     */
    public function site_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['site'] = $this->platc_model->site_get($id);
        $idiomas = $this->platc_model->idiomas_get();
        $this->data['idiomas_select'] = $this->util->select_form_prepare($idiomas, 'IDI_ID', 'IDI_NOMBRE');
        $this->index('sites_edita_view');
    }

    /**
     * Metodo encargado de recivir los parametros del site ya existente,
     * validarlos y editar el site,
     * esto solo para el rol de administrador.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del nuevo site
     * @param string $_POST['descripcion'] descripcion del nuevo site
     * @param int $_POST['idioma'] idioma del site
     * @param int $_POST['idpit'] identificador del site en la PIT
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function site_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('idioma', '', 'required');
        $this->form_validation->set_rules('idpit', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['SIT_ID'] = $this->input->post('id');
            $data['SIT_NOMBRE'] = $this->input->post('nombre');
            $data['SIT_DESCRIPCION'] = $this->input->post('descripcion');
            $data['IDI_ID'] = $this->input->post('idioma');
            $data['SIT_PIT_ID'] = $this->input->post('idpit');
            if ($this->platc_model->site_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/sites_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('sites_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('sites_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina un site segun el id recibido por GET,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param int $id identificador del site a eliminar
     * @return none
     */
    public function site_eliminar($id) {
        if ($this->session->userdata('ROL_ID') == 1) {
            if ($this->platc_model->site_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista de los grupos,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function grupos() {
        $this->index('grupos_view');
    }

    /**
     * Metodo que saca todos los grupos del sistema.
     *
     * @access public
     * @param none
     * @return array $this->data['grupos'] con todos los grupos del sistema
     */
    public function grupos_lista() {

        $this->data['grupos'] = $this->platc_model->grupos_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('grupos_datagrid_view');
    }

    /**
     * Muestra la vista para la creacion de un grupo.
     *
     * @access public
     * @param none
     * @return array $this->data['sites_select'] con todos los site del sistema
     */
    public function grupo_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));

        $this->data['clientes'] = $this->util->prepare_data( $this->util->select_form_prepare( $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') ), 'CLI_ID', 'CLI_NOMBRE' ) );
        $this->data['usuarios'] = $this->util->prepare_data( $this->util->select_form_prepare( $this->platc_model->usuarios_por_rol( array( 2, 3 ), $this->session->userdata('SIT_ID'),TRUE ), 'USU_ID', 'USU_NOMBRE' ) );

        $this->index('grupos_agrega_view');
    }

    /**
     * Crea un grupo con los parametros recividos.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $data['nombre'] nombre del grupo
     * @param string $data['descripcion'] descripcion del grupo
     * @param int $data['site'] id del site al cual esta asignandoce el grupo
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function grupo_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['GRU_NOMBRE'] = $this->input->post('nombre');
            $data['GRU_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            $clientes = $this->input->post('clientes');
            $usuarios = $this->input->post('usuarios');

            if ($this->platc_model->grupo_set($data, $clientes, $usuarios )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/grupos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('grupos_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('grupos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un grupo
     *
     * @access public
     * @param int $id identificador del grupo el cual se quiere editar
     * @return none
     */
    public function grupo_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['grupo'] = $this->platc_model->grupo_get($id);

        // Datos del grupo
        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        if( !empty( $clientes ) )
            $this->data['clientes'] = $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) );
        else
            $this->data['clientes'] = array( );

        $usuarios = $this->platc_model->usuarios_por_rol( array( 2, 3 ), $this->session->userdata('SIT_ID') );
        if( !empty( $usuarios ) )
            $this->data['usuarios'] = $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_NOMBRE' ) );
        else
            $this->data['usuarios'] = array( );

        // Datos para los dropdown de la página
        $clientes = $this->platc_model->clientes_grupo_get( $id );
        if( !empty( $clientes ) )
            $this->data['clientes_sel'] = $this->util->prepare_data( $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE' ) );
        else
            $this->data['clientes_sel'] = array( );

        $usuarios = $this->platc_model->usuarios_por_grupo( $id );
        if( !empty( $usuarios ) )
            $this->data['usuarios_sel'] = $this->util->prepare_data( $this->util->select_form_prepare( $usuarios, 'USU_ID', 'USU_NOMBRE' ) );
        else
            $this->data['usuarios_sel'] = array( );

        $this->index('grupos_edita_view');
    }

    /**
     * Edita un grupo segun nuevos parametros recibidos,
     * se validan y se hace el cambio.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $data['id'] id del grupo que se quiere editar
     * @param string $data['nombre'] nombre del grupo
     * @param string $data['descripcion'] descripcion del grupo
     * @return array $resp encodeado con json con la informacion del resultado
     */
    public function grupo_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['GRU_ID'] = $this->input->post('id');
            $data['GRU_NOMBRE'] = $this->input->post('nombre');
            $data['GRU_DESCRIPCION'] = $this->input->post('descripcion');

            $clientes = $this->input->post('clientes');
            $usuarios = $this->input->post('usuarios');

            if ($this->platc_model->grupo_upd($data, $clientes, $usuarios )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/grupos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('grupos_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('grupos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina un grupo segun el id recibido por GET,
     * esto solo para el rol de administrador.
     *
     * @access public
     * @param int $id identificador del grupo a eliminar
     * @return none
     */
    public function grupo_eliminar($id) {
        if ($this->session->userdata('ROL_ID') == 1) {
            if ($this->platc_model->grupo_del($id))
                echo 'true';
        }
    }

    /**
     * Metodo que autocompleta el campo generalista
     * y especialista segun el tipo y el string que
     * que se necesita que haga match,
     *
     * @access public
     * @param int $tipo tipo de usuario (generalista o especialista)
     * @return none
     */
    public function autocomplete($tipo, $match) {
        $result = $this->platc_model->autocomplete_search_get($tipo, $match);
        if ($result != NULL) {
            foreach ($result as $r)
                echo $r['USU_NOMBRE'] . "\n";
        }
        else
            echo $this->lang->line('error_busqueda');
    }

    /**
     * Carga la vista para la busqueda de TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function busqueda_tc($sdasd = NULL, $cache = FALSE) {

        // Inicializa campos
        $this->data['especialidades_select'] = array( );

        // Administrador
        if ($this->session->userdata('ROL_ID') == 1) {
            $grupos = $this->platc_model->grupos_site_get( $this->session->userdata('SIT_ID') );
            $this->data['grupos_select'] = $this->util->select_form_prepare($grupos, 'GRU_ID', 'GRU_NOMBRE' );
            $especialidades = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
            if( !empty( $especialidades ) ) $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE' );
        } else
            // Supervisor
            if ($this->session->userdata('ROL_ID') == 2 ) {
            $clientes = $this->platc_model->clientes_usuario_get( $this->session->userdata('USU_ID') );
            $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', $this->lang->line('todos'), TRUE );

        } else
            // Especialista
            if ($this->session->userdata('ROL_ID') == 3 ) {
            $clientes = $this->platc_model->clientes_usuario_get( $this->session->userdata('USU_ID') );
            $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', $this->lang->line('todos'), TRUE );
        } else {

            // Generalistas
            $establs = $this->platc_model->establecimientos_cliente_get($this->session->userdata('CLI_ID'));
            $this->data['establs_select'] = $this->util->select_form_prepare($establs, 'ETB_ID', 'ETB_NOMBRE', $this->lang->line('todos'), TRUE );

            $especialidades = $this->platc_model->especialidades_por_cliente( $this->session->userdata('CLI_ID') );
            if( !empty( $especialidades ) ) $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE');
        }

        $this->data['estados_select'] = $this->platc_model->estados_select($this->languaje);
//        $data['autocomplete_especialidad'] = NULL;
//        $data['autocomplete_cliente'] = NULL;
//        $data['autocomplete_establ'] = NULL;
//        $data['busqueda_tc_av'] = NULL;
//        $this->session->set_userdata($data);
        if ($cache != FALSE)
            $this->data['search_cache'] = TRUE;
        else
            $this->data['search_cache'] = FALSE;
        $this->index('busqueda_tc_view');
    }

    /**
     * Carga la vista para la administracion de clientes.
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes() {
        $this->index('clientes_view');
    }

    /**
     * Lista todos los clientes del sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes_lista() {
        $this->data['clientes'] = $this->platc_model->clientes_lista_get();
        $this->index('clientes_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo cliente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function cliente_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));

        // Define especialidades por cada cliente
        $this->data['especialidades'] = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
        // TODO: "usuario_especialidades" debe ser "cliente_especialiades" no se cambia por ocupar misma lógica (reutilización de código)
        $this->index('clientes_agrega_view');
    }

    /**
     * Recibe parametros del nuevo cliente, los valida,
     * y lo crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del cliente
     * @param string $_POST['rut'] rut del cliente
     * @param string $_POST['razonsocial'] razon social del cliente
     * @param int $_POST['site'] site del cliente
     * @param int $_POST['grupo'] grupo del cliente
     * @return none
     */
    public function cliente_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('rut', '', 'required');
        $this->form_validation->set_rules('especialidades', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') < 3) {
            $data['CLI_NOMBRE'] = $this->input->post('nombre');
            $data['CLI_RUT'] = $this->input->post('rut');
            $data['CLI_RAZON_SOCIAL'] = $this->input->post('razonsocial');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            $especialidades = $this->input->post( 'especialidades' );

            if ($this->platc_model->cliente_set($data, $especialidades )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/clientes_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('clientes_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('clientes_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un cliente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function cliente_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['cliente'] = $this->platc_model->cliente_get($id);

        // Define especialidades por cada cliente
        $this->data['especialidades'] = $this->platc_model->especialidades_site_get( $this->session->userdata('SIT_ID') );
        // TODO: "usuario_especialidades" debe ser "cliente_especialiades" no se cambia por ocupar misma lógica (reutilización de código)
        $this->data['usuario_especialidades'] = $this->platc_model->especialidades_por_cliente( $id );
        $this->index('clientes_edita_view');
    }

    /**
     * Recibe los parametros para la edicion de un cliente.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del cliente
     * @param string $_POST['nombre'] nombre del cliente
     * @param string $_POST['rut'] rut del cliente
     * @param string $_POST['razonsocial'] razon social del cliente
     * @param int $_POST['grupo'] grupo del cliente
     * @return none
     */
    public function cliente_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('rut', '', 'required');
        $this->form_validation->set_rules('especialidades', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') < 3) {
            $data['CLI_ID'] = $this->input->post('id');
            $data['CLI_NOMBRE'] = $this->input->post('nombre');
            $data['CLI_RUT'] = $this->input->post('rut');
            $data['CLI_RAZON_SOCIAL'] = $this->input->post('razonsocial');
            $especialidades           = $this->input->post('especialidades');

            // Lee archivo de imagen institucional
            $archivo_imagen = $this->input->post('imagen_institucional');
            if (!empty($archivo_imagen)) {
                $nombre_archivo = 'uploads/' . $archivo_imagen;

                // Elimina del nombre del archivo el timestamp (nombre_archivo_xxxxxxxx.jpg)
                // y lo deja tal cual lo ingresaron (nombre_archivo.jpg)
                $archivo_imagen = explode('.', $archivo_imagen);
                $extension = array_pop($archivo_imagen);
                $archivo_imagen = explode('_', implode('.', $archivo_imagen));
                array_pop($archivo_imagen); //Descarta timestamp
                $archivo_imagen = implode('_', $archivo_imagen);
                $archivo_imagen = implode('.', array($archivo_imagen, $extension));

                @rename($nombre_archivo, 'images/clientes/' . $archivo_imagen);
                @unlink($nombre_archivo);
                $data['CLI_IMAGEN_INSTITUCIONAL'] = $archivo_imagen;
            }
            if ($this->platc_model->cliente_upd($data, $especialidades )) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/clientes_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('clientes_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('clientes_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Página que permite subir el archivo de imagen de la institucion
     */
    public function cliente_subir_imagen_inst() {

        $error = '';

        if (!empty($_FILES)) {
            $config['upload_path'] = './uploads/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '100';
            $config['max_width'] = '200';
            $config['max_height'] = '100';
            $this->load->library('upload', $config);

            if ($this->upload->do_upload('imagen_institucional')) {
                $datos = $this->upload->data();
                $ruta = explode('/', $datos['full_path']);
                array_pop($ruta);
                $ruta = implode('/', $ruta);
                $nombre_nuevo = $datos['raw_name'] . '_' . time() . $datos['file_ext'];

                rename($ruta . '/' . $datos['file_name'], $ruta . '/' . $nombre_nuevo);

                $retorno = '<script language="javascript" type="text/javascript">';
                $retorno.= 'window.opener.document.getElementById( "imagen_institucional" ).value = "' . $nombre_nuevo . '" ;';
                $retorno.= 'window.close();';
                $retorno.= '</script>';

                exit($retorno);
            } else {
                $error = array('error' => $this->upload->display_errors());
            }
        }

        $this->load->view('clientes_subir_imagen_inst', array('error' => $error));
    }

    public function cliente_eliminar($id) {
        if ($this->session->userdata('ROL_ID') < 3) {
            if ($this->platc_model->cliente_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la administracion de establecimientos.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimientos() {
        $this->index('establecimientos_view');
    }

    /**
     * Lista todos los establecimientos del sistema
     * esto segun el rol que esta tenga.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimientos_lista() {
        $this->data['establecimientos'] = $this->platc_model->establecimientos_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('establecimientos_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un establecimiento.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimiento_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes_select']   = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE');

        $municipios = $this->platc_model->municipio_get(  );
        $this->data['municipios_select'] = $this->util->select_form_prepare( $municipios, 'MUNI_ID', 'MUNI_NOMBRE');

        $this->index('establecimientos_agrega_view');
    }

    /**
     * Recibe los parametros para la edicion de un cliente.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del establecimiento
     * @param string $_POST['nivel'] nivel del establecimiento
     * @param string $_POST['direccion'] direccion del establecimiento
     * @param string $_POST['email'] email del establecimiento
     * @param int $_POST['site'] site del establecimiento
     * @param int $_POST['grupo'] grupo del establecimiento
     * @param int $_POST['cliente'] cliente del establecimiento
     * @return none
     */
    public function establecimiento_crea() {
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('nivel', '', 'required');
        $this->form_validation->set_rules('direccion', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('cliente', '', 'required');

        if( $this->session->userdata('SIT_ID') == 22  )
            $this->form_validation->set_rules('municipio', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') < 3) {
            $data['ETB_NOMBRE'] = $this->input->post('nombre');
            $data['ETB_NIVEL'] = $this->input->post('nivel');
            $data['ETB_DIRECCION'] = $this->input->post('direccion');
            $data['ETB_EMAIL'] = $this->input->post('email');
            $data['CLI_ID'] = $this->input->post('cliente');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            if( $this->session->userdata('SIT_ID') == 22  )
                $data['MUNI_ID'] = $this->input->post('municipio');

            if ($this->platc_model->establecimiento_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/establecimientos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('establecimientos_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('establecimientos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un establecimiento.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimiento_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));

        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes_select'] = $this->util->select_form_prepare($clientes, 'CLI_ID', 'CLI_NOMBRE');

        $municipios = $this->platc_model->municipio_get(  );
        $this->data['municipios_select'] = $this->util->select_form_prepare( $municipios, 'MUNI_ID', 'MUNI_NOMBRE');

        $this->data['establecimiento'] = $this->platc_model->establecimiento_get($id);

        $this->index('establecimientos_edita_view');
    }

    /**
     * Recibe los parametros para editar un establecimiento.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del establecimiento
     * @param string $_POST['nombre'] nombre del establecimiento
     * @param string $_POST['nivel'] nivel del establecimiento
     * @param string $_POST['direccion'] direccion del establecimiento
     * @param string $_POST['email'] email del establecimiento
     * @param int $_POST['cliente'] cliente del establecimiento
     * @return none
     */
    public function establecimiento_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('nivel', '', 'required');
        $this->form_validation->set_rules('direccion', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('cliente', '', 'required');

        if( $this->session->userdata('SIT_ID') == 22  )
            $this->form_validation->set_rules('municipio', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') < 3) {
            $data['ETB_ID'] = $this->input->post('id');
            $data['ETB_NOMBRE'] = $this->input->post('nombre');
            $data['ETB_NIVEL'] = $this->input->post('nivel');
            $data['ETB_DIRECCION'] = $this->input->post('direccion');
            $data['ETB_EMAIL'] = $this->input->post('email');
            $data['CLI_ID'] = $this->input->post('cliente');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            if( $this->session->userdata('SIT_ID') == 22  )
                $data['MUNI_ID'] = $this->input->post('municipio');

            if ($this->platc_model->establecimiento_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/establecimientos_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('establecimientos_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('establecimientos_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Recibe el id de un establecimiento y lo elimina.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establecimiento_eliminar($id) {
        if ($this->session->userdata('ROL_ID') < 3) {
            if ($this->platc_model->establecimiento_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la administracion de los usuarios.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuarios() {
        $this->index('usuarios_view');
    }

    /**
     * Carga la lista con los usuarios del sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuarios_lista() {
        $this->data['usuarios'] = $this->platc_model->usuarios_get( $this->session->userdata('SIT_ID') );
        $this->index('usuarios_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $roles = $this->platc_model->roles_get();
        $i = 0;
        foreach ($roles as $r) {
            $rol[$i]['id'] = $r['ROL_ID'];
            $rol[$i]['nombre'] = $this->lang->line('rol_' . $r['ROL_ID']);
            $i++;
        }
        $this->data['rol_select'] = $this->util->select_form_prepare($rol, 'id', 'nombre');
//        $sites = $this->platc_model->sites_get();
//        $this->data['sites_select'] = $this->util->select_form_prepare($sites, 'SIT_ID', 'SIT_NOMBRE');
        $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
        $this->data['clientes_select'] = $this->util->select_form_prepare($clientes, 'CLI_ID', 'CLI_NOMBRE');
        $this->index('usuarios_agrega_view');
    }

    /**
     * Crea lista con todas las especialidades que tenga un site,
     * esto para poder crear un usuario con especialidades.
     *
     * @access public
     * @param  $idsite int Identificador del site al que pertenece la especialidad
     * @param  $idusu  int Identificador del usuario para completar datos del formulario
     * @return none
     */
    public function usuario_especialidades_site($idsite, $idusu = NULL) {
        $this->data['especialidades'] = $this->platc_model->especialidades_site_get($idsite);
        if ($idusu != NULL)
            $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($idusu);
        $this->index('usuarios_especialidades_view');
    }

    /**
     * Carga la vista para la edicion de un usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['usuario'] = $this->platc_model->usuario_get($id);
        $this->data['usuario_especialidades'] = $this->platc_model->usuario_especialidades_get($id);
        $roles = $this->platc_model->roles_get();
        $i = 0;
        foreach ($roles as $r) {
            $rol[$i]['id'] = $r['ROL_ID'];
            $rol[$i]['nombre'] = $this->lang->line('rol_' . $r['ROL_ID']);
            $i++;
        }
        $this->data['rol_select'] = $this->util->select_form_prepare($rol, 'id', 'nombre');

        if( $this->session->userdata('ROL_ID') == 1 )
            $clientes = $this->platc_model->clientes_get( );
        else
            $clientes = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );

        $this->data['clientes_select'] = $this->util->select_form_prepare($clientes, 'CLI_ID', 'CLI_NOMBRE');
        $this->index('usuarios_edita_view');
    }

    /**
     * Desactiva un usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_desactivar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $data['USU_ID'] = $id;
        $data['USU_ACTIVO'] = '0';
        $this->platc_model->usuario_estado_upd($data);
        echo 'true';
    }

    /**
     * Activa un usuario.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_activar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $data['USU_ID'] = $id;
        $data['USU_ACTIVO'] = '1';
        $this->platc_model->usuario_estado_upd($data);
        echo 'true';
    }

    /**
     * Recibe los parametros para la creacion de un nuevo usuario,
     * los valida y lo crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del usuario
     * @param string $_POST['email'] email del establecimiento
     * @param string $_POST['passwd'] password del usuario
     * @param string $_POST['passwdr'] la repeticion del password del usuario
     * @param int $_POST['rol'] rol del usuario
     * @param int $_POST['site'] site al que pertenece el usuario
     * @param int $_POST['grupo'] grupo al que pertenece el usuario
     * @param int $_POST['cliente'] cliente al que pertenece el usuario
     * @param int $_POST['establ'] establecimiento al que pertenece el usuario si es un generalista
     * @param array $_POST['especialidades'] especialidades al que pertenece el usuario si es un especialista
     * @return none
     */
    public function usuario_crea() {
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('passwd', '', 'required');
        $this->form_validation->set_rules('passwdr', '', 'required');
        $this->form_validation->set_rules('rol', '', 'required');

        if ($this->input->post('rol') > 3) {
            $data['CLI_ID'] = $this->input->post('cliente');
            $this->form_validation->set_rules('cliente', '', 'required');
        } else if ($this->input->post('rol') == 3)
            $this->form_validation->set_rules('especialidades', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->input->post('passwd') == $this->input->post('passwdr') && $this->session->userdata('ROL_ID') < $this->input->post('rol') && $this->session->userdata('ROL_ID') < 3) {
            $data['USU_NOMBRE'] = $this->input->post('nombre');
            $data['USU_EMAIL'] = $this->input->post('email');
            $data['USU_PASSWORD'] = md5($this->input->post('passwd'));
            $data['ROL_ID'] = $this->input->post('rol');
            $data['USU_NRO_REGISTRO'] = $this->input->post('nro_registro');
            $data['USU_ACTIVO'] = 1;
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');

            // Lee archivo de imagen de firma
            $archivo_firma = $this->input->post('imagen_firma');
            if (!empty($archivo_firma)) {
                $nombre_archivo = 'uploads/' . $this->input->post('imagen_firma');
                $fp = fopen($nombre_archivo, 'r');
                $imagen = fread($fp, filesize($nombre_archivo));
                $imagen = base64_encode($imagen);
                fclose($fp);
                @unlink($nombre_archivo);
                $data['USU_FIRMA'] = $imagen;
            }

            $id_usu = NULL;
            if ($this->platc_model->site_identificadores_get($data['SIT_ID']) == NULL ||
                    $this->platc_model->site_afiliaciones_get($data['SIT_ID']) == NULL ||
                    $this->platc_model->especialidades_site_get($data['SIT_ID']) == NULL) {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('usuarios_error_2');
            } else {

                // Ingr{esa usuario
                $id_usu = $this->platc_model->usuario_set($data, null);
                switch ($id_usu) {

                    case 'ERROR1' : {
                            $resp['action'] = 'false';
                            $resp['msgt'] = 'ERROR';
                            $resp['msg'] = $this->lang->line('usuarios_error_1');
                        };
                        break;

                    case FALSE : {
                            $resp['action'] = 'false';
                            $resp['msgt'] = 'ERROR';
                            $resp['msg'] = $this->lang->line('usuarios_error');
                        };
                        break;

                    default : {
                            if ($data['ROL_ID'] == 3) {
                                foreach ($this->input->post('especialidades') as $esp) {
                                    $dataesp['USU_ID'] = $id_usu;
                                    $dataesp['ESP_ID'] = $esp;
                                    $this->platc_model->usuario_especialidad_set_upd($dataesp);
                                }
                            }
                            $resp['action'] = 'true';
                            $resp['method'] = base_url() . 'platc/usuarios_lista/';
                            $resp['div'] = 'deploy_content';
                            $resp['msgt'] = 'OK';
                            $resp['msg'] = $this->lang->line('usuarios_ok');
                        };
                        break;
                }
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Recibe los parametros para la edicion de un usuario,
     * ya existente.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del usuario
     * @param string $_POST['nombre'] nombre del usuario
     * @param string $_POST['email'] email del establecimiento
     * @param string $_POST['passwd'] password del usuario
     * @param string $_POST['passwdr'] la repeticion del password del usuario
     * @param int $_POST['rol'] rol del usuario
     * @param int $_POST['grupo'] grupo al que pertenece el usuario
     * @param int $_POST['cliente'] cliente al que pertenece el usuario
     * @param int $_POST['establ'] establecimiento al que pertenece el usuario si es un generalista
     * @param array $_POST['especialidades'] especialidades al que pertenece el usuario si es un especialista
     * @return none
     */
    public function usuario_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('email', '', 'required');
        $this->form_validation->set_rules('passwd', '', 'required');
        $this->form_validation->set_rules('passwdr', '', 'required');
        $this->form_validation->set_rules('rol', '', 'required');

        if ($this->input->post('rol') > 3) {
            $this->form_validation->set_rules('cliente', '', 'required');
        } else if ($this->input->post('rol') == 3)
            $this->form_validation->set_rules('especialidades', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->input->post('passwd') == $this->input->post('passwdr') && $this->session->userdata('ROL_ID') < $this->input->post('rol') && $this->session->userdata('ROL_ID') < 3) {
            $data['USU_ID'] = $this->input->post('id');
            $data['USU_NOMBRE'] = $this->input->post('nombre');
            $data['USU_EMAIL'] = $this->input->post('email');
            if ($this->input->post('passwd') != 'nocambiarestapassword')
                $data['USU_PASSWORD'] = md5($this->input->post('passwd'));
            $data['ROL_ID'] = $this->input->post('rol');

            if( $data['ROL_ID'] > 3 )
                $data['CLI_ID'] = $this->input->post('cliente');

            $data['USU_NRO_REGISTRO'] = $this->input->post('nro_registro');

            // Lee archivo de imagen de firma
            $archivo_firma = $this->input->post('imagen_firma');
            if (!empty($archivo_firma)) {
                $nombre_archivo = 'uploads/' . $this->input->post('imagen_firma');
                $fp = fopen($nombre_archivo, 'r');
                $imagen = fread($fp, filesize($nombre_archivo));
                $imagen = base64_encode($imagen);
                fclose($fp);
                @unlink($nombre_archivo);
                $data['USU_FIRMA'] = $imagen;
            }

            if ($this->platc_model->usuario_upd($data, $this->input->post('grupo'))) {
                if ($data['ROL_ID'] == 3) {
                    foreach ($this->input->post('especialidades') as $esp) {
                        $dataesp['USU_ID'] = $data['USU_ID'];
                        $dataesp['ESP_ID'] = $esp;
                        $this->platc_model->usuario_especialidad_set_upd($dataesp);
                    }
                }
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/usuarios_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('usuarios_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('usuarios_upd_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Página que permite subir el archivo de imagen que contiene
     * la firma del médico tratante.
     */
    public function usuario_subir_firma() {

        $error = '';

        if (!empty($_FILES)) {
            $config['upload_path'] = './uploads/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '900';
            $config['max_width'] = '200';
            $config['max_height'] = '200';
            $this->load->library('upload', $config);

            if ($this->upload->do_upload('firma')) {
                $datos = $this->upload->data();
                $ruta = explode('/', $datos['full_path']);
                array_pop($ruta);
                $ruta = implode('/', $ruta);
                $nombre_nuevo = $datos['raw_name'] . '_' . time() . $datos['file_ext'];

                rename($ruta . '/' . $datos['file_name'], $ruta . '/' . $nombre_nuevo);

                $retorno = '<script language="javascript" type="text/javascript">';
                $retorno.= 'window.opener.document.getElementById( "imagen_firma" ).value = "' . $nombre_nuevo . '" ;';
                $retorno.= 'window.close();';
                $retorno.= '</script>';

                exit($retorno);
            } else {
				//echo $this->upload->display_errors();
				//die();
                $error = array('error' => $this->upload->display_errors());
            }
        }

        $this->load->view('usuarios_subir_firma', array('error' => $error));
    }

    /**
     * Elimina un usuario segun el ID recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function usuario_eliminar($id) {
        if ($this->session->userdata('ROL_ID') < 3) {
            if ($this->platc_model->usuario_del($id))
                echo 'true';
        }
    }

    /**
     * Carga las teleconsultas que un paciente tenga en el sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_paciente($pac_id, $est_id, $tc_id) {
        $this->data['teleconsultas'] = $this->platc_model->tc_paciente_get($pac_id, $tc_id);
        $this->data['est_id'] = $est_id;
        $this->data['tc_id'] = $tc_id;
        $this->index('tc_paciente_datagrid_view');
    }

    /**
     * Carga la vista para la administracion de pacientes.
     *
     * @access public
     * @param none
     * @return none
     */
    public function pacientes() {
        $this->index('pacientes_view');
    }

    /**
     * Lista los pacientes del sistema, esto segun el rol del usuario que esta,
     * trabajando.
     *
     * @access public
     * @param none
     * @return none
     */
    public function pacientes_lista() {
        $this->data['flag'] = FALSE;
        $this->index('pacientes_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un nuevo paciente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_crear() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        $afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'));
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
        $this->data['llamado'] = 'paciente';
        $this->index('pacientes_agrega_view');
    }

    /**
     * Carga la vista para la edicion de un paciente que ya existe recibiendo
     * el id de este por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['paciente'] = $this->platc_model->paciente_get($id);
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        $this->data['paciente_identificadores'] = $this->platc_model->paciente_identificadores_get($id);
        $afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'));
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
        $this->index('pacientes_edita_view');
    }

    /**
     * Recibe los parametros para la creacion de un paciente,
     * los valida y lo crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['afiliacion'] afiliacion del paciente
     * @param string $_POST['nombre1'] primer nombre del paciente
     * @param string $_POST['nombre2'] segundo nombre del paciente
     * @param string $_POST['apellido1'] primer apellido del paciente
     * @param string $_POST['apellido2'] segundo apellido del paciente
     * @param int $_POST['anno'] anno de nacimiento del paciente
     * @param int $_POST['mes'] mes de nacimiento del paciente
     * @param int $_POST['dia'] dia de nacimiento del paciente
     * @param string $_POST['sexo'] sexo del paciente (M o F)
     * @param string $_POST['procedencia'] procedenciadel paciente
     * @param string $_POST['ocupacion'] ocupacion del paciente
     * @param array $_POST['identificador'] arreglo con los diferentes identificadores del paciente
     * @return none
     */
    public function paciente_crea() {
        $this->form_validation->set_rules('afiliacion', '', 'required');
        $this->form_validation->set_rules('nombre1', '', 'required');
        $this->form_validation->set_rules('apellido1', '', 'required');
        $this->form_validation->set_rules('anno', '', 'required');
        $this->form_validation->set_rules('mes', '', 'required');
        $this->form_validation->set_rules('dia', '', 'required');
        $this->form_validation->set_rules('sexo', '', 'required');
        $this->form_validation->set_rules('identificador', '', 'required');
        $this->form_validation->set_rules('identificador_valor', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') > 3) {
            $data['AFI_ID'] = $this->input->post('afiliacion');
            $data['CLI_ID'] = $this->session->userdata('CLI_ID');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            $data['PAC_PRIMER_NOMBRE'] = $this->input->post('nombre1');
            $data['PAC_SEGUNDO_NOMBRE'] = $this->input->post('nombre2');
            $data['PAC_PRIMER_APELLIDO'] = $this->input->post('apellido1');
            $data['PAC_SEGUNDO_APELLIDO'] = $this->input->post('apellido2');
            $data['PAC_NACIMIENTO'] = $this->input->post('anno') . "-" . $this->input->post('mes') . "-" . $this->input->post('dia');
            $data['PAC_SEXO'] = $this->input->post('sexo');
            $data['PAC_PROCEDENCIA'] = $this->input->post('procedencia');
            $data['PAC_OCUPACION'] = $this->input->post('ocupacion');
            $data['PAC_ACTIVO'] = 1;
            $data2[0]['IDT_ID'] = $this->input->post('identificador');
            $data2[0]['PAC_IDT_VALOR'] = $this->input->post('identificador_valor');
            /* 			$cont = 0;
              $chk = FALSE;
              foreach ($this->input->post('identificador') as $key => $val ) {
              if ($key != '' && $val != '') {
              $data2[$cont]['IDT_ID'] = $key;
              $data2[$cont]['PAC_IDT_VALOR'] = $val;
              $cont ++;
              $chk = TRUE;
              }
              }
              if ($chk == TRUE) { */
            $usu_id = $this->platc_model->paciente_set($data, $data2);
            if (is_numeric($usu_id)) {
                if ($this->input->post('tc') == true) {
                    $resp['action'] = 'true';
                    $resp['method'] = base_url() . 'platc/tc_nueva/' . $usu_id . '/';
                    $resp['div'] = 'deploy_content';
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('pacientes_ok');
                } else {
                    $resp['action'] = 'true';
                    $resp['method'] = base_url() . 'platc/pacientes_lista/';
                    $resp['div'] = 'deploy_content';
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('pacientes_ok');
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('pacientes_error');
            }
            /* 			}
              else {
              $resp['action'] = 'false';
              $resp['msgt'] = 'ERROR';
              $resp['msg'] = $this->lang->line('pacientes_ident_error');
              } */
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Recibe los parametros para la edicion de un paciente,
     * los valida y edita.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del paciente
     * @param int $_POST['afiliacion'] afiliacion del paciente
     * @param string $_POST['nombre1'] primer nombre del paciente
     * @param string $_POST['nombre2'] segundo nombre del paciente
     * @param string $_POST['apellido1'] primer apellido del paciente
     * @param string $_POST['apellido2'] segundo apellido del paciente
     * @param int $_POST['anno'] anno de nacimiento del paciente
     * @param int $_POST['mes'] mes de nacimiento del paciente
     * @param int $_POST['dia'] dia de nacimiento del paciente
     * @param string $_POST['sexo'] sexo del paciente (M o F)
     * @param string $_POST['procedencia'] procedenciadel paciente
     * @param string $_POST['ocupacion'] ocupacion del paciente
     * @param array $_POST['identificador'] arreglo con los diferentes identificadores del paciente

     * @return none
     */
    public function paciente_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('afiliacion', '', 'required');
        $this->form_validation->set_rules('nombre1', '', 'required');
        $this->form_validation->set_rules('apellido1', '', 'required');
        $this->form_validation->set_rules('anno', '', 'required');
        $this->form_validation->set_rules('mes', '', 'required');
        $this->form_validation->set_rules('dia', '', 'required');
        $this->form_validation->set_rules('sexo', '', 'required');
        $this->form_validation->set_rules('identificador', '', 'required');
        $this->form_validation->set_rules('identificador_valor', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') > 3) {
            $data['PAC_ID'] = $this->input->post('id');
            $data['AFI_ID'] = $this->input->post('afiliacion');
            $data['PAC_PRIMER_NOMBRE'] = $this->input->post('nombre1');
            $data['PAC_SEGUNDO_NOMBRE'] = $this->input->post('nombre2');
            $data['PAC_PRIMER_APELLIDO'] = $this->input->post('apellido1');
            $data['PAC_SEGUNDO_APELLIDO'] = $this->input->post('apellido2');
            $data['PAC_NACIMIENTO'] = $this->input->post('anno') . "-" . $this->input->post('mes') . "-" . $this->input->post('dia');
            $data['PAC_SEXO'] = $this->input->post('sexo');
            $data['PAC_PROCEDENCIA'] = $this->input->post('procedencia');
            $data['PAC_OCUPACION'] = $this->input->post('ocupacion');
            $data2[0]['IDT_ID'] = $this->input->post('identificador');
            $data2[0]['PAC_IDT_VALOR'] = $this->input->post('identificador_valor');
            /* 			$cont = 0;
              $chk = FALSE;
              foreach ($this->input->post('identificador') as $key => $val ) {
              if ($key != '' && $val != '') {
              $data2[$cont]['IDT_ID'] = $key;
              $data2[$cont]['PAC_IDT_VALOR'] = $val;
              $cont ++;
              $chk = TRUE;
              }
              }
              if ($chk == TRUE) { */
            if ($this->platc_model->paciente_upd($data, $data2)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/pacientes_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('pacientes_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('pacientes_error');
            }
            /* 			}
              else {
              $resp['action'] = 'false';
              $resp['msgt'] = 'ERROR';
              $resp['msg'] = $this->lang->line('pacientes_ident_error');
              } */
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina a un paciente del sistema recibiendo por GET,
     * el ID de este.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_eliminar($id) {
        if ($this->session->userdata('ROL_ID') > 3) {
            if ($this->platc_model->paciente_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la administracion de,
     * las afilicaciones de un site
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliaciones() {
        $this->index('afiliaciones_view');
    }

    /**
     * Crea una lista con todas las afiliacionde del sistema o del site,
     * segun el rol.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliaciones_lista() {
        $this->data['afiliaciones'] = $this->platc_model->afiliaciones_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('afiliaciones_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de una nueva afiliacion.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliacion_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->index('afiliaciones_agrega_view');
    }

    /**
     * Recibe los parametros para la creacion de una nueva afiliacion,
     * los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre de la afiliacion
     * @param string $_POST['descripcion'] descripcion de la afiliacion
     * @param int $_POST['site'] site de la afiliacion
     * @return none
     */
    public function afiliacion_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['AFI_NOMBRE'] = $this->input->post('nombre');
            $data['AFI_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            if ($this->platc_model->afiliacion_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/afiliaciones_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('afiliaciones_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('afiliaciones_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de una afiliacion,
     * recibiendo el id de este por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliacion_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['afiliacion'] = $this->platc_model->afiliacion_get($id);
        $this->index('afiliaciones_edita_view');
    }

    /**
     * Recibe los parametros para la edicion de una afiliacion ya existente,
     * los valida y edita la afiliacion.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la afiliacion
     * @param string $_POST['nombre'] nombre de la afiliacion
     * @param string $_POST['descripcion'] descripcion de la afiliacion
     * @return none
     */
    public function afiliacion_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['AFI_ID'] = $this->input->post('id');
            $data['AFI_NOMBRE'] = $this->input->post('nombre');
            $data['AFI_DESCRIPCION'] = $this->input->post('descripcion');
            if ($this->platc_model->afiliacion_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/afiliaciones_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('afiliaciones_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('afiliaciones_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina una afiliacion recibiendo el ID de esta por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function afiliacion_eliminar($id) {
        if ($this->session->userdata('ROL_ID') == 1) {
            if ($this->platc_model->afiliacion_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la administracion de especialidades.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades() {
        $this->index('especialidades_view');
    }

    /**
     * Lista todas las especialidades que hayan segun el tipo de usuario,
     * si es admin lista todas, si es supervisor solo lista las del site que
     * le corresponde.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_lista() {
        $this->data['especialidades'] = $this->platc_model->especialidades_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('especialidades_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de una nueva especialidad
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidad_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->index('especialidades_agrega_view');
    }

    /**
     * Recibe los parametros de la especialidad,
     * los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre de la especialidad
     * @param string $_POST['descripcion'] descripcion de la especialidad
     * @param int $_POST['site'] site de la especialidad
     * @return none
     */
    public function especialidad_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['ESP_NOMBRE'] = $this->input->post('nombre');
            $data['ESP_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            if ($this->platc_model->especialidad_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/especialidades_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('especialidades_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('especialidades_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de una especialidad,
     * recibiendo por GET el ID de esta.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidad_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['especialidad'] = $this->platc_model->especialidad_get($id);
        $this->index('especialidades_edita_view');
    }

    /**
     * Recibe los parametros de la especialidad a editar,
     * los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la especialidad
     * @param string $_POST['nombre'] nombre de la especialidad
     * @param string $_POST['descripcion'] descripcion de la especialidad
     * @return none
     */
    public function especialidad_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        $this->form_validation->set_rules('site', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['ESP_ID'] = $this->input->post('id');
            $data['ESP_NOMBRE'] = $this->input->post('nombre');
            $data['ESP_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->input->post('site');
            if ($this->platc_model->especialidad_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/especialidades_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('especialidades_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('especialidades_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina una especialidad segun el ID de esta
     * recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidad_eliminar($id) {
        if ($this->session->userdata('ROL_ID') == 1) {
            if ($this->platc_model->especialidad_del($id))
                echo 'true';
            else
                echo 'false';
        }
    }

    /**
     * Carga la vista para la administracion de identificadores.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificadores() {
        $this->index('identificadores_view');
    }

    /**
     * Lista todos los identificadores del sistema.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificadores_lista() {
        $this->data['identificadores'] = $this->platc_model->identificadores_lista_get( $this->session->userdata('SIT_ID') );
        $this->index('identificadores_datagrid_view');
    }

    /**
     * Carga la vista para la creacion de un
     * nuevo identificador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificador_crear() {

        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->index('identificadores_agrega_view');
    }

    /**
     * Recibe los parametros para la creacion de un
     * nuevo identificador, los valida y crea.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param string $_POST['nombre'] nombre del identificador
     * @param string $_POST['descripcion'] descripcion del identificador
     * @param int $_POST['site'] site del identificador
     * @return none
     */
    public function identificador_crea() {

        $this->form_validation->set_rules('nombre', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['IDT_NOMBRE'] = $this->input->post('nombre');
            $data['IDT_DESCRIPCION'] = $this->input->post('descripcion');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            if ($this->platc_model->identificador_set($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/identificadores_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('identificadores_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('identificadores_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la edicion de un identificador,
     * segun el ID de este recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificador_editar($id) {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['identificador'] = $this->platc_model->identificador_get($id);
        $this->index('identificadores_edita_view');
    }

    /**
     * Recibe los parametros para la edicion de un identificador
     * ya existente, los valida y edita.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID del identificador
     * @param string $_POST['nombre'] nombre del identificador
     * @param string $_POST['descripcion'] descripcion del identificador
     * @return none
     */
    public function identificador_edita() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('nombre', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 1) {
            $data['IDT_ID'] = $this->input->post('id');
            $data['IDT_NOMBRE'] = $this->input->post('nombre');
            $data['IDT_DESCRIPCION'] = $this->input->post('descripcion');
            if ($this->platc_model->identificador_upd($data)) {
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/identificadores_lista/';
                $resp['div'] = 'deploy_content';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('identificadores_upd_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('identificadores_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina un identificador segun el
     * ID recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function identificador_eliminar($id) {
        if ($this->session->userdata('ROL_ID') == 1) {
            if ($this->platc_model->identificador_del($id))
                echo 'true';
        }
    }

    /**
     * Devuelve el metodo para mostrar la TC segun el estado
     * en que esta se encuentre.
     *
     * @access private
     * @param none
     * @return none
     */
    private function tc_metodo_view($estado) {
        if ($estado == 1)
            $metodo = 'tc_borrador_editar';
        else if ($estado == 2)
            $metodo = 'tc_enviada_responder';
        else if ($estado == 3)
            $metodo = 'tc_rechazadas_view';
        else if ($estado == 4)
            $metodo = 'tc_eliminada_view';
        else if ($estado == 5)
            $metodo = 'tc_exsol_responder';
        else if ($estado == 6)
            $metodo = 'tc_exreal_responder';
        else if ($estado == 7)
            $metodo = 'tc_contestadas_view';
        else
            $metodo = NULL;
        return $metodo;
    }

    /**
     * Metodo que es llamado desde el menu de usuario y sirve
     * para traer el listado de las teleconsultas segun el estado
     * en que se encuentren.
     *
     * @access public
     * @param int $estado estado la de la TC
     * @param string $view vista que se desplegara
     * @return none
     */
    public function tc_lista_view($estado, $view = NULL) {
        $this->data['reload_view'] = $view;
        $this->data['titulo'] = $this->tc_title($estado);
        $this->data['estado'] = $estado;
        $this->data['metodo'] = 'tc_lista';
        $this->data['tc_id'] = '';
        $this->index('tc_view');
    }

    /**
     * Muestra la TC segun el id y estado.
     *
     * @access public
     * @param int $estado estado de la TC
     * @param int $tc_id ID de la TC
     * @return none
     */
    public function tc_view($estado, $tc_id, $view = NULL, $tc_view = NULL, $est_ant = NULL, $id_ant = NULL) {
        if ($tc_view == 'false')
            $data['tc_paciente_view'] = FALSE;
        else if ($tc_view == 'cache')
            $data['tc_paciente_view'] = 'cache';
        else
            $data['tc_paciente_view'] = TRUE;
        $data['tc_paciente_estado'] = $est_ant;
        $data['tc_paciente_id'] = $id_ant;
        $this->session->set_userdata($data);
        $this->data['reload_view'] = $view;
        $this->data['titulo'] = $this->tc_title($estado, TRUE);
        $this->data['estado'] = $estado;
        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['tc_id'] = $tc_id;
        $this->index('tc_view');
    }

    /**
     * Saca el titulo del archivo de lengua para los diferentes
     * estados de la TC, ya sea singular o plural
     * dependiendo de si se esta viendo la lista de TC o una en
     * particular.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_title($estado, $singular = FALSE) {
        if ($estado == 1 && $singular == FALSE)
            return $this->lang->line('tc_borradores_title');
        else if ($estado == 1 && $singular = TRUE)
            return $this->lang->line('tc_borrador_title');

        if ($estado == 2 && $singular == FALSE) {
            if ($this->session->userdata('ROL_ID') > 3)
                return $this->lang->line('tc_enviadas_title');
            else
                return $this->lang->line('tc_nuevas_title');
        }
        else if ($estado == 2 && $singular == TRUE) {
            if ($this->session->userdata('ROL_ID') > 3)
                return $this->lang->line('tc_enviada_title');
            else
                return $this->lang->line('tc_nueva_title');
        }
        if ($estado == 3 && $singular == FALSE)
            return $this->lang->line('tc_rechazadas_title');
        else if ($estado == 3 && $singular = TRUE)
            return $this->lang->line('tc_rechazada_title');

        if ($estado == 4 && $singular == FALSE)
            return $this->lang->line('tc_eliminadas_title');
        else if ($estado == 4 && $singular = TRUE)
            return $this->lang->line('tc_eliminada_title');

        if ($estado == 5 && $singular == FALSE)
            return $this->lang->line('tc_exsols_title');
        else if ($estado == 5 && $singular = TRUE)
            return $this->lang->line('tc_exsol_title');

        if ($estado == 6 && $singular == FALSE)
            return $this->lang->line('tc_exreals_title');
        else if ($estado == 6 && $singular = TRUE)
            return $this->lang->line('tc_exreal_title');

        if ($estado == 7 && $singular == FALSE)
            return $this->lang->line('tc_contestadas_title');
        else if ($estado == 7 && $singular = TRUE)
            return $this->lang->line('tc_contestada_title');
    }

    /**
     * Metodo que llama a un WebService de la PIT con el identificador
     * del paciente para ver los examenes que tenga en esta.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_examenes_get($id_pac, $id_site) {
        $this->data['examenes_pit'] = $this->util->get_pit_ex($id_pac, $id_site);
        $this->index('tc_examenes_pit_view');
    }

    /**
     * Valida al usuario que quiere enviar la TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_valida_usuario($pass) {
        $passval = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($pass));
        if ($passval != FALSE)
            echo 'true';
        else
            echo 'false';
    }

    /**
     * Carga la vista para la creacion de una
     * nueva TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_crear($cache = '') {
        if ($cache == 'true')
            $this->data['flag'] = TRUE;
        else
            $this->data['flag'] = FALSE;
        $this->index('tc_crear_view');
    }

    /**
     * Busca a un paciente por el identificador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_busca_id() {
        $id= $this->input->post('id');
        $resp= $this->input->post('resp');
        if ($id != '' && $this->session->userdata('ROL_ID') > 3)
            $this->data['pacientes'] = $this->platc_model->pacientes_buscar_id($id);
        else
            $this->data['pacientes'] = NULL;
        $data['busqueda'] = $this->data['pacientes'];
        $this->session->set_userdata($data);
        if ($resp == 1)
            $this->index('tc_crear_resultado_busqueda_view');
        else if ($resp == 2)
            $this->index('pacientes_resultado_busqueda_view');
    }

    /**
     * Busca a un paciente por el nombre y/o apellido.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_busca_na() {
        $nombre= $this->input->post('nombre');
        $apellido= $this->input->post('apellido');
        $resp= $this->input->post('resp');
//        $nombre = str_replace('-', '', $nombre);
//        $apellido = str_replace('-', '', $apellido);
        if (is_numeric($nombre))
            $nombre = '';
        if (is_numeric($apellido))
            $apellido = '';
        if (($nombre != '' || $apellido != '') && $this->session->userdata('ROL_ID') > 3)
            $this->data['pacientes'] = $this->platc_model->pacientes_buscar_na($nombre, $apellido);
        else
            $this->data['pacientes'] = NULL;
        $data['busqueda'] = $this->data['pacientes'];
        $this->session->set_userdata($data);
        if ($resp == 1)
            $this->index('tc_crear_resultado_busqueda_view');
        else if ($resp == 2)
            $this->index('pacientes_resultado_busqueda_view');
    }

    /**
     * Carga la vista para la creacion de una TC buscando al
     * paciente o creando uno nuevo.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_crear_pacientes_lista($cache = '') {
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $this->data['pacientes'] = $this->platc_model->pacientes_get();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        if ($cache == 'true')
            $this->data['flag'] = TRUE;
        else
            $this->data['flag'] = FALSE;
        $this->index('tc_crear_pacientes_datagrid_view');
    }

    /**
     * Carga el cache de una busqueda ya hecha.
     *
     * @access public
     * @param none
     * @return none
     */
    public function paciente_busqueda_cache() {
        $this->data['pacientes'] = $this->session->userdata('busqueda');
        $this->index('tc_crear_resultado_busqueda_view');
    }

    /**
     * Carga la vista para la creacion de un paciente y luego
     * la creacion de una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_crear_paciente() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $this->data['annos_select'] = $this->util->select_form_prepare_annos();
        $this->data['meses_select'] = $this->util->select_form_prepare_meses();
        $this->data['dias_select'] = $this->util->select_form_prepare_dias();
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $this->data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
        $afiliaciones = $this->platc_model->site_afiliaciones_get($this->session->userdata('SIT_ID'));
        $this->data['afiliaciones_select'] = $this->util->select_form_prepare($afiliaciones, 'AFI_ID', 'AFI_NOMBRE');
        $this->data['llamado'] = 'tc';
        $this->index('pacientes_agrega_view');
    }

    /**
     * Prepara el select con el lenguaje correspondientes para las prioridades
     * de las TC.
     *
     * @access private
     * @param none
     * @return none
     */
    private function tc_prioridades_select() {
        $this->lang->load($this->session->userdata('IDI_NOMBRE'), $this->session->userdata('IDI_NOMBRE'));
        $prioridades = $this->platc_model->prioridades_get();
        $i = 0;
        foreach ($prioridades as $prioridad) {
            $p[$i]['PRI_ID'] = $prioridad['PRI_ID'];
            $p[$i]['PRI_NOMBRE'] = $this->lang->line('prioridad_' . $prioridad['PRI_ID']);
            $i++;
        }
        return $this->util->select_form_prepare($p, 'PRI_ID', 'PRI_NOMBRE');
    }

    /**
     * Carga la vista para la creacion de una nueva TC segun
     * el ID del paciente recibido por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_nueva($id) {
        $this->data['prioridades_select'] = $this->tc_prioridades_select();
        $especialidades = $this->platc_model->especialidades_por_cliente( $this->session->userdata('CLI_ID') );
        $establecimientos = $this->platc_model->establs_cliente_get($this->session->userdata('CLI_ID'));
        $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE');
        $this->data['establecimiento_select'] = $this->util->select_form_prepare($establecimientos, 'ETB_ID', 'ETB_NOMBRE');
        $this->data['paciente'] = $this->platc_model->paciente_get($id);
        $this->data['paciente']['PAC_EDAD'] = $this->util->yearscalc($this->data['paciente']['PAC_NACIMIENTO']);
        $this->data['identificadores'] = $this->platc_model->ident_get($id);

        // Campos RIPS
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $ent_administradoras = $this->platc_model->entidades_administradoras__con_codigo_get( );
            $this->data['ent_admnistradoras_select'] = $this->util->select_form_prepare( $ent_administradoras, 'ENTADM_ID', 'ENTADM_NOMBRE' );

            $finalidad_procedimiento = $this->platc_model->finalidad_procedimiento_get( );
            $this->data['finalidad_procedimiento_select'] = $this->util->select_form_prepare( $finalidad_procedimiento, 'FINPROC_ID', 'FINPROC_DESCRIPCION' );

            $ambito_procedimiento = $this->platc_model->ambito_procedimiento_get( );
            $this->data['ambito_procedimiento_select'] = $this->util->select_form_prepare( $ambito_procedimiento, 'AMBPROC_ID', 'AMBPROC_DESCRIPCION' );

            $zona_residencia = $this->platc_model->zona_residencia_get( );
            $this->data['zona_residencia_select'] = $this->util->select_form_prepare( $zona_residencia, 'ZON_ID', 'ZON_NOMBRE' );
        }

        $this->index('tc_nueva_view');
    }

    /**
     * Metodo que es llamado para desplegar todas las TC
     * segun el estado que es pasada con la variable $estado.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_datagrid($estado) {
        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->data['teleconsultas'] = $this->platc_model->tc_lista_get($estado);
        $this->index('tc_datagrid_view');
    }

    /**
     * Busca una teleconsulta segun el estado y el id de esta,
     * que son parametros recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_busca_tcid($estado, $id) {
        $id = str_replace('-', '', $id);
        if ($id != '')
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_tcid($id, $estado);
        else
            $this->data['teleconsultas'] = NULL;

        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }

    /**
     * Busca una teleconsulta segun el estado y el id del paciente,
     * que son parametros recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_busca_id($estado, $id = '') {
        $id = str_replace('-', '', $id);
        if ($id != '')
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_id($id, $estado);
        else
            $this->data['teleconsultas'] = NULL;

        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }

    /**
     * Busca una teleconsultas segun nombre y/o apellido del paciente
     * que son parametros recibidos por GET (busca hacer match con los datos).
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_busca_na($estado, $nombre = '', $apellido = '') {
        $nombre = str_replace('-', '', $nombre);
        $apellido = str_replace('-', '', $apellido);
        if (is_numeric($nombre))
            $nombre = '';
        if (is_numeric($apellido))
            $apellido = '';
        if ($nombre != '' || $apellido != '')
            $this->data['teleconsultas'] = $this->platc_model->tc_busca_na( $estado, $nombre, $apellido );
        else
            $this->data['teleconsultas'] = NULL;
        $this->data['metodo'] = $this->tc_metodo_view($estado);
        $this->data['estado'] = $estado;
        $this->index('tc_datagrid_view');
    }

    /**
     * Carga la vista para la visualizaion de las TC
     * que se encuentran en estado "Contestadas".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_contestadas_view($estado = NULL, $id) {
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if ($this->data['estado_exsol'] != NULL) {
            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
            $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
            $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
        } else {
            $this->data['usuario_exsol'] = NULL;
            $this->data['estado_exreal'] = NULL;
            $this->data['usuario_exreal'] = NULL;
        }
        $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
        $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
        $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
        $this->data['mostrar_tcanteriores'] = TRUE;
        $this->index('tc_contestada_view');
    }

    /**
     * Carga la vista para la visualizaion de las TC
     * que se encuentran en estado "Rechazadas".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_rechazadas_view($estado = NULL, $id) {
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['rechazos'] = $this->platc_model->tc_historia($id, (int)3 );
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['estado_rechazada'] = $this->platc_model->tc_estado_get($id, 3);
        $this->data['estado_rechazada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_rechazada']['TEP_FECHA_HORA']);
        $this->data['usuario_rechaza'] = $this->platc_model->usuario_estado_get($this->data['estado_rechazada']['USU_ID']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['mostrar_tcanteriores'] = TRUE;
        $this->index('tc_rechazada_view');
    }

    /**
     * Carga la vista para la visualizaion de una teleconsulta en especifico
     * que se encuentra en estado eliminada, parametros
     * recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_eliminada_view($estado = NULL, $id) {
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if ($this->data['estado_exsol'] != NULL) {
            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
        }
        else
            $this->data['usuario_exsol'] = NULL;
        $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
        if ($this->data['estado_exreal'] != NULL) {
            $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
            $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
        }
        else
            $this->data['usuario_exreal'] = NULL;
        $this->data['estado_rechazada'] = $this->platc_model->tc_estado_get($id, 3);
        if ($this->data['estado_rechazada'] != NULL) {
            $this->data['estado_rechazada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_rechazada']['TEP_FECHA_HORA']);
            $this->data['usuario_rechaza'] = $this->platc_model->usuario_estado_get($this->data['estado_rechazada']['USU_ID']);
        }
        else
            $this->data['usuario_rechaza'] = NULL;
        $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
        if ($this->data['estado_contestada'] != NULL) {
            $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
            $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
        }
        else
            $this->data['usuario_contesta'] = NULL;
        $this->data['estado_eliminada'] = $this->platc_model->tc_estado_get($id, 4);
        $this->data['estado_eliminada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_eliminada']['TEP_FECHA_HORA']);
        $this->data['usuario_elimina'] = $this->platc_model->usuario_estado_get($this->data['estado_eliminada']['USU_ID']);
        $this->data['mostrar_tcanteriores'] = TRUE;
        $this->index('tc_eliminada_view');
    }

    /**
     * Carga la vista para la visualizaicon de una teleconsulta en especifico
     * que se encuentra en estado "Examenes solicitados", parametros
     * recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_exsol_responder($estado = NULL, $id) {
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
        $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
        $this->data['mostrar_tcanteriores'] = TRUE;
        $this->index('tc_exsol_responder_view');
    }

    /**
     * Carga la vista con todas las TC segun el estado de esta,
     * respetando la visibilidad segun rol y site, grupo y/o establecimiento al
     * que pertenece el susuario, parametros recibidos por GET.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_lista($estado) {
        $this->data['estado'] = $estado;
        $this->index('tc_buscador_view');
    }

    /**
     * Recibe los parametros de la teleconsulta que se quiere reponder
     * en estado "Enviada/Nueva", validando los datos cambiandola de estado a
     * "Examnes solicitados" o guardandola segun corresponda al rol o parametros recibidos.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['estadoanterior'] estadoanterior de la TC
     * @param int $_POST['respuesta'] respuesta de la TC
     * @return none
     */
    public function tc_exsol_responde() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('estadoanterior', '', 'required');
        $this->form_validation->set_rules('respuesta', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') > 3) {
            $chk_control = FALSE;
            if ($this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE) {
                    $newpath = $this->path_file['exam_realizados'] . $this->input->post('id') . '/';
                    @mkdir($newpath, 0777, true);
                    $this->dir_move($this->path_file['exam_solicitados'] . $this->input->post('id') . '/', $newpath);
                    $data['EST_ID'] = 6;
                    $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
                    $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
                } else {
                    $data['EST_ID'] = $this->input->post('estadoanterior');
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = $this->input->post('estadoanterior');
            $data['TEL_ID'] = $this->input->post('id');
            $data['TEL_SOL_ADICIONALES_RESP'] = $this->input->post('respuesta');
            if ($this->platc_model->tc_upd($data)) {
                if ($this->input->post('estadoanterior') != $data['EST_ID'])
                    $this->tc_cambio_estado($this->input->post('id'), $data['EST_ID'], NULL, $this->session->userdata('USU_ID'));
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/5/';
                $resp['div'] = 'deploy';
                if ($chk_control == TRUE) {
                    $resp['msgt'] = 'ERROR';
                    $resp['msg'] = $this->lang->line('tc_error_passwd');
                } elseif ($chk_control == FALSE && $data['EST_ID'] == $this->input->post('estadoanterior')) {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_guardada_ok');
                } else {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_enviada_ok');
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Carga la vista para la visualizacion de una TC en estado "Examnes realizados".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_exreal_responder($estado = NULL, $id) {
        $this->data['prioridades_select'] = $this->tc_prioridades_select();
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
        $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
        $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
        $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
        $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
        $this->data['mostrar_tcanteriores'] = TRUE;
        $this->index('tc_exreal_responder_view');
    }

    /**
     * Carga la vista para la visualizacion de una TC en estado "Borrador"
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_borrador_editar($estado = NULL, $id) {

        $establecimientos = $this->platc_model->establs_cliente_get($this->session->userdata('CLI_ID'));
        $this->data['establecimiento_select'] = $this->util->select_form_prepare($establecimientos, 'ETB_ID', 'ETB_NOMBRE');

        $this->data['prioridades_select'] = $this->tc_prioridades_select();
        $especialidades = $this->platc_model->especialidades_por_cliente($this->session->userdata('CLI_ID'));
        $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE');
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);

        // Compatibilidad con version nueva
        $this->data['mostrar_tcanteriores']    = TRUE;
        // Campos RIPS
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $ent_administradoras = $this->platc_model->entidades_administradoras_get( );
            $this->data['ent_admnistradoras_select'] = $this->util->select_form_prepare( $ent_administradoras, 'ENTADM_ID', 'ENTADM_NOMBRE' );

            $finalidad_procedimiento = $this->platc_model->finalidad_procedimiento_get( );
            $this->data['finalidad_procedimiento_select'] = $this->util->select_form_prepare( $finalidad_procedimiento, 'FINPROC_ID', 'FINPROC_DESCRIPCION' );

            $ambito_procedimiento = $this->platc_model->ambito_procedimiento_get( );
            $this->data['ambito_procedimiento_select'] = $this->util->select_form_prepare( $ambito_procedimiento, 'AMBPROC_ID', 'AMBPROC_DESCRIPCION' );

            $zona_residencia = $this->platc_model->zona_residencia_get( );
            $this->data['zona_residencia_select'] = $this->util->select_form_prepare( $zona_residencia, 'ZON_ID', 'ZON_NOMBRE' );
        }

        $this->index('tc_borradores_edita_view');
    }

    /**
     * Recibe los parametros de la TC que se quiere crear dejandola en estado "Enviada/Nuvea"
     * o "Borrador".
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['especialidad'] especialidad de la TC
     * @param string $_POST['motpaciente'] motivo del paciente de la TC
     * @param string $_POST['motinterconsulta'] motivo de la interconsulta de la TC
     * @param string $_POST['resatencion'] resumen de la atencion de la TC
     * @param string $_POST['svpa_sistolica']  de la TC
     * @param string $_POST['svpa_diastolica']  de la TC
     * @param int $_POST['svfc']
     * @param int $_POST['svfr']
     * @param int $_POST['svtemp']
     * @param int $_POST['svsato2']
     * @param int $_POST['svpeso']
     * @param int $_POST['svtalla']
     * @param float $_POST['svimc']
     * @param string $_POST['svimc_clasificacion']
     * @param string $_POST['ayudiagnostica']
     * @param string $_POST['obsadicionales']
     * @param string $_POST['diapresuntivo']
     * @param string $_POST['traactual']
     * @return none
     */
    public function tc_crea() {
        $this->form_validation->set_rules('prioridad', '', 'required');
        $this->form_validation->set_rules('establecimiento', '', 'required');
        $this->form_validation->set_rules('especialidad', '', 'required');
        $this->form_validation->set_rules('motpaciente', '', 'required');
        $this->form_validation->set_rules('mot_tc', '', 'required');
        $this->form_validation->set_rules('resatencion', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') > 3) {
            $chk_control = FALSE;
            if ($this->session->userdata('ROL_ID') == 4 && $this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE)
                    $data['EST_ID'] = 2;
                else {
                    $data['EST_ID'] = 1;
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = 1;
            $data['PAC_ID'] = $this->input->post('idpac');
            $data['SIT_ID'] = $this->session->userdata('SIT_ID');
            $data['ESP_ID'] = $this->input->post('especialidad');
            $data['ETB_ID'] = $this->input->post('establecimiento');
            $data['PRI_ID'] = $this->input->post('prioridad');

            // Campos RIPS
            if( $this->session->userdata('SIT_ID') == 22 ) {
                $data['ENTADM_ID'] = $this->input->post('ent_administradoras');
                $data['FINPROC_ID'] = $this->input->post('finalidad_procedimiento');
                $data['AMBPROC_ID'] = $this->input->post('ambito_procedimiento');
                $data['TEL_CODIGO_AUTORIZACION'] = $this->input->post('codigo_autorizacion');
                $data['ZON_ID'] = $this->input->post('zona_residencia');
                $data['AFI_ID'] = $this->input->post('afi_id');
            } else {
                $data['ENTADM_ID'] = null;
                $data['FINPROC_ID'] = null;
                $data['AMBPROC_ID'] = null;
                $data['TEL_CODIGO_AUTORIZACION'] = null;
                $data['ZON_ID'] = null;
                $data['AFI_ID'] = null;
            }

            $mot=$this->input->post('mot_tc');
            $data['TEL_MOTIVO'] =$mot[0];
            $data['TEL_ANTECEDENTES'] = implode('#/#', $this->input->post('ant_tc'));
            $data['TEL_ANTECEDENTES_DESC'] =  implode('#/#', $this->input->post('tc_ant_desc'));
            $data['TEL_MOT_PACIENTE'] = $this->input->post('motpaciente');
            $data['TEL_MOT_INTERCONSULTA'] = $this->input->post('motinterconsulta');
            $data['TEL_RES_ATENCION'] = $this->input->post('resatencion');
            if ($this->input->post('svpa_sistolica') != '')
                $data['TEL_SV_PA_SISTOLICA'] = $this->input->post('svpa_sistolica');
            if ($this->input->post('svpa_diastolica') != '')
                $data['TEL_SV_PA_DIASTOLICA'] = $this->input->post('svpa_diastolica');
            if ($this->input->post('svfc') != '')
                $data['TEL_SV_FC'] = $this->input->post('svfc');
            if ($this->input->post('svfr') != '')
                $data['TEL_SV_FR'] = $this->input->post('svfr');
            if ($this->input->post('svtemp') != '')
                $data['TEL_SV_TEMP'] = $this->input->post('svtemp');
            if ($this->input->post('svsato2') != '')
                $data['TEL_SV_SATO2'] = $this->input->post('svsato2');
            if ($this->input->post('svpeso') != '')
                $data['TEL_SV_PESO'] = $this->input->post('svpeso');
            if ($this->input->post('svtalla') != '')
                $data['TEL_SV_TALLA'] = $this->input->post('svtalla');
            if ($this->input->post('svimc') != '')
                $data['TEL_SV_IMC'] = $this->input->post('svimc');
            if ($this->input->post('svimc_clasificacion') != '')
                $data['TEL_SV_IMC_CLASIFICACION'] = $this->input->post('svimc_clasificacion');
            if ($this->input->post('ayudiagnostica') != '')
                $data['TEL_AYU_DIAGNOSTICA'] = $this->input->post('ayudiagnostica');
            if ($this->input->post('obsadicionales') != '')
                $data['TEL_OBS_ADICIONALES'] = $this->input->post('obsadicionales');
            if ($this->input->post('diapresuntivo') != '')
                $data['TEL_DIA_PRESUNTIVO'] = $this->input->post('diapresuntivo');
            if ($this->input->post('traactual') != '')
                $data['TEL_TRA_ACTUAL'] = $this->input->post('traactual');
            $data['TEL_PAC_PRIMER_NOMBRE'] = $this->input->post('nombre1');
            $data['TEL_PAC_SEGUNDO_NOMBRE'] = $this->input->post('nombre2');
            $data['TEL_PAC_PRIMER_APELLIDO'] = $this->input->post('apellido1');
            $data['TEL_PAC_SEGUNDO_APELLIDO'] = $this->input->post('apellido2');
            $data['TEL_PAC_NACIMIENTO'] = $this->input->post('nacimiento');
            $data['TEL_PAC_EDAD'] = $this->input->post('edad');
            $data['TEL_PAC_SEXO'] = $this->input->post('sexo');
            $data['TEL_PAC_PROCEDENCIA'] = $this->input->post('procedencia');
            $data['TEL_PAC_OCUPACION'] = $this->input->post('ocupacion');
            $data['TEL_PAC_AFI_NOMBRE'] = $this->input->post('afiliacion');
            $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            $tcid = $this->platc_model->tc_set($data);
            if ($data['EST_ID'] == 1) {
                $newpath = $this->path_file['borradores'] . $tcid . '/';
                @mkdir($newpath, 0777, true);
                $this->dir_move($this->path_file['users'] . $this->session->userdata('USU_ID') . '/', $newpath);
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/1/';
                $resp['div'] = 'deploy';
                if ($chk_control == TRUE) {
                    $resp['msgt'] = 'ERROR';
                    $resp['msg'] = $this->lang->line('tc_error_passwd');
                } else {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_guardada_ok');
                }
            } else if ($data['EST_ID'] == 2) {
                $this->tc_cambio_estado($tcid, 2, $this->input->post('prioridad'), $this->session->userdata('USU_ID'));
                $newpath = $this->path_file['enviadas'] . $tcid . '/';
                @mkdir($newpath, 0777, true);
                $this->dir_move($this->path_file['users'] . $this->session->userdata('USU_ID') . '/', $newpath);
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('tc_enviada_ok');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Guarda los cambios hechos en una TC en estado "Borrador".
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['especialidad'] especialidad de la TC
     * @param string $_POST['motpaciente'] motivo del paciente de la TC
     * @param string $_POST['motinterconsulta'] motivo de la interconsulta de la TC
     * @param string $_POST['resatencion'] resumen de la atencion de la TC
     * @param string $_POST['svpa_sistolica']  de la TC
     * @param string $_POST['svpa_diastolica']  de la TC
     * @param int $_POST['svfc']
     * @param int $_POST['svfr']
     * @param int $_POST['svtemp']
     * @param int $_POST['svsato2']
     * @param int $_POST['svpeso']
     * @param int $_POST['svtalla']
     * @param float $_POST['svimc']
     * @param string $_POST['svimc_clasificacion']
     * @param string $_POST['ayudiagnostica']
     * @param string $_POST['obsadicionales']
     * @param string $_POST['diapresuntivo']
     * @param string $_POST['traactual']
     * @return none
     */
    public function tc_borrador_edita() {

        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('prioridad', '', 'required');
        $this->form_validation->set_rules('especialidad', '', 'required');
        $this->form_validation->set_rules('motpaciente', '', 'required');
        $this->form_validation->set_rules('mot_tc', '', 'required');
        $this->form_validation->set_rules('resatencion', '', 'required');

        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') > 3) {

            $chk_control = FALSE;
            if ($this->session->userdata('ROL_ID') == 4 && $this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE) {
                    $data['EST_ID'] = 2;
                    $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
                } else {
                    $data['EST_ID'] = 1;
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = 1;
            $data['TEL_ID'] = $this->input->post('id');
            $data['ESP_ID'] = $this->input->post('especialidad');
            $data['PRI_ID'] = $this->input->post('prioridad');

            // Campos RIPS
            if( $this->session->userdata('SIT_ID') == 22 ) {
                $data['ENTADM_ID'] = $this->input->post('ent_administradoras');
                $data['FINPROC_ID'] = $this->input->post('finalidad_procedimiento');
                $data['AMBPROC_ID'] = $this->input->post('ambito_procedimiento');
                $data['TEL_CODIGO_AUTORIZACION'] = $this->input->post('codigo_autorizacion');
                $data['ZON_ID'] = $this->input->post('zona_residencia');
            } else {
                $data['ENTADM_ID'] = null;
                $data['FINPROC_ID'] = null;
                $data['AMBPROC_ID'] = null;
                $data['TEL_CODIGO_AUTORIZACION'] = null;
                $data['ZON_ID'] = null;
            }

            $data['TEL_MOT_PACIENTE'] = $this->input->post('motpaciente');
            $data['TEL_MOT_INTERCONSULTA'] = $this->input->post('motinterconsulta');
            $mot=$this->input->post('mot_tc');
            $data['TEL_MOTIVO'] =$mot[0];
             $data['TEL_ANTECEDENTES'] = implode('#/#', $this->input->post('ant_tc'));
            $data['TEL_ANTECEDENTES_DESC'] =  implode('#/#', $this->input->post('tc_ant_desc'));
            $data['TEL_RES_ATENCION'] = $this->input->post('resatencion');
            if ($this->input->post('svpa_sistolica') != '')
                $data['TEL_SV_PA_SISTOLICA'] = $this->input->post('svpa_sistolica');
            if ($this->input->post('svpa_diastolica') != '')
                $data['TEL_SV_PA_DIASTOLICA'] = $this->input->post('svpa_diastolica');
            if ($this->input->post('svfc') != '')
                $data['TEL_SV_FC'] = $this->input->post('svfc');
            if ($this->input->post('svfr') != '')
                $data['TEL_SV_FR'] = $this->input->post('svfr');
            if ($this->input->post('svtemp') != '')
                $data['TEL_SV_TEMP'] = $this->input->post('svtemp');
            if ($this->input->post('svsato2') != '')
                $data['TEL_SV_SATO2'] = $this->input->post('svsato2');
            if ($this->input->post('svpeso') != '')
                $data['TEL_SV_PESO'] = $this->input->post('svpeso');
            if ($this->input->post('svtalla') != '')
                $data['TEL_SV_TALLA'] = $this->input->post('svtalla');
            if ($this->input->post('svimc') != '')
                $data['TEL_SV_IMC'] = $this->input->post('svimc');
            if ($this->input->post('svimc_clasificacion') != '')
                $data['TEL_SV_IMC_CLASIFICACION'] = $this->input->post('svimc_clasificacion');
            if ($this->input->post('ayudiagnostica') != '')
                $data['TEL_AYU_DIAGNOSTICA'] = $this->input->post('ayudiagnostica');
            if ($this->input->post('obsadicionales') != '')
                $data['TEL_OBS_ADICIONALES'] = $this->input->post('obsadicionales');
            if ($this->input->post('diapresuntivo') != '')
                $data['TEL_DIA_PRESUNTIVO'] = $this->input->post('diapresuntivo');
            if ($this->input->post('traactual') != '')
                $data['TEL_TRA_ACTUAL'] = $this->input->post('traactual');
            if ($this->platc_model->tc_upd($data)) {
                if ($data['EST_ID'] == 1) {
                    $resp['action'] = 'true';
                    $resp['method'] = base_url() . 'platc/tc_lista_view/1/';
                    $resp['div'] = 'deploy';
                    if ($chk_control == TRUE) {
                        $resp['msgt'] = 'ERROR';
                        $resp['msg'] = $this->lang->line('tc_error_passwd');
                    } else {
                        $resp['msgt'] = 'OK';
                        $resp['msg'] = $this->lang->line('tc_guardada_ok');
                    }
                } else if ($data['EST_ID'] == 2) {
                    $this->tc_cambio_estado($this->input->post('id'), 2, $this->input->post('prioridad'), $this->session->userdata('USU_ID'));
                    $newpath = $this->path_file['enviadas'] . $data['TEL_ID'] . '/';
                    @mkdir($newpath, 0777, true );
                    $this->dir_move($this->path_file['borradores'] . $data['TEL_ID'] . '/', $newpath);
                    $resp['action'] = 'true';
                    $resp['method'] = base_url() . 'platc/tc_lista_view/2';
                    $resp['div'] = 'deploy';
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_enviada_ok');
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Elimina de forma definitiva una TC que se encuentra en
     * estado borrador.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_borrador_eliminar($id) {
        if ($this->session->userdata('ROL_ID') > 3) {
            if ($this->platc_model->tc_del($id))
                echo 'true';
        }
    }

    /**
     * Carga la vista para la visualizacion de una teleconsulta
     * en estado "Enviada/Nueva".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_enviada_responder($estado = NULL, $id) {
        $this->data['prioridades_select'] = $this->tc_prioridades_select();
//        $especialidades = $this->platc_model->especialidades_site_get($this->session->userdata('SIT_ID'));
//        $this->data['especialidades_select'] = $this->util->select_form_prepare($especialidades, 'ESP_ID', 'ESP_NOMBRE');
        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);

        // Compatibilidad con version nueva
        $this->data['mostrar_tcanteriores']    = TRUE;
        $this->index('tc_enviadas_responder_view');
    }

    /**
     * Recibe los parametros de la edicion de una TC en estado "Enviada/Nueva"
     * segun estos se le cambia el estado segun corresponda o solo se guarda.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['estadoanterior'] estado anterior de la TC
     * @param string $_POST['conespecialista'] concepto del especialista de la TC
     * @return none
     */
    public function tc_enviada_responde() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('prioridad', '', 'required');
        $this->form_validation->set_rules('conespecialista', '', 'required');
        $this->form_validation->set_rules('estadoanterior', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 3) {
            $chk_control = FALSE;
            if ($this->input->post('passwd') != '') {
                $data_user = $this->platc_model->login($this->session->userdata('USU_EMAIL'), md5($this->input->post('passwd')));
                if ($data_user != FALSE) {
                    $data['EST_ID'] = 7;
                    $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
                    $data['TEL_ABIERTA'] = 1;
                    $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
                } else {
                    $data['EST_ID'] = $this->input->post('estadoanterior');
                    $chk_control = TRUE;
                }
            }
            else
                $data['EST_ID'] = $this->input->post('estadoanterior');
            $data['TEL_ID'] = $this->input->post('id');
            $data['PRI_ID'] = $this->input->post('prioridad');
            $data['TEL_CON_ESPECIALISTA'] = $this->input->post('conespecialista');
            $data['TEL_DIA_ESPECIALISTA'] = $this->input->post('diaespecialista');
            $data['TEL_DIA_ORIENTACION'] = $this->input->post('diaorientacion');
            $data['TEL_DIA_FUNDAMENTOS'] = $this->input->post('diafundamentos');
            if ($this->platc_model->tc_upd($data)) {
                if ($this->input->post('estadoanterior') != $data['EST_ID'])
                    $this->tc_cambio_estado($this->input->post('id'), $data['EST_ID'], $this->input->post('prioridad'), $this->session->userdata('USU_ID'));
                $resp['action'] = 'true';
                $resp['div'] = 'deploy';
                if ($this->input->post('estadoanterior') == 6)
                    $resp['method'] = base_url() . 'platc/tc_lista_view/6/';
                else
                    $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                if ($chk_control == TRUE) {
                    $resp['msgt'] = 'ERROR';
                    $resp['msg'] = $this->lang->line('tc_error_passwd');
                } elseif ($chk_control == FALSE && $data['EST_ID'] == $this->input->post('estadoanterior')) {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_guardada_ok');
                } else {
                    $resp['msgt'] = 'OK';
                    $resp['msg'] = $this->lang->line('tc_enviada_ok');
                }
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Pone en estado "Rechazada" a una TC que se encuentra en
     * estado "Enviada/Nueva".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_enviada_rechazar() {
        $id = $this->input->post( 'id' );
        $motivo = $this->input->post( 'motivo', true );

        $tc = $this->platc_model->tc_get($id);
        $data['TEL_ID'] = $id;
        $data['EST_ID'] = 3;
        $data['TEL_ESTADO_ANT'] = $tc['EST_ID'];
        $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
        $this->tc_cambio_estado($id, $data['EST_ID'], $tc['PRI_ID'], $this->session->userdata('USU_ID'), $motivo );
        if ($this->platc_model->tc_upd($data))
            echo 'true';
        else
            echo 'false';
    }

    /**
     * Vuelve la TC de estado "Rechazada" a estado "Enviada/Nueva".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_enviada_rechazar_revertir( ) {
        $id = $this->input->post( 'id' );
        $motivo = $this->input->post( 'motivo', true );

        $data['TEL_ID'] = $id;
        $data['EST_ID'] = 2;
        $data['TEL_ESTADO_ANT'] = 3;
        $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
        $this->tc_cambio_estado($id, 2, NULL, $this->session->userdata('USU_ID'), $motivo );
        if ($this->platc_model->tc_upd($data))
            echo 'true';
        else
            echo 'false';
    }

    /**
     * Pone en estado "Eliminada" a una TC, esta eliminacion es solo un cambio
     * de estado y se puede revertir.
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_eliminar($id) {
        if ($this->session->userdata('ROL_ID') < 3) {
            $tc = $this->platc_model->tc_get($id);
            $data['TEL_ID'] = $id;
            $data['EST_ID'] = 4;
            $data['TEL_ESTADO_ANT'] = $tc['EST_ID'];
            $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            if ($this->platc_model->tc_upd($data)) {
                $this->tc_cambio_estado($id, $data['EST_ID'], NULL, $this->session->userdata('USU_ID'));
                echo 'true';
            }
            else
                echo 'false';
        }
        else
            echo 'false';
    }

    /**
     * Vuelve al estado anterior a una TC que se encuentra en estado
     * "Eliminada".
     *
     * @access public
     * @param none
     * @return none
     */
    public function tc_eliminar_revertir($id) {
        if ($this->session->userdata('ROL_ID') < 3) {
            $tc = $this->platc_model->tc_get($id);
            $data['TEL_ID'] = $id;
            $data['EST_ID'] = $tc['TEL_ESTADO_ANT'];
            $data['TEL_ESTADO_ANT'] = $tc['EST_ID'];
            $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            $this->tc_cambio_estado($id, $data['EST_ID'], $tc['PRI_ID'], $this->session->userdata('USU_ID'));
            if ($this->platc_model->tc_upd($data))
                echo 'true';
            else
                echo 'false';
        }
        else
            echo 'false';
    }

    /**
     * Pone en estado "Exam. Solicitados" a una TC que se encuentra en
     * estado "Enviada/Nueva" guardando en la db las solicitudes hechas por
     * el especialista.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC
     * @param int $_POST['prioridad'] prioridad de la TC
     * @param int $_POST['estadoanterior'] estado anterior de la TC
     * @param string $_POST['soladicionales'] soladicionales de la TC
     * @return none
     */
    public function tc_enviada_solex() {
        $this->form_validation->set_rules('id', '', 'required');
        $this->form_validation->set_rules('prioridad', '', 'required');
        $this->form_validation->set_rules('estadoanterior', '', 'required');
        $this->form_validation->set_rules('soladicionales', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') == 3) {
            $data['TEL_ID'] = $this->input->post('id');
            $data['PRI_ID'] = $this->input->post('prioridad');
            $data['TEL_SOL_ADICIONALES'] = $this->input->post('soladicionales');
            $data['EST_ID'] = 5;
            $data['TEL_ESTADO_ANT'] = $this->input->post('estadoanterior');
            $data['TEL_FECHA_HORA'] = date('Y-m-d') . " " . date('H:i:s');
            if ($this->platc_model->tc_upd($data)) {
                $this->tc_cambio_estado($this->input->post('id'), $data['EST_ID'], $this->input->post('prioridad'), $this->session->userdata('USU_ID'));
                $resp['action'] = 'true';
                $resp['method'] = base_url() . 'platc/tc_lista_view/2/';
                $resp['div'] = 'deploy';
                $resp['msgt'] = 'OK';
                $resp['msg'] = $this->lang->line('tc_enviada_ok');
            } else {
                $resp['action'] = 'false';
                $resp['msgt'] = 'ERROR';
                $resp['msg'] = $this->lang->line('tc_error');
            }
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Deja un registro del cambio de estado de la TC.
     *
     * @access private
     * @param none
     * @return none
     */
    private function tc_cambio_estado($telid, $estid, $priid, $usuid, $comentario = null) {
        $data['TEL_ID'] = $telid;
        $data['EST_ID'] = $estid;
        $data['PRI_ID'] = $priid;
        $data['USU_ID'] = $usuid;
        $data['TEP_COMENTARIO'] = $comentario;
        $this->platc_model->tc_estado_set($data);
    }

    public function tc_ver( $id, $mostrar_tcanteriores = TRUE ) {

        //
        $this->data['tc']               = $this->platc_model->tc_get($id);
        $this->data['etb']              = $this->platc_model->establecimiento_get( $this->data['tc']['ETB_ID'] );
        $this->data['identificadores']  = $this->platc_model->tc_ident_get($id);

        //
        $this->data['estado_enviada']   = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia']    = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);

        //
        $this->data['prioridades_select'] = $this->tc_prioridades_select();

        // Solicitud información adicional
        $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
        if( !empty( $this->data['estado_exsol'] ) ) {
            $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
            $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
        }

        // Solicitud información adicional
        $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
        if( !empty( $this->data['estado_exreal'] ) ) {
            $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
            $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
        }

        // Contestado
        $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
        if( !empty( $this->data['estado_contestada'] ) ) {
            $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
            $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
        }

        $this->data['mostrar_tcanteriores']    = ( $mostrar_tcanteriores === TRUE ) ? TRUE : FALSE;
        $this->load->view( 'tc_ver_view', $this->data );
    }

    /**
     * Guarda en BD la evaluación del médico Generalista a la respuesta de la TC
     * otorgado por el especialista.
     * @param int $tel_id Identificador de la TC
     * @param string $texto_evaluacion Texto de la evaluación escrito por el generalista
     * @param int $nota_evaluacion Calificación (del 1 al 5) de la respuesta de la TC
     */
    public function tc_guardar_evaluacion( ) {

        $tel_id             = $this->input->post( 'tel_id' );
        $texto_evaluacion   = $this->input->post( 'texto_evaluacion' );
        $nota_evaluacion    = $this->input->post( 'nota_evaluacion' );
        $estado = $this->platc_model->tc_guardar_evaluacion( $tel_id, $texto_evaluacion, $nota_evaluacion );

        if( !empty( $estado ) )
            echo json_encode( array( 'error' => '0' , 'msg' => $this->lang->line( 'tc_evaluacion_cambio_satisfactorio' ) ) );
        else
            echo json_encode( array( 'error' => '1' , 'msg' => $this->lang->line( 'tc_evaluacion_cambio_fallido' ) ) );
    }

    /**
     * Genera el select de los Grupos de un Site.
     *
     * @access public
     * @param none
     * @return none
     */
    public function grupos_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->grupos_site_get($_POST['id']);
        if ($first != FALSE && $first != 'Todos')
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['GRU_ID'])
                echo '<option  selected="selected" value="' . $r['GRU_ID'] . '">' . $r['GRU_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['GRU_ID'] . '">' . $r['GRU_NOMBRE'] . '</option>';
        }
    }

    /**
     * Genera el select de las especialidades de un Site.
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_combobox($first) {
        $q = $this->platc_model->especialidades_site_get($_POST['id']);
        echo '<option value="0">' . $first . '</option>';
        foreach ($q as $r)
            echo '<option value="' . $r['ESP_ID'] . '">' . $r['ESP_NOMBRE'] . '</option>';
    }

    /**
     * Genera el select de las especialidades de un Site.
     * Usado en Búsqueda de TC
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_por_cliente( ) {

        $id_cliente = $this->input->post( 'id' );
        $q = $this->platc_model->especialidades_por_cliente( $id_cliente );
        $q = $this->util->select_form_prepare( $q, 'ESP_ID', 'ESP_NOMBRE' );

        $especialidades = $this->util->select_form_prepare( $this->data['usuario_especialidades'], 'ESP_ID', 'ESP_NOMBRE' );

        foreach ( $q as $k => $v ) {

            // Lógica especial para Especialista (rol=3): Retorna especialidades del cliente
            // que están también en su especialidad. Este if salta iteración si no encuentra
            // especialidades del cliente que coincida con alguno de las especialidades del usuario
            // en sesión.
            if( $this->session->userdata( 'ROL_ID' ) == 3 && !array_key_exists( $k, $especialidades ) )
                continue;

            echo '<option value="' . $k . '">' . $v . '</option>';
        }
    }

    /**
     * Genera el select de las especialidades a las que un usuario tiene acceso según
     * su configuración de grupos. Lógica usada para usuarios a los que se le
     * asocien grupos como Supervisores y Especialistas
     *
     * @access public
     * @param none
     * @return none
     */
    public function especialidades_por_usuario( ) {

        $id_usuario = $this->input->post( 'id' );

        $q = $this->platc_model->especialidades_por_usuario( $id_usuario );
        $q = $this->util->select_form_prepare( $q, 'ESP_ID', 'ESP_NOMBRE' );
        foreach ( $q as $k => $v )
            echo '<option value="' . $k . '">' . $v . '</option>';
    }

    /**
     * Genera el select de los Clientes de un Grupos.
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->clientes_grupo_get($_POST['id']);
        if ($first != FALSE && $first != 'Todos')
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['CLI_ID'])
                echo '<option  selected="selected" value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
        }
    }

    /**
     * Genera el select de los Clientes según Site
     *
     * @access public
     * @param none
     * @return none
     */
    public function clientes_combobox_por_site( $default = '', $first = FALSE ) {

        $id_site = $this->input->post('id');

        $q = $this->platc_model->clientes_get( $id_site );
        if ($first != FALSE && $first != 'Todos')
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';

        if( !empty( $q ) )
            foreach ($q as $r) {
                if ($default == $r['CLI_ID'])
                    echo '<option  selected="selected" value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
                else
                    echo '<option value="' . $r['CLI_ID'] . '">' . $r['CLI_NOMBRE'] . '</option>';
            }
    }

    /**
     * Genera el select de los Establecimientos de un Cliente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function establs_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->establs_cliente_get($_POST['id']);
        if ($first != FALSE)
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['ETB_ID'])
                echo '<option  selected="selected" value="' . $r['ETB_ID'] . '">' . $r['ETB_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['ETB_ID'] . '">' . $r['ETB_NOMBRE'] . '</option>';
        }
    }

    /**
     * Genera el select de los Especialistas de una Especialidad.
     *
     * @deprecated Especialistas se asocian a grupos usando mantenedor grupos
     * Por lo que no tiene sentido mostrar un combo que permita la selección
     * de un elemento en particular
     * @access public
     * @param none
     * @return none
     */
    public function especialistas_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->especialistas_especialidad_get($_POST['id']);
        if ($first != FALSE)
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['USU_ID'])
                echo '<option  selected="selected" value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
        }
    }

    /**
     * Setea variables de session con parametros del autcomplete de la busqueda.
     *
     * @access public
     * @param none
     * @return none
     */
    public function autocomplete_select($tipo, $id = NULL) {
        if ($tipo == 'especialidad')
            $data['autocomplete_especialidad'] = $id;
        else if ($tipo == 'cliente')
            $data['autocomplete_cliente'] = $id;
        else if ($tipo == 'establ')
            $data['autocomplete_establ'] = $id;
        $this->session->set_userdata($data);
    }

    /**
     * Genera el select de los Generalistas (medicos y no medicos) de una Establecimiento.
     *
     * @access public
     * @param none
     * @return none
     */
    public function generalistas_combobox($default = '', $first = FALSE) {
        $q = $this->platc_model->generalistas_establecimiento_get($_POST['id']);
        if ($first != FALSE)
            echo '<option value="0">' . $first . '</option>';
        else
            echo '<option></option>';
        foreach ($q as $r) {
            if ($default == $r['USU_ID'])
                echo '<option  selected="selected" value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
            else
                echo '<option value="' . $r['USU_ID'] . '">' . $r['USU_NOMBRE'] . '</option>';
        }
    }

    /**
     * Agrega comentarios al archivo(s) adjuntadado(s) a la TC.
     *
     * @access public
     * @param int $_POST['tipo'] tipo de archivo
     * @param int $_POST['file'] nombre del archivo
     * @param int $_POST['comment'] comentario del archivo
     * @return none
     */
    public function attach_file_comment($tipo, $id) {
        $this->form_validation->set_rules('file', '', 'required');
        if ($this->form_validation->run() != FALSE && $this->session->userdata('ROL_ID') > 2) {
            $file = $this->input->post('file');
            if ($tipo == 1)
                $filecom = $this->path_file['users'] . $id . '/' . $file . '.comment';
            else if ($tipo == 2)
                $filecom = $this->path_file['borradores'] . $id . '/' . $file . '.comment';
            else if ($tipo == 4)
                $filecom = $this->path_file['exam_solicitados'] . $id . '/' . $file . '.comment';
            else if ($tipo == 6)
                $filecom = $this->path_file['sol_adicional'] . $id . '/' . $file . '.comment';
            @unlink($filecom);
            $f = fopen($filecom, 'a+');
            if ($this->input->post('comment') == '')
                $comment = $this->lang->line('sin_comentario');
            else
                $comment = $this->input->post('comment');
            fwrite($f, $comment);
            fclose($f);
            $resp['action'] = 'false';
            $resp['msgt'] = 'OK';
            $resp['msg'] = $this->lang->line('ok_comentario') . ' ' . $file;
            echo json_encode($resp);
        }
    }

    /**
     * Elimina algun archivo subido al servidor antes de que se envie la TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function attach_file_drop($tipo = NULL, $id = NULL, $file = NULL, $user = NULL) {
        $file=str_replace('oooooo','.', $file);
        if ($tipo != NULL && is_numeric($tipo) && $id != NULL && is_numeric($id) && $file != NULL) {
            if ($tipo == 1)
                $delfile = $this->path_file['users'] . $id . '/' . $file;
            else if ($tipo == 2)
                $delfile = $this->path_file['borradores'] . $id . '/' . $file;
            else if ($tipo == 4)
                $delfile = $this->path_file['exam_solicitados'] . $id . '/' . $file;
            else if ($tipo == 6)
                $delfile = $this->path_file['sol_adicional'] . $id . '/' . $file;

            @unlink($delfile);
            $this->attach_file($tipo, $id, $user);
        }
    }

    /**
     * Muestra los archivos atachados a una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function attach_file($tipo = NULL, $id = NULL, $user = NULL) {
        if ($user != NULL && is_numeric($user)) {
            $data_user = $this->platc_model->data_user($user);
            if ($data_user != FALSE) {
                $data_user['logged_in'] = TRUE;
                $this->session->set_session($data_user);
            }
        }
        if ($tipo != NULL && is_numeric($tipo) && $id != NULL && is_numeric($id)) {
            if ($tipo == 1)
                $dir = $this->path_file['users'] . $id . '/';
            else if ($tipo == 2)
                $dir = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 3)
                $dir = $this->path_file['enviadas'] . $id . '/';
            else if ($tipo == 4)
                $dir = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 5)
                $dir = $this->path_file['exam_realizados'] . $id . '/';
            else if ($tipo == 6)
                $dir = $this->path_file['sol_adicional'] . $id . '/';
//            else
//                break;
				            $this->data['archivos'] = NULL;
            $this->data['folder'] = $dir;
            $this->data['tipo'] = $tipo;
            $this->data['id'] = $id;
            if (is_dir($dir)) {
                $directorio = opendir($dir);
                while ($archivo = readdir($directorio)) {
					$archivo= str_replace("Ñ","N",$archivo);
                    if ($archivo != "." && $archivo != ".." && substr($archivo, -8) != ".comment") {
                        $archivos[] = $archivo;
                        if (is_file($dir . $archivo . ".comment"))
                            $archivo_comment[] = $this->util->lee_archivo($dir . $archivo . ".comment");
                        else
                            $archivo_comment[] = $this->lang->line('sin_comentario');
                    }
                }
                if (isset($archivos)) {
//					ksort ($archivos);
                    $i = 0;
                    foreach ($archivos as $archivo) {
                        $this->data['archivos'][] = $archivo;
                        $this->data['archivo_comment'][] = $archivo_comment[$i];
                        $i++;
                    }
                }
            }
//imprimir( $this->data );
            $this->index('attach_files_view');
        }
    }

    /**
     * Metodo que genera arreglo con todos los archivos atachados de una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function attach_file_arr($tipo = NULL, $id = NULL) {
        $archivos = NULL;
        if ($id != NULL && is_numeric($id)) {
            if ($tipo == 1)
                $dir = $this->path_file['users'] . $id . '/';
            else if ($tipo == 2)
                $dir = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 3)
                $dir = $this->path_file['enviadas'] . $id . '/';
            else if ($tipo == 4)
                $dir = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 5)
                $dir = $this->path_file['exam_realizados'] . $id . '/';
            else if ($tipo == 6)
                $dir = $this->path_file['sol_adicional'] . $id . '/';
//            else
//                break;
            $this->data['archivos'] = NULL;
            $this->data['folder'] = $dir;
            $this->data['id'] = $id;
            if (is_dir($dir)) {
                $directorio = opendir($dir);
                while ($archivo = readdir($directorio)) {
                    if ($archivo != "." && $archivo != ".." && substr($archivo, -8) != ".comment")
                        $archivos[] = $archivo;
                }
            }
            return $archivos;
        }
    }

    /**
     * Mueve el contenido de un directorio a otro, dependiendo del
     * estado de la TC.
     *
     * @access private
     * @param none
     * @return none
     */
    private function dir_move($dir1, $dir2) {
        if (is_dir($dir1) && is_dir($dir2)) {
            $directorio = opendir($dir1);
            while ($archivo = readdir($directorio)) {
                if ($archivo != "." && $archivo != "..") {
                    @copy($dir1 . $archivo, $dir2 . $archivo);
                    @unlink($dir1 . $archivo);
                }
            }
            @rmdir($dir1);
        }
    }

    /**
     * Sube al servidor un archivo, esto para adjuntarlo
     * a una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function upload_file($tipo = NULL, $id = NULL) {
        if (!empty($_FILES)) {
            if ($tipo == 1)
                $dir = $this->path_file['users'] . $id . '/';
            else if ($tipo == 2)
                $dir = $this->path_file['borradores'] . $id . '/';
            else if ($tipo == 4)
                $dir = $this->path_file['exam_solicitados'] . $id . '/';
            else if ($tipo == 6)
                $dir = $this->path_file['sol_adicional'] . $id . '/';
//            else
//                break;
            if (!is_dir($dir))
                mkdir(str_replace('//', '/', $dir), 0755, true);
            $temp_file = $_FILES['Filedata']['tmp_name'];
            $name_file = $this->util->quitar_acentos($_FILES['Filedata']['name']);
            $name_file = str_replace(' ', '_', $name_file);
            $name_file = str_replace('(', '-', $name_file);
            $name_file = str_replace(')', '-', $name_file);
			$name_file = str_replace('Ñ', 'N', $name_file);
			$name_file = str_replace('ñ', 'n', $name_file);
            $dir = str_replace('//', '/', $dir);
            $target_file = $dir . $name_file;
            $ext[] = 'doc';
            $ext[] = 'docx';
            $ext[] = 'xls';
            $ext[] = 'xlsx';
            $ext[] = 'pdf';
            $ext[] = 'jpg';
            $ext[] = 'gif';
            $ext[] = 'png';
            $ext[] = 'bmp';
            $ext[] = 'tiff';
            $ext[] = 'rtf';
            $ext[] = 'rar';
            $ext[] = 'zip';
            $ext[] = '7z';
            $ext[] = 'tar';
            $ext[] = 'tgz';
            $ext_file = explode('.', $name_file);
            $resp = 0;
            $large = count($ext_file);
            foreach ($ext as $e) {
                if ($e == strtolower($ext_file[$large - 1]))
                    $resp = 1;
            }
            if ($resp == 1) {
                $i = 1;
                while (is_file($target_file)) {
                    $name_file = '';
                    for ($j = 0; $j < $large - 1; $j++) {
                        $name_file .= $ext_file[$j] . '.';
                    }
                    $target_file = $dir . $name_file . $i . '.' . $ext_file[$large - 1];
                    $i++;
                }
                move_uploaded_file($temp_file, $target_file);
            }
            echo $resp;
        }
    }

    /**
     * Metodo que exporta una TC a PDF.
     * a una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function exportar_pdf( $id ) {

        $datos = $this->tc_pdf( $id );
        $this->load->library('tc_fpdf20', 'P', 'mm', 'Letter' );

        $pdf = new TC_FPDF20( );
        $pdf->establecer_imagen_cliente($datos);
        $pdf->establecer_datos_solicitud($datos);
        $pdf->establecer_datos_paciente($datos);
        $pdf->establecer_datos_episodio($datos);

        // Datos de la solicitud /respuesta de la solicitud
        if (!empty($datos['tc']['TEL_SOL_ADICIONALES'])) {

            $pdf->establecer_datos_solicitud_info_examen($datos);

            if ($datos['tc']['TEL_SOL_ADICIONALES_RESP'] != NULL && $datos['tc']['EST_ID'] > 5)
                $pdf->establecer_datos_solicitud_respuesta($datos);
        }

        if ($datos['tc']['EST_ID'] == 7) {

            $pdf->establecer_datos_respuesta_especialista($datos);
        }

        $pdf->AliasNbPages();
        $pdf->Output();
    }

    /**
     * Carga la vista que luego es tomada para generar el PDF.
     *
     * @access private
     * @param none
     * @return none
     */
    private function tc_pdf( $id ) {

        $this->data['tc'] = $this->platc_model->tc_get($id);
        $this->data['tc']['TEL_MOTIVO_TEXTO'] = $this->lang->line( 'tc_mot_'.$this->data['tc']['TEL_MOTIVO'] );
        $this->data['tc']['TEL_FECHA_HORA'] = $this->util->fecha_orden2($this->data['tc']['TEL_FECHA_HORA']);
        $this->data['etb'] = $this->platc_model->establecimiento_get($this->data['tc']['ETB_ID']);
        $this->data['estado_enviada'] = $this->platc_model->tc_estado_get($id, 2);
        $this->data['estado_enviada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_enviada']['TEP_FECHA_HORA']);
        $this->data['usuario_envia'] = $this->platc_model->usuario_estado_get($this->data['estado_enviada']['USU_ID']);
        $this->data['file3'] = $this->attach_file_arr(3, $id);
        if ($this->data['tc']['EST_ID'] >= 5 && $this->data['tc']['EST_ID'] <= 7) {
            if ($this->data['tc']['TEL_SOL_ADICIONALES'] != NULL) {
                $this->data['estado_exsol'] = $this->platc_model->tc_estado_get($id, 5);
                $this->data['estado_exsol']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exsol']['TEP_FECHA_HORA']);
                $this->data['usuario_exsol'] = $this->platc_model->usuario_estado_get($this->data['estado_exsol']['USU_ID']);
            }
            if ($this->data['tc']['TEL_SOL_ADICIONALES_RESP'] != NULL) {
                $this->data['file5'] = $this->attach_file_arr(5, $id);
                $this->data['estado_exreal'] = $this->platc_model->tc_estado_get($id, 6);
                $this->data['estado_exreal']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_exreal']['TEP_FECHA_HORA']);
                $this->data['usuario_exreal'] = $this->platc_model->usuario_estado_get($this->data['estado_exreal']['USU_ID']);
            }
            if ($this->data['tc']['EST_ID'] == 7) {
                $this->data['estado_contestada'] = $this->platc_model->tc_estado_get($id, 7);
                $this->data['estado_contestada']['TEP_FECHA_HORA'] = $this->util->fecha_orden2($this->data['estado_contestada']['TEP_FECHA_HORA']);
                $this->data['usuario_contesta'] = $this->platc_model->usuario_estado_get($this->data['estado_contestada']['USU_ID']);
            }
        }
        $this->data['identificadores'] = $this->platc_model->tc_ident_get($id);
        $this->data['estado'] = $this->data['tc']['EST_ID'];

        return $this->data;
    }

    /**
     * Busca una TC segun el id de esta, esto para la vista de busqueda de TC.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['id'] ID de la TC que se esta buscando
     * @return none
     */
    public function buscar_tc_id() {
        $this->form_validation->set_rules('tcid', '', 'required');
        if ($this->form_validation->run() != FALSE) {
            $resp['action'] = 'true';
            $resp['method'] = base_url() . 'platc/busqueda_tcid_datagrid/' . $this->input->post('tcid') . '/';
            $resp['div'] = 'deploy_search_tc';
            $resp['msgt'] = 'false';
            $resp['msg'] = 'false';
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Muestra el resultado de la busqueda por ID de una TC.
     *
     * @access public
     * @param none
     * @return none
     */
    public function busqueda_tcid_datagrid($id) {
        $this->data['teleconsultas'] = $this->platc_model->busca_tcid($id);
        if ($this->data['teleconsultas'] != NULL) {
            $r['identificador'] = $this->platc_model->tc_ident_get($id);
            $this->data['teleconsultas'][0]['identificador'] = $r['identificador'][0];
            $this->data['teleconsultas'][0]['enviada'] = $this->platc_model->busca_tc_estado($id, 2);
            $this->data['teleconsultas'][0]['exsol'] = $this->platc_model->busca_tc_estado($id, 5);
            $this->data['teleconsultas'][0]['contestada'] = $this->platc_model->busca_tc_estado($id, 7);
            if ($this->session->userdata('ROL_ID') < 3) {
                $data['cliente'] = 0;
                $data['establ'] = 0;
                $data['generalista'] = 0;
                $data['especialidad'] = 0;
                $data['especialista1'] = 0;
                $data['especialista2'] = 0;
                $data['estado'] = 0;
                $data['fecha_env_desde'] = 0;
                $data['fecha_env_hasta'] = 0;
                $data['fecha_con_desde'] = 0;
                $data['fecha_con_hasta'] = 0;
                $this->data['rep_id'] = $this->guarda_reporte($data, $this->data['teleconsultas'], 'Todas', 'Todas', 'Todas', 'Todas');
            }
            else
                $this->data['rep_id'] = NULL;
        }
        $this->session->set_userdata($this->data);
        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Metodo que recibe los datos para la busqueda de TC,
     * los valida y busca.
     * El metodo es llamado a traves de javascript
     * por lo que la respuesta no es enviada con "return"
     * sino que encodeando a json el array $resp que contiene el mensaje
     * y el metodo a cargar y donde hacerlo segun los resultados.
     *
     * @access public
     * @param int $_POST['site'] site para la busqueda
     * @param int $_POST['grupo'] grupo para la busqueda
     * @param int $_POST['cliente'] cliente para la busqueda
     * @param int $_POST['especialidad'] especialidad para la busqueda
     * @param int $_POST['estado'] estado para la busqueda
     * @param string $_POST['generalista'] estado para la busqueda
     * @param string $_POST['especialista1'] especialista que solicito examenes adicionales
     * @param string $_POST['especialista2'] especialista que contesto
     * @return none
     */
    public function buscar_tc() {
        if ($this->session->userdata('ROL_ID') == 1) {
            $this->form_validation->set_rules('grupo', '', 'required');
        }
        if ($this->session->userdata('ROL_ID') > 4)
//            $this->form_validation->set_rules('cliente', '', 'required');
            $this->form_validation->set_rules('establ', '', 'required');
        $this->form_validation->set_rules('estado', '', 'required');
        if ($this->form_validation->run() != FALSE) {
            if ($this->session->userdata('ROL_ID') < 4)
                $c = $this->input->post('cliente');
            else
                $c = 0;
            $e = $this->input->post('establ');
            $e = !empty( $e ) ? $e : 0;
            if ($this->input->post('generalista') != '') {
                $gen = $this->platc_model->usuario_busca_get($this->input->post('generalista'));
                if ($gen != NULL)
                    $g = $gen['USU_ID'];
                else
                    $g = 0;
            }
            else
                $g = 0;
            $es = $this->input->post('especialidad');
            $es = empty( $es ) ? 0 : $es;
            if ($this->input->post('especialista1') != '') {
                $esp1 = $this->platc_model->usuario_busca_get($this->input->post('especialista1'));
                if ($esp1 != NULL)
                    $es1 = $esp1['USU_ID'];
                else
                    $es1 = 0;
            }
            else
                $es1 = 0;
            if ($this->input->post('especialista2') != '') {
                $esp2 = $this->platc_model->usuario_busca_get($this->input->post('especialista2'));
                if ($esp2 != NULL)
                    $es2 = $esp2['USU_ID'];
                else
                    $es2 = 0;
            }
            else
                $es2 = 0;
            $est = $this->input->post('estado');
            if ($this->input->post('fecha_env_desde') != '' && $this->input->post('fecha_env_hasta') != '') {
                $f = explode('/', $this->input->post('fecha_env_desde'));
                $fenv_des = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha1 = str_replace('/', '-', $this->input->post('fecha_env_desde'));
                $f = explode('/', $this->input->post('fecha_env_hasta'));
                $fenv_has = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha2 = str_replace('/', '-', $this->input->post('fecha_env_hasta'));
            } else {
                $fenv_des = 0;
                $fecha1 = 'Todas';
                $fenv_has = 0;
                $fecha2 = 'Todas';
            }
            if ($this->input->post('fecha_con_desde') != '' && $this->input->post('fecha_con_hasta') != '') {
                $f = explode('/', $this->input->post('fecha_con_desde'));
                $fcon_des = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha3 = str_replace('/', '-', $this->input->post('fecha_con_desde'));
                $f = explode('/', $this->input->post('fecha_con_hasta'));
                $fcon_has = $f[2] . '-' . $f[1] . '-' . $f[0];
                $fecha4 = str_replace('/', '-', $this->input->post('fecha_con_hasta'));
            } else {
                $fcon_des = 0;
                $fecha3 = 'Todas';
                $fcon_has = 0;
                $fecha4 = 'Todas';
            }
            $resp['action'] = 'true';
            $resp['method'] = base_url() . 'platc/busqueda_tc_datagrid/' . $c . '/' . $e . '/' . $g . '/' . $es . '/' . $es1 . '/' . $es2 . '/' . $est . '/' . $fenv_des . '/' . $fenv_has . '/' . $fcon_des . '/' . $fcon_has . '/' . $fecha1 . '/' . $fecha2 . '/' . $fecha3 . '/' . $fecha4 . '/';
            $resp['div'] = 'deploy_search_tc';
            $resp['msgt'] = 'false';
            $resp['msg'] = 'false';
        } else {
            $resp['action'] = 'false';
            $resp['msgt'] = 'ERROR';
            $resp['msg'] = $this->lang->line('complete_campos');
        }
        echo json_encode($resp);
    }

    /**
     * Busca las TC segun parametros recibidos por GET, ademas prepara los datos
     * para guardar el reporte que luego se podra exportar a PDF o Excel segun corresponda al rol.
     *
     * @access public
     * @param none
     * @return none
     */
    public function busqueda_tc_datagrid($c, $e, $g, $es, $es1, $es2, $est, $fenv_des, $fenv_has, $fcon_des, $fcon_has, $fecha1, $fecha2, $fecha3, $fecha4) {
        $data['cliente'] = $c;
        $data['establ'] = $e;
        $data['generalista'] = $g;
        $data['especialidad'] = $es;
        $data['especialista1'] = $es1;
        $data['especialista2'] = $es2;
        $data['estado'] = $est;
        $data['fecha_env_desde'] = $fenv_des;
        $data['fecha_env_hasta'] = $fenv_has;
        $data['fecha_con_desde'] = $fcon_des;
        $data['fecha_con_hasta'] = $fcon_has;
        $this->data['teleconsultas'] = $this->platc_model->buscar_tc_b($data);
        if ($this->data['teleconsultas'] != NULL) {
            $i = 0;
            foreach ($this->data['teleconsultas'] as $tc) {
                $r['identificador'] = $this->platc_model->tc_ident_get($tc['TEL_ID']);
                $this->data['teleconsultas'][$i]['identificador'] = $r['identificador'][0];
                $this->data['teleconsultas'][$i]['enviada'] = $this->platc_model->busca_tc_estado($tc['TEL_ID'], 2);
                $this->data['teleconsultas'][$i]['exsol'] = $this->platc_model->busca_tc_estado($tc['TEL_ID'], 5);
                $this->data['teleconsultas'][$i]['contestada'] = $this->platc_model->busca_tc_estado($tc['TEL_ID'], 7);
                $i++;
            }
            if ($this->session->userdata('ROL_ID') < 3)
                $this->data['rep_id'] = $this->guarda_reporte($data, $this->data['teleconsultas'], $fecha1, $fecha2, $fecha3, $fecha4);
            else
                $this->data['rep_id'] = NULL;
        }
        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Recibe los parametros de la busqueda para preparar los datos para
     * guardar el reporte que luego podra ser exportado a PDF o Excel.
     *
     * @access private
     * @param none
     * @return none
     */
    private function guarda_reporte($data_report, $teleconsultas, $fecha1, $fecha2, $fecha3, $fecha4) {
        $data['USU_ID'] = $this->session->userdata('USU_ID');
        $data['REP_SITE'] = $this->session->userdata('SIT_NOMBRE');
        $data['REP_GRUPO'] = $this->session->userdata('GRU_NOMBRE');
        if ($data_report['cliente'] != 0) {
            $dat = $this->platc_model->cliente_get($data_report['cliente']);
            $data['REP_CLIENTES'] = $dat['CLI_NOMBRE'];
            $data['REP_CLIENTES'] = 'Todos';
        }
        else
            $data['REP_CLIENTES'] = 'Todos';
        if ($data_report['establ'] != 0) {
            $dat = $this->platc_model->establecimiento_get($data_report['establ']);
            $data['REP_ESTABLECIMIENTO'] = $dat['ETB_NOMBRE'];
            $data['REP_ESTABLECIMIENTO'] = 'Todos';
        }
        else
            $data['REP_ESTABLECIMIENTO'] = 'Todos';
        $data['REP_FECHA_CONTESTADA_DESDE'] = $fecha1;
        $data['REP_FECHA_CONTESTADA_HASTA'] = $fecha2;
        $data['REP_FECHA_ENVIADA_DESDE'] = $fecha3;
        $data['REP_FECHA_ENVIADA_HASTA'] = $fecha4;
        $data['REP_TOTAL'] = count($teleconsultas);
        if ($data_report['estado'] != 0)
            $data['REP_ESTADO'] = $this->lang->line('estado_' . $data_report['estado']);
        else
            $data['REP_ESTADO'] = 'Todos';
        if ($data_report['especialidad'] != 0) {
            $dat = $this->platc_model->especialidad_get($data_report['especialidad']);
            $data['REP_ESPECIALIDAD'] = $dat['ESP_NOMBRE'];
        }
        else
            $data['REP_ESPECIALIDAD'] = 'Todas';
        if ($data_report['especialista1'] != 0) {
            $dat = $this->platc_model->usuario_get($data_report['especialista1']);
            $data['REP_ESPECIALISTA_EXSOL'] = $dat['USU_NOMBRE'];
        }
        else
            $data['REP_ESPECIALISTA_EXSOL'] = 'Todos';
        if ($data_report['especialista2'] != 0) {
            $dat = $this->platc_model->usuario_get($data_report['especialista2']);
            $data['REP_ESPECIALISTA_CONTESTADA'] = $dat['USU_NOMBRE'];
        }
        else
            $data['REP_ESPECIALISTA_CONTESTADA'] = 'Todos';
        $rep_id = $this->platc_model->reporte_set($data);
        if (isset($rep_id) && is_numeric($rep_id)) {
            foreach ($teleconsultas as $tc) {
                $data2['REP_ID'] = $rep_id;
                $data2['RED_TC_ID'] = $tc['TEL_ID'];
                $data2['RED_EST_ID'] = $tc['EST_ID'];
                $data2['RED_PAC_IDENTIFICADOR'] = $tc['identificador']['TCI_VALOR'];
                $data2['RED_PAC_NOMBRE_APELLIDO'] = $tc['TEL_PAC_PRIMER_NOMBRE'] . ' ' . $tc['TEL_PAC_PRIMER_APELLIDO'];
                $data2['RED_ESTABLECIMIENTO'] = $tc['ETB_NOMBRE'];
                $data2['RED_FECHA_ENVIO'] = $tc['enviada']['TEP_FECHA_HORA'];
                $data2['RED_ESPECIALIDAD'] = $tc['ESP_NOMBRE'];
                $data2['RED_FECHA_EXSOL'] = $tc['exsol']['TEP_FECHA_HORA'];
                $data2['RED_FECHA_CONTESTADA'] = $tc['contestada']['TEP_FECHA_HORA'];
                $data2['RED_ESPECIALISTA_CONTESTO'] = $tc['contestada']['USU_NOMBRE'];
                $this->platc_model->reporte_detalle_set($data2);
            }
        }
        return $rep_id;
    }

    public function busqueda_tc_cache() {
        $this->data['teleconsultas'] = $this->session->userdata('teleconsultas');
        $this->index('tc_busqueda_datagrid_view');
    }

    /**
     * Exporta a Excel la busqueda realizada.
     *
     * @access public
     * @param none
     * @return none
     */
    public function exportar_busq_xls($id) {
        $teleconsultas = $this->platc_model->reporte_detalle_get($id);
        if ($teleconsultas != NULL) {
            ini_set('zend.ze1_compatibility_mode', '0');
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator('vrx');
            $objPHPExcel->getProperties()->setLastModifiedBy('vrx');
            $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $this->lang->line('tc_id'));
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', $this->lang->line('tc_id_paciente'));
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', $this->lang->line('tc_nom_ape'));
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', $this->lang->line('tc_establ'));
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', $this->lang->line('tc_time_envio'));
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', $this->lang->line('tc_especialidad_busqueda'));
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', $this->lang->line('tc_time_exsol'));
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', $this->lang->line('tc_time_contestada'));
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', $this->lang->line('tc_especialista_contesto'));
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', $this->lang->line('pdf_estado'));
            $i = 2;
            foreach ($teleconsultas as $tc) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $tc['RED_TC_ID']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $tc['RED_PAC_IDENTIFICADOR']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $tc['RED_PAC_NOMBRE_APELLIDO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $tc['RED_ESTABLECIMIENTO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $tc['RED_FECHA_ENVIO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $tc['RED_ESPECIALIDAD']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $tc['RED_FECHA_EXSOL']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $tc['RED_FECHA_CONTESTADA']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $tc['RED_ESPECIALISTA_CONTESTO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $this->lang->line('estado_' . $tc['RED_EST_ID']));
                $i++;
            }
            $objPHPExcel->getActiveSheet()->setTitle('Simple');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $excel_name = 'reporte_temporal.xls';
            $file_path = $this->path_file['excel'] . $excel_name;
            $objWriter->save($this->path_file['excel'] . $excel_name);
            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename=reporte_' . date('YmdHis') . '.xls');
            header('Cache-Control: public');
            header('Content-Description: File Transfer');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path));
            header('Pragma: no-cache');
            header('Expires: 0');
            readfile($file_path);
            unlink($file_path);
        }
    }

    /**
     * Exporta a PDF la busqueda realizada.
     *
     * @access public
     * @param none
     * @return none
     */
    public function exportar_busq_pdf($id) {
        $data = $this->tc_busq_pdf($id);

        $this->load->library('reporte_fpdf');
        $pdf = new Reporte_FPDF();

        $pdf->datos_generales($data);
        $pdf->datos_tabulados($data);
        $pdf->AliasNbPages();
        $pdf->Output();
    }

    /**
     * Carga en la vista el reporte que se requiere que se guardo anteriormente.
     *
     * @access public
     * @param $id ID
     * @return none
     */
    public function tc_busq_pdf($id) {
        $data['reporte'] = $this->platc_model->reporte_get($id);
        $data['reporte_detalle'] = $this->platc_model->reporte_detalle_get($id);
        return $data;
    }

    /**
     *
     */
    public function reportes( ) {

        $clientes = $this->platc_model->clientes_lista_get( );
        $this->data['clientes_select'] = $this->util->select_form_prepare( $clientes, 'CLI_ID', 'CLI_NOMBRE', 'Todos', TRUE );

        $this->index('reporte_excel');
    }

    /**
     * Genera reporte de usuarios del servicio
     */
    public function reporte_usuarios_del_servicio(  ) {

        $fecha_ini  = $this->input->post( 'fecha_desde' );
        $fecha_fin  = $this->input->post( 'fecha_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_usuarios_del_servicio( $fecha_ini, $fecha_fin, $id_cliente );

        if ( !empty( $reportes ) ) {
            ini_set('zend.ze1_compatibility_mode', '0');
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $this->lang->line('reporte_tipo_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', $this->lang->line('reporte_numero_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', $this->lang->line('reporte_codigo_entidad_administradora') );
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', $this->lang->line('reporte_tipo_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', $this->lang->line('apellido1') );
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', $this->lang->line('apellido2') );
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', $this->lang->line('nombre1') );
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', $this->lang->line('nombre2') );
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', $this->lang->line('edad') );
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', $this->lang->line('reporte_unidad_medida_edad') );
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', $this->lang->line('pacientes_sexo') );
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', $this->lang->line('reporte_codigo_departamento') );
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', $this->lang->line('reporte_codigo_municipio') );
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', $this->lang->line('reporte_zona_residencia') );

            $i = 2;
            foreach ($reportes as $reporte) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $reporte['TIPO_IDENTIFICACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $reporte['PAC_IDT_VALOR']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['ENTADM_ID']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['ID_PACIENTE_TIPO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $reporte['TEL_PAC_PRIMER_APELLIDO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['TEL_PAC_SEGUNDO_APELLIDO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $reporte['TEL_PAC_PRIMER_NOMBRE']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['TEL_PAC_SEGUNDO_NOMBRE']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['TEL_PAC_EDAD']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['UNIDAD_ANOS']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $reporte['TEL_PAC_SEXO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $reporte['DEPTO_CODIGO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, $reporte['MUNI_CODIGO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, $reporte['ZON_ID']);
                $i++;
            }

            $objPHPExcel->getActiveSheet()->setTitle('Simple');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $excel_name = 'reporte_temporal.xls';
            $file_path = $this->path_file['excel'] . $excel_name;
            $objWriter->save($this->path_file['excel'] . $excel_name);
            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename=Reporte_' . date('YmdHis') . '.xls');
            header('Cache-Control: public');
            header('Content-Description: File Transfer');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path));
            header('Pragma: no-cache');
            header('Expires: 0');
            readfile($file_path);
            unlink($file_path);
        }
    }

    /**
     * Genera reporte de servicios facturados
     */
/*
    public function reporte_servicios_facturados( ) {

        $fecha_ini  = $this->input->post( 'fecha_desde' );
        $fecha_fin  = $this->input->post( 'fecha_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_servicios_facturados( $fecha_ini, $fecha_fin, $id_cliente );

        if ($reportes != NULL) {
            ini_set('zend.ze1_compatibility_mode', '0');
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $this->lang->line('reporte_codigo_prestador') );
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', $this->lang->line('reporte_razon_nombre_prestador') );
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', $this->lang->line('reporte_tipo_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', $this->lang->line('reporte_numero_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', $this->lang->line('reporte_numero_factura') );
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', $this->lang->line('reporte_fecha_expedicion_factura') );
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', $this->lang->line('reporte_fecha_inicio') );
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', $this->lang->line('reporte_fecha_final') );
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', $this->lang->line('reporte_codigo_entidad_administradora') );
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', $this->lang->line('reporte_nombre_entidad_administradora') );
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', $this->lang->line('reporte_numero_contrato') );
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', $this->lang->line('reporte_plan_beneficios') );
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', $this->lang->line('reporte_numero_poliza') );
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', $this->lang->line('reporte_valor_total_compartido_copago') );
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', $this->lang->line('reporte_valor_comision') );
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', $this->lang->line('reporte_valor_descuentos') );
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', $this->lang->line('reporte_valor_neto_pagar_entidad_contratante') );

            $i = 2;
            foreach ($reportes as $reporte) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, '110011735401');
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, 'ITMS Colombia');
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['TIPO_IDENTIFICACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['PAC_IDT_VALOR']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, null );
//                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['FECHA_EXPEDICION_FACTURA']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $reporte['FECHA_INICIO']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['FECHA_FIN']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $i, $reporte['']);
                $i++;
            }
            $objPHPExcel->getActiveSheet()->setTitle('Simple');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $excel_name = 'reporte_temporal.xls';
            $file_path = $this->path_file['excel'] . $excel_name;
            $objWriter->save($this->path_file['excel'] . $excel_name);
            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename=Reporte_' . date('YmdHis') . '.xls');
            header('Cache-Control: public');
            header('Content-Description: File Transfer');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path));
            header('Pragma: no-cache');
            header('Expires: 0');
            readfile($file_path);
            unlink($file_path);
        }
    }
*/
    /**
     *
     */
    public function reporte_archivo_consulta( ) {

        $fecha_ini  = $this->input->post( 'fecha_desde' );
        $fecha_fin  = $this->input->post( 'fecha_hasta' );
        $id_cliente = $this->input->post( 'cliente' );

        $reportes = $this->platc_model->reporte_archivo_consulta( $fecha_ini, $fecha_fin, $id_cliente );

        if ( !empty( $reportes ) ) {
            ini_set('zend.ze1_compatibility_mode', '0');
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setTitle('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setSubject('Office 2003 XLS TC Report');
            $objPHPExcel->getProperties()->setDescription('TC Report document for Office 2003 XLS.');
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $this->lang->line('reporte_numero_factura') );
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', $this->lang->line('reporte_codigo_prestador') );
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', $this->lang->line('reporte_tipo_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', $this->lang->line('reporte_numero_identificacion_usuario') );
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', $this->lang->line('reporte_fecha_consulta') );
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', $this->lang->line('reporte_numero_autorizacion') );
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', $this->lang->line('reporte_codigo_consulta') );
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', $this->lang->line('reporte_finalidad_consulta') );
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', $this->lang->line('reporte_causa_externa') );
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', $this->lang->line('reporte_codigo_diagnostico_principal') );
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', $this->lang->line('reporte_codigo_diagnostico_relacionado_1') );
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', $this->lang->line('reporte_codigo_diagnostico_relacionado_2') );
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', $this->lang->line('reporte_codigo_diagnostico_relacionado_3') );
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', $this->lang->line('reporte_tipo_diagnostico_principal') );
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', $this->lang->line('reporte_valor_consulta') );
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', $this->lang->line('reporte_valor_cuota_moderada') );
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', $this->lang->line('reporte_valor_neto_a_pagar') );

            $i = 2;
            foreach ($reportes as $reporte) {
//                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $reporte['']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, '110011735401');
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $reporte['TIPO_IDENTIFICACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $reporte['PAC_IDT_VALOR']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $reporte['TEL_FECHA_HORA']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $reporte['TEL_CODIGO_AUTORIZACION']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, '890402' );
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $reporte['FINPROC_ID']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, '');
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, 1);
//                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $i, $reporte['']);
//                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $i, $reporte['']);
                $i++;
            }
            $objPHPExcel->getActiveSheet()->setTitle('Simple');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $excel_name = 'reporte_temporal.xls';
            $file_path = $this->path_file['excel'] . $excel_name;
            $objWriter->save($this->path_file['excel'] . $excel_name);
            header('Content-type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename=Reporte_' . date('YmdHis') . '.xls');
            header('Cache-Control: public');
            header('Content-Description: File Transfer');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file_path));
            header('Pragma: no-cache');
            header('Expires: 0');
            readfile($file_path);
            unlink($file_path);
        }
    }

}
