<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
* Platc_Model
*
* Clase principal de la aplicacion de tipo modelo
* esta clase trabaja directamente con la base de datos
* y es ocupada por el controlador Platc.
*
* @author Esteban G�mez Lillo
* @author http://www.swift.cl
*
* @package Platc_Model
*/
class Platc_Model extends CI_Model {
	
 	private $path;
 	
	/**
	* Constructor de la clase
	*
	* @access default
	* @param none
	* @return none
	*/
 	function __construct()
 	{
 		parent::__construct();
 		$CI = &get_instance();
 	}

	/**
	* Metodo que recibe el usuario y password del usuario y lo
	* valida contra la base de datos respondiendo si es correcto un array
	* con los datos del usuario o un FALSE si no autentica correctamente
	*
	* @access default
	* @param string $mail email del usuario con el cual se intenta autenticar
	* @param string $pass password del usuario con el cual se intenta autenticar
	* @return array $row[0] contiene todos los datos del usuario para luego ser guardado en variables de session
	*/
 	function login($mail, $pass)
 	{
		$sql = "SELECT  U.USU_ID, U.USU_NOMBRE, U.USU_EMAIL, U.ROL_ID,
                        C.CLI_ID, C.CLI_NOMBRE, C.CLI_IMAGEN_INSTITUCIONAL,
                        S.SIT_ID, S.SIT_NOMBRE, I.IDI_NOMBRE

                 FROM   TC_USUARIO AS U  
                        INNER JOIN ( TC_SITE S
                            JOIN TC_IDIOMA I ON I.IDI_ID = S.IDI_ID )
                        ON S.SIT_ID = U.SIT_ID

                        left join TC_CLIENTE C on C.CLI_ID = U.CLI_ID ";
        $sql .= "WHERE U.USU_EMAIL = '".$mail."' ";
		$sql .= "AND U.USU_ACTIVO = '1' ";
		$sql .= "AND U.USU_PASSWORD = '".$pass."' ";

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
		   	return $row[0];
		}
 		else
 			return FALSE;
 	}

	/**
	* Obtiene datos de un usuario con el ID de este recibido por parametro
	*
	* @access public
	* @param int $id ID del usuario del cual se obtendran los datos
	* @return array $row[0] contiene todos los datos del usuario para luego ser guardado en variables de session
	*/
 	public function data_user($id)
 	{
		$sql = "SELECT U.USU_ID, U.USU_NOMBRE, U.USU_EMAIL, U.ROL_ID, U.ETB_ID, E.ETB_NOMBRE, C.CLI_ID, C.CLI_NOMBRE, C.CLI_IMAGEN_INSTITUCIONAL,
                        G.GRU_ID, G.GRU_NOMBRE, S.SIT_ID, S.SIT_NOMBRE, I.IDI_NOMBRE

                FROM    TC_USUARIO AS U
                            inner join TC_GRUPO G on G.GRU_ID = U.gru_id
                            inner join ( TC_SITE S
                                join TC_IDIOMA I on I.IDI_ID = S.IDI_ID )
                            on S.SIT_ID = G.SIT_ID
                            left join TC_CLIENTE C on C.CLI_ID = U.CLI_ID
                            left join TC_ESTABLECIMIENTO AS E on E.ETB_ID = U.ETB_ID
                WHERE   U.USU_ID = ".$id;
        

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
		   	return $row[0];
		}
 		else
 			return FALSE;
 	}

	/**
	* Cambia el password de un usuario recibiendo el ID, password actual y la nueva password
	* conprueba que la password actual corresponda y si es asi la cambia por la nueva,
	*
	* @access public
	* @param int $id ID del usuario
	* @param string $pass password actual de usuario
	* @param string $newpass nueva password del usuario
	* @return boolean TRUE si el cambio fue correcto
	*/
	public function usuario_chpass($id, $pass, $newpass)
	{
		if ($this->existe_registro('TC_USUARIO', 'USU_ID', $id)) {
			$this->db->where('USU_ID', $id);
			$this->db->where('USU_PASSWORD', $pass);
			$query = $this->db->get('TC_USUARIO');
			if ($query->num_rows() > 0) {
				$data['USU_PASSWORD'] = $newpass;
				$this->db->where('USU_ID', $id);
				$this->db->update('TC_USUARIO', $data);
				return TRUE;
			}
		}
	}

	/**
	* Obtiene las afiliaciones de un site en especifico a traves del ID de este
	* recibido por parametro.
	*
	* @access public
	* @param int $id ID del site
	* @return array Arreglo con todas las afliaciones del site o NULL si no hay resultados
	*/
	public function site_afiliaciones_get($id)
	{
		$this->db->where('SIT_ID', $id);
		$query = $this->db->get('TC_AFILIACION');
		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}
	
	/**
	* Obtiene los identificadores de un site en especifico a traves del ID de este
	* recibido por parametro.
	*
	* @access public
	* @param int $id ID del site
	* @return array Arreglo con todos los identificadores del site o NULL si no hay resultados
	*/
	public function site_identificadores_get($id)
	{
		$this->db->where('SIT_ID', $id);
		$query = $this->db->get('TC_IDENTIFICADOR');
		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene las prioridades del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todas las prioridades del sistema.
	*/
	public function prioridades_get()
	{
		$sql = "SELECT PRI_ID ";
		$sql .= "FROM TC_PRIORIDAD ";
		$sql .= "WHERE PRI_ID <> '4'";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene los roles del sistema,
	* menos el de administrador o el de supervisor dependiendo del usuario
	* que los consulta.
	*
	* @access public
	* @param none
	* @return array Arreglo con los roles del sistema, .
	*/
	public function roles_get()
	{
		$sql = "SELECT ROL_ID ";
		$sql .= "FROM TC_ROL ";
		$sql .= "WHERE ROL_ID <> '1'";

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene todos los sites del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los sites del sistema, .
	*/
	public function sites_get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_SITE ";
		$sql .= "WHERE SIT_ID <> '1'";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene los datos de un site en especifico por su ID que llega por parametro.
	*
	* @access public
	* @param int $id ID del site
	* @return array Arreglo con todos los datos del site.
	*/
	public function site_get($id)
	{
		$this->db->where('SIT_ID', $id);
		$query = $this->db->get('TC_SITE');	
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;	
	}

	/**
	* Obtiene los datos de un site del sistema con su idioma para poder ser listados.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los sites.
	*/
	public function sites_lista_get()
	{
		$sql = "SELECT s.SIT_ID, s.SIT_NOMBRE, s.SIT_DESCRIPCION, s.SIT_PIT_ID, i.IDI_NOMBRE ";
		$sql .= "FROM TC_SITE AS s, TC_IDIOMA as i ";
		$sql .= "WHERE s.SIT_ID <> '1' ";
		$sql .= "AND i.IDI_ID = s.IDI_ID";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Actualiza los datos de un site en especifico recibiendo
	* estos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con los datos a actualizar
	* @return boolean TRUE si fue actualizado correctamente.
	*/
	public function site_upd($data)
	{
		if (!$this->existe_registro('TC_SITE', 'SIT_NOMBRE', $data['SIT_NOMBRE'], 'SIT_ID', $data['SIT_ID'])) {
			$this->db->where('SIT_ID', $data['SIT_ID']);
			$this->db->update('TC_SITE', $data);
			return TRUE;
		}
	}

	/**
	* Inserta un nuevo site en la db, recibiendo
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con los datos del nuevo site
	* @return boolean TRUE si fue insertado correctamente
	*/
	public function site_set($data)
	{
		if (!$this->existe_registro('TC_SITE', 'SIT_NOMBRE', $data['SIT_NOMBRE'])) {
			$this->db->insert('TC_SITE', $data);
			return TRUE;
		}
	}

	/**
	* Elimina un site en especifico recibiendo el ID de este por parametro,
	* chequea que no tenga grupos creados y si borra el site.
	*
	* @access public
	* @param int $id ID del site a borrar
	* @return boolean TRUE si fue eliminado correctamente.
	*/
	public function site_del($id)
	{
		if (!$this->existe_registro('TC_GRUPO', 'SIT_ID', $id)) {
			$data['SIT_ID'] = $id;
			$this->db->delete('TC_SITE', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene todos los grupos del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los grupos
	*/
	public function grupos_get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_GRUPO ";
		$sql .= "WHERE GRU_ID <> '1'";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene los datos de un grupo en especifico recibiendo
	* el ID de este por parametro.
	*
	* @access public
	* @param int $id ID del grupo
	* @return array Arreglo con todos los datos del grupo
	*/
	public function grupo_get($id)
	{
		$sql = "SELECT g.GRU_ID, g.GRU_NOMBRE, g.GRU_DESCRIPCION, s.SIT_ID, s.SIT_NOMBRE ";
		$sql .= "FROM TC_GRUPO AS g, TC_SITE AS s ";
		$sql .= "WHERE g.GRU_ID = ".$id." ";
		$sql .= "AND s.SIT_ID = g.SIT_ID ";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;	
	}

	/**
	* Obtiene los grupos del sistema con el site al que pertenece
	* para poder ser listado.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los grupos
	*/
	public function grupos_lista_get( $id_site = NULL )
	{
		$sql = "SELECT g.GRU_ID, g.GRU_NOMBRE, g.GRU_DESCRIPCION, s.SIT_NOMBRE ";
		$sql .= "FROM TC_GRUPO AS g, TC_SITE as s ";
		$sql .= "WHERE g.GRU_ID <> '1' ";
		$sql .= "AND s.SIT_ID = g.SIT_ID ";

        if( !empty( $id_site ) )
            $sql.= " AND g.SIT_ID = " . $id_site;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Actualiza un grupo en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function grupo_upd($data, $clientes, $usuarios )
	{
		$idi_site = $this->grupo_get($data['GRU_ID']);
		if (!$this->existe_registro('TC_GRUPO', 'GRU_NOMBRE', $data['GRU_NOMBRE'], 'GRU_ID', $data['GRU_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
			$this->db->where('GRU_ID', $data['GRU_ID']);
			$this->db->update('TC_GRUPO', $data);

            $this->db->delete( 'TC_GRUPO_CLIENTE', array( 'GRU_ID' => $data['GRU_ID'] ) ); 
            foreach( $clientes as $cliente )
                $this->db->insert('TC_GRUPO_CLIENTE', array( 'GRU_ID' => $data['GRU_ID'], 'CLI_ID' => $cliente ) );

            $this->db->delete( 'TC_GRUPO_USUARIO', array( 'GRU_ID' => $data['GRU_ID'] ) ); 
            foreach( $usuarios as $usuario )
                $this->db->insert('TC_GRUPO_USUARIO', array( 'GRU_ID' => $data['GRU_ID'], 'USU_ID' => $usuario ) );

			return TRUE;
		}
	}

	/**
	* Obtiene el listado de grupos asociados a un usuario en particular
	* Los usuarios son especialistas.
	*
	* @access public
	* @param int $id_usuario Identificador del usuario
	* @return array Grupos asociados al usuario
	*/
	public function grupos_por_usuario( $id_usuario )
	{
        $sql = "SELECT  *
                FROM    TC_GRUPO_USUARIO GU
                        INNER JOIN TC_USUARIO U ON ( U.USU_ID = GU.USU_ID )
                WHERE   GU.GRU_ID = " . $id_usuario;
        $query = $this->db->query( $sql );

		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Inserta un nuevo grupo en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function grupo_set($data, $clientes, $usuarios)
	{
		if (!$this->existe_registro('TC_GRUPO', 'GRU_NOMBRE', $data['GRU_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {

            $this->db->insert('TC_GRUPO', $data);
            $id_grupo = $this->db->insert_id();

            if( !empty( $clientes ) )
                foreach( $clientes as $cliente )
                    $this->db->insert('TC_GRUPO_CLIENTE', array( 'GRU_ID' => $id_grupo, 'CLI_ID' => $cliente ) );

            if( !empty( $usuarios ) )
                foreach( $usuarios as $usuario )
                    $this->db->insert('TC_GRUPO_USUARIO', array( 'GRU_ID' => $id_grupo, 'USU_ID' => $usuario ) );

			return TRUE;
		}
	}

	/**
	* Elimina un grupo en especifico por el ID recibido por parametro,
	* esto solo si el grupo no tiene clientes asociados a el.
	*
	* @access public
	* @param int $id ID del grupo
	* @return boolean TRUE si se elimino correctamente
	*/
	public function grupo_del($id)
	{
		if (!$this->existe_registro('TC_CLIENTE', 'GRU_ID', $id)) {
			$data['GRU_ID'] = $id;
			$this->db->delete('TC_GRUPO_CLIENTE', $data);
			$this->db->delete('TC_GRUPO_USUARIO', $data);
			$this->db->delete('TC_GRUPO', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene los clientes del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los clientes
	*/
	public function clientes_get( $id_site = null )
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_CLIENTE ";
		$sql .= "WHERE CLI_ID <> '1'";
        
        if( !empty( $id_site ) )
            $sql.=" AND SIT_ID = ".$id_site;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene un cliente en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del cliente
	* @return array Arreglo con los datos del cliente
	*/
	public function cliente_get($id)
	{
		$sql = "SELECT  c.CLI_ID, c.CLI_NOMBRE, c.CLI_RUT, c.CLI_RAZON_SOCIAL, c.SIT_ID, c.CLI_IMAGEN_INSTITUCIONAL,
                        s.SIT_NOMBRE ";
		$sql .= "FROM   TC_CLIENTE AS c
                        INNER JOIN TC_SITE AS s ON ( s.SIT_ID = c.SIT_ID )";
		$sql .= "WHERE c.CLI_ID = ".$id." ";

//imprimir( $sql );
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;	
	}

	/**
	* Obtiene los clientes del sistema con su grupo y site
	* al que pertenece para poder ser listados.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los clientes
	*/
	public function clientes_lista_get()
	{
		$sql = "SELECT c.CLI_ID, c.CLI_NOMBRE, c.CLI_RUT, s.SIT_NOMBRE ";
		$sql .= "FROM TC_CLIENTE AS c
                        INNER JOIN TC_SITE s ON ( s.SIT_ID = c.SIT_ID ) ";
        $sql .= "WHERE c.SIT_ID = ".$this->session->userdata('SIT_ID')." ";
		$sql .= "       AND c.CLI_ID <> '1' ";

//imprimir( $sql );
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Actualiza un cliente en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function cliente_upd($data, $especialidades )
	{
		$idi_site = $this->cliente_get($data['CLI_ID']);
		if (!$this->existe_registro('TC_CLIENTE', 'CLI_RUT', $data['CLI_RUT'], 'CLI_ID', $data['CLI_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
			$this->db->where('CLI_ID', $data['CLI_ID']);
			$this->db->update('TC_CLIENTE', $data);
            
			// Elimina registros asociados a las especialidades
            $this->db->where( 'CLI_ID', $data['CLI_ID'] );
            $this->db->delete( 'TC_CLIENTE_ESPECIALIDAD' );
            
            foreach( $especialidades as $especialidad )
                $this->db->insert( 'TC_CLIENTE_ESPECIALIDAD', array( 'CLI_ID' => $data['CLI_ID'], 'ESP_ID' => $especialidad ) );

			return TRUE;
		}
	}

	/**
	* Inserta un nuevo cliente en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function cliente_set( $data, $especialidades )
	{
		if (!$this->existe_registro('TC_CLIENTE', 'CLI_RUT', $data['CLI_RUT'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {

			$this->db->insert('TC_CLIENTE', $data);
			$id_cliente = $this->db->insert_id();
            
            foreach( $especialidades as $especialidad )
                $this->db->insert( 'TC_CLIENTE_ESPECIALIDAD', array( 'CLI_ID' => $id_cliente, 'ESP_ID' => $especialidad ) );
            
			return $id_cliente;
		}
	}

	/**
	* Elimina un cliente en especifico por el ID recibido por parametro,
	* esto solo si el cliente no tiene establecimientos asociados a el.
	*
	* @access public
	* @param int $id ID del cliente
	* @return boolean TRUE si se elimino correctamente
	*/
	public function cliente_del($id)
	{
		if (!$this->existe_registro('TC_ESTABLECIMIENTO', 'CLI_ID', $id)) {
			$data['CLI_ID'] = $id;
			$this->db->delete('TC_CLIENTE', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene los establecimientos del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los establecimientos
	*/
	public function establecimientos_get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_ESTABLECIMIENTO ";
		$sql .= "WHERE ETB_ID <> '1'";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene los establecimientos de un cliente.
	*
	* @access public
	* @param int $id ID del cliente
	* @return array Arreglo con todos los establecimientos
	*/
	public function establecimientos_cliente_get($id)
	{
		$sql = "SELECT ETB_ID, ETB_NOMBRE ";
		$sql .= "FROM TC_ESTABLECIMIENTO ";
		$sql .= "WHERE ETB_ID <> 1 ";
		$sql .= "AND CLI_ID = ".$id;
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene un establecimiento en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del establecimiento
	* @return array Arreglo con los datos del establecimientos
	*/
	public function establecimiento_get($id)
	{
		
		$sql = "SELECT  e.ETB_ID, e.ETB_NOMBRE, e.ETB_NIVEL, e.ETB_DIRECCION, e.ETB_EMAIL, e.CLI_ID, e.SIT_ID, e.MUNI_ID,
                        s.SIT_NOMBRE ";
		$sql .= "FROM   TC_ESTABLECIMIENTO AS e
                            INNER JOIN ( TC_CLIENTE AS c
                                INNER JOIN TC_SITE s ON ( s.SIT_ID = c.SIT_ID )
                            ) ON ( c.CLI_ID = e.CLI_ID ) ";
		$sql .= "WHERE e.ETB_ID = '".$id."' ";

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

	/**
	* Obtiene los establecimientos del sistema con el cliente
	* al que pertenece para poder ser listados.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los establecimientos
	*/
	public function establecimientos_lista_get( $id_site = NULL )
	{
		$sql = "SELECT e.ETB_ID, e.ETB_NOMBRE, e.ETB_NIVEL, e.ETB_DIRECCION, e.ETB_EMAIL, c.CLI_NOMBRE ";
		$sql .= "FROM TC_ESTABLECIMIENTO AS e, TC_CLIENTE AS c ";
		$sql .= "WHERE e.ETB_ID <> '1' ";
		$sql .= "AND c.CLI_ID = e.CLI_ID ";

        if( !empty( $id_site ) )
            $sql.=" AND e.SIT_ID = ". $id_site;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Actualiza un establecimiento en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function establecimiento_upd($data)
	{
		$idi_site = $this->establecimiento_get($data['ETB_ID']);
		if (!$this->existe_registro('TC_ESTABLECIMIENTO', 'ETB_NOMBRE', $data['ETB_NOMBRE'], 'ETB_ID', $data['ETB_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
			$this->db->where('ETB_ID', $data['ETB_ID']);
			$this->db->update('TC_ESTABLECIMIENTO', $data);
			return TRUE;
		}
	}

	/**
	* Inserta un nuevo establecimiento en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function establecimiento_set($data)
	{
		if (!$this->existe_registro('TC_ESTABLECIMIENTO', 'ETB_NOMBRE', $data['ETB_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
			$this->db->insert('TC_ESTABLECIMIENTO', $data);
			return TRUE;
		}
	}

	/**
	* Elimina un establecimiento en especifico por el ID recibido por parametro.
	* esto solo si el establecimientos no tiene usuarios asociados a el.
	*
	* @access public
	* @param int $id ID del establecimiento
	* @return boolean TRUE si se elimino correctamente
	*/
	public function establecimiento_del($id)
	{
		if (!$this->existe_registro('TC_USUARIO', 'ETB_ID', $id)) {
			$data['ETB_ID'] = $id;
			$this->db->delete('TC_ESTABLECIMIENTO', $data);
			return TRUE;
		}
	}

	/**
	* Retorna todos los estados segun el lenguaje que se esta trabajando.
	*
	* @access public
	* @param string $languaje Lenguaje que se esta trabajndo
	* @return array Arreglo con todos los estados en el idioma que corresponde
	*/
	public function estados_select($languaje)
	{
		$this->lang->load($languaje, $languaje);
		$estados[0] = $this->lang->line('todos');
		if ($this->session->userdata('ROL_ID') > 3)
			$estados[1] = $this->lang->line('estado_1');
		$estados[2] = $this->lang->line('estado_2');
		$estados[3] = $this->lang->line('estado_3');
		if ($this->session->userdata('ROL_ID') < 3)
			$estados[4] = $this->lang->line('estado_4');
		$estados[5] = $this->lang->line('estado_5');
		$estados[6] = $this->lang->line('estado_6');
		$estados[7] = $this->lang->line('estado_7');
		return $estados;
	}

	/**
	* Inserta un nuevo estado para un TC en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function tc_estado_set($data)
	{
		$this->db->insert('TC_TELECONSULTA_ESTADO', $data);
		return TRUE;
	}
	
	/**
	* Obtiene una TC en un estado en especifico si esta se encuentra.
	*
	* @access public
	* @param int $id_tc ID de la TC
	* @param int $id_estado estado de la TC que se requiere
	* @return array Arreglo con la TC si esta fue encontrada
	*/
	public function tc_estado_get($id_tc, $id_estado)
	{
		$this->db->where('TEL_ID', $id_tc);
		$this->db->where('EST_ID', $id_estado);
		$query = $this->db->get('TC_TELECONSULTA_ESTADO');
		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

	/**
	* Obtiene los idiomas del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los idiomas
	*/
	public function idiomas_get()
	{
		$this->db->order_by('IDI_NOMBRE', 'DESC');
		$query = $this->db->get('TC_IDIOMA');
		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los grupos de un site en especifico
	* recibiendo el ID del site por parametro
	*
	* @access public
	* @param int $id ID del site
	* @return array Arreglo con los grupos encontrados
	*/
 	public function grupos_site_get($id)
	{
		$this->db->where('SIT_ID', $id);
		$this->db->order_by('GRU_NOMBRE', 'DESC');
		$query = $this->db->get('TC_GRUPO');
		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los clientes de un grupo en especifico
	* recibiendo el ID del grupo por parametro
	*
	* @access public
	* @param int $id ID del grupo
	* @return array Arreglo con los clientes encontrados
	*/
 	public function clientes_grupo_get($id)
	{
        $sql = "SELECT  *
                FROM    TC_GRUPO_CLIENTE GC
                        INNER JOIN TC_CLIENTE C ON ( C.CLI_ID = GC.CLI_ID )
                WHERE   GC.GRU_ID = " . $id;
        $query = $this->db->query( $sql );

		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los clientes de un usuario en especifico
    * PASANDO POR LOS GRUPOS ASOCIADOS
	* recibiendo el ID del usuario por parametro
	*
	* @access public
	* @param int $id ID del usuario
	* @return array Arreglo con los clientes encontrados, sin repeticion
	*/
 	public function clientes_usuario_get( $id_usuario )
	{
        $sql = "SELECT  DISTINCT C.*
                FROM    TC_CLIENTE C
                        INNER JOIN ( TC_GRUPO_CLIENTE GC
                                        INNER JOIN ( TC_GRUPO G
                                                    INNER JOIN TC_GRUPO_USUARIO GU ON ( GU.GRU_ID = G.GRU_ID )
                                        ) ON ( GC.GRU_ID = G.GRU_ID )
                        ) ON ( C.CLI_ID = GC.CLI_ID )
                WHERE   GU.USU_ID = " . $id_usuario;
        $query = $this->db->query( $sql );

		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los establecimientos de un cliente en especifico
	* recibiendo el ID del cliente por parametro
	*
	* @access public
	* @param int $id ID del cliente
	* @return array Arreglo con los establecimientos encontrados
	*/
 	public function establs_cliente_get($id)
	{
		$this->db->where('CLI_ID', $id);
		$this->db->order_by('ETB_NOMBRE', 'DESC');
		$query = $this->db->get('TC_ESTABLECIMIENTO');
		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los especialistas de una especialidad en especifico
	* recibiendo el ID de la especialidad por parametro
	*
    * @deprecated Este método es llamado desde otro método que ha sido despreciado
    * Especialistas se asocian a grupos a traves de TC_GRUPO_USUARIO y no directamente
	* @access public
	* @param int $id ID de la especialidad
	* @return array Arreglo con los especialistas encontrados
	*/
 	public function especialistas_especialidad_get($id)
	{
		$sql  = "SELECT u.USU_ID, u.USU_NOMBRE ";
		$sql .= "FROM TC_USUARIO AS u, TC_USUARIO_ESPECIALIDAD AS ue ";
		$sql .= "WHERE ue.ESP_ID = ".$id." ";
		$sql .= "AND u.USU_ID = ue.USU_ID ";
		$sql .= "AND u.GRU_ID = ".$this->session->userdata('GRU_ID')." ";
		$sql .= "GROUP BY u.USU_ID";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los especialistas de una especialidad en especifico
	* recibiendo el ID de la especialidad por parametro
	*
	* @access public
	* @param int $id ID de la especialidad
	* @return array Arreglo con los especialistas encontrados
	*/
 	public function generalistas_establecimiento_get($id)
	{
		$sql = "SELECT USU_ID, USU_NOMBRE ";
		$sql .= "FROM TC_USUARIO ";
		$sql .= "WHERE ETB_ID = ".$id." ";
		$sql .= "AND ROL_ID > 3 ";
		$sql .= "ORDER BY USU_NOMBRE";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todas las especialidades de un usuario en especifico
	* recibiendo el ID del usuario por parametro
	*
	* @access public
	* @param int $id ID del usuario
	* @return array Arreglo con los usuarios encontrados
	*/
 	public function usuario_especialidades_get($id)
	{
		$sql = "SELECT e.ESP_ID, e.ESP_NOMBRE ";
		$sql .= "FROM TC_USUARIO_ESPECIALIDAD AS ue, TC_ESPECIALIDAD AS e ";
		$sql .= "WHERE ue.USU_ID = ".$id." ";
		$sql .= "AND e.ESP_ID = ue.ESP_ID";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene todos los establecimientos asociados a un usuario en especifico
	* recibiendo el ID del usuario por parametro
	*
	* @access public
	* @param int $id ID del usuario
	* @return array Arreglo con los establecimientos asociados
	*/
 	public function usuario_establecimientos_get($id)
	{
		$sql = "SELECT E.*
                FROM TC_USUARIO U
                        INNER JOIN ( TC_CLIENTE C
                            INNER JOIN TC_ESTABLECIMIENTO E ON E.CLI_ID = C.CLI_ID )
                        ON C.CLI_ID = U.CLI_ID
                WHERE U.USU_ID = " . $id . ";";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Inserta las especialidades que un especialista tiene, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a insertar
	* @return boolean TRUE si se inserto correctamente
	*/
	public function usuario_especialidad_set_upd($data)
	{
		$this->db->insert('TC_USUARIO_ESPECIALIDAD', $data);
		return TRUE;
	}

	/**
	* Inserta un nuevo usuario en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function usuario_set($data, $grupo)
	{
            
		if (!$this->existe_registro('TC_USUARIO', 'USU_EMAIL', $data['USU_EMAIL'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {

            $this->db->insert('TC_USUARIO', $data);
            $id = $this->db->insert_id();

			if( !empty( $id ) )
				return $id;
			else
				return "ERROR1";
		}
		else
			return FALSE;
	}

	/**
	* Obtiene los usuarios del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los usuarios
	*/
	public function usuarios_get( $id_site = NULL )
	{

        $sql = "SELECT  u.USU_ID, u.USU_NOMBRE, u.USU_EMAIL, u.USU_ACTIVO,
                        u.ROL_ID, u.SIT_ID, s.SIT_NOMBRE, c.CLI_NOMBRE
                FROM    TC_USUARIO AS u
                            INNER JOIN TC_SITE AS s ON ( s.SIT_ID = u.SIT_ID )
                            LEFT JOIN TC_CLIENTE AS c ON ( c.CLI_ID = u.CLI_ID )

                WHERE   u.ROL_ID > 1 ";
        if( !empty( $id_site ) )
            $sql.= " AND u.SIT_ID = ". $id_site . " ";

        // Si es supervisor descarta supervisores
		if ($this->session->userdata('ROL_ID') == 2)
			$sql .= "AND u.ROL_ID <> 2 ";
        
        $sql .= "ORDER BY USU_ID ";

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene los usuarios del sistema segun roles especificados por
    * parámetros
	*
	* @access public
	* @param $roles mix Roles seleccionados para listar
	* @return array Arreglo con los usuarios
	*/
	public function usuarios_por_rol( $roles, $id_site = NULL,$activo = 1 )
	{
        if( !is_array( $roles ) )
            $roles = array( $roles );

        $sql = "SELECT  u.USU_ID,concat(u.USU_EMAIL,' - ',u.USU_NOMBRE) as USU_NOMBRE, u.USU_EMAIL, u.USU_ACTIVO,
                        u.ROL_ID, u.SIT_ID, c.CLI_NOMBRE
                FROM    TC_USUARIO AS u
                            LEFT JOIN TC_CLIENTE AS c ON ( c.CLI_ID = u.CLI_ID )

                WHERE   u.ROL_ID in ( ".  implode( ', ', $roles )." )";

        if( !empty( $id_site ) )
            $sql.= " AND u.SIT_ID = ".$id_site. " ";
        if( $activo == 1 )
            $sql.= " AND u.USU_ACTIVO = 1 ";
        elseif( $activo == 0 )
            $sql.= " AND u.USU_ACTIVO = 0 ";


        $sql .= "ORDER BY USU_ID ";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene un usuario en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del usuario
	* @return array Arreglo con los datos del usuario
	*/
	public function usuario_get($id)
	{
        $sql = "SELECT  u.USU_ID, u.USU_NOMBRE, u.USU_EMAIL, u.USU_ACTIVO,
                        u.ROL_ID, u.SIT_ID, u.USU_FIRMA, u.USU_NRO_REGISTRO,
                        s.SIT_NOMBRE, c.CLI_ID, c.CLI_NOMBRE, c.CLI_IMAGEN_INSTITUCIONAL
                FROM    TC_USUARIO AS u
                            INNER JOIN TC_SITE AS s ON ( s.SIT_ID = u.SIT_ID )
                            LEFT JOIN TC_CLIENTE AS c ON ( c.CLI_ID = u.CLI_ID )
                WHERE   u.USU_ID = ".$id;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;	
	}

	/**
	* Metodo para buscar usuarios en la db.
	*
	* @access public
	* @param string $usu Nombre o parte del nombre del usuario
	* @return array Arreglo con los datos del usuario si este fue encontrado
	*/
	public function usuario_busca_get($usu = NULL)
	{
		if ($usu != NULL && $usu != '') {
			$sql = "SELECT USU_ID, USU_NOMBRE ";
			$sql .= "FROM TC_USUARIO ";
			$sql .= "WHERE USU_NOMBRE LIKE '%".$usu."%' ";
			$query = $this->db->query($sql);
 			if ($query->num_rows() > 0) {
				$row = $query->result_array();
				return $row[0];
			}
			else
				return NULL;
		}
	}

	/**
	* Obtiene los datos de un usuario segun su ID.
	*
	* @access public
	* @param int $id ID del usuario
	* @return array Arreglo con los datos del usuario si este fue encontrado
	*/
	public function usuario_estado_get($id)
	{
		$sql = "SELECT U.*, C.* ";
		$sql .= "FROM TC_USUARIO U ";
		$sql .= "LEFT JOIN TC_CLIENTE C ON C.CLI_ID = U.CLI_ID ";
		$sql .= "WHERE USU_ID = ".$id;
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;	
	}

	/**
	* Actualiza el estado de un usuario en el sistema, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function usuario_estado_upd($data)
	{
		$this->db->where('USU_ID', $data['USU_ID']);
		$query = $this->db->get('TC_USUARIO');
		if ( $query->num_rows() > 0 ) {
			$row = $query->result_array();
			if ( $this->session->userdata('ROL_ID') < $row[0]['ROL_ID'] ) {
				$this->db->where('USU_ID', $data['USU_ID']);
				$this->db->update('TC_USUARIO', $data);
			}
		}
	}

	/**
	* Actualiza un usuario en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @param int $grupo ID del grupo al que pertenece
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function usuario_upd($data, $grupo)
	{
            
		$idi_site = $this->usuario_get($data['USU_ID']);
		if (!$this->existe_registro('TC_USUARIO', 'USU_EMAIL', $data['USU_EMAIL'], 'USU_ID', $data['USU_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
//			if ($data['ROL_ID'] < 4) {
//				$sql = "SELECT e.ETB_ID ";
//				$sql .= "FROM TC_ESTABLECIMIENTO AS e, TC_CLIENTE AS c ";
//				$sql .= "WHERE c.GRU_ID = '".$grupo."' ";
//				$sql .= "AND e.CLI_ID = c.CLI_ID";
//				$query = $this->db->query($sql);
//				if ( $query->num_rows() > 0 ) {
//					$row = $query->result_array();
//					$data['ETB_ID'] = $row[0]['ETB_ID'];
//				}
//			}
			$this->db->where('USU_ID', $data['USU_ID']);
			$this->db->update('TC_USUARIO', $data);
			$datadel['USU_ID'] = $data['USU_ID'];
			$this->db->delete('TC_USUARIO_ESPECIALIDAD', $datadel);
			return TRUE;
		}
	}

	/**
	* Elimina un usuario en especifico por el ID recibido por parametro,
	* esto solo si el usuario no a participado en la respuesta de ninguna TC.
	*
	* @access public
	* @param int $id ID del usuario
	* @return boolean TRUE si se elimino correctamente
	*/
	public function usuario_del($id)
	{
		if (!$this->existe_registro('TC_TELECONSULTA_ESTADO', 'USU_ID', $id)) {
			$data['USU_ID'] = $id;
			$this->db->delete('TC_USUARIO', $data);
			$this->db->delete('TC_USUARIO_ESPECIALIDAD', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene el listado de usuarios asociados a un grupo en particular
	* Los usuarios son especialistas y supervisores.
	*
	* @access public
	* @param int $id_usuario Identificador del usuario
	* @return array Grupos asociados al usuario
	*/
	public function usuarios_por_grupo( $id_grupo )
	{
        $sql = "SELECT  U.*
                FROM    TC_GRUPO_USUARIO GU
                        INNER JOIN TC_USUARIO U ON ( U.USU_ID = GU.USU_ID )
                WHERE   GU.GRU_ID = " . $id_grupo;
        $query = $this->db->query( $sql );

		if ( $query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

    /**
	* Inserta un paciente en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	* El valor de sesion 'CLI_ID' es válido solo para usuarios Médicos Generalistas
    * y Asistentes
    *
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function paciente_set($data, $data2)
	{
		$chk = TRUE;
		foreach ($data2 as $d2) {
			$sql = "SELECT IDT_ID FROM TC_PACIENTE_IDENTIFICADOR AS pi, TC_PACIENTE AS p, TC_ESTABLECIMIENTO AS e ";
			$sql .= "WHERE pi.IDT_ID = ".$d2['IDT_ID']." ";
			$sql .= "AND pi.PAC_IDT_VALOR = '".$d2['PAC_IDT_VALOR']."' ";
			$sql .= "AND e.CLI_ID = ".$this->session->userdata('CLI_ID')." ";
			$sql .= "AND p.PAC_ID = pi.PAC_ID ";
			$sql .= "AND p.ETB_ID = e.ETB_ID";
			$query = $this->db->query($sql);
 			if ($query->num_rows() > 0)
				$chk = FALSE;
		}
		if ($chk == TRUE) {
			$this->db->insert('TC_PACIENTE', $data);
			$pacid = $this->db->insert_id();
			foreach ($data2 as $d2) {
				$ident['PAC_ID'] = $pacid;
				$ident['IDT_ID'] = $d2['IDT_ID'];
				$ident['PAC_IDT_VALOR'] = $d2['PAC_IDT_VALOR'];
				$this->db->insert('TC_PACIENTE_IDENTIFICADOR', $ident);
			}
			return $pacid;
		}
	}

	/**
	* Busca a un paciente por su identificador.
	*
	* @access public
	* @param string $id Identificador del paciente
	* @return array Arreglo con los datos del paciente si este fue encontrado
	*/
	public function pacientes_buscar_id($id)
	{
		$sql = "SELECT p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_NACIMIENTO, a.AFI_NOMBRE,c.CLI_NOMBRE ";
		$sql .= "FROM TC_PACIENTE_IDENTIFICADOR as i, TC_PACIENTE as p, TC_AFILIACION as a, TC_CLIENTE c ";
		$sql .= "WHERE i.PAC_IDT_VALOR = '".$id."' ";
                if($this->session->userdata('SIT_ID') !="22")
                    $sql .= "AND c.CLI_ID = ".$this->session->userdata('CLI_ID')." ";
                $sql .= "AND p.CLI_ID = c.CLI_ID ";
		$sql .= "AND p.PAC_ID = i.PAC_ID ";
		$sql .= "AND a.AFI_ID = p.AFI_ID";
              // die($sql);
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busca a un paciente por su nombre y/o apellido.
	*
	* @access public
	* @param string $nombre Nombre o parte de este de un paciente
	* @param string $apellido Apellido o parte de este de un paciente
	* @return array Arreglo con los datos del o los pacientes si este fue encontrado
	*/
	public function pacientes_buscar_na($nombre = '', $apellido = '')
	{
		$sql = "SELECT p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_NACIMIENTO, a.AFI_NOMBRE, c.CLI_NOMBRE ";
		$sql .= "FROM TC_PACIENTE as p, TC_AFILIACION as a, TC_CLIENTE c ";
		if ($nombre != '') {
			$sql .= "WHERE p.PAC_PRIMER_NOMBRE LIKE '%".$nombre."%' ";
			if ($apellido != '')
				$sql .= "AND ";
		}
		else
			$sql .= "WHERE ";
		if ($apellido != '')
			$sql .= "p.PAC_PRIMER_APELLIDO LIKE '%".$apellido."%' ";
		$sql .= "AND c.CLI_ID = ".$this->session->userdata('CLI_ID')." ";
		$sql .= "AND a.AFI_ID = p.AFI_ID ";
		$sql .= "AND c.CLI_ID = p.CLI_ID";
               
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busqueda de pacientes
	*
	* @access public
	* @param string $data Otros parametros de busqueda si esque son enviados
	* @return array Arreglo con los datos del o los pacientes si este fue encontrado
	*/
	public function pacientes_get($data = '')
	{
		$sql = "SELECT  p.PAC_ID, p.ETB_ID, p.SIT_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO,
                        p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO, p.PAC_SEXO, p.PAC_PROCEDENCIA, p.PAC_OCUPACION, p.PAC_ACTIVO,
                        a.AFI_NOMBRE, e.ETB_NOMBRE ";
		$sql .= "FROM   TC_PACIENTE AS p
                        INNER JOIN ( TC_ESTABLECIMIENTO AS e
                                    INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( e.ETB_ID = p.ETB_ID )
                        INNER JOIN TC_AFILIACION AS a ON ( a.AFI_ID = p.AFI_ID ) ";
		$sql .= "WHERE  ";
		$sql .= " e.CLI_ID = '".$this->session->userdata('CLI_ID')."' ";
		if ($data != '')
			$sql .= " AND ".$data;
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene un paciente en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del paciente
	* @return array Arreglo con los datos del paciente
	*/
	public function paciente_get($id)
	{
		$sql = "SELECT p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO, p.PAC_SEXO, p.PAC_PROCEDENCIA, p.PAC_OCUPACION, p.AFI_ID, a.AFI_NOMBRE ";
		$sql .= "FROM TC_PACIENTE AS p, TC_AFILIACION AS a ";
		$sql .= "WHERE p.PAC_ID = '".$id."' ";
		$sql .= "AND a.AFI_ID = p.AFI_ID";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

	/**
	* Obtiene todas los identificadores de un paciente.
	*
	* @access public
	* @param int $id ID del paciente
	* @return array Arreglo con todos los identificadores del paciente
	*/
	public function paciente_identificadores_get($id)
	{
		$sql = "SELECT pi.IDT_ID, pi.PAC_IDT_VALOR, i.IDT_NOMBRE ";
		$sql .= "FROM TC_PACIENTE_IDENTIFICADOR as pi, TC_IDENTIFICADOR as i ";
		$sql .= "WHERE pi.PAC_ID = '".$id."' ";
		$sql .= "AND i.IDT_ID = pi.IDT_ID";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Actualiza un paciente en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @param array $data2 Arreglo con todos los identificadores del paciente
	* @return boolean TRUE si se actualizo correctamente o FALSE si no lo hizo
	*/
	public function paciente_upd($data, $data2)
	{
		$chk = TRUE;
		foreach ($data2 as $d2) {
			$sql = "SELECT IDT_ID FROM TC_PACIENTE_IDENTIFICADOR AS pi, TC_PACIENTE AS p, TC_ESTABLECIMIENTO AS e ";
			$sql .= "WHERE pi.IDT_ID = ".$d2['IDT_ID']." ";
			$sql .= "AND pi.PAC_ID <> ".$data['PAC_ID']." ";
			$sql .= "AND pi.PAC_IDT_VALOR = '".$d2['PAC_IDT_VALOR']."' ";
			$sql .= "AND e.CLI_ID = ".$this->session->userdata('CLI_ID')." ";
			$sql .= "AND p.PAC_ID = pi.PAC_ID ";
			$sql .= "AND p.ETB_ID = e.ETB_ID";
			$query = $this->db->query($sql);
 			if ($query->num_rows() > 0)
				$chk = FALSE;
		}
		if ($chk == TRUE) {
			$this->db->where('PAC_ID', $data['PAC_ID']);
			$this->db->update('TC_PACIENTE', $data);
			$datadel['PAC_ID'] = $data['PAC_ID'];
			$this->db->delete('TC_PACIENTE_IDENTIFICADOR', $datadel);
			foreach ($data2 as $d2) {
				$ident['PAC_ID'] = $data['PAC_ID'];
				$ident['IDT_ID'] = $d2['IDT_ID'];
				$ident['PAC_IDT_VALOR'] = $d2['PAC_IDT_VALOR'];
				$this->db->insert('TC_PACIENTE_IDENTIFICADOR', $ident);
			}
			return TRUE;
		}
	}

	/**
	* Elimina un paciente en especifico por el ID recibido por parametro,
	* esto solo si el paciente no tiene TC en el sistema.
	*
	* @access public
	* @param int $id ID del paciente
	* @return boolean TRUE si se elimino correctamente
	*/
	public function paciente_del($id)
	{
		if (!$this->existe_registro('TC_TELECONSULTA', 'PAC_ID', $id)) {
			$data['PAC_ID'] = $id;
			$this->db->delete('TC_PACIENTE', $data);
			$this->db->delete('TC_PACIENTE_IDENTIFICADOR', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene las afiliaciones del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos las afiliaciones
	*/
	public function afiliaciones_get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_AFILIACION ";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene las afiliaciones del sistema con el site
	* al que pertenece para poder ser listados.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos las afiliaciones
	*/
	public function afiliaciones_lista_get( $id_site = NULL )
	{
		$sql = "SELECT a.AFI_ID, a.AFI_NOMBRE, a.AFI_DESCRIPCION, s.SIT_NOMBRE ";
		$sql .= "FROM TC_AFILIACION AS a, TC_SITE as s ";
		$sql .= "WHERE s.SIT_ID = a.SIT_ID";

        if( !empty( $id_site ) )
            $sql.=" AND a.SIT_ID = ". $id_site;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Actualiza una afiliacion en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function afiliacion_upd($data)
	{
		$idi_site = $this->afiliacion_get($data['AFI_ID']);
		if (!$this->existe_registro('TC_AFILIACION', 'AFI_NOMBRE', $data['AFI_NOMBRE'], 'AFI_ID', $data['AFI_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
			$this->db->where('AFI_ID', $data['AFI_ID']);
			$this->db->update('TC_AFILIACION', $data);
			return TRUE;
		}
	}

	/**
	* Inserta una nueva afiliacion en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function afiliacion_set($data)
	{
		if (!$this->existe_registro('TC_AFILIACION', 'AFI_NOMBRE', $data['AFI_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
			$this->db->insert('TC_AFILIACION', $data);
			return TRUE;
		}
	}

	/**
	* Elimina una afiliacion por el ID recibido por parametro,
	* esto solo si la afiliacion no esta asignada a aglun paciente.
	*
	* @access public
	* @param int $id ID de la afiliacion
	* @return boolean TRUE si se elimino correctamente
	*/
	public function afiliacion_del($id)
	{
		if (!$this->existe_registro('TC_PACIENTE', 'AFI_ID', $id)) {
			$data['AFI_ID'] = $id;
			$this->db->delete('TC_AFILIACION', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene una afiliacion en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID de la afiliacion
	* @return array Arreglo con los datos de la afiliacion
	*/
	public function afiliacion_get($id)
	{
		$sql = "SELECT a.AFI_ID, a.AFI_NOMBRE, a.AFI_DESCRIPCION, a.SIT_ID, s.SIT_NOMBRE ";
		$sql .= "FROM TC_AFILIACION AS a, TC_SITE AS s ";
		$sql .= "WHERE a.AFI_ID = '".$id."' ";
		$sql .= "AND s.SIT_ID = a.SIT_ID";
		$query = $this->db->query($sql);
		if ( $query->num_rows() > 0 ) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

    /**
     * Retorna listado de especialidades asociados a un cliente en particular
     * Necesario para usuarios del tipo <b>Generalista</b> que tienen relación
     * directa con los clientes a los que atiende (según lógica de negocios)
     * 
     * @param int $id_cliente Identificador del cliente
     * @return array listado de especialidades del cliente pasado por parámetro
     */
    public function especialidades_por_cliente( $id_cliente ) {

		$sql = "SELECT e.* ";
		$sql .= "FROM TC_ESPECIALIDAD e
                        INNER JOIN TC_CLIENTE_ESPECIALIDAD ce ON ( ce.ESP_ID = e.ESP_ID ) ";
		$sql .= " WHERE ce.CLI_ID = '".$id_cliente."' ";
		$sql .= "       AND e.ESP_ID <> '1'";

		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
    }

    /**
     * Retorna listado de especialidades de todos los clientes asociados
     * a un grupo según un usuario en particular.<br/>
     * Necesarios para usuarios del tipo <b>Supervisor</b> y <b>Especialistas</b> que tienen
     * relaciones con estas tablas (según lógica de negocios)
     * 
     * @param int $id_usuario ID del usuario <b>Supervisor</b> o <b>Especialista</b>
     */
    public function especialidades_por_usuario_grupo( $id_usuario ) {

		$sql = "SELECT DISTINCT e.* ";
		$sql .= "FROM TC_ESPECIALIDAD e
                        INNER JOIN ( TC_CLIENTE_ESPECIALIDAD ce
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN ( TC_GRUPO_CLIENTE gc
                                    INNER JOIN ( TC_GRUPO g
                                        INNER JOIN TC_GRUPO_USUARIO gu ON ( gu.GRU_ID = g.GRU_ID )
                                    ) ON ( g.GRU_ID = gc.GRU_ID )
                                ) ON ( gc.CLI_ID = c.CLI_ID )
                            ) ON ( ce.CLI_ID = c.CLI_ID )
                        ) ON ( ce.ESP_ID = e.ESP_ID ) ";
		$sql .= " WHERE gu.USU_ID = '".$id_usuario."' ";

		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
    }

	/**
	* Obtiene todas especialidades de un site en especifico
	* recibiendo el ID del site por parametro
	*
	* @access public
	* @param int $id ID del site
	* @return array Arreglo con las especialidades encontradas
	*/
 	public function especialidades_site_get($id)
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_ESPECIALIDAD ";
		$sql .= "WHERE SIT_ID = '".$id."' ";
		$sql .= "AND ESP_ID <> '1'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene las especialidades del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos las especialidades
	*/
	public function especialidades_get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_ESPECIALIDAD";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene una especialidad en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID de la especialidad
	* @return array Arreglo con los datos de la afiliacion
	*/
	public function especialidad_get($id)
	{
		$sql = "SELECT e.ESP_ID, e.ESP_NOMBRE, e.ESP_DESCRIPCION, e.SIT_ID, s.SIT_NOMBRE ";
		$sql .= "FROM TC_ESPECIALIDAD AS e, TC_SITE AS s ";
		$sql .= "WHERE e.ESP_ID = ".$id." ";
		$sql .= "AND s.SIT_ID = e.SIT_ID ";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;	
	}

	/**
	* Obtiene las especialidades del sistema con su site
	* al que pertene para poder ser listados.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos las especialidades
	*/
	public function especialidades_lista_get( $id_site = NULL )
	{
		$sql = "SELECT e.ESP_ID, e.ESP_NOMBRE, e.ESP_DESCRIPCION, s.SIT_NOMBRE ";
		$sql .= "FROM TC_ESPECIALIDAD AS e, TC_SITE as s ";
		$sql .= "WHERE s.SIT_ID = e.SIT_ID";

        if( !empty( $id_site ) ) 
            $sql.= " AND e.SIT_ID = " . $id_site ;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Actualiza una especialidad en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function especialidad_upd($data)
	{
		if (!$this->existe_registro('TC_ESPECIALIDAD', 'ESP_NOMBRE', $data['ESP_NOMBRE'], 'ESP_ID', $data['ESP_ID'], 'SIT_ID', $data['SIT_ID'])) {
			$this->db->where('ESP_ID', $data['ESP_ID']);
			$this->db->update('TC_ESPECIALIDAD', $data);
			return TRUE;
		}
	}

	/**
	* Inserta una nueva especialidad en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function especialidad_set($data)
	{
		if (!$this->existe_registro('TC_ESPECIALIDAD', 'ESP_NOMBRE', $data['ESP_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
			$this->db->insert('TC_ESPECIALIDAD', $data);
			return TRUE;
		}
	}

	/**
	* Elimina una especialidad por el ID recibido por parametro,
	* esto solo si la especialidad no esta asignada a aglun especialista.
	*
	* @access public
	* @param int $id ID de la especialidad
	* @return boolean TRUE si se elimino correctamente
	*/
	public function especialidad_del($id)
	{
		if (!$this->existe_registro('TC_USUARIO_ESPECIALIDAD', 'ESP_ID', $id)) {
			$data['ESP_ID'] = $id;
			$this->db->delete('TC_ESPECIALIDAD', $data);
			return TRUE;
		}
	}

	/**
	* Obtiene los identificadores del sistema.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los identificadores
	*/
	public function identificadores_get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_IDENTIFICADOR";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;	
	}

	/**
	* Obtiene un identificador en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del identificador
	* @return array Arreglo con los datos del identificador
	*/
	public function identificador_get($id)
	{
		$sql = "SELECT i.IDT_ID, i.IDT_NOMBRE, i.IDT_DESCRIPCION, i.SIT_ID, s.SIT_NOMBRE ";
		$sql .= "FROM TC_IDENTIFICADOR AS i, TC_SITE AS s ";
		$sql .= "WHERE i.IDT_ID = ".$id." ";
		$sql .= "AND s.SIT_ID = i.SIT_ID";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

	/**
	* Obtiene los identificadores del sistema con su site
	* al que pertene para poder ser listados.
	*
	* @access public
	* @param none
	* @return array Arreglo con todos los identificadores
	*/
	public function identificadores_lista_get( $id_site = NULL )
	{
		$sql = "SELECT i.IDT_ID, i.IDT_NOMBRE, i.IDT_DESCRIPCION, s.SIT_NOMBRE ";
		$sql .= "FROM TC_IDENTIFICADOR AS i, TC_SITE AS s ";
		$sql .= "WHERE s.SIT_ID = i.SIT_ID ";

        if( !empty( $id_site ) )
            $sql.= " AND i.SIT_ID = ". $id_site;

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Actualiza un identificador en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function identificador_upd($data)
	{
		$idi_site = $this->identificador_get($data['IDT_ID']);
		if (!$this->existe_registro('TC_IDENTIFICADOR', 'IDT_NOMBRE', $data['IDT_NOMBRE'], 'IDT_ID', $data['IDT_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
			$this->db->where('IDT_ID', $data['IDT_ID']);
			$this->db->update('TC_IDENTIFICADOR', $data);
			return TRUE;
		}
	}

	/**
	* Inserta un nuevo identificador en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function identificador_set($data)
	{
		
		if (!$this->existe_registro('TC_IDENTIFICADOR', 'IDT_NOMBRE', $data['IDT_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
			$this->db->insert('TC_IDENTIFICADOR', $data);
			return TRUE;
		}
	}

	/**
	* Elimina un identificador por el ID recibido por parametro,
	* esto solo si el identificador no esta asignada a aglun paciente.
	*
	* @access public
	* @param int $id ID del identificador
	* @return boolean TRUE si se elimino correctamente
	*/
	public function identificador_del($id)
	{
		if (!$this->existe_registro('TC_PACIENTE_IDENTIFICADOR', 'IDT_ID', $id)) {
			$data['IDT_ID'] = $id;
			$this->db->delete('TC_IDENTIFICADOR', $data);
			return TRUE;
		}
	}

	/**
	* Inserta una nueva TC en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return boolean TRUE si se inserto correctamente
	*/
	public function tc_set($data)
	{
		$this->db->insert('TC_TELECONSULTA', $data);
		$id = $this->db->insert_id();
		$ident = $this->paciente_identificadores_get($data['PAC_ID']);
		foreach ($ident as $i) {
			$newdata['TEL_ID'] = $id;
			$newdata['TCI_NOMBRE'] = $i['IDT_NOMBRE'];
			$newdata['TCI_VALOR'] = $i['PAC_IDT_VALOR'];
			$this->db->insert('TC_TELPAC_IDENTIFICADOR', $newdata);
		}
		return $id;
	}

	/**
	* Metodo que arma parte de un sql query que busca las TC por
	* especialidades de un usuario rol3 especialista.
	*
	* @access private
	* @param none
	* @return string $sql con la SQL armada
	*/
	private function sql_usu_especialdiades_tc()
	{
		$sql = '';
		$usuario = $this->usuario_especialidades_get($this->session->userdata('USU_ID'));
		$chk = FALSE;
		foreach ($usuario as $usu) {
			if ($chk == FALSE) {
				$sql .= "AND (t.ESP_ID = '".$usu['ESP_ID']."' ";
				$chk = TRUE;
			}
			else
				$sql .= "OR t.ESP_ID = '".$usu['ESP_ID']."' ";
		}
		$sql .= ") ";
		if ($chk == TRUE)
			return $sql;
		else
			return NULL;
	}

	/**
	* Obtiene todas las TC de un paciente menos una en especifica
	* valores recibidos por parametro.
	*
	* @access public
	* @param int $pac_id ID del paciente
	* @param int $ptc_id ID de la TC que no se requiere datos
	* @return array Arreglo con todas las TC del paciente menos la que no se requiere
	*/
	public function tc_paciente_get($pac_id, $tc_id)
	{
		$sql = "SELECT  DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO,
                        date_format( t.TEL_FECHA_HORA, '%d/%m/%Y %H:%m' ) as TEL_FECHA_HORA, t.EST_ID, t.PRI_ID,
                        t.TEL_MOTIVO ,
                        e.ETB_NOMBRE, e.ETB_NIVEL, es.ESP_NOMBRE ";

        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
	    $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
	    $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        // Visualiza TC's que pertenencen al paciente $pac_id
		$sql .= "AND t.PAC_ID = ".$pac_id." ";

		// Descarta la TC que se está visualizando
        $sql .= "AND t.TEL_ID <> ".$tc_id." ";

        // Descarta estados 1: Borrador, 3: Rechazados, 4: Eliminados
		$sql .= "AND t.EST_ID <> 1 ";
		$sql .= "AND t.EST_ID <> 3 ";
		$sql .= "AND t.EST_ID <> 4 ";

        $query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Obtiene las TC segun estado.
	*
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    * 
	* @access public
	* @param int $estado Estado de la TC
	* @param int $flag Bandera para buscar solo TC que no han sido abiertas en el estado en que se encuentra
	* @param int $flag Flag para setear un orden en que devolvera la busqueda de las TC
	* @return array Arreglo con la TC encontradas
	*/
	public function tc_lista_get($estado = '', $flag = '', $order = '')
	{
		$sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_FECHA_HORA,
                        t.EST_ID, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL ";

        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";

            if( $this->session->userdata('ROL_ID') == 3 )
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID') ). ' ';
        }

        if( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        // Establece el estado
        $sql .= "AND t.EST_ID = ".$estado." ";

        if ($flag == 1)
			$sql .= "AND t.TEL_ABIERTA = 1 ";

		if ($order != '')
			$sql .= "ORDER BY t.PRI_ID ASC, t.TEL_ID ".$order;
		else
			$sql .= "ORDER BY t.PRI_ID ASC";
//imprimir( $sql );
        $query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busca una TC segun el ID de esta.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    * 
	* @access public
	* @param int $id ID de la TC
	* @param int $estado Estado de la TC
	* @return array Arreglo con la TC encontradas
	*/
	public function tc_busca_tcid($id, $estado)
	{
		$sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_FECHA_HORA,
                        t.EST_ID, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL ";

        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            if( $this->session->userdata('ROL_ID') == 3 )
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID') ). ' ';
        }

        if( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        // Establece el estado
        $sql .= "AND t.EST_ID = ".$estado." ";
		$sql .= "AND t.TEL_ID = ".$id." ";

        $sql .= "ORDER BY t.PRI_ID ASC ";
//imprimir( $sql );
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busca las TC de un paciente segun el identificador de este.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
	* @access public
	* @param string $id Identificador del paciente a buscar TC
	* @param int $estado Estado de la TC
	* @return array Arreglo con todas las TC encontradas
	*/
	public function tc_busca_id($id, $estado)
	{
		$sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_FECHA_HORA,
                        t.EST_ID, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL ";

        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";

            if( $this->session->userdata('ROL_ID') == 3 )
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID') ). ' ';
        }

        if( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

		$sql .= "AND ti.TCI_VALOR = '".$id."' ";
		$sql .= "AND t.EST_ID = ".$estado." ";

        $sql .= "ORDER BY t.PRI_ID ASC ";

        $query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busca las TC de un paciente segun su nombre y/o apellido y el
	* estado en que se encuentra.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    * 
	* @access public
	* @param string $nombre Nombre del paciente a buscar TC
	* @param string $apellido Apellido del paciente a buscar TC
	* @param int $estado Estado de la TC
	* @return array Arreglo con todas las TC encontradas
	*/
	public function tc_busca_na( $estado, $nombre = '', $apellido = '' )
	{
		$sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_FECHA_HORA,
                        t.EST_ID, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL ";

        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            
            if( $this->session->userdata('ROL_ID') == 3 )
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID') ). ' ';
        }

        if( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        
        $sql .= " AND t.EST_ID = " . $estado;

        if ( !empty( $nombre ) )
			$sql .= " AND t.TEL_PAC_PRIMER_NOMBRE LIKE '%".$nombre."%' ";

        if ( !empty( $apellido ) )
			$sql .= " AND t.TEL_PAC_PRIMER_APELLIDO LIKE '%".$apellido."%' ";

        $sql .= "ORDER BY t.PRI_ID ASC ";

        $query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}


	/**
	* Obtiene una TC en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID de la TC
	* @return array Arreglo con los datos de la TC
	*/
	public function tc_get($id)
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_TELECONSULTA ";
        
        if( $this->session->userdata('SIT_ID') == 22 ) {

            $sql.= "    LEFT JOIN TC_ENTIDADES_ADMINISTRADORAS ON ( TC_ENTIDADES_ADMINISTRADORAS.ENTADM_ID = TC_TELECONSULTA.ENTADM_ID )
                        LEFT JOIN TC_FINALIDAD_PROCEDIMIENTO ON ( TC_FINALIDAD_PROCEDIMIENTO.FINPROC_ID = TC_TELECONSULTA.FINPROC_ID )
                        LEFT JOIN TC_ZONA_RESIDENCIA ON ( TC_ZONA_RESIDENCIA.ZON_ID = TC_TELECONSULTA.ZON_ID )
                        LEFT JOIN TC_AMBITO_PROCEDIMIENTO ON ( TC_AMBITO_PROCEDIMIENTO.AMBPROC_ID = TC_TELECONSULTA.AMBPROC_ID ) ";
        }

        $sql .= "WHERE TEL_ID = '".$id."'";

		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			$sql2 = "SELECT ESP_NOMBRE ";
			$sql2 .= "FROM TC_ESPECIALIDAD ";
			$sql2 .= "WHERE ESP_ID = '".$row[0]['ESP_ID']."'";
			$query = $this->db->query($sql2);
			$row2 = $query->result_array();
			$row[0]['ESP_NOMBRE'] = $row2[0]['ESP_NOMBRE'];
			$row[0]['RESPONDER'] = FALSE;
			if (($this->session->userdata('ROL_ID') == 3 && ($row[0]['EST_ID'] == 2 || $row[0]['EST_ID'] == 6)) ||
				($this->session->userdata('ROL_ID') > 3 && ($row[0]['EST_ID'] == 1 || $row[0]['EST_ID'] == 3 || $row[0]['EST_ID'] == 5 || $row[0]['EST_ID'] == 7)))
				$this->tc_abierta_ex($row[0]['TEL_ID'], 0);
			if ($this->session->userdata('ROL_ID') == 3) {
				$usuario = $this->usuario_especialidades_get($this->session->userdata('USU_ID'));
				foreach ($usuario as $usu) {
					if ($usu['ESP_ID'] == $row[0]['ESP_ID'])
						$row[0]['RESPONDER'] = TRUE;
				}
			}
			if ($this->session->userdata('ROL_ID') > 3) {
				$usuario = $this->usuario_get($this->session->userdata('USU_ID'));

                $establecimientos_usuario = $this->usuario_establecimientos_get( $usuario['USU_ID'] );
                foreach( $establecimientos_usuario as $e )
                    if( $e['ETB_ID'] == $row[0]['ETB_ID'])
                        $row[0]['RESPONDER'] = TRUE;
			}
			return $row[0];
		}
		else
			return NULL;
	}

    /**
     * Obtiene un listado con los estados que ha pasado la Teleconsulta
     * ordenado de manera descendente segun fecha.
     * @param type $id Identificador de la TC
     * @param type $id_estado (opcional) solo listar los que están en algún estado en particular
     *                          si no se establece muestra todos los estados
     */
    public function tc_historia( $id, $id_estado = null ) {

        $sql = 'SELECT u.USU_NOMBRE,
                        e.EST_ID, date_format( e.TEP_FECHA_HORA, \'%H:%i:%s %d/%m/%Y\' ) as TEP_FECHA_HORA, e.TEP_COMENTARIO
                FROM TC_TELECONSULTA_ESTADO e
                     INNER JOIN TC_USUARIO u ON (u.USU_ID = e.USU_ID)
                WHERE TEL_ID = '.$id;
        if( !empty( $id_estado ) )
            if( is_array( $id_estado ) )
                $sql.= ' AND e.EST_ID in ( ' .$id_estado . ' )';
            else
                $sql.= ' AND e.EST_ID = ' .$id_estado;

        $sql.= ' ORDER BY e.TEP_FECHA_HORA DESC';

        $query = $this->db->query( $sql );
        return $query->result_array();
    }

    /**
	* Actualiza una TC marcandola como abierta si fue leida por un especialista
	* o generalista dependiendo del estado de esta.
	*
	* @access public
	* @param int $id ID de la TC
	* @param int $abierta Como se marcara, abierta o cerrada
	* @return none
	*/
	public function tc_abierta_ex($id, $abierta)
	{
		$data['TEL_ID'] = $id;
		$data['TEL_ABIERTA'] = $abierta;
		$this->db->where('TEL_ID', $data['TEL_ID']);
		$this->db->update('TC_TELECONSULTA', $data);
	}

	/**
	* Saca de la db todos los identificadores de un paciente para
	* una TC en especifico, esta es la foto de los identificadores
	* cuando se genera la TC.
	*
	* @access public
	* @param int $id ID de la TC
	* @return array Arreglo con todos los identificadores del paciente
	*/
	public function tc_ident_get($id)
	{
		$sql = "SELECT * ";
		$sql .= "FROM TC_TELPAC_IDENTIFICADOR ";
		$sql .= "WHERE TEL_ID = '".$id."'";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0)
			return  $query->result_array();
		else
			return NULL;
	}

	/**
	* Saca de la db todos los identificadores de un paciente en especifico
	* segun el ID de este que llega por parametro.
	*
	* @access public
	* @param int $id ID del paciente
	* @return array Arreglo con todos los identificadores del paciente
	*/
	public function ident_get($id)
	{
		$sql = "SELECT pi.PAC_IDT_VALOR, i.IDT_NOMBRE ";
		$sql .= "FROM TC_PACIENTE_IDENTIFICADOR AS pi, TC_IDENTIFICADOR AS i ";
		$sql .= "WHERE pi.PAC_ID = '".$id."' ";
		$sql .= "AND i.IDT_ID = pi.IDT_ID";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row;
		}
		else
			return NULL;
	}

	/**
	* Actualiza una TC en especifico, recibiendo
	* los datos en un arreglo por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos a actualizar
	* @return boolean TRUE si se actualizo correctamente
	*/
	public function tc_upd($data)
	{
		if ($this->existe_registro('TC_TELECONSULTA', 'TEL_ID', $data['TEL_ID'])) {
			$this->db->where('TEL_ID', $data['TEL_ID']);
			$this->db->update('TC_TELECONSULTA', $data);
			if ($data['EST_ID'] != 1)
				$this->tc_abierta_ex($data['TEL_ID'], 1);
			return TRUE;
		}
	}

	/**
	* Elimina una TC del sistema por el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID de la TC
	* @return boolean TRUE si se elimino correctamente
	*/
	public function tc_del($id)
	{
		$data['TEL_ID'] = $id;
		$this->db->delete('TC_TELECONSULTA', $data);
		$this->db->delete('TC_TELPAC_IDENTIFICADOR', $data);
		return TRUE;
	}

        /**
	* @access public
	* @param int $id ID de la TC
	* @param string $texto Evalución en texto de la TC
	* @param int $nota nota de evualiación de la TC
	* @return boolean TRUE si se ha ingresado la evualiacion
         */
        public function tc_guardar_evaluacion( $id, $texto, $nota ) {

            $datos = array( 'TEL_EVALUACION_COMENTARIO' => $texto,
                            'TEL_EVALUACION_PUNTAJE' => $nota );
            
            $this->db->where( 'TEL_ID', $id );
            $estado = $this->db->update( 'TC_TELECONSULTA', $datos );
            
            if( !empty( $estado ) )
                return true;
            else
                return false;
        }

	/**
	* Metodo que sirve para buscar si existe un registro en la db
	* segun datos que llegan por parametro.
	*
	* @access public
	* @param string $tabla Tabla de la db a la cual se le hara la consulta
	* @param string $campo Campo que se consultara
	* @param string $compare Valor del campo que se busca
	* @param string $nocompare Campo que no comparara
	* @param string $datanocompare Dato del campo a no coparar
	* @param string $otrocampo Otro campo a buscar
	* @param string $otrocompare Dato a buscar en ese campo
	* @return boolean TRUE si encuentra resultado o FALSE sino
	*/
	public function existe_registro($tabla, $campo, $compare, $nocompare = NULL, $datanocompare = NULL, $otrocampo = NULL, $otrocompare = NULL)
	{
		$sql = 'SELECT * FROM '.$tabla.' WHERE '.$campo.' = "'.$compare.'"';
		if ($otrocampo != NULL)
			$sql .= ' AND '.$otrocampo.' = "'.$otrocompare.'"';
		if ($nocompare != NULL)
			$sql .= ' AND '.$nocompare.' <> "'.$datanocompare.'"';
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0)
			return TRUE;
		else
			return FALSE;
	}

	/**
	* Metodo que sirve para buscar un usuario segun el tipo y el nombre
	* busca hacer match con string ingresado.
	*
	* @access public
	* @param int $tipo Tipo de usuario (generalista o especialista)
	* @return array Con el resultado de la busqueda
	*/
	public function autocomplete_search_get($tipo, $match)
	{
		$sql = "SELECT u.USU_ID, u.USU_NOMBRE ";
		$sql .= "FROM TC_USUARIO AS u ";
        $sql .= "       LEFT JOIN TC_USUARIO_ESPECIALIDAD AS ue ON ue.USU_ID = u.USU_ID ";
		$sql .= "WHERE u.SIT_ID = ".$this->session->userdata('SIT_ID')." ";
		if ($tipo == 'especialista') {
			$sql .= "AND u.ROL_ID = 3 ";

			if ($this->session->userdata('autocomplete_especialidad') != NULL) {
				$sql .= "AND ue.ESP_ID = ".$this->session->userdata('autocomplete_especialidad')." ";
				$sql .= "AND u.USU_ID = ue.USU_ID ";
			}
		}
		else if ($tipo == 'generalista') {
			$sql .= "AND u.ROL_ID = 4 ";
			if ($this->session->userdata('autocomplete_establ') != NULL)
				$sql .= "AND u.ETB_ID = ".$this->session->userdata('autocomplete_establ')." ";
			else if ($this->session->userdata('autocomplete_cliente') != NULL) {
				$sql .= "AND u.CLI_ID = ".$this->session->userdata('autocomplete_cliente')." ";
			}
			else
				$sql .= "AND u.CLI_ID = ".$this->session->userdata('CLI_ID')." ";
		}
		$sql .= "AND u.USU_NOMBRE LIKE '%".$match."%' ";
		$sql .= "GROUP BY u.USU_ID ";
		$sql .= "ORDER BY u.USU_NOMBRE ASC";

		$query = $this->db->query($sql);
		if ($query->num_rows() > 0 )
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busca TC en el sistema con datos para la query recibidos
	* por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para la busqueda
	* @return array Con todos las TC encontradas
	*/
	public function buscar_tc_b($data)
	{
		$sql = "SELECT  DISTINCT t.TEL_ID, t.EST_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO,
                        e.ETB_NOMBRE, es.ESP_NOMBRE ";

		$sql .= "FROM TC_TELECONSULTA AS t ";
        $sql .= "       INNER JOIN ( TC_ESPECIALIDAD AS es ) on ( es.ESP_ID = t.ESP_ID ) ";
        $sql .= "       INNER JOIN ( TC_TELECONSULTA_ESTADO AS te ) on ( te.TEL_ID = t.TEL_ID ) ";


        // 1: Administrador lista todas las TC's de su Site (sin cruzar con Grupo)
        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";

            // Búsqueda por Cliente
            if ($data['cliente'] != 0 && $data['establ'] == 0) {
				$sql .= "WHERE e.CLI_ID = ".$data['cliente']." ";
			}
            // Búsqueda por Establecimiento
			elseif ($data['cliente'] != 0 && $data['establ'] != 0)
                $sql .= "WHERE t.ETB_ID = ".$data['establ']." ";
        }

        // 2: Supervisor y 3: Especialista listan TC's usando Grupos
        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {

            // Por omision de cliente y establecimiento
            if ($data['cliente'] == 0 && $data['establ'] == 0) {
                $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                                INNER JOIN ( TC_CLIENTE c
                                                                INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                                INNER JOIN ( TC_GRUPO g
                                                                                                INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                                ) ON ( g.GRU_ID = gc.GRU_ID )
                                                                ) ON ( gc.CLI_ID = c.CLI_ID )
                                                ) ON ( c.CLI_ID = e.CLI_ID )
                                ) ON ( t.ETB_ID = e.ETB_ID ) ";
                $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            }
            // Búsqueda por Cliente
            else if ($data['cliente'] != 0 && $data['establ'] == 0) {
                $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";
                $sql .= "WHERE  e.CLI_ID = " . $data['cliente'] . " ";
            }
            // Búsqueda por establecimiento
            else {
                $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";
                $sql .= "WHERE t.ETB_ID = ".$data['establ']." ";
            }
        }

        // 4: Médico generalista y 5: Especialistas
        if ( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";
            if ($data['establ'] != 0)
				$sql .= "WHERE  t.ETB_ID = ".$data['establ']." ";
        }

        // Filtra TC's por site del usuario
        $sql .= "AND t.SIT_ID = ".$this->session->userdata('SIT_ID')." ";

        // Filtro Especialidad
		if ($data['especialidad'] != 0)
			$sql .= "AND t.ESP_ID = ".$data['especialidad']." ";

        // Filtro por estados de la TC's
		if ($data['estado'] != '' && $data['estado'] != 0)
			$sql .= "AND t.EST_ID = ".$data['estado']." ";

        // Filtro generalista que envió TC
		if ($data['generalista'] != 0)
			$sql .= "AND (te.EST_ID = 2 AND te.USU_ID = ".$data['generalista'].") ";

        // Filtro especialita primera respuesta <-- ?
		if ($data['especialista1'] != 0)
			$sql .= "AND (te.EST_ID = 5 AND te.USU_ID = ".$data['especialista1'].") ";

        // Filtro especialista2 <------- ?
		if ($data['especialista2'] != 0)
			$sql .= "AND (te.EST_ID = 7 AND te.USU_ID = ".$data['especialista2'].") ";

        // Descarta TC's borradores a los 1: Admins, 2: Supervisores y 3: Especialistas
		if ($this->session->userdata('ROL_ID') < 4)
			$sql .= "AND t.EST_ID <> 1 ";

        // Filtra TC's en estado 4 ^_^!<-------- ???????
		if ($this->session->userdata('ROL_ID') > 2)
			$sql .= "AND t.EST_ID <> 4 ";

        // Filtro fecha enviados
		if ($data['fecha_env_desde'] != 0 && $data['fecha_env_hasta'] != 0 && $data['generalista'] != 0)
			$sql .= "AND (te.TEP_FECHA_HORA BETWEEN '".$data['fecha_env_desde']."' AND '".$data['fecha_env_hasta']."' AND te.EST_ID = 2 AND te.USU_ID = ".$data['generalista'].") ";
		else if ($data['fecha_env_desde'] != 0 && $data['fecha_env_hasta'] != 0)
			$sql .= "AND (te.TEP_FECHA_HORA BETWEEN '".$data['fecha_env_desde']."' AND '".$data['fecha_env_hasta']."' AND te.EST_ID = 2) ";

        // Filtro fecha contestados
		if ($data['fecha_con_desde'] != 0 && $data['fecha_con_hasta'] != 0 && $data['estado'] == 7 && $data['especialista2'] != 0)
			$sql .= "AND (te.TEP_FECHA_HORA BETWEEN '".$data['fecha_con_desde']."' AND '".$data['fecha_con_hasta']."' AND te.EST_ID = 7 AND te.USU_ID = ".$data['especialista2'].") ";
		else if ($data['fecha_con_desde'] != 0 && $data['fecha_con_hasta'] != 0 && $data['estado'] == 7)
			$sql .= "AND (te.TEP_FECHA_HORA BETWEEN '".$data['fecha_con_desde']."' AND '".$data['fecha_con_hasta']."' AND te.EST_ID = 7) ";

//		$dat['sqlsearch'] = $sql;
		$query = $this->db->query($sql);
		$dat['tc_cantidad'] = $query->num_rows();
//		$this->session->set_userdata($dat);
 		if ($dat['tc_cantidad'] > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Busca una TC en especifico con el ID y el estado de esta,
	* recibiendo los datos por parametro.
	*
	* @access public
	* @param int $id ID de la TC
	* @param int $estado Estado de la TC
	* @return array Con todos los datos de la TC
	*/
	public function busca_tc_estado($id, $estado)
	{
		$sql = "SELECT u.USU_NOMBRE, te.TEP_FECHA_HORA ";
		$sql .= "FROM TC_USUARIO AS u, TC_TELECONSULTA_ESTADO AS te ";
		$sql .= "WHERE te.TEL_ID = ".$id." ";
		$sql .= "AND te.EST_ID = ".$estado." ";
		$sql .= "AND u.USU_ID = te.USU_ID";
		$query = $this->db->query($sql);
 		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

	/**
	* Busca una TC en especifico con el ID de esta
	* recibida por parametro.
	*
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    * 
	* @access public
	* @param int $id ID de la TC
	* @return array Con todos los datos de la TC
	*/
	public function busca_tcid($id)
	{
		$sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO,
                        t.EST_ID, e.ETB_NOMBRE, es.ESP_NOMBRE ";

        if( $this->session->userdata('ROL_ID') == 1 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( es.ESP_ID = t.ESP_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
            $sql .= "AND    t.EST_ID <> 1  ";
        }

        if( $this->session->userdata('ROL_ID') == 2 ||
            $this->session->userdata('ROL_ID') == 3 ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID )
                            INNER JOIN ( TC_ESPECIALIDAD es ) ON ( es.ESP_ID = t.ESP_ID ) ";

            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "AND    t.EST_ID <> 4 ";
        }

        if( $this->session->userdata('ROL_ID') > 3 ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( es.ESP_ID = t.ESP_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "AND    t.EST_ID <> 4 ";
        }

        if ( !empty( $id ) )
			$sql .= " AND t.TEL_ID = ".$id." ";

        // Descarta TC en estado "Borrador"
        $sql .= "AND t.EST_ID <> 1 ";
		$sql .= "GROUP BY t.TEL_ID "; // <------- ????????????

        $sql .= "ORDER BY t.PRI_ID ASC ";

        $dat['sqlsearch'] = $sql;
		$query = $this->db->query($sql);
		$dat['tc_cantidad'] = $query->num_rows();
//		$this->session->set_userdata($dat);
 		if ($dat['tc_cantidad'] > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
	* Inserta un nuevo reporte en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return int Con el ID del reporte insertado
	*/
	public function reporte_set($data)
	{
		$this->db->insert('TC_REPORTE', $data);
		return $this->db->insert_id();
	}

	/**
	* Inserta el detalle del reporte en la db,
	* recibiendo los datos en un arreglo pasado por parametro.
	*
	* @access public
	* @param array $data Arreglo con todos los datos para el nuevo insert
	* @return none
	*/
	public function reporte_detalle_set($data)
	{
		$this->db->insert('TC_REPORTE_DETALLE', $data);
	}

	/**
    * Campos RIPS: Entidades administradoras
	* Obtiene listado de entidades administradoras
	*
	* @access public
	* @return array Arreglo con los datos de las entidades administradoras
	*/
	public function entidades_administradoras_get( )
	{
        $this->db->order_by( 'ENTADM_NOMBRE' );
		$query = $this->db->get('TC_ENTIDADES_ADMINISTRADORAS');
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

    public function entidades_administradoras__con_codigo_get( ) {

        $entidades = $this->entidades_administradoras_get();
        $listado_entidades = array( );
        foreach( $entidades as $v )
            $listado_entidades[] = array( 'ENTADM_ID' => $v['ENTADM_ID'], 'ENTADM_NOMBRE' => $v['ENTADM_NOMBRE'] . ' ['.$v['ENTADM_ID'].'] ');

        return $listado_entidades;
    }

	/**
    * Campos RIPS: Finalidad procedimiento
	* Obtiene listado de finalidad de procedimientos
	*
	* @access public
	* @return array Arreglo con los datos de procedimientos
	*/
	public function finalidad_procedimiento_get( )
	{
        $this->db->order_by( 'FINPROC_PREDETERMINADO', 'DESC' );
        $this->db->order_by( 'FINPROC_DESCRIPCION' );
		$query = $this->db->get('TC_FINALIDAD_PROCEDIMIENTO');
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
    * Campos RIPS: Municipio
	* Obtiene listado de municipalidades
	*
	* @access public
	* @return array Arreglo con los datos de municipios
	*/
	public function municipio_get( )
	{
        $this->db->order_by( 'MUNI_NOMBRE' );
		$query = $this->db->get('TC_MUNICIPIO');
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

	/**
    * Campos RIPS: Ambitos de procedimiento
	* Obtiene listado de ambitos de procedimiento
	*
	* @access public
	* @return array Arreglo con los datos de ambitos de procedimiento
	*/
	public function ambito_procedimiento_get( )
	{
        $this->db->order_by( 'AMBPROC_DESCRIPCION' );
		$query = $this->db->get('TC_AMBITO_PROCEDIMIENTO');
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

    /**
    * Campos RIPS: Zona residencia
	* Obtiene listado de zona de residencia
	* Actualmente dos valores: Urbano y Rural
	* @access public
	* @return array Arreglo con los datos de zona de residencia
     */
    public function zona_residencia_get( ) {

		$query = $this->db->get('TC_ZONA_RESIDENCIA');
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
    }

	/**
	* Obtiene un reporte en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del reporte
	* @return array Arreglo con los datos del reporte
	*/
	public function reporte_get($id)
	{
		$this->db->where('REP_ID', $id);
		$query = $this->db->get('TC_REPORTE');
		if ($query->num_rows() > 0) {
			$row = $query->result_array();
			return $row[0];
		}
		else
			return NULL;
	}

	/**
	* Obtiene el detalle de un reporte en especifico,
	* segun el ID recibido por parametro.
	*
	* @access public
	* @param int $id ID del reporte
	* @return array Arreglo con los datos del detalle del reporte
	*/
	public function reporte_detalle_get($id)
	{
		$this->db->where('REP_ID', $id);
		$query = $this->db->get('TC_REPORTE_DETALLE');
		if ($query->num_rows() > 0)
			return $query->result_array();
		else
			return NULL;
	}

    /**
     * 
     */
    public function reporte_usuarios_del_servicio( $fecha_ini, $fecha_fin = null, $id_cliente = NULL ) {

        $sql = "SELECT  tc.TEL_ID, i.TIPO_IDENTIFICACION, pi.PAC_IDT_VALOR,
                        tc.ENTADM_ID, a.ID_PACIENTE_TIPO as ID_PACIENTE_TIPO,
                        tc.TEL_PAC_PRIMER_APELLIDO, tc.TEL_PAC_SEGUNDO_APELLIDO, tc.TEL_PAC_PRIMER_NOMBRE, tc.TEL_PAC_SEGUNDO_NOMBRE,
                        tc.TEL_PAC_EDAD, 1 AS UNIDAD_ANOS, tc.TEL_PAC_SEXO, 
                        m.DEPTO_CODIGO, m.MUNI_CODIGO, tc.ZON_ID

                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                                                        INNER JOIN TC_IDENTIFICADOR i ON (i.IDT_ID = pi.IDT_ID )
                                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )";

        $sql.= "    INNER JOIN ( TC_ESTABLECIMIENTO e ";

//        if( !empty( $id_cliente ) )
//            $sql.=" INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID ) ";

        $sql.= "    INNER JOIN TC_MUNICIPIO m ON ( m.MUNI_ID = e.MUNI_ID )
                ) ON ( e.ETB_ID = tc.ETB_ID )
                INNER JOIN TC_AFILIACION a ON ( a.AFI_ID = tc.AFI_ID ) ";

        $sql.= "WHERE   tc.TEL_FECHA_HORA >= str_to_date( '" . $fecha_ini . "', '%d/%m/%Y' ) ";
        
        if( !empty( $fecha_fin ) )
            $sql.= " AND    tc.TEL_FECHA_HORA <= str_to_date( '" . $fecha_fin . "', '%d/%m/%Y' ) ";
        
        if( !empty( $id_cliente ) )
            $sql.= "    AND e.CLI_ID = '". $id_cliente . "' ";
//imprimir( $sql );
		$query = $this->db->query( $sql );
		if ($query->num_rows() > 0 ) {
			return $query->result_array();
		} else
			return NULL;
    }

    /**
     * 
     */
/*
    public function reporte_servicios_facturados( $fecha_ini, $fecha_fin = null, $id_cliente = NULL ) {

        $sql = "SELECT  c.CLI_RUT, c.CLI_RAZON_SOCIAL,
                        i.TIPO_IDENTIFICACION, pi.PAC_IDT_VALOR,
                        null as NUMERO_FACTURA,
                        null as FECHA_EXPEDICION_FACTURA,
                        null as FECHA_INICIO,
                        null as FECHA_FIN

                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                                                        INNER JOIN TC_IDENTIFICADOR i ON (i.IDT_ID = pi.IDT_ID )
                                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )

                        INNER JOIN ( TC_ESTABLECIMIENTO e
                                    INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( e.ETB_ID = tc.ETB_ID ) ";

        $sql.= "WHERE   tc.TEL_FECHA_HORA >= str_to_date( '" . $fecha_ini . "', '%d/%m/%Y' ) ";
        
        if( !empty( $fecha_fin ) )
            $sql.= " AND    tc.TEL_FECHA_HORA <= str_to_date( '" . $fecha_fin . "', '%d/%m/%Y' ) ";

		$query = $this->db->query( $sql );
		if ($query->num_rows() > 0 ) {
			return $query->result_array();
		} else
			return NULL;
    }
*/
    /**
     * 
     */
    public function reporte_archivo_consulta( $fecha_ini, $fecha_fin = null, $id_cliente = NULL ) {

        $sql = "SELECT  i.TIPO_IDENTIFICACION, pi.PAC_IDT_VALOR,
                        date_format( tc.TEL_FECHA_HORA, '%d/%m/%Y %H:%i:%s' ) as TEL_FECHA_HORA, tc.TEL_CODIGO_AUTORIZACION,
                        tc.TEL_ID, tc.FINPROC_ID

                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                                                        INNER JOIN TC_IDENTIFICADOR i ON (i.IDT_ID = pi.IDT_ID )
                                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )
                        
                        INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = tc.ETB_ID ) ";

        $sql.= "WHERE   tc.TEL_FECHA_HORA >= str_to_date( '" . $fecha_ini . "', '%d/%m/%Y' ) ";
        
        if( !empty( $fecha_fin ) )
            $sql.= " AND    tc.TEL_FECHA_HORA <= str_to_date( '" . $fecha_fin . "', '%d/%m/%Y' ) ";
        
        if( !empty( $id_cliente ) )
            $sql.= "    AND e.CLI_ID = '". $id_cliente . "' ";
//imprimir( $sql );
		$query = $this->db->query( $sql );
		if ($query->num_rows() > 0 ) {
			return $query->result_array();
		} else
			return NULL;
    }

}

