<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Tc_Virtual extends CI_Controller{

    private $data = array();
    private $language = "";
    private $path_file = "";

	public function __construct(){
		parent::__construct();
		$this->load->model('platc/platc_model');
		$this->load->model('especialidad_model');
		$this->load->model('paciente_model');
		$this->load->model('tc_virtual_model');
        $this->lang->load("spanish","spanish");
		$this->load->library('util');
	}
	public function agendar(){
		$data['clientes'] = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
		$data['establecimientos'] = $this->platc_model->establecimientos_cliente_get($this->session->userdata('CLI_ID'));
		$data['especialidades'] = $this->especialidad_model->select(array('CLI_ID' => $this->session->userdata('CLI_ID')));
		
		$this->load->view('agendar_buscar_view',$data);
	}
	public function especialidades(){
		if($_POST){
			$especialidades = $this->especialidad_model->select(array('CLI_ID' => $_POST['id']));
			echo ($especialidades) ? json_encode($especialidades) : FALSE;
		}
		else{
			echo FALSE;
		}
	}
	public function pacientes(){
		if($_REQUEST['data']){
			$data = "";
			foreach($_REQUEST['data'] as $value){
				$data[$value['name']] = $value['value'];
			}
			$nombres = ''; $apellidos = '';
			if($data['busqueda_nombre']){
				$nombres = explode(' ',$data['busqueda_nombre']);
			}
			if($data['busqueda_apellido']){
				$apellidos = explode(' ',$data['busqueda_apellido']);
			}
			$clie_id = (array_key_exists('busqueda_cliente',$data) && $data['busqueda_cliente']) ? $data['busqueda_cliente'] : $this->session->userdata('CLI_ID');
			$data['pacientes'] = $this->paciente_model->search_agendar( $data['busqueda_identificador'], $nombres, $apellidos, $clie_id );
			$this->load->view('agendar_grid_pacientes_view',$data);
		}
		else{
			echo FALSE;
		}
	}
	public function calendario(){
		if($_REQUEST['data']){
			$data = "";
			foreach($_REQUEST['data'] as $value){
				$data[$value['name']] = $value['value'];
			}
			$data['especialidad'] = "";
			$data['especialistas'] = $this->especialidad_model->select_especialista_agenda($this->session->userdata('SIT_ID'),$data['busqueda_especialidad']);
			if($data['especialistas']){ foreach($data['especialistas'] as $row){
				$data['especialidad'] = $row['ESP_NOMBRE'];
			}}
			$data['paciente'] = $this->paciente_model->select(array('PAC_ID' => $data['busqueda_paciente']));
			$this->load->view('calendario_view',$data);
		}
		else{
			echo FALSE;
		}
	}
	public function cancelar(){
		$data['clientes'] = $this->platc_model->clientes_get( $this->session->userdata('SIT_ID') );
		$data['establecimientos'] = $this->platc_model->establecimientos_cliente_get($this->session->userdata('CLI_ID'));
		$data['especialidades'] = $this->especialidad_model->select(array('CLI_ID' => $this->session->userdata('CLI_ID')));
		$this->load->view('cancelar_buscar_view',$data);
	}
	public function ficha(){
		if($_REQUEST['age_id']){
			$id_site = $this->session->userdata( 'SIT_ID' );
			$data['agendamiento'] = $this->platc_model->agendamiento_get( $_REQUEST['age_id'], $id_site );
			$data['especialista'] = $this->platc_model->usuario_get( $data['agendamiento']['USU_ID_ESPECIALISTA'] );
			$data['generalista']  = $this->platc_model->usuario_get( $data['agendamiento']['USU_ID_MEDICO'] );
			$this->load->view('agendamiento_ver_pendientes_view',$data);
		}
		else{
			echo FALSE;
		}
	}
	public function agendas(){
		if($_REQUEST['data']){
			$data = "";
			foreach($_REQUEST['data'] as $value){
				$data[$value['name']] = $value['value'];
			}

			$nombres = ''; $apellidos = '';
			if($data['busqueda_nombre']){
				$nombres = explode(' ',$data['busqueda_nombre']);
			}
			if($data['busqueda_apellido']){
				$apellidos = explode(' ',$data['busqueda_apellido']);
			}
			$data['agendas'] = $this->tc_virtual_model->select_agendas( $data['busqueda_identificador'], $nombres, $apellidos );
			$this->load->view('agendar_grid_agendas_view',$data);
		}
		else{
			echo FALSE;
		}
	}
	public function establecimientos(){
		if($_POST){
			$establecimientos = $this->platc_model->establecimientos_cliente_get($_POST['id']);
			echo ($establecimientos) ? json_encode($establecimientos) : FALSE;
		}
		else{
			echo FALSE;
		}
	}
	public function crear_paciente(){
        $identificadores = $this->platc_model->site_identificadores_get($this->session->userdata('SIT_ID'));
        $data['identificadores_select'] = $this->util->select_form_prepare($identificadores, 'IDT_ID', 'IDT_NOMBRE');
		$this->load->view('tc_virtual/crear_paciente_view',$data);
	}
	public function save_paciente(){
		if($_POST){
			$data = array(
				'SIT_ID' => $this->session->userdata('SIT_ID'),
				'PAC_PRIMER_NOMBRE' => $_POST['nombre'],
				'PAC_PRIMER_APELLIDO' => $_POST['apellido'],
				'PAC_TELEFONO' => $_POST['telefono'],
				'PAC_EMAIL' => $_POST['email'],
				'PAC_ACTIVO' => 1
			);
			$where = array(
				'IDT_ID' => $_POST['identificador'],
				'PAC_IDT_VALOR' => $_POST['cedula']
			);
			if(!$this->paciente_model->select_identificador($where)){
				if($pac_id = $this->paciente_model->insert($data)){
					$where = array(
						'PAC_ID' => $pac_id,
						'IDT_ID' => $_POST['identificador'],
						'PAC_IDT_VALOR' => $_POST['cedula']
					);
					echo $this->paciente_model->insert_idt($where);
				}
				else{
					echo FALSE;
				}
			}
			else{
				echo -1;
			}
		}
		else{
			echo FALSE;
		}
	}
	public function teleconsultas(){
		$age_id = ($this->uri->segment(4)) ? $this->uri->segment(4) : "";
		if($age_id){
			$tc_virtual = $this->tc_virtual_model->select(array('TCV_AGE_ID' => $age_id));
			if($tc_virtual){
				$data['teleconsultas'] = $this->tc_virtual_model->tc_lista_get($this->session->userdata('USU_ID'), $this->session->userdata('SIT_ID'),$tc_virtual['TCV_ETB_ID'],$tc_virtual['TCV_PAC_ID'],$tc_virtual['TCV_ESP_ID']);
				$this->load->view('tc_virtual/modal_tc_view',$data);
			}
			else{
				die("No se encontro registro");
			}
		}
		else{
			die("Error: Falta codigo de agenda");
		}
	}
	public function tc_save(){
		if($_POST){
			$data = array(
				'TEL_ID' => $_POST['tel_id']
			);
			if($this->tc_virtual_model->add_tc($_POST['id'],$data)){
				$data = array(
					'TCV_FECHA_MATCH' => date('Y-m-d H:i:s')
				);
				$this->tc_virtual_model->update($_POST['id'],$data);
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
	public function checkagenda(){
		if($_POST){
			$this->load->model('tc_virtual/agenda_model');
			if($row = $this->agenda_model->buscar( $_POST['fecha'], $_POST['age_def'], $_POST['esp_usu'], $_POST['pac_id'] )){
				echo TRUE;
			}
			else{
				echo FALSE;
			}
		}
		else{
			echo FALSE;
		}
	}
}
