/**
 * Hard Coronary Heart Disease (10-year risk)
 * Obtenido desde: http://www.framinghamheartstudy.org/risk/hrdcoronary.html (al 06/08/2013)
 */

function Framingham( ) {

    // M: Masculino , F: Femenino
    this.sexo               = false;
    this.edad               = false;
    this.colesterol         = false;
    this.edad     = false;
    this.fumador            = false;
    this.presion_sistolica  = false;
    this.presion_tratada    = false;

    /**
     * Retorna valor en puntos en función de la edad según tabla de Framingham
     * @return (int) puntos según tabla de Framingham, false si edad no es válido
     */
    this.puntos_edad = function( ) {

        // Validación de datos correctos, parseados en constructor
        if( this.sexo === 'M' && this.edad !== false ) {

            /*
             * Tabla Framingham Hombres según edad
             */
            if( ( 20 <= this.edad ) && ( this.edad <= 34 ) ) return -9;
            if( ( 35 <= this.edad ) && ( this.edad <= 39 ) ) return -4;
            if( ( 40 <= this.edad ) && ( this.edad <= 44 ) ) return 0;
            if( ( 45 <= this.edad ) && ( this.edad <= 49 ) ) return 3;
            if( ( 50 <= this.edad ) && ( this.edad <= 54 ) ) return 6;
            if( ( 55 <= this.edad ) && ( this.edad <= 59 ) ) return 8;
            if( ( 60 <= this.edad ) && ( this.edad <= 64 ) ) return 10;
            if( ( 65 <= this.edad ) && ( this.edad <= 69 ) ) return 11;
            if( ( 70 <= this.edad ) && ( this.edad <= 74 ) ) return 12;
            if( ( 75 <= this.edad ) && ( this.edad <= 79 ) ) return 13;
        } else if( this.sexo === 'F' && this.edad !== false ) {

            /*
             * Tabla Framingham Mujeres según edad
             */
            if( ( 20 <= this.edad ) && ( this.edad <= 34 ) ) return -7;
            if( ( 35 <= this.edad ) && ( this.edad <= 39 ) ) return -3;
            if( ( 40 <= this.edad ) && ( this.edad <= 44 ) ) return 0;
            if( ( 45 <= this.edad ) && ( this.edad <= 49 ) ) return 3;
            if( ( 50 <= this.edad ) && ( this.edad <= 54 ) ) return 6;
            if( ( 55 <= this.edad ) && ( this.edad <= 59 ) ) return 8;
            if( ( 60 <= this.edad ) && ( this.edad <= 64 ) ) return 10;
            if( ( 65 <= this.edad ) && ( this.edad <= 69 ) ) return 12;
            if( ( 70 <= this.edad ) && ( this.edad <= 74 ) ) return 14;
            if( ( 75 <= this.edad ) && ( this.edad <= 79 ) ) return 16;
        } else
            return false;
    }

    /**
     * Retorna valor en puntos en función del colesterol y la edad según tabla de Framingham
     * @return (int) puntos según tabla de Framingham, false si edad o colesterol no son valores válidos
     */
    this.puntos_colesterol = function( ) {

        // Validación de datos correctos, parseados en constructor
        if( this.sexo === 'M' && ( this.edad !== false || this.colesterol !== false ) ) {

            /*
             * Tabla Framingham Hombres según colesterol y edad
             */

            // Colesterol menor a 160
            if( this.colesterol < 160 ) return 0;

            // Caloresterol entre 160 y 199
            if( 160 <= this.colesterol && this.colesterol <= 199 ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 4;
                if( 40 <= this.edad && this.edad <= 49 ) return 3;
                if( 50 <= this.edad && this.edad <= 59 ) return 2;
                if( 60 <= this.edad && this.edad <= 69 ) return 1;
                if( 70 <= this.edad && this.edad <= 79 ) return 0;
            }

            // Caloresterol entre 200 y 239
            if( 200 <= this.colesterol && this.colesterol <= 239 ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 7;
                if( 40 <= this.edad && this.edad <= 49 ) return 6;
                if( 50 <= this.edad && this.edad <= 59 ) return 5;
                if( 60 <= this.edad && this.edad <= 69 ) return 1;
                if( 70 <= this.edad && this.edad <= 79 ) return 0;
            }

            // Caloresterol entre 240 y 279
            if( 240 <= this.colesterol && this.colesterol <= 279 ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 9;
                if( 40 <= this.edad && this.edad <= 49 ) return 6;
                if( 50 <= this.edad && this.edad <= 59 ) return 4;
                if( 60 <= this.edad && this.edad <= 69 ) return 2;
                if( 70 <= this.edad && this.edad <= 79 ) return 1;
            }

            // Caloresterol mayor a 280
            if( 280 <= this.colesterol ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 11;
                if( 40 <= this.edad && this.edad <= 49 ) return 8;
                if( 50 <= this.edad && this.edad <= 59 ) return 5;
                if( 60 <= this.edad && this.edad <= 69 ) return 3;
                if( 70 <= this.edad && this.edad <= 79 ) return 1;
            }

        } else if( this.sexo === 'F' && ( this.edad !== false || this.colesterol !== false ) ) {

            /*
             * Tabla Framingham Mujeres según colesterol y edad
             */

            // Colesterol menor a 160
            if( this.colesterol < 160 ) return 0;

            // Caloresterol entre 160 y 199
            if( 160 <= this.colesterol && this.colesterol <= 199 ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 4;
                if( 40 <= this.edad && this.edad <= 49 ) return 3;
                if( 50 <= this.edad && this.edad <= 59 ) return 2;
                if( 60 <= this.edad && this.edad <= 69 ) return 1;
                if( 70 <= this.edad && this.edad <= 79 ) return 1;
            }

            // Caloresterol entre 200 y 239
            if( 200 <= this.colesterol && this.colesterol <= 239 ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 8;
                if( 40 <= this.edad && this.edad <= 49 ) return 6;
                if( 50 <= this.edad && this.edad <= 59 ) return 4;
                if( 60 <= this.edad && this.edad <= 69 ) return 2;
                if( 70 <= this.edad && this.edad <= 79 ) return 1;
            }

            // Caloresterol entre 240 y 279
            if( 240 <= this.colesterol && this.colesterol <= 279 ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 11;
                if( 40 <= this.edad && this.edad <= 49 ) return 8;
                if( 50 <= this.edad && this.edad <= 59 ) return 5;
                if( 60 <= this.edad && this.edad <= 69 ) return 3;
                if( 70 <= this.edad && this.edad <= 79 ) return 2;
            }

            // Caloresterol mayor a 280
            if( 280 <= this.colesterol ) {
                if( 20 <= this.edad && this.edad <= 39 ) return 13;
                if( 40 <= this.edad && this.edad <= 49 ) return 10;
                if( 50 <= this.edad && this.edad <= 59 ) return 7;
                if( 60 <= this.edad && this.edad <= 69 ) return 4;
                if( 70 <= this.edad && this.edad <= 79 ) return 2;
            }
        }
            return false;
    }

    /**
     * Retorna valor en puntos en función de si fuma o no el paciente y su edad, según tabla de Framingham
     * @return (int) puntos según tabla de Framingham, false si edad no es válido
     */
    this.puntos_fumador = function( ) {

        // Validación de datos correctos, parseados en constructor
        if( this.sexo === 'M'  && ( this.fumador === true || this.fumador === false ) ) {

            /*
             * Tabla Framingham Hombres según fumadores/no fumadores y edad
             */

            // Hombre fumador
            if( this.fumador === true ) {

                if( 20 <= this.edad && this.edad <= 39 ) return 8;
                if( 40 <= this.edad && this.edad <= 49 ) return 5;
                if( 50 <= this.edad && this.edad <= 59 ) return 3;
                if( 60 <= this.edad && this.edad <= 69 ) return 1;
                if( 70 <= this.edad && this.edad <= 79 ) return 1;
            } else {

            // Hombre no fumador
                if( 20 <= this.edad && this.edad <= 39 ) return 0;
                if( 40 <= this.edad && this.edad <= 49 ) return 0;
                if( 50 <= this.edad && this.edad <= 59 ) return 0;
                if( 60 <= this.edad && this.edad <= 69 ) return 0;
                if( 70 <= this.edad && this.edad <= 79 ) return 0;
            }

        } else if( this.sexo === 'F' && ( this.fumador === true || this.fumador === false ) ) {


            /*
             * Tabla Framingham Mujeres según fumadores/no fumadores y edad
             */

            // Mujer fumadora
            if( this.fumador === true ) {

                if( 20 <= this.edad && this.edad <= 39 ) return 9;
                if( 40 <= this.edad && this.edad <= 49 ) return 7;
                if( 50 <= this.edad && this.edad <= 59 ) return 4;
                if( 60 <= this.edad && this.edad <= 69 ) return 2;
                if( 70 <= this.edad && this.edad <= 79 ) return 1;
            } else {

            // Mujer no fumadora
                if( 20 <= this.edad && this.edad <= 39 ) return 0;
                if( 40 <= this.edad && this.edad <= 49 ) return 0;
                if( 50 <= this.edad && this.edad <= 59 ) return 0;
                if( 60 <= this.edad && this.edad <= 69 ) return 0;
                if( 70 <= this.edad && this.edad <= 79 ) return 0;
            }
        }
            return false;
    }

    /**
     * Retorna valor en puntos en función del colesterol HDL
     * @return (int) puntos según tabla de Framingham, false si colesterol no es válido
     */
    this.puntos_colesterol_hdl = function( ) {

        // Validación de datos correctos, parseados en constructor
        if( this.sexo === 'M' && this.colesterol_hdl !== false ) {

            /*
             * Tabla Framingham Hombres según cantidad de colesterol HDL
             * OJO: al parecer son tablas iguales para ambos sexos
             */
            if( this.colesterol_hdl < 40 ) return 2;
            if( 40 <= this.colesterol_hdl && this.colesterol_hdl <= 49 ) return 1;
            if( 50 <= this.colesterol_hdl && this.colesterol_hdl <= 59 ) return 0;
            if( 60 <= this.colesterol_hdl ) return -1;

        } else if( this.sexo === 'F' && this.colesterol_hdl !== false ) {

            /*
             * Tabla Framingham Mujeres según cantidad de colesterol HDL
             * OJO: al parecer son tablas iguales para ambos sexos
             */
            if( this.colesterol_hdl < 40 ) return 2;
            if( 40 <= this.colesterol_hdl && this.colesterol_hdl <= 49 ) return 1;
            if( 50 <= this.colesterol_hdl && this.colesterol_hdl <= 59 ) return 0;
            if( 60 <= this.colesterol_hdl ) return -1;
        }

        return false;
    }

    /**
     * Retorna valor en puntos en función de la presión sistólica
     * @return (int) puntos según tabla de Framingham, false si presión sistólica no es válido
     */
    this.puntos_presion_sistolica = function( ) {

        // Validación de datos correctos, parseados en constructor
        if( this.sexo === 'M' && this.presion_sistolica !== false && ( this.presion_tratada === true || this.presion_tratada === false ) ) {

            /*
             * Tabla Framingham Hombres según presión sistólica
             */
            if( this.presion_tratada === true ) {

                if( this.presion_sistolica < 120 ) return 0;
                if( 120 <= this.presion_sistolica && this.presion_sistolica <= 129 ) return 1;
                if( 130 <= this.presion_sistolica && this.presion_sistolica <= 139 ) return 2;
                if( 140 <= this.presion_sistolica && this.presion_sistolica <= 149 ) return 2;
                if( 160 <= this.presion_sistolica ) return 3;
            } else {

                if( this.presion_sistolica < 120 ) return 0;
                if( 120 <= this.presion_sistolica && this.presion_sistolica <= 129 ) return 0;
                if( 130 <= this.presion_sistolica && this.presion_sistolica <= 139 ) return 1;
                if( 140 <= this.presion_sistolica && this.presion_sistolica <= 149 ) return 1;
                if( 160 <= this.presion_sistolica ) return 2;
            }

        } else if( this.sexo === 'F' && this.presion_sistolica !== false && ( this.presion_tratada === true || this.presion_tratada === false ) ) {

            /*
             * Tabla Framingham Mujeres según presión sistólica
             */
            if( this.presion_tratada === true ) {

                if( this.presion_sistolica < 120 ) return 0;
                if( 120 <= this.presion_sistolica && this.presion_sistolica <= 129 ) return 3;
                if( 130 <= this.presion_sistolica && this.presion_sistolica <= 139 ) return 4;
                if( 140 <= this.presion_sistolica && this.presion_sistolica <= 149 ) return 5;
                if( 160 <= this.presion_sistolica ) return 6;
            } else {

                if( this.presion_sistolica < 120 ) return 0;
                if( 120 <= this.presion_sistolica && this.presion_sistolica <= 129 ) return 1;
                if( 130 <= this.presion_sistolica && this.presion_sistolica <= 139 ) return 2;
                if( 140 <= this.presion_sistolica && this.presion_sistolica <= 149 ) return 3;
                if( 160 <= this.presion_sistolica ) return 4;
            }
        }

        return false;
    }

    /**
     * Retorna valor en porcentaje en función de los puntos obtenido de la suma de resultados de las tablas
     * @return (int) porcentaje según tabla de Framingham, false si presión sistólica no es válido
     */
    this.puntos_resultado = function( total_puntos ) {

        // Validación de datos correctos, parseados en constructor
        if( this.sexo === 'M' ) {

            if( parseInt( total_puntos ) < 0 ) return '<1';
            if( parseInt( total_puntos ) >= 17 ) return '>=30';

            switch( total_puntos ) {

                case  0 : return '1';
                case  1 : return '1';
                case  2 : return '1';
                case  3 : return '1';
                case  4 : return '1';
                case  5 : return '2';
                case  6 : return '2';
                case  7 : return '3';
                case  8 : return '4';
                case  9 : return '5';
                case 10 : return '6';
                case 11 : return '8';
                case 12 : return '10';
                case 13 : return '12';
                case 14 : return '16';
                case 15 : return '20';
                case 16 : return '25';
            }

        } else if( this.sexo === 'F' && this.presion_sistolica !== false && ( this.presion_tratada === true || this.presion_tratada === false ) ) {

            if( parseInt( total_puntos ) < 9 ) return '<1';
            if( parseInt( total_puntos ) >= 25 ) return '>=30';

            switch( total_puntos ) {

                case  9 : return '1';
                case 10 : return '1';
                case 11 : return '1';
                case 12 : return '1';
                case 13 : return '2';
                case 14 : return '2';
                case 15 : return '3';
                case 16 : return '4';
                case 17 : return '5';
                case 18 : return '6';
                case 19 : return '8';
                case 20 : return '11';
                case 21 : return '14';
                case 22 : return '17';
                case 23 : return '22';
                case 24 : return '27';
            }
        }

        return false;
    }

    /**
     * Retorna calculo de Framingham
     * @return (int) puntos según tabla de Framingham, false si presión sistólica no es válido
     */
    this.calcular = function( sexo, edad, colesterol, colesterol_hdl, fumador, presion_sistolica, presion_tratada ) {

    // M: Masculino , F: Femenino
    this.sexo               = ( sexo === 'M' || sexo === 'F' ) ? sexo : false;
    this.edad               = ( ( parseInt( edad ) === NaN ) || ( parseInt( edad ) < 20 ) || ( 80 <= parseInt( edad ) ) ) ? false : parseInt( edad );
    this.colesterol         = ( parseInt( colesterol ) === NaN ) ? false : parseInt( colesterol );
    this.colesterol_hdl     = ( parseInt( colesterol_hdl ) === NaN ) ? false : parseInt( colesterol_hdl );
    this.fumador            = ( fumador === true ) ? true : false;
    this.presion_sistolica  = ( parseInt( presion_sistolica ) === NaN ) ? false : parseInt( presion_sistolica );
    this.presion_tratada    = ( presion_tratada === true ) ? true : false;

    puntos_edad                 = this.puntos_edad();
    puntos_colesterol           = this.puntos_colesterol();
    puntos_colesterol_hdl       = this.puntos_colesterol_hdl();
    puntos_fumador              = this.puntos_fumador();
    puntos_presion_sistolica    = this.puntos_presion_sistolica();

//console.debug( puntos_edad             );
//console.debug( puntos_colesterol       );
//console.debug( puntos_colesterol_hdl   );
//console.debug( puntos_fumador          );
//console.debug( puntos_presion_sistolica);

    if( puntos_edad !== false && puntos_colesterol !== false && puntos_colesterol_hdl !== false &&
        puntos_fumador !== false && puntos_presion_sistolica !== false ) {
        suma_total = puntos_edad + puntos_colesterol + puntos_colesterol_hdl + puntos_fumador + puntos_presion_sistolica;
        return this.puntos_resultado( suma_total );
    } else
        return false;

    }
}