(function($) {
	$.fn.validationEngineLanguage = function() {};
	$.validationEngineLanguage = {
		newLang: function() {
			$.validationEngineLanguage.allRules = 	{"required":{    			// Add your regex rules here, you can take telephone as an example
					"regex":"none",
						"alertText":"* Este campo es requerido",
						"alertTextCheckboxMultiple":"* Por favor selecciona al menos una opcion",
						"alertTextCheckboxe":"* Este checkbox es requerido"},
					"length":{
						"regex":"none",
						"alertText":"*Solo se permiten entre ",
						"alertText2":" y ",
						"alertText3": " caracteres"},
					"maxCheckbox":{
						"regex":"none",
						"alertText":"* Se ha excedido el numero de opciones permitidas"},
					"minCheckbox":{
						"regex":"none",
						"alertText":"* Por favor seleccione al menos ",
						"alertText2":" opciones"},
					"equals":{
						"regex":"none",
						"alertText":"* Los campos con coinciden"},
					"phone":{
						// credit: jquery.h5validate.js / orefalo
						"regex": /^([\+][0-9]{1,3}[ \.\-])?([\(]{1}[0-9]{2,6}[\)])?([0-9 \.\-\/]{3,20})((x|ext|extension)[ ]?[0-9]{1,4})?$/,
						"alertText":"* Número de teléfono invalido"},
					"email":{
						// Shamelessly lifted from Scott Gonzalez via the Bassistance Validation plugin http://projects.scottsplayground.com/email_address_validation/
						"regex": /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/,
						"alertText":"* Correo invalido"},
					"integer":{
						"regex": /^[\-\+]?\d+$/,
						"alertText":"* No es un valor entero válido"},
					"number":{
						// Number, including positive, negative, and floating decimal. Credit: bassistance
						"regex": /^[\-\+]?(?:\d+|\d{1,3}(?:,\d{3})+)(?:\.\d+)$/,
						"alertText":"* No es un valor decimal válido"},
					"date":{
						// Date in ISO format. Credit: bassistance
                         "regex":/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/,
                         "alertText":"* Fecha invalida, por favor utilize el formato AAAA-MM-DD"},

                    "ipv4":{
                    	"regex": /^([1-9][0-9]{0,2})+\.([1-9][0-9]{0,2})+\.([1-9][0-9]{0,2})+\.([1-9][0-9]{0,2})+$/,
                    	"alertText":"* Direccion IP invalida"},
                    "url":{
                    	"regex":/^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/,
                    	"alertText":"* URL Invalida"},
					"onlyNumber":{
						"regex":/^[0-9\ ]+$/,
						"alertText":"* Solo números"},
					"noSpecialCaracters":{
						"regex":/^[0-9a-zA-Z]+$/,
						"alertText":"* No se permiten caracteres especiales"},
					"ajaxUser":{
						"file":"validateUser.php",
						"extraData":"name=eric",
						"alertTextOk":"* Este nombre de usuario esta disponible",
						"alertTextLoad":"* Cargando, espere por favor",
						"alertText":"* Este nombre de usuario ya se encuentra ocupado"},
					"ajaxName":{
						"file":"validateUser.php",
						"alertText":"* Este nombre ya se encuentra ocupado",
						"alertTextOk":"* Este nombre esta disponible",
						"alertTextLoad":"* Cargando, espere por favor"},
					"onlyLetter":{
						"regex":/^[a-zA-Z\ \']+$/,
						"alertText":"* Solo letras"},
					"validate2fields":{
    					"nname":"validate2fields",
    					"alertText":"* Nombe y apellidos son requeridos"},
                    "validarIdentificacion":{
                        "nname":"validarIdentificacion",
                        "alertText":"* Debe ingresar un número de identificación correcto"},
					"validar_campo_examen_fisico_cabeza":{
    					"nname":"validar_campo_examen_fisico_cabeza",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_examen_fisico_cuello":{
    					"nname":"validar_campo_examen_fisico_cuello",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_examen_fisico_torax":{
    					"nname":"validar_campo_examen_fisico_torax",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_examen_fisico_abdomen":{
    					"nname":"validar_campo_examen_fisico_abdomen",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_examen_fisico_genitales":{
    					"nname":"validar_campo_examen_fisico_genitales",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_examen_fisico_extremidades":{
    					"nname":"validar_campo_examen_fisico_extremidades",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_examen_fisico_neurologico":{
    					"nname":"validar_campo_examen_fisico_neurologico",
    					"alertText":"Ingrese información a este campo"},
					"validar_campo_tc_motivo_teleconsulta":{
    					"nname":"validar_campo_tc_motivo_teleconsulta",
    					"alertText":"Ingrese información a este campo"}
					};

		}
	};
})(jQuery);

$(document).ready(function() {
	$.validationEngineLanguage.newLang();
});
