<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class FormularioXML {

    static $MODO_LECTURA   = 'lectura';
    static $MODO_ESCRITURA = 'escritura';
    static $MODO_PDF       = 'pdf';

    private $modo;
    private $archivo_formulario;
    private $validar_campo;
    private $validacion;
    private $form_valores;
    private $form_datos;
    private $datos;
    private $tc;

    private $CI;
    private $htmlpurifier;

    private $pdf_limite_pagina = 210;
    // $y_1columna: tamaño de lo alto de la primera columna para comprobar con alto de la 2da columna
    private $y_1columna;
	
	private $config_cli_id;

    public function __construct() {

        $this->form_valores = array( );
        $this->form_datos   = array( );

        $this->CI = get_instance();
        $this->CI->load->library( 'parser' );
		
		$this->config_cli_id = $this->CI->config->item('cli_id', 'platc');

        // Carga librería para limpiar código HTML de datos que van en el PDF
        $this->CI->load->library( 'HtmlPurifierWrapper' );
        $this->htmlpurifier = $this->CI->htmlpurifierwrapper->HtmlPurifierFactory();
    }

    public function generar( $id_teleconsulta, $modo = NULL ) {

        $this->tc = $this->CI->platc_model->tc_get( $id_teleconsulta );
        $this->form_valores = $this->obtener_valores( $id_teleconsulta );

        $datos['anexo3']   = $this->CI->platc_model->anexo_get(  $id_teleconsulta  );
		//echo "<pre>";		
		//print_r($datos['ANEXO3']);
		//echo "</pre>";
		//die;

        $html = "";
        $ruta = APPPATH.'libraries/Formularios_TC/'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'.xml';


        if( file_exists( $ruta ) ) {

            $xml = simplexml_load_file( $ruta );
            if( $xml !== FALSE ) {

                if( $xml->getName( ) ==  'formulario') {

                    log_message('debug', '[XML] Cargando formulario '.$this->archivo_formulario.'.xml' );
                    $this->modo = ( empty( $modo ) && ( strcmp( $modo, FormularioXML::$MODO_LECTURA ) &&
                                                        strcmp( $modo, FormularioXML::$MODO_ESCRITURA ) &&
                                                        strcmp( $modo, FormularioXML::$MODO_PDF ) ) ) ? FormularioXML::$MODO_LECTURA : $modo;

                    // Inicializa configuración de PDF
                    if( $this->modo == FormularioXML::$MODO_PDF )
                        $this->inicializar_pdf( );

                    $html = $this->procesar_xml( $xml );

                    // Termina configuración de PDF y envía al navegador
                    if( $this->modo == FormularioXML::$MODO_PDF ) {

                        // Datos de la solicitud /respuesta de la solicitud
                        if( !empty( $this->datos['tc']['TEL_SOL_ADICIONALES'] ) ) {

                            $this->CI->tc_fpdf->establecer_datos_solicitud_info_examen( $this->datos );

                            if ($this->datos['tc']['TEL_SOL_ADICIONALES_RESP'] != NULL && $this->datos['tc']['EST_ID'] > 5)
                                $this->CI->tc_fpdf->establecer_datos_solicitud_respuesta($this->datos);
                        }

                        if( $this->datos['tc']['EST_ID'] == 7 ) {

                            $this->datos['especialidad'] = $this->CI->platc_model->especialidad_get( (int)$this->datos['tc']['ESP_ID'] );
                            $this->CI->tc_fpdf->establecer_datos_respuesta_especialista($this->datos);
                        }

                        /*
                         * CO: Lógica Recetas y fórmulas
                         */
						 
						$data['generalista'] = "";
						$historia = $this->CI->platc_model->tc_historia((int)$id_teleconsulta, 2);   //2: Estado enviada/nueva

						foreach( $historia as $v ) {
							$u = $this->CI->platc_model->usuario_get((int)$v['USU_ID']);
							if((int)$u['ROL_ID'] == 4){
								$data['generalista'] = $u;
								$data['generalista_identificacion'] = $this->CI->platc_model->identificador_get( (int)$u['IDT_ID'] );
							}
						}
						
						// Datos médico Especialista (Profesional)
						$especialista =  $this->CI->platc_model->tc_estado_get($id_teleconsulta, $this->datos['tc']['EST_ID']);
						$data['especialista']  = $this->CI->platc_model->usuario_get((int)$especialista['USU_ID']);
						$data['especialista_identificacion'] = $this->CI->platc_model->identificador_get($data['especialista']['IDT_ID']);
						
						$this->datos['tc']['generalista'] = $data['generalista'];
						$this->datos['tc']['generalista_identificacion'] = $data['generalista_identificacion'];
						
						$this->datos['tc']['especialista'] = $data['especialista'] ;
						$this->datos['tc']['especialista_identificacion'] = $data['especialista_identificacion'];
						


                        if( (int)$this->CI->session->userdata('SIT_ID') == 22 && ( !empty( $this->datos['tc']['recetas'] )) ) {
                            $this->CI->tc_fpdf->establecer_recetas( $this->datos['tc'] );
                        }
                        if( (int)$this->CI->session->userdata('SIT_ID') == 22 && ( !empty( $this->datos['tc']['formulas'] )) ) {
                            $this->CI->tc_fpdf->establecer_formulas( $this->datos['tc'] );
                        }
                        
						//agregamos anexo 3 en reporte pdf -ffarias
						if( (int)$this->CI->session->userdata('SIT_ID') == 22 && ( !empty( $datos['anexo3'] )) ) {
                            $this->CI->tc_fpdf->establecer_anexos( $this->datos['tc'] );
                        }
						
						//NO POS NF525
						$data['tc'] = $this->tc;
						$data['paciente'] = $this->CI->platc_model->paciente_get((int)$this->tc['PAC_ID']);
						$data['paciente_identificadores'] = $this->CI->platc_model->paciente_identificadores_get((int)$this->tc['PAC_ID']);
						$data['entidad_administradora'] = $this->CI->platc_model->entidad_administradora_get((int)$this->tc['ENTADM_ID']);

						//RECETAS
						$this->CI->load->model('tc_receta_no_pos_model');
						$data['tc']['recetasNoPos'] = $this->CI->tc_receta_no_pos_model->select(array('RC_TEL_ID' => $id_teleconsulta));
						if($data['tc']['recetasNoPos']){
							foreach($data['tc']['recetasNoPos'] as &$row){
								$row['prestacionNoPos'] = $this->CI->tc_receta_no_pos_model->select_no_pos(array('RCN_RC_ID' => $row['RC_ID']));
								$row['prestacionPos'] = $this->CI->tc_receta_no_pos_model->select_pos(array('RCP_RC_ID' => $row['RC_ID']));
							}
							$this->CI->tc_fpdf->establecer_recetas_no_pos($data);
						}
						//FORMULAS
						$this->CI->load->model('tc_formula_no_pos_model');
						$data['tc']['formulasNoPos'] = $this->CI->tc_formula_no_pos_model->select(array('FM_TEL_ID' => $id_teleconsulta));
						if($data['tc']['formulasNoPos']){
							foreach($data['tc']['formulasNoPos'] as &$row){
								$row['medicamentoNoPos'] = $this->CI->tc_formula_no_pos_model->select_no_pos(array('MFN_FM_ID' => $row['FM_ID']));
								$row['medicamentoPos'] = $this->CI->tc_formula_no_pos_model->select_pos(array('MF_FM_ID' => $row['FM_ID']));
							}
							$this->CI->tc_fpdf->establecer_formulas_no_pos($data);
						}
						//FIN
						
                        if( (bool)$this->CI->config->item( 'salida_firma_digital', 'platc' ) ) {

                            $this->CI->tc_fpdf->AliasNbPages();
                            $archivo = 'TC_'.$this->datos['tc']['TEL_ID'].'_'.date('His');
                            $ruta_llegada = FCPATH. 'pdf/llegada/'.$archivo.'.pdf';
                            $this->CI->tc_fpdf->Output( $ruta_llegada, 'F' );

                            // Genera archivo "lock: *.fin de 0Kb"
                            $f=fopen( FCPATH. 'pdf/llegada/'.$archivo.'.fin','wb');
                            if(!$f)
                                log_message( 'error', "Unable to create output file: ".$name );
                            fwrite($f,"",1);
                            fclose($f);

                            sleep( (int)$this->CI->config->item( 'demonio_demora_seg', 'platc' ) );
                            return base_url(). 'pdf/salida/'.$archivo.'.pdf';
                        } else {
                            $this->CI->tc_fpdf->Output();
                        }
                    }
                }
            } else
                $html = 'error';

        } else
            $html = 'error';

        return $html;
    }

    public function generar_parcial( $id_teleconsulta, $archivo, $modo = NULL, $data = NULL ) {

        if( $modo == NULL || $modo == self::$MODO_PDF ) throw new Exception ( 'Modo no soportado' );

        //
        $this->tc = $this->CI->platc_model->tc_get( $id_teleconsulta );
        $this->form_valores = $this->obtener_valores( $id_teleconsulta );

        $ruta = 'forms/'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'.$archivo.'.php';

        $this->modo = ( empty( $modo ) && ( strcmp( $modo, FormularioXML::$MODO_LECTURA ) &&
                                            strcmp( $modo, FormularioXML::$MODO_ESCRITURA ) &&
                                            strcmp( $modo, FormularioXML::$MODO_PDF ) ) ) ? FormularioXML::$MODO_LECTURA : $modo;

        $todo = array( );
        $todo['modo'] = $this->modo;

        if( !empty( $this->form_valores ) )
            $todo = array_merge( $todo, $this->form_valores );

        if( !empty( $this->form_datos ) )
            $todo = array_merge( $todo, $this->form_datos );

        if( !empty( $data ) )
            $todo = array_merge( $todo, $data );

        return $this->CI->load->view( $ruta, $todo, TRUE );
    }

    private function procesar_xml( SimpleXMLElement $xml ) {

        $html = '';

        switch( $xml->getName( ) ) {

            case 'formulario' : {
                    foreach( $xml->children() as $elemento )
                        $html.= $this->procesar_xml( $elemento );

            }; break;

            case 'importar' : {

                log_message('debug', '[XML] Importando formulario '.(string) $xml['archivo'].'.xml');
                $ruta = APPPATH.'libraries/Formularios_TC/'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'.(string) $xml['archivo'].'.xml';
                $importar = simplexml_load_file( $ruta );
                $html.= $this->procesar_xml( $importar );
            }; break;

            case 'formulario_parcial'   : {

                log_message('debug', '[XML] Operando formulario parcial '.(string) $xml['clave_dic'] );

                if( isset( $xml['oculto'] ) && $this->modo == (string) $xml['oculto'] )
                    return;

                // Valida que el genero del paciente pueda visualizar el formulario parcial
                if( isset( $xml['genero'] ) && (string) $xml['genero'] != $this->tc['TEL_PAC_SEXO'] )
                    return;

                $html_temp = '';
                if( $xml->count() > 0 ) {

                    if( $this->modo == FormularioXML::$MODO_PDF ) {
                        $this->CI->tc_fpdf->Ln();
                        $this->CI->tc_fpdf->MultiCell( 0, 6, html_entity_decode( $this->CI->lang->line( (string) $xml['clave_dic'] ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 1, 'L', false, 0 );

                        foreach( $xml->children( ) as $registros )
                            $this->procesar_xml( $registros ) ;
                    } else {

                        foreach( $xml->children( ) as $registros )
                            $html_temp.= $this->procesar_xml( $registros ) ;

                        $data = array(  'registro'  => $html_temp,
                                        'titulo'    => $this->CI->lang->line( (string) $xml['clave_dic'] ),
                                        'estilos'   => (string) $xml['estilos'] );

                        $html.= $this->CI->parser->parse( 'forms/formulario_parcial', $data, TRUE );
                    }
                }
            }; break;

            case 'registro'             : {

                // Valida que el genero del paciente pueda visualizar el registro
                if( isset( $xml['genero'] ) && (string) $xml['genero'] != $this->tc['TEL_PAC_SEXO'] )
                    return;

                // Configura campos
                if( isset( $xml['validacion'] ) ){
                    $this->validar_campo = TRUE;
                    $this->validacion    = (string) $xml['validacion'];
                }
                // Procesa campos
                if( $xml['plantilla'] == '1_columna' ) {

                    $campo = $xml->children( );
                    $html.= $this->CI->parser->parse( 'forms/1_columna', array( 'contenido' => $this->procesar_campo( $campo->campo ) ), TRUE );
                }

                if( $xml['plantilla'] == '2_columnas' ) {

                    foreach( $xml->children( ) as $columna ) {

                        switch( $columna['tipo'] ) {
                            case 'izquierda' : $campos[ 'izquierda' ] = $this->procesar_campo( $columna->campo ); break;
                            case 'derecha'   : $campos[ 'derecha' ]   = $this->procesar_campo( $columna->campo ); break;
                        }
                    }

                    $html.= $this->CI->parser->parse( 'forms/2_columnas', $campos, TRUE );
                }

                if( $xml['plantilla'] == 'oculto' ) {
                    $campos = array( 'contenido' => $this->procesar_campo ( $xml->campo ) );
                    $html.= $this->CI->parser->parse( 'forms/1_columna', $campos, TRUE );
                }

                // Reinicia configuración
                $this->validar_campo = FALSE;
                $this->validacion    = '';
                $this->y_1columna    = 0;
            }; break;

        }

        return $html;
    }

    public function procesar_campo( SimpleXMLElement $campo ) {

        switch( (string) $campo['tipo'] ) {

            case 'etiqueta' : {

                $html = "";
                if( $this->modo == FormularioXML::$MODO_PDF ) {

                    if( !key_exists( 'clave_dic', $campo ) && key_exists( 'name', $campo ) )
                        $texto = $this->form_datos[ (string) $campo['name'] ];
                    else
                        $texto = $this->CI->lang->line( (string) $campo['clave_dic'] );

                    // $y: contiene altura actual donde se imprime etiqueta en pdf
                    $y = $this->CI->tc_fpdf->GetY( );
                    if( $y > $this->pdf_limite_pagina ) {
                        $this->CI->tc_fpdf->AddPage();
                        $y = $this->CI->tc_fpdf->GetY( );
                    }

                    // Imprime 1a columna
                    $this->CI->tc_fpdf->MultiCell( 50, 6, html_entity_decode( $texto, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 'R' );
                    $this->y_1columna = $this->CI->tc_fpdf->GetY();
                    $this->y_1columna_pagina = $this->CI->tc_fpdf->PageNo();

                    // Establece lugar para imprimir 2da columna
                    $this->CI->tc_fpdf->SetY( $y );
                    $this->CI->tc_fpdf->SetX( 60 );
                } else {
                    if( !key_exists( 'clave_dic', $campo ) && key_exists( 'name', $campo ) )
                        $html = $this->form_datos[ (string) $campo['name'] ];
                    else
                        $html = $this->CI->lang->line( (string) $campo['clave_dic'] );

                    if( $this->validar_campo == TRUE)
                        $html = "<span class=\"redtext\">*</span>&nbsp;" . $html;

                    // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                    if( isset( $campo['post_texto'] ) )
                        $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";
                }

                return $html;
            }; break;

            case 'texto'    : {

                $html = "";

                switch( $this->modo ) {

                    case self::$MODO_LECTURA : {

                        if( isset( $this->form_valores[ (string) $campo['nombre'] ] ) )
                            $html.= $this->form_valores[ (string) $campo['nombre'] ];
                        else
                            $html.= "-";

                        // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                        if( isset( $campo['post_texto'] ) )
                            $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";

                    }; break;

                    case self::$MODO_ESCRITURA : {

                        if( isset( $campo['pre_texto'] ) && !empty( $campo['pre_texto'] ) ) {
                            $html.= "<br/><span style=\"font-style: italic;\">".$this->CI->lang->line( (string)$campo['pre_texto'] )."</span>";
                        }

                        $html.= "<input type=\"text\" id=\"".$campo['nombre']."\" name=\"".$campo['nombre']."\" ";
                        if( !empty( $this->form_valores ) && key_exists( (string) $campo['nombre'], $this->form_valores ) == TRUE )
                            $html.= "value=\"".$this->form_valores[ (string) $campo['nombre'] ]."\" ";

                        if( $this->validar_campo == TRUE )
                            $html.= "class=\"validate[".$this->validacion."]\" ";
                        $html.= "style=\"width: 99%\"/>";

                        // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                        if( isset( $campo['post_texto'] ) )
                            $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";
                    }; break;

                    case self::$MODO_PDF : {

                        if( isset( $this->form_valores[ (string) $campo['nombre'] ] ) )
                            $this->CI->tc_fpdf->MultiCell( 0, 6, utf8_decode( html_entity_decode( $this->form_valores[ (string) $campo['nombre'] ], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) ) );
                        else
                            $this->CI->tc_fpdf->Cell( 0, 6, "-", 0, 1, "L");

                        // Establece altura próximo registro
                        if( $this->y_1columna_pagina < $this->CI->tc_fpdf->PageNo() )
                            $this->CI->tc_fpdf->SetY( $this->CI->tc_fpdf->GetY() );
                        else
                            $this->CI->tc_fpdf->SetY( max( $this->y_1columna, $this->CI->tc_fpdf->GetY() ) );
                    }; break;
                };

                return $html;
            }; break;

            case 'radio'    : {

                $html = '';

                switch( $this->modo ) {

                    case self::$MODO_LECTURA : {

                        $i = $this->form_valores[ (string) $campo['nombre'] ];
                        $html.= $this->form_datos[ (string) $campo['nombre'] ] [ $i ];

                        // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                        if( isset( $campo['post_texto'] ) )
                            $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";

                    }; break;

                    case self::$MODO_ESCRITURA : {

                        foreach( $this->form_datos[ (string) $campo['nombre'] ] as $clave => $valor ) {

                            $html.= "<input type=\"radio\" id=\"".(string) $campo['nombre']."\" name=\"".(string) $campo['nombre']."\" value=\"".$clave."\" ";

                            if( key_exists( (string) $campo['nombre'], $this->form_valores ) == TRUE ) {
                                if( $this->form_valores[ (string) $campo['nombre'] ] == $clave )
                                    $html.= "value=\"".$this->form_valores[ (string) $campo['nombre'] ]."\" checked=\"checked\" ";
                                else
                                    $html.= "value=\"".$this->form_valores[ (string) $campo['nombre'] ]."\" ";

                            }

                            if( $this->validar_campo == TRUE )
                                $html.= "class=\"validate[".$this->validacion."]\"";
                            $html.= "/>".$valor;

                            // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                            if( isset( $campo['post_texto'] ) )
                                $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";

                            $html.=PHP_EOL."<br/>";
                        }
                    }; break;

                    case self::$MODO_PDF : {

                        $this->CI->tc_fpdf->MultiCell( 0, 6, html_entity_decode( $this->form_valores[ (string) $campo['nombre'] ], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ) );
                        $this->CI->tc_fpdf->Ln( );
                    }; break;
                }

                return $html;
            }; break;

            case 'select'    : {

                $html = "";

                switch( $this->modo ) {

                    case self::$MODO_LECTURA : {

                        $i = $this->form_valores[ (string) $campo['nombre'] ];
                        $html.= $this->form_datos[ (string) $campo['nombre'] ] [ $i ];

                        // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                        if( isset( $campo['post_texto'] ) )
                            $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";

                    }; break;

                    case self::$MODO_ESCRITURA : {

                        $html = "<select id=\"".$campo['nombre']."\" name=\"".$campo['nombre']."\"";

                        if( $this->validar_campo )
                            $html.= "class=\"validate[".$this->validacion."]\" ";
                        $html.= '>';

                        if( isset( $this->form_datos[ (string) $campo['nombre'] ] ) && !empty( $this->form_datos[ (string) $campo['nombre'] ] ) )
                            if( key_exists( "", $this->form_datos[ (string) $campo['nombre'] ] ) ) {
                                $html.= "<option value=\"\" ></option>";
                                unset( $this->form_datos[(string) $campo['nombre'] ][ "" ] );
                            }

                            foreach( $this->form_datos[ (string) $campo['nombre'] ] as $clave => $valor ) {

                                if( isset( $this->form_valores[ (string) $campo['nombre'] ] ) &&
                                    !empty( $this->form_valores[ (string) $campo['nombre'] ] ) &&
                                    ( $clave == $this->form_valores[ (string) $campo['nombre'] ] ) )
                                    $html.= "<option value=\"".$clave."\" selected=\"selected\" >".$valor."</option>";
                                else
                                    $html.= "<option value=\"".$clave."\">".$valor."</option>".PHP_EOL;
                            }
                        $html.= "</select>";

                        // Texto que se agrega después del valor del campo como por ejemplo unidad de medida, ej: "cantidad: 120 kgs"
                        if( isset( $campo['post_texto'] ) )
                            $html.= "&nbsp; <span >" . $this->CI->lang->line( (string) $campo['post_texto'] ) . "</span>";

                    }
                }

                return $html;
            }; break;

            case 'textarea'    : {

                $html = "";

                if( isset( $this->form_valores[ (string) $campo['nombre'] ] ) && !empty( $this->form_valores[ (string) $campo['nombre'] ] ) ) {

                    $a = preg_replace( "/<br(\s)*(\/)*>/i", "", $this->form_valores[ (string) $campo['nombre'] ] );
                    $a = preg_replace( "/^\n++(?! )/", "", $a );
                    $this->form_valores[ (string) $campo['nombre'] ] = preg_replace( "/\n++(?! )(&nbsp;)*$/", "", $a );
                }

                switch( $this->modo ) {

                    case self::$MODO_LECTURA : {

                        if( isset( $this->form_valores[ (string) $campo['nombre'] ] ) )
                            $html.= nl2br( $this->form_valores[ (string) $campo['nombre'] ] );
                        else
                            $html.= "-";
                    }; break;

                    case self::$MODO_ESCRITURA : {

                        $html = "";
                        if( isset( $campo['pre_texto'] ) && !empty( $campo['pre_texto'] ) ) {
                            $html.= "<br/><span style=\"font-style: italic;\">".$this->CI->lang->line( (string)$campo['pre_texto'] )."</span>";
                        }
                        $html.= "<textarea name=\"".$campo['nombre']."\" id=\"".$campo['nombre']."\" ";

                        if( $this->validar_campo == TRUE )
                            $html.= "class=\"validate[".$this->validacion."]\" ";

                            if( !empty( $campo['ancho'] ) )
                                $html.= " cols=\"".$campo['ancho']."\" ";
                            else
                                $html.= " cols=\"80\" ";
                        $html.= ">";

                        if( !empty( $this->form_valores[ (string) $campo['nombre'] ] ) )
                            $html.= ( ( $this->CI->session->userdata( "SIT_ID" ) != 2 ) ) ? nl2br( $this->form_valores[ (string) $campo['nombre'] ] ) : $this->form_valores[ (string) $campo['nombre'] ];

                        $html.="</textarea>".PHP_EOL;
                    }; break;

                    case self::$MODO_PDF : {

                        if( isset( $this->form_valores[ (string) $campo['nombre'] ] ) )
                            $this->CI->tc_fpdf->MultiCell( 0, 6, utf8_decode( $this->form_valores[ (string) $campo['nombre'] ] ) );
                        else
                            $this->CI->tc_fpdf->Cell( 0, 6, "-", 0, 1, "L");

                        // Establece altura próximo registro
                        if( $this->y_1columna_pagina < $this->CI->tc_fpdf->PageNo() )
                            $this->CI->tc_fpdf->SetY( $this->CI->tc_fpdf->GetY() );
                        else
                            $this->CI->tc_fpdf->SetY( max( $this->y_1columna, $this->CI->tc_fpdf->GetY() ) );

                    }; break;
                }

                return $html;
            }; break;

            case 'ayuda'    : {
                return $this->CI->lang->line( (string) $campo['clave_dic'] );
            }; break;

            case 'oculto'    : {

                $html = "<input type=\"hidden\" name=\"".$campo['nombre']."\" ";

                if( !empty( $this->form_valores[ (string) $campo['nombre'] ] ) )
                    $html.= "value=\"".$this->form_valores[ (string) $campo['nombre'] ]."\" " ;
                $html.= "/>";
                return $html;
            }; break;

            case 'html'    : {

                $html = "";
                $todo = array( );
                $todo['modo'] = $this->modo;

                if( !empty( $this->form_valores ) )
                    $todo = array_merge( $todo, $this->form_valores );

                if( !empty( $this->form_datos ) )
                    $todo = array_merge( $todo, $this->form_datos );

                if( !empty( $this->tc ) )
                    $todo = array_merge( $todo, array( 'tc' => $this->tc ) );

                if( $this->modo == FormularioXML::$MODO_PDF ) {

                    if( !empty( $this->datos ) )
                        $todo = array_merge( $todo, $this->datos );

                    $todo = array_merge( $todo, array( 'pdf' => &$this->CI->tc_fpdf ) );
                    $this->CI->load->view( 'forms/'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'. (string) $campo['nombre'], $todo, TRUE );
                    $this->CI->tc_fpdf->Ln();

                    // Establece altura próximo registro
                    if( $this->y_1columna_pagina < $this->CI->tc_fpdf->PageNo() )
                        $this->CI->tc_fpdf->SetY( $this->CI->tc_fpdf->GetY() );
                    else
                        $this->CI->tc_fpdf->SetY( max( $this->y_1columna, $this->CI->tc_fpdf->GetY() ) );
                } else
                    $html = $this->CI->load->view( 'forms/'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'.(string) $campo['nombre'], $todo, TRUE );

                return $html;
            }; break;
        }
    }

    public function form_datos( $clave, $valores ) {

        $this->form_datos[ $clave ] = $valores;
    }

    public function form_valores( $clave, $valores ) {

        $this->form_valores[ $clave ] = $valores;
    }

    public function obtener_valores( $id_teleconsulta ) {

        $valores = array( );
        $valores['tc_id'] = $id_teleconsulta;

        $datos = $this->CI->platc_model->tc_obtener_data( $id_teleconsulta );

        // Limpia campos de saltos de líneas posteriores y anteriores al texto
        if( !empty( $datos ) )
            foreach( $datos as $k => $campo ) {
                $datos[ $k ] = preg_replace( "/<br(\s)*(\/)*>/i", "", $campo );
                $datos[ $k ] = preg_replace( "/^\n++(?! )/", "", $datos[ $k ] );
                $datos[ $k ] = preg_replace( "/\n++(?! )(&nbsp;)+$/", "", $datos[ $k ] );
            }

        if( $this->modo == self::$MODO_PDF ) {
            foreach( $datos as $clave => $dato ) {
                if( is_array( $dato ) ) {
                    foreach( $dato as $k => $v )
                        $dato[$k] = $this->htmlpurifier->purify( $v );
                    $datos[$clave] = $dato;
                } else
                    $datos[$clave] = $this->htmlpurifier->purify( $dato );
            }
        }
        //sinergia
        $this->archivo_formulario = ($this->tc['CLI_ID'] == $this->config_cli_id['sinergia']) ? "form_sinergia" : $this->CI->platc_model->tc_obtener_formulario( $id_teleconsulta );
        
		$this->form_datos( 'archivo_formulario', $this->archivo_formulario ); // Agrega variable para que esté disponible en los parciales

        $ruta = APPPATH.'libraries/Formularios_TC/'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'_valores.xml';

        if( file_exists( $ruta ) ) {

            $xml = simplexml_load_file( $ruta );
            if( $xml !== FALSE ) {
                if( $xml->getName( ) == 'formulario' ) {

                    log_message( 'debug', '[XML] Cargando formulario /'.$this->tc['SIT_PAIS'].'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'_valores.xml' );

                    foreach( $xml->children() as $campo ) {

                        // Comprueba que el campo del formulario deba tener valor
                        if( !empty( $datos ) && array_key_exists( (string) $campo['nombre'], $datos ) ) {
//imprimir( $campo,false );
                            if( $this->CI->util->is_json( $datos[ (string) $campo['nombre'] ] ) ) {

                                $v = json_decode( $datos[ (string) $campo['nombre'] ] );

                                if( $campo->count() > 0 ) {

                                    $var = array( );
                                    foreach( $campo->children() as $tabla )
                                        $var = $this->CI->platc_model->obtener_valores( (string) $tabla['nombre'],
                                                                                        (string) $tabla['clave'],
                                                                                        (string) $tabla['valor'],
                                                                                        $v,
                                                                                        $this->CI->session->userdata( 'SIT_ID' ) );
                                        $v =  $var;
                                }
                                $valores[ (string) $campo[ 'nombre' ] ] = $v;
                            } else
                                $valores[ (string) $campo[ 'nombre' ] ] = $this->htmlpurifier->purify( $datos[ (string) $campo[ 'nombre' ] ] );
                        }

                    }

                    return $valores;
                }
            } else throw new Exception( 'archivo no parseable en xml: '.$ruta );
        } else throw new Exception( 'Archivo no encontrado: '.$ruta );
    }

    public function obtener_campos( $id_teleconsulta ) {
        // sinergia
        $this->archivo_formulario = ($this->tc['CLI_ID'] == $this->config_cli_id['sinergia']) ? "form_sinergia" : $this->CI->platc_model->tc_obtener_formulario( $id_teleconsulta );
		
        $ruta = APPPATH.'libraries/Formularios_TC/'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'_valores.xml';

        if( file_exists( $ruta ) ) {

            $xml = simplexml_load_file( $ruta );
            if( $xml !== FALSE ) {
                if( $xml->getName( ) == 'formulario' ) {

                    log_message( 'debug', '[XML] Cargando formulario /'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'_valores.xml' );

                    $campos = array( );
                    foreach( $xml->children() as $campo )
                        $campos[] = (string) $campo['nombre'];

                    return $campos;
                }
            } else throw new Exception( 'archivo no parseable en xml: '.$ruta );
        } else throw new Exception( 'archivo no encontrado: '.$ruta );
    }

    public function obtener_campos_respuesta( $id_teleconsulta ) {
        //sinergia
        $this->archivo_formulario = ($this->tc['CLI_ID'] == $this->config_cli_id['sinergia']) ? "form_sinergia" : $this->CI->platc_model->tc_obtener_formulario( $id_teleconsulta );
		
        $ruta = APPPATH.'libraries/Formularios_TC/'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'_valores_respuesta.xml';

        if( file_exists( $ruta ) ) {

            $xml = simplexml_load_file( $ruta );
            if( $xml !== FALSE ) {
                if( $xml->getName( ) == 'formulario' ) {

                    log_message( 'debug', '[XML] Cargando formulario respuesta /'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'.$this->archivo_formulario.'_valores_respuesta.xml' );

                    $campos = array( );
                    foreach( $xml->children() as $campo )
                        $campos[] = (string) $campo['nombre'];

                    return $campos;
                }
            } else throw new Exception( 'Archivo xml no parseable: '.$ruta );
        } else throw new Exception( 'Archivo no encontrado: '.$ruta );
    }

    public function establecer_datos_pdf( $datos ) {

//        foreach( $datos['tc']['datos'] as $clave => $dato ) {
//            if( is_array( $dato ) ) {
//                foreach( $dato as $k => $v )
//                    $dato[$k] = $this->htmlpurifier->purify( $v );
//                $datos['tc']['datos'][$clave] = $dato;
//            } else
//                $datos['tc']['datos'][$clave] = $this->htmlpurifier->purify( $dato );
//        }

        $this->datos = $datos;
    }

    private function inicializar_pdf( ) {

        $this->CI->load->library('tc_fpdf');
        $this->CI->tc_fpdf->establecer_imagen_cliente( $this->datos );
        $this->CI->tc_fpdf->AddPage();

        $this->CI->tc_fpdf->establecer_datos_solicitud( $this->datos );
        $this->CI->tc_fpdf->establecer_datos_paciente( $this->datos );
    }

    /**
     *
     */
    public function obtener_campos_requeridos( $id_teleconsulta ) {
		$this->tc = $this->CI->platc_model->tc_get( $id_teleconsulta );
		//sinergia
        $this->archivo_formulario = ($this->tc['CLI_ID'] == $this->config_cli_id['sinergia']) ? "form_sinergia" : $this->CI->platc_model->tc_obtener_formulario( $id_teleconsulta );
		
        $ruta = APPPATH.'libraries/Formularios_TC/'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'. $this->archivo_formulario .'_valores.xml';
        $archivo_xml = simplexml_load_file( $ruta );

        $campos_requeridos = array( );
        foreach( $archivo_xml->children() as $campo )
            if( isset( $campo['requerido'] ) )
                $campos_requeridos[] = (string)$campo['nombre'];

        return $campos_requeridos;
    }

    /**
     *
     */
    public function obtener_campos_requeridos_respuesta( $id_teleconsulta ) {
        //sinergia
        $this->archivo_formulario = ($this->tc['CLI_ID'] == $this->config_cli_id['sinergia']) ? "form_sinergia" : $this->CI->platc_model->tc_obtener_formulario( $id_teleconsulta );

        $ruta = APPPATH.'libraries/Formularios_TC/'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'. $this->archivo_formulario .'_valores_respuesta.xml';
        $archivo_xml = simplexml_load_file( $ruta );

        $campos_requeridos = array( );
        foreach( $archivo_xml->children() as $campo )
            if( isset( $campo['requerido'] ) )
                $campos_requeridos[] = (string)$campo['nombre'];

        return $campos_requeridos;
    }

    /**
     * Dado un identificador de TC, genera el html completo con nombre de
     * archivo $view, que esté establecido al interior de un formulario
     * asociado a la especialidad de la TC.
     *
     * @param int $tel_id Id de la teleconsulta
     * @param string $view Nombre del archivo de vista a mostrar (sin extension ".php")
     * @param array $data Array con datos para pasar a la vista
     * @return string Html generado
     */
    public function generar_vista_completa( $tel_id, $view, $data ) {
        // sinergia
        $this->archivo_formulario = ($this->tc['CLI_ID'] == $this->config_cli_id['sinergia']) ? "form_sinergia" : $this->CI->platc_model->tc_obtener_formulario( $tel_id );
        $ruta = 'forms/'.$this->CI->session->userdata( 'SIT_PAIS' ).'/'.$this->archivo_formulario.'/'.$view.'.php';

		

        return $this->CI->load->view( $ruta, $data, TRUE );
    }
}
