<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Description of paciente
 *
 * @author pmercado
 */
class Paciente extends CI_Controller {

    function __construct() {

        parent::__construct();

        $this->data = array( );

        $this->load->model('platc_model');
        $this->load->model('paciente_model');

        $this->load->library('form_validation');
        $this->load->library('util');

        $CI = &get_instance();
        $CI->config->load('platc', true);
        $this->path_file = $CI->config->item('path_file', 'platc');

        if ($this->session->userdata('IDI_NOMBRE') == '')
            $this->language = $this->config->item('language');
        else {
            $this->language = $this->session->userdata('IDI_NOMBRE');
        }

        $this->lang->load($this->language, $this->language);
    }

    public function index( ) {

        if( $this->session->is_logged() ) {

            $this->data['paciente'] = $this->platc_model->paciente_get( (int)$this->session->userdata('PAC_ID') );
            $this->load->view( 'acceso_pacientes/index_view', $this->data );

        } else {

            $this->load->library('seguridad_lib');
            $this->data['coordenadas'] = $this->seguridad_lib->getCoordenadas();
            $this->load->view( 'acceso_pacientes/login_view', $this->data );
        }
    }

    public function login( ) {

        $this->form_validation->set_rules('rut', '', 'required');
        $this->form_validation->set_rules('par1', '', 'required');
        $this->form_validation->set_rules('par2', '', 'required');
        $this->form_validation->set_rules('par3', '', 'required');

        if ($this->form_validation->run() != FALSE) {

            // Valida rut del paciente
            $data_paciente = $this->paciente_model->paciente_login( $this->input->post( 'rut' ) );

            // Valida coordenadas del paciente
            $cord1 = $this->input->post('coord1');
            $cord2 = $this->input->post('coord2');
            $cord3 = $this->input->post('coord3');
            $par1 = $this->input->post('par1');
            $par2 = $this->input->post('par2');
            $par3 = $this->input->post('par3');

            $this->load->library('seguridad_lib');
            $coord_correctas = $this->seguridad_lib->validarCoordenadas( $data_paciente['PAC_ID'], $cord1,$cord2,$cord3, $par1,$par2,$par3 );

            // Si $data_paciente y $coord_correctas retornan falsos (valores no encontrados), entonces se sale
            if( !$data_paciente || !$coord_correctas ) {

                $this->data['msg'] = TRUE;
            }else{

                // Establece datos de sesion
                $data_paciente['logged_in'] = TRUE;
                $data_paciente['PAC_NOMBRE_APELLIDO'] = $data_paciente['PAC_PRIMER_NOMBRE'].' '.$data_paciente['PAC_PRIMER_APELLIDO'];
                $this->session->paciente_set_session($data_paciente);

                // Cambia de idioma según el usuario acreditado
                $this->language = $this->session->userdata('IDI_NOMBRE');
                $this->lang->load( $this->language, $this->language );
            }

        }

        $this->index();
    }

    /**
     * Cierra session del paciente.
     *
     * @access public
     * @param none
     * @return none
     */
    public function logout() {

        $this->session->unset_userdata('logged_in');
        $this->session->sess_destroy();
        $this->index();
    }

    public function teleconsultas_asociadas( $id_paciente ) {

        $listado_tc = $this->paciente_model->paciente_teleconsultas_asociadas( $id_paciente, (int)$this->session->userdata('SIT_ID') );

        $json_grid = array( );
        $json_grid["total"]     = count( $listado_tc );
        $json_grid["page"]      = 1;
        $json_grid["records"]   = count( $listado_tc );
        $json_grid["rows"]      =  $listado_tc;
        $this->output->set_output( json_encode( $json_grid ) );
    }
}
