<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Report extends CI_Controller {
	
	var $limit = 1000;
	var $fechaInicio = '2016-01-01';
	var $fechaFin = '2016-06-14';
	var $especialidades;
	
	public function __construct(){
		parent::__construct();
		if(!(int)$this->session->userdata('ROL_ID') == 1){
			redirect('platc');
		}
		$this->load->model('teleconsulta_model');
		$this->especialidades = array(); //array vacio = todas las especialidades
	}
	public function index(){
		$this->load->view('platc/report/table_view');
	}
	public function generar(){
		if($_POST){
			$this->fechaInicio = ($_POST['fechaInicio']) ? substr($_POST['fechaInicio'],6,4)."-".substr($_POST['fechaInicio'],3,2)."-".substr($_POST['fechaInicio'],0,2) : "";
			$this->fechaFin = ($_POST['fechaTermino']) ? substr($_POST['fechaTermino'],6,4)."-".substr($_POST['fechaTermino'],3,2)."-".substr($_POST['fechaTermino'],0,2) : "";
			if(!$this->fechaInicio || !date_create($this->fechaInicio) || !$this->fechaFin || !date_create($this->fechaFin)){
				die('Error en formato fechas...');
			}
			if(count($this->especialidades) > 0){
				$whereEspecialidades = " AND TC_TELECONSULTA.ESP_ID IN (".implode(',',$this->especialidades).") ";
			}
			else{
				$whereEspecialidades = "";
			}
			$sql = "
				SELECT
					COUNT(DISTINCT TC_TELECONSULTA.TEL_ID) AS TOTAL
				FROM
					TC_TELECONSULTA
				INNER JOIN TC_TELECONSULTA_CIE10_RESPUESTA ON TC_TELECONSULTA.TEL_ID = TC_TELECONSULTA_CIE10_RESPUESTA.TEL_ID
				INNER JOIN TC_ESTABLECIMIENTO ON TC_TELECONSULTA.ETB_ID = TC_ESTABLECIMIENTO.ETB_ID
				INNER JOIN TC_ESPECIALIDAD ON TC_TELECONSULTA.ESP_ID = TC_ESPECIALIDAD.ESP_ID
				INNER JOIN TC_PRIORIDAD ON TC_TELECONSULTA.PRI_ID = TC_PRIORIDAD.PRI_ID
				WHERE
					EST_ID = 7
				AND TEL_FECHA_HORA_RESPUESTA BETWEEN '".$this->fechaInicio." 00:00:00'
				AND '".$this->fechaFin." 23:59:59' ".$whereEspecialidades.";
			";
			if($result = $this->teleconsulta_model->query($sql)){
				$html = '
				<table>
					<thead>
						<tr>
							<th colspan="9">DATOS DE LA TELECONSULTA</th>
							<th colspan="7">SIGNOS VITALES</th>
							<th colspan="4">Datos fisicos</th>
							<th colspan="9">Antecedentes personales</th>
							<th colspan="2"></th>
							<th colspan="6">Evaluacion y respuesta del especialista</th>
						</tr>
						<tr>
							<th>Folio</th>
							<th>Establecimiento de origen</th>
							<th>Fecha Hora envio</th>
							<th>Especialidad de destino</th>
							<th>edad</th>
							<th>Motivo consulta</th>
							<th>Motivo de consulta del paciente</th>
							<th>enfermedad actual</th>
							<th>examen fisico</th>
							<th>Presin Sist.:</th>
							<th>Presin Diast.:</th>
							<th>Presin arterial media:</th>
							<th>FC:</th>
							<th>FR:</th>
							<th>Temperatura:</th>
							<th>Satur. O2:</th>
							<th>Peso</th>
							<th>Talla</th>
							<th>IMC</th>
							<th>Clasificacion IMC</th>
							<th>Patologicos</th>
							<th>Alergicos</th>
							<th>Ocupacionales</th>
							<th>Habitos</th>
							<th>FUR</th>
							<th>Familiares</th>
							<th>Quirurgicos</th>
							<th>Toxicos</th>
							<th>Obstetricas</th>
							<th>Tratamiento Actual</th>
							<th>Diagnstico mdico general</th>
							<th>Prioridad caso segn especialista:</th>
							<th>Diagnstico presuntivo:(codigo cie10 y descripcion)</th>
							<th>Resumen de Historia Clnica:</th>
							<th>Anlisis Especialista:</th>
							<th>Orientacin de Especialista Diagnstico/ Tratamiento/ Control:</th>
							<th>Recomendaciones:</th>
						</tr>
					</thead>
					<tbody>
				';
				$total = (int)$result[0]['TOTAL'];
				$paginas = ceil($total / $this->limit);
				for($i = 0; $i < $total; $i++){
					$sql = "
						SELECT
							TC_TELECONSULTA.TEL_ID,
							ETB_NOMBRE,
							TEL_FECHA_HORA_ENVIO,
							ESP_NOMBRE,
							TEL_PAC_EDAD,
							PRI_NOMBRE,
							TEL_CIE_ID_RESPUESTA,
							TEL_CON_ESPECIALISTA,
							TEL_DIA_ESPECIALISTA,
							TEL_DIA_ORIENTACION
						FROM
							TC_TELECONSULTA
						INNER JOIN TC_TELECONSULTA_CIE10_RESPUESTA ON TC_TELECONSULTA.TEL_ID = TC_TELECONSULTA_CIE10_RESPUESTA.TEL_ID
						INNER JOIN TC_ESTABLECIMIENTO ON TC_TELECONSULTA.ETB_ID = TC_ESTABLECIMIENTO.ETB_ID
						INNER JOIN TC_ESPECIALIDAD ON TC_TELECONSULTA.ESP_ID = TC_ESPECIALIDAD.ESP_ID
						INNER JOIN TC_PRIORIDAD ON TC_TELECONSULTA.PRI_ID = TC_PRIORIDAD.PRI_ID
						WHERE
							EST_ID = 7
						AND TEL_FECHA_HORA_RESPUESTA BETWEEN '".$this->fechaInicio." 00:00:00'
						AND '".$this->fechaFin." 23:59:59' ".$whereEspecialidades." 
						GROUP BY
							TC_TELECONSULTA.TEL_ID
						LIMIT ".($this->limit * $i).",".$this->limit.";
					";
					if($teleconsultas = $this->teleconsulta_model->query($sql)){
					
						foreach($teleconsultas as $row){
							$sql = "SELECT * FROM TC_TELECONSULTA_DATA WHERE TEL_ID = ".$row['TEL_ID'];
							$queryData = $this->teleconsulta_model->query($sql);
							if($queryData){ foreach($queryData as $d){
									$tableData[$d['TD_CLAVE']] = utf8_decode($d['TD_VALOR']);
								}
							}
							$examenFisico = array();
							if(isset($tableData['tc_examen_fisico_cabeza']) && $tableData['tc_examen_fisico_cabeza']){
								$examenFisico[] = "CABEZA: ".$tableData['tc_examen_fisico_cabeza'];
							}
							if(isset($tableData['tc_examen_fisico_cuello']) && $tableData['tc_examen_fisico_cuello']){
								$examenFisico[] = "CUELLO: ".$tableData['tc_examen_fisico_cuello'];
							}
							if(isset($tableData['tc_examen_fisico_torax']) && $tableData['tc_examen_fisico_torax']){
								$examenFisico[] = "TORAX: ".$tableData['tc_examen_fisico_torax'];
							}
							if(isset($tableData['tc_examen_fisico_abdomen']) && $tableData['tc_examen_fisico_abdomen']){
								$examenFisico[] = "ABDOMEN: ".$tableData['tc_examen_fisico_abdomen'];
							}
							if(isset($tableData['tc_examen_fisico_genitales']) && $tableData['tc_examen_fisico_genitales']){
								$examenFisico[] = "GENITALES: ".$tableData['tc_examen_fisico_genitales'];
							}
							if(isset($tableData['tc_examen_fisico_extremidades']) && $tableData['tc_examen_fisico_extremidades']){
								$examenFisico[] = "EXTREMIDADES: ".$tableData['tc_examen_fisico_extremidades'];
							}
							if(isset($tableData['tc_examen_fisico_neurologico']) && $tableData['tc_examen_fisico_neurologico']){
								$examenFisico[] = "NEUROLOGICO: ".$tableData['tc_examen_fisico_neurologico'];
							}
							$obstetricia = array();
							if(isset($tableData['ap_gestaciones']) && $tableData['ap_gestaciones']){
								$obstetricia[] = "GESTACIONES: ".$tableData['ap_gestaciones'];
							}
							if(isset($tableData['ap_partos']) && $tableData['ap_partos']){
								$obstetricia[] = "PARTOS: ".$tableData['ap_partos'];
							}
							if(isset($tableData['ap_cesareas']) && $tableData['ap_cesareas']){
								$obstetricia[] = "CESAREAS: ".$tableData['ap_cesareas'];
							}
							if(isset($tableData['ap_abortos']) && $tableData['ap_abortos']){
								$obstetricia[] = "ABORTOS: ".$tableData['ap_abortos'];
							}
							//Diagnostico Medico General
							$cieList = array();
							if(isset($tableData['dm_general']) && $tableData['dm_general']){
								$sql = "SELECT * FROM TC_CIE10 WHERE CIE_ID IN (".implode(',',json_decode($tableData['dm_general'])).");";
								$cie10 = $this->teleconsulta_model->query($sql);
								if($cie10){ foreach($cie10 as $c){
										$cieList[] = $c['id10']." ".$c['dec10'];
									}
								}
							}
							//Diagnostico Medico Especialista
							$cieListEsp = array();
							if(isset($row['TEL_CIE_ID_RESPUESTA']) && $row['TEL_CIE_ID_RESPUESTA']){
								$sql = "SELECT * FROM TC_CIE10 WHERE CIE_ID IN (".implode(',',json_decode($row['TEL_CIE_ID_RESPUESTA'])).");";
								$cie10 = $this->teleconsulta_model->query($sql);
								if($cie10){ foreach($cie10 as $c){
										$cieListEsp[] = $c['id10']." ".$c['dec10'];
									}
								}
							}
							$html .= '
							<tr>
								<td valign="top">'.$row['TEL_ID'].'</td>
								<td valign="top">'.utf8_decode($row['ETB_NOMBRE']).'</td>
								<td valign="top">'.$row['TEL_FECHA_HORA_ENVIO'].'</td>
								<td valign="top">'.utf8_decode($row['ESP_NOMBRE']).'</td>
								<td valign="top">'.$row['TEL_PAC_EDAD'].'</td>
								<td valign="top">'.((isset($tableData['tc_motivo_teleconsulta'])) ? $tableData['tc_motivo_teleconsulta'] : "").'</td>
								<td valign="top">'.((isset($tableData['tc_motivo_paciente'])) ? utf8_decode($tableData['tc_motivo_paciente']) : "").'</td>
								<td valign="top">'.((isset($tableData['tc_enfermedad_actual'])) ? utf8_decode($tableData['tc_enfermedad_actual']) : "").'</td>
								<td valign="top">'.implode('; ',$examenFisico).'</td>
								<td valign="top">'.((isset($tableData['sv_presion_sist'])) ? $tableData['sv_presion_sist'] : "").'</td>
								<td valign="top">'.((isset($tableData['sv_presion_diast'])) ? $tableData['sv_presion_diast'] : "").'</td>
								<td valign="top">'.((isset($tableData['sv_presion_media'])) ? $tableData['sv_presion_media'] : "").'</td>
								<td valign="top">'.((isset($tableData['sv_fc'])) ? $tableData['sv_fc'] : "").'</td>
								<td valign="top">'.((isset($tableData['sv_fr'])) ? $tableData['sv_fr'] : "").'</td>
								<td valign="top">'.((isset($tableData['sv_temperatura'])) ? $tableData['sv_temperatura'] : "").'</td>
								<td valign="top">'.((isset($tableData['sv_sato2'])) ? $tableData['sv_sato2'] : "").'</td>
								<td valign="top">'.((isset($tableData['df_peso'])) ? $tableData['df_peso'] : "").'</td>
								<td valign="top">'.((isset($tableData['df_talla'])) ? $tableData['df_talla'] : "").'</td>
								<td valign="top">'.((isset($tableData['df_imc'])) ? $tableData['df_imc'] : "").'</td>
								<td valign="top">'.((isset($tableData['df_imc_clasificacion'])) ? $tableData['df_imc_clasificacion'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_patologicos'])) ? $tableData['ap_patologicos'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_alergicos'])) ? $tableData['ap_alergicos'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_ocupacionales'])) ? $tableData['ap_ocupacionales'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_habitos'])) ? $tableData['ap_habitos'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_fur'])) ? $tableData['ap_fur'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_familiares'])) ? $tableData['ap_familiares'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_quirurgicos'])) ? $tableData['ap_quirurgicos'] : "").'</td>
								<td valign="top">'.((isset($tableData['ap_toxicos'])) ? $tableData['ap_toxicos'] : "").'</td>
								<td valign="top">'.implode('; ',$obstetricia).'</td>
								<td valign="top">'.((isset($tableData['ia_traactual'])) ? utf8_decode($tableData['ia_traactual']) : "").'</td>
								<td valign="top">'.implode('; ',$cieList).'</td>
								<td valign="top">'.$row['PRI_NOMBRE'].'</td>
								<td valign="top">'.implode('; ',$cieListEsp).'</td>
								<td valign="top">'.utf8_decode($row['TEL_CON_ESPECIALISTA']).'</td>
								<td valign="top">'.utf8_decode($row['TEL_DIA_ESPECIALISTA']).'</td>
								<td valign="top">'.utf8_decode($row['TEL_DIA_ORIENTACION']).'</td>
								<td valign="top"> - </td>
							</tr>
							';
						}
					}
					//sleep(1);
				}
				
				$html .= '
					</tbody>
				</table>
				';
				
				header("Content-Type:application/vnd.ms-excel; charset=utf-8");
				header("Content-Disposition: attachment; filename=reporte.xls");  //File name extension was wrong
				header("Expires: 0");
				header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				header("Cache-Control: private",false);
				echo $html;
			}
		}
	}
}