<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

// compatibilidad PHP <5.4
if( !defined( 'ENT_HTML401' ) ) define( 'ENT_HTML401', 0 );

class Reportes extends CI_Controller {

	public function __construct( ) {
		parent::__construct();
        $CI = &get_instance();
        $CI->config->load('platc', true);
		$this->path_file = $CI->config->item('path_file', 'platc');
	}

    public function co_reporte_contestadas_v2( ) {

        $fecha_inicio = "2014-01-01 00:00:00";
        $fecha_fin    = "2015-01-01 00:00:00";

        /*
         * Genera Excel, aunque no haya datos que mostrar, as se evita pgina
         * en blanco
         */
        ini_set('zend.ze1_compatibility_mode', '0');
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
//        $objPHPExcel->removeSheetByIndex( $objPHPExcel->getActiveSheetIndex() ); // Elimina hoja vaca creada por omisin

        $this->load->model( 'reportes/reportes_co' );
        $reporte = $this->reportes_co->tc_contestadas_v2( $this->session->userdata('SIT_ID'), $fecha_inicio, $fecha_fin );

        // Fila de cabezera de tabla
        $i = 1; // Indice de fila
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, html_entity_decode( $this->lang->line( 'tc_id' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, html_entity_decode( $this->lang->line( 'tc_id_paciente' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, html_entity_decode( $this->lang->line( 'p_nombre_completo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, html_entity_decode( $this->lang->line( 'establecimiento' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, html_entity_decode( $this->lang->line( 'usuarios_especialidad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, html_entity_decode( $this->lang->line( 'p_sexo' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, html_entity_decode( $this->lang->line( 'p_edad' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, html_entity_decode( $this->lang->line( 'dm_general' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, html_entity_decode( $this->lang->line( 'dm_ci10_especialista' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, html_entity_decode( $this->lang->line( 'tc_responder_conespecialista' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, html_entity_decode( $this->lang->line( 'tc_responder_diaespecialista' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, html_entity_decode( $this->lang->line( 'tc_responder_diafundamentos' ) ) );
        $objPHPExcel->getActiveSheet()->SetCellValue('M'.$i, html_entity_decode( $this->lang->line( 'tc_responder_diaorientacion' ) ) );

        if( !empty( $reporte ) ) {

            // Completa filas por teleconsulta
            foreach( $reporte as $r ) {

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $r['TEL_ID'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $r['PAC_IDT_VALOR'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $r['NOMBRE_COMPLETO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $r['ETB_NOMBRE'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $r['ESP_NOMBRE'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $r['TEL_PAC_SEXO'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $r['TEL_PAC_EDAD'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $r['CIE10_GENERALISTA1'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $r['CIE10_GENERALISTA2'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $r['CIE10_GENERALISTA3'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $r['CIE10_GENERALISTA4'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $i, $r['CIE10_GENERALISTA5'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $i, $r['CIE10_GENERALISTA6'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $i, $r['CIE10_GENERALISTA7'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $i, $r['CIE10_GENERALISTA8'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $i, $r['CIE10_GENERALISTA9'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $i, $r['CIE10_GENERALISTA10'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $i, $r['CIE10_GENERALISTA11'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $i, $r['CIE10_GENERALISTA12'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $i, $r['CIE10_ESPECIALISTA1'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('U' . $i, $r['CIE10_ESPECIALISTA2'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('V' . $i, $r['CIE10_ESPECIALISTA3'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('W' . $i, $r['CIE10_ESPECIALISTA4'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('X' . $i, $r['CIE10_ESPECIALISTA5'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('Y' . $i, $r['CIE10_ESPECIALISTA6'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('Z' . $i, $r['CIE10_ESPECIALISTA7'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('AA' . $i, $r['CIE10_ESPECIALISTA8'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('AB' . $i, $r['CIE10_ESPECIALISTA9'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('AB' . $i, $r['CIE10_ESPECIALISTA10'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('AC' . $i, $r['CIE10_ESPECIALISTA11'] );
                $objPHPExcel->getActiveSheet()->SetCellValue('AD' . $i, $r['CIE10_ESPECIALISTA12'] );
               $i++; // Salto de lnea
            }
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $excel_name = 'reporte_temporal.xls';
        $file_path = $this->path_file['excel'] . $excel_name;
        $objWriter->save($this->path_file['excel'] . $excel_name);
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=Reporte_respondidos_' . date('Ymd') . '.xls');
        header('Cache-Control: public');
        header('Content-Description: File Transfer');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Pragma: no-cache');
        header('Expires: 0');
        readfile($file_path);
        unlink($file_path);
    }
}
