<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Admin_seguridad_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
    }

     public function listar_tarjetas(  $site, $pais ) {


        $this->db->select( "TARJETA_ID,USU_USUARIO,ACTIVO,F_CREACION" );
        $this->db->where( 'PAIS_ID', $pais );
        $this->db->where( 'SITE', $site );
        $this->db->order_by( 'TARJETA_ID', 'ASC' );


        $consulta = $this->db->get( 'RIS_TARJETA');

        $resultado = $consulta->result_array();

        $listado = array( );
        foreach( $resultado as $row ) {
            $listado[ ] = $row;
        }

        return $listado;
    }
    public function grabarTarjeta($usuario,$activa){
        $data = array(
        'USU_USUARIO' => $usuario ,
        'ACTIVO' => $activa ,
        'PAIS_ID' => $this->session->userdata('PAIS_ID') ,
        'SITE' => $this->session->userdata('SITE')
        );

        $this->db->insert('RIS_TARJETA', $data);
        $query = $this->db->query('SELECT LAST_INSERT_ID()');
        $row = $query->row_array();
        return $row['LAST_INSERT_ID()'];
    }
    public function grabarCodigos($tarjetaId,$coordenadas){
         for($i=0;$i<count($coordenadas);$i++){

            for($j=0;$j<count($coordenadas[$i]);$j++){
                $data = array(
                    'TARJETA_ID' => $tarjetaId ,
                    'FILA' => $i ,
                    'COLUMNA' => $j,
                    'VALOR' => $coordenadas[$i][$j]
                    );
                $this->db->insert('RIS_COORDENADA', $data);
            }
//            echo "<\tr>";
        }


    }

    public function getTarjeta($id){
        $this->db->where('TARJETA_ID',$id);
        $query = $this->db->get('RIS_TARJETA');
        return $query;
    }
    public function getTarjetaUsuario($id){
        $this->db->select('TC_USUARIO.USU_NOMBRE');
        $this->db->join('TC_USUARIO', 'TC_USUARIO.USU_ID = RIS_TARJETA.USU_USUARIO');
        $this->db->where('RIS_TARJETA.TARJETA_ID',$id);

        $query = $this->db->get('RIS_TARJETA');
        $usu_nombre="";
        foreach ($query->result() as $row)
        {
            $usu_nombre=$row->USU_NOMBRE;

        }
        return $usu_nombre;
    }

    public function getTarjetaDesdePaciente( $id_paciente ) {

        $this->db->select('RIS_TARJETA.*');
        $this->db->where('RIS_TARJETA.USU_USUARIO', (int)$id_paciente );
        $query = $this->db->get('RIS_TARJETA');

        if( $query->num_rows() > 0 )
            return $query->row_array();
        else
            return FALSE;
    }

    public function getCoordenadas($id){
        $this->db->where('TARJETA_ID',$id);
        $query = $this->db->get('RIS_COORDENADA');
        $coordenadas=array();
        foreach ($query->result() as $row)
        {
            $coordenadas[$row->FILA][$row->COLUMNA]=$row->VALOR;

        }
        return $coordenadas;
    }

    public function getCoordenadasUsuario( $id_paciente ) {

        $this->db->select( 'c.*' );
        $this->db->from( 'RIS_COORDENADA c' );
        $this->db->join( 'RIS_TARJETA t', 't.TARJETA_ID = c.TARJETA_ID' );
        $this->db->where( 't.USU_USUARIO', $id_paciente );
        $query = $this->db->get();
        if( $query->num_rows() > 0 ) {
            foreach ($query->result() as $row)
                $coordenadas[$row->FILA][$row->COLUMNA]=$row->VALOR;

            return $coordenadas;
        } else
            return NULL;
    }

    public function actualizaTarjeta($id,$activo){
        $data = array(
               'ACTIVO' => $activo
            );

        $this->db->where('TARJETA_ID', $id);
        $this->db->update('RIS_TARJETA', $data);
    }

    public function validar( $id_paciente, $cord1,$cord2,$cord3, $par1,$par2,$par3){
        $str="SELECT
	*
FROM
	RIS_TARJETA
INNER JOIN RIS_COORDENADA C1 ON C1.TARJETA_ID = RIS_TARJETA.TARJETA_ID
AND CONCAT(C1.FILA, C1.COLUMNA) = '$cord1' AND C1.VALOR = '$par1'
INNER JOIN RIS_COORDENADA C2 ON C2.TARJETA_ID = RIS_TARJETA.TARJETA_ID
AND CONCAT(C2.FILA, C2.COLUMNA) = '$cord2' AND C2.VALOR = '$par2'
INNER JOIN RIS_COORDENADA C3 ON C3.TARJETA_ID = RIS_TARJETA.TARJETA_ID
AND CONCAT(C3.FILA, C3.COLUMNA) = '$cord3' AND C3.VALOR = '$par3'
AND RIS_TARJETA.ACTIVO=1
AND RIS_TARJETA.USU_USUARIO = '".(int)$id_paciente."'";
        $query = $this->db->query($str);
        $existe=FALSE;
      //  imprimir($query->num_rows());
       if ($query->num_rows() > 0)
{
            $existe=TRUE;
        }
        return $existe;
    }
}
