<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
* Platc_Model
*
* Clase principal de la aplicacion de tipo modelo
* esta clase trabaja directamente con la base de datos
* y es ocupada por el controlador Platc.
*
* @author Esteban G�mez Lillo
* @author http://www.swift.cl
*
* @package Platc_Model
*/
class Platc_Model extends CI_Model {


    /**
    * Constructor de la clase
    *
    * @access default
    * @param none
    * @return none
    */
     function __construct()
     {
         parent::__construct();
         $CI = &get_instance();
     }

    /**
    * Metodo que recibe el usuario y password del usuario y lo
    * valida contra la base de datos respondiendo si es correcto un array
    * con los datos del usuario o un FALSE si no autentica correctamente
    *
    * @access default
    * @param string $mail email del usuario con el cual se intenta autenticar
    * @param string $pass password del usuario con el cual se intenta autenticar
    * @return array $row[0] contiene todos los datos del usuario para luego ser guardado en variables de session
    */
     function login($mail, $pass)
     {
        $sql = "SELECT  U.USU_ID, U.USU_NOMBRE, U.USU_EMAIL, U.ROL_ID,
                        C.CLI_ID, C.CLI_NOMBRE, C.CLI_IMAGEN_INSTITUCIONAL, C.CLI_ACTIVO,
                        S.SIT_ID, S.SIT_NOMBRE, S.SIT_PAIS, I.IDI_NOMBRE

                 FROM   TC_USUARIO AS U
                        INNER JOIN ( TC_SITE S
                            JOIN TC_IDIOMA I ON I.IDI_ID = S.IDI_ID )
                        ON S.SIT_ID = U.SIT_ID

                        left join TC_CLIENTE C on C.CLI_ID = U.CLI_ID ";
        $sql .= "WHERE U.USU_EMAIL = '".$mail."' ";
        $sql .= "AND U.USU_ACTIVO = '1' ";
        $sql .= "AND U.USU_PASSWORD = '".$pass."' ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
               return $row[0];
        }
         else
             return FALSE;
     }




    /**
    * Obtiene datos de un usuario con el ID de este recibido por parametro
    *
    * @access public
    * @param int $id ID del usuario del cual se obtendran los datos
    * @return array $row[0] contiene todos los datos del usuario para luego ser guardado en variables de session
    */
     public function data_user($id)
     {
        $sql = "SELECT U.USU_ID, U.USU_NOMBRE, U.USU_EMAIL, U.ROL_ID, U.ETB_ID, E.ETB_NOMBRE, C.CLI_ID, C.CLI_NOMBRE, C.CLI_IMAGEN_INSTITUCIONAL,
                        G.GRU_ID, G.GRU_NOMBRE, S.SIT_ID, S.SIT_NOMBRE, I.IDI_NOMBRE

                FROM    TC_USUARIO AS U
                            inner join TC_GRUPO G on G.GRU_ID = U.gru_id
                            inner join ( TC_SITE S
                                join TC_IDIOMA I on I.IDI_ID = S.IDI_ID )
                            on S.SIT_ID = G.SIT_ID
                            left join TC_CLIENTE C on C.CLI_ID = U.CLI_ID
                            left join TC_ESTABLECIMIENTO AS E on E.ETB_ID = U.ETB_ID
                WHERE   U.USU_ID = ".$id;


        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
               return $row[0];
        }
         else
             return FALSE;
     }

    /**
    * Cambia el password de un usuario recibiendo el ID, password actual y la nueva password
    * conprueba que la password actual corresponda y si es asi la cambia por la nueva,
    *
    * @access public
    * @param int $id ID del usuario
    * @param string $pass password actual de usuario
    * @param string $newpass nueva password del usuario
    * @return boolean TRUE si el cambio fue correcto
    */
    public function usuario_chpass($id, $pass, $newpass)
    {
        if ($this->existe_registro('TC_USUARIO', 'USU_ID', $id)) {
            $this->db->where('USU_ID', $id);
            $this->db->where('USU_PASSWORD', $pass);
            $query = $this->db->get('TC_USUARIO');
            if ($query->num_rows() > 0) {
                $data['USU_PASSWORD'] = $newpass;
                $this->db->where('USU_ID', $id);
                $this->db->update('TC_USUARIO', $data);
                return TRUE;
            }
        }
    }

    /**
    * Obtiene las afiliaciones de un site en especifico a traves del ID de este
    * recibido por parametro.
    *
    * @access public
    * @param int $id ID del site
    * @return array Arreglo con todas las afliaciones del site o NULL si no hay resultados
    */
    public function site_afiliaciones_get($id, $cod = '')
    {
        $this->db->where('SIT_ID', $id);
		if($cod && is_array($cod)) $this->db->where_in('AFI_ID',$cod);
		$this->db->where('AFI_ACTIVO', '1');
        $query = $this->db->get('TC_AFILIACION');
        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los identificadores de un site en especifico a traves del ID de este
    * recibido por parametro.
    *
    * @access public
    * @param int $id ID del site
    * @return array Arreglo con todos los identificadores del site o NULL si no hay resultados
    */
    public function site_identificadores_get($id)
    {
        $this->db->where('SIT_ID', $id);
        $query = $this->db->get('TC_IDENTIFICADOR');
        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene las prioridades del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todas las prioridades del sistema.
    */
    public function prioridades_get($ids = '')
    {
        $sql = "SELECT PRI_ID ";
        $sql .= "FROM TC_PRIORIDAD ";
        $sql .= "WHERE PRI_ID <> '4'";
		if($ids && is_array($ids)) $sql .= " AND PRI_ID IN (".implode(',',$ids).") ";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los roles del sistema,
    * menos el de administrador o el de supervisor dependiendo del usuario
    * que los consulta.
    *
    * @access public
    * @param none
    * @return array Arreglo con los roles del sistema, .
    */
    public function roles_get()
    {
        $sql = "SELECT ROL_ID ";
        $sql .= "FROM TC_ROL ";
        $sql .= "WHERE ROL_ID <> '1'";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los sites del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los sites del sistema, .
    */
    public function sites_get()
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_SITE ";
        $sql .= "WHERE SIT_ID <> '1'";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los datos de un site en especifico por su ID que llega por parametro.
    *
    * @access public
    * @param int $id ID del site
    * @return array Arreglo con todos los datos del site.
    */
    public function site_get($id)
    {
        $this->db->where('SIT_ID', $id);
        $query = $this->db->get('TC_SITE');
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene los datos de un site del sistema con su idioma para poder ser listados.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los sites.
    */
    public function sites_lista_get()
    {
        $sql = "SELECT s.SIT_ID, s.SIT_NOMBRE, s.SIT_DESCRIPCION, s.SIT_PIT_ID, i.IDI_NOMBRE ";
        $sql .= "FROM TC_SITE AS s, TC_IDIOMA as i ";
        $sql .= "WHERE s.SIT_ID <> '1' ";
        $sql .= "AND i.IDI_ID = s.IDI_ID";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza los datos de un site en especifico recibiendo
    * estos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con los datos a actualizar
    * @return boolean TRUE si fue actualizado correctamente.
    */
    public function site_upd($data)
    {
        if (!$this->existe_registro('TC_SITE', 'SIT_NOMBRE', $data['SIT_NOMBRE'], 'SIT_ID', $data['SIT_ID'])) {
            $this->db->where('SIT_ID', $data['SIT_ID']);
            $this->db->update('TC_SITE', $data);
            return TRUE;
        }
    }

    /**
    * Inserta un nuevo site en la db, recibiendo
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con los datos del nuevo site
    * @return boolean TRUE si fue insertado correctamente
    */
    public function site_set($data)
    {
        if (!$this->existe_registro('TC_SITE', 'SIT_NOMBRE', $data['SIT_NOMBRE'])) {
            $this->db->insert('TC_SITE', $data);
            return TRUE;
        }
    }

    /**
    * Elimina un site en especifico recibiendo el ID de este por parametro,
    * chequea que no tenga grupos creados y si borra el site.
    *
    * @access public
    * @param int $id ID del site a borrar
    * @return boolean TRUE si fue eliminado correctamente.
    */
    public function site_del($id)
    {
        if (!$this->existe_registro('TC_GRUPO', 'SIT_ID', $id)) {
            $data['SIT_ID'] = $id;
            $this->db->delete('TC_SITE', $data);
            return TRUE;
        }
    }

    /**
    * Obtiene todos los grupos del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los grupos
    */
    public function grupos_get()
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_GRUPO ";
        $sql .= "WHERE GRU_ID <> '1'";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los datos de un grupo en especifico recibiendo
    * el ID de este por parametro.
    *
    * @access public
    * @param int $id ID del grupo
    * @return array Arreglo con todos los datos del grupo
    */
    public function grupo_get($id)
    {
        $sql = "SELECT g.GRU_ID, g.GRU_NOMBRE, g.GRU_DESCRIPCION, s.SIT_ID, s.SIT_NOMBRE ";
        $sql .= "FROM TC_GRUPO AS g, TC_SITE AS s ";
        $sql .= "WHERE g.GRU_ID = ".$id." ";
        $sql .= "AND s.SIT_ID = g.SIT_ID ";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene los grupos del sistema con el site al que pertenece
    * para poder ser listado.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los grupos
    */
    public function grupos_lista_get( $id_site = NULL )
    {
        $sql = "SELECT g.GRU_ID, g.GRU_NOMBRE, g.GRU_DESCRIPCION, s.SIT_NOMBRE ";
        $sql .= "FROM TC_GRUPO AS g, TC_SITE as s ";
        $sql .= "WHERE g.GRU_ID <> '1' ";
        $sql .= "AND s.SIT_ID = g.SIT_ID ";

        if( !empty( $id_site ) )
            $sql.= " AND g.SIT_ID = " . $id_site;

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza un grupo en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function grupo_upd($data, $clientes, $usuarios )
    {
        $idi_site = $this->grupo_get($data['GRU_ID']);
        if (!$this->existe_registro('TC_GRUPO', 'GRU_NOMBRE', $data['GRU_NOMBRE'], 'GRU_ID', $data['GRU_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
            $this->db->where('GRU_ID', $data['GRU_ID']);
            $this->db->update('TC_GRUPO', $data);

            $this->db->delete( 'TC_GRUPO_CLIENTE', array( 'GRU_ID' => $data['GRU_ID'] ) );
            foreach( $clientes as $cliente )
                $this->db->insert('TC_GRUPO_CLIENTE', array( 'GRU_ID' => $data['GRU_ID'], 'CLI_ID' => $cliente ) );

            $this->db->delete( 'TC_GRUPO_USUARIO', array( 'GRU_ID' => $data['GRU_ID'] ) );
            foreach( $usuarios as $usuario )
                $this->db->insert('TC_GRUPO_USUARIO', array( 'GRU_ID' => $data['GRU_ID'], 'USU_ID' => $usuario ) );

            return TRUE;
        }
    }

    /**
    * Obtiene el listado de grupos asociados a un usuario en particular
    * Los usuarios son especialistas.
    *
    * @access public
    * @param int $id_usuario Identificador del usuario
    * @return array Grupos asociados al usuario
    */
    public function grupos_por_usuario( $id_usuario )
    {
        $sql = "SELECT  *
                FROM    TC_GRUPO_USUARIO GU
                        INNER JOIN TC_USUARIO U ON ( U.USU_ID = GU.USU_ID )
                WHERE   GU.GRU_ID = " . $id_usuario;
        $query = $this->db->query( $sql );

        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Inserta un nuevo grupo en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function grupo_set($data, $clientes, $usuarios)
    {
        if (!$this->existe_registro('TC_GRUPO', 'GRU_NOMBRE', $data['GRU_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {

            $this->db->insert('TC_GRUPO', $data);
            $id_grupo = $this->db->insert_id();

            if( !empty( $clientes ) )
                foreach( $clientes as $cliente )
                    $this->db->insert('TC_GRUPO_CLIENTE', array( 'GRU_ID' => $id_grupo, 'CLI_ID' => $cliente ) );

            if( !empty( $usuarios ) )
                foreach( $usuarios as $usuario )
                    $this->db->insert('TC_GRUPO_USUARIO', array( 'GRU_ID' => $id_grupo, 'USU_ID' => $usuario ) );

            return TRUE;
        }
    }

    /**
    * Elimina un grupo en especifico por el ID recibido por parametro,
    * esto solo si el grupo no tiene clientes asociados a el.
    *
    * @access public
    * @param int $id ID del grupo
    * @return boolean TRUE si se elimino correctamente
    */
    public function grupo_del($id)
    {
        if (!$this->existe_registro('TC_CLIENTE', 'GRU_ID', $id)) {
            $data['GRU_ID'] = $id;
            $this->db->delete('TC_GRUPO_CLIENTE', $data);
            $this->db->delete('TC_GRUPO_USUARIO', $data);
            $this->db->delete('TC_GRUPO', $data);
            return TRUE;
        }
    }

    /**
    * Obtiene los clientes del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los clientes
    */
    public function clientes_get( $id_site = null )
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_CLIENTE ";
        $sql .= "WHERE CLI_ID <> '1'";

        if( !empty( $id_site ) )
            $sql.=" AND SIT_ID = ".$id_site;

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene un cliente en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del cliente
    * @return array Arreglo con los datos del cliente
    */
    public function cliente_get($id)
    {
        $sql = "SELECT  c.CLI_ID, c.CLI_NOMBRE, c.CLI_RUT, c.CLI_RAZON_SOCIAL, c.SIT_ID, c.CLI_IMAGEN_INSTITUCIONAL,
                        c.CLI_REVISOR, c.CLI_ACTIVO, c.CLI_CODIGO_PRESTADOR, s.SIT_NOMBRE ";
        $sql .= "FROM   TC_CLIENTE AS c
                        INNER JOIN TC_SITE AS s ON ( s.SIT_ID = c.SIT_ID )";
        $sql .= "WHERE c.CLI_ID = ".$id." ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene los clientes del sistema con su grupo y site
    * al que pertenece para poder ser listados.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los clientes
    */
    public function clientes_lista_get()
    {
        $sql = "SELECT c.CLI_ID, c.CLI_NOMBRE, c.CLI_RUT, s.SIT_NOMBRE, c.CLI_ACTIVO ";
        $sql .= "FROM TC_CLIENTE AS c
                        INNER JOIN TC_SITE s ON ( s.SIT_ID = c.SIT_ID ) ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ) {
            $sql.= "    INNER JOIN ( TC_GRUPO_CLIENTE gc
                            INNER JOIN ( TC_GRUPO g
                                INNER JOIN TC_GRUPO_USUARIO gu ON ( gu.GRU_ID = g.GRU_ID AND gu.USU_ID = " . $this->session->userdata('USU_ID') . " )
                            ) ON ( g.GRU_ID = gc.GRU_ID )
                        ) ON ( gc.CLI_ID = c.CLI_ID ) ";
        }

        $sql .= "WHERE c.SIT_ID = ".$this->session->userdata('SIT_ID')." ";
        $sql .= "       AND c.CLI_ID <> '1' ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza un cliente en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function cliente_upd($data, $especialidades )
    {
        $idi_site = $this->cliente_get($data['CLI_ID']);
        if (!$this->existe_registro('TC_CLIENTE', 'CLI_RUT', $data['CLI_RUT'], 'CLI_ID', $data['CLI_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
            $this->db->where('CLI_ID', $data['CLI_ID']);
            $this->db->update('TC_CLIENTE', $data);

            // Elimina registros asociados a las especialidades
            $this->db->where( 'CLI_ID', $data['CLI_ID'] );
            $this->db->delete( 'TC_CLIENTE_ESPECIALIDAD' );

            foreach( $especialidades as $especialidad )
                $this->db->insert( 'TC_CLIENTE_ESPECIALIDAD', array( 'CLI_ID' => $data['CLI_ID'], 'ESP_ID' => $especialidad ) );

            return TRUE;
        }
    }

    /**
    * Inserta un nuevo cliente en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function cliente_set( $data, $especialidades )
    {
        if (!$this->existe_registro('TC_CLIENTE', 'CLI_RUT', $data['CLI_RUT'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {

            $this->db->insert('TC_CLIENTE', $data);
            $id_cliente = $this->db->insert_id();

            foreach( $especialidades as $especialidad )
                $this->db->insert( 'TC_CLIENTE_ESPECIALIDAD', array( 'CLI_ID' => $id_cliente, 'ESP_ID' => $especialidad ) );

            return $id_cliente;
        }
    }

    /**
    * Elimina un cliente en especifico por el ID recibido por parametro,
    * esto solo si el cliente no tiene establecimientos asociados a el.
    *
    * @access public
    * @param int $id ID del cliente
    * @return boolean TRUE si se elimino correctamente
    */
    public function cliente_del($id)
    {
        if (!$this->existe_registro('TC_ESTABLECIMIENTO', 'CLI_ID', $id)) {
            $data['CLI_ID'] = $id;
            $this->db->delete('TC_CLIENTE', $data);
            return TRUE;
        }
    }

    /**
     * Activa un cliente cambiando su estado
     *
     * @param int $id_cliente identificador del cliente a activar
     * @return bool true al actualizar correctamente, false en otro caso
     */
    public function cliente_activar( $id_cliente ) {

        $this->db->where( 'CLI_ID', (int)$id_cliente );
        return $this->db->update( 'TC_CLIENTE', array( 'CLI_ACTIVO' => 1 ) );
    }

    /**
     * Desactiva un cliente cambiando su estado
     *
     * @param int $id_cliente identificador del cliente a desactivar
     * @return bool true al actualizar correctamente, false en otro caso
     */
    public function cliente_desactivar( $id_cliente ) {

        $this->db->where( 'CLI_ID', (int)$id_cliente );
        return $this->db->update( 'TC_CLIENTE', array( 'CLI_ACTIVO' => 0 ) );
    }

    /**
    * Obtiene los establecimientos del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los establecimientos
    */
    public function establecimientos_get()
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_ESTABLECIMIENTO ";
        $sql .= "WHERE ETB_ID <> '1'";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los establecimientos de un cliente.
    *
    * @access public
    * @param int $id ID del cliente
    * @return array Arreglo con todos los establecimientos
    */
    public function establecimientos_cliente_get($id)
    {
        $sql = "SELECT ETB_ID, ETB_NOMBRE ";
        $sql .= "FROM TC_ESTABLECIMIENTO ";
        $sql .= "WHERE ETB_ID <> 1 ";
        $sql .= "AND CLI_ID = ".$id;
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene un establecimiento en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del establecimiento
    * @return array Arreglo con los datos del establecimientos
    */
   // (SI2811)
   //AGREGAMOS ETB_MUNI_ID PARA MOSTRAR MUNICIPIOS EN COMBOS 
    public function establecimiento_get($id)
    {

        $sql = "SELECT  e.ETB_ID, e.ETB_NOMBRE, e.ETB_NIVEL, e.ETB_DIRECCION, e.ETB_EMAIL, e.CLI_ID, e.SIT_ID, e.MUNI_ID, e.ETB_DETALLE_NIVEL, e.ETB_CIUDAD, e.ETB_TELEFONO,
                        s.SIT_NOMBRE,e.ETB_DPTO_ID, e.ETB_MUNI_ID ";
        $sql .= "FROM   TC_ESTABLECIMIENTO AS e
                            INNER JOIN ( TC_CLIENTE AS c
                                INNER JOIN TC_SITE s ON ( s.SIT_ID = c.SIT_ID )
                            ) ON ( c.CLI_ID = e.CLI_ID ) ";
        $sql .= "WHERE e.ETB_ID = '".$id."' ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene los establecimientos del sistema con el cliente
    * al que pertenece para poder ser listados.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los establecimientos
    */
    public function establecimientos_lista_get( $id_site = NULL )
    {
        $sql = "SELECT e.ETB_ID, e.ETB_NOMBRE, e.ETB_NIVEL, e.ETB_DIRECCION, e.ETB_EMAIL, c.CLI_NOMBRE ";
        $sql.= "FROM   TC_ESTABLECIMIENTO AS e
                        INNER JOIN TC_CLIENTE AS c ON ( c.CLI_ID = e.CLI_ID ) ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ) {
            $sql.= "    INNER JOIN ( TC_GRUPO_CLIENTE gc
                            INNER JOIN ( TC_GRUPO g
                                INNER JOIN TC_GRUPO_USUARIO gu ON ( gu.GRU_ID = g.GRU_ID AND gu.USU_ID = " . $this->session->userdata('USU_ID') . " )
                            ) ON ( g.GRU_ID = gc.GRU_ID )
                        ) ON ( gc.CLI_ID = c.CLI_ID ) ";
        }

        $sql.= "WHERE e.ETB_ID <> '1' ";

        if( !empty( $id_site ) )
            $sql.=" AND e.SIT_ID = ". $id_site;

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza un establecimiento en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function establecimiento_upd($data)
    {
        $idi_site = $this->establecimiento_get($data['ETB_ID']);
        if (!$this->existe_registro('TC_ESTABLECIMIENTO', 'ETB_NOMBRE', $data['ETB_NOMBRE'], 'ETB_ID', $data['ETB_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
            $this->db->where('ETB_ID', $data['ETB_ID']);
            $this->db->update('TC_ESTABLECIMIENTO', $data);
            return TRUE;
        }
    }

    /**
    * Inserta un nuevo establecimiento en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function establecimiento_set($data)
    {
        if (!$this->existe_registro('TC_ESTABLECIMIENTO', 'ETB_NOMBRE', $data['ETB_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
            $this->db->insert('TC_ESTABLECIMIENTO', $data);
            return TRUE;
        }
    }

    /**
    * Elimina un establecimiento en especifico por el ID recibido por parametro.
    * esto solo si el establecimientos no tiene usuarios asociados a el.
    *
    * @access public
    * @param int $id ID del establecimiento
    * @return boolean TRUE si se elimino correctamente
    */
    public function establecimiento_del($id)
    {
        if (!$this->existe_registro('TC_USUARIO', 'ETB_ID', $id)) {
            $data['ETB_ID'] = $id;
            $this->db->delete('TC_ESTABLECIMIENTO', $data);
            return TRUE;
        }
    }

    /**
    * Retorna todos los estados segun el lenguaje que se esta trabajando.
    *
    * @access public
    * @param string $languaje Lenguaje que se esta trabajndo
    * @param boolean $sin_todos true: no muestra elemento "todos", muestra elemento "todos" en cualquier caso
    * @return array Arreglo con todos los estados en el idioma que corresponde
    */
    public function estados_select($languaje, $sin_todos = false )
    {
        $this->lang->load($languaje."_".$this->session->userdata('SIT_PAIS'), $languaje);
        if( !empty( $sin_todos ) ) $estados[0] = $this->lang->line('todos');
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ||
	    (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN']	)
            $estados[1] = $this->lang->line('estado_1');
        $estados[2] = $this->lang->line('estado_2');
        $estados[3] = $this->lang->line('estado_3');
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] )
            $estados[4] = $this->lang->line('estado_4');
        $estados[5] = $this->lang->line('estado_5');
        $estados[6] = $this->lang->line('estado_6');
        $estados[7] = $this->lang->line('estado_7');
        return $estados;
    }

    /**
    * Inserta un nuevo estado para un TC en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function tc_estado_set($data)
    {
        $this->db->insert('TC_TELECONSULTA_ESTADO', $data);
        return $this->db->insert_id();
    }

    /**
    * Obtiene una TC en un estado en especifico si esta se encuentra.
    *
    * @access public
    * @param int $id_tc ID de la TC
    * @param int $id_estado estado de la TC que se requiere
    * @return array Arreglo con la TC si esta fue encontrada
    */
    public function tc_estado_get($id_tc, $id_estado)
    {
        $sql = "SELECT  te.*,
                        u.ROL_ID, u.USU_NOMBRE, USU_ACTIVO
                FROM    TC_TELECONSULTA_ESTADO te
                        INNER JOIN TC_USUARIO u ON ( u.USU_ID = te.USU_ID )
                WHERE   te.TEL_ID = " . $id_tc . " AND u.ROL_ID NOT IN (1) AND te.EST_ID = " . $id_estado;
		$sql .= ($id_estado == 2) ? " ORDER BY TEP_ID" : " ORDER BY TEP_ID DESC";

        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0) {
			foreach( $query->result_array( ) as $v ){
				if($id_estado == 5){
					if( $v['ROL_ID'] != Platc::$ROL['MEDICO_REVISOR'] )
						return $v;
					elseif( $v['EST_ID'] == 6 ) {
						return $v;
					}
				}
				else{
					return $v;
				}
			}
        } else
            return NULL;
    }

    /**
     * Retorna un motivo de rechazo en particular
     * @param int Identificador del motivo del rechazo
     */
    public function motivo_rechazo_get( $id_motivo_rechazo ) {

        $r = $this->db->get_where( 'TC_MOTIVO_RECHAZO', array( 'MR_ID' => $id_motivo_rechazo ) );
        return $r->row_array( );
    }

    /**
     * Retorna listado de motivos de rechazo para un site en particular
     * @param int Identificador del site
     */
    public function motivo_rechazo_lista_get( $id_site ) {

        $r = $this->db->get_where( 'TC_MOTIVO_RECHAZO', array( 'SIT_ID' => $id_site ) );
        return $r->result_array( );
    }

    /**
     * Retorna información <b>adicional</b> de la solicitud de examen de una TC
     * que realiza un revisor al médico general. La repuesta está dada en tabla TC_TELECONSULTA
     *
     * @access public
     * @param int $id_tc ID de la TC
     * @return array Arreglo con la información de la solicitud de examen de la TC si ésta fue encontrada, null si no fue encontrada o no existe
     */
    public function tc_revisor_obtener_solicitud_examen( $id_tc )
    {
        $sql = "SELECT  te.*,
                        u.ROL_ID, u.USU_NOMBRE, USU_ACTIVO
                FROM    TC_TELECONSULTA_ESTADO te
                        INNER JOIN TC_USUARIO u ON ( u.USU_ID = te.USU_ID )
                WHERE   te.TEL_ID = " . $id_tc . " AND te.EST_ID = 5";

        $query = $this->db->query( $sql );
        if ($query->num_rows( ) > 0) {

            foreach( $query->result_array( ) as $v )
                if( $v['ROL_ID'] == Platc::$ROL['MEDICO_REVISOR'] )
                    return $v;
        } else
            return NULL;
    }

    /**
     * Retorna información <b>adicional</b> de la respuesta de solicitud de examen de una TC
     * que realiza un médico general al revisor. La repuesta está dada en tabla TC_TELECONSULTA
     *
     * @access public
     * @param int $id_tc ID de la TC
     * @return array Arreglo con la información de la respuesta de solicitud de examen de la TC si ésta fue encontrada, null si no fue encontrada o no existe
     */
    public function tc_revisor_obtener_solicitud_examen_resp( $id_tc )
    {
        $sql = "SELECT  te.*,
                        u.ROL_ID, u.USU_NOMBRE, USU_ACTIVO
                FROM    TC_TELECONSULTA_ESTADO te
                        INNER JOIN TC_USUARIO u ON ( u.USU_ID = te.USU_ID )
                WHERE   te.TEL_ID = " . $id_tc . " AND te.EST_ID = 6";

        $query = $this->db->query( $sql );
        if ($query->num_rows( ) > 0) {

            foreach( $query->result_array( ) as $v )
                if( $v['ROL_ID'] != Platc::$ROL['MEDICO_REVISOR'] )
                    return $v;
        } else
            return NULL;
    }

    /**
    * Obtiene los idiomas del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los idiomas
    */
    public function idiomas_get()
    {
        $this->db->order_by('IDI_NOMBRE', 'DESC');
        $query = $this->db->get('TC_IDIOMA');
        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los grupos de un site en especifico
    * recibiendo el ID del site por parametro
    *
    * @access public
    * @param int $id ID del site
    * @return array Arreglo con los grupos encontrados
    */
     public function grupos_site_get($id)
    {
        $this->db->where('SIT_ID', $id);
        $this->db->order_by('GRU_NOMBRE', 'DESC');
        $query = $this->db->get('TC_GRUPO');
        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los clientes de un grupo en especifico
    * recibiendo el ID del grupo por parametro
    *
    * @access public
    * @param int $id ID del grupo
    * @return array Arreglo con los clientes encontrados
    */
     public function clientes_grupo_get($id)
    {
        $sql = "SELECT  *
                FROM    TC_GRUPO_CLIENTE GC
                        INNER JOIN TC_CLIENTE C ON ( C.CLI_ID = GC.CLI_ID )
                WHERE   GC.GRU_ID = " . $id;
        $query = $this->db->query( $sql );

        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los clientes de un usuario en especifico
    * PASANDO POR LOS GRUPOS ASOCIADOS
    * recibiendo el ID del usuario por parametro
    *
    * @access public
    * @param int $id ID del usuario
    * @return array Arreglo con los clientes encontrados, sin repeticion
    */
     public function clientes_usuario_get( $id_usuario )
    {
        $sql = "SELECT  DISTINCT C.*
                FROM    TC_CLIENTE C
                        INNER JOIN ( TC_GRUPO_CLIENTE GC
                                        INNER JOIN ( TC_GRUPO G
                                                    INNER JOIN TC_GRUPO_USUARIO GU ON ( GU.GRU_ID = G.GRU_ID )
                                        ) ON ( GC.GRU_ID = G.GRU_ID )
                        ) ON ( C.CLI_ID = GC.CLI_ID )
                WHERE   GU.USU_ID = " . $id_usuario;
        $query = $this->db->query( $sql );

        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los establecimientos de un cliente en especifico
    * recibiendo el ID del cliente por parametro
    *
    * @access public
    * @param int $id ID del cliente
    * @return array Arreglo con los establecimientos encontrados
    */
     public function establs_cliente_get($id = '')
    {
        if($id) $this->db->where('CLI_ID', $id);

        $this->db->order_by('ETB_NOMBRE', 'DESC');
        $query = $this->db->get('TC_ESTABLECIMIENTO');
        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los especialistas de una especialidad en especifico
    * recibiendo el ID de la especialidad por parametro
    *
    * @deprecated Este método es llamado desde otro método que ha sido despreciado
    * Especialistas se asocian a grupos a traves de TC_GRUPO_USUARIO y no directamente
    * @access public
    * @param int $id ID de la especialidad
    * @return array Arreglo con los especialistas encontrados
    */
     public function especialistas_especialidad_get($id)
    {
        $sql  = "SELECT u.USU_ID, u.USU_NOMBRE ";
        $sql .= "FROM TC_USUARIO AS u, TC_USUARIO_ESPECIALIDAD AS ue ";
        $sql .= "WHERE ue.ESP_ID = ".$id." ";
        $sql .= "AND u.USU_ID = ue.USU_ID ";
        $sql .= "AND u.GRU_ID = ".$this->session->userdata('GRU_ID')." ";
        $sql .= "GROUP BY u.USU_ID";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    public function especialistas_de_cliente_por_especialidad( $id_cliente, $id_especialidad ) {
        $sql = "SELECT    DISTINCT *
                FROM     TC_USUARIO_ESPECIALIDAD ue
                        INNER JOIN ( TC_USUARIO u
                            INNER JOIN ( TC_GRUPO_USUARIO ug
                                INNER JOIN ( TC_GRUPO g
                                    INNER JOIN ( TC_GRUPO_CLIENTE gc ) ON ( gc.GRU_ID = g.GRU_ID )
                                ) ON ( g.GRU_ID = ug.GRU_ID )
                            ) ON ( ug.USU_ID = u.USU_ID )
                        ) ON ( u.USU_ID = ue.USU_ID )

                WHERE    gc.CLI_ID = " . $id_cliente . "
                    AND u.USU_ACTIVO = 1 /* FH -> SI1383 */
                    AND ue.ESP_ID = " . $id_especialidad;

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los especialistas de un sitio
    *
    * @access   public
    * @param    int $id Identificador del site de donde se obtendrán los especialistas
    * @return   array Arreglo con los especialistas encontrados
    */
     public function especialistas_por_site( $id_site, $vigente = 1 )
    {
        $this->db->order_by( 'USU_NOMBRE', 'ASC' );
        $query = $this->db->get_where( 'TC_USUARIO', array( 'SIT_ID' => $id_site, 'USU_ACTIVO' => $vigente, 'ROL_ID' => '3' ) );
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los especialistas de una especialidad en especifico
    * recibiendo el ID de la especialidad por parametro
    *
    * @access public
    * @param int $id ID de la especialidad
    * @return array Arreglo con los especialistas encontrados
    */
     public function generalistas_establecimiento_get($id)
    {
        $sql = "SELECT USU_ID, USU_NOMBRE ";
        $sql .= "FROM TC_USUARIO ";
        $sql .= "WHERE ETB_ID = ".$id." ";
        $sql .= "AND ROL_ID > 3 ";
        $sql .= "ORDER BY USU_NOMBRE";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todas las especialidades de un usuario en especifico
    * recibiendo el ID del usuario por parametro
    *
    * @access public
    * @param int $id ID del usuario
    * @param bool $especialidad_activo Lista solo especialidades activas, TRUE: solo activos, todos en cualquier caso
    * @return array Arreglo con los usuarios encontrados
    */
     public function usuario_especialidades_get( $id, $especialidad_activo = TRUE )
    {
        $sql = "SELECT e.ESP_ID, e.ESP_NOMBRE ";
        $sql .= "FROM TC_USUARIO_ESPECIALIDAD AS ue, TC_ESPECIALIDAD AS e ";
        $sql .= "WHERE ue.USU_ID = ".$id." ";
        $sql .= "AND e.ESP_ID = ue.ESP_ID ";

        if( $especialidad_activo )
            $sql .= " AND e.ESP_ACTIVO = 1";

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todos los establecimientos asociados a un usuario en especifico
    * recibiendo el ID del usuario por parametro
    *
    * @access public
    * @param int $id ID del usuario
    * @return array Arreglo con los establecimientos asociados
    */
     public function usuario_establecimientos_get($id)
    {
        $sql = "SELECT E.*
                FROM TC_USUARIO U
                        INNER JOIN ( TC_CLIENTE C
                            INNER JOIN TC_ESTABLECIMIENTO E ON E.CLI_ID = C.CLI_ID )
                        ON C.CLI_ID = U.CLI_ID
                WHERE U.USU_ID = " . $id . ";";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Inserta las especialidades que un especialista tiene, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a insertar
    * @return boolean TRUE si se inserto correctamente
    */
    public function usuario_especialidad_set_upd($data)
    {
        $this->db->insert('TC_USUARIO_ESPECIALIDAD', $data);
        return TRUE;
    }

    /**
    * Inserta un nuevo usuario en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function usuario_set($data, $grupo)
    {

        if (!$this->existe_registro('TC_USUARIO', 'USU_EMAIL', $data['USU_EMAIL'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {

            $this->db->insert('TC_USUARIO', $data);
            $id = $this->db->insert_id();

            if( !empty( $id ) )
                return $id;
            else
                return "ERROR1";
        }
        else
            return FALSE;
    }


    // NF432 -> FH
    public function usuario_edita_contrasenia($pass,$id_usuario){

         $sql = " UPDATE TC_USUARIO SET USU_PASSWORD = '"  . md5($pass) . "' WHERE USU_ID = " . $id_usuario ;
         $this->db->query($sql);

         echo "La contraseña ha sido actualizada";
    }


    /**
    * Obtiene los usuarios del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los usuarios
    */
    public function usuarios_get( $id_site = NULL )
    {

        $sql = "SELECT  u.USU_ID, u.USU_NOMBRE, u.USU_EMAIL, u.USU_ACTIVO,
                        u.ROL_ID, u.SIT_ID, s.SIT_NOMBRE, c.CLI_NOMBRE
                FROM    TC_USUARIO AS u
                        INNER JOIN TC_SITE AS s ON ( s.SIT_ID = u.SIT_ID )
                        LEFT JOIN TC_CLIENTE AS c ON ( c.CLI_ID = u.CLI_ID ) ";

        // Rol de Supervisor: solo usuarios de su grupo
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ) {
            $sql.= "WHERE   u.USU_ID IN (

                                -- Especialistas y Revisor: Usuarios que están asociados a grupos
                                SELECT    gu1.USU_ID
                                FROM    TC_GRUPO_USUARIO gu1
                                    INNER JOIN TC_GRUPO_USUARIO gu2 ON ( gu2.GRU_ID = gu1.GRU_ID )
                                    INNER JOIN TC_USUARIO u ON ( u.USU_ID = gu1.USU_ID )
                                WHERE  gu2.USU_ID = ".$this->session->userdata('USU_ID')." AND u.ROL_ID > 2 AND u.SIT_ID = ".(int)$id_site."

                                UNION

                                -- Generalistas: Usuarios que están asociados al cliente
                                SELECT    u.USU_ID
                                FROM    TC_USUARIO u
                                    INNER JOIN ( TC_GRUPO_CLIENTE gc
                                        INNER JOIN TC_GRUPO_USUARIO gu ON ( gu.GRU_ID = gc.GRU_ID )
                                    ) ON ( u.CLI_ID = gc.CLI_ID )

                                WHERE    gu.USU_ID = ".(int)$this->session->userdata('USU_ID')." ".( !empty( $id_site ) ? " AND u.SIT_ID = ".(int)$id_site : "" )."
                            )";
		} else if($this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE']){ //NF432 Solo devuelve usuarios activos
			$sql .= " WHERE u.USU_ACTIVO = 1 ";
			$sql.= !empty( $id_site ) ? " AND u.SIT_ID = ".(int)$id_site : "" ;
			$sql .= " AND u.ROL_ID <> ".(int)Platc::$ROL['ADMIN']." ";
        } else {
            // Rol Administrador: todos los usuarios menos Administradores
            $sql.= " WHERE   u.ROL_ID != ".(int) Platc::$ROL['ADMIN'];
            $sql.= !empty( $id_site ) ? " AND u.SIT_ID = ".(int)$id_site : "" ;
        }

        $sql .= " ORDER BY USU_ID ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los usuarios del sistema segun roles especificados por
    * parámetros
    *
    * @access public
    * @param $roles mix Roles seleccionados para listar
    * @param $id_site int Si va establecido, se filtra registros según SITE
    * @param $activos int Si va establecido, se filtra registros según usuarios
    *                     activos (TRUE) o no (FALSE). Si no se establece (null)
    *                     muestra usuarios activos e inactivos
    */
    public function usuarios_por_rol( $roles, $id_site = NULL, $activos = NULL, $id_cliente = null )
    {
        if( !is_array( $roles ) )
            $roles = array( $roles );

        $sql = "SELECT  u.USU_ID,concat(u.USU_EMAIL,' - ',u.USU_NOMBRE) as USU_EMAIL_NOMBRE, u.USU_NOMBRE, u.USU_EMAIL, u.USU_ACTIVO,
                        u.ROL_ID, u.SIT_ID, c.CLI_NOMBRE
                FROM    TC_USUARIO AS u
                            LEFT JOIN TC_CLIENTE AS c ON ( c.CLI_ID = u.CLI_ID )

                WHERE   u.ROL_ID in ( ".  implode( ', ', $roles )." ) ";

        // Filtro por site
        if( !empty( $id_site ) )
            $sql.= " AND u.SIT_ID = ".$id_site. " ";
 if( !empty( $id_cliente ) )
            $sql.= " AND u.CLI_ID = ".$id_cliente. " ";  
      // Filtro por usuario activo/inactivo
        if( $activos == TRUE )
           $sql.= " AND u.USU_ACTIVO = 1 ";
        elseif( $activos == FALSE )
           $sql.= " AND u.USU_ACTIVO = 0 ";

        $sql .= " ORDER BY USU_NOMBRE ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene un usuario en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del usuario
    * @return array Arreglo con los datos del usuario
    */
    public function usuario_get($id)
    {
        $sql = "SELECT  u.USU_ID, u.USU_NOMBRE, u.USU_EMAIL, u.USU_ACTIVO,
                        u.ROL_ID, u.SIT_ID, u.USU_FIRMA, u.USU_NRO_REGISTRO, u.USU_SKYPE_ID,
                        u.USU_TELEFONO, u.USU_N_IDENTIFICACION, u.IDT_ID, u.IDT_VALOR,
                        s.SIT_NOMBRE, c.CLI_ID, c.CLI_NOMBRE, c.CLI_IMAGEN_INSTITUCIONAL
                FROM    TC_USUARIO AS u
                            INNER JOIN TC_SITE AS s ON ( s.SIT_ID = u.SIT_ID )
                            LEFT JOIN TC_CLIENTE AS c ON ( c.CLI_ID = u.CLI_ID )
                WHERE   u.USU_ID = ".$id;

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Metodo para buscar usuarios en la db.
    *
    * @access public
    * @param string $usu Nombre o parte del nombre del usuario
    * @return array Arreglo con los datos del usuario si este fue encontrado
    */
    public function usuario_busca_get($usu = NULL)
    {
        if ($usu != NULL && $usu != '') {
            $sql = "SELECT USU_ID, USU_NOMBRE ";
            $sql .= "FROM TC_USUARIO ";
            $sql .= "WHERE USU_NOMBRE LIKE '%".$usu."%' ";
            $query = $this->db->query($sql);
             if ($query->num_rows() > 0) {
                $row = $query->result_array();
                return $row[0];
            }
            else
                return NULL;
        }
    }

    /**
    * Obtiene los datos de un usuario segun su ID.
    *
    * @access public
    * @param int $id ID del usuario
    * @return array Arreglo con los datos del usuario si este fue encontrado
    */
    public function usuario_estado_get($id = '')
    {
		if($id){
			$sql = "SELECT U.*, C.* ";
			$sql .= "FROM TC_USUARIO U ";
			$sql .= "LEFT JOIN TC_CLIENTE C ON C.CLI_ID = U.CLI_ID ";
			$sql .= "WHERE USU_ID = ".$id;

			$query = $this->db->query($sql);
			 if ($query->num_rows() > 0) {
				$row = $query->result_array();
				return $row[0];
			}
			else{
				return NULL;
			}
		}
		else{
			return NULL;
		}
    }

    /**
    * Actualiza el estado de un usuario en el sistema, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function usuario_estado_upd($data)
    {
        $this->db->where('USU_ID', $data['USU_ID']);
        $query = $this->db->get('TC_USUARIO');
        if ( $query->num_rows() > 0 ) {
            $row = $query->result_array();
            if ( $this->session->userdata('ROL_ID') < $row[0]['ROL_ID'] ) {
                $this->db->where('USU_ID', $data['USU_ID']);
                $this->db->update('TC_USUARIO', $data);
            }
        }
    }

    /**
    * Actualiza un usuario en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @param int $grupo ID del grupo al que pertenece
    * @return boolean TRUE si se actualizo correctamente
    */
    public function usuario_upd($data, $grupo)
    {

        $idi_site = $this->usuario_get($data['USU_ID']);
        if (!$this->existe_registro('TC_USUARIO', 'USU_EMAIL', $data['USU_EMAIL'], 'USU_ID', $data['USU_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
//            if ($data['ROL_ID'] < 4) {
//                $sql = "SELECT e.ETB_ID ";
//                $sql .= "FROM TC_ESTABLECIMIENTO AS e, TC_CLIENTE AS c ";
//                $sql .= "WHERE c.GRU_ID = '".$grupo."' ";
//                $sql .= "AND e.CLI_ID = c.CLI_ID";
//                $query = $this->db->query($sql);
//                if ( $query->num_rows() > 0 ) {
//                    $row = $query->result_array();
//                    $data['ETB_ID'] = $row[0]['ETB_ID'];
//                }
//            }
            $this->db->where('USU_ID', $data['USU_ID']);
            $this->db->update('TC_USUARIO', $data);
            $datadel['USU_ID'] = $data['USU_ID'];
            $this->db->delete('TC_USUARIO_ESPECIALIDAD', $datadel);
            return TRUE;
        }
    }

    /**
    * Elimina un usuario en especifico por el ID recibido por parametro,
    * esto solo si el usuario no a participado en la respuesta de ninguna TC.
    *
    * @access public
    * @param int $id ID del usuario
    * @return boolean TRUE si se elimino correctamente
    */
    public function usuario_del($id)
    {
        if (!$this->existe_registro('TC_TELECONSULTA_ESTADO', 'USU_ID', $id)) {
            $data['USU_ID'] = $id;
            $this->db->delete('TC_USUARIO', $data);
            $this->db->delete('TC_USUARIO_ESPECIALIDAD', $data);
            return TRUE;
        }
    }

    /**
    * Obtiene el listado de usuarios asociados a un grupo en particular
    * Los usuarios son especialistas y supervisores.
    *
    * @access public
    * @param int $id_usuario Identificador del usuario
    * @return array Grupos asociados al usuario
    */
    public function usuarios_por_grupo( $id_grupo )
    {
        $sql = "SELECT  U.*
                FROM    TC_GRUPO_USUARIO GU
                        INNER JOIN TC_USUARIO U ON ( U.USU_ID = GU.USU_ID )
                WHERE   GU.GRU_ID = " . $id_grupo;
        $query = $this->db->query( $sql );

        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Inserta un paciente en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    * El valor de sesion 'CLI_ID' es válido solo para usuarios Médicos Generalistas
    * y Asistentes
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function paciente_set($data, $data2)
    {
        $chk = TRUE;
        foreach ($data2 as $d2) {
            $sql  = "SELECT IDT_ID ";
            $sql .= "FROM TC_PACIENTE_IDENTIFICADOR AS pi
                            INNER JOIN TC_PACIENTE AS p ON ( p.PAC_ID = pi.PAC_ID ) ";
            $sql .= "WHERE  pi.IDT_ID = ".$d2['IDT_ID']." AND
                            pi.PAC_IDT_VALOR = '".$d2['PAC_IDT_VALOR']."' ";
            $sql .= "   AND p.SIT_ID = " . $this->session->userdata( 'SIT_ID' ) . " ";

            if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
                (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ||
                (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] )
                $sql .= "AND p.CLI_ID = " . $this->session->userdata( 'CLI_ID' ) . " ";

            $query = $this->db->query($sql);
             if ($query->num_rows() > 0)
                $chk = FALSE;
        }
        if ($chk == TRUE) {
            $this->db->insert('TC_PACIENTE', $data);
            $pacid = $this->db->insert_id();
            foreach ($data2 as $d2) {
                $ident['PAC_ID'] = $pacid;
                $ident['IDT_ID'] = $d2['IDT_ID'];
                $ident['PAC_IDT_VALOR'] = $d2['PAC_IDT_VALOR'];
                $this->db->insert('TC_PACIENTE_IDENTIFICADOR', $ident);
            }
            return $pacid;
        }
    }

    /**
    * Busca a un paciente por su identificador.
    *
    * @access public
    * @param string $id Identificador del paciente
    * @return array Arreglo con los datos del paciente si este fue encontrado
    */
    public function pacientes_buscar_id($id, $id_site = NULL)
    {
        $sql = "SELECT  p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO,p.PAC_NACIMIENTO, a.AFI_NOMBRE,c.CLI_NOMBRE
                FROM    TC_PACIENTE as p
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR as i on ( i.PAC_ID = p.PAC_ID )
                            INNER JOIN TC_AFILIACION as a on ( a.AFI_ID = p.AFI_ID )
                            INNER JOIN TC_CLIENTE AS c on ( c.CLI_ID = p.CLI_ID )
                WHERE   p.SIT_ID = " . $this->session->userdata('SIT_ID') . "
                        AND i.PAC_IDT_VALOR LIKE '%".$id."%' ";


        if( !empty( $id_site ) )
            $sql .= "AND p.SIT_ID = ".$id_site." ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    public function pacientes_buscar_id_por_rol($id, $id_site = NULL)
    {
        $sql = "SELECT  p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO,p.PAC_NACIMIENTO, a.AFI_NOMBRE,c.CLI_NOMBRE
                FROM    TC_PACIENTE as p
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR as i on ( i.PAC_ID = p.PAC_ID )
                            INNER JOIN TC_AFILIACION as a on ( a.AFI_ID = p.AFI_ID )
                            INNER JOIN TC_CLIENTE AS c on ( c.CLI_ID = p.CLI_ID )
							INNER JOIN TC_ROL_PACIENTE ON p.PAC_ID = TC_ROL_PACIENTE.RP_PAC_ID 
                WHERE   p.SIT_ID = " . $this->session->userdata('SIT_ID') . "
                        AND i.PAC_IDT_VALOR LIKE '%".$id."%' ";


        if( !empty( $id_site ) )
            $sql .= "AND p.SIT_ID = ".$id_site." ";
		$sql .= " AND TC_ROL_PACIENTE.RP_ROL_ID = '".$this->session->userdata('ROL_ID')."' ";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }
    /**
    * Busca a un paciente por su nombre y/o apellido.
    *
    * @access public
    * @param string $nombre Nombre o parte de este de un paciente
    * @param string $apellido Apellido o parte de este de un paciente
    * @param int $id_site Identificador del site para filtrar
    * @return array Arreglo con los datos del o los pacientes si este fue encontrado
    */
    public function pacientes_buscar_na($nombre = '', $apellido = '', $id_site = NULL )
    {
        $sql = "SELECT  p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO,
                        a.AFI_NOMBRE, c.CLI_NOMBRE ";
        $sql.= "FROM    TC_PACIENTE as p
                        INNER JOIN TC_AFILIACION as a ON ( a.AFI_ID = p.AFI_ID  )
                        INNER JOIN TC_CLIENTE AS c ON ( c.CLI_ID = p.CLI_ID )
                WHERE   p.SIT_ID = ". (int)$id_site ." ";

        if( !empty( $nombre ) || !empty( $apellido ) )
            $sql.= " AND ";

        if( !empty( $nombre ) ) {
            $sql .= " upper( p.PAC_PRIMER_NOMBRE ) LIKE '%".strtoupper($nombre )."%' ";
            if ($apellido != '')	
                $sql .= " AND ";
        }

        if( !empty( $apellido ) ) {
            $a = explode( " ", $apellido, 2 );
            $sql .= " upper( p.PAC_PRIMER_APELLIDO ) LIKE '%".strtoupper( trim( $a[0] ) ) ."%' ";
            if( isset( $a[1] ) && !empty( $a[1] ) )
                $sql .= " AND upper( p.PAC_SEGUNDO_APELLIDO ) LIKE '".strtoupper( trim( $a[1] ) ) ."%' ";
        }

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }
	
    public function pacientes_buscar_na_por_rol($nombre = '', $apellido = '', $id_site = NULL )
    {
        $sql = "SELECT  p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO,
                        a.AFI_NOMBRE, c.CLI_NOMBRE ";
        $sql.= "FROM    TC_PACIENTE as p
                        INNER JOIN TC_AFILIACION as a ON ( a.AFI_ID = p.AFI_ID  )
                        INNER JOIN TC_CLIENTE AS c ON ( c.CLI_ID = p.CLI_ID )
						INNER JOIN TC_ROL_PACIENTE ON p.PAC_ID = TC_ROL_PACIENTE.RP_PAC_ID 
                WHERE   p.SIT_ID = ". (int)$id_site ." ";

        if( !empty( $nombre ) || !empty( $apellido ) )
            $sql.= " AND ";

        if( !empty( $nombre ) ) {
            $sql .= " upper( p.PAC_PRIMER_NOMBRE ) LIKE '%".strtoupper($nombre )."%' ";
            if ($apellido != '')	
                $sql .= " AND ";
        }

        if( !empty( $apellido ) ) {
            $a = explode( " ", $apellido, 2 );
            $sql .= " upper( p.PAC_PRIMER_APELLIDO ) LIKE '%".strtoupper( trim( $a[0] ) ) ."%' ";
            if( isset( $a[1] ) && !empty( $a[1] ) )
                $sql .= " AND upper( p.PAC_SEGUNDO_APELLIDO ) LIKE '".strtoupper( trim( $a[1] ) ) ."%' ";
        }
		$sql .= " AND TC_ROL_PACIENTE.RP_ROL_ID = '".$this->session->userdata('ROL_ID')."' ";
		
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Busqueda de pacientes
    *
    * @access public
    * @param string $data Otros parametros de busqueda si esque son enviados
    * @return array Arreglo con los datos del o los pacientes si este fue encontrado
    */
    public function pacientes_get($data = '')
    {
        $sql = "SELECT  p.PAC_ID, p.ETB_ID, p.SIT_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO,
                        p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO, p.PAC_SEXO, p.PAC_PROCEDENCIA, p.PAC_OCUPACION, p.PAC_ACTIVO,
                        a.AFI_NOMBRE, e.ETB_NOMBRE ";
        $sql .= "FROM   TC_PACIENTE AS p
                        INNER JOIN ( TC_ESTABLECIMIENTO AS e
                                    INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( e.ETB_ID = p.ETB_ID )
                        INNER JOIN TC_AFILIACION AS a ON ( a.AFI_ID = p.AFI_ID ) ";
        $sql .= "WHERE  ";
        $sql .= " e.CLI_ID = '".$this->session->userdata('CLI_ID')."' ";
        if ($data != '')
            $sql .= " AND ".$data;
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }
    public function pacientes_get_por_rol($data = '')
    {
        $sql = "SELECT  p.PAC_ID, p.ETB_ID, p.SIT_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO,
                        p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO, p.PAC_SEXO, p.PAC_PROCEDENCIA, p.PAC_OCUPACION, p.PAC_ACTIVO,
                        a.AFI_NOMBRE, e.ETB_NOMBRE ";
        $sql .= "FROM   TC_PACIENTE AS p
                        INNER JOIN ( TC_ESTABLECIMIENTO AS e
                                    INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( e.ETB_ID = p.ETB_ID )
                        INNER JOIN TC_AFILIACION AS a ON ( a.AFI_ID = p.AFI_ID )
						INNER JOIN TC_ROL_PACIENTE ON p.PAC_ID = TC_ROL_PACIENTE.RP_PAC_ID ";
        $sql .= "WHERE  ";
        $sql .= " e.CLI_ID = '".$this->session->userdata('CLI_ID')."' ";
		$sql .= " AND TC_ROL_PACIENTE.RP_ROL_ID = '".$this->session->userdata('ROL_ID')."' ";
        if ($data != '')
            $sql .= " AND ".$data;
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene los pacientes del sistema con el site al que pertenece
    * para poder ser listado.
    * Id rol permite según rol:
    * Administrador: todos los pacientes del site
    * Supervisor: Todos los pacientes del grupo asociado
    * Especialista: Todos los pacientes del grupo asociado y segun especialidad
    * Generalistas: Todos los pacientes del Cliente asociado
    *
    * @access public
    * @param int $id_site Id del site a cual obtener listado de pacientes
    * @param int $id_rol Rol del usuario para obtener listado
    * @return array Arreglo con todos los pacientes
    */
    public function paciente_listar( $id_site, $id_rol )
    {
        $sql = "SELECT  p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO, a.AFI_NOMBRE, c.CLI_NOMBRE
                FROM    TC_PACIENTE AS p
                            INNER JOIN TC_AFILIACION as a on ( a.AFI_ID = p.AFI_ID )
                            INNER JOIN TC_CLIENTE as c on ( c.CLI_ID = p.CLI_ID ) ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
            $sql .= "       INNER JOIN ( TC_GRUPO_CLIENTE gc
                                            INNER JOIN ( TC_GRUPO g
                                                         INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                       ) ON ( g.GRU_ID = gc.GRU_ID )
                            ) ON ( gc.CLI_ID = c.CLI_ID )
                    ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
//            $sql .= "   AND p.SIT_ID = " . $id_site . " ";
            if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] )
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). " ";
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "                   INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        $sql .= "   AND p.SIT_ID = " . $id_site . " ";

        $query = $this->db->query($sql);

         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene un paciente en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del paciente
    * @return array Arreglo con los datos del paciente
    */
    public function paciente_get($id)
    {
        $sql = "SELECT p.PAC_ID, p.PAC_PRIMER_NOMBRE, p.PAC_SEGUNDO_NOMBRE, p.PAC_PRIMER_APELLIDO, p.PAC_SEGUNDO_APELLIDO, p.PAC_NACIMIENTO, p.PAC_SEXO, p.PAC_TELEFONO, p.PAC_EMAIL, p.PAC_PROCEDENCIA, p.PAC_OCUPACION, p.PAC_ACTIVO,  p.PAC_NOMBRE_MADRE, p.PAC_APELLIDO_MADRE, a.AFI_NOMBRE, c.CLI_ID, c.CLI_NOMBRE, p.AFI_ID, p.DEP_ID,p.MUNI_ID, p.DEP_ID_PROCEDENCIA, 
p.EA_ID";
        $sql .= " FROM TC_PACIENTE AS p
                        INNER JOIN TC_AFILIACION AS a on ( a.AFI_ID = p.AFI_ID )
                        INNER JOIN TC_CLIENTE c on ( c.CLI_ID = p.CLI_ID ) ";
        $sql .= " WHERE p.PAC_ID = '".$id."' ";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene todas los identificadores de un paciente.
    *
    * @access public
    * @param int $id ID del paciente
    * @return array Arreglo con todos los identificadores del paciente
    */
    public function paciente_identificadores_get($id)
    {
        $sql = "SELECT pi.IDT_ID, pi.PAC_IDT_VALOR, i.IDT_NOMBRE, i.TIPO_IDENTIFICACION ";
        $sql .= "FROM TC_PACIENTE_IDENTIFICADOR as pi, TC_IDENTIFICADOR as i ";
        $sql .= "WHERE pi.PAC_ID = '".$id."' ";
        $sql .= "AND i.IDT_ID = pi.IDT_ID";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza un paciente en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @param array $data2 Arreglo con todos los identificadores del paciente
    * @return boolean TRUE si se actualizo correctamente o FALSE si no lo hizo
    */
    public function paciente_upd($data, $data2)
    {
        $chk = TRUE;
        foreach ($data2 as $d2) {
            $sql = "SELECT IDT_ID FROM TC_PACIENTE_IDENTIFICADOR AS pi, TC_PACIENTE AS p ";
            $sql .= "WHERE pi.IDT_ID = ".$d2['IDT_ID']." ";
            $sql .= "AND pi.PAC_ID <> ".$data['PAC_ID']." ";
            $sql .= "AND pi.PAC_IDT_VALOR = '".$d2['PAC_IDT_VALOR']."' ";
            $sql .= "AND p.PAC_ID = pi.PAC_ID ";
            $sql .= "AND p.SIT_ID = " . $this->session->userdata( 'SIT_ID' );

            $query = $this->db->query($sql);

             if ($query->num_rows() > 0)
                $chk = FALSE;
        }
        if ($chk == TRUE) {
            $this->db->where('PAC_ID', $data['PAC_ID']);
            $this->db->update('TC_PACIENTE', $data);
            $datadel['PAC_ID'] = $data['PAC_ID'];
            $this->db->delete('TC_PACIENTE_IDENTIFICADOR', $datadel);
            foreach ($data2 as $d2) {
                $ident['PAC_ID'] = $data['PAC_ID'];
                $ident['IDT_ID'] = $d2['IDT_ID'];
                $ident['PAC_IDT_VALOR'] = $d2['PAC_IDT_VALOR'];
                $this->db->insert('TC_PACIENTE_IDENTIFICADOR', $ident);
            }
            return TRUE;
        }
    }

    /**
     * Actualiza en base de datos la información de un paciente de todas las
     * Teleconsultas asociadas a éste.
     *
     * @param $id_paciente int Identificador del paciente
     * @param $data array Datos del paciente a cambiar en la TC
     * @return TRUE
     */
    public function paciente_upd_tc_vinculadas( $id_paciente, $data, $paciente_identificador ) {

        $teleconsultas = $this->tc_paciente_get( $id_paciente, null, array() );

        if( !empty( $teleconsultas ) )
            foreach( $teleconsultas as $teleconsulta ) {

                $teleconsulta = $this->tc_get( $teleconsulta['TEL_ID'] );

                $datos = array( );
                $datos[ 'TEL_ID' ]   = $teleconsulta['TEL_ID'];
                $datos[ 'EST_ID' ]   = $teleconsulta['EST_ID'];
                $datos[ 'TEL_PAC_PRIMER_NOMBRE' ]   = $data['PAC_PRIMER_NOMBRE'];
                $datos[ 'TEL_PAC_SEGUNDO_NOMBRE' ]  = ( isset( $data['PAC_SEGUNDO_NOMBRE'] ) && !empty( $data['PAC_SEGUNDO_NOMBRE'] ) ) ? $data['PAC_SEGUNDO_NOMBRE'] : '';
                $datos[ 'TEL_PAC_PRIMER_APELLIDO' ] = $data['PAC_PRIMER_APELLIDO'];
                $datos[ 'TEL_PAC_SEGUNDO_APELLIDO' ] = ( isset( $data['PAC_SEGUNDO_APELLIDO'] ) && !empty( $data['PAC_SEGUNDO_APELLIDO'] ) ) ? $data['PAC_SEGUNDO_APELLIDO'] : '';
                $datos[ 'TEL_PAC_NACIMIENTO' ]  = $data['PAC_NACIMIENTO'];
                $datos[ 'TEL_PAC_EDAD' ]        = $this->util->yearscalc( $data['PAC_NACIMIENTO'] );
                $datos[ 'TEL_PAC_SEXO' ]        = $data['PAC_SEXO'];
                $datos[ 'TEL_PAC_PROCEDENCIA' ] = $data['PAC_PROCEDENCIA'];
                $datos[ 'TEL_PAC_OCUPACION' ]   = $data['PAC_OCUPACION'];
                $datos[ 'AFI_ID' ]              = $data['AFI_ID'];
                $afiliacion = $this->afiliacion_get( $data['AFI_ID'] );
                $datos[ 'TEL_PAC_AFI_NOMBRE' ]  = $afiliacion['AFI_NOMBRE'];

                if( $this->session->userdata('SIT_ID') == 21 ) {
                    $datos[ 'TEL_PAC_NOMBRE_MADRE' ]    = $data['PAC_NOMBRE_MADRE'];
                    $datos[ 'TEL_PAC_APELLIDO_MADRE' ]  = $data['PAC_APELLIDO_MADRE'];
                }

                $this->tc_upd( $datos );

                // Obtiene identificador asociado a la TC para string de comentario
                $tc_identificador = $this->tc_ident_get( $teleconsulta['TEL_ID'] );
                $tc_identificador = $tc_identificador[0];

                // Actualiza registro que asocia TC con identificador del paciente
                // (similar a data de paciente en tabla TC)
                $identificador = $this->identificador_get( $paciente_identificador['IDT_ID'] );
                $this->tc_ident_update( $teleconsulta['TEL_ID'], $identificador['IDT_NOMBRE'], $paciente_identificador['PAC_IDT_VALOR'] );

                /*
                 * Deja constancia del cambio
                 */
                // Comentario
                $comentario = $this->lang->line('tc_cambio_paciente'). "\n";
                $comentario.= $this->lang->line('tc_nom_ape') . ": ".
                                $teleconsulta['TEL_PAC_PRIMER_NOMBRE'] .
                                ( ( isset( $teleconsulta['TEL_PAC_SEGUNDO_NOMBRE'] ) && !empty( $teleconsulta['TEL_PAC_SEGUNDO_NOMBRE'] ) ) ?  ' ' .$teleconsulta['TEL_PAC_SEGUNDO_NOMBRE'] : '' ) .
                                ' ' . $teleconsulta['TEL_PAC_PRIMER_APELLIDO'] .
                                ( ( isset( $teleconsulta['TEL_PAC_SEGUNDO_APELLIDO'] ) && !empty( $data['PAC_SEGUNDO_APELLIDO'] ) ) ?  ' ' .$teleconsulta['TEL_PAC_SEGUNDO_APELLIDO'] : '' ) ." \n";
                $comentario.= $this->lang->line('identificador'). " ".$tc_identificador['TCI_NOMBRE'].": ".$tc_identificador['TCI_VALOR']."\n";
                $comentario.= $this->lang->line('p_fecha_nacimiento'). ": ". $this->util->fecha_orden( $teleconsulta['TEL_PAC_NACIMIENTO'] ) .", ".$this->lang->line('p_edad').": ".$teleconsulta['TEL_PAC_EDAD'].", ";
                $comentario.= $this->lang->line('p_sexo'). ": ".( $teleconsulta['TEL_PAC_SEXO'] == 'M' ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino')."\n";
                $comentario.= $this->lang->line('p_telefono'). ": ".$teleconsulta['TEL_PAC_TELEFONO'].", ";
                $comentario.= $this->lang->line('p_email'). ": ".$teleconsulta['TEL_PAC_EMAIL']."\n";
                $comentario.= $this->lang->line('p_procedencia'). ": ".$teleconsulta['TEL_PAC_PROCEDENCIA'].", ";
                $comentario.= $this->lang->line('p_ocupacion'). ": ".$teleconsulta['TEL_PAC_OCUPACION']."\n";
                if( $this->session->userdata('SIT_ID') == 21 ) {
                    $comentario.= "\n";
                    $comentario.= $this->lang->line('p_nombre_madre_completo'). ": ".$teleconsulta['TEL_PAC_NOMBRE_MADRE']." ".$teleconsulta['TEL_PAC_APELLIDO_MADRE']." \n";
                }
                $comentario.= "\n" . $this->lang->line('tc_a') . "\n\n";
                $comentario.= $this->lang->line('tc_nom_ape'). ": ".
                                $data['PAC_PRIMER_NOMBRE'].
                                ( ( isset( $data['PAC_SEGUNDO_NOMBRE'] ) && !empty( $data['PAC_SEGUNDO_NOMBRE'] ) ) ? " " . $data['PAC_SEGUNDO_NOMBRE'] : '' ) .
                                " " .$data['PAC_PRIMER_APELLIDO'] .
                                ( ( isset( $data['PAC_SEGUNDO_APELLIDO'] ) && !empty( $data['PAC_SEGUNDO_APELLIDO'] ) ) ? " " .$data['PAC_SEGUNDO_APELLIDO'] : '' ) ."\n";
                $comentario.= $this->lang->line('identificador'). " ".$identificador['IDT_NOMBRE'].": ".$paciente_identificador['PAC_IDT_VALOR']."\n";
                $comentario.= $this->lang->line('p_fecha_nacimiento'). ": ". $this->util->fecha_orden( $data['PAC_NACIMIENTO'] ) .", ".$this->lang->line('p_edad').": ".$this->util->yearscalc( $data['PAC_NACIMIENTO'] ).", ";
                $comentario.= $this->lang->line('p_sexo'). ": ".( $data['PAC_SEXO'] == 'M' ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino')."\n";
                $comentario.= $this->lang->line('p_telefono'). ": ".$data['PAC_TELEFONO'].", ";
                $comentario.= $this->lang->line('p_email'). ": ".$data['PAC_EMAIL']."\n";
                $comentario.= $this->lang->line('p_procedencia'). ": ".$data['PAC_PROCEDENCIA'].", ";
                $comentario.= $this->lang->line('p_ocupacion'). ": ".$data['PAC_OCUPACION'];
                if( $this->session->userdata('SIT_ID') == 21 ) {
                    $comentario.= "\n";
                    $comentario.= $this->lang->line('p_nombre_madre_completo'). ": ".$data['PAC_NOMBRE_MADRE']." " . $data['PAC_APELLIDO_MADRE'] . "\n";
                }
                // Información técnica del cambio
                $info_tecnico = "Cambio de paciente, de \n";
                $info_tecnico.= "TEL_PAC_PRIMER_NOMBRE [".$teleconsulta['TEL_PAC_PRIMER_NOMBRE']."],\n";
                $info_tecnico.= "TEL_PAC_SEGUNDO_NOMBRE [".$teleconsulta['TEL_PAC_SEGUNDO_NOMBRE']."],\n";
                $info_tecnico.= "TEL_PAC_PRIMER_APELLIDO [".$teleconsulta['TEL_PAC_PRIMER_APELLIDO']."],\n";
                $info_tecnico.= "TEL_PAC_SEGUNDO_APELLIDO [".$teleconsulta['TEL_PAC_SEGUNDO_APELLIDO']."],\n";
                $info_tecnico.= "TCI_NOMBRE [".$tc_identificador['TCI_NOMBRE']."],\n";
                $info_tecnico.= "TCI_VALOR [".$tc_identificador['TCI_VALOR']."],\n";
                $info_tecnico.= "TEL_PAC_NACIMIENTO [". $this->util->fecha_orden( $teleconsulta['TEL_PAC_NACIMIENTO'] ) ."],\n";
                $info_tecnico.= "TEL_PAC_SEXO [".$teleconsulta['TEL_PAC_SEXO']."],\n";
                $info_tecnico.= "TEL_PAC_TELEFONO [".$teleconsulta['TEL_PAC_TELEFONO']."],\n";
                $info_tecnico.= "TEL_PAC_EMAIL [".$teleconsulta['TEL_PAC_EMAIL']."],\n";
                $info_tecnico.= "TEL_PAC_PROCEDENCIA [".$teleconsulta['TEL_PAC_PROCEDENCIA']."],\n";
                $info_tecnico.= "TEL_PAC_OCUPACION [".$teleconsulta['TEL_PAC_OCUPACION']."],\n";
                $info_tecnico.= "TEL_PAC_AFI_NOMBRE [".$teleconsulta['TEL_PAC_AFI_NOMBRE']."],\n";
                $info_tecnico.= "AFI_ID [".$teleconsulta['AFI_ID']."],\n";
                $info_tecnico.= "TEL_PAC_EDAD [".$teleconsulta['TEL_PAC_EDAD']."]";
                if( $this->session->userdata('SIT_ID') == 21 ) {
                    $info_tecnico.= "\n";
                    $info_tecnico.= "TEL_PAC_NOMBRE_MADRE [". $teleconsulta['TEL_PAC_NOMBRE_MADRE'] ."]\n";
                    $info_tecnico.= "TEL_PAC_APELLIDO_MADRE [". $teleconsulta['TEL_PAC_APELLIDO_MADRE'] ."]\n";
                }

                $info_tecnico.= "a\n";
                $info_tecnico.= "PAC_PRIMER_NOMBRE [".$data['PAC_PRIMER_NOMBRE']."],\n";
                $info_tecnico.= "PAC_SEGUNDO_NOMBRE [".( ( isset( $data['PAC_SEGUNDO_NOMBRE'] ) && !empty( $data['PAC_SEGUNDO_NOMBRE'] ) ) ? $data['PAC_SEGUNDO_NOMBRE'] : '' )."],\n";
                $info_tecnico.= "PAC_PRIMER_APELLIDO [".$data['PAC_PRIMER_APELLIDO']."],\n";
                $info_tecnico.= "PAC_SEGUNDO_APELLIDO [".( ( isset( $data['PAC_SEGUNDO_APELLIDO'] ) && !empty( $data['PAC_SEGUNDO_APELLIDO'] ) ) ? $data['PAC_SEGUNDO_APELLIDO'] : '' )."],\n";
                $info_tecnico.= "TCI_NOMBRE [".$identificador['IDT_NOMBRE']."],\n";
                $info_tecnico.= "TCI_VALOR [".$paciente_identificador['PAC_IDT_VALOR']."],\n";
                $info_tecnico.= "PAC_NACIMIENTO [". $this->util->fecha_orden( $data['PAC_NACIMIENTO'] ) ."],\n";
                $info_tecnico.= "PAC_SEXO [".$data['PAC_SEXO']."],\n";
                $info_tecnico.= "PAC_TELEFONO [".$data['PAC_TELEFONO']."],\n";
                $info_tecnico.= "PAC_EMAIL [".$data['PAC_EMAIL']."],\n";
                $info_tecnico.= "PAC_PROCEDENCIA [".$data['PAC_PROCEDENCIA']."],\n";
                $info_tecnico.= "PAC_OCUPACION [".$data['PAC_OCUPACION']."],\n";
                $info_tecnico.= "PAC_AFI_NOMBRE [".$afiliacion['AFI_NOMBRE']."],\n";
                $info_tecnico.= "AFI_ID [".$data[ 'AFI_ID' ]."],\n";
                $info_tecnico.= "TEL_PAC_EDAD [".$this->util->yearscalc( $data['PAC_NACIMIENTO'] )."]";
                if( $this->session->userdata('SIT_ID') == 21 ) {
                    $info_tecnico.= "\n";
                    $info_tecnico.= "PAC_NOMBRE_MADRE [". $data['PAC_NOMBRE_MADRE'] ."]\n";
                    $info_tecnico.= "PAC_APELLIDO_MADRE [". $data['PAC_APELLIDO_MADRE'] ."]\n";
                }

                $datos = array( );
                $datos['TEL_ID'] = $teleconsulta['TEL_ID'];
                $datos['EST_ID'] = $teleconsulta['EST_ID'];
                $datos['PRI_ID'] = $teleconsulta['PRI_ID'];
                $datos['USU_ID'] = $this->session->userdata('USU_ID');
                $datos['TEP_FECHA_HORA'] = date( 'Y-m-d H:i:s' );
                $datos['TEP_COMENTARIO'] = $comentario;
                $datos['TEP_INFO_TECNICO'] = $info_tecnico;

                $this->tc_estado_set( $datos );
            }

        return TRUE;
    }

    /**
    * Desactiva un paciente en especifico por el ID recibido por parametro,
    * esto solo si el paciente no tiene TC en el sistema.
    *
    * @access public
    * @param int $id ID del paciente
    * @return boolean TRUE si se elimino correctamente
    */
    public function paciente_desactivar($id)
    {
        if (!$this->existe_registro('TC_TELECONSULTA', 'PAC_ID', $id)) {
            $data['PAC_ID'] = $id;
            $this->db->delete('TC_PACIENTE', $data);
            $this->db->delete('TC_PACIENTE_IDENTIFICADOR', $data);
            return TRUE;
        } else {

            $this->db->where( 'PAC_ID', $id );
            $this->db->update('TC_PACIENTE', array( 'PAC_ACTIVO' => 0 ) );
            return TRUE;
        }
    }

    /**
     * Desvincula una teleconsulta de un paciente.
     *
     * @param $id_teleconsulta Id de la teleconsulta a desvincular el paciente
     */
    public function paciente_desvincular_teleconsulta( $id_teleconsulta = NULL ) {

        if( !empty( $id_teleconsulta ) ) {

            // Captura paciente
            $teleconsulta   = $this->tc_get($id_teleconsulta);
            $paciente       = $this->paciente_get( $teleconsulta['PAC_ID'] );
            $idt_paciente   = $this->paciente_identificadores_get( $teleconsulta['PAC_ID'] );

            if( !empty( $idt_paciente ) && count( $idt_paciente ) > 0 )
                $idt_paciente = element( 'PAC_IDT_VALOR', $idt_paciente[0] );
            else
                $idt_paciente = ' - ';


            // Desvincula teleconsulta
            $this->db->set( 'PAC_ID', null );
            $this->db->where( 'TEL_ID', $id_teleconsulta );
            $this->db->update( 'TC_TELECONSULTA' );

            // Agrega registro de modificación en TC_TELECONSULTA_ESTADO
            $datos = array( 'TEL_ID' => $id_teleconsulta,
                            'EST_ID' => $teleconsulta['EST_ID'],
                            'PRI_ID' => $teleconsulta['PRI_ID'],
                            'USU_ID' => $this->session->userdata( 'USU_ID' ),
                            'TEP_COMENTARIO' => sprintf( $this->lang->line('pacientes_se_desvincula'), $id_teleconsulta, $idt_paciente ). ': ' .
                                                $paciente['PAC_PRIMER_NOMBRE'].' ' . $paciente['PAC_PRIMER_APELLIDO'].'',
                            'TEP_INFO_TECNICO' => sprintf( $this->lang->line('pacientes_se_desvincula'), $id_teleconsulta, $idt_paciente ). ': ' .
                                                "PAC_ID[".$paciente['PAC_ID'].']'.PHP_EOL.
                                                "PAC_PRIMER_NOMBRE[".$paciente['PAC_PRIMER_NOMBRE'].']'.PHP_EOL.
                                                "PAC_SEGUNDO_NOMBRE[".$paciente['PAC_SEGUNDO_NOMBRE'].']'.PHP_EOL.
                                                "PAC_PRIMER_APELLIDO[".$paciente['PAC_PRIMER_APELLIDO'].']'.PHP_EOL.
                                                "PAC_SEGUNDO_APELLIDO[".$paciente['PAC_SEGUNDO_APELLIDO'].']'.PHP_EOL.
                                                "PAC_NACIMIENTO[".$paciente['PAC_NACIMIENTO'].']'.PHP_EOL.
                                                "PAC_SEXO[".$paciente['PAC_SEXO'].']'.PHP_EOL.
                                                "PAC_PROCEDENCIA[".$paciente['PAC_PROCEDENCIA'].']'.PHP_EOL.
                                                "PAC_OCUPACION[".$paciente['PAC_OCUPACION'].']'.PHP_EOL.
                                                "PAC_ACTIVO[".$paciente['PAC_ACTIVO'].']' );
            $this->tc_estado_set( $datos );
        }
    }

    /**
     * Busca en servidores de PIT examenes anteriores que el paciente pueda tener
     * @param int $idt_paciente
     */
    public function paciente_examenes_anteriores( $idt_paciente ) {

        if( (bool)$this->config->item('ws_activo', 'platc') ) {
            //
            try {

                $wsdl       = $this->config->item('ws_url_pit', 'platc');
                $tpoId      = $this->config->item('ws_id_site', 'platc');
                $idSite     = $this->config->item('ws_id_pais', 'platc');

                @$soap = new SoapClient( $wsdl );
                $resultado = $soap->getExamenes( array( 'idPaciente'  => (string)$idt_paciente,
                                                        'tpoId'       => (string)$tpoId,
                                                        'idSite'      => (string)$idSite ) );

                $examenes = json_decode( $resultado->return, TRUE );

                $listado_examenes = array( );
                foreach( $examenes as $e ) {
                    list( $w_cliente, $x_cliente, $y_cliente, $z_cliente ) = explode( '.', $this->util->obtenerIPCliente() );
                    list( $w_server, $x_server, $y_server, $z_server ) = explode( '.', $this->config->item( 'ws_ip_pit', 'platc' ) );

                    if( $w_cliente == $w_server && $x_cliente == $x_server && $y_cliente == $y_server) {
                        $url = parse_url( $e['url'] );
                        $scheme     = !empty( $url['scheme'] ) ? $url['scheme'] : 'http';
                        //$host       = $this->config->item( 'ws_ip_ris', 'platc' );
						$host       = (isset($url['host']) && $url['host']) ? $url['host'] : ""; //SI516
                        $port       = !empty( $url['port'] )   ? $url['port'] : '80';
                        $path       = !empty( $url['path'] )   ? $url['path'] : 'index.php';
                        $query      = !empty( $url['query'] )   ? $url['query'] : '';
                        $fragment   = !empty( $url['fragment'] )   ? $url['fragment'] : '';

                        //$e['url'] = $scheme.'://'.$host.':'.$port.$path.'?'.$query.(!empty($fragment) ? '#'.$fragment : '' );
						$e['url'] = $scheme.'://'.$host.$path.'?'.$query.(!empty($fragment) ? '#'.$fragment : '' ); //SI516
                    }
                    $listado_examenes[ $e['tipo'] ][ $e['folio'] ] = $e['url'];
                }

                // Realiza orden inverso de examenes
                foreach( $listado_examenes as $tipo => $e )
                    krsort( $listado_examenes[ $tipo ] );

                return $listado_examenes;
            } catch( SoapFault $e ) {

                log_message( "error", "No se pudo obtener información desde web service: ". $e->getMessage() );
                return array( 'error' => array( $this->lang->line('error') => $this->lang->line('tc_error_obtener_examenes_anteriores_pit') ) );
            }
        } else
            return array();
    }
    /**
     * Busca en servidores de RIS examenes anteriores que el paciente pueda tener
     * @param int $idt_paciente
     */
    public function paciente_examenes_anteriores_ris( $idt_paciente ) {

        if( (bool)$this->config->item('ws_activo', 'platc') ) {
            //
            try {

                $wsdl       = $this->config->item('ws_url_ris', 'platc');
                $tpoId      = $this->config->item('ws_id_site', 'platc');
                $idSite     = $this->config->item('ws_id_pais', 'platc');

                @$soap = new SoapClient( $wsdl );
log_message( "error", "antes de llamar al metodo soap.>getExamenesRis >".method_exists( $soap, "getExamenesRis" ) );
                $resultado = $soap->getExamenesRis( array(  'idPaciente'  => (string)$idt_paciente,
                                                            'tpoId'       => (string)$tpoId,
                                                            'idSite'      => (string)$idSite ) );
log_message( "error", "resultado->return: ".$resultado->return );
                $examenes = json_decode( $resultado->return, TRUE );

                $listado_examenes = array( );
                foreach( $examenes as $e ) {
//log_message( "error", "" );
                    list( $w_cliente, $x_cliente, $y_cliente, $z_cliente ) = explode( '.', $this->util->obtenerIPCliente() );
                    list( $w_server, $x_server, $y_server, $z_server ) = explode( '.', $this->config->item( 'ws_ip_ris', 'platc' ) );
                    if( $w_cliente == $w_server && $x_cliente == $x_server && $y_cliente == $y_server) {
                        $url = parse_url( $e['url'] );

                        $scheme     = !empty( $url['scheme'] ) ? $url['scheme'] : 'http';
                        $host       = $this->config->item( 'ws_ip_pit', 'platc' );
                        $port       = !empty( $url['port'] )   ? $url['port'] : '80';
                        $path       = !empty( $url['path'] )   ? $url['path'] : 'index.php';
                        $query      = !empty( $url['query'] )   ? $url['query'] : '';
                        $fragment   = !empty( $url['fragment'] )   ? $url['fragment'] : '';

                        $e['url'] = $scheme.'://'.$host.':'.$port.$path.'?'.$query.(!empty($fragment) ? '#'.$fragment : '' );
                    }

                    $listado_examenes[ $e['folio'] ] = array( 'url' => $e['url'], 'tipo' => $e['tipo'] );
                }

                // Realiza orden inverso de examenes
                foreach( $listado_examenes as $tipo => $e )
                    krsort( $listado_examenes[ $tipo ] );

                return $listado_examenes;
            } catch( SoapFault $e ) {

                log_message( "error", "No se pudo obtener información desde web service: ". $e->getMessage() );
                return array( 'error' => array( $this->lang->line('error') => $this->lang->line('tc_error_obtener_examenes_anteriores_pit') ) );
            }
        } else
            return array();
    }

    /**
     * Retorna listado de  Teleconsultas sin pacientes asociadas
     *
     * @return array Listado de teleconsultas sin pacientes asociados
     */
    public function tc_desvinculadas( ) {

        $sql = 'SELECT  *
                FROM    TC_TELECONSULTA AS t
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                        INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                WHERE   t.SIT_ID = ' . $this->session->userdata('SIT_ID'). '
                        AND PAC_ID is null
                ORDER BY TEL_ID DESC ';

        $query = $this->db->query( $sql );

        return $query->result_array();
    }

    /**
     * Vincula una teleconsulta a un paciente.
     *
     * @param $id_teleconsulta Id de la teleconsulta a vincular
     * @param $id_paciente     Id del paciente a vincular
     */
    public function paciente_vincular_teleconsulta( $id_teleconsulta = NULL, $id_paciente = NULL ) {

        if( !empty( $id_teleconsulta ) && !empty( $id_paciente ) ) {

            // Captura paciente
            $teleconsulta   = $this->tc_get($id_teleconsulta);
            $paciente       = $this->paciente_get( $id_paciente );

            // Vincula teleconsulta
            $this->db->set( 'PAC_ID', $id_paciente );
            $this->db->set( 'TEL_PAC_PRIMER_NOMBRE', $paciente['PAC_PRIMER_NOMBRE'] );
            $this->db->set( 'TEL_PAC_SEGUNDO_NOMBRE', $paciente['PAC_SEGUNDO_NOMBRE'] );
            $this->db->set( 'TEL_PAC_PRIMER_APELLIDO', $paciente['PAC_PRIMER_APELLIDO'] );
            $this->db->set( 'TEL_PAC_SEGUNDO_APELLIDO', $paciente['PAC_SEGUNDO_APELLIDO'] );
            $this->db->set( 'TEL_PAC_NACIMIENTO', $paciente['PAC_NACIMIENTO'] );
            $this->db->set( 'TEL_PAC_EDAD', $this->util->yearscalc( $paciente['PAC_NACIMIENTO'] ) );
            $this->db->set( 'TEL_PAC_SEXO', $paciente['PAC_SEXO'] );
            $this->db->set( 'TEL_PAC_PROCEDENCIA', $paciente['PAC_PROCEDENCIA'] );
            $this->db->set( 'TEL_PAC_OCUPACION', $paciente['PAC_OCUPACION'] );
            $this->db->set( 'AFI_ID', $paciente['AFI_ID'] );
            $this->db->set( 'TEL_PAC_AFI_NOMBRE', $paciente['AFI_NOMBRE'] );
            $this->db->where( 'TEL_ID', $id_teleconsulta );
            $this->db->update( 'TC_TELECONSULTA' );

            // Agrega registro de modificación en TC_TELECONSULTA_ESTADO
            $datos = array( 'TEL_ID' => $id_teleconsulta,
                            'EST_ID' => $teleconsulta['EST_ID'],
                            'PRI_ID' => $teleconsulta['PRI_ID'],
                            'TEP_COMENTARIO' => "Se vincula teleconsulta [ID: ".$id_teleconsulta." ] al paciente [PAC_ID: ".$id_paciente."]: ".PHP_EOL.
                                                "PAC_PRIMER_NOMBRE[".$paciente['PAC_PRIMER_NOMBRE'].']'.PHP_EOL.
                                                "PAC_SEGUNDO_NOMBRE[".$paciente['PAC_SEGUNDO_NOMBRE'].']'.PHP_EOL.
                                                "PAC_PRIMER_APELLIDO[".$paciente['PAC_PRIMER_APELLIDO'].']'.PHP_EOL.
                                                "PAC_SEGUNDO_APELLIDO[".$paciente['PAC_SEGUNDO_APELLIDO'].']'.PHP_EOL.
                                                "PAC_NACIMIENTO[".$paciente['PAC_NACIMIENTO'].']'.PHP_EOL.
                                                "PAC_SEXO[".$paciente['PAC_SEXO'].']'.PHP_EOL.
                                                "PAC_PROCEDENCIA[".$paciente['PAC_PROCEDENCIA'].']'.PHP_EOL.
                                                "PAC_OCUPACION[".$paciente['PAC_OCUPACION'].']'.PHP_EOL.
                                                "AFI_ID[".$paciente['AFI_ID'].']'.PHP_EOL.
                                                "AFI_NOMBRE[".$paciente['AFI_NOMBRE'].']'.PHP_EOL.
                                                "PAC_ACTIVO[".$paciente['PAC_ACTIVO'].']' );
            $this->tc_estado_set( $datos );
        }
    }

    /**
    * Obtiene las afiliaciones del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos las afiliaciones
    */
    public function afiliaciones_get()
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_AFILIACION ";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene las afiliaciones del sistema con el site
    * al que pertenece para poder ser listados.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos las afiliaciones
    */
    public function afiliaciones_lista_get( $id_site = NULL )
    {
        $sql = "SELECT a.AFI_ID, a.AFI_NOMBRE, a.AFI_DESCRIPCION, s.SIT_NOMBRE ";
        $sql .= "FROM TC_AFILIACION AS a, TC_SITE as s ";
        $sql .= "WHERE s.SIT_ID = a.SIT_ID";

        if( !empty( $id_site ) )
            $sql.=" AND a.SIT_ID = ". $id_site;

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza una afiliacion en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function afiliacion_upd($data)
    {
        $idi_site = $this->afiliacion_get($data['AFI_ID']);
        if (!$this->existe_registro('TC_AFILIACION', 'AFI_NOMBRE', $data['AFI_NOMBRE'], 'AFI_ID', $data['AFI_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
            $this->db->where('AFI_ID', $data['AFI_ID']);
            $this->db->update('TC_AFILIACION', $data);
            return TRUE;
        }
    }

    /**
    * Inserta una nueva afiliacion en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function afiliacion_set($data)
    {
        if (!$this->existe_registro('TC_AFILIACION', 'AFI_NOMBRE', $data['AFI_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
            $this->db->insert('TC_AFILIACION', $data);
            return TRUE;
        }
    }

    /**
    * Elimina una afiliacion por el ID recibido por parametro,
    * esto solo si la afiliacion no esta asignada a aglun paciente.
    *
    * @access public
    * @param int $id ID de la afiliacion
    * @return boolean TRUE si se elimino correctamente
    */
    public function afiliacion_del($id)
    {
        if (!$this->existe_registro('TC_PACIENTE', 'AFI_ID', $id)) {
            $data['AFI_ID'] = $id;
            $this->db->delete('TC_AFILIACION', $data);
            return TRUE;
        }
    }

    /**
    * Obtiene una afiliacion en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID de la afiliacion
    * @return array Arreglo con los datos de la afiliacion
    */
    public function afiliacion_get($id)
    {
        $sql = "SELECT a.AFI_ID, a.AFI_NOMBRE, a.AFI_DESCRIPCION, a.SIT_ID, a.AFI_ACTIVO,s.SIT_NOMBRE ";
        $sql .= "FROM TC_AFILIACION AS a, TC_SITE AS s ";
        $sql .= "WHERE a.AFI_ID = '".$id."' ";
        $sql .= "AND s.SIT_ID = a.SIT_ID";
        $query = $this->db->query($sql);
        if ( $query->num_rows() > 0 ) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
     * Retorna listado de especialidades asociados a un cliente en particular
     * Necesario para usuarios del tipo <b>Generalista</b> que tienen relación
     * directa con los clientes a los que atiende (según lógica de negocios)
     * El parámetro $genero filtra especialidades que competen a un género (hombre, mujer)
     * en particular
     *
     * @param int $id_cliente Identificador del cliente
     * @param string $genero Debe recibir: 'M' o 'F', null indica que es para ambos géneros.
     * @return array listado de especialidades del cliente pasado por parámetro
     */
    public function especialidades_por_cliente( $id_cliente, $genero = NULL ) {

        $sql = "SELECT e.* ";
        $sql .= "FROM TC_ESPECIALIDAD e
                        INNER JOIN TC_CLIENTE_ESPECIALIDAD ce ON ( ce.ESP_ID = e.ESP_ID ) ";

        if ( $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE'] ){

            $sql .= "       WHERE e.ESP_ID <> '1' ";
            $sql .= "       AND e.ESP_ACTIVO = 1 ";

        } else {
            
            $sql .= " WHERE ce.CLI_ID = '".$id_cliente."' ";
            $sql .= "       AND e.ESP_ID <> '1' ";
            $sql .= "       AND e.ESP_ACTIVO = 1 ";
        }


        if( !empty( $genero ) )
            $sql.= " AND ( e.ESP_GENERO = '". $genero . "' OR e.ESP_GENERO is null ) ";

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

        public function medicos_generalistas_por_cliente( $id_cliente, $genero = NULL ) {

        $sql = "SELECT e.* ";
        $sql .= "FROM TC_ESPECIALIDAD e
                        INNER JOIN TC_CLIENTE_ESPECIALIDAD ce ON ( ce.ESP_ID = e.ESP_ID ) ";
        $sql .= " WHERE ce.CLI_ID = '".$id_cliente."' ";
        $sql .= "       AND e.ESP_ID <> '1' ";
        $sql .= "       AND e.ESP_ACTIVO = 1 ";

        if( !empty( $genero ) )
            $sql.= " AND ( e.ESP_GENERO = '". $genero . "' OR e.ESP_GENERO is null ) ";

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
     * Retorna listado de especialidades de todos los clientes asociados
     * a un grupo según un usuario en particular.<br/>
     * Necesarios para usuarios del tipo <b>Supervisor</b> y <b>Especialistas</b> que tienen
     * relaciones con estas tablas (según lógica de negocios)
     *
     * @param int $id_usuario ID del usuario <b>Supervisor</b> o <b>Especialista</b>
     */
    public function especialidades_por_usuario_grupo( $id_usuario ) {

        $sql = "SELECT DISTINCT e.* ";
        $sql .= "FROM TC_ESPECIALIDAD e
                        INNER JOIN ( TC_CLIENTE_ESPECIALIDAD ce
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN ( TC_GRUPO_CLIENTE gc
                                    INNER JOIN ( TC_GRUPO g
                                        INNER JOIN TC_GRUPO_USUARIO gu ON ( gu.GRU_ID = g.GRU_ID )
                                    ) ON ( g.GRU_ID = gc.GRU_ID )
                                ) ON ( gc.CLI_ID = c.CLI_ID )
                            ) ON ( ce.CLI_ID = c.CLI_ID )
                        ) ON ( ce.ESP_ID = e.ESP_ID ) ";
        $sql .= " WHERE gu.USU_ID = '".$id_usuario."' ";

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene todas especialidades de un site en especifico
    * recibiendo el ID del site por parametro
    *
    * @access public
    * @param int $id ID del site
    * @return array Arreglo con las especialidades encontradas
    */
     public function especialidades_site_get($id)
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_ESPECIALIDAD ";
        $sql .= "WHERE SIT_ID = '".$id."' ";
        $sql .= "AND ESP_ID <> '1' AND ESP_ACTIVO = 1";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene las especialidades del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos las especialidades
    */
    public function especialidades_get()
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_ESPECIALIDAD";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene una especialidad en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID de la especialidad
    * @return array Arreglo con los datos de la afiliacion
    */
    public function especialidad_get($id)
    {
        $sql = "SELECT e.ESP_ID, e.ESP_NOMBRE, e.ESP_DESCRIPCION, e.SIT_ID, s.SIT_NOMBRE, e.ESP_ARCHIVO_FORMULARIO, e.ESP_GENERO ";
        $sql .= "FROM TC_ESPECIALIDAD AS e, TC_SITE AS s ";
        $sql .= "WHERE e.ESP_ID = ".$id." ";
        $sql .= "AND s.SIT_ID = e.SIT_ID ";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene las especialidades del sistema con su site
    * al que pertene para poder ser listados.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos las especialidades
    */
    public function especialidades_lista_get( $id_site = NULL )
    {
        $sql = "SELECT e.ESP_ID, e.ESP_NOMBRE, e.ESP_DESCRIPCION, s.SIT_NOMBRE ";
        $sql .= "FROM TC_ESPECIALIDAD AS e, TC_SITE as s ";
        $sql .= "WHERE s.SIT_ID = e.SIT_ID AND e.ESP_ACTIVO = 1";

        if( !empty( $id_site ) )
            $sql.= " AND e.SIT_ID = " . $id_site ;
// imprimir($sql);
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza una especialidad en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function especialidad_upd($data)
    {
        if (!$this->existe_registro('TC_ESPECIALIDAD', 'ESP_NOMBRE', $data['ESP_NOMBRE'], 'ESP_ID', $data['ESP_ID'], 'SIT_ID', $data['SIT_ID'])) {
            $this->db->where('ESP_ID', $data['ESP_ID']);
            $this->db->update('TC_ESPECIALIDAD', $data);
            return TRUE;
        }
    }

    /**
    * Inserta una nueva especialidad en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function especialidad_set($data)
    {
        if (!$this->existe_registro('TC_ESPECIALIDAD', 'ESP_NOMBRE', $data['ESP_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
            $this->db->insert('TC_ESPECIALIDAD', $data);
            return TRUE;
        }
    }

    /**
    * Elimina una especialidad por el ID recibido por parametro,
    * esto solo si la especialidad no esta asignada a aglun especialista.
    *
    * @access public
    * @param int $id ID de la especialidad
    * @return boolean TRUE si se elimino correctamente
    */
    public function especialidad_del($id)
    {
        if (!$this->existe_registro('TC_USUARIO_ESPECIALIDAD', 'ESP_ID', $id)) {
            $data['ESP_ID'] = $id;
            $this->db->delete('TC_ESPECIALIDAD', $data);
            return TRUE;
        }
    }

    /**
    * Obtiene los identificadores del sistema.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los identificadores
    */
    public function identificadores_get()
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_IDENTIFICADOR";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene un identificador en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del identificador
    * @return array Arreglo con los datos del identificador
    */
    public function identificador_get($id = '')
    {
		if($id){
			$sql = "SELECT i.IDT_ID, i.IDT_NOMBRE, i.IDT_DESCRIPCION, i.TIPO_IDENTIFICACION, i.SIT_ID, s.SIT_NOMBRE ";
			$sql .= "FROM TC_IDENTIFICADOR AS i, TC_SITE AS s ";
			$sql .= "WHERE i.IDT_ID = ".$id." ";
			$sql .= "AND s.SIT_ID = i.SIT_ID";
			$query = $this->db->query($sql);
			 if ($query->num_rows() > 0) {
				$row = $query->result_array();
				return $row[0];
			}
			else{
				return NULL;
			}
		}
		else{
			return NULL;
		}
    }

    /**
    * Obtiene los identificadores del sistema con su site
    * al que pertene para poder ser listados.
    *
    * @access public
    * @param none
    * @return array Arreglo con todos los identificadores
    */
    public function identificadores_lista_get( $id_site = NULL )
    {
        $sql = "SELECT i.IDT_ID, i.IDT_NOMBRE, i.IDT_DESCRIPCION, s.SIT_NOMBRE ";
        $sql .= "FROM TC_IDENTIFICADOR AS i, TC_SITE AS s ";
        $sql .= "WHERE s.SIT_ID = i.SIT_ID ";

        if( !empty( $id_site ) )
            $sql.= " AND i.SIT_ID = ". $id_site;

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Actualiza un identificador en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function identificador_upd($data)
    {
        $idi_site = $this->identificador_get($data['IDT_ID']);
        if (!$this->existe_registro('TC_IDENTIFICADOR', 'IDT_NOMBRE', $data['IDT_NOMBRE'], 'IDT_ID', $data['IDT_ID'], 'SIT_ID', $idi_site['SIT_ID'])) {
            $this->db->where('IDT_ID', $data['IDT_ID']);
            $this->db->update('TC_IDENTIFICADOR', $data);
            return TRUE;
        }
    }

    /**
    * Inserta un nuevo identificador en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function identificador_set($data)
    {

        if (!$this->existe_registro('TC_IDENTIFICADOR', 'IDT_NOMBRE', $data['IDT_NOMBRE'], NULL, NULL, 'SIT_ID', $data['SIT_ID'])) {
            $this->db->insert('TC_IDENTIFICADOR', $data);
            return TRUE;
        }
    }

    /**
    * Elimina un identificador por el ID recibido por parametro,
    * esto solo si el identificador no esta asignada a aglun paciente.
    *
    * @access public
    * @param int $id ID del identificador
    * @return boolean TRUE si se elimino correctamente
    */
    public function identificador_del($id)
    {
        if (!$this->existe_registro('TC_PACIENTE_IDENTIFICADOR', 'IDT_ID', $id)) {
            $data['IDT_ID'] = $id;
            $this->db->delete('TC_IDENTIFICADOR', $data);
            return TRUE;
        }
    }

    /**
    * Inserta una nueva TC en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return boolean TRUE si se inserto correctamente
    */
    public function tc_set($data)
    {
        $this->db->insert('TC_TELECONSULTA', $data);
        $id = $this->db->insert_id();
        $ident = $this->paciente_identificadores_get($data['PAC_ID']);
        foreach ($ident as $i) {
            $newdata['TEL_ID'] = $id;
            $newdata['TCI_NOMBRE'] = $i['IDT_NOMBRE'];
            $newdata['TCI_VALOR'] = $i['PAC_IDT_VALOR'];
            $this->db->insert('TC_TELPAC_IDENTIFICADOR', $newdata);
        }
        return $id;
    }

    /**
    * Metodo que arma parte de un sql query que busca las TC por
    * especialidades de un usuario rol3 especialista.
    *
    * @access private
    * @param none
    * @return string $sql con la SQL armada
    */
    private function sql_usu_especialdiades_tc( $id_usuario, $especialidad_activo = TRUE )
    {
        $sql = '';
        $usuario = $this->usuario_especialidades_get( $id_usuario, $especialidad_activo );
        $chk = FALSE;
        foreach ($usuario as $usu) {
            if ($chk == FALSE) {
                $sql .= "AND (t.ESP_ID = '".$usu['ESP_ID']."' ";
                $chk = TRUE;
            }
            else
                $sql .= "OR t.ESP_ID = '".$usu['ESP_ID']."' ";
        }
        $sql .= ") ";
        if ($chk == TRUE)
            return $sql;
        else
            return NULL;
    }

    public function tc_rechazar( $id_tc, $motivo_id, $motivo_comentario = null ) {

        $tc = $this->tc_get($id_tc);
        $data_estado['TEL_ID'] = $id_tc;
        $data_estado['PRI_ID'] = $tc['PRI_ID'];
        $data_estado['EST_ID'] = 3;

        $motivo = ( $motivo_id == 1 ) ? $motivo_comentario : element( 'MR_DESCRIPCION', $this->motivo_rechazo_get( $motivo_id ) );

        // 1: Genera cambio de estado en TC_TELECONSULTA_ESTADO
        $comentario   = sprintf( $this->lang->line('tc_rechazo_comentario'),
                                 (string)$this->session->userdata('USU_NOMBRE'), (int)$tc['TEL_ID'] );

        $info_tecnico = sprintf( $this->lang->line('tc_rechazo_info_tecnico'),
                                 (int)$this->session->userdata('USU_ID'),
                                 (string)$this->session->userdata('USU_NOMBRE'),
                                 (int)$tc['TEL_ID'],
                                 (int)$tc['EST_ID'], $motivo_id, $motivo );

        $data_estado['USU_ID'] = $this->session->userdata('USU_ID');
        $data_estado['TEP_COMENTARIO'] = $comentario;
        $data_estado['TEP_INFO_TECNICO'] = $info_tecnico;
        $tep_id = $this->tc_estado_set( $data_estado );

        // 2: Genera registro de comentario de rechazo en TC_TELECONSULTA_MOTIVO_RECHAZO
        $datos_rechazo = array( );
        $datos_rechazo['TEP_ID']         = $tep_id;
        $datos_rechazo['TMR_ID_RECHAZO'] = $motivo_id;
        if( !empty( $motivo_comentario ) ) $datos_rechazo['TMR_COMENTARIO'] = $motivo_comentario;
        $this->db->insert( 'TC_TELECONSULTA_MOTIVO_RECHAZO', $datos_rechazo );

        // 3: Actualiza TC
        $datos_tc['TEL_ID'] = $data_estado['TEL_ID'];
        $datos_tc['PRI_ID'] = $data_estado['PRI_ID'];
        $datos_tc['EST_ID'] = $data_estado['EST_ID'];
        $datos_tc['TEL_ESTADO_ANT'] = $tc['TEL_ESTADO_ANT'];
        $datos_tc['TEL_FECHA_HORA_RECHAZO'] = date('Y-m-d') . " " . date('H:i:s');
        if( $this->platc_model->tc_upd( $datos_tc ) )
            return true;
        else
            return false;
    }

    /**
    * Obtiene todas las TC de un paciente menos una en especifica
    * valores recibidos por parametro.
    *
    * @access public
    * @param int $pac_id ID del paciente
    * @param int $tc_id ID de la TC que no se requiere datos
    * @param int $estados_a_descartar ID de los estados que no estarán en el listado
    * @return array Arreglo con todas las TC del paciente menos la que no se requiere
    */
    public function tc_paciente_get($pac_id, $tc_id = null, $estados_a_descartar = array( 1, 3, 4) )
    {
        $sql = "SELECT  DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO,
                        date_format( t.TEL_FECHA_HORA, '%d/%m/%Y %H:%m' ) as TEL_FECHA_HORA, t.EST_ID, t.PRI_ID,
                        t.TEL_MOTIVO ,
                        e.ETB_NOMBRE, e.ETB_NIVEL, es.ESP_NOMBRE ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] || $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE'] ) { // NF432

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
        $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
        $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        // Visualiza TC's que pertenencen al paciente $pac_id
        $sql .= "AND t.PAC_ID = ".$pac_id." ";

        // Descarta la TC que se está visualizando
        if( !empty( $tc_id ) )
            $sql .= "AND t.TEL_ID <> ".$tc_id." ";

        // Descarta estados 1: Borrador, 3: Rechazados, 4: Eliminados
        if( !empty( $estados_a_descartar ) )
            foreach( $estados_a_descartar as $estado )
                $sql .= "AND t.EST_ID <> " . (int)$estado. " ";

        $sql .= "ORDER BY t.TEL_ID DESC ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene las TC segun estado.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
    * @access public
    * @param int $estado Estado de la TC
    * @param int $tc_abierta Bandera para buscar solo TC que no han sido abiertas(distinto a revisadas) en el estado en que se encuentra
    * @param string $order Ordena por TEL_ID: 'ASC'=ascendente, 'DESC'=descentente, ''=sin orden
    * @return array Arreglo con la TC encontradas
    */
    public function tc_lista_get($estado = '', $order = '', $limite = null, $vistas = false )
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( t.TEL_FECHA_HORA_ENVIO ) end as TEL_FECHA_HORA
                        , t.EST_ID, t.TEL_LOCK_USED, lck.USU_NOMBRE as TEL_LOCK_OWNER_NOMBRE, t.PRI_ID,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE
                        , case when t.EST_ID = 7 then DATEDIFF( DATE_ADD( TEL_FECHA_HORA_RESPUESTA, INTERVAL 10 MINUTE ), TEL_FECHA_HORA_ENVIO )
                                when t.EST_ID = 1 then DATEDIFF( DATE_ADD( NOW(), INTERVAL 10 MINUTE ), TEL_FECHA_HORA )
                        else DATEDIFF( DATE_ADD( NOW(), INTERVAL 10 MINUTE ), t.TEL_FECHA_HORA_ENVIO ) end as TEL_ATRASO, TEL_VISTO_POR_GENERALISTA, TEL_VISTO_POR_ESPECIALISTA ";

        /*
         * Administrador observa TC revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN']  ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /*
         * Filtra por revisada solo para especialista: Bandeja del especialista solo ve las revisadas
         * Supervisor observa las revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA']) {

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $sql .= "FROM   TC_TELECONSULTA AS t
                                INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                                INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                                INNER JOIN ( TC_BOLSA_TELECONSULTA bt
                                            INNER JOIN ( TC_BOLSA_USUARIO bu ) ON ( bu.BOL_ID = bt.BOL_ID AND bu.USU_ID = ".(int)$this->session->userdata('USU_ID')." )
                                            INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID )
                                ) ON ( bt.TEL_ID = t.TEL_ID )
                                LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID )
                        WHERE   b.BOL_ACTIVO = 1 AND b.BOL_ELIMINADO = 0
                                AND t.TEL_REVISADA = 1";

                // Especialista solo puede ver TC revisadas y las de su especialidad
                if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                    $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
                }
            } else {
                $sql .= "FROM   TC_TELECONSULTA AS t";
                $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
                $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                                INNER JOIN ( TC_CLIENTE c
                                                                INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                                INNER JOIN ( TC_GRUPO g
                                                                                                INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                                ) ON ( g.GRU_ID = gc.GRU_ID )
                                                                ) ON ( gc.CLI_ID = c.CLI_ID )
                                                ) ON ( c.CLI_ID = e.CLI_ID )
                                ) ON ( t.ETB_ID = e.ETB_ID ) ";
                $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
                $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID') ;

                // Especialista solo puede ver TC revisadas y las de su especialidad
                if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                    $sql .= "   AND t.TEL_REVISADA = 1";
                    $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
                }
            }
        }

        /* No filtra por revisada:
         * Enviadas/nuevas  = muestra sus propios envios (revisados o no)
         * Solicitud examen = muestra los solicitados tanto del revisor como del especialista
         * Respuesta solicitud = muestra sus propias respuestas (revisadas o no)
         * Respuesta final  = muestra las respuestas finales del especialista
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
        }

        /* Filtra por revisada:
         * (2) Enviadas/nuevas  = muestra tc nuevas sin revisar (tel_revisada=0)
         * (5) Solicitud examen = muestra tc al que se han solicitado examenes (sin revisar tel_revisada=0)
         * (6) Respuesta solicitud = muestra respuestas de la solicitud (solo no revisadas)
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');

            if( $estado == 2 || $estado == 5 || $estado == 6 )
                $sql .= " AND t.TEL_REVISADA = 0 ";
        }


        /**/
        /* NF432 */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            // $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');

            if( $estado == 2 )
                $sql .= " WHERE t.TEL_REVISADA = 0 ";
        }
        /**/
        /**/



        // Establece el estado
        $sql .= " AND t.EST_ID = ".$estado." ";

        // Para respondidas solo se muestran las TC de los últimos 2 meses
        // si el usuario necesita más TC's debe usar el buscador.
		if($this->session->userdata('SIT_ID') == 2){
			if( (int)$estado == 7 &&
				( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
				  $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] || $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) )
				$sql.= " AND t.TEL_FECHA_HORA_RESPUESTA BETWEEN ( DATE_SUB( DATE_ADD( NOW(), INTERVAL 10 MINUTE ), INTERVAL 2 MONTH ) ) AND NOW()";
		}
		else{
			if( (int)$estado == 7 &&
				( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
				  $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) )
				$sql.= " AND t.TEL_FECHA_HORA_RESPUESTA BETWEEN ( DATE_SUB( DATE_ADD( NOW(), INTERVAL 10 MINUTE ), INTERVAL 2 MONTH ) ) AND NOW()";
		}
			
        // Para respondidas solo se muestran las TC que han sido vistas
        if( (bool)$vistas )
            $sql.= " AND t.TEL_ABIERTA = 1 ";

        if ($order != '')
            $sql .= " GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC, t.TEL_ID ".$order." ";
        else
            $sql .= " GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";

        if( !empty( $limite ) )
            $sql .= " LIMIT ".(int) $limite;
//imprimir( $sql );
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0){
            return $query->result_array();
        } else
            return NULL;
    }

    /**
    * Busca una TC segun el ID de esta.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
    * @access public
    * @param int $id ID de la TC
    * @param int $estado Estado de la TC
    * @return array Arreglo con la TC encontradas
    */
    public function tc_busca_tcid($id, $estado)
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA
                        , case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( te.TEP_FECHA_HORA ) end as TEL_FECHA_HORA
                        , t.EST_ID, t.TEL_LOCK_USED, lck.USU_NOMBRE as TEL_LOCK_OWNER_NOMBRE, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE ";

        /*
         * Administrador observa TC revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /*
         * Filtra por revisada solo para especialista: Bandeja del especialista solo ve las revisadas
         * Supervisor observa las revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
            if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                $sql .= "   AND t.TEL_REVISADA = 1";
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
            }
        }

        /* No filtra por revisada:
         * Enviadas/nuevas  = muestra sus propios envios (revisados o no)
         * Solicitud examen = muestra los solicitados tanto del revisor como del especialista
         * Respuesta solicitud = muestra sus propias respuestas (revisadas o no)
         * Respuesta final  = muestra las respuestas finales del especialista
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }



        // NF432 
        if ( $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE']  ){

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 1 ) ";
            $sql .= "   WHERE t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

        }




        /* Filtra por revisada:
         * (2) Enviadas/nuevas  = muestra tc nuevas sin revisar (tel_revisada=0)
         * (5) Solicitud examen = muestra tc al que se han solicitado examenes (sin revisar tel_revisada=0)
         * (6) Respuesta solicitud = muestra respuestas de la solicitud (solo no revisadas)
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $estado == 2 || $estado == 5 || $estado == 6 )
                $sql .= " AND t.TEL_REVISADA = 0 ";
        }

        // Establece el estado
        $sql .= "AND t.EST_ID = ".$estado." ";
        $sql .= "AND t.TEL_ID = ".$id." ";

        $sql .= "GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {

            // Calcula días de atraso desde el último cambio de estado de la TC
            // USA FUNCIONES DE PHP >5.3
            $listado = array( );
            foreach( $query->result_array() as $tc ) {
                $f = explode( ' ', $tc['TEL_FECHA_HORA'] );

                // Para el listado de TC Contestadas (estado: 7) se lista la cantidad de días desde que fue enviada/nueva hasta que alcanza el estado respondida
                // para otros casos usa la fecha actual.
                if( $estado == 7 ) {

                    $asdf = $this->tc_estado_get( $tc['TEL_ID'], 7 );
                    $t = explode( ' ', $asdf['TEP_FECHA_HORA'] );
                    //$tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a');
					$tc['TEL_ATRASO'] = ($f[0] && date_create($f[0]) && $t[0] && date_create($t[0])) ? date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a') : "";
                } else
                    $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create( null ) )->format('%a');

                $listado[] = $tc;
            }

            return $listado;
        } else
            return NULL;
    }

    /**
    * Busca las TC de un paciente segun el identificador de este.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
    * @access public
    * @param string $id Identificador del paciente a buscar TC
    * @param int $estado Estado de la TC
    * @return array Arreglo con todas las TC encontradas
    */
    public function tc_busca_id($id, $estado)
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO
                        , case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( te.TEP_FECHA_HORA ) end as TEL_FECHA_HORA
                        , t.EST_ID, t.TEL_LOCK_USED, lck.USU_NOMBRE as TEL_LOCK_OWNER_NOMBRE, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE ";

        /*
         * Administrador observa TC revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /*
         * Filtra por revisada solo para especialista: Bandeja del especialista solo ve las revisadas
         * Supervisor observa las revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                $sql .= "   AND t.TEL_REVISADA = 1";
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
            }
        }

        /* No filtra por revisada:
         * Enviadas/nuevas  = muestra sus propios envios (revisados o no)
         * Solicitud examen = muestra los solicitados tanto del revisor como del especialista
         * Respuesta solicitud = muestra sus propias respuestas (revisadas o no)
         * Respuesta final  = muestra las respuestas finales del especialista
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /* Filtra por revisada:
         * (2) Enviadas/nuevas  = muestra tc nuevas sin revisar (tel_revisada=0)
         * (5) Solicitud examen = muestra tc al que se han solicitado examenes (sin revisar tel_revisada=0)
         * (6) Respuesta solicitud = muestra respuestas de la solicitud (solo no revisadas)
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $estado == 2 || $estado == 5 || $estado == 6 )
                $sql .= " AND t.TEL_REVISADA = 0 ";
        }

        $sql .= "AND ti.TCI_VALOR = '".$id."' ";
        $sql .= "AND t.EST_ID = ".$estado." ";

        $sql .= "GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";


        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {

            // Calcula días de atraso desde el último cambio de estado de la TC
            // USA FUNCIONES DE PHP >5.3
            $listado = array( );
            foreach( $query->result_array() as $tc ) {
                $f = explode( ' ', $tc['TEL_FECHA_HORA'] );

                // Para el listado de TC Contestadas (estado: 7) se lista la cantidad de días desde que fue enviada/nueva hasta que alcanza el estado respondida
                // para otros casos usa la fecha actual.
                if( $estado == 7 ) {

                    $asdf = $this->tc_estado_get( $tc['TEL_ID'], 7 );
                    $t = explode( ' ', $asdf['TEP_FECHA_HORA'] );
                    $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a');
                } else
                    $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create( null ) )->format('%a');

                $listado[] = $tc;
            }

            return $listado;
        } else
            return NULL;
    }

    /**
    * Busca las TC de un paciente segun su nombre y/o apellido y el
    * estado en que se encuentra.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
    * @access public
    * @param string $nombre Nombre del paciente a buscar TC
    * @param string $apellido Apellido del paciente a buscar TC
    * @param int $estado Estado de la TC
    * @return array Arreglo con todas las TC encontradas
    */
    public function tc_busca_na( $estado, $nombre = '', $apellido = '' )
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO
                        , case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( te.TEP_FECHA_HORA ) end as TEL_FECHA_HORA
                        , t.EST_ID, t.TEL_LOCK_USED, lck.USU_NOMBRE as TEL_LOCK_OWNER_NOMBRE, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE ";

        /*
         * Administrador observa TC revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /*
         * Filtra por revisada solo para especialista: Bandeja del especialista solo ve las revisadas
         * Supervisor observa las revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                $sql .= "   AND t.TEL_REVISADA = 1";
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
            }
        }

        /* No filtra por revisada:
         * Enviadas/nuevas  = muestra sus propios envios (revisados o no)
         * Solicitud examen = muestra los solicitados tanto del revisor como del especialista
         * Respuesta solicitud = muestra sus propias respuestas (revisadas o no)
         * Respuesta final  = muestra las respuestas finales del especialista
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /* Filtra por revisada:
         * (2) Enviadas/nuevas  = muestra tc nuevas sin revisar (tel_revisada=0)
         * (5) Solicitud examen = muestra tc al que se han solicitado examenes (sin revisar tel_revisada=0)
         * (6) Respuesta solicitud = muestra respuestas de la solicitud (solo no revisadas)
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $estado == 2 || $estado == 5 || $estado == 6 )
                $sql .= " AND t.TEL_REVISADA = 0 ";
        }


        $sql .= " AND t.EST_ID = " . $estado;

        if ( !empty( $nombre ) )
            $sql .= " AND t.TEL_PAC_PRIMER_NOMBRE LIKE '%".$nombre."%' ";

        if ( !empty( $apellido ) )
            $sql .= " AND t.TEL_PAC_PRIMER_APELLIDO LIKE '%".$apellido."%' ";

        $sql .= " GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {

            // Calcula días de atraso desde el último cambio de estado de la TC
            // USA FUNCIONES DE PHP >5.3
            $listado = array( );
            foreach( $query->result_array() as $tc ) {
                $f = explode( ' ', $tc['TEL_FECHA_HORA'] );

                // Para el listado de TC Contestadas (estado: 7) se lista la cantidad de días desde que fue enviada/nueva hasta que alcanza el estado respondida
                // para otros casos usa la fecha actual.
                if( $estado == 7 ) {

                    $asdf = $this->tc_estado_get( $tc['TEL_ID'], 7 );
                    $t = explode( ' ', $asdf['TEP_FECHA_HORA'] );
                    $tc['TEL_ATRASO'] = ($f[0] && $t[0]) ? date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a') : "";
                } else
                    //$tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create( null ) )->format('%a');

                $listado[] = $tc;
            }

            return $listado;
        } else
            return NULL;
    }
	
    public function tc_busca_etb($etb = '', $estado)
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA
                        , case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( te.TEP_FECHA_HORA ) end as TEL_FECHA_HORA
                        , t.EST_ID, t.TEL_LOCK_USED, lck.USU_NOMBRE as TEL_LOCK_OWNER_NOMBRE, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE ";

        /*
         * Administrador observa TC revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /*
         * Filtra por revisada solo para especialista: Bandeja del especialista solo ve las revisadas
         * Supervisor observa las revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
            if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                $sql .= "   AND t.TEL_REVISADA = 1";
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
            }
        }

        /* No filtra por revisada:
         * Enviadas/nuevas  = muestra sus propios envios (revisados o no)
         * Solicitud examen = muestra los solicitados tanto del revisor como del especialista
         * Respuesta solicitud = muestra sus propias respuestas (revisadas o no)
         * Respuesta final  = muestra las respuestas finales del especialista
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }



        // NF432 
        if ( $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE']  ){

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 1 ) ";
            $sql .= "   WHERE t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

        }




        /* Filtra por revisada:
         * (2) Enviadas/nuevas  = muestra tc nuevas sin revisar (tel_revisada=0)
         * (5) Solicitud examen = muestra tc al que se han solicitado examenes (sin revisar tel_revisada=0)
         * (6) Respuesta solicitud = muestra respuestas de la solicitud (solo no revisadas)
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $estado == 2 || $estado == 5 || $estado == 6 )
                $sql .= " AND t.TEL_REVISADA = 0 ";
        }

        // Establece el estado
        $sql .= "AND t.EST_ID = ".$estado." ";
        if($etb) $sql .= "AND e.ETB_NOMBRE LIKE '%".$etb."%' ";

        $sql .= "GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {

            // Calcula días de atraso desde el último cambio de estado de la TC
            // USA FUNCIONES DE PHP >5.3
            $listado = array( );
            foreach( $query->result_array() as $tc ) {
                $f = explode( ' ', $tc['TEL_FECHA_HORA'] );

                // Para el listado de TC Contestadas (estado: 7) se lista la cantidad de días desde que fue enviada/nueva hasta que alcanza el estado respondida
                // para otros casos usa la fecha actual.
                if( $estado == 7 ) {

                    $asdf = $this->tc_estado_get( $tc['TEL_ID'], 7 );
                    $t = explode( ' ', $asdf['TEP_FECHA_HORA'] );
                    //$tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a');
					$tc['TEL_ATRASO'] = ($f[0] && date_create($f[0]) && $t[0] && date_create($t[0])) ? date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a') : "";
                } else
                    $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create( null ) )->format('%a');

                $listado[] = $tc;
            }

            return $listado;
        } else
            return NULL;
    }

    /**
    * Busca las TC de un paciente segun su nombre y/o apellido y el
    * estado en que se encuentra.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
    * @access public
    * @param string $nombre Nombre del paciente a buscar TC
    * @param string $apellido Apellido del paciente a buscar TC
    * @param int $estado Estado de la TC
    * @return array Arreglo con todas las TC encontradas
    */
    public function tc_busca_fecha( $estado, $fecha_desde, $fecha_hasta = '' )
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( te.TEP_FECHA_HORA ) end as TEL_FECHA_HORA
                        , t.EST_ID, t.TEL_LOCK_USED, lck.USU_NOMBRE as TEL_LOCK_OWNER_NOMBRE, t.PRI_ID, t.TEL_ABIERTA,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE ";

        /*
         * Administrador observa TC revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /*
         * Filtra por revisada solo para especialista: Bandeja del especialista solo ve las revisadas
         * Supervisor observa las revisadas y no revisadas
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = gu.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                $sql .= "   AND t.TEL_REVISADA = 1";
                $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
            }
        }

        /* No filtra por revisada:
         * Enviadas/nuevas  = muestra sus propios envios (revisados o no)
         * Solicitud examen = muestra los solicitados tanto del revisor como del especialista
         * Respuesta solicitud = muestra sus propias respuestas (revisadas o no)
         * Respuesta final  = muestra las respuestas finales del especialista
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
        }

        /* Filtra por revisada:
         * (2) Enviadas/nuevas  = muestra tc nuevas sin revisar (tel_revisada=0)
         * (5) Solicitud examen = muestra tc al que se han solicitado examenes (sin revisar tel_revisada=0)
         * (6) Respuesta solicitud = muestra respuestas de la solicitud (solo no revisadas)
         */
        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                            INNER JOIN ( TC_GRUPO g
                                                                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                            ) ON ( g.GRU_ID = gc.GRU_ID )
                                                            ) ON ( gc.CLI_ID = c.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID ) ";
            $sql .= "       LEFT JOIN ( TC_TELECONSULTA_ESTADO te
                                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = te.USU_ID AND u_g.ROL_ID = 4 )
                            ) ON ( te.TEL_ID = t.TEL_ID and te.EST_ID = 2 ) ";
            $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID');
            $sql .= "   AND t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";

            if( $estado == 2 || $estado == 5 || $estado == 6 )
                $sql .= " AND t.TEL_REVISADA = 0 ";
        }


        $sql .= " AND t.EST_ID = " . $estado;

        if ( !empty( $fecha_desde ) )
            $sql .= " AND te.TEP_FECHA_HORA > STR_TO_DATE( '".$fecha_desde."', '%d-%m-%Y %H:%i:%s' ) ";

        if ( !empty( $fecha_hasta ) )
            $sql .= " AND te.TEP_FECHA_HORA <= STR_TO_DATE( '".$fecha_hasta." 23:59:59', '%d-%m-%Y %H:%i:%s' ) ";

        $sql .= " GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {

            // Calcula días de atraso desde el último cambio de estado de la TC
            // USA FUNCIONES DE PHP >5.3
            $listado = array( );
            foreach( $query->result_array() as $tc ) {
                $f = explode( ' ', $tc['TEL_FECHA_HORA'] );

                // Para el listado de TC Contestadas (estado: 7) se lista la cantidad de días desde que fue enviada/nueva hasta que alcanza el estado respondida
                // para otros casos usa la fecha actual.
                if( $estado == 7 ) {

                    $asdf = $this->tc_estado_get( $tc['TEL_ID'], 7 );
                    $t = explode( ' ', $asdf['TEP_FECHA_HORA'] );
                    $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create_from_format( 'Y-m-d', $t[0] ) )->format('%a');
                } else
                    $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create( null ) )->format('%a');

                $listado[] = $tc;
            }

            return $listado;
        } else
            return NULL;
    }


    /**
    * Obtiene una TC en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID de la TC
    * @return array Arreglo con los datos de la TC
    */
    public function tc_get($id)
    {
        // Se evita seleccionar todo TC_ESTABLECIMIENTO porque carga columna
        // MUNI_ID, que sobreescribe mismo campo de TC_TELECONSULTA
        $sql = "SELECT  TC_TELECONSULTA.*,
                        TC_SITE.SIT_NOMBRE,
                        TC_SITE.SIT_PAIS,
                        TC_ESTABLECIMIENTO.ETB_NOMBRE,
                        TC_ESTABLECIMIENTO.ETB_NIVEL,
                        TC_ESTABLECIMIENTO.ETB_DIRECCION,
                        TC_ESTABLECIMIENTO.ETB_CIUDAD,
                        TC_ESTABLECIMIENTO.ETB_TELEFONO,
                        TC_ESTABLECIMIENTO.ETB_EMAIL,
                        TC_ESTABLECIMIENTO.ETB_DETALLE_NIVEL,
                        TC_CLIENTE.*,
                        TC_TELECONSULTA_CIE10_RESPUESTA.TEL_CIE_ID_RESPUESTA  ";

        if( $this->session->userdata('SIT_ID') == 22 ) {
            $sql.=", TC_ENTIDADES_ADMINISTRADORAS.*, TC_FINALIDAD_PROCEDIMIENTO.*, TC_ZONA_RESIDENCIA.*, TC_AMBITO_PROCEDIMIENTO.* ";
        }

        $sql .= "FROM   TC_TELECONSULTA
                        INNER JOIN TC_SITE ON ( TC_SITE.SIT_ID = TC_TELECONSULTA.SIT_ID )
                        INNER JOIN ( TC_ESTABLECIMIENTO
                                INNER JOIN TC_CLIENTE ON ( TC_CLIENTE.CLI_ID = TC_ESTABLECIMIENTO.CLI_ID )
                        ) ON ( TC_ESTABLECIMIENTO.ETB_ID = TC_TELECONSULTA.ETB_ID )
                        LEFT JOIN TC_TELECONSULTA_CIE10_RESPUESTA ON ( TC_TELECONSULTA_CIE10_RESPUESTA.TEL_ID = TC_TELECONSULTA.TEL_ID ) ";

        if( $this->session->userdata('SIT_ID') == 22 ) {

            $sql.= "    LEFT JOIN TC_ENTIDADES_ADMINISTRADORAS ON ( TC_ENTIDADES_ADMINISTRADORAS.ENTADM_ID = TC_TELECONSULTA.ENTADM_ID )
                        LEFT JOIN TC_FINALIDAD_PROCEDIMIENTO ON ( TC_FINALIDAD_PROCEDIMIENTO.FINPROC_ID = TC_TELECONSULTA.FINPROC_ID )
                        LEFT JOIN TC_ZONA_RESIDENCIA ON ( TC_ZONA_RESIDENCIA.ZON_ID = TC_TELECONSULTA.ZON_ID )
                        LEFT JOIN TC_AMBITO_PROCEDIMIENTO ON ( TC_AMBITO_PROCEDIMIENTO.AMBPROC_ID = TC_TELECONSULTA.AMBPROC_ID ) ";
        }

        $sql .= " WHERE TC_TELECONSULTA.TEL_ID = ".(int)$id." ";
//imprimir( $sql );
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
//            imprimir($row);
            $sql2 = "SELECT ESP_NOMBRE ";
            $sql2 .= "FROM TC_ESPECIALIDAD ";
            $sql2 .= "WHERE ESP_ID = '".$row[0]['ESP_ID']."'";
            $query = $this->db->query($sql2);
            $row2 = $query->result_array();
            $row[0]['ESP_NOMBRE'] = $row2[0]['ESP_NOMBRE'];
            $row[0]['RESPONDER'] = FALSE;

            // Especialista: marca como "vista" las TC enviadas/nuevas y solicitadas de examen
            // Generalistas: marca como "vista" las TC borradores, Rechazadas, examenes solicitados y respondidos
            if( ( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] &&
                  ( $row[0]['EST_ID'] == 2 || $row[0]['EST_ID'] == 6 ) ) ||
                ( ( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
                  $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) &&
                  ( $row[0]['EST_ID'] == 1 || $row[0]['EST_ID'] == 3 || $row[0]['EST_ID'] == 5 || $row[0]['EST_ID'] == 7 )
                )
            )
                $this->tc_abierta_ex($row[0]['TEL_ID'], 0);

            if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
                $usuario = $this->usuario_especialidades_get($this->session->userdata('USU_ID'));
                foreach ($usuario as $usu) {
                    if ($usu['ESP_ID'] == $row[0]['ESP_ID'])
                        $row[0]['RESPONDER'] = TRUE;
                }
            }


            if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
                $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {
                $usuario = $this->usuario_get($this->session->userdata('USU_ID'));

                $establecimientos_usuario = $this->usuario_establecimientos_get( $usuario['USU_ID'] );
                foreach( $establecimientos_usuario as $e )
                    if( $e['ETB_ID'] == $row[0]['ETB_ID'])
                        $row[0]['RESPONDER'] = TRUE;
            }
            return $row[0];
        }
        else
            return NULL;
    }

    /**
     * Obtiene un listado con los estados que ha pasado la Teleconsulta
     * ordenado de manera descendente segun fecha.
     * @param type $id Identificador de la TC
     * @param type $id_estado (opcional) solo listar los que están en algún estado en particular
     *                          si no se establece muestra todos los estados
     */
    public function tc_historia( $id, $id_estado = null ) {

        $sql = 'SELECT  e.USU_ID, u.USU_NOMBRE,
                        e.EST_ID, date_format( e.TEP_FECHA_HORA, \'%H:%i:%s %d/%m/%Y\' ) as TEP_FECHA_HORA,
                        e.TEP_COMENTARIO, e.TEL_ID,
                        tmr.TMR_ID_RECHAZO, case when tmr.TMR_ID_RECHAZO = 1 then tmr.TMR_COMENTARIO else mr.MR_DESCRIPCION end as TMR_COMENTARIO
                FROM TC_TELECONSULTA_ESTADO e
                     LEFT JOIN TC_USUARIO u ON (u.USU_ID = e.USU_ID)
                     LEFT JOIN ( TC_TELECONSULTA_MOTIVO_RECHAZO tmr
                        INNER JOIN TC_MOTIVO_RECHAZO mr ON ( mr.MR_ID = tmr.TMR_ID_RECHAZO )
                     ) ON ( tmr.TEP_ID = e.TEP_ID )
                WHERE e.TEL_ID = '.$id;
        if( !empty( $id_estado ) ) {
            if( is_array( $id_estado ) )
                $sql.= ' AND e.EST_ID in ( ' .$id_estado . ' )';
            else
                $sql.= ' AND e.EST_ID = ' .$id_estado;
        }
        $sql.= ' ORDER BY e.TEP_FECHA_HORA DESC';
        $query = $this->db->query( $sql );
        return $query->result_array();
    }

    /**
     * Obtiene último estado de la TC según historia.
     * NOTA: Tener en cuenta que los perfiles de Revisor y Especialista
     * comparten iguales estados en (5)Solicitud de examenes y (6)Respuesta
     * de solicitud, por lo que se debe validar fuera del método qué rol
     * tiene el usuario del ultimo estado
     *
     * @param int $id_teleconsulta Identificador de la TC
     * @param int $id_estado (opcional) solo obtiene ultimo registro del estado indicado en el parámetro
     */
    public function tc_ultimo_estado( $id_teleconsulta, $id_estado = null ) {

        $sql = 'SELECT  e.USU_ID, u.USU_NOMBRE, u.ROL_ID,
                        e.EST_ID, date_format( e.TEP_FECHA_HORA, \'%H:%i:%s %d/%m/%Y\' ) as TEP_FECHA_HORA,
                        e.TEP_COMENTARIO, e.TEL_ID,
                        tmr.TMR_ID_RECHAZO, case when tmr.TMR_ID_RECHAZO = 1 then tmr.TMR_COMENTARIO else mr.MR_DESCRIPCION end as TMR_COMENTARIO
                FROM TC_TELECONSULTA_ESTADO e
                     LEFT JOIN TC_USUARIO u ON (u.USU_ID = e.USU_ID)
                     LEFT JOIN ( TC_TELECONSULTA_MOTIVO_RECHAZO tmr
                        INNER JOIN TC_MOTIVO_RECHAZO mr ON ( mr.MR_ID = tmr.TMR_ID_RECHAZO )
                     ) ON ( tmr.TEP_ID = e.TEP_ID )
                WHERE e.TEL_ID = '.$id_teleconsulta. ' ';

        if( !empty( $id_estado ) )
            $sql.=' AND e.EST_ID = ' .$id_estado. ' ';

        $sql.= ' ORDER BY e.TEP_FECHA_HORA DESC';
//imprimir( $sql );
        $query = $this->db->query( $sql );
        if( $query->num_rows() > 0 )
            return $query->result_array();

        return array( );
    }

    /**
    * Actualiza una TC marcandola como abierta si fue leida por un especialista
    * o generalista dependiendo del estado de esta.
    *
    * @access public
    * @param int $id ID de la TC
    * @param int $abierta Como se marcara, abierta o cerrada
    * @return none
    */
    public function tc_abierta_ex($id, $abierta)
    {
        $data['TEL_ID'] = $id;
        $data['TEL_ABIERTA'] = $abierta;
        $this->db->where('TEL_ID', $data['TEL_ID']);
        $this->db->update('TC_TELECONSULTA', $data);
    }

    /**
    * Saca de la db todos los identificadores de un paciente para
    * una TC en especifico, esta es la foto de los identificadores
    * cuando se genera la TC.
    *
    * @access public
    * @param int $id ID de la TC
    * @return array Arreglo con todos los identificadores del paciente
    */
    public function tc_ident_get($id)
    {
        $sql = "SELECT * ";
        $sql .= "FROM TC_TELPAC_IDENTIFICADOR ";
        $sql .= "WHERE TEL_ID = '".$id."'";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0)
            return  $query->result_array();
        else
            return NULL;
    }

    /**
    * Saca de la db todos los identificadores de un paciente para
    * una TC en especifico, esta es la foto de los identificadores
    * cuando se genera la TC.
    *
    * @access public
    * @param int $id ID de la TC
    * @return array Arreglo con todos los identificadores del paciente
    */
    public function tc_ident_update( $tel_id, $tci_nombre, $tci_valor )
    {
        $this->db->set( 'TCI_NOMBRE', $tci_nombre );
        $this->db->set( 'TCI_VALOR', $tci_valor );
        $this->db->where( 'TEL_ID', $tel_id );
        $query = $this->db->update( 'TC_TELPAC_IDENTIFICADOR' );

        return TRUE;
    }

    /**
    * Saca de la db todos los identificadores de un paciente en especifico
    * segun el ID de este que llega por parametro.
    *
    * @access public
    * @param int $id ID del paciente
    * @return array Arreglo con todos los identificadores del paciente
    */
    public function ident_get($id)
    {
        $sql = "SELECT pi.PAC_IDT_VALOR, i.IDT_NOMBRE ";
        $sql .= "FROM TC_PACIENTE_IDENTIFICADOR AS pi, TC_IDENTIFICADOR AS i ";
        $sql .= "WHERE pi.PAC_ID = '".$id."' ";
        $sql .= "AND i.IDT_ID = pi.IDT_ID";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row;
        }
        else
            return NULL;
    }

    /**
    * Actualiza una TC en especifico, recibiendo
    * los datos en un arreglo por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos a actualizar
    * @return boolean TRUE si se actualizo correctamente
    */
    public function tc_upd($data)
    {
        // if ($this->existe_registro('TC_TELECONSULTA', 'TEL_ID', $data['TEL_ID'])) {
            $this->db->where('TEL_ID', $data['TEL_ID']);
            $this->db->update('TC_TELECONSULTA', $data);

            if ($data['EST_ID'] != 1)
                $this->tc_abierta_ex($data['TEL_ID'], 1);
            return TRUE;



        // }
    }

    /**
     *
     */
    public function tc_insert_cie10_respuesta( $id_tc, $dm_cie10_respuesta ) {

        if( !empty( $dm_cie10_respuesta ) ) {
//imprimir( $dm_cie10_respuesta, false );
//imprimir( json_encode( $dm_cie10_respuesta ), false );
            $datos = array( 'TEL_ID' => $id_tc, 'TEL_CIE_ID_RESPUESTA' => json_encode( $dm_cie10_respuesta ) );
            return $this->db->insert( 'TC_TELECONSULTA_CIE10_RESPUESTA', $datos );
        }

        return false;
    }

    public function tc_update_cie10_respuesta( $id_tc, $dm_cie10_respuesta ) {

        $this->tc_delete_cie10_respuesta( $id_tc );
        return $this->tc_insert_cie10_respuesta( $id_tc, $dm_cie10_respuesta );
    }

    public function tc_delete_cie10_respuesta( $id_tc ) {

        $this->db->delete( 'TC_TELECONSULTA_CIE10_RESPUESTA', array( 'TEL_ID' => $id_tc ) );
    }

    /**
     *  Obtiene listado de códigos CIE10 de respuesta
     * @param array $id_teleconsulta listado con identificadores de diagnósticos médicos que se quiere obtener su descripcion
     *                  así es usado al obtener diagnósticos en formularios de lectura.
     *                  Si $datos es vacío se carga listado completo de los diagnosticos.
     * @return array    Listado de diagnósticos médicos según parámetros otorgados
     */
    public function cie10_respuesta_get( $id_teleconsulta ) {

        if( empty( $id_teleconsulta ) ) return null;

        $this->db->select( "TEL_CIE_ID_RESPUESTA" )->from('TC_TELECONSULTA_CIE10_RESPUESTA');
        $this->db->where( 'TEL_ID', $id_teleconsulta );

        $query = $this->db->get( );

        if( $query->num_rows() > 0 ) {
            $listado_cie10 = $query->row_array( );
            if( !empty( $listado_cie10 ) ) {
                $temp = json_decode( array_pop( $listado_cie10 ), TRUE );
                return $codigos = $this->cie10_get( $temp );
            }
        } else
            return null;
    }

    /**
    * Elimina una TC del sistema por el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID de la TC
    * @return boolean TRUE si se elimino correctamente
    */
    public function tc_del($id)
    {
        $data['TEL_ID'] = $id;
        $this->db->delete('TC_TELECONSULTA', $data);
        $this->db->delete('TC_TELPAC_IDENTIFICADOR', $data);
        return TRUE;
    }

    /**
     * Guarda evaluación que realiza el médico generalista a la respuesta
     * del médico especialista
     *
     * @access public
     * @param int $id ID de la TC
     * @param string $texto Evalución en texto de la TC
     * @param int $nota nota de evualiación de la TC
     * @return boolean TRUE si se ha ingresado la evualiacion
     */
    public function tc_guardar_evaluacion( $id, $texto, $nota ) {

        $datos = array( 'TEL_EVALUACION_COMENTARIO' => $texto,
                        'TEL_EVALUACION_PUNTAJE' => $nota );

        $this->db->where( 'TEL_ID', $id );
        $estado = $this->db->update( 'TC_TELECONSULTA', $datos );

        if( !empty( $estado ) )
            return true;
        else
            return false;
    }

    /**
     * Guarda evaluación que realiza el médico especialista a la solicitud
     * del médico generalista
     * @access public
     * @param int $id ID de la TC
     * @param string $texto Evalución en texto de la TC
     * @param int $nota nota de evualiación de la TC
     * @return boolean TRUE si se ha ingresado la evaluacion
     */
    public function tc_guardar_evaluacion_solicitud( $id, $texto, $nota ) {

        $datos = array( 'TEL_EVALUACION_SOLICITUD_COMENTARIO' => $texto,
                        'TEL_EVALUACION_SOLICITUD_PUNTAJE' => $nota );

        $this->db->where( 'TEL_ID', $id );
        $estado = $this->db->update( 'TC_TELECONSULTA', $datos );

        if( !empty( $estado ) )
            return true;
        else
            return false;
    }

    /**
     *
     */
    public function tc_comprobar_toma( $id_teleconsulta ) {

        $this->db->select( 'TC_TELECONSULTA.TEL_LOCK_USED' );
        $this->db->select( 'TC_TELECONSULTA.TEL_LOCK_OWNER' );
        $this->db->select( 'TC_USUARIO.USU_NOMBRE' );
        $this->db->from( 'TC_TELECONSULTA' );
        $this->db->join( 'TC_USUARIO', 'TC_USUARIO.USU_ID = TC_TELECONSULTA.TEL_LOCK_OWNER' );
        $this->db->where( 'TEL_ID', $id_teleconsulta );
        $query = $this->db->get();

        return $query->row_array( );
    }

    /**
     * Establece marca de "Toma" del examen, que está siendo vista por un médico
     * @param int Id de la teleconsulta
     */
    public function tc_marcar_toma( $id_teleconsulta ) {

        $data = array( 'TEL_LOCK_DATE' => date('Y-m-d').' '.date('H:i:s'),
                       'TEL_LOCK_OWNER' => $this->session->userdata('USU_ID'),
                       'TEL_LOCK_USED' => 1 );
        $this->db->where( 'TEL_ID', $id_teleconsulta );
        return $this->db->update( 'TC_TELECONSULTA', $data );
    }

    /**
     * Elimina marca de "Toma" del examen, médico deja de visualizar la TC
     */
    public function tc_desmarcar_toma( $id_teleconsulta ) {

        $data = array( 'TEL_LOCK_DATE' => null,
                       'TEL_LOCK_OWNER' => null,
                       'TEL_LOCK_USED' => 0 );
        $this->db->where( 'TEL_ID', $id_teleconsulta );
        return $this->db->update( 'TC_TELECONSULTA', $data );
    }

    public function tc_agendamientos_get( $id_teleconsulta, $id_estado = null ) {

        $sql = 'SELECT  a.*
                        , u_g.USU_NOMBRE as USU_NOMBRE_GENERALISTA
                        , u_e.USU_NOMBRE as USU_NOMBRE_ESPECIALISTA
                FROM    TC_AGENDA a
                        INNER JOIN TC_USUARIO u_g ON ( u_g.USU_ID = a.USU_ID_MEDICO )
                        INNER JOIN TC_USUARIO u_e ON ( u_e.USU_ID = a.USU_ID_ESPECIALISTA )
                WHERE   a.TEL_ID = '. (int)$id_teleconsulta;

        if( !empty( $id_estado ) )
            $sql.= ' AND a.AGEEST_ID = '.$id_estado;

        $sql.= ' ORDER BY AGE_INICIO_REUNION ASC';
        $resultado = $this->db->query( $sql );
        return $resultado->result_array();
    }

    /**
    * Metodo que sirve para buscar si existe un registro en la db
    * segun datos que llegan por parametro.
    *
    * @access public
    * @param string $tabla Tabla de la db a la cual se le hara la consulta
    * @param string $campo Campo que se consultara
    * @param string $compare Valor del campo que se busca
    * @param string $nocompare Campo que no comparara
    * @param string $datanocompare Dato del campo a no coparar
    * @param string $otrocampo Otro campo a buscar
    * @param string $otrocompare Dato a buscar en ese campo
    * @return boolean TRUE si encuentra resultado o FALSE sino
    */
    public function existe_registro($tabla, $campo, $compare, $nocompare = NULL, $datanocompare = NULL, $otrocampo = NULL, $otrocompare = NULL)
    {
        $sql = 'SELECT * FROM '.$tabla.' WHERE '.$campo.' = "'.$compare.'"';
        if ($otrocampo != NULL)
            $sql .= ' AND '.$otrocampo.' = "'.$otrocompare.'"';
        if ($nocompare != NULL)
            $sql .= ' AND '.$nocompare.' <> "'.$datanocompare.'"';
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
            return TRUE;
        else
            return FALSE;
    }

    /**
    * Metodo que sirve para buscar un usuario segun el tipo y el nombre
    * busca hacer match con string ingresado.
    *
    * @access public
    * @param int $tipo Tipo de usuario (generalista o especialista)
    * @return array Con el resultado de la busqueda
    */
    public function autocomplete_search_get($tipo, $match)
    {
        $sql = "SELECT u.USU_ID, u.USU_NOMBRE ";
        $sql .= "FROM TC_USUARIO AS u ";
        $sql .= "       LEFT JOIN TC_USUARIO_ESPECIALIDAD AS ue ON ue.USU_ID = u.USU_ID ";
        $sql .= "WHERE u.SIT_ID = ".$this->session->userdata('SIT_ID')." ";
        if ($tipo == 'especialista') {
            $sql .= "AND u.ROL_ID = 3 ";

            if ($this->session->userdata('autocomplete_especialidad') != NULL) {
                $sql .= "AND ue.ESP_ID = ".$this->session->userdata('autocomplete_especialidad')." ";
                $sql .= "AND u.USU_ID = ue.USU_ID ";
            }
        }
        else if ($tipo == 'generalista') {
            $sql .= "AND u.ROL_ID = 4 ";
            if ($this->session->userdata('autocomplete_establ') != NULL)
                $sql .= "AND u.ETB_ID = ".$this->session->userdata('autocomplete_establ')." ";
            else if ($this->session->userdata('autocomplete_cliente') != NULL) {
                $sql .= "AND u.CLI_ID = ".$this->session->userdata('autocomplete_cliente')." ";
            }
//            else
//                $sql .= "AND u.CLI_ID = ".$this->session->userdata('CLI_ID')." ";
        }
        $sql .= "AND u.USU_NOMBRE LIKE '%".$match."%' ";
        $sql .= "GROUP BY u.USU_ID ";
        $sql .= "ORDER BY u.USU_NOMBRE ASC";

        $query = $this->db->query($sql);
        if ($query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Busca TC en el sistema con datos para la query recibidos
    * por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para la busqueda
    * @return array Con todos las TC encontradas
    */
    public function buscar_tc_b($data)
    {
        $sql = "SELECT    tc.TEL_ID, pi.PAC_IDT_VALOR, tc.EST_ID,
                        tc.TEL_PAC_PRIMER_NOMBRE, tc.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO,
                        e.ETB_NOMBRE,
                        c.CLI_ID, c.CLI_NOMBRE,
                        es.ESP_NOMBRE,
                        tc.TEL_FECHA_HORA_ENVIO,
                        tc.TEL_FECHA_HORA_SOLEXA,
                        tc.TEL_FECHA_HORA_RESPUESTA,
                        ur.USU_NOMBRE as usu_especialista

                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )
                        INNER JOIN TC_ESPECIALIDAD es ON ( es.ESP_ID = tc.ESP_ID )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_enviado
                            INNER JOIN TC_USUARIO ue ON ( ue.USU_ID = tce_enviado.USU_ID and ue.ROL_ID = 4 )
                        ) ON ( tce_enviado.TEL_ID = tc.TEL_ID AND tce_enviado.EST_ID = 2)
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_respuesta
                            INNER JOIN TC_USUARIO ur ON ( ur.USU_ID = tce_respuesta.USU_ID )
                        ) ON ( tce_respuesta.TEL_ID = tc.TEL_ID AND tce_respuesta.EST_ID = 7 ) ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE']  ) { // NF432

            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN TC_GRUPO_CLIENTE gc ON ( gc.CLI_ID = c.CLI_ID )
                            ) ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $sql .= "       INNER JOIN ( TC_BOLSA_TELECONSULTA bt
                                            INNER JOIN ( TC_BOLSA_USUARIO bu ) ON ( bu.BOL_ID = bt.BOL_ID AND bu.USU_ID = ".(int)$this->session->userdata('USU_ID')." )
                                            INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID )
                                ) ON ( bt.TEL_ID = tc.TEL_ID AND tc.TEL_REVISADA = 1 )
                                INNER JOIN ( TC_ESTABLECIMIENTO e
                                    INNER JOIN ( TC_CLIENTE c ) ON ( c.CLI_ID = e.CLI_ID )
                                ) ON ( e.ETB_ID = tc.ETB_ID )";

                // Especialista solo puede ver TC revisadas y las de su especialidad
//                if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
//                    $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
//                }
            } else {
                $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                                INNER JOIN ( TC_CLIENTE c
                                    INNER JOIN ( TC_GRUPO_CLIENTE gc
                                        INNER JOIN ( TC_GRUPO g
                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID AND gu.USU_ID = " . $this->session->userdata('USU_ID'). " )
                                        ) ON ( g.GRU_ID = gc.GRU_ID )
                                    ) ON ( gc.CLI_ID = c.CLI_ID )
                                ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( tc.ETB_ID = e.ETB_ID ) ";
            }
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {
            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID AND u.USU_ID = " . $this->session->userdata('USU_ID'). " )
                            ) ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }

        // Filtra TC's por site del usuario
        $sql .= "WHERE  tc.SIT_ID = ".$this->session->userdata('SIT_ID')." ";

        // Filtro Cliente (Querys necesitan de cruce con tc->especialidad)
        if ( !empty( $data['grupo'] ) )
            $sql .= "AND gc.GRU_ID = ".(int)$data['grupo']." ";

        // Filtro Cliente (Querys necesitan de cruce con tc->especialidad)
        if ( !empty( $data['cliente'] ) )
            $sql .= "AND e.CLI_ID = ".(int)$data['cliente']." ";

        // Filtro Establecimiento
        if ( !empty( $data['establ'] ) )
            $sql .= "AND tc.ETB_ID = ".(int)$data['establ']." ";

        // Filtro Especialidad
        if ( !empty( $data['especialidad'] ) )
            $sql .= "AND tc.ESP_ID = ".(int)$data['especialidad']." ";

        // Filtro por estados de la TC's
        if ( !empty( $data['estado'] ) )
            $sql .= "AND tc.EST_ID = ".(int)$data['estado']." ";

        // Filtro generalista que envió TC
        if ( !empty( $data['generalista'] ) )
            $sql .= "AND ( tce_enviado.USU_ID = ".$data['generalista'].") ";

        // Filtro especialita primera respuesta <-- ?
        if ( !empty( $data['especialista1'] ) )
            $sql .= "AND ( tce_solexam.USU_ID = ".$data['especialista1'].") ";

        // Filtro especialista2 <------- ?
        if ( !empty( $data['especialista2'] ) )
            $sql .= "AND ( tce_respuesta.USU_ID = ".$data['especialista2'].") ";

        // Descarta TC's borradores a los 1: Admins, 2: Supervisores y 3: Especialistas
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] )
            $sql .= "AND tc.EST_ID <> 1 ";

        // Filtra TC's en estado 4: Eliminadas
        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] )
            $sql .= "AND tc.EST_ID <> 4 ";

        // Filtro fecha enviados
        if ( !empty( $data['fecha_env_desde'] ) && !empty( $data['fecha_env_hasta'] ) && !empty( $data['generalista'] ) )
            $sql .= "AND (tc.TEL_FECHA_HORA_ENVIO BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) AND tce_enviado.USU_ID = ".$data['generalista']." ";
        else if ($data['fecha_env_desde'] != 0 && $data['fecha_env_hasta'] != 0)
            $sql .= "AND (tc.TEL_FECHA_HORA_ENVIO BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) ";

        // Filtro fecha contestados
        if ($data['fecha_con_desde'] != 0 && $data['fecha_con_hasta'] != 0 && $data['estado'] == 7 && $data['especialista2'] != 0)
            $sql .= "AND (tc.TEL_FECHA_HORA_ENVIO BETWEEN '".$data['fecha_con_desde']." 00:00:00' AND '".$data['fecha_con_hasta']." 23:59:59' ) AND tce_respuesta.USU_ID = ".$data['especialista2']." ";
        else if ($data['fecha_con_desde'] != 0 && $data['fecha_con_hasta'] != 0 && $data['estado'] == 7)
            $sql .= "AND (tc.TEL_FECHA_HORA_ENVIO BETWEEN '".$data['fecha_con_desde']." 00:00:00' AND '".$data['fecha_con_hasta']." 23:59:59' ) ";

        $sql.= " GROUP BY tc.TEL_ID
                ORDER BY c.CLI_NOMBRE ASC, tc.TEL_ID DESC";
			
        $query = $this->db->query($sql);
		
        $dat['tc_cantidad'] = $query->num_rows();
		
         if ($dat['tc_cantidad'] > 0){
			return  $query->result_array();
        }else{
           return NULL;
		   }
    }


public function buscar_tc_b_imp($data)
    {
		

        $sql = "SELECT  tc.TEL_ID, pi.PAC_IDT_VALOR, i.TIPO_IDENTIFICACION, tc.EST_ID,
                        tc.TEL_PAC_PRIMER_NOMBRE,tc.TEL_PAC_SEGUNDO_NOMBRE, tc.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO, tc.TEL_PAC_EDAD, tc.TEL_PAC_SEXO,
                        e.ETB_NOMBRE,
                        c.CLI_ID, c.CLI_NOMBRE,
                        es.ESP_NOMBRE,
						ue.USU_NOMBRE AS usu_medico,
                        ur.USU_NOMBRE as usu_especialista,
						tc.EST_ID,
						CASE tc.EST_ID
							WHEN '1'  THEN 'Borrador'
							WHEN '2'  THEN 'Enviada'
							WHEN '3'  THEN 'Rechazada'
							WHEN '4'  THEN 'Eliminada'
							WHEN '5'  THEN 'Examen Solicitado'
							WHEN '6'  THEN 'Examen Realizado'
							WHEN '7'  THEN 'Contestada'
							ELSE 'Sin Info'
							END as glo_estado,
						tc.TEL_FECHA_HORA_ENVIO,
						tc.TEL_FECHA_HORA_REVISOR_SOLEXA,
						tc.TEL_FECHA_HORA_REVISOR_SOLEXARESP , 
						tc.TEL_FECHA_HORA_REVISOR_ENVIO , 
						tc.TEL_FECHA_HORA_SOLEXA , 
						tc.TEL_FECHA_HORA_SOLEXARESP , 
						tc.TEL_FECHA_HORA_RESPUESTA , 
						tc.TEL_FECHA_HORA_RECHAZO,
						tc.TEL_FECHA_HORA,
						tc.TEL_PAC_EDAD,
						tc.TEL_PAC_SEXO,
						cie10.TEL_CIE_ID_RESPUESTA,
						TEL_MODALIDAD_RESPUESTA,
						afi.AFI_NOMBRE,
						MUN_NOMBRE,
						DPTO_NOMBRE,
						ENTADM_NOMBRE,
						tce_revisor.TEP_FECHA_HORA AS FECHA_REVISOR,
						urev.USU_NOMBRE AS NOMBRE_REVISOR,
						tce_generado.TEP_FECHA_HORA AS FECHA_GENERADO,
						ug.USU_NOMBRE AS NOMBRE_MEDICO
                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = p.PAC_ID ) INNER JOIN TC_IDENTIFICADOR i ON pi.IDT_ID = i.IDT_ID 
                        ) ON ( p.PAC_ID = tc.PAC_ID )
                        INNER JOIN TC_ESPECIALIDAD es ON ( es.ESP_ID = tc.ESP_ID )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_enviado
                            INNER JOIN TC_USUARIO ue ON ( ue.USU_ID = tce_enviado.USU_ID and ue.ROL_ID = 4 )
                        ) ON ( tce_enviado.TEL_ID = tc.TEL_ID AND tce_enviado.EST_ID = 2)
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_respuesta
                            INNER JOIN TC_USUARIO ur ON ( ur.USU_ID = tce_respuesta.USU_ID )
                        ) ON ( tce_respuesta.TEL_ID = tc.TEL_ID AND tce_respuesta.EST_ID = 7 ) ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ATENCION_CLIENTE']  ) { // NF432

			if ( !empty( $data['grupo'] ) ){
				$sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN TC_GRUPO_CLIENTE gc ON ( gc.CLI_ID = c.CLI_ID )
                            ) ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
			}
			else{
				$sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";	
			}
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $sql .= "       INNER JOIN ( TC_BOLSA_TELECONSULTA bt
                                            INNER JOIN ( TC_BOLSA_USUARIO bu ) ON ( bu.BOL_ID = bt.BOL_ID AND bu.USU_ID = ".(int)$this->session->userdata('USU_ID')." )
                                            INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID )
                                ) ON ( bt.TEL_ID = tc.TEL_ID AND tc.TEL_REVISADA = 1 )
                                INNER JOIN ( TC_ESTABLECIMIENTO e
                                    INNER JOIN ( TC_CLIENTE c ) ON ( c.CLI_ID = e.CLI_ID )
                                ) ON ( e.ETB_ID = tc.ETB_ID )";

                // Especialista solo puede ver TC revisadas y las de su especialidad
//                if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
//                    $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
//                }
            } else {
                $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                                INNER JOIN ( TC_CLIENTE c
                                    INNER JOIN ( TC_GRUPO_CLIENTE gc
                                        INNER JOIN ( TC_GRUPO g
                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID AND gu.USU_ID = " . $this->session->userdata('USU_ID'). " )
                                        ) ON ( g.GRU_ID = gc.GRU_ID )
                                    ) ON ( gc.CLI_ID = c.CLI_ID )
                                ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( tc.ETB_ID = e.ETB_ID ) ";
            }
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ) {
            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID AND u.USU_ID = " . $this->session->userdata('USU_ID'). " )
                            ) ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }
		
		$sql .= " LEFT JOIN TC_TELECONSULTA_CIE10_RESPUESTA cie10 ON tc.TEL_ID = cie10.TEL_ID LEFT JOIN TC_AFILIACION afi ON p.AFI_ID = afi.AFI_ID LEFT JOIN TC_MUNICIPIO_M m ON p.MUNI_ID = m.MUN_ID
LEFT JOIN TC_DEPARTAMENTO_D d ON m.DPTO_ID = d.DPTO_ID LEFT JOIN TC_ENTIDADES_ADMINISTRADORAS eadm ON p.EA_ID = eadm.ENTADM_CORR LEFT JOIN 
	(
		SELECT
			TEL_ID,
			USU_ID,
			TEP_FECHA_HORA
		FROM
			TC_TELECONSULTA_ESTADO
		WHERE
			LOCATE('Revisor', TEP_COMENTARIO)
		GROUP BY
			TEL_ID
	) tce_revisor ON tc.TEL_ID = tce_revisor.TEL_ID
	LEFT JOIN (
		TC_TELECONSULTA_ESTADO tce_generado
		INNER JOIN TC_USUARIO ug ON (
			ug.USU_ID = tce_generado.USU_ID
		)
	) ON (
		tce_generado.TEL_ID = tc.TEL_ID
		AND tce_generado.EST_ID = 1
	)
	LEFT JOIN TC_USUARIO urev ON tce_revisor.USU_ID = urev.USU_ID ";

        // Filtra TC's por site del usuario
        $sql .= "WHERE  tc.SIT_ID = ".$this->session->userdata('SIT_ID')." ";

        // Filtro Cliente (Querys necesitan de cruce con tc->especialidad)
        if ( !empty( $data['grupo'] ) )
            $sql .= "AND gc.GRU_ID = ".(int)$data['grupo']." ";

        // Filtro Cliente (Querys necesitan de cruce con tc->especialidad)
        if ( !empty( $data['cliente'] ) )
            $sql .= "AND e.CLI_ID = ".(int)$data['cliente']." ";

        // Filtro Establecimiento
        if ( !empty( $data['establ'] ) )
            $sql .= "AND tc.ETB_ID = ".(int)$data['establ']." ";

        // Filtro Especialidad
        if ( !empty( $data['especialidad'] ) )
            $sql .= "AND tc.ESP_ID = ".(int)$data['especialidad']." ";

        // Filtro por estados de la TC's
        if ( !empty( $data['estado'] ) )
            $sql .= "AND tc.EST_ID = ".(int)$data['estado']." ";

        // Filtro generalista que envió TC
        if ( !empty( $data['generalista'] ) )
            $sql .= "AND ( tce_enviado.USU_ID = ".$data['generalista'].") ";

        // Filtro especialita primera respuesta <-- ?
        if ( !empty( $data['especialista1'] ) )
            $sql .= "AND ( tce_solexam.USU_ID = ".$data['especialista1'].") ";

        // Filtro especialista2 <------- ?
        if ( !empty( $data['especialista2'] ) )
            $sql .= "AND ( tce_respuesta.USU_ID = ".$data['especialista2'].") ";

        
		// ---------------- FILTRO SEGUN ESTADO  //FFARIAS SI1434
		if ( !empty( $data['fecha_env_desde'] ) && !empty( $data['fecha_env_hasta'] )) {

		        switch( $data['estado'] ) {

                case 1 : // 1: borrador
					$sql .= " AND (tc.TEL_FECHA_HORA BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) "; break;
                case 2 : // 2: enviada
					$sql .= " AND (tc.TEL_FECHA_HORA_ENVIO BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) "; break;
                case 3 : // 3: rechazada
					$sql .= " AND (tc.TEL_FECHA_HORA_RECHAZO BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) "; break;
                case 4 : // 4: eliminada
					$sql .= " AND (tc.TEL_FECHA_HORA BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) "; break;
                case 5 : // 5: examen solicitado
					$sql .= " AND (tc.TEL_FECHA_HORA_REVISOR_SOLEXA BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' 
					OR 
					tc.TEL_FECHA_HORA_SOLEXA BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' 
					) ";
					break;
				case 6 : // 6: examen realizado
					$sql .= " AND (tc.TEL_FECHA_HORA_REVISOR_ENVIO BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) "; break;
				case 7 : // 7: contestada
					$sql .= " AND (tc.TEL_FECHA_HORA_RESPUESTA BETWEEN '".$data['fecha_env_desde']." 00:00:00' AND '".$data['fecha_env_hasta']." 23:59:59' ) "; break;
            }
		 } 
		
        $sql.= " GROUP BY tc.TEL_ID
                ORDER BY c.CLI_NOMBRE ASC, tc.TEL_ID DESC";

        $query = $this->db->query($sql);
		return $query;
    }
	
    /**
    * Busca una TC en especifico con el ID y el estado de esta,
    * recibiendo los datos por parametro.
    *
    * @access public
    * @param int $id ID de la TC
    * @param int $estado Estado de la TC
    * @return array Con todos los datos de la TC
    */
    public function busca_tc_estado($id, $estado)
    {
        $sql = "SELECT u.USU_NOMBRE, te.TEP_FECHA_HORA ";
        $sql .= "FROM TC_USUARIO AS u, TC_TELECONSULTA_ESTADO AS te ";
        $sql .= "WHERE te.TEL_ID = ".$id." ";
        $sql .= "AND te.EST_ID = ".$estado." ";
        $sql .= "AND u.USU_ID = te.USU_ID";
        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Busca una TC en especifico con el ID de esta
    * recibida por parametro.
    *
    * Query contiene DISTINCT porque hay casos en que el Supervisor|Especialista
    * puede estar asociado a dos grupos cuando estos dos grupos tienen asociados
    * a un mismo cliente
    *
    * @access public
    * @param int $id ID de la TC
    * @return array Con todos los datos de la TC
    */
    public function busca_tcid($id)
    {
        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO,
                        t.EST_ID, e.ETB_NOMBRE, es.ESP_NOMBRE, c.CLI_ID, c.CLI_NOMBRE ";

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( es.ESP_ID = t.ESP_ID ) ";
            $sql .= "WHERE  t.SIT_ID = " . $this->session->userdata('SIT_ID'). " ";
            $sql .= "AND    t.EST_ID <> 1  ";
        }

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {

                if( (int)$this->session->userdata('SIT_ID') == 22 ) {

                    $sql .= "FROM   TC_TELECONSULTA AS t
                                    INNER JOIN ( TC_ESPECIALIDAD es ) ON ( t.ESP_ID = es.ESP_ID )
                                    INNER JOIN ( TC_ESTABLECIMIENTO e
                                        INNER JOIN ( TC_CLIENTE c ) ON ( c.CLI_ID = e.CLI_ID )
                                    ) ON ( t.ETB_ID = e.ETB_ID )
                                    INNER JOIN ( TC_BOLSA_TELECONSULTA bt
                                                INNER JOIN ( TC_BOLSA_USUARIO bu ) ON ( bu.BOL_ID = bt.BOL_ID AND bu.USU_ID = ".(int)$this->session->userdata('USU_ID')." )
                                                INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID )
                                    ) ON ( bt.TEL_ID = t.TEL_ID )
                                    LEFT JOIN ( TC_USUARIO lck ) ON ( t.TEL_LOCK_OWNER = lck.USU_ID )
                            WHERE t.TEL_REVISADA = 1 ";

                    // Especialista solo puede ver TC revisadas y las de su especialidad
//                    if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
//                        $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
//                    }

                } else {

                    $sql .= "FROM   TC_TELECONSULTA AS t";
                    $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                                    INNER JOIN ( TC_CLIENTE c
                                                                    INNER JOIN ( TC_GRUPO_CLIENTE gc
                                                                                    INNER JOIN ( TC_GRUPO g
                                                                                                    INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
                                                                                    ) ON ( g.GRU_ID = gc.GRU_ID )
                                                                    ) ON ( gc.CLI_ID = c.CLI_ID )
                                                    ) ON ( c.CLI_ID = e.CLI_ID )
                                    ) ON ( t.ETB_ID = e.ETB_ID )
                                    INNER JOIN ( TC_ESPECIALIDAD es ) ON ( es.ESP_ID = t.ESP_ID ) ";

                    $sql .= "WHERE  gu.USU_ID = " . $this->session->userdata('USU_ID'). " ";
                    $sql .= "AND    t.EST_ID <> 4 ";
                }
        }

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {

            $sql .= "FROM   TC_TELECONSULTA AS t";
            $sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
                                            INNER JOIN ( TC_CLIENTE c
                                                            INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID )
                                            ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( t.ETB_ID = e.ETB_ID ) ";
            $sql .= "       INNER JOIN ( TC_ESPECIALIDAD es ) ON ( es.ESP_ID = t.ESP_ID ) ";
            $sql .= "WHERE  u.USU_ID = " . $this->session->userdata('USU_ID'). " ";
            $sql .= "AND    t.EST_ID <> 4 ";
        }

        if ( !empty( $id ) )
            $sql .= " AND t.TEL_ID = ".$id." ";

        // Descarta TC en estado "Borrador"
        $sql .= "AND t.EST_ID <> 1 ";
        $sql .= "GROUP BY t.TEL_ID ";

        $sql .= "ORDER BY t.PRI_ID ASC ";
        $dat['sqlsearch'] = $sql;
        $query = $this->db->query($sql);
        $dat['tc_cantidad'] = $query->num_rows();
//        $this->session->set_userdata($dat);
         if ($dat['tc_cantidad'] > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
     * Obtiene listado de Teleconsultas
     */
    public function busca_tc_na_paciente( $site, $nombre = '', $apellido = '' ) {

        // Retorna listado vacío si se intenta realizar listado sin nombre ni apellidos
        if( empty( $nombre ) && empty( $apellido ) ) return array();

        $sql = "SELECT    tc.TEL_ID, pi.PAC_IDT_VALOR, tc.EST_ID,
                        tc.TEL_PAC_PRIMER_NOMBRE, tc.TEL_PAC_PRIMER_APELLIDO, tc.TEL_PAC_SEGUNDO_APELLIDO,
                        e.ETB_NOMBRE,
                        c.CLI_ID, c.CLI_NOMBRE,
                        es.ESP_NOMBRE,
                        min( tce_enviado.TEP_FECHA_HORA ) as hora_envio,
                        min( tce_solexam.TEP_FECHA_HORA ) as hora_solexam,
                        min( tce_respuesta.TEP_FECHA_HORA ) as hora_respuesta,
                        ur.USU_NOMBRE as usu_especialista

                    FROM TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )
                        INNER JOIN TC_ESPECIALIDAD es ON ( es.ESP_ID = tc.ESP_ID )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_enviado ) ON ( tce_enviado.TEL_ID = tc.TEL_ID AND tce_enviado.EST_ID = 2 )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_solexam ) ON ( tce_solexam.TEL_ID = tc.TEL_ID AND tce_solexam.EST_ID = 5 )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_respuesta
                            INNER JOIN TC_USUARIO ur ON ( ur.USU_ID = tce_respuesta.USU_ID )
                        ) ON ( tce_respuesta.TEL_ID = tc.TEL_ID AND tce_respuesta.EST_ID = 7 ) ";

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }

        if( $this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $sql .= "       INNER JOIN ( TC_BOLSA_TELECONSULTA bt
                                            INNER JOIN ( TC_BOLSA_USUARIO bu ) ON ( bu.BOL_ID = bt.BOL_ID AND bu.USU_ID = ".(int)$this->session->userdata('USU_ID')." )
                                            INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID )
                                ) ON ( bt.TEL_ID = tc.TEL_ID AND tc.TEL_REVISADA = 1 )
                                INNER JOIN ( TC_ESTABLECIMIENTO e
                                    INNER JOIN ( TC_CLIENTE c ) ON ( c.CLI_ID = e.CLI_ID )
                                ) ON ( e.ETB_ID = tc.ETB_ID )";

                // Especialista solo puede ver TC revisadas y las de su especialidad
//                if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
//                    $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
//                }
            } else {
                $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                                INNER JOIN ( TC_CLIENTE c
                                    INNER JOIN ( TC_GRUPO_CLIENTE gc
                                        INNER JOIN ( TC_GRUPO g
                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID AND gu.USU_ID = " . $this->session->userdata('USU_ID'). " )
                                        ) ON ( g.GRU_ID = gc.GRU_ID )
                                    ) ON ( gc.CLI_ID = c.CLI_ID )
                                ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( tc.ETB_ID = e.ETB_ID ) ";
            }
        }

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {
            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID AND u.USU_ID = " . $this->session->userdata('USU_ID'). " )
                            ) ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }

        $sql_array = array();
        if( !empty( $nombre ) )
            $sql_array[] = "tc.TEL_PAC_PRIMER_NOMBRE LIKE '%".$nombre."%' ";
        if( !empty( $apellido ) )
            $sql_array[] = "tc.TEL_PAC_PRIMER_APELLIDO LIKE '%".$apellido."%' ";

        $sql.=" WHERE ". implode( ' AND ', $sql_array );

        // Descarta examenes en estado borrador, rechazados y eliminados
        $sql.= " AND tc.EST_ID <> 1 AND tc.EST_ID <> 3 AND tc.EST_ID <> 4 ";
        $sql.= " GROUP BY tc.TEL_ID
                 ORDER BY tc.TEL_ID DESC";

        $query = $this->db->query( $sql );

        if( $query->num_rows() > 0 )
            return $query->result_array( );
        else
            return NULL;
    }

    /**
     * Obtiene listado de Teleconsultas
     */
    public function busca_tc_id_paciente( $idt_paciente, $id_site = NULL ) {

        $sql = "SELECT    tc.TEL_ID, pi.PAC_IDT_VALOR, tc.EST_ID,
                        tc.TEL_PAC_PRIMER_NOMBRE, tc.TEL_PAC_PRIMER_APELLIDO, tc.TEL_PAC_SEGUNDO_APELLIDO, tc.TEL_PAC_EDAD, tc.TEL_PAC_SEXO,
                        e.ETB_NOMBRE,
                        c.CLI_ID, c.CLI_NOMBRE,
                        es.ESP_NOMBRE,
                        min( tce_enviado.TEP_FECHA_HORA ) as hora_envio,
                        min( tce_solexam.TEP_FECHA_HORA ) as hora_solexam,
                        min( tce_respuesta.TEP_FECHA_HORA ) as hora_respuesta,
                        ur.USU_NOMBRE as usu_especialista ";

        $sql.="FROM TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )
                        INNER JOIN TC_ESPECIALIDAD es ON ( es.ESP_ID = tc.ESP_ID )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_enviado ) ON ( tce_enviado.TEL_ID = tc.TEL_ID AND tce_enviado.EST_ID = 2 )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_solexam ) ON ( tce_solexam.TEL_ID = tc.TEL_ID AND tce_solexam.EST_ID = 5 )
                        LEFT JOIN ( TC_TELECONSULTA_ESTADO tce_respuesta
                            INNER JOIN TC_USUARIO ur ON ( ur.USU_ID = tce_respuesta.USU_ID )
                        ) ON ( tce_respuesta.TEL_ID = tc.TEL_ID AND tce_respuesta.EST_ID = 7 ) ";

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ADMIN'] ) {

            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['SUPERVISOR'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {

            if( $this->session->userdata('SIT_ID') == 22 ) {
                $sql .= "       INNER JOIN ( TC_BOLSA_TELECONSULTA bt
                                            INNER JOIN ( TC_BOLSA_USUARIO bu ) ON ( bu.BOL_ID = bt.BOL_ID AND bu.USU_ID = ".(int)$this->session->userdata('USU_ID')." )
                                            INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID )
                                ) ON ( bt.TEL_ID = tc.TEL_ID AND tc.TEL_REVISADA = 1 )
                                INNER JOIN ( TC_ESTABLECIMIENTO e
                                    INNER JOIN ( TC_CLIENTE c ) ON ( c.CLI_ID = e.CLI_ID )
                                ) ON ( e.ETB_ID = tc.ETB_ID )";

                // Especialista solo puede ver TC revisadas y las de su especialidad
//                if( $this->session->userdata('ROL_ID') == Platc::$ROL['ESPECIALISTA'] ) {
//                    $sql .= " " . $this->sql_usu_especialdiades_tc( $this->session->userdata('USU_ID'), FALSE ). ' ';
//                }
            } else {
                $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                                INNER JOIN ( TC_CLIENTE c
                                    INNER JOIN ( TC_GRUPO_CLIENTE gc
                                        INNER JOIN ( TC_GRUPO g
                                            INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID AND gu.USU_ID = " . $this->session->userdata('USU_ID'). ")
                                        ) ON ( g.GRU_ID = gc.GRU_ID )
                                    ) ON ( gc.CLI_ID = c.CLI_ID )
                                ) ON ( c.CLI_ID = e.CLI_ID )
                            ) ON ( tc.ETB_ID = e.ETB_ID ) ";
            }
        }

        if( (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_GENERAL'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'] ||
            (int)$this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_REVISOR'] ) {
            $sql .= "   INNER JOIN ( TC_ESTABLECIMIENTO e
                            INNER JOIN ( TC_CLIENTE c
                                INNER JOIN TC_USUARIO u ON ( c.CLI_ID = u.CLI_ID AND u.USU_ID = " . $this->session->userdata('USU_ID'). " )
                            ) ON ( c.CLI_ID = e.CLI_ID )
                        ) ON ( tc.ETB_ID = e.ETB_ID ) ";
        }

        // Descarta examenes en estado borrador, rechazados y eliminados
        $sql .= " WHERE tc.EST_ID <> 1 AND tc.EST_ID <> 3 AND tc.EST_ID <> 4 ";

        // Filtra por identificador de paciente
        $sql.=" AND pi.PAC_IDT_VALOR = '".$idt_paciente."' ";

        // Filtra por site de la TC
        if( !empty( $id_site ) )
            $sql.=" AND tc.SIT_ID = ".$id_site;

        //
        $sql.= " GROUP BY tc.TEL_ID
                 ORDER BY tc.TEL_ID DESC";

        $query = $this->db->query( $sql );

        if( $query->num_rows() > 0 )
            return $query->result_array( );
        else
            return NULL;
    }

    /**
    * Inserta un nuevo reporte en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return int Con el ID del reporte insertado
    */
    public function reporte_set($data)
    {
        $this->db->insert('TC_REPORTE', $data);
        return $this->db->insert_id();
    }

    /**
    * Inserta el detalle del reporte en la db,
    * recibiendo los datos en un arreglo pasado por parametro.
    *
    * @access public
    * @param array $data Arreglo con todos los datos para el nuevo insert
    * @return none
    */
    public function reporte_detalle_set($data)
    {
        $this->db->insert('TC_REPORTE_DETALLE', $data);
    }

    /**
     * Genera listado de reporte para estadísticas.
     * Campos de diagnósticos CIE10 se entregan tal cual está en base de datos
     * (codificados en json usando identificadores)
     *
     * Entrega los siguientes campos
     * a. ID TC
     * b. Establecimiento
     * c. ID Paciente
     * d. Nombre y apellido del paciente
     * e. Fecha Hora contestada
     * f. Motivo de TC
     * g. Diagnostico presuntivo principal (el que define el medico del cliente)
     * h. Diagnostico definitivo principal (el que define el especialista)
     * i. Especialista que contesto
     * j. Medico que envía
     *
     * @param int $id_site Identificador del site sobre la cual obtener listado
     * @param date $fecha_ini Fecha de inicio del reporte
     * @param date $fecha_fin Fecha de término del reporte. Si no se establece se busca todas las TC hasta la fecha
     * @param int $cliente Identificador del cliente. Si no se establece busca todos los clientes desde la fecha de inicio
     */
    public function reporte_estadisticas( $id_site, $fecha_ini, $fecha_fin = NULL, $cliente = NULL ) {

        $sql = "SELECT  -- ID TC
                        t.TEL_ID,

                        -- Nombre del Establecimiento
                        e.ETB_NOMBRE,

                        -- Tipo de identificador del paciente
                        -- i.TIPO_IDENTIFICADOR

                        -- Valor del identificador del paciente
                        pi.PAC_IDT_VALOR,

                        -- Nombre y apellido del paciente
                        p.PAC_PRIMER_NOMBRE,
                        -- p.PAC_SEGUNDO_NOMBRE,
                        p.PAC_PRIMER_APELLIDO,
                        -- p.PAC_SEGUNDO_APELLIDO

                        -- Fecha y hora respondida
                        date_format( te_r.TEP_FECHA_HORA, '%H:%i:%s %d-%m-%Y' ) as fecha_contestada,

                        -- Motivo de la TC
                        case when td_m.TD_VALOR is null then t.TEL_MOTIVO else td_m.TD_VALOR end as motivo_de_tc,

                        -- Diagnóstico presuntivo
                        td_dp.TD_VALOR as diag_generalista,

                        -- Diagnóstico definitivo
                        tc_cie10_r.TEL_CIE_ID_RESPUESTA as diag_especialista,

                        -- Especialista que responde
                        u_e.USU_NOMBRE as especialista_nombre,

                        -- Médico que envía
                        u_m.USU_NOMBRE as generalista_nombre,

                        -- No usar = Ultimo especialista que envía: descarta flujo rechazo, desrechazo
                        max( te_e.TEP_FECHA_HORA )

                FROM     TC_TELECONSULTA t

                    -- Asocia Establecimientos
                    INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID )

                    -- Asocia paciente
                    INNER JOIN ( TC_PACIENTE p
                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                            -- INNER JOIN TC_IDENTIFICADOR i ON ( i.IDT_ID = pi.IDT_ID )
                        ) ON ( pi.PAC_ID = p.PAC_ID )
                    ) ON ( p.PAC_ID = t.PAC_ID )

                    -- Asocia motivo de consulta
                    LEFT JOIN TC_TELECONSULTA_DATA td_m ON ( td_m.TEL_ID = t.TEL_ID AND td_m.TD_CLAVE = 'tc_motivo_teleconsulta' )

                    -- Asocia diagnóstico presuntivo: lo ingresa generalista al crear TC
                    LEFT JOIN  TC_TELECONSULTA_DATA td_dp ON ( td_dp.TEL_ID = t.TEL_ID AND td_dp.TD_CLAVE = 'dm_general' )

                    -- Asocia diagnostico definitivo: lo ingresa especialista al responder finalmente la TC
                    LEFT JOIN TC_TELECONSULTA_CIE10_RESPUESTA tc_cie10_r ON ( tc_cie10_r.TEL_ID = t.TEL_ID )

                    -- Asocia médico especialista que responde TC, si existe
                    LEFT JOIN ( TC_TELECONSULTA_ESTADO te_r
                        INNER JOIN TC_USUARIO u_e ON ( u_e.USU_ID = te_r.USU_ID )
                    ) ON ( te_r.TEL_ID = t.TEL_ID AND te_r.EST_ID = 7 )

                    -- Asocia médico generalista que envía(nueva) TC
                    INNER JOIN ( TC_TELECONSULTA_ESTADO te_e
                        INNER JOIN TC_USUARIO u_m ON ( u_m.USU_ID = te_e.USU_ID )
                    ) ON ( te_e.TEL_ID = t.TEL_ID AND te_e.EST_ID = 2 )";

            /*
				JV: ZOHO SI834
			*/
			if( !empty( $fecha_fin ) )
				$sql.= "WHERE   te_e.TEP_FECHA_HORA BETWEEN str_to_date( '" . $fecha_ini . " 00:00:00', '%d/%m/%Y %H:%i:%s' ) and str_to_date( '" . $fecha_fin . " 23:59:59', '%d/%m/%Y %H:%i:%s' )";
			else
				$sql.= "WHERE te_e.TEP_FECHA_HORA >= str_to_date( '".$fecha_ini." 00:00:00', '%d/%m/%Y %H:%i:%s' )";
			/*
				JV: FIN ZOHO SI834
			*/

            // Filtro por cliente
            if( !empty( $cliente ) )
                $sql.=" AND e.CLI_ID = " . (int)$cliente. " ";

            $sql.=" AND t.SIT_ID = " . (int)$id_site ;

            $sql.= " GROUP BY t.TEL_ID;";

        $query = $this->db->query( $sql );

        return $query->result_array();
    }

    /**
     *
     */
    public function reporte_tiempos_respuestas( $id_site, $fecha_ini, $fecha_fin = NULL, $cliente = NULL ) {
		/*
			JV: ZOHO SI834
		*/
        $sql = "SELECT     /* ID TC*/
                        t.TEL_ID,

                        /* Nombre del Establecimiento*/
                        e.ETB_NOMBRE,

                        /* Nombre y apellido del paciente*/
                        p.PAC_PRIMER_NOMBRE,
                        /* p.PAC_SEGUNDO_NOMBRE,*/
                        p.PAC_PRIMER_APELLIDO,
                        /* p.PAC_SEGUNDO_APELLIDO*/

                        /* Fecha y hora generacion (envio/nuevo) de TC*/
                        date_format( t.TEL_FECHA_HORA_ENVIO, '%H:%i:%s %d-%m-%Y' ) as TEL_FECHA_HORA_ENVIO,

                        /* Fecha y hora revisor (envio/nuevo) de TC*/
                        date_format( t.TEL_FECHA_HORA_REVISOR_ENVIO, '%H:%i:%s %d-%m-%Y' ) as TEL_FECHA_HORA_REVISOR_ENVIO,

                        /* Fecha y hora respondida*/
                        date_format( t.TEL_FECHA_HORA_RESPUESTA, '%H:%i:%s %d-%m-%Y' ) as TEL_FECHA_HORA_RESPUESTA

                FROM     TC_TELECONSULTA t

                        /* Asocia Establecimientos*/
                        INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID )

                        /* Asocia paciente*/
                        INNER JOIN ( TC_PACIENTE p
                            INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi ) ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = t.PAC_ID )";

           
			if( !empty( $fecha_fin ) )
				$sql.= " WHERE   t.TEL_FECHA_HORA_RESPUESTA BETWEEN str_to_date( '" . $fecha_ini . " 00:00:00', '%d/%m/%Y %H:%i:%s' ) and str_to_date( '" . $fecha_fin . " 23:59:59', '%d/%m/%Y %H:%i:%s' )";
			else
				$sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA >= str_to_date( '".$fecha_ini." 00:00:00', '%d/%m/%Y %H:%i:%s' )";
			/*
				JV: FIN ZOHO SI834 
			*/

            // Filtro por cliente
            if( !empty( $cliente ) )
                $sql.=" AND e.CLI_ID = " . (int)$cliente. " ";

            $sql.= " /* Obtiene solo TC's contestadas*/
                        AND t.EST_ID = 7";
			$sql.=" AND t.SIT_ID = " . (int)$id_site;

        $query = $this->db->query( $sql );

        return $query->result_array();
    }

    /**
    * Campos RIPS: Entidades administradoras
    * Obtiene listado de entidades administradoras
    *
    * @access public
    * @return array Arreglo con los datos de las entidades administradoras
    */
    public function entidades_administradoras_get($ids = '')
    {
        $this->db->order_by( 'ENTADM_NOMBRE' );
		if($ids && is_array($ids)) $this->db->where_in('ENTADM_ID',$ids);
        $query = $this->db->get('TC_ENTIDADES_ADMINISTRADORAS');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Campos RIPS: Entidades administradoras
    * Obtiene un solo registro de entidad administradora
    *
    * @access public
    * @return array Arreglo con los datos de la entidad administradora
    */
    public function entidad_administradora_get( $entadm_id )
    {
        $query = $this->db->get_where('TC_ENTIDADES_ADMINISTRADORAS', array( 'ENTADM_ID' => $entadm_id ) );
        if ($query->num_rows() > 0)
            return $query->row_array();
        else
            return NULL;
    }

    public function entidades_administradoras__con_codigo_get($ids = '') {
        $entidades = $this->entidades_administradoras_get($ids);
        $listado_entidades = array( );
        foreach( $entidades as $v )
            $listado_entidades[] = array( 'ENTADM_ID' => $v['ENTADM_ID'], 'ENTADM_NOMBRE' => $v['ENTADM_NOMBRE'] . ' ['.$v['ENTADM_ID'].'] ');

        return $listado_entidades;
    }

    /**
    * Campos RIPS: Finalidad procedimiento
    * Obtiene listado de finalidad de procedimientos
    *
    * @access public
    * @return array Arreglo con los datos de procedimientos
    */
    public function finalidad_procedimiento_get( )
    {
        $this->db->order_by( 'FINPROC_PREDETERMINADO', 'DESC' );
        $this->db->order_by( 'FINPROC_DESCRIPCION' );
        $query = $this->db->get('TC_FINALIDAD_PROCEDIMIENTO');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Campos RIPS: Municipio
    * Obtiene listado de municipalidades
    *
    * @access public
    * @return array Arreglo con los datos de municipios
    */
    public function municipios_get($ids = '')
    {
        $this->db->order_by( 'MUNI_NOMBRE' );
		if($ids && is_array($ids)) $this->db->where_in('MUNI_ID',$ids);
		$this->db->select("TC_MUNICIPIO.*, CONCAT(MUNI_NOMBRE,' (',DEPTO_NOMBRE,')') AS MUNI_NOMBRECOMPLETO",FALSE);
        $query = $this->db->get('TC_MUNICIPIO');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Campos RIPS: Municipio
    * Obtiene listado de municipalidades
    *
    * @access public
    * @return array Arreglo con los datos de municipios
    */
    public function municipio_get( $muni_id )
    {
        $query = $this->db->get_where('TC_MUNICIPIO', array( 'MUNI_ID' => $muni_id ) );
        if ($query->num_rows() > 0)
            return $query->row_array();
        else
            return NULL;
    }

    public function municipio_busqueda_por_texto( $texto = NULL ) {

        if( !empty( $texto ) ) {

            $sql = "SELECT  MUNI_ID, MUNI_NOMBRE
                    FROM    TC_MUNICIPIO
                    WHERE   MUNI_NOMBRE like '%" . $texto . "%' ";
            $query = $this->db->query( $sql );

            return $query->result_array( );

        } else
            return NULL;
    }

    /**
    * Campos RIPS: Ambitos de procedimiento
    * Obtiene listado de ambitos de procedimiento
    *
    * @access public
    * @return array Arreglo con los datos de ambitos de procedimiento
    */
    public function ambito_procedimiento_get($ids = '')
    {
        $this->db->order_by( 'AMBPROC_DESCRIPCION' );
		if($ids && is_array($ids)) $this->db->where_in('AMBPROC_ID',$ids);
        $query = $this->db->get('TC_AMBITO_PROCEDIMIENTO');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Campos RIPS: Zona residencia
    * Obtiene listado de zona de residencia
    * Actualmente dos valores: Urbano y Rural
    * @access public
    * @return array Arreglo con los datos de zona de residencia
     */
    public function zona_residencia_get( ) {

        $query = $this->db->get('TC_ZONA_RESIDENCIA');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
    * Obtiene un reporte en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del reporte
    * @return array Arreglo con los datos del reporte
    */
    public function reporte_get($id)
    {
        $this->db->where('REP_ID', $id);
        $query = $this->db->get('TC_REPORTE');
        if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;
    }

    /**
    * Obtiene el detalle de un reporte en especifico,
    * segun el ID recibido por parametro.
    *
    * @access public
    * @param int $id ID del reporte
    * @return array Arreglo con los datos del detalle del reporte
    */
    public function reporte_detalle_get($id)
    {
        $this->db->where('REP_ID', $id);
        $query = $this->db->get('TC_REPORTE_DETALLE');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    /**
     *
     */
    public function reporte_usuarios_del_servicio( $fecha_ini, $fecha_fin = null, $id_cliente = NULL ) {

        $sql = "SELECT  tc.TEL_ID, i.TIPO_IDENTIFICACION, pi.PAC_IDT_VALOR,
                        tc.ENTADM_ID, a.ID_PACIENTE_TIPO as ID_PACIENTE_TIPO,
                        tc.TEL_PAC_PRIMER_APELLIDO, tc.TEL_PAC_SEGUNDO_APELLIDO, tc.TEL_PAC_PRIMER_NOMBRE, tc.TEL_PAC_SEGUNDO_NOMBRE,
                        tc.TEL_PAC_EDAD, 1 AS UNIDAD_ANOS, tc.TEL_PAC_SEXO,
                        m.DEPTO_CODIGO, m.MUNI_CODIGO, tc.ZON_ID

                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                                                        INNER JOIN TC_IDENTIFICADOR i ON (i.IDT_ID = pi.IDT_ID )
                                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )";

        $sql.= "    INNER JOIN ( TC_ESTABLECIMIENTO e ";

//        if( !empty( $id_cliente ) )
//            $sql.=" INNER JOIN TC_CLIENTE c ON ( c.CLI_ID = e.CLI_ID ) ";

        $sql.= "    LEFT JOIN TC_MUNICIPIO m ON ( m.MUNI_ID = e.MUNI_ID )
                ) ON ( e.ETB_ID = tc.ETB_ID )
                LEFT JOIN TC_AFILIACION a ON ( a.AFI_ID = tc.AFI_ID ) ";
		/*
			JV: ZOHO SI834
		*/
        if( !empty( $fecha_fin ) )
            $sql.= "WHERE tc.TEL_FECHA_HORA BETWEEN str_to_date( '" . $fecha_ini . " 00:00:00', '%d/%m/%Y %H:%i:%s' ) and str_to_date( '" . $fecha_fin . " 23:59:59', '%d/%m/%Y %H:%i:%s' )";
		else
			$sql.= "WHERE tc.TEL_FECHA_HORA >= str_to_date( '".$fecha_ini." 00:00:00', '%d/%m/%Y %H:%i:%s' )";

        /*
			JV: FIN ZOHO SI834
		*/
		
		if( !empty( $id_cliente ) )
            $sql.= "    AND e.CLI_ID = '". $id_cliente . "' ";

        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0 ) {
            return $query->result_array();
        } else
            return NULL;
    }

    /**
     *
     */
    public function reporte_archivo_consulta( $fecha_ini, $fecha_fin = null, $id_cliente = NULL ) {
//imprimir( func_get_args(), false );
        $sql = "SELECT  i.TIPO_IDENTIFICACION, pi.PAC_IDT_VALOR,
                        date_format( tc.TEL_FECHA_HORA, '%d/%m/%Y %H:%i:%s' ) as TEL_FECHA_HORA, tc.TEL_CODIGO_AUTORIZACION,
                        tc.TEL_ID, tc.FINPROC_ID

                FROM    TC_TELECONSULTA tc
                        INNER JOIN ( TC_PACIENTE p
                                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                                                        INNER JOIN TC_IDENTIFICADOR i ON (i.IDT_ID = pi.IDT_ID )
                                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        ) ON ( p.PAC_ID = tc.PAC_ID )

                        INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = tc.ETB_ID )
                        INNER JOIN TC_TELECONSULTA_ESTADO te ON ( te.TEL_ID = tc.TEL_ID AND te.EST_ID = 7 ) ";

        /*
			JV: ZOHO SI834
		*/
		if( !empty( $fecha_fin ) )
            $sql.= "WHERE   te.TEP_FECHA_HORA BETWEEN str_to_date( '" . $fecha_ini . " 00:00:00', '%d/%m/%Y %H:%i:%s' ) and str_to_date( '" . $fecha_fin . " 23:59:59', '%d/%m/%Y %H:%i:%s' )";
		else
			$sql.= "WHERE te.TEP_FECHA_HORA >= str_to_date( '".$fecha_ini." 00:00:00', '%d/%m/%Y %H:%i:%s' )";
		/*
			JV: FIN ZOHO SI834 
		*/
		
        if( !empty( $id_cliente ) )
            $sql.= "    AND e.CLI_ID = '". $id_cliente . "' ";
//imprimir( $sql );
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0 ) {
            return $query->result_array();
        } else
            return NULL;
    }

    public function tc_agregar_data( $id_teleconsulta, $data ) {

        $bulk_data = array( );
        if( !empty( $data ) ) {
            foreach( $data as $key => $value  ) {
                $d = array( );
                $d['TEL_ID']    = $id_teleconsulta;
                $d['TD_CLAVE']  = $key;
                $d['TD_VALOR']  = $value;

                $bulk_data[] = $d;
            }
            return $this->db->insert_batch( 'TC_TELECONSULTA_DATA', $bulk_data );
        }
    }

    /*
     * No borrar, lógica que valida si la data ingresada es la viene por $_POST
     * llamado desde <i>tc_crea</i> y <i>tc_borrador_edita</i>
     */
    public function tc_comprobar_data( $id_teleconsulta, $data ) {

        $q = $this->db->get_where( 'TC_TELECONSULTA_DATA', array( 'TEL_ID' => $id_teleconsulta ) );
        if( $q->num_rows() > 0 ) {

            $d_b = $this->util->select_form_prepare( $q->result_array(), 'TD_CLAVE', 'TD_VALOR' );
            unset( $d_b[''] );

            foreach( $data as $k => $v )
                if( !array_key_exists( $k, $d_b ) )
                    return FALSE;
        }

        return TRUE;
    }

    public function tc_obtener_data( $id_teleconsulta ) {

        $this->db->where( 'TEL_ID', $id_teleconsulta );
        $query = $this->db->get( 'TC_TELECONSULTA_DATA' );
        if( $query->num_rows() > 0 ) {

            $data = array( );
            foreach( $query->result_array( ) as $v ) {
				//SI641
				//se limpia el valor enviado
				$data[ $v['TD_CLAVE'] ] = trim($v['TD_VALOR']);
            }

            return $data;
        }
        else
            return NULL;
    }

    public function tc_borrar_data( $id_teleconsulta ) {

        $this->db->where( 'TEL_ID', $id_teleconsulta );
        $query = $this->db->delete( 'TC_TELECONSULTA_DATA' );

        return TRUE;
    }

    /**
     *  Obtiene listado de códigos CIE10
     * @param array $datos listado con identificadores de diagnósticos médicos que se quiere obtener su descripcion
     *                  así es usado al obtener diagnósticos en formularios de lectura.
     *                  Si $datos es vacío se carga listado completo de los diagnosticos.
     * @return array    Listado de diagnósticos médicos según parámetros otorgados
     */
    public function cie10_get( $datos ) {

        if( empty( $datos ) ) return null;

        $this->db->select( "CIE_ID, id10, dec10, descripcion" )->from('TC_CIE10');
        $this->db->where_in( 'CIE_ID', $datos );

        $query = $this->db->get( );
		
        if( $query->num_rows() > 0 )
            return $query->result_array( );
        else
            return null;
    }

    public function diagnosticos_medicos_busqueda_por_texto( $site, $texto = NULL ) {

        if( !empty( $texto ) ) {

            $sql = "SELECT  CIE_ID, id10, descripcion
                    FROM    TC_CIE10
                    WHERE   descripcion like '%" . $texto . "%'
                        AND SIT_ID = " . $site . "
                        AND CIE_ACTIVO = 1";
            $query = $this->db->query( $sql );

            return $query->result_array( );

        } else
            return NULL;
    }

    /**
     * Obtiene el nombre de archivo del formulario asociado a la TC
     * Usado en libreria FormularioXML
     *
     * @param int $id_teleconsulta Identificador de la TC
     * @return string nombre del formulario asociado a la TC
     */
    public function tc_obtener_formulario( $id_teleconsulta ) {

        $this->db->select( 'e.ESP_ARCHIVO_FORMULARIO' );
        $this->db->from( 'TC_TELECONSULTA t' );
        $this->db->join( 'TC_ESPECIALIDAD e', ' e.ESP_ID = t.ESP_ID ' );
        $this->db->where( 't.TEL_ID', $id_teleconsulta );
        $query = $this->db->get( );

        if( $query->num_rows( ) > 0 ) {
            $archivo = $query->row_array( );
            return $archivo[ 'ESP_ARCHIVO_FORMULARIO' ];
        }

        return NULL;
    }

    public function obtener_valores( $tabla, $campo_clave, $campo_valor, $datos, $id_site ) {

        $this->db->select( $campo_clave.', '.$campo_valor );
        $this->db->from( $tabla );
        $this->db->where_in( $campo_clave, $datos );

        if( !empty( $id_site ) ) $this->db->where( array( 'SIT_ID' => $id_site ) );

        $query = $this->db->get( );

        $campos = null;
        if( $query->num_rows( ) > 0 )
            foreach( $query->result_array( ) as $valor )
                $campos[ $valor[$campo_clave] ] = $valor[$campo_valor];

        return $campos;
    }

    /**
     *
     */
    public function obtener_agendas( $id_site ) {

        $this->db->join( 'TC_USUARIO u', 'u.USU_ID = ad.USU_ID');
        $agendas = $this->db->get_where( 'TC_AGENDA_DEF ad', array( 'ad.SIT_ID' => $id_site ) );
        return $agendas->result_array();
    }

    /**
     *
     */
    public function agenda_agregar( $fecha_inicio, $fecha_fin, $hora_inicio, $hora_fin, $intervalo, $descripcion, $site, $especialista ) {

        $data['AGEDEF_FECHA_INI']   = $fecha_inicio;
        $data['AGEDEF_FECHA_FIN']   = $fecha_fin;
        $data['AGEDEF_HORA_INICIO'] = $hora_inicio;
        $data['AGEDEF_HORA_FIN']    = $hora_fin;
        $data['AGEDEF_INTERVALO']   = $intervalo;
        $data['AGEDEF_DESCRIPCION'] = $descripcion;
        $data['SIT_ID']         = $site;
        $data['USU_ID']         = $especialista;

        $id = $this->db->insert( 'TC_AGENDA_DEF', $data );

        if( !empty( $id ) )
            return $id;
        else
            return FALSE;
    }

    public function agenda_get( $id_agenda ) {

        $query = $this->db->get_where( 'TC_AGENDA_DEF', array( 'AGEDEF_ID' => $id_agenda ) );

        return $query->row_array( );
    }

    public function agenda_editar( $id_agenda, $fecha_inicio, $fecha_fin, $hora_inicio, $hora_fin, $intervalo, $especialista, $descripcion, $site ) {

        $data['AGEDEF_FECHA_INI']   = $fecha_inicio;
        $data['AGEDEF_FECHA_FIN']   = $fecha_fin;
        $data['AGEDEF_HORA_INICIO'] = $hora_inicio;
        $data['AGEDEF_HORA_FIN']    = $hora_fin;
        $data['AGEDEF_INTERVALO']   = $intervalo;
        $data['USU_ID']             = $especialista;
        $data['AGEDEF_DESCRIPCION'] = $descripcion;
        $data['SIT_ID']         = $site;

        $this->db->where( 'AGEDEF_ID', $id_agenda );
        return $this->db->update( 'TC_AGENDA_DEF', $data );
    }

    public function agenda_bloqueo_get( $id_agenda ) {

        $query = $this->db->get_where( 'TC_AGENDA_BLOQUEO', array( 'AGEDEF_ID' => $id_agenda ) );

        return $query->row_array( );
    }

    public function agenda_bloqueos_get( $id_agenda ) {

        $query = $this->db->get_where( 'TC_AGENDA_BLOQUEO', array( 'AGEDEF_ID' => $id_agenda ) );

        return $query->result_array( );
    }

    public function agenda_agregar_bloqueo( $id_agenda, $bloqueo_dias = array( ), $bloqueo_horas = array( ) ) {

        $data['AGEDEF_ID']      = $id_agenda;
        $data['AGEBLO_DIAS']    = implode( ',', ( !empty( $bloqueo_dias ) ? $bloqueo_dias : array( ) ) );
        $data['AGEBLO_HORAS']   = implode( ',', ( !empty( $bloqueo_horas ) ? $bloqueo_horas : array( ) ) );

        $estado = $this->db->insert( 'TC_AGENDA_BLOQUEO', $data );
        return $estado;
    }

    public function agenda_agregar_bloqueo_por_fecha( $id_agenda, $bloqueo_por_fecha ) {

        $data['AGEDEF_ID']      = $id_agenda;
        $data['AGEBLO_FECHA']   = $bloqueo_por_fecha;

        $estado = $this->db->insert( 'TC_AGENDA_BLOQUEO', $data );
        return $estado;
    }

    public function agenda_eliminar( $id_agenda ) {
        if ( $this->existe_registro('TC_AGENDA_DEF', 'AGEDEF_ID', $id_agenda ) ) {
            $this->db->delete( 'TC_AGENDA_BLOQUEO', array( 'AGEDEF_ID' => $id_agenda ) );
            $this->db->delete( 'TC_AGENDA_DEF', array( 'AGEDEF_ID' => $id_agenda ) );
            return TRUE;
        }
    }

    public function agenda_bloqueo_eliminar( $id_bloqueo_agenda ) {

        if ( $this->existe_registro('TC_AGENDA_BLOQUEO', 'AGEBLO_ID', $id_bloqueo_agenda ) ) {
            $this->db->delete( 'TC_AGENDA_BLOQUEO', array( 'AGEBLO_ID' => $id_bloqueo_agenda ) );
            return TRUE;
        }
        return FALSE;
    }

    public function agendamiento_comprobar_estado_contraparte( $id_agenda, $id_rol ) {

        $estado = false;
        $columna = ( $id_rol == Platc::$ROL['MEDICO_GENERAL'] ) ? 'AGESES_ID_GENERALISTA' : 'AGESES_ID_ESPECIALISTA';

        $query = $this->db->select( $columna )->get_where( 'TC_AGENDA', array( 'AGE_ID' => $id_agenda ) );
        if( $query->num_rows( ) > 0 ) {
            $e = $query->row_array( );
            if( (int) $e[$columna] == Platc::$AGENDAMIENTO_SESION['EN_SESION'] )
                $estado = true;
        }

        return $estado;
    }

    public function agendamiento_calendario_definicion( $id_agenda_def, $id_site ) {

        $resultado = $this->db->get_where( 'TC_AGENDA_DEF', array( 'AGEDEF_ID' => $id_agenda_def, 'SIT_ID' => $id_site ) );
        return $resultado->row_array();
    }

    public function agendamiento_especialista_agendas_disponibles( $id_especialista, $id_site ) {

        // Encuentra solo agendas que estén en el mismo mes vigente o posterior,
        // de las anteriores no tiene sentido retornar coincidencias
        $sql = "SELECT  *
                FROM    TC_AGENDA_DEF
                WHERE   DATE_FORMAT( AGEDEF_FECHA_FIN, '%m') >= DATE_FORMAT( NOW(), '%m' )
                    AND USU_ID = ".(int)$id_especialista . "
                    AND SIT_ID = ".(int)$id_site . " ";
        $resultado = $this->db->query( $sql );

        return $resultado->result_array();
    }

    public function agendamiento_bloqueos_por_agendamiento( $id_agendamiento, $fecha_inicio, $fecha_fin ) {

        $sql = "SELECT  ab.AGEBLO_FECHA, ab.AGEBLO_DIAS, ab.AGEBLO_HORAS,
                        ad.AGEDEF_FECHA_INI, ad.AGEDEF_FECHA_FIN, ad.AGEDEF_HORA_INICIO, ad.AGEDEF_HORA_FIN, ad.AGEDEF_INTERVALO
                FROM    TC_AGENDA_BLOQUEO ab
                        INNER JOIN TC_AGENDA_DEF ad ON ( ad.AGEDEF_ID = ab.AGEDEF_ID )
                WHERE   ad.AGEDEF_ID = " . $id_agendamiento. "
                    AND ( ad.AGEDEF_FECHA_INI <= str_to_date( '".$fecha_fin."', '%Y-%m-%d' )
                    OR  ad.AGEDEF_FECHA_FIN >= str_to_date( '".$fecha_inicio."', '%Y-%m-%d' ) )";

        $resultado = $this->db->query( $sql );
        $bloqueos = $resultado->result_array();

        $retorno = array( );
        foreach( $bloqueos as $bloqueo ) {

            if( !empty( $bloqueo['AGEBLO_DIAS'] ) && !empty( $bloqueo['AGEBLO_HORAS'] ) && empty( $bloqueo['AGEBLO_FECHA'] ) ) {

                // Días de bloqueos: 1,2,3,4.... donde 1=Lunes, 2=Martes, 3=Miércoles......
                $dias_bloqueo  = explode( ',', $bloqueo['AGEBLO_DIAS'] );
                $horas_bloqueo = explode( ',', $bloqueo['AGEBLO_HORAS'] );

                $evento = array( );
                foreach( $dias_bloqueo as $dia_bloqueo ) {

    //imprimir( $dia_bloqueo, false, '$dia_bloqueo' );
                    // Convierte fecha en Timestamp pues existen más funciones compatibles con PHP<5.3
                    $fecha_ini_timestamp = strtotime( str_replace( '/', '-', $bloqueo['AGEDEF_FECHA_INI'] ) );
                    $fecha_fin_timestamp = strtotime( str_replace( '/', '-', $bloqueo['AGEDEF_FECHA_FIN'] ) );

    //imprimir( $fecha_ini_timestamp, false, '$fecha_ini_timestamp' );
    //imprimir( $fecha_fin_timestamp, false, '$fecha_fin_timestamp' );
                    // 0: Domingo => Establece este día al final (en 7)
                    $dia_semana = date( 'w', $fecha_ini_timestamp );
                    $dia_semana = ( $dia_semana == 0 ) ? 7 : $dia_semana;

    //imprimir( $dia_semana, false, '$dia_semana' );
                    // Si el día de bloqueo está antes del día de inicio aumenta en 1 semana
                    // para obtener la distancia en días
                    $diff = 0;
                    if( $dia_bloqueo < $dia_semana )    $dia_bloqueo = $dia_bloqueo + 7;
                    $diff = ( $dia_bloqueo - $dia_semana ) *60*60*24 ; // Obtiene segundos desde los días de diferencias
    //imprimir( $diff, false, '$diff' );

                    // Genera fecha siguiente de bloqueo
                    $f_i = 0;
                    if( $diff > 0 )
                        $f_i = $fecha_ini_timestamp + $diff;
                    else
                        $f_i = $fecha_ini_timestamp;
    //imprimir( $f_i, false, '$f_i' );

                    for( $f_i ; $f_i <= $fecha_fin_timestamp ; $f_i = $f_i + 60*60*24*7 ) {
    //imprimir( $f_i, false, '$f_i' );
    //imprimir( $fecha_fin_timestamp, false, '$fecha_fin_timestamp' );

                        // Agrega horas de bloqueo
                        $hora_bloqueo_anterior = '00:00';
                        $evento = array( );
                        foreach( $horas_bloqueo as $hora_bloqueo ) {

                            if( empty( $hora_bloqueo ) ) continue;
    //imprimir( $hora_bloqueo, false, 'hora_bloqueo' );
                            $h1 = explode( ":", $hora_bloqueo );
                            $minutos_bloqueo            = mktime( $h1[0], $h1[1], 0, 0, 0, 0 );
                            $h2 = explode( ":", $hora_bloqueo_anterior );
                            $minutos_bloqueo_anterior   = mktime( $h2[0], $h2[1], 0, 0, 0, 0 );
    //imprimir( $minutos_bloqueo, false );
    //imprimir( $minutos_bloqueo_anterior );
                            $dist = ( (int)$minutos_bloqueo - (int)$minutos_bloqueo_anterior ) / 60;
                            if( $bloqueo['AGEDEF_INTERVALO'] < $dist ) {

                                if( isset( $evento['start'] ) ) {
                                    $evento['id']   = 'bloqueado';
                                    $evento['end']  = date( 'Y-m-d', $f_i ) . ' '. $hora_bloqueo;
                                    $retorno[] = $evento;
                                }

                                $evento = array( );
                                $evento['title'] = $this->lang->line('agendamiento_no_disponible');
                                $evento['start'] = date( 'Y-m-d', $f_i ). ' '. $hora_bloqueo;
                            }

                            $hora_bloqueo_anterior = $hora_bloqueo;
                        }

                        // Cierra evento que queda abierto cuando termina ciclo
                        $evento['id']   = 'bloqueado';
                        $evento['end']  = date( 'Y-m-d', $f_i ) . ' '. date( 'H:i', $minutos_bloqueo+((int)$bloqueo['AGEDEF_INTERVALO'])*60 );
                        $retorno[] = $evento;
                    }

                }
            }

            if( empty( $bloqueo['AGEBLO_DIAS'] ) && empty( $bloqueo['AGEBLO_HORAS'] ) && !empty( $bloqueo['AGEBLO_FECHA'] ) ) {

                $evento = array( );
                $evento['id'] = 'bloqueado';
                $evento['title'] = $this->lang->line('agendamiento_no_disponible');
                $evento['start'] = $bloqueo['AGEBLO_FECHA'].' '.$bloqueo['AGEDEF_HORA_INICIO'];
                $evento['end']   = $bloqueo['AGEBLO_FECHA'].' '.$bloqueo['AGEDEF_HORA_FIN'];
                $retorno[] = $evento;
            }
        }

        return $retorno;
    }

    /**
     * Retorna un listado con las horas ya tomadas por el especialista.
     * Descarta horas tomadas por el generalista si va pasado por parámetros,
     * esto para que al obtener listado de horas tomadas por generalista
     * ($this->agendamiento_tomados_por_generalista( ) ) no aparezcan horas
     * repetidas y solapadas
     *
     * @param int   $id_agenda Identificador del especialista
     * @param string $fecha_inicio   Fecha de inicio para obtener listado de horas
     * @param string $fecha_fin      Fecha de fin para obtener listado de horas
     * @param int   $id_generalista  (opcional) Identificador del generalista
     * @return string|boolean
     */
    public function agendamiento_tomados_por_agendamiento( $id_agendamiento, $fecha_inicio, $fecha_fin, $id_generalista = NULL ) {

        $sql = "SELECT  a.AGE_HORA, a.AGE_FECHA
                FROM    TC_AGENDA a
                WHERE   a.AGEEST_ID = " . Platc::$AGENDAMIENTO_ESTADOS['TOMADA'];  // AGEEST_ID = 1 => Estado agenda = Tomada
        $sql.= "    AND a.AGEDEF_ID = ". $id_agendamiento . "
                    AND a.AGE_FECHA >= str_to_date( '" . $fecha_inicio . "',  '%Y-%m-%d' )
                    AND a.AGE_FECHA <= str_to_date( '" . $fecha_fin    . "',  '%Y-%m-%d' ) ";

        if( !empty( $id_generalista ) )
            $sql.= "    AND a.USU_ID_MEDICO != ".$id_generalista;

        $query = $this->db->query( $sql );

        if( $query->num_rows() > 0 ) {

            $fechas_tomados = array( );

            foreach( $query->result_array( ) as $hora_tomada) {

                $evento = array( );
                $evento['title'] = 'Hora tomada';
                $evento['start'] = $hora_tomada['AGE_FECHA']. " " . $hora_tomada['AGE_HORA'];
//                $evento['start'] = $hora_tomada['AGE_FECHA']. " " . $hora_tomada['AGE_HORA'];
                $evento['id']    = 'tomado';

                $fechas_tomados[] = $evento;
            }

            return $fechas_tomados;
        }
        else
            return FALSE;
    }

    /**
     * Retorna un listado con las horas ya tomadas por el generalista.
     * Descarta horas tomadas por el especialista si va pasado por parámetros,
     * esto para que al obtener listado de horas tomadas por especialista
     * ($this->agendamiento_tomados_por_agendamiento( ) ) no aparezcan horas
     * repetidas y solapadas
     *
     * @param int   $id_generalista  Identificador del generalista
     * @param string $fecha_inicio   Fecha de inicio para obtener listado de horas
     * @param string $fecha_fin      Fecha de fin para obtener listado de horas
     * @param int   $id_especialista (opcional) Identificador del especialista
     * @return string|boolean
     */
    public function agendamiento_tomados_por_generalista( $id_generalista, $fecha_inicio, $fecha_fin, $id_especialista = NULL ) {

        $sql = "SELECT  a.AGE_HORA, a.AGE_FECHA
                FROM    TC_AGENDA a
                WHERE   a.AGEEST_ID = ".Platc::$AGENDAMIENTO_ESTADOS['TOMADA'];  // AGEEST_ID = 1 => Estado agenda = Tomada
        $sql.= "    AND a.USU_ID_MEDICO = ". $id_generalista . "
                    AND a.AGE_FECHA >= str_to_date( '" . $fecha_inicio . "',  '%Y-%m-%d' )
                    AND a.AGE_FECHA <= str_to_date( '" . $fecha_fin    . "',  '%Y-%m-%d' ) ";

        if( !empty( $id_especialista ) )
            $sql.= "    AND a.USU_ID_ESPECIALISTA = ".$id_especialista;

        $query = $this->db->query( $sql );

        if( $query->num_rows() > 0 ) {

            $fechas_tomados = array( );

            foreach( $query->result_array( ) as $hora_tomada) {

                $evento = array( );
                $evento['title'] = 'Hora tomada';
                $evento['start'] = $hora_tomada['AGE_FECHA']. " " . $hora_tomada['AGE_HORA'];
//                $evento['start'] = $hora_tomada['AGE_FECHA']. " " . $hora_tomada['AGE_HORA'];
                $evento['id']    = 'tomado';

                $fechas_tomados[] = $evento;
            }

            return $fechas_tomados;
        }
        else
            return FALSE;
    }

    public function agendamiento_registro_suceso( $id_teleconsulta = '', $id_agenda = '', $id_estado = '', $id_usuario = '', $observaciones = '', $info_tecnico = '') {

        $this->db->set( 'AGESUC_FECHA_SUCESO', 'now()', false );
        $this->db->set( 'TEL_ID', $id_teleconsulta );
        $this->db->set( 'AGE_ID', $id_agenda );
        $this->db->set( 'AGEEST_ID', $id_estado );
        $this->db->set( 'USU_USUARIO', $id_usuario );
        $this->db->set( 'AGESUC_OBS', $observaciones );
        $this->db->set( 'AGESUC_INFO_TECNICO', $info_tecnico );
        $this->db->insert( 'TC_AGENDA_SUCESO' );

        $id = $this->db->insert_id( );
        if( !empty( $id ) )
            return $id;
        else
            return FALSE;
    }

    /**
     * Retorna historia de una agenda en particular.
     * Retorna un solo registro del estado correspondiente si se pasa el segundo parámetro
     *
     * @param int $id_agenda Identificador de la agenda
     * @param int $id_estado Identificador del estado
     * @return array historial de sucesos de la agenda
     */
    public function agendamiento_historial( $id_agenda, $id_estado = null ) {

        $this->db->order_by( 'AGESUC_ID', 'ASC' );
        $this->db->where( 'TC_AGENDA_SUCESO.AGE_ID', $id_agenda );
        if( !empty( $id_estado ) ) {

            $this->db->where( 'TC_AGENDA_SUCESO.AGEEST_ID', $id_estado );
            $this->db->join ( 'TC_AGENDA_MOTIVO_CANCELACION amr ', 'amr.AGE_ID = TC_AGENDA_SUCESO.AGE_ID' );
            $resultado = $this->db->get( 'TC_AGENDA_SUCESO' );
            return $resultado->row_array();
        }
        $resultado = $this->db->get( 'TC_AGENDA_SUCESO' );
        return $resultado->result_array();
    }

    public function agendamiento_agregar( $id_estado, $id_site, $id_generalista, $id_asistente, $id_tc, $id_agenda_def, $id_especialista, $fecha, $hora, $observaciones, $telefono, $email ) {

        $data['AGEEST_ID']          = $id_estado;
        $data['SIT_ID']             = $id_site;
        $data['USU_ID_MEDICO']      = $id_generalista;
        $data['USU_ID_ASISTENTE']   = $id_asistente;
        $data['TEL_ID']             = $id_tc;
        $data['AGEDEF_ID']          = $id_agenda_def;
        $data['USU_ID_ESPECIALISTA'] = $id_especialista;
        $data['AGE_FECHA']          = $fecha;
        $data['AGE_HORA']           = $hora;
        $data['AGE_OBSERVACIONES']  = $observaciones;
        $data['AGE_TELEFONO']       = $telefono;
        $data['AGE_EMAIL']          = $email;

        $this->db->insert( 'TC_AGENDA', $data );

        $id = $this->db->insert_id( );
        if( !empty( $id ) ) {

            $generalista  = $this->usuario_get( $id_generalista );
            $especialista = $this->usuario_get( $id_especialista );
            $obs = $this->lang->line('agendamiento_suceso_agenda_agregada') . ": ". $fecha . " " . $hora  . PHP_EOL;
            $obs.= $this->lang->line('rol_4'). ": ". $generalista['USU_NOMBRE'] . PHP_EOL ;
            $obs.= $this->lang->line('rol_3'). ": ". $especialista['USU_NOMBRE'] ;

            $info_tecnico = "[AGE_ID ] => [".$id."]".PHP_EOL;
            foreach( $data as $k => $v )
                $info_tecnico.= '['.$k.']=>['.$v.']'.PHP_EOL;
            $info_tecnico = $this->lang->line('agendamiento_suceso_agenda_agregada').': '.$info_tecnico;
            $this->agendamiento_registro_suceso( $id_tc, $id, $id_estado, $this->session->userdata('USU_ID'), $obs, $info_tecnico );
            return $id;
        } else
            return FALSE;
    }

    public function agendamientos_get( $id_site, $id_estado = NULL, $id_rol = NULL, $id_usuario_medico = NULL, $estab = '', $desde = '', $hasta = '' ) {

        if ( ( !empty( $id_rol )  ) && ( $id_rol == 9  )  ){ // NF432

            $sql = "SELECT  a.AGE_ID, ae.AGEEST_DESCRIPCION,
                            t.TEL_ID , a.AGE_FECHA, a.AGE_HORA,
                            e.ESP_NOMBRE,
                            etb.ETB_NOMBRE,
							CONCAT_WS(' ',p.PAC_PRIMER_NOMBRE,p.PAC_PRIMER_APELLIDO,p.PAC_SEGUNDO_APELLIDO) AS PAC_NOMBRE
                    FROM    TC_AGENDA a
								INNER JOIN TC_VIRTUAL tcv ON a.AGE_ID = tcv.TCV_AGE_ID 
								INNER JOIN TC_PACIENTE p ON tcv.TCV_PAC_ID = p.PAC_ID 
                                INNER JOIN TC_AGENDA_ESTADO ae ON ( ae.AGEEST_ID = a.AGEEST_ID )";

        } else {

            $sql = "SELECT  a.AGE_ID, ae.AGEEST_DESCRIPCION,
                            t.TEL_ID, u.USU_NOMBRE, a.AGE_FECHA, a.AGE_HORA,
                            e.ESP_NOMBRE,
                            etb.ETB_NOMBRE,
							CONCAT_WS(' ',p.PAC_PRIMER_NOMBRE,p.PAC_PRIMER_APELLIDO,p.PAC_SEGUNDO_APELLIDO) AS PAC_NOMBRE
                    FROM    TC_AGENDA a
								INNER JOIN TC_VIRTUAL tcv ON a.AGE_ID = tcv.TCV_AGE_ID 
								INNER JOIN TC_PACIENTE p ON tcv.TCV_PAC_ID = p.PAC_ID 
                                INNER JOIN TC_AGENDA_ESTADO ae ON ( ae.AGEEST_ID = a.AGEEST_ID )";

        }
        // Cambia join para obtener médico especialista o generalista según parametros
        if( !empty( $id_rol ) ) {

            switch( (int)$id_rol ) {

                // Obtiene agendas del especialista
                case 1 : 
                case 2 : $sql.= "            INNER JOIN TC_USUARIO u ON ( u.USU_ID = a.USU_ID_ESPECIALISTA )"; break;

                // Obtiene agendas del especialista
                case 3 : $sql.= "            INNER JOIN TC_USUARIO u ON ( u.USU_ID = a.USU_ID_MEDICO )"; break;

                // Obtiene agendas del 4: generalista y 5: Asistente
                case 4 :
                case 5 : $sql.= "            INNER JOIN TC_USUARIO u ON ( u.USU_ID = a.USU_ID_ESPECIALISTA ) "; break;
            }
        }


        $sql.= "            LEFT JOIN TC_TELECONSULTA t ON a.TEL_ID = t.TEL_ID
                                INNER JOIN TC_ESPECIALIDAD e ON e.ESP_ID = tcv.TCV_ESP_ID
                                INNER JOIN TC_ESTABLECIMIENTO etb ON etb.ETB_ID = tcv.TCV_ETB_ID
                            
                WHERE   a.SIT_ID = " . $id_site;

        if( !empty( $id_estado ) ) {
            $sql .= '   AND a.AGEEST_ID = ' . $id_estado;
        }

        // Filtra agendamientos según rol al que pertenecen
        if( !empty( $id_rol ) ) {

            switch( (int)$id_rol ) {

                // Obtiene agendas de todos los especialistas
                case 1 :
                case 2 : break;

                // Obtiene agendas del especialista
                case 3 : $sql .= '   AND a.USU_ID_ESPECIALISTA = ' . $id_usuario_medico; break;

                // Obtiene agendas del 4: generalista y 5: Asistente
                case 4 :
                //case 5 : $sql .= '   AND a.USU_ID_MEDICO = ' . $id_usuario_medico; break;
		      //case 5 : $sql .= '   AND ( a.USU_ID_MEDICO = ' . $id_usuario_medico . ' OR a.USU_ID_ASISTENTE = ' . $id_usuario_medico . ' )'; break;
            }
        }
		
		//Filtros busqueda
		if($estab) $sql .= " AND etb.ETB_NOMBRE LIKE '%".$estab."%'";
		if($desde) $sql .= " AND a.AGE_FECHA >= '".$desde."'";
		if($hasta) $sql .= " AND a.AGE_FECHA <= '".$hasta."'";
		if($id_estado == 1 && !$desde && !$hasta){
			if($this->session->userdata('ROL_ID') == Platc::$ROL['MEDICO_ASISTENTE'])
				$sql .= " AND DATE_FORMAT(a.AGE_FECHA,'%Y-%m') = DATE_FORMAT(CURDATE(),'%Y-%m') ";
			else
				$sql .= " AND a.AGE_FECHA = CURDATE() ";
		}
        // Ordena listado dejando los pendientes desde los próximos hacia los más lejanos
        // caso contrario ordena la lista desde los más nuevos hacia los más antiguos
        if( !empty( $id_estado ) && (int)$id_estado == Platc::$AGENDAMIENTO_ESTADOS['TOMADA'] )
            $sql .= ' ORDER BY a.AGE_FECHA ASC, a.AGE_HORA ASC';
        else
            $sql .= ' ORDER BY a.AGE_FECHA DESC, a.AGE_HORA DESC';

        $query = $this->db->query( $sql );
        return $query->result_array( );
    }

    public function agendamiento_buscar_tc_por_filtro( $id_site = NULL, $establecimiento = NULL, $especialidad = NULL, $estado = NULL, $fecha_inicio = NULL, $fecha_fin = NULL ) {

        $sql = "SELECT  t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO,
                        e.ETB_NOMBRE,
                        case WHEN isnull( t.TEL_FECHA_HORA_ENVIO ) then date_format( t.TEL_FECHA_HORA, '%d-%m-%Y %H:%i:%s' )
                            else date_format( t.TEL_FECHA_HORA_ENVIO, '%d-%m-%Y %H:%i:%s' )
                        END as TEL_FECHA_HORA_ENVIO,
                        t.EST_ID
                FROM    TC_TELECONSULTA t
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";
       // $sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 7 "; // No considera estados: Borrador, Rechazadas, Eliminadas y Contestadas

        if( $id_site == 2 ) // [CL] Mostrar TC para Chile
            $sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4  "; // No considera estados: Borrador, Rechazadas, Eliminadas

        if( $id_site == Platc::$SITE['COLOMBIA'] ) // [CO] Mostrar TC para Colombia
            $sql.= "WHERE  t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7 "; // No considera estados: Rechazadas, Eliminadas, Examenes solicitados y Contestadas

        if( !empty( $id_site ) )
            $sql.= " AND t.SIT_ID = ".$id_site;

        if( !empty( $establecimiento ) )
            $sql.= " AND t.ETB_ID = ".$establecimiento;

        if( !empty( $especialidad ) )
            $sql.= " AND t.ESP_ID = ".$especialidad;

        if( !empty( $estado ) )
            $sql.= " AND t.EST_ID = ".$estado;

        // COLOMBIA: Dado que se permite buscar TC en borrador, el campo de búsqueda por fecha enviada está vacío
        if( $this->session->userdata('SIT_ID') == Platc::$SITE['COLOMBIA'] ) {

            if( !empty( $fecha_inicio ) && empty( $fecha_fin ) )
                $sql.= " AND ( t.TEL_FECHA_HORA_ENVIO >= '".$fecha_inicio." 00:00:00' OR t.TEL_FECHA_HORA_ENVIO is null ) ";

            if( !empty( $fecha_inicio ) && !empty( $fecha_fin ) )
                $sql.= " AND ( t.TEL_FECHA_HORA_ENVIO >= '".$fecha_inicio." 00:00:00' OR t.TEL_FECHA_HORA_ENVIO is null ) AND ( t.TEL_FECHA_HORA_ENVIO <= '".$fecha_fin." 00:00:00' OR t.TEL_FECHA_HORA_ENVIO is null ) ";

            if( empty( $fecha_inicio ) && !empty( $fecha_fin ) )
                $sql.= " AND ( t.TEL_FECHA_HORA_ENVIO <= '".$fecha_fin." 00:00:00' OR t.TEL_FECHA_HORA_ENVIO is null ) ";
        } else {
            
            if( !empty( $fecha_inicio ) && empty( $fecha_fin ) )
                $sql.= " AND t.TEL_FECHA_HORA_ENVIO >= '".$fecha_inicio." 00:00:00'";

            if( !empty( $fecha_inicio ) && !empty( $fecha_fin ) )
                $sql.= " AND t.TEL_FECHA_HORA_ENVIO >= '".$fecha_inicio." 00:00:00' AND t.TEL_FECHA_HORA_ENVIO <= '".$fecha_fin." 00:00:00' ";

            if( empty( $fecha_inicio ) && !empty( $fecha_fin ) )
                $sql.= " AND t.TEL_FECHA_HORA_ENVIO <= '".$fecha_fin." 00:00:00' ";
        }

        $sql.= " ORDER BY t.TEL_FECHA_HORA_ENVIO DESC ";
//imprimir( $sql );
        $query = $this->db->query( $sql );

        if( $query->num_rows( ) > 0 )
            return $query->result_array( );
        else
            return FALSE;
    }

    public function agendamiento_buscar_tc_por_id_paciente( $id_site = NULL, $idt_paciente = NULL ) {

        if( empty( $id_site ) && empty( $idt_paciente ) )
            return FALSE;

        $sql = "SELECT  t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO,
                        e.ETB_NOMBRE,
                        case WHEN isnull( t.TEL_FECHA_HORA_ENVIO ) then date_format( t.TEL_FECHA_HORA, '%d-%m-%Y %H:%i:%s' )
                            else date_format( t.TEL_FECHA_HORA_ENVIO, '%d-%m-%Y %H:%i:%s' )
                        END as TEL_FECHA_HORA_ENVIO,
                        t.EST_ID
                FROM    TC_TELECONSULTA t
                            INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID )
                            INNER JOIN TC_TELPAC_IDENTIFICADOR idt ON ( idt.TEL_ID = t.TEL_ID ) ";
        //$sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 7 "; // No considera estados: Borrador, Rechazadas, Eliminadas y Contestadas

        if( (int)$id_site == 2 ) // [CL] Mostrar TC para Chile
            $sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4  "; // No considera estados: Borrador, Rechazadas, Eliminadas

        if($id_site === 22) // [CO] Mostrar TC para Colombia
            $sql.= "WHERE  t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7 "; // No considera estados: Rechazadas, Eliminadas, Examanes solicitados y Contestadas

        if( !empty( $id_site ) )
            $sql.= " AND t.SIT_ID = ".$id_site;

        if( !empty( $idt_paciente ) )
            $sql.= " AND idt.TCI_VALOR LIKE '%".$idt_paciente."%' ";

        $sql.= " ORDER BY t.TEL_FECHA_HORA DESC ";

        $query = $this->db->query( $sql );

        if( $query->num_rows( ) > 0 )
            return $query->result_array( );
        else
            return FALSE;
    }

    public function agendamiento_buscar_tc_por_paciente( $id_site = NULL, $nombre = NULL, $apellido = NULL ) {

        if( empty( $id_site ) && empty( $nombre ) && empty( $apellido ) )
            return FALSE;

        $sql = "SELECT  t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO,
                        e.ETB_NOMBRE,
                        case WHEN isnull( t.TEL_FECHA_HORA_ENVIO ) then date_format( t.TEL_FECHA_HORA, '%d-%m-%Y %H:%i:%s' )
                            else date_format( t.TEL_FECHA_HORA_ENVIO, '%d-%m-%Y %H:%i:%s' )
                        END as TEL_FECHA_HORA_ENVIO,
                        t.EST_ID
                FROM    TC_TELECONSULTA t
                            INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";
        //$sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 7 "; // No considera estados: Borrador, Rechazadas, Eliminadas, Contestadas

        if($id_site == 2) // [CL] Mostrar TC para Chile
            $sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4  "; // No considera estados: Borrador, Rechazadas, Eliminadas

        if($id_site == 22) // [CO] Mostrar TC para Colombia
            $sql.= "WHERE  t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7 "; // No considera estados: Rechazadas, Eliminadas, Examenes solicitados y Contestadas

        if( !empty( $id_site ) )
            $sql.= " AND t.SIT_ID = ".$id_site;

        if( !empty( $nombre ) )
            $sql.= " AND t.TEL_PAC_PRIMER_NOMBRE LIKE '%".$nombre."%' ";

        if( !empty( $apellido ) )
            $sql.= " AND t.TEL_PAC_PRIMER_APELLIDO LIKE '%".$apellido."%' ";

        $sql.= " ORDER BY t.TEL_FECHA_HORA DESC ";
//imprimir( $sql );

        $query = $this->db->query( $sql );

        if( $query->num_rows( ) > 0 )
            return $query->result_array( );
        else
            return FALSE;
    }

    public function agendamiento_buscar_tc_por_id( $id_site = NULL, $id_teleconsulta = NULL ) {

        if( empty( $id_site ) && empty( $id_teleconsulta ) )
            return FALSE;

        $sql = "SELECT  t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, TEL_PAC_SEGUNDO_APELLIDO,
                        e.ETB_NOMBRE,
                        case WHEN isnull( t.TEL_FECHA_HORA_ENVIO ) then date_format( t.TEL_FECHA_HORA, '%d-%m-%Y %H:%i:%s' )
                            else date_format( t.TEL_FECHA_HORA_ENVIO, '%d-%m-%Y %H:%i:%s' )
                        END as TEL_FECHA_HORA_ENVIO,
                        t.EST_ID
                FROM    TC_TELECONSULTA t
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( e.ETB_ID = t.ETB_ID ) ";
        //$sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 7 "; // No considera estados: Borrador, Rechazadas, Eliminadas, Contestadas

        if($id_site == 2) // [CL] Mostrar TC para Chile
            $sql.= "WHERE   t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4  "; // No considera estados: Borrador, Rechazadas, Eliminadas

        if($id_site == 22) // [CO] Mostrar TC para Colombia
            $sql.= "WHERE t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7 "; // No considera estados: Rechazadas, Eliminadas, Examenes solicitados y Contestadas

        if( !empty( $id_teleconsulta ) )
            $sql.= " AND t.TEL_ID = ".$id_teleconsulta;
 //imprimir( $sql );
        $query = $this->db->query( $sql );

        if( $query->num_rows( ) > 0 )
            return $query->result_array( );
        else
            return FALSE;
    }

    public function agendamiento_get( $id_agendamiento, $id_site = NULL ) {
		/*
        $this->db->join( 'TC_TELECONSULTA t', 't.TEL_ID = a.TEL_ID' );
        $this->db->join( 'TC_PACIENTE p', 'p.PAC_ID = t.PAC_ID' );
        $this->db->join( 'TC_ESPECIALIDAD e', 'e.ESP_ID = t.ESP_ID' );
        $query = $this->db->get_where( 'TC_AGENDA a', array( 'a.AGE_ID' => $id_agendamiento, 'a.SIT_ID' => $id_site ) );

        if( $query->num_rows() > 0 ) {

            return $query->row_array( );
        }

        return null;
		*/
		$this->db->from('TC_VIRTUAL tcv');
		$this->db->join('TC_AGENDA a','tcv.TCV_AGE_ID = a.AGE_id');
		$this->db->join( 'TC_TELECONSULTA t', 'a.TEL_ID = t.TEL_ID','LEFT' );
        $this->db->join( 'TC_PACIENTE p', 'tcv.TCV_PAC_ID = p.PAC_ID' );
        $this->db->join( 'TC_ESPECIALIDAD e', 'e.ESP_ID = tcv.TCV_ESP_ID' );
		if($id_agendamiento) $this->db->where('a.AGE_ID',$id_agendamiento);
		if($id_site) $this->db->where('a.SIT_ID',$id_site);
        $query = $this->db->get();
        if( $query->num_rows() > 0 ) {
            return $query->row_array( );
        }
		else{
			return FALSE;
		}
    }

    public function agendamiento_cancelar_reunion( $id_agendamiento, $id_motivo_rechazo, $motivo ) {

        $id_usuario = $this->session->userdata( 'USU_ID' );
        $id_estado  = Platc::$AGENDAMIENTO_ESTADOS['CANCELADA'];

        $this->db->set( 'AGEEST_ID', $id_estado );
        $this->db->where( 'AGE_ID', $id_agendamiento );
        $this->db->update( 'TC_AGENDA' );

        // 
        $data = array(  'AGE_ID' => (int)$id_agendamiento,
                        'AMR_ID_MOTIVO_CANCELACION' => (int)$id_motivo_rechazo,
                        'AMR_COMENTARIO' => ( ( !empty( $motivo ) ) ? (string)$motivo : null ) );
        $this->db->insert( 'TC_AGENDA_MOTIVO_CANCELACION', $data );

        //
        $q = $this->db->get_where( 'TC_AGENDA', array( 'AGE_ID' => $id_agendamiento )  );
        $r = $q->row_array( );

        $usuario = $this->usuario_get( $id_usuario );
        $observacion  = $this->lang->line('usuario')." ".$usuario['USU_NOMBRE']." ". $this->lang->line('agendamiento_cancela_hora_agenda');
        $info_tecnico = $this->lang->line('usuario')." [".$id_usuario."] ". $this->lang->line('agendamiento_cancela_hora_agenda') ." [".$id_agendamiento."]";
        $estado = $this->agendamiento_registro_suceso( $r['TEL_ID'], $id_agendamiento, $id_estado, $id_usuario, $observacion, $info_tecnico );

        return $estado ? true : false;
    }

    public function agendamiento_en_espera_atencion( $id_agendamiento ) {

        $id_usuario = $this->session->userdata( 'USU_ID' );
        $id_estado  = Platc::$AGENDAMIENTO_ESTADOS['ESPERA'];

        $columna = ( $this->session->userdata( 'ROL_ID' ) == Platc::$ROL['MEDICO_GENERAL'] ) ? 'AGESES_ID_GENERALISTA' : 'AGESES_ID_ESPECIALISTA';
        $this->db->set( $columna, Platc::$AGENDAMIENTO_SESION['EN_SESION'] );
        $this->db->set( 'AGEEST_ID', $id_estado );
        $this->db->where( 'AGE_ID', $id_agendamiento );
        $this->db->update( 'TC_AGENDA' );

        $q = $this->db->get_where( 'TC_AGENDA', array( 'AGE_ID' => $id_agendamiento )  );
        $r = $q->row_array( );

        $usuario = $this->usuario_get( $id_usuario );
        $motivo  = $this->lang->line('usuario'). " " . $usuario['USU_NOMBRE'] . " " . $this->lang->line('agendamiento_inicia_sesion');

        $info_tecnico = $motivo;  // TODO: Agregar más info
        $estado = $this->agendamiento_registro_suceso( $r['TEL_ID'], $id_agendamiento, $id_estado, $id_usuario, $motivo, $info_tecnico );

        return $estado ? true : false;
    }

    public function agendamiento_terminar_reunion( $id_agendamiento, $comentario ) {

        $id_usuario = $this->session->userdata( 'USU_ID' );

        $agendamiento = $this->agendamiento_get( $id_agendamiento, $this->session->userdata('SIT_ID') );
        if( $this->session->userdata( 'ROL_ID' ) == Platc::$ROL['MEDICO_GENERAL'] ) {

            $estado_contraparte  = $agendamiento[ 'AGESES_ID_ESPECIALISTA' ];
            $columna_usuario = 'AGESES_ID_GENERALISTA';
            $columna_comentario = 'AGE_COMENTARIO_GENERALISTA';
        } else {

            $estado_contraparte = $agendamiento[ 'AGESES_ID_GENERALISTA' ];
            $columna_usuario = 'AGESES_ID_ESPECIALISTA';
            $columna_comentario = 'AGE_COMENTARIO_ESPECIALISTA';
        }
        $id_estado_final = ( (int)$estado_contraparte == Platc::$AGENDAMIENTO_SESION['TERMINADO'] ) ? Platc::$AGENDAMIENTO_ESTADOS['FINALIZADA'] : Platc::$AGENDAMIENTO_ESTADOS['ESPERA'];

        if( empty( $agendamiento['AGE_FIN_REUNION'] ) ) $this->db->set( 'AGE_FIN_REUNION', 'NOW()', FALSE );
        $this->db->set( $columna_usuario, Platc::$AGENDAMIENTO_SESION['TERMINADO'] );
        $this->db->set( $columna_comentario, $comentario );
        $this->db->set( 'AGEEST_ID', $id_estado_final );
        $this->db->where( 'AGE_ID', $id_agendamiento );
        $this->db->update( 'TC_AGENDA' );

        $q = $this->db->get_where( 'TC_AGENDA', array( 'AGE_ID' => $id_agendamiento )  );
        $r = $q->row_array( );

        $usuario = $this->usuario_get( $id_usuario );
        $observacion  = $this->lang->line('usuario') . " " . $usuario['USU_NOMBRE'] . " " . $this->lang->line('agendamiento_termina_sesion');
        $info_tecnico = $this->lang->line('usuario') . " " . $usuario['USU_NOMBRE'] . " " . $this->lang->line('agendamiento_termina_sesion'); // TODO: Agregar más info

        $estado_contraparte = $this->agendamiento_registro_suceso( $r['TEL_ID'], $id_agendamiento, $id_estado_final, $id_usuario, $observacion , $info_tecnico );

        return $estado_contraparte ? true : false;
    }

    public function agendamiento_cambiar_fecha_hora( $id_agendamiento, $fecha, $hora ) {

        $agendamiento_anterior = $this->agendamiento_get( $id_agendamiento, $this->session->userdata('SIT_ID') );
        $data = array( 'AGE_FECHA' => $fecha, 'AGE_HORA' => $hora );
        $this->db->where( 'AGE_ID', $id_agendamiento );
        $estado = $this->db->update( 'TC_AGENDA', $data );

        $id_teleconsulta= (int)$agendamiento_anterior['TEL_ID'];
        $id_estado      = (int)$agendamiento_anterior['AGEEST_ID'];
        $id_usuario     = (int)$this->session->userdata('USU_ID');
        $observaciones  = sprintf(  $this->lang->line('agendamiento_cambio_hora_observacion'),
                                    $this->session->userdata('USU_NOMBRE'),
                                    $agendamiento_anterior['AGE_HORA'], $this->util->fecha_orden( $agendamiento_anterior['AGE_FECHA'] ),
                                    $hora, $this->util->fecha_orden( $fecha ) );
        $info_tecnico   = sprintf( $this->lang->line('agendamiento_cambio_hora_info_tecnico'),
                                    $this->session->userdata('USU_ID'), $this->session->userdata('USU_NOMBRE'),
                                    $id_agendamiento, $agendamiento_anterior['AGE_HORA'], $agendamiento_anterior['AGE_FECHA'],
                                    $hora, $fecha );
        $this->agendamiento_registro_suceso( $id_teleconsulta, $id_agendamiento, $id_estado, $id_usuario, $observaciones, $info_tecnico );

        return $estado;
    }
    
    public function agendamiento_establecer_fecha_inicio_reunion( $id_agendamiento ) {

        $this->db->set( 'AGE_INICIO_REUNION', 'now()', FALSE );
        $this->db->where( 'AGE_ID', (int)$id_agendamiento );
        $this->db->update( 'TC_AGENDA' );
    }
// autoguardar:
//    public function agendamiento_guardar_comentario( $id_agendamiento, $rol, $comentarios = null ) {
//
//        $datos = array( );
//        switch( (int) $rol ) {
//            case Platc::$ROL['MEDICO_GENERAL'] : { $datos['AGE_COMENTARIO_GENERALISTA'] = $comentarios; } break;
//            case Platc::$ROL['ESPECIALISTA']   : { $datos['AGE_COMENTARIO_ESPECIALISTA'] = $comentarios; } break;
//        }
//
//        $this->db->where( 'AGE_ID', $id_agendamiento );
//        return $this->db->update( 'TC_AGENDA', $datos );
//    }

    public function agendamiento_exportar_tomadas( $id_estado ) {

        $sql = "SELECT  a.AGE_ID, t.TEL_ID, pi.PAC_IDT_VALOR, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO,
                        e.ETB_NOMBRE,
                        a.AGE_FECHA, a.AGE_HORA,
                        ue.USU_NOMBRE USU_NOMBRE_ESPECIALISTA,
                        esp.ESP_NOMBRE,
                        case when a.USU_ID_ASISTENTE is null then ug.USU_NOMBRE else ua.USU_NOMBRE
                        end as USU_NOMBRE_GENERALISTA
                FROM    TC_AGENDA a
						INNER JOIN TC_VIRTUAL tcv ON a.AGE_ID = tcv.TCV_AGE_ID
						INNER JOIN TC_PACIENTE p ON tcv.TCV_PAC_ID = p.PAC_ID
						INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = p.PAC_ID )
						INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = tcv.TCV_ETB_ID )
						INNER JOIN TC_ESPECIALIDAD esp ON ( esp.ESP_ID = tcv.TCV_ESP_ID )
                        LEFT JOIN TC_TELECONSULTA t ON ( a.TEL_ID = t.TEL_ID )
                        INNER JOIN TC_USUARIO ue ON ( ue.USU_ID = a.USU_ID_ESPECIALISTA )
                        INNER JOIN TC_USUARIO ug ON ( ug.USU_ID = a.USU_ID_MEDICO )
                        LEFT JOIN TC_USUARIO ua ON ( ua.USU_ID = a.USU_ID_ASISTENTE )
                WHERE   a.AGEEST_ID = ".(int)$id_estado . " ORDER BY a.AGE_FECHA DESC, a.AGE_HORA DESC";

        $q = $this->db->query( $sql );
        return $q->result_array();
    }

    public function agendamiento_exportar_finalizadas( $id_estado ) {

        $sql = "SELECT  a.AGE_ID, t.TEL_ID, pi.PAC_IDT_VALOR, p.PAC_PRIMER_NOMBRE, p.PAC_PRIMER_APELLIDO,
                        e.ETB_NOMBRE,
                        ug.USU_NOMBRE USU_NOMBRE_GENERALISTA,
                        t.TEL_FECHA_HORA_ENVIO,
                        esp.ESP_NOMBRE,
                        t.TEL_FECHA_HORA_RESPUESTA,
                        time( SUBTIME( AGE_FIN_REUNION, time( AGE_INICIO_REUNION ) ) ) as DURACION_TC_SINCRONICA,
                        ue.USU_NOMBRE USU_NOMBRE_ESPECIALISTA
                FROM    TC_AGENDA a
						INNER JOIN TC_VIRTUAL tcv ON a.AGE_ID = tcv.TCV_AGE_ID
						INNER JOIN TC_PACIENTE p ON tcv.TCV_PAC_ID = p.PAC_ID
						INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = p.PAC_ID )
						INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = tcv.TCV_ETB_ID )
						INNER JOIN TC_ESPECIALIDAD esp ON ( esp.ESP_ID = tcv.TCV_ESP_ID )
                        LEFT JOIN TC_TELECONSULTA t ON a.TEL_ID = t.TEL_ID
                        INNER JOIN TC_USUARIO ue ON ( ue.USU_ID = a.USU_ID_ESPECIALISTA )
                        INNER JOIN TC_USUARIO ug ON ( ug.USU_ID = a.USU_ID_MEDICO )
                        LEFT JOIN TC_USUARIO ua ON ( ua.USU_ID = a.USU_ID_ASISTENTE )
                WHERE   a.AGEEST_ID = ".(int)$id_estado . " ORDER BY t.TEL_FECHA_HORA_ENVIO DESC";

        $q = $this->db->query( $sql );
        return $q->result_array();
    }

    public function agendamiento_exportar_cancelada( $id_estado ) {

        $sql = "SELECT  t.TEL_ID, pi.PAC_IDT_VALOR, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO,
                        e.ETB_NOMBRE,
                        a.AGE_FECHA, a.AGE_HORA,
                        esp.ESP_NOMBRE,
                        ue.USU_NOMBRE USU_NOMBRE_ESPECIALISTA,
                        uc.USU_NOMBRE as USU_CANCELA,
                        amr.AMR_ID_MOTIVO_CANCELACION AS AMR_ID_MOTIVO_CANCELA,
                        amr.AMR_COMENTARIO
                FROM    TC_AGENDA a
                        INNER JOIN ( TC_TELECONSULTA t
                            INNER JOIN TC_PACIENTE_IDENTIFICADOR pi ON ( pi.PAC_ID = t.PAC_ID )
                            INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID )
                            INNER JOIN TC_ESPECIALIDAD esp ON ( esp.ESP_ID = t.ESP_ID )
                        ) ON ( a.TEL_ID = t.TEL_ID )
                        INNER JOIN TC_USUARIO ue ON ( ue.USU_ID = a.USU_ID_ESPECIALISTA )
                        INNER JOIN ( TC_AGENDA_SUCESO asu
                            INNER JOIN TC_USUARIO uc ON ( uc.USU_ID = asu.USU_USUARIO )
                            LEFT JOIN TC_AGENDA_MOTIVO_CANCELACION amr ON ( amr.AGE_ID = asu.AGE_ID )
                        ) ON ( asu.AGE_ID = a.AGE_ID and asu.AGEEST_ID = 4 )
                WHERE   a.AGEEST_ID = ".(int)$id_estado . " ORDER BY a.AGE_FECHA DESC, a.AGE_HORA DESC";

        $q = $this->db->query( $sql );
        return $q->result_array();
    }

    /**
     * Retorna listado de plantillas
     * @param int $id_site Id del site de donde se obtienen las plantillas.
     * @param array $tags Listado de identificadores a obtener
     * @return array Listado de plantillas
     */
    public function plantillas_get( $id_site, $tags ) {

        $sql = "SELECT  p.*
                FROM    TC_PLANTILLAS p
                WHERE   p.SIT_ID = " . (int)$id_site. "
                    AND p.PLA_TAG IN ( '". implode( "', '", $tags ) ."' ) ";

        $resultado = $this->db->query( $sql );

        if( !empty( $resultado ) )
            return $resultado->result_array();
        else
            return false;
    }

    /**
     * Retorna texto asociado a una plantilla en particular
     *
     * @param int $id_plantilla Id de la plantilla a obtener texto asociado
     * @return mixed Retorna texto de una plantilla, false si no
     */
    public function plantilla_get( $id_plantilla ) {

        $sql = "SELECT PLA_TEXTO
                FROM TC_PLANTILLAS p ";
        $sql.= "WHERE p.PLA_ID = " . $id_plantilla;

        $resultado = $this->db->query( $sql );

        if( $resultado->num_rows( ) > 0 ) {
            $p = $resultado->row_array();
            return $p['PLA_TEXTO'];
        } else
            return false;
    }

    /*
     *
     */
    public function derma_lesion_obtener( $tel_id, $borrador = false ) {

        $lesiones   = array( );

        $ruta = 'files/derma/'.$tel_id;
        $ruta.= ( $borrador ) ? '/'.Platc::$DERMA_DIR_FOTOS['BORRADORES'].'/' : '/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las lesiones
            while( false !== ( $hash_borrador = readdir( $handle ) ) ) {

                if( $hash_borrador != '.' && $hash_borrador != '..' ) {

                    $ruta_lesiones = $ruta.$hash_borrador;
                    $carpeta_lesiones = opendir( $ruta_lesiones );
                    if( $carpeta_lesiones ) {

                        // Recorre las carpetas de lesiones (anatomica, 30 cm, luz blanca, luz uv... )
                        while( false !== ( $carpeta_lesion = readdir( $carpeta_lesiones ) ) ) {

                            $carpeta_foto = FALSE;

                            $ruta_carpeta_lesiones = $ruta_lesiones.'/'.$carpeta_lesion;
                            if( !empty( $carpeta_lesion ) && is_dir( $ruta_carpeta_lesiones ) && $carpeta_lesion != '.' && $carpeta_lesion != '..' ) {

                                $observacion = '';

                                switch( $carpeta_lesion ) {

                                    case Platc::$DERMA_DIR_FOTOS['ANATOMICA'] : {
                                        $carpeta_foto = Platc::$DERMA_DIR_FOTOS['ANATOMICA'];
                                    } break;

                                    case Platc::$DERMA_DIR_FOTOS['30CM'] : {
                                        $carpeta_foto = Platc::$DERMA_DIR_FOTOS['30CM'];
                                    } break;

                                    case Platc::$DERMA_DIR_FOTOS['LUZBLANCA'] : {
                                        $carpeta_foto = Platc::$DERMA_DIR_FOTOS['LUZBLANCA'];
                                    } break;

                                    case Platc::$DERMA_DIR_FOTOS['LUZUV'] : {
                                        $carpeta_foto = Platc::$DERMA_DIR_FOTOS['LUZUV'];
                                    } break;

                                    default: break;
                                }

                                if( !$carpeta_foto ) continue;

                                // Recorre buscando el archivo de imagen
                                $archivos = opendir( $ruta_carpeta_lesiones );
                                while( false !== ( $archivo = readdir( $archivos ) ) ) {

                                    if( !empty( $archivo ) && $archivo != '.' && $archivo != '..' &&
                                        $archivo != Platc::$DERMA_DIR_FOTOS['BORRADOS'] &&
                                        strpos( $archivo, "thumb_" ) === FALSE ) {

                                        $ruta_archivo = $ruta_carpeta_lesiones.'/'.$archivo;

                                        // Si es un archivo de imagen (que no tiene .comment)
                                        if( strpos( $archivo, ".comment" ) === FALSE && is_file( $ruta_archivo ) )
                                            $lesiones[ $hash_borrador ][ $carpeta_foto]['archivo']       = $archivo;

                                        // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_carpeta_lesiones.'/'.$carpeta_foto.".comment" ) ) {

                                            $h_comentario = fopen( $ruta_carpeta_lesiones.'/'.$carpeta_foto.".comment", 'r' );
                                            $observacion  = fread( $h_comentario, filesize( $ruta_carpeta_lesiones.'/'.$carpeta_foto.".comment" )  );
                                            fclose( $h_comentario );
                                            $lesiones[ $hash_borrador ][ $carpeta_foto]['observacion']   = $observacion;
                                        }

                                        // Abandona ciclo, solo 1 archivo.
//                                        break;
                                    }
                                }

                                closedir( $archivos );
                            }
                        }
                    }

                    closedir( $carpeta_lesiones );
                }
            }

            closedir($handle);
        }

        return $lesiones;
    }

    /**
     *
     */
    public function derma_lesion_crear_carpeta_borrador( $tel_id ) {

//        $lesiones = $this->derma_lesion_obtener( $tel_id, TRUE );
//        $ultimo_borrador = (int)key( array_slice( $lesiones, -1, 1, true ) );
//        $nuevo_borrador = (int)($ultimo_borrador + 1);
//        $ruta = 'files/derma/'.$tel_id.'/'.Platc::$DERMA_DIR_FOTOS['BORRADORES'].'/'.$nuevo_borrador;
//imprimir( $ruta );

        do {
            $hash = substr( md5( rand( ) ), 1, 5 );
            $ruta = 'files/derma/'.$tel_id.'/'.Platc::$DERMA_DIR_FOTOS['BORRADORES'].'/'.$hash;
        } while( is_dir( $ruta ) );

        if( @mkdir( $ruta, 0777, TRUE ) )
            return $hash;
        else
            return FALSE;
    }

    /*
     *
     */
    public function otorrino_cabeza_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CABEZA'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['FRONTAL'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['FRONTAL'];
                        } break;

                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];
                        } break;

                        case Platc::$OTORRINO_DIR_Y['DERECHO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['DERECHO'];
                        } break;

                        case Platc::$OTORRINO_DIR_Y['BOCA'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['BOCA'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function otorrino_oido_izquierdo_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_IZQUIERDO'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function otorrino_oido_derecho_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['OIDO_DERECHO'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['DERECHO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['DERECHO'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function otorrino_nariz_izquierdo_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_IZQUIERDO'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function otorrino_nariz_derecho_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['NARIZ_DERECHO'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['DERECHO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['DERECHO'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function otorrino_boca_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['BOCA'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['BOCA'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['BOCA'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function otorrino_cuello_obtener( $tel_id ) {

        $examenes_especificos   = array( );

        $ruta = 'files/otorrino/'.$tel_id.'/'.Platc::$OTORRINO_DIR_EXAMEN_ESPECIFICO['CUELLO'].'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las Y
            while( false !== ( $y = readdir( $handle ) ) ) {

                $carpeta_foto = FALSE;

                if( $y != '.' && $y != '..' ) {

                    switch( $y ) {

                        case Platc::$OTORRINO_DIR_Y['FRONTAL'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['FRONTAL'];
                        } break;
                        case Platc::$OTORRINO_DIR_Y['IZQUIERDO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['IZQUIERDO'];
                        } break;
                        case Platc::$OTORRINO_DIR_Y['DERECHO'] : {
                            $carpeta_foto = Platc::$OTORRINO_DIR_Y['DERECHO'];
                        } break;

                        default: break;
                    }

                    if( !$carpeta_foto ) continue;
                    $examenes_especificos[ $carpeta_foto ] = Array( );

                    $ruta_examenes_fisicos = $ruta.$carpeta_foto;
                    $carpeta_examenes_fisicos = opendir( $ruta_examenes_fisicos );
                    if( $carpeta_examenes_fisicos ) {

                        // Recorre los archivos de Y ( frontal, izquierda, derecha, boca, ... )
                        while( false !== ( $archivo_y = readdir( $carpeta_examenes_fisicos ) ) ) {

//                            $carpeta_y = FALSE;

                            $ruta_archivo_y = $ruta_examenes_fisicos.'/'.$archivo_y;
                            if( !empty( $archivo_y ) && $archivo_y != '.' && $archivo_y != '..' &&
                                $archivo_y != Platc::$OTORRINO_DIR_Y['BORRADOS'] && strpos( $archivo_y, "thumb_" ) === FALSE ) {

                                $observacion = '';

                                // Si es un archivo de imagen (que no tiene .comment)
                                if( strpos( $archivo_y, ".comment" ) === FALSE && is_file( $ruta_archivo_y ) )
                                    $examenes_especificos[ $carpeta_foto ][ 'archivo' ]     = $archivo_y;

                                // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                if( strpos( $archivo_y, ".comment" ) !== FALSE && is_file( $ruta_archivo_y ) ) {

                                    $h_comentario = fopen( $ruta_archivo_y, 'r' );
                                    $observacion  = fread( $h_comentario, filesize( $ruta_archivo_y )  );
                                    fclose( $h_comentario );
                                    $examenes_especificos[ $carpeta_foto ]['observacion']   = $observacion;
                                }

                            }
                        }
                    }

                    closedir( $carpeta_examenes_fisicos );
                }
            }

            closedir($handle);
        }

        return $examenes_especificos;
    }

    /*
     *
     */
    public function oftalmologia_estructura_externas_obtener( $tel_id, $borrador = false ) {

        $protocolos   = array( );

        $ruta = 'files/oftalmologia/'.$tel_id;
//        $ruta.= ( $borrador ) ? '/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADORES'].'/' : '/';
        $carpeta_oftalmologia = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $carpeta_oftalmologia ) {

            // Recorre todas las lesiones
//            while( false !== ( $hash_borrador = readdir( $handle ) ) ) {

//                if( $hash_borrador != '.' && $hash_borrador != '..' ) {

//                    $ruta_lesiones = $ruta.$hash_borrador;
//                    $carpeta_lesiones = opendir( $ruta_lesiones );
//                    if( $carpeta_lesiones ) {

                        // Recorre las carpetas de protocolo (estructura externa, fondo del ojo, ...)
                        while( false !== ( $carpeta_protocolo = readdir( $carpeta_oftalmologia ) ) ) {

                            $carpeta_foto = FALSE;

                            $ruta_carpeta_protocolo = $ruta.'/'.$carpeta_protocolo;
                            if( !empty( $carpeta_protocolo ) && is_dir( $ruta_carpeta_protocolo ) && $carpeta_protocolo != '.' && $carpeta_protocolo != '..' ) {

                                $observacion = '';

                                switch( $carpeta_protocolo ) {

                                    case Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] : {
                                        $carpeta_foto = Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'];
                                    } break;

                                    case Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] : {
                                        $carpeta_foto = Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'];
                                    } break;

                                    default: break;
                                }

                                if( !$carpeta_foto ) continue;

                                // Recorre buscando el archivo de imagen
                                $archivos = opendir( $ruta_carpeta_protocolo );
                                while( false !== ( $archivo = readdir( $archivos ) ) ) {

                                    if( !empty( $archivo ) && $archivo != '.' && $archivo != '..' &&
                                        strpos( $archivo, "thumb_" ) === FALSE ) {

                                        $ruta_archivo = $ruta_carpeta_protocolo.'/'.$archivo;

                                        // Si es un archivo de imagen (que no tiene .comment)
                                        if( strpos( $archivo, ".comment" ) === FALSE && is_file( $ruta_archivo ) )
                                            $protocolos[ $carpeta_foto]['archivo']       = $archivo;

                                        // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_carpeta_protocolo.'/'.$carpeta_foto.".comment" ) ) {

                                            $h_comentario = fopen( $ruta_carpeta_protocolo.'/'.$carpeta_foto.".comment", 'r' );
                                            $observacion  = fread( $h_comentario, filesize( $ruta_carpeta_protocolo.'/'.$carpeta_foto.".comment" )  );
                                            fclose( $h_comentario );
                                            $protocolos[ $carpeta_foto]['observacion']   = $observacion;
                                        }

                                        // Abandona ciclo, solo 1 archivo.
//                                        break;
                                    }
                                }

                                closedir( $archivos );
                            }
                        }
//                    }

//                    closedir( $carpeta_oftalmologia );
//                }
//            }

            closedir($carpeta_oftalmologia);
        }

        return $protocolos;
    }

    /*
     *
     */
    public function oftalmologia_obtener( $tel_id, $protocolo = NULL ) {

        $imagenes   = array( );

        $ruta = 'files/oftalmologia/'.$tel_id.'/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre las carpetas de protocolos (estructuras externas, fondo de ojos... )
            while( false !== ( $p = readdir( $handle ) ) ) {

                if( $protocolo != NULL && $protocolo != $p ) continue;

                if( $p != '.' && $p != '..' ) {

                    $ruta_protocolo = $ruta.$p;
                    $carpeta_protocolo = opendir( $ruta_protocolo );
                    if( $carpeta_protocolo &&
                        ( $protocolo == Platc::$OFTALMOLOGICO_PROTOCOLOS['ESTRUCTURAS_EXTERNAS'] ||
                        $protocolo == Platc::$OFTALMOLOGICO_PROTOCOLOS['FONDO_OJOS'] ) ) {

                        // Recorre las carpetas de lados (izquierdo o derecho)
                        while( false !== ( $lado = readdir( $carpeta_protocolo ) ) ) {

                            $carpeta_lado = FALSE;

                            $ruta_protocolo_lado = $ruta_protocolo.'/'.$lado;
                            if( !empty( $carpeta_protocolo ) && is_dir( $ruta_protocolo_lado ) &&
                                $lado != '.' && $lado != '..' ) {

                                $observacion = '';

                                switch( $lado ) {

                                    case Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] : {
                                        $carpeta_lado = Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'];
                                    } break;

                                    case Platc::$OFTALMOLOGICO_LADO['DERECHO'] : {
                                        $carpeta_lado = Platc::$OFTALMOLOGICO_LADO['DERECHO'];
                                    } break;

                                    default: break;
                                }

                                if( !$carpeta_lado ) continue;

                                // Recorre buscando el archivo de imagen
                                $archivos = opendir( $ruta_protocolo_lado );
                                while( false !== ( $archivo = readdir( $archivos ) ) ) {

                                    if( !empty( $archivo ) && $archivo != '.' && $archivo != '..' &&
                                        $archivo != Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'] &&
                                        strpos( $archivo, "thumb_" ) === FALSE ) {

                                        $ruta_archivo = $ruta_protocolo_lado.'/'.$archivo;

                                        // Si es un archivo de imagen (que no tiene .comment)
                                        if( strpos( $archivo, ".comment" ) === FALSE && is_file( $ruta_archivo ) )
                                            $imagenes[ $p ][ $carpeta_lado]['archivo']       = $archivo;

                                        // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_protocolo_lado.'/'.$carpeta_lado.".comment" ) ) {

                                            $h_comentario = fopen( $ruta_protocolo_lado.'/'.$carpeta_lado.".comment", 'r' );
                                            $observacion  = fread( $h_comentario, filesize( $ruta_protocolo_lado.'/'.$carpeta_lado.".comment" )  );
                                            fclose( $h_comentario );
                                            $imagenes[ $p ][ $carpeta_lado]['observaciones']   = $observacion;
                                        }

                                        // Abandona ciclo, solo 1 archivo.
//                                        break;
                                    }
                                }

                                closedir( $archivos );
                            }
                        }
                    }

                    if( $carpeta_protocolo && $protocolo == Platc::$OFTALMOLOGICO_PROTOCOLOS['TINCION_FLUORESCENCIA'] ||
                        $carpeta_protocolo && $protocolo == Platc::$OFTALMOLOGICO_PROTOCOLOS['FRONTAL_CARA'] ) {

                        // Recorre las carpetas de imagenes parciales ($hash_borrador)
                        while( false !== ( $hash_borrador = readdir( $carpeta_protocolo ) ) ) {

                            $carpeta_lado = FALSE;

                            $ruta_protocolo_lado = $ruta_protocolo.'/'.$hash_borrador;
                            if( !empty( $carpeta_protocolo ) && is_dir( $ruta_protocolo_lado ) &&
                                $hash_borrador != '.' && $hash_borrador != '..' ) {

                                $observacion = '';

                                // Recorre buscando el archivo de imagen
                                $archivos = opendir( $ruta_protocolo_lado );
                                while( false !== ( $archivo = readdir( $archivos ) ) ) {

                                    if( !empty( $archivo ) && $archivo != '.' && $archivo != '..' &&
                                        $archivo != Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADOS'] &&
                                        strpos( $archivo, "thumb_" ) === FALSE ) {

                                        $ruta_archivo = $ruta_protocolo_lado.'/'.$archivo;

                                        // Si es un archivo de imagen (que no tiene .comment)
                                        if( strpos( $archivo, ".comment" ) === FALSE && is_file( $ruta_archivo ) )
                                            $imagenes[ $p ][ $hash_borrador]['archivo']       = $archivo;

                                        // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_protocolo_lado."/observaciones.comment" ) ) {

                                            $h_comentario = fopen( $ruta_protocolo_lado."/observaciones.comment", 'r' );
                                            $observacion  = fread( $h_comentario, filesize( $ruta_protocolo_lado."/observaciones.comment" )  );
                                            fclose( $h_comentario );
                                            $imagenes[ $p ][ $hash_borrador]['observaciones']   = $observacion;
                                        }

                                        // Si es archivo de lateralidad del ojo (si existe archivo "lateralidad.comment")
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_protocolo_lado."/lateralidad_ojo.comment" ) ) {

                                            $h_lateralidad = fopen( $ruta_protocolo_lado."/lateralidad_ojo.comment", 'r' );
                                            $lateralidad  = fread( $h_lateralidad, filesize( $ruta_protocolo_lado."/lateralidad_ojo.comment" )  );
                                            fclose( $h_lateralidad );
                                            $imagenes[ $p ][ $hash_borrador]['lateralidad_ojo']   = $lateralidad;
                                        }

                                        // Abandona ciclo, solo 1 archivo.
//                                        break;
                                    }
                                }

//                                closedir( $archivos );
                            }
                        }
                    }

                    closedir( $carpeta_protocolo );
                }
            }

            closedir($handle);
        }
//imprimir( $imagenes );
        return $imagenes;
    }

    //TC ADMIN
    public function tc_admin_actualizar( $id_tc, $id_paciente, $id_establecimiento ) {

        $estado = TRUE;
        $tc = $this->tc_get( $id_tc );

        if( !empty( $id_establecimiento ) && (int)$id_establecimiento != (int)$tc['ETB_ID'] ) {

            $data['ETB_ID'] = (int)$id_establecimiento;
            $this->db->where( 'TEL_ID', $id_tc );
            $this->db->update( 'TC_TELECONSULTA', $data );

            // Deja constancia del cambio
            $data = array( );
            $data['TEL_ID'] = $id_tc;
            $data['EST_ID'] = $tc['EST_ID'];
            $data['PRI_ID'] = $tc['PRI_ID'];
            $data['USU_ID'] = $this->session->userdata('USU_ID');
            $data['TEP_FECHA_HORA'] = date( 'Y-m-d H:i:s' );

            $e_ori  = $this->establecimiento_get( (int) $tc['ETB_ID'] );
            $e_dest = $this->establecimiento_get( (int) $id_establecimiento );
            $info_comentario = sprintf( $this->lang->line('tc_admin_coment_cambiar_paciente'), (string)$e_ori['ETB_NOMBRE'], (string)$e_dest['ETB_NOMBRE'] );
            $data['TEP_COMENTARIO']     = $info_comentario;

            $info_tecnico = sprintf( $this->lang->line('tc_admin_info_cambiar_paciente'), (int)$e_ori['ETB_ID'], (string)$e_ori['ETB_NOMBRE'], (int)$e_dest['ETB_ID'], (string)$e_dest['ETB_NOMBRE'] );
            $data['TEP_INFO_TECNICO']   = $info_tecnico;
            $this->tc_estado_set( $data );
        }

        if( !empty( $id_paciente ) && (int)$id_paciente != (int)$tc['PAC_ID'] ) {

            //consultamos info paciente
            $this->db->where( 'PAC_ID', $id_paciente );
            $query = $this->db->get('TC_PACIENTE');

            if( $query->num_rows() > 0 ) {

                $paciente = $query->row_array();

                //Afiliacion: necesario para tabla TC_TELECONSULTA
                $this->db->where( 'AFI_ID', $paciente['AFI_ID'] );
                $query = $this->db->get( 'TC_AFILIACION' );
                $afi = $query->row_array();

                $data = array(
                    'PAC_ID' => $id_paciente,
                    'TEL_PAC_PRIMER_NOMBRE'     => $paciente['PAC_PRIMER_NOMBRE'],
                    'TEL_PAC_SEGUNDO_NOMBRE'    => $paciente['PAC_SEGUNDO_NOMBRE'],
                    'TEL_PAC_PRIMER_APELLIDO'   => $paciente['PAC_PRIMER_APELLIDO'],
                    'TEL_PAC_SEGUNDO_APELLIDO'  => $paciente['PAC_SEGUNDO_APELLIDO'],
                    'TEL_PAC_NACIMIENTO'        => $paciente['PAC_NACIMIENTO'],
                    'TEL_PAC_EDAD'              => $this->util->yearscalc($paciente['PAC_NACIMIENTO']),
                    'TEL_PAC_SEXO'              => $paciente['PAC_SEXO'],
                    'TEL_PAC_TELEFONO'          => $paciente['PAC_TELEFONO'],
                    'TEL_PAC_EMAIL'             => $paciente['PAC_EMAIL'],
                    'TEL_PAC_PROCEDENCIA'       => $paciente['PAC_PROCEDENCIA'],
                    'TEL_PAC_OCUPACION'         => $paciente['PAC_OCUPACION'],
                    'TEL_PAC_AFI_NOMBRE'        => $afi['AFI_NOMBRE']
                );

                $this->db->where( 'TEL_ID', $id_tc );
                $this->db->update( 'TC_TELECONSULTA', $data );

                // Deja constancia del cambio
                $data = array( );
                $data['TEL_ID'] = $id_tc;
                $data['EST_ID'] = $tc['EST_ID'];
                $data['PRI_ID'] = $tc['PRI_ID'];
                $data['USU_ID'] = $this->session->userdata('USU_ID');
                $data['TEP_FECHA_HORA'] = date( 'Y-m-d H:i:s' );

                // Comentario
                $info_tecnico = $this->lang->line('tc_cambio_paciente'). "\n";
                $info_tecnico.= $this->lang->line('tc_nom_ape').": %s %s %s %s\n";
                $info_tecnico.= $this->lang->line('p_fecha_nacimiento'). ": %s, ".$this->lang->line('p_edad').": %s, ";
                $info_tecnico.= $this->lang->line('p_sexo'). ": %s\n";
                $info_tecnico.= $this->lang->line('p_telefono'). ": %s, ";
                $info_tecnico.= $this->lang->line('p_email'). ": %s\n";
                $info_tecnico.= $this->lang->line('p_procedencia'). ": %s, ";
                $info_tecnico.= $this->lang->line('p_ocupacion'). ": %s\n";

                $info_tecnico.= "\n" . $this->lang->line('tc_a') . "\n\n";
                $info_tecnico.= $this->lang->line('tc_nom_ape'). ": %s %s %s %s\n";
                $info_tecnico.= $this->lang->line('p_fecha_nacimiento'). ": %s, ".$this->lang->line('p_edad').": %s, ";
                $info_tecnico.= $this->lang->line('p_sexo'). ": %s\n";
                $info_tecnico.= $this->lang->line('p_telefono'). ": %s, ";
                $info_tecnico.= $this->lang->line('p_email'). ": %s\n";
                $info_tecnico.= $this->lang->line('p_procedencia'). ": %s, ";
                $info_tecnico.= $this->lang->line('p_ocupacion'). ": %s\n";

                $data['TEP_COMENTARIO'] = sprintf(  $info_tecnico,
                                                    $tc['TEL_PAC_PRIMER_NOMBRE'],
                                                    $tc['TEL_PAC_SEGUNDO_NOMBRE'],
                                                    $tc['TEL_PAC_PRIMER_APELLIDO'],
                                                    $tc['TEL_PAC_SEGUNDO_APELLIDO'],
                                                    $tc['TEL_PAC_NACIMIENTO'],
                                                    $tc['TEL_PAC_EDAD'],
                                                    ( $tc['TEL_PAC_SEXO'] == 'M' ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino'),
                                                    $tc['TEL_PAC_TELEFONO'],
                                                    $tc['TEL_PAC_EMAIL'],
                                                    $tc['TEL_PAC_PROCEDENCIA'],
                                                    $tc['TEL_PAC_OCUPACION'],

                                                    $paciente['PAC_PRIMER_NOMBRE'],
                                                    $paciente['PAC_SEGUNDO_NOMBRE'],
                                                    $paciente['PAC_PRIMER_APELLIDO'],
                                                    $paciente['PAC_SEGUNDO_APELLIDO'],
                                                    $paciente['PAC_NACIMIENTO'],
                                                    $this->util->yearscalc( $paciente['PAC_NACIMIENTO'] ),
                                                    ( $paciente['PAC_SEXO'] == 'M' ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino'),
                                                    $paciente['PAC_TELEFONO'],
                                                    $paciente['PAC_EMAIL'],
                                                    $paciente['PAC_PROCEDENCIA'],
                                                    $paciente['PAC_OCUPACION'] );

                // Información técnica del cambio
                $info_tecnico = "Cambio de paciente, de \n";
                $info_tecnico.= "TEL_PAC_PRIMER_NOMBRE [%s],\n";
                $info_tecnico.= "TEL_PAC_SEGUNDO_NOMBRE [%s],\n";
                $info_tecnico.= "TEL_PAC_PRIMER_APELLIDO [%s],\n";
                $info_tecnico.= "TEL_PAC_SEGUNDO_APELLIDO [%s],\n";
                $info_tecnico.= "TEL_PAC_NACIMIENTO [%s],\n";
                $info_tecnico.= "TEL_PAC_SEXO [%s],\n";
                $info_tecnico.= "TEL_PAC_TELEFONO [%s],\n";
                $info_tecnico.= "TEL_PAC_EMAIL [%s],\n";
                $info_tecnico.= "TEL_PAC_PROCEDENCIA [%s],\n";
                $info_tecnico.= "TEL_PAC_OCUPACION [%s],\n";
                $info_tecnico.= "TEL_PAC_AFI_NOMBRE [%s],\n";
                $info_tecnico.= "AFI_ID [%s],\n";
                $info_tecnico.= "TEL_PAC_EDAD [%s],\n";

                $info_tecnico.= "a\n";
                $info_tecnico.= "PAC_PRIMER_NOMBRE [%s],\n";
                $info_tecnico.= "PAC_SEGUNDO_NOMBRE [%s],\n";
                $info_tecnico.= "PAC_PRIMER_APELLIDO [%s],\n";
                $info_tecnico.= "PAC_SEGUNDO_APELLIDO [%s],\n";
                $info_tecnico.= "PAC_NACIMIENTO [%s],\n";
                $info_tecnico.= "PAC_SEXO [%s],\n";
                $info_tecnico.= "PAC_TELEFONO [%s],\n";
                $info_tecnico.= "PAC_EMAIL [%s],\n";
                $info_tecnico.= "PAC_PROCEDENCIA [%s],\n";
                $info_tecnico.= "PAC_OCUPACION [%s],\n";
                $info_tecnico.= "PAC_AFI_NOMBRE [%s],\n";
                $info_tecnico.= "AFI_ID [%s],\n";
                $info_tecnico.= "TEL_PAC_EDAD [%s]";

                $data['TEP_INFO_TECNICO'] = sprintf($info_tecnico,
                                                    $tc['TEL_PAC_PRIMER_NOMBRE'],
                                                    $tc['TEL_PAC_SEGUNDO_NOMBRE'],
                                                    $tc['TEL_PAC_PRIMER_APELLIDO'],
                                                    $tc['TEL_PAC_SEGUNDO_APELLIDO'],
                                                    $tc['TEL_PAC_NACIMIENTO'],
                                                    $tc['TEL_PAC_SEXO'],
                                                    $tc['TEL_PAC_TELEFONO'],
                                                    $tc['TEL_PAC_EMAIL'],
                                                    $tc['TEL_PAC_PROCEDENCIA'],
                                                    $tc['TEL_PAC_OCUPACION'],
                                                    $tc['TEL_PAC_AFI_NOMBRE'],
                                                    $tc['AFI_ID'],
                                                    $tc['TEL_PAC_EDAD'],

                                                    $paciente['PAC_PRIMER_NOMBRE'],
                                                    $paciente['PAC_SEGUNDO_NOMBRE'],
                                                    $paciente['PAC_PRIMER_APELLIDO'],
                                                    $paciente['PAC_SEGUNDO_APELLIDO'],
                                                    $paciente['PAC_NACIMIENTO'],
                                                    $paciente['PAC_SEXO'],
                                                    $paciente['PAC_TELEFONO'],
                                                    $paciente['PAC_EMAIL'],
                                                    $paciente['PAC_PROCEDENCIA'],
                                                    $paciente['PAC_OCUPACION'],
                                                    $afi['AFI_NOMBRE'],
                                                    $afi['AFI_ID'],
                                                    $this->util->yearscalc( $paciente['PAC_NACIMIENTO'] ) );

                $this->tc_estado_set( $data );

                $estado = TRUE;
            }
        }

        return $estado;
    }

    public function plantilla_email_get( $id_site, $id_estado ) {

        $resultado = $this->db->get_where( 'TC_PLANTILLA_EMAIL', array( 'SIT_ID' => $id_site, 'EST_ID' => $id_estado ) );
        if( $resultado->num_rows() > 0 )
            return $resultado->row_array( );
        else {

            throw new Exception( $this->lang->line('plantilla_email_error') );
        }
    }

    /*
     * PE: Formulario de oftalmología
     */
    public function pe_oftalmologia_colores_get( ) {

        return array(  1=>$this->lang->line('oftalmologia_rosa'), 2=> $this->lang->line('oftalmologia_palido') );
    }

    public function pe_oftalmologia_color_get( $id_color ) {

        return element( $id_color, $this->pe_oftalmologia_colores_get( ) );
    }

    public function pe_oftalmologia_bordes_get( ) {

        return array(  1=>$this->lang->line('oftalmologia_definidos'), 2=> $this->lang->line('oftalmologia_indefinidos'), 3=> $this->lang->line('oftalmologia_degeneracion_peripapilar') );
    }

    public function pe_oftalmologia_borde_get( $id_borde ) {

        return element( $id_borde, $this->pe_oftalmologia_bordes_get( ) );
    }

    public function pe_oftalmologia_zonas_maculares_get(  ) {

        return array(  1 => 'Normal', 2 => 'Lesión hipercrómica',
                        3 => 'Edema',  4 => 'Exudado',
                        5 => 'Adelgazada',  6 => 'Agujero',
                        7 => 'Hemorragia',  8 => 'Drussen ' );
    }

    public function pe_oftalmologia_zona_macular_get( $id_zona_macular ) {

        return element( $id_zona_macular, $this->pe_oftalmologia_zonas_maculares_get( ) );
    }

    public function pe_oftalmologia_retinas_get( ) {

        return array(   1 => $this->lang->line('oftalmologia_aplicada'),
                        2 => $this->lang->line('oftalmologia_desprendida'),
                        3 => $this->lang->line('oftalmologia_otras_lesiones') );
    }

    public function pe_oftalmologia_retina_get( $id_retina ) {

        return element( $id_retina , $this->pe_oftalmologia_retinas_get( ) );
    }

    public function pe_oftalmologia_diagnosticos_get( ) {

        return array(   1 => $this->lang->line('oftalmologia_fondo_ojo_normal'),
                        2 => $this->lang->line('oftalmologia_retinopatia_hipertensiva_i'),
                        3 => $this->lang->line('oftalmologia_retinopatia_hipertensiva_ii'),
                        4 => $this->lang->line('oftalmologia_retinopatia_hipertensiva_iii'),
                        5 => $this->lang->line('oftalmologia_retinopatia_hipertensiva_iv'),
                        6 => $this->lang->line('oftalmologia_retinopatia_diabetica_no_proliferativa'),
                        7 => $this->lang->line('oftalmologia_retinopatia_diabetica_proliferativa'),
                        8 => $this->lang->line('oftalmologia_maculopatia'),
                        9 => $this->lang->line('oftalmologia_neuropatia_optica'),
                       10 => $this->lang->line('oftalmologia_otras_retinopatias'),
                       11 => $this->lang->line('oftalmologia_otros_diagnosticos') );
    }

    public function pe_oftalmologia_diagnostico_get( $id_diagnostico ) {

        return element( $id_diagnostico, $this->pe_oftalmologia_diagnosticos_get( ) );
    }

    public function pe_oftalmologia_controles_get( ) {

        return array(   1 => $this->lang->line('oftalmologia_anual'),
                        2 => $this->lang->line('oftalmologia_semestral'),
                        3 => $this->lang->line('oftalmologia_trimestral'),
                        4 => $this->lang->line('oftalmologia_unidad_retina') );
    }

    public function pe_oftalmologia_control_get( $id_control ) {

        return element( $id_control, $this->pe_oftalmologia_controles_get( ) );
    }

    /*
     *
     */
    public function pe_oftalmologia_imagenes_obtener( $tel_id ) {

        $lado   = array( );

        $ruta = 'files/oftalmologia/'.$tel_id;
//        $ruta.= ( $borrador ) ? '/'.Platc::$OFTALMOLOGICO_PROTOCOLOS['BORRADORES'].'/' : '/';
        $carpeta_oftalmologia = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $carpeta_oftalmologia ) {

            // Recorre todas las lesiones
//            while( false !== ( $hash_borrador = readdir( $handle ) ) ) {

//                if( $hash_borrador != '.' && $hash_borrador != '..' ) {

//                    $ruta_lesiones = $ruta.$hash_borrador;
//                    $carpeta_lesiones = opendir( $ruta_lesiones );
//                    if( $carpeta_lesiones ) {

                        // Recorre las carpetas de protocolo (estructura externa, fondo del ojo, ...)
                        while( false !== ( $carpeta_lado = readdir( $carpeta_oftalmologia ) ) ) {

                            $carpeta_foto = FALSE;

                            $ruta_carpeta_lado = $ruta.'/'.$carpeta_lado;
                            if( !empty( $carpeta_lado ) && is_dir( $ruta_carpeta_lado ) && $carpeta_lado != '.' && $carpeta_lado != '..' ) {

                                $observacion = '';

                                switch( $carpeta_lado ) {

                                    case Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'] : {
                                        $carpeta_foto = Platc::$OFTALMOLOGICO_LADO['IZQUIERDO'];
                                    } break;

                                    case Platc::$OFTALMOLOGICO_LADO['DERECHO'] : {
                                        $carpeta_foto = Platc::$OFTALMOLOGICO_LADO['DERECHO'];
                                    } break;

                                    default: break;
                                }

//                                if( !$carpeta_foto ) continue;

                                // Recorre buscando el archivo de imagen
                                $archivos = opendir( $ruta_carpeta_lado );
                                while( false !== ( $archivo = readdir( $archivos ) ) ) {

                                    if( !empty( $archivo ) && $archivo != '.' && $archivo != '..' &&
                                        strpos( $archivo, "thumb_" ) === FALSE ) {

                                        $ruta_archivo = $ruta_carpeta_lado.'/'.$archivo;

                                        // Si es un archivo de imagen (que no tiene .comment)
                                        if( strpos( $archivo, ".comment" ) === FALSE && is_file( $ruta_archivo ) )
                                            $lado[ $carpeta_foto ]['archivo']       = $archivo;

                                        // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_carpeta_lado.'/'.$carpeta_foto.".comment" ) ) {

                                            $h_comentario = fopen( $ruta_carpeta_lado.'/'.$carpeta_foto.".comment", 'r' );
                                            $observacion  = fread( $h_comentario, filesize( $ruta_carpeta_lado.'/'.$carpeta_foto.".comment" )  );
                                            fclose( $h_comentario );
                                            $lado[ $carpeta_foto ]['observacion']   = $observacion;
                                        }

                                        // Abandona ciclo, solo 1 archivo.
//                                        break;
                                    }
                                }

                                closedir( $archivos );
                            }
                        }
//                    }

//                    closedir( $carpeta_oftalmologia );
//                }
//            }

            closedir($carpeta_oftalmologia);
        }

        return $lado;
    }

    /**
     * PE: Guarda respuestas de teleconsulta
     * Usa misma organización de datos de formularios
     */
    public function tc_agregar_data_respuesta( $id_teleconsulta, $data ) {

        $bulk_data = array( );
        if( !empty( $data ) ) {
            foreach( $data as $key => $value  ) {
                $d = array( );
                $d['TEL_ID']    = $id_teleconsulta;
                $d['TD_CLAVE']  = $key;
                $d['TD_VALOR']  = $value;

                $bulk_data[] = $d;
            }
            $this->db->insert_batch( 'TC_TELECONSULTA_DATA_RESPUESTA', $bulk_data );
        }
    }

    /**
     * PE: Obtiene respuestas de teleconsulta
     * Usa misma organización de datos de formularios
     */
    public function tc_obtener_data_respuesta( $id_teleconsulta ) {

        $this->db->where( array( 'TEL_ID' => $id_teleconsulta ) );
        $query = $this->db->get( 'TC_TELECONSULTA_DATA_RESPUESTA' );
        if( $query->num_rows() > 0 ) {

            $data = array( );
            foreach( $query->result_array( ) as $v ) {
                $data[ $v['TD_CLAVE'] ] = $v['TD_VALOR'];
            }

            return $data;
        }
        else
            return NULL;
    }

    /**
     * PE: Elimina respuestas de teleconsulta
     * Usa misma organización de datos de formularios
     */
    public function tc_borrar_data_respuesta( $id_teleconsulta, $campo = null, $valor = null ) {

        $filtro = array( 'TEL_ID' => (int)$id_teleconsulta );
        if( !empty( $campo ) ) {

            $filtro['TD_CLAVE'] = $campo;
            if( $valor != null ) $filtro['TD_VALOR'] = $valor;
        }

        $this->db->where( $filtro );
        $query = $this->db->delete( 'TC_TELECONSULTA_DATA_RESPUESTA' );

        return TRUE;
    }

    /*
     * Recetarios
     */
    public function recetario_formulas_medicamentos_tc_get( $tel_id, $sin_eliminados = TRUE ) {

        $sql = "SELECT  rfm.*
                FROM    TC_RECETA r
                        INNER JOIN ( TC_RECETA_FORMULA rf
                            INNER JOIN TC_RECETA_FORMULA_MEDICAMENTO rfm ON ( rfm.RFM_ID = rf.RFM_ID )
                        ) ON ( rf.REC_ID = r.REC_ID )
                WHERE   r.TEL_ID = " . (int)$tel_id . "
                    AND r.REC_TIPO = '" . (string)Platc::$RECETARIO_TIPO['FORMULA'] . "'
                    AND r.SIT_ID = " . (int)$this->session->userdata('SIT_ID')." ";

        if( $sin_eliminados )
            $sql.= "AND r.REC_ELIMINADO = 0";

        $query = $this->db->query( $sql );
        return $query->result_array();
    }

    /*
     * Recetas y sus solicitudes
     */
    public function recetas_solicitudes_tc_get( $tel_id, $sin_eliminados = TRUE ) {

        $sql = "SELECT  rfm.*
        FROM    TC_RECETA r
        INNER JOIN TC_RECETA_FORMULA_RECETARIO rfm ON ( rfm.REC_ID = r.REC_ID )
        WHERE   r.TEL_ID =" . (int)$tel_id . "
        AND r.REC_TIPO = '" . (string)Platc::$RECETARIO_TIPO['RECETA'] . "'
        AND r.SIT_ID = " . (int)$this->session->userdata('SIT_ID')." ";
	
        if( $sin_eliminados )
            $sql.= "AND r.REC_ELIMINADO = 0";

        $query = $this->db->query( $sql );
        return $query->result_array();
    }

    public function recetario_formulas_get( $tel_id, $sin_eliminados = TRUE ) {

        $sql = "SELECT  r.*,
		rfm.RFM_NOMBRE_GENERICO,
		rfm.RFM_CONCENTRACION
                FROM    TC_RECETA r
		INNER JOIN TC_RECETA_FORMULA rf ON r.REC_ID = rf.REC_ID
		INNER JOIN TC_RECETA_FORMULA_MEDICAMENTO rfm ON rf.RFM_ID = rfm.RFM_ID
                WHERE   r.TEL_ID = " . (int)$tel_id . "
                    AND r.REC_TIPO = '" . (string)Platc::$RECETARIO_TIPO['FORMULA'] . "'
                    AND r.SIT_ID = " . (int)$this->session->userdata('SIT_ID')." ";
					
        if( $sin_eliminados )
            $sql.= "AND r.REC_ELIMINADO = 0";

	$sql .= " GROUP BY r.REC_ID";

        $query = $this->db->query( $sql );
        return $query->result_array();
    }

    public function recetario_get( $id_receta, $sin_eliminados = TRUE ) {

        $sql = "SELECT  r.*
                FROM    TC_RECETA r
                WHERE   r.REC_ID = " . (int)$id_receta . "
                    AND r.SIT_ID = " . (int)$this->session->userdata('SIT_ID')." ";

        if( $sin_eliminados )
            $sql.= "AND r.REC_ELIMINADO = 0";

        $query = $this->db->query( $sql );
        return $query->row_array();
    }

    public function recetario_formula_get( $id_receta ) {

        $sql = "SELECT  r.TEL_ID, rf.*
                FROM    TC_RECETA r
                        INNER JOIN TC_RECETA_FORMULA rf ON ( r.REC_ID = rf.REC_ID )
                WHERE   r.REC_ID = " . (int)$id_receta . "
                    AND r.SIT_ID = " . (int)$this->session->userdata('SIT_ID'). " ";

        $query = $this->db->query( $sql );
        return $query->row_array();
    }

    public function recetario_crear( $tel_id, $tipo, $id_medico_generalista, $id_medico_especialista,
                                     $paciente_telefono, $paciente_id_municipio, $paciente_direccion_residencia,
                                     $nombre_recetario, $solicitudes = NULL, $nombre_formula = NULL ) {

        $this->db->set( 'TEL_ID', $tel_id );
        $this->db->set( 'SIT_ID', $this->session->userdata('SIT_ID') );
        $this->db->set( 'REC_TIPO', (string)$tipo );
        $this->db->set( 'REC_FECHA', 'now()', FALSE );
        $this->db->set( 'USU_ID_GENERALISTA', $id_medico_generalista );
        $this->db->set( 'USU_ID_ESPECIALISTA', $id_medico_especialista );
        $this->db->set( 'PAC_TELEFONO', $paciente_telefono );
        $this->db->set( 'MUNI_ID', $paciente_id_municipio );
        $this->db->set( 'PAC_DIRECCION_RESIDENCIA', $paciente_direccion_residencia );
		

        // Nombre Recetario
        if( !empty( $nombre_recetario ) )
            $this->db->set( 'RF_NOMBRE', $nombre_recetario );

        $this->db->insert( 'TC_RECETA' );

        return $this->db->insert_id();
    }

    public function recetario_formula_medicamento_crear( $rec_id, $nombre_generico, $concentracion, $forma_farmaceutica,
                                                         $dosis, $via_administracion, $cantidad_numeros, $cantidad_letras ) {

        // Genera información del medicamento
        $datos = array( 'RFM_NOMBRE_GENERICO'      => $nombre_generico,
                        'RFM_CONCENTRACION'        => $concentracion,
                        'RFM_FORMA_FARMACEUTICA'   => $forma_farmaceutica,
                        'RFM_DOSIS'                => $dosis,
                        'RFM_VIA_ADMINISTRACION'   => $via_administracion,
                        'RFM_CANTIDAD_NUMEROS'     => $cantidad_numeros,
                        'RFM_CANTIDAD_LETRAS'      => $cantidad_letras);

        $this->db->insert( 'TC_RECETA_FORMULA_MEDICAMENTO', $datos );
        $id_medicamento = $this->db->insert_id();

        // Asocia medicamento con la fórmula (receta)
        $datos = array( 'REC_ID' => $rec_id,
                        'RFM_ID' => $id_medicamento);

        $this->db->insert( 'TC_RECETA_FORMULA', $datos );
    }

    public function recetario_solicitudes_crear( $rec_id = '', $solicitudes = '' ) {

        // Genera información de las solicitudes
        $datos = array( 'REC_ID'           => $rec_id,
                        'RFR_SOLICITUDES'  => $solicitudes);

        $this->db->insert( 'TC_RECETA_FORMULA_RECETARIO', $datos );
    }

    public function recetario_formula_medicamentos_get( $rec_id ) {

        $sql = "SELECT  rfm.* 
                FROM    TC_RECETA_FORMULA rf
                            INNER JOIN TC_RECETA_FORMULA_MEDICAMENTO rfm ON ( rfm.RFM_ID = rf.RFM_ID )
                WHERE   rf.REC_ID = ".(int)$rec_id;

        $query = $this->db->query( $sql );
        if( (int)$query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }

    public function recetario_editar( $id_receta, $paciente_telefono, $paciente_id_municipio, $paciente_direccion_residencia, $nombre_recetario, $solicitudes = NULL) {

        $receta = $this->recetario_get( $id_receta );
        $this->recetario_eliminar( $id_receta );
        return $this->recetario_crear( $receta['TEL_ID'], $receta['REC_TIPO'], $receta['USU_ID_GENERALISTA'],
                                       $receta['USU_ID_ESPECIALISTA'], $paciente_telefono, $paciente_id_municipio, $paciente_direccion_residencia, $nombre_recetario, null, null );
    }

    public function recetario_formula_editar( $rec_id, $nombre_generico, $concentracion, $forma_farmaceutica,
                                              $dosis, $via_administracion, $cantidad_numeros, $cantidad_letras ) {

        return $this->recetario_formula_crear( $rec_id, $nombre_generico, $concentracion, $forma_farmaceutica,
                                               $dosis, $via_administracion, $cantidad_numeros, $cantidad_letras );
    }

    public function recetario_eliminar( $id_receta ) {

        $this->db->where( 'REC_ID', $id_receta );
        return $this->db->update( 'TC_RECETA', array( 'REC_ELIMINADO' => 1 ) );
    }

    public function recetario_eliminar_por_tc_id( $id_tc ) {

        $this->db->where( 'TEL_ID', $id_tc );
		$this->db->where( 'REC_TIPO', 'receta' );
        return $this->db->update( 'TC_RECETA', array( 'REC_ELIMINADO' => 1 ) );
    }

    public function recetarios_get( $tel_id, $sin_eliminados = TRUE ) {

        $sql = "SELECT  r.*
                FROM    TC_RECETA r
                WHERE   r.TEL_ID = " . (int)$tel_id . "
                    AND r.REC_TIPO = '" . (string)Platc::$RECETARIO_TIPO['RECETA'] . "'
                    AND r.SIT_ID = " . (int)$this->session->userdata('SIT_ID')." ";

        if( $sin_eliminados )
            $sql.= "AND r.REC_ELIMINADO = 0";

        $query = $this->db->query( $sql );
        return $query->result_array();
    }

    /**
     * Este método retorna listado de recetas asociados a una TC.
     *
     * @param type $id_teleconsulta Identificador (folio) del a teleconsulta
     * @return type array Listado de recetas
     */
    public function recetas_get( $id_teleconsulta ) {

        $listado_recetas = array( );

        $query = $this->db->get_where( 'TC_RECETA', array( 'TEL_ID' => (int)$id_teleconsulta, 'REC_TIPO' => 'receta', 'REC_ELIMINADO' => 0 ) );

//       imprimir($query->result_array());

        $datos = array();
        $i = 0;
        if( $query->num_rows() > 0 ) {

            foreach( $query->result_array() as $r ) {

                $datos[$i]['receta'] = $this->recetario_get( $r['REC_ID'] );

                $datos[$i]['receta']['receta_solicitudes'] = $this->recetas_solicitudes_tc_get( $r['TEL_ID'] );
                $datos[$i]['receta']['fecha_d'] = element( 2, explode( '-', substr( $datos[$i]['receta']['REC_FECHA'], 0, 10 ) ) );
                $datos[$i]['receta']['fecha_m'] = element( 1, explode( '-', substr( $datos[$i]['receta']['REC_FECHA'], 0, 10 ) ) );
                $datos[$i]['receta']['fecha_a'] = element( 0, explode( '-', substr( $datos[$i]['receta']['REC_FECHA'], 0, 10 ) ) );

                $tc = $this->tc_get( (int)$datos[$i]['receta']['TEL_ID'] );
//                $tc']         = $tc;
                $tc['data']    = $this->tc_obtener_data( (int)$tc['TEL_ID'] );

                // Agrega códigos CIE10
                if( !empty( $tc['data']['dm_general'] ) ) {
                        $cie_id = $this->cie10_get( json_decode( $tc['data']['dm_general'] ) );
                        $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
                        unset( $cie_id[''] ); // Elimina elemento vacío
                        $tc['data']['dm_general'] = $cie_id;
                }

                /*
                 * Datos del paciente
                 */
                $datos[$i]['paciente']      = $this->paciente_get( (int)$tc['PAC_ID'] );
                $datos[$i]['paciente_identificadores'] = $this->paciente_identificadores_get( (int)$tc['PAC_ID'] );
                $datos[$i]['municipio']     = $this->municipio_get( (string)$datos[$i]['receta']['MUNI_ID'] );
                $datos[$i]['entidad_administradora']    = $this->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

                /*
                 * Datos médico Generalista (Profesional que remite el caso)
                 */
                $datos[$i]['generalista'] = null;
                $datos[$i]['generalista'] = $this->usuario_get( (int)$datos[$i]['receta']['USU_ID_GENERALISTA'] );
                $datos[$i]['generalista_identificacion'] = $this->identificador_get( $datos[$i]['generalista']['IDT_ID'] );

                // Datos médico Especialista (Profesional)
                $datos[$i]['especialista']  = $this->usuario_get( (int)$datos[$i]['receta']['USU_ID_ESPECIALISTA'] );
                $datos[$i]['especialista_identificacion'] = $this->identificador_get( $datos[$i]['especialista']['IDT_ID'] );

                $listado_recetas[] = $datos[$i];
                $i++;
            }
        }
        return $listado_recetas;
    }

    /**
     * Este método retorna listado de formulas asociados a una TC.
     *
     * @param type $id_teleconsulta Identificador (folio) del a teleconsulta
     * @return type array Listado de formulas
     */
    public function formulas_get( $id_teleconsulta ) {

        $listado_recetas = array( );

        $query = $this->db->get_where( 'TC_RECETA', array( 'TEL_ID' => (int)$id_teleconsulta, 'REC_TIPO' => 'formula', 'REC_ELIMINADO' => 0 ) );

//        imprimir($query->result_array());
        //imprimir($cant_formulas);

        $datos = array();
        $i = 0;
        if( $query->num_rows() > 0 ) {

            foreach( $query->result_array() as $r ) {

                $datos[$i]['receta'] = $this->recetario_get( $r['REC_ID'] );
                //$datos['receta'] = $this->recetario_formulas_get( $r['TEL_ID'] );

                $datos[$i]['receta_formula_medicamentos'] = $this->recetario_formula_medicamentos_get( $r['REC_ID'] );
//imprimir( $datos[$i]['receta_formula_medicamentos'] );
//                $datos['receta']['fecha_d'] = element( 2, explode( '-', substr( $r['REC_FECHA'], 0, 10 ) ) );
//                $datos['receta']['fecha_m'] = element( 1, explode( '-', substr( $r['REC_FECHA'], 0, 10 ) ) );
//                $datos['receta']['fecha_a'] = element( 0, explode( '-', substr( $r['REC_FECHA'], 0, 10 ) ) );
//                imprimir($datos['receta']);
                $datos[$i]['receta']['fecha_d'] = element( 2, explode( '-', substr( $datos[$i]['receta']['REC_FECHA'], 0, 10 ) ) );
                $datos[$i]['receta']['fecha_m'] = element( 1, explode( '-', substr( $datos[$i]['receta']['REC_FECHA'], 0, 10 ) ) );
                $datos[$i]['receta']['fecha_a'] = element( 0, explode( '-', substr( $datos[$i]['receta']['REC_FECHA'], 0, 10 ) ) );

                $tc = $this->tc_get( (int)$datos[$i]['receta']['TEL_ID'] );
//                $tc']         = $tc;
                $tc['data']    = $this->tc_obtener_data( (int)$tc['TEL_ID'] );

                // Agrega códigos CIE10
                if( !empty( $tc['data']['dm_general'] ) ) {
                        $cie_id = $this->cie10_get( json_decode( $tc['data']['dm_general'] ) );
                        $cie_id = $this->util->select_form_prepare( $cie_id, 'CIE_ID', 'descripcion');
                        unset( $cie_id[''] ); // Elimina elemento vacío
                        $tc['data']['dm_general'] = $cie_id;
                }

                /*
                 * Datos del paciente
                 */
                $datos[$i]['paciente']      = $this->paciente_get( (int)$tc['PAC_ID'] );
                $datos[$i]['paciente_identificadores'] = $this->paciente_identificadores_get( (int)$tc['PAC_ID'] );
                $datos[$i]['municipio']     = $this->municipio_get( (string)$datos[$i]['receta']['MUNI_ID'] );
                $datos[$i]['entidad_administradora']    = $this->entidad_administradora_get( (int)$tc['ENTADM_ID'] );

                /*
                 * Datos médico Generalista (Profesional que remite el caso)
                 */
                $datos[$i]['generalista'] = null;
                $datos[$i]['generalista'] = $this->usuario_get( (int)$datos[$i]['receta']['USU_ID_GENERALISTA'] );
                $datos[$i]['generalista_identificacion'] = $this->identificador_get( $datos[$i]['generalista']['IDT_ID'] );

                // Datos médico Especialista (Profesional)
                $datos[$i]['especialista']  = $this->usuario_get( (int)$datos[$i]['receta']['USU_ID_ESPECIALISTA'] );
                $datos[$i]['especialista_identificacion'] = $this->identificador_get( $datos[$i]['especialista']['IDT_ID'] );

                $listado_recetas[] = $datos[$i];

                $i++;
            }
        }

        return $listado_recetas;
    }

    /*
     * Facturación
     */

    /**
     * Encuentra pacientes que se han realizado exámenes en la plataforma
     *
     * @param string $fecha_ini Fecha inicial de corte del reporte
     * @param string $fecha_fin Fecha final   de corte del reporte
     * @param int $id_cliente Identificador del cliente (opcional)
     * @param int $id_establecimiento Identificador del establecimiento (opcional)
     * @param int $id_especialidad Identificador de la especialidad (opcional)
     * @return array Listado de
     */
    public function facturacion_rips_usuarios_serv( $id_site, $fecha_ini, $fecha_fin = NULL, $id_cliente = NULL, $id_establecimiento = NULL, $id_especialidad = NULL ) {

        $sql = " SELECT 
                        i.TIPO_IDENTIFICACION,
						pi.PAC_IDT_VALOR,
                        t.TEL_PAC_AFI_NOMBRE,
                        t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_SEGUNDO_NOMBRE,
                        t.TEL_PAC_EDAD, t.TEL_PAC_SEXO,
						m.DPTO_ID AS DEPTO_CODIGO,
						m.MUN_ID_REAL AS MUNI_ID,
                        t.ZON_ID,
						eadm.ENTADM_ID,
						ID_PACIENTE_TIPO

                FROM     TC_PACIENTE p
                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                            INNER JOIN TC_IDENTIFICADOR i ON ( i.IDT_ID = pi.IDT_ID )
                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        INNER JOIN ( TC_TELECONSULTA t ";

        if( !empty( $id_cliente ) )
            $sql.= "        INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID )";
        $sql.="         ) ON ( t.PAC_ID = p.PAC_ID ) ";
		
		$sql .= "
			LEFT JOIN TC_AFILIACION afi ON p.AFI_ID = afi.AFI_ID 
			LEFT JOIN TC_ENTIDADES_ADMINISTRADORAS eadm ON p.EA_ID = eadm.ENTADM_CORR 
			LEFT JOIN TC_MUNICIPIO_M m ON p.MUNI_ID = m.MUN_ID
			LEFT JOIN TC_DEPARTAMENTO_D d ON m.DPTO_ID = d.DPTO_ID
		";

        if( empty( $fecha_fin ) )
            $sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA  >= STR_TO_DATE( '".$fecha_ini." 00:00:00','%d-%m-%Y %H:%i:%s' ) ";
        else
            $sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA   BETWEEN STR_TO_DATE( '".$fecha_ini." 00:00:00','%d-%m-%Y %H:%i:%s' )
                                                        AND STR_TO_DATE( '".$fecha_fin." 23:59:59','%d-%m-%Y %H:%i:%s' )";

        // Filtro de cliente y establecimiento
        if( !empty( $id_cliente ) )
            $sql.= "   AND e.CLI_ID = ".(int)$id_cliente. " ";
        elseif( !empty( $id_establecimiento ) )
            $sql.= "   AND t.ETB_ID = ".(int)$id_establecimiento. " ";

        //
        if( !empty( $id_especialidad ) )
            $sql.= "   AND t.ESP_ID = ".(int)$id_especialidad. " ";

        //
        if( !empty( $id_site ) )
            $sql.= "   AND t.SIT_ID = ".(int)$id_site. " ";
		
		$sql.= " AND t.EST_ID = 7";
        $sql.=" GROUP BY t.TEL_ID";
		$sql.=" ORDER BY pi.PAC_IDT_VALOR;";
		
        $q = $this->db->query( $sql );
        if( $q->num_rows() > 0 )
            return $q->result_array();
        else
            return NULL;
    }

    /**
     * Encuentra pacientes............
     * @param string $fecha_ini Fecha inicial de corte del reporte
     * @param string $fecha_fin Fecha final   de corte del reporte
     * @param int $id_cliente Identificador del cliente (opcional)
     * @param int $id_establecimiento Identificador del establecimiento (opcional)
     * @param int $id_especialidad Identificador de la especialidad (opcional)
     * @return array Listado de
     */
    public function facturacion_rips_servicios_facturados( $id_site, $fecha_ini, $fecha_fin = NULL, $id_cliente = NULL, $id_establecimiento = NULL, $id_especialidad = NULL ) {

        $sql = "SELECT
                        null    -- codigo del prestador 'itms'
                        , null    -- razon social prestador 'itms'
                        , i.TIPO_IDENTIFICACION
                        , pi.PAC_IDT_VALOR
                        , null     -- numero de factura
                        , null    -- fecha expedicion (¿o emision?) de factura
                        , t.TEL_FECHA_HORA_ENVIO
                        , t.TEL_FECHA_HORA_RESPUESTA
                        , t.ENTADM_ID
                        , ea.ENTADM_NOMBRE
                        , null    -- numero del contrato
                        , null    -- plan beneficios
                        , null    -- numero de la poliza
                        , null    -- valor total copago
                        , null    -- valor total comision
                        , null     -- valor total descuento
                        , null     -- valor neto pagar por entidad contratante
                FROM    TC_PACIENTE p
                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                           INNER JOIN TC_IDENTIFICADOR i ON ( i.IDT_ID = pi.IDT_ID )
                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        INNER JOIN ( TC_TELECONSULTA t
                           LEFT JOIN TC_ENTIDADES_ADMINISTRADORAS ea ON ( ea.ENTADM_ID = t.ENTADM_ID ) ";

        if( !empty( $id_cliente ) )
            $sql.= "        INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID )";

        $sql.="         ) ON ( t.PAC_ID = p.PAC_ID ) ";

        if( empty( $fecha_fin ) )
            $sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA  >= STR_TO_DATE( '".$fecha_ini." 00:00:00','%d-%m-%Y %H:%i:%s' ) ";
        else
            $sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA   BETWEEN STR_TO_DATE( '".$fecha_ini." 00:00:00','%d-%m-%Y %H:%i:%s' )
                                                        AND STR_TO_DATE( '".$fecha_fin." 23:59:59','%d-%m-%Y %H:%i:%s' )";

        // Filtro de cliente y establecimiento
        if( !empty( $id_cliente ) )
            $sql.= "   AND e.CLI_ID = ".(int)$id_cliente. " ";
        elseif( !empty( $id_establecimiento ) )
            $sql.= "   AND t.ETB_ID = ".(int)$id_establecimiento. " ";

        //
        if( !empty( $id_especialidad ) )
            $sql.= "   AND t.ESP_ID = ".(int)$id_especialidad. " ";

        //
        if( !empty( $id_site ) )
            $sql.= "   AND t.SIT_ID = ".(int)$id_site. " ";

		$sql.= " AND t.EST_ID = 7";
		$sql.=" GROUP BY t.TEL_ID";
        $sql.=" ORDER BY pi.PAC_IDT_VALOR;";
//imprimir( $sql, false );
        $q = $this->db->query( $sql );
        if( $q->num_rows() > 0 )
            return $q->result_array();
        else
            return NULL;
    }

    /**
     *
     * @param string $fecha_ini Fecha inicial de corte del reporte
     * @param string $fecha_fin Fecha final   de corte del reporte
     * @param int $id_cliente Identificador del cliente (opcional)
     * @param int $id_establecimiento Identificador del establecimiento (opcional)
     * @param int $id_especialidad Identificador de la especialidad (opcional)
     * @return array Listado de
     */
    public function facturacion_rips_consulta( $id_site, $fecha_ini, $fecha_fin = NULL, $id_cliente = NULL, $id_establecimiento = NULL, $id_especialidad = NULL ) {

        $sql = "SELECT
                        null     -- numero de factura
                        , null    -- codigo del prestador 'itms'
                        , i.TIPO_IDENTIFICACION
                        , pi.PAC_IDT_VALOR
                        , t.TEL_FECHA_HORA_ENVIO
                        , t.TEL_CODIGO_AUTORIZACION
                        , null    -- codigo consulta
                        , null    -- finalidad de la consulta
                        , null    -- causa externa
                        , td.TD_VALOR
                        , cie10r1.TEL_CIE_ID_RESPUESTA
                        , null     -- cie10 respuesta nº2
                        , null     -- cie10 respuesta nº3
                   --     , 1        -- tipo de diagnostico principal
                        , null    -- valor consulta
                        , null    -- valor cuota moderadora
                        , null     -- valor neto a pagar
                FROM    TC_PACIENTE p
                        INNER JOIN ( TC_PACIENTE_IDENTIFICADOR pi
                            INNER JOIN TC_IDENTIFICADOR i ON ( i.IDT_ID = pi.IDT_ID )
                        ) ON ( pi.PAC_ID = p.PAC_ID )
                        INNER JOIN ( TC_TELECONSULTA t
                            LEFT JOIN TC_TELECONSULTA_DATA td ON ( td.TEL_ID = t.TEL_ID AND td.TD_CLAVE = 'dm_general' )
                            LEFT JOIN TC_TELECONSULTA_CIE10_RESPUESTA cie10r1 ON ( cie10r1.TEL_ID = t.TEL_ID ) ";

        if( !empty( $id_cliente ) )
            $sql.= "        INNER JOIN TC_ESTABLECIMIENTO e ON ( e.ETB_ID = t.ETB_ID ) ";

        $sql.="         ) ON ( t.PAC_ID = p.PAC_ID ) ";

        if( empty( $fecha_fin ) )
            $sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA  >= STR_TO_DATE( '".$fecha_ini." 00:00:00', '%d-%m-%Y %H:%i:%s' ) ";
        else
            $sql.= " WHERE t.TEL_FECHA_HORA_RESPUESTA   BETWEEN STR_TO_DATE( '".$fecha_ini." 00:00:00', '%d-%m-%Y %H:%i:%s' )
                                                        AND STR_TO_DATE( '".$fecha_fin." 23:59:59', '%d-%m-%Y %H:%i:%s' )";

        // Filtro de cliente y establecimiento
        if( !empty( $id_cliente ) )
            $sql.= "   AND e.CLI_ID = ".(int)$id_cliente. " ";
        elseif( !empty( $id_establecimiento ) )
            $sql.= "   AND t.ETB_ID = ".(int)$id_establecimiento. " ";

        //
        if( !empty( $id_especialidad ) )
            $sql.= "   AND t.ESP_ID = ".(int)$id_especialidad. " ";

        //
        if( !empty( $id_site ) )
            $sql.= "   AND t.SIT_ID = ".(int)$id_site. " ";

		$sql.= " AND t.EST_ID = 7";
		$sql.=" GROUP BY t.TEL_ID";
        $sql.=" ORDER BY pi.PAC_IDT_VALOR;";
//imprimir( $sql );
        $q = $this->db->query( $sql );
        if( $q->num_rows() > 0 )
            return $q->result_array();
        else
            return NULL;
    }

    /*
     * Tarjeta de coordenadas
     */

    /**
     * Genera matriz con valores de coordenadas al azar.
     *
     * @return array Arreglo con coordenadas
     */
    public function genera_coordendas( ) {

        $coordenadas=array();

        for($i=0;$i<5 ; $i++){
            for($j=0;$j<10;$j++){
                $coordenadas[$i][$j]=  rand(10, 99);
            }
        }
        return $coordenadas;
    }

    /*
     * Bolsas
     */

    /**
     *
     * @return array Listado de bolsas
     */
    public function bolsa_resumen( ) {

        $query = $this->db->get( 'TC_BOLSA' );
        return $query->row_array();
    }

    public function bolsas_get( $id_site, $eliminado = 0 ) {

        if( $eliminado == 0 )
            $this->db->where( 'BOL_ELIMINADO', 0 );

        $this->db->where( 'SIT_ID', (int)$id_site );
        $query = $this->db->get( 'TC_BOLSA' );
        return $query->result_array();
    }

    public function bolsa_get( $id_bolsa ) {

        $query = $this->db->get_where( 'TC_BOLSA', array( 'BOL_ID' => (int)$id_bolsa ) );
        return $query->row_array( );
    }

    /**
     *
     * @return array Listado de bolsas
     */
    public function bolsa_agregar( $id_site, $nombre, $descripcion, $fecha_inicio, $fecha_fin ) {

        $data['SIT_ID']             = $id_site;
        $data['BOL_NOMBRE']         = $nombre;
        $data['BOL_DESCRIPCION']    = $descripcion;
        $data['BOL_FECHA_INICIO']   = $fecha_inicio;
        $data['BOL_FECHA_FIN']      = $fecha_fin;
        $estado = $this->db->insert( 'TC_BOLSA', $data );

        if( $estado )
            return $this->db->insert_id();
        else
            return NULL;
    }

    /**
     *
     * @return array Listado de bolsas
     */
    public function bolsa_editar( $id_bolsa, $nombre, $descripcion, $fecha_inicio, $fecha_fin ) {

        $data['BOL_NOMBRE']         = $nombre;
        $data['BOL_DESCRIPCION']    = $descripcion;
        $data['BOL_FECHA_INICIO']   = $fecha_inicio;
        $data['BOL_FECHA_FIN']      = $fecha_fin;
        $this->db->where( 'BOL_ID', (int)$id_bolsa );
        $estado = $this->db->update( 'TC_BOLSA', $data );

        if( $estado )
            return true;
        else
            return NULL;
    }

    public function bolsa_clientes_get( $id_bolsa ) {

        $this->db->join( 'TC_CLIENTE c', 'c.CLI_ID = bc.CLI_ID' );
        $query = $this->db->get_where( 'TC_BOLSA_CLIENTE bc', array( 'bc.BOL_ID' => (int)$id_bolsa ) );

        if( $query->num_rows() > 0 )
            return $query->result_array( );
        else
            return NULL;
    }

    public function bolsa_cliente_agregar( $id_bolsa, $id_cliente ) {

        if( empty( $id_bolsa ) || empty( $id_cliente ) ) return NULL;

        if( !is_array( $id_cliente ) )
            $id_cliente = array( $id_cliente );

        $data = array( );
        foreach( $id_cliente as $v )
            $data[] = array( 'BOL_ID' => $id_bolsa, 'CLI_ID' => $v );

        $estado = $this->db->insert_batch( 'TC_BOLSA_CLIENTE', $data );

        if( $estado )
            return $this->db->insert_id();
        else
            return NULL;
    }

    public function bolsa_cliente_editar( $id_bolsa, $id_cliente ) {

        if( empty( $id_bolsa ) || empty( $id_cliente ) ) return NULL;

        $this->db->delete( 'TC_BOLSA_CLIENTE', array( 'BOL_ID' => (int)$id_bolsa ) );
        $estado = $this->bolsa_cliente_agregar( (int)$id_bolsa, $id_cliente );

        if( $estado )
            return TRUE;
        else
            return NULL;
    }

    public function bolsa_usuarios_get( $id_bolsa ) {

        $this->db->join( 'TC_USUARIO u', 'u.USU_ID = bu.USU_ID' );
        $query = $this->db->get_where( 'TC_BOLSA_USUARIO bu', array( 'bu.BOL_ID' => (int)$id_bolsa ) );

        if( $query->num_rows() > 0 )
            return $query->result_array( );
        else
            return NULL;
    }

    public function bolsa_usuario_agregar( $id_bolsa, $id_usuario ) {

        if( empty( $id_bolsa ) || empty( $id_usuario ) ) return NULL;

        if( !is_array( $id_usuario ) )
            $id_usuario = array( $id_usuario );

        $data = array( );
        foreach( $id_usuario as $v )
            $data[] = array( 'BOL_ID' => $id_bolsa, 'USU_ID' => $v );

        $estado = $this->db->insert_batch( 'TC_BOLSA_USUARIO', $data );

        if( $estado )
            return $this->db->insert_id();
        else
            return NULL;
    }

    public function bolsa_usuario_editar( $id_bolsa, $id_usuario ) {

        if( empty( $id_bolsa ) || empty( $id_usuario ) ) return NULL;

        $this->db->delete( 'TC_BOLSA_USUARIO', array( 'BOL_ID' => (int)$id_bolsa ) );
        $estado = $this->bolsa_usuario_agregar( (int)$id_bolsa, $id_usuario );

        if( $estado )
            return TRUE;
        else
            return NULL;
    }

    public function bolsa_eliminar( $id_bolsa ) {

        $this->db->where( 'BOL_ID', (int)$id_bolsa );
        return $this->db->update('TC_BOLSA', array( 'BOL_ELIMINADO' => 1 ) );
    }

    public function bolsa_activar( $id_bolsa ) {

        $this->db->where( 'BOL_ID', (int)$id_bolsa );
        return $this->db->update('TC_BOLSA', array( 'BOL_ACTIVO' => 1 ) );
    }

    public function bolsa_desactivar( $id_bolsa ) {

        $this->db->where( 'BOL_ID', (int)$id_bolsa );
        return $this->db->update('TC_BOLSA', array( 'BOL_ACTIVO' => 0 ) );
    }
  

    /**
     * Retorna listado de teleconsultas que no están vinculadas a ninguna
     * bolsa.
     * Teleconsultas en estado Enviadas/nuevas(2), Solicitud de examenes(5) y
     * respuesta de solicitud (6) que son útiles para llenar una bolsa
     *
     * @return array Listado de Teleconsultas sin bolsas asociadas
     */
    public function bolsa_teleconsultas_sin_bolsa( ) {

        $sql  = "SELECT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA_ENVIO
                        , datediff( NOW(), t.TEL_FECHA_HORA_ENVIO ) as TEL_ATRASO
                        , t.EST_ID, t.TEL_LOCK_USED, t.PRI_ID,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE

                FROM    TC_TELECONSULTA AS t
                        INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                        LEFT JOIN ( TC_BOLSA_TELECONSULTA bt
                            INNER JOIN TC_BOLSA b ON ( b.BOL_ID = bt.BOL_ID AND b.BOL_ELIMINADO = 0 )
                        ) ON ( bt.TEL_ID = t.TEL_ID )

                WHERE   t.SIT_ID = " . (int)$this->session->userdata('SIT_ID'). "
                    AND t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7
                    AND t.TEL_REVISADA = 1
                    AND bt.TEL_ID is NULL

                ORDER BY t.TEL_ID ASC ";

        $query = $this->db->query( $sql );
         if ($query->num_rows() > 0){

            return $query->result_array();
        } else
            return NULL;

    }

    /**
     * Retorna grilla de teleconsultas que no están vinculadas a ninguna
     * bolsa. Solo retorna 1 TC que es pasada por parámetro, verifica si
     * cumple condiciones de no estar asociada a una bolsa
     *
     * Teleconsultas en estado Enviadas/nuevas(2), Solicitud de examenes(5) y
     * respuesta de solicitud (6) que son útiles para llenar una bolsa
     *
     * @param int $id_teleconsulta Folio de la TC a encontrar
     * @return array Listado de Teleconsultas sin bolsas asociadas
     */
    public function bolsa_teleconsultas_sin_bolsa_tcid( $id_teleconsulta ) {

        $sql  = "SELECT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA_ENVIO
                        , datediff( NOW(), t.TEL_FECHA_HORA_ENVIO ) as TEL_ATRASO
                        , t.EST_ID, t.TEL_LOCK_USED, t.PRI_ID,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE

                FROM    TC_TELECONSULTA AS t
                        INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                        LEFT JOIN TC_BOLSA_TELECONSULTA b ON ( b.TEL_ID = t.TEL_ID )

                WHERE   t.SIT_ID = " . (int)$this->session->userdata('SIT_ID'). "
                    AND t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7
                    AND t.TEL_REVISADA = 1
                    AND b.TEL_ID is NULL
                    AND t.TEL_ID = ".(int)$id_teleconsulta."

                ORDER BY t.TEL_ID ASC ";

        $query = $this->db->query( $sql );
         if ($query->num_rows() > 0){

           return $query->result_array();
        } else
            return NULL;

    }

    /**
     * Retorna grilla de teleconsultas que no están vinculadas a ninguna
     * bolsa.
     *
     * Teleconsultas en estado Enviadas/nuevas(2), Solicitud de examenes(5) y
     * respuesta de solicitud (6) que son útiles para llenar una bolsa
     *
     * @param string $nombre Primer nombre del paciente
     * @param string $apellido Primer apellido del paciente
     * @return array Listado de Teleconsultas sin bolsas asociadas
     */
    public function bolsa_teleconsultas_sin_bolsa_na( $nombre = NULL, $apellido = NULL ) {

        $sql  = "SELECT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA_ENVIO
                        , datediff( NOW(), t.TEL_FECHA_HORA_ENVIO ) as TEL_ATRASO
                        , t.EST_ID, t.TEL_LOCK_USED, t.PRI_ID,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE

                FROM    TC_TELECONSULTA AS t
                        INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                        LEFT JOIN TC_BOLSA_TELECONSULTA b ON ( b.TEL_ID = t.TEL_ID )

                WHERE   t.SIT_ID = " . (int)$this->session->userdata('SIT_ID'). "
                    AND t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7
                    AND t.TEL_REVISADA = 1
                    AND b.TEL_ID is NULL";

        if( !empty( $nombre ) )
            $sql.=" AND t.TEL_PAC_PRIMER_NOMBRE like '%".$nombre. "%' ";

        if( !empty( $apellido ) )
            $sql.=" AND t.TEL_PAC_PRIMER_APELLIDO like '%".$apellido. "%' ";

        $sql.= "ORDER BY t.TEL_ID ASC ";

        $query = $this->db->query( $sql );
         if ($query->num_rows() > 0){

            return $query->result_array();
        } else
            return NULL;

    }

    /**
     * Retorna grilla de teleconsultas que no están vinculadas a ninguna
     * bolsa. Solo retorna 1 TC que es pasada por parámetro, verifica si
     * cumple condiciones de no estar asociada a una bolsa
     *
     * Teleconsultas en estado Enviadas/nuevas(2), Solicitud de examenes(5) y
     * respuesta de solicitud (6) que son útiles para llenar una bolsa
     *
     * @param string $rut_paciente Identificador (de la cédula) del paciente
     * @return array Listado de Teleconsultas sin bolsas asociadas
     */
    public function bolsa_teleconsultas_sin_bolsa_id( $rut_paciente ) {

        $sql  = "SELECT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA_ENVIO
                        , datediff( NOW(), t.TEL_FECHA_HORA_ENVIO ) as TEL_ATRASO
                        , t.EST_ID, t.TEL_LOCK_USED, t.PRI_ID,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE

                FROM    TC_TELECONSULTA AS t
                        INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID )
                        INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                        LEFT JOIN TC_BOLSA_TELECONSULTA b ON ( b.TEL_ID = t.TEL_ID )

                WHERE   t.SIT_ID = " . (int)$this->session->userdata('SIT_ID'). "
                    AND t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7
                    AND t.TEL_REVISADA = 1
                    AND b.TEL_ID is NULL
                    AND ti.TCI_VALOR = '".$rut_paciente."'

                ORDER BY t.TEL_ID ASC ";

        $query = $this->db->query( $sql );
         if ($query->num_rows() > 0){

            return $query->result_array();
        } else
            return NULL;

    }

    /**
     * Retorna grilla de teleconsultas que no están vinculadas a ninguna
     * bolsa filtrado por fechas
     *
     * Teleconsultas en estado Enviadas/nuevas(2), Solicitud de examenes(5) y
     * respuesta de solicitud (6) que son útiles para llenar una bolsa
     *
     * @param string $fecha_desde Filtro de fecha de inicio
     * @param string $fecha_hasta Filtro de fecha de fin
     * @return array Listado de Teleconsultas sin bolsas asociadas
     */
    public function bolsa_teleconsultas_sin_bolsa_fecha( $fecha_desde, $fecha_hasta ) {

        $sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
                        , t.TEL_FECHA_HORA_ENVIO
                        , datediff( NOW(), t.TEL_FECHA_HORA ) as TEL_ATRASO
                        , t.EST_ID, t.TEL_LOCK_USED, t.PRI_ID,
                        e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE

                FROM    TC_TELECONSULTA AS t
                        INNER JOIN ( TC_TELPAC_IDENTIFICADOR ti ) ON ( ti.TEL_ID = t.TEL_ID )
                        INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
                        INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
                        LEFT JOIN TC_BOLSA_TELECONSULTA b ON ( b.TEL_ID = t.TEL_ID )

                WHERE   t.SIT_ID = " . (int)$this->session->userdata('SIT_ID'). "
                    AND t.EST_ID != 1 AND t.EST_ID != 3 AND t.EST_ID != 4 AND t.EST_ID != 5 AND t.EST_ID != 7
                    AND t.TEL_REVISADA = 1
                    AND b.TEL_ID is NULL";

        if( !empty( $fecha_desde ) && !empty( $fecha_hasta ) ) {
            $sql.= " AND t.TEL_FECHA_HORA_ENVIO BETWEEN str_to_date( '".$fecha_desde."', '%d-%m-%Y' ) AND
                                                        str_to_date( '".$fecha_hasta."', '%d-%m-%Y' ) ";
        } else if( !empty( $fecha_desde ) )
            $sql.= " AND t.TEL_FECHA_HORA_ENVIO >= str_to_date( '".$fecha_desde."', '%d-%m-%Y' ) ";

        $sql.= "GROUP BY t.TEL_ID ORDER BY t.TEL_ID ASC ";

        $query = $this->db->query( $sql );
         if ($query->num_rows() > 0){

            return $query->result_array();
        } else
            return NULL;

    }

    public function bolsa_teleconsultas_get( $id_bolsa ) {


        $sql = "SELECT  t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO, t.TEL_FECHA_HORA_ENVIO,
                        t.EST_ID, t.PRI_ID,
                        etb.ETB_NOMBRE, etb.ETB_NIVEL, esp.ESP_NOMBRE

                FROM    TC_TELECONSULTA t
                        INNER JOIN TC_ESTABLECIMIENTO etb ON ( etb.ETB_ID = t.ETB_ID )
                        INNER JOIN TC_ESPECIALIDAD esp ON ( esp.ESP_ID = t.ESP_ID )
                        INNER JOIN TC_BOLSA_TELECONSULTA bt ON ( bt.TEL_ID = t.TEL_ID )
                WHERE   bt.BOL_ID = " . (int)$id_bolsa . " ";

        $query = $this->db->query( $sql );
        if( $query->num_rows() > 0 ) {

            // Calcula días de atraso desde el último cambio de estado de la TC
            // USA FUNCIONES DE PHP >5.3
            $listado = array( );
            foreach( $query->result_array() as $tc ) {

                $f = explode( ' ', $tc['TEL_FECHA_HORA_ENVIO'] );
                $tc['TEL_ATRASO'] = date_diff( date_create_from_format( 'Y-m-d', $f[0] ), date_create( null ) )->format('%a');

                $listado[] = $tc;
            }

            return $listado;
        } else
            return NULL;
    }

    public function bolsa_teleconsulta_agregar( $id_bolsa, $teleconsultas ) {

        if( empty( $id_bolsa ) || empty( $teleconsultas ) ) return NULL;

        if( !is_array( $teleconsultas ) ) return NULL;

        $data = array( );
        foreach( $teleconsultas as $id_teleconsulta )
            $data[] = array( 'BOL_ID' => $id_bolsa, 'TEL_ID' => $id_teleconsulta );

        $estado = $this->db->insert_batch( 'TC_BOLSA_TELECONSULTA', $data );

        if( $estado )
            return $estado;
        else
            return NULL;
    }

    public function bolsas_teleconsultas_desasociar( $id_bolsa, $id_teleconsulta ) {

        $this->db->where( 'BOL_ID', (int)$id_bolsa );
        $this->db->where( 'TEL_ID', (int)$id_teleconsulta );
        return $this->db->delete( 'TC_BOLSA_TELECONSULTA' );
    }

    public function co_pediatria_tabla_crecimiento( $id_site, $tipo, $sexo, $activo = 1 ) {

        if( empty( $id_site ) || empty( $activo ) || !in_array( $tipo, Platc::$CO_PEDIATRIA_DE ) )
            return array( );

        $sql = "SELECT  tp.PED_MESES, tp.PED_TALLA, tp.PED_3N, tp.PED_2N, tp.PED_1N, tp.PED_CERO, tp.PED_1P, tp.PED_2P, tp.PED_3P
                FROM    TC_TABLA_PEDIATRIA tp
                WHERE   tp.SIT_ID = " . (int)$id_site . "
                    AND tp.PED_TIPO = '" . (string)$tipo . "'
                    AND tp.PED_SEXO = '" . (string)$sexo. "'
                    AND tp.PED_ACTIVO = " . (int)$activo . "
                ORDER BY tp.PED_MESES ASC, tp.PED_TALLA ASC";

        $query = $this->db->query( $sql );
        if( $query->num_rows() > 0 )

            return $query->result_array();
        else
            return NULL;
    }

    public function co_pediatria_tabla_crecimiento_paciente( $idt_paciente, $id_site, $tipo ) {

        if( empty( $id_site ) || !in_array( $tipo, Platc::$CO_PEDIATRIA_DE ) )
            return array( );

        $sql = "SELECT     t.TEL_ID, t.TEL_PAC_NACIMIENTO,
                        t.TEL_FECHA_HORA_ENVIO,
                        TIMESTAMPDIFF( MONTH, t.TEL_PAC_NACIMIENTO, t.TEL_FECHA_HORA_ENVIO ) as meses,
                        td_peso.TD_VALOR as peso,
                        td_talla.TD_VALOR as talla,
                        td_imc.TD_VALOR as imc,
                        td_p_c.TD_VALOR as p_c

                FROM    TC_TELECONSULTA t
                        left join TC_TELECONSULTA_DATA td_peso  ON ( td_peso.TEL_ID  = t.TEL_ID and td_peso.TD_CLAVE  = \"df_peso\" )
                        left join TC_TELECONSULTA_DATA td_talla ON ( td_talla.TEL_ID = t.TEL_ID and td_talla.TD_CLAVE = \"df_talla\" )
                        left join TC_TELECONSULTA_DATA td_imc   ON ( td_imc.TEL_ID   = t.TEL_ID and td_imc.TD_CLAVE   = \"df_imc\" )
                        left join TC_TELECONSULTA_DATA td_p_c   ON ( td_p_c.TEL_ID   = t.TEL_ID and td_p_c.TD_CLAVE   = \"df_perimetro_cefalico\" )

                WHERE   ( t.EST_ID = 2 OR t.EST_ID = 5 OR t.EST_ID = 6 OR t.EST_ID = 7 )
                    AND t.PAC_ID = " . (int)$idt_paciente;

        switch( $tipo ) {

            case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2'] : $sql.= " AND TIMESTAMPDIFF( MONTH, t.TEL_PAC_NACIMIENTO, t.TEL_FECHA_HORA_ENVIO ) <= 24"; break;
            case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5'] : $sql.= " AND TIMESTAMPDIFF( MONTH, t.TEL_PAC_NACIMIENTO, t.TEL_FECHA_HORA_ENVIO ) >= 24
                                                                      AND TIMESTAMPDIFF( MONTH, t.TEL_PAC_NACIMIENTO, t.TEL_FECHA_HORA_ENVIO ) <= 60"; break;
        }

        $query = $this->db->query( $sql );
        if( $query->num_rows() > 0 )

            return $query->result_array();
        else
            return NULL;
    }

    public function co_pediatria_obtener_de( $id_site, $tipo, $sexo, $x, $y ) {

        if( empty( $id_site ) || !in_array( $tipo, Platc::$CO_PEDIATRIA_DE ) || empty( $sexo ) || empty( $x ) || empty( $y ) )
            return array( );

        $sql = "SELECT     *
                FROM    TC_TABLA_PEDIATRIA
                WHERE   SIT_ID = " . (int)$id_site . "
                    AND PED_TIPO = '" . $tipo . "'
                    AND PED_SEXO = '" . $sexo . "' ";

        switch( $tipo ) {

            case Platc::$CO_PEDIATRIA_DE['TALLA_EDAD']          : { $sql.=" AND PED_MESES = " . (int)$x; } break;
            case Platc::$CO_PEDIATRIA_DE['PESO_EDAD']           : { $sql.=" AND PED_MESES = " . (int)$x; } break;
            case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_0_2']      : { $sql.=" AND PED_TALLA = " . (int)$x; } break;
            case Platc::$CO_PEDIATRIA_DE['PESO_TALLA_2_5']      : { $sql.=" AND PED_TALLA = " . (int)$x; } break;
            case Platc::$CO_PEDIATRIA_DE['IMC']                 : { $sql.=" AND PED_MESES = " . (int)$x; } break;
            case Platc::$CO_PEDIATRIA_DE['PERIMETRO_CEFALICO']  : { $sql.=" AND PED_MESES = " . (int)$x; } break;
        }

        $query = $this->db->query( $sql );
        if( $query->num_rows() > 0 )

            return $query->row_array();
        else
            return NULL;
    }

    public function comprobar_token( $hash ) {

        $query = $this->db->get_where( 'TC_USUARIO', array( 'USU_PASSWORD' => $hash ) );
        if( $query->num_rows() > 0 )
            return TRUE;
        else
            return FALSE;
    }

    /*
     * CL: Oftalmología (copiado desde CO
     */

    /**
     *
     */
    public function cl_oftalmologia_crear_carpeta_borrador( $tel_id ) {

        do {
            $hash = substr( md5( rand( ) ), 1, 5 );
            $ruta = 'files/oftalmologia/'.$tel_id.'/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADORES'].'/'.$hash;
        } while( is_dir( $ruta ) );

        if( @mkdir( $ruta, 0777, TRUE ) )
            return $hash;
        else
            return FALSE;
    }

    /*
     *
     */
    public function cl_oftalmologia_obtener( $tel_id, $borrador = false ) {

        $imagenes   = array( );

        $ruta = 'files/oftalmologia/'.$tel_id;
        $ruta.= ( $borrador ) ? '/'.Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADORES'].'/' : '/';
        $handle = ( is_dir( $ruta ) ) ? opendir( $ruta ) : FALSE;

        if( $handle ) {

            // Recorre todas las imagenes
            while( false !== ( $hash_borrador = readdir( $handle ) ) ) {

                if( $hash_borrador != '.' && $hash_borrador != '..' ) {

                    $ruta_imagenes = $ruta.$hash_borrador;
                    $carpeta_imagenes = opendir( $ruta_imagenes );
                    if( $carpeta_imagenes ) {

                        // Recorre las carpetas de imagenes (izquierda, derecha )
                        while( false !== ( $carpeta_lesion = readdir( $carpeta_imagenes ) ) ) {

                            $carpeta_foto = FALSE;

                            $ruta_carpeta_imagenes = $ruta_imagenes.'/'.$carpeta_lesion;

                            if( !empty( $carpeta_lesion ) && is_dir( $ruta_carpeta_imagenes ) && $carpeta_lesion != '.' && $carpeta_lesion != '..' ) {

                                $observacion = '';

                                switch( $carpeta_lesion ) {

                                    case Platc::$CL_OFTALMOLOGIA_FOTOS['IZQUIERDO'] : {
                                        $carpeta_foto = Platc::$CL_OFTALMOLOGIA_FOTOS['IZQUIERDO'];
                                    } break;

                                    case Platc::$CL_OFTALMOLOGIA_FOTOS['DERECHO'] : {
                                        $carpeta_foto = Platc::$CL_OFTALMOLOGIA_FOTOS['DERECHO'];
                                    } break;

                                    default: break;
                                }

                                if( !$carpeta_foto ) continue;

                                // Recorre buscando el archivo de imagen
                                $archivos = opendir( $ruta_carpeta_imagenes );
                                while( false !== ( $archivo = readdir( $archivos ) ) ) {

                                    if( !empty( $archivo ) && $archivo != '.' && $archivo != '..' &&
                                        $archivo != Platc::$CL_OFTALMOLOGIA_FOTOS['BORRADOS'] &&
                                        strpos( $archivo, "thumb_" ) === FALSE ) {

                                        $ruta_archivo = $ruta_carpeta_imagenes.'/'.$archivo;

                                        // Si es un archivo de imagen (que no tiene .comment)
                                        if( strpos( $archivo, ".comment" ) === FALSE && is_file( $ruta_archivo ) )
                                            $imagenes[ $hash_borrador ][ $carpeta_foto]['archivo']       = $archivo;

                                        // Si es un archivo de observacion (si tiene .comment en el nombre del archivo)
                                        if( strpos( $archivo, ".comment" ) !== FALSE && is_file( $ruta_carpeta_imagenes.'/'.$carpeta_foto.".comment" ) ) {

                                            $h_comentario = fopen( $ruta_carpeta_imagenes.'/'.$carpeta_foto.".comment", 'r' );
                                            $observacion  = fread( $h_comentario, filesize( $ruta_carpeta_imagenes.'/'.$carpeta_foto.".comment" )  );
                                            fclose( $h_comentario );
                                            $imagenes[ $hash_borrador ][ $carpeta_foto]['observacion']   = $observacion;
                                        }

                                        // Abandona ciclo, solo 1 archivo.
//                                        break;
                                    }
                                }

                                closedir( $archivos );
                            }
                        }
                    }

                    closedir( $carpeta_imagenes );
                }
            }

            closedir($handle);
        }

        return $imagenes;
    }



	public function gfr_agen_checkExisteAgendamiento ( $id_tc ) {  //ffarias SI1383
		
		    $sql  = " SELECT * FROM  TC_TELECONSULTA AS t,TC_AGENDA as a WHERE t.TEL_ID=" . $id_tc." AND t.TEL_ID=a.TEL_ID" ;
			$query = $this->db->query( $sql );
			 if ($query->num_rows() > 0){
				return 'true';  // tiene agendado 
			} else {
				return 'false';
			}
	
	}
 //------START-------ANEXO 3
 	public function anexo_get( $id_tc ) {

        $sql = "SELECT  a.*
                FROM    TC_ANEXO3 a
                WHERE   a.AXO_TEL_ID = " . (int)$id_tc  ;
		//$sql = " AXO_TEL_ID= ".(int)$tc_id;


        $query = $this->db->query( $sql );

        if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0];
        }
        else
            return NULL;

    }
	
	 public function anexo_crear( $tel_id,$id_sersol_origen='',$id_sersol_tipo='',$id_sersol_prio='',$id_sersol_ubicpac='',$id_sersol_serv='',$id_sersol_cam='',$id_sersol_just='',$id_sersol_guiacod='',$id_sersol_guiaobs='') {
	
			$id_sersol_origen=='on' ? $id_sersol_origen='1' : $id_sersol_origen='0';
			$id_sersol_tipo=='on' ? $id_sersol_tipo='1' : $id_sersol_tipo='0';
			$id_sersol_prio=='on' ? $id_sersol_prio='1' : $id_sersol_prio='0';
			$id_sersol_ubicpac=='on' ? $id_sersol_ubicpac='1' : $id_sersol_ubicpac='0';
			$datetime_now=date("Y-m-d H:i:s");

			$existe_tc_id=$this->get_existe_axo($tel_id);
			if($existe_tc_id) {
				$this->anexo_cups_eliminar( $tel_id );
				$data = array(
					'AXO_SOL_FECHA_UPDATE' => $datetime_now,
					'AXO_SERV_ORIG_COD' => $id_sersol_origen, 
					'AXO_SERV_TIPO_COD' => $id_sersol_tipo, 
					'AXO_SERV_PRIO_COD' => $id_sersol_prio, 
					'AXO_SERV_UBICPAC_COD' => $id_sersol_ubicpac, 
					'AXO_SERV_SERVICIO' => $id_sersol_serv, 
					'AXO_SERV_CAMA' => $id_sersol_cam, 
					'AXO_SERV_JUSTIFICA' => $id_sersol_just, 
					'AXO_SERV_GUIAPRACT_COD' => $id_sersol_guiacod , 
					'AXO_SERV_GUIAPRACT_OBS' => $id_sersol_guiaobs  				
				);
			
				
				 $this->anexo_update($tel_id ,$data);
		         return true;
			}else{
				$this->anexo_cups_eliminar( $tel_id );
				$this->db->set( 'AXO_TEL_ID',               $tel_id );
				$this->db->set( 'AXO_SOL_FECHA',            'NOW()', FALSE );
				$this->db->set( 'AXO_SERV_ORIG_COD',        $id_sersol_origen );
				$this->db->set( 'AXO_SERV_TIPO_COD',        $id_sersol_tipo );
				$this->db->set( 'AXO_SERV_PRIO_COD',        $id_sersol_prio );
				$this->db->set( 'AXO_SERV_UBICPAC_COD',     $id_sersol_ubicpac );
				$this->db->set( 'AXO_SERV_SERVICIO',        $id_sersol_serv );
				$this->db->set( 'AXO_SERV_CAMA',            $id_sersol_cam );
				$this->db->set( 'AXO_SERV_JUSTIFICA',       $id_sersol_just );
				$this->db->set( 'AXO_SERV_GUIAPRACT_COD',   $id_sersol_guiacod );
				$this->db->set( 'AXO_SERV_GUIAPRACT_OBS',   $id_sersol_guiaobs );
				
				
				$this->db->insert( 'TC_ANEXO3' );
				return $this->db->insert_id();

			}

		}

   public function cups_busqueda_por_texto( $id_site, $texto = NULL ) {

        if( !empty( $texto ) ) {
			$texto=urldecode($texto);
            $sql = "SELECT
                        TC_CUPS.*
                    FROM
                        TC_CUPS
                    WHERE CUPS_ACTIVO = 1 
                    AND   ( CUPS_DESC like '%" . $texto . "%' OR CUPS_ID LIKE '%" . $texto . "%' ) 
                    ORDER BY CUPS_DESC ASC ";

            $query = $this->db->query( $sql );

            return $query->result_array( );

        } else
            return NULL;
    }
   public function anexo_cups_crear( $tc_id= NULL,$cups_real_id= NULL,$cups_id= NULL,$cups_cant= NULL,$cups_desc='') {


         if($cups_id and $tc_id )  { 
		     $this->db->set( 'ACU_CUP_ID',           $cups_real_id );
			 $this->db->set( 'ACU_TEL_ID',           $tc_id );
			 $this->db->set( 'ACU_CANT',             $cups_cant );
			 $this->db->set( 'ACU_OBS',             $cups_desc );
			 $this->db->insert( 'TC_ANEXO_CUPS' );
	
			 return $this->db->insert_id();
		  }
    }
	
     public function select_anexos_tc($tc_id = ""){
		if($tc_id){
	
		$sql = "
				SELECT 
					*
				FROM
					TC_ANEXO3
				
				WHERE
					AXO_TEL_ID= ".(int)$tc_id;
			$query = $this->db->query($sql);
			if($query->num_rows()){
				return $query->result_array();
			}
			else{
				return FALSE;
			}
		}
		else{
			return FALSE;
		}
	}
	
    public function diags_busqueda_por_texto( $id_site, $texto = NULL ) {

        if( !empty( $texto ) ) {
            $sql = "SELECT  TC_CIE10.*
                    FROM    TC_CIE10
                    WHERE   id10 like '%" . $texto . "%' 
					   OR   dec10 LIKE '%" . $texto . "%'
                    ORDER BY dec10 ASC ";
            $query = $this->db->query( $sql );
            return $query->result_array( );
        } else
            return NULL;
    }
    public function anexos_solicitudes_tc_get( $tel_id) {

		$sql = "
				SELECT 
					*
				FROM
					TC_ANEXO3
				
				WHERE
					AXO_TEL_ID= ".(int)$tel_id;
	
        $query = $this->db->query( $sql );
        return $query->result_array();
    }	
	
	 public function anexo_obtener_cups_lista( $tc_id ) {

		$sql = "SELECT  ac.ACU_CUP_ID 
		, c.CU_ID
		, ifnull(ac.acu_obs,c.CUPS_DESC) as CUPS_DESC
		, ac.ACU_TEL_ID
		, ac.ACU_CANT
				FROM    
				TC_ANEXO3 as a,
				TC_ANEXO_CUPS as ac,
				TC_CUPS as c
		WHERE
			   ac.ACU_TEL_ID =a.AXO_TEL_ID
			   and ac.ACU_CUP_ID=c.CUPS_ID
			   and a.AXO_TEL_ID = ".(int)$tc_id." GROUP BY ACU_CUP_ID";
        


		$query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
               return $query->result_array( );
        }
         else
               return array( );
		
		
    }
	
	public function anexo_editar( $tel_id='',$sol_id='' ,$id_sersol_origen='',$id_sersol_tipo='',$id_sersol_prio='',$id_sersol_ubicpac='',$id_sersol_serv='',$id_sersol_cam='', $id_sersol_just='', $id_sersol_guiacod='',$id_sersol_guiaobs='') {

  		$datetime_now=date("Y-m-d H:i:s");
		
		if($tel_id){
           
		   	$id_sersol_origen=='on' ? $id_sersol_origen='1' : $id_sersol_origen='0';
			$id_sersol_tipo=='on' ? $id_sersol_tipo='1' : $id_sersol_tipo='0';
			$id_sersol_prio=='on' ? $id_sersol_prio='1' : $id_sersol_prio='0';
			$id_sersol_ubicpac=='on' ? $id_sersol_ubicpac='1' : $id_sersol_ubicpac='0';
		   
		    $data = array(
				'AXO_SOL_FECHA_UPDATE' => $datetime_now,
				'AXO_SERV_ORIG_COD' => $id_sersol_origen, 
				'AXO_SERV_TIPO_COD' => $id_sersol_tipo, 
				'AXO_SERV_PRIO_COD' => $id_sersol_prio, 
				'AXO_SERV_UBICPAC_COD' => $id_sersol_ubicpac, 
				'AXO_SERV_SERVICIO' => $id_sersol_serv, 
				'AXO_SERV_CAMA' => $id_sersol_cam, 
				'AXO_SERV_JUSTIFICA' => $id_sersol_just, 
				'AXO_SERV_GUIAPRACT_COD' => $id_sersol_guiacod , 
				'AXO_SERV_GUIAPRACT_OBS' => $id_sersol_guiaobs  				
			);
		
			 $this->anexo_cups_eliminar( $tel_id );
			 $this->anexo_update($tel_id ,$data);
			 return true;
		}
		else{
			return false;
		}
  
  
    }
	public function anexo_update( $tel_id,$data) {
	
            $this->db->where('AXO_TEL_ID', $tel_id);
            $this->db->update('TC_ANEXO3', $data);
	

     }
	public function anexo_cups_eliminar( $tel_id='' ) {


		$this->db->where('ACU_TEL_ID', $tel_id);
       return  $this->db->delete('TC_ANEXO_CUPS'); 
    }
	
	public function anexo_eliminar( $tel_id='' ) {
         
		// elimina TC_ANEXO_CUPS 
		$this->db->where('ACU_TEL_ID', $tel_id);
		$this->db->delete('TC_ANEXO_CUPS'); 
		// elimina TC_ANEXO3
		$this->db->where('AXO_TEL_ID', $tel_id);
        return  $this->db->delete('TC_ANEXO3'); 
	   
    }
	
    public function guias_practicas_list_get(){
       
	    $sql = "SELECT GPC_ID ,GPC_NOMBRE ";
        $sql .= " FROM TC_GUIA_PRACTICA_CLINICA ";
        $sql .= " WHERE GPC_ACTIVO=1 ";
        $sql .= " ORDER BY  GPC_NOMBRE";

        $query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
            return $query->result_array( );
        }else{
            return NULL;
	    }
     }
	public function upd_data_teleconsulta_data($tel_id = "",$refvalue = ""){
		if($tel_id && $refvalue ){
			$this->db->where("TEL_ID",$tel_id);
			//$this->db->where("TD_CLAVE",'dm_general');
			$this->db->update("TC_TELECONSULTA_CIE10_RESPUESTA",array( 'TEL_CIE_ID_RESPUESTA' => $refvalue ));
			
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
	
		public function establecimiento_data_get( $id_etb )
    {
        $sql = "SELECT  *
                FROM    TC_ESTABLECIMIENTO E,TC_MUNICIPIO_M M ,TC_DEPARTAMENTO_D D
                WHERE  
                
                E.ETB_MUNI_ID=M.MUN_ID
                AND  E.ETB_DPTO_ID=D.DPTO_ID
                AND  E.ETB_ID =" . $id_etb;
        $query = $this->db->query( $sql );

        if ( $query->num_rows() > 0 )
            return $query->result_array();
        else
            return NULL;
    }
	
		public function select_entidad_administra($afilia_id = ""){
		if($afilia_id){
			$this->db->where("ENTADM_AFILIACION",$afilia_id);
			$this->db->where("ENTADM_VIGENTE",'1');
			$this->db->order_by("ENTADM_NOMBRE");
			$query = $this->db->get("TC_ENTIDADES_ADMINISTRADORAS");
			if($query->num_rows()){
				return $query->result();
			}
			else{
				return FALSE;
			}
		}
		else{
			return FALSE;
		}
	}
	
	   public function municipios_m_list_get( )
    {
        $this->db->order_by( 'MUN_NOMBRE' );
        $query = $this->db->get('TC_MUNICIPIO_M');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }
	public function departamentos_m_list_get( )
    {
        $this->db->order_by( 'DPTO_NOMBRE' );
        $query = $this->db->get('TC_DEPARTAMENTO_D');
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }
	
	public function select_municipios($departamento = ""){
		if($departamento){
			$this->db->where("DPTO_ID",$departamento);
			$query = $this->db->get("TC_MUNICIPIO_M");
			if($query->num_rows()){
				return $query->result();
			}
			else{
				return FALSE;
			}
		}
		else{
			return FALSE;
		}
	}
	
	public function get_info_table_param($tablename='',$fieldkey='',$idvalue='') {
	   if($tablename and $idvalue and $fieldkey ){
		   
		$sql = "SELECT *
                FROM ".$tablename."  
                WHERE ".$fieldkey." = '" . $idvalue . "';";
		$query = $this->db->query($sql);
			 if ($query->num_rows() > 0) {
				$row = $query->result_array();
				return $row[0];
			}
			else
				return NULL;
	   
	   }else{
			return FALSE;
	   }
    }
	
	
	public function anexo_obtener_diags_lista( $tc_id ) {

		$sql = "SELECT  c.TEL_ID,c.TEL_CIE_ID_RESPUESTA
				FROM    
				TC_TELECONSULTA_CIE10_RESPUESTA c
		WHERE
			   c.TEL_ID = ".(int)$tc_id;

		$query = $this->db->query($sql);
         if ($query->num_rows() > 0) {
               return $query->result_array( );
        }
         else
               return array( );
		
		
    } 
	
	public function tc_save_axo($data,$axo_tel_id='')
    {
		 if (!empty( $axo_tel_id )) { 
		        $existe_axo=$this->get_existe_axo($axo_tel_id); 
				$now = date('Y-m-d H:i:s');
				if ($existe_axo) {
					
					$data['AXO_SOL_FECHA_UPDATE']   =$now;
					$this->db->where('AXO_TEL_ID', $axo_tel_id);
					$this->db->update('TC_ANEXO3', $data);
					return true;
				} else {
					$data['AXO_SOL_FECHA']   = $now;
					$this->db->insert( 'TC_ANEXO3', $data );
					return true;
				}
		 } else {  
	
			return false;
	
		  } 

    }
	
	public function get_existe_axo( $tel_id) {

		$sql = "
				SELECT 	* FROM
					TC_ANEXO3
				WHERE
					AXO_TEL_ID= ".(int)$tel_id;
	
        $query = $this->db->query( $sql );
        return $query->result_array();
    }
	
	public function cups_eliminar( $tel_id='' ) {
         
		// elimina TC_ANEXO_CUPS 
		$this->db->where('ACU_TEL_ID', $tel_id);
		$this->db->delete('TC_ANEXO_CUPS'); 
   
    }
    public function get_info_entidad_administradora( $pac_ea_id ) {
       if ( $pac_ea_id ) {
			$sql = "SELECT e.ENTADM_ID,e.ENTADM_NOMBRE
			   FROM  TC_PACIENTE p,TC_ENTIDADES_ADMINISTRADORAS e
			   WHERE
				   p.EA_ID=e.ENTADM_CORR
				   AND e.ENTADM_CORR = ".(int)$pac_ea_id;
			$query = $this->db->query($sql);
			 if ($query->num_rows() > 0) {
				  $row = $query->result_array();
				  return $row[0];
			}
			 else
				   return array( );
		} else {  
		
		return false;
		
		} 	
		
    }
	/*
		JV 25-09-2015
		este actualiza los campos enviados al crear la teleconsulta
	*/
	public function update_ficha_paciente( $pac_id,$data) {
	
            $this->db->where('PAC_ID', $pac_id);
            $this->db->update('TC_PACIENTE', $data);
	}
	// JV 25-09-2015 FIN
    public function anexo3_get( $id_teleconsulta ) {

		if($id_teleconsulta){
			
		$sql = "
				SELECT 
					*
				FROM
					TC_ANEXO3
				
				WHERE
					AXO_TEL_ID= ".(int)$id_teleconsulta;
			$query = $this->db->query($sql);
			if($query->num_rows()){
				  $row = $query->result_array();
				  return $row[0];
			}
			else{
				return FALSE;
			}
		}
		else{
			return FALSE;
		}


    }
	
 //-------END------ANEXO 3	
}
